/*
 * Decompiled with CFR 0.152.
 */
package solver;

import java.time.Duration;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import solver.SolverConfig;
import solver.SolverInfo;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\bH\u0016J+\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J+\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000b0\b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\bH\u0016J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\u0006\u0010\f\u001a\u00020\rH\u0016J+\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000b0\b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001f"}, d2={"Lsolver/CVC4SolverInfo;", "Lsolver/SolverInfo;", "()V", "defaultCommand", "", "getDefaultCommand", "()Ljava/lang/String;", "commandForStdInMode", "", "clOptions", "getBitVectorConfigs", "Lsolver/SolverConfig;", "timelimit", "Ljava/time/Duration;", "memlimitBytes", "", "incrementalMode", "", "(Ljava/time/Duration;Ljava/lang/Long;Z)Ljava/util/List;", "getNonLinearConfigs", "getOptionForIncremental", "getOptionForRandomSeed", "randomSeed", "", "getOptionForTimelimit", "getQuantifierConfigs", "readResolve", "", "supportsLogicFeatures", "features", "Lsolver/SolverConfig$LogicFeatures;", "GeneralUtils"})
public final class CVC4SolverInfo
extends SolverInfo {
    @NotNull
    public static final CVC4SolverInfo INSTANCE = new CVC4SolverInfo();

    private CVC4SolverInfo() {
        super("CVC4");
    }

    @Override
    @NotNull
    public String getDefaultCommand() {
        return "cvc4";
    }

    @Override
    @NotNull
    public List<String> getOptionForIncremental() {
        return CollectionsKt.listOf("--incremental");
    }

    @Override
    @NotNull
    public List<String> getOptionForTimelimit(@NotNull Duration timelimit) {
        Intrinsics.checkNotNullParameter(timelimit, "timelimit");
        return CollectionsKt.listOf("--tlimit-per=" + timelimit.toMillis());
    }

    @Override
    public boolean supportsLogicFeatures(@NotNull SolverConfig.LogicFeatures features) {
        Intrinsics.checkNotNullParameter(features, "features");
        return true;
    }

    @Override
    @NotNull
    public List<String> getOptionForRandomSeed(int randomSeed) {
        return CollectionsKt.listOf("--seed=" + randomSeed);
    }

    @Override
    @NotNull
    public List<String> commandForStdInMode(@NotNull List<String> clOptions) {
        Intrinsics.checkNotNullParameter(clOptions, "clOptions");
        String[] stringArray = new String[]{this.getDefaultCommand(), "--lang", "smt2"};
        return CollectionsKt.plus((Collection)CollectionsKt.listOf(stringArray), (Iterable)clOptions);
    }

    @NotNull
    public final List<SolverConfig> getQuantifierConfigs(@NotNull Duration timelimit, @Nullable Long memlimitBytes, boolean incrementalMode) {
        Intrinsics.checkNotNullParameter(timelimit, "timelimit");
        return CollectionsKt.listOf(SolverConfig.copy$default(SolverConfig.Companion.getCvc4().getQ(), null, null, null, null, incrementalMode, timelimit, memlimitBytes, null, null, null, null, 1935, null));
    }

    @NotNull
    public final List<SolverConfig> getNonLinearConfigs(@NotNull Duration timelimit, @Nullable Long memlimitBytes, boolean incrementalMode) {
        Intrinsics.checkNotNullParameter(timelimit, "timelimit");
        return CollectionsKt.listOf(SolverConfig.copy$default(SolverConfig.Companion.getCvc4().getNonlin(), null, null, null, null, incrementalMode, timelimit, memlimitBytes, null, null, null, null, 1935, null));
    }

    @NotNull
    public final List<SolverConfig> getBitVectorConfigs(@NotNull Duration timelimit, @Nullable Long memlimitBytes, boolean incrementalMode) {
        Intrinsics.checkNotNullParameter(timelimit, "timelimit");
        boolean $i$f$unused = false;
        $i$f$unused = false;
        $i$f$unused = incrementalMode;
        boolean $i$f$unused2 = false;
        return CollectionsKt.emptyList();
    }

    private final Object readResolve() {
        return INSTANCE;
    }
}

