/*
 * Decompiled with CFR 0.152.
 */
package parallel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import parallel.EndOfLineParallel;
import parallel.FinishingRaceJob;
import parallel.Parallel;
import parallel.ParallelKt;
import parallel.PreserveDepsOrder;
import parallel.RacerResult;
import parallel.Sem;
import parallel.Thunk;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012 \u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00060\u00050\u00030\u00022\u00020\u0007B\u0019\u0012\u0012\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\t0\u0005\u00a2\u0006\u0002\u0010\nJ\u0010\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202H\u0002J\u001e\u00103\u001a\u0002002\u0006\u00104\u001a\u00020\u00042\f\u00105\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006H\u0002J\u001b\u00106\u001a\u0002002\u0006\u00104\u001a\u00020\u00042\u0006\u00105\u001a\u00028\u0000\u00a2\u0006\u0002\u00107J\u0012\u00108\u001a\u0002002\n\u00109\u001a\u00060\u0012j\u0002`\u0013J\u001b\u0010:\u001a\u0002002\u0006\u00104\u001a\u00020\u00042\u0006\u00105\u001a\u00028\u0000\u00a2\u0006\u0002\u00107J\u000e\u0010;\u001a\u0002002\u0006\u00104\u001a\u00020\u0004J\u000e\u0010<\u001a\u0002002\u0006\u00104\u001a\u00020\u0004J\u000e\u0010=\u001a\u0002002\u0006\u00104\u001a\u00020\u0004J\u000e\u0010>\u001a\u0002002\u0006\u00104\u001a\u00020\u0004J\u0017\u0010?\u001a\u0004\u0018\u00018\u00002\u0006\u00104\u001a\u00020\u0004H\u0002\u00a2\u0006\u0002\u0010@J\u0010\u0010A\u001a\u0002002\u0006\u0010B\u001a\u00020CH\u0016R\u001e\u0010\u000b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00100\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0011\u001a\n\u0018\u00010\u0012j\u0004\u0018\u0001`\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\u001d\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060\u00050\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u001c\u0010 \u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00060!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\"\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010#\u001a\u0004\u0018\u00010$X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010)\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001a\u0010*\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.\u00a8\u0006D"}, d2={"Lparallel/FilteringFanOut;", "T", "Lparallel/EndOfLineParallel;", "Lkotlin/Pair;", "", "", "Lparallel/RacerResult;", "Lparallel/PreserveDepsOrder;", "thunks", "Lparallel/Thunk;", "(Ljava/util/List;)V", "deps", "Lparallel/Parallel;", "getDeps", "()Ljava/util/List;", "deps_", "Lparallel/FinishingRaceJob;", "exceptionThrown", "Ljava/lang/Exception;", "Lkotlin/Exception;", "getExceptionThrown", "()Ljava/lang/Exception;", "setExceptionThrown", "(Ljava/lang/Exception;)V", "lock", "Lparallel/Sem;", "getLock", "()Lparallel/Sem;", "numJobs", "result", "getResult", "()Lkotlin/Pair;", "results", "", "resultsOnNoExit", "startTimeOfFirstThunk", "", "getStartTimeOfFirstThunk", "()Ljava/lang/Long;", "setStartTimeOfFirstThunk", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "status", "getStatus", "()I", "setStatus", "(I)V", "dbgPrnt", "", "msg", "", "register", "id", "res", "registerDqf", "(ILjava/lang/Object;)V", "registerException", "e", "registerFull", "registerLostRace", "registerSkipped", "registerSkippedDelayed", "registerTimeout", "resultOnNoExit", "(I)Ljava/lang/Object;", "sched", "ioPool", "Ljava/util/concurrent/ExecutorService;", "GeneralUtils"})
public final class FilteringFanOut<T>
extends EndOfLineParallel<Pair<? extends Integer, ? extends List<? extends RacerResult<? extends T>>>>
implements PreserveDepsOrder {
    @NotNull
    private final Sem lock;
    private int status;
    @Nullable
    private Exception exceptionThrown;
    private final int numJobs;
    @NotNull
    private final List<FinishingRaceJob<T>> deps_;
    @NotNull
    private final List<T> resultsOnNoExit;
    @NotNull
    private final List<RacerResult<T>> results;
    @Nullable
    private Long startTimeOfFirstThunk;

    /*
     * WARNING - void declaration
     */
    public FilteringFanOut(@NotNull List<Thunk<T>> thunks) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        ArrayList arrayList;
        void $this$mapIndexedTo$iv$iv;
        Iterable $this$mapIndexed$iv;
        Intrinsics.checkNotNullParameter(thunks, "thunks");
        this.lock = new Sem(ParallelKt.access$getSemaphoreId$p().incrementAndGet());
        this.numJobs = thunks.size();
        Iterable iterable = thunks;
        FilteringFanOut filteringFanOut = this;
        boolean $i$f$mapIndexed = false;
        void var4_7 = $this$mapIndexed$iv;
        ArrayList destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv2 : $this$mapIndexedTo$iv$iv) {
            void index;
            void job;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Thunk thunk = (Thunk)item$iv$iv2;
            int n2 = n;
            arrayList = destination$iv$iv;
            boolean bl = false;
            arrayList.add(new FinishingRaceJob(job, (int)(index + true), this));
        }
        filteringFanOut.deps_ = destination$iv$iv;
        $this$mapIndexed$iv = thunks;
        filteringFanOut = this;
        boolean $i$f$map = false;
        $this$mapIndexedTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        int $i$f$mapTo = 0;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Object item$iv$iv2;
            item$iv$iv2 = (Thunk)item$iv$iv;
            arrayList = destination$iv$iv;
            boolean bl = false;
            arrayList.add(it.getResultOnNoExit());
        }
        filteringFanOut.resultsOnNoExit = destination$iv$iv;
        int n = this.numJobs;
        filteringFanOut = this;
        ArrayList arrayList2 = new ArrayList(n);
        int n3 = 0;
        while (n3 < n) {
            int n4;
            $i$f$mapTo = n4 = n3++;
            arrayList = arrayList2;
            boolean bl = false;
            arrayList.add(null);
        }
        filteringFanOut.results = arrayList2;
    }

    @NotNull
    public final Sem getLock() {
        return this.lock;
    }

    public final int getStatus() {
        return this.status;
    }

    public final void setStatus(int n) {
        this.status = n;
    }

    @Nullable
    public final Exception getExceptionThrown() {
        return this.exceptionThrown;
    }

    public final void setExceptionThrown(@Nullable Exception exception) {
        this.exceptionThrown = exception;
    }

    private final T resultOnNoExit(int id) {
        return this.resultsOnNoExit.get(id - 1);
    }

    @Override
    @NotNull
    public List<Parallel<?>> getDeps() {
        return this.deps_;
    }

    @Nullable
    public final Long getStartTimeOfFirstThunk() {
        return this.startTimeOfFirstThunk;
    }

    public final void setStartTimeOfFirstThunk(@Nullable Long l) {
        this.startTimeOfFirstThunk = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Pair<Integer, List<RacerResult<T>>> getResult() {
        Pair<Integer, List<RacerResult<T>>> pair;
        Sem sem = this.lock;
        synchronized (sem) {
            void $this$mapIndexedTo$iv$iv;
            void $this$mapIndexed$iv;
            boolean bl = false;
            Exception exception = this.getExceptionThrown();
            if (exception != null) {
                Exception it = exception;
                boolean bl2 = false;
                throw it;
            }
            if (!(this.getStatus() != 0)) {
                boolean $i$a$-check-FilteringFanOut$result$1$32 = false;
                String $i$a$-check-FilteringFanOut$result$1$32 = "status indicates 'still running', but we're already querying the result";
                throw new IllegalStateException($i$a$-check-FilteringFanOut$result$1$32.toString());
            }
            Iterable iterable = this.results;
            Integer n = this.getStatus() - 1;
            boolean $i$f$mapIndexed = false;
            void it = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void res2;
                int n2;
                if ((n2 = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                RacerResult racerResult = (RacerResult)item$iv$iv;
                int n3 = n2;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                void v1 = res2;
                if (v1 == null) {
                    void i;
                    throw new IllegalStateException(("Result of job " + (int)i + " is null at the end of the race").toString());
                }
                collection.add(v1);
            }
            pair = TuplesKt.to(n, (List)destination$iv$iv);
        }
        return pair;
    }

    private final void register(int id, RacerResult<? extends T> res2) {
        if (this.results.get(id - 1) instanceof RacerResult.Timeout || this.results.get(id - 1) instanceof RacerResult.LostRace) {
            return;
        }
        if (!(this.results.get(id - 1) == null)) {
            boolean bl = false;
            String string2 = "Registering a job's result cannot happen twice";
            throw new IllegalStateException(string2.toString());
        }
        this.results.set(id - 1, res2);
    }

    public final void registerException(@NotNull Exception e) {
        Intrinsics.checkNotNullParameter(e, "e");
        if (this.exceptionThrown == null) {
            this.exceptionThrown = e;
        }
        this.status = -1;
        this.lock.notifyAll();
    }

    public final void registerLostRace(int id) {
        if (!(this.status > 0 || this.exceptionThrown != null)) {
            boolean bl = false;
            String string2 = "Can only lose race if we have a known winner (or a job propagated an exception)";
            throw new IllegalStateException(string2.toString());
        }
        this.register(id, (RacerResult)new RacerResult.LostRace<T>(this.resultOnNoExit(id)));
    }

    public final void registerSkipped(int id) {
        if (!(this.status > 0 || this.exceptionThrown != null)) {
            boolean bl = false;
            String string2 = "Can only be skipped if we have a known winner (or a job propagated an exception)";
            throw new IllegalStateException(string2.toString());
        }
        this.register(id, (RacerResult)new RacerResult.Skipped<T>(this.resultOnNoExit(id)));
    }

    public final void registerSkippedDelayed(int id) {
        if (!(this.startTimeOfFirstThunk != null)) {
            boolean bl = false;
            String string2 = "Can only be skipped if another job has already started";
            throw new IllegalStateException(string2.toString());
        }
        this.register(id, (RacerResult)new RacerResult.SkippedDelayed<T>(this.resultOnNoExit(id)));
    }

    public final void registerTimeout(int id) {
        if (!(this.status == 0 && this.exceptionThrown == null)) {
            boolean bl = false;
            String string2 = "Can only timeout if no one else won (and no job propagated an exception)";
            throw new IllegalStateException(string2.toString());
        }
        this.register(id, (RacerResult)new RacerResult.Timeout<T>(this.resultOnNoExit(id)));
    }

    public final void registerDqf(int id, T res2) {
        this.register(id, (RacerResult)new RacerResult.FromJob<T>(res2));
        this.lock.notifyAll();
    }

    public final void registerFull(int id, T res2) {
        if (!(this.status != -1)) {
            boolean bl = false;
            String string2 = "can't have a winner when status is -1";
            throw new IllegalStateException(string2.toString());
        }
        this.register(id, (RacerResult)new RacerResult.FromJob<T>(res2));
        if (this.status == 0) {
            this.status = id;
        }
        this.lock.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sched(@NotNull ExecutorService ioPool) {
        Intrinsics.checkNotNullParameter(ioPool, "ioPool");
        Sem sem = this.lock;
        synchronized (sem) {
            boolean bl = false;
            if (this.getStatus() == 0) {
                this.setStatus(-1);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void dbgPrnt(String msg) {
        Sem sem = this.lock;
        synchronized (sem) {
            boolean bl = false;
            System.out.println((Object)(this.getLock() + " : " + msg + " (#jobs: " + this.numJobs + " status: " + this.getStatus() + "  results: " + this.results + ")"));
            Unit unit = Unit.INSTANCE;
        }
    }
}

