/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.Serializable;
import org.apache.commons.compress.utils.ByteUtils;

public final class ZipShort
implements Cloneable,
Serializable {
    public static final ZipShort ZERO = new ZipShort(0);
    private static final long serialVersionUID = 1L;
    private final int value;

    public ZipShort(int value2) {
        this.value = value2;
    }

    public ZipShort(byte[] bytes) {
        this(bytes, 0);
    }

    public ZipShort(byte[] bytes, int offset) {
        this.value = ZipShort.getValue(bytes, offset);
    }

    public byte[] getBytes() {
        byte[] result2 = new byte[2];
        ByteUtils.toLittleEndian(result2, this.value, 0, 2);
        return result2;
    }

    public int getValue() {
        return this.value;
    }

    public static byte[] getBytes(int value2) {
        byte[] result2 = new byte[2];
        ZipShort.putShort(value2, result2, 0);
        return result2;
    }

    public static void putShort(int value2, byte[] buf, int offset) {
        ByteUtils.toLittleEndian(buf, value2, offset, 2);
    }

    public static int getValue(byte[] bytes, int offset) {
        return (int)ByteUtils.fromLittleEndian(bytes, offset, 2);
    }

    public static int getValue(byte[] bytes) {
        return ZipShort.getValue(bytes, 0);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ZipShort)) {
            return false;
        }
        return this.value == ((ZipShort)o).getValue();
    }

    public int hashCode() {
        return this.value;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cnfe) {
            throw new RuntimeException(cnfe);
        }
    }

    public String toString() {
        return "ZipShort value: " + this.value;
    }
}

