import * as cdk from '@aws-cdk/core';
import { PolicyStatement } from './policy-statement';
/**
 * Properties for a new PolicyDocument.
 */
export interface PolicyDocumentProps {
    /**
     * Automatically assign Statement Ids to all statements.
     *
     * @default false
     */
    readonly assignSids?: boolean;
    /**
     * Initial statements to add to the policy document.
     *
     * @default - No statements
     */
    readonly statements?: PolicyStatement[];
}
/**
 * A PolicyDocument is a collection of statements.
 */
export declare class PolicyDocument implements cdk.IResolvable {
    /**
     * Creates a new PolicyDocument based on the object provided.
     *
     * This will accept an object created from the `.toJSON()` call
     *
     * @param obj the PolicyDocument in object form.
     */
    static fromJson(obj: any): PolicyDocument;
    /**
     * The creation stack of this resolvable which will be appended to errors thrown during resolution.
     *
     * This may return an array with a single informational element indicating how
     * to get this property populated, if it was skipped for performance reasons.
     */
    readonly creationStack: string[];
    private readonly statements;
    private readonly autoAssignSids;
    /**
     *
     */
    constructor(props?: PolicyDocumentProps);
    /**
     * Produce the Token's value at resolution time.
     */
    resolve(context: cdk.IResolveContext): any;
    /**
     * Whether the policy document contains any statements.
     */
    get isEmpty(): boolean;
    /**
     * The number of statements already added to this policy.
     *
     * Can be used, for example, to generate unique "sid"s within the policy.
     */
    get statementCount(): number;
    /**
     * Adds a statement to the policy document.
     *
     * @param statement the statement to add.
     */
    addStatements(...statement: PolicyStatement[]): void;
    /**
     * Encode the policy document as a string.
     */
    toString(): string;
    /**
     * JSON-ify the document.
     *
     * Used when JSON.stringify() is called
     */
    toJSON(): any;
    /**
     * Validate that all policy statements in the policy document satisfies the requirements for any policy.
     *
     * @see https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#access_policies-json
     */
    validateForAnyPolicy(): string[];
    /**
     * Validate that all policy statements in the policy document satisfies the requirements for a resource-based policy.
     *
     * @see https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#access_policies-json
     */
    validateForResourcePolicy(): string[];
    /**
     * Validate that all policy statements in the policy document satisfies the requirements for an identity-based policy.
     *
     * @see https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#access_policies-json
     */
    validateForIdentityPolicy(): string[];
    private render;
}
