"""
    PandaDoc Public API

    PandaDoc Public API documentation  # noqa: E501

    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from pandadoc_client.api_client import ApiClient, Endpoint as _Endpoint
from pandadoc_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from pandadoc_client.model.webhook_event_details_response import WebhookEventDetailsResponse
from pandadoc_client.model.webhook_event_error_enum import WebhookEventErrorEnum
from pandadoc_client.model.webhook_event_http_status_code_group_enum import WebhookEventHttpStatusCodeGroupEnum
from pandadoc_client.model.webhook_event_page_response import WebhookEventPageResponse
from pandadoc_client.model.webhook_event_trigger_enum import WebhookEventTriggerEnum


class WebhookEventsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.details_webhook_event_endpoint = _Endpoint(
            settings={
                'response_type': (WebhookEventDetailsResponse,),
                'auth': [
                    'apiKey',
                    'oauth2'
                ],
                'endpoint_path': '/public/v1/webhook-events/{id}',
                'operation_id': 'details_webhook_event',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_webhook_event_endpoint = _Endpoint(
            settings={
                'response_type': (WebhookEventPageResponse,),
                'auth': [
                    'apiKey',
                    'oauth2'
                ],
                'endpoint_path': '/public/v1/webhook-events',
                'operation_id': 'list_webhook_event',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'count',
                    'page',
                    'since',
                    'to',
                    'type',
                    'http_status_code',
                    'error',
                ],
                'required': [
                    'count',
                    'page',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'count',
                    'page',
                ]
            },
            root_map={
                'validations': {
                    ('count',): {

                        'inclusive_minimum': 0,
                    },
                    ('page',): {

                        'inclusive_minimum': 0,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'count':
                        (int,),
                    'page':
                        (int,),
                    'since':
                        (datetime,),
                    'to':
                        (datetime,),
                    'type':
                        ([WebhookEventTriggerEnum],),
                    'http_status_code':
                        ([WebhookEventHttpStatusCodeGroupEnum],),
                    'error':
                        ([WebhookEventErrorEnum],),
                },
                'attribute_map': {
                    'count': 'count',
                    'page': 'page',
                    'since': 'since',
                    'to': 'to',
                    'type': 'type',
                    'http_status_code': 'http_status_code',
                    'error': 'error',
                },
                'location_map': {
                    'count': 'query',
                    'page': 'query',
                    'since': 'query',
                    'to': 'query',
                    'type': 'query',
                    'http_status_code': 'query',
                    'error': 'query',
                },
                'collection_format_map': {
                    'type': 'multi',
                    'http_status_code': 'multi',
                    'error': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def details_webhook_event(
        self,
        id,
        **kwargs
    ):
        """Get webhook event by uuid  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.details_webhook_event(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str): Webhook event uuid

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            WebhookEventDetailsResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['id'] = \
            id
        return self.details_webhook_event_endpoint.call_with_http_info(**kwargs)

    def list_webhook_event(
        self,
        count,
        page,
        **kwargs
    ):
        """Get webhook event page  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_webhook_event(count, page, async_req=True)
        >>> result = thread.get()

        Args:
            count (int): Number of element in page
            page (int): Page number

        Keyword Args:
            since (datetime): Filter option: all events from specified timestamp. [optional]
            to (datetime): Filter option: all events up to specified timestamp. [optional]
            type ([WebhookEventTriggerEnum]): Filter option: all events of type. [optional]
            http_status_code ([WebhookEventHttpStatusCodeGroupEnum]): Filter option: all events of http status code. [optional]
            error ([WebhookEventErrorEnum]): Filter option: all events with following error. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            WebhookEventPageResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['count'] = \
            count
        kwargs['page'] = \
            page
        return self.list_webhook_event_endpoint.call_with_http_info(**kwargs)

