import * as ec2 from 'aws-cdk-lib/aws-ec2';
import * as iam from 'aws-cdk-lib/aws-iam';
import { Construct } from 'constructs';
/**
 * Properties for CodeServer construct
 */
export interface CodeServerProps {
    /**
     * The VPC where the instance will be deployed
     *
     * @default - A new VPC will be created
     */
    readonly vpc?: ec2.IVpc;
    /**
     * The instance type
     *
     * @default - C7g.2xlarge
     */
    readonly instanceType?: ec2.InstanceType;
    /**
     * The CPU type
     *
     * @default - ARM_64
     */
    readonly cpuType?: ec2.AmazonLinuxCpuType;
    /**
     * The IAM policy to attach to the instance role
     *
     * @default - Allow all actions on all resources
     */
    readonly policy?: iam.PolicyStatement;
    /**
     * The size of the root volume in GiB
     *
     * @default 30
     */
    readonly volumeSize?: number;
    /**
     * User data to run when launching the instance
     *
     * @default - No additional user data
     */
    readonly userData?: string[];
    /**
     * Whether to use EC2 instance connect endpoint for instance access.
     *
     * If set to true, it will create an EC2 Instance Connect Endpoint in the VPC.
     * You can access the instance using either EC2 Instance Connect or SSM Session Manager.
     *
     * @default false - Uses only SSM Session Manager for instance access
     */
    readonly useInstanceConnectEndpoint?: boolean;
}
/**
 * A CodeServer Construct
 */
export declare class CodeServer extends Construct {
    constructor(scope: Construct, id: string, props?: CodeServerProps);
}
