"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CodeServer = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ocf = require("@open-constructs/aws-cdk");
const ec2 = require("aws-cdk-lib/aws-ec2");
const iam = require("aws-cdk-lib/aws-iam");
const constructs_1 = require("constructs");
const instance_1 = require("./instance");
/**
 * A CodeServer Construct
 */
class CodeServer extends constructs_1.Construct {
    constructor(scope, id, props = {}) {
        super(scope, id);
        const vpc = props.vpc ?? new ec2.Vpc(this, 'Vpc', {
            maxAzs: 1,
            natGateways: 0,
            subnetConfiguration: [
                {
                    cidrMask: 26,
                    name: 'Public',
                    subnetType: ec2.SubnetType.PUBLIC,
                },
            ],
        });
        const instance = new instance_1.PreinstalledAmazonLinuxInstance(this, 'Instance', {
            vpc,
            instanceType: props.instanceType ?? ec2.InstanceType.of(ec2.InstanceClass.C7G, ec2.InstanceSize.XLARGE2),
            ssmSessionPermissions: true,
            blockDevices: [
                {
                    // Attach as a root device
                    deviceName: '/dev/xvda',
                    volume: ec2.BlockDeviceVolume.ebs(props.volumeSize ?? 30, {
                        deleteOnTermination: true,
                        encrypted: false,
                    }),
                },
            ],
            machineImage: new ec2.AmazonLinuxImage({
                generation: ec2.AmazonLinuxGeneration.AMAZON_LINUX_2023,
                cpuType: props.cpuType ?? ec2.AmazonLinuxCpuType.ARM_64,
            }),
            vpcSubnets: {
                subnetType: ec2.SubnetType.PUBLIC,
            },
            preinstalledSoftware: {
                packages: [
                    instance_1.PreinstalledSoftwarePackage.NODEJS,
                    instance_1.PreinstalledSoftwarePackage.VSCODE,
                    instance_1.PreinstalledSoftwarePackage.GIT,
                ],
            },
        });
        instance.addUserData('npm install -g yarn', 
        // Install make and other build tools for setup of CDK
        "sudo dnf groupinstall -y 'Development Tools'", 
        // Increase memory for Node.js
        "echo 'export NODE_OPTIONS=--max-old-space-size=8192' >> /etc/profile.d/myenv.sh", 'chmod +x /etc/profile.d/myenv.sh', 
        // Enable linger for ec2-user to allow running services without a user logged in
        'sudo loginctl enable-linger ec2-user');
        if (props.userData != null && props.userData.length > 0) {
            instance.addUserData(...props.userData);
        }
        instance.addToRolePolicy(props.policy ?? new iam.PolicyStatement({
            actions: ['*'],
            resources: ['*'],
        }));
        // Create EC2 Instance Connect Endpoint only if SSM is not enabled
        if (props.useInstanceConnectEndpoint) {
            const eicEndpoint = new ocf.aws_ec2.InstanceConnectEndpoint(this, 'InstanceConnectEndpoint', {
                vpc,
            });
            // Opening Security Group from EIC Endpoint to EC2 Instance
            eicEndpoint.connections.allowTo(instance, ec2.Port.tcp(22));
        }
    }
}
exports.CodeServer = CodeServer;
_a = JSII_RTTI_SYMBOL_1;
CodeServer[_a] = { fqn: "cdk-code-server.CodeServer", version: "1.0.5" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvaW5kZXgudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQSxnREFBZ0Q7QUFDaEQsMkNBQTJDO0FBQzNDLDJDQUEyQztBQUMzQywyQ0FBdUM7QUFDdkMseUNBQTBGO0FBMkQxRjs7R0FFRztBQUNILE1BQWEsVUFBVyxTQUFRLHNCQUFTO0lBQ3ZDLFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsUUFBeUIsRUFBRTtRQUNuRSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBRWpCLE1BQU0sR0FBRyxHQUFHLEtBQUssQ0FBQyxHQUFHLElBQUksSUFBSSxHQUFHLENBQUMsR0FBRyxDQUFDLElBQUksRUFBRSxLQUFLLEVBQUU7WUFDaEQsTUFBTSxFQUFFLENBQUM7WUFDVCxXQUFXLEVBQUUsQ0FBQztZQUNkLG1CQUFtQixFQUFFO2dCQUNuQjtvQkFDRSxRQUFRLEVBQUUsRUFBRTtvQkFDWixJQUFJLEVBQUUsUUFBUTtvQkFDZCxVQUFVLEVBQUUsR0FBRyxDQUFDLFVBQVUsQ0FBQyxNQUFNO2lCQUNsQzthQUNGO1NBQ0YsQ0FBQyxDQUFDO1FBRUgsTUFBTSxRQUFRLEdBQUcsSUFBSSwwQ0FBK0IsQ0FBQyxJQUFJLEVBQUUsVUFBVSxFQUFFO1lBQ3JFLEdBQUc7WUFDSCxZQUFZLEVBQUUsS0FBSyxDQUFDLFlBQVksSUFBSSxHQUFHLENBQUMsWUFBWSxDQUFDLEVBQUUsQ0FDckQsR0FBRyxDQUFDLGFBQWEsQ0FBQyxHQUFHLEVBQ3JCLEdBQUcsQ0FBQyxZQUFZLENBQUMsT0FBTyxDQUN6QjtZQUNELHFCQUFxQixFQUFFLElBQUk7WUFDM0IsWUFBWSxFQUFFO2dCQUNaO29CQUNBLDBCQUEwQjtvQkFDeEIsVUFBVSxFQUFFLFdBQVc7b0JBQ3ZCLE1BQU0sRUFBRSxHQUFHLENBQUMsaUJBQWlCLENBQUMsR0FBRyxDQUFDLEtBQUssQ0FBQyxVQUFVLElBQUksRUFBRSxFQUFFO3dCQUN4RCxtQkFBbUIsRUFBRSxJQUFJO3dCQUN6QixTQUFTLEVBQUUsS0FBSztxQkFDakIsQ0FBQztpQkFDSDthQUNGO1lBQ0QsWUFBWSxFQUFFLElBQUksR0FBRyxDQUFDLGdCQUFnQixDQUFDO2dCQUNyQyxVQUFVLEVBQUUsR0FBRyxDQUFDLHFCQUFxQixDQUFDLGlCQUFpQjtnQkFDdkQsT0FBTyxFQUFFLEtBQUssQ0FBQyxPQUFPLElBQUksR0FBRyxDQUFDLGtCQUFrQixDQUFDLE1BQU07YUFDeEQsQ0FBQztZQUNGLFVBQVUsRUFBRTtnQkFDVixVQUFVLEVBQUUsR0FBRyxDQUFDLFVBQVUsQ0FBQyxNQUFNO2FBQ2xDO1lBQ0Qsb0JBQW9CLEVBQUU7Z0JBQ3BCLFFBQVEsRUFBRTtvQkFDUixzQ0FBMkIsQ0FBQyxNQUFNO29CQUNsQyxzQ0FBMkIsQ0FBQyxNQUFNO29CQUNsQyxzQ0FBMkIsQ0FBQyxHQUFHO2lCQUNoQzthQUNGO1NBQ0YsQ0FBQyxDQUFDO1FBRUgsUUFBUSxDQUFDLFdBQVcsQ0FDbEIscUJBQXFCO1FBQ3JCLHNEQUFzRDtRQUN0RCw4Q0FBOEM7UUFDOUMsOEJBQThCO1FBQzlCLGlGQUFpRixFQUNqRixrQ0FBa0M7UUFDbEMsZ0ZBQWdGO1FBQ2hGLHNDQUFzQyxDQUN2QyxDQUFDO1FBRUYsSUFBSSxLQUFLLENBQUMsUUFBUSxJQUFJLElBQUksSUFBSSxLQUFLLENBQUMsUUFBUSxDQUFDLE1BQU0sR0FBRyxDQUFDLEVBQUUsQ0FBQztZQUN4RCxRQUFRLENBQUMsV0FBVyxDQUFDLEdBQUcsS0FBSyxDQUFDLFFBQVEsQ0FBQyxDQUFDO1FBQzFDLENBQUM7UUFFRCxRQUFRLENBQUMsZUFBZSxDQUN0QixLQUFLLENBQUMsTUFBTSxJQUFJLElBQUksR0FBRyxDQUFDLGVBQWUsQ0FBQztZQUN0QyxPQUFPLEVBQUUsQ0FBQyxHQUFHLENBQUM7WUFDZCxTQUFTLEVBQUUsQ0FBQyxHQUFHLENBQUM7U0FDakIsQ0FBQyxDQUNILENBQUM7UUFFRixrRUFBa0U7UUFDbEUsSUFBSSxLQUFLLENBQUMsMEJBQTBCLEVBQUUsQ0FBQztZQUNyQyxNQUFNLFdBQVcsR0FBRyxJQUFJLEdBQUcsQ0FBQyxPQUFPLENBQUMsdUJBQXVCLENBQ3pELElBQUksRUFDSix5QkFBeUIsRUFDekI7Z0JBQ0UsR0FBRzthQUNKLENBQ0YsQ0FBQztZQUVGLDJEQUEyRDtZQUMzRCxXQUFXLENBQUMsV0FBVyxDQUFDLE9BQU8sQ0FBQyxRQUFRLEVBQUUsR0FBRyxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQztRQUM5RCxDQUFDO0lBQ0gsQ0FBQzs7QUFwRkgsZ0NBcUZDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgb2NmIGZyb20gJ0BvcGVuLWNvbnN0cnVjdHMvYXdzLWNkayc7XG5pbXBvcnQgKiBhcyBlYzIgZnJvbSAnYXdzLWNkay1saWIvYXdzLWVjMic7XG5pbXBvcnQgKiBhcyBpYW0gZnJvbSAnYXdzLWNkay1saWIvYXdzLWlhbSc7XG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcbmltcG9ydCB7IFByZWluc3RhbGxlZEFtYXpvbkxpbnV4SW5zdGFuY2UsIFByZWluc3RhbGxlZFNvZnR3YXJlUGFja2FnZSB9IGZyb20gJy4vaW5zdGFuY2UnO1xuXG4vKipcbiAqIFByb3BlcnRpZXMgZm9yIENvZGVTZXJ2ZXIgY29uc3RydWN0XG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgQ29kZVNlcnZlclByb3BzIHtcbiAgLyoqXG4gICAqIFRoZSBWUEMgd2hlcmUgdGhlIGluc3RhbmNlIHdpbGwgYmUgZGVwbG95ZWRcbiAgICpcbiAgICogQGRlZmF1bHQgLSBBIG5ldyBWUEMgd2lsbCBiZSBjcmVhdGVkXG4gICAqL1xuICByZWFkb25seSB2cGM/OiBlYzIuSVZwYztcblxuICAvKipcbiAgICogVGhlIGluc3RhbmNlIHR5cGVcbiAgICpcbiAgICogQGRlZmF1bHQgLSBDN2cuMnhsYXJnZVxuICAgKi9cbiAgcmVhZG9ubHkgaW5zdGFuY2VUeXBlPzogZWMyLkluc3RhbmNlVHlwZTtcblxuICAvKipcbiAgICogVGhlIENQVSB0eXBlXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gQVJNXzY0XG4gICAqL1xuICByZWFkb25seSBjcHVUeXBlPzogZWMyLkFtYXpvbkxpbnV4Q3B1VHlwZTtcblxuICAvKipcbiAgICogVGhlIElBTSBwb2xpY3kgdG8gYXR0YWNoIHRvIHRoZSBpbnN0YW5jZSByb2xlXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gQWxsb3cgYWxsIGFjdGlvbnMgb24gYWxsIHJlc291cmNlc1xuICAgKi9cbiAgcmVhZG9ubHkgcG9saWN5PzogaWFtLlBvbGljeVN0YXRlbWVudDtcblxuICAvKipcbiAgICogVGhlIHNpemUgb2YgdGhlIHJvb3Qgdm9sdW1lIGluIEdpQlxuICAgKlxuICAgKiBAZGVmYXVsdCAzMFxuICAgKi9cbiAgcmVhZG9ubHkgdm9sdW1lU2l6ZT86IG51bWJlcjtcblxuICAvKipcbiAgICogVXNlciBkYXRhIHRvIHJ1biB3aGVuIGxhdW5jaGluZyB0aGUgaW5zdGFuY2VcbiAgICpcbiAgICogQGRlZmF1bHQgLSBObyBhZGRpdGlvbmFsIHVzZXIgZGF0YVxuICAgKi9cbiAgcmVhZG9ubHkgdXNlckRhdGE/OiBzdHJpbmdbXTtcblxuICAvKipcbiAgICogV2hldGhlciB0byB1c2UgRUMyIGluc3RhbmNlIGNvbm5lY3QgZW5kcG9pbnQgZm9yIGluc3RhbmNlIGFjY2Vzcy5cbiAgICpcbiAgICogSWYgc2V0IHRvIHRydWUsIGl0IHdpbGwgY3JlYXRlIGFuIEVDMiBJbnN0YW5jZSBDb25uZWN0IEVuZHBvaW50IGluIHRoZSBWUEMuXG4gICAqIFlvdSBjYW4gYWNjZXNzIHRoZSBpbnN0YW5jZSB1c2luZyBlaXRoZXIgRUMyIEluc3RhbmNlIENvbm5lY3Qgb3IgU1NNIFNlc3Npb24gTWFuYWdlci5cbiAgICpcbiAgICogQGRlZmF1bHQgZmFsc2UgLSBVc2VzIG9ubHkgU1NNIFNlc3Npb24gTWFuYWdlciBmb3IgaW5zdGFuY2UgYWNjZXNzXG4gICAqL1xuICByZWFkb25seSB1c2VJbnN0YW5jZUNvbm5lY3RFbmRwb2ludD86IGJvb2xlYW47XG59XG5cbi8qKlxuICogQSBDb2RlU2VydmVyIENvbnN0cnVjdFxuICovXG5leHBvcnQgY2xhc3MgQ29kZVNlcnZlciBleHRlbmRzIENvbnN0cnVjdCB7XG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBDb2RlU2VydmVyUHJvcHMgPSB7fSkge1xuICAgIHN1cGVyKHNjb3BlLCBpZCk7XG5cbiAgICBjb25zdCB2cGMgPSBwcm9wcy52cGMgPz8gbmV3IGVjMi5WcGModGhpcywgJ1ZwYycsIHtcbiAgICAgIG1heEF6czogMSxcbiAgICAgIG5hdEdhdGV3YXlzOiAwLFxuICAgICAgc3VibmV0Q29uZmlndXJhdGlvbjogW1xuICAgICAgICB7XG4gICAgICAgICAgY2lkck1hc2s6IDI2LFxuICAgICAgICAgIG5hbWU6ICdQdWJsaWMnLFxuICAgICAgICAgIHN1Ym5ldFR5cGU6IGVjMi5TdWJuZXRUeXBlLlBVQkxJQyxcbiAgICAgICAgfSxcbiAgICAgIF0sXG4gICAgfSk7XG5cbiAgICBjb25zdCBpbnN0YW5jZSA9IG5ldyBQcmVpbnN0YWxsZWRBbWF6b25MaW51eEluc3RhbmNlKHRoaXMsICdJbnN0YW5jZScsIHtcbiAgICAgIHZwYyxcbiAgICAgIGluc3RhbmNlVHlwZTogcHJvcHMuaW5zdGFuY2VUeXBlID8/IGVjMi5JbnN0YW5jZVR5cGUub2YoXG4gICAgICAgIGVjMi5JbnN0YW5jZUNsYXNzLkM3RyxcbiAgICAgICAgZWMyLkluc3RhbmNlU2l6ZS5YTEFSR0UyLFxuICAgICAgKSxcbiAgICAgIHNzbVNlc3Npb25QZXJtaXNzaW9uczogdHJ1ZSxcbiAgICAgIGJsb2NrRGV2aWNlczogW1xuICAgICAgICB7XG4gICAgICAgIC8vIEF0dGFjaCBhcyBhIHJvb3QgZGV2aWNlXG4gICAgICAgICAgZGV2aWNlTmFtZTogJy9kZXYveHZkYScsXG4gICAgICAgICAgdm9sdW1lOiBlYzIuQmxvY2tEZXZpY2VWb2x1bWUuZWJzKHByb3BzLnZvbHVtZVNpemUgPz8gMzAsIHtcbiAgICAgICAgICAgIGRlbGV0ZU9uVGVybWluYXRpb246IHRydWUsXG4gICAgICAgICAgICBlbmNyeXB0ZWQ6IGZhbHNlLFxuICAgICAgICAgIH0pLFxuICAgICAgICB9LFxuICAgICAgXSxcbiAgICAgIG1hY2hpbmVJbWFnZTogbmV3IGVjMi5BbWF6b25MaW51eEltYWdlKHtcbiAgICAgICAgZ2VuZXJhdGlvbjogZWMyLkFtYXpvbkxpbnV4R2VuZXJhdGlvbi5BTUFaT05fTElOVVhfMjAyMyxcbiAgICAgICAgY3B1VHlwZTogcHJvcHMuY3B1VHlwZSA/PyBlYzIuQW1hem9uTGludXhDcHVUeXBlLkFSTV82NCxcbiAgICAgIH0pLFxuICAgICAgdnBjU3VibmV0czoge1xuICAgICAgICBzdWJuZXRUeXBlOiBlYzIuU3VibmV0VHlwZS5QVUJMSUMsXG4gICAgICB9LFxuICAgICAgcHJlaW5zdGFsbGVkU29mdHdhcmU6IHtcbiAgICAgICAgcGFja2FnZXM6IFtcbiAgICAgICAgICBQcmVpbnN0YWxsZWRTb2Z0d2FyZVBhY2thZ2UuTk9ERUpTLFxuICAgICAgICAgIFByZWluc3RhbGxlZFNvZnR3YXJlUGFja2FnZS5WU0NPREUsXG4gICAgICAgICAgUHJlaW5zdGFsbGVkU29mdHdhcmVQYWNrYWdlLkdJVCxcbiAgICAgICAgXSxcbiAgICAgIH0sXG4gICAgfSk7XG5cbiAgICBpbnN0YW5jZS5hZGRVc2VyRGF0YShcbiAgICAgICducG0gaW5zdGFsbCAtZyB5YXJuJyxcbiAgICAgIC8vIEluc3RhbGwgbWFrZSBhbmQgb3RoZXIgYnVpbGQgdG9vbHMgZm9yIHNldHVwIG9mIENES1xuICAgICAgXCJzdWRvIGRuZiBncm91cGluc3RhbGwgLXkgJ0RldmVsb3BtZW50IFRvb2xzJ1wiLFxuICAgICAgLy8gSW5jcmVhc2UgbWVtb3J5IGZvciBOb2RlLmpzXG4gICAgICBcImVjaG8gJ2V4cG9ydCBOT0RFX09QVElPTlM9LS1tYXgtb2xkLXNwYWNlLXNpemU9ODE5MicgPj4gL2V0Yy9wcm9maWxlLmQvbXllbnYuc2hcIixcbiAgICAgICdjaG1vZCAreCAvZXRjL3Byb2ZpbGUuZC9teWVudi5zaCcsXG4gICAgICAvLyBFbmFibGUgbGluZ2VyIGZvciBlYzItdXNlciB0byBhbGxvdyBydW5uaW5nIHNlcnZpY2VzIHdpdGhvdXQgYSB1c2VyIGxvZ2dlZCBpblxuICAgICAgJ3N1ZG8gbG9naW5jdGwgZW5hYmxlLWxpbmdlciBlYzItdXNlcicsXG4gICAgKTtcblxuICAgIGlmIChwcm9wcy51c2VyRGF0YSAhPSBudWxsICYmIHByb3BzLnVzZXJEYXRhLmxlbmd0aCA+IDApIHtcbiAgICAgIGluc3RhbmNlLmFkZFVzZXJEYXRhKC4uLnByb3BzLnVzZXJEYXRhKTtcbiAgICB9XG5cbiAgICBpbnN0YW5jZS5hZGRUb1JvbGVQb2xpY3koXG4gICAgICBwcm9wcy5wb2xpY3kgPz8gbmV3IGlhbS5Qb2xpY3lTdGF0ZW1lbnQoe1xuICAgICAgICBhY3Rpb25zOiBbJyonXSxcbiAgICAgICAgcmVzb3VyY2VzOiBbJyonXSxcbiAgICAgIH0pLFxuICAgICk7XG5cbiAgICAvLyBDcmVhdGUgRUMyIEluc3RhbmNlIENvbm5lY3QgRW5kcG9pbnQgb25seSBpZiBTU00gaXMgbm90IGVuYWJsZWRcbiAgICBpZiAocHJvcHMudXNlSW5zdGFuY2VDb25uZWN0RW5kcG9pbnQpIHtcbiAgICAgIGNvbnN0IGVpY0VuZHBvaW50ID0gbmV3IG9jZi5hd3NfZWMyLkluc3RhbmNlQ29ubmVjdEVuZHBvaW50KFxuICAgICAgICB0aGlzLFxuICAgICAgICAnSW5zdGFuY2VDb25uZWN0RW5kcG9pbnQnLFxuICAgICAgICB7XG4gICAgICAgICAgdnBjLFxuICAgICAgICB9LFxuICAgICAgKTtcblxuICAgICAgLy8gT3BlbmluZyBTZWN1cml0eSBHcm91cCBmcm9tIEVJQyBFbmRwb2ludCB0byBFQzIgSW5zdGFuY2VcbiAgICAgIGVpY0VuZHBvaW50LmNvbm5lY3Rpb25zLmFsbG93VG8oaW5zdGFuY2UsIGVjMi5Qb3J0LnRjcCgyMikpO1xuICAgIH1cbiAgfVxufSJdfQ==