import { IResource, Resource, aws_ec2 } from 'aws-cdk-lib';
import { Construct } from 'constructs';
/**
 * An EC2 Instance Connect Endpoint.
 */
export interface IInstanceConnectEndpoint extends aws_ec2.IConnectable, IResource {
    /**
     * The ID of the EC2 Instance Connect Endpoint.
     *
     * @attribute
     */
    readonly instanceConnectEndpointId: string;
}
/**
 * Properties for defining an EC2 Instance Connect Endpoint.
 */
export interface InstanceConnectEndpointProps {
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     *
     * @see https://docs.aws.amazon.com/ja_jp/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-instanceconnectendpoint.html#cfn-ec2-instanceconnectendpoint-clienttoken
     */
    readonly clientToken?: string;
    /**
     * Indicates whether your client's IP address is preserved as the source.
     *
     * @see https://docs.aws.amazon.com/ja_jp/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-instanceconnectendpoint.html#cfn-ec2-instanceconnectendpoint-preserveclientip
     * @default true
     */
    readonly preserveClientIp?: boolean;
    /**
     * The security groups to associate with the EC2 Instance Connect Endpoint.
     *
     * @default - a new security group is created
     */
    readonly securityGroups?: aws_ec2.ISecurityGroup[];
    /**
     * The VPC in which the EC2 Instance Connect Endpoint is created.
     */
    readonly vpc: aws_ec2.IVpc;
}
/**
 * Attributes for importing an EC2 Instance Connect Endpoint.
 */
export interface InstanceConnectEndpointAttributes {
    /**
     * The ID of the EC2 Instance Connect Endpoint.
     */
    readonly instanceConnectEndpointId: string;
    /**
     * The security groups associated with the EC2 Instance Connect Endpoint.
     */
    readonly securityGroups: aws_ec2.ISecurityGroup[];
}
/**
 * Represents an EC2 Instance Connect Endpoint construct in AWS CDK.
 *
 * @example
 * declare const securityGroups: aws_ec2.ISecurityGroup[];
 * declare const vpc: aws_ec2.IVpc;
 *
 * const instanceConnectEndpoint = new InstanceConnectEndpoint(
 *   stack,
 *   'InstanceConnectEndpoint',
 *   {
 *     clientToken: 'my-client-token',
 *     preserveClientIp: true,
 *     securityGroups,
 *     vpc,
 *   },
 * );
 */
export declare class InstanceConnectEndpoint extends Resource implements IInstanceConnectEndpoint {
    /**
     * Import an existing endpoint to the stack from its attributes.
     */
    static fromInstanceConnectEndpointAttributes(scope: Construct, id: string, attrs: InstanceConnectEndpointAttributes): IInstanceConnectEndpoint;
    /**
     * The ID of the EC2 Instance Connect Endpoint.
     */
    readonly instanceConnectEndpointId: string;
    /**
     * The connection object associated with the EC2 Instance Connect Endpoint.
     */
    readonly connections: aws_ec2.Connections;
    private readonly props;
    private readonly securityGroups;
    constructor(scope: Construct, id: string, props: InstanceConnectEndpointProps);
    protected createInstanceConnectEndpoint(): aws_ec2.CfnInstanceConnectEndpoint;
    protected createSecurityGroup(): aws_ec2.SecurityGroup;
}
