"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DailySnapshotTime = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Class for scheduling a daily snapshot time.
 */
class DailySnapshotTime {
    constructor(props) {
        this.validate(props.hour, props.minute);
        this.hour = this.getTwoDigitString(props.hour);
        this.minute = this.getTwoDigitString(props.minute);
    }
    /**
     * Converts an hour, and minute into HH:MM string.
     */
    toTimestamp() {
        return `${this.hour}:${this.minute}`;
    }
    /**
     * Pad an integer so that it always contains at least 2 digits.
     * Assumes the number is a positive integer.
     */
    getTwoDigitString(n) {
        const numberString = n.toString();
        if (numberString.length === 1) {
            return `0${n}`;
        }
        return numberString;
    }
    /**
     * Validation needed for the values of the daily snapshot time.
     */
    validate(hour, minute) {
        if (!Number.isInteger(hour) || hour < 0 || hour > 23) {
            throw new Error(`dailySnapshotTime hour must be an integer between 0 and 23, got: ${hour}`);
        }
        if (!Number.isInteger(minute) || minute < 0 || minute > 59) {
            throw new Error(`dailySnapshotTime minute must be an integer between 0 and 59, got: ${minute}`);
        }
    }
}
exports.DailySnapshotTime = DailySnapshotTime;
_a = JSII_RTTI_SYMBOL_1;
DailySnapshotTime[_a] = { fqn: "@open-constructs/aws-cdk.aws_elasticache.DailySnapshotTime", version: "0.1.2" };
//# sourceMappingURL=data:application/json;base64,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