"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DailyAutomaticBackupStartTime = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Class for scheduling a daily automatic backup time.
 */
class DailyAutomaticBackupStartTime {
    constructor(props) {
        this.validate(props.hour, props.minute);
        this.hour = this.getTwoDigitString(props.hour);
        this.minute = this.getTwoDigitString(props.minute);
    }
    /**
     * Converts an hour, and minute into HH:MM string.
     */
    toTimestamp() {
        return `${this.hour}:${this.minute}`;
    }
    /**
     * Pad an integer so that it always contains at least 2 digits. Assumes the number is a positive integer.
     */
    getTwoDigitString(n) {
        const numberString = n.toString();
        if (numberString.length === 1) {
            return `0${n}`;
        }
        return numberString;
    }
    /**
     * Validation needed for the values of the daily automatic backup time.
     */
    validate(hour, minute) {
        if (!Number.isInteger(hour) || hour < 0 || hour > 23) {
            throw new Error(`dailyAutomaticBackupStartTime hour must be an integer between 0 and 24. received: ${hour}`);
        }
        if (!Number.isInteger(minute) || minute < 0 || minute > 59) {
            throw new Error(`dailyAutomaticBackupStartTime minute must be an integer between 0 and 59. received: ${minute}`);
        }
    }
}
exports.DailyAutomaticBackupStartTime = DailyAutomaticBackupStartTime;
_a = JSII_RTTI_SYMBOL_1;
DailyAutomaticBackupStartTime[_a] = { fqn: "@open-constructs/aws-cdk.aws_fsx.DailyAutomaticBackupStartTime", version: "0.1.2" };
//# sourceMappingURL=data:application/json;base64,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