"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MaintenanceTime = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Class for scheduling a weekly maintenance time.
 */
class MaintenanceTime {
    constructor(props) {
        this.validate(props.hour, props.minute);
        this.day = props.day;
        this.hour = this.getTwoDigitString(props.hour);
        this.minute = this.getTwoDigitString(props.minute);
    }
    /**
     * Converts a day, hour, and minute into a timestamp as used by FSx for Lustre's weeklyMaintenanceStartTime field.
     */
    toTimestamp() {
        return `${this.day.valueOf()}:${this.hour}:${this.minute}`;
    }
    /**
     * Pad an integer so that it always contains at least 2 digits. Assumes the number is a positive integer.
     */
    getTwoDigitString(n) {
        const numberString = n.toString();
        if (numberString.length === 1) {
            return `0${n}`;
        }
        return numberString;
    }
    /**
     * Validation needed for the values of the maintenance time.
     */
    validate(hour, minute) {
        if (!Number.isInteger(hour) || hour < 0 || hour > 23) {
            throw new Error('Maintenance time hour must be an integer between 0 and 23');
        }
        if (!Number.isInteger(minute) || minute < 0 || minute > 59) {
            throw new Error('Maintenance time minute must be an integer between 0 and 59');
        }
    }
}
exports.MaintenanceTime = MaintenanceTime;
_a = JSII_RTTI_SYMBOL_1;
MaintenanceTime[_a] = { fqn: "@open-constructs/aws-cdk.aws_fsx.MaintenanceTime", version: "0.1.2" };
//# sourceMappingURL=data:application/json;base64,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