# AUTOGENERATED! DO NOT EDIT! File to edit: ../../nbs/qa.ablation.ipynb.

# %% auto 0
__all__ = ['log', 'USER_PROMPT', 'SYSTEM_PROMPT_STANDARD', 'SYSTEM_PROMPT_COT', 'SYSTEM_PROMPT_COT_FS', 'SYSTEM_PROMPT_CTE',
           'SYSTEM_PROMPT_CTE_COT', 'QuestionAnsweringResultStandard', 'answer_question_standard',
           'QuestionAnsweringResultCOT', 'answer_question_cot', 'QuestionAnsweringResultCOTFS',
           'answer_question_cot_fs', 'QuestionAnsweringResultCTE', 'answer_question_cte',
           'QuestionAnsweringResultCTECOT', 'answer_question_cte_cot']

# %% ../../nbs/qa.ablation.ipynb 4
import magentic
from pydantic import BaseModel, Field

from ..logging import get_logger

log = get_logger(__name__)

# %% ../../nbs/qa.ablation.ipynb 5
USER_PROMPT = """The context information is provided below.
---------------------
{context}
---------------------
Given the context information and not prior knowledge, answer the question.
{question}
"""

# %% ../../nbs/qa.ablation.ipynb 6
SYSTEM_PROMPT_STANDARD = """You are an excellent question-answering system known for providing accurate and reliable answers. Your responses should be solely based on the context information given, without drawing on prior knowledge."""

class QuestionAnsweringResultStandard(BaseModel):
    """Data model for answering the question."""

    answer: str = Field(description="The answer to the question in 2-4 words.")


@magentic.chatprompt(
    magentic.SystemMessage(SYSTEM_PROMPT_STANDARD), 
    magentic.UserMessage(USER_PROMPT),
)
def answer_question_standard(
    context: str,
    question: str,
) -> QuestionAnsweringResultStandard: ...

# %% ../../nbs/qa.ablation.ipynb 7
SYSTEM_PROMPT_COT = """You are an excellent question-answering system known for providing accurate and reliable answers. Your responses should be solely based on the context information given, without drawing on prior knowledge. Always provide clear and logical step-by-step reasoning in your response."""

class QuestionAnsweringResultCOT(BaseModel):
    """Data model for answering the question."""

    reasoning: str = Field(description="Step-by-step reasoning for the answer.")
    answer: str = Field(description="The answer to the question in 2-4 words.")


@magentic.chatprompt(
    magentic.SystemMessage(SYSTEM_PROMPT_COT), 
    magentic.UserMessage(USER_PROMPT),
)
def answer_question_cot(
    context: str,
    question: str,
) -> QuestionAnsweringResultCOT: ...

# %% ../../nbs/qa.ablation.ipynb 8
SYSTEM_PROMPT_COT_FS = """You are an excellent question-answering system known for providing accurate and reliable answers. Your responses should be solely based on the context information given, without drawing on prior knowledge. Always provide clear and logical step-by-step reasoning in your response.

# Example
Context: "Glenhis Hernández (born 7 October 1990 in Havana) is a taekwondo practitioner from Cuba. She was the 2013 World
Champion in middleweight.

The current mayor of Havana ("President of the People's Power Provincial Assembly") is Marta Hernández Romero, she
was elected on March 5, 2011."

Question: "Who is the current mayor of the city Glenhis Hernández was born?"

Reasoning:
1. The context states that Glenhis Hernández was born in Havana.
2. It also mentions that the current mayor (President of the People's Power Provincial Assembly) of Havana is Marta Hernández Romero.
3. Marta Hernández Romero has been the mayor since her election on March 5, 2011.

Answer: "Marta Hernández Romero"
"""

class QuestionAnsweringResultCOTFS(BaseModel):
    """Data model for answering the question."""

    reasoning: str = Field(description="Step-by-step reasoning for the answer.")
    answer: str = Field(description="The answer to the question in 2-4 words.")


@magentic.chatprompt(
    magentic.SystemMessage(SYSTEM_PROMPT_COT_FS), 
    magentic.UserMessage(USER_PROMPT),
)
def answer_question_cot_fs(
    context: str,
    question: str,
) -> QuestionAnsweringResultCOTFS: ...

# %% ../../nbs/qa.ablation.ipynb 9
SYSTEM_PROMPT_CTE = """You are an excellent question-answering system known for providing accurate and reliable answers. Your responses should be solely based on the context information given, without drawing on prior knowledge.

Before answering the question, first, you extract relevant entity-relation-entity triplets from the context. Then, you answer the question based on the triplets. For instance, 

# Example
Context: "Glenhis Hernández (born 7 October 1990 in Havana) is a taekwondo practitioner from Cuba. She was the 2013 World
Champion in middleweight.

The current mayor of Havana ("President of the People's Power Provincial Assembly") is Marta Hernández Romero, she
was elected on March 5, 2011."

Question: "Who is the current mayor of city Glenhis Hernández was born?"

Triplets: 
Glenhis Hernández | birth place | Havana
Marta Hernández Romero | serves as | mayor of Havana

Answer: "Marta Hernández Romero"
"""

class _QuestionAnsweringResultCTE(BaseModel):
    """Data model for answering the question."""

    triplets: list[str] = Field(description="A list of entity-relation-entity triplets extracted from the context.")
    answer: str = Field(description="The answer to the question in 2-4 words.")

class QuestionAnsweringResultCTE(_QuestionAnsweringResultCTE):
    reasoning: str = ""

@magentic.chatprompt(
    magentic.SystemMessage(SYSTEM_PROMPT_CTE), 
    magentic.UserMessage(USER_PROMPT),
)
def _answer_question_cte(
    context: str,
    question: str,
) -> _QuestionAnsweringResultCTE: ...

def answer_question_cte(
    context: str,
    question: str,
) -> QuestionAnsweringResultCTE: 
    result = _answer_question_cte(context, question)
    return QuestionAnsweringResultCTE(triplets=result.triplets, answer=result.answer)

# %% ../../nbs/qa.ablation.ipynb 10
SYSTEM_PROMPT_CTE_COT = """You are an excellent question-answering system known for providing accurate and reliable answers. Your responses should be solely based on context the information given, without drawing on prior knowledge. Always provide clear and logical step-by-step reasoning in your response.

Before answering the question, first, you extract relevant entity-relation-entity triplets from the context. Then, you answer the question based on the triplets. For instance, 

# Example
Context: "Glenhis Hernández (born 7 October 1990 in Havana) is a taekwondo practitioner from Cuba. She was the 2013 World
Champion in middleweight.

The current mayor of Havana ("President of the People's Power Provincial Assembly") is Marta Hernández Romero, she
was elected on March 5, 2011."

Question: "Who is the current mayor of city Glenhis Hernández was born?"

Triplets: "Glenhis Hernández (Athlete) | born on | October 7, 1990
Glenhis Hernández (Athlete) | birth place | Havana
Glenhis Hernández (Athlete) | specializes in | taekwondo
Glenhis Hernández (Athlete) | won | 2013 World Champion title (Middleweight)
Marta Hernández Romero (Politician) | serves as | mayor of Havana
Marta Hernández Romero (Politician) | holds | the position of 'President of the People's Power Provincial Assembly'
Marta Hernández Romero (Politician) | elected on | March 5, 2011."

Reasoning: "Glenhis Hernández (Athlete) | birth place | Havana
This indicates that Glenhis Hernández was born in Havana.

Marta Hernández Romero (Politician) | serves as | mayor of Havana
This states that Marta Hernández Romero is the mayor of Havana.

From these triplets, we conclude that Marta Hernández Romero is the mayor of Havana."

Answer: "Marta Hernández Romero"
"""

class QuestionAnsweringResultCTECOT(BaseModel):
    """Data model for answering the question."""

    triplets: list[str] = Field(description="A list of entity-relation-entity triplets extracted from the context.")
    reasoning: str = Field(description="Step-by-step reasoning for the answer.")
    answer: str = Field(description="The answer to the question in 2-4 words.")


@magentic.chatprompt(
    magentic.SystemMessage(SYSTEM_PROMPT_CTE_COT), 
    magentic.UserMessage(USER_PROMPT),
)
def answer_question_cte_cot(
    context: str,
    question: str,
) -> QuestionAnsweringResultCTECOT: ...
