/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
import * as lambda from "aws-cdk-lib/aws-lambda";
import * as ec2 from "aws-cdk-lib/aws-ec2";
import * as cache from "aws-cdk-lib/aws-elasticache";
import { Construct } from "constructs";
/**
 * @summary The properties for the LambdaToElasticachememcached class.
 */
export interface LambdaToElasticachememcachedProps {
    /**
     * Existing instance of Lambda Function object, providing both this and `lambdaFunctionProps` will cause an error.
     *
     * @default - None
     */
    readonly existingLambdaObj?: lambda.Function;
    /**
     * Optional user provided props to override the default props for the Lambda function.
     *
     * @default - Default properties are used.
     */
    readonly lambdaFunctionProps?: lambda.FunctionProps;
    /**
     * An existing VPC for the construct to use (construct will NOT create a new VPC in this case)
     *
     * @default - none
     */
    readonly existingVpc?: ec2.IVpc;
    /**
     * Properties to override default properties if deployVpc is true
     *
     * @default - DefaultIsolatedVpcProps() in vpc-defaults.ts
     */
    readonly vpcProps?: ec2.VpcProps;
    /**
     * Optional Name for the Lambda function environment variable set to the cache endpoint.
     *
     * @default - CACHE_ENDPOINT
     */
    readonly cacheEndpointEnvironmentVariableName?: string;
    /**
     * Optional user provided props to override the default props for the Elasticache cache.
     * Providing both this and `existingCache` will cause an error.  If you provide this,
     * you must provide the associated VPC in existingVpc.
     *
     * @default - Default properties are used (core/lib/elasticacahe-defaults.ts)
     */
    readonly cacheProps?: cache.CfnCacheClusterProps | any;
    /**
     * Existing instance of Elasticache Cluster object, providing both this and `cacheProps` will cause an error.
     *
     * @default - none
     */
    readonly existingCache?: cache.CfnCacheCluster;
}
/**
 * @summary The LambdaToElasticachememcached class.
 */
export declare class LambdaToElasticachememcached extends Construct {
    readonly lambdaFunction: lambda.Function;
    readonly vpc: ec2.IVpc;
    readonly cache: cache.CfnCacheCluster;
    /**
     * @summary Constructs a new instance of the LambdaToElasticachememcached class.
     * @param {cdk.App} scope - represents the scope for all the resources.
     * @param {string} id - this is a a scope-unique id.
     * @param {LambdaToElasticachememcachedProps} props - user provided props for the construct.
     * @access public
     */
    constructor(scope: Construct, id: string, props: LambdaToElasticachememcachedProps);
}
