function(link_to_target targetName)
    if (NOT TARGET curses)
        add_library(curses INTERFACE)
        vcpkg_download(curses)
        if (MSVC)
            find_vcpkg_library(libpdcurses pdcurses)
            find_path(hdr curses.h)
            target_link_libraries(curses INTERFACE ${libpdcurses})
            target_include_directories(curses INTERFACE "${hdr}")
        elseif(LINUX)
            find_package(Curses REQUIRED)
            target_link_libraries(curses INTERFACE ${CURSES_LIBRARIES})
            target_include_directories(curses INTERFACE "${CURSES_INCLUDE_DIR}/ncurses")
        endif()
    endif()
    target_link_libraries(${targetName} PRIVATE curses)
endfunction()
