from datetime import datetime, date
from typing import Union, Optional

from enemera.api.base import BaseCurveClient
from enemera.core.constants import BASE_URL
from enemera.core.response import APIResponse
from enemera.models.response_models import SpainPriceResponse


class SpainPricesClient(BaseCurveClient):
    """Client for Spanish electricity prices"""

    def __init__(self, api_key: Optional[str] = None):
        super().__init__(base_url=BASE_URL, api_key=api_key)

    def get(self,
            market: str,
            date_from: Union[str, datetime, date],
            date_to: Union[str, datetime, date]) -> APIResponse[SpainPriceResponse]:
        """Get Spanish electricity prices"""
        params = {
            'market': market,
            'date_from': date_from,
            'date_to': date_to
        }
        response = self._make_request('/spain/prices', params)
        return self._parse_response(response, SpainPriceResponse)
