# Generated by Django 3.0.5 on 2020-07-22 07:52

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Rate',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False,
                                        verbose_name='ID')),
                ('key', models.CharField(db_index=True, default=None, max_length=255, null=True)),
                ('value_date', models.DateField()),
                ('value', models.FloatField(default=0)),
                ('currency', models.CharField(max_length=3)),
                ('base_currency', models.CharField(default='EUR', max_length=3)),
                ('user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.PROTECT,
                                           related_name='rates', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ['-value_date'],
            },
        ),
        migrations.AddIndex(
            model_name='rate',
            index=models.Index(fields=['currency', 'base_currency', 'value_date'],
                               name='rates_rate_currenc_6a7540_idx'),
        ),
        migrations.AddIndex(
            model_name='rate',
            index=models.Index(fields=['key', 'currency', 'base_currency', 'value_date'],
                               name='rates_rate_key_8c7b0f_idx'),
        ),
        migrations.AlterUniqueTogether(
            name='rate',
            unique_together={('key', 'currency', 'base_currency', 'value_date')},
        ),
    ]
