# coding: utf-8

"""
    Yagna Market API

     ## Yagna Market The Yagna Market is a core component of the Yagna Network, which enables computational Offers and Demands circulation. The Market is open for all entities willing to buy computations (Demands) or monetize computational resources (Offers). ## Yagna Market API The Yagna Market API is the entry to the Yagna Market through which Requestors and Providers can publish their Demands and Offers respectively, find matching counterparty, conduct negotiations and make an agreement.  This version of Market API conforms with capability level 1 of the <a href=\"https://docs.google.com/document/d/1Zny_vfgWV-hcsKS7P-Kdr3Fb0dwfl-6T_cYKVQ9mkNg\"> Market API specification</a>.  Market API contains two roles: Requestors and Providers which are symmetrical most of the time (excluding agreement phase).   # noqa: E501

    The version of the OpenAPI document: 1.5.2
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ya_market.configuration import Configuration


class Agreement(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'agreement_id': 'str',
        'demand': 'Demand',
        'offer': 'Offer',
        'valid_to': 'datetime',
        'approved_date': 'datetime',
        'state': 'str',
        'proposed_signature': 'str',
        'approved_signature': 'str',
        'committed_signature': 'str'
    }

    attribute_map = {
        'agreement_id': 'agreementId',
        'demand': 'demand',
        'offer': 'offer',
        'valid_to': 'validTo',
        'approved_date': 'approvedDate',
        'state': 'state',
        'proposed_signature': 'proposedSignature',
        'approved_signature': 'approvedSignature',
        'committed_signature': 'committedSignature'
    }

    def __init__(self, agreement_id=None, demand=None, offer=None, valid_to=None, approved_date=None, state=None, proposed_signature=None, approved_signature=None, committed_signature=None, local_vars_configuration=None):  # noqa: E501
        """Agreement - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._agreement_id = None
        self._demand = None
        self._offer = None
        self._valid_to = None
        self._approved_date = None
        self._state = None
        self._proposed_signature = None
        self._approved_signature = None
        self._committed_signature = None
        self.discriminator = None

        self.agreement_id = agreement_id
        self.demand = demand
        self.offer = offer
        self.valid_to = valid_to
        if approved_date is not None:
            self.approved_date = approved_date
        self.state = state
        if proposed_signature is not None:
            self.proposed_signature = proposed_signature
        if approved_signature is not None:
            self.approved_signature = approved_signature
        if committed_signature is not None:
            self.committed_signature = committed_signature

    @property
    def agreement_id(self):
        """Gets the agreement_id of this Agreement.  # noqa: E501


        :return: The agreement_id of this Agreement.  # noqa: E501
        :rtype: str
        """
        return self._agreement_id

    @agreement_id.setter
    def agreement_id(self, agreement_id):
        """Sets the agreement_id of this Agreement.


        :param agreement_id: The agreement_id of this Agreement.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and agreement_id is None:  # noqa: E501
            raise ValueError("Invalid value for `agreement_id`, must not be `None`")  # noqa: E501

        self._agreement_id = agreement_id

    @property
    def demand(self):
        """Gets the demand of this Agreement.  # noqa: E501


        :return: The demand of this Agreement.  # noqa: E501
        :rtype: Demand
        """
        return self._demand

    @demand.setter
    def demand(self, demand):
        """Sets the demand of this Agreement.


        :param demand: The demand of this Agreement.  # noqa: E501
        :type: Demand
        """
        if self.local_vars_configuration.client_side_validation and demand is None:  # noqa: E501
            raise ValueError("Invalid value for `demand`, must not be `None`")  # noqa: E501

        self._demand = demand

    @property
    def offer(self):
        """Gets the offer of this Agreement.  # noqa: E501


        :return: The offer of this Agreement.  # noqa: E501
        :rtype: Offer
        """
        return self._offer

    @offer.setter
    def offer(self, offer):
        """Sets the offer of this Agreement.


        :param offer: The offer of this Agreement.  # noqa: E501
        :type: Offer
        """
        if self.local_vars_configuration.client_side_validation and offer is None:  # noqa: E501
            raise ValueError("Invalid value for `offer`, must not be `None`")  # noqa: E501

        self._offer = offer

    @property
    def valid_to(self):
        """Gets the valid_to of this Agreement.  # noqa: E501

        End of validity period. Agreement needs to be accepted, rejected or cancellled before this date; otherwise will expire   # noqa: E501

        :return: The valid_to of this Agreement.  # noqa: E501
        :rtype: datetime
        """
        return self._valid_to

    @valid_to.setter
    def valid_to(self, valid_to):
        """Sets the valid_to of this Agreement.

        End of validity period. Agreement needs to be accepted, rejected or cancellled before this date; otherwise will expire   # noqa: E501

        :param valid_to: The valid_to of this Agreement.  # noqa: E501
        :type: datetime
        """
        if self.local_vars_configuration.client_side_validation and valid_to is None:  # noqa: E501
            raise ValueError("Invalid value for `valid_to`, must not be `None`")  # noqa: E501

        self._valid_to = valid_to

    @property
    def approved_date(self):
        """Gets the approved_date of this Agreement.  # noqa: E501

        date of the Agreement approval  # noqa: E501

        :return: The approved_date of this Agreement.  # noqa: E501
        :rtype: datetime
        """
        return self._approved_date

    @approved_date.setter
    def approved_date(self, approved_date):
        """Sets the approved_date of this Agreement.

        date of the Agreement approval  # noqa: E501

        :param approved_date: The approved_date of this Agreement.  # noqa: E501
        :type: datetime
        """

        self._approved_date = approved_date

    @property
    def state(self):
        """Gets the state of this Agreement.  # noqa: E501

        * `Proposal` - newly created by a Requestor (based on Proposal) * `Pending` - confirmed by a Requestor and send to Provider for approval * `Cancelled` by a Requestor * `Rejected` by a Provider * `Approved` by both sides * `Expired` - not accepted, rejected nor cancelled within validity period * `Terminated` - finished after approval.   # noqa: E501

        :return: The state of this Agreement.  # noqa: E501
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this Agreement.

        * `Proposal` - newly created by a Requestor (based on Proposal) * `Pending` - confirmed by a Requestor and send to Provider for approval * `Cancelled` by a Requestor * `Rejected` by a Provider * `Approved` by both sides * `Expired` - not accepted, rejected nor cancelled within validity period * `Terminated` - finished after approval.   # noqa: E501

        :param state: The state of this Agreement.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and state is None:  # noqa: E501
            raise ValueError("Invalid value for `state`, must not be `None`")  # noqa: E501
        allowed_values = ["Proposal", "Pending", "Cancelled", "Rejected", "Approved", "Expired", "Terminated"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and state not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `state` ({0}), must be one of {1}"  # noqa: E501
                .format(state, allowed_values)
            )

        self._state = state

    @property
    def proposed_signature(self):
        """Gets the proposed_signature of this Agreement.  # noqa: E501


        :return: The proposed_signature of this Agreement.  # noqa: E501
        :rtype: str
        """
        return self._proposed_signature

    @proposed_signature.setter
    def proposed_signature(self, proposed_signature):
        """Sets the proposed_signature of this Agreement.


        :param proposed_signature: The proposed_signature of this Agreement.  # noqa: E501
        :type: str
        """

        self._proposed_signature = proposed_signature

    @property
    def approved_signature(self):
        """Gets the approved_signature of this Agreement.  # noqa: E501


        :return: The approved_signature of this Agreement.  # noqa: E501
        :rtype: str
        """
        return self._approved_signature

    @approved_signature.setter
    def approved_signature(self, approved_signature):
        """Sets the approved_signature of this Agreement.


        :param approved_signature: The approved_signature of this Agreement.  # noqa: E501
        :type: str
        """

        self._approved_signature = approved_signature

    @property
    def committed_signature(self):
        """Gets the committed_signature of this Agreement.  # noqa: E501


        :return: The committed_signature of this Agreement.  # noqa: E501
        :rtype: str
        """
        return self._committed_signature

    @committed_signature.setter
    def committed_signature(self, committed_signature):
        """Sets the committed_signature of this Agreement.


        :param committed_signature: The committed_signature of this Agreement.  # noqa: E501
        :type: str
        """

        self._committed_signature = committed_signature

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Agreement):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Agreement):
            return True

        return self.to_dict() != other.to_dict()
