# coding: utf-8

"""
    Yagna Payment API

     Invoicing and Payments is a fundamental area of Yagna Ecosystem functionality. It includes aspects of communication between Requestor, Provider and a selected Payment Platform, which becomes crucial when Activities are executed in the context of negotiated Agreements. Yagna applications must be able to exercise various payment models, and the Invoicing/Payment-related communication is happening in parallel to Activity control communication. To define functional patterns of Requestor/Provider interaction in this area, Payment API is specified.  An important principle of the Yagna Payment API is that the actual payment transactions are hidden behind the Invoice flow. In other words, a Yagna Application on Requestor side isn’t expected to trigger actual payment transactions. Instead it is expected to receive and accept Invoices raised by the Provider - based on Application’s Invoice Accept notifications, the Payment API implementation orchestrates the payment via a configured Payment platform.  **NOTE: This specification is work-in-progress.**   # noqa: E501

    The version of the OpenAPI document: 1.2.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ya_payment.configuration import Configuration


class Rejection(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'rejection_reason': 'RejectionReason',
        'total_amount_accepted': 'str',
        'message': 'str'
    }

    attribute_map = {
        'rejection_reason': 'rejectionReason',
        'total_amount_accepted': 'totalAmountAccepted',
        'message': 'message'
    }

    def __init__(self, rejection_reason=None, total_amount_accepted=None, message=None, local_vars_configuration=None):  # noqa: E501
        """Rejection - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._rejection_reason = None
        self._total_amount_accepted = None
        self._message = None
        self.discriminator = None

        self.rejection_reason = rejection_reason
        self.total_amount_accepted = total_amount_accepted
        if message is not None:
            self.message = message

    @property
    def rejection_reason(self):
        """Gets the rejection_reason of this Rejection.  # noqa: E501


        :return: The rejection_reason of this Rejection.  # noqa: E501
        :rtype: RejectionReason
        """
        return self._rejection_reason

    @rejection_reason.setter
    def rejection_reason(self, rejection_reason):
        """Sets the rejection_reason of this Rejection.


        :param rejection_reason: The rejection_reason of this Rejection.  # noqa: E501
        :type: RejectionReason
        """
        if self.local_vars_configuration.client_side_validation and rejection_reason is None:  # noqa: E501
            raise ValueError("Invalid value for `rejection_reason`, must not be `None`")  # noqa: E501

        self._rejection_reason = rejection_reason

    @property
    def total_amount_accepted(self):
        """Gets the total_amount_accepted of this Rejection.  # noqa: E501


        :return: The total_amount_accepted of this Rejection.  # noqa: E501
        :rtype: str
        """
        return self._total_amount_accepted

    @total_amount_accepted.setter
    def total_amount_accepted(self, total_amount_accepted):
        """Sets the total_amount_accepted of this Rejection.


        :param total_amount_accepted: The total_amount_accepted of this Rejection.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and total_amount_accepted is None:  # noqa: E501
            raise ValueError("Invalid value for `total_amount_accepted`, must not be `None`")  # noqa: E501

        self._total_amount_accepted = total_amount_accepted

    @property
    def message(self):
        """Gets the message of this Rejection.  # noqa: E501


        :return: The message of this Rejection.  # noqa: E501
        :rtype: str
        """
        return self._message

    @message.setter
    def message(self, message):
        """Sets the message of this Rejection.


        :param message: The message of this Rejection.  # noqa: E501
        :type: str
        """

        self._message = message

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Rejection):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Rejection):
            return True

        return self.to_dict() != other.to_dict()
