"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DeploymentTierStage = exports.ContextLoadingStage = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const context_1 = require("./context");
const tier_1 = require("./tier");
/**
 * A Stage that can load context values from a JSON file.
 */
class ContextLoadingStage extends aws_cdk_lib_1.Stage {
    /**
     * Creates a new ContextLoadingStage.
     *
     * @param scope - The scope in which to define this construct.
     * @param id - The scoped construct ID.
     * @param props - Initialization properties for this construct.
     */
    constructor(scope, id, props) {
        super(scope, id, { ...props });
        if (props.contextFile) {
            context_1.ContextLoader.loadContext(props.contextFile, this.node);
        }
    }
}
exports.ContextLoadingStage = ContextLoadingStage;
_a = JSII_RTTI_SYMBOL_1;
ContextLoadingStage[_a] = { fqn: "shady-island.ContextLoadingStage", version: "0.1.60" };
/**
 * A Stage whose stacks are part of a single deployment tier.
 */
class DeploymentTierStage extends ContextLoadingStage {
    /**
     * Creates a new DeploymentTierStage.
     *
     * @param scope - The scope in which to define this construct.
     * @param id - The scoped construct ID.
     * @param props - Initialization properties for this construct.
     */
    constructor(scope, id, props) {
        super(scope, id, {
            ...props,
            stageName: props.stageName || props.tier.label,
        });
        const { tier, addTag = true } = props;
        this.tier = tier;
        tier.assignTo(this);
        if (addTag) {
            aws_cdk_lib_1.Aspects.of(this).add(new tier_1.TierTagger(tier));
        }
    }
    /**
     * Whether this stage is considered a production deployment.
     */
    get inProduction() {
        return tier_1.Tier.PRODUCTION.matches(this.tier);
    }
}
exports.DeploymentTierStage = DeploymentTierStage;
_b = JSII_RTTI_SYMBOL_1;
DeploymentTierStage[_b] = { fqn: "shady-island.DeploymentTierStage", version: "0.1.60" };
//# sourceMappingURL=data:application/json;base64,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