"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.assertType = assertType;
exports.findInstanceOf = findInstanceOf;
/**
 * Asserts that a value is an instance of a given type.
 *
 * @param value The value to test.
 * @param type The type of which value must be an instance.
 */
function assertType(value, type) {
    if (value instanceof type) {
        return value;
    }
    throw new TypeError(`Expected value of type: ${type} but got ${typeof value}`);
}
/**
 * Locates an instance of a given type within an array.
 *
 * @param container The array to search.
 * @param type The type of which value must be an instance.
 * @return The located value
 * @throws {TypeError} if the value was not found or not of
 */
function findInstanceOf(container, type) {
    const value = container.find((v) => v instanceof type);
    if (value !== undefined) {
        return value;
    }
    throw new TypeError(`Array does not contain a value of type: ${type}`);
}
//# sourceMappingURL=data:application/json;base64,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