(function (root, factory) {
    if (typeof define === 'function' && define.amd) {
        // AMD. Register as an anonymous module.
        define(['exports', 'echarts'], factory);
    } else if (typeof exports === 'object' && typeof exports.nodeName !== 'string') {
        // CommonJS
        factory(exports, require('echarts'));
    } else {
        // Browser globals
        factory({}, root.echarts);
    }
}(this, function (exports, echarts) {
    var log = function (msg) {
        if (typeof console !== 'undefined') {
            console && console.error && console.error(msg);
        }
    }
    if (!echarts) {
        log('ECharts is not Loaded');
        return;
    }
    if (!echarts.registerMap) {
        log('ECharts Map is not loaded')
        return;
    }
    echarts.registerMap('广西', {"type":"FeatureCollection","features":[{"id":"450100","geometry":{"type":"Polygon","coordinates":["@@IFCAQNEAGEBAMGMUEBIKBC@EFGHBAEBIGI@EKGEGAKKA@EDIP@XFBCVIKK@KE@CEj@VGEIGBE@GCCABEFECK@AKAACFI@CIEBGAAG@EENOF@@GKIMB@CKEOAWOEMPEFKOQDEJ@LBABBH@DFFH@FCFGIKEM@CDCD@LDLABCGIJ@FB@LFBLEFCAE@CFBDBDGGAAMJ@@C@CLCFEHDBSCC@CDC@CCEOBGAAGBCFE@OD@FBJICCDGDAJBJAAIDEHA@MCIGC@ICCBOL@DECQACNABDFHDAHEB@DDAFJHH@@H@HDDLBHFB@BDGHBDD@BDAHFBJNJGH@JDHDELFL@HBDJBADTLAFHBBEJ@LD@FEHDDHEH@EDF@DDEB@BF@DCD@DDCBBDRBDAFHJBBDBBBFCDCBDBLDRCDBHAF@FFFDJCDB@BLD@BA@DDBDCBDLPHHBFAACBCDCPDH@HAJBBCDBBFFBBBBFHBLLBAD@@CFCJ@HFBKDA@EACDGF@BC@@BCTAVDVS@KFCCEEA@GBABACIDEH@BCECEGICAIFCNBD@BEDCJEFDFID@@CEE@CCCA@CAEMEOGCOD@EKEHICI@CDAAEBCLEDAEIC@BQ@IDEFADA@CJABEHA@ECABEMCACBAGCBEGA@ALKACDCFABEHAJ@CCEACBCCHKJABCACCBACDEFBDKAMJADGBIAEDUAGAEBGBCH@DGBOLGAEBABEACEECGBCAIBELGBDDAACD@HEAGCCBCH@HCAEBADBD@ACXIFDD@DDBC@EHCGCFGD@ECACDADQJBDC@CRBJADE@INAFCBBHBDCHEFMFABAEEAEDCFAACEA@AHEKCFEECABECFEAABABBBDJEF@@GFK@IFA@GDEPON@B@@EDCBBDDAJL@JEHKB@@DENBDF@DB@BCFBBNCJ@BEDCDGFEAABMtDHDFNBADBBAFAAAFADEDDT@DAF@FFDA@ACC@IHC@KGEFC@IFOT@BDD@FFBCBED@DH@DJHHD@FABCAANBFD@@CJ@RAHBCEGACACABMACCCADECCB@C@AD@@EAECCDE@CHCJMHCBEBBHMBBD@FIF@J@DBH@BCBCLABRBDNDDFFKAAABA@@ABAACDCBBFCJFDEFBNADCCGJKB@F@BEFCFAFBDC@DB@@CDAB@BBNIRJBDIDCDOJ@DBBLBBPF@@DD@DJB@FCH@JEBIDCLAD@TE@AICCCBAHAECKAHAACKCKBED@@@AC@@BABCC\\QJ@@IBGFCBGJ@GM@EIDAGJAFCHAJEJAB_D@HE@EICA@@CDBBAACCB@ADABA@ECA@EMGBCAAA@ACBCACDCCGA@AGACGk@EBABDHBDQJOBGEGCAAC@AFABEDEFAAEEEC@FGBILFNAHFTEBBD@FD@DXE@CVIF@D@J@FHH@DQD@HE@ID@BELILCDEAEGGAIGFCG@KH@FMKBECI@DID@D@OE@CACCAC@@ADABB@BBCBB@CBADE@CCDCCBFA@AA@BBBDACFEEDFAAAB@BEBAE@DDBCBMQA@CC@ECADCDGDAFBJEPABEBAD@BCNGHQPEDCCMFOHILEDGRM@EEE@ABEJKJCRAHCV@BABECOPIXFJ@DEAATGRCZI\\IDC@CBCDQIEEAIBEAGIQCGC@EBCLE@AGM@AZKHBFOJKCCDABGLBdCVHHDD@LIHEBGFCKIE@ADCDIBECAIFEKKBE@AAGC@CC@CHG@CAGEACIDAL@B@BFFAF@F@BEFBFDHADDFBN@DCPBHC@IDGLEFBBBHCBAAGBCFCDEAAECAC@KDEJEJOCIICJIDEDDDDDBFAJGLKCE@EJ@@APS@IFA@CAEGCKCEB@BG@EFIDEAUFACECCA@ABA@CIEGG@KAEGACDKDCMEACCI@OAKGQGADCAAG@ECDEBGFcVCAEGSIEECKOGODKAIIDEAGDGAEEAKF@PDRAFECO@AFQCCCIHCBCACGECCAGDUTGBQGEKEE]BC@@EACEDA@GIIEAEKIMCAMCGWSEAEQACSIEQ@IDC@MFCEE@CFCFBJEDGDCNCFGJEGQAEMEKACDEBGCUSMEIKOICAADBREDMXEDQ@IAIKEF@B@HAFFF@DABOKA@ILCEA@G@GBGIEAAHC@KCBFGBGABHHBBBDDBB@BLJ@NKLGDC@MGGHGBBEIACDCPABIGIK@GBGFAFDF@DABKDELC@KkGMIGBCDEACFGBG@GEC@EDIEaEOFGFGLA@EGQFUAC@ABKECBCKDA@CECCAK@AAC@CBBDA@GAEDQ@KFABBTAHCDACG@GHALABGBG@EBCDEBCA@GEKIBEGBGEACMK@C@IHEFCBMECFA@IAIMKCCGKHE@IGCAW@cBCDABDB@DCBKDMFCDBF@DGBMPE@ADIECGIBEKIBCFKG@CEGM@EDI@K@GAEDC@EGDABAAEECECBGC@GFAAEIMEG@AFQ@@CFAESA@CFCAACAIKEE@GD@CGDCCA@AFKAAACEDC@IFQBQFED@@MQBABG@@GCAC@GDAHDDCLGDKAAGGGCOGCCCBMEIYAAB@FEHIRIFKDEF@JABEBCAIOBCHG@AOMICEBACAOGECGKOC@G@GDAJSVSOO@OGCKFIWYLMDAL@FC@KJO@ECCE@GBCAKGIIFEGKAGI@B_LAHECIGECGBEDCAEACGACCCMEIAIIGACBC@EMEA@IFO@CUMIAKBCFA@EKSIAC@EHEAc@QHIHEACBEHC@ECE@GDAFGHCFAHADIDE@KEAKCCEDGBCA]OWSCACBKDEAIFMEK@KA[IKIMOGBE@CUEEWGMGDN@XK@MPGCGB@HGFCBGAGDCJARFDADCDQJEFBLFTGJULCACCCECAMNCC_aGHE@QFAHIDGFQ@CAC@M`C@E@CBAJAFBDADAD@FDD@FEB@D@B@JDDBFADOHE@A@EJMJMAGDEFBLAHCDC@@BH@@FFFJJDNF@BCBABB@NCFOJKLBBGBCAAEKCABBHABIB@@DD@F@JCJFFELDF@NF@DB@D@HIBDDBHABMDGAGEEAIDADGDABDJADWDIDIBA@PHABUEK@C@@DCBEAACGBAB@FGNABFD@JWEECMJAHEAC@@FBDJDHFBBBLDDLBBJPTBPJBAJGNG@ADDDEFG@CHAJKN@D@FDNFBAJFNDBDLHB@DHBHCDCHABC@BBBBHF@FDFBBDFADBNLL@JDBC@EBADFFAFHHDFCD@BGJFFAHNNNADFFBDD@BDAJBFDBAJIDBFABEBKJAJ@FB@D@DD@DGJ@F@FAFCB@FCFC@IIEAACAGBEBOAGGKCCSCAEI@CC@EA@KCE@EHEFQHAJELQJO@IJENBLFF@FADEB@LBDHFHDJABBADDHADJHB@ADBNFFJF@@EBCH@FEBFH@DEBAJDDLCNHBBAJEFAHA@GEEBI@KFKAIHMBWBIACBAHBBFBCHNb@HCFIFCDCL_T]FMAYBMAyDEDGNCDGBMREFGDS@OAS@OHE@KAEDEDMASFEFCHIFEFSZEBGPWN@RAHINCDC@WGIBSPG@GCKKICMBEDOFIEgHYAIFGK@KBATCDADMDCFALGP@BABGLWPA@EBAHAJIJWJ@@CAAQMAOGBGAKIICG@ADCPIBAB@LCLILKF@BDHBPIDGBKBIAcBAACEGCSAUME@OBECC@@ADC@IDEBCEG@CHC@C@CCA@ECAY@GCUDEAEGCAO@IIICECSAEBONDHAHCJMJAD@ZBXEVOT@F@LBBJADDLFDFF@FF@DKRAHHLDNADCB@DHLBHADEDADEBGHAFARCDAJEDC@ED@BFDCFBDFD@DED@D@JABE@GACBGLGB@FUHCHEAGCGDACCEG@SBKJEBQOEACBCBADCDEBEACEGA@CEAUSEAGD@HCBI@CFKBAFOF@DDN@FPBFFFFBF@N@HABJBP@JDL@JJNHDFAFO@IFQ@AFGCADBJADEDADIBCJABIDI@ABFFABIACBAB@HEBABBDHDDF@JBBF@HCD@JFLABDBDCFABEAKFLFDHCHALED@DDD@BAHEFAFDDHDDHNBDAHEB@DD@LEHADDDLFDDHlNF@DADDBH@DAFIDALB@BAJJJLHRBJJD@NGBADIBALBHCHABD@DFDBAHKDABBJHD@HCDG@CICCIC@CIIABCFCJEJDJ@DDDFFEFAHHFBBABKRAXGV_LGDBFFHAZBJDBFDJBDGHABBDFBFCTLJBBB@BCJHN@HADQVADLJ@NCNFJ@FBFBDJALFLCVBnKXAFCBC@GAEB@N@JDFFNFRADCN@DBLAF@DADNFADHFB@EFC@DFBBFKBB@ABDDC@@JHA@FB@@CB@BBBABBFDFA@DDA@BDADB@AB@DBABD@AFD@DC@BHDDFDDBA@CBBBB@D@@AJC^FFRFFHDDJAHHLBFBBITDDEB@D@HABEHB@DDBH@HCFACIBEDAFAPFNLADEBUAABAD@DDBNBFFAFABEX@DDFFDJBPFLFFFJVRP@DGH@H@DLRFBFBDBDHB@BCDABB@HCDBJGHKFE@EC@CCCUMIBEBGBAAGKECIJGBGEC@IHKAGDE@IGK@EHEDUFIPCDEAMGSCIBONDNFH@DEJBBAJKHBHFH@HEFGHADBJFLHPDPCJCH[TEPCFFAFBTRJHB@JGDBDDHBFHHDV@VKLATBBDCH@PLRFDJBFDBH@JJDDDHAFKD@NNNFD@HEBEAMBCD@FBFDJHRAFAB@DBBHDBL@HFHHAJBDDBH@JBJHBFCN@FJD\\ABD@HFDDBJADBBBCHBHDBFANIPIFEFMDEBGBELCL@JBXNDJEVBDFJ@ZHLFCN@JDHFADAFD@BRB@F@CFPFAHRNCHFDAFHD@DADC@AA@FEB@FBDC@AGEHCCABBDADGBBHAJAHAJIPBFBDDDBTBFJJLBLFDFTNNFD@RGPANCL@HBFDDFLVPHJdDFRTAFFHFDH@LCHINGJMFMDEFCLCL@JFDJADGHEJ@HHRNPHHLHLFDG@IJOFA@CF@BAFB@FD@H[CSDABCEEDCJABBDABGCGC@BIDED@DDJGD@DRN@ACDCCAC@@IH@FEBFFDCDCA@DPRHC@C@EDAHDBAGGFEACFABELB@TDDCFFJJ@DFADXLLTMDE@CDECCDCHBFJF@BEDABHFCDFDAJDBFEPLRRAFC@ABHJAFG@@JF@HFDFL@FDCFBFHDNAHHDAFIVNLAFF@BCFBF@DCH@DDDBLAFCBDFBLED@JCBCLA@AEECCD@LDJDDAFBBDDNCDDF^CDCBGAAB@BPRLF`NZRNDbBF@RCPIHGAMBCHED@DBXPLBDAFKHILKHIACFIUAEGIECI"],"encodeOffsets":[[111081,24554]]},"properties":{"cp":[108.320004,22.82402],"name":"南宁市","childNum":1}},{"id":"450200","geometry":{"type":"Polygon","coordinates":["@@KECGOKUKGCGEKaIq@KHMHElURELAHEJIDG@IDSDKHGTIVEDE@IasAIIK@SDIJEJCHBDKNCFGHEDGACCCIAECAGCCOGEKI[GICAW@ICAGIGIQYWCWBEDEHEHIDSDEJGPIHGDIDI@IN]BQ@IEAKIEIGcEQAOBEFEDACG@E@EK@GACA@ENEHEBG@CGEAMIKEIDGJCDCBCAIAAEAELCBKC@A@UAGFMDM@UECMOUMKMOAIDSAMOWAI@KCKIO[_IKWYMGeMEGEIBQESGUGOAEFGRMZUHQAQIKEEKI@IDQDMCMM[AGFgEG@IDCJABCEEGBQJC@AC@GAAE@ICG@AMCEBUFM@KBAHADCDCBEEAG@C@GAAC@GAEDKDCNI@E@cDKCCI@@EBAJ@BABEMKCCBEJ@BA@CEIEAAE@EEK@UBCF@DAJAXDLFTNLHVBZGfUHAL@LBVEVMJAb@JALEd@HCHGHAFAHHFRD@DAFBFDJCHHHFDOAGDCJELMDCD@NDFADBNDBHBBD@DCTGBCD[FGACKGBQACBELGHABA@GFCBAF@HF@BDDXCLBBFCFBFRPD@AIBIPQBWAAGABMEGGgB@F@HDD@JACIBAJCBA@SBAFAVBDBDDBFCFBBPDHK@IEEBSFSLEHAJ@LDF@HCHGBMDCBAH@HBDBBDDBN@DBFNPABBFTFDFBFKB@HBBCCEJCBABMFAB@DCAGDCJCAIDCHABBJHJBHFLAHEH@JMDBFLJA@ADGBAFDD@LILBNJDBFADIJK@MCCOGODIACG@E@EHEDC@GCMDAJO@IDCECAEFSAGLI@KDK@EAAGCIKEACGGGOBC@ACBCGBCCGBACDAAEF@DGGSBEDCBC@EKICEBEHG@AIQSOIGMBIDI@CAGIA@C@GJEFKDKCCGAGHKAK@MCEMIAMIEACAEGOCKAC@GEMDEBE@MBMAGIKEGCOGIQGIAGEBIFIRKBCAWBMFMDABCKGEI@CLMAACAKBQIcWGAIDIFEDK@MAKEKIOOEGCCOEIAMBOFSNAFDFAH@FE\\FBN@VGPFBDAFMZBF@BEDGAEBAFEFGAGEEA@JA@CCCGGACEIEEM@M@AIFGAGBG@CAO@QA@CFKAMGCMCE@MDUKGAEDELCBCAEEAMCEKIAG@GAAUKIKKKGCIAIAWFAcCIGASFO@KCOKMCI@GDMBGDM@KGSCGCCACIIiMiGWIGWQOEKCOEUB[OKCQ@UAMECEEQIGACBUEMCAAC@AFIACGEBCLFLE@CAGLEBCCCAICBCA@CAACADGAGIB@EAGBCCACBECEDIHKBCEEBA@BADA@CJA@ECABA@@DBEIG@EECB@GICIGEIK]OQME]@MAmPIAICBGO@GCCBEJNLGHGAG\\BFE@EGIFJJENDHIBEJWF@FFDCBAFCXCLIBAFWD[TCHHZ@PKVGJMHSF[FK@WHKDKEEEICCIHQDKCGEGKIUBUEKAWXGBG@GCECCEQBAB@DBH@@GDABBNANKVMJCFA@A@BMIFMGE@OFOBMDAHLLTLDJ{`]BUJ]bIFKBSFWFKA_GI@GBCDMZARENEHaZKLAJFP@NCNGLCJBDDDLBHFDFCTCLOJOPQA@`HdBVAbBPJPDJ@HAHMdBHLLJHLDNBRFP@JEDADBFHFFDHB@NCBIHGF@BEFCDB@LLfATENAJFLLFdDRDNHHN@dGTGLKPcKNkUq@MNcbiFEJAJFFBD@BEBCBERGDI@ECQK@CFC@CICUXCJG@IFCJDJFDDJBZDJHH`ARBXHTNVHHL@FGLIBCDCL@HHLNLbVTHLARBHHFHHRNLBHCFSLGJCHALANENGFIBIHCHH^HHFEHAdDBFKFEFADPJRBPBLFJNNfHDPFJHDRVhLLJDXA^DTLHBRAHCHEBED]HEJCX@LELOD@fbPbMX[AAD@HFXNRCDIDADChDHBDDBXDHLBPGLGFGBGHC@@HCDGFKPKLGDMAWCAIDQ@EqU_C_A[C]FYBSJKVCR@PHRNNhX`\\p^NFHFFNJTRPDTCNDJFFHHLTHjFV@RETOlC\\GRKNUPMVENIHI@OMW[KI[QK@KBKHM@EECGCK@MCQGM_[OCIAODQNI@UCYBAHLXGJIFiUMCQBMRKJIBECEECOCGGEEGKIAKAMCGEB[BEH@LAHI@CDECG@G@QIGACBG@QNA@EACEBYKIIC@CIGAEA@MFABFD@BQBEEGFE@KCC@CBGHEDAFA@KKG@BHCBGLBBFD@BARTA@NABDDED@FHFLdLAL@BCAGFEF@DFD\\FJ@DQHONQDCDCFG@ERIAIFOCUXAF@`FHIJAFEL@FHR@FEB@REL@JCD@BBHAFEFQNIDC@@fHNBDGXDFADK@AFEFAFAJFDFDCB@DFFBDEPDJOD@BJHGBCF@NO@U@ADE@AJCFAHBBDBFDBJBBJBDJGJBPADBFHJDPHLDLBBTWFEJCF@BBCL@DELOACBDBEJIFEACL@@P@LBCLFHFBLJCD@HHJXNLCD@BJBBPGJLRMLGJCH@AVAHCDOFQPIFMB@DFLHHEH@DELHFD@FB@@ABGBEJJJF@HBFAFCLAB@DDAHBBADJB@DEFDD@BEBC@EBBD@HFHBBBHBFHAVFDCHADBF@RPBDABjDJDTAHBJEBCEA@ABADBXCHABCEA@AJEAC@CEAEDCCDGFB@IDCAAE@AGPERMACHGEGHKGCIBGCACE[EEBALADBHIBEBAFB@CBABC@GHEFABCJKDBHT@FHDBFBHDDHGF@FBJ@XDDABFC@@BE@@DLBFAFDHBBBFGJANDRBBCAKCG@AFCLAJBFDN@FBVLLLDCHALFJBHAJITGDEFC@EBOLDV@HFFCBGHGHALMNCHGFAFDBDHFDBTPDACAHCCABAPHXZVCDDBF@HDBF@FHYFEDINOHOBIJAFCjCF@HBDAF@DHBDFCLBBGAE@ADDFIFGBCD@FBDDDPFAD@J@DDFBLLHBF@FJJ@FDLJFFJVL@DCJCPBFNROLcLBBCBD@BBA@ADDBUBC@CQEGCCKAKF@JCA@CAAKHIDOHEACAFUCAYAECCQAGCCIIKIGCGACCAGCBCABAAABA@AECA@CE@CE@EBADEBAAEFI@ADEACAACGCGAQFMDEHDJCJCPBVDDJBHEFDFDANBBPJHDL@JFFHD@LCFCAEBCJ@TDBB@DIHFHDBHCJ@NFAJDDRVH@JED@AFB@ADEHMTHDHHHAFCDAFDFEBDBJFHJ@NDFBJEDALBJ@RKNCJEREBBANDHJLDBPAD@BB@DEJ@FDFD@HEH@HBNFVANEHKJG@EAKDKAGSSCIBEHKPQFEH@HFDLDD@NH@JFDBDEFAHBHFPX@BMBKF@DBFFF@BUHGDADJLHFD@`IJILGFE@ICI@IGIBGJCBAACFGACBMEMBATE`@^QNBDQBAbCHEF@TFDCHAHBNJH@FDEJ@JHBd@PABBAPBLERIFKF@D@FDDFDDDAHIH@FBDNJBDBNBHCRANBPFHAHJHJBJ@JCJBHFJRFNZ^HPAZBJJHTFNFXVLTFLBPCLGLEH]FIFAFFFVNlLJJLDJBRDLJHPELGJQPIDIAEFEVEJ@TFDDJ\\LJRD`AZ@TFLHRTNLNFRDJCLGDG@cBEFEZANDH@NKPA@AAQ@@JAHBFDDFAH@BJJD@D@FGDGDANCBE@EJI@CKO@CBCCEIGGOEC@ME@GBG@GHE@AIBKGG@E@GICEEAICI@CFCDIHEJCDEACAA@IAAIFC@GIAABAPKAAEA@KL@JDH@D@RJREFAtLbBFBBAAECS"],"encodeOffsets":[[112400,26498]]},"properties":{"cp":[109.411703,24.314617],"name":"柳州市","childNum":1}},{"id":"450300","geometry":{"type":"Polygon","coordinates":["@@KSAKBELETBPADAHGDARDBAAGCI@CB@HBLED@HHJDBA@GDCJBFGFDH@ZUPCHAF@FHNBJANBLCHALB\\@VFF@NEXAZDHAFEAK@OISACDCPOHCF@FHD@BCBIDEHBHHFBVGBBBHBBVDFD\\ADAFODCLQAOHG@ECO@K@CCA[GK@EE@GDO@CIG@GHKFADCACECAC@OACOQAGCGBKFSNM@ODCCI@I@EOIEGBCNFB@AACGKEMIMQBCJGDGLGPGBA@CAAC@MBG@GIYEEIAICISUICCCACDG@CIIDG@CKY@MGKIEACAUEGEE@ADAXFBCBEAIBGBA^G@AIKBEHGTKDIAAOACCBCHK`WDEDGBSDIDCRGhAPIFAB@FLDPBNFJJHZRPFB@DNZJF@D@R]HCD@DDDNFHPFD@BABCAOLM@CCE@AB@pHDANQD@PPHDFBRCN@HBFDD@FABCIKAC@IDCF@HDHDHBXGPCBAKSSEOBEAQOoCCCGQCQDILEFIFiF_@KCCMEI@GDOAKKUcQG]EGECAOBiKG@OHE@QEGMKEACBuDEFKAUE]@YDILQVQLGJKFIBE@CMMWAO@MHWBaKaAC@@BCCEBAAAC@AA@GCA@CCBQWGMAQDGAMACOYGGOCACAIAAA@IFE@E@CAAA@IIOAE@WKCSKISCAMCcWsHEAGKMMCE@IKGOcckGEWKEGKBUM@GPe@GAG@CPY@MIMBKAEGGKCUEKGQGOOCIA@W@GACECIEAIBI@iSWGGGFSACKGWgBKAEIK@EBCHCBC@AGKYYKKBCFAB@@CCEGIGKEKAKAKHSDMCI@EFOBKBC\\WBC@MCEGE@EDEDAZCLMEQCO@GDML@@CEKO@EGCI@AH@NJFHJHDAHIL@JDHNJBPBFAJCNAJ@XLTFL@RHV@BQH]HSJIFIPILEJ@LB\\TFBLAHEDGFSBUAUEWI[AOF]LYBK@_@GCEECOCM@GCQeK[GGGCKAGBEFGAGCCEAOLWCCOGM@UDGEEIGYGMKEKA]BGDIBMECGQgAUCIIES@ECEEBIDGFEHEHIAMMMUMCGAIDOHMHKTMLEJIJ]HQHGPINKHEDEBGEIaMHMRSDGACEEKKIIG]AOISGIUOKMEeOIEA[LGECC@ANKHEDAP@TKTALAJBJANK@EAC@CDC@KWACCAOMWEAO@GCQMGKA@GDIAMFEVDLAHO^IFE@@EQQEK@GFE@CIAU@EABCPE@C@AEASCEGACDC@EAACAAGGEEISUCCEAGXBRATIP@RBJCFIJQHKLDSjEHWD_EKEMOMQK[AIDKLQ@KCKEECCK@]HQPGBWB]CI@SLGHMHOD_FYRMDMHQPO\\QRSFoDKCGGEGCSEGKKMGKBCDI@CDAH@JFPCT@RAD]GAKECKUWMCUME@IDOACCAWFUAGDKLEDC@CC@KLIFGPg@MCCuBSHADDDBFAHEB_BAPE@[YWGI@UDS@kSY[QEoCEFIDU@KDGDCHQIDJ@RBFEBM@ADBJGHDLAFBBFADBFNAHBJEFG@KACCKEQ@GEA@A@AFBDDD@DABG@ECEEAMCEA@C@KJC@CCGAEACBABAJ@FHLBF@FADGFKAAHCJBBLDb`@FEDI@UEED@DHFRLAHIPAHDTNH@HADA@GCMCID]QMCCDEJCBICCCEGCA@FCDI@ILIDWB@HEH@DBD\\VJR@BGHAFDFLJ@FADCDAFHTCHE@BFCBBDHADDHAADBDD@PAHHDHFBJLHDBB@FCL@LKJBHETBFFDCD@JIPCBDN@HCDGF@F@FDHJBPCPHDD@NILCJEBCAMIKAKJC@ECABCH@BIBEKCAING@GFKBGEIAIGAAGBCDBJIDCDBHCDA@EBANABIDDFADGAA@ELEAECESAAOBEMCAM@CAACCAGAG@ABCDANGHGDE@KCI@GBKFADBDELATFF@JGLOCAADEAECCCAUAEBAB@TABIDABDJIBC@GCE@A@HhFHANHBBBAXORAJBJC@QOAEDEAEKAWDIIAAE@GF@HABGBEBEFAFBDARLHBDEHC`GDMDCDC@AAAGMCCAEBMCC@CDKNIFCDBHCPGEGGIDECEACBC@EQGGIBKJGDc@KFIBa@IBUNUFKAK@GBeVYHUAKGSMKEWCIBCBE@AD@VFL@FBFFBFJ@DABI@AFDDNLAFABI@AB@FJ@DDCL@d@FMJCDCLBF@HBDHBD@H@FBAFCDCDGBAB@LENAVDFBNH@JDF@BB@HBDD@RIHAFFADIBCD@JFHEhBHN\\DNCNCR@JLJFFJLBRGRYVQNEHBFHPHVFTARFJFHfNNHXZJL\\`JPDL@LBJPXBNCTBJNPNLPVDNF@VCNENBH@V@BLDDAFKFBBBBJADCDIDCHFJJLBNHF@DAHGFMF@FDBHBL@@F@FDHCBEFAFBPFRHdFJLJFB@JARM^@JCJCJGHOJIHCFCTGJGFCFAFDXZXJRJHBHJDX@DBHJJ\\FLPHDDBHFDJBDDBDCHGFEHMDCLGAIDIFCJ@TJLBJbt@JCFUFSJGHCLCT@JCHIJGFKBQFkVGFEHAF@LPFPHFHDVLPLDHDBHDBAHAJGJIRDVHXLDDFXTjBJCNENEJGHINAJCHAPBPAFIHUHKJCF@F@LLTFTVdHFRFJALG^M`EPDJFDFHPFRFNDR@TFPFJNJD@DDBFAVJlF^PTbNPLXVTZLJHANSPIXBRJRAHEX_TGD@LJHDN@VAVBDDD@XAHAIW@UL[DA@CAEEDCC@CEG@EIO@CEGIK@CDAEC@CIQAYCMIMCMFMJEVCJEHKFOFEFBHHPVF@HATILIJGPCLBDATLFJJbR^HHJHL@HCHGDGBKDKFElUNGJMHUDO@MEKAOCO@MFEJEPAvLJCH@DB@F@BFCDJDCAC@AHADFF@ZLHJLXJ`HJJZFJDLFFBF@HEFCJFJNJV^@VHJnn^RRPHJV`fVLHLNFFFDH@HGDKFEHCHBLFbdFJHHN\\XXHZBLAdFN@JFTBJDF^FLHRHFRHJHPVTNJJ@FADEF[TKRCNDRFPJ\\EbKJIDIFIHEF@NFXdHBJBHGHQBOEG_a@GJG`YFCLANBPFNHLBv@RCZ@JBJFTPjDpJ^BD@BIDELKACCEACLAFBAHBJRjBJGJBLAJGFENGH@B^HFBBDFZ@\\FF@DAPGLBFFHTHTBLDD@HIHC@MJIFEJC"],"encodeOffsets":[[113673,26992]]},"properties":{"cp":[110.299121,25.274215],"name":"桂林市","childNum":1}},{"id":"450400","geometry":{"type":"Polygon","coordinates":["@@DCNSBECMIQDKRIJATDLDdKAEQAEI@GH@DCBKIKCSEMDYXQLeFIJENEFEXIXARGBIHIHMNOVINCL@HCDEBEBKCGEIKMOGEEYq@KDKDSAMG[EKIMAGBEP_JIVCRGhGVGLEFEDIACOAIEKKDIAOAMOgEICAACHABMBCFALHBDD@DADDBCBANBHKBB@F\\BDCBCD@BDPDZOTWRYNOLIZIXARGVUJS@QAEIOSKYKGIDMPKDQLORHLHPHTEA[FMFEBOIOMM@OZUBOKy@YFGDGFC@IBCNGJDD@BCHOFE@E@KHEHAJLLDDDF@LCBA@OAGBCBAJ@FDNRBJAHGLAJKLAHFHBFEJ@FEBDN@JBDFABBABBFHBDCLBD@BCHAD@BB@FIJCBAFBFFF@DCB@BDBAJBBBFC@DHCBBDBDJF@DHBBA@ADCB@RGAEJAJDDFDEDF@DDJJHFJAJMFCLAL@NALABBFHBNCDEPGFADFPFNJDFDPDDFBPAV@FBHJJDHNHVB\\FVLDZFTJLRFXFVNfHJLBpCTCZDNK\\aJcBM@MJGPAtHVAHCd]PGXB`LT@NIFEPBBNEL@HFFJVJbBXAXIhAHQRINCL@JHNJJFLDNANCNGPALDFJFJADCRALEDBTPFBN@BLTGNCH@LHLLNDAJITAJHL@LHJDCLALBBHAHQ@CDBPBHLLDLNHL@DCDGBAP@@GBEFEP@FALMFCFAJ@`JFC@CBM@IGMJIBGIK@CBGLEJIAKm_aSKKGM@MFaReFEJCFAPBRFL@FGTIAGFMLOBCHGdALGRMPSFMF_@WC]FQJQBU@CGSC@ACFOBQCmGAGKFGCI@GGECCCKBIA@OFEADMEAAEB@DQAKDKACCEFGACAADI@GA@O@ECACHC@IHCB@LCJ@HDBABGCAACDCHPD@DGBHHCL@LABAEECQFMUECBE@GEEBOWDA@IIGMDAIOMBAAGCA@UDEAKOC[LAEICADE@ABBHMESME@ACGBEA@FHDIFIAICOMAGMFKEUCEDAECBAFEFC@BEICEDCAMA@SAKEE@CDEBE@GFGBK@OCGFEBGEMMCAC@GAE@ECGBKBICEGECI@COQ@KCCC@AGE@IDIOCCBEMOIAGIAQM@WDUBAKCAFKEACICE@AFM@CEKC@AMBGCC@MGGBCEG@ENKDECYACOGEECMCGAGIIGKE[BMFGXKBICIGESGGMCCG@@GD@DACGC@EMBOB@BHD@ACD@JHRKDAA[AECC@GC@ACBEJGRWCC@GHCLADC@CCCCIAO@uJAFFJGDKCCMIO@KIUEBCTABIAOB@BEFBBAAEADBBG@@EBDBABAEC@AEBFCBCAGEE@eBKDGd]LABAXDFAHDBGD@HDAFNFBAAGCAAIEABICCBCLIAMDC@CIGGBQOEMF@EEKBAGS@AGMGJK@CTKAGECEIMCCCE@EEIACICAIDI@AADC@EFE@MBABA@AGAACDGF@HIBEACDC@GAEECAOGCCEEABCEEBUCIOGBCEEBCAAECEBCE@ECCKAECIB@CDEACEEAEEEKBCEBCCCECABG@FICCACCACGGAKA@EH@CKGG@CFABECKAAGBUIA@AQAACAGHGDE@AAAGAE]I@EEEAEDGCA@CIC@A@GCESKACM@ADECGDAAAEAK@AME@DABEEKAEDA@ACC@C@CHCBEAKBMA@FEAA@@EA@AB@FCACGC@@@EAGDAB@DCDCE@CAAEBAFG@EBA@CDCBCADEMAAFCBCGCCGFEAAC@IIAACGAE@CBMBACA@CBSBCCAC@AF@BIFCJAHCFGFAJGAEBILI@A@KC@CCAGIIEMEGICCBI@CEBCAOIIIBUAAAACEAGDEJEAEAC@GEKAAG@AMEGEAGC@MJAHEBO@KEICM@AAFK@GEMIKGCEAKCS@GBEDIBG@CA_FC@ADABMDAFEBCJBFJLBLAFCFc[pIHKDYEMFMLsNKLJ\\IPOLKTBPRhJZRjNjETKJM@MIIKKGUBKJ[hIPCLGD@HBDBPIBADBDLDDHAPCDGD@HDHHDJNDHNPHBXBH@FFANSNE@EHDD@BELANHLFD@JIL@BLJBF@HAFEDEJE@EN@DFDDHEBAB@JADGBCD@CIE@ACAACIEAGA@KAIDE@@BBDAHBDCPWBKBEDIBMN@FDHHFBNEBOEC@IH@FBDABAHCBFJ@JCHKFJIDOCIIGYEGCAMAKRMDKAQ@IBGFCJKTBNALBLHVDNCPQjBRBFJL`\\FDHBJAHCLINCRAVJVNFHBNFJbTHJLlDbE\\KN[JQ@EFG@GDCHMAKGGAA@EBCAE@CJDJBB@FCAEHEDAF@@JDDHAFEFBDEDCFCBMAEEC@AFA@CJBBBBRBBBBFFADBCFCHEBAAE@AB@BDBL@@BCFCD@@PrLZEXBHHLJHXBPHF@LFRRDJERKNIV@^EhCD@H@JFNGLKDKBABBFCFJH@JILENCB_CCDDFFFDFDBDFAHFFEFBDAFBFEDAHOF@JABKDKJKCMLE@AHEB@FCD@DBD@FBHHDNAH@FDBDDBDBDCDH@FEBCDABDFDDBFADBDDFANBFEBG@CEGEEDGCAPBDCJCB@HDF@TFHDBBBARLBPV\\p@FSRAVCHWbIBECMYGIKIUEW@ODGF[hAHDHLJ@HINWLaKEDY\\GFKAOCQCKBEHCJONuJOFOJGNA^DRLVFDdLPNLRFT@JARIVCPDLN\\BHAXKP@DNHDFBH@BIHM@GCG@CEBICIECEBEDCJOFAFDN@DC@MEG@IACB@DZ\\FFFB\\BBBBHCFIHKBAB@HDLJNHHLFJLFDDAFAFGDK@KP@BEIIBEDAHFJP@HAJ@DRAT@LAJBNAH@HFFJAJCHAJCHGBKEIAOD@JGBC@AIA@IDC@GGCBCFBBNLDHBDD@LAFBBFEDHLD@LGF@D@BHAJBBLFFFFJCDIDGHEDC@EFSBGDIBCBANCJSNIBMAEEIEC@IBAB@NUJGEEKC@ADDF@HDFBFFNB^@N@BDBJADBCJEFIFYHQCKAIIGCCECBEFDLAHEDAJCT\\BRFZ\\lTT@VCJ@XH\\ZF@BO`AFABGAECCBCTGvADD@NOhEHKJ@LDDD@FCLKHCVBXEDBBDCP@JNFDVXNLVFDBLZHF@@C@QDOAICM@EBGDCJ@DC"],"encodeOffsets":[[113222,24948]]},"properties":{"cp":[111.297604,23.474803],"name":"梧州市","childNum":1}},{"id":"450500","geometry":{"type":"MultiPolygon","coordinates":[["@@BRDDHDBGEMAEEAAD","@@@`EZ@HHHFLvZTDVILQBSCMM[EQGECCEBEDIBKNGBKECGDGHG@GCCG@IF","@@DGLCHMFBFABFAFDDHDTDXGPMFCHB@BHBD@BEL@\\NFBDMFBFEBCCC@QAEFCACBCECBCCCBCMGNKCABCB@JK@IAADCAAGMWODSVGHQGOAQMiCW@G@CCABCCCBIEI@CLA@C@IDKCMBKMOAI@GLQ@IDIFELCBEBDAFDADDFADDBFLDDA@EH@@CBCF@FEACBCHHH@BABEBGF@HHBHHHBFDCF@FBACDAAE@EGOIIBC@CGMCABKEEGCAKC@@CBEFC@EA@EKHEBAC@DACIDCD@HMACCCBADADEEE@A@GDGAKfqC_FQJKJGJM@I@SES@SSB_ES@{HaHmTeXQTYQ^SRUPUDUCQGCIEAoSasU³YUGčGOKAMBiCIMSQcOwUoI]@QFlYRYJSDOBWGMBEFELCV@PHZJLVVbR¦XdVJLFLDbCTEPGLGFMF]LcHHFoDsAyDmN[PadwGTAPERBbBVFTJZNLLDN@PGJANFRRDBRAHBRLJBFHFCHA@DAHBABBBNBBHD@DCD@BLDABEBBBADFDABFBCDDBB@@EB@DF@FL@@FC@@@CFJH@BCBBFCBC@GEEB@LAJBDJ@FFJDFA@BCB@DDBFABECCGCECDEFKFBAHFB@HFF@DAB@BJABB@FDBBEB@HDDFDCB@BHT@DABBDA@AB@DALB\\PTARINANDbZJXJPTFTETST[PETBFJVBxATBVBPCXBp\\LPBFGD@@DLCF@HD@FEHC@HBBHAL@@BCFAFCFDJEDA@@GE@AHADBDBBBAH@DALHBKLED@ADGDBD@FDAFE@JDDBAAEDEACD@BDDACIFIDAHBCDEFB@DDLABA@CFAAMACCACE@ADED@B@DFHB@HH@@IFDDJAJNJBHNBFEH@BGLEDEH@BEBAD@@DHFLBZEBA@AEEBAJBB@AFDTAJBBBBJ@RCNABCD@DBBJHBFNFBLAPG@GAGFUHADEFALGDCNBFDDH@RDBFBFAFABADWFINGH@JB@CDABCFBBCJ@DEDFFABFJN@FCFD@FABBDFABD@ADBDD@ADFFBEHABAF@ACB@FFFAHELFDETFBFDBBDD@@DFDADG@@FNANFBCH@@EP@","@@ALBHDBDBNGFEDEBIIIE@ID"]],"encodeOffsets":[[[112202,21970],[111707,21520],[112239,22435],[111828,21409]]]},"properties":{"cp":[109.119254,21.473343],"name":"北海市","childNum":4}},{"id":"450600","geometry":{"type":"Polygon","coordinates":["@@EHEAKGWIEE@CMBGCG@QICCCKGBWICC@CBAD@BEQIQ@CCG[G@AEBKHED@DEACBCH@FMCQTGH@JAAOGKCCCAE@@BGB@FEDA@ACAGH@AEDICEDAFE@AAEGCCEBEJABG@EBAbMF@@AEIIAIKEA@CIEAA@ECCDOFCBEAECAAIAAIWT]LKHChAHEJKBMAONIPBHGGWJKxWR@hLfPXAVIH@\\LJFPBRMLILCJA^HLA^KNGHGHIHU@ECGBGGICI@KDIFGdeZUTKJIDG@WFaHGNGBC@CE@IDAGYK@ACIDUBOCI@EBCTSDALAFDJRHFHBH@RMLEHCF@FCNCLEHEFGNIDE@GISAIUSYYYiccCICWCCOKCMCCmWCCBQAEEEKGOG[IWE±MuDNQAOE]OGIKmMAI@I@EFCH@JDH\\^\\dFNTbBTBNCPGPKNIFMBI@eKMIGIKWCCOGYESGKKBEHGrQTKJGDI@IEEOIoM{E_@SF\\[HGHMVEDIDMBO@WCKDMCM@ICMBCAAGEAGBEGIBKACBCBQlCLBFADWNEFCDANE@KEEDE@GFC@A@@E@AGBABBF@DEDGBCD@BFDAHMBEFBDLBBFAFGB@DDDBDIHIBADBH@HMD@HADGDCAIB@B@DEDA@EGOCAMCACBEDAAEBELEFCBI@GFYDAEGCE@IBEAEDC@ECAIOAAABCYEMBSEOOICOACECAAAGEMEECIAEBICEEKAI@SJGB]O[EcAOIS@edK@GAEGQ@QSAECA@CCGGGEDCFIA@CC@MAIFYHC@EAE@G@KFK@VLBFADFFBHILKLALANCXILVDRFJH@B@FGHGDAD@@FDL@RNJRFHPPRLDD@LDB\\HDHCNIRBD@DCBDD@RDLJVJFFJSbANBRJ\\JLHN@HGLAFDPADKJINEFKFG@CH@DP\\NHDDBFKLJPAPF@LEJNR@DB@BCDAPJbHNPJJNDPJJVNVjRH@PTBNAAT@PTLJNRPCNKNKBBRMD@H@HHTBHCHEHSJEHCJ]HNVCRIPCP@RFlPPBbIL@NRJHND~LR@`D\\PL@bIZ@PCJAXDNLDDD@VG@SBAB@NFNFBB@XCH@BPHARHD@NHBHHDBNGLINBBBK^AFDHDDNHDFDB@FDFVJHDDDF@LH@DEDBFID@FHPVTNLJDPAPGRFJLNXHHRAVERHP\\PHPAFKAKJGHAFDDANIFIB@F@PGBCAECC@I@A@CFA@ECC@EBCBCACBEBIDAF@D@N_D@DBR@HEJCBGREF@HG`bDDNMDBDFDDDBVKHIESAKFERIDCBCECBQDIHCHBDAHE@GHAHDNOL@@W"],"encodeOffsets":[[110879,22740]]},"properties":{"cp":[108.345478,21.614631],"name":"防城港市","childNum":1}},{"id":"450700","geometry":{"type":"MultiPolygon","coordinates":[["@@DL@CCG","@@@@BBAA","@@@BFD@CEA","@@AB@@DAA@","@@BD@AAA","@@@EXEPADA@AD@BE@GDABALABEHCCA@CAE@A@ACAFECEBCDA@CBA@CJG@CAABCEABEB@@CDAFADBBACGAIECCDGACAACBKGKCAC@CIACCC@EAACAABG@CEEBBCD@BAAAHAYYMIKMCKFQ^OPKLOJ[FINMFOAKIKGEEKCS@mIOSI_ESHebQJYBCDELGHGDI@GHCFFLHDADCDKBIVCBGCCG@IDCCKBE@CGCI@KFEBMIACBG@AE@IGADC@IBCAAADECKDCCCCBMHCHMAFGEKEGCOLGLKLOMEGHEDMNWPK@KCECMKKBCCUGQMKMIUMcEWCSDORWFSAMQSUSKOKUImEk@mDSHOPQJCPIFMGUHSLMJOHYHuHaCGMA@CYRK@CA@EFMXQTEFC@IAGGE@C@MAKBANL@FBFBBD@BE@GDEAIBCCIBACAKBAFG@ADMEMB@EH@BCEC@CC@ACCAAESECFKEGFEBEEA@BDE@ABGBAFEEBCC@ACBCC@BACEAAEBC@DE@EIMAEEBCECFI@ADEAADCB@DIAG@MHEJCXABEBEBEACA@QCGECMACDKHEBCFGBEVBH@HOHKBEAEMGAAICAC@ADMBQDI@AAAABICSBEA@IAABFF@BABYFKAGE@CC@ABAFG@CFKFAHG@EFMAAGMIBICIEC@JG@@GGACEA@C@CF@BDFDBBDBNEB@DABKBCCA@FEDCGACBEJDJCBACC@BDCFBFABCC@IEFCB@EACHCBCC@KFALKGCBG@ABAAACBCBGF@@HB@FCCIDEBEFGA@G@KBAA@GGDEFC@@GDECK@@FA@GKOo[WAODUASAwBUAEISAOFS\\STSFSEIOIWaYMCMBQJSB[OKACBA@@BCBAACBS@AGA@CDCEGCA@AFCA@EAAIB@ABA@CEE@GEABGEAELCFFDHDDD@DABG@ACDA@AEBA@MII@AABK@KFAHFD@DAAEDA@AIGDE@@D@@EK@@ECEA@@FA@CADCEABAECBCAAFABAKC@ADC@CGCAAAMAAABBG@CGBEDEGIAQKGAQBCAQQMEIBOHM@KCMKIYESAUAaFQBOHSp[MWAIIO@OIg^[DMA_MKQcAGC@KECACA@EDBFCJQRALDBCFDD@DQTaNlSHSFNS@UAQEBJJT@HCFMJEHGFKFMDEDE@GDKFQNG@GAGEKSGAKDSTAD@FDJCjBHZLBHJCF@@DADMHGHEb@XCHIJSLYVcfEHCJ@LDJHJAHDH@FGVGJGHYNQFKB]GIBKDKJQNOAIE[KG@UJWBeOgKQ@wXILHXGHOAMJBPANILGFgBGDKLS^JXBBBJDBBFAFEDCPDD@FBBJF@DFBJLJBFJ@BE@aNCPIBAFDFHDBF@BEFCBDFCJBFG@BHBDB@FC@EHA@AF@DBDDFHBDBH@HIBG@SHDRENG@ADBDCFC@GFALBFH@H\\DDR@NHDBAFC@AB@DDDXJHADLDDRJH@HDNA@DFFXJLHFBFGACB@LHXHFFDVF@HANPLJ\\JLBL@NFJEFBLCDADBXT^PDBHAFCDDBLLFF@JCBCBGDEHGBEHCF@FDD@FGDAFBJGRGd@FBFGD@JBLT@FEBADBLNJDVP@JEB@NF@FADBDJHBJFJDNDDHBBDBFCDAFDHHFDJGFKBA`J@BHHLEFJJLHDBHAF@DD@FIP@LEDK@CBKNXZEJDLPHP@TPTUBIHCH@D@LPDHHFBPBDFAJDPN@BGHADJPDBFABA@IFELCJEJQFG@EBAZBFJANDDHDDPHHBHLBHCDKCCBGHCD@DB@HH@BARA@NC@EFARER@JCDDFBBLBBEB@DDHC@DHCF@LFBJBDDBDEB@FTEB@DR@BEH@NFFJBBHED@AHFDFDBFABCBFHD@FCHBL@J@FCN@FH@DLHDEJAFLJADHJFBCF@NOHA@CAEDCNELCDA@CCABADCdAX@DBJHF@LGDHLDJNJBB@DENFDAFEJGD@L@DNFBAHFHJAFL@HDBFADCFAH@HABABKHGH@BDDCBGASBALER@FCHBB@ACDAD@BBL@DBFD@DCBDLDALFBAD@VBREFHB@HKHEPEbFJFFCD@HFH@HADEFBDCHANJlH@LKDCFALCBE@ECEBAH@HJLJHBADODCJBAFHAHGNHD@HCLK@MKI@AAACCAAGAAGHBHAAELDD@BGFBHJHAH@B@DFJKB@PLBA@CEEBE@G@AFEJLJBR@FCNWFCAQBCDBPJJLNFVTHDFADCLBNFBFHRIFEHMDCDCHIFEAED@DFFED@NCD@JFRTJBDFRFBXTDHBNNDLJBFJFHJB@FCBD@FD@^AFFFLRHHAVSHCDBFDDHDBDAJGDDRDBEP@FDBECQ@OLEFBBFCHBHCFJJLBPCPHDLFFTJFHDBdUHEFADC@FBHDBBCRHLHPBJ@DDFBDNLCDCHBBF@LHHJF@DAB@BDBFDBDVEFBJCFEH@@ALCBACMLAHGDIBAHHFBFBL@FBF@BBBDCDDHD@XKEEDiB[HOJMLM\\ObMNKJQHSDKPKT@TBTNA^HPR@BFDD@ANCD@F@@GLFB@FCPAJCLBFA"]],"encodeOffsets":[[[111319,22159],[111307,22131],[111301,22127],[111354,22115],[111355,22107],[112457,23121]]]},"properties":{"cp":[108.624175,21.967127],"name":"钦州市","childNum":6}},{"id":"450800","geometry":{"type":"Polygon","coordinates":["@@@CLOBWAGM[CKDOJUBQ@IESKQOMcKECKUCQB]HMPIPEvIPMDIFGLARDPDLBHEZ[FCbLXKJM@GKICGBG\\gHEPCX@VFLJHJNZFDJAXaDGBUTQ@E[oOUKABQAACAEG@SCE@GDADIACBOHDFCHFDFH@FAAEBMCEACBCAECCCEBADCFA@ECGCDCACAACECG@MBGCAG@EAC@CDC@EFABGF@NKLDLILCBA@IPEBGFCAEBEACFEEEBGCECACEEECEDC`DDAFMJK@IIGDEAEBALALCHKEM@I@GDCFg@]JULMFQCIQQKEE@OGWAIGGKAGFWKYOq@@DCDE@AK@CA@ABAF@BBFADGDECAEBAEAAQAAAAADIB@BED@FFNBDADEFCACFEBECGIC@@BEFCFGDB@EAACIDIF@DBFAB@HBLHNBDGHCH@FER@\\ILMF[CaKkGIaSEIAMEGUMUIQBMDKJGDIBGAEC_[KQAQRiDOCMGUAKBKAMIEKCQIMICYSMOAEMBQAIKIKBQHW@SGc[UGO@SZODKEYWYMUCSHKHMPIFCO@_ESCKOMIFOPI@KOAIFYHQAY[cSOQIOOAM@KJSBOAMB]BMHM@EKEiDOCGBBTATEHYTKHDWCQCKGYWIAIPKfSVM`IRALEJMBGCWaK@IFCHEDIJOFI@EEGHKDABDPAJQHBLIDUR@DDBBFGBGEACGLA@CD@DG@@BABE@ABI@CBF@AFECABBDC@C@C@A@B@DFABACA@@DIHCGA@E@@FABE@EBAA@C@CA@ADBFA@ACBAAACB@FA@@AEEA@CBCAAA@ACAABBB@BI@ABGD@DGEBAC@@DCA@CA@@HCAE@@FSECBEIAABKCAAABC@AE@AD@DGBBEAED@FE@AAAGCACGBAFBDB@CBACKACCDAOGE@IKAEQOICI@MMGBIHEDG@DKAEBKTGHBAFDBDBAILQ@EJIBEDCDEBKB@D@DHD@@GAAEADC@KCEB@B@RKLAHIECGAGDEBGDG@ECGGAEFCD@DCDEHCAKBCHCH@@BIHBDHDB@BA@EHCDGDALBAECEI@CDCBWFEBADBDAHCBCBEEK@ADG@AAKC@C@ICEDG@CASEAMAEKHE@CGCE@SRADEBGCMCIDCFCBCA@ABIACCEMEAG@EDGBIFG@GJI@IAAACC@BKDCAEFK@CGOAIFALIVCDCDOJE@IGCEQCAmIAECCC@ABGJGDG@UIEECECQGG@KFGHABCAEMIMBYGI@GAEE[OOSKIBAWLC@CGDCACAAC@GAK@KCGGABAHIJKBDNGDLDJH@FEB@JABEHGLI@@FDFUTCBC@EECCCFIJJDDJIPIFCF@LBDFDBBCFEDADBHABGDAAEAKFCH@JGDOACDM@EACCGBECEAAFE@E@EBAEA@K@CBDJFBBH@DGH@DDDD@BH@BAFLLEFBJFDJADCBCF@LJEDAHGFKHCBGCUGcDKAAHCBDDILEPGAYL@BHN@BKFAD@FHDRDHJFBJAFBJFCRAD@DCD[JYJQDSHBBCFI@WEOJDPAFABU@GDQBIDILAF@BFF@FQNCHKFGJEPDNCDOFGRMHADC@ABAFOBIFEACBCHCDDB@FDDB@NRDACA@CBFFA@ABABBCEFFDECBAA@ABBB@AEDDDC@DCFAB@DAAAD@AAACB@BD@DBBD@DPFC@C@CJJ@FDLAENG@@LDHHEBJHHBFCFKDKJAFC@@JGFC@CRC@C@EGI@C@E@UJ@DWF@CECC@AASFGEMBKEAJEHD@FFBFEBCFAFEB@BBDDBFHAHIPCRGAACAB@FHlBDBHB@DHCDBDADBDB@BBADNH@FDB@FABCB@BDABDABCA@DB@JD@FGFC@A`IBIFGBEDIBBHJC@FHNI@AHEDAH@JI@[RDDBA@AD@@B@@FCLALDBDGBLBFDGBABDDJD@BSFC@KBCDAJEBFHCD@BCBCAGD@FC@ADB@DHHDBBJFAFI@ABFFAFGBADHFJ@FJHBJ@DHHBDCF@DJDAFBDFF@@CNCFBFCFFADDDDPDABAHB@JGBBPFBBDHHF@@AFBN@BD@NHLF@BADBH@DDFBHCCDE@C@CAA@DFLDBDAFFD@DD@BJBA@EDADHD@DAFB@CHEJCDD@BBDBDH@BBBED@HDBE@CHCFEBBDAACHECC@EGIBIFKDBDBFAACFC\\HNBFA@GDCHIDAHDHCBBFEAAFC@EHCJDHJDNJLFB^FLABDFAFGPJBMBABGCIDEF@@AC@DCAA@CHBFCBMPGEOBELCJADA@GAADEDB@ATMFGFCDEFADCBGBELH@DNF@DBDBFDBNDDPAFBDF@DDALJPBHDBEH@BVNJBDABGCEBAFBFHXR@HDFADZXJDBB@FHJBLHHFBDNHHPDFJHBTQJBFIFADA@EAELIHEDDDCHBBB@DABEJBBJADAB@@DNANPFJHZARCHAPDHLFN@NCbBPFHDHLFVDFFDRBvIV@TCRaDaJOFED@DFAJDB@FDABDB@AHD@DAFBADDBD@DHBDHDBDBDPLETFHCJDHFJD`CTEPAdFVLZRPNRJ^JvCdCXB\\BHFFFBR@PDHV@VD\\BFTLPJNVRlTPPDDAjF\\Lx^JN`jhbXVX\\TPPHPCRKPOLIT@TRHXFlHPRCLM`U^FF@FDD@FQDADKJQJIFEFOBGPDCF@FNLERCB@HBFDDBBHJLFDDHNBLCFCLCHK@KCDLAF@FF@BDBBCJCB@BDDEJ@FELHJBDABC@AGGAC@@DAB@DHHDJLHH@BDAF@RDHBBAVDN@HNPBBHADBHHZFHFD@DAD@HDD@NCNADBLND@JAH@"],"encodeOffsets":[[113042,24620]]},"properties":{"cp":[109.602146,23.0936],"name":"贵港市","childNum":1}},{"id":"450900","geometry":{"type":"Polygon","coordinates":["@@OBKBKDAHEBKAIDQBCDC@GEA@@HE@C@MD@BCCAEQ@GOB]SMSAS@OLCLGTIRMLaN[PKNINGPA\\CjFFABLJPT\\PFFHBJ@ZHNANJBFADGBEH@LHHDRDFNJVFHCHIBAD@DDBFnJDBFRHD@JIFCPCDUDKJEBBJHP@DELBFCDALD@BDBB@JIJ@HEHAJCH@FBHNFDFBDAJ@BDBDADEJCNDHDFABCTQF@HD@DGFFLNBFBBT@DCHDF@J@DLDBBH@BCL@FFDADABGACBCFAXEDADCJ@DFBFKACBCHGD@FABA@GCACJG@AG@GDADBLGDCFCDC@EDBFHHFDH@HCFAHCHBFDGJKBQLA@A@DF@LCDFBBB@HC@CGC@A@ALCFCDAFIJ@FKRBJCACABEGASHALBFCLH@FCJGHANNJ@JDRPBFJLF@PHCBDDLBBDDAA@ACBEHABDHDBB@BEFC@BFAFHA@CBCF@@BADBBDBALBBFJDATF@EF@DB@GB@@DDB@CD@ABHF@CHCBAJ@@AAABADB@BBBDBDAB@FF@BB@@EDABBABBDB@AEBCB@@D@DBBFAF@BA@EF@B@DHJG@CB@BDBACEA@B@D@D@D@ACBAFDBEE@DAJ@BAF@BA@AH@@CDCB@HKBDHFHAAECA@CVQJCAKRGBICOBALCHGFFJ@PEJIFCDGJEL@XbHDNAFIBKJQN_TULeJOJBZXLHRDXDCLGZSFGBSASHAPDjCLF@FGNANA^BNAPIT@LBNPPRJTP\\dBZGREZBJLPJ@POJEPNDLFT@`DPJENOLGTGVDZNZXLFPCTYP@VHd\\THX@RGLALJBJARFNPBTNDZNJRJLDJFLSDIHEJAR@LBNCLQNBDBFHHZJJPDJCILEDG@IEIDABGBAAC@EJGD@PFFAAMGECG@ENMJAFCLAXADOACBGAC@AF@JCLBB@BHJFBDDB@BJF@DDCHABC@IBAFACGEC@CFMF@FIFCBE@GAEKI@AJK@IECGKBMFK@ACCFGF@TMBMEEG@WAGAMOCGIMGCCG@GHCDCBOCGKCACBCJAAOAC@GHCDKJO\\gLIVALHJLNJN@LIFSMiQiIYQgAOLSPKJOI[LKtMNKNEZFLCJG\\odDEBEAKIKAEBEBCFABEPEBCAG@EHOCMB@UQIAI@SHEAGDMIG@SFMAOGSEGCIIAG@K@CMCEHEVUNGNMDEIC@IDCC@CDIDSEKWEACDENGBC@EGM@ER_CAMBGAGIAOACECACBICIPY@EKQ_EI@OBOHMPIFKBGGDSNM@MBCZCHGFGBkCIKMBGDGFE@EBOECAG@GDIJGDABEDCF@DJFDZIBADKLWCMBMJEHADAFGDAPY@WZAFEBIIK]GK@KCC@EFMHO@KPKD@DCDC@GECKIK@EACICGBMEGEAIHG@CMQICYEKBSKCE@CGGAEAIBIFIDKFEBAP@FEDGFE@GFCBKFSC@EBGAAAAGECODEAEEBGMCGIYGEJKHI@GCK@IFEJBVDFHFAFYDO@OJQFMHAAEAACGCEE@ESOCC@GGEEGBOACOIKAKGICC@EDU@GDCHJBBFIHa^OJELCFBDADEDECEBAB@JOLMFSBEDCCCBCAEIFGAICIKGID@@CA@EAEIADQWKG@CBINGDCFKB@B@HAFMTE@ISAEBIA@CB@JE@AACEDMCEACE@CEEA@KBC@IFCJACEDEDAHDFKD@DEHCFAJBDAHMC_DADG@AIE@ADAD@@CG@EEEFCBCACABMFABEF@BC@OGAC@CE@@JC@ECADGE@CAFM@OAEEACGFEAGBCBEDEBCFGDCCG@AHBHCBA@A@AECEDI@@GFIAGDA@AAA@KCCGODCF@HCH@BCH@FABCDB@GDB@EPGHIACDCGA@AIGE@CAAADCIIACLGFDC@BBJCFG@ADEBA@BB@@EAAA@@AFEB@DAAID@@CGAAAC@@CDABACIBCCCECKFECCBACG@GACDECKBCEC@GHGCG@GAC@CDIDCDEACBSZWHGHKH@CC@DKEE@CCCDA@CC@ACBCCICAI@ADC@ADEAMKEC@ECA@CEBAA@BOAC@EAQAEDADAAABEA@BAAC@GDADAACDA@CBBLGBEBCA@HEAABDBGBCEFBAECDI@GEA@AHCDCAI@@EEBCACBGECBCAKFCACBGIECAGAA@E@AEB@HCD@DCFC@EDBFDDABE@CDOABGEE@GE@AGC@IIAEBA@GBGM@ADDDIFDHCF@DCA@AE@AECG@ACCAEBAACI@@A@E@ACBCA@CGBGCBCAAAFA@@AGDACA@C@CBACCB@CAAE@CFCDED@DC@GHE@IDECEBEAADABEA@BBBABEA@BABM@@HMFGGEDKAA@DEAECCE@AEEEE@A@KEAEOGOKICCABEBAHBFCGEGQBKEA@CECBEEAEE@EJEECBA@CGGBCACFCCCFE@GAEBCAA@GBCBECEIC@CDCBDDACEAGCAA@@AAABAD@@EB@BCAA@EHADCACDAACABCABA@@CBAAMBEEEEAGDAACBEAABC@IBC@EEAOB@CCAAEC@@AGIAIBGBA@DD@JCBCCCBGI@CGBABBBABBD@@EF@AECBAC@CAA@CA@ACCBACA@AA@CACCAAACAOBCD@CGEABCDBDA@CAGBDFEDCEGKICIBAFI@BEACE@ECCBAM@@EBACEAEFG@ACCFOCEBBBGB@FEBCCEOBE@GI@AAEB@DABACAB@FCFC@ABKBAHDJCNEJANAFADGFIAGMI@CDAEGGAGGGE@CNIBGGADBDEFE@AD@DG@@FCBKCAECCEBCCCBBEACAFKDEFCJ@JKR@HBJNPALDNCVBDCBI@@DFJAJDDADDB@D@HDXNjBRHPGRUHCTXPHNBBCDBB@JILA@ADDBMLNHADDDADFDADBDEDBF@RDDADEFEACNEA[MK@AFC@GA@AGAEDONWHSCGCCCBEAEEBEAGNKDEJDJADBJCF@HAFC@AAAE@EMK@V@F@DHFBH@JEDSFWREN@FDBL@ZQ@DNBDHGbGvGZIPKNGTHVENOJIDORGPCT@nFlJnLVLPVTRTBNETQXCPDTT|JVLNRNVHDDLANLRHD@H@PILIJIFCHGNFKPKLKHDPFHFLEHNBDGNGDADDCDDLCFBBDBJAD@BCJHF@@BAHBDNJFALEJ@HD@DAFDLCD@JDHHDDAJULADCBCGCEKFIFCJ@HCHGFKDCZARIfaTG`FTJJP@nDTFLHFJLBLEPMNEJI\\KPOL]PERDLLNNJZZGBBBABC@ADFADFH@BADBBB@FDDBDDJD@DBHLALBDDBHBDCFDBJDHABCAEBCB@DA@AFFBADBB@DIH@DAB@DCBADDFEFDB@B@BBF@DDBGDAFKBABCBALCBAB"],"encodeOffsets":[[112477,23114]]},"properties":{"cp":[110.154393,22.63136],"name":"玉林市","childNum":1}},{"id":"451000","geometry":{"type":"MultiPolygon","coordinates":[["@@MKGCGIGFfT","@@HIBGFGXYRIJI`HBB@VD@fE^HXMHBNNLJBJLDTJBDCB@F@DDDTFH@LHZAT@HCBEBELK@ACE[OFSTQFIHEDMDEBIGGWASFI@OMASBMNchqPOT_VUfMFEBUDEHERCTIZaFI@MHEHI@WAAC@QHAF@HAB[M@CBGAAOGA@EFCACCCKCAOGEA@CNKACKKEKBM@KCGMGmL{hWFUA]EUEQIGEMSAMT]\\WXMVIaXAZGNKJMHSHMNKRKTGJEBEGSMIMEcA}KUCSKC@MFC@EIGE@GKKEICEQCCACIAQAGDCB@LFN@LHP@HFL@F@BD@BKD@FDDLAHJNEHBT@LIPKJMDO@MC_BaO[BQHSVUT@JDNKNWJ[AOMY@GBILGXIRORQFMBSFQZOR@ZJNCFMJKHMII_Q@ILOTOBEQWGQCIR]HO@MFUFIRMLCFEFGKyGMIIMEcKQGMMQG@A@CAODMJSnLUTMLKNINENBpZJ@BIKQKK@MRKXEXMLKZaROlOVBNJV`@HBBB@HE\\IdAJCNADBDFFBJEJADCJOLeR[@SHK|QPG^KRCPANEZAPHLJRTFNLRJFD@D@HI@AGWBIDGNQPYLkJUFAPAT@JOHAH@RGR@F@DDJTH@HELQDYBKFOHMHCTDFA`iVeDCN@RHLHJTLPZXRJPDJLFFXJHBXGJENAFGBGCIIGICEEAEAQBGDEFEJCdAREFC@KC[@GDIZSbOPEZGPER@ZJLF^XVLL@lMNANDFD\\CR@DCKGGGAK@GFKJMPOL@NDPFLJNDLAVGRSH]LQNMD[E]AK@GCUCIKGECUCKBcLK@SCU[MEMIQG]SKGGiAKB[H_JUAIHKFO\\SDGDICOGOEKAIBCHGFE@GEGAGLGBIAAFI@CEGCMPMJATDNHFBDCJOVEFCDEFCHBJHF@HCLBJGD@HFHAJIFDHLBBHAFAJAVNDD@DFDF@TK@AAIDC@GAACBADA@CGCAEAEAKQ@C@GHG@CQOIUEEUIOCECCIFWBABEEEMACA@CBCBAVBFABCOMMCEBCBAFDJEBGDG@CA@CGAAFGBC@A@CFSCAJEAKAGGIBCCEGQEEED]BI@@@CAAAA@DABCCCEGC@ACDC@BEC@BACAA@@BCACB@ACB@CEBECAAABAAA@@DA@@EGB@ID@CCBAA@LAAEEA@CED@FEACGEBCMCBE@KBCAM@CDQBMEEEICM@A@BJAHIDSBmLUAKDGCOAAG@EEIDM@MKIBCRUBC@GGMDI@AAAIASKEDEAACBAHGCIACAEAAOCQ@GBEECAGFIHOZWHQBALABEAGGEBEFCECCI@ICIFEDADJBDJD@DJJD@DCHGDC@IGAACBGLABEC@CACGBGDKAABCJABMHC@IIQAKGIIBI@AKACBEJCBG@CAMLCJDFLH@FAFGDMAKB@B@H@PIBILEFCRAJBPANITEFKDQF]DSLBHCBI@GCgKOEKIOOKIqOM@KFCLGNEFE@WI[O]QSSOIOIaQgAQE}EUIG@CBAF@DHF@HCDQL@BBFPLBDEBE@MCI@ULODKIGAGKQB]CMBYIKEKIU[IGISAWAIEKSSGG]GwU_MGEYCKCQAKC]OUGCAAGBKBGLOBI@G]cKQ@GNUBGAGKKGMBMLIHAFAFDLHTJREBIJO@EGIGEGIAIDaAOGIOIMC[OIKMcKMICKASKKWQW[SQIQK[[AKBMFKAA@CBUEGOKEEGDEFEHEBQJGA@JBJDDSNE@KVEPMXQJmOIAODpI@IEIIEICM@YCG]QSBGCGGE@UHGCCMKKOASFK@IGIMO@_D_BECCWEQKCM@MDUPK@WI[LKBWAMDSLWVAJFHNJDJ@HKNOPahyIFODmBUFMHIB_AOCQAK@KGE@SLMNGFKAUQMAKALEEOGGGAANQBK@WSWCAE@ACA@GBSLkHA@AC@OAAOCOAIBGBKFCD@DC@UKGAIBSCGK@IPIAGGAQ@IBK^KRSHCDBXIFGLKHAZCJKDKD]BMDMNEJa`MDUP[CMBKHCT@NINIHE@MGM@MDSB[HgVQFM@IMKKKCmPIBMCOGQAMFEHKZBNPbGX@HDLBTClCRGPKLU@@HFFADBDJFIFCH@DEHQRI`@LBHHH^F\\LFHF\\HPbhFLDBDH\\DRABDEF@D@BFFBDB@JCJHFHJFDBJAJFBD@LB@NBHBH@FADGJE@A@EEM@EPID@JLJEF@NH@DGLCDCBOPEDOAEDAFBFDDF@LCJBFHHFBBCHGF[FAD@J@DKJC@CACBADIDEFKFIBIAA@MF@@BBNDJB^CPCLPRCDCRGJAHD`ZnbbjBJFFNFNDNDxBHFDHBTBfDJTPfRPFzDLALEHGFIFUFEHEH@ZRVBJIPIVIZC\\EVQBG@ECIIGGO@EJKPAVPXd\\TRFfFJDHJDNZlNHN@NLTjHJZJLFDFAJIJULCHEVBJbxNbLb@dFbJT@^ELS^CNAT@NIn@JHNHHVP\\FNA\\NDD@VOPWfRDJAL@JFBLCHEFKDcFKFOP@FFFEDALOPEJIBIlGTEHEFIDQVEBAHGJCBING@GAMH@BHLJADB@HH^@DCJKLIBGEG@ED@FEHWNCDCJAHBLAHBF@RCPCJMDGFGBEHKB@DABG@CCCAM@GJCLKJCFBFRDBBA@IBGAWISCCEICMCKDG@iVQ@IAQOMSCKFa@OFE@CCGAKBAGWEGMECBIHIAGJG@ODEFEFEAGBCABOIQAGGISEMFC@MEKBEAOGE@MJCFDPDFFDPPDJELUNYFYBGEkWM@QH]FIBGAKGEKCIKGGG@AIGMCEBI@EACGEAEBINCHABCRFVIXERAR@RG@CBDPCHAJBNKHEBEHGAEDYDEACEEACGA@I@IDQ@SCOIGAKHKDE@EAAC@EHM@CIIGEGKCO@MBI@KCE@EMQ@QCEEIBCJO@OACQ@GIGEKDI@EDABKBUNW@IFG@YD_HMLEJK`CBC@CAE@MFEHCJEBIAGBINE@M@GD@JCDIFCAABCCCB@FGJ@FQVG@SIG@E@GDCAGKCICEC@IDK@@ORIBGHEF@DADA@IICIOQCKBGBACGCCBEDGLCB]HIJCLCDSJUTIFKbCFMHGJBHCHBDDD@FADE@C@ADBFHNBLFAFEBB@FD@BADBJEFHH@DCBQDADDFFL@LDDD@VBBHBBBBNB@BBBLF\\@DEDC@CEABCHDH@BCDUAGEAACBCBEHKZ@JEVIHCBYAGB@FFD@BBFCDW\\CBK@AB@DJND@TABB@DAHEDCFBHPTTJNRAVOTcTYTYRMBkIIBIHGLAJBJL\\@NABKDMHE@E@GBADC@OJGB@BABECCBA@A@@ACB@BAAADAACDA@AF@HADUBoESGKEKQGGMGMEiA_GQBIDORQNIDWDOF_DePeH[E]A]@QBEDMJCJGFGBSCECBaAEG@GB_RMEI@EEEQGEAGEEBWLoJ[DSDKDaAKEKEGKEMAMDIJKFIJejIDOLKH[FOHQBADR`DBNFBBGNCTIBAD@FABWAODI@SIEBCDCJCVGNFDBHCNIL@VCDKBKJCHAFGFBFCRGHBHLBDLAHABKDCHIJAFA@EGC@EBADABGBBFCFCP@HAHANELGHC\\GF@JDL@HALD`@DCD]NAB@FCHOBEAAKCGUEA@BDCBABC@KDADBHJ@TGDBFBFFBHDDFBVDPXHRDN@NBHHDLVBPHNBNTJ\\CX@FAHEHGDEFEHA\\CPEBEFU^_\\eJCEMLG@GIK@GTO\\INARBLFFJDNBPDJLLNHNFZF\\DLBHHHDXAhLHH^lDP@XHTRRTH\\RVFZD`HdHL@lJ`bDBHAHMjBJFJNRFVBR@HEFCJBHBFr`PNDPD\\FDHE@AN@FHFBLLAHEA@@HFRPNFDFDBHADBDLFFBJFFFDP@LEFEH@VZFPNNdR\\BF@FE@CAI@EBCTALBDAFKCKBELCH@PHRIFMKIAK@EHKHKDAZ@`G\\Ad@PDJNXLPBNHH@HAR@TADEDAL@NCH@JEVCPIFEHCHMLoDGDSAE@CTOAGJMDAXILKFKBEBaHOFA^GPELAJBVErAPBJJRHLBFAREFMDOBEJKFAPGlGZBFBXDxO\\QLGHIROXGLEHAJOFOz]TEJ@J@ZBLFLJTFNHJL@FFH`BFCJIDAF@ZD\\ARBPDHAFA@KFEDYJQBMPOBEbQHIHCDEDGAGBCNEdWLCF@FFDNHHFJJJNdAPDFPNF@PLLDZNJ@HBHA\\NFDFJDLDBLBNFFDFJ@PFR@BHLHFHAFCNENBDDPfLNDH@DEL@HPFBJHHFdALBF@FHFDLEVGNEFAJDF@NCHGNOJELKLOVIXEHSJEHCF@DPPN@DARCJCJGFAJ@HDJTFFPLFLJHZC\\ONCJBPLdD^GXANHHJJDXHX@FBN@ZLFFhNb@LNH@FDdHFAFDFFDNFJPHLF`DTHH@HDjHHHHRLPDBTJJBHFDBRBRA"]],"encodeOffsets":[[[107619,25527],[109129,25686]]]},"properties":{"cp":[106.616285,23.897742],"name":"百色市","childNum":2}},{"id":"451100","geometry":{"type":"Polygon","coordinates":["@@SOICSFOCMGG@O@OEGEKgEIQMIGBIHI@CACEAAEBAL@BA@MNYUIQ@KSAEJOLW@WAA@AHEJBDCDDADDBBC@GFIJCHGHAH@BA@GHA@EFIAGBCBAH@NQBDLAJMJSCMDKCYHM@CC@IIKAEEKSAEDMEEAADGDAPGDGBIDCRAHARIDE@ILGBGDCLOBGDCCS@GFGFEFARCBGF_CMBKCO@OUQCIAIGEOIEEAGBIAECCCAG@KAMIGKIECAIBEAACBQ@GEKCCMCE@CBIPMBGCCECKCEGGOCACDGBIEGA@C@IJKBCCGAAMCECAEAM@YDULIA@CEwBMCKCUBCLKJCHEBG@IK_@GGQBIAQDQFQLE@CBEEMBALKFGBKPcDAHCDBDAFCDCBCBcAOX]@A@ENKBKCCGAEEAEIKCBESBAACCACCO@@CDABEAEM@CFE@YEEEIE@CMFAAEDENEAKFEA@ICCAE@GHE@ADE@CBECCDCKOA@EICAIHCA@HUAABCBEACKDCAGEGA@EGCIDMAAFGD@JGAMCA@ADE@CEE@GDCF@DD@ECCACBABACCBE@ICCGCG@BAIUDG@GCCONCCGHA@II@CGCEBEDCBIEGFCAABBDC@ADEA@CEBADECG@AFEBABABADGAEBACCDE@ACADA@@DKBAAGFDBCDCD@DC@@@AJCBIAEBIACAAGCCBMA@AA@KEA@BCBBBGB@@ABBBEBAAABAAGD@BGJIHEBEAEDGCBVAREPBDD@HT@DAVIRERD^@XE`ENOTQNKHcBGHADKPENBHSJEHK@QEOAEBIDKRKZEb@NHNLLbTn`BLIJKFAH@DJL@DKNHN@DAT@DEDE@QGGAI@EBEDKNEBO@EFAF@HO@ABCHCDK@MGCKKKAGAODCR@BGAGKAKBCDGI@KGKBIJSBIMCKKKGG@MDSHAKM@EASOCAKFQBCDIBIECEBKHODMBMCMEKIIGM@IDKJMRQBGJgBWAWIaIUEE@GFKAMOAEFMJS@_KWAOHc^GDUBsGOBIH@NANId[bMLYCSDoDKAGIMeEUEWKQSIYEKCEUA[GUGMICGIEAU@OBEACCCOCEMIOECEEBOHCFMDGAAEBABK@MBKDKNEBIEIIGCI@CCECFCEICIBBFQHA@CD@BABGA@CIEACACDACGD@AEAABICA@ADA@CEEAEBEDAJI@EAAC@GBADC@KACDGAAEBAAAEBAC@ICMFA@EFIAEEGBGLKBIHKBGAIMQECI@ABADBH@PABKDE@CCKCIKGBCBCD@F@LEFGPADC@ICMHAD@JEDCHEH@ZLzAPYV@PNNJPAPEFENB\\SFOGKGQGKPCROLCNHJZLTLJPBF@RITUVQHWBYJKJMPQZSXYPOCACC@ADCD[A@EAAGLMAABADCCCBC@ACKGEBADANGBBDDBFJPhBNBPCJLLJFPBBDCJEFKFUHgHQHUDIJO`AFBHJNFLH\\BNCTCL@LZrFFPHLNFJDHALAFCFGDK@MDUJMPGNGJAJQHWBWJEFMFIFEJKfWRCZFNDTJLALCDG@@HFJRBBFcLKCSCIBQJCLJRDNAFMTCDNHLLFHDTFHHHLDpCTERQP[RONGNCZQ`EPCNGHGTKJ@^DXAHARO^GL@DDFFDL@LKRCLBJL\\\\bLF`FXCFGTiCLKRGJIDEAI@QJOBSAQHWFBDDTVFJHFBHDBBB@FCDBDFHTDFB@B@DOFADFBV@JB@DEF@HFLRR@FF@JEP]BGCKFUNEJBHCB@HLRNHDP@FBNXBPDDXB@LCD@DBD@FMLIBIAKBSBSLO@CBGFML@BDDHF\\KFBPJFfLNVPHJJTBPH^JJLLFFBDCHQTGNbNFJAHCFGFMLOJGHGRI^IJKFSNGLGNCPBJDHVNNNBNGJGFEFCHAJFFFDT@JFDJBVRhDHNFJAHCLA^BLFHNHZFJHFVCN@PHDDKXBPDFHDHBFEHALBHDHHL\\RfHDN@PDFDDF@H@`ALKZE^BPJ\\FXBVAVETCHGFKBEA[SKAI@KFOJEJIJGTG^ARFJA^@LCRBDHJLxKvDDfJd@RFHJ^VxXF@FD@DLRZPDHBRHHJLbXDBR@HFDDBLEFBDXNDBFCJGFADEBSFKFINEPEPKFItGP@LDNLDTHRDBXDPCJGBWDIJIJCbDJAFGCIawCeDKJKHCXK\\EP@JADCBEBKCUMSICcMIGCO@I@OHOJMLKPAHEDEFALADAAG@MGQAAQCCCMWBEFGJAHEDIAIGMMQ@KFMfoLYDUE[KSE_KOAEFSBGEIGCCECMIGKSMOISBCFEFAF@LDD@DIBSBE\\BDBDLBDLAR@NENEJEBERMJQ@GF@JGFCJ@DBBNJDBDFBH@FENMVLBDDRTvLRHDJBHC\\MHAbEFBFFBFBRAJI\\BTFJTV^jVRHJRHH@HEHBDBDJHCBCDARAXCHCVB^HHDJLHBJ@HAVW\\ELANB^LZAPGZ@BGAOBCLC^J\\DJ@`KJARBJBDDLTHBN@DAFGHCNCR@XEVMNOLE"],"encodeOffsets":[[114713,25334]]},"properties":{"cp":[111.552056,24.414141],"name":"贺州市","childNum":1}},{"id":"451200","geometry":{"type":"Polygon","coordinates":["@@D@JCRMFEBEAG@ADC@IFK@QFA@EGQ@EFKBEJIEG@_BEVWPDJEJBFQH@DEDCRCPMRG@CEIC[CEE@EFBHADK@KBKcGE@EFCCCBA@MSBBQ@AECAAHKDAAGB@F@LLB@BEFCHGDAD@LDF@HEFFRA@AECBANEB@BFJH@DJDLJAZDFFBB@RMH@DAHBRJH@H@FDDCJ@BG@KFG\\AFADHBNBLLJFHHFDHDPFFFDJALINQRANDjVJEHIKWBGZAVDJ@RMPCJBPD`\\HNDR@NDLDHFFN@LGLAL@\\RLJX\\PNJ@JGFMNUVOLMHQD[PkFS@QEUGiKSGGEECIDMCSQOISEMGEMEo]_[gWMMGQ@ODQLUTIZA^E\\D`B`DrV@FCRBJXDNBHCLKLOHEDC@GD@HGHAHEHKAOGKWCCAACCGDgBCJCDCMQEW@GBC\\BNWOaeaC@KPKFW@IDGFC^AFGFGDQBGASK]CWBICKKUgCQIGOEGCMeIMKEOAQAOIBCFELEAEcCGBEFGGG]DGJGJAHEFMBMBKDGHIFEHAFCDEAGMKACEMEGGGQAKBSGaUMKGK@GDKDCJAHK@EGKUGSMWGQA_BIKC_CIECCIDIJEH@DIVWJD@DED@DHFPJJ@HCFQDAFA@AACEEBIFIjEdaNMr@lVMdLLOHKHS@cGMMGQCcCKEEKBIFMBSKe@KCAEDAFE@GHAJMDA@CGEEEGCACBIFO@QEMAKCIGKKAGNcBG@GCIIOAOBaAUGc@_mHIDONMHEAIIIBEJCHBHALMPENBHLRHLAFKPIDEHELITGHMDMHODQBWCY@GFWFGFCLABICW_@EBMQOEG@EBE\\QBIEMKACCAECEGGECI@CCMGIAKDECE@GHABECGCACK@CAHUJGDGH@FABEAE@AHABA@CK@BGECCGCE@EJML@RGAEIEEGCI@EEI@CGA@KBCCG@KKOES@GFO@ICGEEOI]COGWCO@GAMAIDOTCDACAGKY@KH@BB@HF@DA@I@AECMA@A@EAIBKIM@I@GFI@OBELG@QF[EACGEEOCMDIFIBMBEAAC@IFIPSBMACEEKEMAWA[HG@QDKFEJAPCFEBQ@GKGGEBIAWOCAC@CDEFBJAHMJYHgAMCYQ_MKEIIEIDAFBDADCE]CCMDCCAABECCCI@KDCFDBFB@DKDA@IFCAKCEDABEAKCC@CDG@CAEDE@AEEKBUMEJCBGGMBGCAEDEECK@CEGEE@@IH@BEGIBAD@BEQQOKEFCABIECDCGEBAFC@AIEAEDGDCFDDCF@NCKSWKBCCEI@EIDECC@SKAAFEBBDEFHHABGCCB@F@DGDOQ@CDBDCECAEEFG@@JD@DBCDBDM@CQC@IHCCC@CFAJD@DHAHCBAAIBCDFFADCBDTG\\C@@EEAABE@@DEBIP@JCHKEKGGGMOGQ@GFIHGBCCIIEK@KDEDCFENINMHGJKDG@ECEGBEQSCEIcOGKUCEECGAK@MDOBQHC@MESMCEKEKAIIAEASCCACAEJOBIBGBIAGHABCACBADDFGBHD@AC@EFA@EBBD@BC@CGCBEECDGQMBGOEDEE@A@AQC@BEBCGEICM@EDGK@YEIACFUCIWMIAK@KDAFAHCFENEFOJMJEBCAAGDGAACAIBCAEC@GAC[BIC@EDMAEIGIAG@CAACBIGGGEK@CAAGCAA@EBQBIGECEAC@ADBNAFGFC@MEMMC@ELGBCCIC@IAGECIAECKQ@ODGACSAKBULU@GCEGGAGEIHA@IGSQEAEBCFBJIVG`A\\JvLH^TRHNJNFV\\TDL@dKLAJBRFLHDJDV@HBLF^C\\MNKRG^QTUHKBMCKIOEMCK@OPINEL@HBLHHLHCDQ@[DECMCMBkNK@UK]WKEYIQ@OFYHOFaPYTCJ@HD\\@LEDQFcBIDEFCFAHBRBFFFJDJHDJAHEHMBIFWHGAWIEEIKOCQIYWKOISKGQGM@CDUf_jEBSCGDGNEPALCZKRGFG@ISCCE@Q@QHG@GBIPS@OBEBIVKlOZMRCHAJHX@BGJC@C@IEKQEMQSKIOGYBMFOBQD]LOH{RGL@TQ\\KfIPCDIBIFEACECAMBIDcB[JGFA@AA@GU_MIUAkPQPYbKLWNWFQL@NLLLRAJI@oYMAMFMJKLSNKVmITCNBP@D@BRHNNRHdLNFJJHNLzEHEFKDQNEJEV@NGPQ^DJHRRXAFSPKP@J`RJJGNILENMDYIQ@YPERATENQRQPWJKHAJ@HNZBPI\\MXMLICS@UVGTARP\\AbD`@NCPINOLKJS@GAMFGIKBCC@ELC@AACE@K@GEO@KGM@KEA@CDBHBRDJDBRDDFFJLL@HHFFJD@NED@TLVD~LdBNFNJHTAFIFSHQLMLGNGTINMLYHWBbUJWN[XS^BNNTHFRJVF^FVBXE|gnKNHDH@LANFLLLBDML@DFBPHDBDLDDDBFEB@PHBBAH@D\\NBA@GBERGD@BB@XGJGF@NEJYbSJQDGFCFAVEFeNUVS`OPgrMdANBTPNJ@TEXBHHAJCFCNGFEJSRET\\PDF@BKLAFAFGDS@YBKGG@SECC@C@EDAACSIKCAIKIMMGAWN]GeFC@@UAA_GIJQJWZEHAHGJP@RDFDJN@HDNFFDAJDFDBFHFPHNBBDBFNHDJBNEXBHLNFDLD\\DdPLBTAJCVULGL@HBVRL@RPPHLANMTIH@N@pLNHPAZLHD`AVGJ@H@PJHLBNAZDXDPFHLNRLXDZCNAfSJIHFJDLDJ@DBBD@BSVABBJFFTLPDFDDDAPEP@FFD@DGFCPBPFRANBHFTCPADMDY@EBCDAJMT@FBJ@D@HER@J@FEDIBCFDP@LCLEFAHNLNBJHLABAJCBAD@DH@HBF@HHJFVBLJHFH@HCFDDHDPBHFRDFAXB`RJN@NCB@FODFFCFCJFJ@LCLRFZNNBjIR@XDXDL@DBDDJCJJF@R@PHDZRNHLLHLBRAREFGHO@OEQEWDQLIRGTEPAXOPMDGJIH@F@BC@EJICIBABABABCF@LJDAFAFIJBBABC@CIAEADIACACDCHABID@J@GECEB@BKLCEEECBODAACACKC@KAGAAI@GCGFE@II@EHCBMBAAEBEHCDIDAJFF@JADALBHAFBPIDGJCFDF@@DFFD@BB@@EB@BB@ABFDJLJDLEPQRORCRBHEAKUWCKCMAOBIVaTcHoLGTD^TPHJ@LAFMHQBOEQQcOeJOAAC@AABECCDGF@HCZBNEF@FBBRB@F@DADCAMBCBAFBB@@H@FFBDABBCLFJDBDEFCJAFDDB@DEDFF@DDDNJH@JNXJFHDBBBRCNMLBBBILAH@DDBJCLKHFCFBHBBJDAHBJR`RdVJX@JBJAHCBEAES[AQHsR]JKNKRIFGDG@WCMBGFCFCLFHN`fZXFLLDL@JIHOBIAKIYAKBGFMVWXMHMFQCMQYECGA@AG@AEGGDKBAB@D@LJFDFA@EDAZENDFBBBBJH@HFHBPINCHIDCF@BFLFNDXLHPBHFFLCP@FFJABD@FDBF@FFF@HBFFPBJCDHLDBDNNJFTFVDhRPHJLTChFJDF@BC\\DZCHCH@JCD@dNTLBFB@JBBBLhXHBhBJJJFH@DKPENANFNFFJFLLDP@NELKHIDCJ@DRF@DNLH^@DCBAJDDCHKDGNFDPDHADALCLFNEF@B@DLJAHTADKF@FBDFDBBMFGNSHCAGGABCDGR@DD@FHLDXNLBHHFBTOF@FAB@BDB@HCHBDCJYAIBID@PDF@JELBFF@PCFGBEFOJBD@DFFBJHBHJZNVBRJHLTRJNL^EDDHHHHBJGBHCDBFFBTBFHJCF@HDHAHGBCAC@GBGNOJCNKHALGHGD@DDDBJIHELSDOFABEBIFGAIJYDGNEFAD@HTFFPF`FHBDFF@LCRBDAFKREFEDEDQNICGCIBIB@XHF@BEDA^M@GLGDIJABGLKBIACCCBAHGJAFAPAFCBMPS@CEE@ICC@CFC@EDADBFIJIFCFBHSLEFADB"],"encodeOffsets":[[111233,25916]]},"properties":{"cp":[108.062105,24.695899],"name":"河池市","childNum":1}},{"id":"451300","geometry":{"type":"Polygon","coordinates":["@@DSBIFCBGCKFEDADFHDJJLBRDZGJEFEDICAIBCA@A@MA]EMAECE@GCEBCD@FLHFVI@MBAJAD@JFFFNBJATMDIBMDAJAHCTAFED@FCHGJCDCEIEEKEAABIAGC@E@KHC@GKFCAEEAKBC@ACCGMKAADEDAHHD@JCB@BJD@HA@IPCJBDDHBJEBCBIDGBIEIGEG@MBIAKBS@QB@CBI@GIOGECBAFJJAFO@@LCLEHEBCBECIKKEGGIMCK@GBALAJGDEAGAA[AKGY[@CDAJBH@NFD@@CCMBEPEDIFCJ@FF@TBBH@HDN@FCDC@ACIIIOGG@IBC@KMCAMBMDC@GCC@CBC@GEYEGGCAGBAAKKAC@GCMBUAACG@QBEACG@KGCIGG@CBA@CD@HBBHD@BAACGIFK@EFICC@ADADIAAACE@@EBECKLDL@DGDKDEAKGMCCKEGIAACCAE@GDAFQMK@EDEOCAHEPEFIJIRCLCBERC@ECE@]E_VKNQDGOEkGWSQS@KJOPQLODOGSOW[WUga_iIMw][KiECBOCSOQkMUOISKAEC[@UGUOCQ@EAEEAGA[DWDcIuI]MQQOKYEUBcFODSC_EICGDIEGFSOKACACGCACCGC@CABCEACBC@BGA@ACCB@ECABIAEC@A@EFIPCbQbSDU@uJQAECCEEUGKGCOEaAMDM@KECGBODGBQGYEIMOMB@CA@CBIBAAFIBA@CAAGACDCCGFKJBF@FCBEBEJIASRGAEIOCGGCMEAGGAKGI@EAAICYWBCCE@GWQEGEAABDFAHCBIAUM@AFGCAAGIOBKCCE@ACBECOMCCAAEAC@CME@CKGAFAHCDEBCFEDEHSN@BCACFBB@HCBIBKDAFFPOHANEDGA@DBBCDD@@BE@CFDJAHABANOIEHEBACKB]EEAIKCMGIICGD@FEDBBEFAAGDGCCBGJCD@HEBMA[GEDBDEBCACAELAJHJ@FDDGFBDCBAAEFGD@DAFGCC@AFAAG@ACAC@ACCIDGF@DEACBC@CGCB@FABAIC@@CECBEACKCCEB@DBD@F@DCGDEACCG@CAABE@GK@MACM@EA@BE@GGACEAAOHA@IGAABCBCOCCBCEEEDEAMD@DE@CEEACBCIE@CDGACGI@ICCGI@GEBCHABEEEBAJ@BEIEAAGCCGA@BCD@@EHCDBDA@ADCEGCDG@EDA@CIC@@CE@AOKAAA@CPIDCJCACQIMJAAA@CB@DA@@CCDEAEBEDAFE@A@ILDHCDMBEACFIEEDAACDBDAB@BB@BABBELCEMCACAQKBADADG@CAI@E@EJC@AAGNAAAFGDINGD@DCFDDBF@FC@@B@DDAFDBCDDBDANDBDBHBDFGAQBI@@DC@AEBMDBBA@EGCIG@CCGC@AFADEEC@ACS@EP@JEDHF@LGD@JDD@BCBEEE@CBS@CCCFEBBBEBABCAABEMGCsCANBBEFCHCDAFI@MDAADE@ACAE@ACFM@CA@GLIFK@BICCAACD@FA@M@OPCF@HEB@JEL@HE@IFACAAABBBEFFDBAFDEFLDGF@BFBBDEBCDBFFFABEBENGFCDGAAAEDMB@JCFIBQA@DCDIACRCBBDFDC@EHHDGD@FADCCC@ECWJBDC@CAABBFGDG@ADDDBHGFC@BDCBACKHAHBHADDHFFBDAFABBFKHAPCHG@ADAHBFBHCVBFAJCHIBBNCLEACFBDDABDADIBGLDDDAFBDDI@GBAFEBCDBDKL@BHBAFHDABBDNDAFDB@FGBAFIB@DCBEBCF@JARD@FJCBKFADBFCB@DDJGJLF@FPCHDFPFNDBB@DD@DFF@DC@EJECIFCDAFC@MAEDBJJDFHFDADG@CFDJABAB@HFBDFED@LUTUCSBAD@@ADE@CHBD@FCBALGEI@ED@DC@ABKKGAAEAAEAAECAADIAGBG@OCCDADBDG@UGCKDAACCCB@@AKC@ACAIDECEEE@GBCAQDKCCADADCAEAAACIAEGCBQAACDACCC@CDE@@AFACCE@FCG@GFCCFG@EKCI@AFGABESKBCIAAC@GEKFKGCICG@IHIMEABGACC@ACHGACA@GEKACC@G@GG@IGBECCA@GFCBEGACMBBDDRCFK@APDD@JHDDJ@NGBCFBJIBIACBCHDDIJEAC@@PEFADBHHBPADF@DCD@DDDATGCEFKD@D@DI@BNHBCHCAEA@DBFEDKFEA@KEAI@HJADKBKCC@CD@DFNJLEHEDIACGAGBAKAI@CFPRELOFFNXPPBLF@DNALJ@HE@MPFFH@BBAHJF@DEJBDLB@BDLEFAFDBHDF@HAFJUHi@DFF@@LLLUJADWEO@CJ@FLBBLFHLH@FHJAJBFGAEH@FADJLFANVNHABHFFBRMDBJEB@DJJFFHVBGRGLGFGJELHHHLR@FADEBOFILERCH@\\GXBNBLFFFBDANOTEJ@JBDFBNAJAJENCPDFFDHFBE\\@RKHAF@PEJ@H@JJNALBJ@F@BNBFD@B@JCBE@@GAAG@@LLZBHBDDCPSJCNBHBP@XDPH^DPJFFDH@JEP@HFTLP@LDHAD@LHB@DFJ@FDJFHJFBFQHK@IN@FDFDHFDAHL@@DABGB@BBFAFEBG@CHIHGVDBL@BDHDFDBAHGF@FDLCJBNHDDJ@FDHHDFBFDDLBFNAJ[RAF@FJNNJANBHV^JDBADKHEXEHEZ@XDRAPCNGNCHGJSFKFGJCLOBEGKKQAGFMNOBKAGDGFIJAJJFBNGPMJCnGRBPOPIDKDSCEGEKACCACDIHKDM@MEOBILKbYFGFMBQNYDCHAJ@`HLBXETELAJE^aVI^A|_CISKKKBGNCPAPEF@NHJEANB@B@DENILUBMAMBAHC@@AG@CBARADFFDHDH@HAXWLBVFVALJFHDHCLGRDJJDFFLFLCXGL@\\ETENGHILU@OGYDG\\SXCBEJADKDWBEDAEC@EXEFIJACGFMIIJEFHF@AEH[HBHGMKFIDAHDP@AHJDJBnONB^@NFPRL^FJJHJD@HDAFFH@FJCA@@ABDB@FIB@DCBABB@FADFLAJGFCFDDADBADBH@FJABHCHDBBB@DDBDABJDDADKFBH@DKFKEADHFBDEJ@BBDDBFNAVBDJHFRDFNFVBR@LD\\PVAPFLDPFXRJHHXNjJjDJDBHDTDLHN@HCNAHCJ@NDPLLDP@TEHBDJBdXEJBJBHDLLJLVLBB@HBHLJDFBNFFDBDAFKFCHBVLNCF@NDHDBNEL@DRBP@DBH@HAHBJE@B@NFNJFDFHBDHDDB@@IFBHFHBFEBEFAHBFC@AAENYBEACOEUHM@EAF[@EBGCEBETMPENAJBPFDDFHPPLJLFNBL@FCJEJCHBdXRJLADBBBKN@DFJLHADCBENANBXADQLEJAJHFJBRHHJDPFHJLBHAN@NAFCFFN@HFPHPBFBDJFBNNJDF@NBLGLBHDHFBHBJCFEHID@B@HJDBJ@JCNA@EFG@GXAJCJKJ@DC@EDBFHDDJDDAFIDCND^RJCNDHDB@BC@GMGCSBGJOBGQKGE@CFCVFJ@FC@Ea_KCAADIBGLBHEBC@EAEGK@EBIBADAFBHBDDD@LID@B@DFBNFFFDH@BA@CCCACBEB@B@HFR@LFDDLBH@FEAIBGEMCAEBAABECKHGAIBCN@FAAE@QCIRJDGHCLCV@JCFEJ@"],"encodeOffsets":[[112965,24880]]},"properties":{"cp":[109.229772,23.733766],"name":"来宾市","childNum":1}},{"id":"451400","geometry":{"type":"Polygon","coordinates":["@@ICO@IABA@G@MAEEEEEOA@ECM@CPEBELADEJ@DA@EBCFAFBVTFB@DHBDFFBFADCBCDADAFBPNFBNKTAH@DFBDHCHDFBDGVG@EHAHKDAHBF@BA@I@CFC@CECACDEEC@AFCD@FCBIDCBQBEHGFABCFCBCAGGK@CDABCCMGKBGLQ@CEEE@CEKECCIBAA@K@EPSFUAW@YBCNIDIBGCGPMFATBFDJDJJP@DBFHFBVCHDZ@DB@FDB@D@DGD@DFHADCF@JCD@BD@FDPAF@VNTBHDDFBBdAJBLAHAJCAOCG@ALEJKDK@KBAJADOBCH@JDLJHBHABPRNBB@DI@IXIJGBAB@FOBKXAHABO@KHEBCDCNCBSDAB@LHLJEZBhGJFPEFCNAJDLLHDH@TOJAXHD@DCJMBG@QXMHOFATYFEJEDGFETENBFCFCLBF@PGT@PBT@HCFENQHADCHMFCzCNBZANB^E`SDKDCJEDE@GMaDGEAAABGDAJBXANAJGLBLEJ@FAHFB@BGFEBIAAMGKDCCBIFA@CEGFA@EDGFA@@IEEEAMBCA@IGBCCGBCAAIBGCGEAC@KFABC@EEEAKFMJIP@RIFKBIRGFEFGF@LDB@@FDDJ@BFTDDDHLBHAPAFBHBDFBJJD@DE@EDABE@E@EHI@CCCC@A@@EBILIFABAAEJCBICAAEBIACC@ACEEBCMMGMEBIEAHC@EDGCEGEBCEAB@FADICK@MKCAEBACEAECE@AGAA@AADGBCDGDGA@CGACKCAEMBIEACM@E@CLMBIDGH@FECCBCH@HMBIIAAOOSAIKACCAKAAGEICAC@ED@FBBGNIFDXF@IECBAHM@EBAHABDFBDA@CD@L@VFBAOGB@JAJCXCBCCIBAHCBCJCFBHFHBNCBAAGCCJA@G@CCAE@@MCEFKEEDI@I@ECC@@JABAAGBALDBFDBHAAALKPIDE@MAAABADE@CMIIEE@EG@@AKBKEECMYQGUFQBGGMWIKQEOHOBICMKUSGO@EJCAEFC@CKGE@CCGCUICE@ECACEMGCCCGBEL]AAMAKJMHCAGGGA@MGCBQOG@ADG@WAAMEMEA@AB@TUHC@CCMKWCIBODY@aJK@[O_CQ@}KMCIGMQK@aJOAkOQEO@ODQJUDGM^DIFGTIFGDGAGGS@G@GNCAQLALMDMQOIMSK@OBSMBSA@OQGUiUMIICOIMOIGMIaBODC@ACAQ@IMKFE@BOIOLKAECCMGO[@CDGH@LEFEJMLIBCCOBEHK@GGMIKI[AQBMTaEIIEIUCK@QCCDA@CACLYBEACACCAWECA@KCCQKOOEGIQQMK@EC@@BCHCHG@E@AIGQEUCIHO@kQaQ}yEOSWGAYFMDAHBARMZWbk|YjIHGBGAOMeGMEKMCMGGKGKBQDSHMBOFQJCHARCLEHGFMH_FKFULGJKHSRYTMHGBGBQVIDD_FKD]NKPCJ@HD^NRl\\f^FL@^CPILIHYNSRMF[BIFE@MKKSKIMGKCSBmXKVALA\\CFKFYDcJODSJODI@aEMIOE]BOFGFMRI\\IFgH]DSCEEMiKQGGcSQCGFBNCFIBCXELDJPRXRHJFJ@TCP@VNNFPBJE`[dEPIbCFFFFBFXHDJ@@HEHEBCCIACBADI@AFCBIDBJEB@HGDCFLFFLDPCF@BPEPFHH@RHB@FCBABGTC@DLABEDBHEHBNEFABCF@DBFJHBHCFCBEAIJK@EACBCDAHDD@H@DCDBPALG@CHEP@FFLMDGFK@EAKBCCC@UGEB@FEFC@CCG@CAI@UJGEE@EBAJG@EGYNDDDNANFFJAFJNBLL@HC@CDFBBDBD@FBDCDMDILOZAHGFBBD@DHDFCD@HABFHINGA@HDFAFC@ADFFAD@DDDFCDDDLD@DFF@AE@CHCB@BHF@FFAJCDBJAFBFCN@LBH@RJLDPDDAHDPAFPDDD@FHPEP@HNJBB@DAFGB@DFJCBBFJNDALBBADFHEFBFADECIDE@CHCDGLCBCBILADBPADDNDFADDBBNCDBDDH@BD`MBDZPBBCB@BHHF@@FABHFKH@BEB@DECA@GNDDHDF@@DDNHHAFCDGDBD@DDB@FDBJFANH@BJBD@DFDBHN@FFHAFFBJDDADBDGF@BE@@DABBJPBDDB@FDCDBBHDP@DBCDQJ@DIBBDADBB@BAHEF@DF@DFF@@DIHHFTFHHDFH@@JDBCHEBBDNCBB@BAFHBJCBBFAHBBDDALBLNABAFDJ@BHFBBHHAHLDCFEB@DEBCD@DCBCCAB@FC@BBEFK@GBUCEGC@G@MAGFEAABE@CGICADFLBP_JAHOHAB@FABGBCFKFMJE@ADKLMJABBDNHBHAJ]NcFS@ICELANBL\\\\RLRJ\\TRXLXTLLBJDLNNdJL\\PNDPJHJBPCbBJHJHFHJ@FIPAJQFSIKGECEBGBKJANHNLLBHAHMV@HLR^d@HAJKPCTBHDBVH^PLDRBLDZDHF`NxV^HHHTTFLBJBXJTJHV\\LJfPNA^DRAHLHBLJPCVKJ@RDF@BAACOKAE@ARKDC@GGE@CBEDAH@VJ~FRFhBbRPJPJTT^R\\PXJF@FEHMDKLEN@rPLJPPLJPFhLHDJ@DAAGTK^C^IFEJSBMAODUBEFEHILC@O@G@ALANBFCDC@GKGCEDIHEFEBCACKEGkCCKECCBCFG@KCCA@GFCBMACGIEACBCFEBC@ECC@A@AFCBKDGCGKELEFBBADE@ACEKBIEC@GDE@AA@ICEGCACBAFA@GBADAJBBAEEBAJ@JCBADIJABCFCBCAIBCHDBEB@P@JEP@BECEMGIIG@"],"encodeOffsets":[[109948,23638]]},"properties":{"cp":[107.353926,22.404108],"name":"崇左市","childNum":1}}],"UTF8Encoding":true});
}));