import numpy as np

score_stack = np.array([
  [ 0, 0, 0, 0, 0, 0, 0, 0, ],
  [ 0, -240, -330, -210, -140, -210, -210, -140, ],
  [ 0, -330, -340, -250, -150, -220, -240, -150, ],
  [ 0, -210, -250, 130, -50, -140, -130, 130, ],
  [ 0, -140, -150, -50, 30, -60, -100, 30, ],
  [ 0, -210, -220, -140, -60, -110, -90, -60, ],
  [ 0, -210, -240, -130, -100, -90, -130, -90, ],
  [ 0, -140, -150, 130, 30, -60, -90, 130, ],
], dtype=np.float32) / -100.

score_mismatch_hairpin = np.array([
  [
    [ 0, 0, 0, 0, 0, ],
    [ 0, 0, 0, 0, 0, ],
    [ 0, 0, 0, 0, 0, ],
    [ 0, 0, 0, 0, 0, ],
    [ 0, 0, 0, 0, 0, ],
  ], 
  [
    [ -80, -100, -110, -100, -80, ],
    [ -140, -150, -150, -140, -150, ],
    [ -80, -100, -110, -100, -80, ],
    [ -150, -230, -150, -240, -150, ],
    [ -100, -100, -140, -100, -210, ],
  ], 
  [
    [ -50, -110, -70, -110, -50, ],
    [ -110, -110, -150, -130, -150, ],
    [ -50, -110, -70, -110, -50, ],
    [ -150, -250, -150, -220, -150, ],
    [ -100, -110, -100, -110, -160, ],
  ], 
  [
    [ 20, 20, -20, -10, -20, ],
    [ 20, 20, -50, -30, -50, ],
    [ -10, -10, -20, -10, -20, ],
    [ -50, -100, -50, -110, -50, ],
    [ -10, -10, -30, -10, -100, ],
  ], 
  [
    [ 0, -20, -10, -20, 0, ],
    [ -30, -50, -30, -60, -30, ],
    [ 0, -20, -10, -20, 0, ],
    [ -30, -90, -30, -110, -30, ],
    [ -10, -20, -10, -20, -90, ],
  ], 
  [
    [ -10, -10, -20, -10, -20, ],
    [ -30, -30, -50, -30, -50, ],
    [ -10, -10, -20, -10, -20, ],
    [ -50, -120, -50, -110, -50, ],
    [ -10, -10, -30, -10, -120, ],
  ], 
  [
    [ 0, -20, -10, -20, 0, ],
    [ -30, -50, -30, -50, -30, ],
    [ 0, -20, -10, -20, 0, ],
    [ -30, -150, -30, -150, -30, ],
    [ -10, -20, -10, -20, -90, ],
  ], 
  [
    [ 20, 20, -10, -10, 0, ],
    [ 20, 20, -30, -30, -30, ],
    [ 0, -10, -10, -10, 0, ],
    [ -30, -90, -30, -110, -30, ],
    [ -10, -10, -10, -10, -90, ],
  ], 
], dtype=np.float32) / -100.

score_mismatch_internal = np.array([
  [
    [ 0, 0, 0, 0, 0, ],
    [ 0, 0, 0, 0, 0, ],
    [ 0, 0, 0, 0, 0, ],
    [ 0, 0, 0, 0, 0, ],
    [ 0, 0, 0, 0, 0, ],
  ], 
  [
    [ 0, 0, 0, 0, 0, ],
    [ 0, 0, 0, -80, 0, ],
    [ 0, 0, 0, 0, 0, ],
    [ 0, -100, 0, -100, 0, ],
    [ 0, 0, 0, 0, -60, ],
  ], 
  [
    [ 0, 0, 0, 0, 0, ],
    [ 0, 0, 0, -80, 0, ],
    [ 0, 0, 0, 0, 0, ],
    [ 0, -100, 0, -100, 0, ],
    [ 0, 0, 0, 0, -60, ],
  ], 
  [
    [ 70, 70, 70, 70, 70, ],
    [ 70, 70, 70, -10, 70, ],
    [ 70, 70, 70, 70, 70, ],
    [ 70, -30, 70, -30, 70, ],
    [ 70, 70, 70, 70, 10, ],
  ], 
  [
    [ 70, 70, 70, 70, 70, ],
    [ 70, 70, 70, -10, 70, ],
    [ 70, 70, 70, 70, 70, ],
    [ 70, -30, 70, -30, 70, ],
    [ 70, 70, 70, 70, 10, ],
  ], 
  [
    [ 70, 70, 70, 70, 70, ],
    [ 70, 70, 70, -10, 70, ],
    [ 70, 70, 70, 70, 70, ],
    [ 70, -30, 70, -30, 70, ],
    [ 70, 70, 70, 70, 10, ],
  ], 
  [
    [ 70, 70, 70, 70, 70, ],
    [ 70, 70, 70, -10, 70, ],
    [ 70, 70, 70, 70, 70, ],
    [ 70, -30, 70, -30, 70, ],
    [ 70, 70, 70, 70, 10, ],
  ], 
  [
    [ 70, 70, 70, 70, 70, ],
    [ 70, 70, 70, -10, 70, ],
    [ 70, 70, 70, 70, 70, ],
    [ 70, -30, 70, -30, 70, ],
    [ 70, 70, 70, 70, 10, ],
  ], 
], dtype=np.float32) / -100.

score_mismatch_internal_1n = np.array([
  [
    [ 0, 0, 0, 0, 0, ],
    [ 0, 0, 0, 0, 0, ],
    [ 0, 0, 0, 0, 0, ],
    [ 0, 0, 0, 0, 0, ],
    [ 0, 0, 0, 0, 0, ],
  ], 
  [
    [ 0, 0, 0, 0, 0, ],
    [ 0, 0, 0, 0, 0, ],
    [ 0, 0, 0, 0, 0, ],
    [ 0, 0, 0, 0, 0, ],
    [ 0, 0, 0, 0, 0, ],
  ], 
  [
    [ 0, 0, 0, 0, 0, ],
    [ 0, 0, 0, 0, 0, ],
    [ 0, 0, 0, 0, 0, ],
    [ 0, 0, 0, 0, 0, ],
    [ 0, 0, 0, 0, 0, ],
  ], 
  [
    [ 70, 70, 70, 70, 70, ],
    [ 70, 70, 70, 70, 70, ],
    [ 70, 70, 70, 70, 70, ],
    [ 70, 70, 70, 70, 70, ],
    [ 70, 70, 70, 70, 70, ],
  ], 
  [
    [ 70, 70, 70, 70, 70, ],
    [ 70, 70, 70, 70, 70, ],
    [ 70, 70, 70, 70, 70, ],
    [ 70, 70, 70, 70, 70, ],
    [ 70, 70, 70, 70, 70, ],
  ], 
  [
    [ 70, 70, 70, 70, 70, ],
    [ 70, 70, 70, 70, 70, ],
    [ 70, 70, 70, 70, 70, ],
    [ 70, 70, 70, 70, 70, ],
    [ 70, 70, 70, 70, 70, ],
  ], 
  [
    [ 70, 70, 70, 70, 70, ],
    [ 70, 70, 70, 70, 70, ],
    [ 70, 70, 70, 70, 70, ],
    [ 70, 70, 70, 70, 70, ],
    [ 70, 70, 70, 70, 70, ],
  ], 
  [
    [ 70, 70, 70, 70, 70, ],
    [ 70, 70, 70, 70, 70, ],
    [ 70, 70, 70, 70, 70, ],
    [ 70, 70, 70, 70, 70, ],
    [ 70, 70, 70, 70, 70, ],
  ], 
], dtype=np.float32) / -100.

score_mismatch_internal_23 = np.array([
  [
    [ 0, 0, 0, 0, 0, ],
    [ 0, 0, 0, 0, 0, ],
    [ 0, 0, 0, 0, 0, ],
    [ 0, 0, 0, 0, 0, ],
    [ 0, 0, 0, 0, 0, ],
  ], 
  [
    [ 0, 0, 0, 0, 0, ],
    [ 0, 0, 0, -50, 0, ],
    [ 0, 0, 0, 0, 0, ],
    [ 0, -110, 0, -70, 0, ],
    [ 0, 0, 0, 0, -30, ],
  ], 
  [
    [ 0, 0, 0, 0, 0, ],
    [ 0, 0, 0, 0, 0, ],
    [ 0, 0, 0, 0, 0, ],
    [ 0, -120, 0, -70, 0, ],
    [ 0, 0, 0, 0, -30, ],
  ], 
  [
    [ 70, 70, 70, 70, 70, ],
    [ 70, 70, 70, 70, 70, ],
    [ 70, 70, 70, 70, 70, ],
    [ 70, -40, 70, 0, 70, ],
    [ 70, 70, 70, 70, 40, ],
  ], 
  [
    [ 70, 70, 70, 70, 70, ],
    [ 70, 70, 70, 20, 70, ],
    [ 70, 70, 70, 70, 70, ],
    [ 70, -40, 70, 0, 70, ],
    [ 70, 70, 70, 70, 40, ],
  ], 
  [
    [ 70, 70, 70, 70, 70, ],
    [ 70, 70, 70, 70, 70, ],
    [ 70, 70, 70, 70, 70, ],
    [ 70, -40, 70, 0, 70, ],
    [ 70, 70, 70, 70, 40, ],
  ], 
  [
    [ 70, 70, 70, 70, 70, ],
    [ 70, 70, 70, 20, 70, ],
    [ 70, 70, 70, 70, 70, ],
    [ 70, -40, 70, 0, 70, ],
    [ 70, 70, 70, 70, 40, ],
  ], 
  [
    [ 70, 70, 70, 70, 70, ],
    [ 70, 70, 70, 70, 70, ],
    [ 70, 70, 70, 70, 70, ],
    [ 70, -40, 70, 0, 70, ],
    [ 70, 70, 70, 70, 40, ],
  ], 
], dtype=np.float32) / -100.

score_mismatch_multi = np.array([
  [
    [ 0, 0, 0, 0, 0, ],
    [ 0, 0, 0, 0, 0, ],
    [ 0, 0, 0, 0, 0, ],
    [ 0, 0, 0, 0, 0, ],
    [ 0, 0, 0, 0, 0, ],
  ], 
  [
    [ -50, -110, -50, -140, -70, ],
    [ -110, -110, -110, -160, -110, ],
    [ -70, -150, -70, -150, -100, ],
    [ -110, -130, -110, -140, -110, ],
    [ -50, -150, -50, -150, -70, ],
  ], 
  [
    [ -80, -140, -80, -140, -100, ],
    [ -100, -150, -100, -140, -100, ],
    [ -110, -150, -110, -150, -140, ],
    [ -100, -140, -100, -160, -100, ],
    [ -80, -150, -80, -150, -120, ],
  ], 
  [
    [ -50, -80, -50, -50, -50, ],
    [ -50, -100, -70, -50, -70, ],
    [ -60, -80, -60, -80, -60, ],
    [ -70, -110, -70, -80, -70, ],
    [ -50, -80, -50, -80, -50, ],
  ], 
  [
    [ -30, -30, -60, -60, -60, ],
    [ -30, -30, -60, -60, -60, ],
    [ -70, -100, -70, -100, -80, ],
    [ -60, -80, -60, -80, -60, ],
    [ -60, -100, -70, -100, -60, ],
  ], 
  [
    [ -50, -80, -50, -80, -50, ],
    [ -70, -100, -70, -110, -70, ],
    [ -60, -80, -60, -80, -60, ],
    [ -70, -110, -70, -120, -70, ],
    [ -50, -80, -50, -80, -50, ],
  ], 
  [
    [ -60, -80, -60, -80, -60, ],
    [ -60, -80, -60, -80, -60, ],
    [ -70, -100, -70, -100, -80, ],
    [ -60, -80, -60, -80, -60, ],
    [ -70, -100, -70, -100, -80, ],
  ], 
  [
    [ -30, -30, -50, -50, -50, ],
    [ -30, -30, -60, -50, -60, ],
    [ -60, -80, -60, -80, -60, ],
    [ -60, -80, -60, -80, -60, ],
    [ -50, -80, -50, -80, -50, ],
  ], 
], dtype=np.float32) / -100.

score_mismatch_external = np.array([
  [
    [ 0, 0, 0, 0, 0, ],
    [ 0, 0, 0, 0, 0, ],
    [ 0, 0, 0, 0, 0, ],
    [ 0, 0, 0, 0, 0, ],
    [ 0, 0, 0, 0, 0, ],
  ], 
  [
    [ -50, -110, -50, -140, -70, ],
    [ -110, -110, -110, -160, -110, ],
    [ -70, -150, -70, -150, -100, ],
    [ -110, -130, -110, -140, -110, ],
    [ -50, -150, -50, -150, -70, ],
  ], 
  [
    [ -80, -140, -80, -140, -100, ],
    [ -100, -150, -100, -140, -100, ],
    [ -110, -150, -110, -150, -140, ],
    [ -100, -140, -100, -160, -100, ],
    [ -80, -150, -80, -150, -120, ],
  ], 
  [
    [ -50, -80, -50, -50, -50, ],
    [ -50, -100, -70, -50, -70, ],
    [ -60, -80, -60, -80, -60, ],
    [ -70, -110, -70, -80, -70, ],
    [ -50, -80, -50, -80, -50, ],
  ], 
  [
    [ -30, -30, -60, -60, -60, ],
    [ -30, -30, -60, -60, -60, ],
    [ -70, -100, -70, -100, -80, ],
    [ -60, -80, -60, -80, -60, ],
    [ -60, -100, -70, -100, -60, ],
  ], 
  [
    [ -50, -80, -50, -80, -50, ],
    [ -70, -100, -70, -110, -70, ],
    [ -60, -80, -60, -80, -60, ],
    [ -70, -110, -70, -120, -70, ],
    [ -50, -80, -50, -80, -50, ],
  ], 
  [
    [ -60, -80, -60, -80, -60, ],
    [ -60, -80, -60, -80, -60, ],
    [ -70, -100, -70, -100, -80, ],
    [ -60, -80, -60, -80, -60, ],
    [ -70, -100, -70, -100, -80, ],
  ], 
  [
    [ -30, -30, -50, -50, -50, ],
    [ -30, -30, -60, -50, -60, ],
    [ -60, -80, -60, -80, -60, ],
    [ -60, -80, -60, -80, -60, ],
    [ -50, -80, -50, -80, -50, ],
  ], 
], dtype=np.float32) / -100.

score_dangle5 = np.array([
  [0, 0, 0, 0, 0,   ],
  [-10, -50, -30, -20, -10,   ],
  [0, -20, -30, 0, 0,   ],
  [-20, -30, -30, -40, -20,   ],
  [-10, -30, -10, -20, -20,   ],
  [-20, -30, -30, -40, -20,   ],
  [-10, -30, -10, -20, -20,   ],
  [0, -20, -10, 0, 0,   ],
], dtype=np.float32) / -100.

score_dangle3 = np.array([
  [0, 0, 0, 0, 0,   ],
  [-40, -110, -40, -130, -60,   ],
  [-80, -170, -80, -170, -120,   ],
  [-10, -70, -10, -70, -10,   ],
  [-50, -80, -50, -80, -60,   ],
  [-10, -70, -10, -70, -10,   ],
  [-50, -80, -50, -80, -60,   ],
  [-10, -70, -10, -70, -10,   ],
], dtype=np.float32) / -100.

score_int11 = np.array([
  [
    [
      [0, 0, 0, 0, 0, ],
      [0, 0, 0, 0, 0, ],
      [0, 0, 0, 0, 0, ],
      [0, 0, 0, 0, 0, ],
      [0, 0, 0, 0, 0, ],
    ], 
    [
      [0, 0, 0, 0, 0, ],
      [0, 0, 0, 0, 0, ],
      [0, 0, 0, 0, 0, ],
      [0, 0, 0, 0, 0, ],
      [0, 0, 0, 0, 0, ],
    ], 
    [
      [0, 0, 0, 0, 0, ],
      [0, 0, 0, 0, 0, ],
      [0, 0, 0, 0, 0, ],
      [0, 0, 0, 0, 0, ],
      [0, 0, 0, 0, 0, ],
    ], 
    [
      [0, 0, 0, 0, 0, ],
      [0, 0, 0, 0, 0, ],
      [0, 0, 0, 0, 0, ],
      [0, 0, 0, 0, 0, ],
      [0, 0, 0, 0, 0, ],
    ], 
    [
      [0, 0, 0, 0, 0, ],
      [0, 0, 0, 0, 0, ],
      [0, 0, 0, 0, 0, ],
      [0, 0, 0, 0, 0, ],
      [0, 0, 0, 0, 0, ],
    ], 
    [
      [0, 0, 0, 0, 0, ],
      [0, 0, 0, 0, 0, ],
      [0, 0, 0, 0, 0, ],
      [0, 0, 0, 0, 0, ],
      [0, 0, 0, 0, 0, ],
    ], 
    [
      [0, 0, 0, 0, 0, ],
      [0, 0, 0, 0, 0, ],
      [0, 0, 0, 0, 0, ],
      [0, 0, 0, 0, 0, ],
      [0, 0, 0, 0, 0, ],
    ], 
    [
      [0, 0, 0, 0, 0, ],
      [0, 0, 0, 0, 0, ],
      [0, 0, 0, 0, 0, ],
      [0, 0, 0, 0, 0, ],
      [0, 0, 0, 0, 0, ],
    ], 
  ], 
  [
    [
      [0, 0, 0, 0, 0, ],
      [0, 0, 0, 0, 0, ],
      [0, 0, 0, 0, 0, ],
      [0, 0, 0, 0, 0, ],
      [0, 0, 0, 0, 0, ],
    ], 
    [
      [90, 90, 50, 50, 50, ],
      [90, 90, 50, 50, 50, ],
      [50, 50, 50, 50, 50, ],
      [50, 50, 50, -140, 50, ],
      [50, 50, 50, 50, 40, ],
    ], 
    [
      [90, 90, 50, 50, 60, ],
      [90, 90, -40, 50, 50, ],
      [60, 30, 50, 50, 60, ],
      [50, -10, 50, -220, 50, ],
      [50, 50, 0, 50, -10, ],
    ], 
    [
      [120, 120, 120, 120, 120, ],
      [120, 60, 50, 120, 120, ],
      [120, 120, 120, 120, 120, ],
      [120, -20, 120, -140, 120, ],
      [120, 120, 100, 120, 110, ],
    ], 
    [
      [220, 220, 170, 120, 120, ],
      [220, 220, 130, 120, 120, ],
      [170, 120, 170, 120, 120, ],
      [120, 120, 120, -140, 120, ],
      [120, 120, 120, 120, 110, ],
    ], 
    [
      [120, 120, 120, 120, 120, ],
      [120, 120, 120, 120, 120, ],
      [120, 120, 120, 120, 120, ],
      [120, 120, 120, -140, 120, ],
      [120, 120, 120, 120, 80, ],
    ], 
    [
      [120, 120, 120, 120, 120, ],
      [120, 120, 120, 120, 120, ],
      [120, 120, 120, 120, 120, ],
      [120, 120, 120, -140, 120, ],
      [120, 120, 120, 120, 120, ],
    ], 
    [
      [220, 220, 170, 120, 120, ],
      [220, 220, 130, 120, 120, ],
      [170, 120, 170, 120, 120, ],
      [120, 120, 120, -140, 120, ],
      [120, 120, 120, 120, 120, ],
    ], 
  ], 
  [
    [
      [0, 0, 0, 0, 0, ],
      [0, 0, 0, 0, 0, ],
      [0, 0, 0, 0, 0, ],
      [0, 0, 0, 0, 0, ],
      [0, 0, 0, 0, 0, ],
    ], 
    [
      [90, 90, 60, 50, 50, ],
      [90, 90, 30, -10, 50, ],
      [50, -40, 50, 50, 0, ],
      [50, 50, 50, -220, 50, ],
      [60, 50, 60, 50, -10, ],
    ], 
    [
      [80, 80, 50, 50, 50, ],
      [80, 80, 50, 50, 50, ],
      [50, 50, 50, 50, 50, ],
      [50, 50, 50, -230, 50, ],
      [50, 50, 50, 50, -60, ],
    ], 
    [
      [190, 190, 120, 150, 150, ],
      [190, 190, 120, 150, 120, ],
      [120, 120, 120, 120, 120, ],
      [120, 120, 120, -140, 120, ],
      [150, 120, 120, 120, 150, ],
    ], 
    [
      [160, 160, 120, 120, 120, ],
      [160, 160, 120, 100, 120, ],
      [120, 120, 120, 120, 120, ],
      [120, 120, 120, -140, 120, ],
      [120, 120, 120, 120, 70, ],
    ], 
    [
      [120, 120, 120, 120, 120, ],
      [120, 120, 120, 120, 120, ],
      [120, 120, 120, 120, 120, ],
      [120, 120, 120, -140, 120, ],
      [120, 120, 120, 120, 80, ],
    ], 
    [
      [120, 120, 120, 120, 120, ],
      [120, 120, 120, 120, 120, ],
      [120, 120, 120, 120, 120, ],
      [120, 120, 120, -140, 120, ],
      [120, 120, 120, 120, 120, ],
    ], 
    [
      [190, 190, 120, 150, 150, ],
      [190, 190, 120, 150, 120, ],
      [120, 120, 120, 120, 120, ],
      [120, 120, 120, -140, 120, ],
      [150, 120, 120, 120, 150, ],
    ], 
  ], 
  [
    [
      [0, 0, 0, 0, 0, ],
      [0, 0, 0, 0, 0, ],
      [0, 0, 0, 0, 0, ],
      [0, 0, 0, 0, 0, ],
      [0, 0, 0, 0, 0, ],
    ], 
    [
      [120, 120, 120, 120, 120, ],
      [120, 60, 120, -20, 120, ],
      [120, 50, 120, 120, 100, ],
      [120, 120, 120, -140, 120, ],
      [120, 120, 120, 120, 110, ],
    ], 
    [
      [190, 190, 120, 120, 150, ],
      [190, 190, 120, 120, 120, ],
      [120, 120, 120, 120, 120, ],
      [150, 150, 120, -140, 120, ],
      [150, 120, 120, 120, 150, ],
    ], 
    [
      [190, 190, 190, 190, 190, ],
      [190, 190, 190, 190, 190, ],
      [190, 190, 190, 190, 190, ],
      [190, 190, 190, -70, 190, ],
      [190, 190, 190, 190, 120, ],
    ], 
    [
      [190, 190, 190, 190, 190, ],
      [190, 190, 190, 190, 190, ],
      [190, 190, 190, 190, 190, ],
      [190, 190, 190, -70, 190, ],
      [190, 190, 190, 190, 160, ],
    ], 
    [
      [190, 190, 190, 190, 190, ],
      [190, 190, 190, 190, 190, ],
      [190, 190, 190, 190, 190, ],
      [190, 190, 190, -70, 190, ],
      [190, 190, 190, 190, 120, ],
    ], 
    [
      [190, 190, 190, 190, 190, ],
      [190, 190, 190, 190, 190, ],
      [190, 190, 190, 190, 190, ],
      [190, 190, 190, -70, 190, ],
      [190, 190, 190, 190, 160, ],
    ], 
    [
      [190, 190, 190, 190, 190, ],
      [190, 190, 190, 190, 190, ],
      [190, 190, 190, 190, 190, ],
      [190, 190, 190, -70, 190, ],
      [190, 190, 190, 190, 160, ],
    ], 
  ], 
  [
    [
      [0, 0, 0, 0, 0, ],
      [0, 0, 0, 0, 0, ],
      [0, 0, 0, 0, 0, ],
      [0, 0, 0, 0, 0, ],
      [0, 0, 0, 0, 0, ],
    ], 
    [
      [220, 220, 170, 120, 120, ],
      [220, 220, 120, 120, 120, ],
      [170, 130, 170, 120, 120, ],
      [120, 120, 120, -140, 120, ],
      [120, 120, 120, 120, 110, ],
    ], 
    [
      [160, 160, 120, 120, 120, ],
      [160, 160, 120, 120, 120, ],
      [120, 120, 120, 120, 120, ],
      [120, 100, 120, -140, 120, ],
      [120, 120, 120, 120, 70, ],
    ], 
    [
      [190, 190, 190, 190, 190, ],
      [190, 190, 190, 190, 190, ],
      [190, 190, 190, 190, 190, ],
      [190, 190, 190, -70, 190, ],
      [190, 190, 190, 190, 160, ],
    ], 
    [
      [190, 190, 190, 190, 190, ],
      [190, 190, 190, 190, 190, ],
      [190, 190, 190, 190, 190, ],
      [190, 190, 190, -70, 190, ],
      [190, 190, 190, 190, 190, ],
    ], 
    [
      [190, 190, 190, 190, 190, ],
      [190, 190, 190, 190, 190, ],
      [190, 190, 190, 190, 190, ],
      [190, 190, 190, -70, 190, ],
      [190, 190, 190, 190, 160, ],
    ], 
    [
      [190, 190, 190, 190, 190, ],
      [190, 190, 190, 190, 190, ],
      [190, 190, 190, 190, 190, ],
      [190, 190, 190, -70, 190, ],
      [190, 190, 190, 190, 190, ],
    ], 
    [
      [220, 220, 190, 190, 190, ],
      [220, 220, 190, 190, 190, ],
      [190, 190, 190, 190, 190, ],
      [190, 190, 190, -70, 190, ],
      [190, 190, 190, 190, 190, ],
    ], 
  ], 
  [
    [
      [0, 0, 0, 0, 0, ],
      [0, 0, 0, 0, 0, ],
      [0, 0, 0, 0, 0, ],
      [0, 0, 0, 0, 0, ],
      [0, 0, 0, 0, 0, ],
    ], 
    [
      [120, 120, 120, 120, 120, ],
      [120, 120, 120, 120, 120, ],
      [120, 120, 120, 120, 120, ],
      [120, 120, 120, -140, 120, ],
      [120, 120, 120, 120, 80, ],
    ], 
    [
      [120, 120, 120, 120, 120, ],
      [120, 120, 120, 120, 120, ],
      [120, 120, 120, 120, 120, ],
      [120, 120, 120, -140, 120, ],
      [120, 120, 120, 120, 80, ],
    ], 
    [
      [190, 190, 190, 190, 190, ],
      [190, 190, 190, 190, 190, ],
      [190, 190, 190, 190, 190, ],
      [190, 190, 190, -70, 190, ],
      [190, 190, 190, 190, 120, ],
    ], 
    [
      [190, 190, 190, 190, 190, ],
      [190, 190, 190, 190, 190, ],
      [190, 190, 190, 190, 190, ],
      [190, 190, 190, -70, 190, ],
      [190, 190, 190, 190, 160, ],
    ], 
    [
      [190, 190, 190, 190, 190, ],
      [190, 190, 190, 190, 190, ],
      [190, 190, 190, 190, 190, ],
      [190, 190, 190, -70, 190, ],
      [190, 190, 190, 190, 120, ],
    ], 
    [
      [190, 190, 190, 190, 190, ],
      [190, 190, 190, 190, 190, ],
      [190, 190, 190, 190, 190, ],
      [190, 190, 190, -70, 190, ],
      [190, 190, 190, 190, 150, ],
    ], 
    [
      [190, 190, 190, 190, 190, ],
      [190, 190, 190, 190, 190, ],
      [190, 190, 190, 190, 190, ],
      [190, 190, 190, -70, 190, ],
      [190, 190, 190, 190, 160, ],
    ], 
  ], 
  [
    [
      [0, 0, 0, 0, 0, ],
      [0, 0, 0, 0, 0, ],
      [0, 0, 0, 0, 0, ],
      [0, 0, 0, 0, 0, ],
      [0, 0, 0, 0, 0, ],
    ], 
    [
      [120, 120, 120, 120, 120, ],
      [120, 120, 120, 120, 120, ],
      [120, 120, 120, 120, 120, ],
      [120, 120, 120, -140, 120, ],
      [120, 120, 120, 120, 120, ],
    ], 
    [
      [120, 120, 120, 120, 120, ],
      [120, 120, 120, 120, 120, ],
      [120, 120, 120, 120, 120, ],
      [120, 120, 120, -140, 120, ],
      [120, 120, 120, 120, 120, ],
    ], 
    [
      [190, 190, 190, 190, 190, ],
      [190, 190, 190, 190, 190, ],
      [190, 190, 190, 190, 190, ],
      [190, 190, 190, -70, 190, ],
      [190, 190, 190, 190, 160, ],
    ], 
    [
      [190, 190, 190, 190, 190, ],
      [190, 190, 190, 190, 190, ],
      [190, 190, 190, 190, 190, ],
      [190, 190, 190, -70, 190, ],
      [190, 190, 190, 190, 190, ],
    ], 
    [
      [190, 190, 190, 190, 190, ],
      [190, 190, 190, 190, 190, ],
      [190, 190, 190, 190, 190, ],
      [190, 190, 190, -70, 190, ],
      [190, 190, 190, 190, 150, ],
    ], 
    [
      [190, 190, 190, 190, 190, ],
      [190, 190, 190, 190, 190, ],
      [190, 190, 190, 190, 190, ],
      [190, 190, 190, -70, 190, ],
      [190, 190, 190, 190, 170, ],
    ], 
    [
      [190, 190, 190, 190, 190, ],
      [190, 190, 190, 190, 190, ],
      [190, 190, 190, 190, 190, ],
      [190, 190, 190, -70, 190, ],
      [190, 190, 190, 190, 190, ],
    ], 
  ], 
  [
    [
      [0, 0, 0, 0, 0, ],
      [0, 0, 0, 0, 0, ],
      [0, 0, 0, 0, 0, ],
      [0, 0, 0, 0, 0, ],
      [0, 0, 0, 0, 0, ],
    ], 
    [
      [220, 220, 170, 120, 120, ],
      [220, 220, 120, 120, 120, ],
      [170, 130, 170, 120, 120, ],
      [120, 120, 120, -140, 120, ],
      [120, 120, 120, 120, 120, ],
    ], 
    [
      [190, 190, 120, 120, 150, ],
      [190, 190, 120, 120, 120, ],
      [120, 120, 120, 120, 120, ],
      [150, 150, 120, -140, 120, ],
      [150, 120, 120, 120, 150, ],
    ], 
    [
      [190, 190, 190, 190, 190, ],
      [190, 190, 190, 190, 190, ],
      [190, 190, 190, 190, 190, ],
      [190, 190, 190, -70, 190, ],
      [190, 190, 190, 190, 160, ],
    ], 
    [
      [220, 220, 190, 190, 190, ],
      [220, 220, 190, 190, 190, ],
      [190, 190, 190, 190, 190, ],
      [190, 190, 190, -70, 190, ],
      [190, 190, 190, 190, 190, ],
    ], 
    [
      [190, 190, 190, 190, 190, ],
      [190, 190, 190, 190, 190, ],
      [190, 190, 190, 190, 190, ],
      [190, 190, 190, -70, 190, ],
      [190, 190, 190, 190, 160, ],
    ], 
    [
      [190, 190, 190, 190, 190, ],
      [190, 190, 190, 190, 190, ],
      [190, 190, 190, 190, 190, ],
      [190, 190, 190, -70, 190, ],
      [190, 190, 190, 190, 190, ],
    ], 
    [
      [220, 220, 190, 190, 190, ],
      [220, 220, 190, 190, 190, ],
      [190, 190, 190, 190, 190, ],
      [190, 190, 190, -70, 190, ],
      [190, 190, 190, 190, 190, ],
    ], 
  ], 
], dtype=np.float32) / -100.

score_int21 = np.array([
  [
    [
      [
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
      ],
      [
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
      ],
      [
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
      ],
      [
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
      ],
      [
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
      ],
    ],
    [
      [
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
      ],
      [
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
      ],
      [
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
      ],
      [
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
      ],
      [
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
      ],
    ],
    [
      [
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
      ],
      [
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
      ],
      [
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
      ],
      [
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
      ],
      [
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
      ],
    ],
    [
      [
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
      ],
      [
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
      ],
      [
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
      ],
      [
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
      ],
      [
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
      ],
    ],
    [
      [
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
      ],
      [
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
      ],
      [
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
      ],
      [
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
      ],
      [
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
      ],
    ],
    [
      [
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
      ],
      [
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
      ],
      [
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
      ],
      [
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
      ],
      [
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
      ],
    ],
    [
      [
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
      ],
      [
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
      ],
      [
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
      ],
      [
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
      ],
      [
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
      ],
    ],
    [
      [
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
      ],
      [
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
      ],
      [
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
      ],
      [
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
      ],
      [
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
      ],
    ],
  ],
  [
    [
      [
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
      ],
      [
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
      ],
      [
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
      ],
      [
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
      ],
      [
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
      ],
    ],
    [
      [
        [230, 230, 230, 230, 230, ],
        [230, 230, 230, 230, 230, ],
        [230, 230, 230, 230, 230, ],
        [230, 230, 230, 230, 230, ],
        [230, 230, 230, 230, 230, ],
      ],
      [
        [230, 230, 230, 110, 230, ],
        [230, 230, 230, 110, 230, ],
        [230, 230, 230, 110, 230, ],
        [110, 110, 110, 110, 110, ],
        [230, 230, 230, 110, 230, ],
      ],
      [
        [230, 230, 230, 230, 230, ],
        [230, 230, 230, 230, 230, ],
        [230, 230, 230, 230, 230, ],
        [230, 230, 230, 230, 230, ],
        [230, 230, 230, 230, 230, ],
      ],
      [
        [230, 110, 230, 110, 230, ],
        [110, 110, 110, 110, 110, ],
        [230, 110, 230, 110, 230, ],
        [110, 110, 110, 110, 110, ],
        [230, 110, 230, 110, 230, ],
      ],
      [
        [230, 230, 230, 230, 150, ],
        [230, 230, 230, 230, 150, ],
        [230, 230, 230, 230, 150, ],
        [230, 230, 230, 230, 150, ],
        [150, 150, 150, 150, 150, ],
      ],
    ],
    [
      [
        [250, 250, 250, 230, 230, ],
        [250, 250, 230, 230, 230, ],
        [250, 230, 250, 230, 230, ],
        [230, 230, 230, 230, 230, ],
        [250, 250, 230, 230, 230, ],
      ],
      [
        [250, 250, 230, 110, 230, ],
        [250, 250, 230, 110, 230, ],
        [230, 230, 170, 110, 230, ],
        [110, 80, 110, 110, 110, ],
        [230, 230, 230, 110, 230, ],
      ],
      [
        [250, 250, 250, 230, 230, ],
        [230, 230, 230, 230, 230, ],
        [250, 230, 250, 230, 230, ],
        [230, 230, 230, 230, 230, ],
        [250, 250, 230, 230, 230, ],
      ],
      [
        [230, 170, 230, 110, 230, ],
        [230, 170, 230, 80, 230, ],
        [230, 110, 230, 110, 230, ],
        [120, 120, 110, 110, 110, ],
        [230, 110, 230, 110, 230, ],
      ],
      [
        [230, 230, 230, 230, 150, ],
        [230, 230, 230, 230, 150, ],
        [230, 230, 220, 230, 150, ],
        [230, 230, 230, 230, 150, ],
        [170, 150, 170, 150, 140, ],
      ],
    ],
    [
      [
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
      ],
      [
        [300, 300, 300, 190, 300, ],
        [300, 300, 300, 190, 300, ],
        [300, 300, 300, 190, 300, ],
        [190, 190, 190, 190, 190, ],
        [300, 300, 300, 190, 300, ],
      ],
      [
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
      ],
      [
        [300, 190, 300, 190, 300, ],
        [300, 190, 300, 190, 300, ],
        [300, 190, 300, 190, 300, ],
        [190, 190, 190, 190, 190, ],
        [300, 190, 300, 190, 300, ],
      ],
      [
        [300, 300, 300, 300, 220, ],
        [300, 300, 300, 300, 220, ],
        [300, 300, 300, 300, 220, ],
        [300, 300, 300, 300, 220, ],
        [220, 220, 220, 220, 220, ],
      ],
    ],
    [
      [
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
      ],
      [
        [300, 300, 300, 190, 300, ],
        [300, 300, 300, 190, 300, ],
        [300, 300, 300, 190, 300, ],
        [190, 190, 190, 190, 190, ],
        [300, 300, 300, 190, 300, ],
      ],
      [
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
      ],
      [
        [300, 190, 300, 190, 300, ],
        [190, 190, 190, 190, 190, ],
        [300, 190, 300, 190, 300, ],
        [190, 190, 190, 190, 190, ],
        [300, 190, 300, 190, 300, ],
      ],
      [
        [300, 300, 300, 300, 220, ],
        [300, 300, 300, 300, 220, ],
        [300, 300, 300, 300, 220, ],
        [300, 300, 300, 300, 220, ],
        [220, 220, 220, 220, 220, ],
      ],
    ],
    [
      [
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
      ],
      [
        [300, 300, 300, 190, 300, ],
        [300, 300, 300, 190, 300, ],
        [300, 300, 300, 190, 300, ],
        [190, 190, 190, 190, 190, ],
        [300, 300, 300, 190, 300, ],
      ],
      [
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
      ],
      [
        [300, 190, 300, 190, 300, ],
        [300, 190, 300, 190, 300, ],
        [300, 190, 300, 190, 300, ],
        [190, 190, 190, 190, 190, ],
        [300, 190, 300, 190, 300, ],
      ],
      [
        [300, 300, 300, 300, 220, ],
        [300, 300, 300, 300, 220, ],
        [300, 300, 300, 300, 220, ],
        [300, 300, 300, 300, 220, ],
        [220, 220, 220, 220, 220, ],
      ],
    ],
    [
      [
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
      ],
      [
        [300, 300, 300, 190, 300, ],
        [300, 300, 300, 190, 300, ],
        [300, 300, 300, 190, 300, ],
        [190, 190, 190, 190, 190, ],
        [300, 300, 300, 190, 300, ],
      ],
      [
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
      ],
      [
        [300, 190, 300, 190, 300, ],
        [190, 190, 190, 190, 190, ],
        [300, 190, 300, 190, 300, ],
        [190, 190, 190, 190, 190, ],
        [300, 190, 300, 190, 300, ],
      ],
      [
        [300, 300, 300, 300, 220, ],
        [300, 300, 300, 300, 220, ],
        [300, 300, 300, 300, 220, ],
        [300, 300, 300, 300, 220, ],
        [220, 220, 220, 220, 220, ],
      ],
    ],
    [
      [
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
      ],
      [
        [300, 300, 300, 190, 300, ],
        [300, 300, 300, 190, 300, ],
        [300, 300, 300, 190, 300, ],
        [190, 190, 190, 190, 190, ],
        [300, 300, 300, 190, 300, ],
      ],
      [
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
      ],
      [
        [300, 190, 300, 190, 300, ],
        [300, 190, 300, 190, 300, ],
        [300, 190, 300, 190, 300, ],
        [190, 190, 190, 190, 190, ],
        [300, 190, 300, 190, 300, ],
      ],
      [
        [300, 300, 300, 300, 220, ],
        [300, 300, 300, 300, 220, ],
        [300, 300, 300, 300, 220, ],
        [300, 300, 300, 300, 220, ],
        [220, 220, 220, 220, 220, ],
      ],
    ],
  ],
  [
    [
      [
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
      ],
      [
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
      ],
      [
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
      ],
      [
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
      ],
      [
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
      ],
    ],
    [
      [
        [250, 250, 230, 230, 230, ],
        [250, 250, 230, 230, 230, ],
        [230, 230, 230, 230, 230, ],
        [230, 230, 230, 230, 230, ],
        [230, 230, 230, 230, 230, ],
      ],
      [
        [250, 250, 230, 230, 230, ],
        [250, 250, 230, 210, 230, ],
        [230, 230, 230, 230, 230, ],
        [120, 120, 110, 110, 110, ],
        [230, 230, 230, 230, 230, ],
      ],
      [
        [230, 230, 230, 230, 230, ],
        [230, 230, 230, 230, 230, ],
        [230, 230, 230, 230, 230, ],
        [230, 230, 230, 230, 230, ],
        [230, 230, 190, 230, 230, ],
      ],
      [
        [230, 110, 230, 110, 230, ],
        [110, 110, 110, 110, 110, ],
        [230, 110, 230, 110, 230, ],
        [110, 110, 110, 110, 110, ],
        [230, 110, 230, 110, 230, ],
      ],
      [
        [230, 230, 230, 230, 150, ],
        [230, 230, 230, 230, 150, ],
        [230, 230, 230, 230, 150, ],
        [230, 230, 230, 230, 150, ],
        [150, 150, 150, 150, 150, ],
      ],
    ],
    [
      [
        [230, 230, 230, 230, 230, ],
        [230, 230, 230, 230, 230, ],
        [230, 230, 230, 230, 230, ],
        [230, 230, 230, 230, 230, ],
        [230, 230, 230, 230, 230, ],
      ],
      [
        [230, 230, 230, 230, 230, ],
        [230, 230, 230, 230, 230, ],
        [230, 230, 230, 230, 230, ],
        [110, 110, 110, 110, 110, ],
        [230, 230, 230, 230, 230, ],
      ],
      [
        [230, 230, 230, 230, 230, ],
        [230, 230, 230, 230, 230, ],
        [230, 230, 230, 230, 230, ],
        [230, 230, 230, 230, 230, ],
        [230, 230, 230, 230, 230, ],
      ],
      [
        [230, 110, 230, 110, 230, ],
        [230, 110, 230, 110, 230, ],
        [230, 110, 230, 110, 230, ],
        [110, 110, 110, 110, 110, ],
        [230, 110, 230, 110, 230, ],
      ],
      [
        [230, 230, 230, 230, 150, ],
        [230, 230, 230, 230, 150, ],
        [230, 230, 230, 230, 150, ],
        [230, 230, 230, 230, 150, ],
        [150, 150, 150, 150, 150, ],
      ],
    ],
    [
      [
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
      ],
      [
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [190, 190, 190, 190, 190, ],
        [300, 300, 300, 300, 300, ],
      ],
      [
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
      ],
      [
        [300, 190, 300, 190, 300, ],
        [300, 190, 300, 190, 300, ],
        [300, 190, 300, 190, 300, ],
        [190, 190, 190, 190, 190, ],
        [300, 190, 300, 190, 300, ],
      ],
      [
        [300, 300, 300, 300, 220, ],
        [300, 300, 300, 300, 220, ],
        [300, 300, 300, 300, 220, ],
        [300, 300, 300, 300, 220, ],
        [220, 220, 220, 220, 220, ],
      ],
    ],
    [
      [
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
      ],
      [
        [300, 300, 300, 300, 300, ],
        [300, 250, 300, 210, 300, ],
        [300, 300, 300, 300, 300, ],
        [190, 120, 190, 190, 190, ],
        [300, 300, 300, 300, 300, ],
      ],
      [
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 190, 300, 300, ],
      ],
      [
        [300, 190, 300, 190, 300, ],
        [190, 190, 190, 190, 190, ],
        [300, 190, 300, 190, 300, ],
        [190, 190, 190, 190, 190, ],
        [300, 190, 300, 190, 300, ],
      ],
      [
        [300, 300, 300, 300, 220, ],
        [300, 300, 300, 300, 220, ],
        [300, 300, 300, 300, 220, ],
        [300, 300, 300, 300, 220, ],
        [220, 220, 220, 220, 220, ],
      ],
    ],
    [
      [
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
      ],
      [
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [190, 190, 190, 190, 190, ],
        [300, 300, 300, 300, 300, ],
      ],
      [
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
      ],
      [
        [300, 190, 300, 190, 300, ],
        [300, 190, 300, 190, 300, ],
        [300, 190, 300, 190, 300, ],
        [190, 190, 190, 190, 190, ],
        [300, 190, 300, 190, 300, ],
      ],
      [
        [300, 300, 300, 300, 220, ],
        [300, 300, 300, 300, 220, ],
        [300, 300, 300, 300, 220, ],
        [300, 300, 300, 300, 220, ],
        [220, 220, 220, 220, 220, ],
      ],
    ],
    [
      [
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
      ],
      [
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [190, 190, 190, 190, 190, ],
        [300, 300, 300, 300, 300, ],
      ],
      [
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
      ],
      [
        [300, 190, 300, 190, 300, ],
        [190, 190, 190, 190, 190, ],
        [300, 190, 300, 190, 300, ],
        [190, 190, 190, 190, 190, ],
        [300, 190, 300, 190, 300, ],
      ],
      [
        [300, 300, 300, 300, 220, ],
        [300, 300, 300, 300, 220, ],
        [300, 300, 300, 300, 220, ],
        [300, 300, 300, 300, 220, ],
        [220, 220, 220, 220, 220, ],
      ],
    ],
    [
      [
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
      ],
      [
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [190, 190, 190, 190, 190, ],
        [300, 300, 300, 300, 300, ],
      ],
      [
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
      ],
      [
        [300, 190, 300, 190, 300, ],
        [300, 190, 300, 190, 300, ],
        [300, 190, 300, 190, 300, ],
        [190, 190, 190, 190, 190, ],
        [300, 190, 300, 190, 300, ],
      ],
      [
        [300, 300, 300, 300, 220, ],
        [300, 300, 300, 300, 220, ],
        [300, 300, 300, 300, 220, ],
        [300, 300, 300, 300, 220, ],
        [220, 220, 220, 220, 220, ],
      ],
    ],
  ],
  [
    [
      [
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
      ],
      [
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
      ],
      [
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
      ],
      [
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
      ],
      [
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
      ],
    ],
    [
      [
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
      ],
      [
        [300, 300, 300, 300, 300, ],
        [300, 250, 300, 210, 300, ],
        [300, 300, 300, 300, 300, ],
        [190, 120, 190, 190, 190, ],
        [300, 300, 300, 300, 300, ],
      ],
      [
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 190, 300, 300, ],
      ],
      [
        [300, 190, 300, 190, 300, ],
        [190, 190, 190, 190, 190, ],
        [300, 190, 300, 190, 300, ],
        [190, 190, 190, 190, 190, ],
        [300, 190, 300, 190, 300, ],
      ],
      [
        [300, 300, 300, 300, 220, ],
        [300, 300, 300, 300, 220, ],
        [300, 300, 300, 300, 220, ],
        [300, 300, 300, 300, 220, ],
        [220, 220, 220, 220, 220, ],
      ],
    ],
    [
      [
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
      ],
      [
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [190, 190, 190, 190, 190, ],
        [300, 300, 300, 300, 300, ],
      ],
      [
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
      ],
      [
        [300, 190, 300, 190, 300, ],
        [300, 190, 300, 190, 300, ],
        [300, 190, 300, 190, 300, ],
        [190, 190, 190, 190, 190, ],
        [300, 190, 300, 190, 300, ],
      ],
      [
        [300, 300, 300, 300, 220, ],
        [300, 300, 300, 300, 220, ],
        [300, 300, 300, 300, 220, ],
        [300, 300, 300, 300, 220, ],
        [220, 220, 220, 220, 220, ],
      ],
    ],
    [
      [
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
      ],
      [
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [260, 260, 260, 260, 260, ],
        [370, 370, 370, 370, 370, ],
      ],
      [
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
      ],
      [
        [370, 260, 370, 260, 370, ],
        [370, 260, 370, 260, 370, ],
        [370, 260, 370, 260, 370, ],
        [260, 260, 260, 260, 260, ],
        [370, 260, 370, 260, 370, ],
      ],
      [
        [370, 370, 370, 370, 300, ],
        [370, 370, 370, 370, 300, ],
        [370, 370, 370, 370, 300, ],
        [370, 370, 370, 370, 300, ],
        [300, 300, 300, 300, 300, ],
      ],
    ],
    [
      [
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
      ],
      [
        [370, 370, 370, 370, 370, ],
        [370, 250, 370, 210, 370, ],
        [370, 370, 370, 370, 370, ],
        [260, 120, 260, 260, 260, ],
        [370, 370, 370, 370, 370, ],
      ],
      [
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 190, 370, 370, ],
      ],
      [
        [370, 260, 370, 260, 370, ],
        [260, 260, 260, 260, 260, ],
        [370, 260, 370, 260, 370, ],
        [260, 260, 260, 260, 260, ],
        [370, 260, 370, 260, 370, ],
      ],
      [
        [370, 370, 370, 370, 300, ],
        [370, 370, 370, 370, 300, ],
        [370, 370, 370, 370, 300, ],
        [370, 370, 370, 370, 300, ],
        [300, 300, 300, 300, 300, ],
      ],
    ],
    [
      [
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
      ],
      [
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [260, 260, 260, 260, 260, ],
        [370, 370, 370, 370, 370, ],
      ],
      [
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
      ],
      [
        [370, 260, 370, 260, 370, ],
        [370, 260, 370, 260, 370, ],
        [370, 260, 370, 260, 370, ],
        [260, 260, 260, 260, 260, ],
        [370, 260, 370, 260, 370, ],
      ],
      [
        [370, 370, 370, 370, 300, ],
        [370, 370, 370, 370, 300, ],
        [370, 370, 370, 370, 300, ],
        [370, 370, 370, 370, 300, ],
        [300, 300, 300, 300, 300, ],
      ],
    ],
    [
      [
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
      ],
      [
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [260, 260, 260, 260, 260, ],
        [370, 370, 370, 370, 370, ],
      ],
      [
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
      ],
      [
        [370, 260, 370, 260, 370, ],
        [260, 260, 260, 260, 260, ],
        [370, 260, 370, 260, 370, ],
        [260, 260, 260, 260, 260, ],
        [370, 260, 370, 260, 370, ],
      ],
      [
        [370, 370, 370, 370, 300, ],
        [370, 370, 370, 370, 300, ],
        [370, 370, 370, 370, 300, ],
        [370, 370, 370, 370, 300, ],
        [300, 300, 300, 300, 300, ],
      ],
    ],
    [
      [
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
      ],
      [
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [260, 260, 260, 260, 260, ],
        [370, 370, 370, 370, 370, ],
      ],
      [
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
      ],
      [
        [370, 260, 370, 260, 370, ],
        [370, 260, 370, 260, 370, ],
        [370, 260, 370, 260, 370, ],
        [260, 260, 260, 260, 260, ],
        [370, 260, 370, 260, 370, ],
      ],
      [
        [370, 370, 370, 370, 300, ],
        [370, 370, 370, 370, 300, ],
        [370, 370, 370, 370, 300, ],
        [370, 370, 370, 370, 300, ],
        [300, 300, 300, 300, 300, ],
      ],
    ],
  ],
  [
    [
      [
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
      ],
      [
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
      ],
      [
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
      ],
      [
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
      ],
      [
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
      ],
    ],
    [
      [
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
      ],
      [
        [300, 300, 300, 190, 300, ],
        [300, 300, 300, 190, 300, ],
        [300, 300, 300, 190, 300, ],
        [190, 190, 190, 190, 190, ],
        [300, 300, 300, 190, 300, ],
      ],
      [
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
      ],
      [
        [300, 190, 300, 190, 300, ],
        [190, 190, 190, 190, 190, ],
        [300, 190, 300, 190, 300, ],
        [190, 190, 190, 190, 190, ],
        [300, 190, 300, 190, 300, ],
      ],
      [
        [300, 300, 300, 300, 220, ],
        [300, 300, 300, 300, 220, ],
        [300, 300, 300, 300, 220, ],
        [300, 300, 300, 300, 220, ],
        [220, 220, 220, 220, 220, ],
      ],
    ],
    [
      [
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
      ],
      [
        [300, 300, 300, 190, 300, ],
        [300, 300, 300, 190, 300, ],
        [300, 300, 300, 190, 300, ],
        [190, 190, 190, 190, 190, ],
        [300, 300, 300, 190, 300, ],
      ],
      [
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
      ],
      [
        [300, 190, 300, 190, 300, ],
        [300, 190, 300, 190, 300, ],
        [300, 190, 300, 190, 300, ],
        [190, 190, 190, 190, 190, ],
        [300, 190, 300, 190, 300, ],
      ],
      [
        [300, 300, 300, 300, 220, ],
        [300, 300, 300, 300, 220, ],
        [300, 300, 300, 300, 220, ],
        [300, 300, 300, 300, 220, ],
        [220, 220, 220, 220, 220, ],
      ],
    ],
    [
      [
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
      ],
      [
        [370, 370, 370, 260, 370, ],
        [370, 370, 370, 260, 370, ],
        [370, 370, 370, 260, 370, ],
        [260, 260, 260, 260, 260, ],
        [370, 370, 370, 260, 370, ],
      ],
      [
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
      ],
      [
        [370, 260, 370, 260, 370, ],
        [370, 260, 370, 260, 370, ],
        [370, 260, 370, 260, 370, ],
        [260, 260, 260, 260, 260, ],
        [370, 260, 370, 260, 370, ],
      ],
      [
        [370, 370, 370, 370, 300, ],
        [370, 370, 370, 370, 300, ],
        [370, 370, 370, 370, 300, ],
        [370, 370, 370, 370, 300, ],
        [300, 300, 300, 300, 300, ],
      ],
    ],
    [
      [
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
      ],
      [
        [370, 370, 370, 260, 370, ],
        [370, 370, 370, 260, 370, ],
        [370, 370, 370, 260, 370, ],
        [260, 260, 260, 260, 260, ],
        [370, 370, 370, 260, 370, ],
      ],
      [
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
      ],
      [
        [370, 260, 370, 260, 370, ],
        [260, 260, 260, 260, 260, ],
        [370, 260, 370, 260, 370, ],
        [260, 260, 260, 260, 260, ],
        [370, 260, 370, 260, 370, ],
      ],
      [
        [370, 370, 370, 370, 300, ],
        [370, 370, 370, 370, 300, ],
        [370, 370, 370, 370, 300, ],
        [370, 370, 370, 370, 300, ],
        [300, 300, 300, 300, 300, ],
      ],
    ],
    [
      [
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
      ],
      [
        [370, 370, 370, 260, 370, ],
        [370, 370, 370, 260, 370, ],
        [370, 370, 370, 260, 370, ],
        [260, 260, 260, 260, 260, ],
        [370, 370, 370, 260, 370, ],
      ],
      [
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
      ],
      [
        [370, 260, 370, 260, 370, ],
        [370, 260, 370, 260, 370, ],
        [370, 260, 370, 260, 370, ],
        [260, 260, 260, 260, 260, ],
        [370, 260, 370, 260, 370, ],
      ],
      [
        [370, 370, 370, 370, 300, ],
        [370, 370, 370, 370, 300, ],
        [370, 370, 370, 370, 300, ],
        [370, 370, 370, 370, 300, ],
        [300, 300, 300, 300, 300, ],
      ],
    ],
    [
      [
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
      ],
      [
        [370, 370, 370, 260, 370, ],
        [370, 370, 370, 260, 370, ],
        [370, 370, 370, 260, 370, ],
        [260, 260, 260, 260, 260, ],
        [370, 370, 370, 260, 370, ],
      ],
      [
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
      ],
      [
        [370, 260, 370, 260, 370, ],
        [260, 260, 260, 260, 260, ],
        [370, 260, 370, 260, 370, ],
        [260, 260, 260, 260, 260, ],
        [370, 260, 370, 260, 370, ],
      ],
      [
        [370, 370, 370, 370, 300, ],
        [370, 370, 370, 370, 300, ],
        [370, 370, 370, 370, 300, ],
        [370, 370, 370, 370, 300, ],
        [300, 300, 300, 300, 300, ],
      ],
    ],
    [
      [
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
      ],
      [
        [370, 370, 370, 260, 370, ],
        [370, 370, 370, 260, 370, ],
        [370, 370, 370, 260, 370, ],
        [260, 260, 260, 260, 260, ],
        [370, 370, 370, 260, 370, ],
      ],
      [
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
      ],
      [
        [370, 260, 370, 260, 370, ],
        [370, 260, 370, 260, 370, ],
        [370, 260, 370, 260, 370, ],
        [260, 260, 260, 260, 260, ],
        [370, 260, 370, 260, 370, ],
      ],
      [
        [370, 370, 370, 370, 300, ],
        [370, 370, 370, 370, 300, ],
        [370, 370, 370, 370, 300, ],
        [370, 370, 370, 370, 300, ],
        [300, 300, 300, 300, 300, ],
      ],
    ],
  ],
  [
    [
      [
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
      ],
      [
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
      ],
      [
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
      ],
      [
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
      ],
      [
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
      ],
    ],
    [
      [
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
      ],
      [
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [190, 190, 190, 190, 190, ],
        [300, 300, 300, 300, 300, ],
      ],
      [
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
      ],
      [
        [300, 190, 300, 190, 300, ],
        [190, 190, 190, 190, 190, ],
        [300, 190, 300, 190, 300, ],
        [190, 190, 190, 190, 190, ],
        [300, 190, 300, 190, 300, ],
      ],
      [
        [300, 300, 300, 300, 220, ],
        [300, 300, 300, 300, 220, ],
        [300, 300, 300, 300, 220, ],
        [300, 300, 300, 300, 220, ],
        [220, 220, 220, 220, 220, ],
      ],
    ],
    [
      [
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
      ],
      [
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [190, 190, 190, 190, 190, ],
        [300, 300, 300, 300, 300, ],
      ],
      [
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
      ],
      [
        [300, 190, 300, 190, 300, ],
        [300, 190, 300, 190, 300, ],
        [300, 190, 300, 190, 300, ],
        [190, 190, 190, 190, 190, ],
        [300, 190, 300, 190, 300, ],
      ],
      [
        [300, 300, 300, 300, 220, ],
        [300, 300, 300, 300, 220, ],
        [300, 300, 300, 300, 220, ],
        [300, 300, 300, 300, 220, ],
        [220, 220, 220, 220, 220, ],
      ],
    ],
    [
      [
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
      ],
      [
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [260, 260, 260, 260, 260, ],
        [370, 370, 370, 370, 370, ],
      ],
      [
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
      ],
      [
        [370, 260, 370, 260, 370, ],
        [370, 260, 370, 260, 370, ],
        [370, 260, 370, 260, 370, ],
        [260, 260, 260, 260, 260, ],
        [370, 260, 370, 260, 370, ],
      ],
      [
        [370, 370, 370, 370, 300, ],
        [370, 370, 370, 370, 300, ],
        [370, 370, 370, 370, 300, ],
        [370, 370, 370, 370, 300, ],
        [300, 300, 300, 300, 300, ],
      ],
    ],
    [
      [
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
      ],
      [
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [260, 260, 260, 260, 260, ],
        [370, 370, 370, 370, 370, ],
      ],
      [
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
      ],
      [
        [370, 260, 370, 260, 370, ],
        [260, 260, 260, 260, 260, ],
        [370, 260, 370, 260, 370, ],
        [260, 260, 260, 260, 260, ],
        [370, 260, 370, 260, 370, ],
      ],
      [
        [370, 370, 370, 370, 300, ],
        [370, 370, 370, 370, 300, ],
        [370, 370, 370, 370, 300, ],
        [370, 370, 370, 370, 300, ],
        [300, 300, 300, 300, 300, ],
      ],
    ],
    [
      [
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
      ],
      [
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [260, 260, 260, 260, 260, ],
        [370, 370, 370, 370, 370, ],
      ],
      [
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
      ],
      [
        [370, 260, 370, 260, 370, ],
        [370, 260, 370, 260, 370, ],
        [370, 260, 370, 260, 370, ],
        [260, 260, 260, 260, 260, ],
        [370, 260, 370, 260, 370, ],
      ],
      [
        [370, 370, 370, 370, 300, ],
        [370, 370, 370, 370, 300, ],
        [370, 370, 370, 370, 300, ],
        [370, 370, 370, 370, 300, ],
        [300, 300, 300, 300, 300, ],
      ],
    ],
    [
      [
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
      ],
      [
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [260, 260, 260, 260, 260, ],
        [370, 370, 370, 370, 370, ],
      ],
      [
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
      ],
      [
        [370, 260, 370, 260, 370, ],
        [260, 260, 260, 260, 260, ],
        [370, 260, 370, 260, 370, ],
        [260, 260, 260, 260, 260, ],
        [370, 260, 370, 260, 370, ],
      ],
      [
        [370, 370, 370, 370, 300, ],
        [370, 370, 370, 370, 300, ],
        [370, 370, 370, 370, 300, ],
        [370, 370, 370, 370, 300, ],
        [300, 300, 300, 300, 300, ],
      ],
    ],
    [
      [
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
      ],
      [
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [260, 260, 260, 260, 260, ],
        [370, 370, 370, 370, 370, ],
      ],
      [
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
      ],
      [
        [370, 260, 370, 260, 370, ],
        [370, 260, 370, 260, 370, ],
        [370, 260, 370, 260, 370, ],
        [260, 260, 260, 260, 260, ],
        [370, 260, 370, 260, 370, ],
      ],
      [
        [370, 370, 370, 370, 300, ],
        [370, 370, 370, 370, 300, ],
        [370, 370, 370, 370, 300, ],
        [370, 370, 370, 370, 300, ],
        [300, 300, 300, 300, 300, ],
      ],
    ],
  ],
  [
    [
      [
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
      ],
      [
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
      ],
      [
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
      ],
      [
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
      ],
      [
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
      ],
    ],
    [
      [
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
      ],
      [
        [300, 300, 300, 190, 300, ],
        [300, 300, 300, 190, 300, ],
        [300, 300, 300, 190, 300, ],
        [190, 190, 190, 190, 190, ],
        [300, 300, 300, 190, 300, ],
      ],
      [
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
      ],
      [
        [300, 190, 300, 190, 300, ],
        [190, 190, 190, 190, 190, ],
        [300, 190, 300, 190, 300, ],
        [190, 190, 190, 190, 190, ],
        [300, 190, 300, 190, 300, ],
      ],
      [
        [300, 300, 300, 300, 220, ],
        [300, 300, 300, 300, 220, ],
        [300, 300, 300, 300, 220, ],
        [300, 300, 300, 300, 220, ],
        [220, 220, 220, 220, 220, ],
      ],
    ],
    [
      [
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
      ],
      [
        [300, 300, 300, 190, 300, ],
        [300, 300, 300, 190, 300, ],
        [300, 300, 300, 190, 300, ],
        [190, 190, 190, 190, 190, ],
        [300, 300, 300, 190, 300, ],
      ],
      [
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
      ],
      [
        [300, 190, 300, 190, 300, ],
        [300, 190, 300, 190, 300, ],
        [300, 190, 300, 190, 300, ],
        [190, 190, 190, 190, 190, ],
        [300, 190, 300, 190, 300, ],
      ],
      [
        [300, 300, 300, 300, 220, ],
        [300, 300, 300, 300, 220, ],
        [300, 300, 300, 300, 220, ],
        [300, 300, 300, 300, 220, ],
        [220, 220, 220, 220, 220, ],
      ],
    ],
    [
      [
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
      ],
      [
        [370, 370, 370, 260, 370, ],
        [370, 370, 370, 260, 370, ],
        [370, 370, 370, 260, 370, ],
        [260, 260, 260, 260, 260, ],
        [370, 370, 370, 260, 370, ],
      ],
      [
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
      ],
      [
        [370, 260, 370, 260, 370, ],
        [370, 260, 370, 260, 370, ],
        [370, 260, 370, 260, 370, ],
        [260, 260, 260, 260, 260, ],
        [370, 260, 370, 260, 370, ],
      ],
      [
        [370, 370, 370, 370, 300, ],
        [370, 370, 370, 370, 300, ],
        [370, 370, 370, 370, 300, ],
        [370, 370, 370, 370, 300, ],
        [300, 300, 300, 300, 300, ],
      ],
    ],
    [
      [
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
      ],
      [
        [370, 370, 370, 260, 370, ],
        [370, 370, 370, 260, 370, ],
        [370, 370, 370, 260, 370, ],
        [260, 260, 260, 260, 260, ],
        [370, 370, 370, 260, 370, ],
      ],
      [
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
      ],
      [
        [370, 260, 370, 260, 370, ],
        [260, 260, 260, 260, 260, ],
        [370, 260, 370, 260, 370, ],
        [260, 260, 260, 260, 260, ],
        [370, 260, 370, 260, 370, ],
      ],
      [
        [370, 370, 370, 370, 300, ],
        [370, 370, 370, 370, 300, ],
        [370, 370, 370, 370, 300, ],
        [370, 370, 370, 370, 300, ],
        [300, 300, 300, 300, 300, ],
      ],
    ],
    [
      [
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
      ],
      [
        [370, 370, 370, 260, 370, ],
        [370, 370, 370, 260, 370, ],
        [370, 370, 370, 260, 370, ],
        [260, 260, 260, 260, 260, ],
        [370, 370, 370, 260, 370, ],
      ],
      [
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
      ],
      [
        [370, 260, 370, 260, 370, ],
        [370, 260, 370, 260, 370, ],
        [370, 260, 370, 260, 370, ],
        [260, 260, 260, 260, 260, ],
        [370, 260, 370, 260, 370, ],
      ],
      [
        [370, 370, 370, 370, 300, ],
        [370, 370, 370, 370, 300, ],
        [370, 370, 370, 370, 300, ],
        [370, 370, 370, 370, 300, ],
        [300, 300, 300, 300, 300, ],
      ],
    ],
    [
      [
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
      ],
      [
        [370, 370, 370, 260, 370, ],
        [370, 370, 370, 260, 370, ],
        [370, 370, 370, 260, 370, ],
        [260, 260, 260, 260, 260, ],
        [370, 370, 370, 260, 370, ],
      ],
      [
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
      ],
      [
        [370, 260, 370, 260, 370, ],
        [260, 260, 260, 260, 260, ],
        [370, 260, 370, 260, 370, ],
        [260, 260, 260, 260, 260, ],
        [370, 260, 370, 260, 370, ],
      ],
      [
        [370, 370, 370, 370, 300, ],
        [370, 370, 370, 370, 300, ],
        [370, 370, 370, 370, 300, ],
        [370, 370, 370, 370, 300, ],
        [300, 300, 300, 300, 300, ],
      ],
    ],
    [
      [
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
      ],
      [
        [370, 370, 370, 260, 370, ],
        [370, 370, 370, 260, 370, ],
        [370, 370, 370, 260, 370, ],
        [260, 260, 260, 260, 260, ],
        [370, 370, 370, 260, 370, ],
      ],
      [
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
      ],
      [
        [370, 260, 370, 260, 370, ],
        [370, 260, 370, 260, 370, ],
        [370, 260, 370, 260, 370, ],
        [260, 260, 260, 260, 260, ],
        [370, 260, 370, 260, 370, ],
      ],
      [
        [370, 370, 370, 370, 300, ],
        [370, 370, 370, 370, 300, ],
        [370, 370, 370, 370, 300, ],
        [370, 370, 370, 370, 300, ],
        [300, 300, 300, 300, 300, ],
      ],
    ],
  ],
  [
    [
      [
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
      ],
      [
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
      ],
      [
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
      ],
      [
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
      ],
      [
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
        [0, 0, 0, 0, 0, ],
      ],
    ],
    [
      [
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
      ],
      [
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [190, 190, 190, 190, 190, ],
        [300, 300, 300, 300, 300, ],
      ],
      [
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
      ],
      [
        [300, 190, 300, 190, 300, ],
        [190, 190, 190, 190, 190, ],
        [300, 190, 300, 190, 300, ],
        [190, 190, 190, 190, 190, ],
        [300, 190, 300, 190, 300, ],
      ],
      [
        [300, 300, 300, 300, 220, ],
        [300, 300, 300, 300, 220, ],
        [300, 300, 300, 300, 220, ],
        [300, 300, 300, 300, 220, ],
        [220, 220, 220, 220, 220, ],
      ],
    ],
    [
      [
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
      ],
      [
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [190, 190, 190, 190, 190, ],
        [300, 300, 300, 300, 300, ],
      ],
      [
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
        [300, 300, 300, 300, 300, ],
      ],
      [
        [300, 190, 300, 190, 300, ],
        [300, 190, 300, 190, 300, ],
        [300, 190, 300, 190, 300, ],
        [190, 190, 190, 190, 190, ],
        [300, 190, 300, 190, 300, ],
      ],
      [
        [300, 300, 300, 300, 220, ],
        [300, 300, 300, 300, 220, ],
        [300, 300, 300, 300, 220, ],
        [300, 300, 300, 300, 220, ],
        [220, 220, 220, 220, 220, ],
      ],
    ],
    [
      [
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
      ],
      [
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [260, 260, 260, 260, 260, ],
        [370, 370, 370, 370, 370, ],
      ],
      [
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
      ],
      [
        [370, 260, 370, 260, 370, ],
        [370, 260, 370, 260, 370, ],
        [370, 260, 370, 260, 370, ],
        [260, 260, 260, 260, 260, ],
        [370, 260, 370, 260, 370, ],
      ],
      [
        [370, 370, 370, 370, 300, ],
        [370, 370, 370, 370, 300, ],
        [370, 370, 370, 370, 300, ],
        [370, 370, 370, 370, 300, ],
        [300, 300, 300, 300, 300, ],
      ],
    ],
    [
      [
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
      ],
      [
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [260, 260, 260, 260, 260, ],
        [370, 370, 370, 370, 370, ],
      ],
      [
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
      ],
      [
        [370, 260, 370, 260, 370, ],
        [260, 260, 260, 260, 260, ],
        [370, 260, 370, 260, 370, ],
        [260, 260, 260, 260, 260, ],
        [370, 260, 370, 260, 370, ],
      ],
      [
        [370, 370, 370, 370, 300, ],
        [370, 370, 370, 370, 300, ],
        [370, 370, 370, 370, 300, ],
        [370, 370, 370, 370, 300, ],
        [300, 300, 300, 300, 300, ],
      ],
    ],
    [
      [
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
      ],
      [
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [260, 260, 260, 260, 260, ],
        [370, 370, 370, 370, 370, ],
      ],
      [
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
      ],
      [
        [370, 260, 370, 260, 370, ],
        [370, 260, 370, 260, 370, ],
        [370, 260, 370, 260, 370, ],
        [260, 260, 260, 260, 260, ],
        [370, 260, 370, 260, 370, ],
      ],
      [
        [370, 370, 370, 370, 300, ],
        [370, 370, 370, 370, 300, ],
        [370, 370, 370, 370, 300, ],
        [370, 370, 370, 370, 300, ],
        [300, 300, 300, 300, 300, ],
      ],
    ],
    [
      [
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
      ],
      [
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [260, 260, 260, 260, 260, ],
        [370, 370, 370, 370, 370, ],
      ],
      [
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
      ],
      [
        [370, 260, 370, 260, 370, ],
        [260, 260, 260, 260, 260, ],
        [370, 260, 370, 260, 370, ],
        [260, 260, 260, 260, 260, ],
        [370, 260, 370, 260, 370, ],
      ],
      [
        [370, 370, 370, 370, 300, ],
        [370, 370, 370, 370, 300, ],
        [370, 370, 370, 370, 300, ],
        [370, 370, 370, 370, 300, ],
        [300, 300, 300, 300, 300, ],
      ],
    ],
    [
      [
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
      ],
      [
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [260, 260, 260, 260, 260, ],
        [370, 370, 370, 370, 370, ],
      ],
      [
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
        [370, 370, 370, 370, 370, ],
      ],
      [
        [370, 260, 370, 260, 370, ],
        [370, 260, 370, 260, 370, ],
        [370, 260, 370, 260, 370, ],
        [260, 260, 260, 260, 260, ],
        [370, 260, 370, 260, 370, ],
      ],
      [
        [370, 370, 370, 370, 300, ],
        [370, 370, 370, 370, 300, ],
        [370, 370, 370, 370, 300, ],
        [370, 370, 370, 370, 300, ],
        [300, 300, 300, 300, 300, ],
      ],
    ],
  ],
], dtype=np.float32) / -100.

score_int22 = np.array([
  [
    [
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
    ],
    [
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
    ],
    [
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
    ],
    [
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
    ],
    [
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
    ],
    [
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
    ],
    [
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
    ],
  ],
  [
    [
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
    ],
    [
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 120, 160, 20, 160, ], 
          [0, 110, 150, 20, 150, ], 
          [0, 20, 60, -70, 60, ], 
          [0, 110, 150, 20, 150, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 160, 200, 60, 200, ], 
          [0, 140, 180, 110, 180, ], 
          [0, 160, 200, 60, 200, ], 
          [0, 130, 170, 90, 170, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 20, 60, -70, 60, ], 
          [0, 110, 150, 20, 150, ], 
          [0, -30, 10, 0, 10, ], 
          [0, 110, 150, 20, 150, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 160, 200, 60, 200, ], 
          [0, 130, 170, 90, 170, ], 
          [0, 160, 200, 60, 200, ], 
          [0, 100, 80, -50, 80, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 110, 140, 110, 130, ], 
          [0, 110, 140, 110, 120, ], 
          [0, 20, 110, 20, 90, ], 
          [0, 110, 140, 110, 120, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 150, 180, 150, 170, ], 
          [0, 140, 170, 140, 150, ], 
          [0, 150, 180, 150, 170, ], 
          [0, 120, 150, 120, 140, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 20, 110, 20, 90, ], 
          [0, 110, 140, 110, 120, ], 
          [0, -40, -10, -40, -20, ], 
          [0, 110, 140, 110, 120, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 150, 180, 150, 170, ], 
          [0, 120, 150, 120, 140, ], 
          [0, 150, 180, 150, 170, ], 
          [0, 30, 60, 30, 50, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 20, 160, -30, 160, ], 
          [0, 20, 150, -40, 150, ], 
          [0, -70, 60, 0, 60, ], 
          [0, 20, 150, -40, 150, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 60, 200, 10, 200, ], 
          [0, 110, 180, -10, 180, ], 
          [0, 60, 200, 10, 200, ], 
          [0, 90, 170, -20, 170, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, -70, 60, 0, 60, ], 
          [0, 20, 150, -40, 150, ], 
          [0, 0, 10, 80, 10, ], 
          [0, 20, 150, -40, 150, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 60, 200, 10, 200, ], 
          [0, 90, 170, -20, 170, ], 
          [0, 60, 200, 10, 200, ], 
          [0, -50, 80, 20, 80, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 110, 130, 110, 100, ], 
          [0, 110, 120, 110, 30, ], 
          [0, 20, 90, 20, -50, ], 
          [0, 110, 120, 110, 30, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 150, 170, 150, 80, ], 
          [0, 140, 150, 140, 60, ], 
          [0, 150, 170, 150, 80, ], 
          [0, 120, 140, 120, 50, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 20, 90, 20, -50, ], 
          [0, 110, 120, 110, 30, ], 
          [0, -40, -20, -40, 20, ], 
          [0, 110, 120, 110, 30, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 150, 170, 150, 80, ], 
          [0, 120, 140, 120, 50, ], 
          [0, 150, 170, 150, 80, ], 
          [0, 30, 50, 30, -40, ], 
        ], 
      ],
    ],
    [
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 130, 60, 0, 170, ], 
          [0, 110, 150, -70, 150, ], 
          [0, -30, 10, -160, -30, ], 
          [0, 110, 150, 10, 150, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 100, 50, -100, 140, ], 
          [0, 110, 150, -60, 150, ], 
          [0, 100, 140, 10, 140, ], 
          [0, 110, 150, 70, 150, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 40, 30, -70, 30, ], 
          [0, 110, 150, 10, 150, ], 
          [0, -30, -30, 0, 10, ], 
          [0, 110, 150, 10, 150, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 100, 140, 10, 140, ], 
          [0, 110, 150, 80, 150, ], 
          [0, 100, 140, 10, 140, ], 
          [0, 150, 0, 90, 70, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 130, 220, 130, 140, ], 
          [0, 100, 130, 100, 120, ], 
          [0, -70, 70, -70, 0, ], 
          [0, 100, 130, 100, 120, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 110, 190, 100, 110, ], 
          [0, 100, 130, 100, 120, ], 
          [0, 100, 130, 100, 110, ], 
          [0, 100, 130, 100, 170, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 70, 70, -10, 60, ], 
          [0, 100, 130, 100, 120, ], 
          [0, -40, -10, -40, 20, ], 
          [0, 100, 130, 100, 120, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 100, 130, 100, 110, ], 
          [0, 110, 140, 110, 120, ], 
          [0, 100, 130, 100, 110, ], 
          [0, -20, -10, 30, 20, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, -20, 170, -10, 170, ], 
          [0, -40, 150, -40, 150, ], 
          [0, -170, -30, -90, -30, ], 
          [0, 10, 150, -40, 150, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 70, 140, -50, 140, ], 
          [0, 70, 150, -40, 150, ], 
          [0, 10, 140, -50, 140, ], 
          [0, 70, 150, 20, 150, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, -50, 30, -30, 30, ], 
          [0, 10, 150, -40, 150, ], 
          [0, -30, 10, 80, 10, ], 
          [0, 10, 150, -40, 150, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 10, 140, -50, 140, ], 
          [0, 80, 150, -50, 150, ], 
          [0, 10, 140, -50, 140, ], 
          [0, 90, 70, 140, 70, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 130, 140, 130, 140, ], 
          [0, 100, 120, 100, 30, ], 
          [0, -70, 0, -70, 50, ], 
          [0, 100, 120, 100, 30, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 100, 110, 100, 30, ], 
          [0, 100, 120, 100, 30, ], 
          [0, 100, 110, 100, 20, ], 
          [0, 100, 120, 100, 30, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, -10, 50, -10, 140, ], 
          [0, 100, 120, 100, 30, ], 
          [0, -40, -60, -40, 70, ], 
          [0, 100, 120, 100, 30, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 100, 110, 100, 20, ], 
          [0, 110, 120, 110, 30, ], 
          [0, 100, 110, 100, 20, ], 
          [0, 30, 40, 30, -60, ], 
        ], 
      ],
    ],
    [
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 270, 300, 170, 300, ], 
          [0, 230, 270, 130, 270, ], 
          [0, 150, 190, 50, 190, ], 
          [0, 230, 270, 130, 270, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 230, 270, 130, 270, ], 
          [0, 230, 270, 190, 270, ], 
          [0, 230, 270, 130, 270, ], 
          [0, 230, 270, 190, 270, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 190, 230, 90, 230, ], 
          [0, 230, 270, 130, 270, ], 
          [0, 100, 140, 130, 140, ], 
          [0, 230, 270, 130, 270, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 230, 270, 130, 270, ], 
          [0, 230, 270, 190, 270, ], 
          [0, 230, 270, 130, 270, ], 
          [0, 290, 270, 130, 270, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 260, 290, 260, 270, ], 
          [0, 220, 250, 220, 240, ], 
          [0, 140, 230, 140, 220, ], 
          [0, 220, 250, 220, 240, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 220, 250, 220, 240, ], 
          [0, 220, 250, 220, 240, ], 
          [0, 220, 250, 220, 240, ], 
          [0, 220, 250, 220, 240, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 180, 270, 180, 260, ], 
          [0, 220, 250, 220, 240, ], 
          [0, 90, 120, 90, 110, ], 
          [0, 220, 250, 220, 240, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 220, 250, 220, 240, ], 
          [0, 220, 250, 220, 240, ], 
          [0, 220, 250, 220, 240, ], 
          [0, 220, 250, 220, 240, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 170, 300, 110, 300, ], 
          [0, 130, 270, 80, 270, ], 
          [0, 50, 190, 130, 190, ], 
          [0, 130, 270, 80, 270, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 130, 270, 80, 270, ], 
          [0, 190, 270, 80, 270, ], 
          [0, 130, 270, 80, 270, ], 
          [0, 190, 270, 80, 270, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 90, 230, 170, 230, ], 
          [0, 130, 270, 80, 270, ], 
          [0, 130, 140, 210, 140, ], 
          [0, 130, 270, 80, 270, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 130, 270, 80, 270, ], 
          [0, 190, 270, 80, 270, ], 
          [0, 130, 270, 80, 270, ], 
          [0, 130, 270, 210, 270, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 260, 270, 260, 240, ], 
          [0, 220, 240, 220, 150, ], 
          [0, 140, 220, 140, 70, ], 
          [0, 220, 240, 220, 150, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 220, 240, 220, 150, ], 
          [0, 220, 240, 220, 150, ], 
          [0, 220, 240, 220, 150, ], 
          [0, 220, 240, 220, 150, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 180, 260, 180, 110, ], 
          [0, 220, 240, 220, 150, ], 
          [0, 90, 110, 90, 150, ], 
          [0, 220, 240, 220, 150, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 220, 240, 220, 150, ], 
          [0, 220, 240, 220, 150, ], 
          [0, 220, 240, 220, 150, ], 
          [0, 220, 240, 220, 150, ], 
        ], 
      ],
    ],
    [
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 160, 200, 70, 200, ], 
          [0, 200, 240, 100, 240, ], 
          [0, 60, 100, -30, 100, ], 
          [0, 200, 240, 100, 240, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 200, 240, 100, 240, ], 
          [0, 200, 240, 160, 240, ], 
          [0, 200, 240, 100, 240, ], 
          [0, 200, 240, 160, 240, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 230, 270, 130, 270, ], 
          [0, 200, 240, 100, 240, ], 
          [0, 70, 110, 100, 110, ], 
          [0, 200, 240, 100, 240, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 200, 240, 100, 240, ], 
          [0, 200, 240, 160, 240, ], 
          [0, 200, 240, 100, 240, ], 
          [0, 260, 240, 100, 240, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 160, 190, 160, 170, ], 
          [0, 190, 220, 190, 210, ], 
          [0, 60, 150, 60, 130, ], 
          [0, 190, 220, 190, 210, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 190, 220, 190, 210, ], 
          [0, 190, 220, 190, 210, ], 
          [0, 190, 220, 190, 210, ], 
          [0, 190, 220, 190, 210, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 220, 310, 220, 300, ], 
          [0, 190, 220, 190, 210, ], 
          [0, 60, 90, 60, 80, ], 
          [0, 190, 220, 190, 210, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 190, 220, 190, 210, ], 
          [0, 190, 220, 190, 210, ], 
          [0, 190, 220, 190, 210, ], 
          [0, 190, 220, 190, 210, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 70, 200, 10, 200, ], 
          [0, 100, 240, 50, 240, ], 
          [0, -30, 100, 40, 100, ], 
          [0, 100, 240, 50, 240, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 100, 240, 50, 240, ], 
          [0, 160, 240, 50, 240, ], 
          [0, 100, 240, 50, 240, ], 
          [0, 160, 240, 50, 240, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 130, 270, 210, 270, ], 
          [0, 100, 240, 50, 240, ], 
          [0, 100, 110, 180, 110, ], 
          [0, 100, 240, 50, 240, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 100, 240, 50, 240, ], 
          [0, 160, 240, 50, 240, ], 
          [0, 100, 240, 50, 240, ], 
          [0, 100, 240, 180, 240, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 160, 170, 160, 140, ], 
          [0, 190, 210, 190, 120, ], 
          [0, 60, 130, 60, -10, ], 
          [0, 190, 210, 190, 120, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 190, 210, 190, 120, ], 
          [0, 190, 210, 190, 120, ], 
          [0, 190, 210, 190, 120, ], 
          [0, 190, 210, 190, 120, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 220, 300, 220, 150, ], 
          [0, 190, 210, 190, 120, ], 
          [0, 60, 80, 60, 120, ], 
          [0, 190, 210, 190, 120, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 190, 210, 190, 120, ], 
          [0, 190, 210, 190, 120, ], 
          [0, 190, 210, 190, 120, ], 
          [0, 190, 210, 190, 120, ], 
        ], 
      ],
    ],
    [
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 200, 240, 100, 240, ], 
          [0, 170, 210, 80, 210, ], 
          [0, 70, 110, -20, 110, ], 
          [0, 170, 210, 80, 210, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 180, 220, 90, 220, ], 
          [0, 180, 220, 140, 220, ], 
          [0, 180, 220, 90, 220, ], 
          [0, 180, 220, 140, 220, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 140, 180, 50, 180, ], 
          [0, 170, 210, 80, 210, ], 
          [0, 20, 60, 60, 60, ], 
          [0, 170, 210, 80, 210, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 180, 220, 90, 220, ], 
          [0, 180, 220, 140, 220, ], 
          [0, 180, 220, 90, 220, ], 
          [0, 150, 130, 0, 130, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 190, 220, 190, 210, ], 
          [0, 170, 200, 170, 180, ], 
          [0, 70, 160, 70, 140, ], 
          [0, 170, 200, 170, 180, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 180, 210, 180, 190, ], 
          [0, 170, 200, 170, 190, ], 
          [0, 180, 210, 180, 190, ], 
          [0, 170, 200, 170, 190, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 140, 230, 140, 210, ], 
          [0, 170, 200, 170, 180, ], 
          [0, 20, 50, 20, 30, ], 
          [0, 170, 200, 170, 180, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 180, 210, 180, 190, ], 
          [0, 170, 200, 170, 190, ], 
          [0, 180, 210, 180, 190, ], 
          [0, 80, 110, 80, 100, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 100, 240, 50, 240, ], 
          [0, 80, 210, 20, 210, ], 
          [0, -20, 110, 50, 110, ], 
          [0, 80, 210, 20, 210, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 90, 220, 30, 220, ], 
          [0, 140, 220, 30, 220, ], 
          [0, 90, 220, 30, 220, ], 
          [0, 140, 220, 30, 220, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 50, 180, 120, 180, ], 
          [0, 80, 210, 20, 210, ], 
          [0, 60, 60, 130, 60, ], 
          [0, 80, 210, 20, 210, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 90, 220, 30, 220, ], 
          [0, 140, 220, 30, 220, ], 
          [0, 90, 220, 30, 220, ], 
          [0, 0, 130, 70, 130, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 190, 210, 190, 180, ], 
          [0, 170, 180, 170, 90, ], 
          [0, 70, 140, 70, 0, ], 
          [0, 170, 180, 170, 90, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 180, 190, 180, 100, ], 
          [0, 170, 190, 170, 100, ], 
          [0, 180, 190, 180, 100, ], 
          [0, 170, 190, 170, 100, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 140, 210, 140, 60, ], 
          [0, 170, 180, 170, 90, ], 
          [0, 20, 30, 20, 70, ], 
          [0, 170, 180, 170, 90, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 180, 190, 180, 100, ], 
          [0, 170, 190, 170, 100, ], 
          [0, 180, 190, 180, 100, ], 
          [0, 80, 100, 80, 10, ], 
        ], 
      ],
    ],
    [
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 200, 240, 100, 240, ], 
          [0, 150, 190, 60, 190, ], 
          [0, 90, 130, 0, 130, ], 
          [0, 150, 190, 60, 190, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 200, 240, 100, 240, ], 
          [0, 200, 240, 160, 240, ], 
          [0, 200, 240, 100, 240, ], 
          [0, 200, 240, 160, 240, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 100, 140, 10, 140, ], 
          [0, 150, 190, 60, 190, ], 
          [0, 40, 80, 80, 80, ], 
          [0, 150, 190, 60, 190, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 200, 240, 100, 240, ], 
          [0, 170, 210, 130, 210, ], 
          [0, 200, 240, 100, 240, ], 
          [0, 170, 150, 20, 150, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 190, 220, 190, 210, ], 
          [0, 150, 180, 150, 160, ], 
          [0, 90, 180, 90, 160, ], 
          [0, 150, 180, 150, 160, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 190, 220, 190, 210, ], 
          [0, 190, 220, 190, 210, ], 
          [0, 190, 220, 190, 210, ], 
          [0, 190, 220, 190, 210, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 100, 190, 100, 170, ], 
          [0, 150, 180, 150, 160, ], 
          [0, 40, 70, 40, 50, ], 
          [0, 150, 180, 150, 160, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 190, 220, 190, 210, ], 
          [0, 160, 190, 160, 180, ], 
          [0, 190, 220, 190, 210, ], 
          [0, 110, 140, 110, 120, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 100, 240, 50, 240, ], 
          [0, 60, 190, 0, 190, ], 
          [0, 0, 130, 70, 130, ], 
          [0, 60, 190, 0, 190, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 100, 240, 50, 240, ], 
          [0, 160, 240, 50, 240, ], 
          [0, 100, 240, 50, 240, ], 
          [0, 160, 240, 50, 240, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 10, 140, 80, 140, ], 
          [0, 60, 190, 0, 190, ], 
          [0, 80, 80, 150, 80, ], 
          [0, 60, 190, 0, 190, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 100, 240, 50, 240, ], 
          [0, 130, 210, 20, 210, ], 
          [0, 100, 240, 50, 240, ], 
          [0, 20, 150, 90, 150, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 190, 210, 190, 180, ], 
          [0, 150, 160, 150, 70, ], 
          [0, 90, 160, 90, 10, ], 
          [0, 150, 160, 150, 70, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 190, 210, 190, 120, ], 
          [0, 190, 210, 190, 120, ], 
          [0, 190, 210, 190, 120, ], 
          [0, 190, 210, 190, 120, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 100, 170, 100, 20, ], 
          [0, 150, 160, 150, 70, ], 
          [0, 40, 50, 40, 90, ], 
          [0, 150, 160, 150, 70, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 190, 210, 190, 120, ], 
          [0, 160, 180, 160, 90, ], 
          [0, 190, 210, 190, 120, ], 
          [0, 110, 120, 110, 30, ], 
        ], 
      ],
    ],
  ],
  [
    [
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
    ],
    [
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 130, 100, 40, 100, ], 
          [0, 130, 110, 70, 100, ], 
          [0, -20, 70, -50, 10, ], 
          [0, 130, 100, -10, 100, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 60, 50, 30, 140, ], 
          [0, 220, 190, 70, 130, ], 
          [0, 170, 140, 30, 140, ], 
          [0, 140, 110, 50, 110, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, -100, -70, 10, ], 
          [0, 130, 100, -10, 100, ], 
          [0, -10, -50, -30, -50, ], 
          [0, 130, 100, -10, 100, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 170, 140, 30, 140, ], 
          [0, 140, 110, 60, 110, ], 
          [0, 170, 140, 30, 140, ], 
          [0, 140, 30, 140, 20, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 110, 110, 110, 110, ], 
          [0, 100, 100, 100, 110, ], 
          [0, -40, 70, 10, 80, ], 
          [0, 100, 100, 100, 110, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 150, 150, 150, 150, ], 
          [0, 130, 130, 130, 140, ], 
          [0, 150, 150, 150, 150, ], 
          [0, 120, 120, 120, 120, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, -70, -60, 10, 80, ], 
          [0, 100, 100, 100, 110, ], 
          [0, -40, -40, -40, -50, ], 
          [0, 100, 100, 100, 110, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 150, 150, 150, 150, ], 
          [0, 120, 120, 120, 120, ], 
          [0, 150, 150, 150, 150, ], 
          [0, 30, 30, 30, 30, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, -30, 100, -30, 100, ], 
          [0, -70, 100, -40, 100, ], 
          [0, -170, 10, -30, 10, ], 
          [0, -70, 100, -40, 100, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 10, 140, -30, 140, ], 
          [0, 70, 130, -10, 130, ], 
          [0, -30, 140, 10, 140, ], 
          [0, 0, 110, -60, 110, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, -160, 10, 0, 10, ], 
          [0, -70, 100, -40, 100, ], 
          [0, -90, -50, 80, -50, ], 
          [0, -70, 100, -40, 100, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, -30, 140, 10, 140, ], 
          [0, 0, 110, 20, 110, ], 
          [0, -30, 140, 10, 140, ], 
          [0, 50, 20, 70, 20, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 110, 110, 110, 150, ], 
          [0, 100, 100, 100, -20, ], 
          [0, 10, 70, 10, 90, ], 
          [0, 100, 100, 100, 30, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 150, 150, 150, 0, ], 
          [0, 130, 130, 130, -10, ], 
          [0, 150, 150, 150, 70, ], 
          [0, 120, 120, 120, 40, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 10, 70, 10, 90, ], 
          [0, 100, 100, 100, 30, ], 
          [0, -40, 20, -40, 140, ], 
          [0, 100, 100, 100, 30, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 150, 150, 150, 70, ], 
          [0, 120, 170, 120, 20, ], 
          [0, 150, 150, 150, 70, ], 
          [0, 30, 30, 30, -60, ], 
        ], 
      ],
    ],
    [
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 150, 120, 10, 120, ], 
          [0, 120, 90, -10, 90, ], 
          [0, -50, -80, -190, -80, ], 
          [0, 120, 90, -10, 90, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 120, 90, -20, 90, ], 
          [0, 120, 90, 50, 90, ], 
          [0, 120, 90, -20, 90, ], 
          [0, 120, 90, 50, 90, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 10, -20, -130, -20, ], 
          [0, 120, 90, -10, 90, ], 
          [0, -20, -50, -20, -50, ], 
          [0, 120, 90, -10, 90, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 120, 90, -20, 90, ], 
          [0, 130, 100, 50, 100, ], 
          [0, 120, 90, -20, 90, ], 
          [0, 110, 20, -90, 20, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 120, 120, 120, 130, ], 
          [0, 100, 100, 100, 100, ], 
          [0, -80, -20, -80, -10, ], 
          [0, 100, 100, 100, 100, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 90, 90, 90, 100, ], 
          [0, 100, 100, 100, 100, ], 
          [0, 90, 90, 90, 100, ], 
          [0, 100, 100, 100, 100, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, -10, 50, -10, 50, ], 
          [0, 100, 100, 100, 100, ], 
          [0, -40, -40, -40, -40, ], 
          [0, 100, 100, 100, 100, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 90, 90, 90, 100, ], 
          [0, 100, 100, 100, 110, ], 
          [0, 90, 90, 90, 100, ], 
          [0, 20, 20, 20, 30, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, -50, 120, -20, 120, ], 
          [0, -80, 90, -40, 90, ], 
          [0, -260, -80, -90, -80, ], 
          [0, -80, 90, -40, 90, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, -80, 90, -50, 90, ], 
          [0, -20, 90, -40, 90, ], 
          [0, -80, 90, -50, 90, ], 
          [0, -20, 90, -40, 90, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, -190, -20, -20, -20, ], 
          [0, -80, 90, -40, 90, ], 
          [0, -90, -50, 80, -50, ], 
          [0, -80, 90, -40, 90, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, -80, 90, -50, 90, ], 
          [0, -10, 100, -40, 100, ], 
          [0, -80, 90, -50, 90, ], 
          [0, -150, 20, 10, 20, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 120, 120, 120, 110, ], 
          [0, 100, 100, 100, 20, ], 
          [0, -80, -20, -80, -150, ], 
          [0, 100, 100, 100, 20, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 90, 90, 90, 20, ], 
          [0, 100, 100, 100, 20, ], 
          [0, 90, 90, 90, 20, ], 
          [0, 100, 100, 100, 20, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, -10, 50, -10, -90, ], 
          [0, 100, 100, 100, 20, ], 
          [0, -40, -40, -40, 10, ], 
          [0, 100, 100, 100, 20, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 90, 90, 90, 20, ], 
          [0, 100, 100, 100, 30, ], 
          [0, 90, 90, 90, 20, ], 
          [0, 20, 20, 20, -50, ], 
        ], 
      ],
    ],
    [
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 280, 250, 140, 250, ], 
          [0, 240, 210, 100, 210, ], 
          [0, 160, 130, 20, 130, ], 
          [0, 240, 210, 100, 210, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 240, 210, 100, 210, ], 
          [0, 240, 210, 160, 210, ], 
          [0, 240, 210, 100, 210, ], 
          [0, 240, 210, 160, 210, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 200, 170, 60, 170, ], 
          [0, 240, 210, 100, 210, ], 
          [0, 110, 80, 100, 80, ], 
          [0, 240, 210, 100, 210, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 240, 210, 100, 210, ], 
          [0, 240, 210, 160, 210, ], 
          [0, 240, 210, 100, 210, ], 
          [0, 300, 210, 100, 210, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 250, 250, 250, 260, ], 
          [0, 220, 220, 220, 220, ], 
          [0, 140, 200, 140, 200, ], 
          [0, 220, 220, 220, 220, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 220, 220, 220, 220, ], 
          [0, 220, 220, 220, 220, ], 
          [0, 220, 220, 220, 220, ], 
          [0, 220, 220, 220, 220, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 180, 240, 180, 240, ], 
          [0, 220, 220, 220, 220, ], 
          [0, 90, 90, 90, 90, ], 
          [0, 220, 220, 220, 220, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 220, 220, 220, 220, ], 
          [0, 220, 220, 220, 220, ], 
          [0, 220, 220, 220, 220, ], 
          [0, 220, 220, 220, 220, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 70, 250, 110, 250, ], 
          [0, 40, 210, 80, 210, ], 
          [0, -40, 130, 130, 130, ], 
          [0, 40, 210, 80, 210, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 40, 210, 80, 210, ], 
          [0, 100, 210, 80, 210, ], 
          [0, 40, 210, 80, 210, ], 
          [0, 100, 210, 80, 210, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 170, 170, 170, ], 
          [0, 40, 210, 80, 210, ], 
          [0, 40, 80, 210, 80, ], 
          [0, 40, 210, 80, 210, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 40, 210, 80, 210, ], 
          [0, 100, 210, 80, 210, ], 
          [0, 40, 210, 80, 210, ], 
          [0, 40, 210, 210, 210, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 250, 250, 250, 240, ], 
          [0, 220, 220, 220, 140, ], 
          [0, 140, 200, 140, 60, ], 
          [0, 220, 220, 220, 140, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 220, 220, 220, 140, ], 
          [0, 220, 220, 220, 140, ], 
          [0, 220, 220, 220, 140, ], 
          [0, 220, 220, 220, 140, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 180, 240, 180, 100, ], 
          [0, 220, 220, 220, 140, ], 
          [0, 90, 90, 90, 140, ], 
          [0, 220, 220, 220, 140, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 220, 220, 220, 140, ], 
          [0, 220, 220, 220, 140, ], 
          [0, 220, 220, 220, 140, ], 
          [0, 220, 220, 220, 140, ], 
        ], 
      ],
    ],
    [
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 190, 150, 40, 150, ], 
          [0, 210, 180, 70, 180, ], 
          [0, 80, 50, -60, 50, ], 
          [0, 210, 180, 70, 180, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 210, 180, 70, 180, ], 
          [0, 210, 180, 130, 180, ], 
          [0, 210, 180, 70, 180, ], 
          [0, 210, 180, 130, 180, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 240, 210, 100, 210, ], 
          [0, 210, 180, 70, 180, ], 
          [0, 80, 50, 70, 50, ], 
          [0, 210, 180, 70, 180, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 210, 180, 70, 180, ], 
          [0, 210, 180, 130, 180, ], 
          [0, 210, 180, 70, 180, ], 
          [0, 270, 180, 70, 180, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 150, 150, 150, 160, ], 
          [0, 190, 190, 190, 190, ], 
          [0, 50, 110, 50, 120, ], 
          [0, 190, 190, 190, 190, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 190, 190, 190, 190, ], 
          [0, 190, 190, 190, 190, ], 
          [0, 190, 190, 190, 190, ], 
          [0, 190, 190, 190, 190, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 220, 280, 220, 280, ], 
          [0, 190, 190, 190, 190, ], 
          [0, 60, 60, 60, 60, ], 
          [0, 190, 190, 190, 190, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 190, 190, 190, 190, ], 
          [0, 190, 190, 190, 190, ], 
          [0, 190, 190, 190, 190, ], 
          [0, 190, 190, 190, 190, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, -20, 150, 10, 150, ], 
          [0, 10, 180, 50, 180, ], 
          [0, -120, 50, 40, 50, ], 
          [0, 10, 180, 50, 180, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 10, 180, 50, 180, ], 
          [0, 70, 180, 50, 180, ], 
          [0, 10, 180, 50, 180, ], 
          [0, 70, 180, 50, 180, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 40, 210, 210, 210, ], 
          [0, 10, 180, 50, 180, ], 
          [0, 10, 50, 180, 50, ], 
          [0, 10, 180, 50, 180, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 10, 180, 50, 180, ], 
          [0, 70, 180, 50, 180, ], 
          [0, 10, 180, 50, 180, ], 
          [0, 10, 180, 180, 180, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 150, 150, 150, 140, ], 
          [0, 190, 190, 190, 110, ], 
          [0, 50, 110, 50, -20, ], 
          [0, 190, 190, 190, 110, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 190, 190, 190, 110, ], 
          [0, 190, 190, 190, 110, ], 
          [0, 190, 190, 190, 110, ], 
          [0, 190, 190, 190, 110, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 220, 280, 220, 140, ], 
          [0, 190, 190, 190, 110, ], 
          [0, 60, 60, 60, 110, ], 
          [0, 190, 190, 190, 110, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 190, 190, 190, 110, ], 
          [0, 190, 190, 190, 110, ], 
          [0, 190, 190, 190, 110, ], 
          [0, 190, 190, 190, 110, ], 
        ], 
      ],
    ],
    [
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 210, 180, 70, 180, ], 
          [0, 190, 160, 50, 160, ], 
          [0, 90, 60, -50, 60, ], 
          [0, 190, 160, 50, 160, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 200, 170, 60, 170, ], 
          [0, 190, 160, 110, 160, ], 
          [0, 200, 170, 60, 170, ], 
          [0, 190, 160, 110, 160, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 160, 130, 20, 130, ], 
          [0, 190, 160, 50, 160, ], 
          [0, 40, 10, 30, 10, ], 
          [0, 190, 160, 50, 160, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 200, 170, 60, 170, ], 
          [0, 190, 160, 110, 160, ], 
          [0, 200, 170, 60, 170, ], 
          [0, 160, 70, -30, 70, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 190, 190, 190, 190, ], 
          [0, 160, 160, 160, 170, ], 
          [0, 60, 120, 60, 130, ], 
          [0, 160, 160, 160, 170, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 170, 170, 170, 180, ], 
          [0, 170, 170, 170, 170, ], 
          [0, 170, 170, 170, 180, ], 
          [0, 170, 170, 170, 170, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 130, 190, 130, 200, ], 
          [0, 160, 160, 160, 170, ], 
          [0, 10, 10, 10, 20, ], 
          [0, 160, 160, 160, 170, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 170, 170, 170, 180, ], 
          [0, 170, 170, 170, 170, ], 
          [0, 170, 170, 170, 180, ], 
          [0, 80, 80, 80, 80, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 10, 180, 50, 180, ], 
          [0, -10, 160, 20, 160, ], 
          [0, -110, 60, 50, 60, ], 
          [0, -10, 160, 20, 160, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 170, 30, 170, ], 
          [0, 50, 160, 30, 160, ], 
          [0, 0, 170, 30, 170, ], 
          [0, 50, 160, 30, 160, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, -40, 130, 120, 130, ], 
          [0, -10, 160, 20, 160, ], 
          [0, -30, 10, 130, 10, ], 
          [0, -10, 160, 20, 160, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 170, 30, 170, ], 
          [0, 50, 160, 30, 160, ], 
          [0, 0, 170, 30, 170, ], 
          [0, -100, 70, 70, 70, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 190, 190, 190, 170, ], 
          [0, 160, 160, 160, 90, ], 
          [0, 60, 120, 60, -10, ], 
          [0, 160, 160, 160, 90, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 170, 170, 170, 100, ], 
          [0, 170, 170, 170, 90, ], 
          [0, 170, 170, 170, 100, ], 
          [0, 170, 170, 170, 90, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 130, 190, 130, 60, ], 
          [0, 160, 160, 160, 90, ], 
          [0, 10, 10, 10, 70, ], 
          [0, 160, 160, 160, 90, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 170, 170, 170, 100, ], 
          [0, 170, 170, 170, 90, ], 
          [0, 170, 170, 170, 100, ], 
          [0, 80, 80, 80, 0, ], 
        ], 
      ],
    ],
    [
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 210, 180, 70, 180, ], 
          [0, 170, 140, 30, 140, ], 
          [0, 110, 80, -30, 80, ], 
          [0, 170, 140, 30, 140, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 210, 180, 70, 180, ], 
          [0, 210, 180, 130, 180, ], 
          [0, 210, 180, 70, 180, ], 
          [0, 210, 180, 130, 180, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 120, 90, -20, 90, ], 
          [0, 170, 140, 30, 140, ], 
          [0, 60, 30, 50, 30, ], 
          [0, 170, 140, 30, 140, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 210, 180, 70, 180, ], 
          [0, 180, 150, 100, 150, ], 
          [0, 210, 180, 70, 180, ], 
          [0, 190, 100, -10, 100, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 190, 190, 190, 190, ], 
          [0, 140, 140, 140, 150, ], 
          [0, 80, 140, 80, 150, ], 
          [0, 140, 140, 140, 150, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 190, 190, 190, 190, ], 
          [0, 190, 190, 190, 190, ], 
          [0, 190, 190, 190, 190, ], 
          [0, 190, 190, 190, 190, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 90, 150, 90, 160, ], 
          [0, 140, 140, 140, 150, ], 
          [0, 30, 30, 30, 40, ], 
          [0, 140, 140, 140, 150, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 190, 190, 190, 190, ], 
          [0, 160, 160, 160, 160, ], 
          [0, 190, 190, 190, 190, ], 
          [0, 100, 100, 100, 110, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 10, 180, 50, 180, ], 
          [0, -30, 140, 0, 140, ], 
          [0, -90, 80, 70, 80, ], 
          [0, -30, 140, 0, 140, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 10, 180, 50, 180, ], 
          [0, 70, 180, 50, 180, ], 
          [0, 10, 180, 50, 180, ], 
          [0, 70, 180, 50, 180, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, -80, 90, 80, 90, ], 
          [0, -30, 140, 0, 140, ], 
          [0, -10, 30, 150, 30, ], 
          [0, -30, 140, 0, 140, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 10, 180, 50, 180, ], 
          [0, 40, 150, 20, 150, ], 
          [0, 10, 180, 50, 180, ], 
          [0, -70, 100, 90, 100, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 190, 190, 190, 170, ], 
          [0, 140, 140, 140, 70, ], 
          [0, 80, 140, 80, 10, ], 
          [0, 140, 140, 140, 70, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 190, 190, 190, 110, ], 
          [0, 190, 190, 190, 110, ], 
          [0, 190, 190, 190, 110, ], 
          [0, 190, 190, 190, 110, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 90, 150, 90, 20, ], 
          [0, 140, 140, 140, 70, ], 
          [0, 30, 30, 30, 90, ], 
          [0, 140, 140, 140, 70, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 190, 190, 190, 110, ], 
          [0, 160, 160, 160, 80, ], 
          [0, 190, 190, 190, 110, ], 
          [0, 100, 100, 100, 30, ], 
        ], 
      ],
    ],
  ],
  [
    [
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
    ],
    [
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 270, 230, 190, 230, ], 
          [0, 260, 220, 180, 220, ], 
          [0, 170, 130, 90, 130, ], 
          [0, 260, 220, 180, 220, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 300, 270, 230, 270, ], 
          [0, 290, 250, 270, 250, ], 
          [0, 300, 270, 230, 270, ], 
          [0, 270, 240, 260, 240, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 170, 130, 90, 130, ], 
          [0, 260, 220, 180, 220, ], 
          [0, 110, 80, 170, 80, ], 
          [0, 260, 220, 180, 220, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 300, 270, 230, 270, ], 
          [0, 270, 240, 260, 240, ], 
          [0, 300, 270, 230, 270, ], 
          [0, 240, 150, 110, 150, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 230, 230, 230, 230, ], 
          [0, 220, 220, 220, 220, ], 
          [0, 130, 190, 130, 190, ], 
          [0, 220, 220, 220, 220, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 270, 270, 270, 270, ], 
          [0, 250, 250, 250, 250, ], 
          [0, 270, 270, 270, 270, ], 
          [0, 240, 240, 240, 240, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 130, 190, 130, 190, ], 
          [0, 220, 220, 220, 220, ], 
          [0, 80, 80, 80, 80, ], 
          [0, 220, 220, 220, 220, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 270, 270, 270, 270, ], 
          [0, 240, 240, 240, 240, ], 
          [0, 270, 270, 270, 270, ], 
          [0, 150, 150, 150, 150, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 150, 230, 100, 230, ], 
          [0, 140, 220, 90, 220, ], 
          [0, 50, 130, 130, 130, ], 
          [0, 140, 220, 90, 220, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 190, 270, 140, 270, ], 
          [0, 230, 250, 120, 250, ], 
          [0, 190, 270, 140, 270, ], 
          [0, 220, 240, 110, 240, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 50, 130, 130, 130, ], 
          [0, 140, 220, 90, 220, ], 
          [0, 130, 80, 210, 80, ], 
          [0, 140, 220, 90, 220, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 190, 270, 140, 270, ], 
          [0, 220, 240, 110, 240, ], 
          [0, 190, 270, 140, 270, ], 
          [0, 70, 150, 150, 150, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 230, 230, 230, 290, ], 
          [0, 220, 220, 220, 220, ], 
          [0, 130, 190, 130, 130, ], 
          [0, 220, 220, 220, 220, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 270, 270, 270, 270, ], 
          [0, 250, 250, 250, 250, ], 
          [0, 270, 270, 270, 270, ], 
          [0, 240, 240, 240, 240, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 130, 190, 130, 130, ], 
          [0, 220, 220, 220, 220, ], 
          [0, 80, 80, 80, 210, ], 
          [0, 220, 220, 220, 220, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 270, 270, 270, 270, ], 
          [0, 240, 240, 240, 240, ], 
          [0, 270, 270, 270, 270, ], 
          [0, 150, 150, 150, 150, ], 
        ], 
      ],
    ],
    [
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 280, 240, 200, 240, ], 
          [0, 250, 220, 180, 220, ], 
          [0, 70, 40, 0, 40, ], 
          [0, 250, 220, 180, 220, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 250, 210, 170, 210, ], 
          [0, 250, 220, 240, 220, ], 
          [0, 250, 210, 170, 210, ], 
          [0, 250, 220, 240, 220, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 140, 100, 60, 100, ], 
          [0, 250, 220, 180, 220, ], 
          [0, 110, 80, 170, 80, ], 
          [0, 250, 220, 180, 220, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 250, 210, 170, 210, ], 
          [0, 260, 220, 240, 220, ], 
          [0, 250, 210, 170, 210, ], 
          [0, 240, 140, 100, 140, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 240, 240, 240, 240, ], 
          [0, 220, 220, 220, 220, ], 
          [0, 40, 100, 40, 100, ], 
          [0, 220, 220, 220, 220, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 210, 210, 210, 210, ], 
          [0, 220, 220, 220, 220, ], 
          [0, 210, 210, 210, 210, ], 
          [0, 220, 220, 220, 220, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 100, 160, 100, 160, ], 
          [0, 220, 220, 220, 220, ], 
          [0, 80, 80, 80, 80, ], 
          [0, 220, 220, 220, 220, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 210, 210, 210, 210, ], 
          [0, 220, 220, 220, 220, ], 
          [0, 210, 210, 210, 210, ], 
          [0, 140, 140, 140, 140, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 160, 240, 110, 240, ], 
          [0, 140, 220, 90, 220, ], 
          [0, -40, 40, 40, 40, ], 
          [0, 140, 220, 90, 220, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 130, 210, 80, 210, ], 
          [0, 200, 220, 90, 220, ], 
          [0, 130, 210, 80, 210, ], 
          [0, 200, 220, 90, 220, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 20, 100, 100, 100, ], 
          [0, 140, 220, 90, 220, ], 
          [0, 130, 80, 210, 80, ], 
          [0, 140, 220, 90, 220, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 130, 210, 80, 210, ], 
          [0, 200, 220, 90, 220, ], 
          [0, 130, 210, 80, 210, ], 
          [0, 60, 140, 140, 140, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 240, 240, 240, 300, ], 
          [0, 220, 220, 220, 220, ], 
          [0, 40, 100, 40, 40, ], 
          [0, 220, 220, 220, 220, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 210, 210, 210, 210, ], 
          [0, 220, 220, 220, 220, ], 
          [0, 210, 210, 210, 210, ], 
          [0, 220, 220, 220, 220, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 100, 160, 100, 100, ], 
          [0, 220, 220, 220, 220, ], 
          [0, 80, 80, 80, 210, ], 
          [0, 220, 220, 220, 220, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 210, 210, 210, 210, ], 
          [0, 220, 220, 220, 220, ], 
          [0, 210, 210, 210, 210, ], 
          [0, 140, 140, 140, 140, ], 
        ], 
      ],
    ],
    [
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 410, 370, 330, 370, ], 
          [0, 370, 340, 300, 340, ], 
          [0, 290, 260, 220, 260, ], 
          [0, 370, 340, 300, 340, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 370, 340, 300, 340, ], 
          [0, 370, 340, 360, 340, ], 
          [0, 370, 340, 300, 340, ], 
          [0, 370, 340, 360, 340, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 330, 300, 260, 300, ], 
          [0, 370, 340, 300, 340, ], 
          [0, 240, 210, 300, 210, ], 
          [0, 370, 340, 300, 340, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 370, 340, 300, 340, ], 
          [0, 370, 340, 360, 340, ], 
          [0, 370, 340, 300, 340, ], 
          [0, 430, 340, 300, 340, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 370, 370, 370, 370, ], 
          [0, 340, 340, 340, 340, ], 
          [0, 260, 320, 260, 320, ], 
          [0, 340, 340, 340, 340, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 340, 340, 340, 340, ], 
          [0, 340, 340, 340, 340, ], 
          [0, 340, 340, 340, 340, ], 
          [0, 340, 340, 340, 340, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 300, 360, 300, 360, ], 
          [0, 340, 340, 340, 340, ], 
          [0, 210, 210, 210, 210, ], 
          [0, 340, 340, 340, 340, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 340, 340, 340, 340, ], 
          [0, 340, 340, 340, 340, ], 
          [0, 340, 340, 340, 340, ], 
          [0, 340, 340, 340, 340, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 290, 370, 240, 370, ], 
          [0, 260, 340, 210, 340, ], 
          [0, 180, 260, 260, 260, ], 
          [0, 260, 340, 210, 340, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 260, 340, 210, 340, ], 
          [0, 320, 340, 210, 340, ], 
          [0, 260, 340, 210, 340, ], 
          [0, 320, 340, 210, 340, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 220, 300, 300, 300, ], 
          [0, 260, 340, 210, 340, ], 
          [0, 260, 210, 340, 210, ], 
          [0, 260, 340, 210, 340, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 260, 340, 210, 340, ], 
          [0, 320, 340, 210, 340, ], 
          [0, 260, 340, 210, 340, ], 
          [0, 260, 340, 340, 340, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 370, 370, 370, 430, ], 
          [0, 340, 340, 340, 340, ], 
          [0, 260, 320, 260, 260, ], 
          [0, 340, 340, 340, 340, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 340, 340, 340, 340, ], 
          [0, 340, 340, 340, 340, ], 
          [0, 340, 340, 340, 340, ], 
          [0, 340, 340, 340, 340, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 300, 360, 300, 300, ], 
          [0, 340, 340, 340, 340, ], 
          [0, 210, 210, 210, 340, ], 
          [0, 340, 340, 340, 340, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 340, 340, 340, 340, ], 
          [0, 340, 340, 340, 340, ], 
          [0, 340, 340, 340, 340, ], 
          [0, 340, 340, 340, 340, ], 
        ], 
      ],
    ],
    [
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 360, 270, 360, 270, ], 
          [0, 340, 310, 270, 310, ], 
          [0, 220, 170, 130, 170, ], 
          [0, 340, 310, 270, 310, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 340, 310, 270, 310, ], 
          [0, 340, 310, 330, 310, ], 
          [0, 340, 310, 270, 310, ], 
          [0, 340, 310, 330, 310, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 370, 340, 300, 340, ], 
          [0, 340, 310, 270, 310, ], 
          [0, 210, 180, 270, 180, ], 
          [0, 340, 310, 270, 310, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 340, 310, 270, 310, ], 
          [0, 340, 310, 330, 310, ], 
          [0, 340, 310, 270, 310, ], 
          [0, 400, 310, 270, 310, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 270, 270, 270, 270, ], 
          [0, 310, 310, 310, 310, ], 
          [0, 170, 230, 170, 230, ], 
          [0, 310, 310, 310, 310, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 310, 310, 310, 310, ], 
          [0, 310, 310, 310, 310, ], 
          [0, 310, 310, 310, 310, ], 
          [0, 310, 310, 310, 310, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 340, 400, 340, 400, ], 
          [0, 310, 310, 310, 310, ], 
          [0, 180, 180, 180, 180, ], 
          [0, 310, 310, 310, 310, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 310, 310, 310, 310, ], 
          [0, 310, 310, 310, 310, ], 
          [0, 310, 310, 310, 310, ], 
          [0, 310, 310, 310, 310, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 190, 270, 140, 270, ], 
          [0, 230, 310, 180, 310, ], 
          [0, 20, 170, 170, 170, ], 
          [0, 230, 310, 180, 310, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 230, 310, 180, 310, ], 
          [0, 290, 310, 180, 310, ], 
          [0, 230, 310, 180, 310, ], 
          [0, 290, 310, 180, 310, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 260, 340, 340, 340, ], 
          [0, 230, 310, 180, 310, ], 
          [0, 230, 180, 310, 180, ], 
          [0, 230, 310, 180, 310, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 230, 310, 180, 310, ], 
          [0, 290, 310, 180, 310, ], 
          [0, 230, 310, 180, 310, ], 
          [0, 230, 310, 310, 310, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 270, 270, 270, 330, ], 
          [0, 310, 310, 310, 310, ], 
          [0, 170, 230, 170, 170, ], 
          [0, 310, 310, 310, 310, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 310, 310, 310, 310, ], 
          [0, 310, 310, 310, 310, ], 
          [0, 310, 310, 310, 310, ], 
          [0, 310, 310, 310, 310, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 340, 400, 340, 340, ], 
          [0, 310, 310, 310, 310, ], 
          [0, 180, 180, 180, 310, ], 
          [0, 310, 310, 310, 310, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 310, 310, 310, 310, ], 
          [0, 310, 310, 310, 310, ], 
          [0, 310, 310, 310, 310, ], 
          [0, 310, 310, 310, 310, ], 
        ], 
      ],
    ],
    [
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 340, 310, 270, 310, ], 
          [0, 320, 280, 240, 280, ], 
          [0, 220, 180, 140, 180, ], 
          [0, 320, 280, 240, 280, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 330, 290, 250, 290, ], 
          [0, 320, 290, 310, 290, ], 
          [0, 330, 290, 250, 290, ], 
          [0, 320, 290, 310, 290, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 290, 250, 210, 250, ], 
          [0, 320, 280, 240, 280, ], 
          [0, 170, 130, 220, 130, ], 
          [0, 320, 280, 240, 280, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 330, 290, 250, 290, ], 
          [0, 320, 290, 310, 290, ], 
          [0, 330, 290, 250, 290, ], 
          [0, 290, 200, 160, 200, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 310, 310, 310, 310, ], 
          [0, 280, 280, 280, 280, ], 
          [0, 180, 240, 180, 240, ], 
          [0, 280, 280, 280, 280, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 290, 290, 290, 290, ], 
          [0, 290, 290, 290, 290, ], 
          [0, 290, 290, 290, 290, ], 
          [0, 290, 290, 290, 290, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 250, 310, 250, 310, ], 
          [0, 280, 280, 280, 280, ], 
          [0, 130, 130, 130, 130, ], 
          [0, 280, 280, 280, 280, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 290, 290, 290, 290, ], 
          [0, 290, 290, 290, 290, ], 
          [0, 290, 290, 290, 290, ], 
          [0, 200, 200, 200, 200, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 230, 310, 180, 310, ], 
          [0, 200, 280, 150, 280, ], 
          [0, 100, 180, 180, 180, ], 
          [0, 200, 280, 150, 280, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 210, 290, 160, 290, ], 
          [0, 270, 290, 160, 290, ], 
          [0, 210, 290, 160, 290, ], 
          [0, 270, 290, 160, 290, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 170, 250, 250, 250, ], 
          [0, 200, 280, 150, 280, ], 
          [0, 180, 130, 260, 130, ], 
          [0, 200, 280, 150, 280, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 210, 290, 160, 290, ], 
          [0, 270, 290, 160, 290, ], 
          [0, 210, 290, 160, 290, ], 
          [0, 120, 200, 200, 200, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 310, 310, 310, 370, ], 
          [0, 280, 280, 280, 280, ], 
          [0, 180, 240, 180, 180, ], 
          [0, 280, 280, 280, 280, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 290, 290, 290, 290, ], 
          [0, 290, 290, 290, 290, ], 
          [0, 290, 290, 290, 290, ], 
          [0, 290, 290, 290, 290, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 250, 310, 250, 250, ], 
          [0, 280, 280, 280, 280, ], 
          [0, 130, 130, 130, 260, ], 
          [0, 280, 280, 280, 280, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 290, 290, 290, 290, ], 
          [0, 290, 290, 290, 290, ], 
          [0, 290, 290, 290, 290, ], 
          [0, 200, 200, 200, 200, ], 
        ], 
      ],
    ],
    [
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 340, 310, 270, 310, ], 
          [0, 300, 260, 220, 260, ], 
          [0, 240, 200, 160, 200, ], 
          [0, 300, 260, 220, 260, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 340, 310, 270, 310, ], 
          [0, 340, 310, 330, 310, ], 
          [0, 340, 310, 270, 310, ], 
          [0, 340, 310, 330, 310, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 250, 210, 170, 210, ], 
          [0, 300, 260, 220, 260, ], 
          [0, 190, 150, 240, 150, ], 
          [0, 300, 260, 220, 260, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 340, 310, 270, 310, ], 
          [0, 310, 280, 300, 280, ], 
          [0, 340, 310, 270, 310, ], 
          [0, 320, 220, 180, 220, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 310, 310, 310, 310, ], 
          [0, 260, 260, 260, 260, ], 
          [0, 200, 260, 200, 260, ], 
          [0, 260, 260, 260, 260, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 310, 310, 310, 310, ], 
          [0, 310, 310, 310, 310, ], 
          [0, 310, 310, 310, 310, ], 
          [0, 310, 310, 310, 310, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 210, 270, 210, 270, ], 
          [0, 260, 260, 260, 260, ], 
          [0, 150, 150, 150, 150, ], 
          [0, 260, 260, 260, 260, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 310, 310, 310, 310, ], 
          [0, 280, 280, 280, 280, ], 
          [0, 310, 310, 310, 310, ], 
          [0, 220, 220, 220, 220, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 230, 310, 180, 310, ], 
          [0, 180, 260, 130, 260, ], 
          [0, 120, 200, 200, 200, ], 
          [0, 180, 260, 130, 260, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 230, 310, 180, 310, ], 
          [0, 290, 310, 180, 310, ], 
          [0, 230, 310, 180, 310, ], 
          [0, 290, 310, 180, 310, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 130, 210, 210, 210, ], 
          [0, 180, 260, 130, 260, ], 
          [0, 200, 150, 280, 150, ], 
          [0, 180, 260, 130, 260, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 230, 310, 180, 310, ], 
          [0, 260, 280, 150, 280, ], 
          [0, 230, 310, 180, 310, ], 
          [0, 140, 220, 220, 220, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 310, 310, 310, 370, ], 
          [0, 260, 260, 260, 260, ], 
          [0, 200, 260, 200, 200, ], 
          [0, 260, 260, 260, 260, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 310, 310, 310, 310, ], 
          [0, 310, 310, 310, 310, ], 
          [0, 310, 310, 310, 310, ], 
          [0, 310, 310, 310, 310, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 210, 270, 210, 210, ], 
          [0, 260, 260, 260, 260, ], 
          [0, 150, 150, 150, 280, ], 
          [0, 260, 260, 260, 260, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 310, 310, 310, 310, ], 
          [0, 280, 280, 280, 280, ], 
          [0, 310, 310, 310, 310, ], 
          [0, 220, 220, 220, 220, ], 
        ], 
      ],
    ],
  ],
  [
    [
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
    ],
    [
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 160, 200, 230, 200, ], 
          [0, 160, 190, 220, 190, ], 
          [0, 70, 100, 130, 100, ], 
          [0, 160, 190, 220, 190, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 200, 240, 270, 240, ], 
          [0, 190, 220, 310, 220, ], 
          [0, 200, 240, 270, 240, ], 
          [0, 170, 210, 300, 210, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 70, 100, 130, 100, ], 
          [0, 160, 190, 220, 190, ], 
          [0, 10, 50, 210, 50, ], 
          [0, 160, 190, 220, 190, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 200, 240, 270, 240, ], 
          [0, 170, 210, 300, 210, ], 
          [0, 200, 240, 270, 240, ], 
          [0, 140, 120, 150, 120, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 200, 200, 200, 200, ], 
          [0, 190, 190, 190, 190, ], 
          [0, 100, 160, 100, 160, ], 
          [0, 190, 190, 190, 190, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 240, 240, 240, 240, ], 
          [0, 220, 220, 220, 220, ], 
          [0, 240, 240, 240, 240, ], 
          [0, 210, 210, 210, 210, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 100, 160, 100, 160, ], 
          [0, 190, 190, 190, 190, ], 
          [0, 50, 50, 50, 50, ], 
          [0, 190, 190, 190, 190, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 240, 240, 240, 240, ], 
          [0, 210, 210, 210, 210, ], 
          [0, 240, 240, 240, 240, ], 
          [0, 120, 120, 120, 120, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 60, 200, 70, 200, ], 
          [0, 60, 190, 60, 190, ], 
          [0, -30, 100, 100, 100, ], 
          [0, 60, 190, 60, 190, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 100, 240, 110, 240, ], 
          [0, 150, 220, 90, 220, ], 
          [0, 100, 240, 110, 240, ], 
          [0, 130, 210, 80, 210, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, -30, 100, 100, 100, ], 
          [0, 60, 190, 60, 190, ], 
          [0, 40, 50, 180, 50, ], 
          [0, 60, 190, 60, 190, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 100, 240, 110, 240, ], 
          [0, 130, 210, 80, 210, ], 
          [0, 100, 240, 110, 240, ], 
          [0, -10, 120, 120, 120, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 200, 200, 200, 260, ], 
          [0, 190, 190, 190, 190, ], 
          [0, 100, 160, 100, 100, ], 
          [0, 190, 190, 190, 190, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 240, 240, 240, 240, ], 
          [0, 220, 220, 220, 220, ], 
          [0, 240, 240, 240, 240, ], 
          [0, 210, 210, 210, 210, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 100, 160, 100, 100, ], 
          [0, 190, 190, 190, 190, ], 
          [0, 50, 50, 50, 180, ], 
          [0, 190, 190, 190, 190, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 240, 240, 240, 240, ], 
          [0, 210, 210, 210, 210, ], 
          [0, 240, 240, 240, 240, ], 
          [0, 120, 120, 120, 120, ], 
        ], 
      ],
    ],
    [
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 190, 210, 240, 210, ], 
          [0, 150, 190, 220, 190, ], 
          [0, -20, 10, 40, 10, ], 
          [0, 150, 190, 220, 190, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 150, 180, 210, 180, ], 
          [0, 150, 190, 280, 190, ], 
          [0, 150, 180, 210, 180, ], 
          [0, 150, 190, 280, 190, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 40, 70, 100, 70, ], 
          [0, 150, 190, 220, 190, ], 
          [0, 10, 50, 210, 50, ], 
          [0, 150, 190, 220, 190, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 150, 180, 210, 180, ], 
          [0, 160, 190, 280, 190, ], 
          [0, 150, 180, 210, 180, ], 
          [0, 140, 110, 140, 110, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 210, 210, 210, 210, ], 
          [0, 190, 190, 190, 190, ], 
          [0, 10, 70, 10, 70, ], 
          [0, 190, 190, 190, 190, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 180, 180, 180, 180, ], 
          [0, 190, 190, 190, 190, ], 
          [0, 180, 180, 180, 180, ], 
          [0, 190, 190, 190, 190, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 70, 130, 70, 130, ], 
          [0, 190, 190, 190, 190, ], 
          [0, 50, 50, 50, 50, ], 
          [0, 190, 190, 190, 190, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 180, 180, 180, 180, ], 
          [0, 190, 190, 190, 190, ], 
          [0, 180, 180, 180, 180, ], 
          [0, 110, 110, 110, 110, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 80, 210, 80, 210, ], 
          [0, 50, 190, 60, 190, ], 
          [0, -120, 10, 10, 10, ], 
          [0, 50, 190, 60, 190, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 50, 180, 50, 180, ], 
          [0, 110, 190, 60, 190, ], 
          [0, 50, 180, 50, 180, ], 
          [0, 110, 190, 60, 190, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, -60, 70, 70, 70, ], 
          [0, 50, 190, 60, 190, ], 
          [0, 40, 50, 180, 50, ], 
          [0, 50, 190, 60, 190, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 50, 180, 50, 180, ], 
          [0, 120, 190, 60, 190, ], 
          [0, 50, 180, 50, 180, ], 
          [0, -20, 110, 110, 110, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 210, 210, 210, 270, ], 
          [0, 190, 190, 190, 190, ], 
          [0, 10, 70, 10, 10, ], 
          [0, 190, 190, 190, 190, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 180, 180, 180, 180, ], 
          [0, 190, 190, 190, 190, ], 
          [0, 180, 180, 180, 180, ], 
          [0, 190, 190, 190, 190, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 70, 130, 70, 70, ], 
          [0, 190, 190, 190, 190, ], 
          [0, 50, 50, 50, 180, ], 
          [0, 190, 190, 190, 190, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 180, 180, 180, 180, ], 
          [0, 190, 190, 190, 190, ], 
          [0, 180, 180, 180, 180, ], 
          [0, 110, 110, 110, 110, ], 
        ], 
      ],
    ],
    [
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 360, 340, 370, 340, ], 
          [0, 270, 310, 340, 310, ], 
          [0, 190, 230, 260, 230, ], 
          [0, 270, 310, 340, 310, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 270, 310, 340, 310, ], 
          [0, 270, 310, 400, 310, ], 
          [0, 270, 310, 340, 310, ], 
          [0, 270, 310, 400, 310, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 360, 270, 300, 270, ], 
          [0, 270, 310, 340, 310, ], 
          [0, 140, 180, 340, 180, ], 
          [0, 270, 310, 340, 310, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 270, 310, 340, 310, ], 
          [0, 270, 310, 400, 310, ], 
          [0, 270, 310, 340, 310, ], 
          [0, 330, 310, 340, 310, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 340, 340, 340, 340, ], 
          [0, 310, 310, 310, 310, ], 
          [0, 230, 290, 230, 290, ], 
          [0, 310, 310, 310, 310, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 310, 310, 310, 310, ], 
          [0, 310, 310, 310, 310, ], 
          [0, 310, 310, 310, 310, ], 
          [0, 310, 310, 310, 310, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 270, 330, 270, 330, ], 
          [0, 310, 310, 310, 310, ], 
          [0, 180, 180, 180, 180, ], 
          [0, 310, 310, 310, 310, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 310, 310, 310, 310, ], 
          [0, 310, 310, 310, 310, ], 
          [0, 310, 310, 310, 310, ], 
          [0, 310, 310, 310, 310, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 220, 340, 210, 340, ], 
          [0, 170, 310, 180, 310, ], 
          [0, 20, 230, 230, 230, ], 
          [0, 170, 310, 180, 310, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 170, 310, 180, 310, ], 
          [0, 230, 310, 180, 310, ], 
          [0, 170, 310, 180, 310, ], 
          [0, 230, 310, 180, 310, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 130, 270, 270, 270, ], 
          [0, 170, 310, 180, 310, ], 
          [0, 170, 180, 310, 180, ], 
          [0, 170, 310, 180, 310, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 170, 310, 180, 310, ], 
          [0, 230, 310, 180, 310, ], 
          [0, 170, 310, 180, 310, ], 
          [0, 170, 310, 310, 310, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 340, 340, 340, 400, ], 
          [0, 310, 310, 310, 310, ], 
          [0, 230, 290, 230, 230, ], 
          [0, 310, 310, 310, 310, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 310, 310, 310, 310, ], 
          [0, 310, 310, 310, 310, ], 
          [0, 310, 310, 310, 310, ], 
          [0, 310, 310, 310, 310, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 270, 330, 270, 270, ], 
          [0, 310, 310, 310, 310, ], 
          [0, 180, 180, 180, 310, ], 
          [0, 310, 310, 310, 310, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 310, 310, 310, 310, ], 
          [0, 310, 310, 310, 310, ], 
          [0, 310, 310, 310, 310, ], 
          [0, 310, 310, 310, 310, ], 
        ], 
      ],
    ],
    [
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 210, 240, 270, 240, ], 
          [0, 240, 280, 310, 280, ], 
          [0, 110, 140, 170, 140, ], 
          [0, 240, 280, 310, 280, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 240, 280, 310, 280, ], 
          [0, 240, 280, 370, 280, ], 
          [0, 240, 280, 310, 280, ], 
          [0, 240, 280, 370, 280, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 270, 310, 340, 310, ], 
          [0, 240, 280, 310, 280, ], 
          [0, 110, 150, 310, 150, ], 
          [0, 240, 280, 310, 280, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 240, 280, 310, 280, ], 
          [0, 240, 280, 370, 280, ], 
          [0, 240, 280, 310, 280, ], 
          [0, 300, 280, 310, 280, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 240, 240, 240, 240, ], 
          [0, 280, 280, 280, 280, ], 
          [0, 140, 200, 140, 200, ], 
          [0, 280, 280, 280, 280, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 280, 280, 280, 280, ], 
          [0, 280, 280, 280, 280, ], 
          [0, 280, 280, 280, 280, ], 
          [0, 280, 280, 280, 280, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 310, 370, 310, 370, ], 
          [0, 280, 280, 280, 280, ], 
          [0, 150, 150, 150, 150, ], 
          [0, 280, 280, 280, 280, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 280, 280, 280, 280, ], 
          [0, 280, 280, 280, 280, ], 
          [0, 280, 280, 280, 280, ], 
          [0, 280, 280, 280, 280, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 110, 240, 110, 240, ], 
          [0, 140, 280, 150, 280, ], 
          [0, 10, 140, 140, 140, ], 
          [0, 140, 280, 150, 280, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 140, 280, 150, 280, ], 
          [0, 200, 280, 150, 280, ], 
          [0, 140, 280, 150, 280, ], 
          [0, 200, 280, 150, 280, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 170, 310, 310, 310, ], 
          [0, 140, 280, 150, 280, ], 
          [0, 140, 150, 280, 150, ], 
          [0, 140, 280, 150, 280, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 140, 280, 150, 280, ], 
          [0, 200, 280, 150, 280, ], 
          [0, 140, 280, 150, 280, ], 
          [0, 140, 280, 280, 280, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 240, 240, 240, 300, ], 
          [0, 280, 280, 280, 280, ], 
          [0, 140, 200, 140, 140, ], 
          [0, 280, 280, 280, 280, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 280, 280, 280, 280, ], 
          [0, 280, 280, 280, 280, ], 
          [0, 280, 280, 280, 280, ], 
          [0, 280, 280, 280, 280, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 310, 370, 310, 310, ], 
          [0, 280, 280, 280, 280, ], 
          [0, 150, 150, 150, 280, ], 
          [0, 280, 280, 280, 280, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 280, 280, 280, 280, ], 
          [0, 280, 280, 280, 280, ], 
          [0, 280, 280, 280, 280, ], 
          [0, 280, 280, 280, 280, ], 
        ], 
      ],
    ],
    [
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 240, 280, 310, 280, ], 
          [0, 220, 250, 280, 250, ], 
          [0, 120, 150, 180, 150, ], 
          [0, 220, 250, 280, 250, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 230, 260, 290, 260, ], 
          [0, 220, 260, 350, 260, ], 
          [0, 230, 260, 290, 260, ], 
          [0, 220, 260, 350, 260, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 190, 220, 250, 220, ], 
          [0, 220, 250, 280, 250, ], 
          [0, 70, 100, 260, 100, ], 
          [0, 220, 250, 280, 250, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 230, 260, 290, 260, ], 
          [0, 220, 260, 350, 260, ], 
          [0, 230, 260, 290, 260, ], 
          [0, 190, 170, 200, 170, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 280, 280, 280, 280, ], 
          [0, 250, 250, 250, 250, ], 
          [0, 150, 210, 150, 210, ], 
          [0, 250, 250, 250, 250, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 260, 260, 260, 260, ], 
          [0, 260, 260, 260, 260, ], 
          [0, 260, 260, 260, 260, ], 
          [0, 260, 260, 260, 260, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 220, 280, 220, 280, ], 
          [0, 250, 250, 250, 250, ], 
          [0, 100, 100, 100, 100, ], 
          [0, 250, 250, 250, 250, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 260, 260, 260, 260, ], 
          [0, 260, 260, 260, 260, ], 
          [0, 260, 260, 260, 260, ], 
          [0, 170, 170, 170, 170, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 140, 280, 150, 280, ], 
          [0, 120, 250, 120, 250, ], 
          [0, 20, 150, 150, 150, ], 
          [0, 120, 250, 120, 250, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 130, 260, 130, 260, ], 
          [0, 180, 260, 130, 260, ], 
          [0, 130, 260, 130, 260, ], 
          [0, 180, 260, 130, 260, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 90, 220, 220, 220, ], 
          [0, 120, 250, 120, 250, ], 
          [0, 100, 100, 230, 100, ], 
          [0, 120, 250, 120, 250, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 130, 260, 130, 260, ], 
          [0, 180, 260, 130, 260, ], 
          [0, 130, 260, 130, 260, ], 
          [0, 30, 170, 170, 170, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 280, 280, 280, 340, ], 
          [0, 250, 250, 250, 250, ], 
          [0, 150, 210, 150, 150, ], 
          [0, 250, 250, 250, 250, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 260, 260, 260, 260, ], 
          [0, 260, 260, 260, 260, ], 
          [0, 260, 260, 260, 260, ], 
          [0, 260, 260, 260, 260, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 220, 280, 220, 220, ], 
          [0, 250, 250, 250, 250, ], 
          [0, 100, 100, 100, 230, ], 
          [0, 250, 250, 250, 250, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 260, 260, 260, 260, ], 
          [0, 260, 260, 260, 260, ], 
          [0, 260, 260, 260, 260, ], 
          [0, 170, 170, 170, 170, ], 
        ], 
      ],
    ],
    [
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 240, 280, 310, 280, ], 
          [0, 200, 230, 260, 230, ], 
          [0, 140, 170, 200, 170, ], 
          [0, 200, 230, 260, 230, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 240, 280, 310, 280, ], 
          [0, 240, 280, 370, 280, ], 
          [0, 240, 280, 310, 280, ], 
          [0, 240, 280, 370, 280, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 150, 180, 210, 180, ], 
          [0, 200, 230, 260, 230, ], 
          [0, 90, 120, 280, 120, ], 
          [0, 200, 230, 260, 230, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 240, 280, 310, 280, ], 
          [0, 210, 250, 340, 250, ], 
          [0, 240, 280, 310, 280, ], 
          [0, 220, 190, 220, 190, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 280, 280, 280, 280, ], 
          [0, 230, 230, 230, 230, ], 
          [0, 170, 230, 170, 230, ], 
          [0, 230, 230, 230, 230, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 280, 280, 280, 280, ], 
          [0, 280, 280, 280, 280, ], 
          [0, 280, 280, 280, 280, ], 
          [0, 280, 280, 280, 280, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 180, 240, 180, 240, ], 
          [0, 230, 230, 230, 230, ], 
          [0, 120, 120, 120, 120, ], 
          [0, 230, 230, 230, 230, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 280, 280, 280, 280, ], 
          [0, 250, 250, 250, 250, ], 
          [0, 280, 280, 280, 280, ], 
          [0, 190, 190, 190, 190, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 140, 280, 150, 280, ], 
          [0, 100, 230, 100, 230, ], 
          [0, 40, 170, 170, 170, ], 
          [0, 100, 230, 100, 230, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 140, 280, 150, 280, ], 
          [0, 200, 280, 150, 280, ], 
          [0, 140, 280, 150, 280, ], 
          [0, 200, 280, 150, 280, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 50, 180, 180, 180, ], 
          [0, 100, 230, 100, 230, ], 
          [0, 120, 120, 250, 120, ], 
          [0, 100, 230, 100, 230, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 140, 280, 150, 280, ], 
          [0, 170, 250, 120, 250, ], 
          [0, 140, 280, 150, 280, ], 
          [0, 60, 190, 190, 190, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 280, 280, 280, 340, ], 
          [0, 230, 230, 230, 230, ], 
          [0, 170, 230, 170, 170, ], 
          [0, 230, 230, 230, 230, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 280, 280, 280, 280, ], 
          [0, 280, 280, 280, 280, ], 
          [0, 280, 280, 280, 280, ], 
          [0, 280, 280, 280, 280, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 180, 240, 180, 180, ], 
          [0, 230, 230, 230, 230, ], 
          [0, 120, 120, 120, 250, ], 
          [0, 230, 230, 230, 230, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 280, 280, 280, 280, ], 
          [0, 250, 250, 250, 250, ], 
          [0, 280, 280, 280, 280, ], 
          [0, 190, 190, 190, 190, ], 
        ], 
      ],
    ],
  ],
  [
    [
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
    ],
    [
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 200, 180, 140, 180, ], 
          [0, 190, 180, 140, 180, ], 
          [0, 100, 90, 50, 90, ], 
          [0, 190, 180, 140, 180, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 240, 220, 180, 220, ], 
          [0, 220, 210, 230, 210, ], 
          [0, 240, 220, 180, 220, ], 
          [0, 210, 190, 210, 190, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 100, 90, 50, 90, ], 
          [0, 190, 180, 140, 180, ], 
          [0, 50, 30, 120, 30, ], 
          [0, 190, 180, 140, 180, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 240, 220, 180, 220, ], 
          [0, 210, 190, 210, 190, ], 
          [0, 240, 220, 180, 220, ], 
          [0, 180, 100, 60, 100, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 170, 180, 170, 180, ], 
          [0, 170, 170, 170, 170, ], 
          [0, 80, 140, 80, 140, ], 
          [0, 170, 170, 170, 170, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 210, 220, 210, 220, ], 
          [0, 200, 200, 200, 200, ], 
          [0, 210, 220, 210, 220, ], 
          [0, 180, 190, 180, 190, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 80, 140, 80, 140, ], 
          [0, 170, 170, 170, 170, ], 
          [0, 20, 30, 20, 30, ], 
          [0, 170, 170, 170, 170, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 210, 220, 210, 220, ], 
          [0, 180, 190, 180, 190, ], 
          [0, 210, 220, 210, 220, ], 
          [0, 90, 100, 90, 100, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 70, 180, 20, 180, ], 
          [0, 70, 180, 20, 180, ], 
          [0, -20, 90, 60, 90, ], 
          [0, 70, 180, 20, 180, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 110, 220, 60, 220, ], 
          [0, 160, 210, 50, 210, ], 
          [0, 110, 220, 60, 220, ], 
          [0, 140, 190, 30, 190, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, -20, 90, 60, 90, ], 
          [0, 70, 180, 20, 180, ], 
          [0, 50, 30, 130, 30, ], 
          [0, 70, 180, 20, 180, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 110, 220, 60, 220, ], 
          [0, 140, 190, 30, 190, ], 
          [0, 110, 220, 60, 220, ], 
          [0, 0, 100, 70, 100, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 170, 180, 170, 150, ], 
          [0, 170, 170, 170, 80, ], 
          [0, 80, 140, 80, 0, ], 
          [0, 170, 170, 170, 80, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 210, 220, 210, 130, ], 
          [0, 200, 200, 200, 110, ], 
          [0, 210, 220, 210, 130, ], 
          [0, 180, 190, 180, 100, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 80, 140, 80, 0, ], 
          [0, 170, 170, 170, 80, ], 
          [0, 20, 30, 20, 70, ], 
          [0, 170, 170, 170, 80, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 210, 220, 210, 130, ], 
          [0, 180, 190, 180, 100, ], 
          [0, 210, 220, 210, 130, ], 
          [0, 90, 100, 90, 10, ], 
        ], 
      ],
    ],
    [
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 210, 200, 160, 200, ], 
          [0, 190, 170, 130, 170, ], 
          [0, 10, 0, -40, 0, ], 
          [0, 190, 170, 130, 170, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 180, 170, 130, 170, ], 
          [0, 190, 170, 190, 170, ], 
          [0, 180, 170, 130, 170, ], 
          [0, 190, 170, 190, 170, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 70, 60, 20, 60, ], 
          [0, 190, 170, 130, 170, ], 
          [0, 50, 30, 120, 30, ], 
          [0, 190, 170, 130, 170, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 180, 170, 130, 170, ], 
          [0, 190, 180, 200, 180, ], 
          [0, 180, 170, 130, 170, ], 
          [0, 170, 100, 60, 100, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 190, 190, 190, 190, ], 
          [0, 160, 170, 160, 170, ], 
          [0, -10, 50, -10, 50, ], 
          [0, 160, 170, 160, 170, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 160, 160, 160, 160, ], 
          [0, 160, 170, 160, 170, ], 
          [0, 160, 160, 160, 160, ], 
          [0, 160, 170, 160, 170, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 50, 110, 50, 110, ], 
          [0, 160, 170, 160, 170, ], 
          [0, 20, 30, 20, 30, ], 
          [0, 160, 170, 160, 170, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 160, 160, 160, 160, ], 
          [0, 170, 170, 170, 170, ], 
          [0, 160, 160, 160, 160, ], 
          [0, 90, 90, 90, 90, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 90, 200, 40, 200, ], 
          [0, 60, 170, 10, 170, ], 
          [0, -110, 0, -30, 0, ], 
          [0, 60, 170, 10, 170, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 60, 170, 10, 170, ], 
          [0, 120, 170, 10, 170, ], 
          [0, 60, 170, 10, 170, ], 
          [0, 120, 170, 10, 170, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, -50, 60, 30, 60, ], 
          [0, 60, 170, 10, 170, ], 
          [0, 50, 30, 130, 30, ], 
          [0, 60, 170, 10, 170, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 60, 170, 10, 170, ], 
          [0, 130, 180, 20, 180, ], 
          [0, 60, 170, 10, 170, ], 
          [0, -10, 100, 70, 100, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 190, 190, 190, 160, ], 
          [0, 160, 170, 160, 80, ], 
          [0, -10, 50, -10, -100, ], 
          [0, 160, 170, 160, 80, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 160, 160, 160, 70, ], 
          [0, 160, 170, 160, 80, ], 
          [0, 160, 160, 160, 70, ], 
          [0, 160, 170, 160, 80, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 50, 110, 50, -30, ], 
          [0, 160, 170, 160, 80, ], 
          [0, 20, 30, 20, 70, ], 
          [0, 160, 170, 160, 80, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 160, 160, 160, 70, ], 
          [0, 170, 170, 170, 80, ], 
          [0, 160, 160, 160, 70, ], 
          [0, 90, 90, 90, 0, ], 
        ], 
      ],
    ],
    [
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 340, 330, 290, 330, ], 
          [0, 310, 290, 250, 290, ], 
          [0, 230, 210, 170, 210, ], 
          [0, 310, 290, 250, 290, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 310, 290, 250, 290, ], 
          [0, 310, 290, 310, 290, ], 
          [0, 310, 290, 250, 290, ], 
          [0, 310, 290, 310, 290, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 270, 250, 210, 250, ], 
          [0, 310, 290, 250, 290, ], 
          [0, 180, 160, 250, 160, ], 
          [0, 310, 290, 250, 290, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 310, 290, 250, 290, ], 
          [0, 310, 290, 310, 290, ], 
          [0, 310, 290, 250, 290, ], 
          [0, 370, 290, 250, 290, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 320, 320, 320, 320, ], 
          [0, 280, 290, 280, 290, ], 
          [0, 200, 270, 200, 270, ], 
          [0, 280, 290, 280, 290, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 280, 290, 280, 290, ], 
          [0, 280, 290, 280, 290, ], 
          [0, 280, 290, 280, 290, ], 
          [0, 280, 290, 280, 290, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 240, 310, 240, 310, ], 
          [0, 280, 290, 280, 290, ], 
          [0, 150, 160, 150, 160, ], 
          [0, 280, 290, 280, 290, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 280, 290, 280, 290, ], 
          [0, 280, 290, 280, 290, ], 
          [0, 280, 290, 280, 290, ], 
          [0, 280, 290, 280, 290, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 220, 330, 170, 330, ], 
          [0, 180, 290, 130, 290, ], 
          [0, 100, 210, 180, 210, ], 
          [0, 180, 290, 130, 290, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 180, 290, 130, 290, ], 
          [0, 240, 290, 130, 290, ], 
          [0, 180, 290, 130, 290, ], 
          [0, 240, 290, 130, 290, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 140, 250, 220, 250, ], 
          [0, 180, 290, 130, 290, ], 
          [0, 180, 160, 260, 160, ], 
          [0, 180, 290, 130, 290, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 180, 290, 130, 290, ], 
          [0, 240, 290, 130, 290, ], 
          [0, 180, 290, 130, 290, ], 
          [0, 180, 290, 260, 290, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 320, 320, 320, 290, ], 
          [0, 280, 290, 280, 200, ], 
          [0, 200, 270, 200, 120, ], 
          [0, 280, 290, 280, 200, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 280, 290, 280, 200, ], 
          [0, 280, 290, 280, 200, ], 
          [0, 280, 290, 280, 200, ], 
          [0, 280, 290, 280, 200, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 240, 310, 240, 160, ], 
          [0, 280, 290, 280, 200, ], 
          [0, 150, 160, 150, 200, ], 
          [0, 280, 290, 280, 200, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 280, 290, 280, 200, ], 
          [0, 280, 290, 280, 200, ], 
          [0, 280, 290, 280, 200, ], 
          [0, 280, 290, 280, 200, ], 
        ], 
      ],
    ],
    [
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 240, 230, 190, 230, ], 
          [0, 280, 260, 220, 260, ], 
          [0, 140, 130, 90, 130, ], 
          [0, 280, 260, 220, 260, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 280, 260, 220, 260, ], 
          [0, 280, 260, 280, 260, ], 
          [0, 280, 260, 220, 260, ], 
          [0, 280, 260, 280, 260, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 310, 290, 250, 290, ], 
          [0, 280, 260, 220, 260, ], 
          [0, 150, 130, 220, 130, ], 
          [0, 280, 260, 220, 260, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 280, 260, 220, 260, ], 
          [0, 280, 260, 280, 260, ], 
          [0, 280, 260, 220, 260, ], 
          [0, 340, 260, 220, 260, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 220, 220, 220, 220, ], 
          [0, 250, 260, 250, 260, ], 
          [0, 120, 180, 120, 180, ], 
          [0, 250, 260, 250, 260, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 250, 260, 250, 260, ], 
          [0, 250, 260, 250, 260, ], 
          [0, 250, 260, 250, 260, ], 
          [0, 250, 260, 250, 260, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 280, 350, 280, 350, ], 
          [0, 250, 260, 250, 260, ], 
          [0, 120, 130, 120, 130, ], 
          [0, 250, 260, 250, 260, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 250, 260, 250, 260, ], 
          [0, 250, 260, 250, 260, ], 
          [0, 250, 260, 250, 260, ], 
          [0, 250, 260, 250, 260, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 120, 230, 70, 230, ], 
          [0, 150, 260, 100, 260, ], 
          [0, 20, 130, 100, 130, ], 
          [0, 150, 260, 100, 260, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 150, 260, 100, 260, ], 
          [0, 210, 260, 100, 260, ], 
          [0, 150, 260, 100, 260, ], 
          [0, 210, 260, 100, 260, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 180, 290, 260, 290, ], 
          [0, 150, 260, 100, 260, ], 
          [0, 150, 130, 230, 130, ], 
          [0, 150, 260, 100, 260, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 150, 260, 100, 260, ], 
          [0, 210, 260, 100, 260, ], 
          [0, 150, 260, 100, 260, ], 
          [0, 150, 260, 230, 260, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 220, 220, 220, 190, ], 
          [0, 250, 260, 250, 170, ], 
          [0, 120, 180, 120, 30, ], 
          [0, 250, 260, 250, 170, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 250, 260, 250, 170, ], 
          [0, 250, 260, 250, 170, ], 
          [0, 250, 260, 250, 170, ], 
          [0, 250, 260, 250, 170, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 280, 350, 280, 200, ], 
          [0, 250, 260, 250, 170, ], 
          [0, 120, 130, 120, 170, ], 
          [0, 250, 260, 250, 170, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 250, 260, 250, 170, ], 
          [0, 250, 260, 250, 170, ], 
          [0, 250, 260, 250, 170, ], 
          [0, 250, 260, 250, 170, ], 
        ], 
      ],
    ],
    [
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 280, 260, 220, 260, ], 
          [0, 250, 240, 200, 240, ], 
          [0, 150, 140, 100, 140, ], 
          [0, 250, 240, 200, 240, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 260, 250, 210, 250, ], 
          [0, 260, 240, 260, 240, ], 
          [0, 260, 250, 210, 250, ], 
          [0, 260, 240, 260, 240, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 220, 210, 170, 210, ], 
          [0, 250, 240, 200, 240, ], 
          [0, 100, 90, 180, 90, ], 
          [0, 250, 240, 200, 240, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 260, 250, 210, 250, ], 
          [0, 260, 240, 260, 240, ], 
          [0, 260, 250, 210, 250, ], 
          [0, 230, 150, 110, 150, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 250, 260, 250, 260, ], 
          [0, 230, 230, 230, 230, ], 
          [0, 130, 190, 130, 190, ], 
          [0, 230, 230, 230, 230, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 240, 240, 240, 240, ], 
          [0, 230, 240, 230, 240, ], 
          [0, 240, 240, 240, 240, ], 
          [0, 230, 240, 230, 240, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 200, 260, 200, 260, ], 
          [0, 230, 230, 230, 230, ], 
          [0, 80, 80, 80, 80, ], 
          [0, 230, 230, 230, 230, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 240, 240, 240, 240, ], 
          [0, 230, 240, 230, 240, ], 
          [0, 240, 240, 240, 240, ], 
          [0, 140, 150, 140, 150, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 150, 260, 100, 260, ], 
          [0, 130, 240, 80, 240, ], 
          [0, 30, 140, 110, 140, ], 
          [0, 130, 240, 80, 240, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 140, 250, 90, 250, ], 
          [0, 190, 240, 80, 240, ], 
          [0, 140, 250, 90, 250, ], 
          [0, 190, 240, 80, 240, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 100, 210, 180, 210, ], 
          [0, 130, 240, 80, 240, ], 
          [0, 110, 90, 190, 90, ], 
          [0, 130, 240, 80, 240, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 140, 250, 90, 250, ], 
          [0, 190, 240, 80, 240, ], 
          [0, 140, 250, 90, 250, ], 
          [0, 40, 150, 120, 150, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 250, 260, 250, 230, ], 
          [0, 230, 230, 230, 140, ], 
          [0, 130, 190, 130, 40, ], 
          [0, 230, 230, 230, 140, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 240, 240, 240, 150, ], 
          [0, 230, 240, 230, 150, ], 
          [0, 240, 240, 240, 150, ], 
          [0, 230, 240, 230, 150, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 200, 260, 200, 110, ], 
          [0, 230, 230, 230, 140, ], 
          [0, 80, 80, 80, 120, ], 
          [0, 230, 230, 230, 140, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 240, 240, 240, 150, ], 
          [0, 230, 240, 230, 150, ], 
          [0, 240, 240, 240, 150, ], 
          [0, 140, 150, 140, 60, ], 
        ], 
      ],
    ],
    [
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 280, 260, 220, 260, ], 
          [0, 230, 220, 180, 220, ], 
          [0, 170, 160, 120, 160, ], 
          [0, 230, 220, 180, 220, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 280, 260, 220, 260, ], 
          [0, 280, 260, 280, 260, ], 
          [0, 280, 260, 220, 260, ], 
          [0, 280, 260, 280, 260, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 180, 170, 130, 170, ], 
          [0, 230, 220, 180, 220, ], 
          [0, 120, 110, 200, 110, ], 
          [0, 230, 220, 180, 220, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 280, 260, 220, 260, ], 
          [0, 250, 230, 250, 230, ], 
          [0, 280, 260, 220, 260, ], 
          [0, 250, 180, 140, 180, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 250, 260, 250, 260, ], 
          [0, 210, 210, 210, 210, ], 
          [0, 150, 210, 150, 210, ], 
          [0, 210, 210, 210, 210, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 250, 260, 250, 260, ], 
          [0, 250, 260, 250, 260, ], 
          [0, 250, 260, 250, 260, ], 
          [0, 250, 260, 250, 260, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 160, 220, 160, 220, ], 
          [0, 210, 210, 210, 210, ], 
          [0, 100, 100, 100, 100, ], 
          [0, 210, 210, 210, 210, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 250, 260, 250, 260, ], 
          [0, 220, 230, 220, 230, ], 
          [0, 250, 260, 250, 260, ], 
          [0, 170, 170, 170, 170, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 150, 260, 100, 260, ], 
          [0, 110, 220, 60, 220, ], 
          [0, 50, 160, 130, 160, ], 
          [0, 110, 220, 60, 220, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 150, 260, 100, 260, ], 
          [0, 210, 260, 100, 260, ], 
          [0, 150, 260, 100, 260, ], 
          [0, 210, 260, 100, 260, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 60, 170, 140, 170, ], 
          [0, 110, 220, 60, 220, ], 
          [0, 130, 110, 210, 110, ], 
          [0, 110, 220, 60, 220, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 150, 260, 100, 260, ], 
          [0, 180, 230, 70, 230, ], 
          [0, 150, 260, 100, 260, ], 
          [0, 70, 180, 150, 180, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 250, 260, 250, 230, ], 
          [0, 210, 210, 210, 120, ], 
          [0, 150, 210, 150, 60, ], 
          [0, 210, 210, 210, 120, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 250, 260, 250, 170, ], 
          [0, 250, 260, 250, 170, ], 
          [0, 250, 260, 250, 170, ], 
          [0, 250, 260, 250, 170, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 160, 220, 160, 70, ], 
          [0, 210, 210, 210, 120, ], 
          [0, 100, 100, 100, 140, ], 
          [0, 210, 210, 210, 120, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 250, 260, 250, 170, ], 
          [0, 220, 230, 220, 140, ], 
          [0, 250, 260, 250, 170, ], 
          [0, 170, 170, 170, 80, ], 
        ], 
      ],
    ],
  ],
  [
    [
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
    ],
    [
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 200, 200, 100, 200, ], 
          [0, 190, 190, 100, 190, ], 
          [0, 100, 100, 10, 100, ], 
          [0, 190, 190, 100, 190, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 240, 240, 140, 240, ], 
          [0, 220, 220, 190, 220, ], 
          [0, 240, 240, 140, 240, ], 
          [0, 210, 210, 170, 210, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 100, 100, 10, 100, ], 
          [0, 190, 190, 100, 190, ], 
          [0, 50, 50, 80, 50, ], 
          [0, 190, 190, 100, 190, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 240, 240, 140, 240, ], 
          [0, 210, 210, 170, 210, ], 
          [0, 240, 240, 140, 240, ], 
          [0, 180, 120, 20, 120, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 150, 200, 150, 170, ], 
          [0, 150, 190, 150, 160, ], 
          [0, 60, 160, 60, 130, ], 
          [0, 150, 190, 150, 160, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 190, 240, 190, 210, ], 
          [0, 180, 220, 180, 190, ], 
          [0, 190, 240, 190, 210, ], 
          [0, 160, 210, 160, 180, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 60, 160, 60, 130, ], 
          [0, 150, 190, 150, 160, ], 
          [0, 0, 50, 0, 20, ], 
          [0, 150, 190, 150, 160, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 190, 240, 190, 210, ], 
          [0, 160, 210, 160, 180, ], 
          [0, 190, 240, 190, 210, ], 
          [0, 70, 120, 70, 90, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 90, 200, 40, 200, ], 
          [0, 90, 190, 40, 190, ], 
          [0, 0, 100, 80, 100, ], 
          [0, 90, 190, 40, 190, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 130, 240, 80, 240, ], 
          [0, 180, 220, 70, 220, ], 
          [0, 130, 240, 80, 240, ], 
          [0, 160, 210, 50, 210, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 100, 80, 100, ], 
          [0, 90, 190, 40, 190, ], 
          [0, 70, 50, 150, 50, ], 
          [0, 90, 190, 40, 190, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 130, 240, 80, 240, ], 
          [0, 160, 210, 50, 210, ], 
          [0, 130, 240, 80, 240, ], 
          [0, 10, 120, 90, 120, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 150, 200, 150, 170, ], 
          [0, 150, 190, 150, 110, ], 
          [0, 60, 160, 60, 20, ], 
          [0, 150, 190, 150, 110, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 190, 240, 190, 150, ], 
          [0, 180, 220, 180, 140, ], 
          [0, 190, 240, 190, 150, ], 
          [0, 160, 210, 160, 120, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 60, 160, 60, 20, ], 
          [0, 150, 190, 150, 110, ], 
          [0, 0, 50, 0, 90, ], 
          [0, 150, 190, 150, 110, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 190, 240, 190, 150, ], 
          [0, 160, 210, 160, 120, ], 
          [0, 190, 240, 190, 150, ], 
          [0, 70, 120, 70, 30, ], 
        ], 
      ],
    ],
    [
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 210, 210, 120, 210, ], 
          [0, 190, 190, 90, 190, ], 
          [0, 10, 10, -80, 10, ], 
          [0, 190, 190, 90, 190, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 180, 180, 90, 180, ], 
          [0, 190, 190, 150, 190, ], 
          [0, 180, 180, 90, 180, ], 
          [0, 190, 190, 150, 190, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 70, 70, -20, 70, ], 
          [0, 190, 190, 90, 190, ], 
          [0, 50, 50, 80, 50, ], 
          [0, 190, 190, 90, 190, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 180, 180, 90, 180, ], 
          [0, 190, 190, 160, 190, ], 
          [0, 180, 180, 90, 180, ], 
          [0, 170, 110, 20, 110, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 170, 210, 170, 180, ], 
          [0, 140, 190, 140, 160, ], 
          [0, -30, 70, -30, 40, ], 
          [0, 140, 190, 140, 160, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 140, 180, 140, 150, ], 
          [0, 140, 190, 140, 160, ], 
          [0, 140, 180, 140, 150, ], 
          [0, 140, 190, 140, 160, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 30, 130, 30, 100, ], 
          [0, 140, 190, 140, 160, ], 
          [0, 0, 50, 0, 20, ], 
          [0, 140, 190, 140, 160, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 140, 180, 140, 150, ], 
          [0, 150, 190, 150, 160, ], 
          [0, 140, 180, 140, 150, ], 
          [0, 70, 110, 70, 80, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 110, 210, 60, 210, ], 
          [0, 80, 190, 30, 190, ], 
          [0, -90, 10, -10, 10, ], 
          [0, 80, 190, 30, 190, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 80, 180, 30, 180, ], 
          [0, 140, 190, 30, 190, ], 
          [0, 80, 180, 30, 180, ], 
          [0, 140, 190, 30, 190, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, -30, 70, 50, 70, ], 
          [0, 80, 190, 30, 190, ], 
          [0, 70, 50, 150, 50, ], 
          [0, 80, 190, 30, 190, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 80, 180, 30, 180, ], 
          [0, 150, 190, 40, 190, ], 
          [0, 80, 180, 30, 180, ], 
          [0, 10, 110, 90, 110, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 170, 210, 170, 190, ], 
          [0, 140, 190, 140, 100, ], 
          [0, -30, 70, -30, -70, ], 
          [0, 140, 190, 140, 100, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 140, 180, 140, 100, ], 
          [0, 140, 190, 140, 100, ], 
          [0, 140, 180, 140, 100, ], 
          [0, 140, 190, 140, 100, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 30, 130, 30, -10, ], 
          [0, 140, 190, 140, 100, ], 
          [0, 0, 50, 0, 90, ], 
          [0, 140, 190, 140, 100, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 140, 180, 140, 100, ], 
          [0, 150, 190, 150, 110, ], 
          [0, 140, 180, 140, 100, ], 
          [0, 70, 110, 70, 30, ], 
        ], 
      ],
    ],
    [
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 340, 340, 250, 340, ], 
          [0, 310, 310, 210, 310, ], 
          [0, 230, 230, 130, 230, ], 
          [0, 310, 310, 210, 310, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 310, 310, 210, 310, ], 
          [0, 310, 310, 270, 310, ], 
          [0, 310, 310, 210, 310, ], 
          [0, 310, 310, 270, 310, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 270, 270, 170, 270, ], 
          [0, 310, 310, 210, 310, ], 
          [0, 180, 180, 210, 180, ], 
          [0, 310, 310, 210, 310, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 310, 310, 210, 310, ], 
          [0, 310, 310, 270, 310, ], 
          [0, 310, 310, 210, 310, ], 
          [0, 370, 310, 210, 310, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 300, 340, 300, 310, ], 
          [0, 260, 310, 260, 280, ], 
          [0, 180, 290, 180, 260, ], 
          [0, 260, 310, 260, 280, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 260, 310, 260, 280, ], 
          [0, 260, 310, 260, 280, ], 
          [0, 260, 310, 260, 280, ], 
          [0, 260, 310, 260, 280, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 220, 330, 220, 300, ], 
          [0, 260, 310, 260, 280, ], 
          [0, 130, 180, 130, 150, ], 
          [0, 260, 310, 260, 280, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 260, 310, 260, 280, ], 
          [0, 260, 310, 260, 280, ], 
          [0, 260, 310, 260, 280, ], 
          [0, 260, 310, 260, 280, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 240, 340, 190, 340, ], 
          [0, 200, 310, 150, 310, ], 
          [0, 120, 230, 200, 230, ], 
          [0, 200, 310, 150, 310, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 200, 310, 150, 310, ], 
          [0, 260, 310, 150, 310, ], 
          [0, 200, 310, 150, 310, ], 
          [0, 260, 310, 150, 310, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 160, 270, 240, 270, ], 
          [0, 200, 310, 150, 310, ], 
          [0, 200, 180, 280, 180, ], 
          [0, 200, 310, 150, 310, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 200, 310, 150, 310, ], 
          [0, 260, 310, 150, 310, ], 
          [0, 200, 310, 150, 310, ], 
          [0, 200, 310, 280, 310, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 300, 340, 300, 320, ], 
          [0, 260, 310, 260, 220, ], 
          [0, 180, 290, 180, 140, ], 
          [0, 260, 310, 260, 220, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 260, 310, 260, 220, ], 
          [0, 260, 310, 260, 220, ], 
          [0, 260, 310, 260, 220, ], 
          [0, 260, 310, 260, 220, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 220, 330, 220, 180, ], 
          [0, 260, 310, 260, 220, ], 
          [0, 130, 180, 130, 220, ], 
          [0, 260, 310, 260, 220, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 260, 310, 260, 220, ], 
          [0, 260, 310, 260, 220, ], 
          [0, 260, 310, 260, 220, ], 
          [0, 260, 310, 260, 220, ], 
        ], 
      ],
    ],
    [
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 240, 240, 150, 240, ], 
          [0, 280, 280, 180, 280, ], 
          [0, 140, 140, 50, 140, ], 
          [0, 280, 280, 180, 280, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 280, 280, 180, 280, ], 
          [0, 280, 280, 240, 280, ], 
          [0, 280, 280, 180, 280, ], 
          [0, 280, 280, 240, 280, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 310, 310, 210, 310, ], 
          [0, 280, 280, 180, 280, ], 
          [0, 150, 150, 180, 150, ], 
          [0, 280, 280, 180, 280, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 280, 280, 180, 280, ], 
          [0, 280, 280, 240, 280, ], 
          [0, 280, 280, 180, 280, ], 
          [0, 340, 280, 180, 280, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 200, 240, 200, 210, ], 
          [0, 230, 280, 230, 250, ], 
          [0, 100, 200, 100, 170, ], 
          [0, 230, 280, 230, 250, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 230, 280, 230, 250, ], 
          [0, 230, 280, 230, 250, ], 
          [0, 230, 280, 230, 250, ], 
          [0, 230, 280, 230, 250, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 260, 370, 260, 340, ], 
          [0, 230, 280, 230, 250, ], 
          [0, 100, 150, 100, 120, ], 
          [0, 230, 280, 230, 250, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 230, 280, 230, 250, ], 
          [0, 230, 280, 230, 250, ], 
          [0, 230, 280, 230, 250, ], 
          [0, 230, 280, 230, 250, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 140, 240, 90, 240, ], 
          [0, 170, 280, 120, 280, ], 
          [0, 40, 140, 120, 140, ], 
          [0, 170, 280, 120, 280, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 170, 280, 120, 280, ], 
          [0, 230, 280, 120, 280, ], 
          [0, 170, 280, 120, 280, ], 
          [0, 230, 280, 120, 280, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 200, 310, 280, 310, ], 
          [0, 170, 280, 120, 280, ], 
          [0, 170, 150, 250, 150, ], 
          [0, 170, 280, 120, 280, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 170, 280, 120, 280, ], 
          [0, 230, 280, 120, 280, ], 
          [0, 170, 280, 120, 280, ], 
          [0, 170, 280, 250, 280, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 200, 240, 200, 220, ], 
          [0, 230, 280, 230, 190, ], 
          [0, 100, 200, 100, 60, ], 
          [0, 230, 280, 230, 190, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 230, 280, 230, 190, ], 
          [0, 230, 280, 230, 190, ], 
          [0, 230, 280, 230, 190, ], 
          [0, 230, 280, 230, 190, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 260, 370, 260, 220, ], 
          [0, 230, 280, 230, 190, ], 
          [0, 100, 150, 100, 190, ], 
          [0, 230, 280, 230, 190, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 230, 280, 230, 190, ], 
          [0, 230, 280, 230, 190, ], 
          [0, 230, 280, 230, 190, ], 
          [0, 230, 280, 230, 190, ], 
        ], 
      ],
    ],
    [
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 280, 280, 180, 280, ], 
          [0, 250, 250, 160, 250, ], 
          [0, 150, 150, 60, 150, ], 
          [0, 250, 250, 160, 250, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 260, 260, 170, 260, ], 
          [0, 260, 260, 220, 260, ], 
          [0, 260, 260, 170, 260, ], 
          [0, 260, 260, 220, 260, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 220, 220, 130, 220, ], 
          [0, 250, 250, 160, 250, ], 
          [0, 100, 100, 140, 100, ], 
          [0, 250, 250, 160, 250, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 260, 260, 170, 260, ], 
          [0, 260, 260, 220, 260, ], 
          [0, 260, 260, 170, 260, ], 
          [0, 230, 170, 70, 170, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 230, 280, 230, 250, ], 
          [0, 210, 250, 210, 220, ], 
          [0, 110, 210, 110, 180, ], 
          [0, 210, 250, 210, 220, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 220, 260, 220, 230, ], 
          [0, 210, 260, 210, 230, ], 
          [0, 220, 260, 220, 230, ], 
          [0, 210, 260, 210, 230, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 180, 280, 180, 250, ], 
          [0, 210, 250, 210, 220, ], 
          [0, 60, 100, 60, 70, ], 
          [0, 210, 250, 210, 220, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 220, 260, 220, 230, ], 
          [0, 210, 260, 210, 230, ], 
          [0, 220, 260, 220, 230, ], 
          [0, 120, 170, 120, 140, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 170, 280, 120, 280, ], 
          [0, 150, 250, 100, 250, ], 
          [0, 50, 150, 130, 150, ], 
          [0, 150, 250, 100, 250, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 160, 260, 110, 260, ], 
          [0, 210, 260, 100, 260, ], 
          [0, 160, 260, 110, 260, ], 
          [0, 210, 260, 100, 260, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 120, 220, 200, 220, ], 
          [0, 150, 250, 100, 250, ], 
          [0, 130, 100, 210, 100, ], 
          [0, 150, 250, 100, 250, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 160, 260, 110, 260, ], 
          [0, 210, 260, 100, 260, ], 
          [0, 160, 260, 110, 260, ], 
          [0, 60, 170, 140, 170, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 230, 280, 230, 250, ], 
          [0, 210, 250, 210, 170, ], 
          [0, 110, 210, 110, 70, ], 
          [0, 210, 250, 210, 170, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 220, 260, 220, 180, ], 
          [0, 210, 260, 210, 170, ], 
          [0, 220, 260, 220, 180, ], 
          [0, 210, 260, 210, 170, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 180, 280, 180, 140, ], 
          [0, 210, 250, 210, 170, ], 
          [0, 60, 100, 60, 150, ], 
          [0, 210, 250, 210, 170, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 220, 260, 220, 180, ], 
          [0, 210, 260, 210, 170, ], 
          [0, 220, 260, 220, 180, ], 
          [0, 120, 170, 120, 80, ], 
        ], 
      ],
    ],
    [
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 280, 280, 180, 280, ], 
          [0, 230, 230, 140, 230, ], 
          [0, 170, 170, 80, 170, ], 
          [0, 230, 230, 140, 230, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 280, 280, 180, 280, ], 
          [0, 280, 280, 240, 280, ], 
          [0, 280, 280, 180, 280, ], 
          [0, 280, 280, 240, 280, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 180, 180, 90, 180, ], 
          [0, 230, 230, 140, 230, ], 
          [0, 120, 120, 160, 120, ], 
          [0, 230, 230, 140, 230, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 280, 280, 180, 280, ], 
          [0, 250, 250, 210, 250, ], 
          [0, 280, 280, 180, 280, ], 
          [0, 250, 190, 100, 190, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 230, 280, 230, 250, ], 
          [0, 190, 230, 190, 200, ], 
          [0, 130, 230, 130, 200, ], 
          [0, 190, 230, 190, 200, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 230, 280, 230, 250, ], 
          [0, 230, 280, 230, 250, ], 
          [0, 230, 280, 230, 250, ], 
          [0, 230, 280, 230, 250, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 140, 240, 140, 210, ], 
          [0, 190, 230, 190, 200, ], 
          [0, 80, 120, 80, 90, ], 
          [0, 190, 230, 190, 200, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 230, 280, 230, 250, ], 
          [0, 200, 250, 200, 220, ], 
          [0, 230, 280, 230, 250, ], 
          [0, 150, 190, 150, 160, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 170, 280, 120, 280, ], 
          [0, 130, 230, 80, 230, ], 
          [0, 70, 170, 150, 170, ], 
          [0, 130, 230, 80, 230, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 170, 280, 120, 280, ], 
          [0, 230, 280, 120, 280, ], 
          [0, 170, 280, 120, 280, ], 
          [0, 230, 280, 120, 280, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 80, 180, 160, 180, ], 
          [0, 130, 230, 80, 230, ], 
          [0, 150, 120, 230, 120, ], 
          [0, 130, 230, 80, 230, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 170, 280, 120, 280, ], 
          [0, 200, 250, 90, 250, ], 
          [0, 170, 280, 120, 280, ], 
          [0, 90, 190, 170, 190, ], 
        ], 
      ],
      [
        [
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
          [0, 0, 0, 0, 0, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 230, 280, 230, 250, ], 
          [0, 190, 230, 190, 150, ], 
          [0, 130, 230, 130, 90, ], 
          [0, 190, 230, 190, 150, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 230, 280, 230, 190, ], 
          [0, 230, 280, 230, 190, ], 
          [0, 230, 280, 230, 190, ], 
          [0, 230, 280, 230, 190, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 140, 240, 140, 100, ], 
          [0, 190, 230, 190, 150, ], 
          [0, 80, 120, 80, 170, ], 
          [0, 190, 230, 190, 150, ], 
        ], 
        [
          [0, 0, 0, 0, 0, ], 
          [0, 230, 280, 230, 190, ], 
          [0, 200, 250, 200, 160, ], 
          [0, 230, 280, 230, 190, ], 
          [0, 150, 190, 150, 110, ], 
        ], 
      ],
    ],
  ],
], dtype=np.float32) / -100.

score_hairpin = np.array([np.inf, np.inf, np.inf, 540, 560, 570, 540, 600, 550, 640, 650, 660, 670, 680, 690, 690, 700, 710, 710, 720, 720, 730, 730, 740, 740, 750, 750, 750, 760, 760, 770, ], dtype=np.float32) / -100.
score_bulge = np.array([np.inf, 380, 280, 320, 360, 400, 440, 460, 470, 480, 490, 500, 510, 520, 530, 540, 540, 550, 550, 560, 570, 570, 580, 580, 580, 590, 590, 600, 600, 600, 610, ], dtype=np.float32) / -100.
score_internal = np.array([np.inf, np.inf, 100, 100, 110, 200, 200, 210, 230, 240, 250, 260, 270, 280, 290, 290, 300, 310, 310, 320, 330, 330, 340, 340, 350, 350, 350, 360, 360, 370, 370, ], dtype=np.float32) / -100.
score_ml_base = np.array([0], dtype=np.float32) / -100.
score_ml_closing = np.array([930], dtype=np.float32) / -100.
score_ml_intern = np.array([-90], dtype=np.float32) / -100.
score_ninio = np.array([60], dtype=np.float32) / -100.
score_max_ninio = np.array([300], dtype=np.float32) / -100.
score_duplex_init = np.array([410], dtype=np.float32) / -100.
score_terminalAU = np.array([50], dtype=np.float32) / -100.
score_lxc = np.array([107.856], dtype=np.float32) / -100.
