/*
 * Decompiled with CFR 0.152.
 */
package io.ray.runtime.gcs;

import io.ray.api.id.ActorId;
import io.ray.api.id.JobId;
import io.ray.api.id.PlacementGroupId;
import io.ray.api.id.UniqueId;
import io.ray.api.placementgroup.PlacementGroup;
import io.ray.api.runtimecontext.NodeInfo;
import io.ray.runtime.gcs.GlobalStateAccessor;
import io.ray.runtime.generated.Gcs;
import io.ray.runtime.placementgroup.PlacementGroupUtils;
import io.ray.shaded.com.google.common.base.Preconditions;
import io.ray.shaded.com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GcsClient {
    private static Logger LOGGER = LoggerFactory.getLogger(GcsClient.class);
    private GlobalStateAccessor globalStateAccessor;

    public GcsClient(String bootstrapAddress, String redisPassword) {
        this.globalStateAccessor = GlobalStateAccessor.getInstance(bootstrapAddress, redisPassword);
    }

    public PlacementGroup getPlacementGroupInfo(PlacementGroupId placementGroupId) {
        byte[] result = this.globalStateAccessor.getPlacementGroupInfo(placementGroupId);
        return PlacementGroupUtils.generatePlacementGroupFromByteArray(result);
    }

    public PlacementGroup getPlacementGroupInfo(String name, String namespace) {
        byte[] result = this.globalStateAccessor.getPlacementGroupInfo(name, namespace);
        return result == null ? null : PlacementGroupUtils.generatePlacementGroupFromByteArray(result);
    }

    public List<PlacementGroup> getAllPlacementGroupInfo() {
        List<byte[]> results = this.globalStateAccessor.getAllPlacementGroupInfo();
        ArrayList<PlacementGroup> placementGroups = new ArrayList<PlacementGroup>();
        for (byte[] result : results) {
            placementGroups.add(PlacementGroupUtils.generatePlacementGroupFromByteArray(result));
        }
        return placementGroups;
    }

    public String getInternalKV(String ns, String key) {
        byte[] value = this.globalStateAccessor.getInternalKV(ns, key);
        return value == null ? null : new String(value);
    }

    public List<NodeInfo> getAllNodeInfo() {
        List<byte[]> results = this.globalStateAccessor.getAllNodeInfo();
        HashMap<UniqueId, NodeInfo> nodes = new HashMap<UniqueId, NodeInfo>();
        for (byte[] result : results) {
            Preconditions.checkNotNull(result);
            Gcs.GcsNodeInfo data = null;
            try {
                data = Gcs.GcsNodeInfo.parseFrom(result);
            }
            catch (InvalidProtocolBufferException e) {
                throw new RuntimeException("Received invalid protobuf data from GCS.");
            }
            UniqueId nodeId = UniqueId.fromByteBuffer(data.getNodeId().asReadOnlyByteBuffer());
            NodeInfo nodeInfo = new NodeInfo(nodeId, data.getNodeManagerAddress(), data.getNodeManagerHostname(), data.getNodeManagerPort(), data.getObjectStoreSocketName(), data.getRayletSocketName(), data.getState() == Gcs.GcsNodeInfo.GcsNodeState.ALIVE, new HashMap<String, Double>(), data.getLabelsMap());
            if (nodeInfo.isAlive) {
                nodeInfo.resources.putAll(data.getResourcesTotalMap());
            }
            nodes.put(nodeId, nodeInfo);
        }
        return new ArrayList<NodeInfo>(nodes.values());
    }

    public boolean actorExists(ActorId actorId) {
        byte[] result = this.globalStateAccessor.getActorInfo(actorId);
        return result != null;
    }

    public boolean wasCurrentActorRestarted(ActorId actorId) {
        byte[] value = this.globalStateAccessor.getActorInfo(actorId);
        if (value == null) {
            return false;
        }
        Gcs.ActorTableData actorTableData = null;
        try {
            actorTableData = Gcs.ActorTableData.parseFrom(value);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException("Received invalid protobuf data from GCS.");
        }
        return actorTableData.getNumRestarts() != 0L;
    }

    public JobId nextJobId() {
        return JobId.fromBytes(this.globalStateAccessor.getNextJobID());
    }

    public Gcs.GcsNodeInfo getNodeToConnectForDriver(String nodeIpAddress) {
        byte[] value = this.globalStateAccessor.getNodeToConnectForDriver(nodeIpAddress);
        Preconditions.checkNotNull(value);
        Gcs.GcsNodeInfo nodeInfo = null;
        try {
            nodeInfo = Gcs.GcsNodeInfo.parseFrom(value);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException("Received invalid protobuf data from GCS.");
        }
        return nodeInfo;
    }

    public byte[] getActorAddress(ActorId actorId) {
        byte[] serializedActorInfo = this.globalStateAccessor.getActorInfo(actorId);
        if (serializedActorInfo == null) {
            return null;
        }
        try {
            Gcs.ActorTableData actorTableData = Gcs.ActorTableData.parseFrom(serializedActorInfo);
            return actorTableData.getAddress().toByteArray();
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException("Received invalid protobuf data from GCS.");
        }
    }

    public void destroy() {
        LOGGER.debug("Destroying global state accessor.");
        GlobalStateAccessor.destroyInstance();
    }
}

