"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.StorageClass = void 0;
/**
 * Storage class to move an object to
 */
class StorageClass {
    constructor(value) {
        this.value = value;
    }
    toString() { return this.value; }
}
exports.StorageClass = StorageClass;
/**
 * Storage class for data that is accessed less frequently, but requires rapid
 * access when needed.
 *
 * Has lower availability than Standard storage.
 */
StorageClass.INFREQUENT_ACCESS = new StorageClass('STANDARD_IA');
/**
 * Infrequent Access that's only stored in one availability zone.
 *
 * Has lower availability than standard InfrequentAccess.
 */
StorageClass.ONE_ZONE_INFREQUENT_ACCESS = new StorageClass('ONEZONE_IA');
/**
 * Storage class for long-term archival that can take between minutes and
 * hours to access.
 *
 * Use for archives where portions of the data might need to be retrieved in
 * minutes. Data stored in the GLACIER storage class has a minimum storage
 * duration period of 90 days and can be accessed in as little as 1-5 minutes
 * using expedited retrieval. If you delete an object before the 90-day
 * minimum, you are charged for 90 days.
 */
StorageClass.GLACIER = new StorageClass('GLACIER');
/**
 * Use for archiving data that rarely needs to be accessed. Data stored in the
 * DEEP_ARCHIVE storage class has a minimum storage duration period of 180
 * days and a default retrieval time of 12 hours. If you delete an object
 * before the 180-day minimum, you are charged for 180 days. For pricing
 * information, see Amazon S3 Pricing.
 */
StorageClass.DEEP_ARCHIVE = new StorageClass('DEEP_ARCHIVE');
/**
 * The INTELLIGENT_TIERING storage class is designed to optimize storage costs
 * by automatically moving data to the most cost-effective storage access
 * tier, without performance impact or operational overhead.
 * INTELLIGENT_TIERING delivers automatic cost savings by moving data on a
 * granular object level between two access tiers, a frequent access tier and
 * a lower-cost infrequent access tier, when access patterns change. The
 * INTELLIGENT_TIERING storage class is ideal if you want to optimize storage
 * costs automatically for long-lived data when access patterns are unknown or
 * unpredictable.
 */
StorageClass.INTELLIGENT_TIERING = new StorageClass('INTELLIGENT_TIERING');
//# sourceMappingURL=data:application/json;base64,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