# Copyright (C) 2019 - TODAY Renato Lima - Akretion
# License AGPL-3.0 or later (http://www.gnu.org/licenses/agpl.html).

from openupgradelib import openupgrade

_column_copies = {
    "product_template": [
        ("service_type_id", None, None),
        ("ncm_id", None, None),
        ("fiscal_classification_id", None, None),
    ],
    "res_partner": [
        ("partner_fiscal_type_id", None, None),
    ],
}

_model_renames = [
    ("l10n_br_account.partner.fiscal.type", "l10n_br_fiscal.partner.profile"),
    ("l10n_br_tax.estimate", "l10n_br_fiscal.tax.estimate"),
    ("l10n_br_account.fiscal.category", "l10n_br_fiscal.operation"),
    ("l10n_br_account.fiscal.document", "l10n_br_fiscal.document.type"),
    ("l10n_br_account.fiscal.document.serie", "l10n_br_fiscal.document.serie"),
    ("l10n_br_account_product.cst", "l10n_br_fiscal.cst"),
    ("l10n_br_account.cnae", "l10n_br_fiscal.cnae"),
    ("l10n_br_account_product.cfop", "l10n_br_fiscal.cfop"),
    ("l10n_br_account_product.cest", "l10n_br_fiscal.cest"),
]

_table_renames = [
    ("l10n_br_tax_estimate", "l10n_br_fiscal_tax_estimate"),
    ("l10n_br_account_fiscal_category", "l10n_br_fiscal_operation"),
    ("res_company_l10n_br_account_cnae", "res_company_fiscal_cnae_rel"),
    ("l10n_br_account_fiscal_document", "l10n_br_fiscal_document_type"),
    ("l10n_br_account_document_serie", "l10n_br_fiscal_document_serie"),
    ("l10n_br_account_cnae", "l10n_br_fiscal_cnae"),
    ("l10n_br_account_product_cfop", "l10n_br_fiscal_cfop"),
    ("l10n_br_account_product_cest", "l10n_br_fiscal_cest"),
]

_xml_ids_fiscal_operation_renames = [
    ("fc_78df616ab31e95ee46c6a519a2ce9e12", "fo_venda_55"),
    ("fc_c333f0a13695741d07c872b54016c093", "fo_bonificacao_55"),
    ("fc_7817d015cb9832d137d7939a224a79a5", "fo_devolucao_venda_55"),
    ("fc_b7aafa9c3056c3f020ceae63d7312504", "fo_compras_55"),
    ("fc_f20c37a9e1e1c870af37efe62a786fbf", "fo_devolucao_compras_55"),
    ("fc_d9132a81edff5374f33560f58666b792", "fo_entrada_remessa_55"),
    ("fc_86d8c770fc2fb9d9fa242a3bdddd507a", "fo_simples_remessa_55"),
]

_xml_ids_cnae_renames = [
    ("l10n_br_account.l10n_br_cnae_1", "l10n_br_fiscal.cnae_A"),
    ("l10n_br_account.l10n_br_cnae_2", "l10n_br_fiscal.cnae_1"),
    ("l10n_br_account.l10n_br_cnae_3", "l10n_br_fiscal.cnae_011"),
    ("l10n_br_account.l10n_br_cnae_4", "l10n_br_fiscal.cnae_01113"),
    ("l10n_br_account.l10n_br_cnae_5", "l10n_br_fiscal.cnae_0111301"),
    ("l10n_br_account.l10n_br_cnae_6", "l10n_br_fiscal.cnae_0111302"),
    ("l10n_br_account.l10n_br_cnae_7", "l10n_br_fiscal.cnae_0111303"),
    ("l10n_br_account.l10n_br_cnae_8", "l10n_br_fiscal.cnae_0111399"),
    ("l10n_br_account.l10n_br_cnae_9", "l10n_br_fiscal.cnae_01121"),
    ("l10n_br_account.l10n_br_cnae_10", "l10n_br_fiscal.cnae_0112101"),
    ("l10n_br_account.l10n_br_cnae_11", "l10n_br_fiscal.cnae_0112102"),
    ("l10n_br_account.l10n_br_cnae_12", "l10n_br_fiscal.cnae_0112199"),
    ("l10n_br_account.l10n_br_cnae_13", "l10n_br_fiscal.cnae_01130"),
    ("l10n_br_account.l10n_br_cnae_14", "l10n_br_fiscal.cnae_0113000"),
    ("l10n_br_account.l10n_br_cnae_15", "l10n_br_fiscal.cnae_01148"),
    ("l10n_br_account.l10n_br_cnae_16", "l10n_br_fiscal.cnae_0114800"),
    ("l10n_br_account.l10n_br_cnae_17", "l10n_br_fiscal.cnae_01156"),
    ("l10n_br_account.l10n_br_cnae_18", "l10n_br_fiscal.cnae_0115600"),
    ("l10n_br_account.l10n_br_cnae_19", "l10n_br_fiscal.cnae_01164"),
    ("l10n_br_account.l10n_br_cnae_20", "l10n_br_fiscal.cnae_0116401"),
    ("l10n_br_account.l10n_br_cnae_21", "l10n_br_fiscal.cnae_0116402"),
    ("l10n_br_account.l10n_br_cnae_22", "l10n_br_fiscal.cnae_0116403"),
    ("l10n_br_account.l10n_br_cnae_23", "l10n_br_fiscal.cnae_0116499"),
    ("l10n_br_account.l10n_br_cnae_24", "l10n_br_fiscal.cnae_01199"),
    ("l10n_br_account.l10n_br_cnae_25", "l10n_br_fiscal.cnae_0119901"),
    ("l10n_br_account.l10n_br_cnae_26", "l10n_br_fiscal.cnae_0119902"),
    ("l10n_br_account.l10n_br_cnae_27", "l10n_br_fiscal.cnae_0119903"),
    ("l10n_br_account.l10n_br_cnae_28", "l10n_br_fiscal.cnae_0119904"),
    ("l10n_br_account.l10n_br_cnae_29", "l10n_br_fiscal.cnae_0119905"),
    ("l10n_br_account.l10n_br_cnae_30", "l10n_br_fiscal.cnae_0119906"),
    ("l10n_br_account.l10n_br_cnae_31", "l10n_br_fiscal.cnae_0119907"),
    ("l10n_br_account.l10n_br_cnae_32", "l10n_br_fiscal.cnae_0119908"),
    ("l10n_br_account.l10n_br_cnae_33", "l10n_br_fiscal.cnae_0119909"),
    ("l10n_br_account.l10n_br_cnae_34", "l10n_br_fiscal.cnae_0119999"),
    ("l10n_br_account.l10n_br_cnae_35", "l10n_br_fiscal.cnae_012"),
    ("l10n_br_account.l10n_br_cnae_36", "l10n_br_fiscal.cnae_01211"),
    ("l10n_br_account.l10n_br_cnae_37", "l10n_br_fiscal.cnae_0121101"),
    ("l10n_br_account.l10n_br_cnae_38", "l10n_br_fiscal.cnae_0121102"),
    ("l10n_br_account.l10n_br_cnae_39", "l10n_br_fiscal.cnae_01229"),
    ("l10n_br_account.l10n_br_cnae_40", "l10n_br_fiscal.cnae_0122900"),
    ("l10n_br_account.l10n_br_cnae_41", "l10n_br_fiscal.cnae_013"),
    ("l10n_br_account.l10n_br_cnae_42", "l10n_br_fiscal.cnae_01318"),
    ("l10n_br_account.l10n_br_cnae_43", "l10n_br_fiscal.cnae_0131800"),
    ("l10n_br_account.l10n_br_cnae_44", "l10n_br_fiscal.cnae_01326"),
    ("l10n_br_account.l10n_br_cnae_45", "l10n_br_fiscal.cnae_0132600"),
    ("l10n_br_account.l10n_br_cnae_46", "l10n_br_fiscal.cnae_01334"),
    ("l10n_br_account.l10n_br_cnae_47", "l10n_br_fiscal.cnae_0133401"),
    ("l10n_br_account.l10n_br_cnae_48", "l10n_br_fiscal.cnae_0133402"),
    ("l10n_br_account.l10n_br_cnae_49", "l10n_br_fiscal.cnae_0133403"),
    ("l10n_br_account.l10n_br_cnae_50", "l10n_br_fiscal.cnae_0133404"),
    ("l10n_br_account.l10n_br_cnae_51", "l10n_br_fiscal.cnae_0133405"),
    ("l10n_br_account.l10n_br_cnae_52", "l10n_br_fiscal.cnae_0133406"),
    ("l10n_br_account.l10n_br_cnae_53", "l10n_br_fiscal.cnae_0133407"),
    ("l10n_br_account.l10n_br_cnae_54", "l10n_br_fiscal.cnae_0133408"),
    ("l10n_br_account.l10n_br_cnae_55", "l10n_br_fiscal.cnae_0133409"),
    ("l10n_br_account.l10n_br_cnae_56", "l10n_br_fiscal.cnae_0133410"),
    ("l10n_br_account.l10n_br_cnae_57", "l10n_br_fiscal.cnae_0133411"),
    ("l10n_br_account.l10n_br_cnae_58", "l10n_br_fiscal.cnae_0133499"),
    ("l10n_br_account.l10n_br_cnae_59", "l10n_br_fiscal.cnae_01342"),
    ("l10n_br_account.l10n_br_cnae_60", "l10n_br_fiscal.cnae_0134200"),
    ("l10n_br_account.l10n_br_cnae_61", "l10n_br_fiscal.cnae_01351"),
    ("l10n_br_account.l10n_br_cnae_62", "l10n_br_fiscal.cnae_0135100"),
    ("l10n_br_account.l10n_br_cnae_63", "l10n_br_fiscal.cnae_01393"),
    ("l10n_br_account.l10n_br_cnae_64", "l10n_br_fiscal.cnae_0139301"),
    ("l10n_br_account.l10n_br_cnae_65", "l10n_br_fiscal.cnae_0139302"),
    ("l10n_br_account.l10n_br_cnae_66", "l10n_br_fiscal.cnae_0139303"),
    ("l10n_br_account.l10n_br_cnae_67", "l10n_br_fiscal.cnae_0139304"),
    ("l10n_br_account.l10n_br_cnae_68", "l10n_br_fiscal.cnae_0139305"),
    ("l10n_br_account.l10n_br_cnae_69", "l10n_br_fiscal.cnae_0139306"),
    ("l10n_br_account.l10n_br_cnae_70", "l10n_br_fiscal.cnae_0139399"),
    ("l10n_br_account.l10n_br_cnae_71", "l10n_br_fiscal.cnae_014"),
    ("l10n_br_account.l10n_br_cnae_72", "l10n_br_fiscal.cnae_01415"),
    ("l10n_br_account.l10n_br_cnae_73", "l10n_br_fiscal.cnae_0141501"),
    ("l10n_br_account.l10n_br_cnae_74", "l10n_br_fiscal.cnae_0141502"),
    ("l10n_br_account.l10n_br_cnae_75", "l10n_br_fiscal.cnae_01423"),
    ("l10n_br_account.l10n_br_cnae_76", "l10n_br_fiscal.cnae_0142300"),
    ("l10n_br_account.l10n_br_cnae_77", "l10n_br_fiscal.cnae_015"),
    ("l10n_br_account.l10n_br_cnae_78", "l10n_br_fiscal.cnae_01512"),
    ("l10n_br_account.l10n_br_cnae_79", "l10n_br_fiscal.cnae_0151201"),
    ("l10n_br_account.l10n_br_cnae_80", "l10n_br_fiscal.cnae_0151202"),
    ("l10n_br_account.l10n_br_cnae_81", "l10n_br_fiscal.cnae_0151203"),
    ("l10n_br_account.l10n_br_cnae_82", "l10n_br_fiscal.cnae_01521"),
    ("l10n_br_account.l10n_br_cnae_83", "l10n_br_fiscal.cnae_0152101"),
    ("l10n_br_account.l10n_br_cnae_84", "l10n_br_fiscal.cnae_0152102"),
    ("l10n_br_account.l10n_br_cnae_85", "l10n_br_fiscal.cnae_0152103"),
    ("l10n_br_account.l10n_br_cnae_86", "l10n_br_fiscal.cnae_01539"),
    ("l10n_br_account.l10n_br_cnae_87", "l10n_br_fiscal.cnae_0153901"),
    ("l10n_br_account.l10n_br_cnae_88", "l10n_br_fiscal.cnae_0153902"),
    ("l10n_br_account.l10n_br_cnae_89", "l10n_br_fiscal.cnae_01547"),
    ("l10n_br_account.l10n_br_cnae_90", "l10n_br_fiscal.cnae_0154700"),
    ("l10n_br_account.l10n_br_cnae_91", "l10n_br_fiscal.cnae_01555"),
    ("l10n_br_account.l10n_br_cnae_92", "l10n_br_fiscal.cnae_0155501"),
    ("l10n_br_account.l10n_br_cnae_93", "l10n_br_fiscal.cnae_0155502"),
    ("l10n_br_account.l10n_br_cnae_94", "l10n_br_fiscal.cnae_0155503"),
    ("l10n_br_account.l10n_br_cnae_95", "l10n_br_fiscal.cnae_0155504"),
    ("l10n_br_account.l10n_br_cnae_96", "l10n_br_fiscal.cnae_0155505"),
    ("l10n_br_account.l10n_br_cnae_97", "l10n_br_fiscal.cnae_01598"),
    ("l10n_br_account.l10n_br_cnae_98", "l10n_br_fiscal.cnae_0159801"),
    ("l10n_br_account.l10n_br_cnae_99", "l10n_br_fiscal.cnae_0159802"),
    ("l10n_br_account.l10n_br_cnae_100", "l10n_br_fiscal.cnae_0159803"),
    ("l10n_br_account.l10n_br_cnae_101", "l10n_br_fiscal.cnae_0159804"),
    ("l10n_br_account.l10n_br_cnae_102", "l10n_br_fiscal.cnae_0159899"),
    ("l10n_br_account.l10n_br_cnae_103", "l10n_br_fiscal.cnae_016"),
    ("l10n_br_account.l10n_br_cnae_104", "l10n_br_fiscal.cnae_01610"),
    ("l10n_br_account.l10n_br_cnae_105", "l10n_br_fiscal.cnae_0161001"),
    ("l10n_br_account.l10n_br_cnae_106", "l10n_br_fiscal.cnae_0161002"),
    ("l10n_br_account.l10n_br_cnae_107", "l10n_br_fiscal.cnae_0161003"),
    ("l10n_br_account.l10n_br_cnae_108", "l10n_br_fiscal.cnae_0161099"),
    ("l10n_br_account.l10n_br_cnae_109", "l10n_br_fiscal.cnae_01628"),
    ("l10n_br_account.l10n_br_cnae_110", "l10n_br_fiscal.cnae_0162801"),
    ("l10n_br_account.l10n_br_cnae_111", "l10n_br_fiscal.cnae_0162802"),
    ("l10n_br_account.l10n_br_cnae_112", "l10n_br_fiscal.cnae_0162803"),
    ("l10n_br_account.l10n_br_cnae_113", "l10n_br_fiscal.cnae_0162899"),
    ("l10n_br_account.l10n_br_cnae_114", "l10n_br_fiscal.cnae_01636"),
    ("l10n_br_account.l10n_br_cnae_115", "l10n_br_fiscal.cnae_0163600"),
    ("l10n_br_account.l10n_br_cnae_116", "l10n_br_fiscal.cnae_017"),
    ("l10n_br_account.l10n_br_cnae_117", "l10n_br_fiscal.cnae_01709"),
    ("l10n_br_account.l10n_br_cnae_118", "l10n_br_fiscal.cnae_0170900"),
    ("l10n_br_account.l10n_br_cnae_119", "l10n_br_fiscal.cnae_2"),
    ("l10n_br_account.l10n_br_cnae_120", "l10n_br_fiscal.cnae_021"),
    ("l10n_br_account.l10n_br_cnae_121", "l10n_br_fiscal.cnae_02101"),
    ("l10n_br_account.l10n_br_cnae_122", "l10n_br_fiscal.cnae_0210101"),
    ("l10n_br_account.l10n_br_cnae_123", "l10n_br_fiscal.cnae_0210102"),
    ("l10n_br_account.l10n_br_cnae_124", "l10n_br_fiscal.cnae_0210103"),
    ("l10n_br_account.l10n_br_cnae_125", "l10n_br_fiscal.cnae_0210104"),
    ("l10n_br_account.l10n_br_cnae_126", "l10n_br_fiscal.cnae_0210105"),
    ("l10n_br_account.l10n_br_cnae_127", "l10n_br_fiscal.cnae_0210106"),
    ("l10n_br_account.l10n_br_cnae_128", "l10n_br_fiscal.cnae_0210107"),
    ("l10n_br_account.l10n_br_cnae_129", "l10n_br_fiscal.cnae_0210108"),
    ("l10n_br_account.l10n_br_cnae_130", "l10n_br_fiscal.cnae_0210109"),
    ("l10n_br_account.l10n_br_cnae_131", "l10n_br_fiscal.cnae_0210199"),
    ("l10n_br_account.l10n_br_cnae_132", "l10n_br_fiscal.cnae_022"),
    ("l10n_br_account.l10n_br_cnae_133", "l10n_br_fiscal.cnae_02209"),
    ("l10n_br_account.l10n_br_cnae_134", "l10n_br_fiscal.cnae_0220901"),
    ("l10n_br_account.l10n_br_cnae_135", "l10n_br_fiscal.cnae_0220902"),
    ("l10n_br_account.l10n_br_cnae_136", "l10n_br_fiscal.cnae_0220903"),
    ("l10n_br_account.l10n_br_cnae_137", "l10n_br_fiscal.cnae_0220904"),
    ("l10n_br_account.l10n_br_cnae_138", "l10n_br_fiscal.cnae_0220905"),
    ("l10n_br_account.l10n_br_cnae_139", "l10n_br_fiscal.cnae_0220906"),
    ("l10n_br_account.l10n_br_cnae_140", "l10n_br_fiscal.cnae_0220999"),
    ("l10n_br_account.l10n_br_cnae_141", "l10n_br_fiscal.cnae_023"),
    ("l10n_br_account.l10n_br_cnae_142", "l10n_br_fiscal.cnae_02306"),
    ("l10n_br_account.l10n_br_cnae_143", "l10n_br_fiscal.cnae_0230600"),
    ("l10n_br_account.l10n_br_cnae_144", "l10n_br_fiscal.cnae_3"),
    ("l10n_br_account.l10n_br_cnae_145", "l10n_br_fiscal.cnae_031"),
    ("l10n_br_account.l10n_br_cnae_146", "l10n_br_fiscal.cnae_03116"),
    ("l10n_br_account.l10n_br_cnae_147", "l10n_br_fiscal.cnae_0311601"),
    ("l10n_br_account.l10n_br_cnae_148", "l10n_br_fiscal.cnae_0311602"),
    ("l10n_br_account.l10n_br_cnae_149", "l10n_br_fiscal.cnae_0311603"),
    ("l10n_br_account.l10n_br_cnae_150", "l10n_br_fiscal.cnae_0311604"),
    ("l10n_br_account.l10n_br_cnae_151", "l10n_br_fiscal.cnae_03124"),
    ("l10n_br_account.l10n_br_cnae_152", "l10n_br_fiscal.cnae_0312401"),
    ("l10n_br_account.l10n_br_cnae_153", "l10n_br_fiscal.cnae_0312402"),
    ("l10n_br_account.l10n_br_cnae_154", "l10n_br_fiscal.cnae_0312403"),
    ("l10n_br_account.l10n_br_cnae_155", "l10n_br_fiscal.cnae_0312404"),
    ("l10n_br_account.l10n_br_cnae_156", "l10n_br_fiscal.cnae_032"),
    ("l10n_br_account.l10n_br_cnae_157", "l10n_br_fiscal.cnae_03213"),
    ("l10n_br_account.l10n_br_cnae_158", "l10n_br_fiscal.cnae_0321301"),
    ("l10n_br_account.l10n_br_cnae_159", "l10n_br_fiscal.cnae_0321302"),
    ("l10n_br_account.l10n_br_cnae_160", "l10n_br_fiscal.cnae_0321303"),
    ("l10n_br_account.l10n_br_cnae_161", "l10n_br_fiscal.cnae_0321304"),
    ("l10n_br_account.l10n_br_cnae_162", "l10n_br_fiscal.cnae_0321305"),
    ("l10n_br_account.l10n_br_cnae_163", "l10n_br_fiscal.cnae_0321399"),
    ("l10n_br_account.l10n_br_cnae_164", "l10n_br_fiscal.cnae_03221"),
    ("l10n_br_account.l10n_br_cnae_165", "l10n_br_fiscal.cnae_0322101"),
    ("l10n_br_account.l10n_br_cnae_166", "l10n_br_fiscal.cnae_0322102"),
    ("l10n_br_account.l10n_br_cnae_167", "l10n_br_fiscal.cnae_0322103"),
    ("l10n_br_account.l10n_br_cnae_168", "l10n_br_fiscal.cnae_0322104"),
    ("l10n_br_account.l10n_br_cnae_169", "l10n_br_fiscal.cnae_0322105"),
    ("l10n_br_account.l10n_br_cnae_170", "l10n_br_fiscal.cnae_0322106"),
    ("l10n_br_account.l10n_br_cnae_171", "l10n_br_fiscal.cnae_0322107"),
    ("l10n_br_account.l10n_br_cnae_172", "l10n_br_fiscal.cnae_0322199"),
    ("l10n_br_account.l10n_br_cnae_173", "l10n_br_fiscal.cnae_B"),
    ("l10n_br_account.l10n_br_cnae_174", "l10n_br_fiscal.cnae_5"),
    ("l10n_br_account.l10n_br_cnae_175", "l10n_br_fiscal.cnae_050"),
    ("l10n_br_account.l10n_br_cnae_176", "l10n_br_fiscal.cnae_05003"),
    ("l10n_br_account.l10n_br_cnae_177", "l10n_br_fiscal.cnae_0500301"),
    ("l10n_br_account.l10n_br_cnae_178", "l10n_br_fiscal.cnae_0500302"),
    ("l10n_br_account.l10n_br_cnae_179", "l10n_br_fiscal.cnae_6"),
    ("l10n_br_account.l10n_br_cnae_180", "l10n_br_fiscal.cnae_060"),
    ("l10n_br_account.l10n_br_cnae_181", "l10n_br_fiscal.cnae_06000"),
    ("l10n_br_account.l10n_br_cnae_182", "l10n_br_fiscal.cnae_0600001"),
    ("l10n_br_account.l10n_br_cnae_183", "l10n_br_fiscal.cnae_0600002"),
    ("l10n_br_account.l10n_br_cnae_184", "l10n_br_fiscal.cnae_0600003"),
    ("l10n_br_account.l10n_br_cnae_185", "l10n_br_fiscal.cnae_7"),
    ("l10n_br_account.l10n_br_cnae_186", "l10n_br_fiscal.cnae_071"),
    ("l10n_br_account.l10n_br_cnae_187", "l10n_br_fiscal.cnae_07103"),
    ("l10n_br_account.l10n_br_cnae_188", "l10n_br_fiscal.cnae_0710301"),
    ("l10n_br_account.l10n_br_cnae_189", "l10n_br_fiscal.cnae_0710302"),
    ("l10n_br_account.l10n_br_cnae_190", "l10n_br_fiscal.cnae_072"),
    ("l10n_br_account.l10n_br_cnae_191", "l10n_br_fiscal.cnae_07219"),
    ("l10n_br_account.l10n_br_cnae_192", "l10n_br_fiscal.cnae_0721901"),
    ("l10n_br_account.l10n_br_cnae_193", "l10n_br_fiscal.cnae_0721902"),
    ("l10n_br_account.l10n_br_cnae_194", "l10n_br_fiscal.cnae_07227"),
    ("l10n_br_account.l10n_br_cnae_195", "l10n_br_fiscal.cnae_0722701"),
    ("l10n_br_account.l10n_br_cnae_196", "l10n_br_fiscal.cnae_0722702"),
    ("l10n_br_account.l10n_br_cnae_197", "l10n_br_fiscal.cnae_07235"),
    ("l10n_br_account.l10n_br_cnae_198", "l10n_br_fiscal.cnae_0723501"),
    ("l10n_br_account.l10n_br_cnae_199", "l10n_br_fiscal.cnae_0723502"),
    ("l10n_br_account.l10n_br_cnae_200", "l10n_br_fiscal.cnae_07243"),
    ("l10n_br_account.l10n_br_cnae_201", "l10n_br_fiscal.cnae_0724301"),
    ("l10n_br_account.l10n_br_cnae_202", "l10n_br_fiscal.cnae_0724302"),
    ("l10n_br_account.l10n_br_cnae_203", "l10n_br_fiscal.cnae_07251"),
    ("l10n_br_account.l10n_br_cnae_204", "l10n_br_fiscal.cnae_0725100"),
    ("l10n_br_account.l10n_br_cnae_205", "l10n_br_fiscal.cnae_07294"),
    ("l10n_br_account.l10n_br_cnae_206", "l10n_br_fiscal.cnae_0729401"),
    ("l10n_br_account.l10n_br_cnae_207", "l10n_br_fiscal.cnae_0729402"),
    ("l10n_br_account.l10n_br_cnae_208", "l10n_br_fiscal.cnae_0729403"),
    ("l10n_br_account.l10n_br_cnae_209", "l10n_br_fiscal.cnae_0729404"),
    ("l10n_br_account.l10n_br_cnae_210", "l10n_br_fiscal.cnae_0729405"),
    ("l10n_br_account.l10n_br_cnae_211", "l10n_br_fiscal.cnae_8"),
    ("l10n_br_account.l10n_br_cnae_212", "l10n_br_fiscal.cnae_081"),
    ("l10n_br_account.l10n_br_cnae_213", "l10n_br_fiscal.cnae_08100"),
    ("l10n_br_account.l10n_br_cnae_214", "l10n_br_fiscal.cnae_0810001"),
    ("l10n_br_account.l10n_br_cnae_215", "l10n_br_fiscal.cnae_0810002"),
    ("l10n_br_account.l10n_br_cnae_216", "l10n_br_fiscal.cnae_0810003"),
    ("l10n_br_account.l10n_br_cnae_217", "l10n_br_fiscal.cnae_0810004"),
    ("l10n_br_account.l10n_br_cnae_218", "l10n_br_fiscal.cnae_0810005"),
    ("l10n_br_account.l10n_br_cnae_219", "l10n_br_fiscal.cnae_0810006"),
    ("l10n_br_account.l10n_br_cnae_220", "l10n_br_fiscal.cnae_0810007"),
    ("l10n_br_account.l10n_br_cnae_221", "l10n_br_fiscal.cnae_0810008"),
    ("l10n_br_account.l10n_br_cnae_222", "l10n_br_fiscal.cnae_0810009"),
    ("l10n_br_account.l10n_br_cnae_223", "l10n_br_fiscal.cnae_0810010"),
    ("l10n_br_account.l10n_br_cnae_224", "l10n_br_fiscal.cnae_0810099"),
    ("l10n_br_account.l10n_br_cnae_225", "l10n_br_fiscal.cnae_089"),
    ("l10n_br_account.l10n_br_cnae_226", "l10n_br_fiscal.cnae_08916"),
    ("l10n_br_account.l10n_br_cnae_227", "l10n_br_fiscal.cnae_0891600"),
    ("l10n_br_account.l10n_br_cnae_228", "l10n_br_fiscal.cnae_08924"),
    ("l10n_br_account.l10n_br_cnae_229", "l10n_br_fiscal.cnae_0892401"),
    ("l10n_br_account.l10n_br_cnae_230", "l10n_br_fiscal.cnae_0892402"),
    ("l10n_br_account.l10n_br_cnae_231", "l10n_br_fiscal.cnae_0892403"),
    ("l10n_br_account.l10n_br_cnae_232", "l10n_br_fiscal.cnae_08932"),
    ("l10n_br_account.l10n_br_cnae_233", "l10n_br_fiscal.cnae_0893200"),
    ("l10n_br_account.l10n_br_cnae_234", "l10n_br_fiscal.cnae_08991"),
    ("l10n_br_account.l10n_br_cnae_235", "l10n_br_fiscal.cnae_0899101"),
    ("l10n_br_account.l10n_br_cnae_236", "l10n_br_fiscal.cnae_0899102"),
    ("l10n_br_account.l10n_br_cnae_237", "l10n_br_fiscal.cnae_0899103"),
    ("l10n_br_account.l10n_br_cnae_238", "l10n_br_fiscal.cnae_0899199"),
    ("l10n_br_account.l10n_br_cnae_239", "l10n_br_fiscal.cnae_9"),
    ("l10n_br_account.l10n_br_cnae_240", "l10n_br_fiscal.cnae_091"),
    ("l10n_br_account.l10n_br_cnae_241", "l10n_br_fiscal.cnae_09106"),
    ("l10n_br_account.l10n_br_cnae_242", "l10n_br_fiscal.cnae_0910600"),
    ("l10n_br_account.l10n_br_cnae_243", "l10n_br_fiscal.cnae_099"),
    ("l10n_br_account.l10n_br_cnae_244", "l10n_br_fiscal.cnae_09904"),
    ("l10n_br_account.l10n_br_cnae_245", "l10n_br_fiscal.cnae_0990401"),
    ("l10n_br_account.l10n_br_cnae_246", "l10n_br_fiscal.cnae_0990402"),
    ("l10n_br_account.l10n_br_cnae_247", "l10n_br_fiscal.cnae_0990403"),
    ("l10n_br_account.l10n_br_cnae_248", "l10n_br_fiscal.cnae_C"),
    ("l10n_br_account.l10n_br_cnae_249", "l10n_br_fiscal.cnae_10"),
    ("l10n_br_account.l10n_br_cnae_250", "l10n_br_fiscal.cnae_101"),
    ("l10n_br_account.l10n_br_cnae_251", "l10n_br_fiscal.cnae_10112"),
    ("l10n_br_account.l10n_br_cnae_252", "l10n_br_fiscal.cnae_1011201"),
    ("l10n_br_account.l10n_br_cnae_253", "l10n_br_fiscal.cnae_1011202"),
    ("l10n_br_account.l10n_br_cnae_254", "l10n_br_fiscal.cnae_1011203"),
    ("l10n_br_account.l10n_br_cnae_255", "l10n_br_fiscal.cnae_1011204"),
    ("l10n_br_account.l10n_br_cnae_256", "l10n_br_fiscal.cnae_1011205"),
    ("l10n_br_account.l10n_br_cnae_257", "l10n_br_fiscal.cnae_10121"),
    ("l10n_br_account.l10n_br_cnae_258", "l10n_br_fiscal.cnae_1012101"),
    ("l10n_br_account.l10n_br_cnae_259", "l10n_br_fiscal.cnae_1012102"),
    ("l10n_br_account.l10n_br_cnae_260", "l10n_br_fiscal.cnae_1012103"),
    ("l10n_br_account.l10n_br_cnae_261", "l10n_br_fiscal.cnae_1012104"),
    ("l10n_br_account.l10n_br_cnae_262", "l10n_br_fiscal.cnae_10139"),
    ("l10n_br_account.l10n_br_cnae_263", "l10n_br_fiscal.cnae_1013901"),
    ("l10n_br_account.l10n_br_cnae_264", "l10n_br_fiscal.cnae_1013902"),
    ("l10n_br_account.l10n_br_cnae_265", "l10n_br_fiscal.cnae_102"),
    ("l10n_br_account.l10n_br_cnae_266", "l10n_br_fiscal.cnae_10201"),
    ("l10n_br_account.l10n_br_cnae_267", "l10n_br_fiscal.cnae_1020101"),
    ("l10n_br_account.l10n_br_cnae_268", "l10n_br_fiscal.cnae_1020102"),
    ("l10n_br_account.l10n_br_cnae_269", "l10n_br_fiscal.cnae_103"),
    ("l10n_br_account.l10n_br_cnae_270", "l10n_br_fiscal.cnae_10317"),
    ("l10n_br_account.l10n_br_cnae_271", "l10n_br_fiscal.cnae_1031700"),
    ("l10n_br_account.l10n_br_cnae_272", "l10n_br_fiscal.cnae_10325"),
    ("l10n_br_account.l10n_br_cnae_273", "l10n_br_fiscal.cnae_1032501"),
    ("l10n_br_account.l10n_br_cnae_274", "l10n_br_fiscal.cnae_1032599"),
    ("l10n_br_account.l10n_br_cnae_275", "l10n_br_fiscal.cnae_10333"),
    ("l10n_br_account.l10n_br_cnae_276", "l10n_br_fiscal.cnae_1033301"),
    ("l10n_br_account.l10n_br_cnae_277", "l10n_br_fiscal.cnae_1033302"),
    ("l10n_br_account.l10n_br_cnae_278", "l10n_br_fiscal.cnae_104"),
    ("l10n_br_account.l10n_br_cnae_279", "l10n_br_fiscal.cnae_10414"),
    ("l10n_br_account.l10n_br_cnae_280", "l10n_br_fiscal.cnae_1041400"),
    ("l10n_br_account.l10n_br_cnae_281", "l10n_br_fiscal.cnae_10422"),
    ("l10n_br_account.l10n_br_cnae_282", "l10n_br_fiscal.cnae_1042200"),
    ("l10n_br_account.l10n_br_cnae_283", "l10n_br_fiscal.cnae_10431"),
    ("l10n_br_account.l10n_br_cnae_284", "l10n_br_fiscal.cnae_1043100"),
    ("l10n_br_account.l10n_br_cnae_285", "l10n_br_fiscal.cnae_105"),
    ("l10n_br_account.l10n_br_cnae_286", "l10n_br_fiscal.cnae_10511"),
    ("l10n_br_account.l10n_br_cnae_287", "l10n_br_fiscal.cnae_1051100"),
    ("l10n_br_account.l10n_br_cnae_288", "l10n_br_fiscal.cnae_10520"),
    ("l10n_br_account.l10n_br_cnae_289", "l10n_br_fiscal.cnae_1052000"),
    ("l10n_br_account.l10n_br_cnae_290", "l10n_br_fiscal.cnae_10538"),
    ("l10n_br_account.l10n_br_cnae_291", "l10n_br_fiscal.cnae_1053800"),
    ("l10n_br_account.l10n_br_cnae_292", "l10n_br_fiscal.cnae_106"),
    ("l10n_br_account.l10n_br_cnae_293", "l10n_br_fiscal.cnae_10619"),
    ("l10n_br_account.l10n_br_cnae_294", "l10n_br_fiscal.cnae_1061901"),
    ("l10n_br_account.l10n_br_cnae_295", "l10n_br_fiscal.cnae_1061902"),
    ("l10n_br_account.l10n_br_cnae_296", "l10n_br_fiscal.cnae_10627"),
    ("l10n_br_account.l10n_br_cnae_297", "l10n_br_fiscal.cnae_1062700"),
    ("l10n_br_account.l10n_br_cnae_298", "l10n_br_fiscal.cnae_10635"),
    ("l10n_br_account.l10n_br_cnae_299", "l10n_br_fiscal.cnae_1063500"),
    ("l10n_br_account.l10n_br_cnae_300", "l10n_br_fiscal.cnae_10643"),
    ("l10n_br_account.l10n_br_cnae_301", "l10n_br_fiscal.cnae_1064300"),
    ("l10n_br_account.l10n_br_cnae_302", "l10n_br_fiscal.cnae_10651"),
    ("l10n_br_account.l10n_br_cnae_303", "l10n_br_fiscal.cnae_1065101"),
    ("l10n_br_account.l10n_br_cnae_304", "l10n_br_fiscal.cnae_1065102"),
    ("l10n_br_account.l10n_br_cnae_305", "l10n_br_fiscal.cnae_1065103"),
    ("l10n_br_account.l10n_br_cnae_306", "l10n_br_fiscal.cnae_10660"),
    ("l10n_br_account.l10n_br_cnae_307", "l10n_br_fiscal.cnae_1066000"),
    ("l10n_br_account.l10n_br_cnae_308", "l10n_br_fiscal.cnae_10694"),
    ("l10n_br_account.l10n_br_cnae_309", "l10n_br_fiscal.cnae_1069400"),
    ("l10n_br_account.l10n_br_cnae_310", "l10n_br_fiscal.cnae_107"),
    ("l10n_br_account.l10n_br_cnae_311", "l10n_br_fiscal.cnae_10716"),
    ("l10n_br_account.l10n_br_cnae_312", "l10n_br_fiscal.cnae_1071600"),
    ("l10n_br_account.l10n_br_cnae_313", "l10n_br_fiscal.cnae_10724"),
    ("l10n_br_account.l10n_br_cnae_314", "l10n_br_fiscal.cnae_1072401"),
    ("l10n_br_account.l10n_br_cnae_315", "l10n_br_fiscal.cnae_1072402"),
    ("l10n_br_account.l10n_br_cnae_316", "l10n_br_fiscal.cnae_108"),
    ("l10n_br_account.l10n_br_cnae_317", "l10n_br_fiscal.cnae_10813"),
    ("l10n_br_account.l10n_br_cnae_318", "l10n_br_fiscal.cnae_1081301"),
    ("l10n_br_account.l10n_br_cnae_319", "l10n_br_fiscal.cnae_1081302"),
    ("l10n_br_account.l10n_br_cnae_320", "l10n_br_fiscal.cnae_10821"),
    ("l10n_br_account.l10n_br_cnae_321", "l10n_br_fiscal.cnae_1082100"),
    ("l10n_br_account.l10n_br_cnae_322", "l10n_br_fiscal.cnae_109"),
    ("l10n_br_account.l10n_br_cnae_323", "l10n_br_fiscal.cnae_10911"),
    ("l10n_br_account.l10n_br_cnae_324", "l10n_br_fiscal.cnae_1091100"),
    ("l10n_br_account.l10n_br_cnae_325", "l10n_br_fiscal.cnae_10929"),
    ("l10n_br_account.l10n_br_cnae_326", "l10n_br_fiscal.cnae_1092900"),
    ("l10n_br_account.l10n_br_cnae_327", "l10n_br_fiscal.cnae_10937"),
    ("l10n_br_account.l10n_br_cnae_328", "l10n_br_fiscal.cnae_1093701"),
    ("l10n_br_account.l10n_br_cnae_329", "l10n_br_fiscal.cnae_1093702"),
    ("l10n_br_account.l10n_br_cnae_330", "l10n_br_fiscal.cnae_10945"),
    ("l10n_br_account.l10n_br_cnae_331", "l10n_br_fiscal.cnae_1094500"),
    ("l10n_br_account.l10n_br_cnae_332", "l10n_br_fiscal.cnae_10953"),
    ("l10n_br_account.l10n_br_cnae_333", "l10n_br_fiscal.cnae_1095300"),
    ("l10n_br_account.l10n_br_cnae_334", "l10n_br_fiscal.cnae_10961"),
    ("l10n_br_account.l10n_br_cnae_335", "l10n_br_fiscal.cnae_1096100"),
    ("l10n_br_account.l10n_br_cnae_336", "l10n_br_fiscal.cnae_10996"),
    ("l10n_br_account.l10n_br_cnae_337", "l10n_br_fiscal.cnae_1099601"),
    ("l10n_br_account.l10n_br_cnae_338", "l10n_br_fiscal.cnae_1099602"),
    ("l10n_br_account.l10n_br_cnae_339", "l10n_br_fiscal.cnae_1099603"),
    ("l10n_br_account.l10n_br_cnae_340", "l10n_br_fiscal.cnae_1099604"),
    ("l10n_br_account.l10n_br_cnae_341", "l10n_br_fiscal.cnae_1099605"),
    ("l10n_br_account.l10n_br_cnae_342", "l10n_br_fiscal.cnae_1099606"),
    ("l10n_br_account.l10n_br_cnae_343", "l10n_br_fiscal.cnae_1099699"),
    ("l10n_br_account.l10n_br_cnae_344", "l10n_br_fiscal.cnae_11"),
    ("l10n_br_account.l10n_br_cnae_345", "l10n_br_fiscal.cnae_111"),
    ("l10n_br_account.l10n_br_cnae_346", "l10n_br_fiscal.cnae_11119"),
    ("l10n_br_account.l10n_br_cnae_347", "l10n_br_fiscal.cnae_1111901"),
    ("l10n_br_account.l10n_br_cnae_348", "l10n_br_fiscal.cnae_1111902"),
    ("l10n_br_account.l10n_br_cnae_349", "l10n_br_fiscal.cnae_11127"),
    ("l10n_br_account.l10n_br_cnae_350", "l10n_br_fiscal.cnae_1112700"),
    ("l10n_br_account.l10n_br_cnae_351", "l10n_br_fiscal.cnae_11135"),
    ("l10n_br_account.l10n_br_cnae_352", "l10n_br_fiscal.cnae_1113501"),
    ("l10n_br_account.l10n_br_cnae_353", "l10n_br_fiscal.cnae_1113502"),
    ("l10n_br_account.l10n_br_cnae_354", "l10n_br_fiscal.cnae_112"),
    ("l10n_br_account.l10n_br_cnae_355", "l10n_br_fiscal.cnae_11216"),
    ("l10n_br_account.l10n_br_cnae_356", "l10n_br_fiscal.cnae_1121600"),
    ("l10n_br_account.l10n_br_cnae_357", "l10n_br_fiscal.cnae_11224"),
    ("l10n_br_account.l10n_br_cnae_358", "l10n_br_fiscal.cnae_1122401"),
    ("l10n_br_account.l10n_br_cnae_359", "l10n_br_fiscal.cnae_1122402"),
    ("l10n_br_account.l10n_br_cnae_360", "l10n_br_fiscal.cnae_1122403"),
    ("l10n_br_account.l10n_br_cnae_361", "l10n_br_fiscal.cnae_1122499"),
    ("l10n_br_account.l10n_br_cnae_362", "l10n_br_fiscal.cnae_12"),
    ("l10n_br_account.l10n_br_cnae_363", "l10n_br_fiscal.cnae_121"),
    ("l10n_br_account.l10n_br_cnae_364", "l10n_br_fiscal.cnae_12107"),
    ("l10n_br_account.l10n_br_cnae_365", "l10n_br_fiscal.cnae_1210700"),
    ("l10n_br_account.l10n_br_cnae_366", "l10n_br_fiscal.cnae_122"),
    ("l10n_br_account.l10n_br_cnae_367", "l10n_br_fiscal.cnae_12204"),
    ("l10n_br_account.l10n_br_cnae_368", "l10n_br_fiscal.cnae_1220401"),
    ("l10n_br_account.l10n_br_cnae_369", "l10n_br_fiscal.cnae_1220402"),
    ("l10n_br_account.l10n_br_cnae_370", "l10n_br_fiscal.cnae_1220403"),
    ("l10n_br_account.l10n_br_cnae_371", "l10n_br_fiscal.cnae_1220499"),
    ("l10n_br_account.l10n_br_cnae_372", "l10n_br_fiscal.cnae_13"),
    ("l10n_br_account.l10n_br_cnae_373", "l10n_br_fiscal.cnae_131"),
    ("l10n_br_account.l10n_br_cnae_374", "l10n_br_fiscal.cnae_13111"),
    ("l10n_br_account.l10n_br_cnae_375", "l10n_br_fiscal.cnae_1311100"),
    ("l10n_br_account.l10n_br_cnae_376", "l10n_br_fiscal.cnae_13120"),
    ("l10n_br_account.l10n_br_cnae_377", "l10n_br_fiscal.cnae_1312000"),
    ("l10n_br_account.l10n_br_cnae_378", "l10n_br_fiscal.cnae_13138"),
    ("l10n_br_account.l10n_br_cnae_379", "l10n_br_fiscal.cnae_1313800"),
    ("l10n_br_account.l10n_br_cnae_380", "l10n_br_fiscal.cnae_13146"),
    ("l10n_br_account.l10n_br_cnae_381", "l10n_br_fiscal.cnae_1314600"),
    ("l10n_br_account.l10n_br_cnae_382", "l10n_br_fiscal.cnae_132"),
    ("l10n_br_account.l10n_br_cnae_383", "l10n_br_fiscal.cnae_13219"),
    ("l10n_br_account.l10n_br_cnae_384", "l10n_br_fiscal.cnae_1321900"),
    ("l10n_br_account.l10n_br_cnae_385", "l10n_br_fiscal.cnae_13227"),
    ("l10n_br_account.l10n_br_cnae_386", "l10n_br_fiscal.cnae_1322700"),
    ("l10n_br_account.l10n_br_cnae_387", "l10n_br_fiscal.cnae_13235"),
    ("l10n_br_account.l10n_br_cnae_388", "l10n_br_fiscal.cnae_1323500"),
    ("l10n_br_account.l10n_br_cnae_389", "l10n_br_fiscal.cnae_133"),
    ("l10n_br_account.l10n_br_cnae_390", "l10n_br_fiscal.cnae_13308"),
    ("l10n_br_account.l10n_br_cnae_391", "l10n_br_fiscal.cnae_1330800"),
    ("l10n_br_account.l10n_br_cnae_392", "l10n_br_fiscal.cnae_134"),
    ("l10n_br_account.l10n_br_cnae_393", "l10n_br_fiscal.cnae_13405"),
    ("l10n_br_account.l10n_br_cnae_394", "l10n_br_fiscal.cnae_1340501"),
    ("l10n_br_account.l10n_br_cnae_395", "l10n_br_fiscal.cnae_1340502"),
    ("l10n_br_account.l10n_br_cnae_396", "l10n_br_fiscal.cnae_1340599"),
    ("l10n_br_account.l10n_br_cnae_397", "l10n_br_fiscal.cnae_135"),
    ("l10n_br_account.l10n_br_cnae_398", "l10n_br_fiscal.cnae_13511"),
    ("l10n_br_account.l10n_br_cnae_399", "l10n_br_fiscal.cnae_1351100"),
    ("l10n_br_account.l10n_br_cnae_400", "l10n_br_fiscal.cnae_13529"),
    ("l10n_br_account.l10n_br_cnae_401", "l10n_br_fiscal.cnae_1352900"),
    ("l10n_br_account.l10n_br_cnae_402", "l10n_br_fiscal.cnae_13537"),
    ("l10n_br_account.l10n_br_cnae_403", "l10n_br_fiscal.cnae_1353700"),
    ("l10n_br_account.l10n_br_cnae_404", "l10n_br_fiscal.cnae_13545"),
    ("l10n_br_account.l10n_br_cnae_405", "l10n_br_fiscal.cnae_1354500"),
    ("l10n_br_account.l10n_br_cnae_406", "l10n_br_fiscal.cnae_13596"),
    ("l10n_br_account.l10n_br_cnae_407", "l10n_br_fiscal.cnae_1359600"),
    ("l10n_br_account.l10n_br_cnae_408", "l10n_br_fiscal.cnae_14"),
    ("l10n_br_account.l10n_br_cnae_409", "l10n_br_fiscal.cnae_141"),
    ("l10n_br_account.l10n_br_cnae_410", "l10n_br_fiscal.cnae_14118"),
    ("l10n_br_account.l10n_br_cnae_411", "l10n_br_fiscal.cnae_1411801"),
    ("l10n_br_account.l10n_br_cnae_412", "l10n_br_fiscal.cnae_1411802"),
    ("l10n_br_account.l10n_br_cnae_413", "l10n_br_fiscal.cnae_14126"),
    ("l10n_br_account.l10n_br_cnae_414", "l10n_br_fiscal.cnae_1412601"),
    ("l10n_br_account.l10n_br_cnae_415", "l10n_br_fiscal.cnae_1412602"),
    ("l10n_br_account.l10n_br_cnae_416", "l10n_br_fiscal.cnae_1412603"),
    ("l10n_br_account.l10n_br_cnae_417", "l10n_br_fiscal.cnae_14134"),
    ("l10n_br_account.l10n_br_cnae_418", "l10n_br_fiscal.cnae_1413401"),
    ("l10n_br_account.l10n_br_cnae_419", "l10n_br_fiscal.cnae_1413402"),
    ("l10n_br_account.l10n_br_cnae_420", "l10n_br_fiscal.cnae_1413403"),
    ("l10n_br_account.l10n_br_cnae_421", "l10n_br_fiscal.cnae_14142"),
    ("l10n_br_account.l10n_br_cnae_422", "l10n_br_fiscal.cnae_1414200"),
    ("l10n_br_account.l10n_br_cnae_423", "l10n_br_fiscal.cnae_142"),
    ("l10n_br_account.l10n_br_cnae_424", "l10n_br_fiscal.cnae_14215"),
    ("l10n_br_account.l10n_br_cnae_425", "l10n_br_fiscal.cnae_1421500"),
    ("l10n_br_account.l10n_br_cnae_426", "l10n_br_fiscal.cnae_14223"),
    ("l10n_br_account.l10n_br_cnae_427", "l10n_br_fiscal.cnae_1422300"),
    ("l10n_br_account.l10n_br_cnae_428", "l10n_br_fiscal.cnae_15"),
    ("l10n_br_account.l10n_br_cnae_429", "l10n_br_fiscal.cnae_151"),
    ("l10n_br_account.l10n_br_cnae_430", "l10n_br_fiscal.cnae_15106"),
    ("l10n_br_account.l10n_br_cnae_431", "l10n_br_fiscal.cnae_1510600"),
    ("l10n_br_account.l10n_br_cnae_432", "l10n_br_fiscal.cnae_152"),
    ("l10n_br_account.l10n_br_cnae_433", "l10n_br_fiscal.cnae_15211"),
    ("l10n_br_account.l10n_br_cnae_434", "l10n_br_fiscal.cnae_1521100"),
    ("l10n_br_account.l10n_br_cnae_435", "l10n_br_fiscal.cnae_15297"),
    ("l10n_br_account.l10n_br_cnae_436", "l10n_br_fiscal.cnae_1529700"),
    ("l10n_br_account.l10n_br_cnae_437", "l10n_br_fiscal.cnae_153"),
    ("l10n_br_account.l10n_br_cnae_438", "l10n_br_fiscal.cnae_15319"),
    ("l10n_br_account.l10n_br_cnae_439", "l10n_br_fiscal.cnae_1531901"),
    ("l10n_br_account.l10n_br_cnae_440", "l10n_br_fiscal.cnae_1531902"),
    ("l10n_br_account.l10n_br_cnae_441", "l10n_br_fiscal.cnae_15327"),
    ("l10n_br_account.l10n_br_cnae_442", "l10n_br_fiscal.cnae_1532700"),
    ("l10n_br_account.l10n_br_cnae_443", "l10n_br_fiscal.cnae_15335"),
    ("l10n_br_account.l10n_br_cnae_444", "l10n_br_fiscal.cnae_1533500"),
    ("l10n_br_account.l10n_br_cnae_445", "l10n_br_fiscal.cnae_15394"),
    ("l10n_br_account.l10n_br_cnae_446", "l10n_br_fiscal.cnae_1539400"),
    ("l10n_br_account.l10n_br_cnae_447", "l10n_br_fiscal.cnae_154"),
    ("l10n_br_account.l10n_br_cnae_448", "l10n_br_fiscal.cnae_15408"),
    ("l10n_br_account.l10n_br_cnae_449", "l10n_br_fiscal.cnae_1540800"),
    ("l10n_br_account.l10n_br_cnae_450", "l10n_br_fiscal.cnae_16"),
    ("l10n_br_account.l10n_br_cnae_451", "l10n_br_fiscal.cnae_161"),
    ("l10n_br_account.l10n_br_cnae_452", "l10n_br_fiscal.cnae_16102"),
    ("l10n_br_account.l10n_br_cnae_453", "l10n_br_fiscal.cnae_1610201"),
    ("l10n_br_account.l10n_br_cnae_454", "l10n_br_fiscal.cnae_1610202"),
    ("l10n_br_account.l10n_br_cnae_455", "l10n_br_fiscal.cnae_162"),
    ("l10n_br_account.l10n_br_cnae_456", "l10n_br_fiscal.cnae_16218"),
    ("l10n_br_account.l10n_br_cnae_457", "l10n_br_fiscal.cnae_1621800"),
    ("l10n_br_account.l10n_br_cnae_458", "l10n_br_fiscal.cnae_16226"),
    ("l10n_br_account.l10n_br_cnae_459", "l10n_br_fiscal.cnae_1622601"),
    ("l10n_br_account.l10n_br_cnae_460", "l10n_br_fiscal.cnae_1622602"),
    ("l10n_br_account.l10n_br_cnae_461", "l10n_br_fiscal.cnae_1622699"),
    ("l10n_br_account.l10n_br_cnae_462", "l10n_br_fiscal.cnae_16234"),
    ("l10n_br_account.l10n_br_cnae_463", "l10n_br_fiscal.cnae_1623400"),
    ("l10n_br_account.l10n_br_cnae_464", "l10n_br_fiscal.cnae_16293"),
    ("l10n_br_account.l10n_br_cnae_465", "l10n_br_fiscal.cnae_1629301"),
    ("l10n_br_account.l10n_br_cnae_466", "l10n_br_fiscal.cnae_1629302"),
    ("l10n_br_account.l10n_br_cnae_467", "l10n_br_fiscal.cnae_17"),
    ("l10n_br_account.l10n_br_cnae_468", "l10n_br_fiscal.cnae_171"),
    ("l10n_br_account.l10n_br_cnae_469", "l10n_br_fiscal.cnae_17109"),
    ("l10n_br_account.l10n_br_cnae_470", "l10n_br_fiscal.cnae_1710900"),
    ("l10n_br_account.l10n_br_cnae_471", "l10n_br_fiscal.cnae_172"),
    ("l10n_br_account.l10n_br_cnae_472", "l10n_br_fiscal.cnae_17214"),
    ("l10n_br_account.l10n_br_cnae_473", "l10n_br_fiscal.cnae_1721400"),
    ("l10n_br_account.l10n_br_cnae_474", "l10n_br_fiscal.cnae_17222"),
    ("l10n_br_account.l10n_br_cnae_475", "l10n_br_fiscal.cnae_1722200"),
    ("l10n_br_account.l10n_br_cnae_476", "l10n_br_fiscal.cnae_173"),
    ("l10n_br_account.l10n_br_cnae_477", "l10n_br_fiscal.cnae_17311"),
    ("l10n_br_account.l10n_br_cnae_478", "l10n_br_fiscal.cnae_1731100"),
    ("l10n_br_account.l10n_br_cnae_479", "l10n_br_fiscal.cnae_17320"),
    ("l10n_br_account.l10n_br_cnae_480", "l10n_br_fiscal.cnae_1732000"),
    ("l10n_br_account.l10n_br_cnae_481", "l10n_br_fiscal.cnae_17338"),
    ("l10n_br_account.l10n_br_cnae_482", "l10n_br_fiscal.cnae_1733800"),
    ("l10n_br_account.l10n_br_cnae_483", "l10n_br_fiscal.cnae_174"),
    ("l10n_br_account.l10n_br_cnae_484", "l10n_br_fiscal.cnae_17419"),
    ("l10n_br_account.l10n_br_cnae_485", "l10n_br_fiscal.cnae_1741901"),
    ("l10n_br_account.l10n_br_cnae_486", "l10n_br_fiscal.cnae_1741902"),
    ("l10n_br_account.l10n_br_cnae_487", "l10n_br_fiscal.cnae_17427"),
    ("l10n_br_account.l10n_br_cnae_488", "l10n_br_fiscal.cnae_1742701"),
    ("l10n_br_account.l10n_br_cnae_489", "l10n_br_fiscal.cnae_1742702"),
    ("l10n_br_account.l10n_br_cnae_490", "l10n_br_fiscal.cnae_1742799"),
    ("l10n_br_account.l10n_br_cnae_491", "l10n_br_fiscal.cnae_17494"),
    ("l10n_br_account.l10n_br_cnae_492", "l10n_br_fiscal.cnae_1749400"),
    ("l10n_br_account.l10n_br_cnae_493", "l10n_br_fiscal.cnae_18"),
    ("l10n_br_account.l10n_br_cnae_494", "l10n_br_fiscal.cnae_181"),
    ("l10n_br_account.l10n_br_cnae_495", "l10n_br_fiscal.cnae_18113"),
    ("l10n_br_account.l10n_br_cnae_496", "l10n_br_fiscal.cnae_1811301"),
    ("l10n_br_account.l10n_br_cnae_497", "l10n_br_fiscal.cnae_1811302"),
    ("l10n_br_account.l10n_br_cnae_498", "l10n_br_fiscal.cnae_18121"),
    ("l10n_br_account.l10n_br_cnae_499", "l10n_br_fiscal.cnae_1812100"),
    ("l10n_br_account.l10n_br_cnae_500", "l10n_br_fiscal.cnae_18130"),
    ("l10n_br_account.l10n_br_cnae_501", "l10n_br_fiscal.cnae_1813001"),
    ("l10n_br_account.l10n_br_cnae_502", "l10n_br_fiscal.cnae_1813099"),
    ("l10n_br_account.l10n_br_cnae_503", "l10n_br_fiscal.cnae_182"),
    ("l10n_br_account.l10n_br_cnae_504", "l10n_br_fiscal.cnae_18211"),
    ("l10n_br_account.l10n_br_cnae_505", "l10n_br_fiscal.cnae_1821100"),
    ("l10n_br_account.l10n_br_cnae_506", "l10n_br_fiscal.cnae_18229"),
    ("l10n_br_account.l10n_br_cnae_507", "l10n_br_fiscal.cnae_1822900"),
    ("l10n_br_account.l10n_br_cnae_508", "l10n_br_fiscal.cnae_183"),
    ("l10n_br_account.l10n_br_cnae_509", "l10n_br_fiscal.cnae_18300"),
    ("l10n_br_account.l10n_br_cnae_510", "l10n_br_fiscal.cnae_1830001"),
    ("l10n_br_account.l10n_br_cnae_511", "l10n_br_fiscal.cnae_1830002"),
    ("l10n_br_account.l10n_br_cnae_512", "l10n_br_fiscal.cnae_1830003"),
    ("l10n_br_account.l10n_br_cnae_513", "l10n_br_fiscal.cnae_19"),
    ("l10n_br_account.l10n_br_cnae_514", "l10n_br_fiscal.cnae_191"),
    ("l10n_br_account.l10n_br_cnae_515", "l10n_br_fiscal.cnae_19101"),
    ("l10n_br_account.l10n_br_cnae_516", "l10n_br_fiscal.cnae_1910100"),
    ("l10n_br_account.l10n_br_cnae_517", "l10n_br_fiscal.cnae_192"),
    ("l10n_br_account.l10n_br_cnae_518", "l10n_br_fiscal.cnae_19217"),
    ("l10n_br_account.l10n_br_cnae_519", "l10n_br_fiscal.cnae_1921700"),
    ("l10n_br_account.l10n_br_cnae_520", "l10n_br_fiscal.cnae_19225"),
    ("l10n_br_account.l10n_br_cnae_521", "l10n_br_fiscal.cnae_1922501"),
    ("l10n_br_account.l10n_br_cnae_522", "l10n_br_fiscal.cnae_1922502"),
    ("l10n_br_account.l10n_br_cnae_523", "l10n_br_fiscal.cnae_1922599"),
    ("l10n_br_account.l10n_br_cnae_524", "l10n_br_fiscal.cnae_193"),
    ("l10n_br_account.l10n_br_cnae_525", "l10n_br_fiscal.cnae_19314"),
    ("l10n_br_account.l10n_br_cnae_526", "l10n_br_fiscal.cnae_1931400"),
    ("l10n_br_account.l10n_br_cnae_527", "l10n_br_fiscal.cnae_19322"),
    ("l10n_br_account.l10n_br_cnae_528", "l10n_br_fiscal.cnae_1932200"),
    ("l10n_br_account.l10n_br_cnae_529", "l10n_br_fiscal.cnae_20"),
    ("l10n_br_account.l10n_br_cnae_530", "l10n_br_fiscal.cnae_201"),
    ("l10n_br_account.l10n_br_cnae_531", "l10n_br_fiscal.cnae_20118"),
    ("l10n_br_account.l10n_br_cnae_532", "l10n_br_fiscal.cnae_2011800"),
    ("l10n_br_account.l10n_br_cnae_533", "l10n_br_fiscal.cnae_20126"),
    ("l10n_br_account.l10n_br_cnae_534", "l10n_br_fiscal.cnae_2012600"),
    ("l10n_br_account.l10n_br_cnae_535", "l10n_br_fiscal.cnae_20134"),
    ("l10n_br_account.l10n_br_cnae_536", "l10n_br_fiscal.cnae_2013400"),
    ("l10n_br_account.l10n_br_cnae_537", "l10n_br_fiscal.cnae_20142"),
    ("l10n_br_account.l10n_br_cnae_538", "l10n_br_fiscal.cnae_2014200"),
    ("l10n_br_account.l10n_br_cnae_539", "l10n_br_fiscal.cnae_20193"),
    ("l10n_br_account.l10n_br_cnae_540", "l10n_br_fiscal.cnae_2019301"),
    ("l10n_br_account.l10n_br_cnae_541", "l10n_br_fiscal.cnae_2019399"),
    ("l10n_br_account.l10n_br_cnae_542", "l10n_br_fiscal.cnae_202"),
    ("l10n_br_account.l10n_br_cnae_543", "l10n_br_fiscal.cnae_20215"),
    ("l10n_br_account.l10n_br_cnae_544", "l10n_br_fiscal.cnae_2021500"),
    ("l10n_br_account.l10n_br_cnae_545", "l10n_br_fiscal.cnae_20223"),
    ("l10n_br_account.l10n_br_cnae_546", "l10n_br_fiscal.cnae_2022300"),
    ("l10n_br_account.l10n_br_cnae_547", "l10n_br_fiscal.cnae_20291"),
    ("l10n_br_account.l10n_br_cnae_548", "l10n_br_fiscal.cnae_2029100"),
    ("l10n_br_account.l10n_br_cnae_549", "l10n_br_fiscal.cnae_203"),
    ("l10n_br_account.l10n_br_cnae_550", "l10n_br_fiscal.cnae_20312"),
    ("l10n_br_account.l10n_br_cnae_551", "l10n_br_fiscal.cnae_2031200"),
    ("l10n_br_account.l10n_br_cnae_552", "l10n_br_fiscal.cnae_20321"),
    ("l10n_br_account.l10n_br_cnae_553", "l10n_br_fiscal.cnae_2032100"),
    ("l10n_br_account.l10n_br_cnae_554", "l10n_br_fiscal.cnae_20339"),
    ("l10n_br_account.l10n_br_cnae_555", "l10n_br_fiscal.cnae_2033900"),
    ("l10n_br_account.l10n_br_cnae_556", "l10n_br_fiscal.cnae_204"),
    ("l10n_br_account.l10n_br_cnae_557", "l10n_br_fiscal.cnae_20401"),
    ("l10n_br_account.l10n_br_cnae_558", "l10n_br_fiscal.cnae_2040100"),
    ("l10n_br_account.l10n_br_cnae_559", "l10n_br_fiscal.cnae_205"),
    ("l10n_br_account.l10n_br_cnae_560", "l10n_br_fiscal.cnae_20517"),
    ("l10n_br_account.l10n_br_cnae_561", "l10n_br_fiscal.cnae_2051700"),
    ("l10n_br_account.l10n_br_cnae_562", "l10n_br_fiscal.cnae_20525"),
    ("l10n_br_account.l10n_br_cnae_563", "l10n_br_fiscal.cnae_2052500"),
    ("l10n_br_account.l10n_br_cnae_564", "l10n_br_fiscal.cnae_206"),
    ("l10n_br_account.l10n_br_cnae_565", "l10n_br_fiscal.cnae_20614"),
    ("l10n_br_account.l10n_br_cnae_566", "l10n_br_fiscal.cnae_2061400"),
    ("l10n_br_account.l10n_br_cnae_567", "l10n_br_fiscal.cnae_20622"),
    ("l10n_br_account.l10n_br_cnae_568", "l10n_br_fiscal.cnae_2062200"),
    ("l10n_br_account.l10n_br_cnae_569", "l10n_br_fiscal.cnae_20631"),
    ("l10n_br_account.l10n_br_cnae_570", "l10n_br_fiscal.cnae_2063100"),
    ("l10n_br_account.l10n_br_cnae_571", "l10n_br_fiscal.cnae_207"),
    ("l10n_br_account.l10n_br_cnae_572", "l10n_br_fiscal.cnae_20711"),
    ("l10n_br_account.l10n_br_cnae_573", "l10n_br_fiscal.cnae_2071100"),
    ("l10n_br_account.l10n_br_cnae_574", "l10n_br_fiscal.cnae_20720"),
    ("l10n_br_account.l10n_br_cnae_575", "l10n_br_fiscal.cnae_2072000"),
    ("l10n_br_account.l10n_br_cnae_576", "l10n_br_fiscal.cnae_20738"),
    ("l10n_br_account.l10n_br_cnae_577", "l10n_br_fiscal.cnae_2073800"),
    ("l10n_br_account.l10n_br_cnae_578", "l10n_br_fiscal.cnae_209"),
    ("l10n_br_account.l10n_br_cnae_579", "l10n_br_fiscal.cnae_20916"),
    ("l10n_br_account.l10n_br_cnae_580", "l10n_br_fiscal.cnae_2091600"),
    ("l10n_br_account.l10n_br_cnae_581", "l10n_br_fiscal.cnae_20924"),
    ("l10n_br_account.l10n_br_cnae_582", "l10n_br_fiscal.cnae_2092401"),
    ("l10n_br_account.l10n_br_cnae_583", "l10n_br_fiscal.cnae_2092402"),
    ("l10n_br_account.l10n_br_cnae_584", "l10n_br_fiscal.cnae_2092403"),
    ("l10n_br_account.l10n_br_cnae_585", "l10n_br_fiscal.cnae_20932"),
    ("l10n_br_account.l10n_br_cnae_586", "l10n_br_fiscal.cnae_2093200"),
    ("l10n_br_account.l10n_br_cnae_587", "l10n_br_fiscal.cnae_20941"),
    ("l10n_br_account.l10n_br_cnae_588", "l10n_br_fiscal.cnae_2094100"),
    ("l10n_br_account.l10n_br_cnae_589", "l10n_br_fiscal.cnae_20991"),
    ("l10n_br_account.l10n_br_cnae_590", "l10n_br_fiscal.cnae_2099101"),
    ("l10n_br_account.l10n_br_cnae_591", "l10n_br_fiscal.cnae_2099199"),
    ("l10n_br_account.l10n_br_cnae_592", "l10n_br_fiscal.cnae_21"),
    ("l10n_br_account.l10n_br_cnae_593", "l10n_br_fiscal.cnae_211"),
    ("l10n_br_account.l10n_br_cnae_594", "l10n_br_fiscal.cnae_21106"),
    ("l10n_br_account.l10n_br_cnae_595", "l10n_br_fiscal.cnae_2110600"),
    ("l10n_br_account.l10n_br_cnae_596", "l10n_br_fiscal.cnae_212"),
    ("l10n_br_account.l10n_br_cnae_597", "l10n_br_fiscal.cnae_21211"),
    ("l10n_br_account.l10n_br_cnae_598", "l10n_br_fiscal.cnae_2121101"),
    ("l10n_br_account.l10n_br_cnae_599", "l10n_br_fiscal.cnae_2121102"),
    ("l10n_br_account.l10n_br_cnae_600", "l10n_br_fiscal.cnae_2121103"),
    ("l10n_br_account.l10n_br_cnae_601", "l10n_br_fiscal.cnae_21220"),
    ("l10n_br_account.l10n_br_cnae_602", "l10n_br_fiscal.cnae_2122000"),
    ("l10n_br_account.l10n_br_cnae_603", "l10n_br_fiscal.cnae_21238"),
    ("l10n_br_account.l10n_br_cnae_604", "l10n_br_fiscal.cnae_2123800"),
    ("l10n_br_account.l10n_br_cnae_605", "l10n_br_fiscal.cnae_22"),
    ("l10n_br_account.l10n_br_cnae_606", "l10n_br_fiscal.cnae_221"),
    ("l10n_br_account.l10n_br_cnae_607", "l10n_br_fiscal.cnae_22111"),
    ("l10n_br_account.l10n_br_cnae_608", "l10n_br_fiscal.cnae_2211100"),
    ("l10n_br_account.l10n_br_cnae_609", "l10n_br_fiscal.cnae_22129"),
    ("l10n_br_account.l10n_br_cnae_610", "l10n_br_fiscal.cnae_2212900"),
    ("l10n_br_account.l10n_br_cnae_611", "l10n_br_fiscal.cnae_22196"),
    ("l10n_br_account.l10n_br_cnae_612", "l10n_br_fiscal.cnae_2219600"),
    ("l10n_br_account.l10n_br_cnae_613", "l10n_br_fiscal.cnae_222"),
    ("l10n_br_account.l10n_br_cnae_614", "l10n_br_fiscal.cnae_22218"),
    ("l10n_br_account.l10n_br_cnae_615", "l10n_br_fiscal.cnae_2221800"),
    ("l10n_br_account.l10n_br_cnae_616", "l10n_br_fiscal.cnae_22226"),
    ("l10n_br_account.l10n_br_cnae_617", "l10n_br_fiscal.cnae_2222600"),
    ("l10n_br_account.l10n_br_cnae_618", "l10n_br_fiscal.cnae_22234"),
    ("l10n_br_account.l10n_br_cnae_619", "l10n_br_fiscal.cnae_2223400"),
    ("l10n_br_account.l10n_br_cnae_620", "l10n_br_fiscal.cnae_22293"),
    ("l10n_br_account.l10n_br_cnae_621", "l10n_br_fiscal.cnae_2229301"),
    ("l10n_br_account.l10n_br_cnae_622", "l10n_br_fiscal.cnae_2229302"),
    ("l10n_br_account.l10n_br_cnae_623", "l10n_br_fiscal.cnae_2229303"),
    ("l10n_br_account.l10n_br_cnae_624", "l10n_br_fiscal.cnae_2229399"),
    ("l10n_br_account.l10n_br_cnae_625", "l10n_br_fiscal.cnae_23"),
    ("l10n_br_account.l10n_br_cnae_626", "l10n_br_fiscal.cnae_231"),
    ("l10n_br_account.l10n_br_cnae_627", "l10n_br_fiscal.cnae_23117"),
    ("l10n_br_account.l10n_br_cnae_628", "l10n_br_fiscal.cnae_2311700"),
    ("l10n_br_account.l10n_br_cnae_629", "l10n_br_fiscal.cnae_23125"),
    ("l10n_br_account.l10n_br_cnae_630", "l10n_br_fiscal.cnae_2312500"),
    ("l10n_br_account.l10n_br_cnae_631", "l10n_br_fiscal.cnae_23192"),
    ("l10n_br_account.l10n_br_cnae_632", "l10n_br_fiscal.cnae_2319200"),
    ("l10n_br_account.l10n_br_cnae_633", "l10n_br_fiscal.cnae_232"),
    ("l10n_br_account.l10n_br_cnae_634", "l10n_br_fiscal.cnae_23206"),
    ("l10n_br_account.l10n_br_cnae_635", "l10n_br_fiscal.cnae_2320600"),
    ("l10n_br_account.l10n_br_cnae_636", "l10n_br_fiscal.cnae_233"),
    ("l10n_br_account.l10n_br_cnae_637", "l10n_br_fiscal.cnae_23303"),
    ("l10n_br_account.l10n_br_cnae_638", "l10n_br_fiscal.cnae_2330301"),
    ("l10n_br_account.l10n_br_cnae_639", "l10n_br_fiscal.cnae_2330302"),
    ("l10n_br_account.l10n_br_cnae_640", "l10n_br_fiscal.cnae_2330303"),
    ("l10n_br_account.l10n_br_cnae_641", "l10n_br_fiscal.cnae_2330304"),
    ("l10n_br_account.l10n_br_cnae_642", "l10n_br_fiscal.cnae_2330305"),
    ("l10n_br_account.l10n_br_cnae_643", "l10n_br_fiscal.cnae_2330399"),
    ("l10n_br_account.l10n_br_cnae_644", "l10n_br_fiscal.cnae_234"),
    ("l10n_br_account.l10n_br_cnae_645", "l10n_br_fiscal.cnae_23419"),
    ("l10n_br_account.l10n_br_cnae_646", "l10n_br_fiscal.cnae_2341900"),
    ("l10n_br_account.l10n_br_cnae_647", "l10n_br_fiscal.cnae_23427"),
    ("l10n_br_account.l10n_br_cnae_648", "l10n_br_fiscal.cnae_2342701"),
    ("l10n_br_account.l10n_br_cnae_649", "l10n_br_fiscal.cnae_2342702"),
    ("l10n_br_account.l10n_br_cnae_650", "l10n_br_fiscal.cnae_23494"),
    ("l10n_br_account.l10n_br_cnae_651", "l10n_br_fiscal.cnae_2349401"),
    ("l10n_br_account.l10n_br_cnae_652", "l10n_br_fiscal.cnae_2349499"),
    ("l10n_br_account.l10n_br_cnae_653", "l10n_br_fiscal.cnae_239"),
    ("l10n_br_account.l10n_br_cnae_654", "l10n_br_fiscal.cnae_23915"),
    ("l10n_br_account.l10n_br_cnae_655", "l10n_br_fiscal.cnae_2391501"),
    ("l10n_br_account.l10n_br_cnae_656", "l10n_br_fiscal.cnae_2391502"),
    ("l10n_br_account.l10n_br_cnae_657", "l10n_br_fiscal.cnae_2391503"),
    ("l10n_br_account.l10n_br_cnae_658", "l10n_br_fiscal.cnae_23923"),
    ("l10n_br_account.l10n_br_cnae_659", "l10n_br_fiscal.cnae_2392300"),
    ("l10n_br_account.l10n_br_cnae_660", "l10n_br_fiscal.cnae_23991"),
    ("l10n_br_account.l10n_br_cnae_661", "l10n_br_fiscal.cnae_2399101"),
    ("l10n_br_account.l10n_br_cnae_662", "l10n_br_fiscal.cnae_2399199"),
    ("l10n_br_account.l10n_br_cnae_663", "l10n_br_fiscal.cnae_24"),
    ("l10n_br_account.l10n_br_cnae_664", "l10n_br_fiscal.cnae_241"),
    ("l10n_br_account.l10n_br_cnae_665", "l10n_br_fiscal.cnae_24113"),
    ("l10n_br_account.l10n_br_cnae_666", "l10n_br_fiscal.cnae_2411300"),
    ("l10n_br_account.l10n_br_cnae_667", "l10n_br_fiscal.cnae_24121"),
    ("l10n_br_account.l10n_br_cnae_668", "l10n_br_fiscal.cnae_2412100"),
    ("l10n_br_account.l10n_br_cnae_669", "l10n_br_fiscal.cnae_242"),
    ("l10n_br_account.l10n_br_cnae_670", "l10n_br_fiscal.cnae_24211"),
    ("l10n_br_account.l10n_br_cnae_671", "l10n_br_fiscal.cnae_2421100"),
    ("l10n_br_account.l10n_br_cnae_672", "l10n_br_fiscal.cnae_24229"),
    ("l10n_br_account.l10n_br_cnae_673", "l10n_br_fiscal.cnae_2422901"),
    ("l10n_br_account.l10n_br_cnae_674", "l10n_br_fiscal.cnae_2422902"),
    ("l10n_br_account.l10n_br_cnae_675", "l10n_br_fiscal.cnae_24237"),
    ("l10n_br_account.l10n_br_cnae_676", "l10n_br_fiscal.cnae_2423701"),
    ("l10n_br_account.l10n_br_cnae_677", "l10n_br_fiscal.cnae_2423702"),
    ("l10n_br_account.l10n_br_cnae_678", "l10n_br_fiscal.cnae_24245"),
    ("l10n_br_account.l10n_br_cnae_679", "l10n_br_fiscal.cnae_2424501"),
    ("l10n_br_account.l10n_br_cnae_680", "l10n_br_fiscal.cnae_2424502"),
    ("l10n_br_account.l10n_br_cnae_681", "l10n_br_fiscal.cnae_243"),
    ("l10n_br_account.l10n_br_cnae_682", "l10n_br_fiscal.cnae_24318"),
    ("l10n_br_account.l10n_br_cnae_683", "l10n_br_fiscal.cnae_2431800"),
    ("l10n_br_account.l10n_br_cnae_684", "l10n_br_fiscal.cnae_24393"),
    ("l10n_br_account.l10n_br_cnae_685", "l10n_br_fiscal.cnae_2439300"),
    ("l10n_br_account.l10n_br_cnae_686", "l10n_br_fiscal.cnae_244"),
    ("l10n_br_account.l10n_br_cnae_687", "l10n_br_fiscal.cnae_24415"),
    ("l10n_br_account.l10n_br_cnae_688", "l10n_br_fiscal.cnae_2441501"),
    ("l10n_br_account.l10n_br_cnae_689", "l10n_br_fiscal.cnae_2441502"),
    ("l10n_br_account.l10n_br_cnae_690", "l10n_br_fiscal.cnae_24423"),
    ("l10n_br_account.l10n_br_cnae_691", "l10n_br_fiscal.cnae_2442300"),
    ("l10n_br_account.l10n_br_cnae_692", "l10n_br_fiscal.cnae_24431"),
    ("l10n_br_account.l10n_br_cnae_693", "l10n_br_fiscal.cnae_2443100"),
    ("l10n_br_account.l10n_br_cnae_694", "l10n_br_fiscal.cnae_24491"),
    ("l10n_br_account.l10n_br_cnae_695", "l10n_br_fiscal.cnae_2449101"),
    ("l10n_br_account.l10n_br_cnae_696", "l10n_br_fiscal.cnae_2449102"),
    ("l10n_br_account.l10n_br_cnae_697", "l10n_br_fiscal.cnae_2449103"),
    ("l10n_br_account.l10n_br_cnae_698", "l10n_br_fiscal.cnae_2449199"),
    ("l10n_br_account.l10n_br_cnae_699", "l10n_br_fiscal.cnae_245"),
    ("l10n_br_account.l10n_br_cnae_700", "l10n_br_fiscal.cnae_24512"),
    ("l10n_br_account.l10n_br_cnae_701", "l10n_br_fiscal.cnae_2451200"),
    ("l10n_br_account.l10n_br_cnae_702", "l10n_br_fiscal.cnae_24521"),
    ("l10n_br_account.l10n_br_cnae_703", "l10n_br_fiscal.cnae_2452100"),
    ("l10n_br_account.l10n_br_cnae_704", "l10n_br_fiscal.cnae_25"),
    ("l10n_br_account.l10n_br_cnae_705", "l10n_br_fiscal.cnae_251"),
    ("l10n_br_account.l10n_br_cnae_706", "l10n_br_fiscal.cnae_25110"),
    ("l10n_br_account.l10n_br_cnae_707", "l10n_br_fiscal.cnae_2511000"),
    ("l10n_br_account.l10n_br_cnae_708", "l10n_br_fiscal.cnae_25128"),
    ("l10n_br_account.l10n_br_cnae_709", "l10n_br_fiscal.cnae_2512800"),
    ("l10n_br_account.l10n_br_cnae_710", "l10n_br_fiscal.cnae_25136"),
    ("l10n_br_account.l10n_br_cnae_711", "l10n_br_fiscal.cnae_2513600"),
    ("l10n_br_account.l10n_br_cnae_712", "l10n_br_fiscal.cnae_252"),
    ("l10n_br_account.l10n_br_cnae_713", "l10n_br_fiscal.cnae_25217"),
    ("l10n_br_account.l10n_br_cnae_714", "l10n_br_fiscal.cnae_2521700"),
    ("l10n_br_account.l10n_br_cnae_715", "l10n_br_fiscal.cnae_25225"),
    ("l10n_br_account.l10n_br_cnae_716", "l10n_br_fiscal.cnae_2522500"),
    ("l10n_br_account.l10n_br_cnae_717", "l10n_br_fiscal.cnae_253"),
    ("l10n_br_account.l10n_br_cnae_718", "l10n_br_fiscal.cnae_25314"),
    ("l10n_br_account.l10n_br_cnae_719", "l10n_br_fiscal.cnae_2531401"),
    ("l10n_br_account.l10n_br_cnae_720", "l10n_br_fiscal.cnae_2531402"),
    ("l10n_br_account.l10n_br_cnae_721", "l10n_br_fiscal.cnae_25322"),
    ("l10n_br_account.l10n_br_cnae_722", "l10n_br_fiscal.cnae_2532201"),
    ("l10n_br_account.l10n_br_cnae_723", "l10n_br_fiscal.cnae_2532202"),
    ("l10n_br_account.l10n_br_cnae_724", "l10n_br_fiscal.cnae_25390"),
    ("l10n_br_account.l10n_br_cnae_725", "l10n_br_fiscal.cnae_2539000"),
    ("l10n_br_account.l10n_br_cnae_726", "l10n_br_fiscal.cnae_254"),
    ("l10n_br_account.l10n_br_cnae_727", "l10n_br_fiscal.cnae_25411"),
    ("l10n_br_account.l10n_br_cnae_728", "l10n_br_fiscal.cnae_2541100"),
    ("l10n_br_account.l10n_br_cnae_729", "l10n_br_fiscal.cnae_25420"),
    ("l10n_br_account.l10n_br_cnae_730", "l10n_br_fiscal.cnae_2542000"),
    ("l10n_br_account.l10n_br_cnae_731", "l10n_br_fiscal.cnae_25438"),
    ("l10n_br_account.l10n_br_cnae_732", "l10n_br_fiscal.cnae_2543800"),
    ("l10n_br_account.l10n_br_cnae_733", "l10n_br_fiscal.cnae_255"),
    ("l10n_br_account.l10n_br_cnae_734", "l10n_br_fiscal.cnae_25501"),
    ("l10n_br_account.l10n_br_cnae_735", "l10n_br_fiscal.cnae_2550101"),
    ("l10n_br_account.l10n_br_cnae_736", "l10n_br_fiscal.cnae_2550102"),
    ("l10n_br_account.l10n_br_cnae_737", "l10n_br_fiscal.cnae_259"),
    ("l10n_br_account.l10n_br_cnae_738", "l10n_br_fiscal.cnae_25918"),
    ("l10n_br_account.l10n_br_cnae_739", "l10n_br_fiscal.cnae_2591800"),
    ("l10n_br_account.l10n_br_cnae_740", "l10n_br_fiscal.cnae_25926"),
    ("l10n_br_account.l10n_br_cnae_741", "l10n_br_fiscal.cnae_2592601"),
    ("l10n_br_account.l10n_br_cnae_742", "l10n_br_fiscal.cnae_2592602"),
    ("l10n_br_account.l10n_br_cnae_743", "l10n_br_fiscal.cnae_25934"),
    ("l10n_br_account.l10n_br_cnae_744", "l10n_br_fiscal.cnae_2593400"),
    ("l10n_br_account.l10n_br_cnae_745", "l10n_br_fiscal.cnae_25993"),
    ("l10n_br_account.l10n_br_cnae_746", "l10n_br_fiscal.cnae_2599301"),
    ("l10n_br_account.l10n_br_cnae_747", "l10n_br_fiscal.cnae_2599399"),
    ("l10n_br_account.l10n_br_cnae_748", "l10n_br_fiscal.cnae_26"),
    ("l10n_br_account.l10n_br_cnae_749", "l10n_br_fiscal.cnae_261"),
    ("l10n_br_account.l10n_br_cnae_750", "l10n_br_fiscal.cnae_26108"),
    ("l10n_br_account.l10n_br_cnae_751", "l10n_br_fiscal.cnae_2610800"),
    ("l10n_br_account.l10n_br_cnae_752", "l10n_br_fiscal.cnae_262"),
    ("l10n_br_account.l10n_br_cnae_753", "l10n_br_fiscal.cnae_26213"),
    ("l10n_br_account.l10n_br_cnae_754", "l10n_br_fiscal.cnae_2621300"),
    ("l10n_br_account.l10n_br_cnae_755", "l10n_br_fiscal.cnae_26221"),
    ("l10n_br_account.l10n_br_cnae_756", "l10n_br_fiscal.cnae_2622100"),
    ("l10n_br_account.l10n_br_cnae_757", "l10n_br_fiscal.cnae_263"),
    ("l10n_br_account.l10n_br_cnae_758", "l10n_br_fiscal.cnae_26311"),
    ("l10n_br_account.l10n_br_cnae_759", "l10n_br_fiscal.cnae_2631100"),
    ("l10n_br_account.l10n_br_cnae_760", "l10n_br_fiscal.cnae_26329"),
    ("l10n_br_account.l10n_br_cnae_761", "l10n_br_fiscal.cnae_2632900"),
    ("l10n_br_account.l10n_br_cnae_762", "l10n_br_fiscal.cnae_264"),
    ("l10n_br_account.l10n_br_cnae_763", "l10n_br_fiscal.cnae_26400"),
    ("l10n_br_account.l10n_br_cnae_764", "l10n_br_fiscal.cnae_2640000"),
    ("l10n_br_account.l10n_br_cnae_765", "l10n_br_fiscal.cnae_265"),
    ("l10n_br_account.l10n_br_cnae_766", "l10n_br_fiscal.cnae_26515"),
    ("l10n_br_account.l10n_br_cnae_767", "l10n_br_fiscal.cnae_2651500"),
    ("l10n_br_account.l10n_br_cnae_768", "l10n_br_fiscal.cnae_26523"),
    ("l10n_br_account.l10n_br_cnae_769", "l10n_br_fiscal.cnae_2652300"),
    ("l10n_br_account.l10n_br_cnae_770", "l10n_br_fiscal.cnae_266"),
    ("l10n_br_account.l10n_br_cnae_771", "l10n_br_fiscal.cnae_26604"),
    ("l10n_br_account.l10n_br_cnae_772", "l10n_br_fiscal.cnae_2660400"),
    ("l10n_br_account.l10n_br_cnae_773", "l10n_br_fiscal.cnae_267"),
    ("l10n_br_account.l10n_br_cnae_774", "l10n_br_fiscal.cnae_26701"),
    ("l10n_br_account.l10n_br_cnae_775", "l10n_br_fiscal.cnae_2670101"),
    ("l10n_br_account.l10n_br_cnae_776", "l10n_br_fiscal.cnae_2670102"),
    ("l10n_br_account.l10n_br_cnae_777", "l10n_br_fiscal.cnae_268"),
    ("l10n_br_account.l10n_br_cnae_778", "l10n_br_fiscal.cnae_26809"),
    ("l10n_br_account.l10n_br_cnae_779", "l10n_br_fiscal.cnae_2680900"),
    ("l10n_br_account.l10n_br_cnae_780", "l10n_br_fiscal.cnae_27"),
    ("l10n_br_account.l10n_br_cnae_781", "l10n_br_fiscal.cnae_271"),
    ("l10n_br_account.l10n_br_cnae_782", "l10n_br_fiscal.cnae_27104"),
    ("l10n_br_account.l10n_br_cnae_783", "l10n_br_fiscal.cnae_2710401"),
    ("l10n_br_account.l10n_br_cnae_784", "l10n_br_fiscal.cnae_2710402"),
    ("l10n_br_account.l10n_br_cnae_785", "l10n_br_fiscal.cnae_2710403"),
    ("l10n_br_account.l10n_br_cnae_786", "l10n_br_fiscal.cnae_272"),
    ("l10n_br_account.l10n_br_cnae_787", "l10n_br_fiscal.cnae_27210"),
    ("l10n_br_account.l10n_br_cnae_788", "l10n_br_fiscal.cnae_2721000"),
    ("l10n_br_account.l10n_br_cnae_789", "l10n_br_fiscal.cnae_27228"),
    ("l10n_br_account.l10n_br_cnae_790", "l10n_br_fiscal.cnae_2722801"),
    ("l10n_br_account.l10n_br_cnae_791", "l10n_br_fiscal.cnae_2722802"),
    ("l10n_br_account.l10n_br_cnae_792", "l10n_br_fiscal.cnae_273"),
    ("l10n_br_account.l10n_br_cnae_793", "l10n_br_fiscal.cnae_27317"),
    ("l10n_br_account.l10n_br_cnae_794", "l10n_br_fiscal.cnae_2731700"),
    ("l10n_br_account.l10n_br_cnae_795", "l10n_br_fiscal.cnae_27325"),
    ("l10n_br_account.l10n_br_cnae_796", "l10n_br_fiscal.cnae_2732500"),
    ("l10n_br_account.l10n_br_cnae_797", "l10n_br_fiscal.cnae_27333"),
    ("l10n_br_account.l10n_br_cnae_798", "l10n_br_fiscal.cnae_2733300"),
    ("l10n_br_account.l10n_br_cnae_799", "l10n_br_fiscal.cnae_274"),
    ("l10n_br_account.l10n_br_cnae_800", "l10n_br_fiscal.cnae_27406"),
    ("l10n_br_account.l10n_br_cnae_801", "l10n_br_fiscal.cnae_2740601"),
    ("l10n_br_account.l10n_br_cnae_802", "l10n_br_fiscal.cnae_2740602"),
    ("l10n_br_account.l10n_br_cnae_803", "l10n_br_fiscal.cnae_275"),
    ("l10n_br_account.l10n_br_cnae_804", "l10n_br_fiscal.cnae_27511"),
    ("l10n_br_account.l10n_br_cnae_805", "l10n_br_fiscal.cnae_2751100"),
    ("l10n_br_account.l10n_br_cnae_806", "l10n_br_fiscal.cnae_27597"),
    ("l10n_br_account.l10n_br_cnae_807", "l10n_br_fiscal.cnae_2759701"),
    ("l10n_br_account.l10n_br_cnae_808", "l10n_br_fiscal.cnae_2759799"),
    ("l10n_br_account.l10n_br_cnae_809", "l10n_br_fiscal.cnae_279"),
    ("l10n_br_account.l10n_br_cnae_810", "l10n_br_fiscal.cnae_27902"),
    ("l10n_br_account.l10n_br_cnae_811", "l10n_br_fiscal.cnae_2790201"),
    ("l10n_br_account.l10n_br_cnae_812", "l10n_br_fiscal.cnae_2790202"),
    ("l10n_br_account.l10n_br_cnae_813", "l10n_br_fiscal.cnae_2790299"),
    ("l10n_br_account.l10n_br_cnae_814", "l10n_br_fiscal.cnae_28"),
    ("l10n_br_account.l10n_br_cnae_815", "l10n_br_fiscal.cnae_281"),
    ("l10n_br_account.l10n_br_cnae_816", "l10n_br_fiscal.cnae_28119"),
    ("l10n_br_account.l10n_br_cnae_817", "l10n_br_fiscal.cnae_2811900"),
    ("l10n_br_account.l10n_br_cnae_818", "l10n_br_fiscal.cnae_28127"),
    ("l10n_br_account.l10n_br_cnae_819", "l10n_br_fiscal.cnae_2812700"),
    ("l10n_br_account.l10n_br_cnae_820", "l10n_br_fiscal.cnae_28135"),
    ("l10n_br_account.l10n_br_cnae_821", "l10n_br_fiscal.cnae_2813500"),
    ("l10n_br_account.l10n_br_cnae_822", "l10n_br_fiscal.cnae_28143"),
    ("l10n_br_account.l10n_br_cnae_823", "l10n_br_fiscal.cnae_2814301"),
    ("l10n_br_account.l10n_br_cnae_824", "l10n_br_fiscal.cnae_2814302"),
    ("l10n_br_account.l10n_br_cnae_825", "l10n_br_fiscal.cnae_28151"),
    ("l10n_br_account.l10n_br_cnae_826", "l10n_br_fiscal.cnae_2815101"),
    ("l10n_br_account.l10n_br_cnae_827", "l10n_br_fiscal.cnae_2815102"),
    ("l10n_br_account.l10n_br_cnae_828", "l10n_br_fiscal.cnae_282"),
    ("l10n_br_account.l10n_br_cnae_829", "l10n_br_fiscal.cnae_28216"),
    ("l10n_br_account.l10n_br_cnae_830", "l10n_br_fiscal.cnae_2821601"),
    ("l10n_br_account.l10n_br_cnae_831", "l10n_br_fiscal.cnae_2821602"),
    ("l10n_br_account.l10n_br_cnae_832", "l10n_br_fiscal.cnae_28224"),
    ("l10n_br_account.l10n_br_cnae_833", "l10n_br_fiscal.cnae_2822401"),
    ("l10n_br_account.l10n_br_cnae_834", "l10n_br_fiscal.cnae_2822402"),
    ("l10n_br_account.l10n_br_cnae_835", "l10n_br_fiscal.cnae_28232"),
    ("l10n_br_account.l10n_br_cnae_836", "l10n_br_fiscal.cnae_2823200"),
    ("l10n_br_account.l10n_br_cnae_837", "l10n_br_fiscal.cnae_28241"),
    ("l10n_br_account.l10n_br_cnae_838", "l10n_br_fiscal.cnae_2824101"),
    ("l10n_br_account.l10n_br_cnae_839", "l10n_br_fiscal.cnae_2824102"),
    ("l10n_br_account.l10n_br_cnae_840", "l10n_br_fiscal.cnae_28259"),
    ("l10n_br_account.l10n_br_cnae_841", "l10n_br_fiscal.cnae_2825900"),
    ("l10n_br_account.l10n_br_cnae_842", "l10n_br_fiscal.cnae_28291"),
    ("l10n_br_account.l10n_br_cnae_843", "l10n_br_fiscal.cnae_2829101"),
    ("l10n_br_account.l10n_br_cnae_844", "l10n_br_fiscal.cnae_2829199"),
    ("l10n_br_account.l10n_br_cnae_845", "l10n_br_fiscal.cnae_283"),
    ("l10n_br_account.l10n_br_cnae_846", "l10n_br_fiscal.cnae_28313"),
    ("l10n_br_account.l10n_br_cnae_847", "l10n_br_fiscal.cnae_2831300"),
    ("l10n_br_account.l10n_br_cnae_848", "l10n_br_fiscal.cnae_28321"),
    ("l10n_br_account.l10n_br_cnae_849", "l10n_br_fiscal.cnae_2832100"),
    ("l10n_br_account.l10n_br_cnae_850", "l10n_br_fiscal.cnae_28330"),
    ("l10n_br_account.l10n_br_cnae_851", "l10n_br_fiscal.cnae_2833000"),
    ("l10n_br_account.l10n_br_cnae_852", "l10n_br_fiscal.cnae_284"),
    ("l10n_br_account.l10n_br_cnae_853", "l10n_br_fiscal.cnae_28402"),
    ("l10n_br_account.l10n_br_cnae_854", "l10n_br_fiscal.cnae_2840200"),
    ("l10n_br_account.l10n_br_cnae_855", "l10n_br_fiscal.cnae_285"),
    ("l10n_br_account.l10n_br_cnae_856", "l10n_br_fiscal.cnae_28518"),
    ("l10n_br_account.l10n_br_cnae_857", "l10n_br_fiscal.cnae_2851800"),
    ("l10n_br_account.l10n_br_cnae_858", "l10n_br_fiscal.cnae_28526"),
    ("l10n_br_account.l10n_br_cnae_859", "l10n_br_fiscal.cnae_2852600"),
    ("l10n_br_account.l10n_br_cnae_860", "l10n_br_fiscal.cnae_28534"),
    ("l10n_br_account.l10n_br_cnae_861", "l10n_br_fiscal.cnae_2853400"),
    ("l10n_br_account.l10n_br_cnae_862", "l10n_br_fiscal.cnae_28542"),
    ("l10n_br_account.l10n_br_cnae_863", "l10n_br_fiscal.cnae_2854200"),
    ("l10n_br_account.l10n_br_cnae_864", "l10n_br_fiscal.cnae_286"),
    ("l10n_br_account.l10n_br_cnae_865", "l10n_br_fiscal.cnae_28615"),
    ("l10n_br_account.l10n_br_cnae_866", "l10n_br_fiscal.cnae_2861500"),
    ("l10n_br_account.l10n_br_cnae_867", "l10n_br_fiscal.cnae_28623"),
    ("l10n_br_account.l10n_br_cnae_868", "l10n_br_fiscal.cnae_2862300"),
    ("l10n_br_account.l10n_br_cnae_869", "l10n_br_fiscal.cnae_28631"),
    ("l10n_br_account.l10n_br_cnae_870", "l10n_br_fiscal.cnae_2863100"),
    ("l10n_br_account.l10n_br_cnae_871", "l10n_br_fiscal.cnae_28640"),
    ("l10n_br_account.l10n_br_cnae_872", "l10n_br_fiscal.cnae_2864000"),
    ("l10n_br_account.l10n_br_cnae_873", "l10n_br_fiscal.cnae_28658"),
    ("l10n_br_account.l10n_br_cnae_874", "l10n_br_fiscal.cnae_2865800"),
    ("l10n_br_account.l10n_br_cnae_875", "l10n_br_fiscal.cnae_28666"),
    ("l10n_br_account.l10n_br_cnae_876", "l10n_br_fiscal.cnae_2866600"),
    ("l10n_br_account.l10n_br_cnae_877", "l10n_br_fiscal.cnae_28691"),
    ("l10n_br_account.l10n_br_cnae_878", "l10n_br_fiscal.cnae_2869100"),
    ("l10n_br_account.l10n_br_cnae_879", "l10n_br_fiscal.cnae_29"),
    ("l10n_br_account.l10n_br_cnae_880", "l10n_br_fiscal.cnae_291"),
    ("l10n_br_account.l10n_br_cnae_881", "l10n_br_fiscal.cnae_29107"),
    ("l10n_br_account.l10n_br_cnae_882", "l10n_br_fiscal.cnae_2910701"),
    ("l10n_br_account.l10n_br_cnae_883", "l10n_br_fiscal.cnae_2910702"),
    ("l10n_br_account.l10n_br_cnae_884", "l10n_br_fiscal.cnae_2910703"),
    ("l10n_br_account.l10n_br_cnae_885", "l10n_br_fiscal.cnae_292"),
    ("l10n_br_account.l10n_br_cnae_886", "l10n_br_fiscal.cnae_29204"),
    ("l10n_br_account.l10n_br_cnae_887", "l10n_br_fiscal.cnae_2920401"),
    ("l10n_br_account.l10n_br_cnae_888", "l10n_br_fiscal.cnae_2920402"),
    ("l10n_br_account.l10n_br_cnae_889", "l10n_br_fiscal.cnae_293"),
    ("l10n_br_account.l10n_br_cnae_890", "l10n_br_fiscal.cnae_29301"),
    ("l10n_br_account.l10n_br_cnae_891", "l10n_br_fiscal.cnae_2930101"),
    ("l10n_br_account.l10n_br_cnae_892", "l10n_br_fiscal.cnae_2930102"),
    ("l10n_br_account.l10n_br_cnae_893", "l10n_br_fiscal.cnae_2930103"),
    ("l10n_br_account.l10n_br_cnae_894", "l10n_br_fiscal.cnae_294"),
    ("l10n_br_account.l10n_br_cnae_895", "l10n_br_fiscal.cnae_29417"),
    ("l10n_br_account.l10n_br_cnae_896", "l10n_br_fiscal.cnae_2941700"),
    ("l10n_br_account.l10n_br_cnae_897", "l10n_br_fiscal.cnae_29425"),
    ("l10n_br_account.l10n_br_cnae_898", "l10n_br_fiscal.cnae_2942500"),
    ("l10n_br_account.l10n_br_cnae_899", "l10n_br_fiscal.cnae_29433"),
    ("l10n_br_account.l10n_br_cnae_900", "l10n_br_fiscal.cnae_2943300"),
    ("l10n_br_account.l10n_br_cnae_901", "l10n_br_fiscal.cnae_29441"),
    ("l10n_br_account.l10n_br_cnae_902", "l10n_br_fiscal.cnae_2944100"),
    ("l10n_br_account.l10n_br_cnae_903", "l10n_br_fiscal.cnae_29450"),
    ("l10n_br_account.l10n_br_cnae_904", "l10n_br_fiscal.cnae_2945000"),
    ("l10n_br_account.l10n_br_cnae_905", "l10n_br_fiscal.cnae_29492"),
    ("l10n_br_account.l10n_br_cnae_906", "l10n_br_fiscal.cnae_2949201"),
    ("l10n_br_account.l10n_br_cnae_907", "l10n_br_fiscal.cnae_2949299"),
    ("l10n_br_account.l10n_br_cnae_908", "l10n_br_fiscal.cnae_295"),
    ("l10n_br_account.l10n_br_cnae_909", "l10n_br_fiscal.cnae_29506"),
    ("l10n_br_account.l10n_br_cnae_910", "l10n_br_fiscal.cnae_2950600"),
    ("l10n_br_account.l10n_br_cnae_911", "l10n_br_fiscal.cnae_30"),
    ("l10n_br_account.l10n_br_cnae_912", "l10n_br_fiscal.cnae_301"),
    ("l10n_br_account.l10n_br_cnae_913", "l10n_br_fiscal.cnae_30113"),
    ("l10n_br_account.l10n_br_cnae_914", "l10n_br_fiscal.cnae_3011301"),
    ("l10n_br_account.l10n_br_cnae_915", "l10n_br_fiscal.cnae_3011302"),
    ("l10n_br_account.l10n_br_cnae_916", "l10n_br_fiscal.cnae_30121"),
    ("l10n_br_account.l10n_br_cnae_917", "l10n_br_fiscal.cnae_3012100"),
    ("l10n_br_account.l10n_br_cnae_918", "l10n_br_fiscal.cnae_303"),
    ("l10n_br_account.l10n_br_cnae_919", "l10n_br_fiscal.cnae_30318"),
    ("l10n_br_account.l10n_br_cnae_920", "l10n_br_fiscal.cnae_3031800"),
    ("l10n_br_account.l10n_br_cnae_921", "l10n_br_fiscal.cnae_30326"),
    ("l10n_br_account.l10n_br_cnae_922", "l10n_br_fiscal.cnae_3032600"),
    ("l10n_br_account.l10n_br_cnae_923", "l10n_br_fiscal.cnae_304"),
    ("l10n_br_account.l10n_br_cnae_924", "l10n_br_fiscal.cnae_30415"),
    ("l10n_br_account.l10n_br_cnae_925", "l10n_br_fiscal.cnae_3041500"),
    ("l10n_br_account.l10n_br_cnae_926", "l10n_br_fiscal.cnae_30423"),
    ("l10n_br_account.l10n_br_cnae_927", "l10n_br_fiscal.cnae_3042300"),
    ("l10n_br_account.l10n_br_cnae_928", "l10n_br_fiscal.cnae_305"),
    ("l10n_br_account.l10n_br_cnae_929", "l10n_br_fiscal.cnae_30504"),
    ("l10n_br_account.l10n_br_cnae_930", "l10n_br_fiscal.cnae_3050400"),
    ("l10n_br_account.l10n_br_cnae_931", "l10n_br_fiscal.cnae_309"),
    ("l10n_br_account.l10n_br_cnae_932", "l10n_br_fiscal.cnae_30911"),
    ("l10n_br_account.l10n_br_cnae_933", "l10n_br_fiscal.cnae_3091100"),
    ("l10n_br_account.l10n_br_cnae_934", "l10n_br_fiscal.cnae_30920"),
    ("l10n_br_account.l10n_br_cnae_935", "l10n_br_fiscal.cnae_3092000"),
    ("l10n_br_account.l10n_br_cnae_936", "l10n_br_fiscal.cnae_30997"),
    ("l10n_br_account.l10n_br_cnae_937", "l10n_br_fiscal.cnae_3099700"),
    ("l10n_br_account.l10n_br_cnae_938", "l10n_br_fiscal.cnae_31"),
    ("l10n_br_account.l10n_br_cnae_939", "l10n_br_fiscal.cnae_310"),
    ("l10n_br_account.l10n_br_cnae_940", "l10n_br_fiscal.cnae_31012"),
    ("l10n_br_account.l10n_br_cnae_941", "l10n_br_fiscal.cnae_3101200"),
    ("l10n_br_account.l10n_br_cnae_942", "l10n_br_fiscal.cnae_31021"),
    ("l10n_br_account.l10n_br_cnae_943", "l10n_br_fiscal.cnae_3102100"),
    ("l10n_br_account.l10n_br_cnae_944", "l10n_br_fiscal.cnae_31039"),
    ("l10n_br_account.l10n_br_cnae_945", "l10n_br_fiscal.cnae_3103900"),
    ("l10n_br_account.l10n_br_cnae_946", "l10n_br_fiscal.cnae_31047"),
    ("l10n_br_account.l10n_br_cnae_947", "l10n_br_fiscal.cnae_3104700"),
    ("l10n_br_account.l10n_br_cnae_948", "l10n_br_fiscal.cnae_32"),
    ("l10n_br_account.l10n_br_cnae_949", "l10n_br_fiscal.cnae_321"),
    ("l10n_br_account.l10n_br_cnae_950", "l10n_br_fiscal.cnae_32116"),
    ("l10n_br_account.l10n_br_cnae_951", "l10n_br_fiscal.cnae_3211601"),
    ("l10n_br_account.l10n_br_cnae_952", "l10n_br_fiscal.cnae_3211602"),
    ("l10n_br_account.l10n_br_cnae_953", "l10n_br_fiscal.cnae_3211603"),
    ("l10n_br_account.l10n_br_cnae_954", "l10n_br_fiscal.cnae_32124"),
    ("l10n_br_account.l10n_br_cnae_955", "l10n_br_fiscal.cnae_3212400"),
    ("l10n_br_account.l10n_br_cnae_956", "l10n_br_fiscal.cnae_322"),
    ("l10n_br_account.l10n_br_cnae_957", "l10n_br_fiscal.cnae_32205"),
    ("l10n_br_account.l10n_br_cnae_958", "l10n_br_fiscal.cnae_3220500"),
    ("l10n_br_account.l10n_br_cnae_959", "l10n_br_fiscal.cnae_323"),
    ("l10n_br_account.l10n_br_cnae_960", "l10n_br_fiscal.cnae_32302"),
    ("l10n_br_account.l10n_br_cnae_961", "l10n_br_fiscal.cnae_3230200"),
    ("l10n_br_account.l10n_br_cnae_962", "l10n_br_fiscal.cnae_324"),
    ("l10n_br_account.l10n_br_cnae_963", "l10n_br_fiscal.cnae_32400"),
    ("l10n_br_account.l10n_br_cnae_964", "l10n_br_fiscal.cnae_3240001"),
    ("l10n_br_account.l10n_br_cnae_965", "l10n_br_fiscal.cnae_3240002"),
    ("l10n_br_account.l10n_br_cnae_966", "l10n_br_fiscal.cnae_3240003"),
    ("l10n_br_account.l10n_br_cnae_967", "l10n_br_fiscal.cnae_3240099"),
    ("l10n_br_account.l10n_br_cnae_968", "l10n_br_fiscal.cnae_325"),
    ("l10n_br_account.l10n_br_cnae_969", "l10n_br_fiscal.cnae_32507"),
    ("l10n_br_account.l10n_br_cnae_970", "l10n_br_fiscal.cnae_3250701"),
    ("l10n_br_account.l10n_br_cnae_971", "l10n_br_fiscal.cnae_3250702"),
    ("l10n_br_account.l10n_br_cnae_972", "l10n_br_fiscal.cnae_3250703"),
    ("l10n_br_account.l10n_br_cnae_973", "l10n_br_fiscal.cnae_3250704"),
    ("l10n_br_account.l10n_br_cnae_974", "l10n_br_fiscal.cnae_3250705"),
    ("l10n_br_account.l10n_br_cnae_975", "l10n_br_fiscal.cnae_3250706"),
    ("l10n_br_account.l10n_br_cnae_976", "l10n_br_fiscal.cnae_3250707"),
    ("l10n_br_account.l10n_br_cnae_977", "l10n_br_fiscal.cnae_3250708"),
    ("l10n_br_account.l10n_br_cnae_978", "l10n_br_fiscal.cnae_329"),
    ("l10n_br_account.l10n_br_cnae_979", "l10n_br_fiscal.cnae_32914"),
    ("l10n_br_account.l10n_br_cnae_980", "l10n_br_fiscal.cnae_3291400"),
    ("l10n_br_account.l10n_br_cnae_981", "l10n_br_fiscal.cnae_32922"),
    ("l10n_br_account.l10n_br_cnae_982", "l10n_br_fiscal.cnae_3292201"),
    ("l10n_br_account.l10n_br_cnae_983", "l10n_br_fiscal.cnae_3292202"),
    ("l10n_br_account.l10n_br_cnae_984", "l10n_br_fiscal.cnae_32990"),
    ("l10n_br_account.l10n_br_cnae_985", "l10n_br_fiscal.cnae_3299001"),
    ("l10n_br_account.l10n_br_cnae_986", "l10n_br_fiscal.cnae_3299002"),
    ("l10n_br_account.l10n_br_cnae_987", "l10n_br_fiscal.cnae_3299003"),
    ("l10n_br_account.l10n_br_cnae_988", "l10n_br_fiscal.cnae_3299004"),
    ("l10n_br_account.l10n_br_cnae_989", "l10n_br_fiscal.cnae_3299005"),
    ("l10n_br_account.l10n_br_cnae_990", "l10n_br_fiscal.cnae_3299099"),
    ("l10n_br_account.l10n_br_cnae_991", "l10n_br_fiscal.cnae_33"),
    ("l10n_br_account.l10n_br_cnae_992", "l10n_br_fiscal.cnae_331"),
    ("l10n_br_account.l10n_br_cnae_993", "l10n_br_fiscal.cnae_33112"),
    ("l10n_br_account.l10n_br_cnae_994", "l10n_br_fiscal.cnae_3311200"),
    ("l10n_br_account.l10n_br_cnae_995", "l10n_br_fiscal.cnae_33121"),
    ("l10n_br_account.l10n_br_cnae_996", "l10n_br_fiscal.cnae_3312101"),
    ("l10n_br_account.l10n_br_cnae_997", "l10n_br_fiscal.cnae_3312102"),
    ("l10n_br_account.l10n_br_cnae_998", "l10n_br_fiscal.cnae_3312103"),
    ("l10n_br_account.l10n_br_cnae_999", "l10n_br_fiscal.cnae_3312104"),
    ("l10n_br_account.l10n_br_cnae_1000", "l10n_br_fiscal.cnae_33139"),
    ("l10n_br_account.l10n_br_cnae_1001", "l10n_br_fiscal.cnae_3313901"),
    ("l10n_br_account.l10n_br_cnae_1002", "l10n_br_fiscal.cnae_3313902"),
    ("l10n_br_account.l10n_br_cnae_1003", "l10n_br_fiscal.cnae_3313999"),
    ("l10n_br_account.l10n_br_cnae_1004", "l10n_br_fiscal.cnae_33147"),
    ("l10n_br_account.l10n_br_cnae_1005", "l10n_br_fiscal.cnae_3314701"),
    ("l10n_br_account.l10n_br_cnae_1006", "l10n_br_fiscal.cnae_3314702"),
    ("l10n_br_account.l10n_br_cnae_1007", "l10n_br_fiscal.cnae_3314703"),
    ("l10n_br_account.l10n_br_cnae_1008", "l10n_br_fiscal.cnae_3314704"),
    ("l10n_br_account.l10n_br_cnae_1009", "l10n_br_fiscal.cnae_3314705"),
    ("l10n_br_account.l10n_br_cnae_1010", "l10n_br_fiscal.cnae_3314706"),
    ("l10n_br_account.l10n_br_cnae_1011", "l10n_br_fiscal.cnae_3314707"),
    ("l10n_br_account.l10n_br_cnae_1012", "l10n_br_fiscal.cnae_3314708"),
    ("l10n_br_account.l10n_br_cnae_1013", "l10n_br_fiscal.cnae_3314709"),
    ("l10n_br_account.l10n_br_cnae_1014", "l10n_br_fiscal.cnae_3314710"),
    ("l10n_br_account.l10n_br_cnae_1015", "l10n_br_fiscal.cnae_3314711"),
    ("l10n_br_account.l10n_br_cnae_1016", "l10n_br_fiscal.cnae_3314712"),
    ("l10n_br_account.l10n_br_cnae_1017", "l10n_br_fiscal.cnae_3314713"),
    ("l10n_br_account.l10n_br_cnae_1018", "l10n_br_fiscal.cnae_3314714"),
    ("l10n_br_account.l10n_br_cnae_1019", "l10n_br_fiscal.cnae_3314715"),
    ("l10n_br_account.l10n_br_cnae_1020", "l10n_br_fiscal.cnae_3314716"),
    ("l10n_br_account.l10n_br_cnae_1021", "l10n_br_fiscal.cnae_3314717"),
    ("l10n_br_account.l10n_br_cnae_1022", "l10n_br_fiscal.cnae_3314718"),
    ("l10n_br_account.l10n_br_cnae_1023", "l10n_br_fiscal.cnae_3314719"),
    ("l10n_br_account.l10n_br_cnae_1024", "l10n_br_fiscal.cnae_3314720"),
    ("l10n_br_account.l10n_br_cnae_1025", "l10n_br_fiscal.cnae_3314721"),
    ("l10n_br_account.l10n_br_cnae_1026", "l10n_br_fiscal.cnae_3314722"),
    ("l10n_br_account.l10n_br_cnae_1027", "l10n_br_fiscal.cnae_3314799"),
    ("l10n_br_account.l10n_br_cnae_1028", "l10n_br_fiscal.cnae_33155"),
    ("l10n_br_account.l10n_br_cnae_1029", "l10n_br_fiscal.cnae_3315500"),
    ("l10n_br_account.l10n_br_cnae_1030", "l10n_br_fiscal.cnae_33163"),
    ("l10n_br_account.l10n_br_cnae_1031", "l10n_br_fiscal.cnae_3316301"),
    ("l10n_br_account.l10n_br_cnae_1032", "l10n_br_fiscal.cnae_3316302"),
    ("l10n_br_account.l10n_br_cnae_1033", "l10n_br_fiscal.cnae_33171"),
    ("l10n_br_account.l10n_br_cnae_1034", "l10n_br_fiscal.cnae_3317101"),
    ("l10n_br_account.l10n_br_cnae_1035", "l10n_br_fiscal.cnae_3317102"),
    ("l10n_br_account.l10n_br_cnae_1036", "l10n_br_fiscal.cnae_33198"),
    ("l10n_br_account.l10n_br_cnae_1037", "l10n_br_fiscal.cnae_3319800"),
    ("l10n_br_account.l10n_br_cnae_1038", "l10n_br_fiscal.cnae_332"),
    ("l10n_br_account.l10n_br_cnae_1039", "l10n_br_fiscal.cnae_33210"),
    ("l10n_br_account.l10n_br_cnae_1040", "l10n_br_fiscal.cnae_3321000"),
    ("l10n_br_account.l10n_br_cnae_1041", "l10n_br_fiscal.cnae_33295"),
    ("l10n_br_account.l10n_br_cnae_1042", "l10n_br_fiscal.cnae_3329501"),
    ("l10n_br_account.l10n_br_cnae_1043", "l10n_br_fiscal.cnae_3329599"),
    ("l10n_br_account.l10n_br_cnae_1044", "l10n_br_fiscal.cnae_D"),
    ("l10n_br_account.l10n_br_cnae_1045", "l10n_br_fiscal.cnae_35"),
    ("l10n_br_account.l10n_br_cnae_1046", "l10n_br_fiscal.cnae_351"),
    ("l10n_br_account.l10n_br_cnae_1047", "l10n_br_fiscal.cnae_35115"),
    ("l10n_br_account.l10n_br_cnae_1048", "l10n_br_fiscal.cnae_3511500"),
    ("l10n_br_account.l10n_br_cnae_1049", "l10n_br_fiscal.cnae_35123"),
    ("l10n_br_account.l10n_br_cnae_1050", "l10n_br_fiscal.cnae_3512300"),
    ("l10n_br_account.l10n_br_cnae_1051", "l10n_br_fiscal.cnae_35131"),
    ("l10n_br_account.l10n_br_cnae_1052", "l10n_br_fiscal.cnae_3513100"),
    ("l10n_br_account.l10n_br_cnae_1053", "l10n_br_fiscal.cnae_35140"),
    ("l10n_br_account.l10n_br_cnae_1054", "l10n_br_fiscal.cnae_3514000"),
    ("l10n_br_account.l10n_br_cnae_1055", "l10n_br_fiscal.cnae_352"),
    ("l10n_br_account.l10n_br_cnae_1056", "l10n_br_fiscal.cnae_35204"),
    ("l10n_br_account.l10n_br_cnae_1057", "l10n_br_fiscal.cnae_3520401"),
    ("l10n_br_account.l10n_br_cnae_1058", "l10n_br_fiscal.cnae_3520402"),
    ("l10n_br_account.l10n_br_cnae_1059", "l10n_br_fiscal.cnae_353"),
    ("l10n_br_account.l10n_br_cnae_1060", "l10n_br_fiscal.cnae_35301"),
    ("l10n_br_account.l10n_br_cnae_1061", "l10n_br_fiscal.cnae_3530100"),
    ("l10n_br_account.l10n_br_cnae_1062", "l10n_br_fiscal.cnae_E"),
    ("l10n_br_account.l10n_br_cnae_1063", "l10n_br_fiscal.cnae_36"),
    ("l10n_br_account.l10n_br_cnae_1064", "l10n_br_fiscal.cnae_360"),
    ("l10n_br_account.l10n_br_cnae_1065", "l10n_br_fiscal.cnae_36006"),
    ("l10n_br_account.l10n_br_cnae_1066", "l10n_br_fiscal.cnae_3600601"),
    ("l10n_br_account.l10n_br_cnae_1067", "l10n_br_fiscal.cnae_3600602"),
    ("l10n_br_account.l10n_br_cnae_1068", "l10n_br_fiscal.cnae_37"),
    ("l10n_br_account.l10n_br_cnae_1069", "l10n_br_fiscal.cnae_370"),
    ("l10n_br_account.l10n_br_cnae_1070", "l10n_br_fiscal.cnae_37011"),
    ("l10n_br_account.l10n_br_cnae_1071", "l10n_br_fiscal.cnae_3701100"),
    ("l10n_br_account.l10n_br_cnae_1072", "l10n_br_fiscal.cnae_37029"),
    ("l10n_br_account.l10n_br_cnae_1073", "l10n_br_fiscal.cnae_3702900"),
    ("l10n_br_account.l10n_br_cnae_1074", "l10n_br_fiscal.cnae_38"),
    ("l10n_br_account.l10n_br_cnae_1075", "l10n_br_fiscal.cnae_381"),
    ("l10n_br_account.l10n_br_cnae_1076", "l10n_br_fiscal.cnae_38114"),
    ("l10n_br_account.l10n_br_cnae_1077", "l10n_br_fiscal.cnae_3811400"),
    ("l10n_br_account.l10n_br_cnae_1078", "l10n_br_fiscal.cnae_38122"),
    ("l10n_br_account.l10n_br_cnae_1079", "l10n_br_fiscal.cnae_3812200"),
    ("l10n_br_account.l10n_br_cnae_1080", "l10n_br_fiscal.cnae_382"),
    ("l10n_br_account.l10n_br_cnae_1081", "l10n_br_fiscal.cnae_38211"),
    ("l10n_br_account.l10n_br_cnae_1082", "l10n_br_fiscal.cnae_3821100"),
    ("l10n_br_account.l10n_br_cnae_1083", "l10n_br_fiscal.cnae_38220"),
    ("l10n_br_account.l10n_br_cnae_1084", "l10n_br_fiscal.cnae_3822000"),
    ("l10n_br_account.l10n_br_cnae_1085", "l10n_br_fiscal.cnae_383"),
    ("l10n_br_account.l10n_br_cnae_1086", "l10n_br_fiscal.cnae_38319"),
    ("l10n_br_account.l10n_br_cnae_1087", "l10n_br_fiscal.cnae_3831901"),
    ("l10n_br_account.l10n_br_cnae_1088", "l10n_br_fiscal.cnae_3831999"),
    ("l10n_br_account.l10n_br_cnae_1089", "l10n_br_fiscal.cnae_38327"),
    ("l10n_br_account.l10n_br_cnae_1090", "l10n_br_fiscal.cnae_3832700"),
    ("l10n_br_account.l10n_br_cnae_1091", "l10n_br_fiscal.cnae_38394"),
    ("l10n_br_account.l10n_br_cnae_1092", "l10n_br_fiscal.cnae_3839401"),
    ("l10n_br_account.l10n_br_cnae_1093", "l10n_br_fiscal.cnae_3839499"),
    ("l10n_br_account.l10n_br_cnae_1094", "l10n_br_fiscal.cnae_39"),
    ("l10n_br_account.l10n_br_cnae_1095", "l10n_br_fiscal.cnae_390"),
    ("l10n_br_account.l10n_br_cnae_1096", "l10n_br_fiscal.cnae_39005"),
    ("l10n_br_account.l10n_br_cnae_1097", "l10n_br_fiscal.cnae_3900500"),
    ("l10n_br_account.l10n_br_cnae_1098", "l10n_br_fiscal.cnae_F"),
    ("l10n_br_account.l10n_br_cnae_1099", "l10n_br_fiscal.cnae_41"),
    ("l10n_br_account.l10n_br_cnae_1100", "l10n_br_fiscal.cnae_411"),
    ("l10n_br_account.l10n_br_cnae_1101", "l10n_br_fiscal.cnae_41107"),
    ("l10n_br_account.l10n_br_cnae_1102", "l10n_br_fiscal.cnae_4110700"),
    ("l10n_br_account.l10n_br_cnae_1103", "l10n_br_fiscal.cnae_412"),
    ("l10n_br_account.l10n_br_cnae_1104", "l10n_br_fiscal.cnae_41204"),
    ("l10n_br_account.l10n_br_cnae_1105", "l10n_br_fiscal.cnae_4120400"),
    ("l10n_br_account.l10n_br_cnae_1106", "l10n_br_fiscal.cnae_42"),
    ("l10n_br_account.l10n_br_cnae_1107", "l10n_br_fiscal.cnae_421"),
    ("l10n_br_account.l10n_br_cnae_1108", "l10n_br_fiscal.cnae_42111"),
    ("l10n_br_account.l10n_br_cnae_1109", "l10n_br_fiscal.cnae_4211101"),
    ("l10n_br_account.l10n_br_cnae_1110", "l10n_br_fiscal.cnae_4211102"),
    ("l10n_br_account.l10n_br_cnae_1111", "l10n_br_fiscal.cnae_42120"),
    ("l10n_br_account.l10n_br_cnae_1112", "l10n_br_fiscal.cnae_4212000"),
    ("l10n_br_account.l10n_br_cnae_1113", "l10n_br_fiscal.cnae_42138"),
    ("l10n_br_account.l10n_br_cnae_1114", "l10n_br_fiscal.cnae_4213800"),
    ("l10n_br_account.l10n_br_cnae_1115", "l10n_br_fiscal.cnae_422"),
    ("l10n_br_account.l10n_br_cnae_1116", "l10n_br_fiscal.cnae_42219"),
    ("l10n_br_account.l10n_br_cnae_1117", "l10n_br_fiscal.cnae_4221901"),
    ("l10n_br_account.l10n_br_cnae_1118", "l10n_br_fiscal.cnae_4221902"),
    ("l10n_br_account.l10n_br_cnae_1119", "l10n_br_fiscal.cnae_4221903"),
    ("l10n_br_account.l10n_br_cnae_1120", "l10n_br_fiscal.cnae_4221904"),
    ("l10n_br_account.l10n_br_cnae_1121", "l10n_br_fiscal.cnae_4221905"),
    ("l10n_br_account.l10n_br_cnae_1122", "l10n_br_fiscal.cnae_42227"),
    ("l10n_br_account.l10n_br_cnae_1123", "l10n_br_fiscal.cnae_4222701"),
    ("l10n_br_account.l10n_br_cnae_1124", "l10n_br_fiscal.cnae_4222702"),
    ("l10n_br_account.l10n_br_cnae_1125", "l10n_br_fiscal.cnae_42235"),
    ("l10n_br_account.l10n_br_cnae_1126", "l10n_br_fiscal.cnae_4223500"),
    ("l10n_br_account.l10n_br_cnae_1127", "l10n_br_fiscal.cnae_429"),
    ("l10n_br_account.l10n_br_cnae_1128", "l10n_br_fiscal.cnae_42910"),
    ("l10n_br_account.l10n_br_cnae_1129", "l10n_br_fiscal.cnae_4291000"),
    ("l10n_br_account.l10n_br_cnae_1130", "l10n_br_fiscal.cnae_42928"),
    ("l10n_br_account.l10n_br_cnae_1131", "l10n_br_fiscal.cnae_4292801"),
    ("l10n_br_account.l10n_br_cnae_1132", "l10n_br_fiscal.cnae_4292802"),
    ("l10n_br_account.l10n_br_cnae_1133", "l10n_br_fiscal.cnae_42995"),
    ("l10n_br_account.l10n_br_cnae_1134", "l10n_br_fiscal.cnae_4299501"),
    ("l10n_br_account.l10n_br_cnae_1135", "l10n_br_fiscal.cnae_4299599"),
    ("l10n_br_account.l10n_br_cnae_1136", "l10n_br_fiscal.cnae_43"),
    ("l10n_br_account.l10n_br_cnae_1137", "l10n_br_fiscal.cnae_431"),
    ("l10n_br_account.l10n_br_cnae_1138", "l10n_br_fiscal.cnae_43118"),
    ("l10n_br_account.l10n_br_cnae_1139", "l10n_br_fiscal.cnae_4311801"),
    ("l10n_br_account.l10n_br_cnae_1140", "l10n_br_fiscal.cnae_4311802"),
    ("l10n_br_account.l10n_br_cnae_1141", "l10n_br_fiscal.cnae_43126"),
    ("l10n_br_account.l10n_br_cnae_1142", "l10n_br_fiscal.cnae_4312600"),
    ("l10n_br_account.l10n_br_cnae_1143", "l10n_br_fiscal.cnae_43134"),
    ("l10n_br_account.l10n_br_cnae_1144", "l10n_br_fiscal.cnae_4313400"),
    ("l10n_br_account.l10n_br_cnae_1145", "l10n_br_fiscal.cnae_43193"),
    ("l10n_br_account.l10n_br_cnae_1146", "l10n_br_fiscal.cnae_4319300"),
    ("l10n_br_account.l10n_br_cnae_1147", "l10n_br_fiscal.cnae_432"),
    ("l10n_br_account.l10n_br_cnae_1148", "l10n_br_fiscal.cnae_43215"),
    ("l10n_br_account.l10n_br_cnae_1149", "l10n_br_fiscal.cnae_4321500"),
    ("l10n_br_account.l10n_br_cnae_1150", "l10n_br_fiscal.cnae_43223"),
    ("l10n_br_account.l10n_br_cnae_1151", "l10n_br_fiscal.cnae_4322301"),
    ("l10n_br_account.l10n_br_cnae_1152", "l10n_br_fiscal.cnae_4322302"),
    ("l10n_br_account.l10n_br_cnae_1153", "l10n_br_fiscal.cnae_4322303"),
    ("l10n_br_account.l10n_br_cnae_1154", "l10n_br_fiscal.cnae_43291"),
    ("l10n_br_account.l10n_br_cnae_1155", "l10n_br_fiscal.cnae_4329101"),
    ("l10n_br_account.l10n_br_cnae_1156", "l10n_br_fiscal.cnae_4329102"),
    ("l10n_br_account.l10n_br_cnae_1157", "l10n_br_fiscal.cnae_4329103"),
    ("l10n_br_account.l10n_br_cnae_1158", "l10n_br_fiscal.cnae_4329104"),
    ("l10n_br_account.l10n_br_cnae_1159", "l10n_br_fiscal.cnae_4329105"),
    ("l10n_br_account.l10n_br_cnae_1160", "l10n_br_fiscal.cnae_4329199"),
    ("l10n_br_account.l10n_br_cnae_1161", "l10n_br_fiscal.cnae_433"),
    ("l10n_br_account.l10n_br_cnae_1162", "l10n_br_fiscal.cnae_43304"),
    ("l10n_br_account.l10n_br_cnae_1163", "l10n_br_fiscal.cnae_4330401"),
    ("l10n_br_account.l10n_br_cnae_1164", "l10n_br_fiscal.cnae_4330402"),
    ("l10n_br_account.l10n_br_cnae_1165", "l10n_br_fiscal.cnae_4330403"),
    ("l10n_br_account.l10n_br_cnae_1166", "l10n_br_fiscal.cnae_4330404"),
    ("l10n_br_account.l10n_br_cnae_1167", "l10n_br_fiscal.cnae_4330405"),
    ("l10n_br_account.l10n_br_cnae_1168", "l10n_br_fiscal.cnae_4330499"),
    ("l10n_br_account.l10n_br_cnae_1169", "l10n_br_fiscal.cnae_439"),
    ("l10n_br_account.l10n_br_cnae_1170", "l10n_br_fiscal.cnae_43916"),
    ("l10n_br_account.l10n_br_cnae_1171", "l10n_br_fiscal.cnae_4391600"),
    ("l10n_br_account.l10n_br_cnae_1172", "l10n_br_fiscal.cnae_43991"),
    ("l10n_br_account.l10n_br_cnae_1173", "l10n_br_fiscal.cnae_4399101"),
    ("l10n_br_account.l10n_br_cnae_1174", "l10n_br_fiscal.cnae_4399102"),
    ("l10n_br_account.l10n_br_cnae_1175", "l10n_br_fiscal.cnae_4399103"),
    ("l10n_br_account.l10n_br_cnae_1176", "l10n_br_fiscal.cnae_4399104"),
    ("l10n_br_account.l10n_br_cnae_1177", "l10n_br_fiscal.cnae_4399105"),
    ("l10n_br_account.l10n_br_cnae_1178", "l10n_br_fiscal.cnae_4399199"),
    ("l10n_br_account.l10n_br_cnae_1179", "l10n_br_fiscal.cnae_G"),
    ("l10n_br_account.l10n_br_cnae_1180", "l10n_br_fiscal.cnae_45"),
    ("l10n_br_account.l10n_br_cnae_1181", "l10n_br_fiscal.cnae_451"),
    ("l10n_br_account.l10n_br_cnae_1182", "l10n_br_fiscal.cnae_45111"),
    ("l10n_br_account.l10n_br_cnae_1183", "l10n_br_fiscal.cnae_4511101"),
    ("l10n_br_account.l10n_br_cnae_1184", "l10n_br_fiscal.cnae_4511102"),
    ("l10n_br_account.l10n_br_cnae_1185", "l10n_br_fiscal.cnae_4511103"),
    ("l10n_br_account.l10n_br_cnae_1186", "l10n_br_fiscal.cnae_4511104"),
    ("l10n_br_account.l10n_br_cnae_1187", "l10n_br_fiscal.cnae_4511105"),
    ("l10n_br_account.l10n_br_cnae_1188", "l10n_br_fiscal.cnae_4511106"),
    ("l10n_br_account.l10n_br_cnae_1189", "l10n_br_fiscal.cnae_45129"),
    ("l10n_br_account.l10n_br_cnae_1190", "l10n_br_fiscal.cnae_4512901"),
    ("l10n_br_account.l10n_br_cnae_1191", "l10n_br_fiscal.cnae_4512902"),
    ("l10n_br_account.l10n_br_cnae_1192", "l10n_br_fiscal.cnae_452"),
    ("l10n_br_account.l10n_br_cnae_1193", "l10n_br_fiscal.cnae_45200"),
    ("l10n_br_account.l10n_br_cnae_1194", "l10n_br_fiscal.cnae_4520001"),
    ("l10n_br_account.l10n_br_cnae_1195", "l10n_br_fiscal.cnae_4520002"),
    ("l10n_br_account.l10n_br_cnae_1196", "l10n_br_fiscal.cnae_4520003"),
    ("l10n_br_account.l10n_br_cnae_1197", "l10n_br_fiscal.cnae_4520004"),
    ("l10n_br_account.l10n_br_cnae_1198", "l10n_br_fiscal.cnae_4520005"),
    ("l10n_br_account.l10n_br_cnae_1199", "l10n_br_fiscal.cnae_4520006"),
    ("l10n_br_account.l10n_br_cnae_1200", "l10n_br_fiscal.cnae_4520007"),
    ("l10n_br_account.l10n_br_cnae_1201", "l10n_br_fiscal.cnae_453"),
    ("l10n_br_account.l10n_br_cnae_1202", "l10n_br_fiscal.cnae_45307"),
    ("l10n_br_account.l10n_br_cnae_1203", "l10n_br_fiscal.cnae_4530701"),
    ("l10n_br_account.l10n_br_cnae_1204", "l10n_br_fiscal.cnae_4530702"),
    ("l10n_br_account.l10n_br_cnae_1205", "l10n_br_fiscal.cnae_4530703"),
    ("l10n_br_account.l10n_br_cnae_1206", "l10n_br_fiscal.cnae_4530704"),
    ("l10n_br_account.l10n_br_cnae_1207", "l10n_br_fiscal.cnae_4530705"),
    ("l10n_br_account.l10n_br_cnae_1208", "l10n_br_fiscal.cnae_4530706"),
    ("l10n_br_account.l10n_br_cnae_1209", "l10n_br_fiscal.cnae_454"),
    ("l10n_br_account.l10n_br_cnae_1210", "l10n_br_fiscal.cnae_45412"),
    ("l10n_br_account.l10n_br_cnae_1211", "l10n_br_fiscal.cnae_4541201"),
    ("l10n_br_account.l10n_br_cnae_1212", "l10n_br_fiscal.cnae_4541202"),
    ("l10n_br_account.l10n_br_cnae_1213", "l10n_br_fiscal.cnae_4541203"),
    ("l10n_br_account.l10n_br_cnae_1214", "l10n_br_fiscal.cnae_4541204"),
    ("l10n_br_account.l10n_br_cnae_1215", "l10n_br_fiscal.cnae_4541205"),
    ("l10n_br_account.l10n_br_cnae_1216", "l10n_br_fiscal.cnae_45421"),
    ("l10n_br_account.l10n_br_cnae_1217", "l10n_br_fiscal.cnae_4542101"),
    ("l10n_br_account.l10n_br_cnae_1218", "l10n_br_fiscal.cnae_4542102"),
    ("l10n_br_account.l10n_br_cnae_1219", "l10n_br_fiscal.cnae_45439"),
    ("l10n_br_account.l10n_br_cnae_1220", "l10n_br_fiscal.cnae_4543900"),
    ("l10n_br_account.l10n_br_cnae_1221", "l10n_br_fiscal.cnae_46"),
    ("l10n_br_account.l10n_br_cnae_1222", "l10n_br_fiscal.cnae_461"),
    ("l10n_br_account.l10n_br_cnae_1223", "l10n_br_fiscal.cnae_46117"),
    ("l10n_br_account.l10n_br_cnae_1224", "l10n_br_fiscal.cnae_4611700"),
    ("l10n_br_account.l10n_br_cnae_1225", "l10n_br_fiscal.cnae_46125"),
    ("l10n_br_account.l10n_br_cnae_1226", "l10n_br_fiscal.cnae_4612500"),
    ("l10n_br_account.l10n_br_cnae_1227", "l10n_br_fiscal.cnae_46133"),
    ("l10n_br_account.l10n_br_cnae_1228", "l10n_br_fiscal.cnae_4613300"),
    ("l10n_br_account.l10n_br_cnae_1229", "l10n_br_fiscal.cnae_46141"),
    ("l10n_br_account.l10n_br_cnae_1230", "l10n_br_fiscal.cnae_4614100"),
    ("l10n_br_account.l10n_br_cnae_1231", "l10n_br_fiscal.cnae_46150"),
    ("l10n_br_account.l10n_br_cnae_1232", "l10n_br_fiscal.cnae_4615000"),
    ("l10n_br_account.l10n_br_cnae_1233", "l10n_br_fiscal.cnae_46168"),
    ("l10n_br_account.l10n_br_cnae_1234", "l10n_br_fiscal.cnae_4616800"),
    ("l10n_br_account.l10n_br_cnae_1235", "l10n_br_fiscal.cnae_46176"),
    ("l10n_br_account.l10n_br_cnae_1236", "l10n_br_fiscal.cnae_4617600"),
    ("l10n_br_account.l10n_br_cnae_1237", "l10n_br_fiscal.cnae_46184"),
    ("l10n_br_account.l10n_br_cnae_1238", "l10n_br_fiscal.cnae_4618401"),
    ("l10n_br_account.l10n_br_cnae_1239", "l10n_br_fiscal.cnae_4618402"),
    ("l10n_br_account.l10n_br_cnae_1240", "l10n_br_fiscal.cnae_4618403"),
    ("l10n_br_account.l10n_br_cnae_1241", "l10n_br_fiscal.cnae_4618499"),
    ("l10n_br_account.l10n_br_cnae_1242", "l10n_br_fiscal.cnae_46192"),
    ("l10n_br_account.l10n_br_cnae_1243", "l10n_br_fiscal.cnae_4619200"),
    ("l10n_br_account.l10n_br_cnae_1244", "l10n_br_fiscal.cnae_462"),
    ("l10n_br_account.l10n_br_cnae_1245", "l10n_br_fiscal.cnae_46214"),
    ("l10n_br_account.l10n_br_cnae_1246", "l10n_br_fiscal.cnae_4621400"),
    ("l10n_br_account.l10n_br_cnae_1247", "l10n_br_fiscal.cnae_46222"),
    ("l10n_br_account.l10n_br_cnae_1248", "l10n_br_fiscal.cnae_4622200"),
    ("l10n_br_account.l10n_br_cnae_1249", "l10n_br_fiscal.cnae_46231"),
    ("l10n_br_account.l10n_br_cnae_1250", "l10n_br_fiscal.cnae_4623101"),
    ("l10n_br_account.l10n_br_cnae_1251", "l10n_br_fiscal.cnae_4623102"),
    ("l10n_br_account.l10n_br_cnae_1252", "l10n_br_fiscal.cnae_4623103"),
    ("l10n_br_account.l10n_br_cnae_1253", "l10n_br_fiscal.cnae_4623104"),
    ("l10n_br_account.l10n_br_cnae_1254", "l10n_br_fiscal.cnae_4623105"),
    ("l10n_br_account.l10n_br_cnae_1255", "l10n_br_fiscal.cnae_4623106"),
    ("l10n_br_account.l10n_br_cnae_1256", "l10n_br_fiscal.cnae_4623107"),
    ("l10n_br_account.l10n_br_cnae_1257", "l10n_br_fiscal.cnae_4623108"),
    ("l10n_br_account.l10n_br_cnae_1258", "l10n_br_fiscal.cnae_4623109"),
    ("l10n_br_account.l10n_br_cnae_1259", "l10n_br_fiscal.cnae_4623199"),
    ("l10n_br_account.l10n_br_cnae_1260", "l10n_br_fiscal.cnae_463"),
    ("l10n_br_account.l10n_br_cnae_1261", "l10n_br_fiscal.cnae_46311"),
    ("l10n_br_account.l10n_br_cnae_1262", "l10n_br_fiscal.cnae_4631100"),
    ("l10n_br_account.l10n_br_cnae_1263", "l10n_br_fiscal.cnae_46320"),
    ("l10n_br_account.l10n_br_cnae_1264", "l10n_br_fiscal.cnae_4632001"),
    ("l10n_br_account.l10n_br_cnae_1265", "l10n_br_fiscal.cnae_4632002"),
    ("l10n_br_account.l10n_br_cnae_1266", "l10n_br_fiscal.cnae_4632003"),
    ("l10n_br_account.l10n_br_cnae_1267", "l10n_br_fiscal.cnae_46338"),
    ("l10n_br_account.l10n_br_cnae_1268", "l10n_br_fiscal.cnae_4633801"),
    ("l10n_br_account.l10n_br_cnae_1269", "l10n_br_fiscal.cnae_4633802"),
    ("l10n_br_account.l10n_br_cnae_1270", "l10n_br_fiscal.cnae_4633803"),
    ("l10n_br_account.l10n_br_cnae_1271", "l10n_br_fiscal.cnae_46346"),
    ("l10n_br_account.l10n_br_cnae_1272", "l10n_br_fiscal.cnae_4634601"),
    ("l10n_br_account.l10n_br_cnae_1273", "l10n_br_fiscal.cnae_4634602"),
    ("l10n_br_account.l10n_br_cnae_1274", "l10n_br_fiscal.cnae_4634603"),
    ("l10n_br_account.l10n_br_cnae_1275", "l10n_br_fiscal.cnae_4634699"),
    ("l10n_br_account.l10n_br_cnae_1276", "l10n_br_fiscal.cnae_46354"),
    ("l10n_br_account.l10n_br_cnae_1277", "l10n_br_fiscal.cnae_4635401"),
    ("l10n_br_account.l10n_br_cnae_1278", "l10n_br_fiscal.cnae_4635402"),
    ("l10n_br_account.l10n_br_cnae_1279", "l10n_br_fiscal.cnae_4635403"),
    ("l10n_br_account.l10n_br_cnae_1280", "l10n_br_fiscal.cnae_4635499"),
    ("l10n_br_account.l10n_br_cnae_1281", "l10n_br_fiscal.cnae_46362"),
    ("l10n_br_account.l10n_br_cnae_1282", "l10n_br_fiscal.cnae_4636201"),
    ("l10n_br_account.l10n_br_cnae_1283", "l10n_br_fiscal.cnae_4636202"),
    ("l10n_br_account.l10n_br_cnae_1284", "l10n_br_fiscal.cnae_46371"),
    ("l10n_br_account.l10n_br_cnae_1285", "l10n_br_fiscal.cnae_4637101"),
    ("l10n_br_account.l10n_br_cnae_1286", "l10n_br_fiscal.cnae_4637102"),
    ("l10n_br_account.l10n_br_cnae_1287", "l10n_br_fiscal.cnae_4637103"),
    ("l10n_br_account.l10n_br_cnae_1288", "l10n_br_fiscal.cnae_4637104"),
    ("l10n_br_account.l10n_br_cnae_1289", "l10n_br_fiscal.cnae_4637105"),
    ("l10n_br_account.l10n_br_cnae_1290", "l10n_br_fiscal.cnae_4637106"),
    ("l10n_br_account.l10n_br_cnae_1291", "l10n_br_fiscal.cnae_4637107"),
    ("l10n_br_account.l10n_br_cnae_1292", "l10n_br_fiscal.cnae_4637199"),
    ("l10n_br_account.l10n_br_cnae_1293", "l10n_br_fiscal.cnae_46397"),
    ("l10n_br_account.l10n_br_cnae_1294", "l10n_br_fiscal.cnae_4639701"),
    ("l10n_br_account.l10n_br_cnae_1295", "l10n_br_fiscal.cnae_4639702"),
    ("l10n_br_account.l10n_br_cnae_1296", "l10n_br_fiscal.cnae_464"),
    ("l10n_br_account.l10n_br_cnae_1297", "l10n_br_fiscal.cnae_46419"),
    ("l10n_br_account.l10n_br_cnae_1298", "l10n_br_fiscal.cnae_4641901"),
    ("l10n_br_account.l10n_br_cnae_1299", "l10n_br_fiscal.cnae_4641902"),
    ("l10n_br_account.l10n_br_cnae_1300", "l10n_br_fiscal.cnae_4641903"),
    ("l10n_br_account.l10n_br_cnae_1301", "l10n_br_fiscal.cnae_46427"),
    ("l10n_br_account.l10n_br_cnae_1302", "l10n_br_fiscal.cnae_4642701"),
    ("l10n_br_account.l10n_br_cnae_1303", "l10n_br_fiscal.cnae_4642702"),
    ("l10n_br_account.l10n_br_cnae_1304", "l10n_br_fiscal.cnae_46435"),
    ("l10n_br_account.l10n_br_cnae_1305", "l10n_br_fiscal.cnae_4643501"),
    ("l10n_br_account.l10n_br_cnae_1306", "l10n_br_fiscal.cnae_4643502"),
    ("l10n_br_account.l10n_br_cnae_1307", "l10n_br_fiscal.cnae_46443"),
    ("l10n_br_account.l10n_br_cnae_1308", "l10n_br_fiscal.cnae_4644301"),
    ("l10n_br_account.l10n_br_cnae_1309", "l10n_br_fiscal.cnae_4644302"),
    ("l10n_br_account.l10n_br_cnae_1310", "l10n_br_fiscal.cnae_46451"),
    ("l10n_br_account.l10n_br_cnae_1311", "l10n_br_fiscal.cnae_4645101"),
    ("l10n_br_account.l10n_br_cnae_1312", "l10n_br_fiscal.cnae_4645102"),
    ("l10n_br_account.l10n_br_cnae_1313", "l10n_br_fiscal.cnae_4645103"),
    ("l10n_br_account.l10n_br_cnae_1314", "l10n_br_fiscal.cnae_46460"),
    ("l10n_br_account.l10n_br_cnae_1315", "l10n_br_fiscal.cnae_4646001"),
    ("l10n_br_account.l10n_br_cnae_1316", "l10n_br_fiscal.cnae_4646002"),
    ("l10n_br_account.l10n_br_cnae_1317", "l10n_br_fiscal.cnae_46478"),
    ("l10n_br_account.l10n_br_cnae_1318", "l10n_br_fiscal.cnae_4647801"),
    ("l10n_br_account.l10n_br_cnae_1319", "l10n_br_fiscal.cnae_4647802"),
    ("l10n_br_account.l10n_br_cnae_1320", "l10n_br_fiscal.cnae_46494"),
    ("l10n_br_account.l10n_br_cnae_1321", "l10n_br_fiscal.cnae_4649401"),
    ("l10n_br_account.l10n_br_cnae_1322", "l10n_br_fiscal.cnae_4649402"),
    ("l10n_br_account.l10n_br_cnae_1323", "l10n_br_fiscal.cnae_4649403"),
    ("l10n_br_account.l10n_br_cnae_1324", "l10n_br_fiscal.cnae_4649404"),
    ("l10n_br_account.l10n_br_cnae_1325", "l10n_br_fiscal.cnae_4649405"),
    ("l10n_br_account.l10n_br_cnae_1326", "l10n_br_fiscal.cnae_4649406"),
    ("l10n_br_account.l10n_br_cnae_1327", "l10n_br_fiscal.cnae_4649407"),
    ("l10n_br_account.l10n_br_cnae_1328", "l10n_br_fiscal.cnae_4649408"),
    ("l10n_br_account.l10n_br_cnae_1329", "l10n_br_fiscal.cnae_4649409"),
    ("l10n_br_account.l10n_br_cnae_1330", "l10n_br_fiscal.cnae_4649410"),
    ("l10n_br_account.l10n_br_cnae_1331", "l10n_br_fiscal.cnae_4649499"),
    ("l10n_br_account.l10n_br_cnae_1332", "l10n_br_fiscal.cnae_465"),
    ("l10n_br_account.l10n_br_cnae_1333", "l10n_br_fiscal.cnae_46516"),
    ("l10n_br_account.l10n_br_cnae_1334", "l10n_br_fiscal.cnae_4651601"),
    ("l10n_br_account.l10n_br_cnae_1335", "l10n_br_fiscal.cnae_4651602"),
    ("l10n_br_account.l10n_br_cnae_1336", "l10n_br_fiscal.cnae_46524"),
    ("l10n_br_account.l10n_br_cnae_1337", "l10n_br_fiscal.cnae_4652400"),
    ("l10n_br_account.l10n_br_cnae_1338", "l10n_br_fiscal.cnae_466"),
    ("l10n_br_account.l10n_br_cnae_1339", "l10n_br_fiscal.cnae_46613"),
    ("l10n_br_account.l10n_br_cnae_1340", "l10n_br_fiscal.cnae_4661300"),
    ("l10n_br_account.l10n_br_cnae_1341", "l10n_br_fiscal.cnae_46621"),
    ("l10n_br_account.l10n_br_cnae_1342", "l10n_br_fiscal.cnae_4662100"),
    ("l10n_br_account.l10n_br_cnae_1343", "l10n_br_fiscal.cnae_46630"),
    ("l10n_br_account.l10n_br_cnae_1344", "l10n_br_fiscal.cnae_4663000"),
    ("l10n_br_account.l10n_br_cnae_1345", "l10n_br_fiscal.cnae_46648"),
    ("l10n_br_account.l10n_br_cnae_1346", "l10n_br_fiscal.cnae_4664800"),
    ("l10n_br_account.l10n_br_cnae_1347", "l10n_br_fiscal.cnae_46656"),
    ("l10n_br_account.l10n_br_cnae_1348", "l10n_br_fiscal.cnae_4665600"),
    ("l10n_br_account.l10n_br_cnae_1349", "l10n_br_fiscal.cnae_46699"),
    ("l10n_br_account.l10n_br_cnae_1350", "l10n_br_fiscal.cnae_4669901"),
    ("l10n_br_account.l10n_br_cnae_1351", "l10n_br_fiscal.cnae_4669999"),
    ("l10n_br_account.l10n_br_cnae_1352", "l10n_br_fiscal.cnae_467"),
    ("l10n_br_account.l10n_br_cnae_1353", "l10n_br_fiscal.cnae_46711"),
    ("l10n_br_account.l10n_br_cnae_1354", "l10n_br_fiscal.cnae_4671100"),
    ("l10n_br_account.l10n_br_cnae_1355", "l10n_br_fiscal.cnae_46729"),
    ("l10n_br_account.l10n_br_cnae_1356", "l10n_br_fiscal.cnae_4672900"),
    ("l10n_br_account.l10n_br_cnae_1357", "l10n_br_fiscal.cnae_46737"),
    ("l10n_br_account.l10n_br_cnae_1358", "l10n_br_fiscal.cnae_4673700"),
    ("l10n_br_account.l10n_br_cnae_1359", "l10n_br_fiscal.cnae_46745"),
    ("l10n_br_account.l10n_br_cnae_1360", "l10n_br_fiscal.cnae_4674500"),
    ("l10n_br_account.l10n_br_cnae_1361", "l10n_br_fiscal.cnae_46796"),
    ("l10n_br_account.l10n_br_cnae_1362", "l10n_br_fiscal.cnae_4679601"),
    ("l10n_br_account.l10n_br_cnae_1363", "l10n_br_fiscal.cnae_4679602"),
    ("l10n_br_account.l10n_br_cnae_1364", "l10n_br_fiscal.cnae_4679603"),
    ("l10n_br_account.l10n_br_cnae_1365", "l10n_br_fiscal.cnae_4679604"),
    ("l10n_br_account.l10n_br_cnae_1366", "l10n_br_fiscal.cnae_4679699"),
    ("l10n_br_account.l10n_br_cnae_1367", "l10n_br_fiscal.cnae_468"),
    ("l10n_br_account.l10n_br_cnae_1368", "l10n_br_fiscal.cnae_46818"),
    ("l10n_br_account.l10n_br_cnae_1369", "l10n_br_fiscal.cnae_4681801"),
    ("l10n_br_account.l10n_br_cnae_1370", "l10n_br_fiscal.cnae_4681802"),
    ("l10n_br_account.l10n_br_cnae_1371", "l10n_br_fiscal.cnae_4681803"),
    ("l10n_br_account.l10n_br_cnae_1372", "l10n_br_fiscal.cnae_4681804"),
    ("l10n_br_account.l10n_br_cnae_1373", "l10n_br_fiscal.cnae_4681805"),
    ("l10n_br_account.l10n_br_cnae_1374", "l10n_br_fiscal.cnae_46826"),
    ("l10n_br_account.l10n_br_cnae_1375", "l10n_br_fiscal.cnae_4682600"),
    ("l10n_br_account.l10n_br_cnae_1376", "l10n_br_fiscal.cnae_46834"),
    ("l10n_br_account.l10n_br_cnae_1377", "l10n_br_fiscal.cnae_4683400"),
    ("l10n_br_account.l10n_br_cnae_1378", "l10n_br_fiscal.cnae_46842"),
    ("l10n_br_account.l10n_br_cnae_1379", "l10n_br_fiscal.cnae_4684201"),
    ("l10n_br_account.l10n_br_cnae_1380", "l10n_br_fiscal.cnae_4684202"),
    ("l10n_br_account.l10n_br_cnae_1381", "l10n_br_fiscal.cnae_4684299"),
    ("l10n_br_account.l10n_br_cnae_1382", "l10n_br_fiscal.cnae_46851"),
    ("l10n_br_account.l10n_br_cnae_1383", "l10n_br_fiscal.cnae_4685100"),
    ("l10n_br_account.l10n_br_cnae_1384", "l10n_br_fiscal.cnae_46869"),
    ("l10n_br_account.l10n_br_cnae_1385", "l10n_br_fiscal.cnae_4686901"),
    ("l10n_br_account.l10n_br_cnae_1386", "l10n_br_fiscal.cnae_4686902"),
    ("l10n_br_account.l10n_br_cnae_1387", "l10n_br_fiscal.cnae_46877"),
    ("l10n_br_account.l10n_br_cnae_1388", "l10n_br_fiscal.cnae_4687701"),
    ("l10n_br_account.l10n_br_cnae_1389", "l10n_br_fiscal.cnae_4687702"),
    ("l10n_br_account.l10n_br_cnae_1390", "l10n_br_fiscal.cnae_4687703"),
    ("l10n_br_account.l10n_br_cnae_1391", "l10n_br_fiscal.cnae_46893"),
    ("l10n_br_account.l10n_br_cnae_1392", "l10n_br_fiscal.cnae_4689301"),
    ("l10n_br_account.l10n_br_cnae_1393", "l10n_br_fiscal.cnae_4689302"),
    ("l10n_br_account.l10n_br_cnae_1394", "l10n_br_fiscal.cnae_4689399"),
    ("l10n_br_account.l10n_br_cnae_1395", "l10n_br_fiscal.cnae_469"),
    ("l10n_br_account.l10n_br_cnae_1396", "l10n_br_fiscal.cnae_46915"),
    ("l10n_br_account.l10n_br_cnae_1397", "l10n_br_fiscal.cnae_4691500"),
    ("l10n_br_account.l10n_br_cnae_1398", "l10n_br_fiscal.cnae_46923"),
    ("l10n_br_account.l10n_br_cnae_1399", "l10n_br_fiscal.cnae_4692300"),
    ("l10n_br_account.l10n_br_cnae_1400", "l10n_br_fiscal.cnae_46931"),
    ("l10n_br_account.l10n_br_cnae_1401", "l10n_br_fiscal.cnae_4693100"),
    ("l10n_br_account.l10n_br_cnae_1402", "l10n_br_fiscal.cnae_47"),
    ("l10n_br_account.l10n_br_cnae_1403", "l10n_br_fiscal.cnae_471"),
    ("l10n_br_account.l10n_br_cnae_1404", "l10n_br_fiscal.cnae_47113"),
    ("l10n_br_account.l10n_br_cnae_1405", "l10n_br_fiscal.cnae_4711301"),
    ("l10n_br_account.l10n_br_cnae_1406", "l10n_br_fiscal.cnae_4711302"),
    ("l10n_br_account.l10n_br_cnae_1407", "l10n_br_fiscal.cnae_47121"),
    ("l10n_br_account.l10n_br_cnae_1408", "l10n_br_fiscal.cnae_4712100"),
    ("l10n_br_account.l10n_br_cnae_1409", "l10n_br_fiscal.cnae_47130"),
    ("l10n_br_account.l10n_br_cnae_1410", "l10n_br_fiscal.cnae_4713001"),
    ("l10n_br_account.l10n_br_cnae_1411", "l10n_br_fiscal.cnae_4713002"),
    ("l10n_br_account.l10n_br_cnae_1412", "l10n_br_fiscal.cnae_4713003"),
    ("l10n_br_account.l10n_br_cnae_1413", "l10n_br_fiscal.cnae_472"),
    ("l10n_br_account.l10n_br_cnae_1414", "l10n_br_fiscal.cnae_47211"),
    ("l10n_br_account.l10n_br_cnae_1415", "l10n_br_fiscal.cnae_4721101"),
    ("l10n_br_account.l10n_br_cnae_1416", "l10n_br_fiscal.cnae_4721102"),
    ("l10n_br_account.l10n_br_cnae_1417", "l10n_br_fiscal.cnae_4721103"),
    ("l10n_br_account.l10n_br_cnae_1418", "l10n_br_fiscal.cnae_4721104"),
    ("l10n_br_account.l10n_br_cnae_1419", "l10n_br_fiscal.cnae_47229"),
    ("l10n_br_account.l10n_br_cnae_1420", "l10n_br_fiscal.cnae_4722901"),
    ("l10n_br_account.l10n_br_cnae_1421", "l10n_br_fiscal.cnae_4722902"),
    ("l10n_br_account.l10n_br_cnae_1422", "l10n_br_fiscal.cnae_47237"),
    ("l10n_br_account.l10n_br_cnae_1423", "l10n_br_fiscal.cnae_4723700"),
    ("l10n_br_account.l10n_br_cnae_1424", "l10n_br_fiscal.cnae_47245"),
    ("l10n_br_account.l10n_br_cnae_1425", "l10n_br_fiscal.cnae_4724500"),
    ("l10n_br_account.l10n_br_cnae_1426", "l10n_br_fiscal.cnae_47296"),
    ("l10n_br_account.l10n_br_cnae_1427", "l10n_br_fiscal.cnae_4729601"),
    ("l10n_br_account.l10n_br_cnae_1428", "l10n_br_fiscal.cnae_4729699"),
    ("l10n_br_account.l10n_br_cnae_1429", "l10n_br_fiscal.cnae_473"),
    ("l10n_br_account.l10n_br_cnae_1430", "l10n_br_fiscal.cnae_47318"),
    ("l10n_br_account.l10n_br_cnae_1431", "l10n_br_fiscal.cnae_4731800"),
    ("l10n_br_account.l10n_br_cnae_1432", "l10n_br_fiscal.cnae_47326"),
    ("l10n_br_account.l10n_br_cnae_1433", "l10n_br_fiscal.cnae_4732600"),
    ("l10n_br_account.l10n_br_cnae_1434", "l10n_br_fiscal.cnae_474"),
    ("l10n_br_account.l10n_br_cnae_1435", "l10n_br_fiscal.cnae_47415"),
    ("l10n_br_account.l10n_br_cnae_1436", "l10n_br_fiscal.cnae_4741500"),
    ("l10n_br_account.l10n_br_cnae_1437", "l10n_br_fiscal.cnae_47423"),
    ("l10n_br_account.l10n_br_cnae_1438", "l10n_br_fiscal.cnae_4742300"),
    ("l10n_br_account.l10n_br_cnae_1439", "l10n_br_fiscal.cnae_47431"),
    ("l10n_br_account.l10n_br_cnae_1440", "l10n_br_fiscal.cnae_4743100"),
    ("l10n_br_account.l10n_br_cnae_1441", "l10n_br_fiscal.cnae_47440"),
    ("l10n_br_account.l10n_br_cnae_1442", "l10n_br_fiscal.cnae_4744001"),
    ("l10n_br_account.l10n_br_cnae_1443", "l10n_br_fiscal.cnae_4744002"),
    ("l10n_br_account.l10n_br_cnae_1444", "l10n_br_fiscal.cnae_4744003"),
    ("l10n_br_account.l10n_br_cnae_1445", "l10n_br_fiscal.cnae_4744004"),
    ("l10n_br_account.l10n_br_cnae_1446", "l10n_br_fiscal.cnae_4744005"),
    ("l10n_br_account.l10n_br_cnae_1447", "l10n_br_fiscal.cnae_4744099"),
    ("l10n_br_account.l10n_br_cnae_1448", "l10n_br_fiscal.cnae_475"),
    ("l10n_br_account.l10n_br_cnae_1449", "l10n_br_fiscal.cnae_47512"),
    ("l10n_br_account.l10n_br_cnae_1450", "l10n_br_fiscal.cnae_4751200"),
    ("l10n_br_account.l10n_br_cnae_1451", "l10n_br_fiscal.cnae_47521"),
    ("l10n_br_account.l10n_br_cnae_1452", "l10n_br_fiscal.cnae_4752100"),
    ("l10n_br_account.l10n_br_cnae_1453", "l10n_br_fiscal.cnae_47539"),
    ("l10n_br_account.l10n_br_cnae_1454", "l10n_br_fiscal.cnae_4753900"),
    ("l10n_br_account.l10n_br_cnae_1455", "l10n_br_fiscal.cnae_47547"),
    ("l10n_br_account.l10n_br_cnae_1456", "l10n_br_fiscal.cnae_4754701"),
    ("l10n_br_account.l10n_br_cnae_1457", "l10n_br_fiscal.cnae_4754702"),
    ("l10n_br_account.l10n_br_cnae_1458", "l10n_br_fiscal.cnae_4754703"),
    ("l10n_br_account.l10n_br_cnae_1459", "l10n_br_fiscal.cnae_47555"),
    ("l10n_br_account.l10n_br_cnae_1460", "l10n_br_fiscal.cnae_4755501"),
    ("l10n_br_account.l10n_br_cnae_1461", "l10n_br_fiscal.cnae_4755502"),
    ("l10n_br_account.l10n_br_cnae_1462", "l10n_br_fiscal.cnae_4755503"),
    ("l10n_br_account.l10n_br_cnae_1463", "l10n_br_fiscal.cnae_47563"),
    ("l10n_br_account.l10n_br_cnae_1464", "l10n_br_fiscal.cnae_4756300"),
    ("l10n_br_account.l10n_br_cnae_1465", "l10n_br_fiscal.cnae_47571"),
    ("l10n_br_account.l10n_br_cnae_1466", "l10n_br_fiscal.cnae_4757100"),
    ("l10n_br_account.l10n_br_cnae_1467", "l10n_br_fiscal.cnae_47598"),
    ("l10n_br_account.l10n_br_cnae_1468", "l10n_br_fiscal.cnae_4759801"),
    ("l10n_br_account.l10n_br_cnae_1469", "l10n_br_fiscal.cnae_4759899"),
    ("l10n_br_account.l10n_br_cnae_1470", "l10n_br_fiscal.cnae_476"),
    ("l10n_br_account.l10n_br_cnae_1471", "l10n_br_fiscal.cnae_47610"),
    ("l10n_br_account.l10n_br_cnae_1472", "l10n_br_fiscal.cnae_4761001"),
    ("l10n_br_account.l10n_br_cnae_1473", "l10n_br_fiscal.cnae_4761002"),
    ("l10n_br_account.l10n_br_cnae_1474", "l10n_br_fiscal.cnae_4761003"),
    ("l10n_br_account.l10n_br_cnae_1475", "l10n_br_fiscal.cnae_47628"),
    ("l10n_br_account.l10n_br_cnae_1476", "l10n_br_fiscal.cnae_4762800"),
    ("l10n_br_account.l10n_br_cnae_1477", "l10n_br_fiscal.cnae_47636"),
    ("l10n_br_account.l10n_br_cnae_1478", "l10n_br_fiscal.cnae_4763601"),
    ("l10n_br_account.l10n_br_cnae_1479", "l10n_br_fiscal.cnae_4763602"),
    ("l10n_br_account.l10n_br_cnae_1480", "l10n_br_fiscal.cnae_4763603"),
    ("l10n_br_account.l10n_br_cnae_1481", "l10n_br_fiscal.cnae_4763604"),
    ("l10n_br_account.l10n_br_cnae_1482", "l10n_br_fiscal.cnae_4763605"),
    ("l10n_br_account.l10n_br_cnae_1483", "l10n_br_fiscal.cnae_477"),
    ("l10n_br_account.l10n_br_cnae_1484", "l10n_br_fiscal.cnae_47717"),
    ("l10n_br_account.l10n_br_cnae_1485", "l10n_br_fiscal.cnae_4771701"),
    ("l10n_br_account.l10n_br_cnae_1486", "l10n_br_fiscal.cnae_4771702"),
    ("l10n_br_account.l10n_br_cnae_1487", "l10n_br_fiscal.cnae_4771703"),
    ("l10n_br_account.l10n_br_cnae_1488", "l10n_br_fiscal.cnae_4771704"),
    ("l10n_br_account.l10n_br_cnae_1489", "l10n_br_fiscal.cnae_47725"),
    ("l10n_br_account.l10n_br_cnae_1490", "l10n_br_fiscal.cnae_4772500"),
    ("l10n_br_account.l10n_br_cnae_1491", "l10n_br_fiscal.cnae_47733"),
    ("l10n_br_account.l10n_br_cnae_1492", "l10n_br_fiscal.cnae_4773300"),
    ("l10n_br_account.l10n_br_cnae_1493", "l10n_br_fiscal.cnae_47741"),
    ("l10n_br_account.l10n_br_cnae_1494", "l10n_br_fiscal.cnae_4774100"),
    ("l10n_br_account.l10n_br_cnae_1495", "l10n_br_fiscal.cnae_478"),
    ("l10n_br_account.l10n_br_cnae_1496", "l10n_br_fiscal.cnae_47814"),
    ("l10n_br_account.l10n_br_cnae_1497", "l10n_br_fiscal.cnae_4781400"),
    ("l10n_br_account.l10n_br_cnae_1498", "l10n_br_fiscal.cnae_47822"),
    ("l10n_br_account.l10n_br_cnae_1499", "l10n_br_fiscal.cnae_4782201"),
    ("l10n_br_account.l10n_br_cnae_1500", "l10n_br_fiscal.cnae_4782202"),
    ("l10n_br_account.l10n_br_cnae_1501", "l10n_br_fiscal.cnae_47831"),
    ("l10n_br_account.l10n_br_cnae_1502", "l10n_br_fiscal.cnae_4783101"),
    ("l10n_br_account.l10n_br_cnae_1503", "l10n_br_fiscal.cnae_4783102"),
    ("l10n_br_account.l10n_br_cnae_1504", "l10n_br_fiscal.cnae_47849"),
    ("l10n_br_account.l10n_br_cnae_1505", "l10n_br_fiscal.cnae_4784900"),
    ("l10n_br_account.l10n_br_cnae_1506", "l10n_br_fiscal.cnae_47857"),
    ("l10n_br_account.l10n_br_cnae_1507", "l10n_br_fiscal.cnae_4785701"),
    ("l10n_br_account.l10n_br_cnae_1508", "l10n_br_fiscal.cnae_4785799"),
    ("l10n_br_account.l10n_br_cnae_1509", "l10n_br_fiscal.cnae_47890"),
    ("l10n_br_account.l10n_br_cnae_1510", "l10n_br_fiscal.cnae_4789001"),
    ("l10n_br_account.l10n_br_cnae_1511", "l10n_br_fiscal.cnae_4789002"),
    ("l10n_br_account.l10n_br_cnae_1512", "l10n_br_fiscal.cnae_4789003"),
    ("l10n_br_account.l10n_br_cnae_1513", "l10n_br_fiscal.cnae_4789004"),
    ("l10n_br_account.l10n_br_cnae_1514", "l10n_br_fiscal.cnae_4789005"),
    ("l10n_br_account.l10n_br_cnae_1515", "l10n_br_fiscal.cnae_4789006"),
    ("l10n_br_account.l10n_br_cnae_1516", "l10n_br_fiscal.cnae_4789007"),
    ("l10n_br_account.l10n_br_cnae_1517", "l10n_br_fiscal.cnae_4789008"),
    ("l10n_br_account.l10n_br_cnae_1518", "l10n_br_fiscal.cnae_4789009"),
    ("l10n_br_account.l10n_br_cnae_1519", "l10n_br_fiscal.cnae_4789099"),
    ("l10n_br_account.l10n_br_cnae_1520", "l10n_br_fiscal.cnae_479"),
    ("l10n_br_account.l10n_br_cnae_1521", "l10n_br_fiscal.cnae_47903"),
    ("l10n_br_account.l10n_br_cnae_1522", "l10n_br_fiscal.cnae_H"),
    ("l10n_br_account.l10n_br_cnae_1523", "l10n_br_fiscal.cnae_49"),
    ("l10n_br_account.l10n_br_cnae_1524", "l10n_br_fiscal.cnae_491"),
    ("l10n_br_account.l10n_br_cnae_1525", "l10n_br_fiscal.cnae_49116"),
    ("l10n_br_account.l10n_br_cnae_1526", "l10n_br_fiscal.cnae_4911600"),
    ("l10n_br_account.l10n_br_cnae_1527", "l10n_br_fiscal.cnae_49124"),
    ("l10n_br_account.l10n_br_cnae_1528", "l10n_br_fiscal.cnae_4912401"),
    ("l10n_br_account.l10n_br_cnae_1529", "l10n_br_fiscal.cnae_4912402"),
    ("l10n_br_account.l10n_br_cnae_1530", "l10n_br_fiscal.cnae_4912403"),
    ("l10n_br_account.l10n_br_cnae_1531", "l10n_br_fiscal.cnae_492"),
    ("l10n_br_account.l10n_br_cnae_1532", "l10n_br_fiscal.cnae_49213"),
    ("l10n_br_account.l10n_br_cnae_1533", "l10n_br_fiscal.cnae_4921301"),
    ("l10n_br_account.l10n_br_cnae_1534", "l10n_br_fiscal.cnae_4921302"),
    ("l10n_br_account.l10n_br_cnae_1535", "l10n_br_fiscal.cnae_49221"),
    ("l10n_br_account.l10n_br_cnae_1536", "l10n_br_fiscal.cnae_4922101"),
    ("l10n_br_account.l10n_br_cnae_1537", "l10n_br_fiscal.cnae_4922102"),
    ("l10n_br_account.l10n_br_cnae_1538", "l10n_br_fiscal.cnae_4922103"),
    ("l10n_br_account.l10n_br_cnae_1539", "l10n_br_fiscal.cnae_49230"),
    ("l10n_br_account.l10n_br_cnae_1540", "l10n_br_fiscal.cnae_4923001"),
    ("l10n_br_account.l10n_br_cnae_1541", "l10n_br_fiscal.cnae_4923002"),
    ("l10n_br_account.l10n_br_cnae_1542", "l10n_br_fiscal.cnae_49248"),
    ("l10n_br_account.l10n_br_cnae_1543", "l10n_br_fiscal.cnae_4924800"),
    ("l10n_br_account.l10n_br_cnae_1544", "l10n_br_fiscal.cnae_49299"),
    ("l10n_br_account.l10n_br_cnae_1545", "l10n_br_fiscal.cnae_4929901"),
    ("l10n_br_account.l10n_br_cnae_1546", "l10n_br_fiscal.cnae_4929902"),
    ("l10n_br_account.l10n_br_cnae_1547", "l10n_br_fiscal.cnae_4929903"),
    ("l10n_br_account.l10n_br_cnae_1548", "l10n_br_fiscal.cnae_4929904"),
    ("l10n_br_account.l10n_br_cnae_1549", "l10n_br_fiscal.cnae_4929999"),
    ("l10n_br_account.l10n_br_cnae_1550", "l10n_br_fiscal.cnae_493"),
    ("l10n_br_account.l10n_br_cnae_1551", "l10n_br_fiscal.cnae_49302"),
    ("l10n_br_account.l10n_br_cnae_1552", "l10n_br_fiscal.cnae_4930201"),
    ("l10n_br_account.l10n_br_cnae_1553", "l10n_br_fiscal.cnae_4930202"),
    ("l10n_br_account.l10n_br_cnae_1554", "l10n_br_fiscal.cnae_4930203"),
    ("l10n_br_account.l10n_br_cnae_1555", "l10n_br_fiscal.cnae_4930204"),
    ("l10n_br_account.l10n_br_cnae_1556", "l10n_br_fiscal.cnae_494"),
    ("l10n_br_account.l10n_br_cnae_1557", "l10n_br_fiscal.cnae_49400"),
    ("l10n_br_account.l10n_br_cnae_1558", "l10n_br_fiscal.cnae_4940000"),
    ("l10n_br_account.l10n_br_cnae_1559", "l10n_br_fiscal.cnae_495"),
    ("l10n_br_account.l10n_br_cnae_1560", "l10n_br_fiscal.cnae_49507"),
    ("l10n_br_account.l10n_br_cnae_1561", "l10n_br_fiscal.cnae_4950700"),
    ("l10n_br_account.l10n_br_cnae_1562", "l10n_br_fiscal.cnae_50"),
    ("l10n_br_account.l10n_br_cnae_1563", "l10n_br_fiscal.cnae_501"),
    ("l10n_br_account.l10n_br_cnae_1564", "l10n_br_fiscal.cnae_50114"),
    ("l10n_br_account.l10n_br_cnae_1565", "l10n_br_fiscal.cnae_5011401"),
    ("l10n_br_account.l10n_br_cnae_1566", "l10n_br_fiscal.cnae_5011402"),
    ("l10n_br_account.l10n_br_cnae_1567", "l10n_br_fiscal.cnae_50122"),
    ("l10n_br_account.l10n_br_cnae_1568", "l10n_br_fiscal.cnae_5012201"),
    ("l10n_br_account.l10n_br_cnae_1569", "l10n_br_fiscal.cnae_5012202"),
    ("l10n_br_account.l10n_br_cnae_1570", "l10n_br_fiscal.cnae_502"),
    ("l10n_br_account.l10n_br_cnae_1571", "l10n_br_fiscal.cnae_50211"),
    ("l10n_br_account.l10n_br_cnae_1572", "l10n_br_fiscal.cnae_5021101"),
    ("l10n_br_account.l10n_br_cnae_1573", "l10n_br_fiscal.cnae_5021102"),
    ("l10n_br_account.l10n_br_cnae_1574", "l10n_br_fiscal.cnae_50220"),
    ("l10n_br_account.l10n_br_cnae_1575", "l10n_br_fiscal.cnae_5022001"),
    ("l10n_br_account.l10n_br_cnae_1576", "l10n_br_fiscal.cnae_5022002"),
    ("l10n_br_account.l10n_br_cnae_1577", "l10n_br_fiscal.cnae_503"),
    ("l10n_br_account.l10n_br_cnae_1578", "l10n_br_fiscal.cnae_50301"),
    ("l10n_br_account.l10n_br_cnae_1579", "l10n_br_fiscal.cnae_5030101"),
    ("l10n_br_account.l10n_br_cnae_1580", "l10n_br_fiscal.cnae_5030102"),
    ("l10n_br_account.l10n_br_cnae_1581", "l10n_br_fiscal.cnae_509"),
    ("l10n_br_account.l10n_br_cnae_1582", "l10n_br_fiscal.cnae_50912"),
    ("l10n_br_account.l10n_br_cnae_1583", "l10n_br_fiscal.cnae_5091201"),
    ("l10n_br_account.l10n_br_cnae_1584", "l10n_br_fiscal.cnae_5091202"),
    ("l10n_br_account.l10n_br_cnae_1585", "l10n_br_fiscal.cnae_50998"),
    ("l10n_br_account.l10n_br_cnae_1586", "l10n_br_fiscal.cnae_5099801"),
    ("l10n_br_account.l10n_br_cnae_1587", "l10n_br_fiscal.cnae_5099899"),
    ("l10n_br_account.l10n_br_cnae_1588", "l10n_br_fiscal.cnae_51"),
    ("l10n_br_account.l10n_br_cnae_1589", "l10n_br_fiscal.cnae_511"),
    ("l10n_br_account.l10n_br_cnae_1590", "l10n_br_fiscal.cnae_51111"),
    ("l10n_br_account.l10n_br_cnae_1591", "l10n_br_fiscal.cnae_5111100"),
    ("l10n_br_account.l10n_br_cnae_1592", "l10n_br_fiscal.cnae_51129"),
    ("l10n_br_account.l10n_br_cnae_1593", "l10n_br_fiscal.cnae_5112901"),
    ("l10n_br_account.l10n_br_cnae_1594", "l10n_br_fiscal.cnae_5112999"),
    ("l10n_br_account.l10n_br_cnae_1595", "l10n_br_fiscal.cnae_512"),
    ("l10n_br_account.l10n_br_cnae_1596", "l10n_br_fiscal.cnae_51200"),
    ("l10n_br_account.l10n_br_cnae_1597", "l10n_br_fiscal.cnae_5120000"),
    ("l10n_br_account.l10n_br_cnae_1598", "l10n_br_fiscal.cnae_513"),
    ("l10n_br_account.l10n_br_cnae_1599", "l10n_br_fiscal.cnae_51307"),
    ("l10n_br_account.l10n_br_cnae_1600", "l10n_br_fiscal.cnae_5130700"),
    ("l10n_br_account.l10n_br_cnae_1601", "l10n_br_fiscal.cnae_52"),
    ("l10n_br_account.l10n_br_cnae_1602", "l10n_br_fiscal.cnae_521"),
    ("l10n_br_account.l10n_br_cnae_1603", "l10n_br_fiscal.cnae_52117"),
    ("l10n_br_account.l10n_br_cnae_1604", "l10n_br_fiscal.cnae_5211701"),
    ("l10n_br_account.l10n_br_cnae_1605", "l10n_br_fiscal.cnae_5211702"),
    ("l10n_br_account.l10n_br_cnae_1606", "l10n_br_fiscal.cnae_5211799"),
    ("l10n_br_account.l10n_br_cnae_1607", "l10n_br_fiscal.cnae_52125"),
    ("l10n_br_account.l10n_br_cnae_1608", "l10n_br_fiscal.cnae_5212500"),
    ("l10n_br_account.l10n_br_cnae_1609", "l10n_br_fiscal.cnae_522"),
    ("l10n_br_account.l10n_br_cnae_1610", "l10n_br_fiscal.cnae_52214"),
    ("l10n_br_account.l10n_br_cnae_1611", "l10n_br_fiscal.cnae_5221400"),
    ("l10n_br_account.l10n_br_cnae_1612", "l10n_br_fiscal.cnae_52222"),
    ("l10n_br_account.l10n_br_cnae_1613", "l10n_br_fiscal.cnae_5222200"),
    ("l10n_br_account.l10n_br_cnae_1614", "l10n_br_fiscal.cnae_52231"),
    ("l10n_br_account.l10n_br_cnae_1615", "l10n_br_fiscal.cnae_5223100"),
    ("l10n_br_account.l10n_br_cnae_1616", "l10n_br_fiscal.cnae_52290"),
    ("l10n_br_account.l10n_br_cnae_1617", "l10n_br_fiscal.cnae_5229001"),
    ("l10n_br_account.l10n_br_cnae_1618", "l10n_br_fiscal.cnae_5229002"),
    ("l10n_br_account.l10n_br_cnae_1619", "l10n_br_fiscal.cnae_5229099"),
    ("l10n_br_account.l10n_br_cnae_1620", "l10n_br_fiscal.cnae_523"),
    ("l10n_br_account.l10n_br_cnae_1621", "l10n_br_fiscal.cnae_52311"),
    ("l10n_br_account.l10n_br_cnae_1622", "l10n_br_fiscal.cnae_5231101"),
    ("l10n_br_account.l10n_br_cnae_1623", "l10n_br_fiscal.cnae_5231102"),
    ("l10n_br_account.l10n_br_cnae_1624", "l10n_br_fiscal.cnae_52320"),
    ("l10n_br_account.l10n_br_cnae_1625", "l10n_br_fiscal.cnae_5232000"),
    ("l10n_br_account.l10n_br_cnae_1626", "l10n_br_fiscal.cnae_52397"),
    ("l10n_br_account.l10n_br_cnae_1627", "l10n_br_fiscal.cnae_5239700"),
    ("l10n_br_account.l10n_br_cnae_1628", "l10n_br_fiscal.cnae_524"),
    ("l10n_br_account.l10n_br_cnae_1629", "l10n_br_fiscal.cnae_52401"),
    ("l10n_br_account.l10n_br_cnae_1630", "l10n_br_fiscal.cnae_5240101"),
    ("l10n_br_account.l10n_br_cnae_1631", "l10n_br_fiscal.cnae_5240199"),
    ("l10n_br_account.l10n_br_cnae_1632", "l10n_br_fiscal.cnae_525"),
    ("l10n_br_account.l10n_br_cnae_1633", "l10n_br_fiscal.cnae_52508"),
    ("l10n_br_account.l10n_br_cnae_1634", "l10n_br_fiscal.cnae_5250801"),
    ("l10n_br_account.l10n_br_cnae_1635", "l10n_br_fiscal.cnae_5250802"),
    ("l10n_br_account.l10n_br_cnae_1636", "l10n_br_fiscal.cnae_5250803"),
    ("l10n_br_account.l10n_br_cnae_1637", "l10n_br_fiscal.cnae_5250804"),
    ("l10n_br_account.l10n_br_cnae_1638", "l10n_br_fiscal.cnae_5250805"),
    ("l10n_br_account.l10n_br_cnae_1639", "l10n_br_fiscal.cnae_53"),
    ("l10n_br_account.l10n_br_cnae_1640", "l10n_br_fiscal.cnae_531"),
    ("l10n_br_account.l10n_br_cnae_1641", "l10n_br_fiscal.cnae_53105"),
    ("l10n_br_account.l10n_br_cnae_1642", "l10n_br_fiscal.cnae_5310501"),
    ("l10n_br_account.l10n_br_cnae_1643", "l10n_br_fiscal.cnae_5310502"),
    ("l10n_br_account.l10n_br_cnae_1644", "l10n_br_fiscal.cnae_532"),
    ("l10n_br_account.l10n_br_cnae_1645", "l10n_br_fiscal.cnae_53202"),
    ("l10n_br_account.l10n_br_cnae_1646", "l10n_br_fiscal.cnae_5320201"),
    ("l10n_br_account.l10n_br_cnae_1647", "l10n_br_fiscal.cnae_5320202"),
    ("l10n_br_account.l10n_br_cnae_1648", "l10n_br_fiscal.cnae_I"),
    ("l10n_br_account.l10n_br_cnae_1649", "l10n_br_fiscal.cnae_55"),
    ("l10n_br_account.l10n_br_cnae_1650", "l10n_br_fiscal.cnae_551"),
    ("l10n_br_account.l10n_br_cnae_1651", "l10n_br_fiscal.cnae_55108"),
    ("l10n_br_account.l10n_br_cnae_1652", "l10n_br_fiscal.cnae_5510801"),
    ("l10n_br_account.l10n_br_cnae_1653", "l10n_br_fiscal.cnae_5510802"),
    ("l10n_br_account.l10n_br_cnae_1654", "l10n_br_fiscal.cnae_5510803"),
    ("l10n_br_account.l10n_br_cnae_1655", "l10n_br_fiscal.cnae_559"),
    ("l10n_br_account.l10n_br_cnae_1656", "l10n_br_fiscal.cnae_55906"),
    ("l10n_br_account.l10n_br_cnae_1657", "l10n_br_fiscal.cnae_5590601"),
    ("l10n_br_account.l10n_br_cnae_1658", "l10n_br_fiscal.cnae_5590602"),
    ("l10n_br_account.l10n_br_cnae_1659", "l10n_br_fiscal.cnae_5590603"),
    ("l10n_br_account.l10n_br_cnae_1660", "l10n_br_fiscal.cnae_5590699"),
    ("l10n_br_account.l10n_br_cnae_1661", "l10n_br_fiscal.cnae_56"),
    ("l10n_br_account.l10n_br_cnae_1662", "l10n_br_fiscal.cnae_561"),
    ("l10n_br_account.l10n_br_cnae_1663", "l10n_br_fiscal.cnae_56112"),
    ("l10n_br_account.l10n_br_cnae_1664", "l10n_br_fiscal.cnae_5611201"),
    ("l10n_br_account.l10n_br_cnae_1665", "l10n_br_fiscal.cnae_5611202"),
    ("l10n_br_account.l10n_br_cnae_1666", "l10n_br_fiscal.cnae_5611203"),
    ("l10n_br_account.l10n_br_cnae_1667", "l10n_br_fiscal.cnae_56121"),
    ("l10n_br_account.l10n_br_cnae_1668", "l10n_br_fiscal.cnae_5612100"),
    ("l10n_br_account.l10n_br_cnae_1669", "l10n_br_fiscal.cnae_562"),
    ("l10n_br_account.l10n_br_cnae_1670", "l10n_br_fiscal.cnae_56201"),
    ("l10n_br_account.l10n_br_cnae_1671", "l10n_br_fiscal.cnae_5620101"),
    ("l10n_br_account.l10n_br_cnae_1672", "l10n_br_fiscal.cnae_5620102"),
    ("l10n_br_account.l10n_br_cnae_1673", "l10n_br_fiscal.cnae_5620103"),
    ("l10n_br_account.l10n_br_cnae_1674", "l10n_br_fiscal.cnae_5620104"),
    ("l10n_br_account.l10n_br_cnae_1675", "l10n_br_fiscal.cnae_J"),
    ("l10n_br_account.l10n_br_cnae_1676", "l10n_br_fiscal.cnae_58"),
    ("l10n_br_account.l10n_br_cnae_1677", "l10n_br_fiscal.cnae_581"),
    ("l10n_br_account.l10n_br_cnae_1678", "l10n_br_fiscal.cnae_58115"),
    ("l10n_br_account.l10n_br_cnae_1679", "l10n_br_fiscal.cnae_5811500"),
    ("l10n_br_account.l10n_br_cnae_1680", "l10n_br_fiscal.cnae_58123"),
    ("l10n_br_account.l10n_br_cnae_1681", "l10n_br_fiscal.cnae_5812300"),
    ("l10n_br_account.l10n_br_cnae_1682", "l10n_br_fiscal.cnae_58131"),
    ("l10n_br_account.l10n_br_cnae_1683", "l10n_br_fiscal.cnae_5813100"),
    ("l10n_br_account.l10n_br_cnae_1684", "l10n_br_fiscal.cnae_58191"),
    ("l10n_br_account.l10n_br_cnae_1685", "l10n_br_fiscal.cnae_5819100"),
    ("l10n_br_account.l10n_br_cnae_1686", "l10n_br_fiscal.cnae_582"),
    ("l10n_br_account.l10n_br_cnae_1687", "l10n_br_fiscal.cnae_58212"),
    ("l10n_br_account.l10n_br_cnae_1688", "l10n_br_fiscal.cnae_5821200"),
    ("l10n_br_account.l10n_br_cnae_1689", "l10n_br_fiscal.cnae_58221"),
    ("l10n_br_account.l10n_br_cnae_1690", "l10n_br_fiscal.cnae_5822100"),
    ("l10n_br_account.l10n_br_cnae_1691", "l10n_br_fiscal.cnae_58239"),
    ("l10n_br_account.l10n_br_cnae_1692", "l10n_br_fiscal.cnae_5823900"),
    ("l10n_br_account.l10n_br_cnae_1693", "l10n_br_fiscal.cnae_58298"),
    ("l10n_br_account.l10n_br_cnae_1694", "l10n_br_fiscal.cnae_5829800"),
    ("l10n_br_account.l10n_br_cnae_1695", "l10n_br_fiscal.cnae_59"),
    ("l10n_br_account.l10n_br_cnae_1696", "l10n_br_fiscal.cnae_591"),
    ("l10n_br_account.l10n_br_cnae_1697", "l10n_br_fiscal.cnae_59111"),
    ("l10n_br_account.l10n_br_cnae_1698", "l10n_br_fiscal.cnae_5911101"),
    ("l10n_br_account.l10n_br_cnae_1699", "l10n_br_fiscal.cnae_5911102"),
    ("l10n_br_account.l10n_br_cnae_1700", "l10n_br_fiscal.cnae_5911199"),
    ("l10n_br_account.l10n_br_cnae_1701", "l10n_br_fiscal.cnae_59120"),
    ("l10n_br_account.l10n_br_cnae_1702", "l10n_br_fiscal.cnae_5912001"),
    ("l10n_br_account.l10n_br_cnae_1703", "l10n_br_fiscal.cnae_5912002"),
    ("l10n_br_account.l10n_br_cnae_1704", "l10n_br_fiscal.cnae_5912099"),
    ("l10n_br_account.l10n_br_cnae_1705", "l10n_br_fiscal.cnae_59138"),
    ("l10n_br_account.l10n_br_cnae_1706", "l10n_br_fiscal.cnae_5913800"),
    ("l10n_br_account.l10n_br_cnae_1707", "l10n_br_fiscal.cnae_59146"),
    ("l10n_br_account.l10n_br_cnae_1708", "l10n_br_fiscal.cnae_5914600"),
    ("l10n_br_account.l10n_br_cnae_1709", "l10n_br_fiscal.cnae_592"),
    ("l10n_br_account.l10n_br_cnae_1710", "l10n_br_fiscal.cnae_59201"),
    ("l10n_br_account.l10n_br_cnae_1711", "l10n_br_fiscal.cnae_5920100"),
    ("l10n_br_account.l10n_br_cnae_1712", "l10n_br_fiscal.cnae_60"),
    ("l10n_br_account.l10n_br_cnae_1713", "l10n_br_fiscal.cnae_601"),
    ("l10n_br_account.l10n_br_cnae_1714", "l10n_br_fiscal.cnae_60101"),
    ("l10n_br_account.l10n_br_cnae_1715", "l10n_br_fiscal.cnae_6010100"),
    ("l10n_br_account.l10n_br_cnae_1716", "l10n_br_fiscal.cnae_602"),
    ("l10n_br_account.l10n_br_cnae_1717", "l10n_br_fiscal.cnae_60217"),
    ("l10n_br_account.l10n_br_cnae_1718", "l10n_br_fiscal.cnae_6021700"),
    ("l10n_br_account.l10n_br_cnae_1719", "l10n_br_fiscal.cnae_60225"),
    ("l10n_br_account.l10n_br_cnae_1720", "l10n_br_fiscal.cnae_6022501"),
    ("l10n_br_account.l10n_br_cnae_1721", "l10n_br_fiscal.cnae_6022502"),
    ("l10n_br_account.l10n_br_cnae_1722", "l10n_br_fiscal.cnae_61"),
    ("l10n_br_account.l10n_br_cnae_1723", "l10n_br_fiscal.cnae_611"),
    ("l10n_br_account.l10n_br_cnae_1724", "l10n_br_fiscal.cnae_61108"),
    ("l10n_br_account.l10n_br_cnae_1725", "l10n_br_fiscal.cnae_6110801"),
    ("l10n_br_account.l10n_br_cnae_1726", "l10n_br_fiscal.cnae_6110802"),
    ("l10n_br_account.l10n_br_cnae_1727", "l10n_br_fiscal.cnae_6110803"),
    ("l10n_br_account.l10n_br_cnae_1728", "l10n_br_fiscal.cnae_6110899"),
    ("l10n_br_account.l10n_br_cnae_1729", "l10n_br_fiscal.cnae_612"),
    ("l10n_br_account.l10n_br_cnae_1730", "l10n_br_fiscal.cnae_61205"),
    ("l10n_br_account.l10n_br_cnae_1731", "l10n_br_fiscal.cnae_6120501"),
    ("l10n_br_account.l10n_br_cnae_1732", "l10n_br_fiscal.cnae_6120502"),
    ("l10n_br_account.l10n_br_cnae_1733", "l10n_br_fiscal.cnae_6120599"),
    ("l10n_br_account.l10n_br_cnae_1734", "l10n_br_fiscal.cnae_613"),
    ("l10n_br_account.l10n_br_cnae_1735", "l10n_br_fiscal.cnae_61302"),
    ("l10n_br_account.l10n_br_cnae_1736", "l10n_br_fiscal.cnae_6130200"),
    ("l10n_br_account.l10n_br_cnae_1737", "l10n_br_fiscal.cnae_614"),
    ("l10n_br_account.l10n_br_cnae_1738", "l10n_br_fiscal.cnae_61418"),
    ("l10n_br_account.l10n_br_cnae_1739", "l10n_br_fiscal.cnae_6141800"),
    ("l10n_br_account.l10n_br_cnae_1740", "l10n_br_fiscal.cnae_61426"),
    ("l10n_br_account.l10n_br_cnae_1741", "l10n_br_fiscal.cnae_6142600"),
    ("l10n_br_account.l10n_br_cnae_1742", "l10n_br_fiscal.cnae_61434"),
    ("l10n_br_account.l10n_br_cnae_1743", "l10n_br_fiscal.cnae_6143400"),
    ("l10n_br_account.l10n_br_cnae_1744", "l10n_br_fiscal.cnae_619"),
    ("l10n_br_account.l10n_br_cnae_1745", "l10n_br_fiscal.cnae_61906"),
    ("l10n_br_account.l10n_br_cnae_1746", "l10n_br_fiscal.cnae_6190601"),
    ("l10n_br_account.l10n_br_cnae_1747", "l10n_br_fiscal.cnae_6190602"),
    ("l10n_br_account.l10n_br_cnae_1748", "l10n_br_fiscal.cnae_6190699"),
    ("l10n_br_account.l10n_br_cnae_1749", "l10n_br_fiscal.cnae_62"),
    ("l10n_br_account.l10n_br_cnae_1750", "l10n_br_fiscal.cnae_620"),
    ("l10n_br_account.l10n_br_cnae_1751", "l10n_br_fiscal.cnae_62015"),
    ("l10n_br_account.l10n_br_cnae_1752", "l10n_br_fiscal.cnae_6201500"),
    ("l10n_br_account.l10n_br_cnae_1753", "l10n_br_fiscal.cnae_62023"),
    ("l10n_br_account.l10n_br_cnae_1754", "l10n_br_fiscal.cnae_6202300"),
    ("l10n_br_account.l10n_br_cnae_1755", "l10n_br_fiscal.cnae_62031"),
    ("l10n_br_account.l10n_br_cnae_1756", "l10n_br_fiscal.cnae_6203100"),
    ("l10n_br_account.l10n_br_cnae_1757", "l10n_br_fiscal.cnae_62040"),
    ("l10n_br_account.l10n_br_cnae_1758", "l10n_br_fiscal.cnae_6204000"),
    ("l10n_br_account.l10n_br_cnae_1759", "l10n_br_fiscal.cnae_62091"),
    ("l10n_br_account.l10n_br_cnae_1760", "l10n_br_fiscal.cnae_6209100"),
    ("l10n_br_account.l10n_br_cnae_1761", "l10n_br_fiscal.cnae_63"),
    ("l10n_br_account.l10n_br_cnae_1762", "l10n_br_fiscal.cnae_631"),
    ("l10n_br_account.l10n_br_cnae_1763", "l10n_br_fiscal.cnae_63119"),
    ("l10n_br_account.l10n_br_cnae_1764", "l10n_br_fiscal.cnae_6311900"),
    ("l10n_br_account.l10n_br_cnae_1765", "l10n_br_fiscal.cnae_63194"),
    ("l10n_br_account.l10n_br_cnae_1766", "l10n_br_fiscal.cnae_6319400"),
    ("l10n_br_account.l10n_br_cnae_1767", "l10n_br_fiscal.cnae_639"),
    ("l10n_br_account.l10n_br_cnae_1768", "l10n_br_fiscal.cnae_63917"),
    ("l10n_br_account.l10n_br_cnae_1769", "l10n_br_fiscal.cnae_6391700"),
    ("l10n_br_account.l10n_br_cnae_1770", "l10n_br_fiscal.cnae_63992"),
    ("l10n_br_account.l10n_br_cnae_1771", "l10n_br_fiscal.cnae_6399200"),
    ("l10n_br_account.l10n_br_cnae_1772", "l10n_br_fiscal.cnae_K"),
    ("l10n_br_account.l10n_br_cnae_1773", "l10n_br_fiscal.cnae_64"),
    ("l10n_br_account.l10n_br_cnae_1774", "l10n_br_fiscal.cnae_641"),
    ("l10n_br_account.l10n_br_cnae_1775", "l10n_br_fiscal.cnae_64107"),
    ("l10n_br_account.l10n_br_cnae_1776", "l10n_br_fiscal.cnae_6410700"),
    ("l10n_br_account.l10n_br_cnae_1777", "l10n_br_fiscal.cnae_642"),
    ("l10n_br_account.l10n_br_cnae_1778", "l10n_br_fiscal.cnae_64212"),
    ("l10n_br_account.l10n_br_cnae_1779", "l10n_br_fiscal.cnae_6421200"),
    ("l10n_br_account.l10n_br_cnae_1780", "l10n_br_fiscal.cnae_64221"),
    ("l10n_br_account.l10n_br_cnae_1781", "l10n_br_fiscal.cnae_6422100"),
    ("l10n_br_account.l10n_br_cnae_1782", "l10n_br_fiscal.cnae_64239"),
    ("l10n_br_account.l10n_br_cnae_1783", "l10n_br_fiscal.cnae_6423900"),
    ("l10n_br_account.l10n_br_cnae_1784", "l10n_br_fiscal.cnae_64247"),
    ("l10n_br_account.l10n_br_cnae_1785", "l10n_br_fiscal.cnae_6424701"),
    ("l10n_br_account.l10n_br_cnae_1786", "l10n_br_fiscal.cnae_6424702"),
    ("l10n_br_account.l10n_br_cnae_1787", "l10n_br_fiscal.cnae_6424703"),
    ("l10n_br_account.l10n_br_cnae_1788", "l10n_br_fiscal.cnae_6424704"),
    ("l10n_br_account.l10n_br_cnae_1789", "l10n_br_fiscal.cnae_643"),
    ("l10n_br_account.l10n_br_cnae_1790", "l10n_br_fiscal.cnae_64310"),
    ("l10n_br_account.l10n_br_cnae_1791", "l10n_br_fiscal.cnae_6431000"),
    ("l10n_br_account.l10n_br_cnae_1792", "l10n_br_fiscal.cnae_64328"),
    ("l10n_br_account.l10n_br_cnae_1793", "l10n_br_fiscal.cnae_6432800"),
    ("l10n_br_account.l10n_br_cnae_1794", "l10n_br_fiscal.cnae_64336"),
    ("l10n_br_account.l10n_br_cnae_1795", "l10n_br_fiscal.cnae_6433600"),
    ("l10n_br_account.l10n_br_cnae_1796", "l10n_br_fiscal.cnae_64344"),
    ("l10n_br_account.l10n_br_cnae_1797", "l10n_br_fiscal.cnae_6434400"),
    ("l10n_br_account.l10n_br_cnae_1798", "l10n_br_fiscal.cnae_64352"),
    ("l10n_br_account.l10n_br_cnae_1799", "l10n_br_fiscal.cnae_6435201"),
    ("l10n_br_account.l10n_br_cnae_1800", "l10n_br_fiscal.cnae_6435202"),
    ("l10n_br_account.l10n_br_cnae_1801", "l10n_br_fiscal.cnae_6435203"),
    ("l10n_br_account.l10n_br_cnae_1802", "l10n_br_fiscal.cnae_64361"),
    ("l10n_br_account.l10n_br_cnae_1803", "l10n_br_fiscal.cnae_6436100"),
    ("l10n_br_account.l10n_br_cnae_1804", "l10n_br_fiscal.cnae_64379"),
    ("l10n_br_account.l10n_br_cnae_1805", "l10n_br_fiscal.cnae_6437900"),
    ("l10n_br_account.l10n_br_cnae_1806", "l10n_br_fiscal.cnae_644"),
    ("l10n_br_account.l10n_br_cnae_1807", "l10n_br_fiscal.cnae_64409"),
    ("l10n_br_account.l10n_br_cnae_1808", "l10n_br_fiscal.cnae_6440900"),
    ("l10n_br_account.l10n_br_cnae_1809", "l10n_br_fiscal.cnae_645"),
    ("l10n_br_account.l10n_br_cnae_1810", "l10n_br_fiscal.cnae_64506"),
    ("l10n_br_account.l10n_br_cnae_1811", "l10n_br_fiscal.cnae_6450600"),
    ("l10n_br_account.l10n_br_cnae_1812", "l10n_br_fiscal.cnae_646"),
    ("l10n_br_account.l10n_br_cnae_1813", "l10n_br_fiscal.cnae_64611"),
    ("l10n_br_account.l10n_br_cnae_1814", "l10n_br_fiscal.cnae_6461100"),
    ("l10n_br_account.l10n_br_cnae_1815", "l10n_br_fiscal.cnae_64620"),
    ("l10n_br_account.l10n_br_cnae_1816", "l10n_br_fiscal.cnae_6462000"),
    ("l10n_br_account.l10n_br_cnae_1817", "l10n_br_fiscal.cnae_64638"),
    ("l10n_br_account.l10n_br_cnae_1818", "l10n_br_fiscal.cnae_6463800"),
    ("l10n_br_account.l10n_br_cnae_1819", "l10n_br_fiscal.cnae_647"),
    ("l10n_br_account.l10n_br_cnae_1820", "l10n_br_fiscal.cnae_64701"),
    ("l10n_br_account.l10n_br_cnae_1821", "l10n_br_fiscal.cnae_6470101"),
    ("l10n_br_account.l10n_br_cnae_1822", "l10n_br_fiscal.cnae_6470102"),
    ("l10n_br_account.l10n_br_cnae_1823", "l10n_br_fiscal.cnae_6470103"),
    ("l10n_br_account.l10n_br_cnae_1824", "l10n_br_fiscal.cnae_649"),
    ("l10n_br_account.l10n_br_cnae_1825", "l10n_br_fiscal.cnae_64913"),
    ("l10n_br_account.l10n_br_cnae_1826", "l10n_br_fiscal.cnae_6491300"),
    ("l10n_br_account.l10n_br_cnae_1827", "l10n_br_fiscal.cnae_64921"),
    ("l10n_br_account.l10n_br_cnae_1828", "l10n_br_fiscal.cnae_6492100"),
    ("l10n_br_account.l10n_br_cnae_1829", "l10n_br_fiscal.cnae_64930"),
    ("l10n_br_account.l10n_br_cnae_1830", "l10n_br_fiscal.cnae_6493000"),
    ("l10n_br_account.l10n_br_cnae_1831", "l10n_br_fiscal.cnae_64999"),
    ("l10n_br_account.l10n_br_cnae_1832", "l10n_br_fiscal.cnae_6499901"),
    ("l10n_br_account.l10n_br_cnae_1833", "l10n_br_fiscal.cnae_6499902"),
    ("l10n_br_account.l10n_br_cnae_1834", "l10n_br_fiscal.cnae_6499903"),
    ("l10n_br_account.l10n_br_cnae_1835", "l10n_br_fiscal.cnae_6499904"),
    ("l10n_br_account.l10n_br_cnae_1836", "l10n_br_fiscal.cnae_6499905"),
    ("l10n_br_account.l10n_br_cnae_1837", "l10n_br_fiscal.cnae_6499999"),
    ("l10n_br_account.l10n_br_cnae_1838", "l10n_br_fiscal.cnae_65"),
    ("l10n_br_account.l10n_br_cnae_1839", "l10n_br_fiscal.cnae_651"),
    ("l10n_br_account.l10n_br_cnae_1840", "l10n_br_fiscal.cnae_65111"),
    ("l10n_br_account.l10n_br_cnae_1841", "l10n_br_fiscal.cnae_6511101"),
    ("l10n_br_account.l10n_br_cnae_1842", "l10n_br_fiscal.cnae_6511102"),
    ("l10n_br_account.l10n_br_cnae_1843", "l10n_br_fiscal.cnae_65120"),
    ("l10n_br_account.l10n_br_cnae_1844", "l10n_br_fiscal.cnae_6512000"),
    ("l10n_br_account.l10n_br_cnae_1845", "l10n_br_fiscal.cnae_652"),
    ("l10n_br_account.l10n_br_cnae_1846", "l10n_br_fiscal.cnae_65201"),
    ("l10n_br_account.l10n_br_cnae_1847", "l10n_br_fiscal.cnae_6520100"),
    ("l10n_br_account.l10n_br_cnae_1848", "l10n_br_fiscal.cnae_653"),
    ("l10n_br_account.l10n_br_cnae_1849", "l10n_br_fiscal.cnae_65308"),
    ("l10n_br_account.l10n_br_cnae_1850", "l10n_br_fiscal.cnae_6530800"),
    ("l10n_br_account.l10n_br_cnae_1851", "l10n_br_fiscal.cnae_654"),
    ("l10n_br_account.l10n_br_cnae_1852", "l10n_br_fiscal.cnae_65413"),
    ("l10n_br_account.l10n_br_cnae_1853", "l10n_br_fiscal.cnae_6541300"),
    ("l10n_br_account.l10n_br_cnae_1854", "l10n_br_fiscal.cnae_65421"),
    ("l10n_br_account.l10n_br_cnae_1855", "l10n_br_fiscal.cnae_6542100"),
    ("l10n_br_account.l10n_br_cnae_1856", "l10n_br_fiscal.cnae_655"),
    ("l10n_br_account.l10n_br_cnae_1857", "l10n_br_fiscal.cnae_65502"),
    ("l10n_br_account.l10n_br_cnae_1858", "l10n_br_fiscal.cnae_6550200"),
    ("l10n_br_account.l10n_br_cnae_1859", "l10n_br_fiscal.cnae_66"),
    ("l10n_br_account.l10n_br_cnae_1860", "l10n_br_fiscal.cnae_661"),
    ("l10n_br_account.l10n_br_cnae_1861", "l10n_br_fiscal.cnae_66118"),
    ("l10n_br_account.l10n_br_cnae_1862", "l10n_br_fiscal.cnae_6611801"),
    ("l10n_br_account.l10n_br_cnae_1863", "l10n_br_fiscal.cnae_6611802"),
    ("l10n_br_account.l10n_br_cnae_1864", "l10n_br_fiscal.cnae_6611803"),
    ("l10n_br_account.l10n_br_cnae_1865", "l10n_br_fiscal.cnae_6611804"),
    ("l10n_br_account.l10n_br_cnae_1866", "l10n_br_fiscal.cnae_66126"),
    ("l10n_br_account.l10n_br_cnae_1867", "l10n_br_fiscal.cnae_6612601"),
    ("l10n_br_account.l10n_br_cnae_1868", "l10n_br_fiscal.cnae_6612602"),
    ("l10n_br_account.l10n_br_cnae_1869", "l10n_br_fiscal.cnae_6612603"),
    ("l10n_br_account.l10n_br_cnae_1870", "l10n_br_fiscal.cnae_6612604"),
    ("l10n_br_account.l10n_br_cnae_1871", "l10n_br_fiscal.cnae_6612605"),
    ("l10n_br_account.l10n_br_cnae_1872", "l10n_br_fiscal.cnae_66134"),
    ("l10n_br_account.l10n_br_cnae_1873", "l10n_br_fiscal.cnae_6613400"),
    ("l10n_br_account.l10n_br_cnae_1874", "l10n_br_fiscal.cnae_66193"),
    ("l10n_br_account.l10n_br_cnae_1875", "l10n_br_fiscal.cnae_6619301"),
    ("l10n_br_account.l10n_br_cnae_1876", "l10n_br_fiscal.cnae_6619302"),
    ("l10n_br_account.l10n_br_cnae_1877", "l10n_br_fiscal.cnae_6619303"),
    ("l10n_br_account.l10n_br_cnae_1878", "l10n_br_fiscal.cnae_6619304"),
    ("l10n_br_account.l10n_br_cnae_1879", "l10n_br_fiscal.cnae_6619305"),
    ("l10n_br_account.l10n_br_cnae_1880", "l10n_br_fiscal.cnae_6619399"),
    ("l10n_br_account.l10n_br_cnae_1881", "l10n_br_fiscal.cnae_662"),
    ("l10n_br_account.l10n_br_cnae_1882", "l10n_br_fiscal.cnae_66215"),
    ("l10n_br_account.l10n_br_cnae_1883", "l10n_br_fiscal.cnae_6621501"),
    ("l10n_br_account.l10n_br_cnae_1884", "l10n_br_fiscal.cnae_6621502"),
    ("l10n_br_account.l10n_br_cnae_1885", "l10n_br_fiscal.cnae_66223"),
    ("l10n_br_account.l10n_br_cnae_1886", "l10n_br_fiscal.cnae_6622300"),
    ("l10n_br_account.l10n_br_cnae_1887", "l10n_br_fiscal.cnae_66291"),
    ("l10n_br_account.l10n_br_cnae_1888", "l10n_br_fiscal.cnae_6629100"),
    ("l10n_br_account.l10n_br_cnae_1889", "l10n_br_fiscal.cnae_663"),
    ("l10n_br_account.l10n_br_cnae_1890", "l10n_br_fiscal.cnae_66304"),
    ("l10n_br_account.l10n_br_cnae_1891", "l10n_br_fiscal.cnae_6630400"),
    ("l10n_br_account.l10n_br_cnae_1892", "l10n_br_fiscal.cnae_L"),
    ("l10n_br_account.l10n_br_cnae_1893", "l10n_br_fiscal.cnae_68"),
    ("l10n_br_account.l10n_br_cnae_1894", "l10n_br_fiscal.cnae_681"),
    ("l10n_br_account.l10n_br_cnae_1895", "l10n_br_fiscal.cnae_68102"),
    ("l10n_br_account.l10n_br_cnae_1896", "l10n_br_fiscal.cnae_6810201"),
    ("l10n_br_account.l10n_br_cnae_1897", "l10n_br_fiscal.cnae_6810202"),
    ("l10n_br_account.l10n_br_cnae_1898", "l10n_br_fiscal.cnae_682"),
    ("l10n_br_account.l10n_br_cnae_1899", "l10n_br_fiscal.cnae_68218"),
    ("l10n_br_account.l10n_br_cnae_1900", "l10n_br_fiscal.cnae_6821801"),
    ("l10n_br_account.l10n_br_cnae_1901", "l10n_br_fiscal.cnae_6821802"),
    ("l10n_br_account.l10n_br_cnae_1902", "l10n_br_fiscal.cnae_68226"),
    ("l10n_br_account.l10n_br_cnae_1903", "l10n_br_fiscal.cnae_6822600"),
    ("l10n_br_account.l10n_br_cnae_1904", "l10n_br_fiscal.cnae_M"),
    ("l10n_br_account.l10n_br_cnae_1905", "l10n_br_fiscal.cnae_69"),
    ("l10n_br_account.l10n_br_cnae_1906", "l10n_br_fiscal.cnae_691"),
    ("l10n_br_account.l10n_br_cnae_1907", "l10n_br_fiscal.cnae_69117"),
    ("l10n_br_account.l10n_br_cnae_1908", "l10n_br_fiscal.cnae_6911701"),
    ("l10n_br_account.l10n_br_cnae_1909", "l10n_br_fiscal.cnae_6911702"),
    ("l10n_br_account.l10n_br_cnae_1910", "l10n_br_fiscal.cnae_6911703"),
    ("l10n_br_account.l10n_br_cnae_1911", "l10n_br_fiscal.cnae_69125"),
    ("l10n_br_account.l10n_br_cnae_1912", "l10n_br_fiscal.cnae_6912500"),
    ("l10n_br_account.l10n_br_cnae_1913", "l10n_br_fiscal.cnae_692"),
    ("l10n_br_account.l10n_br_cnae_1914", "l10n_br_fiscal.cnae_69206"),
    ("l10n_br_account.l10n_br_cnae_1915", "l10n_br_fiscal.cnae_6920601"),
    ("l10n_br_account.l10n_br_cnae_1916", "l10n_br_fiscal.cnae_6920602"),
    ("l10n_br_account.l10n_br_cnae_1917", "l10n_br_fiscal.cnae_70"),
    ("l10n_br_account.l10n_br_cnae_1918", "l10n_br_fiscal.cnae_701"),
    ("l10n_br_account.l10n_br_cnae_1919", "l10n_br_fiscal.cnae_70107"),
    ("l10n_br_account.l10n_br_cnae_1920", "l10n_br_fiscal.cnae_702"),
    ("l10n_br_account.l10n_br_cnae_1921", "l10n_br_fiscal.cnae_70204"),
    ("l10n_br_account.l10n_br_cnae_1922", "l10n_br_fiscal.cnae_7020400"),
    ("l10n_br_account.l10n_br_cnae_1923", "l10n_br_fiscal.cnae_71"),
    ("l10n_br_account.l10n_br_cnae_1924", "l10n_br_fiscal.cnae_711"),
    ("l10n_br_account.l10n_br_cnae_1925", "l10n_br_fiscal.cnae_71111"),
    ("l10n_br_account.l10n_br_cnae_1926", "l10n_br_fiscal.cnae_7111100"),
    ("l10n_br_account.l10n_br_cnae_1927", "l10n_br_fiscal.cnae_71120"),
    ("l10n_br_account.l10n_br_cnae_1928", "l10n_br_fiscal.cnae_7112000"),
    ("l10n_br_account.l10n_br_cnae_1929", "l10n_br_fiscal.cnae_71197"),
    ("l10n_br_account.l10n_br_cnae_1930", "l10n_br_fiscal.cnae_7119701"),
    ("l10n_br_account.l10n_br_cnae_1931", "l10n_br_fiscal.cnae_7119702"),
    ("l10n_br_account.l10n_br_cnae_1932", "l10n_br_fiscal.cnae_7119703"),
    ("l10n_br_account.l10n_br_cnae_1933", "l10n_br_fiscal.cnae_7119704"),
    ("l10n_br_account.l10n_br_cnae_1934", "l10n_br_fiscal.cnae_7119799"),
    ("l10n_br_account.l10n_br_cnae_1935", "l10n_br_fiscal.cnae_712"),
    ("l10n_br_account.l10n_br_cnae_1936", "l10n_br_fiscal.cnae_71201"),
    ("l10n_br_account.l10n_br_cnae_1937", "l10n_br_fiscal.cnae_7120100"),
    ("l10n_br_account.l10n_br_cnae_1938", "l10n_br_fiscal.cnae_72"),
    ("l10n_br_account.l10n_br_cnae_1939", "l10n_br_fiscal.cnae_721"),
    ("l10n_br_account.l10n_br_cnae_1940", "l10n_br_fiscal.cnae_72100"),
    ("l10n_br_account.l10n_br_cnae_1941", "l10n_br_fiscal.cnae_7210000"),
    ("l10n_br_account.l10n_br_cnae_1942", "l10n_br_fiscal.cnae_722"),
    ("l10n_br_account.l10n_br_cnae_1943", "l10n_br_fiscal.cnae_72207"),
    ("l10n_br_account.l10n_br_cnae_1944", "l10n_br_fiscal.cnae_7220700"),
    ("l10n_br_account.l10n_br_cnae_1945", "l10n_br_fiscal.cnae_73"),
    ("l10n_br_account.l10n_br_cnae_1946", "l10n_br_fiscal.cnae_731"),
    ("l10n_br_account.l10n_br_cnae_1947", "l10n_br_fiscal.cnae_73114"),
    ("l10n_br_account.l10n_br_cnae_1948", "l10n_br_fiscal.cnae_7311400"),
    ("l10n_br_account.l10n_br_cnae_1949", "l10n_br_fiscal.cnae_73122"),
    ("l10n_br_account.l10n_br_cnae_1950", "l10n_br_fiscal.cnae_7312200"),
    ("l10n_br_account.l10n_br_cnae_1951", "l10n_br_fiscal.cnae_73190"),
    ("l10n_br_account.l10n_br_cnae_1952", "l10n_br_fiscal.cnae_7319001"),
    ("l10n_br_account.l10n_br_cnae_1953", "l10n_br_fiscal.cnae_7319002"),
    ("l10n_br_account.l10n_br_cnae_1954", "l10n_br_fiscal.cnae_7319003"),
    ("l10n_br_account.l10n_br_cnae_1955", "l10n_br_fiscal.cnae_7319004"),
    ("l10n_br_account.l10n_br_cnae_1956", "l10n_br_fiscal.cnae_7319099"),
    ("l10n_br_account.l10n_br_cnae_1957", "l10n_br_fiscal.cnae_732"),
    ("l10n_br_account.l10n_br_cnae_1958", "l10n_br_fiscal.cnae_73203"),
    ("l10n_br_account.l10n_br_cnae_1959", "l10n_br_fiscal.cnae_7320300"),
    ("l10n_br_account.l10n_br_cnae_1960", "l10n_br_fiscal.cnae_74"),
    ("l10n_br_account.l10n_br_cnae_1961", "l10n_br_fiscal.cnae_741"),
    ("l10n_br_account.l10n_br_cnae_1962", "l10n_br_fiscal.cnae_74102"),
    ("l10n_br_account.l10n_br_cnae_1963", "l10n_br_fiscal.cnae_7410201"),
    ("l10n_br_account.l10n_br_cnae_1964", "l10n_br_fiscal.cnae_7410202"),
    ("l10n_br_account.l10n_br_cnae_1965", "l10n_br_fiscal.cnae_742"),
    ("l10n_br_account.l10n_br_cnae_1966", "l10n_br_fiscal.cnae_74200"),
    ("l10n_br_account.l10n_br_cnae_1967", "l10n_br_fiscal.cnae_7420001"),
    ("l10n_br_account.l10n_br_cnae_1968", "l10n_br_fiscal.cnae_7420002"),
    ("l10n_br_account.l10n_br_cnae_1969", "l10n_br_fiscal.cnae_7420003"),
    ("l10n_br_account.l10n_br_cnae_1970", "l10n_br_fiscal.cnae_7420004"),
    ("l10n_br_account.l10n_br_cnae_1971", "l10n_br_fiscal.cnae_7420005"),
    ("l10n_br_account.l10n_br_cnae_1972", "l10n_br_fiscal.cnae_749"),
    ("l10n_br_account.l10n_br_cnae_1973", "l10n_br_fiscal.cnae_74901"),
    ("l10n_br_account.l10n_br_cnae_1974", "l10n_br_fiscal.cnae_7490101"),
    ("l10n_br_account.l10n_br_cnae_1975", "l10n_br_fiscal.cnae_7490102"),
    ("l10n_br_account.l10n_br_cnae_1976", "l10n_br_fiscal.cnae_7490103"),
    ("l10n_br_account.l10n_br_cnae_1977", "l10n_br_fiscal.cnae_7490104"),
    ("l10n_br_account.l10n_br_cnae_1978", "l10n_br_fiscal.cnae_7490105"),
    ("l10n_br_account.l10n_br_cnae_1979", "l10n_br_fiscal.cnae_7490199"),
    ("l10n_br_account.l10n_br_cnae_1980", "l10n_br_fiscal.cnae_75"),
    ("l10n_br_account.l10n_br_cnae_1981", "l10n_br_fiscal.cnae_750"),
    ("l10n_br_account.l10n_br_cnae_1982", "l10n_br_fiscal.cnae_75001"),
    ("l10n_br_account.l10n_br_cnae_1983", "l10n_br_fiscal.cnae_7500100"),
    ("l10n_br_account.l10n_br_cnae_1984", "l10n_br_fiscal.cnae_N"),
    ("l10n_br_account.l10n_br_cnae_1985", "l10n_br_fiscal.cnae_77"),
    ("l10n_br_account.l10n_br_cnae_1986", "l10n_br_fiscal.cnae_771"),
    ("l10n_br_account.l10n_br_cnae_1987", "l10n_br_fiscal.cnae_77110"),
    ("l10n_br_account.l10n_br_cnae_1988", "l10n_br_fiscal.cnae_7711000"),
    ("l10n_br_account.l10n_br_cnae_1989", "l10n_br_fiscal.cnae_77195"),
    ("l10n_br_account.l10n_br_cnae_1990", "l10n_br_fiscal.cnae_7719501"),
    ("l10n_br_account.l10n_br_cnae_1991", "l10n_br_fiscal.cnae_7719502"),
    ("l10n_br_account.l10n_br_cnae_1992", "l10n_br_fiscal.cnae_7719599"),
    ("l10n_br_account.l10n_br_cnae_1993", "l10n_br_fiscal.cnae_772"),
    ("l10n_br_account.l10n_br_cnae_1994", "l10n_br_fiscal.cnae_77217"),
    ("l10n_br_account.l10n_br_cnae_1995", "l10n_br_fiscal.cnae_7721700"),
    ("l10n_br_account.l10n_br_cnae_1996", "l10n_br_fiscal.cnae_77225"),
    ("l10n_br_account.l10n_br_cnae_1997", "l10n_br_fiscal.cnae_7722500"),
    ("l10n_br_account.l10n_br_cnae_1998", "l10n_br_fiscal.cnae_77233"),
    ("l10n_br_account.l10n_br_cnae_1999", "l10n_br_fiscal.cnae_7723300"),
    ("l10n_br_account.l10n_br_cnae_2000", "l10n_br_fiscal.cnae_77292"),
    ("l10n_br_account.l10n_br_cnae_2001", "l10n_br_fiscal.cnae_7729201"),
    ("l10n_br_account.l10n_br_cnae_2002", "l10n_br_fiscal.cnae_7729202"),
    ("l10n_br_account.l10n_br_cnae_2003", "l10n_br_fiscal.cnae_7729203"),
    ("l10n_br_account.l10n_br_cnae_2004", "l10n_br_fiscal.cnae_7729299"),
    ("l10n_br_account.l10n_br_cnae_2005", "l10n_br_fiscal.cnae_773"),
    ("l10n_br_account.l10n_br_cnae_2006", "l10n_br_fiscal.cnae_77314"),
    ("l10n_br_account.l10n_br_cnae_2007", "l10n_br_fiscal.cnae_7731400"),
    ("l10n_br_account.l10n_br_cnae_2008", "l10n_br_fiscal.cnae_77322"),
    ("l10n_br_account.l10n_br_cnae_2009", "l10n_br_fiscal.cnae_7732201"),
    ("l10n_br_account.l10n_br_cnae_2010", "l10n_br_fiscal.cnae_7732202"),
    ("l10n_br_account.l10n_br_cnae_2011", "l10n_br_fiscal.cnae_77331"),
    ("l10n_br_account.l10n_br_cnae_2012", "l10n_br_fiscal.cnae_7733100"),
    ("l10n_br_account.l10n_br_cnae_2013", "l10n_br_fiscal.cnae_77390"),
    ("l10n_br_account.l10n_br_cnae_2014", "l10n_br_fiscal.cnae_7739001"),
    ("l10n_br_account.l10n_br_cnae_2015", "l10n_br_fiscal.cnae_7739002"),
    ("l10n_br_account.l10n_br_cnae_2016", "l10n_br_fiscal.cnae_7739003"),
    ("l10n_br_account.l10n_br_cnae_2017", "l10n_br_fiscal.cnae_7739099"),
    ("l10n_br_account.l10n_br_cnae_2018", "l10n_br_fiscal.cnae_774"),
    ("l10n_br_account.l10n_br_cnae_2019", "l10n_br_fiscal.cnae_77403"),
    ("l10n_br_account.l10n_br_cnae_2020", "l10n_br_fiscal.cnae_7740300"),
    ("l10n_br_account.l10n_br_cnae_2021", "l10n_br_fiscal.cnae_78"),
    ("l10n_br_account.l10n_br_cnae_2022", "l10n_br_fiscal.cnae_781"),
    ("l10n_br_account.l10n_br_cnae_2023", "l10n_br_fiscal.cnae_78108"),
    ("l10n_br_account.l10n_br_cnae_2024", "l10n_br_fiscal.cnae_7810800"),
    ("l10n_br_account.l10n_br_cnae_2025", "l10n_br_fiscal.cnae_782"),
    ("l10n_br_account.l10n_br_cnae_2026", "l10n_br_fiscal.cnae_78205"),
    ("l10n_br_account.l10n_br_cnae_2027", "l10n_br_fiscal.cnae_7820500"),
    ("l10n_br_account.l10n_br_cnae_2028", "l10n_br_fiscal.cnae_783"),
    ("l10n_br_account.l10n_br_cnae_2029", "l10n_br_fiscal.cnae_78302"),
    ("l10n_br_account.l10n_br_cnae_2030", "l10n_br_fiscal.cnae_7830200"),
    ("l10n_br_account.l10n_br_cnae_2031", "l10n_br_fiscal.cnae_79"),
    ("l10n_br_account.l10n_br_cnae_2032", "l10n_br_fiscal.cnae_791"),
    ("l10n_br_account.l10n_br_cnae_2033", "l10n_br_fiscal.cnae_79112"),
    ("l10n_br_account.l10n_br_cnae_2034", "l10n_br_fiscal.cnae_7911200"),
    ("l10n_br_account.l10n_br_cnae_2035", "l10n_br_fiscal.cnae_79121"),
    ("l10n_br_account.l10n_br_cnae_2036", "l10n_br_fiscal.cnae_7912100"),
    ("l10n_br_account.l10n_br_cnae_2037", "l10n_br_fiscal.cnae_799"),
    ("l10n_br_account.l10n_br_cnae_2038", "l10n_br_fiscal.cnae_79902"),
    ("l10n_br_account.l10n_br_cnae_2039", "l10n_br_fiscal.cnae_7990200"),
    ("l10n_br_account.l10n_br_cnae_2040", "l10n_br_fiscal.cnae_80"),
    ("l10n_br_account.l10n_br_cnae_2041", "l10n_br_fiscal.cnae_801"),
    ("l10n_br_account.l10n_br_cnae_2042", "l10n_br_fiscal.cnae_80111"),
    ("l10n_br_account.l10n_br_cnae_2043", "l10n_br_fiscal.cnae_8011101"),
    ("l10n_br_account.l10n_br_cnae_2044", "l10n_br_fiscal.cnae_8011102"),
    ("l10n_br_account.l10n_br_cnae_2045", "l10n_br_fiscal.cnae_80129"),
    ("l10n_br_account.l10n_br_cnae_2046", "l10n_br_fiscal.cnae_8012900"),
    ("l10n_br_account.l10n_br_cnae_2047", "l10n_br_fiscal.cnae_802"),
    ("l10n_br_account.l10n_br_cnae_2048", "l10n_br_fiscal.cnae_80200"),
    ("l10n_br_account.l10n_br_cnae_2049", "l10n_br_fiscal.cnae_8020000"),
    ("l10n_br_account.l10n_br_cnae_2050", "l10n_br_fiscal.cnae_803"),
    ("l10n_br_account.l10n_br_cnae_2051", "l10n_br_fiscal.cnae_80307"),
    ("l10n_br_account.l10n_br_cnae_2052", "l10n_br_fiscal.cnae_8030700"),
    ("l10n_br_account.l10n_br_cnae_2053", "l10n_br_fiscal.cnae_81"),
    ("l10n_br_account.l10n_br_cnae_2054", "l10n_br_fiscal.cnae_811"),
    ("l10n_br_account.l10n_br_cnae_2055", "l10n_br_fiscal.cnae_81117"),
    ("l10n_br_account.l10n_br_cnae_2056", "l10n_br_fiscal.cnae_8111700"),
    ("l10n_br_account.l10n_br_cnae_2057", "l10n_br_fiscal.cnae_81125"),
    ("l10n_br_account.l10n_br_cnae_2058", "l10n_br_fiscal.cnae_8112500"),
    ("l10n_br_account.l10n_br_cnae_2059", "l10n_br_fiscal.cnae_812"),
    ("l10n_br_account.l10n_br_cnae_2060", "l10n_br_fiscal.cnae_81214"),
    ("l10n_br_account.l10n_br_cnae_2061", "l10n_br_fiscal.cnae_8121400"),
    ("l10n_br_account.l10n_br_cnae_2062", "l10n_br_fiscal.cnae_81222"),
    ("l10n_br_account.l10n_br_cnae_2063", "l10n_br_fiscal.cnae_8122200"),
    ("l10n_br_account.l10n_br_cnae_2064", "l10n_br_fiscal.cnae_81290"),
    ("l10n_br_account.l10n_br_cnae_2065", "l10n_br_fiscal.cnae_8129000"),
    ("l10n_br_account.l10n_br_cnae_2066", "l10n_br_fiscal.cnae_813"),
    ("l10n_br_account.l10n_br_cnae_2067", "l10n_br_fiscal.cnae_81303"),
    ("l10n_br_account.l10n_br_cnae_2068", "l10n_br_fiscal.cnae_8130300"),
    ("l10n_br_account.l10n_br_cnae_2069", "l10n_br_fiscal.cnae_82"),
    ("l10n_br_account.l10n_br_cnae_2070", "l10n_br_fiscal.cnae_821"),
    ("l10n_br_account.l10n_br_cnae_2071", "l10n_br_fiscal.cnae_82113"),
    ("l10n_br_account.l10n_br_cnae_2072", "l10n_br_fiscal.cnae_8211300"),
    ("l10n_br_account.l10n_br_cnae_2073", "l10n_br_fiscal.cnae_82199"),
    ("l10n_br_account.l10n_br_cnae_2074", "l10n_br_fiscal.cnae_8219901"),
    ("l10n_br_account.l10n_br_cnae_2075", "l10n_br_fiscal.cnae_8219999"),
    ("l10n_br_account.l10n_br_cnae_2076", "l10n_br_fiscal.cnae_822"),
    ("l10n_br_account.l10n_br_cnae_2077", "l10n_br_fiscal.cnae_82202"),
    ("l10n_br_account.l10n_br_cnae_2078", "l10n_br_fiscal.cnae_8220200"),
    ("l10n_br_account.l10n_br_cnae_2079", "l10n_br_fiscal.cnae_823"),
    ("l10n_br_account.l10n_br_cnae_2080", "l10n_br_fiscal.cnae_82300"),
    ("l10n_br_account.l10n_br_cnae_2081", "l10n_br_fiscal.cnae_8230001"),
    ("l10n_br_account.l10n_br_cnae_2082", "l10n_br_fiscal.cnae_8230002"),
    ("l10n_br_account.l10n_br_cnae_2083", "l10n_br_fiscal.cnae_829"),
    ("l10n_br_account.l10n_br_cnae_2084", "l10n_br_fiscal.cnae_82911"),
    ("l10n_br_account.l10n_br_cnae_2085", "l10n_br_fiscal.cnae_8291100"),
    ("l10n_br_account.l10n_br_cnae_2086", "l10n_br_fiscal.cnae_82920"),
    ("l10n_br_account.l10n_br_cnae_2087", "l10n_br_fiscal.cnae_8292000"),
    ("l10n_br_account.l10n_br_cnae_2088", "l10n_br_fiscal.cnae_82997"),
    ("l10n_br_account.l10n_br_cnae_2089", "l10n_br_fiscal.cnae_8299701"),
    ("l10n_br_account.l10n_br_cnae_2090", "l10n_br_fiscal.cnae_8299702"),
    ("l10n_br_account.l10n_br_cnae_2091", "l10n_br_fiscal.cnae_8299703"),
    ("l10n_br_account.l10n_br_cnae_2092", "l10n_br_fiscal.cnae_8299704"),
    ("l10n_br_account.l10n_br_cnae_2093", "l10n_br_fiscal.cnae_8299705"),
    ("l10n_br_account.l10n_br_cnae_2094", "l10n_br_fiscal.cnae_8299706"),
    ("l10n_br_account.l10n_br_cnae_2095", "l10n_br_fiscal.cnae_8299707"),
    ("l10n_br_account.l10n_br_cnae_2096", "l10n_br_fiscal.cnae_8299799"),
    ("l10n_br_account.l10n_br_cnae_2097", "l10n_br_fiscal.cnae_O"),
    ("l10n_br_account.l10n_br_cnae_2098", "l10n_br_fiscal.cnae_84"),
    ("l10n_br_account.l10n_br_cnae_2099", "l10n_br_fiscal.cnae_841"),
    ("l10n_br_account.l10n_br_cnae_2100", "l10n_br_fiscal.cnae_84116"),
    ("l10n_br_account.l10n_br_cnae_2101", "l10n_br_fiscal.cnae_8411600"),
    ("l10n_br_account.l10n_br_cnae_2102", "l10n_br_fiscal.cnae_84124"),
    ("l10n_br_account.l10n_br_cnae_2103", "l10n_br_fiscal.cnae_8412400"),
    ("l10n_br_account.l10n_br_cnae_2104", "l10n_br_fiscal.cnae_84132"),
    ("l10n_br_account.l10n_br_cnae_2105", "l10n_br_fiscal.cnae_8413200"),
    ("l10n_br_account.l10n_br_cnae_2106", "l10n_br_fiscal.cnae_842"),
    ("l10n_br_account.l10n_br_cnae_2107", "l10n_br_fiscal.cnae_84213"),
    ("l10n_br_account.l10n_br_cnae_2108", "l10n_br_fiscal.cnae_8421300"),
    ("l10n_br_account.l10n_br_cnae_2109", "l10n_br_fiscal.cnae_84221"),
    ("l10n_br_account.l10n_br_cnae_2110", "l10n_br_fiscal.cnae_8422100"),
    ("l10n_br_account.l10n_br_cnae_2111", "l10n_br_fiscal.cnae_84230"),
    ("l10n_br_account.l10n_br_cnae_2112", "l10n_br_fiscal.cnae_8423000"),
    ("l10n_br_account.l10n_br_cnae_2113", "l10n_br_fiscal.cnae_84248"),
    ("l10n_br_account.l10n_br_cnae_2114", "l10n_br_fiscal.cnae_8424800"),
    ("l10n_br_account.l10n_br_cnae_2115", "l10n_br_fiscal.cnae_84256"),
    ("l10n_br_account.l10n_br_cnae_2116", "l10n_br_fiscal.cnae_8425600"),
    ("l10n_br_account.l10n_br_cnae_2117", "l10n_br_fiscal.cnae_843"),
    ("l10n_br_account.l10n_br_cnae_2118", "l10n_br_fiscal.cnae_84302"),
    ("l10n_br_account.l10n_br_cnae_2119", "l10n_br_fiscal.cnae_8430200"),
    ("l10n_br_account.l10n_br_cnae_2120", "l10n_br_fiscal.cnae_P"),
    ("l10n_br_account.l10n_br_cnae_2121", "l10n_br_fiscal.cnae_85"),
    ("l10n_br_account.l10n_br_cnae_2122", "l10n_br_fiscal.cnae_851"),
    ("l10n_br_account.l10n_br_cnae_2123", "l10n_br_fiscal.cnae_85112"),
    ("l10n_br_account.l10n_br_cnae_2124", "l10n_br_fiscal.cnae_8511200"),
    ("l10n_br_account.l10n_br_cnae_2125", "l10n_br_fiscal.cnae_85121"),
    ("l10n_br_account.l10n_br_cnae_2126", "l10n_br_fiscal.cnae_8512100"),
    ("l10n_br_account.l10n_br_cnae_2127", "l10n_br_fiscal.cnae_85139"),
    ("l10n_br_account.l10n_br_cnae_2128", "l10n_br_fiscal.cnae_8513900"),
    ("l10n_br_account.l10n_br_cnae_2129", "l10n_br_fiscal.cnae_852"),
    ("l10n_br_account.l10n_br_cnae_2130", "l10n_br_fiscal.cnae_85201"),
    ("l10n_br_account.l10n_br_cnae_2131", "l10n_br_fiscal.cnae_8520100"),
    ("l10n_br_account.l10n_br_cnae_2132", "l10n_br_fiscal.cnae_853"),
    ("l10n_br_account.l10n_br_cnae_2133", "l10n_br_fiscal.cnae_85317"),
    ("l10n_br_account.l10n_br_cnae_2134", "l10n_br_fiscal.cnae_8531700"),
    ("l10n_br_account.l10n_br_cnae_2135", "l10n_br_fiscal.cnae_85325"),
    ("l10n_br_account.l10n_br_cnae_2136", "l10n_br_fiscal.cnae_8532500"),
    ("l10n_br_account.l10n_br_cnae_2137", "l10n_br_fiscal.cnae_85333"),
    ("l10n_br_account.l10n_br_cnae_2138", "l10n_br_fiscal.cnae_8533300"),
    ("l10n_br_account.l10n_br_cnae_2139", "l10n_br_fiscal.cnae_854"),
    ("l10n_br_account.l10n_br_cnae_2140", "l10n_br_fiscal.cnae_85414"),
    ("l10n_br_account.l10n_br_cnae_2141", "l10n_br_fiscal.cnae_8541400"),
    ("l10n_br_account.l10n_br_cnae_2142", "l10n_br_fiscal.cnae_85422"),
    ("l10n_br_account.l10n_br_cnae_2143", "l10n_br_fiscal.cnae_8542200"),
    ("l10n_br_account.l10n_br_cnae_2144", "l10n_br_fiscal.cnae_855"),
    ("l10n_br_account.l10n_br_cnae_2145", "l10n_br_fiscal.cnae_85503"),
    ("l10n_br_account.l10n_br_cnae_2146", "l10n_br_fiscal.cnae_8550301"),
    ("l10n_br_account.l10n_br_cnae_2147", "l10n_br_fiscal.cnae_8550302"),
    ("l10n_br_account.l10n_br_cnae_2148", "l10n_br_fiscal.cnae_859"),
    ("l10n_br_account.l10n_br_cnae_2149", "l10n_br_fiscal.cnae_85911"),
    ("l10n_br_account.l10n_br_cnae_2150", "l10n_br_fiscal.cnae_8591100"),
    ("l10n_br_account.l10n_br_cnae_2151", "l10n_br_fiscal.cnae_85929"),
    ("l10n_br_account.l10n_br_cnae_2152", "l10n_br_fiscal.cnae_8592901"),
    ("l10n_br_account.l10n_br_cnae_2153", "l10n_br_fiscal.cnae_8592902"),
    ("l10n_br_account.l10n_br_cnae_2154", "l10n_br_fiscal.cnae_8592903"),
    ("l10n_br_account.l10n_br_cnae_2155", "l10n_br_fiscal.cnae_8592999"),
    ("l10n_br_account.l10n_br_cnae_2156", "l10n_br_fiscal.cnae_85937"),
    ("l10n_br_account.l10n_br_cnae_2157", "l10n_br_fiscal.cnae_8593700"),
    ("l10n_br_account.l10n_br_cnae_2158", "l10n_br_fiscal.cnae_85996"),
    ("l10n_br_account.l10n_br_cnae_2159", "l10n_br_fiscal.cnae_8599601"),
    ("l10n_br_account.l10n_br_cnae_2160", "l10n_br_fiscal.cnae_8599602"),
    ("l10n_br_account.l10n_br_cnae_2161", "l10n_br_fiscal.cnae_8599603"),
    ("l10n_br_account.l10n_br_cnae_2162", "l10n_br_fiscal.cnae_8599604"),
    ("l10n_br_account.l10n_br_cnae_2163", "l10n_br_fiscal.cnae_8599605"),
    ("l10n_br_account.l10n_br_cnae_2164", "l10n_br_fiscal.cnae_8599699"),
    ("l10n_br_account.l10n_br_cnae_2165", "l10n_br_fiscal.cnae_Q"),
    ("l10n_br_account.l10n_br_cnae_2166", "l10n_br_fiscal.cnae_86"),
    ("l10n_br_account.l10n_br_cnae_2167", "l10n_br_fiscal.cnae_861"),
    ("l10n_br_account.l10n_br_cnae_2168", "l10n_br_fiscal.cnae_86101"),
    ("l10n_br_account.l10n_br_cnae_2169", "l10n_br_fiscal.cnae_8610101"),
    ("l10n_br_account.l10n_br_cnae_2170", "l10n_br_fiscal.cnae_8610102"),
    ("l10n_br_account.l10n_br_cnae_2171", "l10n_br_fiscal.cnae_862"),
    ("l10n_br_account.l10n_br_cnae_2172", "l10n_br_fiscal.cnae_86216"),
    ("l10n_br_account.l10n_br_cnae_2173", "l10n_br_fiscal.cnae_8621601"),
    ("l10n_br_account.l10n_br_cnae_2174", "l10n_br_fiscal.cnae_8621602"),
    ("l10n_br_account.l10n_br_cnae_2175", "l10n_br_fiscal.cnae_86224"),
    ("l10n_br_account.l10n_br_cnae_2176", "l10n_br_fiscal.cnae_8622400"),
    ("l10n_br_account.l10n_br_cnae_2177", "l10n_br_fiscal.cnae_863"),
    ("l10n_br_account.l10n_br_cnae_2178", "l10n_br_fiscal.cnae_86305"),
    ("l10n_br_account.l10n_br_cnae_2179", "l10n_br_fiscal.cnae_8630501"),
    ("l10n_br_account.l10n_br_cnae_2180", "l10n_br_fiscal.cnae_8630502"),
    ("l10n_br_account.l10n_br_cnae_2181", "l10n_br_fiscal.cnae_8630503"),
    ("l10n_br_account.l10n_br_cnae_2182", "l10n_br_fiscal.cnae_8630504"),
    ("l10n_br_account.l10n_br_cnae_2183", "l10n_br_fiscal.cnae_8630505"),
    ("l10n_br_account.l10n_br_cnae_2184", "l10n_br_fiscal.cnae_8630506"),
    ("l10n_br_account.l10n_br_cnae_2185", "l10n_br_fiscal.cnae_8630507"),
    ("l10n_br_account.l10n_br_cnae_2186", "l10n_br_fiscal.cnae_8630599"),
    ("l10n_br_account.l10n_br_cnae_2187", "l10n_br_fiscal.cnae_864"),
    ("l10n_br_account.l10n_br_cnae_2188", "l10n_br_fiscal.cnae_86402"),
    ("l10n_br_account.l10n_br_cnae_2189", "l10n_br_fiscal.cnae_8640201"),
    ("l10n_br_account.l10n_br_cnae_2190", "l10n_br_fiscal.cnae_8640202"),
    ("l10n_br_account.l10n_br_cnae_2191", "l10n_br_fiscal.cnae_8640203"),
    ("l10n_br_account.l10n_br_cnae_2192", "l10n_br_fiscal.cnae_8640204"),
    ("l10n_br_account.l10n_br_cnae_2193", "l10n_br_fiscal.cnae_8640205"),
    ("l10n_br_account.l10n_br_cnae_2194", "l10n_br_fiscal.cnae_8640206"),
    ("l10n_br_account.l10n_br_cnae_2195", "l10n_br_fiscal.cnae_8640207"),
    ("l10n_br_account.l10n_br_cnae_2196", "l10n_br_fiscal.cnae_8640208"),
    ("l10n_br_account.l10n_br_cnae_2197", "l10n_br_fiscal.cnae_8640209"),
    ("l10n_br_account.l10n_br_cnae_2198", "l10n_br_fiscal.cnae_8640210"),
    ("l10n_br_account.l10n_br_cnae_2199", "l10n_br_fiscal.cnae_8640211"),
    ("l10n_br_account.l10n_br_cnae_2200", "l10n_br_fiscal.cnae_8640212"),
    ("l10n_br_account.l10n_br_cnae_2201", "l10n_br_fiscal.cnae_8640213"),
    ("l10n_br_account.l10n_br_cnae_2202", "l10n_br_fiscal.cnae_8640214"),
    ("l10n_br_account.l10n_br_cnae_2203", "l10n_br_fiscal.cnae_8640299"),
    ("l10n_br_account.l10n_br_cnae_2204", "l10n_br_fiscal.cnae_865"),
    ("l10n_br_account.l10n_br_cnae_2205", "l10n_br_fiscal.cnae_86500"),
    ("l10n_br_account.l10n_br_cnae_2206", "l10n_br_fiscal.cnae_8650001"),
    ("l10n_br_account.l10n_br_cnae_2207", "l10n_br_fiscal.cnae_8650002"),
    ("l10n_br_account.l10n_br_cnae_2208", "l10n_br_fiscal.cnae_8650003"),
    ("l10n_br_account.l10n_br_cnae_2209", "l10n_br_fiscal.cnae_8650004"),
    ("l10n_br_account.l10n_br_cnae_2210", "l10n_br_fiscal.cnae_8650005"),
    ("l10n_br_account.l10n_br_cnae_2211", "l10n_br_fiscal.cnae_8650006"),
    ("l10n_br_account.l10n_br_cnae_2212", "l10n_br_fiscal.cnae_8650007"),
    ("l10n_br_account.l10n_br_cnae_2213", "l10n_br_fiscal.cnae_8650099"),
    ("l10n_br_account.l10n_br_cnae_2214", "l10n_br_fiscal.cnae_866"),
    ("l10n_br_account.l10n_br_cnae_2215", "l10n_br_fiscal.cnae_86607"),
    ("l10n_br_account.l10n_br_cnae_2216", "l10n_br_fiscal.cnae_8660700"),
    ("l10n_br_account.l10n_br_cnae_2217", "l10n_br_fiscal.cnae_869"),
    ("l10n_br_account.l10n_br_cnae_2218", "l10n_br_fiscal.cnae_86909"),
    ("l10n_br_account.l10n_br_cnae_2219", "l10n_br_fiscal.cnae_8690901"),
    ("l10n_br_account.l10n_br_cnae_2220", "l10n_br_fiscal.cnae_8690902"),
    ("l10n_br_account.l10n_br_cnae_2221", "l10n_br_fiscal.cnae_8690999"),
    ("l10n_br_account.l10n_br_cnae_2222", "l10n_br_fiscal.cnae_87"),
    ("l10n_br_account.l10n_br_cnae_2223", "l10n_br_fiscal.cnae_871"),
    ("l10n_br_account.l10n_br_cnae_2224", "l10n_br_fiscal.cnae_87115"),
    ("l10n_br_account.l10n_br_cnae_2225", "l10n_br_fiscal.cnae_8711501"),
    ("l10n_br_account.l10n_br_cnae_2226", "l10n_br_fiscal.cnae_8711502"),
    ("l10n_br_account.l10n_br_cnae_2227", "l10n_br_fiscal.cnae_8711503"),
    ("l10n_br_account.l10n_br_cnae_2228", "l10n_br_fiscal.cnae_8711504"),
    ("l10n_br_account.l10n_br_cnae_2229", "l10n_br_fiscal.cnae_8711505"),
    ("l10n_br_account.l10n_br_cnae_2230", "l10n_br_fiscal.cnae_87123"),
    ("l10n_br_account.l10n_br_cnae_2231", "l10n_br_fiscal.cnae_8712300"),
    ("l10n_br_account.l10n_br_cnae_2232", "l10n_br_fiscal.cnae_872"),
    ("l10n_br_account.l10n_br_cnae_2233", "l10n_br_fiscal.cnae_87204"),
    ("l10n_br_account.l10n_br_cnae_2234", "l10n_br_fiscal.cnae_8720401"),
    ("l10n_br_account.l10n_br_cnae_2235", "l10n_br_fiscal.cnae_8720499"),
    ("l10n_br_account.l10n_br_cnae_2236", "l10n_br_fiscal.cnae_873"),
    ("l10n_br_account.l10n_br_cnae_2237", "l10n_br_fiscal.cnae_87301"),
    ("l10n_br_account.l10n_br_cnae_2238", "l10n_br_fiscal.cnae_8730101"),
    ("l10n_br_account.l10n_br_cnae_2239", "l10n_br_fiscal.cnae_8730102"),
    ("l10n_br_account.l10n_br_cnae_2240", "l10n_br_fiscal.cnae_8730199"),
    ("l10n_br_account.l10n_br_cnae_2241", "l10n_br_fiscal.cnae_88"),
    ("l10n_br_account.l10n_br_cnae_2242", "l10n_br_fiscal.cnae_880"),
    ("l10n_br_account.l10n_br_cnae_2243", "l10n_br_fiscal.cnae_88006"),
    ("l10n_br_account.l10n_br_cnae_2244", "l10n_br_fiscal.cnae_8800600"),
    ("l10n_br_account.l10n_br_cnae_2245", "l10n_br_fiscal.cnae_R"),
    ("l10n_br_account.l10n_br_cnae_2246", "l10n_br_fiscal.cnae_90"),
    ("l10n_br_account.l10n_br_cnae_2247", "l10n_br_fiscal.cnae_900"),
    ("l10n_br_account.l10n_br_cnae_2248", "l10n_br_fiscal.cnae_90019"),
    ("l10n_br_account.l10n_br_cnae_2249", "l10n_br_fiscal.cnae_9001901"),
    ("l10n_br_account.l10n_br_cnae_2250", "l10n_br_fiscal.cnae_9001902"),
    ("l10n_br_account.l10n_br_cnae_2251", "l10n_br_fiscal.cnae_9001903"),
    ("l10n_br_account.l10n_br_cnae_2252", "l10n_br_fiscal.cnae_9001904"),
    ("l10n_br_account.l10n_br_cnae_2253", "l10n_br_fiscal.cnae_9001905"),
    ("l10n_br_account.l10n_br_cnae_2254", "l10n_br_fiscal.cnae_9001906"),
    ("l10n_br_account.l10n_br_cnae_2255", "l10n_br_fiscal.cnae_9001999"),
    ("l10n_br_account.l10n_br_cnae_2256", "l10n_br_fiscal.cnae_90027"),
    ("l10n_br_account.l10n_br_cnae_2257", "l10n_br_fiscal.cnae_9002701"),
    ("l10n_br_account.l10n_br_cnae_2258", "l10n_br_fiscal.cnae_9002702"),
    ("l10n_br_account.l10n_br_cnae_2259", "l10n_br_fiscal.cnae_90035"),
    ("l10n_br_account.l10n_br_cnae_2260", "l10n_br_fiscal.cnae_9003500"),
    ("l10n_br_account.l10n_br_cnae_2261", "l10n_br_fiscal.cnae_91"),
    ("l10n_br_account.l10n_br_cnae_2262", "l10n_br_fiscal.cnae_910"),
    ("l10n_br_account.l10n_br_cnae_2263", "l10n_br_fiscal.cnae_91015"),
    ("l10n_br_account.l10n_br_cnae_2264", "l10n_br_fiscal.cnae_9101500"),
    ("l10n_br_account.l10n_br_cnae_2265", "l10n_br_fiscal.cnae_91023"),
    ("l10n_br_account.l10n_br_cnae_2266", "l10n_br_fiscal.cnae_9102301"),
    ("l10n_br_account.l10n_br_cnae_2267", "l10n_br_fiscal.cnae_9102302"),
    ("l10n_br_account.l10n_br_cnae_2268", "l10n_br_fiscal.cnae_91031"),
    ("l10n_br_account.l10n_br_cnae_2269", "l10n_br_fiscal.cnae_9103100"),
    ("l10n_br_account.l10n_br_cnae_2270", "l10n_br_fiscal.cnae_92"),
    ("l10n_br_account.l10n_br_cnae_2271", "l10n_br_fiscal.cnae_920"),
    ("l10n_br_account.l10n_br_cnae_2272", "l10n_br_fiscal.cnae_92003"),
    ("l10n_br_account.l10n_br_cnae_2273", "l10n_br_fiscal.cnae_9200301"),
    ("l10n_br_account.l10n_br_cnae_2274", "l10n_br_fiscal.cnae_9200302"),
    ("l10n_br_account.l10n_br_cnae_2275", "l10n_br_fiscal.cnae_9200399"),
    ("l10n_br_account.l10n_br_cnae_2276", "l10n_br_fiscal.cnae_93"),
    ("l10n_br_account.l10n_br_cnae_2277", "l10n_br_fiscal.cnae_931"),
    ("l10n_br_account.l10n_br_cnae_2278", "l10n_br_fiscal.cnae_93115"),
    ("l10n_br_account.l10n_br_cnae_2279", "l10n_br_fiscal.cnae_9311500"),
    ("l10n_br_account.l10n_br_cnae_2280", "l10n_br_fiscal.cnae_93123"),
    ("l10n_br_account.l10n_br_cnae_2281", "l10n_br_fiscal.cnae_9312300"),
    ("l10n_br_account.l10n_br_cnae_2282", "l10n_br_fiscal.cnae_93131"),
    ("l10n_br_account.l10n_br_cnae_2283", "l10n_br_fiscal.cnae_9313100"),
    ("l10n_br_account.l10n_br_cnae_2284", "l10n_br_fiscal.cnae_93191"),
    ("l10n_br_account.l10n_br_cnae_2285", "l10n_br_fiscal.cnae_9319101"),
    ("l10n_br_account.l10n_br_cnae_2286", "l10n_br_fiscal.cnae_9319199"),
    ("l10n_br_account.l10n_br_cnae_2287", "l10n_br_fiscal.cnae_932"),
    ("l10n_br_account.l10n_br_cnae_2288", "l10n_br_fiscal.cnae_93212"),
    ("l10n_br_account.l10n_br_cnae_2289", "l10n_br_fiscal.cnae_9321200"),
    ("l10n_br_account.l10n_br_cnae_2290", "l10n_br_fiscal.cnae_93298"),
    ("l10n_br_account.l10n_br_cnae_2291", "l10n_br_fiscal.cnae_9329801"),
    ("l10n_br_account.l10n_br_cnae_2292", "l10n_br_fiscal.cnae_9329802"),
    ("l10n_br_account.l10n_br_cnae_2293", "l10n_br_fiscal.cnae_9329803"),
    ("l10n_br_account.l10n_br_cnae_2294", "l10n_br_fiscal.cnae_9329804"),
    ("l10n_br_account.l10n_br_cnae_2295", "l10n_br_fiscal.cnae_9329899"),
    ("l10n_br_account.l10n_br_cnae_2296", "l10n_br_fiscal.cnae_S"),
    ("l10n_br_account.l10n_br_cnae_2297", "l10n_br_fiscal.cnae_94"),
    ("l10n_br_account.l10n_br_cnae_2298", "l10n_br_fiscal.cnae_941"),
    ("l10n_br_account.l10n_br_cnae_2299", "l10n_br_fiscal.cnae_94111"),
    ("l10n_br_account.l10n_br_cnae_2300", "l10n_br_fiscal.cnae_9411100"),
    ("l10n_br_account.l10n_br_cnae_2301", "l10n_br_fiscal.cnae_94120"),
    ("l10n_br_account.l10n_br_cnae_2302", "l10n_br_fiscal.cnae_9412000"),
    ("l10n_br_account.l10n_br_cnae_2303", "l10n_br_fiscal.cnae_942"),
    ("l10n_br_account.l10n_br_cnae_2304", "l10n_br_fiscal.cnae_94201"),
    ("l10n_br_account.l10n_br_cnae_2305", "l10n_br_fiscal.cnae_9420100"),
    ("l10n_br_account.l10n_br_cnae_2306", "l10n_br_fiscal.cnae_943"),
    ("l10n_br_account.l10n_br_cnae_2307", "l10n_br_fiscal.cnae_94308"),
    ("l10n_br_account.l10n_br_cnae_2308", "l10n_br_fiscal.cnae_9430800"),
    ("l10n_br_account.l10n_br_cnae_2309", "l10n_br_fiscal.cnae_949"),
    ("l10n_br_account.l10n_br_cnae_2310", "l10n_br_fiscal.cnae_94910"),
    ("l10n_br_account.l10n_br_cnae_2311", "l10n_br_fiscal.cnae_9491000"),
    ("l10n_br_account.l10n_br_cnae_2312", "l10n_br_fiscal.cnae_94928"),
    ("l10n_br_account.l10n_br_cnae_2313", "l10n_br_fiscal.cnae_9492800"),
    ("l10n_br_account.l10n_br_cnae_2314", "l10n_br_fiscal.cnae_94936"),
    ("l10n_br_account.l10n_br_cnae_2315", "l10n_br_fiscal.cnae_9493600"),
    ("l10n_br_account.l10n_br_cnae_2316", "l10n_br_fiscal.cnae_94995"),
    ("l10n_br_account.l10n_br_cnae_2317", "l10n_br_fiscal.cnae_9499500"),
    ("l10n_br_account.l10n_br_cnae_2318", "l10n_br_fiscal.cnae_95"),
    ("l10n_br_account.l10n_br_cnae_2319", "l10n_br_fiscal.cnae_951"),
    ("l10n_br_account.l10n_br_cnae_2320", "l10n_br_fiscal.cnae_95118"),
    ("l10n_br_account.l10n_br_cnae_2321", "l10n_br_fiscal.cnae_9511800"),
    ("l10n_br_account.l10n_br_cnae_2322", "l10n_br_fiscal.cnae_95126"),
    ("l10n_br_account.l10n_br_cnae_2323", "l10n_br_fiscal.cnae_9512600"),
    ("l10n_br_account.l10n_br_cnae_2324", "l10n_br_fiscal.cnae_952"),
    ("l10n_br_account.l10n_br_cnae_2325", "l10n_br_fiscal.cnae_95215"),
    ("l10n_br_account.l10n_br_cnae_2326", "l10n_br_fiscal.cnae_9521500"),
    ("l10n_br_account.l10n_br_cnae_2327", "l10n_br_fiscal.cnae_95291"),
    ("l10n_br_account.l10n_br_cnae_2328", "l10n_br_fiscal.cnae_9529101"),
    ("l10n_br_account.l10n_br_cnae_2329", "l10n_br_fiscal.cnae_9529102"),
    ("l10n_br_account.l10n_br_cnae_2330", "l10n_br_fiscal.cnae_9529103"),
    ("l10n_br_account.l10n_br_cnae_2331", "l10n_br_fiscal.cnae_9529104"),
    ("l10n_br_account.l10n_br_cnae_2332", "l10n_br_fiscal.cnae_9529105"),
    ("l10n_br_account.l10n_br_cnae_2333", "l10n_br_fiscal.cnae_9529106"),
    ("l10n_br_account.l10n_br_cnae_2334", "l10n_br_fiscal.cnae_9529199"),
    ("l10n_br_account.l10n_br_cnae_2335", "l10n_br_fiscal.cnae_96"),
    ("l10n_br_account.l10n_br_cnae_2336", "l10n_br_fiscal.cnae_960"),
    ("l10n_br_account.l10n_br_cnae_2337", "l10n_br_fiscal.cnae_96017"),
    ("l10n_br_account.l10n_br_cnae_2338", "l10n_br_fiscal.cnae_9601701"),
    ("l10n_br_account.l10n_br_cnae_2339", "l10n_br_fiscal.cnae_9601702"),
    ("l10n_br_account.l10n_br_cnae_2340", "l10n_br_fiscal.cnae_9601703"),
    ("l10n_br_account.l10n_br_cnae_2341", "l10n_br_fiscal.cnae_96025"),
    ("l10n_br_account.l10n_br_cnae_2342", "l10n_br_fiscal.cnae_9602501"),
    ("l10n_br_account.l10n_br_cnae_2343", "l10n_br_fiscal.cnae_9602502"),
    ("l10n_br_account.l10n_br_cnae_2344", "l10n_br_fiscal.cnae_96033"),
    ("l10n_br_account.l10n_br_cnae_2345", "l10n_br_fiscal.cnae_9603301"),
    ("l10n_br_account.l10n_br_cnae_2346", "l10n_br_fiscal.cnae_9603302"),
    ("l10n_br_account.l10n_br_cnae_2347", "l10n_br_fiscal.cnae_9603303"),
    ("l10n_br_account.l10n_br_cnae_2348", "l10n_br_fiscal.cnae_9603304"),
    ("l10n_br_account.l10n_br_cnae_2349", "l10n_br_fiscal.cnae_9603305"),
    ("l10n_br_account.l10n_br_cnae_2350", "l10n_br_fiscal.cnae_9603399"),
    ("l10n_br_account.l10n_br_cnae_2351", "l10n_br_fiscal.cnae_96092"),
    ("l10n_br_account.l10n_br_cnae_2352", "l10n_br_fiscal.cnae_9609201"),
    ("l10n_br_account.l10n_br_cnae_2353", "l10n_br_fiscal.cnae_9609202"),
    ("l10n_br_account.l10n_br_cnae_2354", "l10n_br_fiscal.cnae_9609203"),
    ("l10n_br_account.l10n_br_cnae_2355", "l10n_br_fiscal.cnae_9609204"),
    ("l10n_br_account.l10n_br_cnae_2356", "l10n_br_fiscal.cnae_9609299"),
    ("l10n_br_account.l10n_br_cnae_2357", "l10n_br_fiscal.cnae_T"),
    ("l10n_br_account.l10n_br_cnae_2358", "l10n_br_fiscal.cnae_97"),
    ("l10n_br_account.l10n_br_cnae_2359", "l10n_br_fiscal.cnae_970"),
    ("l10n_br_account.l10n_br_cnae_2360", "l10n_br_fiscal.cnae_97005"),
    ("l10n_br_account.l10n_br_cnae_2361", "l10n_br_fiscal.cnae_9700500"),
    ("l10n_br_account.l10n_br_cnae_2362", "l10n_br_fiscal.cnae_U"),
    ("l10n_br_account.l10n_br_cnae_2363", "l10n_br_fiscal.cnae_99"),
    ("l10n_br_account.l10n_br_cnae_2364", "l10n_br_fiscal.cnae_990"),
    ("l10n_br_account.l10n_br_cnae_2365", "l10n_br_fiscal.cnae_99008"),
    ("l10n_br_account.l10n_br_cnae_2366", "l10n_br_fiscal.cnae_9900800"),
]


_xml_ids_document_renames = [
    ("l10n_br_account.fiscal_document_service", "l10n_br_fiscal.document_SE"),
    ("l10n_br_account_product.fiscal_document_01", "l10n_br_fiscal.document_01"),
    ("l10n_br_account_product.fiscal_document_1B", "l10n_br_fiscal.document_1B"),
    ("l10n_br_account_product.fiscal_document_02", "l10n_br_fiscal.document_02"),
    ("l10n_br_account_product.fiscal_document_2D", "l10n_br_fiscal.document_2D"),
    ("l10n_br_account_product.fiscal_document_2E", "l10n_br_fiscal.document_2E"),
    ("l10n_br_account_product.fiscal_document_04", "l10n_br_fiscal.document_04"),
    ("l10n_br_account_product.fiscal_document_06", "l10n_br_fiscal.document_06"),
    ("l10n_br_account_product.fiscal_document_07", "l10n_br_fiscal.document_07"),
    ("l10n_br_account_product.fiscal_document_08", "l10n_br_fiscal.document_08"),
    ("l10n_br_account_product.fiscal_document_8B", "l10n_br_fiscal.document_8B"),
    ("l10n_br_account_product.fiscal_document_09", "l10n_br_fiscal.document_09"),
    ("l10n_br_account_product.fiscal_document_10", "l10n_br_fiscal.document_10"),
    ("l10n_br_account_product.fiscal_document_11", "l10n_br_fiscal.document_11"),
    ("l10n_br_account_product.fiscal_document_13", "l10n_br_fiscal.document_13"),
    ("l10n_br_account_product.fiscal_document_14", "l10n_br_fiscal.document_14"),
    ("l10n_br_account_product.fiscal_document_15", "l10n_br_fiscal.document_15"),
    ("l10n_br_account_product.fiscal_document_17", "l10n_br_fiscal.document_17"),
    ("l10n_br_account_product.fiscal_document_16", "l10n_br_fiscal.document_16"),
    ("l10n_br_account_product.fiscal_document_18", "l10n_br_fiscal.document_18"),
    ("l10n_br_account_product.fiscal_document_20", "l10n_br_fiscal.document_20"),
    ("l10n_br_account_product.fiscal_document_21", "l10n_br_fiscal.document_21"),
    ("l10n_br_account_product.fiscal_document_22", "l10n_br_fiscal.document_22"),
    ("l10n_br_account_product.fiscal_document_23", "l10n_br_fiscal.document_23"),
    ("l10n_br_account_product.fiscal_document_24", "l10n_br_fiscal.document_24"),
    ("l10n_br_account_product.fiscal_document_25", "l10n_br_fiscal.document_25"),
    ("l10n_br_account_product.fiscal_document_26", "l10n_br_fiscal.document_26"),
    ("l10n_br_account_product.fiscal_document_27", "l10n_br_fiscal.document_27"),
    ("l10n_br_account_product.fiscal_document_28", "l10n_br_fiscal.document_28"),
    ("l10n_br_account_product.fiscal_document_29", "l10n_br_fiscal.document_29"),
    ("l10n_br_account_product.fiscal_document_30", "l10n_br_fiscal.document_30"),
    ("l10n_br_account_product.fiscal_document_55", "l10n_br_fiscal.document_55"),
    ("l10n_br_account_product.fiscal_document_57", "l10n_br_fiscal.document_57"),
    ("l10n_br_account_product.fiscal_document_59", "l10n_br_fiscal.document_59"),
]


_xml_ids_cfop_renames = [
    ("l10n_br_account_product.cfop_1101", "l10n_br_fiscal.cfop_1101"),
    ("l10n_br_account_product.cfop_1102", "l10n_br_fiscal.cfop_1102"),
    ("l10n_br_account_product.cfop_1111", "l10n_br_fiscal.cfop_1111"),
    ("l10n_br_account_product.cfop_1113", "l10n_br_fiscal.cfop_1113"),
    ("l10n_br_account_product.cfop_1116", "l10n_br_fiscal.cfop_1116"),
    ("l10n_br_account_product.cfop_1117", "l10n_br_fiscal.cfop_1117"),
    ("l10n_br_account_product.cfop_1118", "l10n_br_fiscal.cfop_1118"),
    ("l10n_br_account_product.cfop_1120", "l10n_br_fiscal.cfop_1120"),
    ("l10n_br_account_product.cfop_1121", "l10n_br_fiscal.cfop_1121"),
    ("l10n_br_account_product.cfop_1122", "l10n_br_fiscal.cfop_1122"),
    ("l10n_br_account_product.cfop_1124", "l10n_br_fiscal.cfop_1124"),
    ("l10n_br_account_product.cfop_1125", "l10n_br_fiscal.cfop_1125"),
    ("l10n_br_account_product.cfop_1126", "l10n_br_fiscal.cfop_1126"),
    ("l10n_br_account_product.cfop_1128", "l10n_br_fiscal.cfop_1128"),
    ("l10n_br_account_product.cfop_1131", "l10n_br_fiscal.cfop_1131"),
    ("l10n_br_account_product.cfop_1132", "l10n_br_fiscal.cfop_1132"),
    ("l10n_br_account_product.cfop_1135", "l10n_br_fiscal.cfop_1135"),
    ("l10n_br_account_product.cfop_1151", "l10n_br_fiscal.cfop_1151"),
    ("l10n_br_account_product.cfop_1152", "l10n_br_fiscal.cfop_1152"),
    ("l10n_br_account_product.cfop_1153", "l10n_br_fiscal.cfop_1153"),
    ("l10n_br_account_product.cfop_1154", "l10n_br_fiscal.cfop_1154"),
    ("l10n_br_account_product.cfop_1159", "l10n_br_fiscal.cfop_1159"),
    ("l10n_br_account_product.cfop_1201", "l10n_br_fiscal.cfop_1201"),
    ("l10n_br_account_product.cfop_1202", "l10n_br_fiscal.cfop_1202"),
    ("l10n_br_account_product.cfop_1203", "l10n_br_fiscal.cfop_1203"),
    ("l10n_br_account_product.cfop_1204", "l10n_br_fiscal.cfop_1204"),
    ("l10n_br_account_product.cfop_1205", "l10n_br_fiscal.cfop_1205"),
    ("l10n_br_account_product.cfop_1206", "l10n_br_fiscal.cfop_1206"),
    ("l10n_br_account_product.cfop_1207", "l10n_br_fiscal.cfop_1207"),
    ("l10n_br_account_product.cfop_1208", "l10n_br_fiscal.cfop_1208"),
    ("l10n_br_account_product.cfop_1209", "l10n_br_fiscal.cfop_1209"),
    ("l10n_br_account_product.cfop_1212", "l10n_br_fiscal.cfop_1212"),
    ("l10n_br_account_product.cfop_1213", "l10n_br_fiscal.cfop_1213"),
    ("l10n_br_account_product.cfop_1214", "l10n_br_fiscal.cfop_1214"),
    ("l10n_br_account_product.cfop_1251", "l10n_br_fiscal.cfop_1251"),
    ("l10n_br_account_product.cfop_1252", "l10n_br_fiscal.cfop_1252"),
    ("l10n_br_account_product.cfop_1253", "l10n_br_fiscal.cfop_1253"),
    ("l10n_br_account_product.cfop_1254", "l10n_br_fiscal.cfop_1254"),
    ("l10n_br_account_product.cfop_1255", "l10n_br_fiscal.cfop_1255"),
    ("l10n_br_account_product.cfop_1256", "l10n_br_fiscal.cfop_1256"),
    ("l10n_br_account_product.cfop_1257", "l10n_br_fiscal.cfop_1257"),
    ("l10n_br_account_product.cfop_1301", "l10n_br_fiscal.cfop_1301"),
    ("l10n_br_account_product.cfop_1302", "l10n_br_fiscal.cfop_1302"),
    ("l10n_br_account_product.cfop_1303", "l10n_br_fiscal.cfop_1303"),
    ("l10n_br_account_product.cfop_1304", "l10n_br_fiscal.cfop_1304"),
    ("l10n_br_account_product.cfop_1305", "l10n_br_fiscal.cfop_1305"),
    ("l10n_br_account_product.cfop_1306", "l10n_br_fiscal.cfop_1306"),
    ("l10n_br_account_product.cfop_1351", "l10n_br_fiscal.cfop_1351"),
    ("l10n_br_account_product.cfop_1352", "l10n_br_fiscal.cfop_1352"),
    ("l10n_br_account_product.cfop_1353", "l10n_br_fiscal.cfop_1353"),
    ("l10n_br_account_product.cfop_1354", "l10n_br_fiscal.cfop_1354"),
    ("l10n_br_account_product.cfop_1355", "l10n_br_fiscal.cfop_1355"),
    ("l10n_br_account_product.cfop_1356", "l10n_br_fiscal.cfop_1356"),
    ("l10n_br_account_product.cfop_1360", "l10n_br_fiscal.cfop_1360"),
    ("l10n_br_account_product.cfop_1401", "l10n_br_fiscal.cfop_1401"),
    ("l10n_br_account_product.cfop_1403", "l10n_br_fiscal.cfop_1403"),
    ("l10n_br_account_product.cfop_1406", "l10n_br_fiscal.cfop_1406"),
    ("l10n_br_account_product.cfop_1407", "l10n_br_fiscal.cfop_1407"),
    ("l10n_br_account_product.cfop_1408", "l10n_br_fiscal.cfop_1408"),
    ("l10n_br_account_product.cfop_1409", "l10n_br_fiscal.cfop_1409"),
    ("l10n_br_account_product.cfop_1410", "l10n_br_fiscal.cfop_1410"),
    ("l10n_br_account_product.cfop_1411", "l10n_br_fiscal.cfop_1411"),
    ("l10n_br_account_product.cfop_1414", "l10n_br_fiscal.cfop_1414"),
    ("l10n_br_account_product.cfop_1415", "l10n_br_fiscal.cfop_1415"),
    ("l10n_br_account_product.cfop_1451", "l10n_br_fiscal.cfop_1451"),
    ("l10n_br_account_product.cfop_1452", "l10n_br_fiscal.cfop_1452"),
    ("l10n_br_account_product.cfop_1501", "l10n_br_fiscal.cfop_1501"),
    ("l10n_br_account_product.cfop_1503", "l10n_br_fiscal.cfop_1503"),
    ("l10n_br_account_product.cfop_1504", "l10n_br_fiscal.cfop_1504"),
    ("l10n_br_account_product.cfop_1505", "l10n_br_fiscal.cfop_1505"),
    ("l10n_br_account_product.cfop_1505", "l10n_br_fiscal.cfop_1505"),
    ("l10n_br_account_product.cfop_1506", "l10n_br_fiscal.cfop_1506"),
    ("l10n_br_account_product.cfop_1506", "l10n_br_fiscal.cfop_1506"),
    ("l10n_br_account_product.cfop_1551", "l10n_br_fiscal.cfop_1551"),
    ("l10n_br_account_product.cfop_1552", "l10n_br_fiscal.cfop_1552"),
    ("l10n_br_account_product.cfop_1553", "l10n_br_fiscal.cfop_1553"),
    ("l10n_br_account_product.cfop_1554", "l10n_br_fiscal.cfop_1554"),
    ("l10n_br_account_product.cfop_1555", "l10n_br_fiscal.cfop_1555"),
    ("l10n_br_account_product.cfop_1556", "l10n_br_fiscal.cfop_1556"),
    ("l10n_br_account_product.cfop_1557", "l10n_br_fiscal.cfop_1557"),
    ("l10n_br_account_product.cfop_1601", "l10n_br_fiscal.cfop_1601"),
    ("l10n_br_account_product.cfop_1602", "l10n_br_fiscal.cfop_1602"),
    ("l10n_br_account_product.cfop_1603", "l10n_br_fiscal.cfop_1603"),
    ("l10n_br_account_product.cfop_1604", "l10n_br_fiscal.cfop_1604"),
    ("l10n_br_account_product.cfop_1605", "l10n_br_fiscal.cfop_1605"),
    ("l10n_br_account_product.cfop_1651", "l10n_br_fiscal.cfop_1651"),
    ("l10n_br_account_product.cfop_1652", "l10n_br_fiscal.cfop_1652"),
    ("l10n_br_account_product.cfop_1653", "l10n_br_fiscal.cfop_1653"),
    ("l10n_br_account_product.cfop_1658", "l10n_br_fiscal.cfop_1658"),
    ("l10n_br_account_product.cfop_1659", "l10n_br_fiscal.cfop_1659"),
    ("l10n_br_account_product.cfop_1660", "l10n_br_fiscal.cfop_1660"),
    ("l10n_br_account_product.cfop_1661", "l10n_br_fiscal.cfop_1661"),
    ("l10n_br_account_product.cfop_1662", "l10n_br_fiscal.cfop_1662"),
    ("l10n_br_account_product.cfop_1663", "l10n_br_fiscal.cfop_1663"),
    ("l10n_br_account_product.cfop_1664", "l10n_br_fiscal.cfop_1664"),
    ("l10n_br_account_product.cfop_1901", "l10n_br_fiscal.cfop_1901"),
    ("l10n_br_account_product.cfop_1902", "l10n_br_fiscal.cfop_1902"),
    ("l10n_br_account_product.cfop_1903", "l10n_br_fiscal.cfop_1903"),
    ("l10n_br_account_product.cfop_1904", "l10n_br_fiscal.cfop_1904"),
    ("l10n_br_account_product.cfop_1905", "l10n_br_fiscal.cfop_1905"),
    ("l10n_br_account_product.cfop_1906", "l10n_br_fiscal.cfop_1906"),
    ("l10n_br_account_product.cfop_1907", "l10n_br_fiscal.cfop_1907"),
    ("l10n_br_account_product.cfop_1908", "l10n_br_fiscal.cfop_1908"),
    ("l10n_br_account_product.cfop_1909", "l10n_br_fiscal.cfop_1909"),
    ("l10n_br_account_product.cfop_1910", "l10n_br_fiscal.cfop_1910"),
    ("l10n_br_account_product.cfop_1911", "l10n_br_fiscal.cfop_1911"),
    ("l10n_br_account_product.cfop_1912", "l10n_br_fiscal.cfop_1912"),
    ("l10n_br_account_product.cfop_1913", "l10n_br_fiscal.cfop_1913"),
    ("l10n_br_account_product.cfop_1914", "l10n_br_fiscal.cfop_1914"),
    ("l10n_br_account_product.cfop_1915", "l10n_br_fiscal.cfop_1915"),
    ("l10n_br_account_product.cfop_1916", "l10n_br_fiscal.cfop_1916"),
    ("l10n_br_account_product.cfop_1917", "l10n_br_fiscal.cfop_1917"),
    ("l10n_br_account_product.cfop_1918", "l10n_br_fiscal.cfop_1918"),
    ("l10n_br_account_product.cfop_1919", "l10n_br_fiscal.cfop_1919"),
    ("l10n_br_account_product.cfop_1920", "l10n_br_fiscal.cfop_1920"),
    ("l10n_br_account_product.cfop_1921", "l10n_br_fiscal.cfop_1921"),
    ("l10n_br_account_product.cfop_1922", "l10n_br_fiscal.cfop_1922"),
    ("l10n_br_account_product.cfop_1923", "l10n_br_fiscal.cfop_1923"),
    ("l10n_br_account_product.cfop_1924", "l10n_br_fiscal.cfop_1924"),
    ("l10n_br_account_product.cfop_1925", "l10n_br_fiscal.cfop_1925"),
    ("l10n_br_account_product.cfop_1926", "l10n_br_fiscal.cfop_1926"),
    ("l10n_br_account_product.cfop_1931", "l10n_br_fiscal.cfop_1931"),
    ("l10n_br_account_product.cfop_1932", "l10n_br_fiscal.cfop_1932"),
    ("l10n_br_account_product.cfop_1933", "l10n_br_fiscal.cfop_1933"),
    ("l10n_br_account_product.cfop_1934", "l10n_br_fiscal.cfop_1934"),
    ("l10n_br_account_product.cfop_1949", "l10n_br_fiscal.cfop_1949"),
    ("l10n_br_account_product.cfop_2101", "l10n_br_fiscal.cfop_2101"),
    ("l10n_br_account_product.cfop_2102", "l10n_br_fiscal.cfop_2102"),
    ("l10n_br_account_product.cfop_2111", "l10n_br_fiscal.cfop_2111"),
    ("l10n_br_account_product.cfop_2113", "l10n_br_fiscal.cfop_2113"),
    ("l10n_br_account_product.cfop_2116", "l10n_br_fiscal.cfop_2116"),
    ("l10n_br_account_product.cfop_2117", "l10n_br_fiscal.cfop_2117"),
    ("l10n_br_account_product.cfop_2118", "l10n_br_fiscal.cfop_2118"),
    ("l10n_br_account_product.cfop_2120", "l10n_br_fiscal.cfop_2120"),
    ("l10n_br_account_product.cfop_2121", "l10n_br_fiscal.cfop_2121"),
    ("l10n_br_account_product.cfop_2122", "l10n_br_fiscal.cfop_2122"),
    ("l10n_br_account_product.cfop_2124", "l10n_br_fiscal.cfop_2124"),
    ("l10n_br_account_product.cfop_2125", "l10n_br_fiscal.cfop_2125"),
    ("l10n_br_account_product.cfop_2126", "l10n_br_fiscal.cfop_2126"),
    ("l10n_br_account_product.cfop_2128", "l10n_br_fiscal.cfop_2128"),
    ("l10n_br_account_product.cfop_2131", "l10n_br_fiscal.cfop_2131"),
    ("l10n_br_account_product.cfop_2132", "l10n_br_fiscal.cfop_2132"),
    ("l10n_br_account_product.cfop_2135", "l10n_br_fiscal.cfop_2135"),
    ("l10n_br_account_product.cfop_2151", "l10n_br_fiscal.cfop_2151"),
    ("l10n_br_account_product.cfop_2152", "l10n_br_fiscal.cfop_2152"),
    ("l10n_br_account_product.cfop_2153", "l10n_br_fiscal.cfop_2153"),
    ("l10n_br_account_product.cfop_2154", "l10n_br_fiscal.cfop_2154"),
    ("l10n_br_account_product.cfop_2159", "l10n_br_fiscal.cfop_2159"),
    ("l10n_br_account_product.cfop_2201", "l10n_br_fiscal.cfop_2201"),
    ("l10n_br_account_product.cfop_2202", "l10n_br_fiscal.cfop_2202"),
    ("l10n_br_account_product.cfop_2203", "l10n_br_fiscal.cfop_2203"),
    ("l10n_br_account_product.cfop_2204", "l10n_br_fiscal.cfop_2204"),
    ("l10n_br_account_product.cfop_2205", "l10n_br_fiscal.cfop_2205"),
    ("l10n_br_account_product.cfop_2206", "l10n_br_fiscal.cfop_2206"),
    ("l10n_br_account_product.cfop_2207", "l10n_br_fiscal.cfop_2207"),
    ("l10n_br_account_product.cfop_2208", "l10n_br_fiscal.cfop_2208"),
    ("l10n_br_account_product.cfop_2209", "l10n_br_fiscal.cfop_2209"),
    ("l10n_br_account_product.cfop_2212", "l10n_br_fiscal.cfop_2212"),
    ("l10n_br_account_product.cfop_2213", "l10n_br_fiscal.cfop_2213"),
    ("l10n_br_account_product.cfop_2214", "l10n_br_fiscal.cfop_2214"),
    ("l10n_br_account_product.cfop_2251", "l10n_br_fiscal.cfop_2251"),
    ("l10n_br_account_product.cfop_2252", "l10n_br_fiscal.cfop_2252"),
    ("l10n_br_account_product.cfop_2253", "l10n_br_fiscal.cfop_2253"),
    ("l10n_br_account_product.cfop_2254", "l10n_br_fiscal.cfop_2254"),
    ("l10n_br_account_product.cfop_2255", "l10n_br_fiscal.cfop_2255"),
    ("l10n_br_account_product.cfop_2256", "l10n_br_fiscal.cfop_2256"),
    ("l10n_br_account_product.cfop_2257", "l10n_br_fiscal.cfop_2257"),
    ("l10n_br_account_product.cfop_2301", "l10n_br_fiscal.cfop_2301"),
    ("l10n_br_account_product.cfop_2302", "l10n_br_fiscal.cfop_2302"),
    ("l10n_br_account_product.cfop_2303", "l10n_br_fiscal.cfop_2303"),
    ("l10n_br_account_product.cfop_2304", "l10n_br_fiscal.cfop_2304"),
    ("l10n_br_account_product.cfop_2305", "l10n_br_fiscal.cfop_2305"),
    ("l10n_br_account_product.cfop_2306", "l10n_br_fiscal.cfop_2306"),
    ("l10n_br_account_product.cfop_2351", "l10n_br_fiscal.cfop_2351"),
    ("l10n_br_account_product.cfop_2352", "l10n_br_fiscal.cfop_2352"),
    ("l10n_br_account_product.cfop_2353", "l10n_br_fiscal.cfop_2353"),
    ("l10n_br_account_product.cfop_2354", "l10n_br_fiscal.cfop_2354"),
    ("l10n_br_account_product.cfop_2355", "l10n_br_fiscal.cfop_2355"),
    ("l10n_br_account_product.cfop_2356", "l10n_br_fiscal.cfop_2356"),
    ("l10n_br_account_product.cfop_2401", "l10n_br_fiscal.cfop_2401"),
    ("l10n_br_account_product.cfop_2403", "l10n_br_fiscal.cfop_2403"),
    ("l10n_br_account_product.cfop_2406", "l10n_br_fiscal.cfop_2406"),
    ("l10n_br_account_product.cfop_2407", "l10n_br_fiscal.cfop_2407"),
    ("l10n_br_account_product.cfop_2408", "l10n_br_fiscal.cfop_2408"),
    ("l10n_br_account_product.cfop_2409", "l10n_br_fiscal.cfop_2409"),
    ("l10n_br_account_product.cfop_2410", "l10n_br_fiscal.cfop_2410"),
    ("l10n_br_account_product.cfop_2411", "l10n_br_fiscal.cfop_2411"),
    ("l10n_br_account_product.cfop_2414", "l10n_br_fiscal.cfop_2414"),
    ("l10n_br_account_product.cfop_2415", "l10n_br_fiscal.cfop_2415"),
    ("l10n_br_account_product.cfop_2501", "l10n_br_fiscal.cfop_2501"),
    ("l10n_br_account_product.cfop_2503", "l10n_br_fiscal.cfop_2503"),
    ("l10n_br_account_product.cfop_2504", "l10n_br_fiscal.cfop_2504"),
    ("l10n_br_account_product.cfop_2505", "l10n_br_fiscal.cfop_2505"),
    ("l10n_br_account_product.cfop_2505", "l10n_br_fiscal.cfop_2505"),
    ("l10n_br_account_product.cfop_2506", "l10n_br_fiscal.cfop_2506"),
    ("l10n_br_account_product.cfop_2506", "l10n_br_fiscal.cfop_2506"),
    ("l10n_br_account_product.cfop_2551", "l10n_br_fiscal.cfop_2551"),
    ("l10n_br_account_product.cfop_2552", "l10n_br_fiscal.cfop_2552"),
    ("l10n_br_account_product.cfop_2553", "l10n_br_fiscal.cfop_2553"),
    ("l10n_br_account_product.cfop_2554", "l10n_br_fiscal.cfop_2554"),
    ("l10n_br_account_product.cfop_2555", "l10n_br_fiscal.cfop_2555"),
    ("l10n_br_account_product.cfop_2556", "l10n_br_fiscal.cfop_2556"),
    ("l10n_br_account_product.cfop_2557", "l10n_br_fiscal.cfop_2557"),
    ("l10n_br_account_product.cfop_2603", "l10n_br_fiscal.cfop_2603"),
    ("l10n_br_account_product.cfop_2651", "l10n_br_fiscal.cfop_2651"),
    ("l10n_br_account_product.cfop_2652", "l10n_br_fiscal.cfop_2652"),
    ("l10n_br_account_product.cfop_2653", "l10n_br_fiscal.cfop_2653"),
    ("l10n_br_account_product.cfop_2658", "l10n_br_fiscal.cfop_2658"),
    ("l10n_br_account_product.cfop_2659", "l10n_br_fiscal.cfop_2659"),
    ("l10n_br_account_product.cfop_2660", "l10n_br_fiscal.cfop_2660"),
    ("l10n_br_account_product.cfop_2661", "l10n_br_fiscal.cfop_2661"),
    ("l10n_br_account_product.cfop_2662", "l10n_br_fiscal.cfop_2662"),
    ("l10n_br_account_product.cfop_2663", "l10n_br_fiscal.cfop_2663"),
    ("l10n_br_account_product.cfop_2664", "l10n_br_fiscal.cfop_2664"),
    ("l10n_br_account_product.cfop_2901", "l10n_br_fiscal.cfop_2901"),
    ("l10n_br_account_product.cfop_2902", "l10n_br_fiscal.cfop_2902"),
    ("l10n_br_account_product.cfop_2903", "l10n_br_fiscal.cfop_2903"),
    ("l10n_br_account_product.cfop_2904", "l10n_br_fiscal.cfop_2904"),
    ("l10n_br_account_product.cfop_2905", "l10n_br_fiscal.cfop_2905"),
    ("l10n_br_account_product.cfop_2906", "l10n_br_fiscal.cfop_2906"),
    ("l10n_br_account_product.cfop_2907", "l10n_br_fiscal.cfop_2907"),
    ("l10n_br_account_product.cfop_2908", "l10n_br_fiscal.cfop_2908"),
    ("l10n_br_account_product.cfop_2909", "l10n_br_fiscal.cfop_2909"),
    ("l10n_br_account_product.cfop_2910", "l10n_br_fiscal.cfop_2910"),
    ("l10n_br_account_product.cfop_2911", "l10n_br_fiscal.cfop_2911"),
    ("l10n_br_account_product.cfop_2912", "l10n_br_fiscal.cfop_2912"),
    ("l10n_br_account_product.cfop_2913", "l10n_br_fiscal.cfop_2913"),
    ("l10n_br_account_product.cfop_2914", "l10n_br_fiscal.cfop_2914"),
    ("l10n_br_account_product.cfop_2915", "l10n_br_fiscal.cfop_2915"),
    ("l10n_br_account_product.cfop_2916", "l10n_br_fiscal.cfop_2916"),
    ("l10n_br_account_product.cfop_2917", "l10n_br_fiscal.cfop_2917"),
    ("l10n_br_account_product.cfop_2918", "l10n_br_fiscal.cfop_2918"),
    ("l10n_br_account_product.cfop_2919", "l10n_br_fiscal.cfop_2919"),
    ("l10n_br_account_product.cfop_2920", "l10n_br_fiscal.cfop_2920"),
    ("l10n_br_account_product.cfop_2921", "l10n_br_fiscal.cfop_2921"),
    ("l10n_br_account_product.cfop_2922", "l10n_br_fiscal.cfop_2922"),
    ("l10n_br_account_product.cfop_2923", "l10n_br_fiscal.cfop_2923"),
    ("l10n_br_account_product.cfop_2924", "l10n_br_fiscal.cfop_2924"),
    ("l10n_br_account_product.cfop_2925", "l10n_br_fiscal.cfop_2925"),
    ("l10n_br_account_product.cfop_2931", "l10n_br_fiscal.cfop_2931"),
    ("l10n_br_account_product.cfop_2932", "l10n_br_fiscal.cfop_2932"),
    ("l10n_br_account_product.cfop_2933", "l10n_br_fiscal.cfop_2933"),
    ("l10n_br_account_product.cfop_2934", "l10n_br_fiscal.cfop_2934"),
    ("l10n_br_account_product.cfop_2949", "l10n_br_fiscal.cfop_2949"),
    ("l10n_br_account_product.cfop_3101", "l10n_br_fiscal.cfop_3101"),
    ("l10n_br_account_product.cfop_3102", "l10n_br_fiscal.cfop_3102"),
    ("l10n_br_account_product.cfop_3126", "l10n_br_fiscal.cfop_3126"),
    ("l10n_br_account_product.cfop_3127", "l10n_br_fiscal.cfop_3127"),
    ("l10n_br_account_product.cfop_3128", "l10n_br_fiscal.cfop_3128"),
    ("l10n_br_account_product.cfop_3129", "l10n_br_fiscal.cfop_3129"),
    ("l10n_br_account_product.cfop_3201", "l10n_br_fiscal.cfop_3201"),
    ("l10n_br_account_product.cfop_3202", "l10n_br_fiscal.cfop_3202"),
    ("l10n_br_account_product.cfop_3205", "l10n_br_fiscal.cfop_3205"),
    ("l10n_br_account_product.cfop_3206", "l10n_br_fiscal.cfop_3206"),
    ("l10n_br_account_product.cfop_3207", "l10n_br_fiscal.cfop_3207"),
    ("l10n_br_account_product.cfop_3211", "l10n_br_fiscal.cfop_3211"),
    ("l10n_br_account_product.cfop_3212", "l10n_br_fiscal.cfop_3212"),
    ("l10n_br_account_product.cfop_3217", "l10n_br_fiscal.cfop_3217"),
    ("l10n_br_account_product.cfop_3251", "l10n_br_fiscal.cfop_3251"),
    ("l10n_br_account_product.cfop_3301", "l10n_br_fiscal.cfop_3301"),
    ("l10n_br_account_product.cfop_3351", "l10n_br_fiscal.cfop_3351"),
    ("l10n_br_account_product.cfop_3352", "l10n_br_fiscal.cfop_3352"),
    ("l10n_br_account_product.cfop_3353", "l10n_br_fiscal.cfop_3353"),
    ("l10n_br_account_product.cfop_3354", "l10n_br_fiscal.cfop_3354"),
    ("l10n_br_account_product.cfop_3355", "l10n_br_fiscal.cfop_3355"),
    ("l10n_br_account_product.cfop_3356", "l10n_br_fiscal.cfop_3356"),
    ("l10n_br_account_product.cfop_3503", "l10n_br_fiscal.cfop_3503"),
    ("l10n_br_account_product.cfop_3551", "l10n_br_fiscal.cfop_3551"),
    ("l10n_br_account_product.cfop_3553", "l10n_br_fiscal.cfop_3553"),
    ("l10n_br_account_product.cfop_3556", "l10n_br_fiscal.cfop_3556"),
    ("l10n_br_account_product.cfop_3651", "l10n_br_fiscal.cfop_3651"),
    ("l10n_br_account_product.cfop_3652", "l10n_br_fiscal.cfop_3652"),
    ("l10n_br_account_product.cfop_3653", "l10n_br_fiscal.cfop_3653"),
    ("l10n_br_account_product.cfop_3930", "l10n_br_fiscal.cfop_3930"),
    ("l10n_br_account_product.cfop_3949", "l10n_br_fiscal.cfop_3949"),
    ("l10n_br_account_product.cfop_5101", "l10n_br_fiscal.cfop_5101"),
    ("l10n_br_account_product.cfop_5102", "l10n_br_fiscal.cfop_5102"),
    ("l10n_br_account_product.cfop_5103", "l10n_br_fiscal.cfop_5103"),
    ("l10n_br_account_product.cfop_5104", "l10n_br_fiscal.cfop_5104"),
    ("l10n_br_account_product.cfop_5105", "l10n_br_fiscal.cfop_5105"),
    ("l10n_br_account_product.cfop_5106", "l10n_br_fiscal.cfop_5106"),
    ("l10n_br_account_product.cfop_5109", "l10n_br_fiscal.cfop_5109"),
    ("l10n_br_account_product.cfop_5110", "l10n_br_fiscal.cfop_5110"),
    ("l10n_br_account_product.cfop_5111", "l10n_br_fiscal.cfop_5111"),
    ("l10n_br_account_product.cfop_5112", "l10n_br_fiscal.cfop_5112"),
    ("l10n_br_account_product.cfop_5113", "l10n_br_fiscal.cfop_5113"),
    ("l10n_br_account_product.cfop_5114", "l10n_br_fiscal.cfop_5114"),
    ("l10n_br_account_product.cfop_5115", "l10n_br_fiscal.cfop_5115"),
    ("l10n_br_account_product.cfop_5116", "l10n_br_fiscal.cfop_5116"),
    ("l10n_br_account_product.cfop_5117", "l10n_br_fiscal.cfop_5117"),
    ("l10n_br_account_product.cfop_5118", "l10n_br_fiscal.cfop_5118"),
    ("l10n_br_account_product.cfop_5119", "l10n_br_fiscal.cfop_5119"),
    ("l10n_br_account_product.cfop_5120", "l10n_br_fiscal.cfop_5120"),
    ("l10n_br_account_product.cfop_5122", "l10n_br_fiscal.cfop_5122"),
    ("l10n_br_account_product.cfop_5123", "l10n_br_fiscal.cfop_5123"),
    ("l10n_br_account_product.cfop_5124", "l10n_br_fiscal.cfop_5124"),
    ("l10n_br_account_product.cfop_5125", "l10n_br_fiscal.cfop_5125"),
    ("l10n_br_account_product.cfop_5129", "l10n_br_fiscal.cfop_5129"),
    ("l10n_br_account_product.cfop_5131", "l10n_br_fiscal.cfop_5131"),
    ("l10n_br_account_product.cfop_5132", "l10n_br_fiscal.cfop_5132"),
    ("l10n_br_account_product.cfop_5151", "l10n_br_fiscal.cfop_5151"),
    ("l10n_br_account_product.cfop_5152", "l10n_br_fiscal.cfop_5152"),
    ("l10n_br_account_product.cfop_5153", "l10n_br_fiscal.cfop_5153"),
    ("l10n_br_account_product.cfop_5155", "l10n_br_fiscal.cfop_5155"),
    ("l10n_br_account_product.cfop_5156", "l10n_br_fiscal.cfop_5156"),
    ("l10n_br_account_product.cfop_5159", "l10n_br_fiscal.cfop_5159"),
    ("l10n_br_account_product.cfop_5160", "l10n_br_fiscal.cfop_5160"),
    ("l10n_br_account_product.cfop_5201", "l10n_br_fiscal.cfop_5201"),
    ("l10n_br_account_product.cfop_5202", "l10n_br_fiscal.cfop_5202"),
    ("l10n_br_account_product.cfop_5205", "l10n_br_fiscal.cfop_5205"),
    ("l10n_br_account_product.cfop_5206", "l10n_br_fiscal.cfop_5206"),
    ("l10n_br_account_product.cfop_5207", "l10n_br_fiscal.cfop_5207"),
    ("l10n_br_account_product.cfop_5208", "l10n_br_fiscal.cfop_5208"),
    ("l10n_br_account_product.cfop_5209", "l10n_br_fiscal.cfop_5209"),
    ("l10n_br_account_product.cfop_5210", "l10n_br_fiscal.cfop_5210"),
    ("l10n_br_account_product.cfop_5213", "l10n_br_fiscal.cfop_5213"),
    ("l10n_br_account_product.cfop_5214", "l10n_br_fiscal.cfop_5214"),
    ("l10n_br_account_product.cfop_5215", "l10n_br_fiscal.cfop_5215"),
    ("l10n_br_account_product.cfop_5251", "l10n_br_fiscal.cfop_5251"),
    ("l10n_br_account_product.cfop_5252", "l10n_br_fiscal.cfop_5252"),
    ("l10n_br_account_product.cfop_5253", "l10n_br_fiscal.cfop_5253"),
    ("l10n_br_account_product.cfop_5254", "l10n_br_fiscal.cfop_5254"),
    ("l10n_br_account_product.cfop_5255", "l10n_br_fiscal.cfop_5255"),
    ("l10n_br_account_product.cfop_5256", "l10n_br_fiscal.cfop_5256"),
    ("l10n_br_account_product.cfop_5257", "l10n_br_fiscal.cfop_5257"),
    ("l10n_br_account_product.cfop_5258", "l10n_br_fiscal.cfop_5258"),
    ("l10n_br_account_product.cfop_5301", "l10n_br_fiscal.cfop_5301"),
    ("l10n_br_account_product.cfop_5302", "l10n_br_fiscal.cfop_5302"),
    ("l10n_br_account_product.cfop_5303", "l10n_br_fiscal.cfop_5303"),
    ("l10n_br_account_product.cfop_5304", "l10n_br_fiscal.cfop_5304"),
    ("l10n_br_account_product.cfop_5305", "l10n_br_fiscal.cfop_5305"),
    ("l10n_br_account_product.cfop_5306", "l10n_br_fiscal.cfop_5306"),
    ("l10n_br_account_product.cfop_5307", "l10n_br_fiscal.cfop_5307"),
    ("l10n_br_account_product.cfop_5351", "l10n_br_fiscal.cfop_5351"),
    ("l10n_br_account_product.cfop_5352", "l10n_br_fiscal.cfop_5352"),
    ("l10n_br_account_product.cfop_5353", "l10n_br_fiscal.cfop_5353"),
    ("l10n_br_account_product.cfop_5354", "l10n_br_fiscal.cfop_5354"),
    ("l10n_br_account_product.cfop_5355", "l10n_br_fiscal.cfop_5355"),
    ("l10n_br_account_product.cfop_5356", "l10n_br_fiscal.cfop_5356"),
    ("l10n_br_account_product.cfop_5357", "l10n_br_fiscal.cfop_5357"),
    ("l10n_br_account_product.cfop_5359", "l10n_br_fiscal.cfop_5359"),
    ("l10n_br_account_product.cfop_5360", "l10n_br_fiscal.cfop_5360"),
    ("l10n_br_account_product.cfop_5401", "l10n_br_fiscal.cfop_5401"),
    ("l10n_br_account_product.cfop_5402", "l10n_br_fiscal.cfop_5402"),
    ("l10n_br_account_product.cfop_5403", "l10n_br_fiscal.cfop_5403"),
    ("l10n_br_account_product.cfop_5405", "l10n_br_fiscal.cfop_5405"),
    ("l10n_br_account_product.cfop_5408", "l10n_br_fiscal.cfop_5408"),
    ("l10n_br_account_product.cfop_5409", "l10n_br_fiscal.cfop_5409"),
    ("l10n_br_account_product.cfop_5410", "l10n_br_fiscal.cfop_5410"),
    ("l10n_br_account_product.cfop_5411", "l10n_br_fiscal.cfop_5411"),
    ("l10n_br_account_product.cfop_5412", "l10n_br_fiscal.cfop_5412"),
    ("l10n_br_account_product.cfop_5413", "l10n_br_fiscal.cfop_5413"),
    ("l10n_br_account_product.cfop_5414", "l10n_br_fiscal.cfop_5414"),
    ("l10n_br_account_product.cfop_5415", "l10n_br_fiscal.cfop_5415"),
    ("l10n_br_account_product.cfop_5451", "l10n_br_fiscal.cfop_5451"),
    ("l10n_br_account_product.cfop_5501", "l10n_br_fiscal.cfop_5501"),
    ("l10n_br_account_product.cfop_5502", "l10n_br_fiscal.cfop_5502"),
    ("l10n_br_account_product.cfop_5503", "l10n_br_fiscal.cfop_5503"),
    ("l10n_br_account_product.cfop_5504", "l10n_br_fiscal.cfop_5504"),
    ("l10n_br_account_product.cfop_5505", "l10n_br_fiscal.cfop_5505"),
    ("l10n_br_account_product.cfop_5551", "l10n_br_fiscal.cfop_5551"),
    ("l10n_br_account_product.cfop_5552", "l10n_br_fiscal.cfop_5552"),
    ("l10n_br_account_product.cfop_5553", "l10n_br_fiscal.cfop_5553"),
    ("l10n_br_account_product.cfop_5554", "l10n_br_fiscal.cfop_5554"),
    ("l10n_br_account_product.cfop_5555", "l10n_br_fiscal.cfop_5555"),
    ("l10n_br_account_product.cfop_5556", "l10n_br_fiscal.cfop_5556"),
    ("l10n_br_account_product.cfop_5557", "l10n_br_fiscal.cfop_5557"),
    ("l10n_br_account_product.cfop_5601", "l10n_br_fiscal.cfop_5601"),
    ("l10n_br_account_product.cfop_5602", "l10n_br_fiscal.cfop_5602"),
    ("l10n_br_account_product.cfop_5603", "l10n_br_fiscal.cfop_5603"),
    ("l10n_br_account_product.cfop_5605", "l10n_br_fiscal.cfop_5605"),
    ("l10n_br_account_product.cfop_5606", "l10n_br_fiscal.cfop_5606"),
    ("l10n_br_account_product.cfop_5651", "l10n_br_fiscal.cfop_5651"),
    ("l10n_br_account_product.cfop_5652", "l10n_br_fiscal.cfop_5652"),
    ("l10n_br_account_product.cfop_5653", "l10n_br_fiscal.cfop_5653"),
    ("l10n_br_account_product.cfop_5654", "l10n_br_fiscal.cfop_5654"),
    ("l10n_br_account_product.cfop_5655", "l10n_br_fiscal.cfop_5655"),
    ("l10n_br_account_product.cfop_5656", "l10n_br_fiscal.cfop_5656"),
    ("l10n_br_account_product.cfop_5657", "l10n_br_fiscal.cfop_5657"),
    ("l10n_br_account_product.cfop_5658", "l10n_br_fiscal.cfop_5658"),
    ("l10n_br_account_product.cfop_5659", "l10n_br_fiscal.cfop_5659"),
    ("l10n_br_account_product.cfop_5660", "l10n_br_fiscal.cfop_5660"),
    ("l10n_br_account_product.cfop_5661", "l10n_br_fiscal.cfop_5661"),
    ("l10n_br_account_product.cfop_5662", "l10n_br_fiscal.cfop_5662"),
    ("l10n_br_account_product.cfop_5663", "l10n_br_fiscal.cfop_5663"),
    ("l10n_br_account_product.cfop_5664", "l10n_br_fiscal.cfop_5664"),
    ("l10n_br_account_product.cfop_5665", "l10n_br_fiscal.cfop_5665"),
    ("l10n_br_account_product.cfop_5666", "l10n_br_fiscal.cfop_5666"),
    ("l10n_br_account_product.cfop_5667", "l10n_br_fiscal.cfop_5667"),
    ("l10n_br_account_product.cfop_5901", "l10n_br_fiscal.cfop_5901"),
    ("l10n_br_account_product.cfop_5902", "l10n_br_fiscal.cfop_5902"),
    ("l10n_br_account_product.cfop_5903", "l10n_br_fiscal.cfop_5903"),
    ("l10n_br_account_product.cfop_5904", "l10n_br_fiscal.cfop_5904"),
    ("l10n_br_account_product.cfop_5905", "l10n_br_fiscal.cfop_5905"),
    ("l10n_br_account_product.cfop_5906", "l10n_br_fiscal.cfop_5906"),
    ("l10n_br_account_product.cfop_5907", "l10n_br_fiscal.cfop_5907"),
    ("l10n_br_account_product.cfop_5908", "l10n_br_fiscal.cfop_5908"),
    ("l10n_br_account_product.cfop_5909", "l10n_br_fiscal.cfop_5909"),
    ("l10n_br_account_product.cfop_5910", "l10n_br_fiscal.cfop_5910"),
    ("l10n_br_account_product.cfop_5911", "l10n_br_fiscal.cfop_5911"),
    ("l10n_br_account_product.cfop_5912", "l10n_br_fiscal.cfop_5912"),
    ("l10n_br_account_product.cfop_5913", "l10n_br_fiscal.cfop_5913"),
    ("l10n_br_account_product.cfop_5914", "l10n_br_fiscal.cfop_5914"),
    ("l10n_br_account_product.cfop_5915", "l10n_br_fiscal.cfop_5915"),
    ("l10n_br_account_product.cfop_5916", "l10n_br_fiscal.cfop_5916"),
    ("l10n_br_account_product.cfop_5917", "l10n_br_fiscal.cfop_5917"),
    ("l10n_br_account_product.cfop_5918", "l10n_br_fiscal.cfop_5918"),
    ("l10n_br_account_product.cfop_5919", "l10n_br_fiscal.cfop_5919"),
    ("l10n_br_account_product.cfop_5920", "l10n_br_fiscal.cfop_5920"),
    ("l10n_br_account_product.cfop_5921", "l10n_br_fiscal.cfop_5921"),
    ("l10n_br_account_product.cfop_5922", "l10n_br_fiscal.cfop_5922"),
    ("l10n_br_account_product.cfop_5923", "l10n_br_fiscal.cfop_5923"),
    ("l10n_br_account_product.cfop_5923", "l10n_br_fiscal.cfop_5923"),
    ("l10n_br_account_product.cfop_5924", "l10n_br_fiscal.cfop_5924"),
    ("l10n_br_account_product.cfop_5925", "l10n_br_fiscal.cfop_5925"),
    ("l10n_br_account_product.cfop_5926", "l10n_br_fiscal.cfop_5926"),
    ("l10n_br_account_product.cfop_5927", "l10n_br_fiscal.cfop_5927"),
    ("l10n_br_account_product.cfop_5928", "l10n_br_fiscal.cfop_5928"),
    ("l10n_br_account_product.cfop_5929", "l10n_br_fiscal.cfop_5929"),
    ("l10n_br_account_product.cfop_5931", "l10n_br_fiscal.cfop_5931"),
    ("l10n_br_account_product.cfop_5932", "l10n_br_fiscal.cfop_5932"),
    ("l10n_br_account_product.cfop_5933", "l10n_br_fiscal.cfop_5933"),
    ("l10n_br_account_product.cfop_5934", "l10n_br_fiscal.cfop_5934"),
    ("l10n_br_account_product.cfop_5949", "l10n_br_fiscal.cfop_5949"),
    ("l10n_br_account_product.cfop_6101", "l10n_br_fiscal.cfop_6101"),
    ("l10n_br_account_product.cfop_6102", "l10n_br_fiscal.cfop_6102"),
    ("l10n_br_account_product.cfop_6103", "l10n_br_fiscal.cfop_6103"),
    ("l10n_br_account_product.cfop_6104", "l10n_br_fiscal.cfop_6104"),
    ("l10n_br_account_product.cfop_6105", "l10n_br_fiscal.cfop_6105"),
    ("l10n_br_account_product.cfop_6106", "l10n_br_fiscal.cfop_6106"),
    ("l10n_br_account_product.cfop_6107", "l10n_br_fiscal.cfop_6107"),
    ("l10n_br_account_product.cfop_6108", "l10n_br_fiscal.cfop_6108"),
    ("l10n_br_account_product.cfop_6109", "l10n_br_fiscal.cfop_6109"),
    ("l10n_br_account_product.cfop_6110", "l10n_br_fiscal.cfop_6110"),
    ("l10n_br_account_product.cfop_6111", "l10n_br_fiscal.cfop_6111"),
    ("l10n_br_account_product.cfop_6112", "l10n_br_fiscal.cfop_6112"),
    ("l10n_br_account_product.cfop_6113", "l10n_br_fiscal.cfop_6113"),
    ("l10n_br_account_product.cfop_6114", "l10n_br_fiscal.cfop_6114"),
    ("l10n_br_account_product.cfop_6115", "l10n_br_fiscal.cfop_6115"),
    ("l10n_br_account_product.cfop_6116", "l10n_br_fiscal.cfop_6116"),
    ("l10n_br_account_product.cfop_6117", "l10n_br_fiscal.cfop_6117"),
    ("l10n_br_account_product.cfop_6118", "l10n_br_fiscal.cfop_6118"),
    ("l10n_br_account_product.cfop_6119", "l10n_br_fiscal.cfop_6119"),
    ("l10n_br_account_product.cfop_6120", "l10n_br_fiscal.cfop_6120"),
    ("l10n_br_account_product.cfop_6122", "l10n_br_fiscal.cfop_6122"),
    ("l10n_br_account_product.cfop_6123", "l10n_br_fiscal.cfop_6123"),
    ("l10n_br_account_product.cfop_6124", "l10n_br_fiscal.cfop_6124"),
    ("l10n_br_account_product.cfop_6125", "l10n_br_fiscal.cfop_6125"),
    ("l10n_br_account_product.cfop_6129", "l10n_br_fiscal.cfop_6129"),
    ("l10n_br_account_product.cfop_6131", "l10n_br_fiscal.cfop_6131"),
    ("l10n_br_account_product.cfop_6132", "l10n_br_fiscal.cfop_6132"),
    ("l10n_br_account_product.cfop_6151", "l10n_br_fiscal.cfop_6151"),
    ("l10n_br_account_product.cfop_6152", "l10n_br_fiscal.cfop_6152"),
    ("l10n_br_account_product.cfop_6153", "l10n_br_fiscal.cfop_6153"),
    ("l10n_br_account_product.cfop_6155", "l10n_br_fiscal.cfop_6155"),
    ("l10n_br_account_product.cfop_6156", "l10n_br_fiscal.cfop_6156"),
    ("l10n_br_account_product.cfop_6159", "l10n_br_fiscal.cfop_6159"),
    ("l10n_br_account_product.cfop_6160", "l10n_br_fiscal.cfop_6160"),
    ("l10n_br_account_product.cfop_6201", "l10n_br_fiscal.cfop_6201"),
    ("l10n_br_account_product.cfop_6202", "l10n_br_fiscal.cfop_6202"),
    ("l10n_br_account_product.cfop_6205", "l10n_br_fiscal.cfop_6205"),
    ("l10n_br_account_product.cfop_6206", "l10n_br_fiscal.cfop_6206"),
    ("l10n_br_account_product.cfop_6207", "l10n_br_fiscal.cfop_6207"),
    ("l10n_br_account_product.cfop_6208", "l10n_br_fiscal.cfop_6208"),
    ("l10n_br_account_product.cfop_6209", "l10n_br_fiscal.cfop_6209"),
    ("l10n_br_account_product.cfop_6210", "l10n_br_fiscal.cfop_6210"),
    ("l10n_br_account_product.cfop_6213", "l10n_br_fiscal.cfop_6213"),
    ("l10n_br_account_product.cfop_6214", "l10n_br_fiscal.cfop_6214"),
    ("l10n_br_account_product.cfop_6215", "l10n_br_fiscal.cfop_6215"),
    ("l10n_br_account_product.cfop_6251", "l10n_br_fiscal.cfop_6251"),
    ("l10n_br_account_product.cfop_6252", "l10n_br_fiscal.cfop_6252"),
    ("l10n_br_account_product.cfop_6253", "l10n_br_fiscal.cfop_6253"),
    ("l10n_br_account_product.cfop_6254", "l10n_br_fiscal.cfop_6254"),
    ("l10n_br_account_product.cfop_6255", "l10n_br_fiscal.cfop_6255"),
    ("l10n_br_account_product.cfop_6256", "l10n_br_fiscal.cfop_6256"),
    ("l10n_br_account_product.cfop_6257", "l10n_br_fiscal.cfop_6257"),
    ("l10n_br_account_product.cfop_6258", "l10n_br_fiscal.cfop_6258"),
    ("l10n_br_account_product.cfop_6301", "l10n_br_fiscal.cfop_6301"),
    ("l10n_br_account_product.cfop_6302", "l10n_br_fiscal.cfop_6302"),
    ("l10n_br_account_product.cfop_6303", "l10n_br_fiscal.cfop_6303"),
    ("l10n_br_account_product.cfop_6304", "l10n_br_fiscal.cfop_6304"),
    ("l10n_br_account_product.cfop_6305", "l10n_br_fiscal.cfop_6305"),
    ("l10n_br_account_product.cfop_6306", "l10n_br_fiscal.cfop_6306"),
    ("l10n_br_account_product.cfop_6307", "l10n_br_fiscal.cfop_6307"),
    ("l10n_br_account_product.cfop_6351", "l10n_br_fiscal.cfop_6351"),
    ("l10n_br_account_product.cfop_6352", "l10n_br_fiscal.cfop_6352"),
    ("l10n_br_account_product.cfop_6353", "l10n_br_fiscal.cfop_6353"),
    ("l10n_br_account_product.cfop_6354", "l10n_br_fiscal.cfop_6354"),
    ("l10n_br_account_product.cfop_6355", "l10n_br_fiscal.cfop_6355"),
    ("l10n_br_account_product.cfop_6356", "l10n_br_fiscal.cfop_6356"),
    ("l10n_br_account_product.cfop_6357", "l10n_br_fiscal.cfop_6357"),
    ("l10n_br_account_product.cfop_6359", "l10n_br_fiscal.cfop_6359"),
    ("l10n_br_account_product.cfop_6360", "l10n_br_fiscal.cfop_6360"),
    ("l10n_br_account_product.cfop_6401", "l10n_br_fiscal.cfop_6401"),
    ("l10n_br_account_product.cfop_6402", "l10n_br_fiscal.cfop_6402"),
    ("l10n_br_account_product.cfop_6403", "l10n_br_fiscal.cfop_6403"),
    ("l10n_br_account_product.cfop_6404", "l10n_br_fiscal.cfop_6404"),
    ("l10n_br_account_product.cfop_6408", "l10n_br_fiscal.cfop_6408"),
    ("l10n_br_account_product.cfop_6409", "l10n_br_fiscal.cfop_6409"),
    ("l10n_br_account_product.cfop_6410", "l10n_br_fiscal.cfop_6410"),
    ("l10n_br_account_product.cfop_6411", "l10n_br_fiscal.cfop_6411"),
    ("l10n_br_account_product.cfop_6412", "l10n_br_fiscal.cfop_6412"),
    ("l10n_br_account_product.cfop_6413", "l10n_br_fiscal.cfop_6413"),
    ("l10n_br_account_product.cfop_6414", "l10n_br_fiscal.cfop_6414"),
    ("l10n_br_account_product.cfop_6415", "l10n_br_fiscal.cfop_6415"),
    ("l10n_br_account_product.cfop_6501", "l10n_br_fiscal.cfop_6501"),
    ("l10n_br_account_product.cfop_6502", "l10n_br_fiscal.cfop_6502"),
    ("l10n_br_account_product.cfop_6503", "l10n_br_fiscal.cfop_6503"),
    ("l10n_br_account_product.cfop_6504", "l10n_br_fiscal.cfop_6504"),
    ("l10n_br_account_product.cfop_6505", "l10n_br_fiscal.cfop_6505"),
    ("l10n_br_account_product.cfop_6551", "l10n_br_fiscal.cfop_6551"),
    ("l10n_br_account_product.cfop_6552", "l10n_br_fiscal.cfop_6552"),
    ("l10n_br_account_product.cfop_6553", "l10n_br_fiscal.cfop_6553"),
    ("l10n_br_account_product.cfop_6554", "l10n_br_fiscal.cfop_6554"),
    ("l10n_br_account_product.cfop_6555", "l10n_br_fiscal.cfop_6555"),
    ("l10n_br_account_product.cfop_6556", "l10n_br_fiscal.cfop_6556"),
    ("l10n_br_account_product.cfop_6557", "l10n_br_fiscal.cfop_6557"),
    ("l10n_br_account_product.cfop_6603", "l10n_br_fiscal.cfop_6603"),
    ("l10n_br_account_product.cfop_6651", "l10n_br_fiscal.cfop_6651"),
    ("l10n_br_account_product.cfop_6652", "l10n_br_fiscal.cfop_6652"),
    ("l10n_br_account_product.cfop_6653", "l10n_br_fiscal.cfop_6653"),
    ("l10n_br_account_product.cfop_6654", "l10n_br_fiscal.cfop_6654"),
    ("l10n_br_account_product.cfop_6655", "l10n_br_fiscal.cfop_6655"),
    ("l10n_br_account_product.cfop_6656", "l10n_br_fiscal.cfop_6656"),
    ("l10n_br_account_product.cfop_6657", "l10n_br_fiscal.cfop_6657"),
    ("l10n_br_account_product.cfop_6658", "l10n_br_fiscal.cfop_6658"),
    ("l10n_br_account_product.cfop_6659", "l10n_br_fiscal.cfop_6659"),
    ("l10n_br_account_product.cfop_6660", "l10n_br_fiscal.cfop_6660"),
    ("l10n_br_account_product.cfop_6661", "l10n_br_fiscal.cfop_6661"),
    ("l10n_br_account_product.cfop_6662", "l10n_br_fiscal.cfop_6662"),
    ("l10n_br_account_product.cfop_6663", "l10n_br_fiscal.cfop_6663"),
    ("l10n_br_account_product.cfop_6664", "l10n_br_fiscal.cfop_6664"),
    ("l10n_br_account_product.cfop_6665", "l10n_br_fiscal.cfop_6665"),
    ("l10n_br_account_product.cfop_6666", "l10n_br_fiscal.cfop_6666"),
    ("l10n_br_account_product.cfop_6667", "l10n_br_fiscal.cfop_6667"),
    ("l10n_br_account_product.cfop_6901", "l10n_br_fiscal.cfop_6901"),
    ("l10n_br_account_product.cfop_6902", "l10n_br_fiscal.cfop_6902"),
    ("l10n_br_account_product.cfop_6903", "l10n_br_fiscal.cfop_6903"),
    ("l10n_br_account_product.cfop_6904", "l10n_br_fiscal.cfop_6904"),
    ("l10n_br_account_product.cfop_6905", "l10n_br_fiscal.cfop_6905"),
    ("l10n_br_account_product.cfop_6906", "l10n_br_fiscal.cfop_6906"),
    ("l10n_br_account_product.cfop_6907", "l10n_br_fiscal.cfop_6907"),
    ("l10n_br_account_product.cfop_6908", "l10n_br_fiscal.cfop_6908"),
    ("l10n_br_account_product.cfop_6909", "l10n_br_fiscal.cfop_6909"),
    ("l10n_br_account_product.cfop_6910", "l10n_br_fiscal.cfop_6910"),
    ("l10n_br_account_product.cfop_6911", "l10n_br_fiscal.cfop_6911"),
    ("l10n_br_account_product.cfop_6912", "l10n_br_fiscal.cfop_6912"),
    ("l10n_br_account_product.cfop_6913", "l10n_br_fiscal.cfop_6913"),
    ("l10n_br_account_product.cfop_6914", "l10n_br_fiscal.cfop_6914"),
    ("l10n_br_account_product.cfop_6915", "l10n_br_fiscal.cfop_6915"),
    ("l10n_br_account_product.cfop_6916", "l10n_br_fiscal.cfop_6916"),
    ("l10n_br_account_product.cfop_6917", "l10n_br_fiscal.cfop_6917"),
    ("l10n_br_account_product.cfop_6918", "l10n_br_fiscal.cfop_6918"),
    ("l10n_br_account_product.cfop_6919", "l10n_br_fiscal.cfop_6919"),
    ("l10n_br_account_product.cfop_6920", "l10n_br_fiscal.cfop_6920"),
    ("l10n_br_account_product.cfop_6921", "l10n_br_fiscal.cfop_6921"),
    ("l10n_br_account_product.cfop_6922", "l10n_br_fiscal.cfop_6922"),
    ("l10n_br_account_product.cfop_6923", "l10n_br_fiscal.cfop_6923"),
    ("l10n_br_account_product.cfop_6923", "l10n_br_fiscal.cfop_6923"),
    ("l10n_br_account_product.cfop_6924", "l10n_br_fiscal.cfop_6924"),
    ("l10n_br_account_product.cfop_6925", "l10n_br_fiscal.cfop_6925"),
    ("l10n_br_account_product.cfop_6929", "l10n_br_fiscal.cfop_6929"),
    ("l10n_br_account_product.cfop_6931", "l10n_br_fiscal.cfop_6931"),
    ("l10n_br_account_product.cfop_6932", "l10n_br_fiscal.cfop_6932"),
    ("l10n_br_account_product.cfop_6933", "l10n_br_fiscal.cfop_6933"),
    ("l10n_br_account_product.cfop_6934", "l10n_br_fiscal.cfop_6934"),
    ("l10n_br_account_product.cfop_6949", "l10n_br_fiscal.cfop_6949"),
    ("l10n_br_account_product.cfop_7101", "l10n_br_fiscal.cfop_7101"),
    ("l10n_br_account_product.cfop_7102", "l10n_br_fiscal.cfop_7102"),
    ("l10n_br_account_product.cfop_7105", "l10n_br_fiscal.cfop_7105"),
    ("l10n_br_account_product.cfop_7106", "l10n_br_fiscal.cfop_7106"),
    ("l10n_br_account_product.cfop_7127", "l10n_br_fiscal.cfop_7127"),
    ("l10n_br_account_product.cfop_7129", "l10n_br_fiscal.cfop_7129"),
    ("l10n_br_account_product.cfop_7201", "l10n_br_fiscal.cfop_7201"),
    ("l10n_br_account_product.cfop_7202", "l10n_br_fiscal.cfop_7202"),
    ("l10n_br_account_product.cfop_7205", "l10n_br_fiscal.cfop_7205"),
    ("l10n_br_account_product.cfop_7206", "l10n_br_fiscal.cfop_7206"),
    ("l10n_br_account_product.cfop_7207", "l10n_br_fiscal.cfop_7207"),
    ("l10n_br_account_product.cfop_7210", "l10n_br_fiscal.cfop_7210"),
    ("l10n_br_account_product.cfop_7211", "l10n_br_fiscal.cfop_7211"),
    ("l10n_br_account_product.cfop_7212", "l10n_br_fiscal.cfop_7212"),
    ("l10n_br_account_product.cfop_7251", "l10n_br_fiscal.cfop_7251"),
    ("l10n_br_account_product.cfop_7301", "l10n_br_fiscal.cfop_7301"),
    ("l10n_br_account_product.cfop_7358", "l10n_br_fiscal.cfop_7358"),
    ("l10n_br_account_product.cfop_7501", "l10n_br_fiscal.cfop_7501"),
    ("l10n_br_account_product.cfop_7504", "l10n_br_fiscal.cfop_7504"),
    ("l10n_br_account_product.cfop_7551", "l10n_br_fiscal.cfop_7551"),
    ("l10n_br_account_product.cfop_7553", "l10n_br_fiscal.cfop_7553"),
    ("l10n_br_account_product.cfop_7556", "l10n_br_fiscal.cfop_7556"),
    ("l10n_br_account_product.cfop_7651", "l10n_br_fiscal.cfop_7651"),
    ("l10n_br_account_product.cfop_7654", "l10n_br_fiscal.cfop_7654"),
    ("l10n_br_account_product.cfop_7667", "l10n_br_fiscal.cfop_7667"),
    ("l10n_br_account_product.cfop_7930", "l10n_br_fiscal.cfop_7930"),
    ("l10n_br_account_product.cfop_7949", "l10n_br_fiscal.cfop_7949"),
]


@openupgrade.migrate(use_env=True)
def migrate(env, version):
    if openupgrade.column_exists(
        env.cr, "product_template", "fiscal_classification_id"
    ):
        openupgrade.copy_columns(env.cr, _column_copies)

    # TODO cnae is only on company, remove them + set null?
    openupgrade.rename_xmlids(env.cr, _xml_ids_cnae_renames)

    openupgrade.rename_xmlids(env.cr, _xml_ids_document_renames)
    openupgrade.rename_xmlids(env.cr, _xml_ids_cfop_renames)
    openupgrade.rename_xmlids(env.cr, _xml_ids_fiscal_operation_renames)
    openupgrade.rename_models(env.cr, _model_renames)
    openupgrade.rename_tables(env.cr, _table_renames)

    # nullifies relations that will be set back in post scripts:
    openupgrade.logged_query(env.cr, "UPDATE product_template SET service_type_id=NULL")
    openupgrade.logged_query(env.cr, "UPDATE product_template SET ncm_id=NULL")
    openupgrade.logged_query(
        env.cr, "UPDATE product_template SET fiscal_classification_id=NULL"
    )

    # the next records will be reset properly by l10n_br_fiscal installation,
    # specially with the post_init_hook that will be called
    # in the post-migration script.
    # relations to these records can be set back in post script
    # if columns are copied previously
    # (TODO should we leave the original table for a lookup
    # in the post-installation script? the rename_models/rename_tables
    # is what will trash the old tables and feel the new ones that
    # we trash here. Is it smart??)
    # TODO what about the xmlids? (seems Odoo will trash them)
    #    openupgrade.logged_query(env.cr,
    #            "DELETE from l10n_br_fiscal_partner_profile")
    openupgrade.logged_query(env.cr, "DELETE from l10n_br_fiscal_tax_estimate")
    # TODO we want to keep the operation, but then we should update their xmlid
    # or can we search in the new ones by code?
    openupgrade.logged_query(env.cr, "DELETE from l10n_br_fiscal_operation")
    # TODO we may want to keep the serie, but then we sould update their xmlid
    openupgrade.logged_query(env.cr, "DELETE from l10n_br_fiscal_document_serie")
    openupgrade.logged_query(env.cr, "DELETE from l10n_br_fiscal_document_type")
    openupgrade.logged_query(env.cr, "DELETE from l10n_br_fiscal_cnae")
    openupgrade.logged_query(env.cr, "DELETE from l10n_br_fiscal_cfop")
    #    openupgrade.logged_query(env.cr,
    #            "DELETE from l10n_br_fiscal_cest")

    openupgrade.logged_query(
        env.cr,
        "DELETE FROM ir_model_data\
        WHERE model='account.product.fiscal.classification.template'",
    )


#    openupgrade.logged_query(env.cr,
#            "DELETE from l10n_br_fiscal_ncm")
