"use strict";
const assert_1 = require("@aws-cdk/assert");
const cdk = require("@aws-cdk/core");
const iam = require("../lib");
module.exports = {
    'automatic exports are created when attributes are referneced across stacks'(test) {
        // GIVEN
        const app = new cdk.App();
        const stackWithUser = new cdk.Stack(app, 'stack1');
        const stackWithGroup = new cdk.Stack(app, 'stack2');
        const user = new iam.User(stackWithUser, 'User');
        const group = new iam.Group(stackWithGroup, 'Group');
        // WHEN
        group.addUser(user);
        //
        // `group.addUser` adds the group to the user resource definition, so we expect
        // that an automatic export will be created for the group and the user's stack
        // to use ImportValue to import it.
        // note that order of "expect"s matters. we first need to synthesize the user's
        // stack so that the cross stack reference will be reported and only then the
        // group's stack. in the real world, App will take care of this.
        //
        // THEN
        assert_1.expect(stackWithUser).toMatch({
            Resources: {
                User00B015A1: {
                    Type: "AWS::IAM::User",
                    Properties: {
                        Groups: [{ "Fn::ImportValue": "stack2:ExportsOutputRefGroupC77FDACD8CF7DD5B" }]
                    }
                }
            }
        });
        assert_1.expect(stackWithGroup).toMatch({
            Outputs: {
                ExportsOutputRefGroupC77FDACD8CF7DD5B: {
                    Value: { Ref: "GroupC77FDACD" },
                    Export: { Name: "stack2:ExportsOutputRefGroupC77FDACD8CF7DD5B" }
                }
            },
            Resources: {
                GroupC77FDACD: {
                    Type: "AWS::IAM::Group"
                }
            }
        });
        test.done();
    },
    'cannot reference tokens across apps'(test) {
        // GIVEN
        const stack1 = new cdk.Stack();
        const stack2 = new cdk.Stack();
        const user = new iam.User(stack1, 'User');
        const group = new iam.Group(stack2, 'Group');
        group.addUser(user);
        // THEN
        test.throws(() => assert_1.SynthUtils.synthesize(stack1), /Cannot reference across apps/);
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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