"use strict";
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
const iam = require("../lib");
module.exports = {
    'Grant.drop() returns a no-op grant'(test) {
        const stack = new core_1.Stack();
        const user = new iam.User(stack, 'poo');
        const grant = lib_1.Grant.drop(user, 'dropping me');
        test.ok(!grant.success, 'grant should not be successul');
        test.deepEqual(grant.principalStatement, undefined);
        test.deepEqual(grant.resourceStatement, undefined);
        test.done();
    }
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidGVzdC5ncmFudC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInRlc3QuZ3JhbnQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IjtBQUFBLHdDQUFzQztBQUV0QyxnQ0FBK0I7QUFDL0IsOEJBQStCO0FBRS9CLGlCQUFTO0lBQ1Asb0NBQW9DLENBQUMsSUFBVTtRQUM3QyxNQUFNLEtBQUssR0FBRyxJQUFJLFlBQUssRUFBRSxDQUFDO1FBQzFCLE1BQU0sSUFBSSxHQUFHLElBQUksR0FBRyxDQUFDLElBQUksQ0FBQyxLQUFLLEVBQUUsS0FBSyxDQUFDLENBQUM7UUFDeEMsTUFBTSxLQUFLLEdBQUcsV0FBSyxDQUFDLElBQUksQ0FBQyxJQUFJLEVBQUUsYUFBYSxDQUFDLENBQUM7UUFFOUMsSUFBSSxDQUFDLEVBQUUsQ0FBQyxDQUFDLEtBQUssQ0FBQyxPQUFPLEVBQUUsK0JBQStCLENBQUMsQ0FBQztRQUN6RCxJQUFJLENBQUMsU0FBUyxDQUFDLEtBQUssQ0FBQyxrQkFBa0IsRUFBRSxTQUFTLENBQUMsQ0FBQztRQUNwRCxJQUFJLENBQUMsU0FBUyxDQUFDLEtBQUssQ0FBQyxpQkFBaUIsRUFBRSxTQUFTLENBQUMsQ0FBQztRQUNuRCxJQUFJLENBQUMsSUFBSSxFQUFFLENBQUM7SUFDZCxDQUFDO0NBQ0YsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IFN0YWNrIH0gZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5pbXBvcnQgeyBUZXN0IH0gZnJvbSAnbm9kZXVuaXQnO1xuaW1wb3J0IHsgR3JhbnQgfSBmcm9tICcuLi9saWInO1xuaW1wb3J0IGlhbSA9IHJlcXVpcmUoJy4uL2xpYicpO1xuXG5leHBvcnQgPSB7XG4gICdHcmFudC5kcm9wKCkgcmV0dXJucyBhIG5vLW9wIGdyYW50Jyh0ZXN0OiBUZXN0KSB7XG4gICAgY29uc3Qgc3RhY2sgPSBuZXcgU3RhY2soKTtcbiAgICBjb25zdCB1c2VyID0gbmV3IGlhbS5Vc2VyKHN0YWNrLCAncG9vJyk7XG4gICAgY29uc3QgZ3JhbnQgPSBHcmFudC5kcm9wKHVzZXIsICdkcm9wcGluZyBtZScpO1xuXG4gICAgdGVzdC5vayghZ3JhbnQuc3VjY2VzcywgJ2dyYW50IHNob3VsZCBub3QgYmUgc3VjY2Vzc3VsJyk7XG4gICAgdGVzdC5kZWVwRXF1YWwoZ3JhbnQucHJpbmNpcGFsU3RhdGVtZW50LCB1bmRlZmluZWQpO1xuICAgIHRlc3QuZGVlcEVxdWFsKGdyYW50LnJlc291cmNlU3RhdGVtZW50LCB1bmRlZmluZWQpO1xuICAgIHRlc3QuZG9uZSgpO1xuICB9XG59OyJdfQ==