# Copyright (c) 2021-2023, NVIDIA CORPORATION.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from abc import ABC, abstractmethod

from nvflare.apis.signal import Signal
from nvflare.app_common.abstract.init_final_component import InitFinalArgsComponent


class PSIWorkflow(InitFinalArgsComponent, ABC):
    """
    PSIWorkflow is an interface for different PSI algorithms
    for example, DDH-Based PSI, Homomorphic-based PSI etc.
    """

    @abstractmethod
    def pre_process(self, abort_signal: Signal) -> bool:
        pass

    @abstractmethod
    def run(self, abort_signal: Signal) -> bool:
        pass

    @abstractmethod
    def post_process(self, abort_signal: Signal) -> bool:
        pass
