"""
infj - A Python package that provides the 'infj' complex number literal.

This package defines 'infj' as a complex number with zero real part and infinite
imaginary part (0 + ∞i), making it available as a convenient literal for mathematical
computations involving complex infinity.

infj is also known as the INFJ Personality Type in the Myers-Briggs Type Indicator (MBTI).

Example:
    >>> from infj import infj
    >>> infj
    infj
    >>> str(infj)
    'infj'
    >>> repr(infj)
    'infj'
    >>> infj == complex(0, float('inf'))
    True
"""

__version__ = "1.0.1"
__author__ = "KoolShow"
__email__ = "koolshowtec@gmail.com"
__all__ = ['infj']

from math import inf

# Define infj as a complex number with infinite imaginary part, aka 0 + ∞i
infj = complex(0, inf)
