"""
Unit tests for the infj package.
"""

import unittest

from . import infj
from math import inf


class TestInfj(unittest.TestCase):
    """Test cases for the infj complex number literal."""

    def test_str(self):
        """Test string representation of infj."""
        self.assertEqual(str(infj), 'infj')

    def test_repr(self):
        """Test repr representation of infj."""
        self.assertEqual(repr(infj), 'infj')

    def test_definition(self):
        """Test the definition of infj."""
        self.assertEqual(infj.real, 0.0)
        self.assertEqual(infj.imag, inf)
        self.assertIsInstance(infj, complex)
        self.assertEqual(infj, complex(0, inf))

if __name__ == '__main__':
    unittest.main(verbosity=2)
