]q (cpygments.token
_TokenType
qX   KeywordqX   Reservedqqqq}q(X   subtypesqcbuiltins
set
q	]q
qRqX   parentq
hhqqq}q(hh	]q(hhX   Wordqqqq}q(hh	]qqRqh
hubhhhqqq}q(hh	]qq Rq!h
hubhhX   Typeq"q#q$q%}q&(hh	]q'q(Rq)h
hubhhX   PreProcq*q+q,q-}q.(hh	]q/q0Rq1h
hubhhX   Controlq2q3q4q5}q6(hh	]q7q8Rq9h
hubhhX   Constantq:q;q<q=}q>(hh	]q?q@RqAh
hubhhX	   NamespaceqBqCqDqE}qF(hh	]qGqHRqIh
hubhhX   PseudoqJqKqLqM}qN(hh	]qOqPRqQh
hubhhX   DeclarationqRqSqTqU}qV(hh	]qWqXRqYh
hubheqZRq[h
h)q\q]}q^(hh	]q_(hX   Escapeq`qaqbqc}qd(hh	]qeqfRqgh
h]ubhX   Operatorqhqiqjqk}ql(hh	]qm(hhhX   DBSqnqoqpqq}qr(hh	]qsqtRquh
hkubhhhhqvqwqx}qy(hh	]qzq{Rq|h
hkubeq}Rq~h
h]hhxhnhqubhX   Nameqqqq}q(hh	]q(hhX   Tagqqqq}q(hh	]qqRqh
hubhhX   Entityqqqq}q(hh	]qhhhhnqqq}q(hh	]qqRqh
hubaqRqh
hhnhubhhX	   Exceptionqqqq}q(hh	]qqRqh
hubhhX	   Decoratorqqqq}q(hh	]qqRqh
hubhhX   Classqqqq}q(hh	]q(hhhhnqqq}q(hh	]qqRqh
hubhhhX   Startqqqq}q(hh	]qqRqh
hubeqRqh
hhhhnhubhhX   VariableqÆqąqŁq}q(hh	]q(hhhX	   Anonymousqɇqʅqˁq}q(hh	]q΅qRqh
hubhhhhqхqҁq}q(hh	]qՅqRqh
hubhhhX   Magicq؇qمqځq}q(hh	]q݅qRqh
hubhhhX   Globalqqqq}q(hh	]qqRqh
hubhhhX   Instanceqqqq}q(hh	]qqRqh
hubeqRqh
hhhhhhhhhhhubhhX	   Attributeqqqq}q(hh	]qhhhhÇqqq}q(hh	]qqRqh
hubaqRr   h
hhhubhhhBr  r  r  }r  (hh	]r  r  Rr  h
hubhhX   Propertyr  r	  r
  r  }r  (hh	]r
  r  Rr  h
hubhhX   Symbolr  r  r  r  }r  (hh	]r  r  Rr  h
hubhhX   Classesr  r  r  r  }r  (hh	]r  r  Rr  h
hubhhhJr   r!  r"  }r#  (hh	]r$  r%  Rr&  h
hubhhX   Labelr'  r(  r)  r*  }r+  (hh	]r,  r-  Rr.  h
hubhhhhr/  r0  r1  }r2  (hh	]r3  r4  Rr5  h
hubhhX   Builtinr6  r7  r8  r9  }r:  (hh	]r;  (hhj6  hJr<  r=  r>  }r?  (hh	]r@  rA  RrB  h
j9  ubhhj6  h"rC  rD  rE  }rF  (hh	]rG  rH  RrI  h
j9  uberJ  RrK  h
hhJj>  h"jE  ubhhX   FieldrL  rM  rN  rO  }rP  (hh	]rQ  rR  RrS  h
hubhhX   OtherrT  rU  rV  rW  }rX  (hh	]rY  hhjT  X   MemberrZ  r[  r\  r]  }r^  (hh	]r_  r`  Rra  h
jW  ubarb  Rrc  h
hjZ  j]  ubhhX   Functionrd  re  rf  rg  }rh  (hh	]ri  hhjd  h؇rj  rk  rl  }rm  (hh	]rn  ro  Rrp  h
jg  ubarq  Rrr  h
hhjl  ubhhh"rs  rt  ru  }rv  (hh	]rw  rx  Rry  h
hubhhh:rz  r{  r|  }r}  (hh	]r~  r  Rr  h
huber  Rr  h
h]hhj6  j9  hhh:j|  hhhhhhjd  jg  j  j  j'  j*  hBj  jT  jW  hhhhjL  jO  j  j  hJj"  hhj1  j  j  h"ju  ubhX   Literalr  r  r  r  }r  (hh	]r  (hj  jT  r  r  r  }r  (hh	]r  r  Rr  h
j  ubhj  X   Charr  r  r  r  }r  (hh	]r  r  Rr  h
j  ubhj  X   Dater  r  r  r  }r  (hh	]r  r  Rr  h
j  ubhj  X   Scalarr  r  r  r  }r  (hh	]r  hj  j  X   Plainr  r  r  r  }r  (hh	]r  r  Rr  h
j  ubar  Rr  h
j  j  j  ubhj  X   Stringr  r  r  r  }r  (hh	]r  (hj  j  X   Interpolr  r  r  r  }r  (hh	]r  r  Rr  h
j  ubhj  j  X	   Delimeterr  r  r  r  }r  (hh	]r  r  Rr  h
j  ubhj  j  j  r  r  r  }r  (hh	]r  r  Rr  h
j  ubhj  j  j  r  r  r  }r  (hh	]r  r  Rr  h
j  ubhj  j  X   Singler  r  r  r  }r  (hh	]r  r  Rr  h
j  ubhj  j  jT  r  r  r  }r  (hh	]r  r  Rr  h
j  ubhj  j  X   Backtickr  r  r  r  }r  (hh	]r  r  Rr  h
j  ubhj  j  h`r  r  r  }r  (hh	]r  r  Rr  h
j  ubhj  j  X   Regexr  r  r  r  }r  (hh	]r  r  Rr  h
j  ubhj  j  X   Momentr  r  r  r  }r  (hh	]r  r   Rr  h
j  ubhj  j  X   Booleanr  r  r  r  }r  (hh	]r  r  Rr	  h
j  ubhj  j  X	   Characterr
  r  r  r
  }r  (hh	]r  r  Rr  h
j  ubhj  j  X	   Delimiterr  r  r  r  }r  (hh	]r  r  Rr  h
j  ubhj  j  X   Docr  r  r  r  }r  (hh	]r  r   Rr!  h
j  ubhj  j  hr"  r#  r$  }r%  (hh	]r&  r'  Rr(  h
j  ubhj  j  X   Affixr)  r*  r+  r,  }r-  (hh	]r.  r/  Rr0  h
j  ubhj  j  X   Heredocr1  r2  r3  r4  }r5  (hh	]r6  r7  Rr8  h
j  ubhj  j  X   Doubler9  r:  r;  r<  }r=  (hh	]r>  r?  Rr@  h
j  ubhj  j  X   InterprA  rB  rC  rD  }rE  (hh	]rF  rG  RrH  h
j  ubhj  j  X   AtomrI  rJ  rK  rL  }rM  (hh	]rN  rO  RrP  h
j  uberQ  RrR  h
j  j)  j,  j  j  j  j  j  j  j  j  j9  j<  h`j  j1  j4  j  j  jT  j  j  j  j  j  j  j  j
  j
  j  j  jA  jD  j  j  j  j  jI  jL  hj$  ubhj  X   NumberrS  rT  rU  rV  }rW  (hh	]rX  (hj  jS  X   FloatrY  rZ  r[  r\  }r]  (hh	]r^  r_  Rr`  h
jV  ubhj  jS  X   Decra  rb  rc  rd  }re  (hh	]rf  rg  Rrh  h
jV  ubhj  jS  X   Radixri  rj  rk  rl  }rm  (hh	]rn  ro  Rrp  h
jV  ubhj  jS  X   Octrq  rr  rs  rt  }ru  (hh	]rv  rw  Rrx  h
jV  ubhj  jS  X   Binry  rz  r{  r|  }r}  (hh	]r~  r  Rr  h
jV  ubhj  jS  hr  r  r  }r  (hh	]r  r  Rr  h
jV  ubhj  jS  X   Hexr  r  r  r  }r  (hh	]r  r  Rr  h
jV  ubhj  jS  X   Integerr  r  r  r  }r  (hh	]r  h(j  jS  j  X   Longr  tr  r  r  }r  (hh	]r  r  Rr  h
j  ubar  Rr  h
jV  j  j  ubhj  jS  X   Decimalr  r  r  r  }r  (hh	]r  r  Rr  h
jV  uber  Rr  h
j  jy  j|  jY  j\  j  j  j  j  jq  jt  ji  jl  hj  j  j  ja  jd  uber  Rr  h
h]j  j  jS  jV  j  j  j  j  jT  j  j  j  ubhX   Genericr  r  r  r  }r  (hh	]r  (hj  X   Errorr  r  r  r  }r  (hh	]r  r  Rr  h
j  ubhj  X
   Subheadingr  r  r  r  }r  (hh	]r  r  Rr  h
j  ubhj  X	   Tracebackr  r  r  r  }r  (hh	]r  r  Rr  h
j  ubhj  X   Outputr  r  r  r  }r  (hh	]r  r  Rr  h
j  ubhj  X   Promptr  r  r  r  }r  (hh	]r  r  Rr  h
j  ubhj  X   Deletedr  r  r  r  }r  (hh	]r  r  Rr  h
j  ubhj  X   Insertedr  r  r  r  }r  (hh	]r  r  Rr  h
j  ubhj  X   Headingr  r  r  r  }r  (hh	]r  r  Rr  h
j  ubhj  X   Strongr  r  r  r  }r  (hh	]r  r  Rr  h
j  ubhj  X   Emphr  r  r  r  }r  (hh	]r  r   Rr  h
j  uber  Rr  h
h]j  j  j  j  j  j  j  j  j  j  j  j  j  j  j  j  j  j  j  j  ubhj  r  r  r  }r  (hh	]r  r	  Rr
  h
h]ubhhjT  r  r  r
  }r  (hh	]r  r  Rr  h
h]ubhX   Textr  r  r  r  }r  (hh	]r  (hj  X   Rootr  r  r  r  }r  (hh	]r  r  Rr  h
j  ubhj  j  r   r!  r"  }r#  (hh	]r$  r%  Rr&  h
j  ubhj  X   Ragr'  r(  r)  r*  }r+  (hh	]r,  r-  Rr.  h
j  ubhj  X
   Whitespacer/  r0  r1  r2  }r3  (hh	]r4  r5  Rr6  h
j  ubhj  X   Beerr7  r8  r9  r:  }r;  (hh	]r<  r=  Rr>  h
j  ubhj  X   Punctuationr?  r@  rA  rB  }rC  (hh	]rD  rE  RrF  h
j  uberG  RrH  h
h]j/  j2  j  j"  j?  jB  j  j  j7  j:  j'  j*  ubhX   CommentrI  rJ  rK  rL  }rM  (hh	]rN  (hjI  X   PreprocrO  rP  rQ  rR  }rS  (hh	]rT  rU  RrV  h
jL  ubhjI  X   MultirW  rX  rY  rZ  }r[  (hh	]r\  r]  Rr^  h
jL  ubhjI  X   Hashbangr_  r`  ra  rb  }rc  (hh	]rd  re  Rrf  h
jL  ubhjI  j  rg  rh  ri  }rj  (hh	]rk  rl  Rrm  h
jL  ubhjI  X
   SingleLinern  ro  rp  rq  }rr  (hh	]rs  rt  Rru  h
jL  ubhjI  j  rv  rw  rx  }ry  (hh	]rz  r{  Rr|  h
jL  ubhjI  X	   Directiver}  r~  r  r  }r  (hh	]r  r  Rr  h
jL  ubhjI  X	   Multiliner  r  r  r  }r  (hh	]r  r  Rr  h
jL  ubhjI  X
   Singleliner  r  r  r  }r  (hh	]r  r  Rr  h
jL  ubhjI  X   PreprocFiler  r  r  r  }r  (hh	]r  r  Rr  h
jL  ubhjI  X   Specialr  r  r  r  }r  (hh	]r  r  Rr  h
jL  uber  Rr  h
h]j_  jb  j  j  jO  jR  j  j  j  ji  j  j  j}  j  jn  jq  j  jx  jW  jZ  j  j  ubhj?  r  r  r  }r  (hh	]r  hj?  X	   Indicatorr  r  r  r  }r  (hh	]r  r  Rr  h
j  ubar  Rr  h
h]j  j  uber  Rr  j  j  h`hcj  j  jT  j
  hhhhj  j  j?  j  hhhkjI  jL  j  j  X   Tokenr  h]j  j  jS  jV  ubh:h=hRhUhBhEhJhMhhh"h%h2h5hhh*h-hhububX    r  r  jL  X   % Copyright 2005 Brian Alliet
r  r  j  X   
r  r  hX   \documentclassr  r  hX   [11pt]r  r  j9  X   {r  r  j  X   articler  r  j9  X   }r  r  j  j  r  hX   \usepackager  r  j9  j  r  j  X   palatinor  r  j9  j  r  j  j  r  hX   \usepackager  r  j9  j  r  j  X   fullpager  r  j9  j  r  j  j  r  hX   \usepackager  r  j9  j  r  j  X   parskipr  r  j9  j  r  j  j  r  hX   \usepackager  r  j9  j  r  j  X   lhsr  r  j9  j  r  j  X   

r  r  hX   \beginr  r  j9  j  r  j  X   documentr  r  j9  j  r  j  X   

r  r  hX   \titler  r  j9  j  r  j  X
   Sudoku Solverr  r  j9  j  r  j  j  r  hX   \authorr  r  j9  j  r  j  X   Brian Allietr  r  j9  j  r  j  j  r  hX
   \maketitler  r  j  X   

r  r   hX   \ignorer  r  j9  j  r  j  j  r  hX   \beginr  r  j9  j  r  j  X   coder  r	  j9  j  r
  j  j  r  hX   moduler  r
  j  X    r  r  j  X   Sudokur  r  j  j  r  j  X   (r  r  j  X   
    r  r  h%X   Sudokur  r  j  X   ,r  r  j  X   
    r  r  jg  X
   makeSudokur  r  j  j  r  j  j  r   jg  X   solver!  r"  j  j  r#  j  j  r$  jg  X	   eliminater%  r&  j  j  r'  j  j  r(  jg  X   analyzer)  r*  j  j  r+  j  j  r,  jg  X	   backtrackr-  r.  j  j  r/  j  X   
    r0  r1  jg  X   mainr2  r3  j  X   
    r4  r5  j  X   )r6  r7  j  j  r8  hX   wherer9  r:  j  X   

r;  r<  hX   importr=  r>  j  j  r?  j  X   Arrayr@  rA  j  j  rB  hX   importrC  rD  j  j  rE  j  X   MonadrF  rG  j  j  rH  hX   importrI  rJ  j  j  rK  j  X   ListrL  rM  j  j  rN  j  j  rO  jg  X   unionrP  rQ  j  j  rR  jg  X   intersperserS  rT  j  j  rU  jg  X	   transposerV  rW  j  j  rX  j  j  rY  hkX   \\rZ  r[  j  j6  r\  j  j  r]  jg  X   nubr^  r_  j  j  r`  jg  X   nubByra  rb  j  j6  rc  j  j  rd  hX   \endre  rf  j9  j  rg  j  X   coderh  ri  j9  j  rj  j  j  rk  j9  j  rl  j  X   

rm  rn  hX   \sectionro  rp  j9  j  rq  j  X   Introductionrr  rs  j9  j  rt  j  X5   

This Haskell module implements a solver for Sudoku~ru  rv  hX	   \footnoterw  rx  j9  j  ry  j  X#   http://en.wikipedia.org/wiki/Sudokurz  r{  j9  j  r|  j  XQ    puzzles. It can solve
any Sudoku puzzle, even those that require backtracking.

r}  r~  hX   \sectionr  r  j9  j  r  j  X
   Data Typesr  r  j9  j  r  j  X   

r  r  hX   \beginr  r  j9  j  r  j  X   coder  r  j9  j  r  j  j  r  j  j  r  hX   datar  r  j  j  r  h%X	   CellStater  r  j  j  r  hX   ar  r  j  j  r  hxX   =r  r  j  j  r  h%X   Knownr  r  j  j  r  hj  r  j  j  r  hkX   |r  r  j  j  r  h%X   Unknownr  r  j  j  r  j  X   [r  r  hj  r  j  X   ]r  r  j  j  r  hkj  r  j  j  r  h%X
   Impossibler  r  j  j  r  hX   derivingr  r  j  j  r  h%X   Eqr  r  j  j  r  hX   \endr  r  j9  j  r  j  X   coder  r  j9  j  r  j  Xf   

Each cell in a Sudoku grid can be in one of three states: ``Known'' if it has a known correct value~r  r  hX	   \footnoter  r  j9  j  r  j  Xw   Actually
this doesn't always means it is correct. While we are in the backtracking stage we make our guesses ``Known''.r  r  j9  j  r  j  X   ,
``Unknown'' if there is still more than one possible correct value, or ``Impossible'' if there is no value that can
possibly fit the cell. Sudoku grids with ``Impossible'' cells are quickly discarded by the r  r  j9  j  r  hX   \ttr  r  j  X    solver  r  j9  j  r  j  X    function.

r  r  hX   \beginr  r  j9  j  r  j  X   coder  r  j9  j  r  j  j  r  j  j  r  hX   typer  r  j  j  r  h%X   Coordsr  r  j  j  r  hxj  r  j  j  r  j  j  r  h%X   Intr  r  j  j  r  h%X   Intr  r  j  j6  r  j  j  r  hX   typer  r  j  j  r  h%X   Gridr  r  j  j  r  hj  r  j  j  r  hxj  r  j  j  r  h%X   Arrayr  r  j  j  r  h%X   Coordsr  r  j  j  r  j  j  r  h%X	   CellStater  r  j  j  r  hj  r  j  j6  r  j  j  r  hX   newtyper  r  j  j  r   h%X   Sudokur  r  j  j  r  hj  r  j  j  r  hxj  r  j  j  r  h%X   Sudokur  r	  j  j  r
  j  j  r  j  j  r  hX   unSudokur
  r  j  j  r  hxX   ::r  r  j  j  r  h%X   Gridr  r  j  j  r  hj  r  j  j  r  j  j  r  j  j  r  hX   derivingr  r  j  j  r  h%X   Eqr  r  j  j  r  hX   \endr   r!  j9  j  r"  j  X   coder#  r$  j9  j  r%  j  X   

We represent a Sudoku grid as an Array indexed by integer coordinates. We additionally define a newtype wrapper for the
grid. The smart constructor, r&  r'  j9  j  r(  hX   \ttr)  r*  j  X    makeSudokur+  r,  j9  j  r-  j  Xv    verifies some invariants before creating the Sudoku value. All the public
API functions operate on the Sudoku type.

r.  r/  hX   \beginr0  r1  j9  j  r2  j  X   coder3  r4  j9  j  r5  j  j  r6  j  j  r7  hX   instancer8  r9  j  j  r:  h%X   Showr;  r<  j  j  r=  hj  r>  j  j  r?  hxX   =>r@  rA  j  j  rB  h%X   ShowrC  rD  j  j  rE  j  j  rF  h%X   SudokurG  rH  j  j  rI  hj  rJ  j  j6  rK  j  j  rL  hX   whererM  rN  j  j  rO  hX	   showsPrecrP  rQ  j  j  rR  hX   prS  rT  j  j  rU  hxj  rV  j  j  rW  hX	   showParenrX  rY  j  j  rZ  j  j  r[  hjS  r\  hkX   >r]  r^  j  X   0r_  r`  j  j6  ra  j  j  rb  hkX   .rc  rd  j  j  re  hX	   showsGridrf  rg  j  j  rh  hkjc  ri  j  j  rj  hX   unSudokurk  rl  j  j  rm  hX   instancern  ro  j  j  rp  h%X   Showrq  rr  j  j  rs  hj  rt  j  j  ru  hxX   =>rv  rw  j  j  rx  h%X   Showry  rz  j  j  r{  j  j  r|  h%X	   CellStater}  r~  j  j  r  hj  r  j  j6  r  j  j  r  hX   wherer  r  j  j  r  hX	   showsPrecr  r  j  j  r  hX   _r  r  j  j  r  hxj  r  j  j  r  hX	   showsCellr  r  j  j  r  hX   \endr  r  j9  j  r  j  X   coder  r  j9  j  r  j  X   

We define r  r  j9  j  r  hX   \ttr  r  j  X    Showr  r  j9  j  r  j  X!    instances for the above types.

r  r  hX   \sectionr  r  j9  j  r  j  X   Internal Functionsr  r  j9  j  r  j  X   

r  r  hX   \beginr  r  j9  j  r  j  X   coder  r  j9  j  r  j  j  r  j  j  r  jg  X   sizer  r  j  j  r  hxX   ::r  r  j  j  r  h%X   Gridr  r  j  j  r  hj  r  j  j  r  hxX   ->r  r  j  j  r  h%X   Intr  r  j  j  r  jg  X   sizer  r  j  j  r  hxj  r  j  j  r  j  j  r  hkX   +r  r  j  X   1r  r  j  j6  r  hkjc  r  hX   fstr  r  hkjc  r  hX   sndr  r  hkjc  r  hX   boundsr  r  j  j  r  hX   \endr  r  j9  j  r  j  X   coder  r  j9  j  r  j  X   

r  r  j9  j  r  hX   \ttr  r  j  X    sizer  r  j9  j  r  j  X    returns the size (the width, height, and number of subboxes) for a Sudoku grid. We ensure Grid's are always
square and indexed starting at r  r  j  X   $r  r  hkj  r  jV  j_  r  j9  j  r  jV  j_  r  hkj6  r  j  j  r  j  XH    so simply incrementing either of the array's upper bounds is correct.

r  r  hX   \beginr  r  j9  j  r  j  X   coder  r  j9  j  r  j  j  r  j  j  r  jg  X   getRowr  r  j  j  r  hX   getColr  r  j  j  r  hX   getBoxr  r   j  j  r  hxX   ::r  r  j  j  r  h%X   Gridr  r  j  j  r  hj  r  j  j  r	  hxX   ->r
  r  j  j  r  h%X   Intr
  r  j  j  r  hxX   ->r  r  j  j  r  j  j  r  j  j  r  h%X   Coordsr  r  j  j  r  h%X	   CellStater  r  j  j  r  hj  r  j  j6  r  j  j  r  j  j  r  jg  X   getRowr  r   j  j  r!  hX   gridr"  r#  j  j  r$  hX   rr%  r&  j  j  r'  hxj  r(  j  j  r)  j  j  r*  hX   letr+  r,  j  j  r-  hX   lr.  r/  j  j  r0  hxj  r1  j  j  r2  j  j  r3  hj%  r4  j  j  r5  hX   cr6  r7  j  j6  r8  j  j  r9  hX   inr:  r;  j  j  r<  j  j  r=  hj.  r>  j  j  r?  hX   gridr@  rA  hkX   !rB  rC  hj.  rD  j  j6  rE  hkj  rF  hj6  rG  j  j  rH  hxX   <-rI  rJ  j  j  rK  j  j  rL  j  j_  rM  hkX   ..rN  rO  hX   sizerP  rQ  j  j  rR  hX   gridrS  rT  j  j  rU  hkX   -rV  rW  j  j  rX  j  j  rY  j  j  rZ  j  j  r[  j  j  r\  jg  X   getColr]  r^  j  j  r_  hX   gridr`  ra  j  j  rb  hj6  rc  j  j  rd  hxj  re  j  j  rf  j  j  rg  hX   letrh  ri  j  j  rj  hj.  rk  j  j  rl  hxj  rm  j  j  rn  j  j  ro  hj%  rp  j  j  rq  hj6  rr  j  j6  rs  j  j  rt  hX   inru  rv  j  j  rw  j  j  rx  hj.  ry  j  j  rz  hX   gridr{  r|  hkjB  r}  hj.  r~  j  j6  r  hkj  r  hj%  r  j  j  r  hxX   <-r  r  j  j  r  j  j  r  j  j_  r  hkX   ..r  r  hX   sizer  r  j  j  r  hX   gridr  r  j  j  r  hkjV  r  j  j  r  j  j  r  j  j  r  j  j  r  j  j  r  jg  X   getBoxr  r  j  j  r  hX   gridr  r  j  j  r  hX   br  r  j  j  r  hxj  r  j  j  r  j  j  r  hX   letr  r  j  j  r  hj.  r  j  j  r  hxj  r  j  j  r  j  j  r  hj%  r  j  j  r  hj6  r  j  j6  r  j  j  r  hX   inr  r  j  j  r  j  j  r  hj.  r  j  j  r  hX   gridr  r  hkjB  r  hj.  r  j  j6  r  hkj  r  hj%  r  j  j  r  hxX   <-r  r  j  j  r  j  j  r  hX   boxRr  r  hkX   ..r  r  hX   boxRr  r  hkj  r  hX   boxNr  r  hkjV  r  j  j  r  j  j  r  j  j  r  hj6  r  j  j  r  hxX   <-r  r  j  j  r  j  j  r  hX   boxCr  r  hkX   ..r  r  hX   boxCr  r  hkj  r  hX   boxNr  r  hkjV  r  j  j  r  j  j  r  j  j  r  j  X   
    r  r  hX   wherer  r  j  X	   
        r  r  hX   boxNr  r  j  j  r  hxj  r  j  j  r  hX   intSqrtr  r  j  j  r  j  j  r  hX   sizer  r  j  j  r  hX   gridr  r  j  j6  r  j  X   ;r  r  j  j  r  hX   boxRr  r  j  j  r  hxj  r  j  j  r  hj  r  j  j  r  j  X   `r   r  hX   quotr  r  j  j   r  j  j  r  hX   boxNr  r  j  j  r  hkX   *r	  r
  j  j  r  hX   boxNr  r
  j  j  r  j  j  r  hX   boxCr  r  j  j  r  hxj  r  j  j  r  hj  r  j  j  r  j  j   r  hX   remr  r  j  j   r  j  X     r  r  hX   boxNr  r  j  j  r  hkj	  r   j  j  r!  hX   boxNr"  r#  j  X   

r$  r%  jg  X   getBoxOfr&  r'  j  j  r(  hxX   ::r)  r*  j  j  r+  h%X   Gridr,  r-  j  j  r.  hj  r/  j  j  r0  hxX   ->r1  r2  j  j  r3  h%X   Coordsr4  r5  j  j  r6  hxX   ->r7  r8  j  j  r9  j  j  r:  j  j  r;  h%X   Coordsr<  r=  j  j  r>  h%X	   CellStater?  r@  j  j  rA  hj  rB  j  j6  rC  j  j  rD  j  j  rE  jg  X   getBoxOfrF  rG  j  j  rH  hX   gridrI  rJ  j  j  rK  j  j  rL  hj%  rM  j  j  rN  hj6  rO  j  j6  rP  j  j  rQ  hxj  rR  j  j  rS  hX   gridrT  rU  j  j  rV  j  j   rW  hX   getBoxrX  rY  j  j   rZ  j  j  r[  j  j  r\  j  j  r]  hj%  r^  j  j  r_  j  j   r`  hX   quotra  rb  j  j   rc  j  j  rd  hX   boxNre  rf  j  j  rg  hkj	  rh  j  j  ri  hX   boxNrj  rk  j  j6  rl  j  j  rm  hkj  rn  j  j  ro  j  j  rp  hj6  rq  j  j  rr  j  j   rs  hX   quotrt  ru  j  j   rv  j  j  rw  hX   boxNrx  ry  j  j6  rz  j  j6  r{  j  X   
    r|  r}  hX   wherer~  r  j  j  r  hX   boxNr  r  j  j  r  hxj  r  j  j  r  hX   intSqrtr  r  j  j  r  j  j  r  hX   sizer  r  j  j  r  hX   gridr  r  j  j6  r  j  j  r  hX   \endr  r  j9  j  r  j  X   coder  r  j9  j  r  j  X   

r  r  j9  j  r  hX   \ttr  r  j  X    getRowr  r  j9  j  r  j  X   , r  r  j9  j  r  hX   \ttr  r  j  X    getColr  r  j9  j  r  j  X   , and r  r  j9  j  r  hX   \ttr  r  j  X    getBoxr  r  j9  j  r  j  XM    return the coordinates and values of the cell in row, column, or box
number r  r  j9  j  r  hX   \ttr  r  j  X    nr  r  j9  j  r  j  X   , r  r  j9  j  r  hX   \ttr  r  j  X    rr  r  j9  j  r  j  X   , or r  r  j9  j  r  hX   \ttr  r  j  X    br  r  j9  j  r  j  X   .

r  r  hX   \beginr  r  j9  j  r  j  X   coder  r  j9  j  r  j  j  r  j  j  r  jg  X   getNeighborsr  r  j  j  r  hxX   ::r  r  j  j  r  h%X   Eqr  r  j  j  r  hj  r  j  j  r  hxX   =>r  r  j  j  r  h%X   Gridr  r  j  j  r  hj  r  j  j  r  hxX   ->r  r  j  j  r  h%X   Coordsr  r  j  j  r  hxX   ->r  r  j  j  r  j  j  r  j  j  r  h%X   Coordsr  r  j  j  r  h%X	   CellStater  r  j  j  r  hj  r  j  j6  r  j  j  r  j  j  r  jg  X   getNeighborsr  r  j  j  r  hX   gridr  r  j  j  r  hj.  r  hkX   @r   r  j  j  r  hj%  r  j  j  r  hj6  r  j  j6  r  j  j  r  hxj  r  j  j  r	  hX   filterr
  r  j  j  r  j  j  r
  j  j  r  hkX   /=r  r  hj.  r  j  j6  r  hkjc  r  hX   fstr  r  j  j6  r  j  X    
                          r  r  hkj  r  j  j  r  hX   foldrr  r  j  j  r  j  j  r  hX   unionr  r   hkjc  r!  j  j  r"  hkj  r#  hX   gridr$  r%  j  j6  r&  j  j6  r'  j  j  r(  h%X   []r)  r*  j  X    
                          r+  r,  j  j  r-  j  j  r.  j  j   r/  hX   getRowr0  r1  j  j   r2  hj%  r3  j  j6  r4  j  j  r5  j  j  r6  j  j   r7  hX   getColr8  r9  j  j   r:  hj6  r;  j  j6  r<  j  j  r=  j  j  r>  j  j   r?  hX   getBoxOfr@  rA  j  j   rB  hj.  rC  j  j6  rD  j  j  rE  j  j  rF  hX   \endrG  rH  j9  j  rI  j  X   coderJ  rK  j9  j  rL  j  X   

rM  rN  j9  j  rO  hX   \ttrP  rQ  j  X
    getNeighborsrR  rS  j9  j  rT  j  XH    returns the coordinates and values of all the neighbors of this cell.

rU  rV  hX   \beginrW  rX  j9  j  rY  j  X   coderZ  r[  j9  j  r\  j  j  r]  j  j  r^  jg  X
   impossibler_  r`  j  j  ra  hxX   ::rb  rc  j  j  rd  h%X   Eqre  rf  j  j  rg  hj  rh  j  j  ri  hxX   =>rj  rk  j  j  rl  h%X   Gridrm  rn  j  j  ro  hj  rp  j  j  rq  hxX   ->rr  rs  j  j  rt  h%X   Coordsru  rv  j  j  rw  hxX   ->rx  ry  j  j  rz  j  j  r{  hj  r|  j  j  r}  j  j  r~  jg  X
   impossibler  r  j  j  r  hX   gridr  r  j  j  r  hj.  r  j  j  r  hxj  r  j  j  r  hX   mapr  r  j  j  r  hX   sndr  r  j  j  r  hkj  r  j  j  r  hX
   justKnownsr  r  j  j  r  hkj  r  j  j  r  hX   gridr  r  j  j  r  j  j   r  hX   getNeighborsr  r  j  j   r  j  j  r  hj.  r  j  j  r  hX   \endr  r  j9  j  r  j  X   coder  r  j9  j  r  j  X   

r  r  j9  j  r  hX   \ttr  r  j  X    impossibler  r  j9  j  r  j  X}    returns a list of impossible values for a given cell. The impossible values consist of the values any
``Known'' neighbors.

r  r  hX   \beginr  r  j9  j  r  j  X   coder  r  j9  j  r  j  j  r  j  j  r  jg  X   justUnknownsr  r  j  j  r  hxX   ::r  r  j  j  r  j  j  r  j  j  r  h%X   Coordsr  r  j  j  r  h%X	   CellStater  r  j  j  r  hj  r  j  j6  r  j  j  r  j  j  r  hxX   ->r  r  j  j  r  j  j  r  j  j  r  h%X   Coordsr  r  j  j  r  j  j  r  hj  r  j  j  r  j  j6  r  j  j  r  j  j  r  jg  X   justUnknownsr  r  j  j  r  hxj  r  j  j  r  hX   foldrr  r  j  j  r  j  j  r  jg  X   \r  r  hj6  r  j  j  r  hxX   ->r  r  j  j  r  hX   caser  r  j  j  r  hj6  r  j  j  r  hX   ofr  r  j  j  r  j  j  r  hjS  r  j  j  r  h%X   Unknownr  r  j  j  r  hX   xsr  r  j  j6  r  j  j  r  hxX   ->r  r  j  j  r  j  j  r  j  j  r  hjS  r  j  j  r 	  hX   xsr	  r	  j  j6  r	  h%X   :r	  r	  j  j6  r	  j  j  r	  j  j  r	  hj  r		  j  j  r
	  hxX   ->r	  r	  j  j  r
	  hX   idr	  r	  e(j  j6  r	  j  j  r	  h%X   []r	  r	  j  X   

r	  r	  jg  X
   justKnownsr	  r	  j  j  r	  hxX   ::r	  r	  j  j  r	  j  j  r	  j  j  r	  h%X   Coordsr	  r	  j  j  r 	  h%X	   CellStater!	  r"	  j  j  r#	  hj  r$	  j  j6  r%	  j  j  r&	  j  j  r'	  hxX   ->r(	  r)	  j  j  r*	  j  j  r+	  j  j  r,	  h%X   Coordsr-	  r.	  j  j  r/	  hj  r0	  j  j6  r1	  j  j  r2	  j  j  r3	  jg  X
   justKnownsr4	  r5	  j  j  r6	  hxj  r7	  j  j  r8	  hX   foldrr9	  r:	  j  j  r;	  j  j  r<	  jg  j  r=	  hj6  r>	  j  j  r?	  hxX   ->r@	  rA	  j  j  rB	  hX   caserC	  rD	  j  j  rE	  hj6  rF	  j  j  rG	  hX   ofrH	  rI	  j  j  rJ	  j  j  rK	  hjS  rL	  j  j  rM	  h%X   KnownrN	  rO	  j  j  rP	  hX   xrQ	  rR	  j  j6  rS	  j  j  rT	  hxX   ->rU	  rV	  j  j  rW	  j  j  rX	  j  j  rY	  hjS  rZ	  j  j  r[	  hjQ	  r\	  j  j6  r]	  h%j	  r^	  j  j6  r_	  j  j  r`	  j  j  ra	  hj  rb	  j  j  rc	  hxX   ->rd	  re	  j  j  rf	  hX   idrg	  rh	  j  j6  ri	  j  j  rj	  h%X   []rk	  rl	  j  j  rm	  hX   \endrn	  ro	  j9  j  rp	  j  X   coderq	  rr	  j9  j  rs	  j  X   

rt	  ru	  j9  j  rv	  hX   \ttrw	  rx	  j  X
    justUnknownsry	  rz	  j9  j  r{	  j  X    and r|	  r}	  j9  j  r~	  hX   \ttr	  r	  j  X    justKnownsr	  r	  j9  j  r	  j  Xd    return only the Known or Unknown values (with the constructor stripped off)
from a list of cells.

r	  r	  hX   \beginr	  r	  j9  j  r	  j  X   coder	  r	  j9  j  r	  j  j  r	  j  j  r	  jg  X
   updateGridr	  r	  j  j  r	  hxX   ::r	  r	  j  j  r	  h%X   Gridr	  r	  j  j  r	  hj  r	  j  j  r	  hxX   ->r	  r	  j  j  r	  j  j  r	  j  j  r	  h%X   Coordsr	  r	  j  j  r	  h%X	   CellStater	  r	  j  j  r	  hj  r	  j  j6  r	  j  j  r	  j  j  r	  hxX   ->r	  r	  j  j  r	  h%X   Mayber	  r	  j  j  r	  j  j  r	  h%X   Gridr	  r	  j  j  r	  hj  r	  j  j6  r	  j  j  r	  jg  X
   updateGridr	  r	  j  j  r	  hj  r	  j  j  r	  h%X   []r	  r	  j  j  r	  hxj  r	  j  j  r	  h%X   Nothingr	  r	  j  j  r	  jg  X
   updateGridr	  r	  j  j  r	  hX   gridr	  r	  j  j  r	  hX   xsr	  r	  j  j  r	  hxj  r	  j  j  r	  h%X   Justr	  r	  j  j  r	  hkj  r	  j  j  r	  hX   gridr	  r	  j  j  r	  hkX   //r	  r	  j  j  r	  hX   nubByr	  r	  j  j  r	  j  j  r	  jg  j  r	  j  j  r	  hjQ	  r	  j  j  r	  hj  r	  j  j6  r	  j  j  r	  j  j  r	  hX   yr	  r	  j  j  r	  hj  r	  j  j6  r	  j  j  r	  hxX   ->r	  r	  j  j  r	  hjQ	  r	  hkX   ==r	  r	  hj	  r	  j  j6  r	  j  j  r	  hX   xsr	  r	  j  j  r	  hX   \endr	  r	  j9  j  r	  j  X   coder	  r	  j9  j  r	  j  X   

r	  r	  j9  j  r	  hX   \ttr	  r 
  j  X    updateGridr
  r
  j9  j  r
  j  XV    applies a set of updates to a grid and returns the new grid only if it was updated.

r
  r
  hX   \sectionr
  r
  j9  j  r
  j  X
   Public APIr	
  r

  j9  j  r
  j  X   

r
  r
  hX   \beginr
  r
  j9  j  r
  j  X   coder
  r
  j9  j  r
  j  j  r
  j  j  r
  jg  X
   makeSudokur
  r
  j  j  r
  hxX   ::r
  r
  j  j  r
  j  j  r
  h%X   Numr
  r
  j  j  r
  hj  r 
  j  j  r!
  j  j  r"
  h%X   Ordr#
  r$
  j  j  r%
  hj  r&
  j  j  r'
  j  j  r(
  h%X   Enumr)
  r*
  j  j  r+
  hj  r,
  j  j6  r-
  j  j  r.
  hxX   =>r/
  r0
  j  j  r1
  j  j  r2
  j  j  r3
  hj  r4
  j  j  r5
  j  j  r6
  j  j  r7
  hxX   ->r8
  r9
  j  j  r:
  h%X   Sudokur;
  r<
  j  j  r=
  hj  r>
  j  j  r?
  jg  X
   makeSudokur@
  rA
  j  j  rB
  hX   xsrC
  rD
  j  X   
    rE
  rF
  hkj  rG
  j  j  rH
  hX   notrI
  rJ
  j  j  rK
  j  j  rL
  hX   allrM
  rN
  j  j  rO
  j  j  rP
  j  j  rQ
  hkX   ==rR
  rS
  hX   sizerT
  rU
  j  j6  rV
  hkjc  rW
  hX   lengthrX
  rY
  j  j6  rZ
  j  j  r[
  hX   xsr\
  r]
  j  j6  r^
  j  j  r_
  hxj  r`
  j  j  ra
  hX   errorrb
  rc
  j  j  rd
  j  X   "re
  rf
  j  X   error not a squarerg
  rh
  j  je
  ri
  j  X   
    rj
  rk
  hkj  rl
  j  j  rm
  j  j  rn
  hX   intSqrtro
  rp
  j  j  rq
  hX   sizerr
  rs
  j  j6  rt
  hkX   ^ru
  rv
  j  j  rw
  j  X   2rx
  ry
  hxX   ::rz
  r{
  h%X   Intr|
  r}
  j  j6  r~
  j  j  r
  hkX   /=r
  r
  j  j  r
  hX   sizer
  r
  j  j  r
  hxj  r
  j  j  r
  hX   errorr
  r
  j  j  r
  j  je
  r
  j  X!   error dims aren't perfect squaresr
  r
  j  je
  r
  j  X   
    r
  r
  hkj  r
  j  j  r
  hX   anyr
  r
  j  j  r
  j  j  r
  jg  j  r
  hjQ	  r
  j  j  r
  hxX   ->r
  r
  j  j  r
  hjQ	  r
  j  j  r
  hkX   <r
  r
  j  j  r
  j  j_  r
  j  j  r
  hkX   ||r
  r
  j  j  r
  hjQ	  r
  j  j  r
  hkj]  r
  j  j  r
  hX   fromIntegralr
  r
  j  j  r
  hX   sizer
  r
  j  j6  r
  j  j  r
  j  j  r
  hX   concatr
  r
  j  j  r
  hX   xsr
  r
  j  j6  r
  j  j  r
  hxj  r
  j  j  r
  hX   errorr
  r
  j  j  r
  j  je
  r
  j  X   value out of ranger
  r
  j  je
  r
  j  X   
    r
  r
  hkj  r
  j  j  r
  hX	   otherwiser
  r
  j  j  r
  hxj  r
  j  j  r
  h%X   Sudokur
  r
  j  j  r
  j  j  r
  hX	   listArrayr
  r
  j  j  r
  j  j  r
  j  j  r
  j  j_  r
  j  j  r
  j  j_  r
  j  j6  r
  j  j  r
  j  j  r
  hX   sizer
  r
  hkjV  r
  j  j  r
  j  j  r
  hX   sizer
  r
  hkjV  r
  j  j  r
  j  j6  r
  j  j6  r
  j  j  r
  hX   statesr
  r
  j  j6  r
  j  X   
    r
  r
  hX   wherer
  r
  j  X	   
        r
  r
  hX   sizer
  r
  j  j  r
  hxj  r
  j  j  r
  hX   lengthr
  r
  j  j  r
  hX   xsr
  r
  j  X	   
        r
  r
  hX   statesr
  r
  j  j  r
  hxj  r
  j  j  r   hX   mapr  r  j  j  r  hX   fr  r  j  j  r  j  j  r  hX   concatr  r	  j  j  r
  hX   xsr  r  j  j6  r
  j  X	   
        r  r  hj  r  j  j  r  j  j_  r  j  j  r  hxj  r  j  j  r  h%X   Unknownr  r  j  j  r  j  j  r  j  j  r  hkX   ..r  r  hX   fromIntegralr  r  j  j  r  hX   sizer   r!  j  j  r"  j  X	   
        r#  r$  hj  r%  j  j  r&  hjQ	  r'  j  j  r(  hxj  r)  j  j  r*  h%X   Knownr+  r,  j  j  r-  hjQ	  r.  j  j  r/  hX   \endr0  r1  j9  j  r2  j  X   coder3  r4  j9  j  r5  j  X   

r6  r7  j9  j  r8  hX   \ttr9  r:  j  X    makeSudokur;  r<  j9  j  r=  j  X	    makes a r>  r?  j9  j  r@  hX   \ttrA  rB  j  X    SudokurC  rD  j9  j  rE  j  X    value from a list of numbers. The given matrix must be square and have dimensions
that are a perfect square. The possible values for each cell range from 1 to the dimension of the square with ``0''
representing unknown values.rF  rG  hX	   \footnoterH  rI  j9  j  rJ  j  X   The rest of the code doesn't depend on any of this weird ``0'' is unknown
representation. In fact, it doesn't depend on numeric values at all. ``0'' is just used here because it makes
representing grids in Haskell source code easier.rK  rL  j9  j  rM  j  X   

rN  rO  hX   \beginrP  rQ  j9  j  rR  j  X   coderS  rT  j9  j  rU  j  j  rV  j  j  rW  jg  X	   eliminaterX  rY  j  j  rZ  hxX   ::r[  r\  j  j  r]  h%X   Eqr^  r_  j  j  r`  hj  ra  j  j  rb  hxX   =>rc  rd  j  j  re  h%X   Sudokurf  rg  j  j  rh  hj  ri  j  j  rj  hxX   ->rk  rl  j  j  rm  h%X   Maybern  ro  j  j  rp  j  j  rq  h%X   Sudokurr  rs  j  j  rt  hj  ru  j  j6  rv  j  j  rw  jg  X	   eliminaterx  ry  j  j  rz  j  j  r{  h%X   Sudokur|  r}  j  j  r~  hX   gridr  r  j  j6  r  j  j  r  hxj  r  j  j  r  hX   fmapr  r  j  j  r  h%X   Sudokur  r  j  j  r  hkj  r  j  j  r  hX
   updateGridr  r  j  j  r  hX   gridr  r  j  j  r  hX   changesr  r  j  j  r  hkX   >>=r  r  j  j  r  hX   sanitizer  r  j  X   
    r  r  hX   wherer  r  j  X	   
        r  r  hX   changesr  r  j  j  r  hxj  r  j  j  r  hX	   concatMapr  r  j  j  r  hX
   findChanger  r  j  j  r  hkj  r  j  j  r  hX   assocsr  r  j  j  r  hX   gridr  r  j  X	   
        r  r  hX
   findChanger  r  j  j  r  j  j  r  hj.  r  j  j  r  h%X   Unknownr  r  j  j  r  hX   xsr  r  j  j6  r  j  X    
            r  r  hxj  r  j  j  r  hX   mapr  r  j  j  r  j  j  r  j  j  r  j  j  r  j  j6  r  j  j  r  hj.  r  j  j6  r  j  X    
            r  r  hkj  r  j  j  r  hX   caser  r  j  j  r  hX   filterr  r  j  j  r  j  j  r  hX   notr  r  hkjc  r  j  j  r  j  j   r  hX   elemr  r  j  j   r  hX
   impossibler  r  j  j  r  hX   gridr  r  j  j  r  hj.  r  j  j6  r  j  j6  r  j  j  r  hX   xsr  r  j  j  r  hX   ofr  r  j  X   
                r  r  h%X   []r  r  j  j  r  hxX   ->r  r  j  j  r  hX   returnr  r  j  j  r  h%X
   Impossibler  r  j  X   
                r  r  j  j  r   hjQ	  r  j  j  r  j  j  r  hxX   ->r  r  j  j  r  hX   returnr  r  j  j  r	  hkj  r
  j  j  r  h%X   Knownr  r
  j  j  r  hjQ	  r  j  X   
                r  r  hX   xs'r  r  j  X   
                    r  r  hkj  r  j  j  r  hX   xs'r  r  j  j  r  hkX   /=r  r  j  j  r  hX   xsr  r  j  j  r   hxX   ->r!  r"  j  j  r#  hX   returnr$  r%  j  j  r&  hkj  r'  j  j  r(  h%X   Unknownr)  r*  j  j  r+  hX   xs'r,  r-  j  X   
                    r.  r/  hkj  r0  j  j  r1  hX	   otherwiser2  r3  j  j  r4  hxX   ->r5  r6  j  j  r7  hX   mzeror8  r9  j  X	   
        r:  r;  hX
   findChanger<  r=  j  j  r>  hj  r?  j  j  r@  hxj  rA  j  j  rB  hX   mzerorC  rD  j  X	   
        rE  rF  hX   sanitizerG  rH  j  j  rI  hX   gridrJ  rK  j  j  rL  hxj  rM  j  j  rN  hX   returnrO  rP  j  j  rQ  hkj  rR  j  j  rS  hX   gridrT  rU  j  j  rV  hkX   //rW  rX  j  j  rY  j  j  rZ  j  j  r[  hj.  r\  j  j  r]  h%X
   Impossibler^  r_  j  j6  r`  j  j  ra  hkj  rb  j  X    
            rc  rd  j  j  re  hj.  rf  j  j  rg  hjQ	  rh  j  j6  ri  j  j  rj  hxX   <-rk  rl  j  j  rm  hX
   justKnownsrn  ro  j  j  rp  hX   changesrq  rr  j  j  rs  j  j  rt  hjQ	  ru  j  j  rv  j  j   rw  hX   elemrx  ry  j  j   rz  j  j  r{  hX
   impossibler|  r}  j  j  r~  hX   gridr  r  j  j  r  hj.  r  j  j  r  j  j  r  hX   \endr  r  j9  j  r  j  X   coder  r  j9  j  r  j  X   

The r  r  j9  j  r  hX   \ttr  r  j  X
    eliminater  r  j9  j  r  j  X   phase tries to remove possible choices for ``Unknowns'' based on ``Known'' values in the same row,
column, or box as the ``Unknown'' value. For each cell on the grid we find its ``neighbors'', that is, cells in the
same row, column, or box. Out of those neighbors we get a list of all the ``Known'' values. We can eliminate all of
these from our list of candidates for this cell. If we're lucky enough to eliminate all the candidates but one we have
a new ``Known'' value. If we're unlucky enough to have eliminates r  r  j9  j  r  hX   \bfr  r  j  X    allr  r  j9  j  r  j  X    the possible candidates we have a new
``Impossible'' value.

After iterating though every cell we make one more pass looking for conflicting changes. r  r  j9  j  r  hX   \ttr  r  j  X	    sanitizer  r  j9  j  r  j  XI    marks cells as
``Impossible'' if we have conflicting ``Known'' values.

r  r  hX   \beginr  r  j9  j  r  j  X   coder  r  j9  j  r  j  j  r  j  j  r  jg  X   analyzer  r  j  j  r  hxX   ::r  r  j  j  r  h%X   Eqr  r  j  j  r  hj  r  j  j  r  hxX   =>r  r  j  j  r  h%X   Sudokur  r  j  j  r  hj  r  j  j  r  hxX   ->r  r  j  j  r  h%X   Mayber  r  j  j  r  j  j  r  h%X   Sudokur  r  j  j  r  hj  r  j  j6  r  j  j  r  jg  X   analyzer  r  j  j  r  j  j  r  h%X   Sudokur  r  j  j  r  hX   gridr  r  j  j6  r  j  j  r  hxj  r  j  j  r  hX   fmapr  r  j  j  r  h%X   Sudokur  r  j  j  r  hkj  r  j  j  r  hX
   updateGridr  r  j  j  r  hX   gridr  r  j  j  r  hkj  r  j  j  r  hX   nubr  r  j  j  r  j  j  r  hX   ur  r  j  j  r  hkj  r  j  X
   
            r  r  hj  r  j  j  r  hxX   <-r  r  j  j  r  hX   mapr  r  j  j  r  j  j  r  hkj  r  hX   gridr  r  j  j6  r 
  j  j  r
  j  j  r
  hX   getRowr
  r
  j  j  r
  hX   getColr
  r
  j  j  r
  hX   getBoxr	
  r

  j  j  r
  j  j  r
  j  X
   
            r

  r
  hX   nr
  r
  j  j  r
  hxX   <-r
  r
  j  j  r
  j  j  r
  j  j_  r
  hkX   ..r
  r
  hX   sizer
  r
  j  j  r
  hX   gridr
  r
  j  j  r
  hkjV  r
  j  j  r 
  j  j  r!
  j  j  r"
  j  j  r#
  j  X
   
            r$
  r%
  hj  r&
  j  j  r'
  hxX   <-r(
  r)
  j  j  r*
  hX   uniquer+
  r,
  j  j  r-
  j  j  r.
  hj  r/
  j  j  r0
  hj
  r1
  j  j6  r2
  j  j  r3
  j  X   
    r4
  r5
  hX   wherer6
  r7
  j  X	   
        r8
  r9
  hX   uniquer:
  r;
  j  j  r<
  hX   xsr=
  r>
  j  j  r?
  hxj  r@
  j  j  rA
  hX   foldrrB
  rC
  j  j  rD
  hj  rE
  j  j  rF
  h%X   []rG
  rH
  j  j  rI
  hkj  rJ
  j  j  rK
  hX   foldrrL
  rM
  j  j  rN
  j  j  rO
  hX   unionrP
  rQ
  hkjc  rR
  hX   sndrS
  rT
  j  j6  rU
  j  j  rV
  h%X   []rW
  rX
  j  j  rY
  hX   unknownsrZ
  r[
  j  j  r\
  hkX   \\r]
  r^
  j  j  r_
  hX   mapr`
  ra
  j  j  rb
  hX   sndrc
  rd
  j  j  re
  j  j  rf
  hX
   justKnownsrg
  rh
  j  j  ri
  hX   xsrj
  rk
  j  j6  rl
  j  X
   
            rm
  rn
  hX   wherero
  rp
  j  X   
                rq
  rr
  hX   unknownsrs
  rt
  j  j  ru
  hxj  rv
  j  j  rw
  hX   justUnknownsrx
  ry
  j  j  rz
  hX   xsr{
  r|
  j  X   
                r}
  r~
  hj  r
  j  j  r
  hj6  r
  j  j  r
  hxj  r
  j  j  r
  hX   caser
  r
  j  j  r
  hX   filterr
  r
  j  j  r
  j  j  r
  j  j  r
  hj6  r
  j  j   r
  hX   elemr
  r
  j  j   r
  j  j6  r
  hkjc  r
  hX   sndr
  r
  j  j6  r
  j  j  r
  hX   unknownsr
  r
  j  j  r
  hX   ofr
  r
  j  X   
                    r
  r
  j  j  r
  j  j  r
  hjS  r
  j  j  r
  hj  r
  j  j6  r
  j  j  r
  j  j  r
  hxX   ->r
  r
  j  j  r
  j  j  r
  j  j  r
  hjS  r
  j  j  r
  h%X   Knownr
  r
  j  j  r
  hj6  r
  j  j6  r
  h%j	  r
  j  j6  r
  j  X   
                    r
  r
  hj  r
  j  j  r
  hxX   ->r
  r
  j  j  r
  hX   idr
  r
  j  j  r
  hX   \endr
  r
  j9  j  r
  j  X   coder
  r
  j9  j  r
  j  X   

The r
  r
  j9  j  r
  hX   \ttr
  r
  j  X    analyzer
  r
  j9  j  r
  j  X    phase tries to turn ``Unknowns'' into ``Knowns'' when a certain ``Unknown'' is the only cell that
contains a value needed in a given row, column, or box. We apply each of the functions r
  r
  j9  j  r
  hX   \ttr
  r
  j  X    getRowr
  r
  j9  j  r
  j  X   , r
  r
  j9  j  r
  hX   \ttr
  r
  j  X    getColr
  r
  j9  j  r
  j  X   , and
r
  r
  j9  j  r
  hX   \ttr
  r
  j  X    getBoxr
  r
  j9  j  r
  j  X'    to all the indices on the grid, apply r
  r
  j9  j  r
  hX   \ttr
  r
  j  X    uniquer
  r
  j9  j  r
  j  X7    to each group, and update the array with the
results. r
  r
  j9  j  r
  hX   \ttr
  r
  j  X    uniquer
  r
  j9  j  r
  j  X    gets a list of all  the unknown cells in the group and finds all the unknown values in each of
those cells. Each of these values are iterated though looking for a value that is only contained in one cell. If such a
value is found the cell containing it must be that value.

r
  r
  hX   \beginr
  r
  j9  j  r
  j  X   coder
  r
  j9  j  r
  j  j  r
  j  j  r
  jg  X	   backtrackr
  r   j  j  r  hxX   ::r  r  j  j  r  j  j  r  h%X	   MonadPlusr  r  j  j  r  hX   mr	  r
  j  j  r  j  j  r  h%X   Eqr
  r  j  j  r  hj  r  j  j6  r  j  j  r  hxX   =>r  r  j  j  r  h%X   Sudokur  r  j  j  r  hj  r  j  j  r  hxX   ->r  r  j  j  r  hj	  r  j  j  r  j  j  r   h%X   Sudokur!  r"  j  j  r#  hj  r$  j  j6  r%  j  j  r&  jg  X	   backtrackr'  r(  j  j  r)  j  j  r*  h%X   Sudokur+  r,  j  j  r-  hX   gridr.  r/  j  j6  r0  j  j  r1  hxj  r2  j  j  r3  hX   caser4  r5  j  j  r6  j  j  r7  hX   justUnknownsr8  r9  j  j  r:  j  j  r;  hX   assocsr<  r=  j  j  r>  hX   gridr?  r@  j  j6  rA  j  j6  rB  j  j  rC  hX   ofrD  rE  j  X   
    rF  rG  h%X   []rH  rI  j  j  rJ  hxX   ->rK  rL  j  j  rM  hX   returnrN  rO  j  j  rP  hkj  rQ  j  j  rR  h%X   SudokurS  rT  j  j  rU  hX   gridrV  rW  j  X   
    rX  rY  j  j  rZ  j  j  r[  hjS  r\  e(j  j  r]  hX   xsr^  r_  j  j6  r`  h%j	  ra  hj  rb  j  j6  rc  j  j  rd  hxX   ->re  rf  j  j  rg  hX   msumrh  ri  j  j  rj  hkj  rk  j  j  rl  hX   maprm  rn  j  j  ro  j  j  rp  jg  j  rq  hjQ	  rr  j  j  rs  hxX   ->rt  ru  j  j  rv  hX   solverw  rx  j  j  ry  hkj  rz  j  j  r{  h%X   Sudokur|  r}  j  j  r~  hkj  r  j  j  r  hX   gridr  r  j  j  r  hkX   //r  r  j  j  r  j  j  r  j  j  r  hjS  r  j  j  r  h%X   Knownr  r  j  j  r  hjQ	  r  j  j6  r  j  j  r  j  j6  r  j  j  r  hX   xsr  r  j  j  r  hX   \endr  r  j9  j  r  j  X   coder  r  j9  j  r  j  X  

Sometimes the above two phases still aren't enough to solve a puzzle. For these rare puzzles backtracking is required.
We attempt to solve the puzzle by replacing the first ``Unknown'' value with each of the candidate values and solving
the resulting puzzles. Hopefully at least one of our choices will result in a solvable puzzle.

We could actually solve any puzzle using backtracking alone, although this would be very inefficient. The above
functions simplify most puzzles enough that the backtracking phase has to do hardly any work.

r  r  hX   \beginr  r  j9  j  r  j  X   coder  r  j9  j  r  j  j  r  j  j  r  jg  X   solver  r  j  j  r  hxX   ::r  r  j  j  r  j  j  r  h%X	   MonadPlusr  r  j  j  r  hj	  r  j  j  r  j  j  r  h%X   Eqr  r  j  j  r  hj  r  j  j6  r  j  j  r  hxX   =>r  r  j  j  r  h%X   Sudokur  r  j  j  r  hj  r  j  j  r  hxX   ->r  r  j  j  r  hj	  r  j  j  r  j  j  r  h%X   Sudokur  r  j  j  r  hj  r  j  j6  r  j  j  r  jg  X   solver  r  j  j  r  hX   sudokur  r  j  j  r  hxj  r  j  X    
    r  r  hX   caser  r  j  j  r  hX	   eliminater  r  j  j  r  hX   sudokur  r  j  j  r  hX   ofr  r  j  X	   
        r  r  h%X   Justr  r  j  j  r  hX   newr  r  j  X    
            r  r  hkj  r  j  j  r  hX   anyr  r  j  j  r  j  j  r  hkX   ==r  r  h%X
   Impossibler  r  j  j6  r  j  j  r  j  j  r  hX   elemsr  r  j  j  r  j  j  r  hX   unSudokur  r  j  j  r  hX   newr  r  j  j6  r   j  j6  r  hxX   ->r  r  j  j  r  hX   mzeror  r  j  X
   
            r  r  hkj  r	  j  j  r
  hX	   otherwiser  r  j  j  r
  hxX   ->r  r  j  j  r  hX   solver  r  j  j  r  hX   newr  r  j  X	   
        r  r  h%X   Nothingr  r  j  j  r  hxX   ->r  r  j  j  r  hX   caser  r  j  j  r   hX   analyzer!  r"  j  j  r#  hX   sudokur$  r%  j  j  r&  hX   ofr'  r(  j  X
   
            r)  r*  h%X   Justr+  r,  j  j  r-  hX   newr.  r/  j  j  r0  hxX   ->r1  r2  j  j  r3  hX   solver4  r5  j  j  r6  hX   newr7  r8  j  X
   
            r9  r:  h%X   Nothingr;  r<  j  j  r=  hxX   ->r>  r?  j  j  r@  hX	   backtrackrA  rB  j  j  rC  hX   sudokurD  rE  j  j  rF  hX   \endrG  rH  j9  j  rI  j  X   coderJ  rK  j9  j  rL  j  X   

rM  rN  j9  j  rO  hX   \ttrP  rQ  j  X    solverR  rS  j9  j  rT  j  X7    glues all the above phases together. First we run the rU  rV  j9  j  rW  hX   \ttrX  rY  j  X
    eliminaterZ  r[  j9  j  r\  j  XL    phase. If that found the puzzle  to
be unsolvable we abort immediately. If r]  r^  j9  j  r_  hX   \ttr`  ra  j  X
    eliminaterb  rc  j9  j  rd  j  X#    changed the grid we go though the re  rf  j9  j  rg  hX   \ttrh  ri  j  X
    eliminaterj  rk  j9  j  rl  j  X,    phase again
hoping to eliminate more. Once rm  rn  j9  j  ro  hX   \ttrp  rq  j  X
    eliminaterr  rs  j9  j  rt  j  X'    can do no more work we move on to the ru  rv  j9  j  rw  hX   \ttrx  ry  j  X    analyzerz  r{  j9  j  r|  j  XI    phase. If this
succeeds in doing some work we start over again with the r}  r~  j9  j  r  hX   \ttr  r  j  X
    eliminater  r  j9  j  r  j  X
    phase. Once r  r  j9  j  r  hX   \ttr  r  j  X    analyzer  r  j9  j  r  j  X    can do no more work
we have no choice but to resort to backtracking. (However in most cases backtracking won't actually do anything because
the puzzle is already solved.)

r  r  hX   \beginr  r  j9  j  r  j  X   coder  r  j9  j  r  j  j  r  j  j  r  jg  X	   showsCellr  r  j  j  r  hxX   ::r  r  j  j  r  h%X   Showr  r  j  j  r  hj  r  j  j  r  hxX   =>r  r  j  j  r  h%X	   CellStater  r  j  j  r  hj  r  j  j  r  hxX   ->r  r  j  j  r  h%X   ShowSr  r  j  j  r  jg  X	   showsCellr  r  j  j  r  j  j  r  h%X   Knownr  r  j  j  r  hjQ	  r  j  j6  r  j  j  r  hxj  r  j  j  r  hX   showsr  r  j  j  r  hjQ	  r  j  j  r  jg  X	   showsCellr  r  j  j  r  j  j  r  h%X
   Impossibler  r  j  j6  r  j  j  r  hxj  r  j  j  r  hX   showCharr  r  j  j  r  j  X   'X'r  r  j  j  r  jg  X	   showsCellr  r  j  j  r  j  j  r  h%X   Unknownr  r  j  j  r  hX   xsr  r  j  j6  r  j  j  r  hxj  r  j  j  r  jg  j  r  hX   restr  r  j  j  r  hxX   ->r  r  j  j  r  j  j  r  j  X   '('r  r  h%j	  r  j  j6  r  j  X    
                       r  r  hkj  r  j  j  r  hX   foldrr  r  j  j  r  hX   idr  r  j  j  r  j  j  r  j  X   ')'r  r  h%j	  r  hX   restr  r  j  j6  r  j  X   
                       r  r  hkj  r  j  j  r  hX   intersperser  r   j  j  r  j  j  r  hX   showCharr  r  j  j  r  j  X   ' 'r  r  j  j6  r  j  X   
                       r	  r
  hkj  r  j  j  r  hX   mapr
  r  j  j  r  hX   showsr  r  j  j  r  hX   xsr  r  j  j  r  hX   \endr  r  j9  j  r  j  X   coder  r  j9  j  r  j  X   

r  r  j9  j  r  hX   \ttr  r   j  X	    showCellr!  r"  j9  j  r#  j  X    shows a cell.

r$  r%  hX   \beginr&  r'  j9  j  r(  j  X   coder)  r*  j9  j  r+  j  j  r,  j  j  r-  jg  X	   showsGridr.  r/  j  j  r0  hxX   ::r1  r2  j  j  r3  h%X   Showr4  r5  j  j  r6  hj  r7  j  j  r8  hxX   =>r9  r:  j  j  r;  h%X   Gridr<  r=  j  j  r>  hj  r?  j  j  r@  hxX   ->rA  rB  j  j  rC  h%X   ShowSrD  rE  j  j  rF  jg  X	   showsGridrG  rH  j  j  rI  hX   gridrJ  rK  j  j  rL  hxj  rM  j  j  rN  hX
   showsTablerO  rP  j  j  rQ  j  j  rR  j  j  rS  hX   gridrT  rU  hkjB  rV  j  j  rW  hj%  rX  j  j  rY  hj6  rZ  j  j6  r[  j  j  r\  hkj  r]  j  j  r^  hj6  r_  j  j  r`  hxX   <-ra  rb  j  j  rc  j  j  rd  j  j_  re  hkX   ..rf  rg  hX   sizerh  ri  j  j  rj  hX   gridrk  rl  hkjV  rm  j  j  rn  j  j  ro  j  j  rp  j  j  rq  hkj  rr  j  j  rs  hj%  rt  j  j  ru  hxX   <-rv  rw  j  j  rx  j  j  ry  j  j_  rz  hkX   ..r{  r|  hX   sizer}  r~  j  j  r  hX   gridr  r  hkjV  r  j  j  r  j  j  r  j  j  r  j  j  r  hX   \endr  r  j9  j  r  j  X   coder  r  j9  j  r  j  X   

r  r  j9  j  r  hX   \ttr  r  j  X	    showGridr  r  j9  j  r  j  X    show a grid.

r  r  hX   \beginr  r  j9  j  r  j  X   coder  r  j9  j  r  j  j  r  j  j  r  ji  X&   -- FEATURE: This is pretty inefficientr  r  j  j  r  jg  X
   showsTabler  r  j  j  r  hxX   ::r  r  j  j  r  h%X   Showr  r  j  j  r  hj  r  j  j  r  hxX   =>r  r  j  j  r  j  j  r  j  j  r  hj  r  j  j  r  j  j  r  j  j  r  hxX   ->r  r  j  j  r  h%X   ShowSr  r  j  j  r  jg  X
   showsTabler  r  j  j  r  hX   xsr  r  j  j  r  hxj  r  j  j  r  j  j  r  hX   showCharr  r  j  j  r  j  X   'r  r  j  j  r  j  j
  r  j  j  r  j  j  r  hkjc  r  j  j6  r  j  j  r  hkj  r  j  j  r  hX
   showStringr  r  j  j  r  hkj  r  j  j  r  hX   unlinesr  r  j  j  r  hkj  r  j  j  r  hX   mapr  r  j  j  r  j  j  r  hX   concatr  r  j  j  r  hkjc  r  j  j  r  hX   intersperser  r  j  j  r  j  je
  r  j  j  r  j  je
  r  j  j6  r  j  j  r  hX   xs''r  r  j  X   
    r  r  hX   wherer  r  j  X	   
        r  r  hX   xs'r  r  j  j  r  hxj  r  j  j  r  j  j  r  hX   mapr  r  hkjc  r  hX   mapr  r   j  j6  r  j  j  r  hX   showr  r  j  j  r  hX   xsr  r  j  X	   
        r  r	  hX	   colWidthsr
  r  j  j  r  hxj  r
  j  j  r  hX   mapr  r  j  j  r  j  j  r  hX   maxr  r  j  j  r  j  jx
  r  j  j  r  hkjc  r  j  j  r  hX   maximumr  r  j  j  r  hkjc  r  j  j  r  hX   mapr  r   j  j  r!  hX   lengthr"  r#  j  j6  r$  j  j  r%  j  j  r&  hX	   transposer'  r(  j  j  r)  hX   xs'r*  r+  j  j6  r,  j  X	   
        r-  r.  hX   xs''r/  r0  j  j  r1  hxj  r2  j  j  r3  hX   mapr4  r5  j  j  r6  j  j  r7  hX   zipWithr8  r9  j  j  r:  j  j  r;  jg  j  r<  hj
  r=  j  j  r>  hX   sr?  r@  j  j  rA  hxX   ->rB  rC  j  j  rD  hj?  rE  j  j  rF  hkX   ++rG  rH  j  j  rI  j  j  rJ  hX	   replicaterK  rL  j  j  rM  j  j  rN  hj
  rO  j  j  rP  hkjV  rQ  j  j  rR  hX   lengthrS  rT  j  j  rU  hj?  rV  j  j6  rW  j  j  rX  j  X   ' 'rY  rZ  j  j6  r[  j  j6  r\  j  j  r]  hX	   colWidthsr^  r_  j  j6  r`  j  j  ra  hX   xs'rb  rc  j  j  rd  hX   \endre  rf  j9  j  rg  j  X   coderh  ri  j9  j  rj  j  X   

rk  rl  j9  j  rm  hX   \ttrn  ro  j  X    showsTablerp  rq  j9  j  rr  j  XP    shows a table (or matrix). Every column has the same width so things line up.

rs  rt  hX   \beginru  rv  j9  j  rw  j  X   coderx  ry  j9  j  rz  j  j  r{  j  j  r|  jg  X   intSqrtr}  r~  j  j  r  hxX   ::r  r  j  j  r  h%X   Integralr  r  j  j  r  hj  r  j  j  r  hxX   =>r  r  j  j  r  hj  r  j  j  r  hxX   ->r  r  j  j  r  hj  r  j  j  r  jg  X   intSqrtr  r  j  j  r  hj
  r  j  X   
    r  r  hkj  r  j  j  r  hj
  r  j  j  r  hkj
  r  j  j  r  j  j_  r  j  j  r  hxj  r  j  j  r  hX   errorr  r  j  j  r  j  je
  r  j  X   intSqrt: negative nr  r  j  je
  r  j  X   
    r  r  hkj  r  j  j  r  hX	   otherwiser  r  j  j  r  hxj  r  j  j  r  hj  r  j  j  r  hj
  r  j  X   
    r  r  hX   wherer  r  j  X	   
        r  r  hj  r  j  j  r  hjQ	  r  j  j  r  hxj  r  j  j  r  hX   ifr  r  j  j  r  hj	  r  j  j  r  hkj
  r  j  j  r  hjQ	  r  j  j  r  hX   thenr  r  j  j  r  hj  r  j  j  r  hj	  r  j  j  r  hX   elser  r  j  j  r  hjQ	  r  j  X
   
            r  r  hX   wherer  r  j  j  r  hj	  r  j  j  r  hxj  r  j  j  r  j  j  r  hjQ	  r  j  j  r  hkj  r  j  j  r  j  j  r  hj
  r  j  j  r  j  j   r  hX   quotr  r  j  j   r  j  j  r  hjQ	  r  j  j6  r  j  j6  r  j  j  r  j  j   r  hX   quotr  r  j  j   r  j  j  r  j  jx
  r  j  j  r  hX   \endr  r  j9  j  r  j  X   coder  r  j9  j  r  j  X   

r  r  j9  j  r  hX   \ttr  r   j  X    intSqrtr  r  j9  j  r  j  X;    is Newton`s Iteration for finding integral square roots.

r  r  hX   \ignorer  r  j9  j  r  j  j  r	  hX   \beginr
  r  j9  j  r  j  X   coder
  r  j9  j  r  j  j  r  j  j  r  jg  X   testr  r  j  j  r  hxX   ::r  r  j  j  r  h%X   Sudokur  r  j  j  r  h%X   Intr  r  j  j  r  jg  X   testr  r  j  j  r   hxj  r!  j  j  r"  hX
   makeSudokur#  r$  j  j  r%  j  j  r&  j  X   
    r'  r(  j  j  r)  j  j_  r*  j  j  r+  j  X   6r,  r-  j  j  r.  j  j_  r/  j  j  r0  j  j  r1  j  j  r2  j  j_  r3  j  j  r4  j  X   4r5  r6  j  j  r7  j  j_  r8  j  j  r9  j  X   5r:  r;  j  j  r<  j  j_  r=  j  j  r>  j  j  r?  j  X   
    r@  rA  j  j  rB  j  j_  rC  j  j  rD  j  j_  rE  j  j  rF  j  X   8rG  rH  j  j  rI  j  X   3rJ  rK  j  j  rL  j  j_  rM  j  j  rN  j  j:  rO  j  j  rP  j  j,  rQ  j  j  rR  j  j_  rS  j  j  rT  j  j_  rU  j  j  rV  j  j  rW  j  X   
    rX  rY  j  j  rZ  j  jx
  r[  j  j  r\  j  j_  r]  j  j  r^  j  j_  r_  j  j  r`  j  j_  ra  j  j  rb  j  j_  rc  j  j  rd  j  j_  re  j  j  rf  j  j_  rg  j  j  rh  j  j_  ri  j  j  rj  j  j  rk  j  j  rl  j  j  rm  j  X   
    rn  ro  j  j  rp  j  jG  rq  j  j  rr  j  j_  rs  j  j  rt  j  j_  ru  j  j  rv  j  j5  rw  j  j  rx  j  j_  ry  j  j  rz  j  X   7r{  r|  j  j  r}  j  j_  r~  j  j  r  j  j_  r  j  j  r  j  j,  r  j  j  r  j  j  r  j  X   
    r  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j,  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  jJ  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j  r  j  X   
    r  r  j  j  r  j  j{  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  X   9r  r  j  j  r  j  j_  r  j  j  r  j  j  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j5  r  j  j  r  j  j  r  j  X   
    r  r  j  j  r  j  j:  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  jx
  r  j  j  r  j  j  r  j  X   
    r  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j{  r  j  j  r  j  jx
  r  j  j  r  j  j_  r  j  j  r  j  j,  r  j  j  r  j  j  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j  r  j  X   
    r  r  j  j  r  j  j_  r  j  j  r  j  j5  r  j  j  r  j  j_  r  j  j  r  j  j:  r  j  j  r  j  j_  r  j  j  r  j  jG  r  j  j  r  j  j_  r  j  j  r  j  j{  r  j  j  r  j  j_  r  j  j  r  j  j  r  j  X   

r  r  jg  X   test2r  r  j  j  r  hxX   ::r  r  j  j  r  h%X   Sudokur  r  j  j  r  h%X   Intr  r   j  j  r  jg  X   test2r  r  j  j  r  hxj  r  j  j  r  hX
   makeSudokur  r  j  j  r	  j  j  r
  j  X   
    r  r  j  j  r
  j  j_  r  j  j  r  j  j{  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  jG  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j  r   j  X   
    r!  r"  j  j  r#  j  j_  r$  j  j  r%  j  j_  r&  j  j  r'  j  j_  r(  j  j  r)  j  jx
  r*  j  j  r+  j  j_  r,  j  j  r-  j  j5  r.  j  j  r/  j  j_  r0  j  j  r1  j  j_  r2  j  j  r3  j  j_  r4  j  j  r5  j  j  r6  j  X   
    r7  r8  j  j  r9  j  j_  r:  j  j  r;  j  j_  r<  j  j  r=  j  j,  r>  j  j  r?  j  j_  r@  j  j  rA  j  j_  rB  j  j  rC  j  j_  rD  j  j  rE  j  j_  rF  j  j  rG  j  jJ  rH  j  j  rI  j  j_  rJ  j  j  rK  j  j  rL  j  X   
    rM  rN  j  j  rO  j  j_  rP  j  j  rQ  j  j_  rR  j  j  rS  j  j_  rT  j  j  rU  j  j:  rV  j  j  rW  j  j_  rX  j  j  rY  j  j_  rZ  j  j  r[  j  j_  r\  e(j  j  r]  j  j_  r^  j  j  r_  j  j,  r`  j  j  ra  j  j  rb  j  X   
    rc  rd  j  j  re  j  j  rf  j  j  rg  j  j_  rh  j  j  ri  j  jG  rj  j  j  rk  j  j_  rl  j  j  rm  j  j_  rn  j  j  ro  j  jx
  rp  j  j  rq  j  j_  rr  j  j  rs  j  j5  rt  j  j  ru  j  j_  rv  j  j  rw  j  j  rx  j  X   
    ry  rz  j  j  r{  j  j_  r|  j  j  r}  j  j:  r~  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  jJ  r  j  j  r  j  j_  r  j  j  r  j  j  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j  r  j  X   
    r  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  jx
  r  j  j  r  j  j_  r  j  j  r  j  jG  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j,  r  j  j  r  j  j_  r  j  j  r  j  j  r  j  X   
    r  r  j  j  r  j  j_  r  j  j  r  j  j,  r  j  j  r  j  j_  r  j  j  r  j  j  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j{  r  j  j  r  j  j_  r  j  j  r  j  j  r  j  j  r  j  j  r  j  X   
    r  r  j  j  r  j  j5  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  jJ  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j  r  j  X   

r  r  jg  X	   testSmallr  r  j  j  r  hxX   ::r  r  j  j  r  h%X   Sudokur  r  j  j  r  h%X   Intr  r  j  j  r  jg  X	   testSmallr  r  j  j  r  hxj  r  j  j  r  hX
   makeSudokur  r  j  j  r  j  j  r  j  X   
    r  r  j  j  r  j  j  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j  r  j  X   
    r  r  j  j  r   j  j_  r  j  j  r  j  j_  r  j  j  r  j  jx
  r  j  j  r  j  j{  r  j  j  r  j  j5  r	  j  j  r
  j  j_  r  j  j  r  j  j_  r
  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j  r  j  X   
    r  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j:  r  j  j  r  j  j_  r  j  j  r   j  j_  r!  j  j  r"  j  j_  r#  j  j  r$  j  j_  r%  j  j  r&  j  j5  r'  j  j  r(  j  j  r)  j  X   
    r*  r+  j  j  r,  j  j_  r-  j  j  r.  j  jJ  r/  j  j  r0  j  j_  r1  j  j  r2  j  j_  r3  j  j  r4  j  j_  r5  j  j  r6  j  j_  r7  j  j  r8  j  j_  r9  j  j  r:  j  j_  r;  j  j  r<  j  j_  r=  j  j  r>  j  j  r?  j  X   
    r@  rA  j  j  rB  j  j{  rC  j  j  rD  j  j:  rE  j  j  rF  j  j_  rG  j  j  rH  j  j_  rI  j  j  rJ  j  j_  rK  j  j  rL  j  j_  rM  j  j  rN  j  j_  rO  j  j  rP  j  j_  rQ  j  j  rR  j  j_  rS  j  j  rT  j  j  rU  j  X   
    rV  rW  j  j  rX  j  j_  rY  j  j  rZ  j  j_  r[  j  j  r\  j  j_  r]  j  j  r^  j  j_  r_  j  j  r`  j  j_  ra  j  j  rb  j  j  rc  j  j  rd  j  j,  re  j  j  rf  j  j_  rg  j  j  rh  j  j_  ri  j  j  rj  j  j  rk  j  X   
    rl  rm  j  j  rn  j  j_  ro  j  j  rp  j  j5  rq  j  j  rr  j  j_  rs  j  j  rt  j  j_  ru  j  j  rv  j  j_  rw  j  j  rx  j  j,  ry  j  j  rz  j  j_  r{  j  j  r|  j  j_  r}  j  j  r~  j  j_  r  j  j  r  j  j  r  j  X   
    r  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j{  r  j  j  r  j  j  r  j  j  r  j  j  r  j  X   
    r  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j  r  j  j  r  j  j_  r  j  j  r  j  jJ  r  j  j  r  j  j_  r  j  j  r  j  j  r  j  X   

r  r  jg  X   testHardr  r  j  j  r  hxX   ::r  r  j  j  r  h%X   Sudokur  r  j  j  r  h%X   Intr  r  j  j  r  jg  X   testHardr  r  j  j  r  hxj  r  j  j  r  hX
   makeSudokur  r  j  j  r  j  j  r  j  X   
    r  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  jG  r  j  j  r  j  j_  r  j  j  r  j  jx
  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j  r  j  X   
    r  r  j  j  r  j  j:  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j  r  j  j  r  j  j  r  j  X   
    r  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j,  r  j  j  r  j  j_  r  j  j  r  j  j:  r  j  j  r  j  j_  r  j  j  r  j  jJ  r   j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j  r  j  X   
    r  r  j  j  r	  j  j_  r
  j  j  r  j  j_  r  j  j  r
  j  j  r  j  j  r  j  j_  r  j  j  r  j  j  r  j  j  r  j  j_  r  j  j  r  j  jG  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j  r  j  X   
    r  r  j  j  r  j  j  r   j  j  r!  j  j_  r"  j  j  r#  j  j_  r$  j  j  r%  j  j_  r&  j  j  r'  j  j_  r(  j  j  r)  j  j_  r*  j  j  r+  j  j_  r,  j  j  r-  j  j_  r.  j  j  r/  j  jx
  r0  j  j  r1  j  j  r2  j  X   
    r3  r4  j  j  r5  j  j_  r6  j  j  r7  j  j_  r8  j  j  r9  j  j_  r:  j  j  r;  j  j  r<  j  j  r=  j  j_  r>  j  j  r?  j  j{  r@  j  j  rA  j  j_  rB  j  j  rC  j  j_  rD  j  j  rE  j  j_  rF  j  j  rG  j  j  rH  j  X   
    rI  rJ  j  j  rK  j  j_  rL  j  j  rM  j  j,  rN  j  j  rO  j  j  rP  j  j  rQ  j  j_  rR  j  j  rS  j  jJ  rT  j  j  rU  j  j_  rV  j  j  rW  j  j{  rX  j  j  rY  j  jG  rZ  j  j  r[  j  j_  r\  j  j  r]  j  j  r^  j  X   
    r_  r`  j  j  ra  j  j_  rb  j  j  rc  j  j:  rd  j  j  re  j  j_  rf  j  j  rg  j  j_  rh  j  j  ri  j  j_  rj  j  j  rk  j  j_  rl  j  j  rm  j  j_  rn  j  j  ro  j  j5  rp  j  j  rq  j  j_  rr  j  j  rs  j  j  rt  j  X   
    ru  rv  j  j  rw  j  j_  rx  j  j  ry  j  j{  rz  j  j  r{  j  jx
  r|  j  j  r}  j  j_  r~  j  j  r  j  j5  r  j  j  r  j  j_  r  j  j  r  j  j  r  j  j  r  j  j:  r  j  j  r  j  j_  r  j  j  r  j  j  r  j  X   

r  r  jg  X	   testHard2r  r  j  j  r  hxX   ::r  r  j  j  r  h%X   Sudokur  r  j  j  r  h%X   Intr  r  j  j  r  jg  X	   testHard2r  r  j  j  r  hxj  r  j  j  r  hX
   makeSudokur  r  j  j  r  j  j  r  j  X   
    r  r  j  j  r  j  jJ  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  jx
  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j  r  j  X   
    r  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j:  r  j  j  r  j  j  r  j  X   
    r  r  j  j  r  j  j_  r  j  j  r  j  j{  r  j  j  r  j  j_  r  j  j  r  j  j  r  j  j  r  j  j_  r  j  j  r  j  j5  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j  r  j  X   
    r  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  jG  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j  r  j  X   
    r  r  j  j  r  j  j:  r  j  j  r  j  j_  r  j  j  r   j  j_  r  j  j  r  j  j_  r  j  j  r  j  j{  r  j  j  r  j  j_  r  j  j  r  j  j_  r	  j  j  r
  j  j_  r  j  j  r  j  j,  r
  j  j  r  j  j  r  j  X   
    r  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  jx
  r  j  j  r   j  j_  r!  j  j  r"  j  j_  r#  j  j  r$  j  j  r%  j  X   
    r&  r'  j  j  r(  j  j_  r)  j  j  r*  j  j_  r+  j  j  r,  j  j_  r-  j  j  r.  j  jJ  r/  j  j  r0  j  j_  r1  j  j  r2  j  j  r3  j  j  r4  j  j_  r5  j  j  r6  j  j5  r7  j  j  r8  j  j_  r9  j  j  r:  j  j  r;  j  X   
    r<  r=  j  j  r>  j  jG  r?  j  j  r@  j  j_  rA  j  j  rB  j  j_  rC  j  j  rD  j  j_  rE  j  j  rF  j  j_  rG  j  j  rH  j  j_  rI  j  j  rJ  j  j_  rK  j  j  rL  j  j_  rM  j  j  rN  j  j_  rO  j  j  rP  j  j  rQ  j  X   
    rR  rS  j  j  rT  j  j_  rU  j  j  rV  j  j_  rW  j  j  rX  j  j,  rY  j  j  rZ  j  j_  r[  j  j  r\  j  j_  r]  j  j  r^  j  j:  r_  j  j  r`  j  j_  ra  j  j  rb  j  j_  rc  j  j  rd  j  j{  re  j  j  rf  j  j  rg  j  X   

rh  ri  jg  X   testHWrj  rk  j  j  rl  hxX   ::rm  rn  j  j  ro  h%X   Sudokurp  rq  j  j  rr  h%X   Intrs  rt  j  j  ru  jg  X   testHWrv  rw  j  j  rx  hxj  ry  j  j  rz  hX
   makeSudokur{  r|  j  j  r}  j  j  r~  j  X   
    r  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j{  r  j  j  r  j  j_  r  j  j  r  j  jx
  r  j  j  r  j  j  r  j  X	       
    r  r  j  j  r  j  j_  r  j  j  r  j  jJ  r  j  j  r  j  j_  r  j  j  r  j  j  r  j  j  r  j  j:  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j  r  j  X   
    r  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  jx
  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  jJ  r  j  j  r  j  j  r  j  X   
    r  r  j  j  r  j  j:  r  j  j  r  j  j  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  jJ  r  j  j  r  j  j_  r  j  j  r  j  j  r  j  j  r  j  j  r  j  X   
    r  r  j  j  r  j  j_  r  j  j  r  j  jx
  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j{  r  j  j  r  j  j_  r  j  j  r  j  j  r  j  X   
    r  r  j  j  r  j  j{  r  j  j  r  j  j_  r  j  j  r  j  jJ  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j  r  j  j  r  j  jG  r   j  j  r  j  j  r  j  X   
    r  r  j  j  r  j  jG  r  j  j  r  j  j_  r  j  j  r	  j  j_  r
  j  j  r  j  jx
  r  j  j  r
  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j  r  j  X   
    r  r  j  j  r  j  j_  r  j  j  r  j  j_  r  j  j  r  j  j_  r   j  j  r!  j  j_  r"  j  j  r#  j  jG  r$  j  j  r%  j  j:  r&  j  j  r'  j  j_  r(  j  j  r)  j  j,  r*  j  j  r+  j  j_  r,  j  j  r-  j  j  r.  j  X   
    r/  r0  j  j  r1  j  j,  r2  j  j  r3  j  j_  r4  j  j  r5  j  j:  r6  j  j  r7  j  j_  r8  j  j  r9  j  j_  r:  j  j  r;  j  j  r<  j  j  r=  j  j_  r>  j  j  r?  j  j_  r@  j  j  rA  j  j_  rB  j  j  rC  j  j  rD  j  X   

rE  rF  jg  X	   testToughrG  rH  j  j  rI  hxX   ::rJ  rK  j  j  rL  h%X   SudokurM  rN  j  j  rO  h%X   IntrP  rQ  j  j  rR  jg  X	   testToughrS  rT  j  j  rU  hxj  rV  j  j  rW  hX
   makeSudokurX  rY  j  j  rZ  hkj  r[  j  j  r\  hX   mapr]  r^  j  j  r_  j  j  r`  hX   mapra  rb  j  j  rc  hX   readrd  re  j  j  rf  hkjc  rg  j  j  rh  hX   wordsri  rj  j  j6  rk  j  j  rl  hkj  rm  j  j  rn  hX   linesro  rp  j  j  rq  hkj  rr  j  X   
 rs  rt  j  je
  ru  j  X   8 3 0  0 0 0  0 4 6rv  rw  j  j  rx  j  j
  ry  j  je
  rz  hkX   ++r{  r|  j  X   
 r}  r~  j  je
  r  j  X   0 2 0  1 0 4  0 3 0r  r  j  j  r  j  j
  r  j  je
  r  hkX   ++r  r  j  X   
 r  r  j  je
  r  j  X   0 0 0  0 0 0  0 0 0r  r  j  j  r  j  j
  r  j  je
  r  hkX   ++r  r  j  X   
 r  r  j  je
  r  j  X   0 0 2  9 0 6  5 0 0r  r  j  j  r  j  j
  r  j  je
  r  hkX   ++r  r  j  X   
 r  r  j  je
  r  j  X   1 4 0  0 0 0  0 2 3r  r  j  j  r  j  j
  r  j  je
  r  hkX   ++r  r  e(j  X   
 r  r  j  je
  r  j  X   0 0 5  4 0 3  1 0 0r  r  j  j  r  j  j
  r  j  je
  r  hkX   ++r  r  j  X   
 r  r  j  je
  r  j  X   0 0 0  0 0 0  0 0 0r  r  j  j  r  j  j
  r  j  je
  r  hkX   ++r  r  j  X   
 r  r  j  je
  r  j  X   0 6 0  3 0 8  0 7 0r  r  j  j  r  j  j
  r  j  je
  r  hkX   ++r  r  j  X   
 r  r  j  je
  r  j  X   9 5 0  0 0 0  0 6 2r  r  j  j  r  j  j
  r  j  je
  r  j  X   

r  r  jg  X   testDiabolicalr  r  j  j  r  hxX   ::r  r  j  j  r  h%X   Sudokur  r  j  j  r  h%X   Intr  r  j  X    
r  r  jg  X   testDiabolicalr  r  j  j  r  hxj  r  j  j  r  hX
   makeSudokur  r  j  j  r  hkj  r  j  j  r  hX   mapr  r  j  j  r  j  j  r  hX   mapr  r  j  j  r  hX   readr  r  j  j  r  hkjc  r  j  j  r  hX   wordsr  r  j  j6  r  j  j  r  hkj  r  j  j  r  hX   linesr  r  j  j  r  hkj  r  j  X   
  r  r  j  je
  r  j  X   8 0 0  7 0 1  0 0 2r  r  j  j  r  j  j
  r   j  je
  r  hkX   ++r  r  j  X   
  r  r  j  je
  r  j  X   0 0 6  0 0 0  7 0 0r  r  j  j  r	  j  j
  r
  j  je
  r  hkX   ++r  r
  j  X   
  r  r  j  je
  r  j  X   0 1 7  0 0 0  8 9 0r  r  j  j  r  j  j
  r  j  je
  r  hkX   ++r  r  j  X   
  r  r  j  je
  r  j  X   0 0 0  1 7 3  0 0 0r  r  j  j  r  j  j
  r  j  je
  r  hkX   ++r   r!  j  X   
  r"  r#  j  je
  r$  j  X   7 0 0  0 0 0  0 0 6r%  r&  j  j  r'  j  j
  r(  j  je
  r)  hkX   ++r*  r+  j  X   
  r,  r-  j  je
  r.  j  X   0 0 0  9 5 6  0 0 0r/  r0  j  j  r1  j  j
  r2  j  je
  r3  hkX   ++r4  r5  j  X   
  r6  r7  j  je
  r8  j  X   0 9 5  0 0 0  4 1 0r9  r:  j  j  r;  j  j
  r<  j  je
  r=  hkX   ++r>  r?  j  X   
  r@  rA  j  je
  rB  j  X   0 0 8  0 0 0  5 0 0rC  rD  j  j  rE  j  j
  rF  j  je
  rG  hkX   ++rH  rI  j  X   
  rJ  rK  j  je
  rL  j  X   3 0 0  6 0 5  0 0 7rM  rN  j  j  rO  j  j
  rP  j  je
  rQ  j  X   

rR  rS  jg  X   mainrT  rU  j  j  rV  hxX   ::rW  rX  j  j  rY  h%X   IOrZ  r[  j  j  r\  j9  X   ()r]  r^  j  j  r_  jg  X   mainr`  ra  j  j  rb  hxj  rc  j  j  rd  hX   dore  rf  j  X   
    rg  rh  hX   letri  rj  j  X	   
        rk  rl  hX   solve'rm  rn  j  j  ro  hjS  rp  j  j  rq  hxj  rr  j  j  rs  hX   casert  ru  j  j  rv  hX   solverw  rx  j  j  ry  hjS  rz  j  j  r{  hX   ofr|  r}  j  X
   
            r~  r  h%X   []r  r  j  j  r  hxX   ->r  r  j  j  r  hX   failr  r  j  j  r  hkj  r  j  j  r  j  je
  r  j  X   couldn't solve: r  r  j  je
  r  j  j  r  hkX   ++r  r  j  j  r  hX   showr  r  j  j  r  hjS  r  j  X
   
            r  r  hX   solsr  r  j  j  r  hxX   ->r  r  j  j  r  hX   returnr  r  j  j  r  hX   solsr  r  j  X   
    r  r  hX   mapM_r  r  j  j  r  j  j  r  jg  j  r  hjS  r  j  j  r  hxX   ->r  r  j  j  r  hX   solve'r  r  j  j  r  hjS  r  j  j  r  hkX   >>=r  r  j  j  r  hX   putStrLnr  r  hkjc  r  hX   showr  r  j  j6  r  j  j  r  j  j  r  hX   testr  r  j  j  r  hX   test2r  r  j  j  r  hX	   testSmallr  r  j  j  r  hX   testHardr  r  j  j  r  hX	   testHard2r  r  j  j  r  hX   testHWr  r  j  j  r  hX	   testToughr  r  j  j  r  hX   testDiabolicalr  r  j  j  r  j  X   
    r  r  hX   returnr  r  j  j  r  j9  X   ()r  r  j  X   

r  r  hX   \endr  r  j9  j  r  j  X   coder  r  j9  j  r  j  j  r  j9  j  r  j  X   

r  r  hX   \endr  r  j9  j  r  j  X   documentr  r  j9  j  r  j  j  r  j  j  r  e.