/**
 * Options for `YamlFile`
 */
export interface YamlFileOptions {
    /**
     * The object that will be serialized. You can modify the object's contents
     * before synthesis.
     *
     * @default {} an empty object
     */
    readonly obj?: any;
}
export declare class YamlFile {
    /**
     * The path to the file that the object will be written to.
     */
    private readonly filePath;
    /**
      * The output object. This object can be mutated until the project is synthesized.
      */
    private obj;
    /**
     * A comment to be added to the top of the YAML file.
     *
     * Can be multiline. All non-empty line are pefixed with '# '. Empty lines are kept, but not
    */
    commentAtTop?: string;
    constructor(filePath: string, options?: YamlFileOptions);
    /**
     * Update the output object.
     */
    update(obj: any): void;
    /**
     * Returns the patched yaml file.
     */
    toYaml(): string;
    /**
     * Write the patched yaml file to the specified location.
     */
    writeFile(): void;
}
