import { Construct } from 'constructs';
import { JobData, ContainerOptions, JobDefaults, JobPermissions, JobStepData, JobStrategy } from './job-data';
export interface SecretsOptions {
    readonly referencedName: string;
    readonly secretName: string;
    readonly secretValue: string;
}
export interface JobStep extends JobStepData {
    readonly withSecrets?: SecretsOptions[];
}
export interface JobProps {
    readonly jobRefereneName?: string;
    readonly steps: JobStep[];
    readonly runsOn?: string | string[];
    readonly name?: string;
    readonly dependsOn?: Job[];
    readonly permissions?: JobPermissions;
    readonly environment?: unknown;
    readonly concurrency?: unknown;
    readonly strategy?: JobStrategy;
    readonly outputs?: Record<string, string>;
    readonly env?: Record<string, string>;
    readonly defaults?: JobDefaults;
    readonly runIf?: string;
    readonly timeoutMinutes?: number;
    readonly continueOnError?: boolean;
    readonly container?: ContainerOptions;
    readonly services?: Record<string, ContainerOptions>;
}
export declare class Job extends Construct {
    readonly id: string;
    readonly steps: JobStep[];
    readonly runsOn: string | string[];
    readonly dependsOn: string[];
    readonly permissions: JobPermissions;
    readonly timeoutMinutes: number;
    readonly name?: string;
    readonly environment?: unknown;
    readonly concurrency?: unknown;
    readonly strategy?: JobStrategy;
    readonly outputs?: Record<string, string>;
    readonly env?: Record<string, string>;
    readonly defaults?: JobDefaults;
    readonly runIf?: string;
    readonly continueOnError?: boolean;
    readonly container?: ContainerOptions;
    readonly services?: Record<string, ContainerOptions>;
    readonly secrets: SecretsOptions[];
    constructor(scope: Construct, id: string, props: JobProps);
    addDependency(job: Job): void;
    toObject(): JobData;
}
