from . import config as config, formatter as formatter
from _typeshed import Incomplete
from importlib.metadata import EntryPoint as EntryPoint
from pathlib import PurePath
from typing import Dict, Iterable, Mapping, Optional, Sequence, Union

logger: Incomplete

def iter_entry_points(group: str, name: Optional[str] = ...): ...
def load_plugin(module: str, force: bool = ..., *, cache: Dict = ...) -> Optional['Plugin']: ...
def get_names(group: str = ...) -> Iterable[str]: ...
def search_plugins(*modules: str, force: bool = ...): ...

class Plugin:
    formatters: Sequence[formatter.BaseFormatter]
    config_loaders: Sequence[config.ConfigFileLoader]
    configs: Sequence[Union[str, PurePath]]
    def __init__(self) -> None: ...
    def get_config(self): ...
    def add_arguments(self, parser) -> None: ...
    def parse_known_args(self, args, namespace): ...

class ProxyPlugin(Plugin):
    configs: Incomplete
    def __init__(self, original) -> None: ...

class PluginLoader:
    module: str
    entry_point: Optional[EntryPoint]
    @classmethod
    def from_entry_point(cls, ep: EntryPoint) -> PluginLoader: ...
    def load(self) -> Optional[Plugin]: ...
    def __init__(self, module, entry_point) -> None: ...

def get_plugin_loaders(group: str = ...) -> Mapping[str, PluginLoader]: ...
