from .client_transports import RPCClientTransport, RPCClientTransportRequest, RPCFeatures, RPCTarget, RPC_E2EE_Information
from .definition import RPCName, RPC_Definition, _RequestModel, _ResponseModel, _UploadModel
from .utils import LineSendStream
from anyio.streams.memory import MemoryObjectReceiveStream, MemoryObjectSendStream
from collections.abc import AsyncGenerator, Callable, Mapping
from dataclasses import dataclass
from typing import Generic
from typing_extensions import Self

__all__ = ['RequestCancelledByRPCServerError', 'RPCClient', 'OutgoingRPCRequest', 'FailUpload', 'RequestError', 'RequestSendTimeoutError']

@dataclass
class RPCClient:
    transport = ...
    def __init__(self, transport: RPCClientTransport, get_rpc_features_for_target: Callable[[RPCTarget, RPCName], RPCFeatures] | None = None) -> None: ...
    @classmethod
    async def create(cls, transport: RPCClientTransport | None = None, get_rpc_features_for_target: Callable[[RPCTarget, RPCName], RPCFeatures] | None = None) -> AsyncGenerator[Self, None]: ...
    async def start_new_request(self, rpc_definition: RPC_Definition[_RequestModel, _ResponseModel, _UploadModel], request_object: _RequestModel, target: RPCTarget, send_timeout: float = 60.0, request_published_callback: Callable[[bool], None] | None = None, request_delivered_callback: Callable[[], None] | None = None, log_event: Callable[[str], None] = ...) -> AsyncGenerator[OutgoingRPCRequest[_RequestModel, _ResponseModel, _UploadModel], None]: ...

@dataclass
class OutgoingRPCRequest(Generic[_RequestModel, _ResponseModel, _UploadModel]):
    rpc_definition: RPC_Definition[_RequestModel, _ResponseModel, _UploadModel]
    rpc_transport_request: RPCClientTransportRequest
    upload_line_send_stream: LineSendStream
    target: RPCTarget
    cookie_store: CookieStore
    request_delivered_callback: Callable[[], None] | None = ...
    log_event: Callable[[str], None] = ...
    received_data_messages: int = ...
    sent_data_messages: int = ...
    def get_base_url(self) -> str: ...
    def compression_used(self) -> str | None: ...
    def e2ee_information(self) -> RPC_E2EE_Information | None: ...
    def h2_multiplexing_used(self) -> bool: ...
    def real_rpc_name(self) -> RPCName: ...
    async def open_response(self) -> AsyncGenerator[MemoryObjectReceiveStream[_ResponseModel | RequestError], None]: ...
    async def consume_complete_response(self) -> list[_ResponseModel]: ...
    async def open_upload(self) -> AsyncGenerator[MemoryObjectSendStream[_UploadModel | FailUpload], None]: ...

@dataclass
class FailUpload:
    error_message: str

@dataclass
class CookieStore:
    def get_cookies_for_identity(self, target: RPCTarget) -> dict[str, str]: ...
    def update_cookies_for_identity(self, target: RPCTarget, cookies: Mapping[str, str | None]) -> None: ...

class RequestError(Exception): ...
class RequestSendTimeoutError(TimeoutError): ...

class RequestCancelledByRPCServerError(RequestError):
    def __init__(self) -> None: ...
