"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
function arrayDiff(oldValues, newValues) {
    const deletes = new Set(oldValues);
    const adds = new Set();
    for (const v of new Set(newValues)) {
        if (deletes.has(v)) {
            deletes.delete(v);
        }
        else {
            adds.add(v);
        }
    }
    return {
        adds: Array.from(adds),
        deletes: Array.from(deletes),
    };
}
exports.arrayDiff = arrayDiff;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZGlmZi5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImRpZmYudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQSxTQUFnQixTQUFTLENBQUMsU0FBbUIsRUFBRSxTQUFtQjtJQUNoRSxNQUFNLE9BQU8sR0FBRyxJQUFJLEdBQUcsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUNuQyxNQUFNLElBQUksR0FBRyxJQUFJLEdBQUcsRUFBVSxDQUFDO0lBRS9CLEtBQUssTUFBTSxDQUFDLElBQUksSUFBSSxHQUFHLENBQUMsU0FBUyxDQUFDLEVBQUU7UUFDbEMsSUFBSSxPQUFPLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQyxFQUFFO1lBQ2xCLE9BQU8sQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDLENBQUM7U0FDbkI7YUFBTTtZQUNMLElBQUksQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDLENBQUM7U0FDYjtLQUNGO0lBRUQsT0FBTztRQUNMLElBQUksRUFBRSxLQUFLLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQztRQUN0QixPQUFPLEVBQUUsS0FBSyxDQUFDLElBQUksQ0FBQyxPQUFPLENBQUM7S0FDN0IsQ0FBQztBQUNKLENBQUM7QUFoQkQsOEJBZ0JDIiwic291cmNlc0NvbnRlbnQiOlsiZXhwb3J0IGZ1bmN0aW9uIGFycmF5RGlmZihvbGRWYWx1ZXM6IHN0cmluZ1tdLCBuZXdWYWx1ZXM6IHN0cmluZ1tdKSB7XG4gIGNvbnN0IGRlbGV0ZXMgPSBuZXcgU2V0KG9sZFZhbHVlcyk7XG4gIGNvbnN0IGFkZHMgPSBuZXcgU2V0PHN0cmluZz4oKTtcblxuICBmb3IgKGNvbnN0IHYgb2YgbmV3IFNldChuZXdWYWx1ZXMpKSB7XG4gICAgaWYgKGRlbGV0ZXMuaGFzKHYpKSB7XG4gICAgICBkZWxldGVzLmRlbGV0ZSh2KTtcbiAgICB9IGVsc2Uge1xuICAgICAgYWRkcy5hZGQodik7XG4gICAgfVxuICB9XG5cbiAgcmV0dXJuIHtcbiAgICBhZGRzOiBBcnJheS5mcm9tKGFkZHMpLFxuICAgIGRlbGV0ZXM6IEFycmF5LmZyb20oZGVsZXRlcyksXG4gIH07XG59XG4iXX0=