"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
class MyStack extends core_1.Stack {
    constructor(scope, id) {
        super(scope, id);
        const tagName = new core_1.CfnParameter(this, 'PrincipalTag', { default: 'developer' });
        const stringEquals = new core_1.CfnJson(this, 'PrincipalTagCondition', {
            value: {
                [`aws:PrincipalTag/${tagName.valueAsString}`]: 'true',
            },
        });
        const principal = new lib_1.AccountRootPrincipal().withConditions({
            StringEquals: stringEquals,
        });
        new lib_1.Role(this, 'MyRole', { assumedBy: principal });
    }
}
const app = new core_1.App();
new MyStack(app, 'test-condition-with-ref');
app.synth();
//# sourceMappingURL=data:application/json;base64,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