"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@aws-cdk/core");
const iam = require("../lib");
const app = new core_1.App();
const stack = new core_1.Stack(app, 'oidc-provider-integ-test');
new iam.OpenIdConnectProvider(stack, 'NoClientsNoThumbprint', {
    url: 'https://oidc.eks.us-east-1.amazonaws.com/id/test2',
});
new iam.OpenIdConnectProvider(stack, 'Clients', {
    url: 'https://oidc.eks.us-east-1.amazonaws.com/id/test3',
    clientIds: ['foo', 'bar'],
});
new iam.OpenIdConnectProvider(stack, 'Thumbprints', {
    url: 'https://oidc.eks.us-east-1.amazonaws.com/id/test4',
    thumbprints: [
        'aa00aa1122aa00aa1122aa00aa1122aa00aa1122',
        'aa00aa1122aa00aa1122aa00aa1122aa00aa1111',
    ],
});
app.synth();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcub2lkYy1wcm92aWRlci5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImludGVnLm9pZGMtcHJvdmlkZXIudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQSx3Q0FBMkM7QUFDM0MsOEJBQThCO0FBRTlCLE1BQU0sR0FBRyxHQUFHLElBQUksVUFBRyxFQUFFLENBQUM7QUFDdEIsTUFBTSxLQUFLLEdBQUcsSUFBSSxZQUFLLENBQUMsR0FBRyxFQUFFLDBCQUEwQixDQUFDLENBQUM7QUFFekQsSUFBSSxHQUFHLENBQUMscUJBQXFCLENBQUMsS0FBSyxFQUFFLHVCQUF1QixFQUFFO0lBQzVELEdBQUcsRUFBRSxtREFBbUQ7Q0FDekQsQ0FBQyxDQUFDO0FBRUgsSUFBSSxHQUFHLENBQUMscUJBQXFCLENBQUMsS0FBSyxFQUFFLFNBQVMsRUFBRTtJQUM5QyxHQUFHLEVBQUUsbURBQW1EO0lBQ3hELFNBQVMsRUFBRSxDQUFFLEtBQUssRUFBRSxLQUFLLENBQUU7Q0FDNUIsQ0FBQyxDQUFDO0FBRUgsSUFBSSxHQUFHLENBQUMscUJBQXFCLENBQUMsS0FBSyxFQUFFLGFBQWEsRUFBRTtJQUNsRCxHQUFHLEVBQUUsbURBQW1EO0lBQ3hELFdBQVcsRUFBRTtRQUNYLDBDQUEwQztRQUMxQywwQ0FBMEM7S0FDM0M7Q0FDRixDQUFDLENBQUM7QUFFSCxHQUFHLENBQUMsS0FBSyxFQUFFLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBBcHAsIFN0YWNrIH0gZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5pbXBvcnQgKiBhcyBpYW0gZnJvbSAnLi4vbGliJztcblxuY29uc3QgYXBwID0gbmV3IEFwcCgpO1xuY29uc3Qgc3RhY2sgPSBuZXcgU3RhY2soYXBwLCAnb2lkYy1wcm92aWRlci1pbnRlZy10ZXN0Jyk7XG5cbm5ldyBpYW0uT3BlbklkQ29ubmVjdFByb3ZpZGVyKHN0YWNrLCAnTm9DbGllbnRzTm9UaHVtYnByaW50Jywge1xuICB1cmw6ICdodHRwczovL29pZGMuZWtzLnVzLWVhc3QtMS5hbWF6b25hd3MuY29tL2lkL3Rlc3QyJyxcbn0pO1xuXG5uZXcgaWFtLk9wZW5JZENvbm5lY3RQcm92aWRlcihzdGFjaywgJ0NsaWVudHMnLCB7XG4gIHVybDogJ2h0dHBzOi8vb2lkYy5la3MudXMtZWFzdC0xLmFtYXpvbmF3cy5jb20vaWQvdGVzdDMnLFxuICBjbGllbnRJZHM6IFsgJ2ZvbycsICdiYXInIF0sXG59KTtcblxubmV3IGlhbS5PcGVuSWRDb25uZWN0UHJvdmlkZXIoc3RhY2ssICdUaHVtYnByaW50cycsIHtcbiAgdXJsOiAnaHR0cHM6Ly9vaWRjLmVrcy51cy1lYXN0LTEuYW1hem9uYXdzLmNvbS9pZC90ZXN0NCcsXG4gIHRodW1icHJpbnRzOiBbXG4gICAgJ2FhMDBhYTExMjJhYTAwYWExMTIyYWEwMGFhMTEyMmFhMDBhYTExMjInLFxuICAgICdhYTAwYWExMTIyYWEwMGFhMTEyMmFhMDBhYTExMjJhYTAwYWExMTExJyxcbiAgXSxcbn0pO1xuXG5hcHAuc3ludGgoKTsiXX0=