# generated by datamodel-codegen:
#   filename:  node/worldlayer/gridded.json
#   timestamp: 2025-04-16T01:50:45+00:00

from __future__ import annotations

from typing import List, Literal, Optional

from oceanum.eidos._basemodel import EidosModel
from pydantic import ConfigDict, Field, RootModel

from .. import world


class Mesh(EidosModel):
    shape: Optional[str] = None
    length: Optional[float] = None
    width: Optional[float] = None


class GridLayerDatakeys(EidosModel):
    """
    Mapping from data variables to x,y and c(scalar value)
    """

    x: str
    y: str
    c: Optional[str] = None
    d: Optional[str] = None
    m: Optional[str] = None
    u: Optional[str] = None
    v: Optional[str] = None


class GriddedProps(EidosModel):
    altitude: Optional[float] = None
    zscale: Optional[float] = None
    colormap: Optional[bool] = None
    opacity: Optional[float] = 1.0
    color: Optional[world.Color] = None


class Pcolor(RootModel[GriddedProps]):
    root: GriddedProps


class Particles(GriddedProps):
    size: Optional[float] = None
    length: Optional[float] = 10
    speed: Optional[float] = 0.2


class Partmesh(GriddedProps):
    speed: Optional[float] = 0.2
    mesh: Optional[Mesh] = None


class Contour(GriddedProps):
    levels: Optional[List[float]] = None
    linewidth: Optional[int] = 1


class GriddedLayerSpec(EidosModel):
    """
    Specification for Gridded Overlay model settings
    """

    model_config = ConfigDict(
        extra='forbid',
    )
    layerType: Literal['gridded']
    datakeys: GridLayerDatakeys
    legend: Optional[world.Legend] = None
    colormap: world.Colormap
    pcolor: Optional[Pcolor] = None
    particles: Optional[Particles] = None
    partmesh: Optional[Particles] = None
    contour: Optional[Contour] = None
    scale: Optional[float] = 1
    offset: Optional[float] = 1
    units: Optional[str] = None
    precision: Optional[float] = 1
    landmask: Optional[bool] = None
    global_: Optional[bool] = Field(None, alias='global')
