# generated by datamodel-codegen:
#   filename:  root.json
#   timestamp: 2025-04-16T01:50:45+00:00

from __future__ import annotations

from typing import Any, Dict, List, Literal, Optional, Union

from oceanum.eidos._basemodel import EidosModel
from pydantic import ConfigDict, Field, RootModel, constr

from . import data as data_1
from . import theme as theme_1
from .node import document, grid, menu, plot, world


class CssSpec(RootModel[Optional[Union[int, str]]]):
    root: Optional[Union[int, str]]
    """
    CSS string or pixels as integer or null
    """


class Position(EidosModel):
    top: Optional[CssSpec] = None
    left: Optional[CssSpec] = None
    bottom: Optional[CssSpec] = None
    right: Optional[CssSpec] = None


class Node(
    RootModel[Union[world.World, plot.Plot, document.Document, grid.Grid, menu.Menu]]
):
    root: Union[world.World, plot.Plot, document.Document, grid.Grid, menu.Menu] = (
        Field(..., title='Node')
    )
    """
    Spec for node (world, plot, document, grid or menu)
    """


class Modal(EidosModel):
    """
    Spec for modal node (world, plot, document, grid or menu)
    """

    id: str
    """
    Unique ID of the modal
    """
    node: Node
    trigger: Optional[Dict[str, Any]] = None
    """
    event object that triggers modal
    """
    exclusive: Optional[bool] = False
    """
    If true, this modal is exclusive and will close other modals when opened
    """
    height: Optional[CssSpec] = None
    """
    Height of modal dialog (CSS string or pixels)
    """
    width: Optional[CssSpec] = None
    """
    Width of modal dialog (CSS string or pixels)
    """
    position: Optional[Position] = Field(
        default_factory=lambda: Position.model_validate(
            {'top': None, 'left': None, 'bottom': None, 'right': None}
        )
    )
    """
    Location of modal relative to content
    """
    title: Optional[str] = None
    """
    Title of modal
    """


class EidosSpecification(EidosModel):
    """
    Top level specification for Oceanum Dataview display and interaction
    """

    model_config = ConfigDict(
        extra='forbid',
    )
    version: Literal['0.4.0'] = '0.4.0'
    """
    Version of EIDOS
    """
    id: constr(pattern=r'^[a-z0-9-_]+$')
    """
    Unique id of the specification
    """
    name: str
    """
    Human readable name of the specification
    """
    description: Optional[str] = ''
    """
    Description of the specification
    """
    title: Optional[str] = None
    """
    Title displayed at top of screen
    """
    logo: Optional[str] = None
    """
    URL of logo image
    """
    theme: Optional[theme_1.EidosTheme] = None
    data: Optional[List[data_1.EidosData]] = Field(None, title='Data')
    transforms: Optional[List[data_1.Transform]] = Field(None, title='Data Transforms')
    rootNode: Node
    modals: Optional[List[Modal]] = None
