"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cfn_element_1 = require("./cfn-element");
const cfn_fn_1 = require("./cfn-fn");
const token_1 = require("./token");
/**
 * Represents a CloudFormation mapping.
 */
class CfnMapping extends cfn_element_1.CfnRefElement {
    constructor(scope, id, props = {}) {
        super(scope, id);
        this.mapping = {};
        this.mapping = props.mapping || {};
    }
    /**
     * Sets a value in the map based on the two keys.
     */
    setValue(key1, key2, value) {
        if (!(key1 in this.mapping)) {
            this.mapping[key1] = {};
        }
        this.mapping[key1][key2] = value;
    }
    /**
     * @returns A reference to a value in the map based on the two keys.
     */
    findInMap(key1, key2) {
        // opportunistically check that the key exists (if the key does not contain tokens)
        if (!token_1.Token.isUnresolved(key1) && !(key1 in this.mapping)) {
            throw new Error(`Mapping doesn't contain top-level key '${key1}'`);
        }
        // opportunistically check that the second key exists (if the key does not contain tokens)
        if (!token_1.Token.isUnresolved(key1) && !token_1.Token.isUnresolved(key2) && !(key2 in this.mapping[key1])) {
            throw new Error(`Mapping doesn't contain second-level key '${key2}'`);
        }
        return cfn_fn_1.Fn.findInMap(this.logicalId, key1, key2);
    }
    /**
     * @internal
     */
    _toCloudFormation() {
        return {
            Mappings: {
                [this.logicalId]: this.mapping
            }
        };
    }
}
exports.CfnMapping = CfnMapping;
//# sourceMappingURL=data:application/json;base64,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