"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.P6Namer = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib");
const lambda = require("aws-cdk-lib/aws-lambda");
const lambdajs = require("aws-cdk-lib/aws-lambda-nodejs");
const cr = require("aws-cdk-lib/custom-resources");
const floyd = require("cdk-iam-floyd");
class P6Namer extends cdk.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        const policy = new floyd.Iam().allow().toCreateAccountAlias();
        const onEvent = new lambdajs.NodejsFunction(this, "p6namer", {
            runtime: lambda.Runtime.NODEJS_14_X,
            timeout: cdk.Duration.seconds(2),
            tracing: lambda.Tracing.ACTIVE,
            bundling: {
                minify: true,
                externalModules: ["aws-sdk"],
            },
        });
        onEvent.addToRolePolicy(policy);
        const provider = new cr.Provider(this, "P6Namer/Provider", {
            onEventHandler: onEvent,
        });
        new cdk.CustomResource(this, "P6Namer/CR", {
            serviceToken: provider.serviceToken,
            properties: {
                AccountAlias: props.accountAlias,
            },
        });
    }
}
exports.P6Namer = P6Namer;
_a = JSII_RTTI_SYMBOL_1;
P6Namer[_a] = { fqn: "p6-cdk-namer.P6Namer", version: "0.8.12" };
//# sourceMappingURL=data:application/json;base64,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