"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Evidently = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [evidently](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncloudwatchevidently.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Evidently extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [evidently](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncloudwatchevidently.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'evidently';
        this.accessLevelList = {
            Write: [
                'BatchEvaluateFeature',
                'CreateExperiment',
                'CreateFeature',
                'CreateLaunch',
                'CreateProject',
                'DeleteExperiment',
                'DeleteFeature',
                'DeleteLaunch',
                'DeleteProject',
                'EvaluateFeature',
                'PutProjectEvents',
                'StartExperiment',
                'StartLaunch',
                'StopExperiment',
                'StopLaunch',
                'UpdateExperiment',
                'UpdateFeature',
                'UpdateLaunch',
                'UpdateProject',
                'UpdateProjectDataDelivery'
            ],
            Read: [
                'GetExperiment',
                'GetExperimentResults',
                'GetFeature',
                'GetLaunch',
                'GetProject',
                'ListExperiments',
                'ListFeatures',
                'ListLaunches',
                'ListProjects',
                'ListTagsForResource'
            ],
            Tagging: [
                'TagResource',
                'UntagResource'
            ]
        };
    }
    /**
     * Grants permission to send a batched evaluate feature request
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_BatchEvaluateFeature.html
     */
    toBatchEvaluateFeature() {
        return this.to('BatchEvaluateFeature');
    }
    /**
     * Grants permission to create an experiment
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_CreateExperiment.html
     */
    toCreateExperiment() {
        return this.to('CreateExperiment');
    }
    /**
     * Grants permission to create a feature
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_CreateFeature.html
     */
    toCreateFeature() {
        return this.to('CreateFeature');
    }
    /**
     * Grants permission to create a launch
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_CreateLaunch.html
     */
    toCreateLaunch() {
        return this.to('CreateLaunch');
    }
    /**
     * Grants permission to create a project
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_CreateProject.html
     */
    toCreateProject() {
        return this.to('CreateProject');
    }
    /**
     * Grants permission to delete an experiment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_DeleteExperiment.html
     */
    toDeleteExperiment() {
        return this.to('DeleteExperiment');
    }
    /**
     * Grants permission to delete a feature
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_DeleteFeature.html
     */
    toDeleteFeature() {
        return this.to('DeleteFeature');
    }
    /**
     * Grants permission to delete a launch
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_DeleteLaunch.html
     */
    toDeleteLaunch() {
        return this.to('DeleteLaunch');
    }
    /**
     * Grants permission to delete a project
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_DeleteProject.html
     */
    toDeleteProject() {
        return this.to('DeleteProject');
    }
    /**
     * Grants permission to send an evaluate feature request
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_EvaluateFeature.html
     */
    toEvaluateFeature() {
        return this.to('EvaluateFeature');
    }
    /**
     * Grants permission to get experiment details
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_GetExperiment.html
     */
    toGetExperiment() {
        return this.to('GetExperiment');
    }
    /**
     * Grants permission to get experiment result
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_GetExperimentResults.html
     */
    toGetExperimentResults() {
        return this.to('GetExperimentResults');
    }
    /**
     * Grants permission to get feature details
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_GetFeature.html
     */
    toGetFeature() {
        return this.to('GetFeature');
    }
    /**
     * Grants permission to get launch details
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_GetLaunch.html
     */
    toGetLaunch() {
        return this.to('GetLaunch');
    }
    /**
     * Grants permission to get project details
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_GetProject.html
     */
    toGetProject() {
        return this.to('GetProject');
    }
    /**
     * Grants permission to list experiments
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_ListExperiments.html
     */
    toListExperiments() {
        return this.to('ListExperiments');
    }
    /**
     * Grants permission to list features
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_ListFeatures.html
     */
    toListFeatures() {
        return this.to('ListFeatures');
    }
    /**
     * Grants permission to list launches
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_ListLaunches.html
     */
    toListLaunches() {
        return this.to('ListLaunches');
    }
    /**
     * Grants permission to list projects
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_ListProjects.html
     */
    toListProjects() {
        return this.to('ListProjects');
    }
    /**
     * Grants permission to list tags for resources
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * Grants permission to send performance events
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_PutProjectEvents.html
     */
    toPutProjectEvents() {
        return this.to('PutProjectEvents');
    }
    /**
     * Grants permission to start an experiment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_StartExperiment.html
     */
    toStartExperiment() {
        return this.to('StartExperiment');
    }
    /**
     * Grants permission to start a launch
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_StartLaunch.html
     */
    toStartLaunch() {
        return this.to('StartLaunch');
    }
    /**
     * Grants permission to stop an experiment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_StopExperiment.html
     */
    toStopExperiment() {
        return this.to('StopExperiment');
    }
    /**
     * Grants permission to stop a launch
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_StopLaunch.html
     */
    toStopLaunch() {
        return this.to('StopLaunch');
    }
    /**
     * Grants permission to tag resources
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_TagResource.html
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * Grants permission to untag resources
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_UntagResource.html
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * Grants permission to update experiment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_UpdateExperiment.html
     */
    toUpdateExperiment() {
        return this.to('UpdateExperiment');
    }
    /**
     * Grants permission to update feature
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_UpdateFeature.html
     */
    toUpdateFeature() {
        return this.to('UpdateFeature');
    }
    /**
     * Grants permission to update a launch
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_UpdateLaunch.html
     */
    toUpdateLaunch() {
        return this.to('UpdateLaunch');
    }
    /**
     * Grants permission to update project
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_UpdateProject.html
     */
    toUpdateProject() {
        return this.to('UpdateProject');
    }
    /**
     * Grants permission to update project data delivery
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_UpdateProjectDataDelivery.html
     */
    toUpdateProjectDataDelivery() {
        return this.to('UpdateProjectDataDelivery');
    }
    /**
     * Adds a resource of type Project to the statement
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/projects.html
     *
     * @param ownerAccountId - Identifier for the ownerAccountId.
     * @param projectName - Identifier for the projectName.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onProject(ownerAccountId, projectName, region, partition) {
        return this.on(`arn:${partition || 'aws'}:evidently:${region || '*'}:${ownerAccountId}:project/${projectName}`);
    }
    /**
     * Adds a resource of type Feature to the statement
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/features.html
     *
     * @param ownerAccountId - Identifier for the ownerAccountId.
     * @param projectName - Identifier for the projectName.
     * @param featureName - Identifier for the featureName.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onFeature(ownerAccountId, projectName, featureName, region, partition) {
        return this.on(`arn:${partition || 'aws'}:evidently:${region || '*'}:${ownerAccountId}:project/${projectName}/feature/${featureName}`);
    }
    /**
     * Adds a resource of type Experiment to the statement
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/experiments.html
     *
     * @param ownerAccountId - Identifier for the ownerAccountId.
     * @param projectName - Identifier for the projectName.
     * @param experimentName - Identifier for the experimentName.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onExperiment(ownerAccountId, projectName, experimentName, region, partition) {
        return this.on(`arn:${partition || 'aws'}:evidently:${region || '*'}:${ownerAccountId}:project/${projectName}/experiment/${experimentName}`);
    }
    /**
     * Adds a resource of type Launch to the statement
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/launches.html
     *
     * @param ownerAccountId - Identifier for the ownerAccountId.
     * @param projectName - Identifier for the projectName.
     * @param launchName - Identifier for the launchName.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onLaunch(ownerAccountId, projectName, launchName, region, partition) {
        return this.on(`arn:${partition || 'aws'}:evidently:${region || '*'}:${ownerAccountId}:project/${projectName}/launch/${launchName}`);
    }
}
exports.Evidently = Evidently;
_a = JSII_RTTI_SYMBOL_1;
Evidently[_a] = { fqn: "cdk-iam-floyd.Evidently", version: "0.345.0" };
//# sourceMappingURL=data:application/json;base64,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