"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CodedeployCommandsSecure = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [codedeploy-commands-secure](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscodedeploysecurehostcommandsservice.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class CodedeployCommandsSecure extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [codedeploy-commands-secure](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscodedeploysecurehostcommandsservice.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'codedeploy-commands-secure';
        this.accessLevelList = {
            Read: [
                'GetDeploymentSpecification',
                'PollHostCommand'
            ],
            Write: [
                'PutHostCommandAcknowledgement',
                'PutHostCommandComplete'
            ]
        };
    }
    /**
     * Grants permission to get deployment specification
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codedeploy/latest/userguide/vpc-endpoints.html#vpc-codedeploy-agent-configuration
     */
    toGetDeploymentSpecification() {
        return this.to('GetDeploymentSpecification');
    }
    /**
     * Grants permission to request host agent commands
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codedeploy/latest/userguide/vpc-endpoints.html#vpc-codedeploy-agent-configuration
     */
    toPollHostCommand() {
        return this.to('PollHostCommand');
    }
    /**
     * Grants permission to mark host agent commands acknowledged
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codedeploy/latest/userguide/vpc-endpoints.html#vpc-codedeploy-agent-configuration
     */
    toPutHostCommandAcknowledgement() {
        return this.to('PutHostCommandAcknowledgement');
    }
    /**
     * Grants permission to mark host agent commands completed
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codedeploy/latest/userguide/vpc-endpoints.html#vpc-codedeploy-agent-configuration
     */
    toPutHostCommandComplete() {
        return this.to('PutHostCommandComplete');
    }
}
exports.CodedeployCommandsSecure = CodedeployCommandsSecure;
_a = JSII_RTTI_SYMBOL_1;
CodedeployCommandsSecure[_a] = { fqn: "cdk-iam-floyd.CodedeployCommandsSecure", version: "0.345.0" };
//# sourceMappingURL=data:application/json;base64,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