"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Controltower = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [controltower](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscontroltower.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Controltower extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [controltower](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscontroltower.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'controltower';
        this.accessLevelList = {
            Write: [
                'CreateManagedAccount',
                'DeregisterManagedAccount',
                'DeregisterOrganizationalUnit',
                'DisableGuardrail',
                'EnableGuardrail',
                'ManageOrganizationalUnit',
                'SetupLandingZone',
                'UpdateAccountFactoryConfig'
            ],
            Read: [
                'DescribeAccountFactoryConfig',
                'DescribeCoreService',
                'DescribeGuardrail',
                'DescribeGuardrailForTarget',
                'DescribeManagedAccount',
                'DescribeManagedOrganizationalUnit',
                'DescribeSingleSignOn',
                'GetAvailableUpdates',
                'GetGuardrailComplianceStatus',
                'GetHomeRegion',
                'GetLandingZoneStatus'
            ],
            List: [
                'ListDirectoryGroups',
                'ListEnabledGuardrails',
                'ListGuardrailViolations',
                'ListGuardrails',
                'ListGuardrailsForTarget',
                'ListManagedAccounts',
                'ListManagedAccountsForGuardrail',
                'ListManagedAccountsForParent',
                'ListManagedOrganizationalUnits',
                'ListManagedOrganizationalUnitsForGuardrail'
            ]
        };
    }
    /**
     * Grants permission to create an account managed by AWS Control Tower.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/account-factory.html
     */
    toCreateManagedAccount() {
        return this.to('CreateManagedAccount');
    }
    /**
     * Grants permission to deregister an account created through the account factory from AWS Control Tower.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/account-factory.html
     */
    toDeregisterManagedAccount() {
        return this.to('DeregisterManagedAccount');
    }
    /**
     * Grants permission to deregister an organizational unit from AWS Control Tower management.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/organizations.html
     */
    toDeregisterOrganizationalUnit() {
        return this.to('DeregisterOrganizationalUnit');
    }
    /**
     * Grants permission to describe the current account factory configuration.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/account-factory.html
     */
    toDescribeAccountFactoryConfig() {
        return this.to('DescribeAccountFactoryConfig');
    }
    /**
     * Grants permission to describe resources managed by core accounts in AWS Control Tower.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/how-control-tower-works.html#what-shared
     */
    toDescribeCoreService() {
        return this.to('DescribeCoreService');
    }
    /**
     * Grants permission to describe a guardrail.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/guardrails.html
     */
    toDescribeGuardrail() {
        return this.to('DescribeGuardrail');
    }
    /**
     * Grants permission to describe a guardrail for a organizational unit.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/guardrails.html
     */
    toDescribeGuardrailForTarget() {
        return this.to('DescribeGuardrailForTarget');
    }
    /**
     * Grants permission to describe an account created through account factory.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/account-factory.html
     */
    toDescribeManagedAccount() {
        return this.to('DescribeManagedAccount');
    }
    /**
     * Grants permission to describe an AWS Organizations organizational unit managed by AWS Control Tower.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/organizations.html
     */
    toDescribeManagedOrganizationalUnit() {
        return this.to('DescribeManagedOrganizationalUnit');
    }
    /**
     * Grants permission to describe the current AWS Control Tower SSO configuration.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/sso.html
     */
    toDescribeSingleSignOn() {
        return this.to('DescribeSingleSignOn');
    }
    /**
     * Grants permission to disable a guardrail from an organizational unit.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/guardrails.html#enable-guardrails
     */
    toDisableGuardrail() {
        return this.to('DisableGuardrail');
    }
    /**
     * Grants permission to enable a guardrail to an organizational unit.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/guardrails.html#enable-guardrails
     */
    toEnableGuardrail() {
        return this.to('EnableGuardrail');
    }
    /**
     * Grants permission to list available updates for the current AWS Control Tower deployment.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/configuration-updates.html
     */
    toGetAvailableUpdates() {
        return this.to('GetAvailableUpdates');
    }
    /**
     * Grants permission to get the current compliance status of a guardrail.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/guardrails.html
     */
    toGetGuardrailComplianceStatus() {
        return this.to('GetGuardrailComplianceStatus');
    }
    /**
     * Grants permission to get the home region of the AWS Control Tower setup.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/how-control-tower-works.html#region-how
     */
    toGetHomeRegion() {
        return this.to('GetHomeRegion');
    }
    /**
     * Grants permission to get the current status of the landing zone setup.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/getting-started-with-control-tower.html#step-two
     */
    toGetLandingZoneStatus() {
        return this.to('GetLandingZoneStatus');
    }
    /**
     * Grants permission to list the current directory groups available through SSO.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/sso.html
     */
    toListDirectoryGroups() {
        return this.to('ListDirectoryGroups');
    }
    /**
     * Grants permission to list currently enabled guardrails.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/guardrails.html
     */
    toListEnabledGuardrails() {
        return this.to('ListEnabledGuardrails');
    }
    /**
     * Grants permission to list existing guardrail violations.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/guardrails.html
     */
    toListGuardrailViolations() {
        return this.to('ListGuardrailViolations');
    }
    /**
     * Grants permission to list all available guardrails.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/guardrails.html
     */
    toListGuardrails() {
        return this.to('ListGuardrails');
    }
    /**
     * Grants permission to list guardrails and their current state for a organizational unit.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/guardrails.html
     */
    toListGuardrailsForTarget() {
        return this.to('ListGuardrailsForTarget');
    }
    /**
     * Grants permission to list accounts managed through AWS Control Tower.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/account-factory.html
     */
    toListManagedAccounts() {
        return this.to('ListManagedAccounts');
    }
    /**
     * Grants permission to list managed accounts with a specified guardrail applied.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/account-factory.html
     */
    toListManagedAccountsForGuardrail() {
        return this.to('ListManagedAccountsForGuardrail');
    }
    /**
     * Grants permission to list managed accounts under an organizational unit.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/account-factory.html
     */
    toListManagedAccountsForParent() {
        return this.to('ListManagedAccountsForParent');
    }
    /**
     * Grants permission to list organizational units managed by AWS Control Tower.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/organizations.html
     */
    toListManagedOrganizationalUnits() {
        return this.to('ListManagedOrganizationalUnits');
    }
    /**
     * Grants permission to list managed organizational units that have a specified guardrail applied.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/organizations.html
     */
    toListManagedOrganizationalUnitsForGuardrail() {
        return this.to('ListManagedOrganizationalUnitsForGuardrail');
    }
    /**
     * Grants permission to set up an organizational unit to be managed by AWS Control Tower.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/organizations.html
     */
    toManageOrganizationalUnit() {
        return this.to('ManageOrganizationalUnit');
    }
    /**
     * Grants permission to set up or update AWS Control Tower landing zone.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/getting-started-with-control-tower.html#step-two
     */
    toSetupLandingZone() {
        return this.to('SetupLandingZone');
    }
    /**
     * Grants permission to update the account factory configuration.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/account-factory.html
     */
    toUpdateAccountFactoryConfig() {
        return this.to('UpdateAccountFactoryConfig');
    }
}
exports.Controltower = Controltower;
_a = JSII_RTTI_SYMBOL_1;
Controltower[_a] = { fqn: "cdk-iam-floyd.Controltower", version: "0.345.0" };
//# sourceMappingURL=data:application/json;base64,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