import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement, Operator } from '../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [license-manager](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awslicensemanager.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class LicenseManager extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to accept a grant
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/license-manager/latest/APIReference/API_AcceptGrant.html
     */
    toAcceptGrant(): this;
    /**
     * Grants permission to check in license entitlements back to pool
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/license-manager/latest/APIReference/API_CheckInLicense.html
     */
    toCheckInLicense(): this;
    /**
     * Grants permission to check out license entitlements for borrow use case
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/license-manager/latest/APIReference/API_CheckoutBorrowLicense.html
     */
    toCheckoutBorrowLicense(): this;
    /**
     * Grants permission to check out license entitlements
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/license-manager/latest/APIReference/API_CheckoutLicense.html
     */
    toCheckoutLicense(): this;
    /**
     * Grants permission to create a new grant for license
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/license-manager/latest/APIReference/API_CreateGrant.html
     */
    toCreateGrant(): this;
    /**
     * Grants permission to create new version of grant
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/license-manager/latest/APIReference/API_CreateGrantVersion.html
     */
    toCreateGrantVersion(): this;
    /**
     * Grants permission to create a new license
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/license-manager/latest/APIReference/API_CreateLicense.html
     */
    toCreateLicense(): this;
    /**
     * Grants permission to create a new license configuration
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/license-manager/latest/APIReference/API_CreateLicenseConfiguration.html
     */
    toCreateLicenseConfiguration(): this;
    /**
     * Grants permission to create a license conversion task for a resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/license-manager/latest/APIReference/API_CreateLicenseConversionTaskForResource.html
     */
    toCreateLicenseConversionTaskForResource(): this;
    /**
     * Grants permission to create a report generator for a license configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/license-manager/latest/APIReference/API_CreateLicenseManagerReportGenerator.html
     */
    toCreateLicenseManagerReportGenerator(): this;
    /**
     * Grants permission to create new version of license.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/license-manager/latest/APIReference/API_CreateLicenseVersion.html
     */
    toCreateLicenseVersion(): this;
    /**
     * Grants permission to create a new token for license
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/license-manager/latest/APIReference/API_CreateToken.html
     */
    toCreateToken(): this;
    /**
     * Deletes a grant
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/license-manager/latest/APIReference/API_DeleteGrant.html
     */
    toDeleteGrant(): this;
    /**
     * Grants permission to delete a license
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/license-manager/latest/APIReference/API_DeleteLicense.html
     */
    toDeleteLicense(): this;
    /**
     * Grants permission to permanently delete a license configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/license-manager/latest/APIReference/API_DeleteLicenseConfiguration.html
     */
    toDeleteLicenseConfiguration(): this;
    /**
     * Grants permission to delete a report generator
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/license-manager/latest/APIReference/API_DeleteLicenseManagerReportGenerator.html
     */
    toDeleteLicenseManagerReportGenerator(): this;
    /**
     * Grants permission to delete token
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/license-manager/latest/APIReference/API_DeleteToken.html
     */
    toDeleteToken(): this;
    /**
     * Grants permission to extend consumption period of already checkout license entitlements
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/license-manager/latest/APIReference/API_ExtendLicenseConsumption.html
     */
    toExtendLicenseConsumption(): this;
    /**
     * Grants permission to get access token
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/license-manager/latest/APIReference/API_GetAccessToken.html
     */
    toGetAccessToken(): this;
    /**
     * Grants permission to get a grant
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/license-manager/latest/APIReference/API_GetGrant.html
     */
    toGetGrant(): this;
    /**
     * Grants permission to get a license
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/license-manager/latest/APIReference/API_GetLicense.html
     */
    toGetLicense(): this;
    /**
     * Grants permission to get a license configuration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/license-manager/latest/APIReference/API_GetLicenseConfiguration.html
     */
    toGetLicenseConfiguration(): this;
    /**
     * Grants permission to retrieve a license conversion task
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/license-manager/latest/APIReference/API_GetLicenseConversionTask.html
     */
    toGetLicenseConversionTask(): this;
    /**
     * Grants permission to get a report generator
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/license-manager/latest/APIReference/API_GetLicenseManagerReportGenerator.html
     */
    toGetLicenseManagerReportGenerator(): this;
    /**
     * Grants permission to get a license usage
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/license-manager/latest/APIReference/API_GetLicenseUsage.html
     */
    toGetLicenseUsage(): this;
    /**
     * Grants permission to get service settings
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/license-manager/latest/APIReference/API_GetServiceSettings.html
     */
    toGetServiceSettings(): this;
    /**
     * Grants permission to list associations for a selected license configuration
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/license-manager/latest/APIReference/API_ListAssociationsForLicenseConfiguration.html
     */
    toListAssociationsForLicenseConfiguration(): this;
    /**
     * Grants permission to list distributed grants
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/license-manager/latest/APIReference/API_ListDistributedGrants.html
     */
    toListDistributedGrants(): this;
    /**
     * Grants permission to list the license configuration operations that failed
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/license-manager/latest/APIReference/API_ListFailuresForLicenseConfigurationOperations.html
     */
    toListFailuresForLicenseConfigurationOperations(): this;
    /**
     * Grants permission to list license configurations
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/license-manager/latest/APIReference/API_ListLicenseConfigurations.html
     */
    toListLicenseConfigurations(): this;
    /**
     * Grants permission to list license conversion tasks
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/license-manager/latest/APIReference/API_ListLicenseConversionTasks.html
     */
    toListLicenseConversionTasks(): this;
    /**
     * Grants permission to list report generators
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/license-manager/latest/APIReference/API_ListLicenseManagerReportGenerators.html
     */
    toListLicenseManagerReportGenerators(): this;
    /**
     * Grants permission to list license specifications associated with a selected resource
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/license-manager/latest/APIReference/API_ListLicenseSpecificationsForResource.html
     */
    toListLicenseSpecificationsForResource(): this;
    /**
     * Grants permission to list license versions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/license-manager/latest/APIReference/API_ListLicenseVersions.html
     */
    toListLicenseVersions(): this;
    /**
     * Grants permission to list licenses
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/license-manager/latest/APIReference/API_ListLicenses.html
     */
    toListLicenses(): this;
    /**
     * Grants permission to list received grants
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/license-manager/latest/APIReference/API_ListReceivedGrants.html
     */
    toListReceivedGrants(): this;
    /**
     * Grants permission to list received licenses
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/license-manager/latest/APIReference/API_ListReceivedLicenses.html
     */
    toListReceivedLicenses(): this;
    /**
     * Grants permission to list resource inventory
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/license-manager/latest/APIReference/API_ListResourceInventory.html
     */
    toListResourceInventory(): this;
    /**
     * Grants permission to list tags for a selected resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/license-manager/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to list tokens
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/license-manager/latest/APIReference/API_ListTokens.html
     */
    toListTokens(): this;
    /**
     * Grants permission to list usage records for selected license configuration
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/license-manager/latest/APIReference/API_ListUsageForLicenseConfiguration.html
     */
    toListUsageForLicenseConfiguration(): this;
    /**
     * Grants permission to reject a grant
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/license-manager/latest/APIReference/API_RejectGrant.html
     */
    toRejectGrant(): this;
    /**
     * Grants permission to tag a selected resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/license-manager/latest/APIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to untag a selected resource
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/license-manager/latest/APIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update an existing license configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/license-manager/latest/APIReference/API_UpdateLicenseConfiguration.html
     */
    toUpdateLicenseConfiguration(): this;
    /**
     * Grants permission to update a report generator for a license configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/license-manager/latest/APIReference/API_UpdateLicenseManagerReportGenerator.html
     */
    toUpdateLicenseManagerReportGenerator(): this;
    /**
     * Grants permission to updates license specifications for a selected resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/license-manager/latest/APIReference/API_UpdateLicenseSpecificationsForResource.html
     */
    toUpdateLicenseSpecificationsForResource(): this;
    /**
     * Grants permission to updates service settings
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/license-manager/latest/APIReference/API_UpdateServiceSettings.html
     */
    toUpdateServiceSettings(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type license-configuration to the statement
     *
     * https://docs.aws.amazon.com/license-manager/latest/userguide/license-configurations.html
     *
     * @param licenseConfigurationId - Identifier for the licenseConfigurationId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifResourceTag()
     */
    onLicenseConfiguration(licenseConfigurationId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type license to the statement
     *
     * https://docs.aws.amazon.com/license-manager/latest/userguide/seller-issued-licenses.html
     *
     * @param licenseId - Identifier for the licenseId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onLicense(licenseId: string, account?: string, partition?: string): this;
    /**
     * Adds a resource of type grant to the statement
     *
     * https://docs.aws.amazon.com/license-manager/latest/userguide/granted-licenses.html
     *
     * @param grantId - Identifier for the grantId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onGrant(grantId: string, account?: string, partition?: string): this;
    /**
     * Adds a resource of type report-generator to the statement
     *
     * https://docs.aws.amazon.com/license-manager/latest/userguide/report-generators.html
     *
     * @param reportGeneratorId - Identifier for the reportGeneratorId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifResourceTag()
     */
    onReportGenerator(reportGeneratorId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access based on tag key-value pairs attached to the resource
     *
     * https://docs.aws.amazon.com/license-manager/latest/userguide/identity-access-management.html
     *
     * Applies to resource types:
     * - license-configuration
     * - report-generator
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [license-manager](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awslicensemanager.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
