"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MigrationhubStrategy = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [migrationhub-strategy](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmigrationhubstrategyrecommendations..html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class MigrationhubStrategy extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [migrationhub-strategy](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmigrationhubstrategyrecommendations..html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'migrationhub-strategy';
        this.accessLevelList = {
            Read: [
                'GetAntiPattern',
                'GetApplicationComponentDetails',
                'GetApplicationComponentStrategies',
                'GetAssessment',
                'GetImportFileTask',
                'GetMessage',
                'GetPortfolioPreferences',
                'GetPortfolioSummary',
                'GetRecommendationReportDetails',
                'GetServerDetails',
                'GetServerStrategies'
            ],
            List: [
                'ListAntiPatterns',
                'ListApplicationComponents',
                'ListCollectors',
                'ListImportFileTask',
                'ListJarArtifacts',
                'ListServers'
            ],
            Write: [
                'PutPortfolioPreferences',
                'RegisterCollector',
                'SendMessage',
                'StartAssessment',
                'StartImportFileTask',
                'StartRecommendationReportGeneration',
                'StopAssessment',
                'UpdateApplicationComponentConfig',
                'UpdateServerConfig'
            ]
        };
    }
    /**
     * Grants permission to get details of each anti pattern that collector should look at in a customer's environment
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_GetAntiPattern.html
     */
    toGetAntiPattern() {
        return this.to('GetAntiPattern');
    }
    /**
     * Grants permission to get details of an application
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_GetApplicationComponentDetails.html
     */
    toGetApplicationComponentDetails() {
        return this.to('GetApplicationComponentDetails');
    }
    /**
     * Grants permission to get a list of all recommended strategies and tools for an application running in a server
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_GetApplicationComponentStrategies.html
     */
    toGetApplicationComponentStrategies() {
        return this.to('GetApplicationComponentStrategies');
    }
    /**
     * Grants permission to retrieve status of an on-going assessment
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_GetAssessment.html
     */
    toGetAssessment() {
        return this.to('GetAssessment');
    }
    /**
     * Grants permission to get details of a specific import task
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_GetImportFileTask.html
     */
    toGetImportFileTask() {
        return this.to('GetImportFileTask');
    }
    /**
     * Grants permission to the collector to receive information from the service
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_GetMessage.html
     */
    toGetMessage() {
        return this.to('GetMessage');
    }
    /**
     * Grants permission to retrieve customer migration/Modernization preferences
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_GetPortfolioPreferences.html
     */
    toGetPortfolioPreferences() {
        return this.to('GetPortfolioPreferences');
    }
    /**
     * Grants permission to retrieve overall summary (number-of servers to rehost etc as well as overall number of anti patterns)
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_GetPortfolioSummary.html
     */
    toGetPortfolioSummary() {
        return this.to('GetPortfolioSummary');
    }
    /**
     * Grants permission to retrieve detailed information about a recommendation report
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_GetRecommendationReportDetails.html
     */
    toGetRecommendationReportDetails() {
        return this.to('GetRecommendationReportDetails');
    }
    /**
     * Grants permission to get info about a specific server
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_GetServerDetails.html
     */
    toGetServerDetails() {
        return this.to('GetServerDetails');
    }
    /**
     * Grants permission to get recommended strategies and tools for a specific server
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_GetServerStrategies.html
     */
    toGetServerStrategies() {
        return this.to('GetServerStrategies');
    }
    /**
     * Grants permission to get a list of all anti patterns that collector should look for in a customer's environment
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_ListAntiPatterns.html
     */
    toListAntiPatterns() {
        return this.to('ListAntiPatterns');
    }
    /**
     * Grants permission to get a list of all applications running on servers on customer's servers
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_ListApplicationComponents.html
     */
    toListApplicationComponents() {
        return this.to('ListApplicationComponents');
    }
    /**
     * Grants permission to get a list of all collectors installed by the customer
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_ListCollectors.html
     */
    toListCollectors() {
        return this.to('ListCollectors');
    }
    /**
     * Grants permission to get list of all imports performed by the customer
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_ListImportFileTask.html
     */
    toListImportFileTask() {
        return this.to('ListImportFileTask');
    }
    /**
     * Grants permission to get a list of binaries that collector should assess
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_ListJarArtifacts.html
     */
    toListJarArtifacts() {
        return this.to('ListJarArtifacts');
    }
    /**
     * Grants permission to get a list of all servers in a customer's environment
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_ListServers.html
     */
    toListServers() {
        return this.to('ListServers');
    }
    /**
     * Grants permission to save customer's Migration/Modernization preferences
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_PutPortfolioPreferences.html
     */
    toPutPortfolioPreferences() {
        return this.to('PutPortfolioPreferences');
    }
    /**
     * Grants permission to register the collector to receive an ID and to start receiving messages from the service
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_RegisterCollector.html
     */
    toRegisterCollector() {
        return this.to('RegisterCollector');
    }
    /**
     * Grants permission to the collector to send information to the service
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_SendMessage.html
     */
    toSendMessage() {
        return this.to('SendMessage');
    }
    /**
     * Grants permission to start assessment in a customer's environment (collect data from all servers and provide recommendations)
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_StartAssessment.html
     */
    toStartAssessment() {
        return this.to('StartAssessment');
    }
    /**
     * Grants permission to start importing data from a file provided by customer
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_StartImportFileTask.html
     */
    toStartImportFileTask() {
        return this.to('StartImportFileTask');
    }
    /**
     * Grants permission to start generating a recommendation report
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_StartRecommendationReportGeneration.html
     */
    toStartRecommendationReportGeneration() {
        return this.to('StartRecommendationReportGeneration');
    }
    /**
     * Grants permission to stop an on-going assessment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_StopAssessment.html
     */
    toStopAssessment() {
        return this.to('StopAssessment');
    }
    /**
     * Grants permission to update details for an application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_UpdateApplicationComponentConfig.html
     */
    toUpdateApplicationComponentConfig() {
        return this.to('UpdateApplicationComponentConfig');
    }
    /**
     * Grants permission to update info on a server along with the recommended strategy
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_UpdateServerConfig.html
     */
    toUpdateServerConfig() {
        return this.to('UpdateServerConfig');
    }
}
exports.MigrationhubStrategy = MigrationhubStrategy;
_a = JSII_RTTI_SYMBOL_1;
MigrationhubStrategy[_a] = { fqn: "cdk-iam-floyd.MigrationhubStrategy", version: "0.345.0" };
//# sourceMappingURL=data:application/json;base64,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