"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Panorama = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [panorama](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awspanorama.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Panorama extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [panorama](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awspanorama.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'panorama';
        this.accessLevelList = {
            Write: [
                'CreateApp',
                'CreateAppDeployment',
                'CreateAppVersion',
                'CreateApplicationInstance',
                'CreateDataSource',
                'CreateDeploymentConfiguration',
                'CreateInputs',
                'CreateJobForDevices',
                'CreateModel',
                'CreateNodeFromTemplateJob',
                'CreatePackage',
                'CreatePackageImportJob',
                'CreateStreams',
                'DeleteApp',
                'DeleteAppVersion',
                'DeleteDataSource',
                'DeleteDevice',
                'DeleteModel',
                'DeletePackage',
                'DeregisterPackageVersion',
                'ProvisionDevice',
                'RegisterPackageVersion',
                'RemoveApplicationInstance',
                'UpdateApp',
                'UpdateAppConfiguration',
                'UpdateDataSource',
                'UpdateDeviceMetadata'
            ],
            Read: [
                'DescribeApp',
                'DescribeAppDeployment',
                'DescribeAppVersion',
                'DescribeApplicationInstance',
                'DescribeApplicationInstanceDetails',
                'DescribeDataSource',
                'DescribeDevice',
                'DescribeDeviceJob',
                'DescribeModel',
                'DescribeNode',
                'DescribeNodeFromTemplateJob',
                'DescribePackage',
                'DescribePackageImportJob',
                'DescribePackageVersion',
                'DescribeSoftware',
                'GetDeploymentConfiguration',
                'GetInputs',
                'GetStreams',
                'GetWebSocketURL'
            ],
            List: [
                'ListAppDeploymentOperations',
                'ListAppVersions',
                'ListApplicationInstanceDependencies',
                'ListApplicationInstanceNodeInstances',
                'ListApplicationInstances',
                'ListApps',
                'ListDataSources',
                'ListDeploymentConfigurations',
                'ListDevices',
                'ListDevicesJobs',
                'ListModels',
                'ListNodeFromTemplateJobs',
                'ListNodes',
                'ListPackageImportJobs',
                'ListPackages',
                'ListTagsForResource'
            ],
            Tagging: [
                'TagResource',
                'UntagResource'
            ]
        };
    }
    /**
     * Grants permission to create an AWS Panorama application
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_CreateApp.html
     */
    toCreateApp() {
        return this.to('CreateApp');
    }
    /**
     * Grants permission to deploy an AWS Panorama application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_CreateAppDeployment.html
     */
    toCreateAppDeployment() {
        return this.to('CreateAppDeployment');
    }
    /**
     * Grants permission to create a version of an AWS Panorama application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_CreateAppVersion.html
     */
    toCreateAppVersion() {
        return this.to('CreateAppVersion');
    }
    /**
     * Grants permission to create an AWS Panorama Application Instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_CreateApplicationInstance.html
     */
    toCreateApplicationInstance() {
        return this.to('CreateApplicationInstance');
    }
    /**
     * Grants permission to create an AWS Panorama datasource
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_CreateDataSource.html
     */
    toCreateDataSource() {
        return this.to('CreateDataSource');
    }
    /**
     * Grants permission to configure a deployment for an AWS Panorama application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_CreateDeploymentConfiguration.html
     */
    toCreateDeploymentConfiguration() {
        return this.to('CreateDeploymentConfiguration');
    }
    /**
     * Grants permission to generate a list of cameras on the same network as an AWS Panorama Appliance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_CreateInputList.html
     */
    toCreateInputs() {
        return this.to('CreateInputs');
    }
    /**
     * Grants permission to create a job for an AWS Panorama Appliance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_CreateJobForDevices.html
     */
    toCreateJobForDevices() {
        return this.to('CreateJobForDevices');
    }
    /**
     * Grants permission to import a machine learning model into AWS Panorama
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_CreateModel.html
     */
    toCreateModel() {
        return this.to('CreateModel');
    }
    /**
     * Grants permission to create an AWS Panorama Node
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_CreateNodeFromTemplateJob.html
     */
    toCreateNodeFromTemplateJob() {
        return this.to('CreateNodeFromTemplateJob');
    }
    /**
     * Grants permission to create an AWS Panorama Package
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_CreatePackage.html
     */
    toCreatePackage() {
        return this.to('CreatePackage');
    }
    /**
     * Grants permission to create an AWS Panorama Package
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_CreatePackageImportJob.html
     */
    toCreatePackageImportJob() {
        return this.to('CreatePackageImportJob');
    }
    /**
     * Grants permission to generate a list of streams available to an AWS Panorama Appliance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_CreateStreamsList.html
     */
    toCreateStreams() {
        return this.to('CreateStreams');
    }
    /**
     * Grants permission to delete an AWS Panorama application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_DeleteApp.html
     */
    toDeleteApp() {
        return this.to('DeleteApp');
    }
    /**
     * Grants permission to delete a version of an AWS Panorama application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_DeleteAppVersion.html
     */
    toDeleteAppVersion() {
        return this.to('DeleteAppVersion');
    }
    /**
     * Grants permission to delete an AWS Panorama datasource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_DeleteDataSource.html
     */
    toDeleteDataSource() {
        return this.to('DeleteDataSource');
    }
    /**
     * Grants permission to deregister an AWS Panorama Appliance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_DeleteDevice.html
     */
    toDeleteDevice() {
        return this.to('DeleteDevice');
    }
    /**
     * Grants permission to delete a machine learning model from AWS Panorama
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_DeleteModel.html
     */
    toDeleteModel() {
        return this.to('DeleteModel');
    }
    /**
     * Grants permission to delete an AWS Panorama Package
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_DeletePackage.html
     */
    toDeletePackage() {
        return this.to('DeletePackage');
    }
    /**
     * Grants permission to deregister an AWS Panorama Package Version
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_DeregisterPackageVersion.html
     */
    toDeregisterPackageVersion() {
        return this.to('DeregisterPackageVersion');
    }
    /**
     * Grants permission to view details about an AWS Panorama application
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_DescribeApp.html
     */
    toDescribeApp() {
        return this.to('DescribeApp');
    }
    /**
     * Grants permission to view details about a deployment for an AWS Panorama application
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_DescribeAppDeployment.html
     */
    toDescribeAppDeployment() {
        return this.to('DescribeAppDeployment');
    }
    /**
     * Grants permission to view details about a version of an AWS Panorama application
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_DescribeAppVersion.html
     */
    toDescribeAppVersion() {
        return this.to('DescribeAppVersion');
    }
    /**
     * Grants permission to view details about an AWS Panorama Application Instance
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_DescribeApplicationInstance.html
     */
    toDescribeApplicationInstance() {
        return this.to('DescribeApplicationInstance');
    }
    /**
     * Grants permission to view details about an AWS Panorama Application Instance
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_DescribeApplicationInstanceDetails.html
     */
    toDescribeApplicationInstanceDetails() {
        return this.to('DescribeApplicationInstanceDetails');
    }
    /**
     * Grants permission to view details about a datasource in AWS Panorama
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_DescribeDataSource.html
     */
    toDescribeDataSource() {
        return this.to('DescribeDataSource');
    }
    /**
     * Grants permission to view details about an AWS Panorama Appliance
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_DescribeDevice.html
     */
    toDescribeDevice() {
        return this.to('DescribeDevice');
    }
    /**
     * Grants permission to view job details for an AWS Panorama Appliance
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_DescribeDeviceJob.html
     */
    toDescribeDeviceJob() {
        return this.to('DescribeDeviceJob');
    }
    /**
     * Grants permission to view details about a machine learning model in AWS Panorama
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_DescribeModel.html
     */
    toDescribeModel() {
        return this.to('DescribeModel');
    }
    /**
     * Grants permission to view details about an AWS Panorama Node
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_DescribeNode.html
     */
    toDescribeNode() {
        return this.to('DescribeNode');
    }
    /**
     * Grants permission to view details about AWS Panorama Node
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_DescribeNodeFromTemplateJob.html
     */
    toDescribeNodeFromTemplateJob() {
        return this.to('DescribeNodeFromTemplateJob');
    }
    /**
     * Grants permission to view details about an AWS Panorama Package
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_DescribePackage.html
     */
    toDescribePackage() {
        return this.to('DescribePackage');
    }
    /**
     * Grants permission to view details about an AWS Panorama Package
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_DescribePackageImportJob.html
     */
    toDescribePackageImportJob() {
        return this.to('DescribePackageImportJob');
    }
    /**
     * Grants permission to view details about an AWS Panorama Package Version
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_DescribePackageVersion.html
     */
    toDescribePackageVersion() {
        return this.to('DescribePackageVersion');
    }
    /**
     * Grants permission to view details about a software version for the AWS Panorama Appliance
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_DescribeSoftware.html
     */
    toDescribeSoftware() {
        return this.to('DescribeSoftware');
    }
    /**
     * Grants permission to view details about a deployment configuration for an AWS Panorama application
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_GetDeploymentConfiguration.html
     */
    toGetDeploymentConfiguration() {
        return this.to('GetDeploymentConfiguration');
    }
    /**
     * Grants permission to retrieve a list of cameras generated with CreateInputs
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_GetInputList.html
     */
    toGetInputs() {
        return this.to('GetInputs');
    }
    /**
     * Grants permission to retrieve a list of streams generated with CreateStreams
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_GetStreamsList.html
     */
    toGetStreams() {
        return this.to('GetStreams');
    }
    /**
     * Grants permission to generate a WebSocket endpoint for communication with AWS Panorama
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_GetWebSocketURL.html
     */
    toGetWebSocketURL() {
        return this.to('GetWebSocketURL');
    }
    /**
     * Grants permission to retrieve a list of deployments for an AWS Panorama application
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_ListAppDeploymentOperations.html
     */
    toListAppDeploymentOperations() {
        return this.to('ListAppDeploymentOperations');
    }
    /**
     * Grants permission to retrieve a list of application versions in AWS Panorama
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_ListAppVersions.html
     */
    toListAppVersions() {
        return this.to('ListAppVersions');
    }
    /**
     * Grants permission to retrieve a list of application instance dependencies in AWS Panorama
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_ListApplicationInstanceDependencies.html
     */
    toListApplicationInstanceDependencies() {
        return this.to('ListApplicationInstanceDependencies');
    }
    /**
     * Grants permission to retrieve a list of node instances of application instances in AWS Panorama
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_ListApplicationInstanceNodeInstances.html
     */
    toListApplicationInstanceNodeInstances() {
        return this.to('ListApplicationInstanceNodeInstances');
    }
    /**
     * Grants permission to retrieve a list of application instances in AWS Panorama
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_ListApplicationInstances.html
     */
    toListApplicationInstances() {
        return this.to('ListApplicationInstances');
    }
    /**
     * Grants permission to retrieve a list of applications in AWS Panorama
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_ListApps.html
     */
    toListApps() {
        return this.to('ListApps');
    }
    /**
     * Grants permission to retrieve a list of datasources in AWS Panorama
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_ListDataSources.html
     */
    toListDataSources() {
        return this.to('ListDataSources');
    }
    /**
     * Grants permission to retrieve a list of deployment configurations in AWS Panorama
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_ListDeploymentConfigurations.html
     */
    toListDeploymentConfigurations() {
        return this.to('ListDeploymentConfigurations');
    }
    /**
     * Grants permission to retrieve a list of appliances in AWS Panorama
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_ListDevices.html
     */
    toListDevices() {
        return this.to('ListDevices');
    }
    /**
     * Grants permission to retrieve a list of jobs for an AWS Panorama Appliance
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_ListDevicesJobs.html
     */
    toListDevicesJobs() {
        return this.to('ListDevicesJobs');
    }
    /**
     * Grants permission to retrieve a list of models in AWS Panorama
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_ListModels.html
     */
    toListModels() {
        return this.to('ListModels');
    }
    /**
     * Grants permission to retrieve a list of Nodes for an AWS Panorama Appliance
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_ListNodeFromTemplateJobs.html
     */
    toListNodeFromTemplateJobs() {
        return this.to('ListNodeFromTemplateJobs');
    }
    /**
     * Grants permission to retrieve a list of nodes in AWS Panorama
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_ListNodes.html
     */
    toListNodes() {
        return this.to('ListNodes');
    }
    /**
     * Grants permission to retrieve a list of packages in AWS Panorama
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_ListPackageImportJobs.html
     */
    toListPackageImportJobs() {
        return this.to('ListPackageImportJobs');
    }
    /**
     * Grants permission to retrieve a list of packages in AWS Panorama
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_ListPackages.html
     */
    toListPackages() {
        return this.to('ListPackages');
    }
    /**
     * Grants permission to retrieve a list of tags for a resource in AWS Panorama
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_ListTagsForResource.html
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * Grants permission to register an AWS Panorama Appliance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_ProvisionDevice.html
     */
    toProvisionDevice() {
        return this.to('ProvisionDevice');
    }
    /**
     * Grants permission to register an AWS Panorama Package Version
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_RegisterPackageVersion.html
     */
    toRegisterPackageVersion() {
        return this.to('RegisterPackageVersion');
    }
    /**
     * Grants permission to remove an AWS Panorama Application Instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_RemoveApplicationInstance.html
     */
    toRemoveApplicationInstance() {
        return this.to('RemoveApplicationInstance');
    }
    /**
     * Grants permission to add tags to a resource in AWS Panorama
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_TagResource.html
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * Grants permission to remove tags from a resource in AWS Panorama
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_UntagResource.html
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * Grants permission to modify an AWS Panorama application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_UpdateApp.html
     */
    toUpdateApp() {
        return this.to('UpdateApp');
    }
    /**
     * Grants permission to modify the version-specific configuration of an AWS Panorama application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_UpdateAppConfiguration.html
     */
    toUpdateAppConfiguration() {
        return this.to('UpdateAppConfiguration');
    }
    /**
     * Grants permission to modify an AWS Panorama datasource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_UpdateDataSource.html
     */
    toUpdateDataSource() {
        return this.to('UpdateDataSource');
    }
    /**
     * Grants permission to modify basic settings for an AWS Panorama Appliance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_UpdateDeviceMetadata.html
     */
    toUpdateDeviceMetadata() {
        return this.to('UpdateDeviceMetadata');
    }
    /**
     * Adds a resource of type device to the statement
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/
     *
     * @param deviceId - Identifier for the deviceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onDevice(deviceId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:panorama:${region || '*'}:${account || '*'}:device/${deviceId}`);
    }
    /**
     * Adds a resource of type package to the statement
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/
     *
     * @param packageId - Identifier for the packageId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onPackage(packageId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:panorama:${region || '*'}:${account || '*'}:package/${packageId}`);
    }
    /**
     * Adds a resource of type applicationInstance to the statement
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/
     *
     * @param applicationInstanceId - Identifier for the applicationInstanceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onApplicationInstance(applicationInstanceId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:panorama:${region || '*'}:${account || '*'}:applicationInstance/${applicationInstanceId}`);
    }
    /**
     * Adds a resource of type dataSource to the statement
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/
     *
     * @param deviceId - Identifier for the deviceId.
     * @param dataSourceName - Identifier for the dataSourceName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onDataSource(deviceId, dataSourceName, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:panorama:${region || '*'}:${account || '*'}:dataSource/${deviceId}/${dataSourceName}`);
    }
    /**
     * Adds a resource of type model to the statement
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/
     *
     * @param modelName - Identifier for the modelName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onModel(modelName, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:panorama:${region || '*'}:${account || '*'}:model/${modelName}`);
    }
    /**
     * Adds a resource of type app to the statement
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/
     *
     * @param appName - Identifier for the appName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onApp(appName, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:panorama:${region || '*'}:${account || '*'}:app/${appName}`);
    }
    /**
     * Adds a resource of type appVersion to the statement
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/
     *
     * @param appName - Identifier for the appName.
     * @param appVersion - Identifier for the appVersion.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onAppVersion(appName, appVersion, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:panorama:${region || '*'}:${account || '*'}:app/${appName}:${appVersion}`);
    }
}
exports.Panorama = Panorama;
_a = JSII_RTTI_SYMBOL_1;
Panorama[_a] = { fqn: "cdk-iam-floyd.Panorama", version: "0.345.0" };
//# sourceMappingURL=data:application/json;base64,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