"""Growatt Sensor definitions for the Inverter type."""
from __future__ import annotations

from homeassistant.components.sensor import SensorDeviceClass, SensorStateClass
from homeassistant.const import (
    ELECTRIC_CURRENT_AMPERE,
    ELECTRIC_POTENTIAL_VOLT,
    ENERGY_KILO_WATT_HOUR,
    FREQUENCY_HERTZ,
    POWER_WATT,
    TEMP_CELSIUS,
)

from .sensor_entity_description import GrowattSensorEntityDescription

INVERTER_SENSOR_TYPES: tuple[GrowattSensorEntityDescription, ...] = (
    GrowattSensorEntityDescription(
        key="inverter_energy_today",
        name="Energy today",
        api_key="powerToday",
        native_unit_of_measurement=ENERGY_KILO_WATT_HOUR,
        device_class=SensorDeviceClass.ENERGY,
        precision=1,
    ),
    GrowattSensorEntityDescription(
        key="inverter_energy_total",
        name="Lifetime energy output",
        api_key="powerTotal",
        native_unit_of_measurement=ENERGY_KILO_WATT_HOUR,
        device_class=SensorDeviceClass.ENERGY,
        precision=1,
        state_class=SensorStateClass.TOTAL,
    ),
    GrowattSensorEntityDescription(
        key="inverter_voltage_input_1",
        name="Input 1 voltage",
        api_key="vpv1",
        native_unit_of_measurement=ELECTRIC_POTENTIAL_VOLT,
        device_class=SensorDeviceClass.VOLTAGE,
        precision=2,
    ),
    GrowattSensorEntityDescription(
        key="inverter_amperage_input_1",
        name="Input 1 Amperage",
        api_key="ipv1",
        native_unit_of_measurement=ELECTRIC_CURRENT_AMPERE,
        device_class=SensorDeviceClass.CURRENT,
        precision=1,
    ),
    GrowattSensorEntityDescription(
        key="inverter_wattage_input_1",
        name="Input 1 Wattage",
        api_key="ppv1",
        native_unit_of_measurement=POWER_WATT,
        device_class=SensorDeviceClass.POWER,
        precision=1,
    ),
    GrowattSensorEntityDescription(
        key="inverter_voltage_input_2",
        name="Input 2 voltage",
        api_key="vpv2",
        native_unit_of_measurement=ELECTRIC_POTENTIAL_VOLT,
        device_class=SensorDeviceClass.VOLTAGE,
        precision=1,
    ),
    GrowattSensorEntityDescription(
        key="inverter_amperage_input_2",
        name="Input 2 Amperage",
        api_key="ipv2",
        native_unit_of_measurement=ELECTRIC_CURRENT_AMPERE,
        device_class=SensorDeviceClass.CURRENT,
        precision=1,
    ),
    GrowattSensorEntityDescription(
        key="inverter_wattage_input_2",
        name="Input 2 Wattage",
        api_key="ppv2",
        native_unit_of_measurement=POWER_WATT,
        device_class=SensorDeviceClass.POWER,
        precision=1,
    ),
    GrowattSensorEntityDescription(
        key="inverter_voltage_input_3",
        name="Input 3 voltage",
        api_key="vpv3",
        native_unit_of_measurement=ELECTRIC_POTENTIAL_VOLT,
        device_class=SensorDeviceClass.VOLTAGE,
        precision=1,
    ),
    GrowattSensorEntityDescription(
        key="inverter_amperage_input_3",
        name="Input 3 Amperage",
        api_key="ipv3",
        native_unit_of_measurement=ELECTRIC_CURRENT_AMPERE,
        device_class=SensorDeviceClass.CURRENT,
        precision=1,
    ),
    GrowattSensorEntityDescription(
        key="inverter_wattage_input_3",
        name="Input 3 Wattage",
        api_key="ppv3",
        native_unit_of_measurement=POWER_WATT,
        device_class=SensorDeviceClass.POWER,
        precision=1,
    ),
    GrowattSensorEntityDescription(
        key="inverter_internal_wattage",
        name="Internal wattage",
        api_key="ppv",
        native_unit_of_measurement=POWER_WATT,
        device_class=SensorDeviceClass.POWER,
        precision=1,
    ),
    GrowattSensorEntityDescription(
        key="inverter_reactive_voltage",
        name="Reactive voltage",
        api_key="vacr",
        native_unit_of_measurement=ELECTRIC_POTENTIAL_VOLT,
        device_class=SensorDeviceClass.VOLTAGE,
        precision=1,
    ),
    GrowattSensorEntityDescription(
        key="inverter_inverter_reactive_amperage",
        name="Reactive amperage",
        api_key="iacr",
        native_unit_of_measurement=ELECTRIC_CURRENT_AMPERE,
        device_class=SensorDeviceClass.CURRENT,
        precision=1,
    ),
    GrowattSensorEntityDescription(
        key="inverter_frequency",
        name="AC frequency",
        api_key="fac",
        native_unit_of_measurement=FREQUENCY_HERTZ,
        precision=1,
    ),
    GrowattSensorEntityDescription(
        key="inverter_current_wattage",
        name="Output power",
        api_key="pac",
        native_unit_of_measurement=POWER_WATT,
        device_class=SensorDeviceClass.POWER,
        precision=1,
    ),
    GrowattSensorEntityDescription(
        key="inverter_current_reactive_wattage",
        name="Reactive wattage",
        api_key="pacr",
        native_unit_of_measurement=POWER_WATT,
        device_class=SensorDeviceClass.POWER,
        precision=1,
    ),
    GrowattSensorEntityDescription(
        key="inverter_ipm_temperature",
        name="Intelligent Power Management temperature",
        api_key="ipmTemperature",
        native_unit_of_measurement=TEMP_CELSIUS,
        device_class=SensorDeviceClass.TEMPERATURE,
        precision=1,
    ),
    GrowattSensorEntityDescription(
        key="inverter_temperature",
        name="Temperature",
        api_key="temperature",
        native_unit_of_measurement=TEMP_CELSIUS,
        device_class=SensorDeviceClass.TEMPERATURE,
        precision=1,
    ),
)
