PRAGMA foreign_keys=OFF;
BEGIN TRANSACTION;
CREATE TABLE data_source (
	id INTEGER NOT NULL, 
	name VARCHAR(100), 
	uri VARCHAR(200), 
	md5 VARCHAR(32), 
	notes VARCHAR(1000), 
	PRIMARY KEY (id), 
	UNIQUE (md5)
);
INSERT INTO data_source VALUES(1,'Import of controls.fasta','controls.fasta','edb7776a3eb1b0bf999aca6cc8069ea0','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(2,'Import of 2019-BL-1B_S117_L001.fasta','single_isolates/2019-BL-1B_S117_L001.fasta','410868d1b3a20dae9588e2dec224d35d','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(3,'Import of 2019-Pp2_S176_L001.fasta','single_isolates/2019-Pp2_S176_L001.fasta','635eba28bca958be156600f5a76fa130','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(4,'Import of 75-BT3-1gDNA-P-austrocedrae-F08_S68_L001.fasta','single_isolates/75-BT3-1gDNA-P-austrocedrae-F08_S68_L001.fasta','b9d033fb512a938bbd43a9d37a02617a','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(5,'Import of 76-GA3-1gDNA-P-austrocedrae-G08_S80_L001.fasta','single_isolates/76-GA3-1gDNA-P-austrocedrae-G08_S80_L001.fasta','a0f23279ec301b6e24fbd917bca8f9d2','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(6,'Import of 78-CPB-DNA-from-FR-dil-1-100-P-obscura-H08_S92_L001.fasta','single_isolates/78-CPB-DNA-from-FR-dil-1-100-P-obscura-H08_S92_L001.fasta','24e99e17cc8762f1f3a3be3b70ab8251','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(7,'Import of 88069-P-infestans-56-A04_S4_L001.fasta','single_isolates/88069-P-infestans-56-A04_S4_L001.fasta','0c3feb4c0fe4dbcee2a8211e45c88c0b','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(8,'Import of P-Europaea-DNA-from-FR-dil-1-100-F07_S67_L001.fasta','single_isolates/P-Europaea-DNA-from-FR-dil-1-100-F07_S67_L001.fasta','be94bad04e61973e3cedafcbee01049c','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(9,'Import of P-cinnamomi-82-1-10-A07_S7_L001.fasta','single_isolates/P-cinnamomi-82-1-10-A07_S7_L001.fasta','e908d7662bf813cbbd1579bab316a2cc','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(10,'Import of P-foliorum_S165_L001.fasta','single_isolates/P-foliorum_S165_L001.fasta','ef558628310ffd3f7ab3b453456817f1','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(11,'Import of Pd2c_S105_L001.fasta','single_isolates/Pd2c_S105_L001.fasta','48cd9b09775236178a0e605caa41bd7c','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(12,'Import of RG161_S139_L001.fasta','single_isolates/RG161_S139_L001.fasta','ce517ab8e7df28177f0d0d3f158c5306','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(13,'Import of SCRP-1161-P-austrocedrae-1-C03_S27_L001.fasta','single_isolates/SCRP-1161-P-austrocedrae-1-C03_S27_L001.fasta','f8969263fa5826630533a64c813e2622','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(14,'Import of SCRP-1161-P-austrocedrae-1-G01_S73_L001.fasta','single_isolates/SCRP-1161-P-austrocedrae-1-G01_S73_L001.fasta','46ad4dde36e46288c54f50aa539aac1f','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(15,'Import of SCRP-1161-P-austrocedrae-2-D03_S39_L001.fasta','single_isolates/SCRP-1161-P-austrocedrae-2-D03_S39_L001.fasta','3713ec1a19429c90b78022103c55b4e2','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(16,'Import of SCRP-1161-P-austrocedrae-2-D10_S46_L001.fasta','single_isolates/SCRP-1161-P-austrocedrae-2-D10_S46_L001.fasta','868c7b450a4c7bc23654eb5c3887518b','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(17,'Import of SCRP-1161-P-austrocedrae-2-H01_S85_L001.fasta','single_isolates/SCRP-1161-P-austrocedrae-2-H01_S85_L001.fasta','2af51b23a7044a5bac99cbc22d2f69a5','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(18,'Import of SCRP-1161-P-austrocedrae-3-A02_S2_L001.fasta','single_isolates/SCRP-1161-P-austrocedrae-3-A02_S2_L001.fasta','542a75fb4f1200fb53f85b8295721ced','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(19,'Import of SCRP-1161-P-austrocedrae-3-E03_S51_L001.fasta','single_isolates/SCRP-1161-P-austrocedrae-3-E03_S51_L001.fasta','a11ec91a4bb7ab5783f89cdacb64acc5','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(20,'Import of SCRP-1161-P-austrocedrae-3-E10_S58_L001.fasta','single_isolates/SCRP-1161-P-austrocedrae-3-E10_S58_L001.fasta','7f77d2ca72611ab2fbc097df1ebf0498','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(21,'Import of SCRP-1163-P-gonapodyides-C06_S30_L001.fasta','single_isolates/SCRP-1163-P-gonapodyides-C06_S30_L001.fasta','e3becd9bca1b9dae7d64b57bac23d5f2','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(22,'Import of SCRP-1170-P-Erythroseptica-B08_S20_L001.fasta','single_isolates/SCRP-1170-P-Erythroseptica-B08_S20_L001.fasta','ab5969cfa74cbdfae2e8709c6e8a1db2','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(23,'Import of SCRP-1171-P-Erythroseptica-C08_S32_L001.fasta','single_isolates/SCRP-1171-P-Erythroseptica-C08_S32_L001.fasta','5e4b1918da6bddba2762de9d43d42229','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(24,'Import of SCRP-1197-P-nicotianae-50-or-51-C04_S28_L001.fasta','single_isolates/SCRP-1197-P-nicotianae-50-or-51-C04_S28_L001.fasta','0930f783ab98db5c23d4258a638b238f','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(25,'Import of SCRP-734-P-pseudosyringae-1-D01_S37_L001.fasta','single_isolates/SCRP-734-P-pseudosyringae-1-D01_S37_L001.fasta','2cccb1400e24c869165229914a18c522','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(26,'Import of SCRP-734-P-pseudosyringae-1-H02_S86_L001.fasta','single_isolates/SCRP-734-P-pseudosyringae-1-H02_S86_L001.fasta','52691ec02b9f2c0e06aba8e34def7dae','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(27,'Import of SCRP-734-P-pseudosyringae-2-A03_S3_L001.fasta','single_isolates/SCRP-734-P-pseudosyringae-2-A03_S3_L001.fasta','4a9fee9d3ea2d3e6fee66422dea7bb1a','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(28,'Import of SCRP-734-P-pseudosyringae-2-A10_S10_L001.fasta','single_isolates/SCRP-734-P-pseudosyringae-2-A10_S10_L001.fasta','fdf9cbab00b6ef0f2c1e49899c933c5e','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(29,'Import of SCRP-734-P-pseudosyringae-2-E01_S49_L001.fasta','single_isolates/SCRP-734-P-pseudosyringae-2-E01_S49_L001.fasta','c5b212be82d798ce53d8e8abf866c6a8','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(30,'Import of SCRP-734-P-pseudosyringae-3-B03_S15_L001.fasta','single_isolates/SCRP-734-P-pseudosyringae-3-B03_S15_L001.fasta','85a836986733ee22e41de822b4e53a09','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(31,'Import of SCRP-734-P-pseudosyringae-3-B10_S22_L001.fasta','single_isolates/SCRP-734-P-pseudosyringae-3-B10_S22_L001.fasta','66dc12b09af8d0ab08b974b6c52956bf','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(32,'Import of SCRP-734-P-pseudosyringae-3-F01_S61_L001.fasta','single_isolates/SCRP-734-P-pseudosyringae-3-F01_S61_L001.fasta','ee1d2a67f92a04c637636511acc02ab0','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(33,'Import of SCRP10-P-aln-G06_S78_L001.fasta','single_isolates/SCRP10-P-aln-G06_S78_L001.fasta','f8f27981a37a487e1519569b4e435b60','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(34,'Import of SCRP1022-P-capsici-40-B05_S17_L001.fasta','single_isolates/SCRP1022-P-capsici-40-B05_S17_L001.fasta','de4e34757e41d78cd06e0971ec4f5f48','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(35,'Import of SCRP1161-P-austrocedrae-1-20-1-C10_S34_L001.fasta','single_isolates/SCRP1161-P-austrocedrae-1-20-1-C10_S34_L001.fasta','08c99d3effea5a8d7bd23ed7042c27d1','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(36,'Import of SCRP1162-P-austrocedrae-E08_S56_L001.fasta','single_isolates/SCRP1162-P-austrocedrae-E08_S56_L001.fasta','c4bb3e46150402c1e226f0a1905ea1a4','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(37,'Import of SCRP1218_S174_L001.fasta','single_isolates/SCRP1218_S174_L001.fasta','40c5346460c7092a496554815167bc0a','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(38,'Import of SCRP1220_S151_L001.fasta','single_isolates/SCRP1220_S151_L001.fasta','20457e003ea03927c65e4a502da9910e','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(39,'Import of SCRP1222_S187_L001.fasta','single_isolates/SCRP1222_S187_L001.fasta','3250d35908ce49b9ec60660f6c170c33','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(40,'Import of SCRP1226_S186_L001.fasta','single_isolates/SCRP1226_S186_L001.fasta','d29f93bed44dbc54d419e9601a31ef0c','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(41,'Import of SCRP1227_S103_L001.fasta','single_isolates/SCRP1227_S103_L001.fasta','e60694b4ef3d691de374936234e377f0','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(42,'Import of SCRP165-P-citricola-T-60-D05_S41_L001.fasta','single_isolates/SCRP165-P-citricola-T-60-D05_S41_L001.fasta','3879365d7d1df03d7196fa2decaa68f2','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(43,'Import of SCRP179_S177_L001.fasta','single_isolates/SCRP179_S177_L001.fasta','f658223ca78a1d1f1013abcc387f9b00','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(44,'Import of SCRP207-P-Cryptogea-72-or-73-A08_S8_L001.fasta','single_isolates/SCRP207-P-Cryptogea-72-or-73-A08_S8_L001.fasta','5a677701dd0859de85bf4b312334ff9b','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(45,'Import of SCRP23-P-boehmeriae-1-B09_S21_L001.fasta','single_isolates/SCRP23-P-boehmeriae-1-B09_S21_L001.fasta','e0717d26d51db4824192dd5efca69f4d','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(46,'Import of SCRP231-P-cajani-71-1-10-C07_S31_L001.fasta','single_isolates/SCRP231-P-cajani-71-1-10-C07_S31_L001.fasta','51feea1bd7f7ad00bfa1ba1511adb456','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(47,'Import of SCRP333-P-rubi-race-3-45-E07_S55_L001.fasta','single_isolates/SCRP333-P-rubi-race-3-45-E07_S55_L001.fasta','e5cb0b82772fa9c9eaad1c47316bee02','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(48,'Import of SCRP35-1-or-2-P-cactorum-CAC17-R222-E04_S52_L001.fasta','single_isolates/SCRP35-1-or-2-P-cactorum-CAC17-R222-E04_S52_L001.fasta','f3a196ad5363cb2c98aa6957d6883ac7','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(49,'Import of SCRP37-P-cactorum-CAC19-145H-F04_S64_L001.fasta','single_isolates/SCRP37-P-cactorum-CAC19-145H-F04_S64_L001.fasta','2ef825ce0e519fa051c3188aa22828a7','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(50,'Import of SCRP371-P-idaei-41-A05_S5_L001.fasta','single_isolates/SCRP371-P-idaei-41-A05_S5_L001.fasta','bd71cd2dc3f11e28bf1f60a06377b35b','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(51,'Import of SCRP372-P-idaei-47-H04_S88_L001.fasta','single_isolates/SCRP372-P-idaei-47-H04_S88_L001.fasta','c5ffdbf050c1bea2f9e054bbd35d4cbc','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(52,'Import of SCRP377-P-ilicis-62-E05_S53_L001.fasta','single_isolates/SCRP377-P-ilicis-62-E05_S53_L001.fasta','aa05088fdddbcdef3efa42d63b8f762c','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(53,'Import of SCRP386-P-iranica-48-D04_S40_L001.fasta','single_isolates/SCRP386-P-iranica-48-D04_S40_L001.fasta','d057c13577581d15d1071c1791406044','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(54,'Import of SCRP388-P-castaneae-44-H05_S89_L001.fasta','single_isolates/SCRP388-P-castaneae-44-H05_S89_L001.fasta','73903eca1d478b0ef7af0f34c3bb55ac','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(55,'Import of SCRP390_S129_L001.fasta','single_isolates/SCRP390_S129_L001.fasta','9311bd8dea14d0d9937bfa6e9866e25e','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(56,'Import of SCRP417-1-OR-2-P-megasperma-B06_S18_L001.fasta','single_isolates/SCRP417-1-OR-2-P-megasperma-B06_S18_L001.fasta','c0a24e66621635578470beb91eced8ff','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(57,'Import of SCRP420-P-megasperma-66-A06_S6_L001.fasta','single_isolates/SCRP420-P-megasperma-66-A06_S6_L001.fasta','5acf6c06b4d62f75a6e123db53a6296c','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(58,'Import of SCRP455-P-melonis-70-B07_S19_L001.fasta','single_isolates/SCRP455-P-melonis-70-B07_S19_L001.fasta','4b0bf6de70eb3d7f579886718b79c628','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(59,'Import of SCRP474-P-palmivora-11-F05_S65_L001.fasta','single_isolates/SCRP474-P-palmivora-11-F05_S65_L001.fasta','3befac09d8878973c82e7eb44fcfa3d0','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(60,'Import of SCRP526-P-palmivora-64A-G05_S77_L001.fasta','single_isolates/SCRP526-P-palmivora-64A-G05_S77_L001.fasta','f8ca44626ff7db82d9058334cbc24cea','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(61,'Import of SCRP56-P-cactorum-CH97-46-G04_S76_L001.fasta','single_isolates/SCRP56-P-cactorum-CH97-46-G04_S76_L001.fasta','eb4672cd94ded5acded4804cb58fac98','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(62,'Import of SCRP607-P-fallax-12-A09_S9_L001.fasta','single_isolates/SCRP607-P-fallax-12-A09_S9_L001.fasta','eee190f0dcd5ef525330aa6749178139','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(63,'Import of SCRP645-P-inundata-68-D06_S42_L001.fasta','single_isolates/SCRP645-P-inundata-68-D06_S42_L001.fasta','c3fb81d5717bde4e7c02724b14aa91b5','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(64,'Import of SCRP660-P-syringae-83-H07_S91_L001.fasta','single_isolates/SCRP660-P-syringae-83-H07_S91_L001.fasta','0d64fab90e2d9adb856694021488ccb0','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(65,'Import of SCRP660_S153_L001.fasta','single_isolates/SCRP660_S153_L001.fasta','f3d25ef3e862f31f1f8db427c41a14a2','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(66,'Import of SCRP71-P-cambivora-69-cam5-H06_S90_L001.fasta','single_isolates/SCRP71-P-cambivora-69-cam5-H06_S90_L001.fasta','c5dc489ab31a75f6c71f358693c6f7e5','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(67,'Import of SCRP722_S141_L001.fasta','single_isolates/SCRP722_S141_L001.fasta','4c872ee9200a34b28e7875ead4824085','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(68,'Import of SCRP734-1-or-2-P-pseudosyringae-1-H09_S93_L001.fasta','single_isolates/SCRP734-1-or-2-P-pseudosyringae-1-H09_S93_L001.fasta','74999328eb896c5a45fc0312555198cb','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(69,'Import of SCRP893-P-sojae-22-D07_S43_L001.fasta','single_isolates/SCRP893-P-sojae-22-D07_S43_L001.fasta','6fa60abf7f948991beb77b07ee6c2d83','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(70,'Import of SCRP9-P-aln-F06_S66_L001.fasta','single_isolates/SCRP9-P-aln-F06_S66_L001.fasta','c75bffcc1dbe0796d93ce8a94260e480','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(71,'Import of SRCP1221_S175_L001.fasta','single_isolates/SRCP1221_S175_L001.fasta','54911ef6e9117cbbd553c59aa227bc33','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(72,'Import of T-30-4-1-A01_S1_L001.fasta','single_isolates/T-30-4-1-A01_S1_L001.fasta','80c04900062c2ba8e982b2fb637f51f3','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(73,'Import of T-30-4-1-E02_S50_L001.fasta','single_isolates/T-30-4-1-E02_S50_L001.fasta','34c531f18befe1491edcbc07ec012e4d','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(74,'Import of T-30-4-2-B01_S13_L001.fasta','single_isolates/T-30-4-2-B01_S13_L001.fasta','f9fc3f1112d2884a014b3ffdc2aa30da','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(75,'Import of T-30-4-2-F02_S62_L001.fasta','single_isolates/T-30-4-2-F02_S62_L001.fasta','8adbc9331abd7ee1773c7e0d3f905be9','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(76,'Import of T-30-4-2-F09_S69_L001.fasta','single_isolates/T-30-4-2-F09_S69_L001.fasta','83a1a21c498a999507a8ec35c86417b0','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(77,'Import of T-30-4-3-C01_S25_L001.fasta','single_isolates/T-30-4-3-C01_S25_L001.fasta','f6e61f47db1ba63aecc7d0734931542b','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(78,'Import of T-30-4-3-G02_S74_L001.fasta','single_isolates/T-30-4-3-G02_S74_L001.fasta','491646427d79cb86f4e5197e3e4708da','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(79,'Import of T-30-4-3-G09_S81_L001.fasta','single_isolates/T-30-4-3-G09_S81_L001.fasta','de47994e2847642ce2f866cc7effe56d','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(80,'Import of T30-4-P-infestans-55-1-20-1-E09_S57_L001.fasta','single_isolates/T30-4-P-infestans-55-1-20-1-E09_S57_L001.fasta','f5a8a74f793605f8ae25dd951a6fb5e9','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(81,'Import of WL54_S128_L001.fasta','single_isolates/WL54_S128_L001.fasta','23ea6eb01b59cb5325acfc772383f218','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(82,'Import of WL77_S152_L001.fasta','single_isolates/WL77_S152_L001.fasta','8793ff33cef54442371a8943b666df7c','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(83,'Import of 2022-07-05_ITS1_Oomycota_obs.fasta','2022-07-05_ITS1_Oomycota_obs.fasta','f63b69f776310b434e21248ca50963eb','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(84,'Import of 2022-07-05_ITS1_Oomycota_w32.fasta','2022-07-05_ITS1_Oomycota_w32.fasta','08ba14e81908c54801513e4944509593','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(85,'Import of Nothophytophthora_ITS1_curated.fasta','Nothophytophthora_ITS1_curated.fasta','a8ce79c75a0e7cf55d5c32322c75789d','ITS1 imported with thapbi_pict v0.12.6');
INSERT INTO data_source VALUES(86,'Import of Phytophthora_ITS1_curated.fasta','Phytophthora_ITS1_curated.fasta','f83db1d50db5405c217900f881d0df63','ITS1 imported with thapbi_pict v0.12.6');
CREATE TABLE taxonomy (
	id INTEGER NOT NULL, 
	ncbi_taxid INTEGER, 
	genus VARCHAR(100) NOT NULL, 
	species VARCHAR(100) NOT NULL, 
	PRIMARY KEY (id)
);
INSERT INTO taxonomy VALUES(1,4765,'Achlya','');
INSERT INTO taxonomy VALUES(2,4769,'Saprolegnia','');
INSERT INTO taxonomy VALUES(3,4778,'Bremia','');
INSERT INTO taxonomy VALUES(4,4780,'Plasmopara','');
INSERT INTO taxonomy VALUES(5,4783,'Phytophthora','');
INSERT INTO taxonomy VALUES(6,4797,'Pythium','');
INSERT INTO taxonomy VALUES(7,4802,'Lagenidium','');
INSERT INTO taxonomy VALUES(8,65356,'Albugo','');
INSERT INTO taxonomy VALUES(9,70742,'Peronospora','');
INSERT INTO taxonomy VALUES(10,74556,'Thraustotheca','');
INSERT INTO taxonomy VALUES(11,74559,'Dictyuchus','');
INSERT INTO taxonomy VALUES(12,92968,'Pythiopsis','');
INSERT INTO taxonomy VALUES(13,92971,'Aplanopsis','');
INSERT INTO taxonomy VALUES(14,92975,'Leptolegnia','');
INSERT INTO taxonomy VALUES(15,92980,'Apodachlya','');
INSERT INTO taxonomy VALUES(16,100860,'Aphanomyces','');
INSERT INTO taxonomy VALUES(17,100862,'Plectospira','');
INSERT INTO taxonomy VALUES(18,100865,'Leptomitus','');
INSERT INTO taxonomy VALUES(19,100873,'Sapromyces','');
INSERT INTO taxonomy VALUES(20,112093,'Brevilegnia','');
INSERT INTO taxonomy VALUES(21,120399,'Aplanes','');
INSERT INTO taxonomy VALUES(22,120403,'Calyptralegnia','');
INSERT INTO taxonomy VALUES(23,120410,'Pachymetra','');
INSERT INTO taxonomy VALUES(24,120422,'Scoliolegnia','');
INSERT INTO taxonomy VALUES(25,127445,'Halophytophthora','');
INSERT INTO taxonomy VALUES(26,134688,'Isoachlya','');
INSERT INTO taxonomy VALUES(27,135472,'Haliphthoros','');
INSERT INTO taxonomy VALUES(28,135475,'Atkinsiella','');
INSERT INTO taxonomy VALUES(29,135478,'Halocrusticida','');
INSERT INTO taxonomy VALUES(30,143452,'Pseudoperonospora','');
INSERT INTO taxonomy VALUES(31,159316,'Eurychasma','');
INSERT INTO taxonomy VALUES(32,162127,'Basidiophora','');
INSERT INTO taxonomy VALUES(33,162129,'Sclerospora','');
INSERT INTO taxonomy VALUES(34,162131,'Paraperonospora','');
INSERT INTO taxonomy VALUES(35,184462,'Hyaloperonospora','');
INSERT INTO taxonomy VALUES(36,184464,'Perofascia','');
INSERT INTO taxonomy VALUES(37,230838,'Peronosclerospora','');
INSERT INTO taxonomy VALUES(38,244731,'Viennotia','');
INSERT INTO taxonomy VALUES(39,335372,'Protobremia','');
INSERT INTO taxonomy VALUES(40,369777,'Benua','');
INSERT INTO taxonomy VALUES(41,369781,'Plasmoverna','');
INSERT INTO taxonomy VALUES(42,369783,'Graminivora','');
INSERT INTO taxonomy VALUES(43,371951,'Protoachlya','');
INSERT INTO taxonomy VALUES(44,377433,'Haptoglossa','');
INSERT INTO taxonomy VALUES(45,414971,'Halodaphnea','');
INSERT INTO taxonomy VALUES(46,416807,'Olpidiopsis','');
INSERT INTO taxonomy VALUES(47,421926,'Diasporangium','');
INSERT INTO taxonomy VALUES(48,442664,'Myzocytiopsis','');
INSERT INTO taxonomy VALUES(49,461276,'Novotelnova','');
INSERT INTO taxonomy VALUES(50,467175,'Sclerophthora','');
INSERT INTO taxonomy VALUES(51,485443,'Chlamydomyzium','');
INSERT INTO taxonomy VALUES(52,572136,'Wilsoniana','');
INSERT INTO taxonomy VALUES(53,572138,'Pustula','');
INSERT INTO taxonomy VALUES(54,650118,'Halioticida','');
INSERT INTO taxonomy VALUES(55,795339,'Phytopythium','');
INSERT INTO taxonomy VALUES(56,944615,'Pythiogeton','');
INSERT INTO taxonomy VALUES(57,983658,'Salisapilia','');
INSERT INTO taxonomy VALUES(58,1009718,'Eraphthora','');
INSERT INTO taxonomy VALUES(59,1432540,'Geolegnia','');
INSERT INTO taxonomy VALUES(60,1440114,'Paralagenidium','');
INSERT INTO taxonomy VALUES(61,1448050,'Elongisporangium','');
INSERT INTO taxonomy VALUES(62,1448052,'Globisporangium','');
INSERT INTO taxonomy VALUES(63,1489788,'Lagena','');
INSERT INTO taxonomy VALUES(64,1495611,'Aquastella','');
INSERT INTO taxonomy VALUES(65,1618012,'Newbya','');
INSERT INTO taxonomy VALUES(66,1635158,'Pilasporangium','');
INSERT INTO taxonomy VALUES(67,1663099,'Anisolpidium','');
INSERT INTO taxonomy VALUES(68,1672053,'Blastulidium','');
INSERT INTO taxonomy VALUES(69,1682048,'Lagenisma','');
INSERT INTO taxonomy VALUES(70,1702222,'Salilagenidium','');
INSERT INTO taxonomy VALUES(71,1729147,'Phragmosporangium','');
INSERT INTO taxonomy VALUES(72,1779447,'Baobabopsis','');
INSERT INTO taxonomy VALUES(73,1862710,'Salispina','');
INSERT INTO taxonomy VALUES(74,2025987,'Nothophytophthora','');
INSERT INTO taxonomy VALUES(75,2050023,'Calycofera','');
INSERT INTO taxonomy VALUES(76,2182427,'Crypticola','');
INSERT INTO taxonomy VALUES(77,2203426,'Miracula','');
INSERT INTO taxonomy VALUES(78,2494380,'Ectrogella','');
INSERT INTO taxonomy VALUES(79,2494382,'Pontisma','');
INSERT INTO taxonomy VALUES(80,2681695,'Diatomophthora','');
INSERT INTO taxonomy VALUES(81,2793140,'Aphanomycopsis','');
INSERT INTO taxonomy VALUES(82,2803946,'Sirolpidium','');
INSERT INTO taxonomy VALUES(83,2815746,'Periplasma','');
INSERT INTO taxonomy VALUES(84,2874106,'Bolbea','');
INSERT INTO taxonomy VALUES(85,4766,'Achlya','bisexualis');
INSERT INTO taxonomy VALUES(86,4767,'Achlya','klebsiana');
INSERT INTO taxonomy VALUES(87,4768,'Achlya','ambisexualis');
INSERT INTO taxonomy VALUES(88,4770,'Saprolegnia','ferax');
INSERT INTO taxonomy VALUES(89,4779,'Bremia','lactucae');
INSERT INTO taxonomy VALUES(90,4781,'Plasmopara','halstedii');
INSERT INTO taxonomy VALUES(91,4784,'Phytophthora','capsici');
INSERT INTO taxonomy VALUES(92,4785,'Phytophthora','cinnamomi');
INSERT INTO taxonomy VALUES(93,4786,'Phytophthora','cryptogea');
INSERT INTO taxonomy VALUES(94,4787,'Phytophthora','infestans');
INSERT INTO taxonomy VALUES(95,4788,'Phytophthora','megasperma');
INSERT INTO taxonomy VALUES(96,4790,'Phytophthora','nicotianae');
INSERT INTO taxonomy VALUES(97,4792,'Phytophthora','parasitica');
INSERT INTO taxonomy VALUES(98,4793,'Phytophthora','citrophthora');
INSERT INTO taxonomy VALUES(99,4794,'Phytophthora','drechsleri');
INSERT INTO taxonomy VALUES(100,4795,'Phytophthora','megakarya');
INSERT INTO taxonomy VALUES(101,4796,'Phytophthora','palmivora');
INSERT INTO taxonomy VALUES(102,4798,'Pythium','hydnosporum');
INSERT INTO taxonomy VALUES(103,4799,'Pythium','torulosum');
INSERT INTO taxonomy VALUES(104,4803,'Lagenidium','giganteum');
INSERT INTO taxonomy VALUES(105,29920,'Phytophthora','cactorum');
INSERT INTO taxonomy VALUES(106,36331,'Globisporangium','irregulare');
INSERT INTO taxonomy VALUES(107,37553,'Saprolegnia','monoica');
INSERT INTO taxonomy VALUES(108,41045,'Pythium','oligandrum');
INSERT INTO taxonomy VALUES(109,49446,'Pythium','pachycaule');
INSERT INTO taxonomy VALUES(110,53983,'Phytophthora','cambivora');
INSERT INTO taxonomy VALUES(111,53984,'Phytophthora','citricola');
INSERT INTO taxonomy VALUES(112,53985,'Phytophthora','fragariae');
INSERT INTO taxonomy VALUES(113,53986,'Phytophthora','idaei');
INSERT INTO taxonomy VALUES(114,53987,'Phytophthora','pseudotsugae');
INSERT INTO taxonomy VALUES(115,54510,'Phytophthora','medicaginis');
INSERT INTO taxonomy VALUES(116,54511,'Phytophthora','trifolii');
INSERT INTO taxonomy VALUES(117,65069,'Pythium','acanthicum');
INSERT INTO taxonomy VALUES(118,65070,'Pythium','aphanidermatum');
INSERT INTO taxonomy VALUES(119,65357,'Albugo','candida');
INSERT INTO taxonomy VALUES(120,67591,'Phytophthora','macrochlamydospora');
INSERT INTO taxonomy VALUES(121,67592,'Phytophthora','iranica');
INSERT INTO taxonomy VALUES(122,67593,'Phytophthora','sojae');
INSERT INTO taxonomy VALUES(123,67594,'Phytophthora','syringae');
INSERT INTO taxonomy VALUES(124,67595,'Phytophthora','vignae');
INSERT INTO taxonomy VALUES(125,70743,'Peronospora','sparsa');
INSERT INTO taxonomy VALUES(126,74555,'Achlya','intricata');
INSERT INTO taxonomy VALUES(127,74557,'Thraustotheca','clavata');
INSERT INTO taxonomy VALUES(128,74560,'Dictyuchus','sterilis');
INSERT INTO taxonomy VALUES(129,78236,'Phytophthora','quercina');
INSERT INTO taxonomy VALUES(130,78237,'Phytophthora','gonapodyides');
INSERT INTO taxonomy VALUES(131,82926,'Globisporangium','splendens');
INSERT INTO taxonomy VALUES(132,82932,'Pythium','arrhenomanes');
INSERT INTO taxonomy VALUES(133,82933,'Phytopythium','chamaehyphon');
INSERT INTO taxonomy VALUES(134,82934,'Pythium','coloratum');
INSERT INTO taxonomy VALUES(135,82935,'Pythium','deliense');
INSERT INTO taxonomy VALUES(136,82936,'Pythium','dissotocum');
INSERT INTO taxonomy VALUES(137,82937,'Pythium','graminicola');
INSERT INTO taxonomy VALUES(138,82938,'Pythium','inflatum');
INSERT INTO taxonomy VALUES(139,82940,'Globisporangium','middletonii');
INSERT INTO taxonomy VALUES(140,82941,'Pythium','myriotylum');
INSERT INTO taxonomy VALUES(141,82942,'Globisporangium','nunn');
INSERT INTO taxonomy VALUES(142,82945,'Pythium','periilum');
INSERT INTO taxonomy VALUES(143,82946,'Pythium','periplocum');
INSERT INTO taxonomy VALUES(144,82949,'Pythium','sulcatum');
INSERT INTO taxonomy VALUES(145,82950,'Globisporangium','sylvaticum');
INSERT INTO taxonomy VALUES(146,82951,'Pythium','vanterpoolii');
INSERT INTO taxonomy VALUES(147,82952,'Globisporangium','violae');
INSERT INTO taxonomy VALUES(148,82953,'Pythium','volutum');
INSERT INTO taxonomy VALUES(149,82955,'Pythium','sp. Py37');
INSERT INTO taxonomy VALUES(150,83917,'Pythium','catenulatum');
INSERT INTO taxonomy VALUES(151,83918,'Pythium','sp. Py55');
INSERT INTO taxonomy VALUES(152,86334,'Peronospora','manshurica');
INSERT INTO taxonomy VALUES(153,86335,'Peronospora','destructor');
INSERT INTO taxonomy VALUES(154,88834,'Pythium','porphyrae');
INSERT INTO taxonomy VALUES(155,89334,'Phytophthora','clandestina');
INSERT INTO taxonomy VALUES(156,89335,'Phytophthora','ilicis');
INSERT INTO taxonomy VALUES(157,89336,'Phytophthora','sp.');
INSERT INTO taxonomy VALUES(158,92964,'Pythium','monospermum');
INSERT INTO taxonomy VALUES(159,92969,'Pythiopsis','cymosa');
INSERT INTO taxonomy VALUES(160,92972,'Aplanopsis','terrestris');
INSERT INTO taxonomy VALUES(161,92976,'Leptolegnia','caudata');
INSERT INTO taxonomy VALUES(162,92981,'Apodachlya','brachynema');
INSERT INTO taxonomy VALUES(163,92984,'Leptolegnia','chapmanii');
INSERT INTO taxonomy VALUES(164,92985,'Leptolegnia','sp.');
INSERT INTO taxonomy VALUES(165,100861,'Aphanomyces','euteiches');
INSERT INTO taxonomy VALUES(166,100863,'Plectospira','myriandra');
INSERT INTO taxonomy VALUES(167,100864,'Apodachlya','pirifera');
INSERT INTO taxonomy VALUES(168,100866,'Leptomitus','lacteus');
INSERT INTO taxonomy VALUES(169,100870,'Phytophthora','litchii');
INSERT INTO taxonomy VALUES(170,100874,'Sapromyces','elongatus');
INSERT INTO taxonomy VALUES(171,101203,'Saprolegnia','parasitica');
INSERT INTO taxonomy VALUES(172,102135,'Peronospora','cristata');
INSERT INTO taxonomy VALUES(173,102136,'Peronospora','viciae');
INSERT INTO taxonomy VALUES(174,104971,'Elongisporangium','prolatum');
INSERT INTO taxonomy VALUES(175,105151,'Globisporangium','echinulatum');
INSERT INTO taxonomy VALUES(176,105152,'Globisporangium','nodosum');
INSERT INTO taxonomy VALUES(177,105153,'Globisporangium','ornacarpum');
INSERT INTO taxonomy VALUES(178,109152,'Phytophthora','boehmeriae');
INSERT INTO taxonomy VALUES(179,110438,'Pythium','contiguanum');
INSERT INTO taxonomy VALUES(180,111171,'Phytophthora','erythroseptica');
INSERT INTO taxonomy VALUES(181,112026,'Achlya','americana');
INSERT INTO taxonomy VALUES(182,112027,'Achlya','conspicua');
INSERT INTO taxonomy VALUES(183,112028,'Achlya','aquatica');
INSERT INTO taxonomy VALUES(184,112029,'Achlya','crenulata');
INSERT INTO taxonomy VALUES(185,112030,'Achlya','heterosexualis');
INSERT INTO taxonomy VALUES(186,112031,'Newbya','oligocantha');
INSERT INTO taxonomy VALUES(187,112032,'Achlya','proliferoides');
INSERT INTO taxonomy VALUES(188,112078,'Achlya','caroliniana');
INSERT INTO taxonomy VALUES(189,112079,'Achlya','colorata');
INSERT INTO taxonomy VALUES(190,112081,'Achlya','dubia');
INSERT INTO taxonomy VALUES(191,112082,'Achlya','flagellata');
INSERT INTO taxonomy VALUES(192,112083,'Achlya','glomerata');
INSERT INTO taxonomy VALUES(193,112087,'Achlya','racemosa');
INSERT INTO taxonomy VALUES(194,112088,'Achlya','radiosa');
INSERT INTO taxonomy VALUES(195,112089,'Achlya','recurva');
INSERT INTO taxonomy VALUES(196,112090,'Aphanomyces','astaci');
INSERT INTO taxonomy VALUES(197,112091,'Aphanomyces','cochlioides');
INSERT INTO taxonomy VALUES(198,112092,'Aphanomyces','laevis');
INSERT INTO taxonomy VALUES(199,112094,'Brevilegnia','bispora');
INSERT INTO taxonomy VALUES(200,112097,'Pythium','aquatile');
INSERT INTO taxonomy VALUES(201,112098,'Saprolegnia','diclina');
INSERT INTO taxonomy VALUES(202,112438,'Saprolegnia','sp. strain 2 (fish)');
INSERT INTO taxonomy VALUES(203,112439,'Saprolegnia','sp. strain 1 (fish eggs)');
INSERT INTO taxonomy VALUES(204,114742,'Pythium','insidiosum');
INSERT INTO taxonomy VALUES(205,114966,'Globisporangium','erinaceum');
INSERT INTO taxonomy VALUES(206,115417,'Globisporangium','iwayamae');
INSERT INTO taxonomy VALUES(207,115418,'Globisporangium','mamillatum');
INSERT INTO taxonomy VALUES(208,115419,'Globisporangium','paddicum');
INSERT INTO taxonomy VALUES(209,115420,'Globisporangium','pulchrum');
INSERT INTO taxonomy VALUES(210,115718,'Peronospora','pisi');
INSERT INTO taxonomy VALUES(211,120023,'Phytophthora','melonis');
INSERT INTO taxonomy VALUES(212,120396,'Achlya','papillosa');
INSERT INTO taxonomy VALUES(213,120397,'Achlya','treleaseana');
INSERT INTO taxonomy VALUES(214,120398,'Aphanomyces','stellatus');
INSERT INTO taxonomy VALUES(215,120400,'Aplanes','androgynus');
INSERT INTO taxonomy VALUES(216,120401,'Achlya','ornata');
INSERT INTO taxonomy VALUES(217,120402,'Brevilegnia','megasperma');
INSERT INTO taxonomy VALUES(218,120404,'Calyptralegnia','achlyoides');
INSERT INTO taxonomy VALUES(219,120407,'Dictyuchus','monosporus');
INSERT INTO taxonomy VALUES(220,120411,'Pachymetra','chaunorhiza');
INSERT INTO taxonomy VALUES(221,120412,'Peronospora','ficariae');
INSERT INTO taxonomy VALUES(222,120415,'Saprolegnia','anisospora');
INSERT INTO taxonomy VALUES(223,120416,'Saprolegnia','eccentrica');
INSERT INTO taxonomy VALUES(224,120417,'Saprolegnia','hypogyna');
INSERT INTO taxonomy VALUES(225,120418,'Saprolegnia','litoralis');
INSERT INTO taxonomy VALUES(226,120419,'Saprolegnia','monilifera');
INSERT INTO taxonomy VALUES(227,120420,'Saprolegnia','torulosa');
INSERT INTO taxonomy VALUES(228,120421,'Saprolegnia','unispora');
INSERT INTO taxonomy VALUES(229,120423,'Scoliolegnia','asterophora');
INSERT INTO taxonomy VALUES(230,120501,'Aphanomyces','sp. AR_11');
INSERT INTO taxonomy VALUES(231,120571,'Dictyuchus','sp. AR_29');
INSERT INTO taxonomy VALUES(232,120572,'Peronospora','bulbocapni');
INSERT INTO taxonomy VALUES(233,120573,'Pythium','sp. AR_100');
INSERT INTO taxonomy VALUES(234,121062,'Globisporangium','perplexum');
INSERT INTO taxonomy VALUES(235,126844,'Phytopythium','helicoides');
INSERT INTO taxonomy VALUES(236,126845,'Phytopythium','megacarpum');
INSERT INTO taxonomy VALUES(237,126846,'Phytopythium','ostracodes');
INSERT INTO taxonomy VALUES(238,127442,'Phytophthora','insolita');
INSERT INTO taxonomy VALUES(239,127443,'Phytophthora','richardiae');
INSERT INTO taxonomy VALUES(240,127444,'Elongisporangium','undulatum');
INSERT INTO taxonomy VALUES(241,127446,'Halophytophthora','batemanensis');
INSERT INTO taxonomy VALUES(242,129347,'Phytophthora','arecae');
INSERT INTO taxonomy VALUES(243,129348,'Phytophthora','botryosa');
INSERT INTO taxonomy VALUES(244,129349,'Phytophthora','cajani');
INSERT INTO taxonomy VALUES(245,129350,'Phytophthora','colocasiae');
INSERT INTO taxonomy VALUES(246,129351,'Phytophthora','heveae');
INSERT INTO taxonomy VALUES(247,129352,'Phytophthora','humicola');
INSERT INTO taxonomy VALUES(248,129353,'Phytophthora','inflata');
INSERT INTO taxonomy VALUES(249,129354,'Phytophthora','katsurae');
INSERT INTO taxonomy VALUES(250,129355,'Phytophthora','lateralis');
INSERT INTO taxonomy VALUES(251,129356,'Phytophthora','mirabilis');
INSERT INTO taxonomy VALUES(252,129357,'Phytophthora','multivesiculata');
INSERT INTO taxonomy VALUES(253,129358,'Phytophthora','phaseoli');
INSERT INTO taxonomy VALUES(254,129359,'Phytophthora','porri');
INSERT INTO taxonomy VALUES(255,129360,'Phytophthora','primulae');
INSERT INTO taxonomy VALUES(256,129361,'Phytophthora','sinensis');
INSERT INTO taxonomy VALUES(257,129362,'Phytophthora','tentaculata');
INSERT INTO taxonomy VALUES(258,129364,'Phytophthora','rubi');
INSERT INTO taxonomy VALUES(259,129366,'Phytophthora','sp. UQ2141');
INSERT INTO taxonomy VALUES(260,132615,'Phytophthora','glovera');
INSERT INTO taxonomy VALUES(261,134455,'Phytophthora','quininea');
INSERT INTO taxonomy VALUES(262,134456,'Phytophthora','sp. P8213');
INSERT INTO taxonomy VALUES(263,134457,'Phytophthora','cf. cryptogea/drechsleri');
INSERT INTO taxonomy VALUES(264,134686,'Apodachlya','minima');
INSERT INTO taxonomy VALUES(265,134689,'Isoachlya','toruloides');
INSERT INTO taxonomy VALUES(266,134690,'Salilagenidium','chthamalophilum');
INSERT INTO taxonomy VALUES(267,134698,'Peronospora','farinosa');
INSERT INTO taxonomy VALUES(268,135245,'Phytophthora','sp. KACC40449');
INSERT INTO taxonomy VALUES(269,135473,'Haliphthoros','milfordensis');
INSERT INTO taxonomy VALUES(270,135474,'Haliphthoros','philippinensis');
INSERT INTO taxonomy VALUES(271,135477,'Atkinsiella','dubia');
INSERT INTO taxonomy VALUES(272,135479,'Halocrusticida','okinawaensis');
INSERT INTO taxonomy VALUES(273,135480,'Salilagenidium','callinectes');
INSERT INTO taxonomy VALUES(274,135481,'Lagenidium','caudatum');
INSERT INTO taxonomy VALUES(275,135482,'Myzocytiopsis','humana');
INSERT INTO taxonomy VALUES(276,135483,'Pythium','myophilum');
INSERT INTO taxonomy VALUES(277,135484,'Salilagenidium','thermophilum');
INSERT INTO taxonomy VALUES(278,135850,'Dictyuchus','sp. Petersen-4.2');
INSERT INTO taxonomy VALUES(279,135851,'Dictyuchus','sp. Petersen-5.6');
INSERT INTO taxonomy VALUES(280,135852,'Leptolegnia','sp. Soerensen-1.6');
INSERT INTO taxonomy VALUES(281,135853,'Leptolegnia','sp. Soerensen-3.1');
INSERT INTO taxonomy VALUES(282,135856,'Aphanomyces','piscicida');
INSERT INTO taxonomy VALUES(283,137729,'Phytophthora','tropicalis');
INSERT INTO taxonomy VALUES(284,140044,'Pythium','aristosporum');
INSERT INTO taxonomy VALUES(285,140045,'Pythium','butleri');
INSERT INTO taxonomy VALUES(286,140046,'Globisporangium','polymastum');
INSERT INTO taxonomy VALUES(287,140047,'Pythium','salpingophorum');
INSERT INTO taxonomy VALUES(288,140048,'Pythium','tracheiphilum');
INSERT INTO taxonomy VALUES(289,141266,'Elongisporangium','dimorphum');
INSERT INTO taxonomy VALUES(290,143451,'Plasmopara','viticola');
INSERT INTO taxonomy VALUES(291,143453,'Pseudoperonospora','cubensis');
INSERT INTO taxonomy VALUES(292,147702,'Globisporangium','buismaniae');
INSERT INTO taxonomy VALUES(293,147703,'Pythium','jasmonium');
INSERT INTO taxonomy VALUES(294,147704,'Globisporangium','mastophorum');
INSERT INTO taxonomy VALUES(295,147705,'Globisporangium','megalacanthum');
INSERT INTO taxonomy VALUES(296,147706,'Globisporangium','uncinulatum');
INSERT INTO taxonomy VALUES(297,156628,'Pythium','diclinum');
INSERT INTO taxonomy VALUES(298,156629,'Pythium','pectinolyticum');
INSERT INTO taxonomy VALUES(299,157072,'Aphanomyces','invadans');
INSERT INTO taxonomy VALUES(300,157079,'Aphanomyces','sp. TF33');
INSERT INTO taxonomy VALUES(301,157080,'Aphanomyces','sp. TF5');
INSERT INTO taxonomy VALUES(302,157081,'Achlya','sp. S2AC');
INSERT INTO taxonomy VALUES(303,159317,'Eurychasma','dicksonii');
INSERT INTO taxonomy VALUES(304,162088,'Pythium','aff. vanterpoolii');
INSERT INTO taxonomy VALUES(305,162089,'Pythium','sp. AR_204');
INSERT INTO taxonomy VALUES(306,162090,'Pythium','sp. AR_235');
INSERT INTO taxonomy VALUES(307,162094,'Peronospora','hiemalis');
INSERT INTO taxonomy VALUES(308,162095,'Peronospora','pulveracea');
INSERT INTO taxonomy VALUES(309,162096,'Peronospora','trivialis');
INSERT INTO taxonomy VALUES(310,162097,'Peronospora','alsinearum');
INSERT INTO taxonomy VALUES(311,162098,'Peronospora','myosotidis');
INSERT INTO taxonomy VALUES(312,162099,'Peronospora','coronillae');
INSERT INTO taxonomy VALUES(313,162100,'Peronospora','boni-henrici');
INSERT INTO taxonomy VALUES(314,162101,'Peronospora','rumicis');
INSERT INTO taxonomy VALUES(315,162102,'Peronospora','variabilis');
INSERT INTO taxonomy VALUES(316,162103,'Peronospora','trifoliorum');
INSERT INTO taxonomy VALUES(317,162104,'Peronospora','trifolii-minoris');
INSERT INTO taxonomy VALUES(318,162105,'Peronospora','trifolii-hybridi');
INSERT INTO taxonomy VALUES(319,162106,'Peronospora','trifolii-alpestris');
INSERT INTO taxonomy VALUES(320,162107,'Peronospora','aestivalis');
INSERT INTO taxonomy VALUES(321,162108,'Peronospora','calotheca');
INSERT INTO taxonomy VALUES(322,162109,'Peronospora','aparines');
INSERT INTO taxonomy VALUES(323,162110,'Peronospora','violacea');
INSERT INTO taxonomy VALUES(324,162111,'Peronospora','potentillae-sterilis');
INSERT INTO taxonomy VALUES(325,162112,'Peronospora','sanguisorbae');
INSERT INTO taxonomy VALUES(326,162113,'Peronospora','conglomerata');
INSERT INTO taxonomy VALUES(327,162114,'Peronospora','silvestris');
INSERT INTO taxonomy VALUES(328,162115,'Peronospora','arvensis');
INSERT INTO taxonomy VALUES(329,162116,'Peronospora','grisea');
INSERT INTO taxonomy VALUES(330,162117,'Peronospora','alta');
INSERT INTO taxonomy VALUES(331,162118,'Peronospora','lamii');
INSERT INTO taxonomy VALUES(332,162119,'Pseudoperonospora','urticae');
INSERT INTO taxonomy VALUES(333,162120,'Pseudoperonospora','humuli');
INSERT INTO taxonomy VALUES(334,162122,'Hyaloperonospora','barbareae');
INSERT INTO taxonomy VALUES(335,162123,'Hyaloperonospora','dentariae');
INSERT INTO taxonomy VALUES(336,162124,'Hyaloperonospora','thlaspeos-arvensis');
INSERT INTO taxonomy VALUES(337,162125,'Hyaloperonospora','brassicae');
INSERT INTO taxonomy VALUES(338,162128,'Basidiophora','entospora');
INSERT INTO taxonomy VALUES(339,162130,'Sclerospora','graminicola');
INSERT INTO taxonomy VALUES(340,162132,'Paraperonospora','leptosperma');
INSERT INTO taxonomy VALUES(341,162136,'Plasmopara','sii');
INSERT INTO taxonomy VALUES(342,162137,'Plasmopara','pimpinellae');
INSERT INTO taxonomy VALUES(343,162138,'Plasmopara','geranii');
INSERT INTO taxonomy VALUES(344,162139,'Plasmopara','pusilla');
INSERT INTO taxonomy VALUES(345,162140,'Plasmopara','obducens');
INSERT INTO taxonomy VALUES(346,162141,'Plasmopara','densa');
INSERT INTO taxonomy VALUES(347,162142,'Plasmoverna','isopyrithalictroides');
INSERT INTO taxonomy VALUES(348,164328,'Phytophthora','ramorum');
INSERT INTO taxonomy VALUES(349,166937,'Pythium','longandrum');
INSERT INTO taxonomy VALUES(350,166938,'Pythium','terrestris');
INSERT INTO taxonomy VALUES(351,168136,'Aphanomyces','sp. 84-1240');
INSERT INTO taxonomy VALUES(352,170619,'Aphanomyces','helicoides');
INSERT INTO taxonomy VALUES(353,170620,'Leptolegnia','sp. CBS 177.86');
INSERT INTO taxonomy VALUES(354,172234,'Pythium','grandisporangium');
INSERT INTO taxonomy VALUES(355,173901,'Globisporangium','proliferatum');
INSERT INTO taxonomy VALUES(356,174576,'Phytophthora','pistaciae');
INSERT INTO taxonomy VALUES(357,175300,'Phytophthora','hibernalis');
INSERT INTO taxonomy VALUES(358,180900,'Phytophthora','europaea');
INSERT INTO taxonomy VALUES(359,180901,'Phytophthora','psychrophila');
INSERT INTO taxonomy VALUES(360,180902,'Phytophthora','uliginosa');
INSERT INTO taxonomy VALUES(361,182683,'Globisporangium','okanoganense');
INSERT INTO taxonomy VALUES(362,182783,'Globisporangium','canariense');
INSERT INTO taxonomy VALUES(363,184463,'Hyaloperonospora','niessleana');
INSERT INTO taxonomy VALUES(364,184465,'Perofascia','lepidii');
INSERT INTO taxonomy VALUES(365,184466,'Peronospora','arborescens');
INSERT INTO taxonomy VALUES(366,186163,'Globisporangium','cylindrosporum');
INSERT INTO taxonomy VALUES(367,187813,'Phytophthora','brassicae');
INSERT INTO taxonomy VALUES(368,187986,'Phytophthora','bisheria');
INSERT INTO taxonomy VALUES(369,189821,'Globisporangium','bifurcatum');
INSERT INTO taxonomy VALUES(370,190219,'Globisporangium','abappressorium');
INSERT INTO taxonomy VALUES(371,192020,'Globisporangium','carolinianum');
INSERT INTO taxonomy VALUES(372,192975,'Phytophthora','meadii');
INSERT INTO taxonomy VALUES(373,196599,'Globisporangium','regulare');
INSERT INTO taxonomy VALUES(374,209243,'Globisporangium','segnitium');
INSERT INTO taxonomy VALUES(375,210167,'Peronospora','corydalis');
INSERT INTO taxonomy VALUES(376,214887,'Phytopythium','montanum');
INSERT INTO taxonomy VALUES(377,216130,'Pythium','destruens');
INSERT INTO taxonomy VALUES(378,220750,'Phytopythium','carbonicum');
INSERT INTO taxonomy VALUES(379,221518,'Phytophthora','pseudosyringae');
INSERT INTO taxonomy VALUES(380,221743,'Phytopythium','citrinum');
INSERT INTO taxonomy VALUES(381,222716,'Plasmopara','angustiterminalis');
INSERT INTO taxonomy VALUES(382,222890,'Globisporangium','rhizosaccharum');
INSERT INTO taxonomy VALUES(383,226325,'Albugo','occidentalis');
INSERT INTO taxonomy VALUES(384,227376,'Saprolegnia','multispora');
INSERT INTO taxonomy VALUES(385,228097,'Pythium','sp. C5-1-1');
INSERT INTO taxonomy VALUES(386,228342,'Globisporangium','campanulatum');
INSERT INTO taxonomy VALUES(387,228749,'Globisporangium','glomeratum');
INSERT INTO taxonomy VALUES(388,228916,'Saprolegnia','bulbosa');
INSERT INTO taxonomy VALUES(389,230109,'Saprolegnia','oliviae');
INSERT INTO taxonomy VALUES(390,230110,'Saprolegnia','sp. Arg 009');
INSERT INTO taxonomy VALUES(391,230111,'Saprolegnia','longicaulis');
INSERT INTO taxonomy VALUES(392,230362,'Peronospora','romanica');
INSERT INTO taxonomy VALUES(393,230363,'Peronospora','meliloti');
INSERT INTO taxonomy VALUES(394,230364,'Peronospora','mayorii');
INSERT INTO taxonomy VALUES(395,230365,'Peronospora','ervi');
INSERT INTO taxonomy VALUES(396,230368,'Peronospora','trifolii-repentis');
INSERT INTO taxonomy VALUES(397,230369,'Peronospora','potentillae');
INSERT INTO taxonomy VALUES(398,230370,'Peronospora','aff. potentillae');
INSERT INTO taxonomy VALUES(399,230371,'Peronospora','violae');
INSERT INTO taxonomy VALUES(400,230372,'Peronospora','agrestis');
INSERT INTO taxonomy VALUES(401,230373,'Peronospora','flava');
INSERT INTO taxonomy VALUES(402,230374,'Peronospora','sordida');
INSERT INTO taxonomy VALUES(403,230375,'Hyaloperonospora','nesliae');
INSERT INTO taxonomy VALUES(404,230378,'Hyaloperonospora','arabidis-alpinae');
INSERT INTO taxonomy VALUES(405,230379,'Peronospora','astragalina');
INSERT INTO taxonomy VALUES(406,230421,'Peronospora','asperuginis');
INSERT INTO taxonomy VALUES(407,230422,'Peronospora','lotorum');
INSERT INTO taxonomy VALUES(408,230423,'Peronospora','ranunculi');
INSERT INTO taxonomy VALUES(409,230424,'Peronospora','illyrica');
INSERT INTO taxonomy VALUES(410,230425,'Peronospora','aff. ranunculi');
INSERT INTO taxonomy VALUES(411,230426,'Peronospora','alpicola');
INSERT INTO taxonomy VALUES(412,230427,'Peronospora','dicentrae');
INSERT INTO taxonomy VALUES(413,230428,'Peronospora','chrysosplenii');
INSERT INTO taxonomy VALUES(414,230429,'Peronospora','esulae');
INSERT INTO taxonomy VALUES(415,230430,'Peronospora','paula');
INSERT INTO taxonomy VALUES(416,230431,'Peronospora','parva');
INSERT INTO taxonomy VALUES(417,230432,'Peronospora','arenariae');
INSERT INTO taxonomy VALUES(418,230433,'Peronospora','claytoniae');
INSERT INTO taxonomy VALUES(419,230434,'Peronospora','polygoni');
INSERT INTO taxonomy VALUES(420,230435,'Peronospora','holostei');
INSERT INTO taxonomy VALUES(421,230436,'Peronospora','arthurii');
INSERT INTO taxonomy VALUES(422,230438,'Peronospora','obovata');
INSERT INTO taxonomy VALUES(423,230439,'Peronospora','tabacina');
INSERT INTO taxonomy VALUES(424,230440,'Peronospora','kochiae-scopariae');
INSERT INTO taxonomy VALUES(425,230441,'Peronospora','chenopodii-polyspermi');
INSERT INTO taxonomy VALUES(426,230442,'Peronospora','valerianellae');
INSERT INTO taxonomy VALUES(427,230443,'Peronospora','tranzscheliana');
INSERT INTO taxonomy VALUES(428,230444,'Peronospora','stigmaticola');
INSERT INTO taxonomy VALUES(429,230445,'Peronospora','radii');
INSERT INTO taxonomy VALUES(430,230446,'Peronospora','silvatica');
INSERT INTO taxonomy VALUES(431,230447,'Peronospora','sherardiae');
INSERT INTO taxonomy VALUES(432,230448,'Peronospora','knautiae');
INSERT INTO taxonomy VALUES(433,230449,'Peronospora','alchemillae');
INSERT INTO taxonomy VALUES(434,230450,'Hyaloperonospora','camelinae');
INSERT INTO taxonomy VALUES(435,230451,'Hyaloperonospora','lunariae');
INSERT INTO taxonomy VALUES(436,230452,'Hyaloperonospora','tribulina');
INSERT INTO taxonomy VALUES(437,230839,'Peronosclerospora','sorghi');
INSERT INTO taxonomy VALUES(438,231958,'Globisporangium','debaryanum');
INSERT INTO taxonomy VALUES(439,235445,'Pythium','sp. LVP A');
INSERT INTO taxonomy VALUES(440,235446,'Pythium','sp. LVP B');
INSERT INTO taxonomy VALUES(441,235447,'Pythium','sp. LVP D');
INSERT INTO taxonomy VALUES(442,235448,'Pythium','sp. LVP F');
INSERT INTO taxonomy VALUES(443,235575,'Plasmopara','wildemaniana');
INSERT INTO taxonomy VALUES(444,235576,'Plasmopara','solidaginis');
INSERT INTO taxonomy VALUES(445,235577,'Plasmopara','baudysii');
INSERT INTO taxonomy VALUES(446,235579,'Plasmopara','angelicae');
INSERT INTO taxonomy VALUES(447,235580,'Plasmopara','peucedani');
INSERT INTO taxonomy VALUES(448,235581,'Plasmopara','pastinacae');
INSERT INTO taxonomy VALUES(449,235582,'Plasmopara','mei-foeniculi');
INSERT INTO taxonomy VALUES(450,235584,'Plasmopara','chaerophylli');
INSERT INTO taxonomy VALUES(451,235585,'Plasmopara','epilobii');
INSERT INTO taxonomy VALUES(452,235586,'Plasmopara','skvortzovii');
INSERT INTO taxonomy VALUES(453,239968,'Phytophthora','nemorosa');
INSERT INTO taxonomy VALUES(454,240413,'Hyaloperonospora','aff. dentariae MG 18-6');
INSERT INTO taxonomy VALUES(455,240414,'Peronospora','aquatica');
INSERT INTO taxonomy VALUES(456,240415,'Hyaloperonospora','erophilae');
INSERT INTO taxonomy VALUES(457,240417,'Hyaloperonospora','thlaspeos-perfoliati');
INSERT INTO taxonomy VALUES(458,240418,'Peronospora','verna');
INSERT INTO taxonomy VALUES(459,240424,'Plasmopara','megasperma');
INSERT INTO taxonomy VALUES(460,240425,'Hyaloperonospora','aff. dentariae MG 5-8');
INSERT INTO taxonomy VALUES(461,241406,'Globisporangium','attrantheridium');
INSERT INTO taxonomy VALUES(462,244122,'Phytophthora','inundata');
INSERT INTO taxonomy VALUES(463,244163,'Phytophthora','sp. P1049');
INSERT INTO taxonomy VALUES(464,244165,'Phytophthora','sp. P510');
INSERT INTO taxonomy VALUES(465,244166,'Phytophthora','sp. P896');
INSERT INTO taxonomy VALUES(466,244167,'Phytophthora','rosacearum');
INSERT INTO taxonomy VALUES(467,244168,'Phytophthora','sp. P1054');
INSERT INTO taxonomy VALUES(468,244169,'Phytophthora','sp. P1055');
INSERT INTO taxonomy VALUES(469,244170,'Phytophthora','sp. P1056');
INSERT INTO taxonomy VALUES(470,244171,'Phytophthora','sp. P1050');
INSERT INTO taxonomy VALUES(471,244172,'Phytophthora','sp. P1044');
INSERT INTO taxonomy VALUES(472,244173,'Phytophthora','sp. P532');
INSERT INTO taxonomy VALUES(473,244732,'Viennotia','oplismeni');
INSERT INTO taxonomy VALUES(474,253176,'Aphanomyces','cladogamus');
INSERT INTO taxonomy VALUES(475,253177,'Aphanomyces','sp. 65');
INSERT INTO taxonomy VALUES(476,254942,'Pythium','sp. PTS-2003');
INSERT INTO taxonomy VALUES(477,255163,'Globisporangium','hypogynum');
INSERT INTO taxonomy VALUES(478,255164,'Pythium','sp. PB-2003a');
INSERT INTO taxonomy VALUES(479,255165,'Globisporangium','longisporangium');
INSERT INTO taxonomy VALUES(480,255166,'Globisporangium','viniferum');
INSERT INTO taxonomy VALUES(481,255167,'Pythium','sp. F-74');
INSERT INTO taxonomy VALUES(482,255168,'Pythium','sp. F-39');
INSERT INTO taxonomy VALUES(483,255169,'Pythium','sp. F-1216');
INSERT INTO taxonomy VALUES(484,255170,'Pythium','sp. F-1234');
INSERT INTO taxonomy VALUES(485,272952,'Hyaloperonospora','arabidopsidis');
INSERT INTO taxonomy VALUES(486,272953,'Hyaloperonospora','berteroae');
INSERT INTO taxonomy VALUES(487,272956,'Hyaloperonospora','cardaminopsidis');
INSERT INTO taxonomy VALUES(488,272957,'Hyaloperonospora','cheiranthi');
INSERT INTO taxonomy VALUES(489,272958,'Hyaloperonospora','cochleariae');
INSERT INTO taxonomy VALUES(490,272962,'Hyaloperonospora','galligena');
INSERT INTO taxonomy VALUES(491,272963,'Hyaloperonospora','hesperidis');
INSERT INTO taxonomy VALUES(492,272965,'Hyaloperonospora','isatidis');
INSERT INTO taxonomy VALUES(493,272967,'Hyaloperonospora','nasturtii-aquatici');
INSERT INTO taxonomy VALUES(494,272970,'Hyaloperonospora','sisymbrii-loeselii');
INSERT INTO taxonomy VALUES(495,272973,'Hyaloperonospora','teesdaliae');
INSERT INTO taxonomy VALUES(496,273300,'Pythium','sp. P17-1');
INSERT INTO taxonomy VALUES(497,273301,'Pythium','sp. P17-3');
INSERT INTO taxonomy VALUES(498,278112,'Haliphthoros','sp. NJM 0034');
INSERT INTO taxonomy VALUES(499,281399,'Aphanomyces','frigidophilus');
INSERT INTO taxonomy VALUES(500,281400,'Saprolegnia','salmonis');
INSERT INTO taxonomy VALUES(501,281401,'Saprolegnia','semihypogyna');
INSERT INTO taxonomy VALUES(502,281402,'Saprolegnia','australis');
INSERT INTO taxonomy VALUES(503,281403,'Achlya','prolifera');
INSERT INTO taxonomy VALUES(504,283007,'Phytophthora','ipomoeae');
INSERT INTO taxonomy VALUES(505,283008,'Phytophthora','sp. Spathiphyllum');
INSERT INTO taxonomy VALUES(506,283009,'Phytophthora','andina');
INSERT INTO taxonomy VALUES(507,283010,'Phytophthora','hybrid Dutch variant');
INSERT INTO taxonomy VALUES(508,285429,'Achlya','sp. strain S3');
INSERT INTO taxonomy VALUES(509,285430,'Dictyuchus','sp. BP-S2');
INSERT INTO taxonomy VALUES(510,285431,'Saprolegnia','sp. BP-S1');
INSERT INTO taxonomy VALUES(511,286475,'Pythium','sp. F-1292');
INSERT INTO taxonomy VALUES(512,286477,'Pythium','sp. BG01');
INSERT INTO taxonomy VALUES(513,286479,'Pythium','sp. BG12');
INSERT INTO taxonomy VALUES(514,286560,'Aphanomyces','sp. F-1293');
INSERT INTO taxonomy VALUES(515,286561,'Achlya','spiralis');
INSERT INTO taxonomy VALUES(516,287896,'Pythium','sp. Bamako dog');
INSERT INTO taxonomy VALUES(517,289317,'Aphanomyces','repetans');
INSERT INTO taxonomy VALUES(518,289424,'Pythium','sp. RSC-2004');
INSERT INTO taxonomy VALUES(519,289596,'Pythium','adhaerens');
INSERT INTO taxonomy VALUES(520,289597,'Pythium','chondricola');
INSERT INTO taxonomy VALUES(521,289598,'Pythium','angustatum');
INSERT INTO taxonomy VALUES(522,289599,'Pythium','conidiophorum');
INSERT INTO taxonomy VALUES(523,289600,'Pythium','apleroticum');
INSERT INTO taxonomy VALUES(524,289601,'Pythium','capillosum');
INSERT INTO taxonomy VALUES(525,289602,'Pythium','pyrilobum');
INSERT INTO taxonomy VALUES(526,289603,'Globisporangium','acrogynum');
INSERT INTO taxonomy VALUES(527,289604,'Globisporangium','multisporum');
INSERT INTO taxonomy VALUES(528,289605,'Globisporangium','pleroticum');
INSERT INTO taxonomy VALUES(529,289606,'Elongisporangium','anandrum');
INSERT INTO taxonomy VALUES(530,289607,'Elongisporangium','helicandrum');
INSERT INTO taxonomy VALUES(531,289609,'Phytopythium','cucurbitacearum (nom. inval.)');
INSERT INTO taxonomy VALUES(532,289610,'Halophytophthora','avicenniae');
INSERT INTO taxonomy VALUES(533,289612,'Pythium','amasculinum');
INSERT INTO taxonomy VALUES(534,289613,'Pythium','folliculosum');
INSERT INTO taxonomy VALUES(535,289614,'Pythium','zingiberis');
INSERT INTO taxonomy VALUES(536,289615,'Pythium','scleroteichum');
INSERT INTO taxonomy VALUES(537,289616,'Pythium','dissimile');
INSERT INTO taxonomy VALUES(538,289617,'Pythium','plurisporium');
INSERT INTO taxonomy VALUES(539,289618,'Pythium','lutarium');
INSERT INTO taxonomy VALUES(540,289619,'Pythium','marinum');
INSERT INTO taxonomy VALUES(541,289620,'Pythium','flevoense');
INSERT INTO taxonomy VALUES(542,289621,'Globisporangium','radiosum');
INSERT INTO taxonomy VALUES(543,289622,'Globisporangium','parvum');
INSERT INTO taxonomy VALUES(544,289623,'Globisporangium','marsipium');
INSERT INTO taxonomy VALUES(545,289624,'Globisporangium','kunmingense');
INSERT INTO taxonomy VALUES(546,289625,'Globisporangium','nagaii');
INSERT INTO taxonomy VALUES(547,289626,'Pythium','indigoferae');
INSERT INTO taxonomy VALUES(548,290088,'Pythium','minus');
INSERT INTO taxonomy VALUES(549,291619,'Peronospora','campestris');
INSERT INTO taxonomy VALUES(550,291620,'Peronospora','trigonotidis');
INSERT INTO taxonomy VALUES(551,291622,'Pseudoperonospora','cannabina');
INSERT INTO taxonomy VALUES(552,291623,'Pseudoperonospora','celtidis');
INSERT INTO taxonomy VALUES(553,291792,'Pythium','sp. MJY-M 2004');
INSERT INTO taxonomy VALUES(554,295094,'Albugo','ipomoeae-panduratae');
INSERT INTO taxonomy VALUES(555,295481,'Phytophthora','hedraiandra');
INSERT INTO taxonomy VALUES(556,295491,'Globisporangium','cystogenes');
INSERT INTO taxonomy VALUES(557,297340,'Phytophthora','sp. Ph1');
INSERT INTO taxonomy VALUES(558,299391,'Phytophthora','alni');
INSERT INTO taxonomy VALUES(559,299392,'Phytophthora','x alni');
INSERT INTO taxonomy VALUES(560,299393,'Phytophthora','uniformis');
INSERT INTO taxonomy VALUES(561,299394,'Phytophthora','x multiformis');
INSERT INTO taxonomy VALUES(562,299625,'Pythium','rhizo-oryzae');
INSERT INTO taxonomy VALUES(563,300240,'Phytophthora','sp. AG43');
INSERT INTO taxonomy VALUES(564,300241,'Phytophthora','sp. AG52');
INSERT INTO taxonomy VALUES(565,300242,'Phytophthora','sp. AG34');
INSERT INTO taxonomy VALUES(566,302027,'Phytophthora','sp. isolate SCRP233');
INSERT INTO taxonomy VALUES(567,304778,'Peronospora','sp. UASWS0007');
INSERT INTO taxonomy VALUES(568,304779,'Peronospora','sp. UASWS0008');
INSERT INTO taxonomy VALUES(569,304781,'Peronospora','sp. UASWS0009');
INSERT INTO taxonomy VALUES(570,304782,'Peronospora','sp. UASWS0010');
INSERT INTO taxonomy VALUES(571,309403,'Brevilegnia','macrospora');
INSERT INTO taxonomy VALUES(572,311217,'Peronospora','sp. UASWS0033');
INSERT INTO taxonomy VALUES(573,311218,'Peronospora','sp. UASWS0034');
INSERT INTO taxonomy VALUES(574,311219,'Peronospora','sp. UASWS0035');
INSERT INTO taxonomy VALUES(575,311224,'Peronospora','sp. UASWS0036');
INSERT INTO taxonomy VALUES(576,315265,'Peronospora','sp. UASWS0037');
INSERT INTO taxonomy VALUES(577,315353,'Pythium','sp. UASWS0020');
INSERT INTO taxonomy VALUES(578,319040,'Pythium','phragmitis');
INSERT INTO taxonomy VALUES(579,321825,'Phytophthora','sp. isolate 1410');
INSERT INTO taxonomy VALUES(580,323410,'Pythium','sp. GY-1938');
INSERT INTO taxonomy VALUES(581,323840,'Albugo','chardoni');
INSERT INTO taxonomy VALUES(582,323849,'Albugo','trianthemae');
INSERT INTO taxonomy VALUES(583,324709,'Phytophthora','sp. P47');
INSERT INTO taxonomy VALUES(584,324710,'Phytophthora','sp. P51');
INSERT INTO taxonomy VALUES(585,324711,'Phytophthora','sp. P61');
INSERT INTO taxonomy VALUES(586,324712,'Phytophthora','sp. P79 (BO-15)');
INSERT INTO taxonomy VALUES(587,324713,'Phytophthora','sp. P82 (B13A)');
INSERT INTO taxonomy VALUES(588,324714,'Phytophthora','sp. P14');
INSERT INTO taxonomy VALUES(589,324715,'Phytophthora','sp. P31');
INSERT INTO taxonomy VALUES(590,324716,'Phytophthora','sp. P32');
INSERT INTO taxonomy VALUES(591,324717,'Phytophthora','sp. P34');
INSERT INTO taxonomy VALUES(592,324745,'Phytophthora','medicaginis x cryptogea');
INSERT INTO taxonomy VALUES(593,324746,'Phytophthora','sp. P28');
INSERT INTO taxonomy VALUES(594,325452,'Phytophthora','kernoviae');
INSERT INTO taxonomy VALUES(595,326095,'Phytophthora','sp. cc2124');
INSERT INTO taxonomy VALUES(596,326096,'Phytophthora','sp. cc2286');
INSERT INTO taxonomy VALUES(597,326097,'Phytophthora','sp. cc2300');
INSERT INTO taxonomy VALUES(598,326098,'Phytophthora','sp. cc2378');
INSERT INTO taxonomy VALUES(599,327753,'Saprolegnia','megasperma');
INSERT INTO taxonomy VALUES(600,328553,'Phytophthora','sp. VPRI 22561');
INSERT INTO taxonomy VALUES(601,328554,'Phytophthora','sp. VPRI 30465');
INSERT INTO taxonomy VALUES(602,328555,'Phytophthora','sp. VPRI 32027');
INSERT INTO taxonomy VALUES(603,328556,'Phytophthora','sp. VPRI 32085');
INSERT INTO taxonomy VALUES(604,328557,'Phytophthora','sp. VPRI 20622');
INSERT INTO taxonomy VALUES(605,328558,'Phytophthora','sp. VPRI 32025');
INSERT INTO taxonomy VALUES(606,328559,'Phytophthora','sp. VPRI 32026');
INSERT INTO taxonomy VALUES(607,330677,'Albugo','evolvuli');
INSERT INTO taxonomy VALUES(608,330678,'Albugo','caryophyllacearum');
INSERT INTO taxonomy VALUES(609,330679,'Albugo','gomphrenae');
INSERT INTO taxonomy VALUES(610,330680,'Wilsoniana','amaranthi');
INSERT INTO taxonomy VALUES(611,330889,'Pythium','sp. MuShi');
INSERT INTO taxonomy VALUES(612,332200,'Phytophthora','sp. ex Drimys winteri');
INSERT INTO taxonomy VALUES(613,334524,'Saprolegnia','subterranea');
INSERT INTO taxonomy VALUES(614,334525,'Saprolegnia','furcata');
INSERT INTO taxonomy VALUES(615,334526,'Saprolegnia','mixta');
INSERT INTO taxonomy VALUES(616,334527,'Saprolegnia','polymorpha');
INSERT INTO taxonomy VALUES(617,334528,'Saprolegnia','terrestris');
INSERT INTO taxonomy VALUES(618,334529,'Saprolegnia','turfosa');
INSERT INTO taxonomy VALUES(619,334530,'Pythiopsis','humphreyana');
INSERT INTO taxonomy VALUES(620,334531,'Pythiopsis','terrestris');
INSERT INTO taxonomy VALUES(621,335373,'Protobremia','sphaerosperma');
INSERT INTO taxonomy VALUES(622,337957,'Peronospora','sp. UPS F-119987');
INSERT INTO taxonomy VALUES(623,337958,'Peronospora','sp. UPS F-119986');
INSERT INTO taxonomy VALUES(624,337960,'Peronospora','narbonensis');
INSERT INTO taxonomy VALUES(625,337961,'Peronospora','sepium');
INSERT INTO taxonomy VALUES(626,338422,'Plasmopara','geranii-sylvatici');
INSERT INTO taxonomy VALUES(627,338424,'Pythium','sp. PID095');
INSERT INTO taxonomy VALUES(628,340183,'Phytopythium','litorale');
INSERT INTO taxonomy VALUES(629,343460,'Plasmopara','wilsonii');
INSERT INTO taxonomy VALUES(630,343461,'Plasmopara','praetermissa');
INSERT INTO taxonomy VALUES(631,344599,'Pythium','sp. PE16');
INSERT INTO taxonomy VALUES(632,347284,'Pythium','sp. UASWS0160');
INSERT INTO taxonomy VALUES(633,347286,'Pythium','sp. UASWS0162');
INSERT INTO taxonomy VALUES(634,347287,'Pythium','sp. UASWS0163');
INSERT INTO taxonomy VALUES(635,347288,'Pythium','sp. UASWS0164');
INSERT INTO taxonomy VALUES(636,347289,'Pythium','sp. UASWS0165');
INSERT INTO taxonomy VALUES(637,347290,'Pythium','sp. UASWS0166');
INSERT INTO taxonomy VALUES(638,347291,'Pythium','sp. UASWS0167');
INSERT INTO taxonomy VALUES(639,347292,'Pythium','sp. UASWS0168');
INSERT INTO taxonomy VALUES(640,347293,'Pythium','sp. UASWS0169');
INSERT INTO taxonomy VALUES(641,347294,'Pythium','sp. UASWS0170');
INSERT INTO taxonomy VALUES(642,347295,'Pythium','sp. UASWS0171');
INSERT INTO taxonomy VALUES(643,347296,'Pythium','sp. UASWS0172');
INSERT INTO taxonomy VALUES(644,347297,'Pythium','sp. UASWS0173');
INSERT INTO taxonomy VALUES(645,347298,'Pythium','sp. UASWS0174');
INSERT INTO taxonomy VALUES(646,347299,'Pythium','sp. UASWS0175');
INSERT INTO taxonomy VALUES(647,347300,'Pythium','sp. UASWS0176');
INSERT INTO taxonomy VALUES(648,347301,'Pythium','sp. UASWS0177');
INSERT INTO taxonomy VALUES(649,347302,'Pythium','sp. UASWS0178');
INSERT INTO taxonomy VALUES(650,347303,'Pythium','sp. UASWS0185');
INSERT INTO taxonomy VALUES(651,347823,'Pythium','sp. PA53');
INSERT INTO taxonomy VALUES(652,347824,'Pythium','sp. PA54');
INSERT INTO taxonomy VALUES(653,347825,'Pythium','sp. PA55');
INSERT INTO taxonomy VALUES(654,347826,'Pythium','sp. PA56');
INSERT INTO taxonomy VALUES(655,347827,'Pythium','sp. PE154');
INSERT INTO taxonomy VALUES(656,347828,'Pythium','sp. PE155');
INSERT INTO taxonomy VALUES(657,347829,'Pythium','sp. PE156');
INSERT INTO taxonomy VALUES(658,347830,'Pythium','sp. PE157');
INSERT INTO taxonomy VALUES(659,347831,'Pythium','sp. PE158');
INSERT INTO taxonomy VALUES(660,347832,'Pythium','sp. PE159');
INSERT INTO taxonomy VALUES(661,347833,'Pythium','sp. PE160');
INSERT INTO taxonomy VALUES(662,349317,'Pythium','sp. F-148');
INSERT INTO taxonomy VALUES(663,349318,'Pythium','sp. F-147');
INSERT INTO taxonomy VALUES(664,349319,'Pythium','sp. F-977');
INSERT INTO taxonomy VALUES(665,349320,'Pythium','sp. F-1331');
INSERT INTO taxonomy VALUES(666,349322,'Pythium','sp. F-1335');
INSERT INTO taxonomy VALUES(667,349323,'Pythium','sp. F-1319');
INSERT INTO taxonomy VALUES(668,349324,'Pythium','sp. F-1318');
INSERT INTO taxonomy VALUES(669,349325,'Pythium','apiculatum');
INSERT INTO taxonomy VALUES(670,349985,'Pythium','sp. PE101');
INSERT INTO taxonomy VALUES(671,349986,'Pythium','sp. UASWS0186');
INSERT INTO taxonomy VALUES(672,349987,'Pythium','sp. UASWS0187');
INSERT INTO taxonomy VALUES(673,349988,'Pythium','sp. UASWS188');
INSERT INTO taxonomy VALUES(674,350600,'Pythium','sp. UASWS0189');
INSERT INTO taxonomy VALUES(675,350616,'Pythium','sp. F-163');
INSERT INTO taxonomy VALUES(676,350617,'Pythium','sp. F-162');
INSERT INTO taxonomy VALUES(677,350618,'Pythium','sp. F-1412');
INSERT INTO taxonomy VALUES(678,350619,'Pythium','sp. F-1413');
INSERT INTO taxonomy VALUES(679,352268,'Pythium','sp. JN-1');
INSERT INTO taxonomy VALUES(680,352829,'Pythium','sp. JN-5');
INSERT INTO taxonomy VALUES(681,352830,'Pythium','sp. JN-6');
INSERT INTO taxonomy VALUES(682,353634,'Pythium','sp. JN-7a');
INSERT INTO taxonomy VALUES(683,353635,'Pythium','sp. JN-8');
INSERT INTO taxonomy VALUES(684,354130,'Pythium','sp. JN-12');
INSERT INTO taxonomy VALUES(685,354131,'Pythium','sp. JN-13');
INSERT INTO taxonomy VALUES(686,354132,'Pythium','sp. JN-14');
INSERT INTO taxonomy VALUES(687,354744,'Pythium','sp. F-1241');
INSERT INTO taxonomy VALUES(688,359324,'Phytophthora','gallica');
INSERT INTO taxonomy VALUES(689,360399,'Phytophthora','fallax');
INSERT INTO taxonomy VALUES(690,360400,'Phytophthora','captiosa');
INSERT INTO taxonomy VALUES(691,362222,'Saprolegnia','anomalies');
INSERT INTO taxonomy VALUES(692,362705,'Phytophthora','sp. MN 23');
INSERT INTO taxonomy VALUES(693,369351,'Pythium','sp. Py26');
INSERT INTO taxonomy VALUES(694,369778,'Benua','kellermanii');
INSERT INTO taxonomy VALUES(695,369779,'Plasmopara','nivea');
INSERT INTO taxonomy VALUES(696,369782,'Plasmoverna','pygmaea');
INSERT INTO taxonomy VALUES(697,369784,'Graminivora','graminicola');
INSERT INTO taxonomy VALUES(698,369823,'Pythium','sterilum');
INSERT INTO taxonomy VALUES(699,369825,'Pythium','sp. PI-5');
INSERT INTO taxonomy VALUES(700,369826,'Peronospora','sp. UASWS0196');
INSERT INTO taxonomy VALUES(701,370328,'Saprolegnia','cf. ferax');
INSERT INTO taxonomy VALUES(702,370329,'Leptolegnia','sp. SAP248');
INSERT INTO taxonomy VALUES(703,371029,'Plasmoverna','anemones-ranunculoides');
INSERT INTO taxonomy VALUES(704,371952,'Protoachlya','paradoxa');
INSERT INTO taxonomy VALUES(705,371956,'Protoachlya','polysporus');
INSERT INTO taxonomy VALUES(706,372164,'Saprolegnia','sp. UNCW105');
INSERT INTO taxonomy VALUES(707,372165,'Saprolegnia','sp. UNCW114');
INSERT INTO taxonomy VALUES(708,372166,'Saprolegnia','sp. UNCW162');
INSERT INTO taxonomy VALUES(709,372167,'Saprolegnia','sp. UNCW170');
INSERT INTO taxonomy VALUES(710,372168,'Saprolegnia','sp. UNCW172');
INSERT INTO taxonomy VALUES(711,372169,'Saprolegnia','sp. UNCW176');
INSERT INTO taxonomy VALUES(712,372170,'Saprolegnia','sp. UNCW177');
INSERT INTO taxonomy VALUES(713,372171,'Saprolegnia','sp. UNCW217');
INSERT INTO taxonomy VALUES(714,372172,'Saprolegnia','sp. UNCW218');
INSERT INTO taxonomy VALUES(715,372173,'Saprolegnia','sp. UNCW219');
INSERT INTO taxonomy VALUES(716,372174,'Saprolegnia','sp. UNCW244');
INSERT INTO taxonomy VALUES(717,372175,'Saprolegnia','sp. UNCW250');
INSERT INTO taxonomy VALUES(718,372176,'Saprolegnia','sp. UNCW251');
INSERT INTO taxonomy VALUES(719,372177,'Saprolegnia','sp. UNCW253');
INSERT INTO taxonomy VALUES(720,372178,'Saprolegnia','sp. UNCW254');
INSERT INTO taxonomy VALUES(721,372179,'Saprolegnia','sp. UNCW257');
INSERT INTO taxonomy VALUES(722,372180,'Saprolegnia','sp. UNCW258');
INSERT INTO taxonomy VALUES(723,372181,'Saprolegnia','sp. UNCW259');
INSERT INTO taxonomy VALUES(724,372182,'Saprolegnia','sp. UNCW260');
INSERT INTO taxonomy VALUES(725,372183,'Saprolegnia','sp. UNCW261');
INSERT INTO taxonomy VALUES(726,372184,'Saprolegnia','sp. UNCW263');
INSERT INTO taxonomy VALUES(727,372185,'Saprolegnia','sp. UNCW264');
INSERT INTO taxonomy VALUES(728,372186,'Saprolegnia','sp. UNCW266');
INSERT INTO taxonomy VALUES(729,372187,'Saprolegnia','sp. UNCW269');
INSERT INTO taxonomy VALUES(730,372188,'Saprolegnia','sp. UNCW271');
INSERT INTO taxonomy VALUES(731,372189,'Saprolegnia','sp. UNCW272');
INSERT INTO taxonomy VALUES(732,372190,'Saprolegnia','sp. UNCW273');
INSERT INTO taxonomy VALUES(733,372191,'Saprolegnia','sp. UNCW277');
INSERT INTO taxonomy VALUES(734,372192,'Saprolegnia','sp. UNCW278');
INSERT INTO taxonomy VALUES(735,372193,'Saprolegnia','sp. UNCW280');
INSERT INTO taxonomy VALUES(736,372194,'Saprolegnia','sp. UNCW283');
INSERT INTO taxonomy VALUES(737,372195,'Saprolegnia','sp. UNCW284');
INSERT INTO taxonomy VALUES(738,372196,'Saprolegnia','sp. UNCW285');
INSERT INTO taxonomy VALUES(739,372197,'Saprolegnia','sp. UNCW286');
INSERT INTO taxonomy VALUES(740,372198,'Saprolegnia','sp. UNCW288');
INSERT INTO taxonomy VALUES(741,372199,'Saprolegnia','sp. UNCW289');
INSERT INTO taxonomy VALUES(742,372200,'Saprolegnia','sp. UNCW290');
INSERT INTO taxonomy VALUES(743,372201,'Saprolegnia','sp. UNCW292');
INSERT INTO taxonomy VALUES(744,372202,'Saprolegnia','sp. UNCW295');
INSERT INTO taxonomy VALUES(745,372203,'Saprolegnia','sp. UNCW298');
INSERT INTO taxonomy VALUES(746,372204,'Saprolegnia','sp. UNCW299');
INSERT INTO taxonomy VALUES(747,372205,'Saprolegnia','sp. UNCW312');
INSERT INTO taxonomy VALUES(748,372206,'Saprolegnia','sp. UNCW314');
INSERT INTO taxonomy VALUES(749,372207,'Saprolegnia','sp. UNCW315');
INSERT INTO taxonomy VALUES(750,372208,'Saprolegnia','sp. UNCW316');
INSERT INTO taxonomy VALUES(751,372209,'Saprolegnia','sp. UNCW320');
INSERT INTO taxonomy VALUES(752,372210,'Saprolegnia','sp. UNCW328');
INSERT INTO taxonomy VALUES(753,372211,'Saprolegnia','sp. UNCW329');
INSERT INTO taxonomy VALUES(754,372212,'Saprolegnia','sp. UNCW291');
INSERT INTO taxonomy VALUES(755,372213,'Saprolegnia','sp. UNCW300');
INSERT INTO taxonomy VALUES(756,372214,'Saprolegnia','sp. UNCW372');
INSERT INTO taxonomy VALUES(757,372215,'Saprolegnia','sp. UNCW373');
INSERT INTO taxonomy VALUES(758,372216,'Saprolegnia','sp. UNCW374');
INSERT INTO taxonomy VALUES(759,372217,'Saprolegnia','sp. UNCW375');
INSERT INTO taxonomy VALUES(760,372218,'Saprolegnia','sp. UNCW377');
INSERT INTO taxonomy VALUES(761,372219,'Saprolegnia','sp. UNCW380');
INSERT INTO taxonomy VALUES(762,372220,'Saprolegnia','sp. UNCW381');
INSERT INTO taxonomy VALUES(763,372221,'Saprolegnia','sp. UNCW382');
INSERT INTO taxonomy VALUES(764,372222,'Saprolegnia','sp. UNCW383');
INSERT INTO taxonomy VALUES(765,372223,'Saprolegnia','sp. UNCW384');
INSERT INTO taxonomy VALUES(766,372224,'Saprolegnia','sp. UNCW385');
INSERT INTO taxonomy VALUES(767,372225,'Saprolegnia','sp. UNCW386');
INSERT INTO taxonomy VALUES(768,372226,'Saprolegnia','sp. UNCW262');
INSERT INTO taxonomy VALUES(769,373629,'Pythium','sp. UASWS0201');
INSERT INTO taxonomy VALUES(770,373630,'Globisporangium','spiculum');
INSERT INTO taxonomy VALUES(771,374175,'Phytophthora','polonica');
INSERT INTO taxonomy VALUES(772,376151,'Phytophthora','cactorum x hedraiandra');
INSERT INTO taxonomy VALUES(773,376152,'Pythium','sp. UASWS0221');
INSERT INTO taxonomy VALUES(774,376153,'Pythium','sp. UASWS0222');
INSERT INTO taxonomy VALUES(775,376154,'Pythium','sp. UASWS0223');
INSERT INTO taxonomy VALUES(776,376155,'Pythium','sp. UASWS0227');
INSERT INTO taxonomy VALUES(777,376157,'Peronospora','sp. UASWS0229');
INSERT INTO taxonomy VALUES(778,376158,'Phytophthora','nicotianae x cactorum');
INSERT INTO taxonomy VALUES(779,377434,'Haptoglossa','heterospora');
INSERT INTO taxonomy VALUES(780,377435,'Haptoglossa','sp. TK01');
INSERT INTO taxonomy VALUES(781,377436,'Haptoglossa','sp. NI01');
INSERT INTO taxonomy VALUES(782,377437,'Haptoglossa','sp. SZ01');
INSERT INTO taxonomy VALUES(783,378252,'Pythium','sp. AP');
INSERT INTO taxonomy VALUES(784,381960,'Pythium','sp. Py292');
INSERT INTO taxonomy VALUES(785,381961,'Pythium','sp. Py293');
INSERT INTO taxonomy VALUES(786,381962,'Pythium','sp. Py294');
INSERT INTO taxonomy VALUES(787,381967,'Peronospora','sp. AM-2006');
INSERT INTO taxonomy VALUES(788,382729,'Phytophthora','sp. MN20FF');
INSERT INTO taxonomy VALUES(789,382730,'Phytophthora','sp. MN1');
INSERT INTO taxonomy VALUES(790,383386,'Peronospora','sp. isolate 079401,55 (BR)');
INSERT INTO taxonomy VALUES(791,383387,'Peronospora','sp. isolate 079403,57 (BR)');
INSERT INTO taxonomy VALUES(792,383388,'Peronospora','sp. isolate 079405,59 (BR)');
INSERT INTO taxonomy VALUES(793,383389,'Peronospora','sp. isolate 079409,63 (BR)');
INSERT INTO taxonomy VALUES(794,383390,'Peronospora','sp. isolate 079413,67 (BR)');
INSERT INTO taxonomy VALUES(795,383391,'Peronospora','sp. isolate UASWS0236');
INSERT INTO taxonomy VALUES(796,383392,'Peronospora','sp. isolate UASWS0237');
INSERT INTO taxonomy VALUES(797,383393,'Peronospora','sp. isolate UASWS0238');
INSERT INTO taxonomy VALUES(798,383394,'Peronospora','sp. isolate UASWS0239');
INSERT INTO taxonomy VALUES(799,383395,'Peronospora','sp. isolate UASWS0240');
INSERT INTO taxonomy VALUES(800,383396,'Peronospora','sp. isolate UASWS0241');
INSERT INTO taxonomy VALUES(801,386775,'Peronospora','sp. UASWS0242');
INSERT INTO taxonomy VALUES(802,386776,'Peronospora','sp. UASWS0243');
INSERT INTO taxonomy VALUES(803,386777,'Peronospora','sp. UASWS0244');
INSERT INTO taxonomy VALUES(804,386778,'Peronospora','sp. UASWS0245');
INSERT INTO taxonomy VALUES(805,386779,'Peronospora','sp. UASWS0246');
INSERT INTO taxonomy VALUES(806,386780,'Peronospora','sp. UASWS0247');
INSERT INTO taxonomy VALUES(807,386781,'Peronospora','sp. UASWS0248');
INSERT INTO taxonomy VALUES(808,386782,'Peronospora','sp. UASWS0249');
INSERT INTO taxonomy VALUES(809,386783,'Peronospora','sp. UASWS0250');
INSERT INTO taxonomy VALUES(810,386784,'Peronospora','sp. UASWS0251');
INSERT INTO taxonomy VALUES(811,386785,'Peronospora','sp. UASWS0252');
INSERT INTO taxonomy VALUES(812,386786,'Peronospora','sp. UASWS0253');
INSERT INTO taxonomy VALUES(813,386787,'Peronospora','sp. UASWS0254');
INSERT INTO taxonomy VALUES(814,386788,'Peronospora','sp. UASWS0255');
INSERT INTO taxonomy VALUES(815,386789,'Peronospora','sp. UASWS0256');
INSERT INTO taxonomy VALUES(816,386790,'Peronospora','sp. UASWS0257');
INSERT INTO taxonomy VALUES(817,386791,'Peronospora','sp. UASWS0258');
INSERT INTO taxonomy VALUES(818,387099,'Pythium','sp. UASWS0263');
INSERT INTO taxonomy VALUES(819,387100,'Pythium','sp. UASWS0268');
INSERT INTO taxonomy VALUES(820,387101,'Pythium','sp. UASWS0269');
INSERT INTO taxonomy VALUES(821,387102,'Pythium','sp. UASWS0271');
INSERT INTO taxonomy VALUES(822,387263,'Pythium','sp. 96-224');
INSERT INTO taxonomy VALUES(823,387436,'Pythium','sp. UASWS0276');
INSERT INTO taxonomy VALUES(824,393596,'Saprolegnia','sp. THMK0306');
INSERT INTO taxonomy VALUES(825,394619,'Pythium','sp. F-1432.1');
INSERT INTO taxonomy VALUES(826,394620,'Pythium','sp. F-1374');
INSERT INTO taxonomy VALUES(827,394621,'Pythium','sp. F-1393');
INSERT INTO taxonomy VALUES(828,394622,'Pythium','sp. F-1476');
INSERT INTO taxonomy VALUES(829,394623,'Pythium','sp. F-1376');
INSERT INTO taxonomy VALUES(830,394711,'Pythium','sp. F-1306');
INSERT INTO taxonomy VALUES(831,394712,'Pythium','sp. F-1399');
INSERT INTO taxonomy VALUES(832,394713,'Pythium','sp. F-940');
INSERT INTO taxonomy VALUES(833,394714,'Pythium','sp. F-1308');
INSERT INTO taxonomy VALUES(834,398757,'Phytophthora','sp. BR514');
INSERT INTO taxonomy VALUES(835,399382,'Aphanomyces','sp. JN-9');
INSERT INTO taxonomy VALUES(836,399415,'Phytophthora','sp. EC3414');
INSERT INTO taxonomy VALUES(837,399474,'Phytophthora','sp. EC3090');
INSERT INTO taxonomy VALUES(838,399475,'Phytophthora','sp. EC3094');
INSERT INTO taxonomy VALUES(839,399476,'Phytophthora','sp. EC3099');
INSERT INTO taxonomy VALUES(840,399477,'Phytophthora','sp. EC3154');
INSERT INTO taxonomy VALUES(841,399478,'Phytophthora','sp. EC3199');
INSERT INTO taxonomy VALUES(842,399479,'Phytophthora','sp. EC3237');
INSERT INTO taxonomy VALUES(843,399480,'Phytophthora','sp. EC3238');
INSERT INTO taxonomy VALUES(844,399481,'Phytophthora','sp. EC3240');
INSERT INTO taxonomy VALUES(845,399482,'Phytophthora','sp. EC3253');
INSERT INTO taxonomy VALUES(846,399483,'Phytophthora','sp. EC3300');
INSERT INTO taxonomy VALUES(847,399484,'Phytophthora','sp. EC3308');
INSERT INTO taxonomy VALUES(848,399485,'Phytophthora','sp. EC3309');
INSERT INTO taxonomy VALUES(849,399486,'Phytophthora','sp. EC3310');
INSERT INTO taxonomy VALUES(850,399487,'Phytophthora','sp. EC3330');
INSERT INTO taxonomy VALUES(851,399488,'Phytophthora','sp. EC3331');
INSERT INTO taxonomy VALUES(852,399489,'Phytophthora','sp. EC3335');
INSERT INTO taxonomy VALUES(853,399490,'Phytophthora','sp. EC3336');
INSERT INTO taxonomy VALUES(854,399491,'Phytophthora','sp. EC3364');
INSERT INTO taxonomy VALUES(855,399492,'Phytophthora','sp. EC3394');
INSERT INTO taxonomy VALUES(856,399493,'Phytophthora','sp. EC3449');
INSERT INTO taxonomy VALUES(857,401379,'Pythium','sp. AW-A');
INSERT INTO taxonomy VALUES(858,401381,'Pythium','sp. AW-B');
INSERT INTO taxonomy VALUES(859,402602,'Pythium','sp. AW-C');
INSERT INTO taxonomy VALUES(860,402603,'Pythium','sp. AW-N');
INSERT INTO taxonomy VALUES(861,402604,'Pythium','sp. AW-D');
INSERT INTO taxonomy VALUES(862,402605,'Pythium','sp. AW-E');
INSERT INTO taxonomy VALUES(863,402606,'Pythium','sp. AW-F');
INSERT INTO taxonomy VALUES(864,402607,'Pythium','sp. AW-G');
INSERT INTO taxonomy VALUES(865,402608,'Pythium','sp. AW-H');
INSERT INTO taxonomy VALUES(866,402609,'Aphanomyces','sp. AW-I');
INSERT INTO taxonomy VALUES(867,402610,'Aphanomyces','sp. AW-J');
INSERT INTO taxonomy VALUES(868,403825,'Pythium','sp. quercum');
INSERT INTO taxonomy VALUES(869,405749,'Peronospora','sp. UF0651');
INSERT INTO taxonomy VALUES(870,405949,'Peronospora','sp. SMK 17388');
INSERT INTO taxonomy VALUES(871,405950,'Peronospora','sp. SMK 19551');
INSERT INTO taxonomy VALUES(872,405951,'Peronospora','sp. SMK 20438');
INSERT INTO taxonomy VALUES(873,410070,'Phytophthora','sp. WV BSC');
INSERT INTO taxonomy VALUES(874,410723,'Pythium','quercum');
INSERT INTO taxonomy VALUES(875,410860,'Phytophthora','sp. MN14d');
INSERT INTO taxonomy VALUES(876,411106,'Phytophthora','sp. GD7E');
INSERT INTO taxonomy VALUES(877,411258,'Pythium','sp. WD2D');
INSERT INTO taxonomy VALUES(878,411259,'Pythium','sp. WD2E');
INSERT INTO taxonomy VALUES(879,411260,'Pythium','sp. WD2J');
INSERT INTO taxonomy VALUES(880,412151,'Phytophthora','sp. ICMP 16471');
INSERT INTO taxonomy VALUES(881,413847,'Haliphthoros','sp. NJM 0443');
INSERT INTO taxonomy VALUES(882,413848,'Haliphthoros','sp. NJM 0440');
INSERT INTO taxonomy VALUES(883,413849,'Halodaphnea','panulirata');
INSERT INTO taxonomy VALUES(884,413850,'Halocrusticida','parasitica');
INSERT INTO taxonomy VALUES(885,413851,'Halocrusticida','baliensis');
INSERT INTO taxonomy VALUES(886,414967,'Haliphthoros','sp. NJM 0143');
INSERT INTO taxonomy VALUES(887,414968,'Haliphthoros','sp. NJM 0449');
INSERT INTO taxonomy VALUES(888,414969,'Haliphthoros','sp. NJM 0535');
INSERT INTO taxonomy VALUES(889,415739,'Phytophthora','sp. frigida');
INSERT INTO taxonomy VALUES(890,415740,'Phytophthora','sp. alticola');
INSERT INTO taxonomy VALUES(891,415976,'Phytophthora','foliorum');
INSERT INTO taxonomy VALUES(892,416215,'Pythium','sp. UASWS0288');
INSERT INTO taxonomy VALUES(893,416216,'Pythium','sp. UASWS0290');
INSERT INTO taxonomy VALUES(894,416217,'Pythium','sp. UASWS0291');
INSERT INTO taxonomy VALUES(895,416218,'Pythium','sp. UASWS0292');
INSERT INTO taxonomy VALUES(896,416219,'Pythium','sp. UASWS0293');
INSERT INTO taxonomy VALUES(897,416220,'Pythium','sp. WD2B');
INSERT INTO taxonomy VALUES(898,416221,'Pythium','sp. WD2C');
INSERT INTO taxonomy VALUES(899,416223,'Saprolegnia','sp. WD4C');
INSERT INTO taxonomy VALUES(900,416547,'Pythium','sp. F-1309.1');
INSERT INTO taxonomy VALUES(901,416548,'Pythium','sp. F-1374.1');
INSERT INTO taxonomy VALUES(902,416549,'Pythium','sp. F-1308.1');
INSERT INTO taxonomy VALUES(903,416550,'Pythium','sp. F-1318.1');
INSERT INTO taxonomy VALUES(904,416551,'Pythium','sp. F-1476.1');
INSERT INTO taxonomy VALUES(905,416552,'Pythium','sp. F-1253');
INSERT INTO taxonomy VALUES(906,416808,'Pontisma','porphyrae');
INSERT INTO taxonomy VALUES(907,417335,'Phytophthora','sp. GD2f');
INSERT INTO taxonomy VALUES(908,417336,'Phytophthora','sp. GD4a');
INSERT INTO taxonomy VALUES(909,417337,'Phytophthora','sp. GD4b');
INSERT INTO taxonomy VALUES(910,417338,'Phytophthora','sp. GD4c');
INSERT INTO taxonomy VALUES(911,417339,'Phytophthora','sp. GD4f');
INSERT INTO taxonomy VALUES(912,417340,'Phytophthora','sp. WD40b');
INSERT INTO taxonomy VALUES(913,417341,'Pythium','sp. 824b');
INSERT INTO taxonomy VALUES(914,417342,'Pythium','sp. GD29c');
INSERT INTO taxonomy VALUES(915,417343,'Pythium','sp. GD33b');
INSERT INTO taxonomy VALUES(916,417344,'Pythium','sp. GD4e');
INSERT INTO taxonomy VALUES(917,417345,'Saprolegnia','sp. W805b');
INSERT INTO taxonomy VALUES(918,417820,'Peronospora','sp. S4');
INSERT INTO taxonomy VALUES(919,417821,'Peronospora','sp. S6');
INSERT INTO taxonomy VALUES(920,417822,'Peronospora','sp. S6-2');
INSERT INTO taxonomy VALUES(921,417823,'Peronospora','sp. S7');
INSERT INTO taxonomy VALUES(922,417824,'Peronospora','sp. S7-2');
INSERT INTO taxonomy VALUES(923,417825,'Phytophthora','sp. P12745');
INSERT INTO taxonomy VALUES(924,417826,'Phytophthora','sp. P12845');
INSERT INTO taxonomy VALUES(925,417827,'Pythium','sp. P15845');
INSERT INTO taxonomy VALUES(926,419135,'Phytophthora','sp. LT');
INSERT INTO taxonomy VALUES(927,421884,'Pythium','sp. PB-2007');
INSERT INTO taxonomy VALUES(928,421928,'Diasporangium','sp. CCD-2007');
INSERT INTO taxonomy VALUES(929,422210,'Pythium','sp. UASWS Py26');
INSERT INTO taxonomy VALUES(930,422211,'Pythium','sp. UASWS STEU6208');
INSERT INTO taxonomy VALUES(931,422212,'Pythium','sp. UASWS STEU6209');
INSERT INTO taxonomy VALUES(932,422213,'Pythium','sp. UASWS STEU6210');
INSERT INTO taxonomy VALUES(933,425772,'Peronospora','sp. A1');
INSERT INTO taxonomy VALUES(934,425773,'Peronospora','sp. A2');
INSERT INTO taxonomy VALUES(935,425774,'Peronospora','sp. B1');
INSERT INTO taxonomy VALUES(936,425775,'Peronospora','sp. B2');
INSERT INTO taxonomy VALUES(937,425776,'Peronospora','sp. C1');
INSERT INTO taxonomy VALUES(938,425777,'Peronospora','sp. C2');
INSERT INTO taxonomy VALUES(939,425778,'Peronospora','sp. D1');
INSERT INTO taxonomy VALUES(940,425779,'Peronospora','sp. D2');
INSERT INTO taxonomy VALUES(941,425780,'Peronospora','sp. E1');
INSERT INTO taxonomy VALUES(942,425781,'Peronospora','sp. E3');
INSERT INTO taxonomy VALUES(943,425782,'Peronospora','sp. F1');
INSERT INTO taxonomy VALUES(944,425783,'Peronospora','sp. F2');
INSERT INTO taxonomy VALUES(945,425784,'Peronospora','sp. G1');
INSERT INTO taxonomy VALUES(946,425785,'Peronospora','sp. G2');
INSERT INTO taxonomy VALUES(947,425786,'Peronospora','sp. H1');
INSERT INTO taxonomy VALUES(948,428695,'Pythium','sp. recalcitrans');
INSERT INTO taxonomy VALUES(949,429562,'Pythium','guiyangense');
INSERT INTO taxonomy VALUES(950,429744,'Phytophthora','sp. Kunnunara');
INSERT INTO taxonomy VALUES(951,431833,'Phytophthora','sp. H-6/02');
INSERT INTO taxonomy VALUES(952,431834,'Phytophthora','sp. H-7/02');
INSERT INTO taxonomy VALUES(953,431835,'Phytophthora','sp. H-8/02');
INSERT INTO taxonomy VALUES(954,433353,'Saprolegnia','sp. II-2');
INSERT INTO taxonomy VALUES(955,433354,'Saprolegnia','sp. LB');
INSERT INTO taxonomy VALUES(956,433355,'Saprolegnia','sp. H-');
INSERT INTO taxonomy VALUES(957,434349,'Peronospora','fulva');
INSERT INTO taxonomy VALUES(958,434350,'Peronospora','medicaginis-minimae');
INSERT INTO taxonomy VALUES(959,434351,'Peronospora','lathyri-verni');
INSERT INTO taxonomy VALUES(960,434352,'Peronospora','lathyrina');
INSERT INTO taxonomy VALUES(961,434353,'Peronospora','tetragonolobi');
INSERT INTO taxonomy VALUES(962,434355,'Peronospora','medicaginis-orbicularis');
INSERT INTO taxonomy VALUES(963,434356,'Peronospora','ornithopi');
INSERT INTO taxonomy VALUES(964,434360,'Peronospora','trifolii-arvensis');
INSERT INTO taxonomy VALUES(965,434361,'Peronospora','orobi');
INSERT INTO taxonomy VALUES(966,434492,'Phytophthora','sp. VHSC13615');
INSERT INTO taxonomy VALUES(967,434493,'Phytophthora','sp. VHSC13713');
INSERT INTO taxonomy VALUES(968,434925,'Saprolegnia','sp. MCA 3030');
INSERT INTO taxonomy VALUES(969,434926,'Saprolegnia','sp. MCA 3070');
INSERT INTO taxonomy VALUES(970,434927,'Aphanomyces','sp. MCA 3058');
INSERT INTO taxonomy VALUES(971,435244,'Peronospora','sp. GG133');
INSERT INTO taxonomy VALUES(972,435245,'Peronospora','sp. GG56');
INSERT INTO taxonomy VALUES(973,435246,'Peronospora','sp. GG99');
INSERT INTO taxonomy VALUES(974,435247,'Peronospora','sp. HV22.3F');
INSERT INTO taxonomy VALUES(975,435248,'Peronospora','sp. HV27.1F-27.3');
INSERT INTO taxonomy VALUES(976,435249,'Peronospora','sp. HV48.3F');
INSERT INTO taxonomy VALUES(977,435250,'Peronospora','sp. HV938');
INSERT INTO taxonomy VALUES(978,435251,'Peronospora','sp. HV956');
INSERT INTO taxonomy VALUES(979,435252,'Peronospora','sp. MA-Fungi27993');
INSERT INTO taxonomy VALUES(980,435253,'Peronospora','sp. MG1796');
INSERT INTO taxonomy VALUES(981,435254,'Peronospora','sp. MG1797');
INSERT INTO taxonomy VALUES(982,436079,'Phytophthora','siskiyouensis');
INSERT INTO taxonomy VALUES(983,436701,'Plasmopara','penniseti');
INSERT INTO taxonomy VALUES(984,437581,'Phytophthora','taxon hungarica');
INSERT INTO taxonomy VALUES(985,437582,'Phytophthora','sp. sylvatica');
INSERT INTO taxonomy VALUES(986,438833,'Plasmopara','constantinescui');
INSERT INTO taxonomy VALUES(987,439464,'Pythium','sp. 286');
INSERT INTO taxonomy VALUES(988,439807,'Pythium','sp. 173');
INSERT INTO taxonomy VALUES(989,442665,'Myzocytiopsis','glutinospora');
INSERT INTO taxonomy VALUES(990,443219,'Phytophthora','sp. cuyabensis');
INSERT INTO taxonomy VALUES(991,444502,'Pythium','sp. F-1509');
INSERT INTO taxonomy VALUES(992,444503,'Pythium','sp. F-166');
INSERT INTO taxonomy VALUES(993,444504,'Pythium','sp. F-42.1');
INSERT INTO taxonomy VALUES(994,444505,'Pythium','sp. F-713');
INSERT INTO taxonomy VALUES(995,444506,'Pythium','sp. F-923.1');
INSERT INTO taxonomy VALUES(996,444507,'Pythium','sp. tumidum');
INSERT INTO taxonomy VALUES(997,445396,'Phytophthora','cuyabensis');
INSERT INTO taxonomy VALUES(998,445398,'Phytophthora','sulawesiensis');
INSERT INTO taxonomy VALUES(999,446563,'Pythium','sp. SB10-1');
INSERT INTO taxonomy VALUES(1000,446564,'Pythium','sp. PB2-R8-A Lr');
INSERT INTO taxonomy VALUES(1001,446565,'Pythium','sp. SB9-4');
INSERT INTO taxonomy VALUES(1002,447326,'Bremia','sp. UASWS0322');
INSERT INTO taxonomy VALUES(1003,447327,'Bremia','sp. UASWS0323');
INSERT INTO taxonomy VALUES(1004,447328,'Bremia','sp. UASWS0324');
INSERT INTO taxonomy VALUES(1005,447329,'Bremia','sp. UASWS0325');
INSERT INTO taxonomy VALUES(1006,447330,'Bremia','sp. UASWS0326');
INSERT INTO taxonomy VALUES(1007,453155,'Hyaloperonospora','parasitica species group');
INSERT INTO taxonomy VALUES(1008,455088,'Phytophthora','sp. 77-231');
INSERT INTO taxonomy VALUES(1009,455089,'Pythium','sp. 93-68P');
INSERT INTO taxonomy VALUES(1010,455158,'Phytophthora','sp. 91-112');
INSERT INTO taxonomy VALUES(1011,455159,'Pythium','sp. 93-70P');
INSERT INTO taxonomy VALUES(1012,455356,'Pythium','sp. valencianum');
INSERT INTO taxonomy VALUES(1013,455357,'Pythium','sp. ''amazonianum''');
INSERT INTO taxonomy VALUES(1014,457353,'Phytophthora','sp. thermophilum');
INSERT INTO taxonomy VALUES(1015,457354,'Phytophthora','sp. napoensis');
INSERT INTO taxonomy VALUES(1016,458389,'Pythium','sp. 13 eu');
INSERT INTO taxonomy VALUES(1017,458390,'Pythium','sp. 14 eu');
INSERT INTO taxonomy VALUES(1018,458391,'Pythium','sp. 22 us-1');
INSERT INTO taxonomy VALUES(1019,458392,'Pythium','sp. 241 us-1');
INSERT INTO taxonomy VALUES(1020,458393,'Pythium','sp. 26 us-2');
INSERT INTO taxonomy VALUES(1021,458394,'Pythium','sp. 280 A eu');
INSERT INTO taxonomy VALUES(1022,458395,'Pythium','sp. 29 us');
INSERT INTO taxonomy VALUES(1023,458396,'Pythium','sp. 30b us-1');
INSERT INTO taxonomy VALUES(1024,458397,'Pythium','sp. 4 eu');
INSERT INTO taxonomy VALUES(1025,458398,'Pythium','sp. 6 eu');
INSERT INTO taxonomy VALUES(1026,458399,'Pythium','sp. 7b eu');
INSERT INTO taxonomy VALUES(1027,458400,'Pythium','sp. 802 us-2');
INSERT INTO taxonomy VALUES(1028,458401,'Pythium','sp. 803-2 us');
INSERT INTO taxonomy VALUES(1029,458402,'Pythium','sp. 805 us');
INSERT INTO taxonomy VALUES(1030,458403,'Pythium','sp. 806 us');
INSERT INTO taxonomy VALUES(1031,458404,'Pythium','sp. 814 us-2');
INSERT INTO taxonomy VALUES(1032,458405,'Pythium','sp. 840b us');
INSERT INTO taxonomy VALUES(1033,458406,'Pythium','sp. 845 us-2');
INSERT INTO taxonomy VALUES(1034,458407,'Pythium','sp. 870 us');
INSERT INTO taxonomy VALUES(1035,458408,'Pythium','sp. 881 us-1');
INSERT INTO taxonomy VALUES(1036,458409,'Pythium','sp. 884 us-2');
INSERT INTO taxonomy VALUES(1037,458410,'Pythium','sp. 914 us');
INSERT INTO taxonomy VALUES(1038,458411,'Pythium','sp. 916 us');
INSERT INTO taxonomy VALUES(1039,458412,'Pythium','sp. 978 eu B');
INSERT INTO taxonomy VALUES(1040,458413,'Pythium','sp. 987 B eu');
INSERT INTO taxonomy VALUES(1041,458414,'Pythium','sp. 987-A eu');
INSERT INTO taxonomy VALUES(1042,458415,'Pythium','sp. 991b eu');
INSERT INTO taxonomy VALUES(1043,458840,'Phytophthora','sp. novaeguinee');
INSERT INTO taxonomy VALUES(1044,459871,'Phytophthora','sp. P8618');
INSERT INTO taxonomy VALUES(1045,459872,'Phytophthora','sp. P8619');
INSERT INTO taxonomy VALUES(1046,459873,'Phytophthora','sp. ''personii''');
INSERT INTO taxonomy VALUES(1047,459874,'Phytophthora','sp. P11555');
INSERT INTO taxonomy VALUES(1048,459875,'Phytophthora','sp. P10417');
INSERT INTO taxonomy VALUES(1049,459876,'Phytophthora','sp. P10672');
INSERT INTO taxonomy VALUES(1050,459877,'Phytophthora','sp. P1087');
INSERT INTO taxonomy VALUES(1051,459878,'Phytophthora','sp. P6875');
INSERT INTO taxonomy VALUES(1052,459879,'Phytophthora','sp. P10690');
INSERT INTO taxonomy VALUES(1053,459880,'Phytophthora','sp. P10705');
INSERT INTO taxonomy VALUES(1054,459881,'Phytophthora','sp. P10090');
INSERT INTO taxonomy VALUES(1055,459882,'Phytophthora','mexicana');
INSERT INTO taxonomy VALUES(1056,459883,'Phytophthora','quercetorum');
INSERT INTO taxonomy VALUES(1057,461275,'Bremia','centaureae');
INSERT INTO taxonomy VALUES(1058,461277,'Novotelnova','scorzonerae');
INSERT INTO taxonomy VALUES(1059,461278,'Paraperonospora','tanaceti');
INSERT INTO taxonomy VALUES(1060,461279,'Plasmopara','euphrasiae');
INSERT INTO taxonomy VALUES(1061,461878,'Pythium','sp. F-1231');
INSERT INTO taxonomy VALUES(1062,461879,'Pythium','sp. F-1504.2.0');
INSERT INTO taxonomy VALUES(1063,461880,'Pythium','sp. F-1511.2 (Ourika 2)');
INSERT INTO taxonomy VALUES(1064,463007,'Leptolegnia','sp. PSCR0503');
INSERT INTO taxonomy VALUES(1065,463009,'Saprolegnia','sp. RACA0702');
INSERT INTO taxonomy VALUES(1066,466188,'Peronospora','sp. DAR45530');
INSERT INTO taxonomy VALUES(1067,466189,'Peronospora','sp. SMK20063');
INSERT INTO taxonomy VALUES(1068,467161,'Peronosclerospora','sacchari');
INSERT INTO taxonomy VALUES(1069,467162,'Peronosclerospora','heteropogonis');
INSERT INTO taxonomy VALUES(1070,467163,'Peronosclerospora','noblei');
INSERT INTO taxonomy VALUES(1071,467166,'Peronosclerospora','sp. BRIP 46698A');
INSERT INTO taxonomy VALUES(1072,467176,'Sclerophthora','macrospora');
INSERT INTO taxonomy VALUES(1073,467781,'Phytophthora','sp. SY1982');
INSERT INTO taxonomy VALUES(1074,467782,'Phytophthora','sp. P10080');
INSERT INTO taxonomy VALUES(1075,467783,'Phytophthora','sp. P10335');
INSERT INTO taxonomy VALUES(1076,467784,'Phytophthora','sp. P10442');
INSERT INTO taxonomy VALUES(1077,467785,'Phytophthora','sp. P10456');
INSERT INTO taxonomy VALUES(1078,467787,'Phytophthora','sp. P10679');
INSERT INTO taxonomy VALUES(1079,467788,'Phytophthora','sp. P1679');
INSERT INTO taxonomy VALUES(1080,467789,'Phytophthora','sp. P1825');
INSERT INTO taxonomy VALUES(1081,467790,'Phytophthora','sp. P3007');
INSERT INTO taxonomy VALUES(1082,467791,'Phytophthora','sp. P3103');
INSERT INTO taxonomy VALUES(1083,467792,'Phytophthora','sp. P7491');
INSERT INTO taxonomy VALUES(1084,467793,'Phytophthora','sp. P8480');
INSERT INTO taxonomy VALUES(1085,467794,'Phytophthora','sp. PDA576');
INSERT INTO taxonomy VALUES(1086,467795,'Phytophthora','sp. PDA984');
INSERT INTO taxonomy VALUES(1087,468620,'Phytophthora','sp. 92-207');
INSERT INTO taxonomy VALUES(1088,468621,'Phytophthora','sp. 92-209C');
INSERT INTO taxonomy VALUES(1089,468622,'Phytophthora','taxon asparagi');
INSERT INTO taxonomy VALUES(1090,468623,'Albugo','lepidii');
INSERT INTO taxonomy VALUES(1091,468624,'Albugo','capparis');
INSERT INTO taxonomy VALUES(1092,468625,'Albugo','sp. SMK13752');
INSERT INTO taxonomy VALUES(1093,468626,'Albugo','sp. SMK15670');
INSERT INTO taxonomy VALUES(1094,470318,'Pythium','sp. AW-K');
INSERT INTO taxonomy VALUES(1095,470319,'Pythium','sp. AW-M');
INSERT INTO taxonomy VALUES(1096,470320,'Aphanomyces','sp. AW-L');
INSERT INTO taxonomy VALUES(1097,470715,'Saprolegnia','sp. nuchiae');
INSERT INTO taxonomy VALUES(1098,471156,'Pythium','sp. solare');
INSERT INTO taxonomy VALUES(1099,475204,'Pythium','aff. phragmitis');
INSERT INTO taxonomy VALUES(1100,475607,'Pythium','sp. takayamanum');
INSERT INTO taxonomy VALUES(1101,475626,'Phytophthora','sp. zentmyerii');
INSERT INTO taxonomy VALUES(1102,476099,'Olpidiopsis','sp. 4439');
INSERT INTO taxonomy VALUES(1103,479473,'Phytophthora','taxon Pgchlamydo');
INSERT INTO taxonomy VALUES(1104,479888,'Phytophthora','sp. 458');
INSERT INTO taxonomy VALUES(1105,479889,'Phytophthora','sp. Ps-56');
INSERT INTO taxonomy VALUES(1106,479890,'Phytophthora','sp. Ps-57');
INSERT INTO taxonomy VALUES(1107,479891,'Phytophthora','sp. Ps-63');
INSERT INTO taxonomy VALUES(1108,479892,'Phytophthora','sp. Ps-7');
INSERT INTO taxonomy VALUES(1109,479953,'Phytophthora','sp. 1670-08');
INSERT INTO taxonomy VALUES(1110,479954,'Phytophthora','sp. 1670-11');
INSERT INTO taxonomy VALUES(1111,479955,'Phytophthora','sp. ST18-37');
INSERT INTO taxonomy VALUES(1112,480029,'Pythium','sp. CHE-284');
INSERT INTO taxonomy VALUES(1113,480030,'Pythium','sp. CHE-287');
INSERT INTO taxonomy VALUES(1114,480032,'Phytophthora','sp. Asparagus 117');
INSERT INTO taxonomy VALUES(1115,480033,'Phytophthora','sp. Asparagus 287');
INSERT INTO taxonomy VALUES(1116,481581,'Achlya','stellata');
INSERT INTO taxonomy VALUES(1117,481583,'Saprolegnia','cf. kauffmanniana H1E2');
INSERT INTO taxonomy VALUES(1118,481584,'Saprolegnia','sp. AE1');
INSERT INTO taxonomy VALUES(1119,481585,'Saprolegnia','sp. BBE08');
INSERT INTO taxonomy VALUES(1120,481586,'Saprolegnia','sp. BBE15');
INSERT INTO taxonomy VALUES(1121,481587,'Saprolegnia','sp. BBE17');
INSERT INTO taxonomy VALUES(1122,481588,'Saprolegnia','sp. BBE20');
INSERT INTO taxonomy VALUES(1123,481589,'Saprolegnia','sp. H1E1');
INSERT INTO taxonomy VALUES(1124,481590,'Saprolegnia','sp. H1E4');
INSERT INTO taxonomy VALUES(1125,481591,'Saprolegnia','sp. H2E1');
INSERT INTO taxonomy VALUES(1126,481592,'Saprolegnia','sp. H2E3');
INSERT INTO taxonomy VALUES(1127,481593,'Saprolegnia','sp. H3E1');
INSERT INTO taxonomy VALUES(1128,481594,'Saprolegnia','sp. H3E2');
INSERT INTO taxonomy VALUES(1129,481595,'Saprolegnia','sp. H3E3');
INSERT INTO taxonomy VALUES(1130,481596,'Saprolegnia','sp. H3E5');
INSERT INTO taxonomy VALUES(1131,482632,'Leptolegnia','sp. K08');
INSERT INTO taxonomy VALUES(1132,482705,'Pythium','sp. 754B');
INSERT INTO taxonomy VALUES(1133,482722,'Pythium','sp. GD18D');
INSERT INTO taxonomy VALUES(1134,482723,'Pythium','sp. GD34B');
INSERT INTO taxonomy VALUES(1135,482738,'Pythium','sp. WD44A');
INSERT INTO taxonomy VALUES(1136,482739,'Pythium','sp. WD46A');
INSERT INTO taxonomy VALUES(1137,482745,'Saprolegnia','sp. WD18C');
INSERT INTO taxonomy VALUES(1138,482749,'Saprolegnia','sp. WD1E');
INSERT INTO taxonomy VALUES(1139,482751,'Saprolegnia','sp. WD1G');
INSERT INTO taxonomy VALUES(1140,482753,'Saprolegnia','sp. WD1I');
INSERT INTO taxonomy VALUES(1141,482754,'Saprolegnia','sp. WD1J');
INSERT INTO taxonomy VALUES(1142,482757,'Saprolegnia','sp. WD1M');
INSERT INTO taxonomy VALUES(1143,482759,'Saprolegnia','sp. WD34A');
INSERT INTO taxonomy VALUES(1144,482760,'Saprolegnia','sp. WD3A');
INSERT INTO taxonomy VALUES(1145,482761,'Saprolegnia','sp. WD3B');
INSERT INTO taxonomy VALUES(1146,482762,'Saprolegnia','sp. WD3D');
INSERT INTO taxonomy VALUES(1147,482763,'Saprolegnia','sp. WD3E');
INSERT INTO taxonomy VALUES(1148,482764,'Saprolegnia','sp. WD3G');
INSERT INTO taxonomy VALUES(1149,485441,'Myzocytiopsis','intermedia');
INSERT INTO taxonomy VALUES(1150,485442,'Myzocytiopsis','vermicola');
INSERT INTO taxonomy VALUES(1151,485444,'Chlamydomyzium','sp. SL02');
INSERT INTO taxonomy VALUES(1152,485445,'Haptoglossa','sp. IMI#395179');
INSERT INTO taxonomy VALUES(1153,485446,'Myzocytiopsis','sp. venatrix');
INSERT INTO taxonomy VALUES(1154,488387,'Saprolegnia','sp. JY');
INSERT INTO taxonomy VALUES(1155,488388,'Saprolegnia','sp. BMY');
INSERT INTO taxonomy VALUES(1156,488863,'Phytophthora','sp. 6 TIB-2007');
INSERT INTO taxonomy VALUES(1157,488865,'Phytophthora','sp. 8 TIB-2007');
INSERT INTO taxonomy VALUES(1158,490914,'Pythium','ornamentatum');
INSERT INTO taxonomy VALUES(1159,490915,'Pythium','sp. KS121');
INSERT INTO taxonomy VALUES(1160,491012,'Phytophthora','sp. 23J7');
INSERT INTO taxonomy VALUES(1161,492061,'Pythium','sp. stipitatum (TUR 14-3)');
INSERT INTO taxonomy VALUES(1162,492096,'Saprolegnia','sp. EM14');
INSERT INTO taxonomy VALUES(1163,492097,'Saprolegnia','sp. EM25');
INSERT INTO taxonomy VALUES(1164,496858,'Albugo','sp. BPI877752');
INSERT INTO taxonomy VALUES(1165,496859,'Albugo','sp. BPI877753');
INSERT INTO taxonomy VALUES(1166,496860,'Albugo','sp. BPI877754');
INSERT INTO taxonomy VALUES(1167,496861,'Albugo','sp. SAU80');
INSERT INTO taxonomy VALUES(1168,501486,'Saprolegnia','brachydanionis (nom. inval.)');
INSERT INTO taxonomy VALUES(1169,502111,'Bremia','microspora');
INSERT INTO taxonomy VALUES(1170,502112,'Bremia','ovata');
INSERT INTO taxonomy VALUES(1171,502113,'Bremia','saussureae');
INSERT INTO taxonomy VALUES(1172,502114,'Bremia','sonchicola');
INSERT INTO taxonomy VALUES(1173,502252,'Paraperonospora','minor');
INSERT INTO taxonomy VALUES(1174,502323,'Pythium','sp. balticum');
INSERT INTO taxonomy VALUES(1175,503243,'Phytophthora','sp. 1-21-1');
INSERT INTO taxonomy VALUES(1176,503244,'Phytophthora','sp. 1931');
INSERT INTO taxonomy VALUES(1177,503245,'Phytophthora','sp. 2-04B');
INSERT INTO taxonomy VALUES(1178,503246,'Phytophthora','sp. 62169-00');
INSERT INTO taxonomy VALUES(1179,503247,'Phytophthora','sp. 80213-91');
INSERT INTO taxonomy VALUES(1180,503248,'Phytophthora','sp. B-6');
INSERT INTO taxonomy VALUES(1181,505981,'Haptoglossa','zoospora');
INSERT INTO taxonomy VALUES(1182,505982,'Haptoglossa','sp. KG01');
INSERT INTO taxonomy VALUES(1183,505983,'Haptoglossa','sp. KG02');
INSERT INTO taxonomy VALUES(1184,505984,'Haptoglossa','sp. SZ03');
INSERT INTO taxonomy VALUES(1185,507571,'Saprolegnia','sp. RACL2005Karraker');
INSERT INTO taxonomy VALUES(1186,507576,'Peronospora','perillae');
INSERT INTO taxonomy VALUES(1187,508680,'Phytophthora','ohioensis (nom. inval.)');
INSERT INTO taxonomy VALUES(1188,510390,'Pythium','sp. Tun-30');
INSERT INTO taxonomy VALUES(1189,510391,'Pythium','sp. Tun-2');
INSERT INTO taxonomy VALUES(1190,510498,'Phytophthora','sp. ripicola');
INSERT INTO taxonomy VALUES(1191,510686,'Pythium','sp. WM_5');
INSERT INTO taxonomy VALUES(1192,510687,'Saprolegnia','sp. WM_1');
INSERT INTO taxonomy VALUES(1193,510688,'Saprolegnia','sp. WM_2');
INSERT INTO taxonomy VALUES(1194,510689,'Saprolegnia','sp. WM_3');
INSERT INTO taxonomy VALUES(1195,512091,'Pythium','sp. Arg 3.5');
INSERT INTO taxonomy VALUES(1196,512330,'Pythium','sp. Turkey 1');
INSERT INTO taxonomy VALUES(1197,515321,'Protoachlya','sp. Argentina 3.1');
INSERT INTO taxonomy VALUES(1198,515322,'Thraustotheca','sp. Argentina 3.8');
INSERT INTO taxonomy VALUES(1199,516998,'Phytophthora','sp. KACC 40914');
INSERT INTO taxonomy VALUES(1200,518826,'Phytophthora','sp. 1 FFL-2008');
INSERT INTO taxonomy VALUES(1201,518827,'Phytophthora','sp. 2 FFL-2008');
INSERT INTO taxonomy VALUES(1202,518828,'Phytophthora','sp. 4 FFL-2008');
INSERT INTO taxonomy VALUES(1203,519076,'Phytophthora','sp. VHS16115');
INSERT INTO taxonomy VALUES(1204,519079,'Phytophthora','sp. VHS17779');
INSERT INTO taxonomy VALUES(1205,519080,'Phytophthora','sp. VHS5185');
INSERT INTO taxonomy VALUES(1206,524365,'Phytophthora','sp. BF1');
INSERT INTO taxonomy VALUES(1207,524366,'Phytophthora','sp. BF3');
INSERT INTO taxonomy VALUES(1208,524367,'Phytophthora','sp. BF36');
INSERT INTO taxonomy VALUES(1209,524368,'Phytophthora','sp. BF4');
INSERT INTO taxonomy VALUES(1210,524369,'Phytophthora','sp. BFA');
INSERT INTO taxonomy VALUES(1211,524370,'Phytophthora','sp. BFK');
INSERT INTO taxonomy VALUES(1212,524371,'Phytophthora','sp. BFR');
INSERT INTO taxonomy VALUES(1213,524372,'Phytophthora','sp. BLW71');
INSERT INTO taxonomy VALUES(1214,524373,'Phytophthora','sp. MC1A');
INSERT INTO taxonomy VALUES(1215,524374,'Phytophthora','sp. MC32');
INSERT INTO taxonomy VALUES(1216,524375,'Phytophthora','sp. MC5');
INSERT INTO taxonomy VALUES(1217,524376,'Phytophthora','sp. MC53');
INSERT INTO taxonomy VALUES(1218,524377,'Phytophthora','sp. MCH');
INSERT INTO taxonomy VALUES(1219,524378,'Phytophthora','sp. MCO');
INSERT INTO taxonomy VALUES(1220,524379,'Phytophthora','sp. TF16');
INSERT INTO taxonomy VALUES(1221,528135,'Pythium','sp. PV So7');
INSERT INTO taxonomy VALUES(1222,529119,'Globisporangium','cryptoirregulare');
INSERT INTO taxonomy VALUES(1223,538568,'Phytophthora','pinifolia');
INSERT INTO taxonomy VALUES(1224,540036,'Phytophthora','parvispora');
INSERT INTO taxonomy VALUES(1225,540037,'Phytophthora','sp. CH-2008b');
INSERT INTO taxonomy VALUES(1226,540038,'Phytophthora','sp. CH-2008c');
INSERT INTO taxonomy VALUES(1227,540768,'Pythium','sp. PV Wi 22h');
INSERT INTO taxonomy VALUES(1228,540769,'Pythium','sp. PV Wi 36e');
INSERT INTO taxonomy VALUES(1229,542652,'Pythium','sp. BP-2008a');
INSERT INTO taxonomy VALUES(1230,542653,'Pythium','sp. BP-2008b');
INSERT INTO taxonomy VALUES(1231,542832,'Peronospora','effusa');
INSERT INTO taxonomy VALUES(1232,544548,'Phytophthora','taxon Oaksoil');
INSERT INTO taxonomy VALUES(1233,544870,'Peronospora','sp. KUS-F23241');
INSERT INTO taxonomy VALUES(1234,544909,'Phytophthora','parsiana');
INSERT INTO taxonomy VALUES(1235,546104,'Phytopythium','mercuriale');
INSERT INTO taxonomy VALUES(1236,552432,'Phytophthora','sp. 59');
INSERT INTO taxonomy VALUES(1237,552433,'Phytophthora','sp. 63');
INSERT INTO taxonomy VALUES(1238,552434,'Phytophthora','sp. 64');
INSERT INTO taxonomy VALUES(1239,552435,'Phytophthora','sp. 65');
INSERT INTO taxonomy VALUES(1240,552436,'Pythium','sp. 66');
INSERT INTO taxonomy VALUES(1241,553974,'Pythium','sp. stipitatum (F-1516)');
INSERT INTO taxonomy VALUES(1242,554913,'Phytophthora','taxon raspberry');
INSERT INTO taxonomy VALUES(1243,554914,'Pythium','sp. WD35B');
INSERT INTO taxonomy VALUES(1244,555429,'Phytophthora','sansomeana');
INSERT INTO taxonomy VALUES(1245,558704,'Achlya','primoachlya');
INSERT INTO taxonomy VALUES(1246,559848,'Pythium','sp. F389');
INSERT INTO taxonomy VALUES(1247,562958,'Plasmopara','siegesbeckiae');
INSERT INTO taxonomy VALUES(1248,562961,'Plasmopara','sp. KUS-F 23331');
INSERT INTO taxonomy VALUES(1249,562962,'Plasmopara','sp. KUS-F 23332');
INSERT INTO taxonomy VALUES(1250,562963,'Plasmopara','sp. KUS-F 23333');
INSERT INTO taxonomy VALUES(1251,562964,'Plasmopara','sp. KUS-F 23334');
INSERT INTO taxonomy VALUES(1252,562965,'Plasmopara','sp. KUS-F 23336');
INSERT INTO taxonomy VALUES(1253,562966,'Plasmopara','sp. KUS-F 23337');
INSERT INTO taxonomy VALUES(1254,565057,'Phytophthora','gemini');
INSERT INTO taxonomy VALUES(1255,565287,'Phytophthora','irrigata');
INSERT INTO taxonomy VALUES(1256,565288,'Phytophthora','hydropathica');
INSERT INTO taxonomy VALUES(1257,569193,'Peronospora','sp. FLDM-1');
INSERT INTO taxonomy VALUES(1258,572053,'Pythium','sp. OPU797');
INSERT INTO taxonomy VALUES(1259,572054,'Pythium','sp. UZ156');
INSERT INTO taxonomy VALUES(1260,572055,'Pythium','sp. UZ164');
INSERT INTO taxonomy VALUES(1261,572056,'Pythium','sp. UZ182');
INSERT INTO taxonomy VALUES(1262,572057,'Pythium','sp. UZ190');
INSERT INTO taxonomy VALUES(1263,572058,'Pythium','sp. UZ213');
INSERT INTO taxonomy VALUES(1264,572059,'Pythium','sp. UZ230');
INSERT INTO taxonomy VALUES(1265,572060,'Pythium','sp. UZ248');
INSERT INTO taxonomy VALUES(1266,572061,'Pythium','sp. UZ249');
INSERT INTO taxonomy VALUES(1267,572062,'Pythium','sp. UZ252');
INSERT INTO taxonomy VALUES(1268,572063,'Pythium','sp. UZ253');
INSERT INTO taxonomy VALUES(1269,572064,'Pythium','sp. UZ260');
INSERT INTO taxonomy VALUES(1270,572065,'Pythium','sp. UZ263');
INSERT INTO taxonomy VALUES(1271,572066,'Pythium','sp. UZ275');
INSERT INTO taxonomy VALUES(1272,572067,'Pythium','sp. UZ277');
INSERT INTO taxonomy VALUES(1273,572068,'Pythium','sp. UZ284');
INSERT INTO taxonomy VALUES(1274,572069,'Pythium','sp. UZ285');
INSERT INTO taxonomy VALUES(1275,572070,'Pythium','sp. UZ287');
INSERT INTO taxonomy VALUES(1276,572071,'Pythium','sp. UZ290');
INSERT INTO taxonomy VALUES(1277,572072,'Pythium','sp. UZ304');
INSERT INTO taxonomy VALUES(1278,572073,'Pythium','sp. UZ318');
INSERT INTO taxonomy VALUES(1279,572074,'Pythium','sp. UZ379');
INSERT INTO taxonomy VALUES(1280,572076,'Pythium','sp. UZ392');
INSERT INTO taxonomy VALUES(1281,572077,'Pythium','sp. UZ400');
INSERT INTO taxonomy VALUES(1282,572078,'Pythium','sp. UZ416');
INSERT INTO taxonomy VALUES(1283,572079,'Pythium','sp. UZ419');
INSERT INTO taxonomy VALUES(1284,572080,'Pythium','sp. UZ594');
INSERT INTO taxonomy VALUES(1285,572081,'Pythium','sp. UZ612');
INSERT INTO taxonomy VALUES(1286,572082,'Pythium','sp. UZ636');
INSERT INTO taxonomy VALUES(1287,572083,'Pythium','sp. UZ655');
INSERT INTO taxonomy VALUES(1288,572084,'Pythium','sp. OPU1448');
INSERT INTO taxonomy VALUES(1289,572085,'Pythium','sp. OPU1449');
INSERT INTO taxonomy VALUES(1290,572086,'Pythium','sp. ZSF0011');
INSERT INTO taxonomy VALUES(1291,572087,'Pythium','sp. ZSF0030');
INSERT INTO taxonomy VALUES(1292,572088,'Pythium','sp. ZSF0056');
INSERT INTO taxonomy VALUES(1293,572089,'Pythium','sp. ZSF0069');
INSERT INTO taxonomy VALUES(1294,572090,'Pythium','sp. ZSF0093');
INSERT INTO taxonomy VALUES(1295,572137,'Wilsoniana','portulacae');
INSERT INTO taxonomy VALUES(1296,572139,'Pustula','tragopogonis');
INSERT INTO taxonomy VALUES(1297,572926,'Phytophthora','citricola I');
INSERT INTO taxonomy VALUES(1298,572927,'Phytophthora','citricola II');
INSERT INTO taxonomy VALUES(1299,572928,'Phytophthora','citricola III');
INSERT INTO taxonomy VALUES(1300,572929,'Phytophthora','citricola IV');
INSERT INTO taxonomy VALUES(1301,576717,'Pythium','sp. F-152.2');
INSERT INTO taxonomy VALUES(1302,577270,'Phytophthora','sp. BUX1');
INSERT INTO taxonomy VALUES(1303,577271,'Phytophthora','sp. BUX2');
INSERT INTO taxonomy VALUES(1304,577272,'Phytophthora','sp. R1');
INSERT INTO taxonomy VALUES(1305,577273,'Phytophthora','sp. R2');
INSERT INTO taxonomy VALUES(1306,581215,'Phytophthora','morindae');
INSERT INTO taxonomy VALUES(1307,584792,'Aphanomyces','sp. LIT7');
INSERT INTO taxonomy VALUES(1308,587446,'Peronospora','sp. 1217402');
INSERT INTO taxonomy VALUES(1309,596104,'Phytophthora','multivora');
INSERT INTO taxonomy VALUES(1310,596297,'Pythium','oopapillum');
INSERT INTO taxonomy VALUES(1311,598569,'Peronospora','swinglei');
INSERT INTO taxonomy VALUES(1312,601994,'Aphanomyces','iridis');
INSERT INTO taxonomy VALUES(1313,610363,'Pythium','echinogynum');
INSERT INTO taxonomy VALUES(1314,610364,'Globisporangium','stipitatum');
INSERT INTO taxonomy VALUES(1315,611796,'Phytophthora','sp. CCH-2009a');
INSERT INTO taxonomy VALUES(1316,611798,'Phytophthora','aquimorbida');
INSERT INTO taxonomy VALUES(1317,621210,'Leptolegnia','sp. VI04813');
INSERT INTO taxonomy VALUES(1318,621211,'Saprolegnia','cf. ferax VI02389');
INSERT INTO taxonomy VALUES(1319,621212,'Saprolegnia','cf. ferax VI04808');
INSERT INTO taxonomy VALUES(1320,621213,'Saprolegnia','sp. VI04818');
INSERT INTO taxonomy VALUES(1321,622442,'Peronospora','sp. HOH HUH961');
INSERT INTO taxonomy VALUES(1322,622444,'Peronospora','belbahrii');
INSERT INTO taxonomy VALUES(1323,631356,'Phytophthora','sp. P3132');
INSERT INTO taxonomy VALUES(1324,631357,'Phytophthora','sp. 11652');
INSERT INTO taxonomy VALUES(1325,631358,'Phytophthora','asparagi');
INSERT INTO taxonomy VALUES(1326,631361,'Phytophthora','austrocedri');
INSERT INTO taxonomy VALUES(1327,631433,'Phytophthora','cf. botryosa');
INSERT INTO taxonomy VALUES(1328,631436,'Pythium','sp. P11577');
INSERT INTO taxonomy VALUES(1329,631437,'Pythium','sp. P11838');
INSERT INTO taxonomy VALUES(1330,631439,'Pythium','sp. P8243');
INSERT INTO taxonomy VALUES(1331,631440,'Saprolegnia','sp. P8203');
INSERT INTO taxonomy VALUES(1332,632166,'Saprolegnia','sp. HL0602');
INSERT INTO taxonomy VALUES(1333,635125,'Saprolegnia','sp. DC3U2_2007');
INSERT INTO taxonomy VALUES(1334,635126,'Saprolegnia','sp. DC3U9_2007');
INSERT INTO taxonomy VALUES(1335,637496,'Aphanomyces','sp. APH1');
INSERT INTO taxonomy VALUES(1336,637497,'Aphanomyces','sp. APH2');
INSERT INTO taxonomy VALUES(1337,637498,'Aphanomyces','sp. APH3');
INSERT INTO taxonomy VALUES(1338,637499,'Saprolegnia','sp. SAP1');
INSERT INTO taxonomy VALUES(1339,637500,'Saprolegnia','sp. SAP2');
INSERT INTO taxonomy VALUES(1340,637501,'Saprolegnia','sp. SAP3');
INSERT INTO taxonomy VALUES(1341,637502,'Saprolegnia','sp. SAP4');
INSERT INTO taxonomy VALUES(1342,637538,'Phytophthora','sp. Banksia/Lancelin/AUS');
INSERT INTO taxonomy VALUES(1343,638629,'Phytophthora','sp. MYA-4555');
INSERT INTO taxonomy VALUES(1344,638644,'Phytophthora','sp. MYA-4554');
INSERT INTO taxonomy VALUES(1345,638948,'Phytophthora','chrysanthemi');
INSERT INTO taxonomy VALUES(1346,639000,'Phytophthora','plurivora');
INSERT INTO taxonomy VALUES(1347,640322,'Pythium','sp. PV Wi 36c');
INSERT INTO taxonomy VALUES(1348,642600,'Pustula','spinulosa');
INSERT INTO taxonomy VALUES(1349,642601,'Wilsoniana','bliti');
INSERT INTO taxonomy VALUES(1350,642602,'Wilsoniana','platensis');
INSERT INTO taxonomy VALUES(1351,642603,'Wilsoniana','achyranthis');
INSERT INTO taxonomy VALUES(1352,643143,'Elongisporangium','senticosum');
INSERT INTO taxonomy VALUES(1353,643144,'Globisporangium','takayamanum');
INSERT INTO taxonomy VALUES(1354,643145,'Pythium','sp. group G');
INSERT INTO taxonomy VALUES(1355,643146,'Pythium','sp. I-276');
INSERT INTO taxonomy VALUES(1356,643147,'Pythium','sp. I-806');
INSERT INTO taxonomy VALUES(1357,643148,'Pythium','sp. I-840');
INSERT INTO taxonomy VALUES(1358,643149,'Pythium','sp. I-845');
INSERT INTO taxonomy VALUES(1359,643150,'Pythium','sp. I-846');
INSERT INTO taxonomy VALUES(1360,643151,'Pythium','sp. I-848');
INSERT INTO taxonomy VALUES(1361,643152,'Pythium','sp. I-867');
INSERT INTO taxonomy VALUES(1362,643153,'Pythium','sp. I-879');
INSERT INTO taxonomy VALUES(1363,643154,'Pythium','sp. I-881');
INSERT INTO taxonomy VALUES(1364,643155,'Pythium','sp. I-886');
INSERT INTO taxonomy VALUES(1365,643156,'Pythium','sp. I-918');
INSERT INTO taxonomy VALUES(1366,643157,'Pythium','sp. I-978');
INSERT INTO taxonomy VALUES(1367,643158,'Pythium','sp. I-987');
INSERT INTO taxonomy VALUES(1368,643578,'Albugo','capparidis');
INSERT INTO taxonomy VALUES(1369,645453,'Pythium','sp. PPRI8403');
INSERT INTO taxonomy VALUES(1370,645454,'Pythium','sp. PPRI8411');
INSERT INTO taxonomy VALUES(1371,645455,'Pythium','sp. PPRI8424');
INSERT INTO taxonomy VALUES(1372,645456,'Pythium','sp. PPRI8598');
INSERT INTO taxonomy VALUES(1373,645457,'Pythium','sp. PPRI8614');
INSERT INTO taxonomy VALUES(1374,645458,'Pythium','sp. PPRI8622');
INSERT INTO taxonomy VALUES(1375,645459,'Pythium','sp. WJB-1');
INSERT INTO taxonomy VALUES(1376,645460,'Pythium','sp. WJB-2');
INSERT INTO taxonomy VALUES(1377,645461,'Pythium','sp. WJB-3');
INSERT INTO taxonomy VALUES(1378,650119,'Halioticida','noduliformans');
INSERT INTO taxonomy VALUES(1379,653773,'Saprolegnia','sp. F-1561.8');
INSERT INTO taxonomy VALUES(1380,653948,'Albugo','laibachii');
INSERT INTO taxonomy VALUES(1381,657220,'Globisporangium','emineosum');
INSERT INTO taxonomy VALUES(1382,657222,'Globisporangium','camurandrum');
INSERT INTO taxonomy VALUES(1383,658183,'Peronospora','elsholtziae');
INSERT INTO taxonomy VALUES(1384,658425,'Phytophthora','pini');
INSERT INTO taxonomy VALUES(1385,658426,'Phytophthora','mengei');
INSERT INTO taxonomy VALUES(1386,658597,'Peronospora','sp. YJC-2009a');
INSERT INTO taxonomy VALUES(1387,658966,'Pythium','guangxiense');
INSERT INTO taxonomy VALUES(1388,668775,'Peronospora','sp. DK02');
INSERT INTO taxonomy VALUES(1389,668776,'Peronospora','sp. DK03');
INSERT INTO taxonomy VALUES(1390,668777,'Peronospora','sp. DK05');
INSERT INTO taxonomy VALUES(1391,668778,'Peronospora','sp. DK06');
INSERT INTO taxonomy VALUES(1392,668779,'Peronospora','sp. DK07');
INSERT INTO taxonomy VALUES(1393,668780,'Peronospora','sp. DK08');
INSERT INTO taxonomy VALUES(1394,668781,'Peronospora','sp. DK10');
INSERT INTO taxonomy VALUES(1395,668782,'Peronospora','sp. DK11');
INSERT INTO taxonomy VALUES(1396,668783,'Peronospora','sp. DK12');
INSERT INTO taxonomy VALUES(1397,668784,'Peronospora','sp. DK13');
INSERT INTO taxonomy VALUES(1398,668785,'Peronospora','sp. DK14');
INSERT INTO taxonomy VALUES(1399,668786,'Peronospora','sp. DK16');
INSERT INTO taxonomy VALUES(1400,668787,'Peronospora','sp. DK18');
INSERT INTO taxonomy VALUES(1401,668788,'Peronospora','sp. DK19');
INSERT INTO taxonomy VALUES(1402,668789,'Peronospora','sp. DK20');
INSERT INTO taxonomy VALUES(1403,668790,'Peronospora','sp. DK21');
INSERT INTO taxonomy VALUES(1404,668791,'Peronospora','sp. DK22');
INSERT INTO taxonomy VALUES(1405,668792,'Peronospora','sp. DK24');
INSERT INTO taxonomy VALUES(1406,668793,'Peronospora','sp. DK25');
INSERT INTO taxonomy VALUES(1407,668794,'Peronospora','sp. EC05');
INSERT INTO taxonomy VALUES(1408,668795,'Peronospora','sp. EC06');
INSERT INTO taxonomy VALUES(1409,668796,'Peronospora','sp. EC07');
INSERT INTO taxonomy VALUES(1410,668797,'Peronospora','sp. EC09');
INSERT INTO taxonomy VALUES(1411,668798,'Peronospora','sp. EC10');
INSERT INTO taxonomy VALUES(1412,668799,'Peronospora','sp. PE01');
INSERT INTO taxonomy VALUES(1413,668800,'Peronospora','sp. PE03');
INSERT INTO taxonomy VALUES(1414,668801,'Peronospora','sp. PE05');
INSERT INTO taxonomy VALUES(1415,669489,'Phytophthora','frigida');
INSERT INTO taxonomy VALUES(1416,674463,'Phytophthora','sp. unk1');
INSERT INTO taxonomy VALUES(1417,674464,'Phytophthora','sp. unk2');
INSERT INTO taxonomy VALUES(1418,674465,'Phytophthora','sp. unk3');
INSERT INTO taxonomy VALUES(1419,680264,'Peronospora','trigonellae');
INSERT INTO taxonomy VALUES(1420,682055,'Albugo','mauginii');
INSERT INTO taxonomy VALUES(1421,682330,'Pythium','sp. B-23');
INSERT INTO taxonomy VALUES(1422,682832,'Pythium','sp. F-1540.4');
INSERT INTO taxonomy VALUES(1423,682833,'Pythium','sp. F-1550.16');
INSERT INTO taxonomy VALUES(1424,682834,'Pythium','sp. F-1550.7');
INSERT INTO taxonomy VALUES(1425,683806,'Achlya','sp. 02RCT');
INSERT INTO taxonomy VALUES(1426,683807,'Achlya','sp. CORA1');
INSERT INTO taxonomy VALUES(1427,683808,'Achlya','sp. DG');
INSERT INTO taxonomy VALUES(1428,683809,'Achlya','sp. EM23');
INSERT INTO taxonomy VALUES(1429,683810,'Achlya','sp. EM25');
INSERT INTO taxonomy VALUES(1430,683811,'Achlya','sp. EM26B');
INSERT INTO taxonomy VALUES(1431,683812,'Achlya','sp. EM31B');
INSERT INTO taxonomy VALUES(1432,683813,'Achlya','sp. EM31E');
INSERT INTO taxonomy VALUES(1433,683814,'Achlya','sp. EM32C');
INSERT INTO taxonomy VALUES(1434,683815,'Achlya','sp. EM47A');
INSERT INTO taxonomy VALUES(1435,683816,'Achlya','sp. EM7');
INSERT INTO taxonomy VALUES(1436,683817,'Achlya','sp. MOT2');
INSERT INTO taxonomy VALUES(1437,683818,'Achlya','sp. MOTAD3');
INSERT INTO taxonomy VALUES(1438,683819,'Achlya','sp. O3EG1');
INSERT INTO taxonomy VALUES(1439,683820,'Achlya','sp. PCRTB2');
INSERT INTO taxonomy VALUES(1440,683821,'Achlya','sp. SCAAD');
INSERT INTO taxonomy VALUES(1441,683822,'Aphanomyces','sp. NVA');
INSERT INTO taxonomy VALUES(1442,683824,'Leptolegnia','sp. EM32A');
INSERT INTO taxonomy VALUES(1443,683825,'Leptolegnia','sp. NT');
INSERT INTO taxonomy VALUES(1444,683826,'Leptolegnia','sp. SP');
INSERT INTO taxonomy VALUES(1445,683827,'Pythium','sp. OAK');
INSERT INTO taxonomy VALUES(1446,683828,'Saprolegnia','sp. AESB');
INSERT INTO taxonomy VALUES(1447,683829,'Saprolegnia','sp. SPE');
INSERT INTO taxonomy VALUES(1448,684893,'Phytophthora','sp. TARI 27147');
INSERT INTO taxonomy VALUES(1449,684894,'Phytophthora','sp. TARI 28041');
INSERT INTO taxonomy VALUES(1450,692225,'Aphanomyces','sp. NJM 0703');
INSERT INTO taxonomy VALUES(1451,692226,'Aphanomyces','sp. NJM 0704');
INSERT INTO taxonomy VALUES(1452,692227,'Aphanomyces','sp. NJM 0714');
INSERT INTO taxonomy VALUES(1453,692228,'Aphanomyces','sp. NJM 0705');
INSERT INTO taxonomy VALUES(1454,692229,'Aphanomyces','sp. NJM 0706');
INSERT INTO taxonomy VALUES(1455,692230,'Aphanomyces','sp. NJM 0707');
INSERT INTO taxonomy VALUES(1456,692231,'Aphanomyces','sp. NJM 0908');
INSERT INTO taxonomy VALUES(1457,692232,'Aphanomyces','sp. NJM 0909');
INSERT INTO taxonomy VALUES(1458,692233,'Aphanomyces','sp. NJM 0910');
INSERT INTO taxonomy VALUES(1459,692234,'Aphanomyces','sp. NJM 0912');
INSERT INTO taxonomy VALUES(1460,692235,'Aphanomyces','sp. NJM 0914');
INSERT INTO taxonomy VALUES(1461,692236,'Aphanomyces','sp. NJM 0915');
INSERT INTO taxonomy VALUES(1462,692237,'Aphanomyces','sp. NJM 0916');
INSERT INTO taxonomy VALUES(1463,692238,'Aphanomyces','sp. NJM 0917');
INSERT INTO taxonomy VALUES(1464,692239,'Aphanomyces','sp. NJM 0911');
INSERT INTO taxonomy VALUES(1465,692240,'Aphanomyces','sp. NJM 0913');
INSERT INTO taxonomy VALUES(1466,692241,'Aphanomyces','sp. NJM 0918');
INSERT INTO taxonomy VALUES(1467,692242,'Aphanomyces','sp. NJM 0919');
INSERT INTO taxonomy VALUES(1468,692243,'Aphanomyces','sp. NJM 0903');
INSERT INTO taxonomy VALUES(1469,692244,'Aphanomyces','sp. NJM 0904');
INSERT INTO taxonomy VALUES(1470,692245,'Aphanomyces','sp. NJM 0905');
INSERT INTO taxonomy VALUES(1471,692246,'Aphanomyces','sp. NJM 0906');
INSERT INTO taxonomy VALUES(1472,692247,'Aphanomyces','sp. NJM 0907');
INSERT INTO taxonomy VALUES(1473,692272,'Aphanomyces','sp. NJM 0708');
INSERT INTO taxonomy VALUES(1474,697875,'Hyaloperonospora','drabae');
INSERT INTO taxonomy VALUES(1475,697890,'Hyaloperonospora','norvegica');
INSERT INTO taxonomy VALUES(1476,702469,'Pythium','sp. BP-2009c');
INSERT INTO taxonomy VALUES(1477,706571,'Pythium','sp. SHT-2010a');
INSERT INTO taxonomy VALUES(1478,707993,'Halophytophthora','exoprolifera');
INSERT INTO taxonomy VALUES(1479,707994,'Phytopythium','kandeliae');
INSERT INTO taxonomy VALUES(1480,707995,'Phytophthora','alticola');
INSERT INTO taxonomy VALUES(1481,707996,'Phytophthora','himalayensis');
INSERT INTO taxonomy VALUES(1482,707997,'Phytophthora','sp. P10369');
INSERT INTO taxonomy VALUES(1483,707998,'Phytophthora','sp. P10800');
INSERT INTO taxonomy VALUES(1484,707999,'Phytophthora','sp. P11656');
INSERT INTO taxonomy VALUES(1485,708000,'Phytophthora','sp. P15002');
INSERT INTO taxonomy VALUES(1486,708002,'Phytophthora','sp. P1714');
INSERT INTO taxonomy VALUES(1487,708003,'Phytophthora','sp. P21283');
INSERT INTO taxonomy VALUES(1488,708004,'Phytophthora','sp. P3587');
INSERT INTO taxonomy VALUES(1489,708005,'Phytophthora','sp. P3602');
INSERT INTO taxonomy VALUES(1490,708006,'Phytophthora','sp. P3849');
INSERT INTO taxonomy VALUES(1491,708007,'Phytophthora','sp. glovera');
INSERT INTO taxonomy VALUES(1492,708008,'Phytophthora','sp. ''kelmania''');
INSERT INTO taxonomy VALUES(1493,708009,'Phytophthora','sp. ''lagoariana''');
INSERT INTO taxonomy VALUES(1494,708012,'Pythium','sp. P15703');
INSERT INTO taxonomy VALUES(1495,708013,'Pythium','sp. P16024');
INSERT INTO taxonomy VALUES(1496,708014,'Pythium','sp. P16028');
INSERT INTO taxonomy VALUES(1497,708015,'Pythium','sp. P19300/1/3');
INSERT INTO taxonomy VALUES(1498,708016,'Pythium','sp. P19305');
INSERT INTO taxonomy VALUES(1499,708017,'Pythium','sp. P19400');
INSERT INTO taxonomy VALUES(1500,708018,'Pythium','sp. P19407');
INSERT INTO taxonomy VALUES(1501,708019,'Pythium','sp. P19410');
INSERT INTO taxonomy VALUES(1502,708020,'Pythium','sp. P19421');
INSERT INTO taxonomy VALUES(1503,708021,'Pythium','sp. P19430');
INSERT INTO taxonomy VALUES(1504,708022,'Pythium','sp. P19432');
INSERT INTO taxonomy VALUES(1505,708023,'Pythium','sp. P19448');
INSERT INTO taxonomy VALUES(1506,708024,'Pythium','sp. P19450');
INSERT INTO taxonomy VALUES(1507,708025,'Pythium','sp. P19465');
INSERT INTO taxonomy VALUES(1508,708026,'Pythium','sp. P19467');
INSERT INTO taxonomy VALUES(1509,708027,'Pythium','sp. P19474');
INSERT INTO taxonomy VALUES(1510,708028,'Pythium','sp. P19477');
INSERT INTO taxonomy VALUES(1511,708029,'Pythium','sp. P19478');
INSERT INTO taxonomy VALUES(1512,708030,'Pythium','sp. P19480');
INSERT INTO taxonomy VALUES(1513,708031,'Pythium','sp. P19498');
INSERT INTO taxonomy VALUES(1514,708032,'Pythium','sp. P19501');
INSERT INTO taxonomy VALUES(1515,708033,'Pythium','sp. P19507');
INSERT INTO taxonomy VALUES(1516,708034,'Pythium','sp. P19510');
INSERT INTO taxonomy VALUES(1517,708035,'Pythium','sp. P3862');
INSERT INTO taxonomy VALUES(1518,708036,'Pythium','sp. P8201');
INSERT INTO taxonomy VALUES(1519,708037,'Pythium','sp. P8207');
INSERT INTO taxonomy VALUES(1520,708038,'Pythium','sp. P8209');
INSERT INTO taxonomy VALUES(1521,708039,'Pythium','sp. P8212');
INSERT INTO taxonomy VALUES(1522,708040,'Saprolegnia','sp. P8205');
INSERT INTO taxonomy VALUES(1523,713106,'Pythium','sp. OPU809');
INSERT INTO taxonomy VALUES(1524,714891,'Hyaloperonospora','lobulariae');
INSERT INTO taxonomy VALUES(1525,714893,'Hyaloperonospora','rorippae-islandicae');
INSERT INTO taxonomy VALUES(1526,714894,'Hyaloperonospora','sisymbrii-sophiae');
INSERT INTO taxonomy VALUES(1527,743708,'Halophytophthora','porrigovesica');
INSERT INTO taxonomy VALUES(1528,747250,'Phytophthora','sp. P1212');
INSERT INTO taxonomy VALUES(1529,747252,'Phytophthora','sp. P16855');
INSERT INTO taxonomy VALUES(1530,747254,'Phytophthora','sp. P16858');
INSERT INTO taxonomy VALUES(1531,747255,'Phytophthora','sp. P16859');
INSERT INTO taxonomy VALUES(1532,747256,'Phytophthora','sp. P3600');
INSERT INTO taxonomy VALUES(1533,747257,'Pythium','sp. P8204');
INSERT INTO taxonomy VALUES(1534,749328,'Peronospora','verbenae');
INSERT INTO taxonomy VALUES(1535,749329,'Hyaloperonospora','sp. KUS-F24009');
INSERT INTO taxonomy VALUES(1536,756885,'Pythium','sp. P16681');
INSERT INTO taxonomy VALUES(1537,756886,'Pythium','sp. P16683');
INSERT INTO taxonomy VALUES(1538,758748,'Salisapilia','elongata');
INSERT INTO taxonomy VALUES(1539,758750,'Salisapilia','mycoparasitica');
INSERT INTO taxonomy VALUES(1540,758751,'Halophytophthora','polymorphica');
INSERT INTO taxonomy VALUES(1541,758752,'Halophytophthora','cf. polymorphica');
INSERT INTO taxonomy VALUES(1542,758753,'Halophytophthora','cf. batemanensis');
INSERT INTO taxonomy VALUES(1543,758754,'Salisapilia','epistomia');
INSERT INTO taxonomy VALUES(1544,758755,'Salisapilia','bahamensis');
INSERT INTO taxonomy VALUES(1545,758758,'Halophytophthora','cf. exoprolifera');
INSERT INTO taxonomy VALUES(1546,758760,'Halophytophthora','vesicula');
INSERT INTO taxonomy VALUES(1547,758762,'Halophytophthora','sp. P7166');
INSERT INTO taxonomy VALUES(1548,759900,'Phytophthora','sp. WA28-022404');
INSERT INTO taxonomy VALUES(1549,759903,'Halophytophthora','sp. WA26-091603');
INSERT INTO taxonomy VALUES(1550,760138,'Halophytophthora','sp. P7666');
INSERT INTO taxonomy VALUES(1551,760139,'Halophytophthora','sp. P7667');
INSERT INTO taxonomy VALUES(1552,760140,'Halophytophthora','sp. P7892');
INSERT INTO taxonomy VALUES(1553,760141,'Halophytophthora','sp. P7893');
INSERT INTO taxonomy VALUES(1554,763862,'Aphanomyces','trifolii');
INSERT INTO taxonomy VALUES(1555,766754,'Phytophthora','sp. P16825');
INSERT INTO taxonomy VALUES(1556,767159,'Pythium','sp. F-147.10');
INSERT INTO taxonomy VALUES(1557,767160,'Pythium','sp. F-1541.8');
INSERT INTO taxonomy VALUES(1558,795340,'Phytopythium','sindhum');
INSERT INTO taxonomy VALUES(1559,858365,'Pythium','sp. F-1545.7');
INSERT INTO taxonomy VALUES(1560,858704,'Hyaloperonospora','praecox');
INSERT INTO taxonomy VALUES(1561,859640,'Phytophthora','sp. Y5');
INSERT INTO taxonomy VALUES(1562,864584,'Albugo','resedae');
INSERT INTO taxonomy VALUES(1563,864825,'Phytophthora','sp. P13803');
INSERT INTO taxonomy VALUES(1564,864826,'Phytophthora','sp. P16853');
INSERT INTO taxonomy VALUES(1565,864827,'Phytophthora','sp. P16911');
INSERT INTO taxonomy VALUES(1566,880410,'Phytophthora','taxon paludosa');
INSERT INTO taxonomy VALUES(1567,880411,'Phytophthora','gibbosa');
INSERT INTO taxonomy VALUES(1568,880412,'Phytophthora','gregata');
INSERT INTO taxonomy VALUES(1569,880414,'Phytophthora','thermophila');
INSERT INTO taxonomy VALUES(1570,884615,'Aphanomyces','sp. PWL-2010');
INSERT INTO taxonomy VALUES(1571,884617,'Lagenidium','sp. PWL-2010a');
INSERT INTO taxonomy VALUES(1572,884618,'Lagenidium','sp. PWL-2010b');
INSERT INTO taxonomy VALUES(1573,884619,'Lagenidium','deciduum');
INSERT INTO taxonomy VALUES(1574,884620,'Lagenidium','sp. PWL-2010d');
INSERT INTO taxonomy VALUES(1575,884621,'Lagenidium','sp. PWL-2010e');
INSERT INTO taxonomy VALUES(1576,884622,'Lagenidium','sp. PWL-2010f');
INSERT INTO taxonomy VALUES(1577,884623,'Lagenidium','sp. PWL-2010g');
INSERT INTO taxonomy VALUES(1578,884624,'Lagenidium','sp. PWL-2010h');
INSERT INTO taxonomy VALUES(1579,884625,'Lagenidium','sp. PWL-2010i');
INSERT INTO taxonomy VALUES(1580,885261,'Phytophthora','sp. TTB-2010');
INSERT INTO taxonomy VALUES(1581,886948,'Peronosclerospora','philippinensis');
INSERT INTO taxonomy VALUES(1582,886949,'Peronosclerospora','maydis');
INSERT INTO taxonomy VALUES(1583,887151,'Albugo','sp. SSP-2010');
INSERT INTO taxonomy VALUES(1584,888549,'Pythium','sp. FFM-2010');
INSERT INTO taxonomy VALUES(1585,889394,'Phytophthora','sp. 2_WS');
INSERT INTO taxonomy VALUES(1586,889395,'Phytophthora','sp. Hennops river');
INSERT INTO taxonomy VALUES(1587,904467,'Saprolegnia','sp. MF-2010');
INSERT INTO taxonomy VALUES(1588,905063,'Phytophthora','elongata');
INSERT INTO taxonomy VALUES(1589,905064,'Phytophthora','cf. elongata');
INSERT INTO taxonomy VALUES(1590,907250,'Phytophthora','sp. FFM-2010');
INSERT INTO taxonomy VALUES(1591,907715,'Phytophthora','sp. LMQO-2010');
INSERT INTO taxonomy VALUES(1592,907744,'Phytophthora','aff. infestans');
INSERT INTO taxonomy VALUES(1593,907745,'Phytophthora','aff. rosacearum');
INSERT INTO taxonomy VALUES(1594,907748,'Phytophthora','aff. primulae');
INSERT INTO taxonomy VALUES(1595,907943,'Phytophthora','sp. AL-2010a');
INSERT INTO taxonomy VALUES(1596,907945,'Phytophthora','sp. AL-2010b');
INSERT INTO taxonomy VALUES(1597,907947,'Phytopythium','vexans');
INSERT INTO taxonomy VALUES(1598,907948,'Pythium','sp. AL-2010');
INSERT INTO taxonomy VALUES(1599,908142,'Phytophthora','sp. AL-2010d');
INSERT INTO taxonomy VALUES(1600,908143,'Phytophthora','sp. AL-2010c');
INSERT INTO taxonomy VALUES(1601,908144,'Phytophthora','sp. AL-2010e');
INSERT INTO taxonomy VALUES(1602,909764,'Phytophthora','cf. rosacearum');
INSERT INTO taxonomy VALUES(1603,910611,'Phytophthora','sp. raspberry/TIB-2010');
INSERT INTO taxonomy VALUES(1604,911891,'Phytophthora','capensis');
INSERT INTO taxonomy VALUES(1605,911925,'Pythium','sp. F-147C');
INSERT INTO taxonomy VALUES(1606,911926,'Pythium','sp. F-1517.1');
INSERT INTO taxonomy VALUES(1607,911927,'Pythium','sp. F-1525.4');
INSERT INTO taxonomy VALUES(1608,911928,'Pythium','sp. F1630');
INSERT INTO taxonomy VALUES(1609,911929,'Pythium','sp. cernum/BP-2010');
INSERT INTO taxonomy VALUES(1610,911930,'Pythium','sp. longicarpum/BP-2010');
INSERT INTO taxonomy VALUES(1611,912656,'Phytophthora','sp. 2 FFL-2010');
INSERT INTO taxonomy VALUES(1612,913021,'Albugo','leimonios');
INSERT INTO taxonomy VALUES(1613,913022,'Albugo','hesleri');
INSERT INTO taxonomy VALUES(1614,913023,'Albugo','hohenheimia');
INSERT INTO taxonomy VALUES(1615,913185,'Pustula','centaurii');
INSERT INTO taxonomy VALUES(1616,913194,'Bremia','cirsii');
INSERT INTO taxonomy VALUES(1617,913195,'Bremia','lapsanae');
INSERT INTO taxonomy VALUES(1618,913196,'Bremia','tulasnei');
INSERT INTO taxonomy VALUES(1619,913197,'Bremia','taraxaci');
INSERT INTO taxonomy VALUES(1620,913854,'Bremia','sp. ex Arctium sp.');
INSERT INTO taxonomy VALUES(1621,913855,'Bremia','sp. ex Centaurea jacea');
INSERT INTO taxonomy VALUES(1622,913856,'Bremia','sp. ex Leonthodon hispidus');
INSERT INTO taxonomy VALUES(1623,913857,'Bremia','sp. ex Carlina acaulis');
INSERT INTO taxonomy VALUES(1624,913858,'Bremia','sp. ex Hieracium murorum');
INSERT INTO taxonomy VALUES(1625,913859,'Bremia','sp. ex Helichrysum sp.');
INSERT INTO taxonomy VALUES(1626,913862,'Bremia','sp. ex Cirsium acaule');
INSERT INTO taxonomy VALUES(1627,913886,'Albugo','leimonios s.l.');
INSERT INTO taxonomy VALUES(1628,914078,'Albugo','sp. 28A');
INSERT INTO taxonomy VALUES(1629,914079,'Albugo','sp. 22A');
INSERT INTO taxonomy VALUES(1630,914080,'Albugo','sp. 34A');
INSERT INTO taxonomy VALUES(1631,914081,'Albugo','sp. 14A');
INSERT INTO taxonomy VALUES(1632,914083,'Pustula','sp. CU13');
INSERT INTO taxonomy VALUES(1633,914084,'Pustula','sp. CU24');
INSERT INTO taxonomy VALUES(1634,914085,'Pustula','sp. A76');
INSERT INTO taxonomy VALUES(1635,914086,'Pustula','sp. A72');
INSERT INTO taxonomy VALUES(1636,914087,'Pustula','sp. A19');
INSERT INTO taxonomy VALUES(1637,914088,'Pustula','sp. D158');
INSERT INTO taxonomy VALUES(1638,914089,'Pustula','sp. A69');
INSERT INTO taxonomy VALUES(1639,914090,'Pustula','sp. A91');
INSERT INTO taxonomy VALUES(1640,914091,'Pustula','sp. D178');
INSERT INTO taxonomy VALUES(1641,914092,'Pustula','sp. CU4');
INSERT INTO taxonomy VALUES(1642,914093,'Pustula','sp. HOH-HUH 880a');
INSERT INTO taxonomy VALUES(1643,914094,'Pustula','sp. HOH-HUH 880b');
INSERT INTO taxonomy VALUES(1644,914095,'Pustula','sp. HOH-HUH 936');
INSERT INTO taxonomy VALUES(1645,914096,'Pustula','sp. D179');
INSERT INTO taxonomy VALUES(1646,914097,'Pustula','sp. A71');
INSERT INTO taxonomy VALUES(1647,914098,'Pustula','sp. A73');
INSERT INTO taxonomy VALUES(1648,914099,'Pustula','sp. D150');
INSERT INTO taxonomy VALUES(1649,914100,'Pustula','sp. D147');
INSERT INTO taxonomy VALUES(1650,914101,'Pustula','sp. A59');
INSERT INTO taxonomy VALUES(1651,914102,'Pustula','sp. D153');
INSERT INTO taxonomy VALUES(1652,914103,'Pustula','sp. D181');
INSERT INTO taxonomy VALUES(1653,914104,'Pustula','sp. D149');
INSERT INTO taxonomy VALUES(1654,914105,'Pustula','sp. A75');
INSERT INTO taxonomy VALUES(1655,914106,'Pustula','sp. D157');
INSERT INTO taxonomy VALUES(1656,914107,'Pustula','sp. A163b');
INSERT INTO taxonomy VALUES(1657,914108,'Pustula','sp. D177');
INSERT INTO taxonomy VALUES(1658,914109,'Pustula','sp. D155');
INSERT INTO taxonomy VALUES(1659,914110,'Pustula','sp. A60');
INSERT INTO taxonomy VALUES(1660,914111,'Pustula','sp. A50');
INSERT INTO taxonomy VALUES(1661,914112,'Pustula','sp. D146');
INSERT INTO taxonomy VALUES(1662,914113,'Pustula','sp. HOH-HUH 679');
INSERT INTO taxonomy VALUES(1663,914114,'Pustula','sp. A30-1');
INSERT INTO taxonomy VALUES(1664,914115,'Pustula','sp. D180');
INSERT INTO taxonomy VALUES(1665,914116,'Pustula','sp. A81');
INSERT INTO taxonomy VALUES(1666,926064,'Saprolegnia','sp. crucian carp/strain JL');
INSERT INTO taxonomy VALUES(1667,928215,'Phytophthora','himalsilva');
INSERT INTO taxonomy VALUES(1668,929501,'Saprolegnia','sp. VI03782');
INSERT INTO taxonomy VALUES(1669,929502,'Saprolegnia','sp. VI03788');
INSERT INTO taxonomy VALUES(1670,929503,'Saprolegnia','sp. VI03796');
INSERT INTO taxonomy VALUES(1671,929504,'Saprolegnia','sp. VI03812');
INSERT INTO taxonomy VALUES(1672,929565,'Phytophthora','constricta');
INSERT INTO taxonomy VALUES(1673,929574,'Phytophthora','arenaria');
INSERT INTO taxonomy VALUES(1674,934032,'Albugo','sp. YJC-2010a');
INSERT INTO taxonomy VALUES(1675,934033,'Albugo','rorippae');
INSERT INTO taxonomy VALUES(1676,935871,'Aphanomyces','salsuginosus');
INSERT INTO taxonomy VALUES(1677,942182,'Pythium','sp. CLZ223');
INSERT INTO taxonomy VALUES(1678,942183,'Pythium','sp. DBH114');
INSERT INTO taxonomy VALUES(1679,942735,'Aphanomyces','cf. repetans');
INSERT INTO taxonomy VALUES(1680,943233,'Lagenidium','sp. PWL-2011a');
INSERT INTO taxonomy VALUES(1681,944587,'Achlya','sparrowii');
INSERT INTO taxonomy VALUES(1682,944588,'Brevilegnia','gracilis');
INSERT INTO taxonomy VALUES(1683,944594,'Brevilegnia','unisperma');
INSERT INTO taxonomy VALUES(1684,944596,'Brevilegnia','variabilis');
INSERT INTO taxonomy VALUES(1685,944600,'Phytophthora','aff. botryosa');
INSERT INTO taxonomy VALUES(1686,944601,'Phytophthora','aff. sansomeana');
INSERT INTO taxonomy VALUES(1687,944602,'Phytophthora','batemanensis');
INSERT INTO taxonomy VALUES(1688,944609,'Phytophthora','tabaci');
INSERT INTO taxonomy VALUES(1689,944610,'Phytopythium','aff. vexans');
INSERT INTO taxonomy VALUES(1690,944611,'Pythium','afertile');
INSERT INTO taxonomy VALUES(1691,944616,'Pythiogeton','zeae');
INSERT INTO taxonomy VALUES(1692,944618,'Pythium','aff. diclinum');
INSERT INTO taxonomy VALUES(1693,944619,'Pythium','aff. dictyosporum');
INSERT INTO taxonomy VALUES(1694,944620,'Pythium','aff. dissotocum');
INSERT INTO taxonomy VALUES(1695,944621,'Pythium','aff. hydnosporum');
INSERT INTO taxonomy VALUES(1696,944622,'Pythium','aff. hypogynum');
INSERT INTO taxonomy VALUES(1697,944623,'Pythium','aff. periilum');
INSERT INTO taxonomy VALUES(1698,944624,'Globisporangium','aff. perplexum');
INSERT INTO taxonomy VALUES(1699,944625,'Pythium','aff. pleroticum');
INSERT INTO taxonomy VALUES(1700,944626,'Globisporangium','aff. polymastum');
INSERT INTO taxonomy VALUES(1701,944627,'Pythium','aff. torulosum');
INSERT INTO taxonomy VALUES(1702,944628,'Pythium','aff. volutum');
INSERT INTO taxonomy VALUES(1703,944629,'Pythium','cf. dictyosporum');
INSERT INTO taxonomy VALUES(1704,944634,'Pythium','kashmirense');
INSERT INTO taxonomy VALUES(1705,944635,'Globisporangium','lucens');
INSERT INTO taxonomy VALUES(1706,944636,'Pythium','lycopersicum');
INSERT INTO taxonomy VALUES(1707,944637,'Pythium','sukuiense');
INSERT INTO taxonomy VALUES(1708,944638,'Pythium','tardicrescens');
INSERT INTO taxonomy VALUES(1709,944640,'Saprolegnia','asterophora');
INSERT INTO taxonomy VALUES(1710,944641,'Saprolegnia','delica');
INSERT INTO taxonomy VALUES(1711,944642,'Saprolegnia','lapponica');
INSERT INTO taxonomy VALUES(1712,944643,'Thraustotheca','terrestris');
INSERT INTO taxonomy VALUES(1713,946204,'Pythium','sp. YYL-2011b');
INSERT INTO taxonomy VALUES(1714,946366,'Aphanomyces','sp. BOLD:AAO9952');
INSERT INTO taxonomy VALUES(1715,946367,'Leptolegnia','sp. BOLD:AAX5717');
INSERT INTO taxonomy VALUES(1716,946370,'Saprolegnia','sp. BOLD:AAO5998');
INSERT INTO taxonomy VALUES(1717,946373,'Phytopythium','oedochilum');
INSERT INTO taxonomy VALUES(1718,946374,'Phytopythium','sp. BOLD:AAO6860');
INSERT INTO taxonomy VALUES(1719,946375,'Pythium','sp. CAL-2011a');
INSERT INTO taxonomy VALUES(1720,946376,'Pythium','sp. groupF CAL-2011b');
INSERT INTO taxonomy VALUES(1721,946377,'Pythium','sp. CAL-2011c');
INSERT INTO taxonomy VALUES(1722,946379,'Achlya','rodrigueziana');
INSERT INTO taxonomy VALUES(1723,946380,'Globisporangium','aff. iwayamae');
INSERT INTO taxonomy VALUES(1724,947153,'Pythium','sp. CAL-2011e');
INSERT INTO taxonomy VALUES(1725,947341,'Pythium','sp. XGL324');
INSERT INTO taxonomy VALUES(1726,977741,'Phytophthora','litoralis');
INSERT INTO taxonomy VALUES(1727,977911,'Phytophthora','citricola E');
INSERT INTO taxonomy VALUES(1728,980185,'Phytophthora','sp. P1896');
INSERT INTO taxonomy VALUES(1729,980186,'Phytophthora','sp. P8222');
INSERT INTO taxonomy VALUES(1730,980187,'Phytophthora','sp. P8225');
INSERT INTO taxonomy VALUES(1731,980188,'Phytophthora','sp. P8226');
INSERT INTO taxonomy VALUES(1732,980189,'Phytophthora','sp. P8227');
INSERT INTO taxonomy VALUES(1733,980190,'Phytophthora','sp. P8228');
INSERT INTO taxonomy VALUES(1734,980191,'Phytophthora','sp. P8229');
INSERT INTO taxonomy VALUES(1735,980192,'Phytophthora','sp. P8233');
INSERT INTO taxonomy VALUES(1736,980194,'Halophytophthora','sp. P15740');
INSERT INTO taxonomy VALUES(1737,980195,'Halophytophthora','sp. P15746');
INSERT INTO taxonomy VALUES(1738,980196,'Halophytophthora','sp. P7846');
INSERT INTO taxonomy VALUES(1739,980197,'Salispina','spinosa');
INSERT INTO taxonomy VALUES(1740,980198,'Salispina','lobata');
INSERT INTO taxonomy VALUES(1741,980346,'Salisapilia','masteri');
INSERT INTO taxonomy VALUES(1742,980618,'Phytophthora','sp. P16987');
INSERT INTO taxonomy VALUES(1743,980619,'Phytophthora','sp. P16991');
INSERT INTO taxonomy VALUES(1744,980620,'Phytophthora','sp. P16992');
INSERT INTO taxonomy VALUES(1745,980621,'Phytophthora','sp. P16993');
INSERT INTO taxonomy VALUES(1746,980622,'Phytophthora','sp. P16994');
INSERT INTO taxonomy VALUES(1747,980623,'Phytophthora','sp. P16995');
INSERT INTO taxonomy VALUES(1748,980624,'Phytophthora','sp. P16996');
INSERT INTO taxonomy VALUES(1749,980625,'Phytophthora','sp. P16997');
INSERT INTO taxonomy VALUES(1750,980630,'Phytophthora','sp. P10918');
INSERT INTO taxonomy VALUES(1751,981404,'Phytophthora','sp. 1 EEO-2011');
INSERT INTO taxonomy VALUES(1752,981427,'Phytophthora','sp. 3 EEO-2011');
INSERT INTO taxonomy VALUES(1753,981428,'Phytophthora','sp. 2 EEO-2011');
INSERT INTO taxonomy VALUES(1754,983655,'Halophytophthora','sp. LT6430');
INSERT INTO taxonomy VALUES(1755,983656,'Halophytophthora','sp. LT6465');
INSERT INTO taxonomy VALUES(1756,983659,'Salisapilia','nakagirii');
INSERT INTO taxonomy VALUES(1757,983660,'Salisapilia','sapeloensis');
INSERT INTO taxonomy VALUES(1758,983661,'Salisapilia','tartarea');
INSERT INTO taxonomy VALUES(1759,983662,'Salisapilia','sp. LT6460');
INSERT INTO taxonomy VALUES(1760,983663,'Salisapilia','sp. LT6466');
INSERT INTO taxonomy VALUES(1761,983664,'Salisapilia','sp. LT6471');
INSERT INTO taxonomy VALUES(1762,983690,'Leptolegnia','CAL-2011b');
INSERT INTO taxonomy VALUES(1763,983692,'Phytophthora','sp. CAL-2011b');
INSERT INTO taxonomy VALUES(1764,983699,'Phytopythium','sp. CAL-2011b');
INSERT INTO taxonomy VALUES(1765,983702,'Pythium','sp. group F');
INSERT INTO taxonomy VALUES(1766,983703,'Pythium','sp. CAL-2011f');
INSERT INTO taxonomy VALUES(1767,983704,'Saprolegnia','sp. CAL-2011b');
INSERT INTO taxonomy VALUES(1768,984975,'Saprolegnia','sp. 197907');
INSERT INTO taxonomy VALUES(1769,993381,'Phytopythium','sp. HSR-2011');
INSERT INTO taxonomy VALUES(1770,1000572,'Pseudoperonospora','sp. 21226');
INSERT INTO taxonomy VALUES(1771,1000573,'Pseudoperonospora','sp. 22238');
INSERT INTO taxonomy VALUES(1772,1000574,'Pseudoperonospora','sp. 23231');
INSERT INTO taxonomy VALUES(1773,1000575,'Pseudoperonospora','sp. 24230');
INSERT INTO taxonomy VALUES(1774,1000576,'Pseudoperonospora','sp. D149');
INSERT INTO taxonomy VALUES(1775,1000577,'Pseudoperonospora','sp. D190');
INSERT INTO taxonomy VALUES(1776,1000578,'Pseudoperonospora','sp. D232');
INSERT INTO taxonomy VALUES(1777,1000579,'Pseudoperonospora','sp. D265');
INSERT INTO taxonomy VALUES(1778,1000580,'Pseudoperonospora','sp. NY425');
INSERT INTO taxonomy VALUES(1779,1000581,'Pseudoperonospora','sp. NY440');
INSERT INTO taxonomy VALUES(1780,1000582,'Pseudoperonospora','sp. NY461');
INSERT INTO taxonomy VALUES(1781,1000583,'Pseudoperonospora','sp. U196');
INSERT INTO taxonomy VALUES(1782,1000584,'Pseudoperonospora','sp. U201');
INSERT INTO taxonomy VALUES(1783,1002673,'Phytophthora','sp. SW08');
INSERT INTO taxonomy VALUES(1784,1002674,'Phytophthora','sp. SW09');
INSERT INTO taxonomy VALUES(1785,1002675,'Phytophthora','sp. SWKA');
INSERT INTO taxonomy VALUES(1786,1002676,'Phytophthora','sp. MZ09');
INSERT INTO taxonomy VALUES(1787,1002677,'Phytophthora','sp. KM09');
INSERT INTO taxonomy VALUES(1788,1002678,'Phytophthora','sp. YZ09');
INSERT INTO taxonomy VALUES(1789,1002679,'Phytophthora','sp. HK09');
INSERT INTO taxonomy VALUES(1790,1005363,'Pustula','helianthicola');
INSERT INTO taxonomy VALUES(1791,1009719,'Eraphthora','butleri');
INSERT INTO taxonomy VALUES(1792,1027885,'Globisporangium','aff. canariense OW1707');
INSERT INTO taxonomy VALUES(1793,1029593,'Pythium','sp. V1');
INSERT INTO taxonomy VALUES(1794,1029594,'Pythium','sp. V12');
INSERT INTO taxonomy VALUES(1795,1030115,'Phytophthora','sp. W6');
INSERT INTO taxonomy VALUES(1796,1030116,'Phytophthora','sp. V24');
INSERT INTO taxonomy VALUES(1797,1030117,'Phytophthora','sp. V53');
INSERT INTO taxonomy VALUES(1798,1034759,'Phytophthora','cf. arenaria');
INSERT INTO taxonomy VALUES(1799,1049189,'Pythium','sp. CBS 101876');
INSERT INTO taxonomy VALUES(1800,1049190,'Pythium','sp. CBS 113341');
INSERT INTO taxonomy VALUES(1801,1049191,'Pythium','sp. CBS 122647');
INSERT INTO taxonomy VALUES(1802,1049196,'Phytopythium','boreale');
INSERT INTO taxonomy VALUES(1803,1049197,'Aphanomyces','sp. CBS 583.85');
INSERT INTO taxonomy VALUES(1804,1049198,'Leptolegnia','sp. CBS 582.85');
INSERT INTO taxonomy VALUES(1805,1049225,'Phytophthora','aff. asparagi');
INSERT INTO taxonomy VALUES(1806,1049592,'Phytophthora','fluvialis');
INSERT INTO taxonomy VALUES(1807,1055752,'Phytophthora','sp. CAL-2011a');
INSERT INTO taxonomy VALUES(1808,1070317,'Pythium','sp. PB912 85');
INSERT INTO taxonomy VALUES(1809,1070318,'Pythium','sp. PB912 88');
INSERT INTO taxonomy VALUES(1810,1075218,'Pythium','sp. N053');
INSERT INTO taxonomy VALUES(1811,1077222,'Pythium','aff. monospermum');
INSERT INTO taxonomy VALUES(1812,1077223,'Pythium','aff. heterothallicum');
INSERT INTO taxonomy VALUES(1813,1077224,'Globisporangium','aff. macrosporum');
INSERT INTO taxonomy VALUES(1814,1077225,'Globisporangium','aff. canariense');
INSERT INTO taxonomy VALUES(1815,1081074,'Peronosclerospora','eriochloae');
INSERT INTO taxonomy VALUES(1816,1081075,'Peronosclerospora','cf. eriochloae');
INSERT INTO taxonomy VALUES(1817,1081076,'Peronosclerospora','miscanthi');
INSERT INTO taxonomy VALUES(1818,1081077,'Peronosclerospora','sp. ST-2011');
INSERT INTO taxonomy VALUES(1819,1087851,'Phytophthora','cf. capsici FM-2011');
INSERT INTO taxonomy VALUES(1820,1087852,'Phytophthora','cf. citricola 1 FM-2011');
INSERT INTO taxonomy VALUES(1821,1087853,'Phytophthora','cf. citrophthora 1a FM-2011');
INSERT INTO taxonomy VALUES(1822,1087854,'Phytophthora','cf. citrophthora 1b FM-2011');
INSERT INTO taxonomy VALUES(1823,1087855,'Phytophthora','cf. citrophthora 2 FM-2011');
INSERT INTO taxonomy VALUES(1824,1087856,'Phytophthora','cf. cryptogea 2 FM-2011');
INSERT INTO taxonomy VALUES(1825,1087857,'Phytophthora','cf. cryptogea FM-2011');
INSERT INTO taxonomy VALUES(1826,1087858,'Phytophthora','cf. heveae 2 FM-2011');
INSERT INTO taxonomy VALUES(1827,1087859,'Phytophthora','cf. heveae 1 FM-2011');
INSERT INTO taxonomy VALUES(1828,1087860,'Phytophthora','cf. meadii 1 FM-2011');
INSERT INTO taxonomy VALUES(1829,1087861,'Phytophthora','cf. porri 1 FM-2011');
INSERT INTO taxonomy VALUES(1830,1087862,'Phytophthora','cf. porri 2 FM-2011');
INSERT INTO taxonomy VALUES(1831,1087863,'Phytophthora','cf. citricola 2 FM-2011');
INSERT INTO taxonomy VALUES(1832,1088697,'Phytophthora','sp. FM-2011');
INSERT INTO taxonomy VALUES(1833,1089797,'Plasmopara','majewskii');
INSERT INTO taxonomy VALUES(1834,1099854,'Peronospora','dianthicola');
INSERT INTO taxonomy VALUES(1835,1100812,'Phytophthora','sp. SH-2011');
INSERT INTO taxonomy VALUES(1836,1104319,'Phytophthora','obscura');
INSERT INTO taxonomy VALUES(1837,1118861,'Pythium','sp. A16');
INSERT INTO taxonomy VALUES(1838,1118862,'Pythium','sp. B12');
INSERT INTO taxonomy VALUES(1839,1118863,'Pythium','sp. B35');
INSERT INTO taxonomy VALUES(1840,1118864,'Pythium','sp. B57');
INSERT INTO taxonomy VALUES(1841,1118865,'Pythium','sp. B65');
INSERT INTO taxonomy VALUES(1842,1118866,'Pythium','sp. B81');
INSERT INTO taxonomy VALUES(1843,1118867,'Pythium','sp. C24');
INSERT INTO taxonomy VALUES(1844,1118868,'Pythium','sp. C31');
INSERT INTO taxonomy VALUES(1845,1118869,'Pythium','sp. C34');
INSERT INTO taxonomy VALUES(1846,1118870,'Pythium','sp. C70');
INSERT INTO taxonomy VALUES(1847,1118871,'Pythium','sp. C73');
INSERT INTO taxonomy VALUES(1848,1118872,'Pythium','sp. C88');
INSERT INTO taxonomy VALUES(1849,1118873,'Pythium','sp. D02');
INSERT INTO taxonomy VALUES(1850,1118874,'Pythium','sp. D21');
INSERT INTO taxonomy VALUES(1851,1118875,'Pythium','sp. D37');
INSERT INTO taxonomy VALUES(1852,1118876,'Pythium','sp. D48');
INSERT INTO taxonomy VALUES(1853,1118877,'Pythium','sp. D85');
INSERT INTO taxonomy VALUES(1854,1118878,'Pythium','sp. D92');
INSERT INTO taxonomy VALUES(1855,1118879,'Pythium','sp. E06');
INSERT INTO taxonomy VALUES(1856,1118880,'Pythium','sp. E17');
INSERT INTO taxonomy VALUES(1857,1118881,'Pythium','sp. E20');
INSERT INTO taxonomy VALUES(1858,1118882,'Pythium','sp. E26');
INSERT INTO taxonomy VALUES(1859,1118883,'Pythium','sp. E41');
INSERT INTO taxonomy VALUES(1860,1118884,'Pythium','sp. E44');
INSERT INTO taxonomy VALUES(1861,1118885,'Pythium','sp. E47');
INSERT INTO taxonomy VALUES(1862,1118886,'Pythium','sp. E58');
INSERT INTO taxonomy VALUES(1863,1118887,'Pythium','sp. F32');
INSERT INTO taxonomy VALUES(1864,1118888,'Pythium','sp. F61');
INSERT INTO taxonomy VALUES(1865,1118889,'Pythium','sp. F65');
INSERT INTO taxonomy VALUES(1866,1125843,'Aphanomyces','sinensis');
INSERT INTO taxonomy VALUES(1867,1125983,'Phytophthora','sp. EL-8701');
INSERT INTO taxonomy VALUES(1868,1125996,'Phytophthora','sp. NBRC32176');
INSERT INTO taxonomy VALUES(1869,1125997,'Phytophthora','sp. MAFF 238158');
INSERT INTO taxonomy VALUES(1870,1125998,'Phytophthora','sp. APC001');
INSERT INTO taxonomy VALUES(1871,1126000,'Halophytophthora','sp. NBRC 32444');
INSERT INTO taxonomy VALUES(1872,1126001,'Halophytophthora','sp. NBRC 32445');
INSERT INTO taxonomy VALUES(1873,1126677,'Saprolegnia','sp. HP');
INSERT INTO taxonomy VALUES(1874,1126678,'Achlya','sp. YC');
INSERT INTO taxonomy VALUES(1875,1129773,'Peronospora','sp. Ng2011');
INSERT INTO taxonomy VALUES(1876,1130067,'Phytopythium','fagopyri');
INSERT INTO taxonomy VALUES(1877,1130069,'Phytopythium','iriomotense');
INSERT INTO taxonomy VALUES(1878,1130980,'Phytopythium','delawarense');
INSERT INTO taxonomy VALUES(1879,1131323,'Phytophthora','pisi');
INSERT INTO taxonomy VALUES(1880,1141941,'Phytophthora','sp. P1200');
INSERT INTO taxonomy VALUES(1881,1151129,'Peronospora','saturejae-hortensis');
INSERT INTO taxonomy VALUES(1882,1154630,'Albugo','sp. FR0046008');
INSERT INTO taxonomy VALUES(1883,1154631,'Albugo','sp. FR0046009');
INSERT INTO taxonomy VALUES(1884,1154632,'Albugo','sp. FR0046010');
INSERT INTO taxonomy VALUES(1885,1154633,'Albugo','sp. FR0046011');
INSERT INTO taxonomy VALUES(1886,1154634,'Albugo','sp. FR0046012');
INSERT INTO taxonomy VALUES(1887,1154635,'Albugo','sp. FR0046013');
INSERT INTO taxonomy VALUES(1888,1154636,'Albugo','sp. FR0046014');
INSERT INTO taxonomy VALUES(1889,1154637,'Albugo','sp. FR0046017');
INSERT INTO taxonomy VALUES(1890,1154638,'Albugo','sp. FR0046018');
INSERT INTO taxonomy VALUES(1891,1154639,'Albugo','sp. FR0046019');
INSERT INTO taxonomy VALUES(1892,1154640,'Albugo','sp. FR0046020');
INSERT INTO taxonomy VALUES(1893,1154641,'Albugo','sp. FR0046021');
INSERT INTO taxonomy VALUES(1894,1154642,'Albugo','sp. FR0046022');
INSERT INTO taxonomy VALUES(1895,1154643,'Albugo','sp. FR0046023');
INSERT INTO taxonomy VALUES(1896,1168480,'Hyaloperonospora','sp. KUS-F25091');
INSERT INTO taxonomy VALUES(1897,1176157,'Lagenidium','sp. MTLA-01');
INSERT INTO taxonomy VALUES(1898,1176158,'Lagenidium','sp. MTLA-03');
INSERT INTO taxonomy VALUES(1899,1176159,'Lagenidium','sp. MTLA-04');
INSERT INTO taxonomy VALUES(1900,1176160,'Lagenidium','sp. MTLA-05');
INSERT INTO taxonomy VALUES(1901,1185511,'Phytophthora','riparia');
INSERT INTO taxonomy VALUES(1902,1185512,'Phytophthora','borealis');
INSERT INTO taxonomy VALUES(1903,1190534,'Phytophthora','lacustris');
INSERT INTO taxonomy VALUES(1904,1190584,'Phytophthora','sp. CH-2012');
INSERT INTO taxonomy VALUES(1905,1190596,'Chlamydomyzium','dictyuchoides');
INSERT INTO taxonomy VALUES(1906,1194187,'Phytophthora','sp. WH-2012');
INSERT INTO taxonomy VALUES(1907,1194341,'Phytophthora','taxon walnut');
INSERT INTO taxonomy VALUES(1908,1194342,'Phytophthora','taxon forestsoil');
INSERT INTO taxonomy VALUES(1909,1194441,'Pythium','sp. M2-05');
INSERT INTO taxonomy VALUES(1910,1196443,'Plasmopara','muralis');
INSERT INTO taxonomy VALUES(1911,1196597,'Phytophthora','amnicola');
INSERT INTO taxonomy VALUES(1912,1197709,'Phytophthora','cf. gregata');
INSERT INTO taxonomy VALUES(1913,1197710,'Phytophthora','bilorbang');
INSERT INTO taxonomy VALUES(1914,1197711,'Phytophthora','sp. TIB-2012');
INSERT INTO taxonomy VALUES(1915,1200954,'Pythium','sp. DBS323');
INSERT INTO taxonomy VALUES(1916,1200955,'Pythium','sp. CBS531');
INSERT INTO taxonomy VALUES(1917,1200956,'Globisporangium','wuhanense');
INSERT INTO taxonomy VALUES(1918,1201160,'Globisporangium','breve');
INSERT INTO taxonomy VALUES(1919,1201161,'Globisporangium','baisense');
INSERT INTO taxonomy VALUES(1920,1202104,'Saprolegnia','sp. salmon/trout/2012');
INSERT INTO taxonomy VALUES(1921,1202474,'Pythium','sp. C WLL-2012');
INSERT INTO taxonomy VALUES(1922,1202475,'Pythium','sp. B WLL-2012');
INSERT INTO taxonomy VALUES(1923,1202476,'Pythium','sp. A WLL-2012');
INSERT INTO taxonomy VALUES(1924,1202772,'Achlya','hypogyna');
INSERT INTO taxonomy VALUES(1925,1203047,'Leptolegnia','sp. WLL-2012');
INSERT INTO taxonomy VALUES(1926,1214257,'Phytophthora','aff. arenaria');
INSERT INTO taxonomy VALUES(1927,1214258,'Phytophthora','aff. humicola');
INSERT INTO taxonomy VALUES(1928,1215926,'Phytophthora','sp. P0622');
INSERT INTO taxonomy VALUES(1929,1215927,'Phytophthora','sp. P10860');
INSERT INTO taxonomy VALUES(1930,1215928,'Phytophthora','sp. P10866');
INSERT INTO taxonomy VALUES(1931,1215929,'Phytophthora','sp. P10870');
INSERT INTO taxonomy VALUES(1932,1215930,'Phytophthora','sp. P10873');
INSERT INTO taxonomy VALUES(1933,1215931,'Phytophthora','sp. P10875');
INSERT INTO taxonomy VALUES(1934,1215932,'Phytophthora','sp. P10878');
INSERT INTO taxonomy VALUES(1935,1215933,'Phytophthora','sp. P11055');
INSERT INTO taxonomy VALUES(1936,1215934,'Phytophthora','sp. P11098');
INSERT INTO taxonomy VALUES(1937,1215935,'Phytophthora','sp. P11498');
INSERT INTO taxonomy VALUES(1938,1215936,'Phytophthora','sp. P15127');
INSERT INTO taxonomy VALUES(1939,1215937,'Phytophthora','sp. P19007');
INSERT INTO taxonomy VALUES(1940,1215938,'Phytophthora','sp. P19018');
INSERT INTO taxonomy VALUES(1941,1215939,'Phytophthora','sp. P19030');
INSERT INTO taxonomy VALUES(1942,1215940,'Phytophthora','sp. P19041');
INSERT INTO taxonomy VALUES(1943,1215941,'Phytophthora','sp. P19052');
INSERT INTO taxonomy VALUES(1944,1215942,'Phytophthora','sp. P19055');
INSERT INTO taxonomy VALUES(1945,1215943,'Phytophthora','sp. P19071');
INSERT INTO taxonomy VALUES(1946,1215944,'Phytophthora','sp. P19081');
INSERT INTO taxonomy VALUES(1947,1215945,'Phytophthora','sp. P19083');
INSERT INTO taxonomy VALUES(1948,1215946,'Phytophthora','sp. P19085');
INSERT INTO taxonomy VALUES(1949,1215947,'Phytophthora','sp. P19104');
INSERT INTO taxonomy VALUES(1950,1215948,'Phytophthora','sp. P19105');
INSERT INTO taxonomy VALUES(1951,1215949,'Phytophthora','sp. P19106');
INSERT INTO taxonomy VALUES(1952,1215950,'Phytophthora','sp. P19108');
INSERT INTO taxonomy VALUES(1953,1215951,'Phytophthora','sp. P19110');
INSERT INTO taxonomy VALUES(1954,1215952,'Phytophthora','sp. P19114');
INSERT INTO taxonomy VALUES(1955,1215953,'Phytophthora','sp. P19117');
INSERT INTO taxonomy VALUES(1956,1215954,'Phytophthora','sp. P19121');
INSERT INTO taxonomy VALUES(1957,1215955,'Phytophthora','sp. P19134');
INSERT INTO taxonomy VALUES(1958,1215956,'Phytophthora','sp. P19144');
INSERT INTO taxonomy VALUES(1959,1215957,'Phytophthora','sp. P19145');
INSERT INTO taxonomy VALUES(1960,1215958,'Phytophthora','sp. P19146');
INSERT INTO taxonomy VALUES(1961,1215959,'Phytophthora','sp. P19156');
INSERT INTO taxonomy VALUES(1962,1215960,'Phytophthora','sp. P19160');
INSERT INTO taxonomy VALUES(1963,1215961,'Phytophthora','sp. P19163');
INSERT INTO taxonomy VALUES(1964,1215962,'Phytophthora','sp. P19168');
INSERT INTO taxonomy VALUES(1965,1215963,'Phytophthora','sp. P19172');
INSERT INTO taxonomy VALUES(1966,1215964,'Phytophthora','sp. P19173');
INSERT INTO taxonomy VALUES(1967,1215965,'Phytophthora','sp. P19175');
INSERT INTO taxonomy VALUES(1968,1215966,'Phytophthora','sp. P19176');
INSERT INTO taxonomy VALUES(1969,1215967,'Phytophthora','sp. P19177');
INSERT INTO taxonomy VALUES(1970,1215968,'Phytophthora','sp. P19178');
INSERT INTO taxonomy VALUES(1971,1215969,'Phytophthora','sp. P19179');
INSERT INTO taxonomy VALUES(1972,1215970,'Phytophthora','sp. P19180');
INSERT INTO taxonomy VALUES(1973,1215971,'Phytophthora','sp. P19181');
INSERT INTO taxonomy VALUES(1974,1215972,'Phytophthora','sp. P3773');
INSERT INTO taxonomy VALUES(1975,1215973,'Phytophthora','sp. P6127');
INSERT INTO taxonomy VALUES(1976,1215974,'Phytophthora','sp. P6129');
INSERT INTO taxonomy VALUES(1977,1215975,'Phytophthora','sp. P6130');
INSERT INTO taxonomy VALUES(1978,1215976,'Phytophthora','sp. P8485');
INSERT INTO taxonomy VALUES(1979,1216509,'Phytophthora','amnicola x taxon PgChlamydo');
INSERT INTO taxonomy VALUES(1980,1216510,'Phytophthora','thermophila x amnicola');
INSERT INTO taxonomy VALUES(1981,1216511,'Phytophthora','taxon Sisuluriver');
INSERT INTO taxonomy VALUES(1982,1216623,'Pythium','sp. P19301');
INSERT INTO taxonomy VALUES(1983,1216624,'Phytophthora','cf. tropicalis');
INSERT INTO taxonomy VALUES(1984,1216625,'Phytophthora','cf. insolita');
INSERT INTO taxonomy VALUES(1985,1216626,'Phytophthora','cf. mexicana');
INSERT INTO taxonomy VALUES(1986,1216627,'Pythium','sp. MDC-2012');
INSERT INTO taxonomy VALUES(1987,1216629,'Phytophthora','sp. MDC-2012b');
INSERT INTO taxonomy VALUES(1988,1216630,'Phytophthora','sp. MDC-2012c');
INSERT INTO taxonomy VALUES(1989,1216631,'Phytophthora','sp. MDC-2012d');
INSERT INTO taxonomy VALUES(1990,1217585,'Pythiogeton','zizaniae');
INSERT INTO taxonomy VALUES(1991,1217586,'Pythiogeton','ramosum');
INSERT INTO taxonomy VALUES(1992,1217587,'Pythiogeton','uniforme');
INSERT INTO taxonomy VALUES(1993,1217588,'Pythiogeton','puliense');
INSERT INTO taxonomy VALUES(1994,1217589,'Pythiogeton','oblongilobum');
INSERT INTO taxonomy VALUES(1995,1217590,'Pythiogeton','microzoosporum');
INSERT INTO taxonomy VALUES(1996,1217591,'Pythiogeton','abundans');
INSERT INTO taxonomy VALUES(1997,1217592,'Pythiogeton','paucisporum');
INSERT INTO taxonomy VALUES(1998,1217593,'Pythiogeton','proliferatum');
INSERT INTO taxonomy VALUES(1999,1217863,'Aphanomyces','sp. WLL-2012');
INSERT INTO taxonomy VALUES(2000,1218934,'Phytophthora','sp. FM-2012');
INSERT INTO taxonomy VALUES(2001,1218935,'Phytophthora','cf. citricola FM-2012');
INSERT INTO taxonomy VALUES(2002,1218936,'Phytophthora','aff. citricola 1 FM-2012');
INSERT INTO taxonomy VALUES(2003,1218937,'Phytophthora','aff. citricola 2 FM-2012');
INSERT INTO taxonomy VALUES(2004,1218938,'Phytophthora','cf. citrophthora 1b FM-2012');
INSERT INTO taxonomy VALUES(2005,1218939,'Phytophthora','cf. citrophthora 2 FM-2012');
INSERT INTO taxonomy VALUES(2006,1218940,'Phytophthora','cf. cryptogea 1 FM-2012');
INSERT INTO taxonomy VALUES(2007,1218942,'Phytophthora','cf. heveae 1 FM-2012');
INSERT INTO taxonomy VALUES(2008,1218943,'Phytophthora','cf. heveae 2 FM-2012');
INSERT INTO taxonomy VALUES(2009,1218944,'Phytophthora','cf. katsurae 1 FM-2012');
INSERT INTO taxonomy VALUES(2010,1218945,'Phytophthora','cf. katsurae 2 FM-2012');
INSERT INTO taxonomy VALUES(2011,1218946,'Phytophthora','sp. ''rasp tasm''');
INSERT INTO taxonomy VALUES(2012,1218947,'Phytophthora','cf. cryptogea 2 FM-2012');
INSERT INTO taxonomy VALUES(2013,1222020,'Phytophthora','sp. REB326-69');
INSERT INTO taxonomy VALUES(2014,1222021,'Phytophthora','sp. REB327-68');
INSERT INTO taxonomy VALUES(2015,1222022,'Phytophthora','sp. REB327-73');
INSERT INTO taxonomy VALUES(2016,1222023,'Phytophthora','sp. ICMP 18407');
INSERT INTO taxonomy VALUES(2017,1222025,'Pythium','sp. REB326-70');
INSERT INTO taxonomy VALUES(2018,1222026,'Pythium','sp. REB326-73');
INSERT INTO taxonomy VALUES(2019,1222027,'Pythium','sp. REB326-74');
INSERT INTO taxonomy VALUES(2020,1222028,'Pythium','sp. REB326-77');
INSERT INTO taxonomy VALUES(2021,1227510,'Phytophthora','sp. MAFF237500');
INSERT INTO taxonomy VALUES(2022,1231630,'Pythium','sp. IBL//2011/30');
INSERT INTO taxonomy VALUES(2023,1231631,'Pythium','sp. IBL/2011/12/1');
INSERT INTO taxonomy VALUES(2024,1231632,'Pythium','sp. IBL/2011/13/1');
INSERT INTO taxonomy VALUES(2025,1231633,'Pythium','sp. IBL/2011/22/2');
INSERT INTO taxonomy VALUES(2026,1231634,'Pythium','sp. IBL/2011/29/1');
INSERT INTO taxonomy VALUES(2027,1231635,'Pythium','sp. IBL/2011/29/2');
INSERT INTO taxonomy VALUES(2028,1231976,'Phytophthora','sp. IBL/2011/5/1/1');
INSERT INTO taxonomy VALUES(2029,1231977,'Phytophthora','sp. IBL/2012/7');
INSERT INTO taxonomy VALUES(2030,1234294,'Halophytophthora','sp. EMTD10');
INSERT INTO taxonomy VALUES(2031,1234295,'Halophytophthora','sp. EMTD11');
INSERT INTO taxonomy VALUES(2032,1234296,'Halophytophthora','sp. EMTD12');
INSERT INTO taxonomy VALUES(2033,1234297,'Halophytophthora','sp. EMTD7');
INSERT INTO taxonomy VALUES(2034,1234298,'Halophytophthora','sp. EMTS10');
INSERT INTO taxonomy VALUES(2035,1234299,'Halophytophthora','sp. EMTS12');
INSERT INTO taxonomy VALUES(2036,1234300,'Halophytophthora','sp. EMTS19');
INSERT INTO taxonomy VALUES(2037,1234301,'Halophytophthora','sp. EMTS2');
INSERT INTO taxonomy VALUES(2038,1234302,'Halophytophthora','sp. EMTS20');
INSERT INTO taxonomy VALUES(2039,1234303,'Halophytophthora','sp. EMTS21');
INSERT INTO taxonomy VALUES(2040,1234304,'Halophytophthora','sp. EMTS22');
INSERT INTO taxonomy VALUES(2041,1234305,'Halophytophthora','sp. EMTS23');
INSERT INTO taxonomy VALUES(2042,1234306,'Halophytophthora','sp. EMTS4');
INSERT INTO taxonomy VALUES(2043,1234307,'Halophytophthora','sp. EMTS6');
INSERT INTO taxonomy VALUES(2044,1234308,'Halophytophthora','sp. EMTS7');
INSERT INTO taxonomy VALUES(2045,1234309,'Halophytophthora','sp. EMTS8');
INSERT INTO taxonomy VALUES(2046,1234955,'Peronospora','jagei');
INSERT INTO taxonomy VALUES(2047,1235424,'Phytophthora','taxon Pgchlamydo x amnicola');
INSERT INTO taxonomy VALUES(2048,1235425,'Phytophthora','thermophila x taxon Pgchlamydo');
INSERT INTO taxonomy VALUES(2049,1241941,'Phytophthora','acerina');
INSERT INTO taxonomy VALUES(2050,1243776,'Lagenidium','albertoi');
INSERT INTO taxonomy VALUES(2051,1243777,'Lagenidium','sp. LM-2012b');
INSERT INTO taxonomy VALUES(2052,1243779,'Lagenidium','vilelae (nom. inval.)');
INSERT INTO taxonomy VALUES(2053,1244139,'Lagenidium','sp. LC1');
INSERT INTO taxonomy VALUES(2054,1245828,'Phytophthora','sp. WAMItV-2012');
INSERT INTO taxonomy VALUES(2055,1247367,'Saprolegnia','sp. CY1');
INSERT INTO taxonomy VALUES(2056,1247368,'Saprolegnia','sp. HZL1');
INSERT INTO taxonomy VALUES(2057,1247369,'Saprolegnia','sp. JE1');
INSERT INTO taxonomy VALUES(2058,1247370,'Saprolegnia','sp. JY2');
INSERT INTO taxonomy VALUES(2059,1249688,'Pythium','sp. rooibos 2');
INSERT INTO taxonomy VALUES(2060,1266055,'Phytophthora','sp. GUCC0313');
INSERT INTO taxonomy VALUES(2061,1266951,'Dictyuchus','sp. JVS-2012');
INSERT INTO taxonomy VALUES(2062,1266952,'Leptolegnia','sp. JVS-2012');
INSERT INTO taxonomy VALUES(2063,1268265,'Phytophthora','sp. B089');
INSERT INTO taxonomy VALUES(2064,1268266,'Phytophthora','sp. B101');
INSERT INTO taxonomy VALUES(2065,1268267,'Phytophthora','sp. B106');
INSERT INTO taxonomy VALUES(2066,1268268,'Phytophthora','sp. B163');
INSERT INTO taxonomy VALUES(2067,1269256,'Saprolegnia','sp. PB-2012');
INSERT INTO taxonomy VALUES(2068,1273180,'Phytophthora','cyperi');
INSERT INTO taxonomy VALUES(2069,1273191,'Saprolegnia','sp. LR11');
INSERT INTO taxonomy VALUES(2070,1273192,'Saprolegnia','sp. LB52');
INSERT INTO taxonomy VALUES(2071,1273193,'Saprolegnia','sp. MB35/MB13');
INSERT INTO taxonomy VALUES(2072,1273194,'Saprolegnia','sp. LB26');
INSERT INTO taxonomy VALUES(2073,1273195,'Saprolegnia','sp. MB70');
INSERT INTO taxonomy VALUES(2074,1273196,'Saprolegnia','sp. LB39');
INSERT INTO taxonomy VALUES(2075,1273197,'Saprolegnia','sp. LR2');
INSERT INTO taxonomy VALUES(2076,1273198,'Saprolegnia','sp. MB12');
INSERT INTO taxonomy VALUES(2077,1273199,'Saprolegnia','sp. LB46');
INSERT INTO taxonomy VALUES(2078,1273200,'Achlya','sp. LB63');
INSERT INTO taxonomy VALUES(2079,1273201,'Achlya','sp. LB35');
INSERT INTO taxonomy VALUES(2080,1273698,'Pythium','sp. P056');
INSERT INTO taxonomy VALUES(2081,1277646,'Globisporangium','schmitthenneri');
INSERT INTO taxonomy VALUES(2082,1277647,'Globisporangium','selbyi');
INSERT INTO taxonomy VALUES(2083,1278159,'Pythium','caudatum');
INSERT INTO taxonomy VALUES(2084,1279233,'Myzocytiopsis','sp. GPR-2013');
INSERT INTO taxonomy VALUES(2085,1283836,'Phytophthora','cactorum/hedraiandra SP-2013');
INSERT INTO taxonomy VALUES(2086,1286608,'Phytophthora','hydrogena');
INSERT INTO taxonomy VALUES(2087,1286650,'Phytophthora','x pelgrandis');
INSERT INTO taxonomy VALUES(2088,1287862,'Peronospora','plantaginis');
INSERT INTO taxonomy VALUES(2089,1306403,'Phytophthora','x stagnum');
INSERT INTO taxonomy VALUES(2090,1311513,'Peronospora','sp. KUS-F26431');
INSERT INTO taxonomy VALUES(2091,1320215,'Phytophthora','cichorii');
INSERT INTO taxonomy VALUES(2092,1320216,'Phytophthora','dauci');
INSERT INTO taxonomy VALUES(2093,1320217,'Phytophthora','lactucae');
INSERT INTO taxonomy VALUES(2094,1320218,'Phytophthora','sp. taxon castitis');
INSERT INTO taxonomy VALUES(2095,1320219,'Phytophthora','sp. taxon parsley');
INSERT INTO taxonomy VALUES(2096,1320378,'Peronospora','digitalis');
INSERT INTO taxonomy VALUES(2097,1322367,'Phytophthora','sp. Costa Rica 1');
INSERT INTO taxonomy VALUES(2098,1322368,'Phytophthora','sp. Costa Rica 11');
INSERT INTO taxonomy VALUES(2099,1322369,'Phytophthora','sp. Costa Rica 3');
INSERT INTO taxonomy VALUES(2100,1322370,'Phytophthora','sp. Costa Rica 5');
INSERT INTO taxonomy VALUES(2101,1322371,'Phytophthora','sp. Costa Rica 8');
INSERT INTO taxonomy VALUES(2102,1322372,'Phytophthora','sp. Grenada 1');
INSERT INTO taxonomy VALUES(2103,1322373,'Phytophthora','sp. Grenada 2');
INSERT INTO taxonomy VALUES(2104,1322374,'Phytophthora','sp. Grenada 3');
INSERT INTO taxonomy VALUES(2105,1322375,'Phytophthora','sp. Maryland 1');
INSERT INTO taxonomy VALUES(2106,1322376,'Phytophthora','sp. Maryland 2');
INSERT INTO taxonomy VALUES(2107,1322377,'Phytophthora','sp. Maryland 4');
INSERT INTO taxonomy VALUES(2108,1322378,'Phytophthora','sp. Maryland 5');
INSERT INTO taxonomy VALUES(2109,1322379,'Phytophthora','sp. Maryland 6');
INSERT INTO taxonomy VALUES(2110,1322380,'Phytophthora','sp. Maryland 7');
INSERT INTO taxonomy VALUES(2111,1322381,'Phytophthora','sp. Maryland 8');
INSERT INTO taxonomy VALUES(2112,1322382,'Phytophthora','sp. Maryland 9');
INSERT INTO taxonomy VALUES(2113,1322383,'Phytophthora','sp. Peru 1');
INSERT INTO taxonomy VALUES(2114,1322384,'Phytophthora','sp. Peru 3');
INSERT INTO taxonomy VALUES(2115,1322385,'Phytophthora','sp. Peru 4');
INSERT INTO taxonomy VALUES(2116,1322386,'Phytophthora','sp. Taxodium 1');
INSERT INTO taxonomy VALUES(2117,1322387,'Phytophthora','sp. Taxodium 2');
INSERT INTO taxonomy VALUES(2118,1329263,'Phytophthora','sp. Umtamvuna');
INSERT INTO taxonomy VALUES(2119,1329264,'Phytophthora','sp. canthium');
INSERT INTO taxonomy VALUES(2120,1329266,'Phytophthora','sp. stellaris');
INSERT INTO taxonomy VALUES(2121,1329267,'Phytophthora','sp. xHennops');
INSERT INTO taxonomy VALUES(2122,1329268,'Phytophthora','sp. xWS');
INSERT INTO taxonomy VALUES(2123,1330343,'Phytophthora','pluvialis');
INSERT INTO taxonomy VALUES(2124,1334601,'Phytopythium','sp. 1 PB-2013');
INSERT INTO taxonomy VALUES(2125,1334602,'Phytopythium','sp. 2 PB-2013');
INSERT INTO taxonomy VALUES(2126,1334603,'Phytopythium','sp. 3 PB-2013');
INSERT INTO taxonomy VALUES(2127,1334604,'Phytopythium','cf. citrinum A PB-2013');
INSERT INTO taxonomy VALUES(2128,1334605,'Phytopythium','cf. citrinum B PB-2013');
INSERT INTO taxonomy VALUES(2129,1334606,'Phytophthora','cf. rosacearum PB-2013');
INSERT INTO taxonomy VALUES(2130,1344363,'Plasmopara','laserpitii');
INSERT INTO taxonomy VALUES(2131,1344364,'Hyaloperonospora','cardamines-laciniatae');
INSERT INTO taxonomy VALUES(2132,1344365,'Hyaloperonospora','dentariae-macrophyllae');
INSERT INTO taxonomy VALUES(2133,1344366,'Hyaloperonospora','malyi');
INSERT INTO taxonomy VALUES(2134,1344368,'Hyaloperonospora','cardamines-enneaphyllos');
INSERT INTO taxonomy VALUES(2135,1344369,'Plasmopara','sp. 1 HV-2013');
INSERT INTO taxonomy VALUES(2136,1346087,'Phytophthora','sp. 1 TIB-2013');
INSERT INTO taxonomy VALUES(2137,1348161,'Peronospora','sp. AT-2013');
INSERT INTO taxonomy VALUES(2138,1358711,'Phytophthora','sp. EBK-2013');
INSERT INTO taxonomy VALUES(2139,1358712,'Phytopythium','sp. EBK-2013');
INSERT INTO taxonomy VALUES(2140,1358714,'Pythium','sp. EBK-2013a');
INSERT INTO taxonomy VALUES(2141,1358715,'Pythium','sp. EBK-2013b');
INSERT INTO taxonomy VALUES(2142,1358716,'Aphanomyces','sp. EBK-2013');
INSERT INTO taxonomy VALUES(2143,1380025,'Pythium','sp. 1 HW-2013');
INSERT INTO taxonomy VALUES(2144,1380738,'Phytophthora','pachypleura');
INSERT INTO taxonomy VALUES(2145,1383453,'Pythium','sp. 1 MNS-2013');
INSERT INTO taxonomy VALUES(2146,1385620,'Phytophthora','occultans');
INSERT INTO taxonomy VALUES(2147,1385621,'Phytophthora','terminalis');
INSERT INTO taxonomy VALUES(2148,1387894,'Phytophthora','sp. 2 TIB-2013');
INSERT INTO taxonomy VALUES(2149,1391457,'Pythium','phragmiticola');
INSERT INTO taxonomy VALUES(2150,1396423,'Phytophthora','mississippiae');
INSERT INTO taxonomy VALUES(2151,1401295,'Phytophthora','stricta');
INSERT INTO taxonomy VALUES(2152,1401296,'Phytophthora','macilentosa');
INSERT INTO taxonomy VALUES(2153,1402215,'Saprolegnia','sp. 1 APM-2013');
INSERT INTO taxonomy VALUES(2154,1404344,'Phytophthora','sp. 1 KS-2013');
INSERT INTO taxonomy VALUES(2155,1407013,'Phytophthora','sp. EL_8701');
INSERT INTO taxonomy VALUES(2156,1407014,'Phytophthora','sp. EL_8703');
INSERT INTO taxonomy VALUES(2157,1417922,'Phytophthora','sp. 160_1670-11');
INSERT INTO taxonomy VALUES(2158,1417923,'Phytophthora','sp. 58_MC-38');
INSERT INTO taxonomy VALUES(2159,1417924,'Phytophthora','sp. BLW NRA');
INSERT INTO taxonomy VALUES(2160,1420584,'Pythium','sp. E13106a');
INSERT INTO taxonomy VALUES(2161,1420585,'Pythium','sp. E13106f');
INSERT INTO taxonomy VALUES(2162,1421716,'Pythium','sp. F-1541.11');
INSERT INTO taxonomy VALUES(2163,1432261,'Pythium','sp. BP 2013a');
INSERT INTO taxonomy VALUES(2164,1432262,'Pythium','sp. BP 2013b');
INSERT INTO taxonomy VALUES(2165,1432263,'Pythium','sp. BP 2013c');
INSERT INTO taxonomy VALUES(2166,1432264,'Pythium','sp. BP 2013d');
INSERT INTO taxonomy VALUES(2167,1432265,'Pythium','sp. BP 2013e');
INSERT INTO taxonomy VALUES(2168,1432266,'Pythium','sp. BP 2013f');
INSERT INTO taxonomy VALUES(2169,1432267,'Pythium','sp. BP 2013g');
INSERT INTO taxonomy VALUES(2170,1432268,'Pythium','sp. BP 2013h');
INSERT INTO taxonomy VALUES(2171,1432269,'Pythium','sp. BP 2013i');
INSERT INTO taxonomy VALUES(2172,1432270,'Pythium','sp. BP 2013j');
INSERT INTO taxonomy VALUES(2173,1432271,'Pythium','sp. BP 2013k');
INSERT INTO taxonomy VALUES(2174,1432272,'Pythium','sp. BP 2013l');
INSERT INTO taxonomy VALUES(2175,1432273,'Pythium','sp. BP 2013m');
INSERT INTO taxonomy VALUES(2176,1432543,'Geolegnia','helicoides');
INSERT INTO taxonomy VALUES(2177,1434786,'Phytophthora','sp. KPh2010_1_1');
INSERT INTO taxonomy VALUES(2178,1434787,'Phytophthora','sp. KPh2010_3_2');
INSERT INTO taxonomy VALUES(2179,1434788,'Phytophthora','sp. KPh2010_4_1');
INSERT INTO taxonomy VALUES(2180,1434789,'Phytophthora','sp. KPh2011_1_1');
INSERT INTO taxonomy VALUES(2181,1434790,'Phytophthora','sp. KPh2013_1_1');
INSERT INTO taxonomy VALUES(2182,1434791,'Phytophthora','sp. KPh2013_2_1');
INSERT INTO taxonomy VALUES(2183,1434792,'Phytophthora','sp. KPh2013_3_2');
INSERT INTO taxonomy VALUES(2184,1434793,'Phytophthora','sp. KPh2013_4_1');
INSERT INTO taxonomy VALUES(2185,1437524,'Pythiogeton','sp. BV1');
INSERT INTO taxonomy VALUES(2186,1440115,'Paralagenidium','karlingii');
INSERT INTO taxonomy VALUES(2187,1440157,'Lagenidium','sp. CICR-Hop');
INSERT INTO taxonomy VALUES(2188,1441741,'Lagenidium','aff. deciduum LEV5864');
INSERT INTO taxonomy VALUES(2189,1441742,'Lagenidium','sp. strain LEV5863');
INSERT INTO taxonomy VALUES(2190,1441743,'Lagenidium','sp. strain LEV5848');
INSERT INTO taxonomy VALUES(2191,1441771,'Paralagenidium','sp. C06-TW60');
INSERT INTO taxonomy VALUES(2192,1441772,'Paralagenidium','sp. C09-TL95');
INSERT INTO taxonomy VALUES(2193,1445011,'Saprolegnia','sp. Leka.Manoch');
INSERT INTO taxonomy VALUES(2194,1446065,'Phytophthora','sp. hybrid type 1');
INSERT INTO taxonomy VALUES(2195,1446066,'Phytophthora','sp. hybrid type 2');
INSERT INTO taxonomy VALUES(2196,1446067,'Phytophthora','sp. hybrid type 3');
INSERT INTO taxonomy VALUES(2197,1446881,'Halophytophthora','fluviatilis');
INSERT INTO taxonomy VALUES(2198,1446882,'Phytophthora','sp. citIX');
INSERT INTO taxonomy VALUES(2199,1448053,'Globisporangium','intermedium');
INSERT INTO taxonomy VALUES(2200,1448060,'Pythium','salinum');
INSERT INTO taxonomy VALUES(2201,1448062,'Phytopythium','sp. 1 KC-2014');
INSERT INTO taxonomy VALUES(2202,1448063,'Phytopythium','sp. 2 KC-2014');
INSERT INTO taxonomy VALUES(2203,1448066,'Pythium','sp. 1 KC-2014');
INSERT INTO taxonomy VALUES(2204,1448067,'Pythium','sp. 2 KC-2014');
INSERT INTO taxonomy VALUES(2205,1448069,'Pythium','sp. 1106-4-4B');
INSERT INTO taxonomy VALUES(2206,1450233,'Leptolegnia','sp. CBS 392.81');
INSERT INTO taxonomy VALUES(2207,1450477,'Globisporangium','cederbergense');
INSERT INTO taxonomy VALUES(2208,1452752,'Globisporangium','sp. KC-2014');
INSERT INTO taxonomy VALUES(2209,1452753,'Halophytophthora','sp. 1 KC-2014');
INSERT INTO taxonomy VALUES(2210,1452754,'Halophytophthora','sp. 2 KC-2014');
INSERT INTO taxonomy VALUES(2211,1452755,'Halophytophthora','sp. 3 KC-2014');
INSERT INTO taxonomy VALUES(2212,1454042,'Saprolegnia','sp. JR-2014a');
INSERT INTO taxonomy VALUES(2213,1458840,'Plasmopara','sp. HV-2014a');
INSERT INTO taxonomy VALUES(2214,1458904,'Phytophthora','sp. CH98ASP051');
INSERT INTO taxonomy VALUES(2215,1458905,'Phytophthora','sp. CH98ASP061');
INSERT INTO taxonomy VALUES(2216,1458906,'Phytophthora','sp. CH98ASP063');
INSERT INTO taxonomy VALUES(2217,1458907,'Phytophthora','sp. CH98ASP069');
INSERT INTO taxonomy VALUES(2218,1463539,'Plasmopara','invertifolia');
INSERT INTO taxonomy VALUES(2219,1464076,'Phytophthora','aff. cactorum FNM-2014');
INSERT INTO taxonomy VALUES(2220,1470262,'Lagenidium','ajelloi (nom. inval.)');
INSERT INTO taxonomy VALUES(2221,1471603,'Pustula','obtusata');
INSERT INTO taxonomy VALUES(2222,1473563,'Phytophthora','sp. PV-29');
INSERT INTO taxonomy VALUES(2223,1473564,'Phytophthora','sp. PV-47');
INSERT INTO taxonomy VALUES(2224,1473565,'Phytophthora','taxon Buxus');
INSERT INTO taxonomy VALUES(2225,1473752,'Peronospora','sp. DML84');
INSERT INTO taxonomy VALUES(2226,1477121,'Phytophthora','virginiana');
INSERT INTO taxonomy VALUES(2227,1484098,'Bremia','aff. lagoseridis GLM68027');
INSERT INTO taxonomy VALUES(2228,1484099,'Bremia','picridis');
INSERT INTO taxonomy VALUES(2229,1484100,'Bremia','elliptica');
INSERT INTO taxonomy VALUES(2230,1484102,'Peronospora','anagallidis');
INSERT INTO taxonomy VALUES(2231,1484356,'Peronospora','valerianae');
INSERT INTO taxonomy VALUES(2232,1484358,'Peronospora','honckenyae');
INSERT INTO taxonomy VALUES(2233,1484359,'Peronospora','phacae');
INSERT INTO taxonomy VALUES(2234,1484360,'Peronospora','potentillae-anserinae');
INSERT INTO taxonomy VALUES(2235,1484361,'Peronospora','potentillae-reptantis');
INSERT INTO taxonomy VALUES(2236,1484362,'Peronospora','rubi');
INSERT INTO taxonomy VALUES(2237,1484363,'Peronospora','salviae-plebeiae');
INSERT INTO taxonomy VALUES(2238,1484364,'Peronospora','saxifragae');
INSERT INTO taxonomy VALUES(2239,1484365,'Peronospora','schachtii');
INSERT INTO taxonomy VALUES(2240,1484366,'Peronospora','stachydis');
INSERT INTO taxonomy VALUES(2241,1484367,'Peronospora','symphyti');
INSERT INTO taxonomy VALUES(2242,1484368,'Peronospora','scleranthi');
INSERT INTO taxonomy VALUES(2243,1484369,'Peronospora','scutellariae');
INSERT INTO taxonomy VALUES(2244,1484371,'Peronospora','teucrii');
INSERT INTO taxonomy VALUES(2245,1484372,'Peronospora','tomentosa');
INSERT INTO taxonomy VALUES(2246,1484373,'Peronospora','vernalis');
INSERT INTO taxonomy VALUES(2247,1484374,'Peronospora','verbasci');
INSERT INTO taxonomy VALUES(2248,1484375,'Peronospora','debaryi');
INSERT INTO taxonomy VALUES(2249,1484376,'Peronospora','dipsaci');
INSERT INTO taxonomy VALUES(2250,1484377,'Peronospora','echii');
INSERT INTO taxonomy VALUES(2251,1484378,'Peronospora','erodii');
INSERT INTO taxonomy VALUES(2252,1484379,'Peronospora','galii');
INSERT INTO taxonomy VALUES(2253,1484380,'Peronospora','glechomae');
INSERT INTO taxonomy VALUES(2254,1484381,'Peronospora','affinis');
INSERT INTO taxonomy VALUES(2255,1484382,'Peronospora','antirrhini');
INSERT INTO taxonomy VALUES(2256,1484383,'Peronospora','argemones');
INSERT INTO taxonomy VALUES(2257,1484384,'Peronospora','cerastii-anomali');
INSERT INTO taxonomy VALUES(2258,1484385,'Peronospora','cerastii-brachypetali');
INSERT INTO taxonomy VALUES(2259,1484386,'Peronospora','consolidae');
INSERT INTO taxonomy VALUES(2260,1484387,'Peronospora','corydalis-intermediae');
INSERT INTO taxonomy VALUES(2261,1484431,'Peronospora','cyparissiae');
INSERT INTO taxonomy VALUES(2262,1484475,'Peronospora','lapponica');
INSERT INTO taxonomy VALUES(2263,1484476,'Peronospora','lepigoni');
INSERT INTO taxonomy VALUES(2264,1484477,'Peronospora','linariae');
INSERT INTO taxonomy VALUES(2265,1484478,'Peronospora','linariae-genistifoliae');
INSERT INTO taxonomy VALUES(2266,1484480,'Peronospora','lithospermi');
INSERT INTO taxonomy VALUES(2267,1484481,'Peronospora','meconopsidis');
INSERT INTO taxonomy VALUES(2268,1484482,'Peronospora','melandryi-noctiflori');
INSERT INTO taxonomy VALUES(2269,1484483,'Peronospora','minor');
INSERT INTO taxonomy VALUES(2270,1484484,'Peronospora','oblatispora');
INSERT INTO taxonomy VALUES(2271,1484485,'Peronospora','polygoni-convolvuli');
INSERT INTO taxonomy VALUES(2272,1484486,'Myzocytiopsis','osiris');
INSERT INTO taxonomy VALUES(2273,1484555,'Pythium','sp. YJC-2014');
INSERT INTO taxonomy VALUES(2274,1484556,'Lagenidium','sp. YJC-2014');
INSERT INTO taxonomy VALUES(2275,1484560,'Halophytophthora','sp. YJC-2014');
INSERT INTO taxonomy VALUES(2276,1484563,'Albugo','sp. YJC-2014');
INSERT INTO taxonomy VALUES(2277,1485010,'Globisporangium','[Pythium] brassicae (nom. inval.)');
INSERT INTO taxonomy VALUES(2278,1485171,'Phytophthora','sp. TARI 29352');
INSERT INTO taxonomy VALUES(2279,1486344,'Phytophthora','amaranthi');
INSERT INTO taxonomy VALUES(2280,1487174,'Peronosclerospora','sp. YJC-2014');
INSERT INTO taxonomy VALUES(2281,1487765,'Phytophthora','sp. JP1');
INSERT INTO taxonomy VALUES(2282,1487766,'Phytophthora','sp. JP2');
INSERT INTO taxonomy VALUES(2283,1487767,'Phytophthora','sp. JP3');
INSERT INTO taxonomy VALUES(2284,1487768,'Phytophthora','sp. JP4');
INSERT INTO taxonomy VALUES(2285,1487769,'Phytophthora','sp. JP5');
INSERT INTO taxonomy VALUES(2286,1487770,'Phytophthora','sp. JP6');
INSERT INTO taxonomy VALUES(2287,1487771,'Phytophthora','sp. JP7');
INSERT INTO taxonomy VALUES(2288,1489738,'Globisporangium','polare');
INSERT INTO taxonomy VALUES(2289,1489740,'Globisporangium','solare');
INSERT INTO taxonomy VALUES(2290,1489741,'Globisporangium','recalcitrans');
INSERT INTO taxonomy VALUES(2291,1489786,'Lagenidium','sp. SLG-2014a');
INSERT INTO taxonomy VALUES(2292,1489787,'Lagenidium','sp. SLG-2014b');
INSERT INTO taxonomy VALUES(2293,1489789,'Lagena','radicicola');
INSERT INTO taxonomy VALUES(2294,1490495,'Phytophthora','fragariaefolia');
INSERT INTO taxonomy VALUES(2295,1491441,'Peronospora','apula');
INSERT INTO taxonomy VALUES(2296,1491442,'Peronospora','somniferi');
INSERT INTO taxonomy VALUES(2297,1491443,'Peronospora','sp. MA-Fungi 27841');
INSERT INTO taxonomy VALUES(2298,1495612,'Aquastella','attenuata');
INSERT INTO taxonomy VALUES(2299,1495613,'Aquastella','acicularis');
INSERT INTO taxonomy VALUES(2300,1498505,'Achlya','sp. BKKU1005');
INSERT INTO taxonomy VALUES(2301,1498506,'Achlya','sp. BKKU1009');
INSERT INTO taxonomy VALUES(2302,1498507,'Achlya','sp. BKKU1117');
INSERT INTO taxonomy VALUES(2303,1498508,'Achlya','sp. BKKU1118');
INSERT INTO taxonomy VALUES(2304,1498509,'Achlya','sp. BKKU1127');
INSERT INTO taxonomy VALUES(2305,1498510,'Achlya','sp. BKKU1134');
INSERT INTO taxonomy VALUES(2306,1499098,'Phytophthora','lacustris x riparia');
INSERT INTO taxonomy VALUES(2307,1499989,'Pustula','sp. LdT-2014');
INSERT INTO taxonomy VALUES(2308,1503225,'Saprolegnia','sp. 5 SR-2014');
INSERT INTO taxonomy VALUES(2309,1503226,'Leptolegnia','sp. SR-2014');
INSERT INTO taxonomy VALUES(2310,1503440,'Phytopythium','sp. MAB-2014');
INSERT INTO taxonomy VALUES(2311,1507810,'Phytophthora','sp. NJB-2014');
INSERT INTO taxonomy VALUES(2312,1524452,'Pythium','sp. BCC53698');
INSERT INTO taxonomy VALUES(2313,1525374,'Pythium','sp. ''cf. amazonianum C022''');
INSERT INTO taxonomy VALUES(2314,1525375,'Pythium','sp. ''cf. amazonianum C024''');
INSERT INTO taxonomy VALUES(2315,1525376,'Phytopythium','cf. vexans C061');
INSERT INTO taxonomy VALUES(2316,1525714,'Phytophthora','nagaii');
INSERT INTO taxonomy VALUES(2317,1527294,'Phytophthora','sp. Ak-6-1');
INSERT INTO taxonomy VALUES(2318,1527295,'Phytophthora','sp. Fk-3');
INSERT INTO taxonomy VALUES(2319,1527296,'Phytophthora','sp. Ku-1');
INSERT INTO taxonomy VALUES(2320,1527297,'Phytophthora','sp. CH84S-2');
INSERT INTO taxonomy VALUES(2321,1529059,'Phytophthora','asiatica');
INSERT INTO taxonomy VALUES(2322,1532566,'Leptolegnia','sp. SAP0772');
INSERT INTO taxonomy VALUES(2323,1532567,'Saprolegnia','sp. SAP0261');
INSERT INTO taxonomy VALUES(2324,1532568,'Saprolegnia','sp. SAP0265');
INSERT INTO taxonomy VALUES(2325,1532569,'Saprolegnia','sp. SAP0267');
INSERT INTO taxonomy VALUES(2326,1532570,'Saprolegnia','sp. SAP0268');
INSERT INTO taxonomy VALUES(2327,1532571,'Saprolegnia','sp. SAP0277');
INSERT INTO taxonomy VALUES(2328,1532572,'Saprolegnia','sp. SAP0284');
INSERT INTO taxonomy VALUES(2329,1532573,'Saprolegnia','sp. SAP0285');
INSERT INTO taxonomy VALUES(2330,1532574,'Saprolegnia','sp. SAP0291');
INSERT INTO taxonomy VALUES(2331,1532575,'Saprolegnia','sp. SAP0382');
INSERT INTO taxonomy VALUES(2332,1532576,'Saprolegnia','sp. SAP0433');
INSERT INTO taxonomy VALUES(2333,1532577,'Saprolegnia','sp. SAP0445');
INSERT INTO taxonomy VALUES(2334,1532578,'Saprolegnia','sp. SAP0446');
INSERT INTO taxonomy VALUES(2335,1532579,'Saprolegnia','sp. SAP0457');
INSERT INTO taxonomy VALUES(2336,1532580,'Saprolegnia','sp. SAP0458');
INSERT INTO taxonomy VALUES(2337,1532581,'Saprolegnia','sp. SAP0470');
INSERT INTO taxonomy VALUES(2338,1532582,'Saprolegnia','sp. SAP0477');
INSERT INTO taxonomy VALUES(2339,1532583,'Saprolegnia','sp. SAP0500');
INSERT INTO taxonomy VALUES(2340,1532584,'Saprolegnia','sp. SAP0533');
INSERT INTO taxonomy VALUES(2341,1532585,'Saprolegnia','sp. SAP0562');
INSERT INTO taxonomy VALUES(2342,1532586,'Saprolegnia','sp. SAP0575');
INSERT INTO taxonomy VALUES(2343,1532587,'Saprolegnia','sp. SAP0580');
INSERT INTO taxonomy VALUES(2344,1532588,'Saprolegnia','sp. SAP0624');
INSERT INTO taxonomy VALUES(2345,1532589,'Saprolegnia','sp. SAP0625');
INSERT INTO taxonomy VALUES(2346,1532590,'Saprolegnia','sp. SAP0626');
INSERT INTO taxonomy VALUES(2347,1532591,'Saprolegnia','sp. SAP0645');
INSERT INTO taxonomy VALUES(2348,1532592,'Saprolegnia','sp. SAP0649');
INSERT INTO taxonomy VALUES(2349,1532593,'Saprolegnia','sp. SAP0653');
INSERT INTO taxonomy VALUES(2350,1532594,'Saprolegnia','sp. SAP0656');
INSERT INTO taxonomy VALUES(2351,1532595,'Saprolegnia','sp. SAP0708');
INSERT INTO taxonomy VALUES(2352,1532596,'Saprolegnia','sp. SAP0709');
INSERT INTO taxonomy VALUES(2353,1532597,'Saprolegnia','sp. SAP0771');
INSERT INTO taxonomy VALUES(2354,1532598,'Saprolegnia','sp. SAP0776');
INSERT INTO taxonomy VALUES(2355,1532599,'Saprolegnia','sp. SAP0781');
INSERT INTO taxonomy VALUES(2356,1532600,'Saprolegnia','sp. SAP0783');
INSERT INTO taxonomy VALUES(2357,1532601,'Saprolegnia','sp. SAP0792');
INSERT INTO taxonomy VALUES(2358,1532602,'Saprolegnia','sp. SAP0794');
INSERT INTO taxonomy VALUES(2359,1532603,'Saprolegnia','sp. SAP0808');
INSERT INTO taxonomy VALUES(2360,1532604,'Saprolegnia','sp. SAP0812');
INSERT INTO taxonomy VALUES(2361,1532605,'Saprolegnia','sp. SAP0813');
INSERT INTO taxonomy VALUES(2362,1532606,'Saprolegnia','sp. SAP0819');
INSERT INTO taxonomy VALUES(2363,1532607,'Saprolegnia','sp. SAP0820');
INSERT INTO taxonomy VALUES(2364,1532608,'Saprolegnia','sp. SAP0829');
INSERT INTO taxonomy VALUES(2365,1532609,'Saprolegnia','sp. SAP0900');
INSERT INTO taxonomy VALUES(2366,1532610,'Saprolegnia','sp. SAP0933');
INSERT INTO taxonomy VALUES(2367,1532611,'Saprolegnia','sp. SAP0955');
INSERT INTO taxonomy VALUES(2368,1532612,'Saprolegnia','sp. SAP0956');
INSERT INTO taxonomy VALUES(2369,1532613,'Saprolegnia','sp. SAP0957');
INSERT INTO taxonomy VALUES(2370,1532614,'Saprolegnia','sp. SAP0958');
INSERT INTO taxonomy VALUES(2371,1532615,'Saprolegnia','sp. SAP0971');
INSERT INTO taxonomy VALUES(2372,1532616,'Saprolegnia','sp. SAP0987');
INSERT INTO taxonomy VALUES(2373,1532617,'Saprolegnia','sp. SAP0988');
INSERT INTO taxonomy VALUES(2374,1532618,'Saprolegnia','sp. SAP0992');
INSERT INTO taxonomy VALUES(2375,1532619,'Saprolegnia','sp. SAP0999');
INSERT INTO taxonomy VALUES(2376,1532620,'Saprolegnia','sp. SAP1006');
INSERT INTO taxonomy VALUES(2377,1532621,'Saprolegnia','sp. SAP1008');
INSERT INTO taxonomy VALUES(2378,1532622,'Saprolegnia','sp. SAP1028');
INSERT INTO taxonomy VALUES(2379,1532623,'Saprolegnia','sp. SAP1037');
INSERT INTO taxonomy VALUES(2380,1532624,'Saprolegnia','sp. SAP1088');
INSERT INTO taxonomy VALUES(2381,1532625,'Saprolegnia','sp. SAP1101');
INSERT INTO taxonomy VALUES(2382,1532626,'Saprolegnia','sp. SAP1102');
INSERT INTO taxonomy VALUES(2383,1532627,'Saprolegnia','sp. SAP1103');
INSERT INTO taxonomy VALUES(2384,1532628,'Saprolegnia','sp. SAP1104');
INSERT INTO taxonomy VALUES(2385,1532629,'Saprolegnia','sp. SAP1112');
INSERT INTO taxonomy VALUES(2386,1532630,'Saprolegnia','sp. SAP1124');
INSERT INTO taxonomy VALUES(2387,1532631,'Saprolegnia','sp. SAP1138');
INSERT INTO taxonomy VALUES(2388,1532632,'Saprolegnia','sp. SAP1164');
INSERT INTO taxonomy VALUES(2389,1532633,'Saprolegnia','sp. SAP1165');
INSERT INTO taxonomy VALUES(2390,1532634,'Saprolegnia','sp. SAP1168');
INSERT INTO taxonomy VALUES(2391,1532635,'Saprolegnia','sp. SAP1169');
INSERT INTO taxonomy VALUES(2392,1532636,'Saprolegnia','sp. SAP1185');
INSERT INTO taxonomy VALUES(2393,1532637,'Saprolegnia','sp. SAP1187');
INSERT INTO taxonomy VALUES(2394,1532638,'Saprolegnia','sp. SAP1209');
INSERT INTO taxonomy VALUES(2395,1532639,'Saprolegnia','sp. SAP1246');
INSERT INTO taxonomy VALUES(2396,1532640,'Saprolegnia','sp. SAP1253');
INSERT INTO taxonomy VALUES(2397,1532641,'Saprolegnia','sp. SAP1261');
INSERT INTO taxonomy VALUES(2398,1532642,'Saprolegnia','sp. SAP1267');
INSERT INTO taxonomy VALUES(2399,1532643,'Saprolegnia','sp. SAP1272');
INSERT INTO taxonomy VALUES(2400,1532644,'Saprolegnia','sp. SAP1278');
INSERT INTO taxonomy VALUES(2401,1532645,'Saprolegnia','sp. SAP1280');
INSERT INTO taxonomy VALUES(2402,1532646,'Saprolegnia','sp. SAP1298');
INSERT INTO taxonomy VALUES(2403,1532647,'Saprolegnia','sp. SAP1302');
INSERT INTO taxonomy VALUES(2404,1532648,'Saprolegnia','sp. SAP1303');
INSERT INTO taxonomy VALUES(2405,1532649,'Saprolegnia','sp. SAP1304');
INSERT INTO taxonomy VALUES(2406,1532650,'Saprolegnia','sp. SAP1308');
INSERT INTO taxonomy VALUES(2407,1532651,'Saprolegnia','sp. SAP1309');
INSERT INTO taxonomy VALUES(2408,1532652,'Saprolegnia','sp. SAP1310');
INSERT INTO taxonomy VALUES(2409,1532653,'Saprolegnia','sp. SAP1311');
INSERT INTO taxonomy VALUES(2410,1532654,'Saprolegnia','sp. SAP1312');
INSERT INTO taxonomy VALUES(2411,1532655,'Saprolegnia','sp. SAP1315');
INSERT INTO taxonomy VALUES(2412,1532656,'Saprolegnia','sp. SAP1316');
INSERT INTO taxonomy VALUES(2413,1532657,'Saprolegnia','sp. SAP1323');
INSERT INTO taxonomy VALUES(2414,1532658,'Saprolegnia','sp. SAP1326');
INSERT INTO taxonomy VALUES(2415,1532659,'Saprolegnia','sp. SAP1330');
INSERT INTO taxonomy VALUES(2416,1532660,'Saprolegnia','sp. SAP1360');
INSERT INTO taxonomy VALUES(2417,1532661,'Saprolegnia','sp. SAP1370');
INSERT INTO taxonomy VALUES(2418,1532662,'Saprolegnia','sp. SAP1383');
INSERT INTO taxonomy VALUES(2419,1532663,'Saprolegnia','sp. SAP1424');
INSERT INTO taxonomy VALUES(2420,1532664,'Saprolegnia','sp. SAP1425');
INSERT INTO taxonomy VALUES(2421,1532665,'Saprolegnia','sp. SAP1436');
INSERT INTO taxonomy VALUES(2422,1532666,'Saprolegnia','sp. SAP1439');
INSERT INTO taxonomy VALUES(2423,1532667,'Saprolegnia','sp. SAP1440');
INSERT INTO taxonomy VALUES(2424,1532668,'Saprolegnia','sp. SAP1441');
INSERT INTO taxonomy VALUES(2425,1532669,'Saprolegnia','sp. SAP1449');
INSERT INTO taxonomy VALUES(2426,1532670,'Saprolegnia','sp. SAP1456');
INSERT INTO taxonomy VALUES(2427,1532671,'Saprolegnia','sp. SAP1459');
INSERT INTO taxonomy VALUES(2428,1532672,'Saprolegnia','sp. SAP1536');
INSERT INTO taxonomy VALUES(2429,1532673,'Saprolegnia','sp. SAP1550');
INSERT INTO taxonomy VALUES(2430,1532674,'Saprolegnia','sp. SAP1560');
INSERT INTO taxonomy VALUES(2431,1532675,'Saprolegnia','sp. SAP1562');
INSERT INTO taxonomy VALUES(2432,1532676,'Saprolegnia','sp. SAP1563');
INSERT INTO taxonomy VALUES(2433,1532677,'Saprolegnia','sp. SAP1570');
INSERT INTO taxonomy VALUES(2434,1532678,'Saprolegnia','sp. SAP1574');
INSERT INTO taxonomy VALUES(2435,1532679,'Saprolegnia','sp. SAP1642');
INSERT INTO taxonomy VALUES(2436,1532680,'Saprolegnia','sp. SAP1693');
INSERT INTO taxonomy VALUES(2437,1532681,'Saprolegnia','sp. SAP1698');
INSERT INTO taxonomy VALUES(2438,1532682,'Saprolegnia','sp. SAP1734');
INSERT INTO taxonomy VALUES(2439,1532683,'Saprolegnia','sp. SAP1793');
INSERT INTO taxonomy VALUES(2440,1532684,'Saprolegnia','sp. SAP1823');
INSERT INTO taxonomy VALUES(2441,1532685,'Saprolegnia','sp. SAP1853');
INSERT INTO taxonomy VALUES(2442,1532686,'Saprolegnia','sp. SAP1872');
INSERT INTO taxonomy VALUES(2443,1532687,'Saprolegnia','sp. SAP1881');
INSERT INTO taxonomy VALUES(2444,1532688,'Saprolegnia','sp. SAP1938');
INSERT INTO taxonomy VALUES(2445,1532689,'Saprolegnia','sp. SAP1950');
INSERT INTO taxonomy VALUES(2446,1532690,'Saprolegnia','sp. SAP1951');
INSERT INTO taxonomy VALUES(2447,1532691,'Saprolegnia','sp. SAP1975');
INSERT INTO taxonomy VALUES(2448,1532692,'Saprolegnia','sp. SAP1979');
INSERT INTO taxonomy VALUES(2449,1532693,'Saprolegnia','sp. SAP1996');
INSERT INTO taxonomy VALUES(2450,1532694,'Saprolegnia','sp. SAP1997');
INSERT INTO taxonomy VALUES(2451,1541757,'Saprolegnia','sp. HEE-2014-1');
INSERT INTO taxonomy VALUES(2452,1546192,'Saprolegnia','sp. MNS-2014a');
INSERT INTO taxonomy VALUES(2453,1546193,'Saprolegnia','sp. MNS-2014b');
INSERT INTO taxonomy VALUES(2454,1546194,'Saprolegnia','sp. MNS-2014c');
INSERT INTO taxonomy VALUES(2455,1547590,'Achlya','sp. MNS-2014a');
INSERT INTO taxonomy VALUES(2456,1547591,'Saprolegnia','sp. MNS-2014d');
INSERT INTO taxonomy VALUES(2457,1547592,'Pythium','sp. MNS-2014a');
INSERT INTO taxonomy VALUES(2458,1547593,'Leptolegnia','sp. MNS-2014a');
INSERT INTO taxonomy VALUES(2459,1547594,'Phytopythium','sp. MNS-2014a');
INSERT INTO taxonomy VALUES(2460,1547642,'Phytophthora','sp. PNS-2014');
INSERT INTO taxonomy VALUES(2461,1564265,'Plasmopara','sphagneticolae');
INSERT INTO taxonomy VALUES(2462,1565087,'Phytophthora','taxon banihashemiana');
INSERT INTO taxonomy VALUES(2463,1567491,'Phytophthora','x serendipita');
INSERT INTO taxonomy VALUES(2464,1571765,'Phytophthora','sp. CH14NA1');
INSERT INTO taxonomy VALUES(2465,1571766,'Phytophthora','sp. CH14NB1');
INSERT INTO taxonomy VALUES(2466,1571770,'Phytophthora','sp. FS08ASP1');
INSERT INTO taxonomy VALUES(2467,1577959,'Phytophthora','moyootj');
INSERT INTO taxonomy VALUES(2468,1578581,'Pythium','sp. 1 LAC-2014');
INSERT INTO taxonomy VALUES(2469,1578582,'Pythium','sp. 2 LAC-2014');
INSERT INTO taxonomy VALUES(2470,1578583,'Pythium','sp. 3 LAC-2014');
INSERT INTO taxonomy VALUES(2471,1579205,'Brevilegnia','minutandra');
INSERT INTO taxonomy VALUES(2472,1582015,'Phytophthora','sp. Marion-2012');
INSERT INTO taxonomy VALUES(2473,1582016,'Phytophthora','cf. lacustris NJG-2014');
INSERT INTO taxonomy VALUES(2474,1588901,'Pythium','utonaiense');
INSERT INTO taxonomy VALUES(2475,1588902,'Pythium','brachiatum');
INSERT INTO taxonomy VALUES(2476,1588903,'Pythium','biforme');
INSERT INTO taxonomy VALUES(2477,1588904,'Pythium','junctum');
INSERT INTO taxonomy VALUES(2478,1588905,'Pythium','sp. SU-2014');
INSERT INTO taxonomy VALUES(2479,1593254,'Phytophthora','sp. gondwanense');
INSERT INTO taxonomy VALUES(2480,1593255,'Phytophthora','sp. boodjera');
INSERT INTO taxonomy VALUES(2481,1602131,'Phytopythium','mirpurense');
INSERT INTO taxonomy VALUES(2482,1602133,'Phytopythium','palingenes');
INSERT INTO taxonomy VALUES(2483,1602931,'Pythium','sp. UASWS1226');
INSERT INTO taxonomy VALUES(2484,1604233,'Phytophthora','sp. CJL-2014');
INSERT INTO taxonomy VALUES(2485,1617306,'Pythium','sp. hordeum');
INSERT INTO taxonomy VALUES(2486,1617996,'Aphanomyces','scaber');
INSERT INTO taxonomy VALUES(2487,1618013,'Newbya','spinosa');
INSERT INTO taxonomy VALUES(2488,1618014,'Pythiopsis','intermedia');
INSERT INTO taxonomy VALUES(2489,1618016,'Achlya','debaryana');
INSERT INTO taxonomy VALUES(2490,1618017,'Achlya','bonariensis');
INSERT INTO taxonomy VALUES(2491,1618018,'Leptolegnia','sp. LB-2015');
INSERT INTO taxonomy VALUES(2492,1618019,'Aplanes','treleaseanus');
INSERT INTO taxonomy VALUES(2493,1618020,'Newbya','dichotoma');
INSERT INTO taxonomy VALUES(2494,1628162,'Bremia','sp. YJC-2015');
INSERT INTO taxonomy VALUES(2495,1628357,'Achlya','catenulata');
INSERT INTO taxonomy VALUES(2496,1629122,'Globisporangium','barbulae');
INSERT INTO taxonomy VALUES(2497,1631664,'Haptoglossa','sp. UK');
INSERT INTO taxonomy VALUES(2498,1631665,'Albugo','lepigoni');
INSERT INTO taxonomy VALUES(2499,1631803,'Brevilegnia','longicaulis');
INSERT INTO taxonomy VALUES(2500,1632203,'Globisporangium','kandovanense');
INSERT INTO taxonomy VALUES(2501,1632271,'Basidiophora','simplex');
INSERT INTO taxonomy VALUES(2502,1632272,'Basidiophora','sp. 1 AS-2015');
INSERT INTO taxonomy VALUES(2503,1632273,'Basidiophora','sp. 2 AS-2015');
INSERT INTO taxonomy VALUES(2504,1632274,'Basidiophora','sp. 3 AS-2015');
INSERT INTO taxonomy VALUES(2505,1632275,'Basidiophora','sp. 4 AS-2015');
INSERT INTO taxonomy VALUES(2506,1632276,'Basidiophora','sp. 5 AS-2015');
INSERT INTO taxonomy VALUES(2507,1632285,'Pythium','burgundicum');
INSERT INTO taxonomy VALUES(2508,1632286,'Peronospora','sp. HV-2015');
INSERT INTO taxonomy VALUES(2509,1632297,'Peronospora','sp. 1023');
INSERT INTO taxonomy VALUES(2510,1632298,'Peronospora','sp. 1025');
INSERT INTO taxonomy VALUES(2511,1632299,'Peronospora','sp. 1029');
INSERT INTO taxonomy VALUES(2512,1632300,'Peronospora','sp. 1031');
INSERT INTO taxonomy VALUES(2513,1632301,'Peronospora','sp. 1035');
INSERT INTO taxonomy VALUES(2514,1632302,'Peronospora','sp. 1041');
INSERT INTO taxonomy VALUES(2515,1632303,'Peronospora','sp. 1042');
INSERT INTO taxonomy VALUES(2516,1632304,'Peronospora','sp. 1044');
INSERT INTO taxonomy VALUES(2517,1632305,'Peronospora','sp. 1046');
INSERT INTO taxonomy VALUES(2518,1632306,'Peronospora','sp. 1164');
INSERT INTO taxonomy VALUES(2519,1632307,'Peronospora','sp. 1165');
INSERT INTO taxonomy VALUES(2520,1632308,'Peronospora','sp. 2558');
INSERT INTO taxonomy VALUES(2521,1632309,'Peronospora','sp. 2559');
INSERT INTO taxonomy VALUES(2522,1632310,'Peronospora','sp. 2709');
INSERT INTO taxonomy VALUES(2523,1632311,'Peronospora','sp. 2710');
INSERT INTO taxonomy VALUES(2524,1632312,'Peronospora','sp. 2859');
INSERT INTO taxonomy VALUES(2525,1632313,'Peronospora','sp. BP124');
INSERT INTO taxonomy VALUES(2526,1632314,'Peronospora','sp. HV1019');
INSERT INTO taxonomy VALUES(2527,1632315,'Peronospora','sp. HV2117');
INSERT INTO taxonomy VALUES(2528,1632316,'Peronospora','sp. HV2617');
INSERT INTO taxonomy VALUES(2529,1632317,'Peronospora','sp. HV2657');
INSERT INTO taxonomy VALUES(2530,1632318,'Peronospora','sp. HV2908');
INSERT INTO taxonomy VALUES(2531,1632319,'Peronospora','sp. HV2939');
INSERT INTO taxonomy VALUES(2532,1632320,'Peronospora','sp. HV312');
INSERT INTO taxonomy VALUES(2533,1632321,'Peronospora','sp. HV507');
INSERT INTO taxonomy VALUES(2534,1632322,'Peronospora','sp. HV852');
INSERT INTO taxonomy VALUES(2535,1632323,'Peronospora','sp. S25');
INSERT INTO taxonomy VALUES(2536,1632324,'Peronospora','sp. S27');
INSERT INTO taxonomy VALUES(2537,1632325,'Peronospora','litoralis');
INSERT INTO taxonomy VALUES(2538,1632326,'Peronospora','polycarpi');
INSERT INTO taxonomy VALUES(2539,1632327,'Peronospora','atriplicis-hastatae');
INSERT INTO taxonomy VALUES(2540,1633573,'Saprolegnia','sp. 736F2');
INSERT INTO taxonomy VALUES(2541,1633574,'Saprolegnia','sp. 746F4');
INSERT INTO taxonomy VALUES(2542,1633830,'Saprolegnia','sp. 2 JVS-2015');
INSERT INTO taxonomy VALUES(2543,1633831,'Saprolegnia','sp. 1 JVS-2015');
INSERT INTO taxonomy VALUES(2544,1635159,'Pilasporangium','apinafurcum');
INSERT INTO taxonomy VALUES(2545,1638924,'Olpidiopsis','feldmanni');
INSERT INTO taxonomy VALUES(2546,1642459,'Phytophthora','agathidicida');
INSERT INTO taxonomy VALUES(2547,1642464,'Phytophthora','cocois');
INSERT INTO taxonomy VALUES(2548,1642465,'Phytophthora','castaneae');
INSERT INTO taxonomy VALUES(2549,1663100,'Anisolpidium','ectocarpii');
INSERT INTO taxonomy VALUES(2550,1663342,'Phytopythium','sp. EVC-2015');
INSERT INTO taxonomy VALUES(2551,1672054,'Blastulidium','paedophthorum');
INSERT INTO taxonomy VALUES(2552,1678641,'Pythium','sp. Ten8-1');
INSERT INTO taxonomy VALUES(2553,1678642,'Pythium','sp. Ten2');
INSERT INTO taxonomy VALUES(2554,1679947,'Peronospora','cf. fagopyri MK-2015');
INSERT INTO taxonomy VALUES(2555,1682049,'Lagenisma','coscinodisci');
INSERT INTO taxonomy VALUES(2556,1686415,'Pontisma','pyropiae');
INSERT INTO taxonomy VALUES(2557,1686789,'Saprolegnia','aenigmatica');
INSERT INTO taxonomy VALUES(2558,1686790,'Saprolegnia','racemosa');
INSERT INTO taxonomy VALUES(2559,1689812,'Phytophthora','sp. NJB-2015');
INSERT INTO taxonomy VALUES(2560,1690101,'Phytophthora','taxon totara');
INSERT INTO taxonomy VALUES(2561,1692154,'Phytophthora','chlamydospora');
INSERT INTO taxonomy VALUES(2562,1695208,'Pythium','sp. CLE-2015a');
INSERT INTO taxonomy VALUES(2563,1695209,'Pythium','sp. CLE-2015b');
INSERT INTO taxonomy VALUES(2564,1695210,'Pythium','sp. CLE-2015c');
INSERT INTO taxonomy VALUES(2565,1695211,'Pythium','sp. CLE-2015d');
INSERT INTO taxonomy VALUES(2566,1695212,'Pythium','sp. CLE-2015e');
INSERT INTO taxonomy VALUES(2567,1695213,'Pythium','sp. CLE-2015f');
INSERT INTO taxonomy VALUES(2568,1696062,'Phytophthora','ornamentata');
INSERT INTO taxonomy VALUES(2569,1696985,'Phytophthora','aff. meadii isolate Pr3');
INSERT INTO taxonomy VALUES(2570,1697476,'Baobabopsis','donbarrettii');
INSERT INTO taxonomy VALUES(2571,1697477,'Baobabopsis','enneapogonis');
INSERT INTO taxonomy VALUES(2572,1697482,'Peronosclerospora','sp. YJC-2015');
INSERT INTO taxonomy VALUES(2573,1697569,'Bremia','sp. YJC-2015b');
INSERT INTO taxonomy VALUES(2574,1698793,'Phytophthora','sp. IP-2015');
INSERT INTO taxonomy VALUES(2575,1702223,'Salilagenidium','myophilum');
INSERT INTO taxonomy VALUES(2576,1702224,'Chlamydomyzium','anomalum');
INSERT INTO taxonomy VALUES(2577,1702225,'Myzocytiopsis','humicola');
INSERT INTO taxonomy VALUES(2578,1702226,'Myzocytiopsis','lenticularis');
INSERT INTO taxonomy VALUES(2579,1702227,'Myzocytiopsis','subuliformis');
INSERT INTO taxonomy VALUES(2580,1702228,'Haptoglossa','sp. DM2 4/12');
INSERT INTO taxonomy VALUES(2581,1702229,'Haptoglossa','sp. SL20');
INSERT INTO taxonomy VALUES(2582,1702230,'Lagenidium','sp. SL23');
INSERT INTO taxonomy VALUES(2583,1702231,'Haptoglossa','sp. SL32');
INSERT INTO taxonomy VALUES(2584,1702233,'Lagenidium','sp. DAOM 242348');
INSERT INTO taxonomy VALUES(2585,1702234,'Lagenidium','sp. IMI395810');
INSERT INTO taxonomy VALUES(2586,1702235,'Lagenidium','sp. SL10');
INSERT INTO taxonomy VALUES(2587,1704119,'Phytophthora','cf. fluvialis hybrid DH117');
INSERT INTO taxonomy VALUES(2588,1704120,'Phytophthora','cf. fluvialis hybrid VHS29992');
INSERT INTO taxonomy VALUES(2589,1704121,'Phytophthora','cf. thermophila hybrid DH106');
INSERT INTO taxonomy VALUES(2590,1704122,'Phytophthora','sp. hybrid VHS2713');
INSERT INTO taxonomy VALUES(2591,1704123,'Phytophthora','moyootj x thermophila');
INSERT INTO taxonomy VALUES(2592,1704124,'Phytophthora','sp. x amnicola');
INSERT INTO taxonomy VALUES(2593,1704125,'Phytophthora','amnicola x moyootj');
INSERT INTO taxonomy VALUES(2594,1704126,'Phytophthora','moyootj x fluvialis');
INSERT INTO taxonomy VALUES(2595,1704127,'Phytophthora','fluvialis x moyootj');
INSERT INTO taxonomy VALUES(2596,1704128,'Phytophthora','moyootj x litoralis');
INSERT INTO taxonomy VALUES(2597,1704129,'Phytophthora','litoralis x moyootj');
INSERT INTO taxonomy VALUES(2598,1704130,'Phytophthora','thermophila x moyootj');
INSERT INTO taxonomy VALUES(2599,1706396,'Phytophthora','sp. PS1');
INSERT INTO taxonomy VALUES(2600,1706397,'Phytophthora','sp. PS10');
INSERT INTO taxonomy VALUES(2601,1706398,'Phytophthora','sp. PS2');
INSERT INTO taxonomy VALUES(2602,1706399,'Phytophthora','sp. PS3');
INSERT INTO taxonomy VALUES(2603,1706400,'Phytophthora','sp. PS4');
INSERT INTO taxonomy VALUES(2604,1706401,'Phytophthora','sp. PS5');
INSERT INTO taxonomy VALUES(2605,1706402,'Phytophthora','sp. PS6');
INSERT INTO taxonomy VALUES(2606,1706403,'Phytophthora','sp. PS7');
INSERT INTO taxonomy VALUES(2607,1706404,'Phytophthora','sp. PS8');
INSERT INTO taxonomy VALUES(2608,1706405,'Phytophthora','sp. PS9');
INSERT INTO taxonomy VALUES(2609,1706406,'Phytophthora','sp. SCRP1086');
INSERT INTO taxonomy VALUES(2610,1706407,'Phytophthora','sp. SCRP1087');
INSERT INTO taxonomy VALUES(2611,1706408,'Phytophthora','sp. SCRP1088');
INSERT INTO taxonomy VALUES(2612,1706409,'Phytophthora','sp. SP1');
INSERT INTO taxonomy VALUES(2613,1706410,'Phytophthora','sp. SP4');
INSERT INTO taxonomy VALUES(2614,1706411,'Phytophthora','sp. SP9');
INSERT INTO taxonomy VALUES(2615,1706412,'Phytophthora','sp. SUC605');
INSERT INTO taxonomy VALUES(2616,1706413,'Phytophthora','sp. SUC606');
INSERT INTO taxonomy VALUES(2617,1706414,'Phytophthora','sp. SUC607');
INSERT INTO taxonomy VALUES(2618,1706415,'Phytophthora','sp. SUC608');
INSERT INTO taxonomy VALUES(2619,1706416,'Phytophthora','sp. SUC614');
INSERT INTO taxonomy VALUES(2620,1706417,'Phytophthora','sp. SUC615');
INSERT INTO taxonomy VALUES(2621,1706418,'Phytophthora','sp. SUC616');
INSERT INTO taxonomy VALUES(2622,1706419,'Phytophthora','sp. SUC617');
INSERT INTO taxonomy VALUES(2623,1706420,'Phytophthora','sp. SUC619');
INSERT INTO taxonomy VALUES(2624,1706421,'Phytophthora','sp. SUC622');
INSERT INTO taxonomy VALUES(2625,1706422,'Phytophthora','sp. SUC623');
INSERT INTO taxonomy VALUES(2626,1706423,'Phytophthora','sp. SUC626');
INSERT INTO taxonomy VALUES(2627,1706424,'Phytophthora','sp. SUC627');
INSERT INTO taxonomy VALUES(2628,1706425,'Phytophthora','sp. SUC628');
INSERT INTO taxonomy VALUES(2629,1706426,'Phytophthora','sp. SUC630');
INSERT INTO taxonomy VALUES(2630,1706427,'Phytophthora','sp. SUC636');
INSERT INTO taxonomy VALUES(2631,1706428,'Phytophthora','sp. SUC641');
INSERT INTO taxonomy VALUES(2632,1706429,'Phytophthora','sp. SUC654');
INSERT INTO taxonomy VALUES(2633,1706430,'Phytophthora','sp. WAC6627');
INSERT INTO taxonomy VALUES(2634,1708770,'Phytophthora','sp. PR12-475');
INSERT INTO taxonomy VALUES(2635,1708771,'Phytophthora','sp. PR13-109');
INSERT INTO taxonomy VALUES(2636,1712660,'Peronospora','sp. Aquilegia');
INSERT INTO taxonomy VALUES(2637,1729142,'Pythium','sp. SCOR-2015');
INSERT INTO taxonomy VALUES(2638,1729143,'Achlya','orion');
INSERT INTO taxonomy VALUES(2639,1729144,'Achlya','oviparvula');
INSERT INTO taxonomy VALUES(2640,1729145,'Dictyuchus','pseudodictyon');
INSERT INTO taxonomy VALUES(2641,1729146,'Leptolegnia','eccentrica');
INSERT INTO taxonomy VALUES(2642,1729148,'Phragmosporangium','uniseriatum');
INSERT INTO taxonomy VALUES(2643,1729207,'Pythiopsis','irregularis');
INSERT INTO taxonomy VALUES(2644,1729208,'Saprolegnia','truncata');
INSERT INTO taxonomy VALUES(2645,1735753,'Pythium','sp. WL-2015');
INSERT INTO taxonomy VALUES(2646,1737462,'Phytophthora','urerae');
INSERT INTO taxonomy VALUES(2647,1747825,'Phytophthora','intercalaris');
INSERT INTO taxonomy VALUES(2648,1760867,'Pythium','sp. 8206 PARP');
INSERT INTO taxonomy VALUES(2649,1761981,'Peronospora','chlorae');
INSERT INTO taxonomy VALUES(2650,1762014,'Peronospora','statices');
INSERT INTO taxonomy VALUES(2651,1763597,'Phytopythium','sp. 1 ROH-2015');
INSERT INTO taxonomy VALUES(2652,1763598,'Phytophthora','sp. 2 ROH-2015');
INSERT INTO taxonomy VALUES(2653,1763599,'Pythium','sp. 1 ROH-2015');
INSERT INTO taxonomy VALUES(2654,1763600,'Pythium','sp. 2 ROH-2015');
INSERT INTO taxonomy VALUES(2655,1771314,'Phytopythium','sp. B57');
INSERT INTO taxonomy VALUES(2656,1771315,'Phytopythium','sp. D37');
INSERT INTO taxonomy VALUES(2657,1771316,'Phytopythium','sp. F65');
INSERT INTO taxonomy VALUES(2658,1771317,'Pythium','sp. unique1');
INSERT INTO taxonomy VALUES(2659,1771318,'Pythium','sp. unique1sub2');
INSERT INTO taxonomy VALUES(2660,1771319,'Pythium','sp. unique1sub3');
INSERT INTO taxonomy VALUES(2661,1771320,'Pythium','sp. unique2');
INSERT INTO taxonomy VALUES(2662,1771321,'Pythium','sp. unique3');
INSERT INTO taxonomy VALUES(2663,1771325,'Phytophthora','cf. inundata D0S1P25');
INSERT INTO taxonomy VALUES(2664,1771326,'Pythium','cf. deliense D2.5S2P21-2');
INSERT INTO taxonomy VALUES(2665,1771327,'Pythium','cf. periplocum 4SE010');
INSERT INTO taxonomy VALUES(2666,1771328,'Pythium','cf. porphyrae D0S3P02');
INSERT INTO taxonomy VALUES(2667,1771973,'Phytophthora','crassamura');
INSERT INTO taxonomy VALUES(2668,1785729,'Phytophthora','boodjera');
INSERT INTO taxonomy VALUES(2669,1792277,'Globisporangium','yorkense');
INSERT INTO taxonomy VALUES(2670,1792278,'Globisporangium','aff. intermedium JEB-2016');
INSERT INTO taxonomy VALUES(2671,1792279,'Elongisporangium','aff. undulatum JEB-2016');
INSERT INTO taxonomy VALUES(2672,1792280,'Pythium','sp. JEB-2016');
INSERT INTO taxonomy VALUES(2673,1798167,'Phytophthora','sp. NJB-2016a');
INSERT INTO taxonomy VALUES(2674,1798950,'Haliphthoros','sp.');
INSERT INTO taxonomy VALUES(2675,1805850,'Pythium','sp. FL-2016a');
INSERT INTO taxonomy VALUES(2676,1805851,'Pythium','sp. FL-2016b');
INSERT INTO taxonomy VALUES(2677,1805852,'Pythium','sp. FL-2016c');
INSERT INTO taxonomy VALUES(2678,1805853,'Pythium','sp. FL-2016d');
INSERT INTO taxonomy VALUES(2679,1805854,'Pythium','sp. FL-2016e');
INSERT INTO taxonomy VALUES(2680,1805855,'Pythium','sp. FL-2016f');
INSERT INTO taxonomy VALUES(2681,1805856,'Pythium','sp. FL-2016g');
INSERT INTO taxonomy VALUES(2682,1805857,'Pythium','sp. FL-2016h');
INSERT INTO taxonomy VALUES(2683,1805858,'Pythium','sp. FL-2016i');
INSERT INTO taxonomy VALUES(2684,1805859,'Pythium','sp. FL-2016j');
INSERT INTO taxonomy VALUES(2685,1805860,'Pythium','sp. FL-2016k');
INSERT INTO taxonomy VALUES(2686,1805861,'Pythium','sp. FL-2016l');
INSERT INTO taxonomy VALUES(2687,1805864,'Phytophthora','sp. P8071');
INSERT INTO taxonomy VALUES(2688,1805865,'Phytophthora','sp. P8057');
INSERT INTO taxonomy VALUES(2689,1805866,'Phytophthora','sp. P9105');
INSERT INTO taxonomy VALUES(2690,1805867,'Phytophthora','sp. P8056');
INSERT INTO taxonomy VALUES(2691,1805868,'Phytophthora','sp. P9151');
INSERT INTO taxonomy VALUES(2692,1805869,'Phytophthora','sp. N9022');
INSERT INTO taxonomy VALUES(2693,1805870,'Phytophthora','sp. P8096');
INSERT INTO taxonomy VALUES(2694,1805871,'Phytophthora','sp. P8012');
INSERT INTO taxonomy VALUES(2695,1805872,'Phytophthora','sp. P8085');
INSERT INTO taxonomy VALUES(2696,1805873,'Phytophthora','sp. P8050');
INSERT INTO taxonomy VALUES(2697,1805874,'Phytophthora','sp. P8088');
INSERT INTO taxonomy VALUES(2698,1805875,'Phytophthora','sp. N9036');
INSERT INTO taxonomy VALUES(2699,1805876,'Phytophthora','sp. P9104');
INSERT INTO taxonomy VALUES(2700,1805877,'Phytophthora','sp. N9035');
INSERT INTO taxonomy VALUES(2701,1805878,'Phytophthora','sp. P8072');
INSERT INTO taxonomy VALUES(2702,1805879,'Phytophthora','sp. N9071');
INSERT INTO taxonomy VALUES(2703,1805880,'Phytophthora','sp. P8074');
INSERT INTO taxonomy VALUES(2704,1805881,'Phytophthora','sp. P9144');
INSERT INTO taxonomy VALUES(2705,1805882,'Phytophthora','sp. N9041');
INSERT INTO taxonomy VALUES(2706,1805883,'Phytophthora','sp. N9012');
INSERT INTO taxonomy VALUES(2707,1805884,'Phytophthora','sp. N9029');
INSERT INTO taxonomy VALUES(2708,1805885,'Phytophthora','sp. N9010');
INSERT INTO taxonomy VALUES(2709,1805886,'Phytophthora','sp. P9148');
INSERT INTO taxonomy VALUES(2710,1805887,'Phytophthora','sp. P9127');
INSERT INTO taxonomy VALUES(2711,1805888,'Phytophthora','sp. N9042');
INSERT INTO taxonomy VALUES(2712,1806582,'Phytophthora','aff. meadii AdP-2013');
INSERT INTO taxonomy VALUES(2713,1806948,'Phytophthora','sp. AL78');
INSERT INTO taxonomy VALUES(2714,1817409,'Peronospora','sp. BPI893224');
INSERT INTO taxonomy VALUES(2715,1821206,'Phytophthora','pseudocryptogea');
INSERT INTO taxonomy VALUES(2716,1825568,'Plasmopara','australis');
INSERT INTO taxonomy VALUES(2717,1833877,'Phytophthora','versiformis');
INSERT INTO taxonomy VALUES(2718,1844468,'Halophytophthora','sp. Zostera');
INSERT INTO taxonomy VALUES(2719,1846162,'Haliphthoros','sp. IPMB 1402');
INSERT INTO taxonomy VALUES(2720,1847781,'Pythium','sp. HT2-5');
INSERT INTO taxonomy VALUES(2721,1852271,'Pythium','sp. 1 PV-2016');
INSERT INTO taxonomy VALUES(2722,1852272,'Pythium','sp. 2 PV-2016');
INSERT INTO taxonomy VALUES(2723,1855969,'Peronospora','agrimoniae');
INSERT INTO taxonomy VALUES(2724,1857252,'Phytophthora','chesapeakensis');
INSERT INTO taxonomy VALUES(2725,1857766,'Phytophthora','aff. meadii');
INSERT INTO taxonomy VALUES(2726,1861792,'Salispina','intermedia');
INSERT INTO taxonomy VALUES(2727,1861846,'Phytophthora','attenuata');
INSERT INTO taxonomy VALUES(2728,1861847,'Phytophthora','x heterohybrida');
INSERT INTO taxonomy VALUES(2729,1861848,'Phytophthora','sp. forestsoil-like');
INSERT INTO taxonomy VALUES(2730,1861849,'Phytophthora','sp. occultans-like');
INSERT INTO taxonomy VALUES(2731,1861850,'Phytophthora','sp. x Kunnunara-like');
INSERT INTO taxonomy VALUES(2732,1861851,'Phytophthora','sp. x botryosa-like');
INSERT INTO taxonomy VALUES(2733,1861852,'Phytophthora','sp. x insolita-like');
INSERT INTO taxonomy VALUES(2734,1861853,'Phytophthora','sp. x meadii-like');
INSERT INTO taxonomy VALUES(2735,1861854,'Phytophthora','sp. x virginiana-like-1');
INSERT INTO taxonomy VALUES(2736,1861855,'Phytophthora','sp. x virginiana-like-2');
INSERT INTO taxonomy VALUES(2737,1861856,'Phytophthora','sp. x virginiana-like-3');
INSERT INTO taxonomy VALUES(2738,1861857,'Phytophthora','formosana');
INSERT INTO taxonomy VALUES(2739,1861858,'Phytophthora','x incrassata');
INSERT INTO taxonomy VALUES(2740,1861859,'Phytophthora','flexuosa');
INSERT INTO taxonomy VALUES(2741,1861860,'Phytophthora','intricata');
INSERT INTO taxonomy VALUES(2742,1862603,'Phytophthora','rhizophorae');
INSERT INTO taxonomy VALUES(2743,1862604,'Phytophthora','estuarina');
INSERT INTO taxonomy VALUES(2744,1862976,'Saprolegnia','sp.');
INSERT INTO taxonomy VALUES(2745,1862977,'Pythium','sp.');
INSERT INTO taxonomy VALUES(2746,1868015,'Phytophthora','sp. bitahaiensis');
INSERT INTO taxonomy VALUES(2747,1868016,'Phytophthora','sp. nixiensis');
INSERT INTO taxonomy VALUES(2748,1869342,'Peronospora','mesembryanthemi');
INSERT INTO taxonomy VALUES(2749,1871600,'Phytophthora','sp. Chile5');
INSERT INTO taxonomy VALUES(2750,1873451,'Saprolegnia','milanezii');
INSERT INTO taxonomy VALUES(2751,1880901,'Phytophthora','bishii');
INSERT INTO taxonomy VALUES(2752,1882210,'Pythium','cedri');
INSERT INTO taxonomy VALUES(2753,1884448,'Lagenidium','juracyae');
INSERT INTO taxonomy VALUES(2754,1889812,'Phytophthora','sp. MFM-2016a');
INSERT INTO taxonomy VALUES(2755,1891364,'Peronosclerospora','sargae');
INSERT INTO taxonomy VALUES(2756,1891365,'Peronosclerospora','australiensis');
INSERT INTO taxonomy VALUES(2757,1891640,'Pythium','sp. ASR17');
INSERT INTO taxonomy VALUES(2758,1891641,'Pythium','sp. SR33');
INSERT INTO taxonomy VALUES(2759,1891642,'Pythium','sp. SR36');
INSERT INTO taxonomy VALUES(2760,1897510,'Phytopythium','sp.');
INSERT INTO taxonomy VALUES(2761,1897522,'Pythiogeton','sp.');
INSERT INTO taxonomy VALUES(2762,1903600,'Globisporangium','ershadii');
INSERT INTO taxonomy VALUES(2763,1903601,'Globisporangium','pyrioosporum');
INSERT INTO taxonomy VALUES(2764,1903602,'Globisporangium','urmianum');
INSERT INTO taxonomy VALUES(2765,1904033,'Halophytophthora','sp.');
INSERT INTO taxonomy VALUES(2766,1909805,'Pustula','junggarensis');
INSERT INTO taxonomy VALUES(2767,1910894,'Peronospora','aconiti');
INSERT INTO taxonomy VALUES(2768,1913598,'Phytophthora','formosa');
INSERT INTO taxonomy VALUES(2769,1926936,'Anisolpidium','rosenvingei');
INSERT INTO taxonomy VALUES(2770,1935391,'Hyaloperonospora','sp.');
INSERT INTO taxonomy VALUES(2771,1935936,'Globisporangium','lacustre');
INSERT INTO taxonomy VALUES(2772,1938505,'Phytopythium','sp. ''sterile''');
INSERT INTO taxonomy VALUES(2773,1938515,'Pythium','heteroogonium');
INSERT INTO taxonomy VALUES(2774,1938516,'Pythium','sp. ''kamfiruzense''');
INSERT INTO taxonomy VALUES(2775,1938517,'Pythium','longipapillum');
INSERT INTO taxonomy VALUES(2776,1938518,'Pythium','oryzicollum');
INSERT INTO taxonomy VALUES(2777,1938519,'Pythium','sp. 1 HM-2017');
INSERT INTO taxonomy VALUES(2778,1938520,'Pythium','sp. 2 HM-2017');
INSERT INTO taxonomy VALUES(2779,1940654,'Paralagenidium','sp. MTLA-26');
INSERT INTO taxonomy VALUES(2780,1945754,'Peronospora','cf. ducometii');
INSERT INTO taxonomy VALUES(2781,1955676,'Globisporangium','oryzicola');
INSERT INTO taxonomy VALUES(2782,1971756,'Calycofera','operculata');
INSERT INTO taxonomy VALUES(2783,1971757,'Calycofera','cryptica');
INSERT INTO taxonomy VALUES(2784,1972064,'Pontisma','[Olpidiopsis] porphyrae var. koreanae (nom. inval.)');
INSERT INTO taxonomy VALUES(2785,1972065,'Pythium','sp. OPU810');
INSERT INTO taxonomy VALUES(2786,1972066,'Pythium','sp. OPU811');
INSERT INTO taxonomy VALUES(2787,1972067,'Pythium','sp. OPU812');
INSERT INTO taxonomy VALUES(2788,1980703,'Halophytophthora','sp. GHJ-2017a');
INSERT INTO taxonomy VALUES(2789,1980704,'Halophytophthora','sp. GHJ-2017b');
INSERT INTO taxonomy VALUES(2790,1980705,'Plectospira','gemmifera');
INSERT INTO taxonomy VALUES(2791,1982524,'Aphanomyces','sp.');
INSERT INTO taxonomy VALUES(2792,1982665,'Peronospora','sp.');
INSERT INTO taxonomy VALUES(2793,1985165,'Phytophthora','castanetorum');
INSERT INTO taxonomy VALUES(2794,1985166,'Phytophthora','tubulina');
INSERT INTO taxonomy VALUES(2795,1985167,'Phytophthora','tyrrhenica');
INSERT INTO taxonomy VALUES(2796,1985168,'Phytophthora','vulcanica');
INSERT INTO taxonomy VALUES(2797,2013512,'Sclerophthora','sp.');
INSERT INTO taxonomy VALUES(2798,2014980,'Phytopythium','leanoi');
INSERT INTO taxonomy VALUES(2799,2014981,'Phytopythium','dogmae');
INSERT INTO taxonomy VALUES(2800,2017131,'Phytopythium','sp. SL-2017a');
INSERT INTO taxonomy VALUES(2801,2017132,'Phytopythium','sp. UZ612');
INSERT INTO taxonomy VALUES(2802,2017134,'Phytophthora','aff. capsici');
INSERT INTO taxonomy VALUES(2803,2017135,'Phytophthora','aff. cichorii');
INSERT INTO taxonomy VALUES(2804,2017136,'Phytophthora','aff. citrophthora');
INSERT INTO taxonomy VALUES(2805,2017137,'Phytophthora','aff. cryptogea');
INSERT INTO taxonomy VALUES(2806,2017138,'Phytophthora','aff. dauci');
INSERT INTO taxonomy VALUES(2807,2017139,'Phytophthora','aff. erythroseptica');
INSERT INTO taxonomy VALUES(2808,2017140,'Phytophthora','aff. hedraiandra');
INSERT INTO taxonomy VALUES(2809,2017141,'Phytophthora','aff. himalsilva');
INSERT INTO taxonomy VALUES(2810,2017142,'Phytophthora','aff. parsiana');
INSERT INTO taxonomy VALUES(2811,2017143,'Phytophthora','aff. pseudotsugae');
INSERT INTO taxonomy VALUES(2812,2017144,'Phytophthora','gondwanensis');
INSERT INTO taxonomy VALUES(2813,2017540,'Pilasporangium','sp.');
INSERT INTO taxonomy VALUES(2814,2019373,'Plasmopara','velutina');
INSERT INTO taxonomy VALUES(2815,2019374,'Plasmopara','destructor');
INSERT INTO taxonomy VALUES(2816,2020009,'Pontisma','muelleri');
INSERT INTO taxonomy VALUES(2817,2020010,'Pontisma','palmariae');
INSERT INTO taxonomy VALUES(2818,2020011,'Pontisma','[Olpidiopsis] porphyrae var. scotiae (nom. inval.)');
INSERT INTO taxonomy VALUES(2819,2022663,'Phytophthora','sp. SKS-2017');
INSERT INTO taxonomy VALUES(2820,2022871,'Phytophthora','sp. AUS-10A');
INSERT INTO taxonomy VALUES(2821,2022872,'Phytophthora','sp. AUS-1A');
INSERT INTO taxonomy VALUES(2822,2022873,'Phytophthora','sp. AUS-1B');
INSERT INTO taxonomy VALUES(2823,2022874,'Phytophthora','sp. AUS-1C');
INSERT INTO taxonomy VALUES(2824,2022875,'Phytophthora','sp. AUS-1D');
INSERT INTO taxonomy VALUES(2825,2022876,'Phytophthora','sp. AUS-2A');
INSERT INTO taxonomy VALUES(2826,2022877,'Phytophthora','sp. AUS-2B');
INSERT INTO taxonomy VALUES(2827,2022878,'Phytophthora','sp. AUS-3A');
INSERT INTO taxonomy VALUES(2828,2022879,'Phytophthora','sp. AUS-5A');
INSERT INTO taxonomy VALUES(2829,2022880,'Phytophthora','sp. AUS-6A');
INSERT INTO taxonomy VALUES(2830,2022881,'Phytophthora','sp. AUS-6B');
INSERT INTO taxonomy VALUES(2831,2022882,'Phytophthora','sp. AUS-6C');
INSERT INTO taxonomy VALUES(2832,2022883,'Phytophthora','sp. AUS-8A');
INSERT INTO taxonomy VALUES(2833,2022884,'Phytophthora','sp. AUS-8B');
INSERT INTO taxonomy VALUES(2834,2022885,'Phytophthora','sp. AUS-8C');
INSERT INTO taxonomy VALUES(2835,2022886,'Phytophthora','sp. AUS-9A');
INSERT INTO taxonomy VALUES(2836,2022887,'Phytophthora','sp. AUS-9B');
INSERT INTO taxonomy VALUES(2837,2022888,'Phytophthora','sp. AUS-9C');
INSERT INTO taxonomy VALUES(2838,2022889,'Phytophthora','sp. AUS-9D');
INSERT INTO taxonomy VALUES(2839,2022890,'Phytophthora','sp. AUS-9E');
INSERT INTO taxonomy VALUES(2840,2023236,'Phytophthora','aff. citricola');
INSERT INTO taxonomy VALUES(2841,2025988,'Nothophytophthora','amphigynosa');
INSERT INTO taxonomy VALUES(2842,2025989,'Nothophytophthora','caduca');
INSERT INTO taxonomy VALUES(2843,2025990,'Nothophytophthora','chlamydospora');
INSERT INTO taxonomy VALUES(2844,2025991,'Nothophytophthora','intricata');
INSERT INTO taxonomy VALUES(2845,2025992,'Nothophytophthora','valdiviana');
INSERT INTO taxonomy VALUES(2846,2025993,'Nothophytophthora','vietnamensis');
INSERT INTO taxonomy VALUES(2847,2028483,'Peronospora','aff. claytoniae');
INSERT INTO taxonomy VALUES(2848,2028484,'Perofascia','sp.');
INSERT INTO taxonomy VALUES(2849,2028485,'Peronospora','cf. viciae');
INSERT INTO taxonomy VALUES(2850,2036925,'Phytopythium','sp. AQ-2017a');
INSERT INTO taxonomy VALUES(2851,2039707,'Achlya','sp. (in: Oomycetes)');
INSERT INTO taxonomy VALUES(2852,2044929,'Globisporangium','iranense');
INSERT INTO taxonomy VALUES(2853,2044930,'Globisporangium','monoclinum');
INSERT INTO taxonomy VALUES(2854,2044931,'Pythium','sp. M-2017c');
INSERT INTO taxonomy VALUES(2855,2047754,'Pontisma','heterosiphoniae');
INSERT INTO taxonomy VALUES(2856,2051935,'Salispina','sp.');
INSERT INTO taxonomy VALUES(2857,2052682,'Globisporangium','ultimum');
INSERT INTO taxonomy VALUES(2858,2054050,'Phytophthora','balyanboodja');
INSERT INTO taxonomy VALUES(2859,2054051,'Phytophthora','condilina');
INSERT INTO taxonomy VALUES(2860,2054052,'Phytophthora','cooljarloo');
INSERT INTO taxonomy VALUES(2861,2054053,'Phytophthora','kwongonina');
INSERT INTO taxonomy VALUES(2862,2054054,'Phytophthora','pseudorosacearum');
INSERT INTO taxonomy VALUES(2863,2056922,'Phytophthora','x cambivora');
INSERT INTO taxonomy VALUES(2864,2056924,'Pythium','rishiriense');
INSERT INTO taxonomy VALUES(2865,2056925,'Globisporangium','alternatum');
INSERT INTO taxonomy VALUES(2866,2057904,'Peronospora','pseudostellariae');
INSERT INTO taxonomy VALUES(2867,2057905,'Peronospora','stellariae-aquaticae');
INSERT INTO taxonomy VALUES(2868,2057906,'Peronospora','stellariae-uliginosae');
INSERT INTO taxonomy VALUES(2869,2057907,'Hyaloperonospora','arabidis-glabrae');
INSERT INTO taxonomy VALUES(2870,2057908,'Hyaloperonospora','nasturtii-montanii');
INSERT INTO taxonomy VALUES(2871,2057909,'Hyaloperonospora','nasturtii-palustris');
INSERT INTO taxonomy VALUES(2872,2060693,'Phytophthora','sp. ''cadmea''');
INSERT INTO taxonomy VALUES(2873,2060695,'Phytophthora','sp. ''juncus''');
INSERT INTO taxonomy VALUES(2874,2064827,'Phytophthora','aff. syringae');
INSERT INTO taxonomy VALUES(2875,2064828,'Phytophthora','sp. ''aureomontensis''');
INSERT INTO taxonomy VALUES(2876,2065305,'Phytophthora','humicola x inundata');
INSERT INTO taxonomy VALUES(2877,2065306,'Phytophthora','cf. megasperma');
INSERT INTO taxonomy VALUES(2878,2065307,'Phytophthora','cf. parsiana');
INSERT INTO taxonomy VALUES(2879,2065309,'Phytophthora','taxon juncus');
INSERT INTO taxonomy VALUES(2880,2065310,'Phytophthora','sp. ''guadalupesoil''');
INSERT INTO taxonomy VALUES(2881,2067969,'Phytophthora','sp. LS-2018');
INSERT INTO taxonomy VALUES(2882,2069634,'Pustula','cancriniae');
INSERT INTO taxonomy VALUES(2883,2069635,'Pustula','xinyuanensis');
INSERT INTO taxonomy VALUES(2884,2077275,'Phytophthora','pseudolactucae');
INSERT INTO taxonomy VALUES(2885,2077276,'Phytophthora','lilii');
INSERT INTO taxonomy VALUES(2886,2093902,'Paralagenidium','sp. 1391');
INSERT INTO taxonomy VALUES(2887,2107226,'Phytophthora','oleae');
INSERT INTO taxonomy VALUES(2888,2108448,'Pythium','cf. salpingophorum/conidiophorum');
INSERT INTO taxonomy VALUES(2889,2116650,'Phytophthora','sp. ''mugwort''');
INSERT INTO taxonomy VALUES(2890,2125992,'Globisporangium','acanthophoron');
INSERT INTO taxonomy VALUES(2891,2125993,'Globisporangium','sp. MA-2018a');
INSERT INTO taxonomy VALUES(2892,2125994,'Globisporangium','orthogonon');
INSERT INTO taxonomy VALUES(2893,2125995,'Globisporangium','paroecandrum');
INSERT INTO taxonomy VALUES(2894,2125998,'Globisporangium','spinosum');
INSERT INTO taxonomy VALUES(2895,2126261,'Phytophthora','sp. LS-2018a');
INSERT INTO taxonomy VALUES(2896,2126262,'Phytophthora','sp. LS-2018b');
INSERT INTO taxonomy VALUES(2897,2126263,'Phytophthora','sp. LS-2018c');
INSERT INTO taxonomy VALUES(2898,2126763,'Hyaloperonospora','erucae');
INSERT INTO taxonomy VALUES(2899,2126764,'Peronospora','erucastri');
INSERT INTO taxonomy VALUES(2900,2136986,'Leptolegnia','sp. BS1');
INSERT INTO taxonomy VALUES(2901,2136987,'Leptolegnia','sp. BS11');
INSERT INTO taxonomy VALUES(2902,2136988,'Leptolegnia','sp. BS13');
INSERT INTO taxonomy VALUES(2903,2136989,'Leptolegnia','sp. BS14');
INSERT INTO taxonomy VALUES(2904,2136990,'Leptolegnia','sp. BS16');
INSERT INTO taxonomy VALUES(2905,2136991,'Leptolegnia','sp. BS6');
INSERT INTO taxonomy VALUES(2906,2136992,'Leptolegnia','sp. BS8');
INSERT INTO taxonomy VALUES(2907,2136993,'Saprolegnia','sp. BF1');
INSERT INTO taxonomy VALUES(2908,2136994,'Saprolegnia','sp. BMF11');
INSERT INTO taxonomy VALUES(2909,2136995,'Saprolegnia','sp. BMF12');
INSERT INTO taxonomy VALUES(2910,2136996,'Saprolegnia','sp. BMF13');
INSERT INTO taxonomy VALUES(2911,2136997,'Saprolegnia','sp. BMF15');
INSERT INTO taxonomy VALUES(2912,2136998,'Saprolegnia','sp. BMF16');
INSERT INTO taxonomy VALUES(2913,2136999,'Saprolegnia','sp. BMF19');
INSERT INTO taxonomy VALUES(2914,2137000,'Saprolegnia','sp. BMF3');
INSERT INTO taxonomy VALUES(2915,2137001,'Saprolegnia','sp. BMF4');
INSERT INTO taxonomy VALUES(2916,2137002,'Saprolegnia','sp. BMF5');
INSERT INTO taxonomy VALUES(2917,2137003,'Saprolegnia','sp. BMF6');
INSERT INTO taxonomy VALUES(2918,2137004,'Saprolegnia','sp. BMF7');
INSERT INTO taxonomy VALUES(2919,2137005,'Saprolegnia','sp. BMF8');
INSERT INTO taxonomy VALUES(2920,2137006,'Saprolegnia','sp. BMF9');
INSERT INTO taxonomy VALUES(2921,2137007,'Saprolegnia','sp. BMS11');
INSERT INTO taxonomy VALUES(2922,2137008,'Saprolegnia','sp. BMS14');
INSERT INTO taxonomy VALUES(2923,2137009,'Achlya','sp. BMS8');
INSERT INTO taxonomy VALUES(2924,2137010,'Achlya','sp. BMS1');
INSERT INTO taxonomy VALUES(2925,2137011,'Achlya','sp. BMF1');
INSERT INTO taxonomy VALUES(2926,2153462,'Phytophthora','cf. citricola/pini');
INSERT INTO taxonomy VALUES(2927,2153463,'Phytophthora','cf. niederhauseri');
INSERT INTO taxonomy VALUES(2928,2153465,'Phytophthora','sp. ''x 4''');
INSERT INTO taxonomy VALUES(2929,2153495,'Phytophthora','sp. neb 1543');
INSERT INTO taxonomy VALUES(2930,2169586,'Pseudoperonospora','sp.');
INSERT INTO taxonomy VALUES(2931,2174906,'Aphanomyces','fennicus');
INSERT INTO taxonomy VALUES(2932,2175193,'Pythium','aff. pachycaule');
INSERT INTO taxonomy VALUES(2933,2182428,'Crypticola','clavulifera');
INSERT INTO taxonomy VALUES(2934,2202004,'Dictyuchus','sp. 1 HM-2018');
INSERT INTO taxonomy VALUES(2935,2202005,'Dictyuchus','sp. 2 HM-2018');
INSERT INTO taxonomy VALUES(2936,2202006,'Dictyuchus','sp. 3 HM-2018');
INSERT INTO taxonomy VALUES(2937,2202007,'Dictyuchus','sp. 4 HM-2018');
INSERT INTO taxonomy VALUES(2938,2202008,'Dictyuchus','sp. 5 HM-2018');
INSERT INTO taxonomy VALUES(2939,2202009,'Dictyuchus','sp. 6 HM-2018');
INSERT INTO taxonomy VALUES(2940,2202010,'Dictyuchus','sp. 7 HM-2018');
INSERT INTO taxonomy VALUES(2941,2202011,'Dictyuchus','sp. 8 HM-2018');
INSERT INTO taxonomy VALUES(2942,2202155,'Paralagenidium','sp.');
INSERT INTO taxonomy VALUES(2943,2203297,'Achlya','sp. 1 HM-2018');
INSERT INTO taxonomy VALUES(2944,2203415,'Albugo','tropica');
INSERT INTO taxonomy VALUES(2945,2203424,'Diatomophthora','drebesii');
INSERT INTO taxonomy VALUES(2946,2203427,'Miracula','helgolandica');
INSERT INTO taxonomy VALUES(2947,2249429,'Phytophthora','sp. WM-2018a');
INSERT INTO taxonomy VALUES(2948,2268959,'Saprolegnia','maragheica');
INSERT INTO taxonomy VALUES(2949,2292440,'Phytopythium','sp. 1 JJC-2018');
INSERT INTO taxonomy VALUES(2950,2305843,'Phytophthora','oreophila');
INSERT INTO taxonomy VALUES(2951,2305844,'Phytophthora','cacuminis');
INSERT INTO taxonomy VALUES(2952,2305847,'Achlya','sp. 2 HM-2018');
INSERT INTO taxonomy VALUES(2953,2305848,'Brevilegnia','sp.');
INSERT INTO taxonomy VALUES(2954,2306272,'Dictyuchus','sp. 10 HM-2018');
INSERT INTO taxonomy VALUES(2955,2306273,'Dictyuchus','sp. 11 HM-2018');
INSERT INTO taxonomy VALUES(2956,2306274,'Dictyuchus','sp. 12 HM-2018');
INSERT INTO taxonomy VALUES(2957,2306275,'Dictyuchus','sp. 13 HM-2018');
INSERT INTO taxonomy VALUES(2958,2306276,'Dictyuchus','sp. 14 HM-2018');
INSERT INTO taxonomy VALUES(2959,2306277,'Dictyuchus','sp. 9 HM-2018');
INSERT INTO taxonomy VALUES(2960,2306489,'Basidiophora','sp.');
INSERT INTO taxonomy VALUES(2961,2306943,'Pythiopsis','sp. JVS-2018a');
INSERT INTO taxonomy VALUES(2962,2306945,'Albugo','arenosa');
INSERT INTO taxonomy VALUES(2963,2358452,'Lagenidium','sp.');
INSERT INTO taxonomy VALUES(2964,2358464,'Diatomophthora','gillii');
INSERT INTO taxonomy VALUES(2965,2483409,'Nothophytophthora','sp. Chile5');
INSERT INTO taxonomy VALUES(2966,2487002,'Pythium','sp. 1 JJC-2018');
INSERT INTO taxonomy VALUES(2967,2487003,'Pythium','sp. 2 JJC-2018');
INSERT INTO taxonomy VALUES(2968,2487004,'Pythium','sp. 3 JJC-2018');
INSERT INTO taxonomy VALUES(2969,2487005,'Pythium','sp. 4 JJC-2018');
INSERT INTO taxonomy VALUES(2970,2487006,'Pythium','sp. 5 JJC-2018');
INSERT INTO taxonomy VALUES(2971,2487435,'Lagenidium','sp. SLG-2014d');
INSERT INTO taxonomy VALUES(2972,2487436,'Pontisma','bostrychiae');
INSERT INTO taxonomy VALUES(2973,2487437,'Pythium','sp. CFJS-2018a');
INSERT INTO taxonomy VALUES(2974,2488101,'Phytophthora','abietivora');
INSERT INTO taxonomy VALUES(2975,2492455,'Miracula','moenusica');
INSERT INTO taxonomy VALUES(2976,2494378,'Olpidiopsis','saprolegniae');
INSERT INTO taxonomy VALUES(2977,2494383,'Ectrogella','bacillariacearum');
INSERT INTO taxonomy VALUES(2978,2494385,'Pontisma','lagenidioides');
INSERT INTO taxonomy VALUES(2979,2496075,'Phytophthora','aleatoria');
INSERT INTO taxonomy VALUES(2980,2506486,'Pythium','subutonaiense');
INSERT INTO taxonomy VALUES(2981,2507044,'Dictyuchus','sp.');
INSERT INTO taxonomy VALUES(2982,2507514,'Bremia','itoana');
INSERT INTO taxonomy VALUES(2983,2509893,'Pythium','sp. FS-2019a');
INSERT INTO taxonomy VALUES(2984,2509894,'Pythium','sp. FS-2019b');
INSERT INTO taxonomy VALUES(2985,2509895,'Pythium','sp. FS-2019c');
INSERT INTO taxonomy VALUES(2986,2517218,'Paralagenidium','ajellopsis');
INSERT INTO taxonomy VALUES(2987,2518591,'Aphanomyces','raphani');
INSERT INTO taxonomy VALUES(2988,2546172,'Olpidiopsis','parthenogenetica');
INSERT INTO taxonomy VALUES(2989,2559589,'Phytophthora','sp. MK-2019a');
INSERT INTO taxonomy VALUES(2990,2562512,'Bremia','sp.');
INSERT INTO taxonomy VALUES(2991,2562513,'Bremia','cf. cirsii');
INSERT INTO taxonomy VALUES(2992,2575701,'Phytophthora','chlamydospora x amnicola');
INSERT INTO taxonomy VALUES(2993,2575762,'Plasmopara','elegantissima');
INSERT INTO taxonomy VALUES(2994,2579937,'Phytophthora','cf. citricola');
INSERT INTO taxonomy VALUES(2995,2583024,'Peronospora','sp. YGC-2019');
INSERT INTO taxonomy VALUES(2996,2583025,'Peronospora','ranunculi-sardoi');
INSERT INTO taxonomy VALUES(2997,2584052,'Periplasma','isogametum');
INSERT INTO taxonomy VALUES(2998,2603265,'Pythium','aff. attrantheridum');
INSERT INTO taxonomy VALUES(2999,2603266,'Globisporangium','aff. cederbergense');
INSERT INTO taxonomy VALUES(3000,2603267,'Globisporangium','aff. rostratum');
INSERT INTO taxonomy VALUES(3001,2603268,'Elongisporangium','aff. undulatum');
INSERT INTO taxonomy VALUES(3002,2603534,'Peronospora','salviae-officinalis');
INSERT INTO taxonomy VALUES(3003,2606568,'Phytophthora','cathayensis');
INSERT INTO taxonomy VALUES(3004,2610823,'Phytophthora','sp. 1 NS-2019');
INSERT INTO taxonomy VALUES(3005,2610824,'Pythium','sp. 1 NS-2019');
INSERT INTO taxonomy VALUES(3006,2610825,'Pythium','sp. 10 NS-2019');
INSERT INTO taxonomy VALUES(3007,2610826,'Pythium','sp. 11 NS-2019');
INSERT INTO taxonomy VALUES(3008,2610827,'Pythium','sp. 12 NS-2019');
INSERT INTO taxonomy VALUES(3009,2610828,'Pythium','sp. 13 NS-2019');
INSERT INTO taxonomy VALUES(3010,2610829,'Pythium','sp. 14 NS-2019');
INSERT INTO taxonomy VALUES(3011,2610830,'Pythium','sp. 2 NS-2019');
INSERT INTO taxonomy VALUES(3012,2610831,'Pythium','sp. 3 NS-2019');
INSERT INTO taxonomy VALUES(3013,2610832,'Pythium','sp. 4 NS-2019');
INSERT INTO taxonomy VALUES(3014,2610833,'Pythium','sp. 5 NS-2019');
INSERT INTO taxonomy VALUES(3015,2610834,'Pythium','sp. 6 NS-2019');
INSERT INTO taxonomy VALUES(3016,2610835,'Pythium','sp. 7 NS-2019');
INSERT INTO taxonomy VALUES(3017,2610836,'Pythium','sp. 8 NS-2019');
INSERT INTO taxonomy VALUES(3018,2610837,'Pythium','sp. 9 NS-2019');
INSERT INTO taxonomy VALUES(3019,2651250,'Phytophthora','sp. ''hedraiandra-related1''');
INSERT INTO taxonomy VALUES(3020,2651251,'Phytophthora','sp. ''hedraiandra-related2''');
INSERT INTO taxonomy VALUES(3021,2651252,'Phytophthora','aff. megasperma');
INSERT INTO taxonomy VALUES(3022,2651253,'Phytophthora','niederhauseri');
INSERT INTO taxonomy VALUES(3023,2651254,'Phytophthora','aff. niederhauseri');
INSERT INTO taxonomy VALUES(3024,2651255,'Phytophthora','aff. porri x sp. ''parsley''');
INSERT INTO taxonomy VALUES(3025,2651256,'Phytophthora','pseudocryptogea x sp kelmania');
INSERT INTO taxonomy VALUES(3026,2651258,'Phytophthora','aff. pseudocryptogea');
INSERT INTO taxonomy VALUES(3027,2651259,'Phytophthora','sp. ''novaeguineae''');
INSERT INTO taxonomy VALUES(3028,2651260,'Phytophthora','sp. ''Peru4-related''');
INSERT INTO taxonomy VALUES(3029,2651261,'Phytophthora','sp. ''x Hennops-related''');
INSERT INTO taxonomy VALUES(3030,2651262,'Phytophthora','aff. attenuata');
INSERT INTO taxonomy VALUES(3031,2651263,'Phytophthora','aff. cambivora');
INSERT INTO taxonomy VALUES(3032,2651264,'Phytophthora','sp. ''citrophthora 1 KP-2019''');
INSERT INTO taxonomy VALUES(3033,2651265,'Phytophthora','sp. ''citrophthora 2 KP-2019''');
INSERT INTO taxonomy VALUES(3034,2651266,'Phytophthora','sp. ''citrophthora-related1''');
INSERT INTO taxonomy VALUES(3035,2651267,'Phytophthora','sp. ''citrophthora-related2''');
INSERT INTO taxonomy VALUES(3036,2651268,'Phytophthora','aff. heterohybrida');
INSERT INTO taxonomy VALUES(3037,2651269,'Phytophthora','niederhauseri x aff. asparagi');
INSERT INTO taxonomy VALUES(3038,2651270,'Phytophthora','occultans x aff. citrophthora');
INSERT INTO taxonomy VALUES(3039,2651271,'Phytophthora','hedraiandra x sp. ''hedraiandra 1-KP-2019''');
INSERT INTO taxonomy VALUES(3040,2651289,'Phytophthora','amnicola x chlamydospora');
INSERT INTO taxonomy VALUES(3041,2651290,'Phytophthora','aff. boehmeriae');
INSERT INTO taxonomy VALUES(3042,2651291,'Phytophthora','chlamydospora x lacustris');
INSERT INTO taxonomy VALUES(3043,2651292,'Phytophthora','cactorum x aff. hedraiandra');
INSERT INTO taxonomy VALUES(3044,2662415,'Saprolegnia','sp. 14');
INSERT INTO taxonomy VALUES(3045,2662416,'Saprolegnia','sp. 06');
INSERT INTO taxonomy VALUES(3046,2666504,'Bolbea','parasitica');
INSERT INTO taxonomy VALUES(3047,2675548,'Phytophthora','caryae');
INSERT INTO taxonomy VALUES(3048,2675888,'Phytophthora','pseudopolonica');
INSERT INTO taxonomy VALUES(3049,2678298,'Phytophthora','sp. ''kelmania'' x sansomeana');
INSERT INTO taxonomy VALUES(3050,2681168,'Saprolegnia','glomerata');
INSERT INTO taxonomy VALUES(3051,2681169,'Saprolegnia','blelhamensis');
INSERT INTO taxonomy VALUES(3052,2681712,'Diatomophthora','perforans');
INSERT INTO taxonomy VALUES(3053,2691624,'Phytophthora','citricola IX');
INSERT INTO taxonomy VALUES(3054,2691625,'Phytophthora','citricola VII');
INSERT INTO taxonomy VALUES(3055,2691626,'Phytophthora','citricola VIII');
INSERT INTO taxonomy VALUES(3056,2691627,'Phytophthora','citricola X');
INSERT INTO taxonomy VALUES(3057,2691628,'Phytophthora','citricola XI');
INSERT INTO taxonomy VALUES(3058,2691630,'Elongisporangium','sp. Hoang Lien');
INSERT INTO taxonomy VALUES(3059,2691813,'Phytopythium','sp. ConDao');
INSERT INTO taxonomy VALUES(3060,2691814,'Phytopythium','sp. UZ248');
INSERT INTO taxonomy VALUES(3061,2691817,'Pythium','cf. xZSF0056');
INSERT INTO taxonomy VALUES(3062,2691818,'Phytophthora','cf. attenuata 2');
INSERT INTO taxonomy VALUES(3063,2691820,'Phytophthora','cf. attenuata 1');
INSERT INTO taxonomy VALUES(3064,2691821,'Phytophthora','cf. Peru 4');
INSERT INTO taxonomy VALUES(3065,2691822,'Phytophthora','cf. Kunnunara');
INSERT INTO taxonomy VALUES(3066,2691823,'Phytophthora','cf. virginiana');
INSERT INTO taxonomy VALUES(3067,2691824,'Phytophthora','cf. Grenada 3');
INSERT INTO taxonomy VALUES(3068,2691825,'Phytophthora','cf. attenuata 3');
INSERT INTO taxonomy VALUES(3069,2691826,'Pythium','cf. conidiophorum');
INSERT INTO taxonomy VALUES(3070,2691827,'Phytophthora','cf. meadii 2');
INSERT INTO taxonomy VALUES(3071,2691828,'Phytophthora','cf. meadii 1');
INSERT INTO taxonomy VALUES(3072,2691829,'Phytophthora','cf. tropicalis 2');
INSERT INTO taxonomy VALUES(3073,2691830,'Phytophthora','cf. quininea');
INSERT INTO taxonomy VALUES(3074,2691831,'Phytophthora','cf. gallica 2');
INSERT INTO taxonomy VALUES(3075,2691832,'Phytophthora','cf. gallica 1');
INSERT INTO taxonomy VALUES(3076,2692152,'Phytophthora','cf. multivesiculata 1');
INSERT INTO taxonomy VALUES(3077,2692153,'Phytophthora','cf. sp. sylvatica 2');
INSERT INTO taxonomy VALUES(3078,2692154,'Phytophthora','cf. sp. sylvatica 3');
INSERT INTO taxonomy VALUES(3079,2692155,'Phytophthora','cf. sp. bitahaiensis');
INSERT INTO taxonomy VALUES(3080,2692156,'Phytophthora','cf. sp. sylvatica 1');
INSERT INTO taxonomy VALUES(3081,2692335,'Newbya','apiculata');
INSERT INTO taxonomy VALUES(3082,2692336,'Newbya','oblongata');
INSERT INTO taxonomy VALUES(3083,2699229,'Phytopythium','aichiense');
INSERT INTO taxonomy VALUES(3084,2699230,'Lagenidium','sp. CBS 127285');
INSERT INTO taxonomy VALUES(3085,2708265,'Globisporangium','heterothallicum');
INSERT INTO taxonomy VALUES(3086,2711120,'Globisporangium','macrosporum');
INSERT INTO taxonomy VALUES(3087,2711122,'Globisporangium','rostratifingens');
INSERT INTO taxonomy VALUES(3088,2711123,'Globisporangium','rostratum');
INSERT INTO taxonomy VALUES(3089,2711124,'Globisporangium','sp.');
INSERT INTO taxonomy VALUES(3090,2713658,'Peronospora','sp. CSS-2020a');
INSERT INTO taxonomy VALUES(3091,2713659,'Hyaloperonospora','daughtreyae');
INSERT INTO taxonomy VALUES(3092,2714593,'Phytophthora','betacei');
INSERT INTO taxonomy VALUES(3093,2719893,'Phytophthora','cf. meadii');
INSERT INTO taxonomy VALUES(3094,2719985,'Phytophthora','heterospora');
INSERT INTO taxonomy VALUES(3095,2726694,'Phytopythium','sp. 2 NS-2020');
INSERT INTO taxonomy VALUES(3096,2726695,'Phytopythium','sp. 3 NS-2020');
INSERT INTO taxonomy VALUES(3097,2726696,'Pythium','sp. 11 NS-2020');
INSERT INTO taxonomy VALUES(3098,2726697,'Pythium','sp. 3 NS-2020');
INSERT INTO taxonomy VALUES(3099,2726698,'Pythium','sp. 5 NS-2020');
INSERT INTO taxonomy VALUES(3100,2726699,'Pythium','sp. 6 NS-2020');
INSERT INTO taxonomy VALUES(3101,2726992,'Phytophthora','cf. ''kelmania''');
INSERT INTO taxonomy VALUES(3102,2733688,'Aphanomyces','sp. NJM 9510');
INSERT INTO taxonomy VALUES(3103,2736613,'Globisporangium','huanghuaiense');
INSERT INTO taxonomy VALUES(3104,2741113,'Peronospora','aquilegiicola');
INSERT INTO taxonomy VALUES(3105,2741729,'Pythium','sp. ''group B'' DP-2020');
INSERT INTO taxonomy VALUES(3106,2742166,'Phytophthora','acaciivora');
INSERT INTO taxonomy VALUES(3107,2743405,'Phytophthora','sp. CL8');
INSERT INTO taxonomy VALUES(3108,2743406,'Phytophthora','sp. CL9-1');
INSERT INTO taxonomy VALUES(3109,2746716,'Peronospora','lanceolatae');
INSERT INTO taxonomy VALUES(3110,2750334,'Phytophthora','sp. ST_20190627');
INSERT INTO taxonomy VALUES(3111,2750911,'Peronospora','clinopodii');
INSERT INTO taxonomy VALUES(3112,2750912,'Peronospora','chenopodii-ambrosioidis');
INSERT INTO taxonomy VALUES(3113,2755056,'Phytophthora','aysenensis');
INSERT INTO taxonomy VALUES(3114,2759522,'Phytophthora','personensis');
INSERT INTO taxonomy VALUES(3115,2761362,'Peronospora','kuewa');
INSERT INTO taxonomy VALUES(3116,2763413,'Phytophthora','sp. CMR-2020');
INSERT INTO taxonomy VALUES(3117,2770500,'Albugo','cruciferarum');
INSERT INTO taxonomy VALUES(3118,2770501,'Peronospora','ranunculi-peduncularis');
INSERT INTO taxonomy VALUES(3119,2770502,'Plasmopara','carlottae');
INSERT INTO taxonomy VALUES(3120,2770503,'Plasmopara','latifolii');
INSERT INTO taxonomy VALUES(3121,2772402,'Pythium','sp. 1 SC-2020');
INSERT INTO taxonomy VALUES(3122,2772403,'Pythium','sp. 2 SC-2020');
INSERT INTO taxonomy VALUES(3123,2772404,'Pythium','sp. 3 SC-2020');
INSERT INTO taxonomy VALUES(3124,2772405,'Pythium','sp. 4 SC-2020');
INSERT INTO taxonomy VALUES(3125,2773627,'Pythium','sp. ''cluster B2A''');
INSERT INTO taxonomy VALUES(3126,2780433,'Albugo','koreana');
INSERT INTO taxonomy VALUES(3127,2789430,'Peronospora','chenopodii-ficifolii');
INSERT INTO taxonomy VALUES(3128,2792423,'Phytophthora','mekongensis');
INSERT INTO taxonomy VALUES(3129,2792424,'Phytophthora','prodigiosa');
INSERT INTO taxonomy VALUES(3130,2793141,'Aphanomycopsis','bacillariacearum');
INSERT INTO taxonomy VALUES(3131,2793315,'Phytophthora','sp. 1 ML-2020');
INSERT INTO taxonomy VALUES(3132,2796155,'Nothophytophthora','sp. ''irlandica''');
INSERT INTO taxonomy VALUES(3133,2796156,'Nothophytophthora','sp. ''liri''');
INSERT INTO taxonomy VALUES(3134,2796157,'Phytophthora','sp. ZM-2020a');
INSERT INTO taxonomy VALUES(3135,2801445,'Phytophthora','aquae-cooljarloo');
INSERT INTO taxonomy VALUES(3136,2802040,'Phytophthora','cf. castaneae');
INSERT INTO taxonomy VALUES(3137,2802041,'Phytophthora','cf. heveae');
INSERT INTO taxonomy VALUES(3138,2803945,'Sirolpidium','bryopsidis');
INSERT INTO taxonomy VALUES(3139,2805667,'Phytophthora','sp. ''clade 6D''');
INSERT INTO taxonomy VALUES(3140,2805668,'Phytophthora','kelmanii');
INSERT INTO taxonomy VALUES(3141,2810773,'Phytophthora','sp. AUS2D');
INSERT INTO taxonomy VALUES(3142,2810774,'Phytophthora','sp. PNG2A');
INSERT INTO taxonomy VALUES(3143,2810775,'Phytophthora','sp. PNG2B');
INSERT INTO taxonomy VALUES(3144,2810776,'Phytophthora','sp. VTN2A');
INSERT INTO taxonomy VALUES(3145,2810777,'Phytophthora','sp. VTN2B');
INSERT INTO taxonomy VALUES(3146,2811085,'Plasmopara','sp.');
INSERT INTO taxonomy VALUES(3147,2811289,'Salisapilia','sp.');
INSERT INTO taxonomy VALUES(3148,2811941,'Peronospora','eranthidis');
INSERT INTO taxonomy VALUES(3149,2811942,'Peronospora','myosuri');
INSERT INTO taxonomy VALUES(3150,2811959,'Phytophthora','theobromicola');
INSERT INTO taxonomy VALUES(3151,2812885,'Miracula','sp. AB-2020a');
INSERT INTO taxonomy VALUES(3152,2815209,'Miracula','sp. AB-2020b');
INSERT INTO taxonomy VALUES(3153,2817067,'Phytophthora','sp. XX-2020a');
INSERT INTO taxonomy VALUES(3154,2817068,'Phytophthora','sp. XX-2020b');
INSERT INTO taxonomy VALUES(3155,2817558,'Pythium','sp. 1 HK-2021');
INSERT INTO taxonomy VALUES(3156,2822403,'Phytophthora','sp. ''germisporangia''');
INSERT INTO taxonomy VALUES(3157,2822404,'Phytophthora','sp. ''awatangi''');
INSERT INTO taxonomy VALUES(3158,2822405,'Phytophthora','multibullata');
INSERT INTO taxonomy VALUES(3159,2822406,'Phytophthora','insulinativitatica');
INSERT INTO taxonomy VALUES(3160,2822408,'Phytophthora','x vanyenensis');
INSERT INTO taxonomy VALUES(3161,2822520,'Albugo','sp.');
INSERT INTO taxonomy VALUES(3162,2823662,'Phytophthora','sp. 1 DB-2021');
INSERT INTO taxonomy VALUES(3163,2823906,'Phytophthora','mediterranea');
INSERT INTO taxonomy VALUES(3164,2828545,'Phytophthora','sp. ax TBB-2021');
INSERT INTO taxonomy VALUES(3165,2829234,'Halocrusticida','sp.');
INSERT INTO taxonomy VALUES(3166,2829235,'Chlamydomyzium','sp.');
INSERT INTO taxonomy VALUES(3167,2836810,'Pustula','sp.');
INSERT INTO taxonomy VALUES(3168,2841982,'Peronospora','vincae');
INSERT INTO taxonomy VALUES(3169,2843339,'Phytophthora','emzansi');
INSERT INTO taxonomy VALUES(3170,2843340,'Phytophthora','afrocarpa');
INSERT INTO taxonomy VALUES(3171,2849776,'Phytophthora','sp. ''docynia''');
INSERT INTO taxonomy VALUES(3172,2853999,'Nothophytophthora','sp.');
INSERT INTO taxonomy VALUES(3173,2860123,'Phytophthora','marrasii');
INSERT INTO taxonomy VALUES(3174,2864849,'Globisporangium','sp. MT-2021a');
INSERT INTO taxonomy VALUES(3175,2864850,'Globisporangium','sp. MT-2021b');
INSERT INTO taxonomy VALUES(3176,2864851,'Globisporangium','sp. MT-2021c');
INSERT INTO taxonomy VALUES(3177,2864852,'Globisporangium','sp. MT-2021d');
INSERT INTO taxonomy VALUES(3178,2864853,'Globisporangium','sp. MT-2021e');
INSERT INTO taxonomy VALUES(3179,2866776,'Phytophthora','panamensis');
INSERT INTO taxonomy VALUES(3180,2866777,'Phytophthora','transitoria');
INSERT INTO taxonomy VALUES(3181,2866778,'Phytophthora','variabilis');
INSERT INTO taxonomy VALUES(3182,2867952,'Phytophthora','cf. palmivora');
INSERT INTO taxonomy VALUES(3183,2873698,'Haptoglossa','sp.');
INSERT INTO taxonomy VALUES(3184,2874298,'Halophytophthora','sp. MHJ-2021a');
INSERT INTO taxonomy VALUES(3185,2874299,'Halophytophthora','sp. MHJ-2021b');
INSERT INTO taxonomy VALUES(3186,2874300,'Halophytophthora','sp. MHJ-2021c');
INSERT INTO taxonomy VALUES(3187,2874301,'Halophytophthora','sp. MHJ-2021d');
INSERT INTO taxonomy VALUES(3188,2874302,'Halophytophthora','sp. MHJ-2021e');
INSERT INTO taxonomy VALUES(3189,2874303,'Halophytophthora','sp. MHJ-2021f');
INSERT INTO taxonomy VALUES(3190,2874304,'Halophytophthora','sp. MHJ-2021g');
INSERT INTO taxonomy VALUES(3191,2874305,'Halophytophthora','sp. MHJ-2021h');
INSERT INTO taxonomy VALUES(3192,2874362,'Halophytophthora','cf. ''thermoambigua''');
INSERT INTO taxonomy VALUES(3193,2874571,'Halophytophthora','sp. Portugal9');
INSERT INTO taxonomy VALUES(3194,2875801,'Newbya','androgyna');
INSERT INTO taxonomy VALUES(3195,2877943,'Phytophthora','sp. ax');
INSERT INTO taxonomy VALUES(3196,2878102,'Sclerospora','iseilematis');
INSERT INTO taxonomy VALUES(3197,2878103,'Sclerospora','noblei');
INSERT INTO taxonomy VALUES(3198,2891597,'Pythium','sp. 1 YL-2020');
INSERT INTO taxonomy VALUES(3199,2891598,'Pythium','sp. 2 YL-2020');
INSERT INTO taxonomy VALUES(3200,2897317,'Phytophthora','alpina');
INSERT INTO taxonomy VALUES(3201,2905208,'Pythium','sp. 1 AA-2018');
INSERT INTO taxonomy VALUES(3202,2905209,'Pythium','sp. 2 AA-2018');
INSERT INTO taxonomy VALUES(3203,2905210,'Pythium','sp. 3 AA-2018');
INSERT INTO taxonomy VALUES(3204,2905211,'Pythium','sp. 4 AA-2018');
INSERT INTO taxonomy VALUES(3205,2905212,'Pythium','sp. 5 AA-2018');
INSERT INTO taxonomy VALUES(3206,2905213,'Pythium','sp. 6 AA-2018');
INSERT INTO taxonomy VALUES(3207,2905214,'Pythium','sp. 7 AA-2018');
INSERT INTO taxonomy VALUES(3208,2911079,'Phytophthora','sp. ''E'' AP-2022');
INSERT INTO taxonomy VALUES(3209,2911080,'Phytophthora','sp. ''K'' AP-2022');
INSERT INTO taxonomy VALUES(3210,2911393,'Pythium','periculosum');
INSERT INTO taxonomy VALUES(3211,2925230,'Peronosclerospora','ischaemi');
INSERT INTO taxonomy VALUES(3212,2925231,'Peronosclerospora','mactaggartii');
INSERT INTO taxonomy VALUES(3213,2925232,'Peronosclerospora','schizachyrii');
INSERT INTO taxonomy VALUES(3214,2925233,'Baobabopsis','marneyi');
INSERT INTO taxonomy VALUES(3215,2925234,'Eraphthora','drenthii');
INSERT INTO taxonomy VALUES(3216,2925236,'Peronosclerospora','aristidae');
INSERT INTO taxonomy VALUES(3217,2925237,'Peronosclerospora','boughtoniae');
INSERT INTO taxonomy VALUES(3218,2925238,'Peronosclerospora','jamesiae');
INSERT INTO taxonomy VALUES(3219,2925240,'Peronosclerospora','sehimatis');
INSERT INTO taxonomy VALUES(3220,2926383,'Phytophthora','sp. MHJ-2022l');
INSERT INTO taxonomy VALUES(3221,2929588,'Halophytophthora','sp. ''thermoambigua-like''');
INSERT INTO taxonomy VALUES(3222,2929589,'Phytophthora','sp. ''Clade06a-New-PT''');
INSERT INTO taxonomy VALUES(3223,2943178,'Salisapilia','coffeyi');
INSERT INTO taxonomy VALUES(3224,2946837,'Pythium','agreste');
INSERT INTO taxonomy VALUES(3225,2951979,'Pythium','sp. ''aquasilvae''');
INSERT INTO taxonomy VALUES(3226,2951980,'Pythium','sp. ''rhizoterrae''');
INSERT INTO taxonomy VALUES(3227,32630,'synthetic','construct C1');
INSERT INTO taxonomy VALUES(3228,32630,'synthetic','construct C2');
INSERT INTO taxonomy VALUES(3229,32630,'synthetic','construct C3');
INSERT INTO taxonomy VALUES(3230,32630,'synthetic','construct C4');
INSERT INTO taxonomy VALUES(3231,0,'Nothophytophthora','taxon Catala2018sp13');
INSERT INTO taxonomy VALUES(3232,0,'Phytophthora','acaciae');
INSERT INTO taxonomy VALUES(3233,0,'Phytophthora','taxon Catala2018sp2');
INSERT INTO taxonomy VALUES(3234,0,'Phytophthora','taxon aquatilis');
INSERT INTO taxonomy VALUES(3235,0,'Phytophthora','taxon Catala2018sp9');
INSERT INTO taxonomy VALUES(3236,0,'Phytophthora','taxon Catala2018sp8');
INSERT INTO taxonomy VALUES(3237,0,'Phytophthora','taxon Catala2018sp4');
INSERT INTO taxonomy VALUES(3238,0,'Phytophthora','taxon Catala2018sp6');
INSERT INTO taxonomy VALUES(3239,0,'Phytophthora','taxon Catala2018sp7');
INSERT INTO taxonomy VALUES(3240,0,'Phytophthora','taxon Catala2018sp1');
INSERT INTO taxonomy VALUES(3241,0,'Phytophthora','taxon Catala2018sp3');
INSERT INTO taxonomy VALUES(3242,0,'Phytophthora','taxon Catala2018sp10');
INSERT INTO taxonomy VALUES(3243,0,'Phytophthora','taxon Catala2018sp11');
INSERT INTO taxonomy VALUES(3244,0,'Phytophthora','taxon Catala2018sp12');
INSERT INTO taxonomy VALUES(3245,0,'Phytophthora','taxon Catala2018sp5');
CREATE TABLE marker_definition (
	id INTEGER NOT NULL, 
	name VARCHAR(32), 
	left_primer VARCHAR(100), 
	right_primer VARCHAR(100), 
	min_length INTEGER, 
	max_length INTEGER, 
	PRIMARY KEY (id), 
	UNIQUE (name)
);
INSERT INTO marker_definition VALUES(1,'ITS1','GAAGGTGAAGTCGTAACAAGG','GCARRGACTTTCGTCCCYRC',100,1000);
CREATE TABLE marker_sequence (
	id INTEGER NOT NULL, 
	md5 VARCHAR(32), 
	sequence VARCHAR(250), 
	PRIMARY KEY (id), 
	UNIQUE (md5), 
	UNIQUE (sequence)
);
INSERT INTO marker_sequence VALUES(1,'3b3cb03c4aa9604e922913ad148cd12c','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCGGGTCCCGGACAGCTCCGATGCCCTGTATCAGTGCCGGTTTGCTACGGTAGATCCCCCGTTCCCGTGTTGGTCATGCACGAACCTGTCCTCGTGGCGTCTTTATGTAATGGTGGCCCTTGCTTCGTGAGGACGAAGTTTACCCAGGCTGGCGGGCGTTCGGACGCAGAGCAGTTCGTGGAAATAGAAACTGTG');
INSERT INTO marker_sequence VALUES(2,'6ad4c7e0216fc47df90fe208a3b7806c','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACAATAGAACCATGTCTGTTATGCTACTAGTCCGTGAGTGTCTCTGCAGCCAGTTTCCTTCCAACTGTTTTCATGTCATTTACTGGCTTCCTCCCCGTGTGTTCTAGTTATCGGTGATGGTAGGAGAACGAGGTTGGAGCAGGTAAAAAAGCTCGGCGGCGAACTGTCCACAACTGTCTAGCTTCAATCGAGGGGC');
INSERT INTO marker_sequence VALUES(3,'8613c7627e99537203fe5895d0a24e8e','TTTCCGTAGGTGAACCTGCGGAAGGATCATTATTACAGCCAGAGTAACTATATAATCTACGAGGGTGTTAGCTGTACGATGAGCGCGTCTGGTATTGCGTTCATTGGGGTCGATATTCCGACCTGCATGGTCCCGTTGCCAGCATGGTGTCTTTTCTTCGGGCTTGTAGCTCGTACAGTCTGACCGTGTAGGTTTGCAGGACCTCGGCCAGTCCCCTAGGCCGTTGC');
INSERT INTO marker_sequence VALUES(4,'8c55f39152a1c260dbbe1317db10f100','TTTCCGTAGGTGAACCTGCGGAAGGATCATTAAGGTCCGAGAGGTACTTCCTAGCCATTAGGCAGGCTAGTGCATTGCCGCAGCTTCCAGTCGTTCCGACGGGATGGTTCAATTTGCCCCCTACGCCACAAATGCCTCAGAGTTGCCGTCGGGGAGGTAGCCTCTCCAATGCTCCGAGGATGTTTGTAAACAAACCCCACGGAATACAAGCATGCTGACAGCTCTGT');
INSERT INTO marker_sequence VALUES(5,'88531412fbe9f8496ee2e80d1cbfa17d','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAAATGCGTCCCATCATGGCGATCGTTTCGACCTCGGTTGGAATTAGTAGCTACATTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(6,'29c57fb8bb431163a028917e552a1259','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACAACATAAATTGGGGGTGATCCTGACGGTAGCTGCTGGTTTTTTACTGGCGGTAACTATTGAGTGAACCTCATCATGACGAACCGTTGGGCTTTTGTCTGGCGTAGTAGAATAAATTTTAAACCCTTACTTAATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(7,'f48331c6566caa6da14adda9329f1d9a','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACAACTTAAATTGGGGGTGATCTTGACGGTAGCTGCTGGTTTTTTACTGGCGGTAACTATTGAGTGAACCTCATCATGACGAACCGTTGGGCTTTCGTCTGGCGTAGTAGAATAAATTTTAAACCCTTACTTAATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(8,'dd7e2a61f258d6befab1d2a55242e5e0','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACAACTTAAATTGGGGGTGATCTTGACGGTAGCTGCTGGTTTTTTACTGGCGGTAACTATTGAGTGAACCTCATCATGACGAACCGTTGGGCTTTTGTCTGGCGTAGTAGAATAAATTTTAAACCCTTACTTAATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(9,'d9bc3879fdab3b4184c04bfbb5cf6afb','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAAAATCCTTTTATTGGGGGCTTCTGTCTGGTCTGGCTTCGGCTGGTCTGGGTGGCGGCTCTATCATGGTGACCGCTCTGGGCTTCGGCTTGGAGTTAGTAGCCCACTTTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO marker_sequence VALUES(10,'688ca1f52e3ffeb2417adceff1011655','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAAAACCCTTTATTGGGGGCTTCTGTCTGGTCTGGCTTCGGCTGGGCTGGGTGGCGGCTCTATCATGGCGACCGCTCTGGGCTTCGGCCTGGAGTTAGTAGCTCACTTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO marker_sequence VALUES(11,'259d50fc8098473b48ceacb48eb3ed99','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(12,'3d3fa2fd6fe0f183cad80771f5950b27','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCATTTAGTTGGGGGCTTGTCCTGGTGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGGCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(13,'f1d4c0432c89f005ec2b4e467839f5cc','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(14,'86faa3e6c55cb63348af05c3272a51ed','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAGCATACT');
INSERT INTO marker_sequence VALUES(15,'f696591f997895f8ae62d4b9c44f4ccd','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACACCCTTAGTTGGGGGCTGCTGTTCGGCTGGCTTCGGCTGGCTGGGCGGCGGCTCTATCATGGCGAGCGCCTGGGCCTTCGGGTCTGAGCTAGTAGCCCACTTTTAAACCCATTCCTAATTACTGAACATACT');
INSERT INTO marker_sequence VALUES(16,'8c593016c6c188d66817d7c0ada433d5','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATTAATTGGGGGTTTACTTGGCGGCTGCTGGTGGCATGTTTTTGCTGGCTGGCTACTGCTGAGCGAACCCTATCATGGCGAGTGTTCTGACCTCGGTTGGAGCTAGTAGCTTAAATTGTAAACCCATTCTTAAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(17,'ab082031f945cad0319dffaf35beade5','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACAATCCACGTGAACCGTATCAACCCCCCTTAATTGGGGCTTCCCTGCTGTCTTGTGCTGGCTGAGCTTTGTTGTTCGGCTGGTCGAGGCGGCGGGTTGAGGCCTATCAGCGAACGCTTTTTGTTAGTAGCTTTTTTTTGCGACCGAGCGTTTGTGCCGACTATTGATGGAATCGCTTTTGCAAGCAGGCCAGTTACCTGTAGCATTGGCTTGAATCCGGACGCGGTTGGCGCGAGCTAGTAGTTTTGCAAAAGTTTTTTAAACCCTTTACTAAATACTGAAAAACT');
INSERT INTO marker_sequence VALUES(18,'04f98d2bf3f9dd49f7102ea1db7a128f','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAATAATCCACGTGAACCGTATCAACCCCCCTTAATTGGGGCTTCCCTGCTGTCTTGTGCTGGCTGAGCTTTGTTGTTCGGCTGGTCGAGGCGGCGGGTTGAGGCCTATCAGCGAACGCTTTTTGTTAGTAGCTTTTTTTTGCGACCGAGCGTTTGTGCCGACTATTGATGGAATCGCTTTTGCAAGCAGGCCAGTTACCTGTAGCATTGGCTTGAATCCGGACGCGGTTGGCGCGAGCTAGTAGTTTTGCAAAAGTTTTTTAAACCCTTTACTAAATACTGAAAAACT');
INSERT INTO marker_sequence VALUES(19,'ed44806393cfa394e5056fca15b45a5c','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACAATCCACGTGAACCGTATCAACCCCCCTTAATTGGGGCTTCCCTGCTGTCTTGTGCTGGCTGAGCTTTGTTGTTCGGCTGGTCGAGGCGGCGGGTTGAGGCCTATCAGCGAACGCTTTTTGTTAGTAGCTTTTTTTTTGCGAACGAGCGTTTGTGCCGACTATTGATGGAATCGCTTTTGCAAGCAGGCCAGTTACCTGTAGCATTGGCTTGAATCCGGACGCGGTTGGCGCGAGCTAGTAGTTTTGCAAAAGTTTTTTAAACCCTTTACTAAATACTGAAAAACT');
INSERT INTO marker_sequence VALUES(20,'ed15fefb7a3655147115fc28a8d6d671','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(21,'af46526f85cbf2d345d419a0f30e854a','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTAGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTTGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(22,'f65d8c80202d42fc17e32da2bb7f2858','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTAGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTTGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(23,'10ba08ab269b69142b6f83328e3e7099','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTAGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(24,'a012903e04863a4c2f904dee8dabc5cb','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTAAACCATTCCTAATTACTGAATATACT');
INSERT INTO marker_sequence VALUES(25,'b1199a1082e563c9954dee14b4150557','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(26,'2e4f0ed53888ed39a2aee6d6d8e02206','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTATCGAACAACTAGTTGGGGGTCTTGTTTGGCGTGCGGCTGCTTCGGTAGCTGCTGCTAGGCGAGCCCTATCACGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTATTTTTTAAACCCATTCTTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(27,'b3b684fc69437b76cc7921e2ed287dae','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(28,'12dc63e906f613f17219530896e88839','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGAACTGAGCCAGTAGCCCTTTTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(29,'c50b7fc6de0f1405b4388e95bdb01b4c','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO marker_sequence VALUES(30,'18ab920ad62eb511ae7b88fdccec0e36','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCATTTCACAATTCTGATTATACT');
INSERT INTO marker_sequence VALUES(31,'6bcdcba67f36c711c34f3a5ec368babb','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAAAACCCTTTTATTGGGGGCTTCTGTCTGGTCTGGCTTCGGCTGGTCTGGGTGGCGGCTCTATCATGGTGACCGCTCTGGGCTTCGGCTTGGAGTTAGTAGCCCACTTTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO marker_sequence VALUES(32,'d343fb37b0b42e3533546d8cbae33048','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAAAACCCTTTTATTGGGGGCTTCTGTCTGGTCTGGCTTCGGCTGGTCTGGGTGGCGGCTCTATCATGGTGACCACTCTGGGCTTCGGCTTGGAGTTAGTAGCCCACTTTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO marker_sequence VALUES(33,'e827e3de506c4ff02217fde4a95bfa70','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTTGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(34,'602d96b1f4128367c10946522fe33269','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTTGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(35,'88c30cd5198b5c00764cb64ead1ea822','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(36,'783143261c94eddc7a13630cd5ba33ee','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTTTACT');
INSERT INTO marker_sequence VALUES(37,'ed32541ef8addf4b146847ac02646b28','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(38,'681a00ee195ffe65ef3f2dfd47598653','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAAACTTTCCACGTGAACTGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(39,'28c639a1150d8b7e4c6fba0e424e0271','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(40,'3c94d5e2cb0abf95075ee1a12aa129c8','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(41,'e6371979623484f3c17cb4805b8a3940','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAATTTGGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO marker_sequence VALUES(42,'7ac50609279c89c7fc3d88ffed426dac','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTCAACCTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(43,'4b5e99f8fcd8d04270c10da2bf59020b','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCAATTGGTTTGGGTCCTCCTCGTGGGGAACTAGATCATGAGCCCACTTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO marker_sequence VALUES(44,'a2ac9d97f7118c5cd7fa12880050a74a','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTACCATGGCAATTGGTTTGGGTCCTCCTCGTGGGGAACTAGATCATGAGCCCACTTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO marker_sequence VALUES(45,'d8613e80b8803b13f7ea5d097f8fe46f','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCCTGTCCTGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(46,'f27df8e8755049e831b1ea4521ad6eb3','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(47,'fe1bd3a42e730f95c9fde798e32f8478','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGTGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(48,'8950417251c8298320f60deda691b35b','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTATCGAACAACTAGTTGGGGGTCTTGTTTGGCGTGCGGCTGCTTCGGTAGCTGCTGCTAGGCGAGCCCTATCACGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTATTTTTTAAACCCATTCTTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(49,'a59091bd29e998d270db901e842e9bef','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAATATTTCCACGTGAACCGTTTCAACCAAAAAAATTTGGGGGTCTTGTTTGGCGGCGGCTACTGGCTTTATTGCTGGCGGCTGCTGCTGGACGAGCCCTAACGCGAAAGTTTAGACTTCGGTCTGGGCTAGTAGCTTTATTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(50,'29de890989becddc5e0b10ecbbc11b1a','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTAACAAACCAATAGTTGGGGGCGAGTTTGGCGGCGGCTGCTGGCTTTGGCTGGCTGGCTGCTGCTGGACGAGCTCTATCATGGCGAGCGTTTGGACTTCGGTCTGAACTAGTAGCCCTTCTTTTAAACCCATTCCTAATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(51,'36ad9a45fa33397a67d7f6be02a39964','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAAAACCCTTAGTTGGGGGCTTCTGTTCGGCTGGCTTCGGCTGGCTGGGCGGCGGCTCTATCATGGCGAGCGCATGGGCCTTCGGGTCTGAGCTAGTAGCCCTCTTTTTAAACCCATTCCTAAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(52,'24be91088cd4734b066a717bd2de041c','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAAAACCCTTAGTTGGGGGCTTCTGTTCGACTGGCTTCGGCTGGCTGGGCGGCGGCTCTATCATGGCGAGCGCATGGGCCTTCGGGTCTGAGCTAGTAGCCCTCTTTTTAAACCCATTCCTAAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(53,'7f3b213656cc5541bdcdf4692a3ed5bb','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(54,'d48d9e6e3548bfd92a88d1b46d19bde1','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGTTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(55,'8b835ab53506bff14285df6262625455','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(56,'76ca49ebff534e95634d75561c06cf23','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATATT');
INSERT INTO marker_sequence VALUES(57,'c971cc015791eec087271765b2b19cc3','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO marker_sequence VALUES(58,'c79d286595a487be4d76cd8dd3bd384d','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO marker_sequence VALUES(59,'5661d8e6ef0f1cc4e6cf61e4d7500fcb','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGTGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO marker_sequence VALUES(60,'a7471bc623c89cef2d91a9d43df99579','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO marker_sequence VALUES(61,'07874837d1d9a8477337081d921a38d4','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAATTCCACGTGAACTGTATTGTCAACCAAATTCGGGGATTCCTTGCTAGCGTGCCTTCGGGCGTGCCGGTAGGTTGAGACCCATCAAACGAAAACATCGGCTGAAAGGTCGGAGCCAGTAGTTAACTTTGTAAACCCTTTACTAAATACTGAAAAACT');
INSERT INTO marker_sequence VALUES(62,'91bf0a26b1eb21d6e54ac6a814c62775','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAATTCCACGTGAACTGTATTGTCAACCAAATTCGGGGATTCCTTGCTAGCGTGCCTTCGGGCGTGCCGGTAGGTTGAGACCCATCAAACGAAAACATCGGCTGAAAGGTCGGAGCCAGTAGTTACCTTTGTAAACCCTTTACTAAATACTGAAAAACT');
INSERT INTO marker_sequence VALUES(63,'0a61e6d1bd2525462225d081bea9c3ce','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAATTCCACGTGAACTGTATTGTCAACCAAATTCGGGGATTCCTTGCTAGCGTGCCTTCGGGCGTGCCGGTAGGTTGAGACCCATCAAACGAAAACATCGGCTGAAAGGTCGGAGCCAGTAGTTACCTTTGTAAACCCTTCACTAAATACTGAAAAACT');
INSERT INTO marker_sequence VALUES(64,'ac00bb7b4811bcc240d374d8bf03cd72','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAGATTGGGAGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCCTTCTTTAATTACTGAAATACT');
INSERT INTO marker_sequence VALUES(65,'3efd1e21521baf83a4751ccd90d39421','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAGATTGGGAGCTTGCTCGGCGGCGTGCGTCTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCCTTCTTTAATTACTGAAATACT');
INSERT INTO marker_sequence VALUES(66,'32159de6cbb6df37d084e31c37c30e7b','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAAAACCCTTTTATTGGGGGCTTCTGTCTGGTCTGGCTTCGGCTGGATTGGGTGGCGGCTCTATCATGGCGACCGCTCTGAGCTTCGGCCTGGAGCTAGTAGCCCACTTTTTAAACCCATTCTTAATTACTGAACAAACT');
INSERT INTO marker_sequence VALUES(67,'972db44c016a166de86a2bacab3f4226','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATTTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(68,'21d6308d89d74b8ed493d73a2cb4adb5','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCTGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(69,'99977bef41e2f50048e6c730637dc941','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGGCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATTTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(70,'301acf5db567b162de87ca69423a8440','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCTGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATTTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(71,'4ae6aaf0acd68944c1274608a7211df3','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTATTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(72,'366a3b698343fa24129a272f807ccf94','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAATTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATTTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(73,'d9e6de1308a8ac1448de351747d023c0','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGGCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(74,'f502b76965836568a0a113e2074879c8','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(75,'2843e160cc0859ffa1b6ac4f6ec7c508','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCTGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(76,'3d3f43d07f2d4dd63fe88aa3d6df9b52','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTAAAAAACTAGTTGGGGGCTCCTCGTTGGCAGTTTCGACTGTTAGTGGGTTGAGTTCTATCAAACGATCGATTTGGGCTGCAAAGTCGGAATTGAGAGTTTCTTTTTTAAACCCATTACTTAATTACTGAATATACT');
INSERT INTO marker_sequence VALUES(77,'951ac00b20e25e3e1664a5edef2acb6c','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGACGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(78,'66abcf5b8d99d1570bd815e67442f666','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGATGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(79,'8b82f3e8bc9c3b11d34027df788ab8b9','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(80,'4b639550662bfcf27f9face76af10d6b','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGTGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(81,'b88010d58905d035f845a320e18e00c3','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAAACCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(82,'23d10b136d1963f88a2ba28313054721','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATTCAACAATTATAATTGGGGGTGATCTTGGTGGAAGCTACTAGTCATTTTGGCTGGAGGCTACTATAGAGTGAACCTCATCATGACGAAAAAGTAGACTTTTGTCTAGTGAAGTAGTGAACATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(83,'69ecbd0dba57c8bf258f21109bd81917','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(84,'661e1af0a2d9e30c3a70448efc031f9d','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTATCAACCCCATTAGTTGGGGGTTTGCTTGGTGGCGATCACTGGCTTAATTGCTGGATGATTACTGCTAGGTAAGCCCTATCATGGCGAGCGTTTGGACTTCGGTCTGAACTAGTAGCTTCTATTTTAAACCCTTTCTTAATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(85,'00ac4cb747abc6550171c6e3a03198a2','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTCCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO marker_sequence VALUES(86,'6eb4119eaf468e8cc8397fd96fd9ef33','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAATTTGGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO marker_sequence VALUES(87,'426e99137914cbacedfe68f1fce6e3a4','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAAAACCCTTTTATTGGGGGCTTCTGTCTGGTCTGGCTTCGGTTGGATTGGGTGGCGGCTCTATCATGGCGACCGCTCTGAGCTTCGGCCTGGAGCTAGTAGCCCACTTTTTAAACCCATTCTTAATTACTGAACAAACT');
INSERT INTO marker_sequence VALUES(88,'5645deedd24b7e9eb0ac25d1ebda1115','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAACAACTTAAATTGGGGACGAAGATCTTGGTGGTAACTACTAGTCTCGACTGGTGGTAGCTACTAGGTGAGTAGTCTTATCATGGCGAACCATTGGGCTTTTGTCTAATGTAGTAGTATAAATTGTAAACACTTACTTAATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(89,'78ba64b49c3f8c890c53ef4d8ba88156','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAACTTTCCACGTGAACCGTATCAAACAATTAATTGGGGGCTTATTTGGCGGCAGCAGCTAGCATATCGTATTATTTTTGCTGGCTACTGCTGCTGTGTAAGCTCTATCATGGGTATACTTAACGGCAACAGCTAGCATATTGTATTATTTTTGCTGACGACTGCTACTAGGTATACCCTGTCATGGCAAGCGCTCGGACCTTGATTTGAGCAGGAGCATGAATTTTAAACCATTTACTAATTACTGAATATACT');
INSERT INTO marker_sequence VALUES(90,'326f496396ac9b3629c2db0479bd8c97','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(91,'0b1d20154db6e4ac15c578f6df339ec5','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCAACATAATTGGGGGTTTATTTGGCGGCGGCTGCTGGCATTTTGTGCTGGCTGGCTGCTACTGGGCAAGCCCTATCGCGAGCGTTTGGGCCTTGGCCTGAGCTAGTAGCTTTTATTTTAAACCATTCTTAATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(92,'31fd4387ad92d3142038fe56f0d22993','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATTAATTGGGGATTTAATTGGTGGTTGCTGCTGGCATCTTTTTGCTGACTAGCGACTGCTGAGCGAATCCTATCATCGTGAGCGCTCTGACCTCGGTTGGAGCTAGCTTCAATTATAAACCCTTTCTTAAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(93,'790e4a597416e73e0fb92c8f5e550383','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCTCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(94,'4ae4fb75b607e4986a9e300acf0fdffd','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCAAAAAAACTATCCACGTGAACCGTTAAACAACACTATAGTTGGCTTGTTTGTTGGGGAGTTTGTGAAAAGCTTGGAGATGTTTTCGGATATTTCTATGCCTAGTACTGGACATTCTGGCGAGCGAGTCGACTAGCAACGAAGGTCGGGAGTTCGCTTGCGGACTGATGTGCGATTCTCGCGTGTCGGACTAAAGGCTTGAGCAAACGGCTGATGTATTACTTTCAAACCATACCTGAATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(95,'32baeff340ced9e7855f1afa1567971e','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(96,'5ba953195780f6b0d43a6b3a177977a5','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATAATTTGGGGGTTTAATTGGCGGCTGCTGCTGGTATCTTTTTACTGGCTGGCGGCTGCTGAGCGAACCCTATCGTGAGCGTTCTGACCTTGGTTGGAGCTAGTAACTTAAATTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(97,'ad7988adbd78cd25b2d7d7499118b0c8','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTGATTATTGGGGGCTGCTGACTGGACTGGCTTCGGCTGGACTGGGCGGCGGCTCTAGCGCGACCGTTCTGGGCTTCGGCTTGGGGCTAGTAGCTTTTATTTTAAACCCATTCTTAATTTACTGAAATACT');
INSERT INTO marker_sequence VALUES(98,'009c8937ee39c05f9200b54606484f75','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAACAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(99,'06a7aa678e7d4df10933e87a02844ee4','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(100,'6854846b280a587c2d7a69ecae5cf67e','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATTAATTGGGGGTTTACTTGGTGGTTGCTGCTGGCATGTTTTTGCTGACTGGCGACTACTGAGTGAATCCTATCATAGTGAGCACTCTAACCTCGGTTAGAGCTAGCTTCAATTATAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(101,'72522cd1ff789b3a0677649db6ab97a0','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(102,'b6d454066dc3f4057b78aa91b8a3bca6','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCAACATAATTGGGGGTTTGTTTGGCGGCGGCTGCTGGCATTTTGTGCTGGCTGGCTGCTACTGGGCAAGCCCTATCGCGAGCGTTTGGGCCTTGGCCTGAGCTAGTAGCTTTTATTTTAAACCATTCTTAATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(103,'f382d86fe4a54ca4012f482e69c87f6e','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTCCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO marker_sequence VALUES(104,'b25abb32cd14ad41dfc78c8e0d27c7c0','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGTTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(105,'0c737c047c34834f5931ab601bdefa4a','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(106,'45138e9fa59fe5faacbb044e02b930aa','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAAAACCCTTTTATTGGGGGCTTCTGTCTGGTCTGGCTTCGGCTGGATTGGGTGGCGGCTCTATCATGGCGACCGCTCTGAGCTTCGGCCTGGAGCTAGTAGCCCACTTTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO marker_sequence VALUES(107,'a98978ab6168a911c27ce58605d1bb07','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATTAATTGGGGGTTTACTTGGCGGCGGCGGCTGGCATAGTTTTGCTGGCTGCTGCTGCCGAGTGAGCCCTATCATGGCGAGTGTTTGGACCTCGGTCTGAGCTAGTAGCTTTAATTTTAAACCCATTCTTAATTACTGAATATACT');
INSERT INTO marker_sequence VALUES(108,'561f37acfbc28678818abc1c561ae60f','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATTAATTGGGGGTTTAATTGGTGGTTGCTGCTGATATTTTATTGCTGGCTAGCGACTGCTGAGTGAATCCTATCATCGTGAGCACTCTGACCTCGGTTGGAGCTAGCTTAAATTATAAACCCATTCTTATATACTGAATATACT');
INSERT INTO marker_sequence VALUES(109,'0721a6a48cb10a2b0a866336cd8b40f0','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAATCTTTCCACGTGAACTGTTTTGTAAATTTGGGCTTCGCCTGCTGCGCTTTTCGCTTCCTTTTTGGTTGTAAAGAGCGCGACGGCTTGAGGCCATCAGGGTGCGCTTGCTTGATTTCTGTTTGGAATCGAGCGAGTGCGCTCTTTGTCAACCCATTTCTTTTGAAACTGATTATACT');
INSERT INTO marker_sequence VALUES(110,'b5f54ef8f37a15df2d63fc1a67b7644f','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTAGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(111,'ebca47b4048609ff879a378809a690ca','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAGATTGGGAGCTTGCTCGGCGGCGTGCGTGCTGGCCTAAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCCTTCTTTAATTACTGAAATACT');
INSERT INTO marker_sequence VALUES(112,'2f83bdad6a120dc89f8cb5b41a9b516e','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACAATTATAATTGGGGGTGACCTTGGTAGTGGCTACTAGTCTATTTTGGCTGGTGGTTATAACTGAGTGAGCCTCATCATGGCGAAAAGTTAGACTTTTGTTTAACCGAGTAGTATAAATTTTAAACCCTTACCTAATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(113,'617d15947d40845f29b9fcc690952490','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTTCACGTGAACCGTATCAACACTTATAATTGGGGGTGATCTTGGTGGCGGCTACTAGTCTTTTGGCTGGCGGCTACTACTGAGTGAGCCTCATCATGGCGAACCATTGGGCTCTTGTCTAATGTAGTAGTATAAATTTTAAACCCTTACTTAATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(114,'0eb7e1997d8a34c94d69ebf70f036d8b','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(115,'f48072cae23f50a216a6b19049f4e0f4','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATTAATTGGGGGTTTACTTGGCGGCGGCTGCTGGCATAGTTTTGCTGGCTGCTGCTGCCGAGTGAGCCCTATCATGGTGAGTGTTTGGACCTCGGTCTGAGCTAGTAGCTTTAATTTCAAACCCATTCTTAATTACTGAATATACT');
INSERT INTO marker_sequence VALUES(116,'b318ec87553fa394de95a976c1c43e6a','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCAACTAATTGGGGGTTTATTTGGTGGCGGCTGCTGGCATCTTTTTGCTGTCTGCTGCTACTGAGTGAACCCTATCATGGCGAGTGTTCGGACCTCGGTCTGAATTAGTAGCTCTCATTGTAAACCCATTCTTAATTACTGAATATACT');
INSERT INTO marker_sequence VALUES(117,'68a72613e6a259a6411f3df34e052235','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACATCTTTCCACGTGAACCGTTTGTGACATGGTTGGGCTTGTGCGTTTTCTCTCTCTTTTGTAGGGGGGATGCGTGCGAGCTATCTGTAAACTTGTCAAACCCATTCTTTTTGATAACTGAAACATACT');
INSERT INTO marker_sequence VALUES(118,'5f374e12834d04f3cae448eaa2ea4f16','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(119,'23da740847ffc944c8a2771a20d20a5f','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAATTTGGGGGCTCCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO marker_sequence VALUES(120,'3d3321eed13dba60899edfbb40cb7629','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCCTGGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCATTCCTAATTACTGAAAAAACT');
INSERT INTO marker_sequence VALUES(122,'16c58608a62790a2e9d945c9e9ed833a','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTATCAAAACAATTAATTGGGGGTTTAATTGGCGGCGGCTGCTGACATCTTTTTGTTGGCGGCTGCTGCTGAGCAAGCCCTATCATGGCGAATGTTCGGACCTCGGTCTGAGCTAGTAGCTTTCATTTTAAACCCATTCCTAATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(123,'3884c2f5f95fe09d820579c0487dcfa7','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATTTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(124,'05b1d79f8105b66f3bf307ac3fe270c8','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGCGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTAAACCATTCCTAATTACTGAATATACT');
INSERT INTO marker_sequence VALUES(125,'93a51769fd2c2c1a0f890d0918f4621e','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAATCTTTCCACGTGAATTGTTTTGCTGTAATTTTGGGCTTCGCCGTTGTCTTTTTTTCTTTTTTTCTTTTTTTGTAAAAAAAGGGGGGAGCGCGGTTGGAGGCCATCAGGGGCGTGTTCGTCGTGCGTTTTATGATTCTATGATTCTATGATTCACGCGCGAGTGCGTCCTTTTGTCAACCCATTTCTTTTGAAAAACTGATCATACT');
INSERT INTO marker_sequence VALUES(126,'2ab6c3f03f5fbc4c2ad2951f4a45290f','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGGCTGTCGATGTCAAAGTCGGCGGCTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO marker_sequence VALUES(127,'782eafb8aa41461c393d4233aa3f019a','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCAAATAGTTGGGGATAAGTTAGGCGGCGACTGCTGACATTATTGTTGGCGGTTGCTGCTAGACGAGTCCTATCATAGTGAAGTGGTTTGGACTTCGGTCCGAGCTAGTAGCTATTTTTAAACCATTAATTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(128,'acaf8864a2dc452f1e556426fc718698','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAAACCAAACTTGGGGGTTTGTTTGGTAGCGGCTATTGGCATCTTTTTGCTGGTTAGCTGTTGCTGAGCAAGCTCTATCATGGCGAATGTTTGGACTTCGGTCTGAATTAGTAGCTTACTTGTAAACCATTTCTTAAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(129,'a5d8fbd3918d8f81a5a06785ea4a9efb','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACATCTTTCCACGTGAACCGTTTGTGACATGGTTGGGCTTGTGCGTTTTCTCTCTCTTTTGGGGGAGGGGATGCGTGCGAGCTATCTGTAAACTTGTCAAACCCATTCTTTTTGATAACTGAAACATACT');
INSERT INTO marker_sequence VALUES(130,'5d03e2643c51072e4350273e1c1f541c','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCCCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(131,'2acdd64613751e3ced36374d5eb2e626','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACCGTATCAACCCTTGATTATTGGGGGCTGCTGACTGGACTGGCTTCGGCTGGACTGGGCGGCGGCTCTAGCGCGACCGTTCTGGGCTTCGGCTTGGGGCTAGTAGCTTTTATTTTAAACCCATTCTTAATTTACTGAAATACT');
INSERT INTO marker_sequence VALUES(132,'c68eaea03874118a710997420cce7ba0','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACATCTTTCCACGTGAACCGTTTGTGACATGGTTGGGCTTGTGCGTTTTCTCTCTTTTGTAGGGGGATGCGTGCGAGCTATCTGTAAACTTGTCAAACCCATTCTTTTTGATAACTGAAACATACT');
INSERT INTO marker_sequence VALUES(133,'7592fefa8701d3e442016b90526deaee','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATACTTCGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(134,'cc80da6bfdc5122143834b3cd40841d3','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTAAATTGGGGGCTCCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO marker_sequence VALUES(135,'dfae766ff29a02c0521fea4ee7969dc2','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAAATTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTATAATGGGTTGGTGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAATTACTGAAATACT');
INSERT INTO marker_sequence VALUES(136,'eb59453ed0e1d94881d080fbfa0cf623','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATTAATTGGGGGTTTCGTTGGCGGCTGCTGCTGGCATGTTTTTGCTGGCTAGCAGCTGCTGAGTAAACCCTATCATGGCGAGTGCTCTGATCTCGGTCGGAGCTAGTAGCTTCAATTTTAAACCCTTTCTTAAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(137,'03f6e3a6fdfa9b9eccbb6f9297f7bf91','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAATCTTTCCACGTGAATTGTTTTGTACACTGTTGGGTTTCGCTGGCGCGTGTTTTCTTGTCGAATGTAGTGTTTGACGGCGCGCGGCGGCTGGAGGCCATCAGGGCGTCTGTTGTTGTGATGGACGCTCTTTTTGTAAACCCCCTTTTTTTTTTATTTTGTGAAACTGATTGTACT');
INSERT INTO marker_sequence VALUES(138,'ed8fb26846b6b75ec063ff5148a9e1c7','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(139,'ebf17b7149dc75e8063184ccc3e2115f','CTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGATGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(140,'d2f79ee350b1a26e592ec9acf46aeaa6','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTGTCCACGTGAACCGTATCAACCCAAGTAGTTGGGGGCGTTACTGTTCTGCGCAGGCTGTCGATGTGAAAGTCGGCGGCTGGTGCGGAGCGGTGATGCCCTATCATGGCGAAGGTGTTGTGTTCCTCTCGGGGGACGTGATGTCGGCTGCCCTCTGTTTTAAACCCATTCCTAATAACTGATTAATACT');
INSERT INTO marker_sequence VALUES(141,'c9ada13adb72000a23195213711c7c41','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACTTTAAAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTGACTGAGCTGGTGTTTTCATTTTTGGACACTGGAACGGGAGTCAGCAGGACGAAGGTTGGTCTGTTGTAATGCAAGTTATGATGGACTAGCTGATGAACTTTTGTTTTTAAACCCTTACCTAAATACTGATTTATACT');
INSERT INTO marker_sequence VALUES(142,'f488ef4fe0dbb0e7b074021b65cd0c9b','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAATATCCACGTGAACCGTTTAGATTTGTTTTGTGCGTCGCTGATGCTTGAATGCTGGGTTTCGGTCCGGCGTCGCTGATGCTTGATGCTAAACGAAGGGGCGTTCGGTGACGTTTGGCTTTTGCTATTTTCCGTCTTGAACAAACCAGATTGTTGGGGGGTCTCGTTGCGGTAGGCGGCTTCGGCTGCTGGCTGCTTGGAGCGTCTCGGCGGTAGGTGGCTTCGGCTACTGGCTGCTTTGAGCAAACCGATGATTTGGTGCGATCGACGATGTGTGGCTCTGGCTGTTGCCTTGAACAAACCGATGTAACTTTTTAAACCATTTCCTAATACTGATCTATACTC');
INSERT INTO marker_sequence VALUES(143,'0d13097c518be88ad11aed4f94890d5c','TTTCCGTAGGTGAACCTGTGGAAGGATCATTACCACACCTAAATATCCACGTGAACCGTTTAGATTTGTTTTGTGCGTCGCTGATGCTTGAATGCTGGGTTTCGGTCCGGCGTCGCTGATGCTTGATGCTAAACGAAGGGGCGTTCGGTGACGTTTGGCTTTTGCTATTTTCCGTCTTGAACAAACCAGATTGTTGGGGGGTCTCGTTGCGGTAGGCGGCTTCGGCTGCTGGCTGCTTGGAGCGTCTCGGCGGTAGGTGGCTTCGGCTACTGGCTGCTTTGAGCAAACCGATGATTTGGTGCGATCGACGATGTGTGGCTCTGGCTGTTGCCTTGAACAAACCGATGTAACTTTTTAAACCATTTCCTAATACTGATTTATACTC');
INSERT INTO marker_sequence VALUES(144,'bb04f7764615f35f290ec81ed57a285d','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAATCTTTCCACGTGAATTGTTTTGTACACTGTTGGGTTTCGCTGGCGCGTGTTTTCTTGTCGAATGTAGTGTTTGACGGCGCGCGGCGGCTGGAGGCCATCAGGGCGTCTGTTGTTGTGATGGACGCTCTTTTTGTAAACCCCCTTTTTTTTGTTATTTTGTGAAACTGATTGTACT');
INSERT INTO marker_sequence VALUES(145,'1ba4dfd7af0dd5c02769b16641baaafb','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACATCTTTCCACGTGAACCGTTTGTGACATGGTTGGGCTTGTGCGTTTTCTCTCTCTCTCTTTTGGGGGAGGGGATGCGTGCGAGCTATCTGTAAACTTGTCAAACCCATTCTTTTGATAACTGAAACATACT');
INSERT INTO marker_sequence VALUES(146,'5af8bd9fecdc11a35378b4bd68f4b5fe','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTTCACGTGAACCGTTGAGTATTGTTGGGGACTTGTTCGGCGGCGTGCGCTTTTCGGAGCGCGTGCTACTGGGCGAGACCTATCATGGGCGCGATCGCTCGGGCTTCGGTCTGGGCTAGTAGCTGCTCTTTTTTAAACCCATTCGTAATGACTGAATATACT');
INSERT INTO marker_sequence VALUES(147,'2e0b58e8c1868ccee83b69cbcb38d807','TTCCCGTAGGTGAACCTGCGGAAGGGATCATTACCCACACCTTAAAAAACTTTCCACGTGAACCGTATTAACAATTATAATTGGNAGGGTGATCTTAATGGAGGGCTACTGGTCATTTTTGACTGGAGGCTACTATCGAGTGAACCTTATCATGACGAAAAATTAGGCTTATGTCTAGTGAAGTAGTGAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(148,'c235f6ea18ec86df70cc0b1652b5de7c','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAATTTGGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO marker_sequence VALUES(149,'0b05ab6b8fb55f6d437a0fc7406df0e8','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCTTCTCTTTTAAACCCATTCCTAATGACTGAATATACT');
INSERT INTO marker_sequence VALUES(150,'0da6aab1797bea65158e304dbda9eff6','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO marker_sequence VALUES(151,'51c2049cc591015dda17da26c85cd4e1','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGATGTCAAAGTCCGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(152,'53e1a65ecf593b64bbb48b74478782ad','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTCCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO marker_sequence VALUES(153,'06a6d3654806b1a7b908f7643e48ed2b','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCATATTTTCTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO marker_sequence VALUES(154,'4d5fa3f36faef5add3740adc94624936','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(155,'2b13ab9a70c1db5c7ec0abed13e925fa','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(156,'fcc64a72a6b0440c24b223279df24eec','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(157,'1044332b717569424a4d5ae2bad695e8','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACAACTTTAATTGGGGGTGATCTTGACGGTAGCTACTGGTTTTTTACTGGCGGTAACCATTGAGTGAACCTCATCATGACGAACCGTTGGGCTTTTGCCTGACGTAGTAGAATAAATTTTAAACCCTTACTTAATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(158,'8513f958408b8a4a3b7c44620bc2c19a','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATTAACAATTATAATTGGGGGTGATCTTAATGGAGGCTACTAGTCATTTTGGCTGGAGGCTACTATCGAGTGAACCTTATCATGGCGAAAAACTAGACTTTTGTTTGGTGAAGTAGTGAAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(159,'6d85285e77611ff5d472b91005d2437d','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACAATCCACGTGAACCGTATCAACCCAATAATTGGGGGTTTACTTGGCGGCGGCTGCTAGCATCTTTTTGCTGGCTGGCTACTGCTGAGTGAATCCTATCGCGAGCGTTCTGACTTCGGTTGGAGCTAGTAGCTTAACTTATAAACCCTTTCTTAAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(160,'856d53c7a6d239561ae28b79bbf5d941','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAACAATCCACGTGAACCGTATCAACCCAATAATTGGGGGTTTACTTGGCGGCGGCTGCTAGCATCTTTTTGCTGGCTGGCTACTGCTGAGTGAATCCTATCGCGAGCGTTCTGACTTCGGTTGGAGCTAGTAGCTTAACTTATAAACCCTTTCTTAAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(161,'e728e682481346b013c6d197dd53f2e6','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCAATAACTTGGGGGTTTAATTGGCGGCTGCTGCTGGTATCTTTTTACTGGCTGGCGGCTGCTGAGCGAACCCTATCGTGAGCGTTCTGACCTTGGTTGGAGCTAGTAACTTAAATTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(162,'6fbeade395be8dbcf9beca25ccbc2d07','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCAATAATTTGGGGGTTTAATTGGCGGCTGCTGCTGGTATCTTTTTACTGGCTGGCGGCTGCTGAGCGAACCCTATCGTGAGCGTTCTGACCTTGGTTGGAGCTAGTAACTTAAATTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(163,'5f6e5cf246ace4ab7809083ec0ab0f7d','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATTAATTGGGGGTTTTATTGGCGGCTGCTGCTGGCATCTTTTTGCTGGCTGGCGACTGCTGAGCGAACCCTATCATGGCGAGCGTTCTGACCTCGGTTGGAGCTAGTAGCTTGCATTTTAAACCCATTCTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(164,'fe8e4668ef29f3e3de3dd7bf3b5fdc5e','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTTCCACGTGAACCGTATCAACCCAATTAATTGGGGGTTTTATTGGCGGCTGCTGCTGGCATCTTTTTGCTGGCTGGCGACTGCTGAACGAACCCTATCATGGCGAGCGTTCTGACCTCGGTTGGAGCTAGTAGCTTGCATTTTAAACCCATTCTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(165,'3b3d7017bb0704e653f1013630ca487e','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTATTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(166,'fd18002dfea696481aa89788dc794cba','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGTCGGGCTCTATCATGGGCGAGCGTTTGGGCTTGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(167,'3058d6421cffeac1fd0bbb9978b787a4','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTTTCAACCAAATATTTTGGGGGTCTTGTCTGGCGTATGGCTGCTGCTGTAAAAGGCGGCGGCTGTTGCTGGGTGAGCCCTATCATGGCGAACGTTTGGGCTTCGGTCTGAACAAGTAGCTCTTTTATAAACCATTACTTTTTACTGATTATACT');
INSERT INTO marker_sequence VALUES(168,'475cd908a78967e65e144153ef9820d7','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(169,'f945858f0b811b505119f9fbd4eb356d','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCGAGTAGCCTTTTGTTTTAAACCCATTTCTCAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(170,'3b727c62621b67a073e326975cfa1cad','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCTGGACGAGTAGCCTTTTGTTTTAAACCCATTTCTCAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(171,'835aa47db171a3ebf793ad23e5b3fb9a','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACTTTAAAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTGACTGAGCTGGTGTTTTCATTTTTGGACACTGGAACGGGAGTCAGCAGGACGAAGGTTGGTCTGTTGTAATGCAAGTTATGATGGACTAGCTGATGAACTTTTGTTTTTAAACCCTTACCTAAATACTGATTTATACT');
INSERT INTO marker_sequence VALUES(172,'10a03f57248843ddf484e2d87a7b8473','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACTTTAAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTAACTGATTTCGTGTGTTTTCCTATTTTTGGACACTAGAAGACAGGATTCAGCAGGACGAAGGTTAGTCTCTCTTAATGCAAGTTAGGAGGAGGATTAGCTGATGAACTTTTNTTTTTAAACCCTTACCTAAATACTGATTTATACT');
INSERT INTO marker_sequence VALUES(173,'370005b0daef9507e9b65c8d2f8d70af','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGCTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(174,'60c91384928b4233ce2d4c529462716f','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(175,'9025fdfe8864e9671f4bdb3742520708','TTTCCGTAGGTGAACCTGCGGAGGATCATTACCACACCTAAAAAATTTCCACGTGAACCGTTTCAACCAAAAGTTGGGGGTCTTGTTTGGCGGTGACTGCTGGCTTTATTGCTGGCGGCTGCTGCTGGACGAGCCCTATCATGGCGAAAGTTTGGACTTCGGTCTGAGCTAGTAGTTATTATTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(176,'f536a0b271339b12326e25148e6aa2aa','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTCAGTTGGGGGCCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(177,'e0878938e6b23431cc66f1695359875a','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCTCAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(178,'de16621f8d58a174870c5a53995ef7aa','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAATCTTTCCACGTGAACTGTTTTTGTAAATTTGGGCTTCGCCTGCTGCGTTCTTTTACCATTTAATTATTTATTTTTTTCTTTGGTGAGGGAATGCGACGGCTTGAGGCCATCAGGGTGCGCTTGCTTGGTTACTTTTGTTTGTACCATTCAAAAAAATGTAATCGAGCGAGTGCGCTCTTTGTCAACCCATTTCTTTTGAAACTGATTATACT');
INSERT INTO marker_sequence VALUES(179,'708813ddaef97718f2c301884a0bca41','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAATCTTCCACGTGAACCGTATCAACCAATTAATTGGGGGCTTTCTTGGCAACGGCTGCGAGCATCTTTTTGCTGGCTAGTTCTTGCGGAGGAAGCCCTATCATGGCGAGCGTTCGGACCTCGGTCTGAACTAGTAGCTTCAACTTGTAAACCCTTTCCTAATTACTGAATATACT');
INSERT INTO marker_sequence VALUES(180,'92e3f27103b24dd4889e47553f1714fc','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAATCTTTCCACGTGAACCGTATCAACCCAATACATTGGGGGTTAGCTTGGTGGTGGCTGCTGGCATCTTTTTGCTGGCTGGCTGCTGCTGAGCAAGCCCTATCATGGCGATCGTACGGACTTCGGTCTGAACTAGTAGCTTCAATTGTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO marker_sequence VALUES(181,'bfa53084c50e0c682fcb537ca8309205','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACAACTTTAATTGGGGGTGATCTTGGTGGTGGCTACTAGTCTTTGGCTGGTGGTAACTACTAGGTGAACCTCATCATGGCGAACCATTGGGCTTTTGTCTAATGTAGTAGTATAAATTTTAAACACTTACTTAATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(182,'ebaf56e503ad9ea65861df2155fd3b2a','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACAATTTAAATTGGGAGCGATCTTGGTGGTGGCTACTAGTCTTTTGGCTGGTGGCTACTATTGGGTGAGCTCCATCATGGCGAACCATTGGACTTTGTCTAATGTAGTAGTATAAATTTTAAACCCTTACTTAATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(183,'41633fca3ba2580f02234d6f6bda6568','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCACCCATTTGGGGGTTTGTTTGGCGACTGCTACTGGCATCTTTTTGCTGGCTGCTGTTTCTGGGCAAACCCTATCATGGCGAGCGCTCGGACCTTGGTCGGAGCTAGTAGCTTTCTTTTAAACCCATTCTTAATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(184,'93ea3dd682f13feec67aeaad84db6ce4','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTATCAACCTAATAAATTGGGGGTTTAATTGGCGGTGGCTGCTGGCATCTTTTTGTTGGCGGCTGTTGCTGAGCAAGCCCTATCATGGCGAACGTTTGGACCTCGGTCTGAACTAGTAGCTTTTATTTTAAACCCTTTCTTAATTACTGAATATACT');
INSERT INTO marker_sequence VALUES(185,'255a21ada2166aa92c2888c34bfa43c1','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTATCCACGTGAACCGTATCAACCCAATTAATTGGGGGTTTAATTGGCGGCGGCTGCTGGCATATTGCTGGCTGGCTGCTGCTGAGCGAGCCCTATCATGGCGAGCGCTTGGGCTTCGGTCTGAGCTAGTAGCTTTTATTTTAAACCCATTCTTAATTACTGAATATACT');
INSERT INTO marker_sequence VALUES(186,'8923222158a12cc3586e1c920c0eb9b5','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATTAATTGGGGGTTTAATTGGCGGCGGCTGCTGGCATATTGCTGGCTGGCTGCTGCTAAGCGAGCCCTATCATGGCGAGCGCTTGGGCTTCGGTCGGAGCTAGTAGCTTTTATTTTAAACCCATTCTTAATTACTGAATATACT');
INSERT INTO marker_sequence VALUES(187,'33ef3d9a577f74c0af17a7b08ab17b6e','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCTAATTAATTGGGGGCTTAATTGGCGGCGGCTGCTGGCATCTTGCTGGCTGGCTGCTGCTGAACGAGCCCTATCATGGCGAGCGCTTGGGCTTCGGTCTGGGTTAGTAGCTTTTATTTTAAACCATTCTTAATTACTGAATATACT');
INSERT INTO marker_sequence VALUES(188,'7026eab909f51daa1e6d447b943d5563','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTATCAACCCCATTAATTGGGGGTTTTGTTTGGCGGTGATCGCTAGCTTAATTGCTGGTTGATTACTGCTAGGCGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTATTTTAAACCCTTTCTTAATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(189,'5cdd7c7d5c8fab6c0ddc0f117d3633e3','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATTCAACAATTATAATTGGGGGTGATCTTGGTGGAGGCTACTAGTCATTTTGGCTGGAGGCTACTATAGAGTGAACCTCATCATGACGAAAAATTAGGCTTTTGTCTAGTGAAGTAGTGAAAATTTTAAACCTTACTTAATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(190,'e3e5a040ac67cdfcda4f2cb6c8af4829','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATTCAACAATTATAATTGGGGGTGATCTTGGTGGAGGCTACTAGTCATTTTGGCTGGAGGCTACTATAGAGTGAACCTCATCATGACGAAAAATTAGGCTTTTGGTCTAGTGAAGTAGTGAAAATTTTAAACCTTACTTAATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(191,'826aec1ee8a066f97a0eeaa26747e320','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATTAACAATTATAATTGGGGGTGATCTTAATGGAGGCTACTAGTCATTTTGGCTGGAGGCTACTATCGAGTGAACCTTATCATGGCGAAAAACTAGACTTTTGTTTGGTGAAGTAGTGAAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(192,'d4f0f164d6b1f6bf2e2f1f08e11008fb','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATTAACAATTATAATTGGGGGTGATCTTAATGGAGGCTACTAGTCATTTTGGCTGGAGGCTACTATCGAGTGAACCTTATCATGGCGAAAAACTAGACTTTTGTTTGGTGAAGTAGTGAAAACTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(193,'b9cd13d5a142a34fa9a27ae4b1a5a8ce','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAACAACTTAAATTGGGGACGAAGATCTTGGTGGTAACTACTAGTCTCGACTGGTGGTAGCTACTAGGTGAGTAGTCTCATCATGGCGAACCATTGGGCTTTTGTCTAATGTAGTAGTATAAATTGTAAACACTTACTTAATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(194,'b41a92def772e860fbb8eac8172ea242','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTCCACGTGAACTGTATCAACAACTTAAATTGGGGACGAAGATCTTGGTGGTAACTACTAGTCTCGACTGGTGGTAGCTACTAGGTGAGTAGTCTCATCATGGCGAACCATTGGGCTTTTGTCTAATGTAGTAGTATAAATTGTAAACACTTACTTAATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(195,'863482727724d44031d5d6ef252cac3e','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAACTTTCCACGTGGACCGTTCAACAAATGAATTGGAGGCGATCTCGGTGGCGGCTGCTGGTCTTTTGATTGGCTGGCTGCTACTTTGTGAGCCTCATCATGTCGAACAATTGGACTTCGGTCTGATGTAGTAGTATTCTTTTAAACCATTACTTCATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(196,'715ffa19d36ed46d2755b609191b3c01','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATTCAACAATTATAATTGGGGGTGATCTTGGTGGAGGCTACTAGTCATTTTGGCTGGAGGCTACTATAGAGTGAACCTCATCATGACGAAAAATTAGGCTTTTGTCTAGTGAAGTAGTGAAAATTTTAAACCTTACTTAATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(197,'56ceaf4df9464d7509f1c99541f2c4ed','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGGACCGTTTCACAAATGAATTGGAGGCGATCTCGGTGGCGGCTGCTGGTCTTTTGATTGGCTGGCTGCTACTTTGTGAGCCTCATCATGTCGAACAATTGGACTTCGGTCTGATGTAGTAGTATTCTTTTAAACCATTACTTCATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(198,'4bf8c2745368880ccc4522be8998707b','TTTTCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACAATTATAATTGGGGGTGATCTTGGTGATGGCTACCAGTCTATGACTGGCGGTCTACTGAGTGAACCCTATCATGGCGAACCATTGGGCTTTGGTCTAATGTAGTAGTATAAATTTTAAACCCTTACCTAATTACTGATTTACT');
INSERT INTO marker_sequence VALUES(199,'b04e88ef83262ac85a7573fcd12d7384','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACACACCTAAAACTTTCCACGTGACGTATCACAATTATAATTGGGGGTGATCTTGGTGATGGCTACCAGTCTATGACTGGCGGTCTACTGAGTGAACCCTATCATGGCGAACCATTGGACTTTGGTCTAATGTAGTAGTATAAATTTTAAACCCTTACCTAATTACTGATTTACT');
INSERT INTO marker_sequence VALUES(200,'30e386355fec666b8f9a191fbd9110fc','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAACTTTCCACGTGAACTGTATCACAATTATAATTGGGGGTGATCTTGGTGATGGCTACCAGTCTATGACTGGCGGTCTACTGAGTGAACCCTATCATGGCGAACCATTGGGCTTTGGTCTAATGTAGTAGTATAAATTTTAAACCCTTACCTAATTACTGATTTACT');
INSERT INTO marker_sequence VALUES(201,'0f215d00d967a49a40b5134549ad7ba3','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAACTTTCCACGTGAACCGTATCACAATTATAATTGGGGGTGATCTTGGTGATGGCTACCAGTCTATGACTGGCGGTCTACTGAGTGAACCCTATCATGGCGAACCATTGGGCTTTGGTCTAATGTAGTAGTATAAATTTTAAACCCTTACCTAATTACTGATTTACT');
INSERT INTO marker_sequence VALUES(202,'3c40ffb101830dc1d5c3df83b36082b7','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATTAACAATTATAATTGGAGGTGACCTTAATGGAGGCTACTAGTCATTTTGGCTGGCGGCTACTATCGAGTGAATCTCATCATGGCGAAAAATTAGGCTTCGGTCTAGTGAAGTAGTGAAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(203,'79d7a18d5a009bf7ad9557cb4b97d9c2','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATTACAATTATAATTGGAGGTGACCTTAATGGAGGCTACTAGTCATTTTGGCTGGCGGCTACTATCGAGTGAATCTCATCATGGCGAAAAATTAGGCTTCGGTCTAGTGAAGTAGTGAAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(204,'93ce19c8d140792dc9864b3100ff4bb5','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGACCGTATTAACAATTATAATTGGAGGTGACCTTAATGGAGGCTACTAGTCATTTTGGCTGGCGGCTACTATCGAGTGAATCTCATCATGGCGAAAAATTAGGCTTCGGTCTAGTGAAGTAGTGAAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(205,'9240f7d151759ca688a64c91eb24987b','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGGACCGTCTCAACAAATGAATTGGAGGCGATCTCGGTGGCGGCTGCTGGTCTTTTGATTGGCTGGCTGCTACTTCGTGAGCCTTATCATGTCGAACAATTGGACTTCGGTCTGATGTAGTAGTACTTTTTTAAACCATTACTTTACTACTGATTATACT');
INSERT INTO marker_sequence VALUES(206,'18d58d7cf3403b57e0d94f0bbf83dca0','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGGACCGTTTCAACAAATGAATTGGAGGCGATCTCGGTGGCGGCTGCTGGTCTTTTGATTGGCTGGCTGCTACTTCGTGAGCCTTATCATGTCGAACAATTGGACTTCGGTCTGATGTAGTAGTACTTTTTTAAACCATTACTTTACTACTGATTATACT');
INSERT INTO marker_sequence VALUES(207,'f34f88e4c1ca303a88f2d648e626079d','TTTCCGTAGGTGAACCCTGCGGAAGGATCATTACCACACCTAAAACTTTCCACGTGGACGTTTTACAAATGAATTGGAGGCGATCTCGGTGGCGGCTGCTGGTCTTTTGATTGGCTGGCTGCTACTTCGTGAGCCTTATCATGTCGAACAATTGGACTTCGGTCTGATGTAGTAGTACTTTTTTAAACCATTACTTTACTACTGATTATACT');
INSERT INTO marker_sequence VALUES(208,'d936c7a268cb71e1fa8e3ea9b1e6c2ca','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAACTTTCCACGTGGACCGTTTCACAAATGAATTGGAGGCGATCTCGGTGGCGGCTGCTGGTCTTTTGATTGGCTGGCTGCTACTTTGTGAGCCTTATCATGTCGAACAATTGGACTTCGGTCTGATGTAGTAGTACTTTTTTAAACCATTACTTTACTACTGATTATACT');
INSERT INTO marker_sequence VALUES(209,'d6b8e74a58fbe5d993b65de811735cb9','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACAATTTTAATTGGGGGTGATCTTGGCGGTAGCTACTGGTTTTGTACTGGCGGTAACTATTGAGTGAACCTTATCATGACGAACCGTTGGGCTTTTGTCTGGCGTAGTAGAATAAATTTTAAACCCTTACTTAATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(210,'c5ab809f6fbfee2f97373c411096ecc5','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACATTTATAATTGGGGGCGATCTTGGCGGCGGCTACTAGTCTATGACTGGCGGCGGCTACTGGGTGAGCCTCATCATGACGAATCGTTGGGCTTTTGTCTAATGTAGTAGTAAAATTTTAAACCCTTACCTAATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(211,'5ec367879dbc8a844e32fc2faf53684b','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAACTTTCCACGTGAACCGTATCAACATTTATAATTGGGGGCGATCTTGGCGGCGGCTACTAGTCTATGACTGGCGGCGGCTACTGGGTGAGCCTCATCATGACGAATCGTTGGGCTTTTGTCTAATGTAGTAGTAAAATTTTAAACCCTTACCTAATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(212,'11209f488e9451525341984073b9c972','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTCCACGTGAACCGTATCAACTTTTTTAATTCGGGGGACGCTAGGTGGCGATTGCCGGTCTCTTTGACTGGCGATTGCTACTAGGCGACTCAACCGTGGCTAAGGTCAGGCTTCTGTTTGATAACTTAGTGATATTGTAAACCATTCTTTAATTACTGTATACT');
INSERT INTO marker_sequence VALUES(213,'90c45b44fd7abb30407b209a8049c4a3','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTCCACCGTGAACCGTATCAACTTTTTTAATTCGGGGGACGCTAGGTGGCGATTGCCGGTCTTTTTGACTGGCGATTGCTACTAGGCGACTCAACCGTGGCTAAGGCCAGGCTTCTGTTTGATAACTTAGTGATATTGTAAACCATTCTTTAATTACTGTATACT');
INSERT INTO marker_sequence VALUES(214,'a4081b4f14371f872a28aaa1c4d21b44','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTCCACCGTGAACCGTATCAACTTTTTTAATTCGGGGGACGCTAGGTGGCGATTGCCGGTCTTTTTGACTGGCGATTGCTACTAGGCGACTCAACCGTGGCTAAGGTCAGGCTTCTGTTTGATAACTTAGTGATATTGTAAACCATTCTTTAATTACTGTATACT');
INSERT INTO marker_sequence VALUES(215,'44473736a9868c934c5be8456c0256f9','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTCCACCGTGAACCGTATCAACTTTTTTAATTCGGGGGACGCTAGGTGGCGATTGCCGGTCTTTTTGACTGGCGATTGCTACTAGGCGACTCAACCGTGGCTAAGGTCAGGCTTCTGTTTGATAACTTAGTGATATTGTAAACCATTCTTTAATTACTGTATACT');
INSERT INTO marker_sequence VALUES(216,'4c2ca12e8525ec7de8f3a3671e01b626','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTNCACGTGAACCGTATCAAACCAATTCATTGGGGGTTTGTTTGGCGGCGGCTGCTGGCATCTTTTTGCTGGCTGCTGCTGCTGAGCGAGCCCTATCATGGCAAGCGCTCGGACCTCGGTCGGAGCTAGTAGCATTCATTTTAAACCCATTCCTAATGACTGAATATACT');
INSERT INTO marker_sequence VALUES(217,'c83e20e2c5832013e0a68552564a9dd9','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACGCCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGATGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(218,'3bdf5286000b2ca5eb7b90835e3cc935','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGATGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(219,'77adca129f2d827c43c57ce137e33515','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(220,'7544808057374eb181cc4a2e3334faae','TCCGTACGTGAACCTGCGGAAGGATCATTACCACACTTTAAAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTGACTGAGTCGGTGTTTTCATTTTTGGACACTGGAACGGGAGTCAGCAGGACGAAGGTTGGTCTCTCGTAATGCAAGTTATGGGGGACTAGCTGATGAACTTTTCTTTTTAAACCCTTACCTAAATACTGATTTATACT');
INSERT INTO marker_sequence VALUES(221,'5045df00b7ef969171c5c55bb2133907','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTATCGAACAACTAGTTGGGGGTCTTGTTTGGCGTGCGGCTGCTTCGGTAGCTGCTGCTAGGCAAGCCCTATCACGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTATTTTTTAAACCCATTCTTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(222,'fe95518c0a00500728a72f4605e5bbd7','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTATCGAACAACTAGTTGGGGGTCTTGTTTGGCGTGCGGCTGCTTCGGTAGCTGCTGCTAGGCGAGCCCTATCACGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTATTTTTTAAACCCATTCTTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(223,'d9b1961bdc806d3a2815ea4c035ad2e8','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACTTTAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTGACTGATCTGGTGTTTTTGGATACTGGATCGGGAGTGAGCAGGACGAAGGTTGGTCTCGTAATGTAAATTATGGGACTAGCTGATGCATTCGTTTTTCAAACCCTTACCTAAATACTGATTGATACT');
INSERT INTO marker_sequence VALUES(224,'47a8a864eb87593a23f664638e2f87a4','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCAAAAACTTTCCACGTGAACTGTCATTGCATGTTTTGTGCCTTTAATTAGGCTAAACGAAGGTCGGAGTAAAATCTGGCTGATCTATTTTTTAAACCCATTCTTAAACACTGATTTATACT');
INSERT INTO marker_sequence VALUES(225,'a86e864c63e41412c76902e56ff2ce9e','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTCTAAATATGTTCTGTGCTTCGTCGAACCGGACTGCTCTCTTTTTTGAGGATAGTCTTGCGACGGCTTGAGGCTGAACGAAGGCTTGCTCAGTAACTCGTATGACTCTCGGGTTGTACGGCGGAACTGCTAGCCGATGTCTTTTTCAAACCCATTTTACTAAACACTGATCTATACT');
INSERT INTO marker_sequence VALUES(226,'58f037eddc83ec4fb217818a33cfbf0c','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCCGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGATGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(227,'d0fbcc7c0c60219018e29330c7b101a9','TTCCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAAAACCCTTAGTTGGGGGCTTCTGTTCGGCTGGCTTCGGCTGGCTGGGCGGCGGCTCTATCATGGCGAGCGCTTGAGCCTTCGGGTCTGAGCTAGTAGCCCACTTTTTAAACCCATTCCTAAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(228,'17941b175ac7798ad8b9556063659808','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTTAAAACTATCCACGTGAACCGTTTGTACCAAGATTTGCGTCAAGATGTTTGTGCATGTTTGTTGTATCACTGTGTATTCGTACGCGGTGTGTGGCAAGTATGTATGACGCTTGGCTGATCGAAGGTCGTGTCGCACTTGATTGTGTGTATCGGCTGACTTATTTTTCAAACCCATTCTTTAGTACTGATTATACT');
INSERT INTO marker_sequence VALUES(229,'b3979d23e362a1c73671ad4b26e75d98','TTTCCGTAGGTGAACCTGCGGAAAGGATCATTACCACACCAAAAATCCTTTCCACGTGAACTGTCGTATTTGATTCGCGCCGTGACGTGTGTCGTCGCTGCGTGTGCGTTTGTGCGTGCGTCTTCTTGGAGATGTGTGCGCGAGTGCGCGCGTGGCGGTGACTGCGTGGGTCGGCTGATCGAAAGGTCGCTTTGCGCTGTCTGGCGCGGAGCGGCTGACTTATTCTTTCAAACCCATTCGTTAGTACTGAAACATACT');
INSERT INTO marker_sequence VALUES(231,'77015eca7216898e734fb21eb0ac49b3','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACTGTCGTTATTTGTTGTGTGTGTGCGCGTTGGTAGCATGCGCGTTTGCTTACGCTTCGGTGTTTGCGAGTGCGCGTGCTGGCGGTGCGCAGACTGAACGAAGGTCGTGTGTTTGCTGTGTGCCTGCTGCACCGCTGACTTTTGCATTGATTTGCATGATGTTGGCGGAGCGGCGGGTGCTGTGCGTGCGCGCGGCTGACCTATTTTTTTCAAACCCCATACCTAAATGACTGATTATACT');
INSERT INTO marker_sequence VALUES(232,'41393538e0b610b4253a37bb7556bb11','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTCGTTATTTGTTGTGTGTGTGCGCGTTGCTGGCGTGCGTTTGCTTACGCTTCGGTGTTTGCGAGTGCGTGCTGTCGGTGCGCGGACTGAACGAAGGTCGTGTGTTTGCTGTGTGCCTGCTGCACCGCTGACTTTGCATTCATTTGCATGGTCTTGGCGGAGCGGCGGGTGCTGTGCGTGCGCGGCTGACTTATCTTTTTCAAACCCCATACCTAAATGACTGATTATACT');
INSERT INTO marker_sequence VALUES(234,'a96b601c63eb6756e2ead804d37a05ef','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTCTGTATTTGTTTTGTGTGTGCGCGTTGCTGGCGTGCGTCTGCTTTGCATGAATGTGCGTTGCGGGTGCGTGCTGGCGGTGCGCGGACTAAACGAAGGTTGGTTGTCTGTGCGTCTGCGGATCTGCTGTGCTGAGCTTCATTGTTTGGCGTGGCGGGTGTTGCGGGTGCTATTTTGACCGGCTGACTTATTTTTTCAAACCCCATACCTAAATGACTGATTATACT');
INSERT INTO marker_sequence VALUES(235,'d67f2fef4ac44379625d4ecf95900bdc','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTCATTATTTGTTGTGCGCTCTCTGCGGTGTCGGTGGCGTCTGTTGGCTGTATTTGATACTGCTGGCGGGTGCGAGCCGGATGCAGAGGCTGAACGAAGGTCGAGTTGCTTTGCTCTCGGCTGACTTATTTTTTCAAACCCAATACCCAACTTACTGATTATACT');
INSERT INTO marker_sequence VALUES(236,'90a17bbda9d128a73db4d4ca28dee8d4','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTCTTACTTAGTTTTGCGCTGCTGTCGGGAGTGTTCTGCGTGCGCGCTTGCACGGAGAGCGTTTCTTGCAACGGCTGAACGAAGGTTGGTGGCGTCTTGTCTTCTTTGCGTGCTTGATTGTATGCGGGAGACGTACGCCGCCGGCTGACTTACTCTTTCAACCCCATTACGAAACAAACTGAAGTATACT');
INSERT INTO marker_sequence VALUES(237,'70a723a08a44decb5d674755e42f2249','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTCTTACTTAGTTTTGCGCTGCTGCGAGGGGGTGTTCTGCGCACATGTGCGTAGGGCGTCTTTTGCGGCGGCTAAACGAAGGTTGGTTGAGTGTTGTTGTGCGTGCTTTATTGCGCGCCGTCGTACGCTTGCCGGCTGACTTATTTTTTCAACCCCTTTTAACTTACAACTGAATTATACT');
INSERT INTO marker_sequence VALUES(238,'1660d452397da144120f7eda91b85982','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCAAAAAACTTTCCACGTGAACTGTCTTAGCATGTTTTGTGCCTTTTATTAGGCTAAACGAAGGTCGGAGTAAAATCTGGCTGATCTATCTTTTTAAACCCATTACTTTATTACTGATTTATACT');
INSERT INTO marker_sequence VALUES(239,'6f1aa39f52d96240df6a5aa9f6733e66','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCAAAAACTTTCCACGTGAACTGTCTTAACATGTTTTGTGCCTTTTAATTAGGCTAAACGAAGGTCGGAGTAAAATCTGGCTGATTTATCTTTTTAAACCCCTTACTTAATTACTGATTTATACT');
INSERT INTO marker_sequence VALUES(240,'723addf7247cc370289affd5bd44936b','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCAAAAAACTTTCCACGTGAACTGTCTTAACATGTTTTGTGCCTTTAATTAGGCTAAACGAAGGTCGGAGTAAAATCTGGCTGATCTATCTTTTTAAACCCCTTACTTAATTACTGATTTATACT');
INSERT INTO marker_sequence VALUES(241,'34120df98bc9aca34cdb9a3142919a7a','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTCAAACCTGTTCTGTGCTTGTGCTGGGTCTGCGTTTTCGGACGCGGACGCGGCGGAGGCTGAACGAAGGCTGGTTTCATTTGTATGAGATCAGCTGATATATTTTTTCAAACCCCTTTTTTACAAAATGACTGATCAATACT');
INSERT INTO marker_sequence VALUES(242,'79fcddffa171bab6dc1cb9d8d1633408','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACTTTAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTGACTGATCTGGTGTTTTCGGATACTGGATCGGGAGTCAGCAGGACGAAGGTTGGTCTCGTAATGTAAATTATGGGACTAGCTGATGCATTCCTTTTTCAAACCCTTACCTAAATACTGATTGATACT');
INSERT INTO marker_sequence VALUES(243,'72bab5ead7563838ced9566a9273817c','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCAAAAAAACTTTCCACGTGAACCGTTTTGTGCGTTTTGTGCTTTGTGTTTGCTTTTGTTTGTCTCGCTCTTCGGGGTGTGGTGGACAAGAGGAAGCGCAAGGCTAAACGAAGGCTGCGAGTCTCGTGCTTGCGGCCGATTTATTCTTTCAAACCCATACATTAAACACTGAACTATACT');
INSERT INTO marker_sequence VALUES(244,'b36b5e9e0544064810e75a157831bc54','TTTCCGTAGGTGAACCTGSGGAAGGATCATTACCACACCTAATAAACTTTCCACGTGAACCGTCAACCCAGCCAGTTTAGCGTCACTTTGTGTGCGTCTTTTCTCGATTGCCGTTTTTAATGAAATGGCGAGAGAGGGGAAACAAGCGCAATTTAGACAGAACGAAGGTCGAGCTGTTTTTCTATTCGTAGTGAGACGGCTTGGCTGATTTATTCTTTTCAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(245,'58abf2d07461a8d8725bc8300f5aadfc','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAATAAACTTTCCACGTGAACCGTCAACCCAGCCAGTTTAGCGTCACTTTGTGTGCGTCTTTTCTCGATTGCCGTTTTTAATGAAATGGCGAGAGAGGAGAAACAAGCGCAATTTAGACAGAACGAAGGTCGAGCTGTTTTTCTATTCGTAGTGAGACGGCTTGGCTGATTTATTCTTTTCAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(246,'0916adb8d3909e059eb787b1089f8256','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTCAAATGAAACTAGTTTTGTGCCGGGTTGTGTGCGTTCTTAACGGAACAAGCGCGGCCTGGCTAAACGAAGGTCGAGTTGTTTTTCCTTTATTGGAGAGACGGCGTGGCTGATTTATTTTTCAAACCCATTACCTAAATACTGATGATACT');
INSERT INTO marker_sequence VALUES(247,'80da1f71212fb400df0c284672b31c10','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAATCTTTCCACGTGAATTGTTTTGTTGTAAGTTGGGCTTCGCTGGCGTGTTCTGTTTTCGGACGGAGCGCAACGGCTTGAGGCCATCAGGGCGTTTATTGTGTCGTGCAGTATTCGCTCTTTTTGTAAACCCATTTTTGATGAAACTGATTATACT');
INSERT INTO marker_sequence VALUES(248,'559fdd3bdc30917df45fa305f1e7d36f','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAATCTTTCCACGTGAATTGTTTGTCGTTGTTTGGGCTTCGCCTGCGCGCTTTGTTTCGTTCTGTTTTTGTTCGGACGAGGTGCAACGGCTTGAGGCCATCAGAGCGTTTTATTTGTGCTTTTGTACGAGTAATCGCTCTTTTTTGTAAACCCCTTTTTTTTTTAACATGAAAACTGATTTATACT');
INSERT INTO marker_sequence VALUES(249,'6d9139626cac4cc6c265b62636b8b8a6','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAATCTTTCCACGTGAATTGTTTGTTGCAATGTTGGGCCTCGCTGGGCTAGGATTTTCCTGGTTCGGTTGGAGGTCATCAGGGCGTGTCGTTGCTTTGTGATTCGTTTTGCATGGTGTCGCGCGCTCTTTTTGTAAACCCATTTAATTGAAACTGATTATACT');
INSERT INTO marker_sequence VALUES(250,'aaac9608e2bc6c8d19ccb91f3fabb70b','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACATCTTTCCACGTGAACCGTTTGTGACATGGTTGGGCTTGTGCGTGTTCTCTCTGTTTTGGGGGGAGGCGTGCGAGCTATCTGTAAACTTGTCAAACCCATTCTCTTTGATAACTGAAACATACT');
INSERT INTO marker_sequence VALUES(251,'b217c3d3022a4f6b354be5ec16acc31e','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACATCTTTCCACGTGAACCGTTTGTGACATTGTTGGGCTTGTCTTTCTTTCGGGGAGGATGAGCTATCTGTAAACTTGTCAAACCCCTTTCTTTTTTTATAAAACTGAAACATACT');
INSERT INTO marker_sequence VALUES(252,'b717c1ab773e83a1a52d6fa8dea6157e','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCAAAAAAACTATCCACGTGAACCGTTAAGTAAAAGTCTAGTTGGCTTGTGTTGTTGGGGAGTGTGTTGGGAAAAGCTTGGAGATGTCTTTGGATATTTCGATGCGTAGTACTGGTCATTCTAACGAGCGAGTCGGGTAGCAACGAAGGTCGGGAGTTCGCTTGCGGACTGATGTGCGCTTGTCGCATGTCGGTCGAAAGGCTTGAGCAAACGGCTGATCTATTCMTTTTAAACCATACCATAAGTACTGATTATACT');
INSERT INTO marker_sequence VALUES(253,'33f32a66a3b03e9cf6348ebfb784d87d','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCAAAAACAACTTTCCACGTGAACTGTCGTACGAGATTCGCGCCGTGACGCGTGTTGGCGCTGTGTGTGTCTGTCTGTGTCTTCTTTCGGGAGGATGTGGATGGATGGTGCATGGCGTTGACCGCGTGGGTCGGCTGATCGAAGGTCGCGTTGTGCATTCTTGCATGGCGCGGCTGACTTATTCTTTCAAACCCATTACTAATACTACTGATTCATACT');
INSERT INTO marker_sequence VALUES(254,'6c82b8269ca16bff4664713afeca4475','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTCATTATTTGTTGTGTGTCTGTGCGTTGTTGGCGTGCATTTGCTTACACTTTGGTGTTTGTGAGTGCGTGTTGGCAGTGTGCGGACTGAACGAAGGTTGTGTGTTGTTATGTGCCTGCTGCACTGCTGACTTTGCATTCATTTGTATGGTCTTGGCGGAGTGGCGGGTACTGTGCATGCGCAACTGACTTATTTTTTCAAACCCCATACCTAAATGACTGATTATACT');
INSERT INTO marker_sequence VALUES(255,'70ccf40bed3a705cc8fe44a8053dc1c1','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACTGTCGTTATTTGTTGTGTGTGTGCGTGTTGGTAGCATGCGTGTTTGCTTACGCTTTGGTGTTTGCGAGTGTGTGTGTTGTCGGTGCGCAGACTGAACGAAGGTCGTGTGTTGCTGTGTGTCTGCTGTACTGCTGACTTTGCATTGATTTGCATGGTGTTGGCGGAGCGGCGGGTGCTGTTGCATGCGCGGCTGACCTATTTTTTTCAAACCCCATACCTAAATGACTGATTATACT');
INSERT INTO marker_sequence VALUES(256,'43041eceb10e755278469dbb0f0c2672','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTCTGTATTTGTTTTGTGTCTGCGCGTTGCTGGCGTGCGTTTGCTTGCGCTTCGGCGTTTGCGAGTGCGTGCTGGCGGTGCGCGGACTGAACGAAGGTTGTGTTGCTGTGTGCCTGCTGCATTGCTGACTTTGCATTAAGTTGTATCGTCTTGGCGGAGCGGCGGGTGCTGATGCGACCAGCTGACTTATTTTTTCAAACCCCATACCTAACTTACTGATTATACT');
INSERT INTO marker_sequence VALUES(257,'a819104b9374c2079a7f3280c498dc7e','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTCATGTAACGTTTCGTACTTGCTGTGTGTTGTGTCGATGTGCATTCATTTGCGTGTCGGCTGCGCACTGGCAGGTTGAACGAAGGTCGCATTGTGTACTTGCCTGTGTCGCTCTTTTTTTGTTTCCTTTGTGTTGTATTTCGGTACAAGAGAGAGGAGAGAGAGAGAGAGTGCGCGCGGTGTGTGTGTGCGGTGTCGGCTGACCTATTTTTTCAAACCCAATTACCTCAAATACTGATCAATACT');
INSERT INTO marker_sequence VALUES(258,'143ec9c0e693fe3c54ecaea7fc639707','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAATACTTTCCACGTGAACTGTCTTACTTAGTTTTGCGCTGCTGTCGGGAGTGTTCTGCGTGCGCTTGCACGGAGAGCGTTTCTTGCAACGGCTGAACGAAGGTTGGTTGAGTGTGTTGTCTTTTGCGTGCTTGATTGTATGCGGGGGACGTACGCCGCCGGCTGACTTACTTTTTCAACCCCATTACGAAACAAACTGAAGTATACT');
INSERT INTO marker_sequence VALUES(259,'f3fb6adcbc0650dd28cd448e0d4bbab8','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTCTTACTTAGTTTTGCGCTGCTGCGGTAGCGGTGTTCTGCGCACTTGTGCGTGGTGCGCTGTTTATCTGCAGCGGCTAAACGAAGGTTGGTTGGAGTGTTGTTGTGTGTGCTTTCTTGCGCGCCATCGTACGCTCTGCCGGCTGACTTATTTTTTCAACCCCTTACTTTAAAAACTGAACTATACT');
INSERT INTO marker_sequence VALUES(260,'e798a519c94d44abd72be67445cdae84','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCAAAAAAACTTTCCACGTGAACCGTTCTGTCCGTTTTGTGCCGTTGCTGTTGTCGTGCTTCGACGAGAAGAGCAGTGGCTAAACGAAGGCTGTGAGCTTCGTGCTTGCGGTCGATTTATTCTTTCAAACCCCATACGTTAAGAACTGAAGTATACT');
INSERT INTO marker_sequence VALUES(261,'0d0fec88a3d9e7fcf0d8824de6bdc806','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCAAAAAAACTTTCCACGTGAACCGTTTTGTGCGTTTTGTGCTTGTTGTTGTTGTTTTCGCTCTGCTCTGTGCCTTCGGGTGTAGAGTGTGGAGTGGGAAGAAAGCTCCAGGCTAAACGAAGGCTGCGAGTTTCGTGCTTGCGGCCGATTTATTCTTTCAAACCCATACATTAAAGACTGAAATATACT');
INSERT INTO marker_sequence VALUES(262,'f257387dee3a31332a4a2f39c11a54cf','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAATAAACTTTCCACGTGAACCGTCAACCCAACCAGTTTAGCGTCATCTTGTGTGCGTCTTTTCTCGATTGCTTTTTAATTAAATTGCGAGAGAGGGGAAACAAGCGCAATTTAGACAGAACGAAGGTCGAGCTGTTTTTCTATTCGTAGTGAGACGGCTTGGCTGATTTATCCTTTTCAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(263,'a051649239a2e72a8884ebc7565bec06','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTCTGTATTTGTTTTGTGTCTGCGCGTTGCTGGCGTGCGTTTGCTTGCGCTTCGGCGTTTGCGAGTGCGTGTTGGTGGTGCGCGGACTGAACGAAGGTTGTGTTGCTGTGTGCCTGCTGCACTGCTGACTTTGCATTAAGTTGTATCGTCTTGGCGGAGCGGCGGGTGCTGATGCGACCGGCTGACTTATTTTTTCAAACCCCATACCTAAATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(264,'06d53952668adb0008128c3613112e2e','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTCTCCGCGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(265,'5641d474912b437f90ae4af8cca5139a','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(266,'0eee3ae6092f08f69963d7c417034086','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACTTTAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTGACTGATCTGGTGTTTTGTGATACTGGATCGGGAGTGAGCAGGACGAAGGTTGGTCTCGTAATGTAAATTGTGGGACTAGCTGATGCATTCGTTTTTTCAAACCCTTACCTAAATACTGATTGATACT');
INSERT INTO marker_sequence VALUES(267,'3b916ca14070e375adbe8069a72a888d','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATTAATTGGGGGTTTCGTTGGCGGCTGTTGCTGGCATGTTTTTGCTGGCTGGCAGCTGCTGAGTAAGCCCTATCATGGCGAGTGCTCTGATCTCGGTCGGAGCTAGTAGCTTCAATTTTAAACCCTTTCTTAAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(268,'c6c3999113602df0d684348261478b43','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO marker_sequence VALUES(269,'468dc60921568e6ca5c197d04032eb44','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTCCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO marker_sequence VALUES(271,'d8b485933dbde7387d58cf825bba6ec1','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCATAAAAACTTTCCACGTGAACCGTTACAATTATGTTCTGTGCTCTCTCTCGGGAGGGCTGAACGAAGGTAGAGCTGCATGTAAAAGTGCGGTTTCTGCCGATGTACTTTTAAACCCATTCACACTAATACTGAACTATACTCCGAGAACGAAAGTTTTTGGTTTTAGATCAATAACAACTTTCA');
INSERT INTO marker_sequence VALUES(272,'1cee4bf5c654f172587bb1fb745f55e2','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTATCCACGTGAACCGTTAAGCAAACAAGTTAAGGCAGGCGCGATTGGTGGTGCGTCTGGGAANCGCTTGTCGATATTCGATCGGATCGGATATTGTCGGGNGTCGTCCTGGACACGCTGTCGATCGGAGTCGGCTAAACGAAGGTCGGGCGTCTCGCTATCGGAGCGATGTGCGCGTTGTCGCACGTTGCTGCAATGGCTCGAGCAAGCGGCTGATTTATGTNTTTCAAACCATACGTGACGTACTGATTATATCT');
INSERT INTO marker_sequence VALUES(273,'0df7f90c31099085afd275f076c2a588','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGAGCTTCGGCTCGAGCTAGTAGCTTTAATTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(274,'8328540b8b3ad6f06442b5be8688da47','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCAAAATACTTTCCACGTGAACTGTCTTACGAGATTCGCGCCGTGACGTGTGTTGTCGCTGCGTGCGCTGTATTTATATAGTGCGCATAGCGTCGACTGCGTGGGTCGGCTGATCGAAGGTCGCATTGTGCTGTATTGCGCAGTGTGGCTGACTTATTCTTTCAAACCCATTCCTTCATTACTGATTCATACT');
INSERT INTO marker_sequence VALUES(275,'b1437c5cb42f4ca4b1451769f61411fb','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCAAAATCCTTTCCACGTGAACTGTCTTACGAGATTCGCACCGTGACGTGTGTTGTCACTGTGTGTGCTGTACATATATATATGTATGGTGCGCATGGTGGCGACTGCGTGGGTCGGCTGATCGAAGGTCGCATTGTGCTGTATTGCGCAGTGTGGCTGACTTATTCTTTCAAACCCATTCCTTAATGACTGATTCATACT');
INSERT INTO marker_sequence VALUES(276,'f252faaf78caf9a3d02577d562593a2f','TTTCCTTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(277,'b3c1fb99eca1959f32d6d514afd8f765','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCTTCTCTTTTAAACCCATTCCTAATGACTGAATATACT');
INSERT INTO marker_sequence VALUES(278,'0a22e0be09570d2d5f3622188dc9b80c','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGGGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(279,'ed5b93072af57d34851564d0417bde50','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(280,'189e9cd1ed790d20ea3616cdae209150','TTTCCGTAGGTGAACCTGCGGAAGGATCATTTCCACACCTTAAAAAACTTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(281,'0f5434e268d592c8e8879e9062d60419','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(282,'e0263a8f47c37a4ce0b8e188cf488de9','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(283,'85537de69bca6eed39b0db1d5308bf03','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGCCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCTTCTCTTTTAAACCCATTCCTAATGACTGAATATACT');
INSERT INTO marker_sequence VALUES(284,'c8dab198b98ba03720142cdfc778d4ff','TTTCCGTAGGTGAACTTGGGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(285,'5a5b313bf7de860d163445c8bd9e02c1','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAACTTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(286,'0d8f066ff9b4958fb217fc45baf3edf4','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACCTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(287,'e33d51c1dcd3d26d01f27ddf2280a40b','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGTCTCGGCCTGGGCTAGTAGCTTCTCTTTTAAACCCATTCCTAATGACTGAATATACT');
INSERT INTO marker_sequence VALUES(288,'a5e7459087f6628b1011045a18099552','TTTCCGTAGGTGAACTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGTCTCGGCCTGGGCTAGTAGCTTCTCTTTTAAACCCATTCCTAATGACTGAATATACT');
INSERT INTO marker_sequence VALUES(289,'abbd658918a5b375bb9cdf763e2c32d9','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAGATTGGGAGCTTGCTCGGCGGCGTGCGTGCTGGCCTATAATGGGTTGGTGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAATTACTGAAATACT');
INSERT INTO marker_sequence VALUES(290,'96a5fa947b6fe404820922a66387ce10','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTTGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(291,'fb9355a99ecb412246ea04de8eadedd9','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGTCTCGGCCTGGGTTAGTAGCTTCTCTTTTTAAACCCATTCCTAATGACTGAATATACT');
INSERT INTO marker_sequence VALUES(292,'ceedcd60e6e02a713ec00ed3d5e5a2eb','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACATTCCACGTGAACCGTATCAACCCCAAGTTGGGGGTTTCATTGGCGGCGGCTGCTGGCATCTTTTTGCTGGCTGGCTACTGCTGAGAGAACCCTATCGTGAGCGTTCTGACCTTGGTTGGAGCTAGTAACTTATTATAAACCCATTCCTAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(293,'ba4392a2e3199f77b7ac3dece0eadc36','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAAAACCCTTAGTTGGGGGCTTCTGTTCGGCTGGCTTCGGCTGGCTGGGCGGCGGCTCTATCATGGCGAGCGCTTGAGCCTTCGGGTCTGAGCTAGTAGCCCACTTTTTAAACCCATTCCTAAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(294,'b57a74bfa1a8a5f9141f0d02f8ebeb1f','CTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAAAACCCTTAGTTGGGGGCTTCTGTTCGGCTGGCTTCGGCTGGCTGGGCGGCGGCTCTATCATGGCGAGCGCTTGAGCCTTCGGGTCTGAGCTAGTAGCCCACTTTTTAAACCCATTCCTAAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(295,'695e24b21aaa4c2c50a949d7862217d5','TCCGTAGGTGAACCTGCGGAAGGATCATTACACACTAAAACTTCCCACGTGAACCGTATCAAACCAATTCATTGGGGGTTTGTTTGGCGGCGGGCTGCTGGCATCTTTTTGCTGGCTGCTGCTGCTGAGCGAGCCCTATCATGGCAAGCGCTCGGACCTCGGTCGGAGCTAGTAGCATTCATTTTAAACCCATTCCTAATGACTAAATATACT');
INSERT INTO marker_sequence VALUES(296,'af5522eac4c6d9f8b1e75ad37e8b0335','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCAAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATTAGGCGGCGACTGCAGACTTAATTGTTAGCGGTTGCTGCTAGATGCGTCCCATCATGGTGATCGTTTCAACCTCGGTTGAAATAAGTAGCTAAATTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(297,'9054bf901cfe5dbdd5ac56468bebcb93','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAACTTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAGATGCGTCCTATCATGGCGAGCATTTCGACCTTGGTTGAAATGAGTAGCTAAATTTTTTAACCCTTTAATTATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(298,'b3b5ea72cd147541dfa6cba860a8c0dd','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTCCACGTGAACTGTATCAAACTTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAGATGCGTCCTATCATGGCGAGCATTTCGACCTTGGTTGAAATGAGTAGCTAAATTTTTTAACCCTTTAATTATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(299,'a31642ade45f1b4f8c326f8ba98d6b7e','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTCAAGTAATAGATTCAGTGCCTCTGCTGTGGCTGTGGTGTTTTCGGACGCTGCGCTGTGGCGGAGGAGGAACGAAGGTTGGTCTTGTGTGTGCACAGCAATGTGTGTGTGCGGGACTGGCTGATCTATTTTTTTCAAACCCCATACAAAATGACTGATTTATACT');
INSERT INTO marker_sequence VALUES(300,'491d749883c4590d95db9c8a795a28e9','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTCATTATTTGTTGTGCGCTCTCTGCGGTGTCGGTGGCGTCTGTTGGCTGTATTTGATACTGCTGGCGGGTGCGAGCCGGATGCAGAGGCTGAACGAAGGTCGAGTTGCTTTGCTCTCGGCTGACTTATTTTTCAAACCCAATACCCAACTTACTGATTATACT');
INSERT INTO marker_sequence VALUES(301,'0425aac57c924f369fd8731edae1a191','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACTGTCTGTATTTGTTTTGTGTCTGCGCGTTGCTGGCGTGCGTGTGTTTGCTTGCGCTTCGGTGTTGGCGAGTGCGCGTGCTGGCGGTGCGTGGACTGAACGAAGGTTGTGTTTGCTGTGTGCGTGCTGCACTGCTGACTTTGCATGAATTTGTATCGTCTTGGCGGAGTGGCGCGTGCTGATGCGGCCAGCTGACTTATCTTTTTCAAACCCCATACCTAACTTACTGATTATACT');
INSERT INTO marker_sequence VALUES(302,'26029e20e8d4bfad564502e525de6321','CTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(303,'3257c62afa883ce39dc94f3606715be7','CCCGTATGTGAACCTGCGGAAGGATCATTACCCACTTTAAAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTGACTGAGCTGGTGTTTTCATTTTTGGACACTGGAACGGGAGTCAGCAGGACGAAGGTTGGTCTGTTGTAATGCAAGTTATGATGGACTAGCTGATGAACTTTTGGTTTTAAACCCTTACCTAAATACTGATTTATACT');
INSERT INTO marker_sequence VALUES(304,'acecba67b97ef4f0b6c7fc30079db885','ATTCCGTAGGTGAACCTGCGGAAGGATCATTCCCACTTTAAAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTGACTGAGCTGGTGTTTTCATTTTTGGACACTGGAACGGGAGTCAGCAGGACGAAGGTGGTCTGTTGTAATGCAAGTTATGATGGACTAGCTGATGAACTTTTGTTTTTAAACCCTTACCTAAATACTGATTTATACT');
INSERT INTO marker_sequence VALUES(305,'f066fa8f09bbc7ad2c615ff4abc5b73d','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(306,'8aac44b365f465a4d1862759d6c2c653','GTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(307,'fecfb10d71898434fcde9533203c528e','TTTCCGTAGGTGACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(308,'818fbe16d4878e16fb6e453c5d96fad8','TTTCCGTAGGTGANCCTGCGGAAGGATCATTACCACACCTAAAAATCTTTCCACGTGAATTGTTTTGTTGTAAACTTGGGCTTCGCCGTTGTTTCCTACTTGTGAGAGAAGGGAGCGCGGTTGGAGGCCATCAGGGGTGCGTTTGTCGTGAATTTATATTTGCGCGAATGCGTCCTTTTGTCAACCCATTTCTTTTTGAAAACTGATCATACT');
INSERT INTO marker_sequence VALUES(309,'f39d1fc4a489aa764020ae6939baad11','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTAACAACCCCTTTAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTAATTTTAAACCCATTCTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(310,'3c8cf2635297e7c71b353978a70d5d96','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTTAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTAATTTTAAACCCATTCTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(311,'6e847180a4da6eed316e1fb98b21218f','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(312,'0ddb0e124c655b9f38fe29e666c96ba9','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATAATTTGGGGGTTAATTTGGTAATGGCTGCTGGCATCTTTTTGTTGGCTGGCTGTTACTGAGTAAGCCCTATCATGGCGAGAGTTTGGACCTTTGTCTGAACAAGTAGCTACGATTGTAAACCCTTTCTTAATTACTGAATATACT');
INSERT INTO marker_sequence VALUES(313,'67c28bffa343eb242b9793b0666845b4','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(314,'5f5b7d4fc028c587fca2d4b37a06e935','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCAAAAACTTTCCACGTGAACTGTCTTAGCATGTTTTGTGCCTTTAATTAGGCTAAACGAAGGTCGGAGTAAAATCTGGCTGATCTATTTTTTAAACCCATTCTTAAACACTGATTTATACT');
INSERT INTO marker_sequence VALUES(315,'9b57053b5946075e77b47569325c6981','GTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGACTTTATTGTTGGCGGCTGCTGCTGGACGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(316,'b323cdabe8a1af3a8de2e337fb96000c','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGACTTTATTGTTGGCGGCTGCTGCTGGACGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(317,'92034122d29da9d0a33f00fa75fd7cbf','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACTGTCTGTATTTGTTGTGTGTCTGTGCGTGCTGGCGTGCGTTTTGCGTGCCGGCGTGTGCGGACTGAACGAAGGTCGTGTCGCTGTGCGGCTGACTTCTTTTTCAAACCCCATACGTAAATGACTGATTATACT');
INSERT INTO marker_sequence VALUES(318,'35429ab6104efdd8f863ea7e3abc511b','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTNGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(319,'c2eb091ccfc0deac3dc646365813e9c1','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAACTACTGAACATACT');
INSERT INTO marker_sequence VALUES(320,'d77c5bc02785b9ef5cdf3e591dfca7cc','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGANCCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(321,'7ec8e52c0b4b5aed0cb532054a969dd2','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(322,'91887f2c7c65630f6c3fe33ba4221820','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(323,'5c274a2592e4095b9dd7341a1c0ea817','TTTCCGTAGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(324,'09edb4649c86e99f86c9211ee8512f4c','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTNGCTTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(325,'a5e79e809a499ecd876a47267ec06ee9','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTTCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTTCATTTTAAACCCATTCTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(326,'70a650ac5f5794a43c573099fb852aea','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTTCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(327,'46e829a1976bc099d99d76d6f1491ba7','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTGTTTTAAACCCATTTCACAATACTGATAATACT');
INSERT INTO marker_sequence VALUES(328,'35b9b7110c578df9dea9deace96ebb11','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTATAAACCAAAATTTGGGAGTTTATAAGGTATATACTGCTAACATTTTTATATGCGGTTAATACTTTATAAACTCTATCATGGCGAATGCTTGGATTTCGGTCTAAAGCTAGTAGCTGTTTTAAACCATTAATTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(329,'821ba75e948a627dd19343a8a30be8cf','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATTAAAACTTAATTGGGGACAAATTAGGCGGCGACTGCAGACTTTGATGTTAGCGGTTGCTGCTAGATAAGTCTCATCATGGCGATTGTTTCGACCTTGGTCGGGACTAGTAGCTGTTCTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(330,'d4638b7ab7986355cc759e118950864a','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATTAAAAATTAGTTGGGGATTTATCAGGCGGAGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAGATGAGTCCTATCATGATGGCGAGCGTAACGACCTTGGTCGGAGCTAGTAGCTATTTTTATAAACCTTTAATTATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(331,'ece86753d3594a7ff9a9316bc75f7091','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATTAAAATTAGTTGGGGGCTTATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAGATGAGTCCTATCATAATAGCGAGCGTAACGACCTTGGTCGAAGCTAGTAGCTATATTTGAAACCTTTACTAACTACTGATTATACT');
INSERT INTO marker_sequence VALUES(332,'16ca2300d2bd222c6c09415bdb0bc1bc','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACCTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAGATGCGTCCTATCATGGCGATTGTTCTGACCTTGGTCGGAACAAGTAGCTAAACTTTTAACCCTTTAATTATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(333,'44c95e6ffa5637c1f05c5dde3150f28a','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATCAGGCGGCGACTACAGACTTTATTAGTAGCGGTTGCTGCTAGATGCGTCCCATCATGGCGATCGTTTCGACTTCGGTTGAAATTAGTAGCTACATTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(334,'55620fe486f5c66a255658024dae9d28','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTACTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAGATGCGTCCCATCATGGCGATCGTTTCGACCTTGGTTGAGATTAGTAGCTACATTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(335,'63956cdc186d4157ccb80092c105f143','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATTAGGCGGCRACTGCAGACTTAATTGTTAGCGGTTGCTGCTAGATGCGTCCCATCATTGCGATCGTTTCGACCTTGGTTGAAATTAGTAGCTACATTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(336,'aa6a7d2e66d188ee3251d784b0cd4240','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATCAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAGATGCGTCCTATCATGGCGATCGTTTCGACCTCGGTTGAAATTAGTAGCTAAATTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(337,'e3bd2c62353f8f35a48f6816a6c241dc','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATCAGGCGGCGACTGCGGACTTTATTGTTAGCGGTTGCTGCTAGATGCGTCCTATCATGGCGATCGTTTCGACCTCGGTTGAAATTAGTAGCTAAATTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(338,'3f84f64fd3e7463c5f4ec98eb5d72acd','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATCAGGCGGCRACTGCAGACTTTATTGTTAGCGGTTGCTGCTAGATGCGTCCTATCATGGCGATCGTTTCGACCTCGGTTGAAATTAGTAGCTAAATTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(339,'4d77b62b389e01f2f74c390cf3ca5c1a','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATCAGGCGGCGACAGCAGACTTTATTGTTAGCGGTTGCTGCTAGATGCGTCCCATCATGGCGATCGTTTCAACTTCGGTTGAAACTAGTAGCTAAATTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(340,'5603cafc041e4cf4622e513e70eac74d','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATCAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAGATGCGTCCCATCATGGCGATCGTTTCGACTTCGGTTGAAATTAGTAGCTAAATTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(341,'5bc32e2e61bc0fd22f299c5fa70734ad','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATCAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAGATGCGTCCCATCATGGCGATCGTTTCGACTTCGGTTGAAACTAGTAGCTAAATTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(342,'544032f80c151c5c4d616fa8e1f2f250','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCAAATAGTTGGGGATGAGTTAGGTGGCAGCTGCTGACTTTAATGTTGGCGGTAGCCGCTAGACGAGTCCTATCATAGTGAAGTGGTTTGGACATTATAGTCCGAGCTAGTAGCTATTTTTAAACCATTACTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(343,'7a57117327960d93fcb6245ee5e5fc03','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCAAATAGTTGGGGATGAGTTAGGCGGCTGCTGCTGACATAATTGTTGGCGGCTGCTGCTAGACGAGTCCTATCATAGTGAAGTGGTTTGGACCTCGGTCCGAGCTAGTAGCTATTTTTAAACCATTAATTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(344,'64dcf9f4d953fbbd1e7e02f462117805','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAYTTTCCACGTGAACCGTTTCAACCAAATAGTTGGGGATGAATTAGGCGGCGRCTGCTGACTTTATTGTTGGCGGATGCTGCTAGATGAATCCTATCATAGTGAAGTGGTTTGGACTTCGGTCCGAGCTAGTAGCTATTTTTAAACCATTACTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(345,'6fed17e532e91bb0c3a761d7341023fe','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAYTTTCCACGTGAACCGTTTCAACCAAATAGTTGGGGATGAATTAGGCGGCGACTGCTGACTTTATTGTTGGCGGATGCTGCTAGATGAATCCTATCATAGTGAAGTGGTTTGGACTTCGGTCCGAGCTAGTAGCTATTTTTAAACCATTACTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(346,'2cd09e377d564881ac4b99d145f3429d','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAATTTTCCACGTGAACCGTTTCAACCAAATAGTTGGGGATGAATTAGGCGGCGACTGCTGACTTTATTGTTGGCGGATGCTGCTAGATGAATCCTATCATAGTGAAGTGGTTTGGACTTCGGTCCGAGCTAGTAGCTATTTTTAAACCATTACTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(347,'3cccb1f9781a76016a34c91c98803a21','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCAAATAGTTGGGGATGAATTAGGCGGCGACTGCTGACTTTATTGTTGGCGGATGCTGCTAGATGAATCCTATCATAGTGAAGTGGTTTGGACTTCGGTCCGAGCTAGTAGCTATTTTTAAACCATTACTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(348,'275ec227f84ad7e0c84b51317cf2dee2','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTCTCCACGTGAACTGTTGTATCAGATTAGCGCCAAGATTTTCGTGCGTGTTTGTGGTATCGCTATGTATTCGTACGTGGTGTTAGCAAGCATTGTATGGAGCTTGGCTGATCGAAGGTCGGTGCGCACCTTGTGTGTGTATTGGCTGATTAACCTTTTAAACCCTTTCAATAAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(349,'a2bc846b75dcb286fcdf181f6eaed772','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTCTCCACGTGAACTGTTTGTATCAGATTAGCGCCGAGATTTTCGTGCGTGTTTGTGGTATCGCTATGTATTCGTACGTGGCGTTAGCAAGCATTGTATGGAGCTTGGCTGATCGAAGGTCGGTGCACACCTTGTGTGTGTGTTGGCTGATTAACCTTTCAAACCCTTTCAATAAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(350,'044db8a32bb000180f4a65e171681185','TTTCCGTAGGTGAACTTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAATTTGGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO marker_sequence VALUES(351,'05f6d966e58d6da27438709ca9cb2695','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(352,'3d944f84b8274a67241746a7826f4100','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGTTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(353,'3b7f032192e8c231037d1f1c9879f267','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACTTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAATTTGGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO marker_sequence VALUES(354,'84f30676996cdabaa4e9ad2f1e2577d6','TTTCCGTAGGTGAACNTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAATTTGGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO marker_sequence VALUES(355,'703b081e2ba3492355ffc2d089676dc2','TTTCCGTAGGTGANCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(356,'fb594e9f7314902b3630670cc1744e67','TTTCNGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(357,'aeece02ad2d9cccf8131ceb1ef8d638b','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAAAACCCTTTTATTGGGGGCTTCTGTCTGGTCTGGCTTCGGCTGGATTGGGTGGCGGCTCTATCATGGCGACCGCTCTGAGCTTCGGCCTGGAGCTAGTAGCCCACTTTTTAAACCCATTCTTAATTACTGAACAAACT');
INSERT INTO marker_sequence VALUES(358,'a0d9bbe111ffe197b559440df53e1a35','TTTCCGTAGGTGAACNTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAGATTGGGAGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCCTTCTTTAATTACTGAAATACT');
INSERT INTO marker_sequence VALUES(359,'96e0e2f0475bd1617a4b05e778bb04c9','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(360,'9ba3657d5ecb7d8f35ce7f5feacbc3f7','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCAGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAACTAGTAGCTATCAATTTTAAACCCTTTCTTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(361,'81ddb943bcc0de589f73020a3c670f4c','TTTCCGTAGGTGAACNGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTAATTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(362,'606fb0b056b4b80c38cbba24fddce3a5','TTTCCGTAGGNGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTAATTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(363,'a7360f237aa7135ba3ecc13a44b1f1ed','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO marker_sequence VALUES(364,'78089b51075c8bc137d4aec53e4eefc0','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTNGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(365,'409ad8cbf29bfb895d4782bd2cc5faed','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCTTGCTCTGGCGTGCGGCTGTTGACCTGTAATGGGCTGACGGCTGCTGCTGGGCGGGCTCTATCAAAGGCGAGCGTTTGGACCTCGGTCCGAGCTAGTAGCTTTACTTTTTTAAACCCATTCTTTACATACTGAATATACT');
INSERT INTO marker_sequence VALUES(366,'426911b323b1ddad56e09dfa290bf04f','TTTCCGTAGGTGAACNTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTAATTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(367,'79b4ce1cdc03ee2e9af377e6de9223a7','TTTCCGTAGGTGAACCTGCGGAAATCATTACCACACTTTAAAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTGACTGAGCTGGTGTTTTCATTTTTGGACACTGGAACGGGAGTCAGCAGGACGAAGGTTGGTCTGTTGTAATGCAAGTTATGATGGACTAGCTGATGAACTTTTGTTTTTAAACCCTTACCTAAATACTGATTTATACT');
INSERT INTO marker_sequence VALUES(368,'707626c1f9f65dfa85432685fdb06cd9','TTTCCGTAGGTGAACCTGCGGAAGGCTCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCCTGGGCCTCGGCCTGGGTTAGTAGCNGTATTTTTTAAACCATTCCTAATTACTGAAAAAACTT');
INSERT INTO marker_sequence VALUES(369,'3128796eef17cbcd3ad3b1e5a9797451','TTCCCGTAGGTGAACCTGCGGAAGGCTCATTACCACACTTTAAAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTGACTGAGCTGGTGTTTTCATTTTTGGACACTGGAACGGGAGTCAGCAGGACGAAGGTTGGTCTGTTGTAATGCAAGTTATGATGGACTAGCTGATAACTTTGTTTTTAACCCTTACCTAAAACTATTTATACT');
INSERT INTO marker_sequence VALUES(370,'9ce3eccef73d8b4725b1938cc8f5568b','TTTCCGTAGGTGAACCTGCGGAAGGCTCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCCTGGGCCTCGGCCTGGGTTAGTAGCAGTATTTTTTAAACCATTCCTAATTACTTGAAAAAACTT');
INSERT INTO marker_sequence VALUES(371,'03db0b23fe1682ed026a92b09bdea01e','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACTTTAAAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTGACTGAGCTGGTGTTTTCATTTTTGGACACTGGAACGGGAGTCAGCAGGACGAAGGTTGGTCTGTTGTAATGCAAGTTATGATGGACTAGCTGATGAACTTTTGTTTTTAAACCCTTACCTAAATACTTGATTTATACT');
INSERT INTO marker_sequence VALUES(372,'03d98fbad6045a2c8bd15d861cfa16b1','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGGCTCTATCATGGCGACCGCCTGGGCCTCGGCCTGGGTTAGTAGCGTATTTTTTAAACCATTCCTAATTACTTGAAAAAACT');
INSERT INTO marker_sequence VALUES(373,'b757fdd9c830990ea1f90d16dc935762','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(374,'a65a2cf7dc2f2cb28bd56a585ff0a7d0','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAATTTGGGGGCTTCCGTCTGGCCGGCCGGTTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO marker_sequence VALUES(375,'9efb8bb971e5320b1da23ce10f2c354a','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGNCTTTATTGTTGGCGGCTGCTGCTGGNCGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(376,'a89c5be6cf14173b0c7ac57c941fb29f','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(377,'bba05d4d4aac8b7ccaa286afad44acb4','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGTTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(378,'38a7928f5fd9f7b4ca9c4636b55c2d15','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(379,'f2a6a813f6f006452afa0be752b9aa2f','TTTCCGTAGGTGAACNTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(380,'11b74237bf44899f24ace62be657172a','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCAGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAACTAGTAGCTATCAATTTTAAACCCTTTCTTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(381,'6b314f83ce021591cfbf595337040b86','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCCTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCATTCCTAATTACTGAAAAAACT');
INSERT INTO marker_sequence VALUES(382,'dcedc83a57776c9594d28c2dec55dffe','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGCTTCTGTTCGGCTGGCTTTTGCTGGCTGGGCGGCGGCTCTATCATGGCGAGCGCCTGGGCCTTCGGGTCTGAGCTAGTAGTCTTCTTTTAAACCCTTTCTTAAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(383,'0c2322caa3d7c51a5b8e79272a1f71b1','TTTCCGTAGGTGAACTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(384,'4d15b99abf01573c46c675f8c7f4b80b','TCCGTAGGTGAACCTGCGAAGGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(385,'d88fafb4c053cca34831650e33e56dab','TTTCCGTAGGTGACTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTGGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(386,'703e4af16de0fb6f326b7050580088be','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(387,'c3ec33641d1ff129d8e5ba75084fdfac','TTCCGTAGGGAACCTGGGGAGGGATCATTACCACACCTAAAAACCTTTTCCACGTGAACCGGTTTCAACCCAATAGTGGGGGGTCTTACTGGGCGGCGGCTGCTGCCTTTATTGCTGCCGGCTACTGCTGGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(388,'9b64fd9f0780dd0feb28abc6a1a03f07','TTTCCGTAGGTGAACCTGGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(389,'db7883ca7a5baacaf4e322a5eb022d68','TTCCGTAGGTGAACTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(390,'578710db0966a4dc8019aca35a5a2568','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(391,'631509780f0391507ec0a77bcfbdd13b','TCCGTAGGTGACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(392,'c6b909637840e252a1df1bc23d90624f','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(393,'976eb3744da68f5e28e674b26c8b4d0f','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTTCCACGCTGAACCGCTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(394,'0f4154c98a01cb08fb18f090d51f3c9f','TCCGTAGGTGAACTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(395,'97a6b4745c13545c7f3341f36be584d1','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAACTTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(396,'2e030f23eb72e967fff36b8f57e83ef6','TTCCGTAGGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(397,'4d02336870bbc3fb5a720938b1b5d4c6','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACTTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(398,'98d90d2cf6a19318abb1d7b767015945','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(399,'fcfcc1044d784d86620a53c606935300','TTCCGTAGGTGAACTGCGGAAGGATCATTACCACACTTAAAAACTTTCCACGTGAACCGTTTCACCCCAATAGTTGGGGTTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGTTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(400,'359e7c4596b5ad023dffe21b41afa963','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCACCCAATAGTTGGGGGTCTTACTGGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(401,'a8ee42751dca99de7d353dde9053d9a2','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGGCTGTCGATGTCAAAGTCGACGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(402,'bae80cfc18bc8b8089221aa8d7fb0c1a','TTTCCGTAGGTGAACCTGCGGAGGACATTACCACACTTTAAAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTGACTGAGCTGGTGTTTTCATTTTTGGACACTGGAACGGGAGTCAGCAGGACGAAGGTTGGTCTGTTGTAATGCAAGTTATGATGGACTAGCTGATGAACTTTTGTTTTTAAACCCTTACCTAAATACTAGATTTATACT');
INSERT INTO marker_sequence VALUES(403,'8b7ec3f98d6fa904dee73e2a9b5f4b5d','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCCGCTGGTCGGCTCCATCAAACGAGGCTCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTTTTTGTAAACCCTTTTTACTATTTTCTGATGATACT');
INSERT INTO marker_sequence VALUES(404,'9ea2f65e5d94a2adbe60fb0728cdb377','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCAACATAATTGGGGGTTTATTTGGCGGCGGCTGCTGGCATTTTGTGCTGGCTGGCTGCTACTGGGCAAGCCCTATCGCGAGCGTTTGGGCCTTGGCCTGAGCTAGTAGCTTTTATTTTAAACCATTCTTAATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(405,'0007d64cf0fc6d78095351cb39323335','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTGCTGAGTCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(406,'0557224e2fdca9647380562657d854d4','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCTCCCCTAAACAACTTTCCCCGTGAACCGTATCCACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCTGGACGAGATAGCTTTTTGTTTTAAACCCATTTCTCAGTACTGATTATACT');
INSERT INTO marker_sequence VALUES(407,'70f559ad623a00ec20743c67f79f983e','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCTGGACGAGTAGCTTTTTGTTTTAAACCCATTTCACAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(408,'d77d0f102dd51beb53069d397b85b212','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCTGGNCGAGATAGCTTTTTGTTTTAAACCCATTTCTCAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(409,'aeda52b90bcd3d061a434df95f4508d3','TTTCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCTGCCGTTCGCGGCGGCTCCATCAAACGAGGCTCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTACTTTATTTTCTGATCATACT');
INSERT INTO marker_sequence VALUES(410,'77eaaee8b5e011b45671be7f44c3c674','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTGGGGGGCGTGCCGTTCGCGGCGGCTCCATCAAACGAGGCCCTGGGCTGAAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTTACCACATTTTCTGATCATACT');
INSERT INTO marker_sequence VALUES(411,'0238a15a2f2dbb5eafd4edd4965e9e48','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCCGCTGGTCGGCTCCATCAAACGAGGCTCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTTTTTGTAAACCCTTTTTAATATTTTCTGATGATACT');
INSERT INTO marker_sequence VALUES(412,'9941e83036c615f524c8148d2aaaea39','TTTCCGTAGGTGAACCTAGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(413,'eb8113a30581951505a4943f00173b54','GTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO marker_sequence VALUES(414,'d25ca50dbc97548c6d29d0c9a1b085e9','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGAGCTTGTTTGGCGGCGTGTGTGCTGGCCTGTTAAGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGATCGTTTTGGGCTTCGGCTCGAGCGAGTAGCTTTAATTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO marker_sequence VALUES(415,'43ffd9318141f025b3fd8c0bdb44ed13','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(416,'f4ab19ea587564f4a73de8675d4ee929','TTTCCGTAGGTGAACCTGCGGAAGGATCATTTCCACACCTAAAAACTTTCCACGTGAACCGTATCAACCACATTAGTTGGGGGTTTAATTGGCGGCTGCTGCTGGCATCTTTTTGCTGGCTGGCGACTGCTGAGCGAACCCTATCATGGCGAGCGTTCTGACTTCGGTTGGAGCTAGTAGCTTGTATTTTAAACCATTCTTAATTACTGAACATACT');
INSERT INTO marker_sequence VALUES(417,'6a553fbb4c02acf49d0842e5bd5168f3','TTTCCGTTGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO marker_sequence VALUES(418,'94af1852cb2de2d92cadaa416feaa9a7','TTCCGTAGGGTGACTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCRGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO marker_sequence VALUES(419,'e9f8bf83d9d9998b28a218dedebd4bb4','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCGTGGCGAATGTTTGGACTTCGGTCTGGGCGAGTAGCTTTTTTTTTAAACCCATTTCTCAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(420,'ba38d44bddc3017e4e1e04ada49165ea','GTTCCGTAGGTGAACTGCGGAAGGATCATTACCACACCAAAAATCCTTTCCACGTGAACTGTCGTATTGATTCGCGCCGTGACGTGTGTGTCGCTGCGAGTGCGTTCGTGCGTGCGTCTTCTTGGAGATGTGTGCGCGAGTGCGCGCGTGGCGTCGACTGCGTGGGTCGGCTGATCGAAGGTCGCTTTGTGCTGTCTGGCGCGGAGCGGCTGACTTATTCTTTCAAACCCATATCTGTAGTACTGAAACATACT');
INSERT INTO marker_sequence VALUES(421,'9d87ebed2edc09847cb26077b6d8765f','TTTCCGTAGGTGAACTGCGGAAGGATCATTACCACACTTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO marker_sequence VALUES(422,'c4c1e775d64914a228498df57ec3a2d9','TTTCCGTAGGTGAACTGCGGAAGGATCATTACCACACTTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO marker_sequence VALUES(424,'104be96dea7edb9bb1955ff4bd6ad1b3','GTTCCGTAGGTGACCTGCGGAAGGATCATTACCACACCAAAAACAACTTTCCACGTGAACTGTCTTACGAGATTCGCGCCGTGACGCGTGTTGACGCTGTGTGTGTTTGTGTCTTCTTTCGAGAGGATATTGTGATGCAAACAGTGTTGACCGTGTGGGTCGGCTGATCGAAGGTCGCTTTGTGCATTATTGTATGGAGCGGCTGACTTATTCTTTCAAACCCATTACACAATACTACTGATTCATACT');
INSERT INTO marker_sequence VALUES(425,'d8efc82596d277fbcac3ca2c6e5ed44f','CTTCCGTAGGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO marker_sequence VALUES(426,'cbbf2db424c839609c5b16a6cf1f640b','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCAACAAATTGGGGGTTTGTTTGGCGACAGCTGCTGGCATCTTTTTTGCTAGCGGCTGCTGCTGAGCAACCCTATCATGGCGAGCGTTCGGACCTCGGTCGGAGCCAGTAGCTTTCATTGTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(427,'0cc6b9e59b8172d8400acbef1265bf1c','TTCCGTAGGTGACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGGCTGTCGATGTCAAAGTCGACGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(428,'f44ceb8cd2c1e6b8f9fee417118a1dff','GTTCCGTAGGTGAACTGCGGAAGGATCATTACCACACCAAAAAAACTTTCCACGTGAACCGTTCTGTCCGTTTTGTGCCGTTGCTGTGTCGGCGTTTGTCGAGAAGAGCAGTGGCTAAACGAAGGCTGTGAGCTTTGTTGCTTGCGGTCGATTTACTCTTTCAAACCCCATACGTTAAGAACTGAAGTATACT');
INSERT INTO marker_sequence VALUES(429,'a2c541e717c27592983da94f0574883b','TTTCCGTAGGTGAACCTGCGGAAGGATCATCACCACACCTAAATAACTTTCCACGTGANCCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(430,'97d704573f84ecd81c3c7f2bd8cfe768','GTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGACTTAATTGCTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCNTGATTTAGTAGTCTTTTTTTCTTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(431,'a46e3698664f663c18def5a8008bf034','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGACTTAATTGCTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(432,'c706fbf2a393612ee9b81b52b69d60f4','TTTCGTAGTGAACTGCGGAAGGATCATTACCACACTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(433,'45aaf5b5e3448f8608ed9a836aac5f21','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACTCATTTCACAATTCTGATTATACT');
INSERT INTO marker_sequence VALUES(434,'a75471225c256d99ae2fa877a402307d','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCMTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(435,'a6d37168c367f12441e4c50a42d7485f','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTCAGTTGGGGGCCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(436,'d2ab6ab527a7252b3a6b44e7e2c0521f','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCATTTTGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCATTTAACAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(437,'d9c6ea4551c68ac939a80b5118238a6d','CTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCATTTTGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCATTTAACAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(438,'2b0fb8f896789112752902da4388b9ab','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCATTTTGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCTTTAACAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(439,'e71071d698a48898827e3e8408e4936a','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCATTTTGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCTTTAACAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(440,'e0f43da2346edf0c8b402dadee5452d6','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTAACAAACCAATAGTTGGGGGCGAGTTTGGCGGCTACTGCTGCTGGACGAGCTCTATCATGGCGAGCGTTTGGACTTCGGTCTGAACTAGTAGCCCTTCTTTTAAACCCATTCCTAATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(441,'5a5bec99f665f2649af2fbc00fee48ec','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAGATTGGGAGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGCGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCCTTCTTTAATTACTGAAATACT');
INSERT INTO marker_sequence VALUES(442,'c62665f8bb267be1cb4fb5b8f9b1cbbe','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTGTCCACGTGAACTGTGTCGATGTTGGGGCGTGCTGGGCGTGCGTGTTTGTGTGGCTTCGGCCGCGTGCGTGCGCGTGTTCGGTTGTGCTCATCAAACGAGGAGGCGGGTCGCAAGGCCTGYGTTCTTTGTTACTGTTTTAAATCCTTCTTRTAGACTGATTGTACT');
INSERT INTO marker_sequence VALUES(443,'9088dc4d4b53e41876bcbbc328daea9c','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTGTCCACGTGAACTGTGTCGATGTTGGGGCGTGCTGGGCGTGCGTGTGTGTGTGGCTTCGGCCGCGTGCGTGCGCGTGTTCGGTTGTGCTCATCAAACGAGGAGGCGGGTCGCAAGGCCTGCGTTCTTTGTTACTGTTTTAAATCCTTCTTATAGACTGATTGTACT');
INSERT INTO marker_sequence VALUES(444,'076cc341940e9457a686d9af642e4c60','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTGTCCACGTGAACTGTGTCGATGTTGGGGCGTGCTGGGCGTGCGTGTGTGTGTGGCTTCGGCCGCGTGCGTGCGCGTGTTCGGTTGTGCTCATCAAACGAGGAGGCGGGTCGCAAGGCCTGYGTTCTTTGTTACTGTTTTAAATCCTTCTTATACACTGATTGTACT');
INSERT INTO marker_sequence VALUES(445,'38ee2b1c022e0281a31ebd92cba0eaaa','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTTCAAAATTTAGTTGGGGGTCTTTTTCGGCGACGGCTGCTGGCTTCATTGCTGGTGGCTGTTGTTGGACGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCATTATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(446,'1b31fdd8ad336e8c1689a582f491d0ba','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO marker_sequence VALUES(447,'2e06d5cacfd23669f60f3be9f89bbf84','CTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTYTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO marker_sequence VALUES(448,'05b3bcfc073ea8dea040becdc3d1c682','CTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCCTGGGCCTCGGCCTGGGTTAGTAGCGTATTTTTTAAACCATTCCTAATTACTGAAAAAACT');
INSERT INTO marker_sequence VALUES(449,'8383a2adb59ec462a368cec481980f55','CTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO marker_sequence VALUES(450,'48a56b5bc7960f7a3abf27155d746743','GTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCATATTTTCTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO marker_sequence VALUES(451,'f0a3c5aae76eb46fd57bea4877f384a4','TTTCCGTAGGTGAACCCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO marker_sequence VALUES(452,'c19a5c2ec79b91912351f2bda62d82d4','TTTCCGTAGGTGAACCTCCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO marker_sequence VALUES(453,'6f0043db557f51fd8b3b3d55e61b785d','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCYGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO marker_sequence VALUES(454,'b142870e537d9894344f9ba9fd3b02e6','GTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO marker_sequence VALUES(455,'4b3128660945b4c813c8ab1f3492e590','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACTTAGAAACTATCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO marker_sequence VALUES(456,'c17e132009b5dd541ffc9f5cbf220c5c','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(457,'5f430b56aa9cbd8b7e2313645ab8d33a','CTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(458,'af921f0c69e7c4fd68ea7c8ea981f1f4','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCATTTTGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(459,'bd445bdaa983dab945bc502fa286d63e','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGACGTTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(460,'2856efcce50f73d0869b56a3a11573c8','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACATAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(461,'9003de7226966a0ed7bf98f6d874b89e','TCTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCAAAACTCCTTTCCACGTGCACTGTCTTACGAGATTCGCGCCGTGACGTGTGTTCTCGCTGTGTGTGCTGTATGTATGTTTACATATGTATGGTGCGCATGGTGGCGACTGCGTGGGTCGGCTGATCGAAGGTCGCATTGTGCTGTATTGCGCAGTGTGGCTGACTTATTCTTTCAAACCCATTCCTTAATGACTGATTCATACT');
INSERT INTO marker_sequence VALUES(462,'2f6368a968d8a9d69b3bec7d6567af9d','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAGCTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGCCTGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCTCAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(463,'febde0e5e3c64ca579a4271a98147af3','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAGCCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCTCAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(464,'e3419d8a8b442a8fe8d7b6be670a813e','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACAACTTTAATTGGGGGTGATCTTGACGGTAGCTACTGGTTTTCTACTGGTGGTAACTATTGAGTGAACCTCATCATGACGAACCGTTGGGCTTTTGTCTGACGTAGTAGAATAAATTTTAAACCATTACTTAATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(465,'9d4a4a383efe798c04b520bebe68fe35','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTATCCACGTGAACCGTATCAACAATTATATTTGGGGGTGATCTTGGTGGTGCTACCAGTCTCTGACTGGCGGCCTACTGAGTGAGCCCTATCATGGCGAACCATTAGGCTTTGGTCTGATGTAGTAGTAAATTTTTAAACCCATACCTAATTACTGATTTACT');
INSERT INTO marker_sequence VALUES(466,'273216ec7b0fdebeaa0777360305e5b3','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACAATTATATTTGGGGGTGATCTTGGTGGTGCTACCAGTCTCTGACTGGCGGCCTACTGAGTGAGCCCTATCATGGCGAACCATTAGGCTTTGGTCTGATGTAGTAGTAAATTTTTAAACCCATACCTAATTACTGATTTACT');
INSERT INTO marker_sequence VALUES(467,'ed286291132771717b7215691bff93b1','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCTGCCGTTCGCGGCGGCTCCATCAAACGAGGCTCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTACTTTATTTTCTGATCATACT');
INSERT INTO marker_sequence VALUES(468,'0ff1f8b33fd6580576d13bb42a9614d1','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCTGCCGTTCGCGGCGGCTCCATCAAACGAGGCTCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTCCTATATTTTCTGATCATACT');
INSERT INTO marker_sequence VALUES(469,'5dade03ea56d839c93134d4f85de86c4','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTTTAATTTGGGGGCTTGTTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCACTTTTAAACTCCTTTCTTAAAAAACTGAACATACT');
INSERT INTO marker_sequence VALUES(470,'51f0cbc65e13865f7a36ee073ac5e0ab','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTTWAATTTGGGGGCTTGYTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAMTTTTAAACTCCTTTCTTWAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(471,'69eb2a483b767127e98ff2d79ce8dc0f','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTTAATTTGGGGGCTTGTTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCACTTTTAAACTCCTTTCTTAAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(472,'a829d569a7edc749cb86a111f687e10f','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTGTCCACGTGAACTGTGTTGAGCTTGGGGCGTGCTGGGCGTGCGTGTGCGTGTGGCTTCGGCCGCGTGCGTGCGYGTGTTYGGCGTGCTCATCAAACGAAGAGGCGGGTCGCAAGGCCTGCTTTGGTAGTTACTTTTTTAAATCCTTCTKTWWAACTGATTATACT');
INSERT INTO marker_sequence VALUES(473,'64c33b1964919f78247f44b83ce152ff','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTGTCCACGTGAACTGTGTTGAGCTTGGGGCGTGCTGGGCGTGCGTGTGCGTGTGGCTTCGGCCGCGTGCGTGCGTGTGTTTGGCGTGCTCATCAAACGAAGAGGCGGGTCGCAAGGCCTGCTTTGGTAGTTACTTTTTTAAATCCTTCTKTWWAACTGATTATACT');
INSERT INTO marker_sequence VALUES(474,'a9e9ff04cca5ffb6f780c2e657c95337','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTGTCCACGTGAACTGTGTTGAGCTTGGGGCGTGCTGGGCGTGCGTGTGCGTGTGGCTTCGGCCGCGTGCGTGCGTGTGTTTGGCGTGCTCATCAAACGAAGAGGCGGGTCGCAAGGCCTGCTTTGGTAGTTACTTTTTTAAATCCTTCTTGTTAACTGATTATACT');
INSERT INTO marker_sequence VALUES(475,'3506613f7d1c8fcd7f4d3838c6d3d1d4','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACACCCTTCCACGTGAACCGTTTTGTTTTGCTTTCGAGTGCTTTGTTGTGCTCGGAGCATGTTTGGGCTTCGCTGCTGGCGCTTGATTGTGCTGGCGGCTCGAGGCCATCAAGCGGCGTTTTGAGTGTGTGTTCGCATACAATTAAAACGTCCAAACCTTTTAAACCCATTTGATTGAAAACTGAAGTATACT');
INSERT INTO marker_sequence VALUES(476,'1dd4277036f006f4c82ec1a64eb83a01','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO marker_sequence VALUES(477,'9fc2d9f990c21adc1e55c14e46757dc7','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO marker_sequence VALUES(478,'b699b6e6e8dfebe5ffdf5403b3b2c799','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTATCGAACAACTAGTTGGGGGTCTTGTTTGGCGTGCGGCTGCTTCGGTAGCTGCTGCTAGGCGAGCCCTATCACGGCGAGCGTTTGGACTTCGGTCTGAACTAGTAGCTATTTTTTAAACCCATTCTTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(479,'72376b730437eb12e0ec1935392f48ee','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTGAAATCTTTCCACGTGAACTGTTGGGATTGCCGTTGGGCATGACGTGGGGCTTCCGTGCTGCTTTGCGGTTTTGCTGCTTTGCGCGTGGAGGCCCCGTCTGGGTGTTGCTGTGCCGTTTRGGCTTGGCGGTGCCTGGCGCCTTTTTGTTTTGAACCCGTTACGTAATGACTGAGTATACT');
INSERT INTO marker_sequence VALUES(480,'dcd6316eb77be50ee344fbeca6e005c7','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAAAACCCTTAGTTGGGGGCTTCTGTTCGGCTGGCTTCGGCTGGCTGGGCGGCGGCTCTATCATGGCGAGCGCTTGAGCCTTCGGGTCTGAGCTAGTAGCCCACTTTTTAAACCCATTCCTAAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(481,'353f176534f3c4af3bc936a03a56ed22','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTATCGAACAACTAGTTGGGGGTCTTGTTTGGCGTGCGGCTGCTTCGGTAGCTGCTGCTAGGCAAGCCCTATCACGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTATTTTTTAAACCCATTCTTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(482,'75a4b4c171ecaf3e4b3ca04060d3e310','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTTCATGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(483,'2f13a21c7b20c2fe0bf9757b5b8c814d','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCAGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAACTAGTAGCTATCAATTTTAAACYCTTTCTTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(484,'419ba098165eeae2cbe3d90569b521ce','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTCCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(485,'cab2875a481e358a4993910872ec53a6','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCATTTAGTTGGGGGCTTGTCCTGGTGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGGCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(486,'b224f508faf26009511efd4b55970f08','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGYTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCCTTCTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(487,'9d9730d2e14c109f91f4218672a05b08','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTATTAACCAAATAGTTGGGGATTTGCTAGGTAGTGACTGCTGACTTAATTGTTGGCTGTTGCTGCTAGGCGAATCCTATCATGACGAGCGTTTAGACTTCGGTCTAAGCTAGTAGTTATTTTTTAAACCATTCATAAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(488,'af06b9143985bbf5c0b28bf3ff4623bd','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAATATCACGTGAACCGTTTCAACCAAATAGTTGGGGATAAATTAGGCAGCGACTGCTGACATTACTGTTGGTGGTTACTGCTCGATAAGTCCTATCATAGTGAAGTGGCTTGGACTTCGGTCCGTGCTAGTAGCTATTTTAAAACCATTACTAAATTCTGATAATACT');
INSERT INTO marker_sequence VALUES(489,'590f1647264759ee155e9cad57bff622','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTAGTTACCCGATTAGCGCCGCGACGCGTGTCTGCGATGCATGTATGTGTGTTGTGGGCGTGTGGGCTCGGCTGATCGAAGGTTGTCGTGCCTGTTTGTGTTGCCTTGTGCGACGCGAGCGTGTGCGCGGCGGCTGACTTATTCTTTCAAACCCCTTACTTTAAAACTGATGTATACT');
INSERT INTO marker_sequence VALUES(490,'5a0d68fbfc03a3c7c1034f353dd63419','CTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(491,'5299cbe2a369a605a0b42070f0f954a6','CTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(492,'6abf31007c1f26561b4fd535e4b6c58a','ATTCCGTAGGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(493,'7dd27e642851130aaa95e40ea03f9103','CTTCCGTAGNGTGACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(494,'00efbfbaadb2fe542966870b75609af2','CATCCGTAGGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(495,'2c8d07bfb6d825695123cfa268f01132','CTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(496,'25c9901e30366642996b2e1a1676665f','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGGCTGTCGATGTCAAAGTCGGCGGCTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO marker_sequence VALUES(497,'af3282a9797a70b6922e29e68c0b2bdc','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTCCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO marker_sequence VALUES(498,'0bca08a93b59b84a4339100bd86cd0c3','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACTTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTTCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(499,'aa5ee9d565f1b48ef682693634088b40','TTCCGTAGGTGGAACCTGCCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(500,'63e1f4c32faa22ba141e9b8b7bc61d43','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTCCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO marker_sequence VALUES(501,'d279b80c995a8bf2992fd0ccd7bd5521','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACACCCTTCCACGTGAACCGTTTTGTTTTGCTTTCGAGTGCTTTGTTGCGCTCGGAGCATGTTTTGGGCTTCGCTGCTGGCGCTTGATTGTGCTGGCGGCTCGAGGCCATCAAGTGGCGTTTTGAGTGTGCCTTGCGCAATTGAAAACGTCCAAACCTTTTAAACCCATTTGATTGAAAACTGAAGTATACT');
INSERT INTO marker_sequence VALUES(503,'9075894e545142d7bc05d7fec6c89003','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACATCTTTCCACGTGAACCGTTTGTGACATGGTTGGGCTTGTGCGCGTTCTCTCTGTTTTGGGGGGAGGCGTGCGAGCTATCTGTAAACTTGTCAAACCCATTCTCTTTGATAACTGAAACATACT');
INSERT INTO marker_sequence VALUES(504,'85ed4e1cc97faa97133272abfa0109e8','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACATCTTTCCACGTGAACCGTTTGTGACATGGTTGGGCTTGTGCGTTTTCTCTCTCTCTTTTGGGGGAGGGGATGCGTGCGAGCTATCTGTAAACTTGTCAAACCCATTCTTTTTGATAACTGAAACATACT');
INSERT INTO marker_sequence VALUES(505,'e194320f9bc5d39db54c071e7bae1acb','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACTTTAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTGACTGATCTGGTGTTTTTGGATACTGGATCGGGAGTGAGCAGGACGAAGGTTGGTCTCGTAATGTAAATTATGGGACTAGCTGATGCATTCGTTTTTCAAACCCTTACCTAAATACTGATTGATACT');
INSERT INTO marker_sequence VALUES(506,'f665558f726d4cd876844a10f698751c','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTCAGTTGGGGGYCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(507,'931f8ea73c055c156ef36db9adf648d0','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTCAGTTGGGGGTCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(508,'6a5735e3565bb831a73114b1ab33a52d','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTCAGTTGGGGGTCTTGCTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(509,'662d837e3c52d7b1eda8f84c9a12f887','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTATCAACCCCATTAATTGGGGGTTTTGGTTGGCGATGATCGCTAACTTAATTGCTGGTTGATTACTGCTAGGCGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTATTTTAAACCCTTTCTTAATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(510,'a3a2d4d1a20702ec081912e41503c3af','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTATCAACCCCATTAATTGGGGGTTTTGTTTGGCGGTGATCGCTAGCTTAATTGCTGGTTGATTACTGCTAAGCGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTATTTTAAACCCTTTCTTAATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(511,'bcc38dc6454cb609f6d6aa19563d9cfc','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTATCAACCCCATTAATTGGGGGTTTTGGTTGGCGGTGATCGCTAGCTTAATTGCTGGTTGATTACTGATAAGCGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTATTTTAAACCCTTTCTTAATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(512,'3ab5216ed6be7d2629fd65d6a07b6ad2','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTATCAACCCCATTAATTGGGGGTTTTGGTTGGCGATGATCGCTAACTTAATTGCTGGTTGATTACTGCTAAGCGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTATTTTAAACCCTTTCTTAATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(513,'3cda763a7e9d996246ad9e6795dd7068','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTATCAACCCCATTAATTGGGGGTTTTGGTTGGCGGTGATCGCTAGCTTAATTGCTGGTTGATTACTGCTAGGCGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTATTTTAAACCCTTTCTTAATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(514,'be0b430fcfe0f2476561ad9c8be71d41','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTATCAACCCCATTAATTGGGGGTTTTGTTTGGCGGTGATCGCTAGCTTAATTGCTGGTTGATTACTGATAAGCGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTATTTTAAACCCTTTCTTAATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(515,'358546744ed88ab7015585c45bb85f76','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTATCAACCCCATTAATTGGGGGTTTTGTTTGGCGGTGATCGCTAGCTTAATTGCTGGTTGATTACTGATAGGCGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTATTTTAAACCCTTTCTTAATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(516,'fda4226e454c44e1935dda95eba0ac0e','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTATCAACCCCATTAATTGGGGGTTTTGGTTGGCGATGATCGCTAGCTTAATTGCTGGTTGATTACTGCTAAGCGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTATTTTAAACCCTTTCTTAATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(517,'0bb8743153006d1faf9767aec6260fb0','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAATCTTTCCACGTGAACTGTTTTTGTAAATTTGGGCTTCGCCTGCTGCGTTCTTTTACCATTTAATTATTTATTTTTTTCTTTGGTGAAGGAATGCGACGGCTTGAGGCCATCAGGGTGCGCTTGCTTGGTTACTTTTGTTTGTACCATTCAAAAAAATGTAATCGAGCGAGTGCGCTCTTTGTCAACCCATTTCTTTTGAAACTGATTATACT');
INSERT INTO marker_sequence VALUES(518,'3dd3b5989ee07ed2d2b3fac826dbb94f','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAATCTTTCCACGTGAATTGTTTTGCTGTACCTTTGGGCTTCGCCGTTGTCTTGTTCTTTTGTAAGAGAAAGGGGGAGGCGCGGTTGGAGGCCATCAGGGGTGTGTTCGTCGCGGTTTGTTTCTTTTGTTGGAACTTGCGCGCGGATGCGTCCTTTTGTCAACCCATTTTTTGAATGAAAAACTGATCATACT');
INSERT INTO marker_sequence VALUES(519,'e16426989a336ad828be4cb4d6d55db7','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAATCTTTCCACGTGAACTGTTTTGTAAATTTGGGCTTCGCCTGCTGCGCGCTTTGCTTTTTCGTGAAGAGTGCGACGGCTTGAGGCCATCAGGGTGCGCTTGCTTGATTTTTTTTGGAATCGGGCGAGTGCGCTCTTTGTCAACCCATTTCTTTTGAAACTGATTATACT');
INSERT INTO marker_sequence VALUES(520,'520dd408b1c8c34d572f886dfc82d946','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAAACATCTTTCCACGTGAATTGTTTTTGTTGTAAGCTTGGGCTTCGCTGTGTGTGTGCGCTTGTCGTACCATCGGTTTGAGGCCATCAGGACTTGTACGAGTCCTTCTTTGTAAACCCATTTCTTTTGTTATTATTAAAACTGATCATTACT');
INSERT INTO marker_sequence VALUES(521,'19a7a75bb44a74c58a181d6c59fec34c','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACCTTTCCACGTGAACTGTCTGTATTTGTTTTGTGTCTGCGCGTTGCTGGCGTGCGTGCGTTTGCTTGCGCTTCGGTGTTGGCGAGTGCGTGCTGGCGGTGCGCGGACTGAACGAAGGTTGTGTTGTTGTGCGTCTGCGGATTTGCTGTGCTTTACTTTTTTTTTGTATCGCGTGGCGGGGTGTTGCGGGTGCTATTCGACCGGCTGACTTATCTTTTTCAAACCCCATACCTAACTTACTGATTAATACT');
INSERT INTO marker_sequence VALUES(522,'501ce547299e7c41f30976431e3d9c22','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTTAAACTATCCACGTGAACCGTTTGTACCAAGATTTGCGCCGAGATGTTTGTGCGTATTTGTTGTATCACTGTGTATTCGTACGCGGTGTGTGTCAAATATGTATGTCGCTTGGCTGATCGAAGGTCGTATCGCACTGTATTGTGTGTGTCGGCTGACTTATTTTTCAAACCCATTCTTACATACTGATTATACT');
INSERT INTO marker_sequence VALUES(523,'a526c4a57e18ed41ad3096d0e7293174','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTCGTTATTTGTTGTGCGCTCTCTGCGGTGTCGGTGGCGTCTGCTGGCTTTGTTGCTGGCGGGTGCGAGCCGGATGCGGAGGCTGAACGAAGGTCGAGTTGCTTTGCTCTCGGCTGACTTATTTTTCAAACCCAATACCAAACTTACTGATTATACT');
INSERT INTO marker_sequence VALUES(524,'e1d5caa9c3bd281850b302b256e9db57','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACTGTCGTTATTTGTTGTGTGTGTGCGCRTTGGTAGCATGCGYGTTTGCTTACGCTTCGGTGTTTGCGAGTGCGCGTGCTGGCRGTGCGCAGACTGAACGAAGGTCGTGTGTTGCTGTGTGCCTGCTGCATCGCTGACTTTGCATTGATTTGCATGATGTTGGCGGAGTGGCGGGTGCTGTGCGTGCGCGGCTGACTTATTTTTTCAAACCCCATACCTAAATGACTGAWTATACT');
INSERT INTO marker_sequence VALUES(525,'9453c342aac20b69a9f6fe68c1bb2512','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCAAAAAAACTTTCCACGTGAACCGTTTTGTGCGTTTTGTGCCTTTTTGTTGTTTTTTCGTATTGTTTTTTTTTTTTAAATGAAACGGAGAATAACGGAAGGCTAAACGAAGGCTGCGAGTTTCGTGCTTGCGGCCGATTTATTCTTTCAAACCCCATACATTATATACTGAACTATACT');
INSERT INTO marker_sequence VALUES(526,'0fb072e5a68eaa5edf3d7906110ff15d','TTTCCGTAGGTGAACCTGCGGAAGGRWCATTACCACACCTAAAAAACTTTCCACGTGAACTGTCAAACCTGTTCTGTGCTTGTGCTGGGTCTGCGTTTTCGGACGCGGACGCGGCGGAGGCTGAACGAAGGTTGGTTTTCTTCTTGTGAGAGACCAGCTGATATATTTTTCAAACCCCTTTTTTACAAAATGACTGATCAATACT');
INSERT INTO marker_sequence VALUES(527,'4e589ac66c46cced6e5f94a9e6b52b3e','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTCTGTATTTGTTTTGTGTCTGCGCGTTGCTGGCGTGCGTTTGCTTGCGCTTCGGCGTTTGCGAGTGCGTGCTGGCGGTGCGCGGACTGAACGAAGGTTGTGTTGCTGTGTGTCTGCTGCACTGCTGACTTTGCATGAAGTTGTATCGTCTTGGCGGAGCGGCAGGTGCTGATGCGACCGGCTGACTTATTTTTTCAAACCCGATACCTAAATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(528,'db6722de2c4890b7ef3d3a6b71db214c','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTATCCACGTGAACCGTTAAGCAAACAAGTTAAGGCAGGCGCGATTGATGGTGCGTCTGGGAAGCGCTTGTCGATATTCGATCGGATCGGATATTGTCGGGCGTCGTCCTGGACACGCTGTCGAGCGGAGTCGGCTAAACGAAGGTCGGGCGTTCGCTATCGGAGCGATGTGCGCGTTGTCGCACGTTGCTGCAATGGCTCGAGCAAGCGGCTGATTTATGTCTTTCAAACCATACGTGACGTACTGATGATACT');
INSERT INTO marker_sequence VALUES(529,'61256721c23efaa9da67878f020c7d33','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTTTGTACCAGATTAGCGCCGTGACGTGCGATTGTTGTTCTTTTTTGCTGCATATGTGGCGACAACGATTGTGCGGACGCGGCTGATCGAAGGTCGTGTGCGTGCTAGCGCGTGCTCGGCTGACTTATCATTTTCAAACCCCTTCTTACTTTAACAACTGATCTTTACT');
INSERT INTO marker_sequence VALUES(530,'277e9b888a70dd3e5fbfa2935ce20971','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCAAAAACTTTCCACGTGAACTGTCTTAGCATGTTTTGTGCCTTTGATTAKGCTAAACGAAGGTCGGAGTAAAATCTGGCTGATCTATTTTTTAAACCCCTTACTTAAACACTGATTTATACT');
INSERT INTO marker_sequence VALUES(531,'84c5a8bf81375d6ed827da4ef391b6c8','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTATTCACGTGAACCGTCAATTAAACCAGTTTTGTGTCGCGTTGTGTGCGTGTTTTCCATTTCAATTGCTTTTTTTAAACGAATCGCGAGCGAGGAGGAGAAGACAATCGCAATGTCGACTGAACGAAGGTCGAGTTTGTTTTCTATTCGTAGAGAACGAGTTTGGCTGATTTATTCTTTTTCAAACCCTAAATCCTAAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(532,'ab383244716b36871abc7508df043468','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCAAAAATCCTTTCCACGTGAACTGTCTTACGAGATTCGCGCCGTGACGCGTGTTAGCGCTGTGTGTATATGTCTGTGTCTTCTTTCGGGGAGATGTGGATTGTGTGCACATGGTGCTGACTGCGTGGGTCGGCTGATCGAAGGTCGCTTTGTGCTGTATGTATAGTGCAAAGTGGCTGACTTATTCTTTCAAACCCATTACTCAATACTACTGATTAATACT');
INSERT INTO marker_sequence VALUES(533,'690d1f0ee357088ae511715e717d9b2b','CTTCCGTAGGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTTCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(534,'a04a413be08d7e9a4c4c8e896679298b','CTTCCGTAGGGTGACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGGCTGTCGATGTCAAAGTCGACGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(535,'42c445a8cf3f97d84d765b972a79f212','GTTCGTAGGTGAACTGCGGAAGGATCATTACCACACCTAAAAACACCCTTCCACGTGAACCGTTTTGTTTTGCTTTCGAGTGCTTTGTTGCGCTCGGAGCATGTTTGGGCTTCGCTGCTGGCGCTTGATTGTGCTGGCGGCTCGAGGCCATCAAGTGGCGTTTTGAGTGTGCGTTGCGCAATTAAAACGTCCAAACCCTTTTAAACCCCATTTGATTGAAAACTGAAGTATACT');
INSERT INTO marker_sequence VALUES(536,'7c4aa61e319a01684ac520d340eae1e2','TTTCGTAGTGAACTGCGGAAGGATCATTACCACACCTAAAAACACCCTTCCACGTGAACCGTTTTGTTTTGCTTTCGAGTGCTTTGTTGCGCTCGGAGCATGTTTGGGCTTCGCTGCTGGCGCTTGATTGTGCTGGCGGCTCGAGGCCATCAAGTGGCGTTTTGAGTGTGCGTTGCGCAATTAAAACGTCCAAACCCTTTTAAACCCCATTTGATTGAAAACTGAAGTATACT');
INSERT INTO marker_sequence VALUES(537,'5ae632c57e47cf5df40e28c13fbdd991','TTTCGTAGGTGAACTGCGGAAGGATCATTACCACACCTAAAAACACCCTTCCACGTGAACCGTTTTGTTTTGCTTTCGAGTGCTTTGTTGCGCTCGGAGCATGTTTGGGCTTCGCTGCTGGCGCTTGATTGTGCTGGCGGCTCGAGGCCATCAAGTGGCGTTTTGAGTGTGCGTTGCGCAATTAAAACGTCCAAACCCTTTTAAACCCCATTTGATTGAAAACTGAAGTATACT');
INSERT INTO marker_sequence VALUES(538,'c28b086bae183783267aea373e6017a4','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAAAACCCTTAGTTGGGGGCTTCTGTTCGGCTGGCTTCGGCTGGCTGGGCGGCGGCTCTATCATGGCGAGCGCATGGGCCTTCGGGTCTGAGCTAGTAGCCCTCTTTTTAAACCCATTCCTAAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(539,'09a61080fac555762020523d9d0c65d4','TTTCCGTAGGTGAACTTGCGGAAGGATCATTCCCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(540,'7075d38f892326f8f9a73322068d15a6','TCTCCGTAGGTGAACCTGCGGAAGGATCATTTACCACACCTAAAAAACTCTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(541,'2c7490e46e89d73eb484cbeadbb0547b','TTTCCGTAGGTGAACCTGCGGAAGGATCATTATCCCACCTAAAAAACCTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGGTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(542,'8a7b3ba717cc915bea47c8014e8e4c98','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATTAACAATTATAATTGGGGGTGATCTTAATGGAGGCTACTAGTCATTTTGGCTGGAGGCTACTATCGAGTGAACCTTATCATGGCGAAAAACTAGACTTTTGTTTGGTGAAGTAGTGAAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(543,'92c29bc27345a49ab5cba840ac4a01f5','TCCGTAGGTGAACTGCGGAAGGATCATTACCACACTAAAAAACTTTCCACGTGAACCGTATTAACAATTATAATTGGGGGTGATCTTAATGGAGGCTACTAGTCATTTTGGCTGGAGGCTACTATCGAGTGAACCTTATCATGGCGAAAAACTAGACTTTTGTTTGGTGAAGTAGTGAAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(544,'d61e6c80f717f3105619e6a026f7058c','CTTCCGTAGGGTGAACCTGCGGGAAGGATCATTACCACACCTAAACAACTTTCCACGTGAACCGTATCAACAAGTAGTTGCGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO marker_sequence VALUES(545,'fd195011543e7136a047dfe60140db7b','TTCCCGTAGGGTGGACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO marker_sequence VALUES(546,'25269a233837ab8bb0bc14e27374325b','TTCCCGTAAGGTGAACCTGCGGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO marker_sequence VALUES(547,'9658301642ee9b858160b9a549e98dfc','TTTCCGTAGGTGAACTGCGGAAGGATCATTACCACACCTAAAAAACTTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(548,'c11f90edae716b4b780ec14c67492c4d','TTTCCGTAGGTGAACTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAAAACCCTTAGTTGGGGGCTTCTGTTCGGCTGGCTTCGGCTGGCTGGGCGGCGGCTCTATCATGGCGAGCGCTTGAGCCTTCGGGTCTGAGCTAGTAGCCCACTTTTTAAACCCATTCCTAAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(549,'955a02294bda1d76a622148d3d9b434e','CCCGTAGGTGAACTGCGGAAGGATCATTACCACACCTAAAAAAACTTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(550,'f6a0f223ba6612a08dacc0d5aed1376f','TTTCCGTAGGTGAACTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(551,'2f4efde9c1dd2b2be46b56d546ba31de','TTTCCGTAGGGTGAACCTGCGGAAGGATCATTACCACACTTTAAAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTGACTGAGCTGGTGTTTTCATTTTTGGACACTGGAACGGGAGTCAGCAGGACGAAGGTTGGTCTGTTGTAATGCAAGTTATGATGGACTAGCTGATGAACTTTTGTTTTTAAACCCTTACCTAAATACTGATTTATACT');
INSERT INTO marker_sequence VALUES(552,'f290875068ce712a4c4540ec9a952f35','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACTTTAAAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTGACTGAGCTGGTGTTTTCATTTTTGGACACTGGAACGGGAGTCAGCAGGACGAAGGTTGGTCTGTTGTAATGCAAGTTATGATGGACTAGCTGATGAACTTTTATTTTTAAACCCTTACCTAAATACTGATTTATACT');
INSERT INTO marker_sequence VALUES(553,'cccc5940b8faac002d4a919653736c2e','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACACCCTTCCACGTGAACCGTTTTGTTTTGCTTTCGAGTGCTTTGTTGTGCTCGGAGCATGTTTGGGCTTCGCTGCTGGCGCTTGATTGTGCTGGCGGCTCGAGGCCATCAAGCGGCGTTTTGAGTGTGTGTTCGCATACAATTGAAACGTCCAAACCTTTTAAACCCATTTGATTGAAAACTGAAGTATACT');
INSERT INTO marker_sequence VALUES(554,'5a458880acf3c93daa0874ab0dab14d0','TTTCCGTAGTGAACCTGCGGAAGGATCATTTCCACACCTAAAACACCTTTCCACGTGAACCGTATCAATCCAATGAGTTGGGGGTTTATTTGGTAATGGCTGCTGGCATGTTTTATGCAGGCTGGCTGTTGCTGAGTAAGTCCTATCGTGAGCGTTTGGACCTCGTCGGTCTGAGCTAGTAACTTGAAATTGTAAACCCATTCTTAATTACTGAATATACT');
INSERT INTO marker_sequence VALUES(555,'a946c62cbec42ee01a9f27cac2641093','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTCAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(556,'a0f16354a0ecc4940972b2aef84a8bb1','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCCTTCTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(557,'38e9ac5563db2a74294b9db716d52089','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAAYGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTCCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(558,'0df4fff59813ce219204d862ac82162b','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGKCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTCCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(559,'e5886806762e2c964d2fcbb23700a053','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTRCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(560,'1890f11e1c00b68914cfa865d05701af','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGYTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCCTTCTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(561,'6365b9d59fdaea9e71c336df5b55db66','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCACCCCCTTAAGATTGGGAGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCCTTCTTTAATTACTGAAATACT');
INSERT INTO marker_sequence VALUES(562,'dff82cdd8ded5b1003849d434f9b2d9b','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTTAAAACTATCCACGTGAACCGTTTGTACCCAGATTTGCGCCGAGATTTTCGTGCGTGTTTGTTTGTATCACTGTGTATTCGTACGCGGTGTGTGGCAAATATGTATGGAGCTTGGCTGATCGAAGGTCGTATCGCACTTTATTGTGTGTGTCGGCTGACTTATTTTTCAAACCCATTACTTACTACTGATTATACT');
INSERT INTO marker_sequence VALUES(563,'2ef7ae8b17a25ccdbc6f5cb4d3610033','TTTCCGTAGGTGAACCTGCGGAAGGATCATTATGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTCGTTATTTGTTGTGCGCTCTCTGCGGTGTCGGTGGCGTCTGCTGGCTTTGTTGCTGGCGGGTGCGAGCCGGATGCGGAGGCTGAACGAAGGTCGAGTTGCTTTGCTCTCGGCTGACTTATTTTTCAAACCCAATACCAAACTTACTGATTATACT');
INSERT INTO marker_sequence VALUES(564,'c088527ec9fe24f922a2ec741c8178b5','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACTGTCGTTATTTGTTGTGTGTGTGCGCATTGGTAGCATGCGTGTTTGCTTACGCTTCGGTGTTTGCGAGTGCGCGTGCTGGCAGTGCGCAGACTGAACGAAGGTCGTGTGTTGCTGTGTGCCTGCTGCATCGCTGACTTTGCATTGATTTGCATGATGTTGGCGGAGCGGCGGGTGCTGTGCATGCGCGGCTGACTTATTTTTTCAAACCCCATACCTAAATGACTGAATATACT');
INSERT INTO marker_sequence VALUES(565,'e972badb25937086148cd71d51857a4b','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACTCCTAAAAAAACTTTCCACGTGAACTGTCGTTATTTGTTGTGTGTGTGCGTGTTGGTAGCATGCGTGTTTGCTTACGCTTTGGTGTTTGCGAGTGTGTGTGTTGTCGGTGCGCAGACTGAACGAAGGTCGTGTGTTGCTGTGTGCCTGCTGCACTGCTGACTTTGCATTGATTTGCATGGTGTTGGCGGAGCGGCGGGTGCTGTTGCGTGCGCGGCTGACCTATTTTTTTCAAACCCCATACCTAAATGACTGATTATACT');
INSERT INTO marker_sequence VALUES(566,'55c0e89766b0decb3b721563c7d584e2','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAATCTTTCCACGTGAATTGTTTTGCTGTACCTTTGGGCTTCGCCGTTGTCTTGTTCTTTTGTAAGAGAAAGGGGGAGGCGCGGTTGGAGGCCATCAGGGGTGTGTTCGTCGCGGTTTGTTTCTTTTGTTGGAACTTGCGCGCGGATGCGTCCTTTTGTCAACCCATTTTTTGAATGAAAAACTGATCATACT');
INSERT INTO marker_sequence VALUES(568,'be2eb2eea7c3b7cad3594538b48352d8','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTCTCCACGTGAACTGTCTGATCCGATTCGCGCCGTGACGCGTGCTGCGGGTTTGTAAAAGAATCTGCGGCGTGCGGGCTCGGCTGATCGAAGGTTTCATTGCTGCGAGCGTGTGCTTTTCGGAGCGCGCGTTTATCGGCGGTGGGGCTGACTTACTCTTTCAAACCCCTTTACCGAATGACTGATGTATACT');
INSERT INTO marker_sequence VALUES(569,'0df67e279a276edd7458d432fddd2707','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAATCTTTCCACGTGAATTGTTTTGCTGTACCTTTGGGCTTCGCCGTTGTCTTGTTCTTTTGTAAGAGAAAGGGGGAGGCGCGGTTGGAGGCCATCAGGGGTGCGTTCGTCGCGGTTTGTTTCTTTTGTTGAAACTTGCCCGCGAATGCGTCCTTTTGTCAACCCATTTTTTGAATGAAAAACTGATCATACT');
INSERT INTO marker_sequence VALUES(570,'eedb1816618a4e690fa397e83c6c8fd0','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACTTTAAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTAACTGATCTAGTGCTTTTCCTATTTTTGGGACACTGGAATACAGGATTCAGCAGGACGAAGGTTAGTCTCTCGTAATGCAAATTAGGAGGACTAGCTGATGAACTTTTCTTTTTAAACCCTTACCTAAATACTGATTTATACT');
INSERT INTO marker_sequence VALUES(571,'888e981a2b2846f2f45284af68e441ff','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAACACCCTTCCACGTGAACCGTTTTGTTTTGCTTTCGAGTGCTTTGTTGTGCTCGGAGCATGTTTGGGCTTCGCTGCTGGCGCTTGATTGTGCTGGCGGCTTGAGGCCATCAAGCGGCGTTTTGAGTGTGTGTTCGCATACAATTAAAACGTCCAAACCTTTTAAACCCATTTGATTGAAAACTGAAGTATACT');
INSERT INTO marker_sequence VALUES(572,'a96f466b160c121b875fcea5ba990d63','TCTCCGTAGGGTGAACTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTATCAAACCGTTTTAGTTGGGGGTCTTGCTTGGCATTTTGCTGAGCCGCCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCGAGTAGCATTTTGTTTTAAACCCATTTCTCAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(573,'4f6ec6bb5bfe9857d933ff96eb96ced0','TTTCTGTAGGTGAACATGCGGAAGGATCATTACCACACATAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO marker_sequence VALUES(574,'43f613224a8ab0943a0d34575f41664e','TTTCTGTAGGTGACTGCGGAAGGATCATTACCACACGTAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO marker_sequence VALUES(575,'5f1ac58fe15890d49245861e9031a5f4','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGGGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(576,'0779f13c1f00a7d17a438590355dcd75','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(577,'aebf57764e329ea0772a4227caa7774a','TTTCCGTAGATGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(578,'706fa349f33364e400be9cd14236a4f2','GTTCCGTAGGTGAACCTGCGGAAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATTACCAAAGTTAGTTGGGGACTCCCTGTTGTTGGTCGATGTAGCAATATGTTGACCGGCGGCGGGTTGAGACCTATCAAACGACGGCGACGAATGTGCGGGCTGAAAAGTCGGCACGTTTGTTTCTGAAGTTTCTCTTTTAAACTCCTTCTTATTTAACTGAACATACT');
INSERT INTO marker_sequence VALUES(579,'a541ea370f26ebd3abdbb53e792d505c','TTTCCGTAGGTGAACCTGCGGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCCGCTGGTCGGCTCCATCAAACGAGGCTCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTTTTTGTAAACCCTTTTTAATATTTTCTGATGATACT');
INSERT INTO marker_sequence VALUES(580,'9ac09b835e9e517eb814cbeb5bbf96b7','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTAACAAACCAATAGTTGGGGGCGAGTTTGGCGGCTGCTGCTGCTGGACGAGCTCTATCATGGCGAGCGTTTGGACTTCGGTCTGAACTAGTAGCCCTTCTTTTAAACCCATTCCTAATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(581,'9bf1f9e07f01983d74280cc4f546eb66','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCTGCCCTTGGTGGTGGCTCCATCAAACGAGGCCCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTGTTGTAAACCCTTTTGTAATTTTTCTGATCATACT');
INSERT INTO marker_sequence VALUES(582,'580f8527ff86c4d9141248aa214a024c','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCAAAAACTTTCCACGTGAACTGTCTTAGCATGTTTTGTGCCTTTGATTAGGCTAAACGAAGGTCGGAGTAAAATCTGGCTGATCTATTTTTTAAACCCCTTACTTAAACACTGATTTATACT');
INSERT INTO marker_sequence VALUES(583,'7569d70ed6e495569202109ff978aae3','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGCCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGGGAGCCCTATCAAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(584,'137ccb18340a59821a97c1359e322156','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(585,'ff3f4d95350ee27b4aa7c2116ac5ff19','TTTCGTAGGTGAACTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO marker_sequence VALUES(586,'7f31770b87b54f1ce1d83fc6be9fbae9','TTTCGTAGGTGAACTGCGGAAGGATCATTACCCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO marker_sequence VALUES(587,'51166230544c4248de315c58446a2d83','TTTCCGTAGGTGAACTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO marker_sequence VALUES(588,'9625dfc9c662a2d0fe385dd9a01eca4b','TTCGTAGGTGAACCTGCGGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO marker_sequence VALUES(589,'25246a770a67ef7b29d6274b2765a402','TTTCGTAGGTGAACTGCGGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO marker_sequence VALUES(590,'1c471fab01d15528a6181215d85e6676','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO marker_sequence VALUES(591,'c9ffbe55146983661f684c9b22ebd5fb','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO marker_sequence VALUES(592,'8a0f2eece3abe12c27d34cae6d831139','TTTCGTAGGTGAACTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO marker_sequence VALUES(593,'de307c46f163c26f9d0e0a51b028c83e','TTCGTAGGTGAACTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO marker_sequence VALUES(594,'a648240a0692f31f13181f7519d04523','TTTCTGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO marker_sequence VALUES(595,'900f431295cb1b61cf5a4817f349e4e8','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO marker_sequence VALUES(596,'f6fdb8abff76857755e50980d8709dc6','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACAATTTAAATTGGGAGCGATCTTGGTGGTGGCTTCTAGTCTTTTGACTGGTGGCTACTATTGGGTGAGCTCCATCATGGCGAACCATTGGACTTTGTCTAATGTAGTAGTATAAATTTTAAACCCTTACTTAATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(597,'26dfe6e36479116861fb8b687e172475','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGCGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO marker_sequence VALUES(598,'a1290b71d32ef4510c9c4b445565e40f','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO marker_sequence VALUES(599,'2ee6dbeaaa5665e1aa8e8c64e339f308','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGTTTGGCGGCGTGCGTGCTGGCCTGTTAAGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGATCGTTTTGGGCTTCGGCTCGAGCGAGTAGCTTTAATTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO marker_sequence VALUES(600,'4dfb42c0d964c78956a1fa99aa4c6a17','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAATCTTTCCACGTGAATTGTTTTGCTGTAATTTTGGGCTTCGCCGTTGTCTTTTTTCTTTTTTTCTTTTTTGTAAAAAAGGGGGAGCGCGGTTGGAGGCCATCAGGGGCGTGTTCGTCGTGCGTTTTATGATTCTATGATTCTATGATTCGCGCGCGAGTGCGTCCTTTTGTCAACCCATTTCTTTTGAAAAACTGATCATACT');
INSERT INTO marker_sequence VALUES(601,'a9d05e6ffc89812632209e5d1ae79869','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAATCTTTCCACGTGAATTGTTTTGCTGTAATTTTGGGCTTCGCCGTTGTCTTTTTTCTTTTTTTCTTTTTTGTAAAAAAGGGGGAGCGCGGTTGGAGGCCATCAGGGGCGTGTTCGTCGTGCGTTTTATGATTCTATGATTCTATGATTCGCGCGCGAGTGCGTCCTTTTGTCAACCCATTTCTTTTGAAAAACTGATCATACT');
INSERT INTO marker_sequence VALUES(602,'bf9aa1795af1e8356c93ad8b590ddae8','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAATCTTTCCACGTGAATTGTTTTGCTGTAATTTTGGGCTTCGCCGTTGTCTTTTTTCTTTTTTTTCTTTTTGTAAAAAAGGGGGAGCGCGGTTGGAGGCCATCAGGGGCGTGTTCGTCGTGCGTTTTATGATTCTATGATTCTATGATTCGCGCGCGAGTGCGTCCTTTTGTCAACCCATTTCTTTTGAAAAACTGATCATACT');
INSERT INTO marker_sequence VALUES(603,'12887ae18ccdc8b16975d73329f3226c','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAATCTTTCCACGTGAATTGTTTGCTGTAATTTGGGCTTCGTCGCTGCGTGTCCGTGAAAAAGGCGCGCGCGGCTGGAGGCCATCAGGGGTGCGTTTCTTTCGGACCGCTCCCTTTTGTCAACCCATTTGTATTCTTTTGAAAACTGATCATACT');
INSERT INTO marker_sequence VALUES(604,'1b5f542578dcfe73f3a1559317ac2bfa','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAATCTTTCCACGTGAATCGTTTGCTGCAATGTTGGGCTTCGCTGGGCGTGAGTTCGGTTGGAGGCCATCAGGGCGTGCTGTTCTTGTGACGGTCGCTCTTTTTGTAAACCCATTTGTATTGAAACTGATTGTACT');
INSERT INTO marker_sequence VALUES(605,'679466a5c195d4c105d3bf9a474309c8','TATTCGTAGGTGAACCTGGGGAAGGATCATTACCACACCTAAAGAACTTACATTTCCCAATTTCATCCCCATAGTTGGGGGTCTTACTGGGCGGCGGCTGCGGGATTTATAGCTGGATGCAAATGCTGAGCGAGCCGTATCATGATGCGACAGTCCGGACTTCGGTCTGAGCTAGTACCTTTTTTATTTTAAATCCTTCACTTAATACTGATCATACT');
INSERT INTO marker_sequence VALUES(606,'d7044a6ee0a49534ccde949acba546a8','TTTCCGTAGGTGAACCTGCGGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(607,'277709cfd2a669d578981a2309f1d7a8','TTTCCGAAGGTGAACCTGCGGAAGGATCATACCACACATAAAAACTTTCCACGTGAACCGTTTTCAACCCAATAGTTGGGGGGTCTTACTTGGCGGCGGGCTGCTGGCTTTATTGCTGGCGGATACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTAGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(608,'1a04508e37fc4cb7e42019bad0e57424','TTTCCGTAGGTGAACTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGACCGTTTCAACCCAATAGTGGGGGTCTTACTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(609,'c5abc7d6c8e1ec8a84038725f639898f','TTTCGTAGGTGAACTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTCGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(610,'07d0b76907342047f51b97b79f769e65','TTTCCGTAGGTGAAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(611,'4b53389ae30dad1bb0a6296fd4520855','TTTCTGTAGTTTAACCTGCGGAAGGATCATTACCACACATAAAAACTCTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(612,'d3cff96b65c034eb5f07106895a7571a','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTCGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(613,'814f2bc749d26cc69042d59b891e2010','TTTCCGTAGGTGAAGCTGCGGAAGGATCATTACCACACATAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(614,'24739260e17ede86b47fd1873757e46c','TTTCTGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(615,'003e673466229ef503fe2c2adaec5a71','TCTCAGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(616,'18f1ae214733a74d770d47b35cc287de','TTTCTGTAGGTGAACCTGCGGAAGGATCATTTACCACACATAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(617,'802ef17fd5d2e2cc425538d2546b4f78','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(618,'d5de54c06b7f94f5b93800269b703a89','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACATAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(619,'8099b056bfc997be4223229bc82c9e09','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTCAACCTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTCGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(620,'ca72e970a6f55e364ca1e93b21c1dec1','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACTAAAAAACTTTCCACGTGAACCGTTCAACCTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(621,'8355fdff40c93d7bc9f06fd2b545d3cb','TTTCCGTAGGTGAACTGCGGAAGGATCATTACCACACATAAAAAACTTTCCACGTGAACCGTTCAACCTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(622,'bd25422fd0ec807db6140fb700c049a3','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAGCTTTCCACGTGAACCGTTCAACCTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(623,'f82e6a4a226636f8cdad41f4deb0f3a7','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTCAACCTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGTTGCTGGTGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(624,'b9ef98ee5822b990f18e5b7e9e389d29','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTCAACCTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(625,'e7fef18ac04e5189c0811481c4bcf112','ATCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCATTTCACAATTCTGATTATACT');
INSERT INTO marker_sequence VALUES(626,'d1b86b1de6486880b7e0c519671cebd6','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACGCCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO marker_sequence VALUES(627,'ee47beb745e4d4778fe5e6b8df789032','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACATAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO marker_sequence VALUES(628,'f29805ddd76df0b38decee0ab2bc461c','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACCTTCCACGTGAACCGTTCAACCTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(629,'34772cbba882b0c6f5d6210bf9ce528d','TTCTGTAGGTGAACTTGCGGAAGGATCATTACCACACTAAAAAACTTTCCACGTGAACCGTCAACCTTTTAGTTGGGGACTCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGCGACCTATCAAAACGAGTGATTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(630,'fd870caeabfede41198133a363d92a66','TTCCGTAGGTGAACTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTCAACCTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(631,'139b6366b0fc2302dc06511d35e8e39f','TTCCGTAGGTGAACTGCGGAAGGATCATTACCACACGTAAAAAACTTTCCACGTGAACCGTTCAACTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(632,'1c01455b4119772b0e83161fb74a8295','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAGAAAACTTTCCACGTGAACCGTTCAACCTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(633,'18b82f367d8ad7441d45244ff9eb6be6','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAGCCGTTCAACCTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(634,'00cd61435353ce76cd17a974c01462aa','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTCAACTTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(635,'1827f397d9f5d1595055f35a1aad6db8','TTCCGTAGGTGAACTGCGGAAGGATCATTACCACACTAAAAAACTTTCCACGTGAACCGTTCAACCTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGAGACTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(636,'045887d8c3a0573c7c031b5a1efde6e0','ATTCCGTAGGTGAACTGCGGAAGGATCATTACCAACACTAAAAAACTTTCCACGTGAACCGTTCAACCTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(637,'aad954aa0a048154a3e1ccf39a463d79','TCCGTAGGTGAACCTGCGGAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTCAACCTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(638,'3b4d0ae8c9a718f7299dc4da7d3016f1','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTCAACCTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGCGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(639,'6629dacda6d37a957717fc437e88968a','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACTAAAAAACTTTCCACGTGAACCGTTCAACTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(640,'c6efff0d661d1c2e0b08b1774c1be3b7','TTTCCGTAGGTGAACTGCGGAAGGATCATTACCCACCACTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCATTTCACAATTCTGATTATACT');
INSERT INTO marker_sequence VALUES(641,'46445620ace373f38517c9dfc741565f','ATTCCGTAGGTGAACTGCGGAAGGATCATTACCACCACTAAAAAACTTTCCACGTGAACCGTTCAACTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(642,'8b8ca81821bf3977efe1f88a5df2ede0','TTTCCGTAGGTGAACTGCGGAAGGATCATTACCACAACTAAAAAACTTTCCACGTGACCGTTCAACTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTGAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(643,'3fb7e0af331ca0f81df1bf13e1bf4560','TTTCGTAGGTGAACTGCGGAAGGATCATTACCAACACTAAAAAACTTTCCACGTGAACCGTTCAACATTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(644,'2c73026d0d7622bce09e9f20531ec2cf','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAGAAACTTTCCACGTGAACCGTTCAACCTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(645,'d99c93fb05833c9a383af80b4051cf69','TTTCCGTAGCTGAACTGCGGAAGGATCATTACCACACTAAAAAACTTCCACGTGAACGTTCAACTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(646,'01fb098b0b8ccf49b9be1b0bd2561d1b','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTCAACTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(647,'5fbed6b60c0107bca8099628ced96235','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACTAAAAAACTTTCCACGTGAACCGTTCAACTTTTAGTTGGGGACCCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(648,'66fae0637486b259809e88f2ad8aa23b','TCCGTAGGTGAACCTGCGGAAGGATCATTACCCACACCCAAAAAAACTTTCCACGTGAACCGTTCAACCTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(649,'b0bd7663c21c94f7b66434935b4e3086','TTCCGTAGGTGAACCTGCGGAAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(650,'a09ccfd0dbb469d88d6f07438d77915d','TTCCGTAGGTGAACCTGCGGAAAGGATCATTACCACCACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(651,'79c360dd99f4f687be76af1e14516ed3','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACTTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGTTCTTATTGGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(652,'5c8eaed20b3e7243ed9723ffb8213a56','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTAATTGGCGGCGGTTGTTGGCTTAATTGTTGGCGGTTGTTGTTGAATAAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(653,'dd6abca251d58114a5968abe35d5f8b6','TTTCCGTAGCGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(654,'449446a960d84d7470357ee6881daf46','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTTTCAACCCAATTATTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(655,'33e094ceb423d8bc76207dc4735c1dfc','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTCGTTATTTGTTGTGTGTCTGCGCGTTGCTGGCGTGCGTTTGCTTACGCTTCGGTGTTTGCGAGTGCGTGCTGGCGGTGCGCGGACTGAACGAAGGTCGTGTTGCTGAGTGCCTGCTGCACTGCTGACTTTGCATTGATTTGCATGGTCTTGGCGGAGCGGCGGGTGCTGTGCGTGCGCGGCTGACTTACTTTTTCAAACCCCATACCTAAATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(656,'60856ed983dc6e7fc199114358bded61','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTCTGTATTTGTTGTGTGTCTGCGCGTGCTGGCGTGCGTTTTGCGTGCCGGCGTGTGCGGACTGAACGAAGGTCGTGTCGCTGTGCGGCTGACTTCTTTTTCAAACCCCATACGTAAATGACTGATTATACT');
INSERT INTO marker_sequence VALUES(657,'dcb77a04928067a824bded5ca06d1220','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTCAAACCTGTTCTGTGCTTGTGCTGGGTCTGCATTTTCGGACGCGGACGCGGCGGAGGCTGAACGAAGGTTGGTTTTCTTCTTGTGAGAGACCAGCTGATATATTTTTTCAAACCCCTTTTTACAAAATGACTGATCAATACT');
INSERT INTO marker_sequence VALUES(658,'3392f6c7949c6129059ff8959ba808ab','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTGTCCACGTGAACTGTGCTGAAGATGATTGGGGCGTGCTGGGCGTGCGTGTGCGGCTTCGGCTGCKTGCGTGTGTTTGGCGTGCCCATCAAACGAGGAGGCGGGTCGCAAGGCCTGCTTTAGTAGTTACTATTTTAAACCCTTTTAYTGTTAACTGATATACT');
INSERT INTO marker_sequence VALUES(659,'ad76d2b630120164a0c2c93f8bbd41ae','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTGTCCACGTGAACTGTGCTGAAGATGATTGGGGCGTGCTGGGCGTGCGTGTGCGGCTTCGGCTGCGTGCGTGTGTTTGGCGTGCCCATCAAACGAGGAGGCGGGTCGCAAGGCCTGCTTTAGTAGTTACTATTTTAAACCCTTTTACTGTTAACTGATATACT');
INSERT INTO marker_sequence VALUES(660,'ba6340f463186b78fa1c0531518dc5e7','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAATTTGGGGGCTYCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO marker_sequence VALUES(661,'8ecb567b5e5716d6f750c120606c4248','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAAACTTTAGTTGGGGGTCTTTTTCGGCGACGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGATGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(662,'28c48ef7d181958172daf8eae8228686','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTNCACGTGAACCCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(663,'dde63c479dd20ce5b18386c22379287b','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTTCACGTGAACCGTATCAACCCTTTTTAGTTGGGGGTCTTGCTTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(664,'e7b5749d2adf6ae689f41a38e1dd9b61','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCCGTATCAACCCATTTAGTTGGGGGCTTGTCCTGGTGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGGCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(665,'c4d9d7cae0475d2fe8adc27110a6ec1d','TTTCCGTAGGTGAACCTGCGGGAAGGATCATTACCNCACCTAAAAAACTTTNNACGTGAACCCGTATCAACCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATTTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(666,'83a3f1230b199848a978988709babca4','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTAATTTCAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(667,'80b6f53914bca8629394fdad682b4404','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATTACCACCCAGTTGGGGACTCTCTGTTGGTGGTTGGGGCTGGCTAGCGCTGGCTTTGACTGTCGATGGGTTGAGACCTATCAAACGACGCGTTTGGGCTGCAAGGCCTGAGTGTTGTCTGTTTCTCTTGTAAACCCATTTCTAAAAACTGAATATACT');
INSERT INTO marker_sequence VALUES(668,'336200af57988de8a40ecc27368ecfc2','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTCTAAATATGTTCTGTGCTTCGTCGACGTGTGCTGCTATCCTTTGGAAAGTGGCGTAACGGAGGCTTGAGGCTGAACGAAGGTTGGCTCAGTACTCGTGTAGCTCTCGGGCTGCGCGGTGGAACGGCTTACCGATGTCTTTTTCAAACCCATTTACTAAATACTGATCTATACT');
INSERT INTO marker_sequence VALUES(669,'ec642d4b8148085bb3f426829665755d','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTTTCAACCAAATATTTTGGGGGTCTTGTCTGGCGTATGGCTGCTGCTGTAAAAGGCGGCGGCTGTTGCTGGGTGAGCCCTATCATGGCGAACGTTTGGGCTTCGGTCTGAACAAGTAGCTCTTTTTTAAACCATTACTTATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(670,'36f4940573cc05c6fdb488b251b8ec79','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCAAATAGTTGGGGATGAGTTAGGTGGCAGCTGCTGACTTTAATGTTGGCGGTAGCCGCTAGACGAGTCCTATCATAGTGAAGTGGTTTGGACATTATAGTCCGAGCTAGTAGCTATTTTTAAACCCTTACTTAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(671,'6325c50638b988c4093b76c353f1e9bf','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCCGCTGGTCGGCTCCATCAAACGAGGCTCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTTTTTGTAAACCCTTTTTAMTATTTTCTGATGATACT');
INSERT INTO marker_sequence VALUES(672,'8d5a19d0b6609eb2f1f754a0d4fcfb7b','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCTGTCTGCCKGTTGGCGGCGGCTCCATCAAACGAGGCTCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTCCTATATTTTCTGATCATACT');
INSERT INTO marker_sequence VALUES(673,'9e8bb971a4f1451db144392e5eb77ce7','GTTCCGTAGGTGAACTGCGGAAGGATCATTAACCAAAAATCCTTTCCACGTGAACTGTCGTATTTGATTCGCGCCGTGACGTGTGTCGTCGCTGCGTGTGCGTTTGTGCGTGCGTCTTCTTGGAGATGTGTGCGCGAGTGCGCGCGTGGCGGTGACTGCGTGGGTCGGCTGATCGAAGGTCGCTTTGCGCTGTCTGGCGCGGAGCGGCTGACTTATTCTTTCAAACCCATTCGTTAGTACTGAAACATACT');
INSERT INTO marker_sequence VALUES(674,'f0432c3c662dda226aedebf1c7cb8a36','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAATTTCCACGTGAACCGTTTCAACCAAAAGTTGGGGGTCTTGTTTGGCGGTGACTGCTGGCTTTATTGCTGGCGGCTGCTGCTGGACGAGCCCTATCATGGCGAAAGTTTGGACTTCGGTCTGAGCTAGTAGTTATTATTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(675,'65b51e51b328da714cc5c4893d6fcc85','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTGTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO marker_sequence VALUES(676,'afacccc1b2d58d3a50a23673e5ed686b','TCCGTAGGTGAACTGCGGAAGGATCATTACCACACTAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTTGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO marker_sequence VALUES(677,'67df3f2122a6981f257efe2affa6eebf','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTACGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(678,'c74ed94dd12163bb458c10e384c46efa','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCCAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(679,'dd96e95b7b93c47b418490e0fe10a69b','TCCGTAGGTGAACTGCGGAAGGATCATTACCACACTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO marker_sequence VALUES(680,'4ba69422aa80a919ae213b635ed4b307','TTTCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTCTAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO marker_sequence VALUES(681,'765d0fa712e105d935265b989c785ee0','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACGTAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO marker_sequence VALUES(682,'e343bdcb1c1a7993f4e59624ba1c3794','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO marker_sequence VALUES(683,'19873bf5a0614d5ae96fc3252a03c417','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGGGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(684,'60a9d525a5769eb1d6925342e9bb2753','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACTTTAAAAAACTGTCCACGTGAACTGGAAGCAAGTCTAGCGCTGTGACTGAGCTGGTGTTTTCATTTTTGGACACTGGAACGGGAGTCAGCAGGACGAAGGTTGGTCTGTTGTAATGCAAGTTATGATGGACTAGCTGATGAACTTTTGTTTTTAAACCCTTACCTAAATACTGATTTATACT');
INSERT INTO marker_sequence VALUES(685,'0a321e94415cdd5143383d1f3c361a73','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACATTCCACGTGAACCGTATCAACCCCAAGTTGGGGGTTCGATTGGCGGCGGCTGCTGGCATCTTTTTGCTGGCTGGCTACTGCCGAGAGAACCCTATCGTGAGCGTTCTGACCTTGGTTGGAGCTAGTAACTTTATTATAAACCCATTCCTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(686,'b4ce0eafd08dd1ddfc125a6e9dea1aa6','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAATCTTTCCACGTGAACCGTTTTGTGTAATAGTTGGGCTTCGCTGCCTGGCAGTCTGCGCTCGCAGTCTGTTGGAACGCTTGAGGCTATCAAGTGGGTGTGTGGTCTGTCGCTCTCGGGCGCGGGTCGCACTTCCGCTTCTGTTTGAACCCATACTTAACTTCTGAACATACT');
INSERT INTO marker_sequence VALUES(687,'c7c11b511c63bb6dcda50fe8968ad5b2','TCCGTAGGTGAACTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO marker_sequence VALUES(688,'293d58f213f9aa71e3924bb0a7315ad7','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTCATTATTTGTTGTGTGTCTGTGCGTTGTTGGTGTGCATTTGCTTACACTTTGGTGTTTGTGAGTGCGTGTTGGCAGTGTGCGGACTGAACGAAGGTTGTGTGTTGTTATGTGCCTGCTGCACTGCTGACTTTGCATTCATTTGTATGGTCTTGGCGGAGTGGCGGGTACTGTGCATGCGCAACTGACTTATTTTTTCAAACCCCATACCTAAATGACTGATTATACT');
INSERT INTO marker_sequence VALUES(689,'f296d6107b332f824077df66868871a2','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(690,'1b01ff321444067ba1f94e0b5dbcba95','TCCGTAGGTGAACCTGCGGAAGGATCATTACCCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(691,'5f0483d287d79efa03640fc9ff7077e5','TCCGTAGGTGAACCTGCGGAAGGATCATTACCCACACTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(692,'8b63dad7bf52c6c0fa1b485d2e6570f3','TCCGTAGGTGAAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(693,'52bfcad2d248b791e14a0f11f3e6708b','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(694,'36b1270325b76676449673a07eac8634','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(695,'24cf314f0c5f56d7546749b67324c232','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACCACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCCTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCATTCCTAATTACTGAAAAAACT');
INSERT INTO marker_sequence VALUES(696,'3a0c840a0db4016dc62fe90b54df9064','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGACTTAATTGCTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(697,'f71e91c7ea4f984b64fa66390b1f526a','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGACTTAATTGCTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(698,'4a937dceaeffdc52d9887267f5e9f601','CTTCGTATGTGAACCTGCGGAAGGATCATTACCACACATAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCCTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCATTCCTAATTACTGAAAAAACT');
INSERT INTO marker_sequence VALUES(699,'ff8ba2bc05cfe9151217bdb986adc1cc','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(700,'77aeaf72f5886c11f9b67da4d4393b91','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAATCTTTCCACGTGAACCGTATCAACCCCCTTCGTTGGGGGCCTGCTCTGGGCGGCGGCTGYCGATGTCAAAGTCGGCGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCCCTATTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(701,'2303d391291904d6c4002d718919b455','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCCTGTCCTGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(702,'0f9cb39229055b782eb8aa7403474039','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCYWGTCCYGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTWTCTTTTAAACCCATTCTTGAATACTGAAYATACT');
INSERT INTO marker_sequence VALUES(703,'d3570e57b23b50a42b35083e7fb6c7e5','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCCTGTCCTGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATCTTTTAAACCCATTCTTGAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(704,'f92ce0ecac86007829d5779e5a13b5ec','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGACGGGCTCTATCATGGCAATTGGTTTGGGTCCTCCTCGTGGGGAACTAGATCATGAGCCCACTTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO marker_sequence VALUES(705,'5eecfb8148b3384d6369a066fa52ee1b','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGCTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(706,'c64f61c7c4f67b1517dd5982b5b57363','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGTAGGCTCTATCGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATTAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(707,'6ee0634c2c460285d24c1736d3ec0d20','GTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCAATTAGTTGGGGGCTTGCTCTGGCGTGCGGCTGTTGACCTGTAATGGGCTGACGGCTGCTGCTGGGCGGGCTCTATCAAAGGCGAGCGTTTGGACCTCGGTCCGAGCTAGTAGCTTTACTTTTTTAAACCCATTCTTTACATACTGAATATACT');
INSERT INTO marker_sequence VALUES(708,'889f79422e2ffc567cc61c27dfbcbdb4','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTYCCGTCTGGCCGGCCGGTTCTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO marker_sequence VALUES(709,'65abe9be0c092b96f374849a7bdb18cc','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCCTGGGCCTCGGCCTGGGTTAGTAGCGTATTTTTTAAACCATTCCTAATTACTGAAAAAACT');
INSERT INTO marker_sequence VALUES(710,'7639e707a2de8bfb144f9c5f2e03c759','TTCCGTAGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACACCCTTAGTTGGGGGCTGCTGTTCGGCTGGCTTCGGCTGGCTGGGCGGCGGCTCTATCATGGCGAGCGCCTGGGCCTTCGGGTCTGAGCTAGTAGCCCACTTTTAAACCCATTCCTAATTACTGAACATACT');
INSERT INTO marker_sequence VALUES(711,'193f136c4bd08d9605ce19b428eb8305','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAATCTTTCCACGTGAATTGTTTGGACCATGTTGGGCTTCGCTGGTGTGTTTGCTTTGTACGGGTATTCCTTTTTGGAACTATTCGTAAAAAGCGGACGCGTCGGCTTGAGGCTATCAGGGCGTTGGACGCTCTCTTTGAATTTCGTGTTCGAGGAGAGTGTCTGTCGCTCTTTTGTAAACCCATTTGTAATGAAACTGATTATACT');
INSERT INTO marker_sequence VALUES(712,'909898bdc6f044b983625ae41633c558','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCTGTCTGCCTGTTGGCGGCGGCTCCATCAAACGAGGCTCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTCCTATATTTTCTGATCATACT');
INSERT INTO marker_sequence VALUES(713,'f2ad6bd2e66b38efdb54bb616cc12fe5','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACATCTTTCCACGTGAACCGTTTGTGGCATGGTTGGGCTTGTGCGTTTTCTCTCTTTTGTAGGGGGGATGCGTGCGAGCTATCTGTAAACTTGTCAAACCCATTCTTTTTGATAACTGAAACATACT');
INSERT INTO marker_sequence VALUES(714,'e1f1bf06b199288151b9cbe1b40daa06','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCACATTAGTTGGGGGTTTGATTGGCGGCTGCTGCTGACATCTTTTTGCTGGCTGGCGACTGCTGAGCGAACCCTATCCTGGCGAGCGTTCTGACCTCGGTTGGAGCTAGTAGCTTGCATTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO marker_sequence VALUES(715,'9c901f099a5a1e1bf31497b75b3ace48','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCACATTTATTGGGGGTTTCATTGACGGCTGCTGCTGGCATCTTTTTGCTGGCTGGCGACTGCTGAGCGAACCCTATCATGGCGATCGTTCTGACCTCGGTTGGAGCTAGTAGCTTGCATTTTAAACCCATTCTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(716,'c96e87d12fe1125ad17bee911413b401','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCACATTAGTTGGGGGTTTGATTGGCGGCTGCTGCTGGCATCTTTTTGCTGGCTGGCRACTGCTGAGCGAACCCTATCTTGGTGATCGTTCTGACCTTCGGTTGGAGCTAGTAGCTTGCATTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO marker_sequence VALUES(717,'291e8e1f770ffcf4b40143d4a0cfc89f','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCATTAGTTGGGGGTTTGATTGGCGGTTGCTGCTGGCATCTTTTTGCTGGCTGGCGACTGCTGAGCGAACCCTATCTTGGCGATTGTTCTGACCTTCGGTTGGAGTGAGTAGCTTGCATTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO marker_sequence VALUES(718,'dcd8f572a3963026c1e81fcfcdfef8fe','TTTCCGTAGGTGAACTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAGATTGGGAGCTTGCTCGGCGGCGTGCGTGCTGGSMWGKAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCCTTCTTTAATTACTGAAATACT');
INSERT INTO marker_sequence VALUES(719,'fcf0da69e576456b29517383aaa4265a','TTTCCGTAGGTGAACCTTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO marker_sequence VALUES(720,'0fc1531c6d4df12afe9aa709a68610c9','GTTCCGTCAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCCGAATGTTTGGGAATTTCGGTCCGGGCGAGTAAGCTTTTTGTTTTAAACCCTTTTCACAATTCTGATTATACT');
INSERT INTO marker_sequence VALUES(721,'5cca5784dda345f896e1fd9c409c9143','TTCCGTAGGTGAGACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO marker_sequence VALUES(722,'0f71712d7612c06a63ce7091d462b338','TTTCCGTAAGAGAACCTGAGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO marker_sequence VALUES(723,'d4a4551f98476ad29bcfb9eb2ffa1c02','GTTCCGTAGGTGAACGACTGCGGAAGGATCATTACCACCACTTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO marker_sequence VALUES(724,'6e5b47e4bb778b5e8cb54149f7b1b31c','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(725,'245efb631925e5c9d579c427318ad336','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTTAAAACTATCCACGTGAACCGTTTGTATGAAGATTTGCGCCGAGATGTTTGTGCGTGTTTGTTGTATCACTGTGTGTTCGTACGCGGTGTGTGGCAAGTATGTATGACGCTTGGCTGATCGAAGGTCGATATGCACTTGATTGTGTGTGTCGGCTGACTTATTTTTCAAACCCATTCTACAGTACTGATTATACT');
INSERT INTO marker_sequence VALUES(726,'5648b3a45a3c228e8522f1fecb5459f0','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCRCWCCTAAAAAACACYCTTTCCACGTGMACCGTTNTTGTTTTGCTTTCGAGTGCYTTGTTGCGACYTCACCWTCATTTGGGCTTCGCTGCTGGCGCTTGATTGTGCTGGCGGCTCGAGGCCATCAAGTGGCGTTTTGAGTGTGCTTTGCGCAATTGAAACGTCGAAACCTTTTTTTAAACCCATTTGATTGAAAACTGAAGTATACT');
INSERT INTO marker_sequence VALUES(727,'9974ae43fd33fb0ad6015fc1ecb4c7e1','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACWCCTAAAAACMYCCTTCCACGTGAACCGTTTTGTTTTGCTTTCGAGTGCTTTGTTGCGMYCGSAGCATGTTTGGGCTTCGCTGCTGGCGCTTGATTGTGCTGGCGGCTCGAGGCCATCAAGCGGCGTTTTTGAGTGTGCTTGCGCATTTTGAAACGTCCAAACCTTTTAAACCCATTTGATTGAAAACTGAAGTATACT');
INSERT INTO marker_sequence VALUES(728,'dd87a4a3ec6653b9c24e1109de2f455d','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAATCTTTCCACGTGAACCGTATCAACCCCCTTCGTTGGGGGCCTGCTCTGGGCGGCGGCTGCCGATGTCAAAGTCGGCGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCCCTATTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(729,'96c8e77e563908036f335d34089c802a','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACACCCTTCCACGTGAACCGTTTTGTTTTGCTTTCGAGTGCTTTGTTGCGCTCGGAGCATGTTTTGGGCTTCGCTGCTGGCGCTTGATTGTGCTGGCGGCTCGAGGCCATCAAGTGGCGTTTTGAGTGTGCTTTGCGCAATTGAAACGTCGAAACCTTTTTTTTAAACCCATTTGATTGAAAACTGAAGTATACT');
INSERT INTO marker_sequence VALUES(730,'91eaac3e1e4cb921440878e2098aeae5','TTTCCGTAGGTGACCTGCGGAAGGATCATTACCACACCTAAAAACACCCTTCCACGTGAACCGTTTTGTTTTGCTTTCGAGTGCTTTGTTGCGCTCGGAGCATGTTTGGGCTTCGCTGCTGGCGCTTGATTGTGCTGGCGGCTCGAGGCCATCAAGCGGCGTTTGGAGTGTGCTTGCGCACANTTTTAGACGTCCAAACCTTTTAAACCCATTTGATTGAAAACTGAAGTATACT');
INSERT INTO marker_sequence VALUES(731,'35d607edc1e89843f292c825b27a5d74','TTTCCGTAGGTGAACCTGCGGAAGGATCAYTWCCACACCTAAAAACACCCTTCCACGTGAACCGTTTTGTTTTGCTTTCGAGTGCTTTGTTGCGCTCKSAGCAYGTTTGGGCTTCGCTGCTGGCGCTTGATTGTGCTGGCGGCTCGAGGCCATCAAGCGGCGTTTGGAGTGTGTGCTTGCGCACATTTTGAATGTCCAAACCTTTTAAACCCATTTGATTGAAAACTGAAGTATACT');
INSERT INTO marker_sequence VALUES(732,'25e68bc34b3ba17f8ab0cb154ae487d7','TTTCCGTAGGTGAACCTGCGGAAGGATCAYTACCRCACCTAAAAACACCCTTCCACGTGAACCGTTTTGTTTTGCTTTCGAGTGCTTTGTTGCGCTCGCAGCATGTTTGGGCTTCGCTGCTGGCGCTTGATTGTGCTGGCGGCTCGAGGCCATCAAGCGGCGTTTGKWGWGTGTGCTTGCGCACATTTTGAATCGTCCAAACCTTTTAAACCCATTTGATTGAAAACTGAAGTATACT');
INSERT INTO marker_sequence VALUES(733,'4b2ce35aad592a07add8a10b59f68992','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACACCCTTCCACGTGAACCGTTTTGTTTTGCTTTCGAGTGCTTTGTTGCGCTCGGAGCATGTTTGGGCTTCGCTGCTGGCGCTTGATTGTGCTGGCGGCTCGAGGCCATCAAGCGGCGTTTGGAGTGTGTGCTTGCGCACATTTTGAATGTCCAAACCTTTTAAACCCATTTGATTGAAAACTGAAGTATACT');
INSERT INTO marker_sequence VALUES(734,'d6e051b77d05ca16f9eb2fe26e4a8dc1','TTTCCGTAGGTGACCTTGCGGAAGGATCATTMCCACCCCTAAAAANCACCCTTCCACGTGAACCGTTTTGTTTTGCTTTCGAGTGCTTTGTTGCGCTCGGAGCATGTTTTGGGCTTCGCTGCTGGCGCTTGATTGTGCTGGCGGCTCGAGGCCATCAAGTGGCGTTTTGAGTGTGCTTTGCGCAATTGAAACGTCGAAACCTTTTTTTAAACCCATTTGATTGAAAACTGAAGTATACT');
INSERT INTO marker_sequence VALUES(735,'0a86b4c68d0ae0bfa68441b38ce3fa3c','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCRCACCTAAAAACACCCTTCCACGTGAACCGTKYTGTTTTGCTTTCGAGTGCTTTGTTGCGCTCGGAGCATGTTTGGGCTTCGCTGCTGGCGCTTGATTGTGCTGGCGGCTCGAGGCCATCAAGTGGCGTTTTGAGTGTGCTTGCACATTTTTTGAACGTCCAAACCTTTTAAACCCATTTGATTTGAAAACTGAAATATACT');
INSERT INTO marker_sequence VALUES(736,'4c171f14423e55f0705b0942f45b08e9','GTTCCGTAGGTRACCTGCGGAAGGATCATTACCCCMCCCTAAAAAACACCCTTNCCACGTGAACCGTTTTGTTTTGCTTTCGAGTGCTTTGTTGCGCTCGGAGCATGTTTTGGGCTTCGCTGCTGGCGCTTGATTGTGCTGGCGGCTCGAGGCCATCAAGTGGCGTTTTGAGTGTGCTTTGCGCAATTGAAACGTCGAAACCTTTTTTTTAAACCCATTTGATTGAAAACTGAAGTATACT');
INSERT INTO marker_sequence VALUES(737,'3caccabb2423b0f0773b4f30adb82c1d','TTTCTGTAGGTAAACCTGCGGAAGGATCATTACCRCWSYTAAAAAACACCCTNTCCACGTGARCCGTKTTGGTTTNGCTTTCTRGTGMTTTGTTGCGCTCKSAGCATGTTTTGGGCTTCGCTGCTGGCGCTTGATTGTGCTGGCGGCTCGAGGCCATCAAGTGGCGTTTTGAGTGTGCTTTGCGCAATTGAAACGTCGAAACCTTTTTTTTAAACCCATTTGATTGAAAACTGAAGTATACT');
INSERT INTO marker_sequence VALUES(738,'a72916a906146c532ced0eba9cbc6b08','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACACCCTTCCACNGTGAACCGTTNTTGTTTTGCTTTCGAGTGCTTTGTTGCGCTCGGAGCATGTTTTGGGCTTCGCTGCTGGCGCTTGATTGTGCTGGCGGCTCGAGGCCATCAAGTGGCGTTTTGAGTGTGCTTTGCGCAATTGAAACGTCGAAACCTTTTTTTTAAACCCATTTGATTGAAAACTGAAGTATACT');
INSERT INTO marker_sequence VALUES(740,'f65cb12b202fc8fec0e92307b9a46c39','TTTCCGTAGGTGWACCTGCGGAAGGATCATTACCACACCTAAAAACACCCTTCCACGTGAACCGTTTTGTTTTGCTTTCGAGTGCTTTTGTGGCGCTCGGAGCATGTTTTGGGCTTCGCTGCTGGCGCTTGATTGTGCTGGCGGCTCGAGGCCATCAAGCGGCGTTTTGAGTGTGTGTTCGCATACAATTAAAACGTCCAAACCTTTTAAACCCATTTGATTGCAAACTGAAGTATACT');
INSERT INTO marker_sequence VALUES(741,'887162ae495d7616ceffc3cc7d3e655a','GTTCCGTAGGTGAACCTGCGGAAGGATCATTACCCACACCTAAAAACACCCTTCCACGTGAACCGTTTTGTTTTGCTTTCGAGTGCTTTGTTGCGCTCGGAGCATGTTTGGGCTTCGCTGCTGGCGCTTGATTGTGCTGGCGGCTCGAGGCCATCAAGCGGCGTTTTTGAGTGTGCTTGCGCATTTTGAAACGTCCAAACCTTTTAAACCCATTTGATTGAAAACTGAAGTATACT');
INSERT INTO marker_sequence VALUES(742,'fbac189093d584d1e62a7335d01ab2d3','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATTAATTGGGGGTTTACTTGGCGGCTGCTGCTGGCATCTTTTTGCTGGCTGGCTACTGCTGAGCGAACCCTATCATGGTGAGCGCTCTGACCTCGGTTGGAGCTAGTAGCTTGAATTGTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(743,'d12ad32ed234c43004ba6946f227df94','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGATGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGATTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(744,'cbfc8eef7a86d4fca9dd3c90bc8eb278','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTCTAAATATGTTCTGTGCTTCGTCGACGTGTGCTGCTATCCTTTGGAAAGTGGCGTAACGGAGGCTTGAGGCTGAACGAAGGTTGGCTCAGTACTCGTGTAGCTCTCGGGCTGCGCGGTGGAACGGCTTACCGATGTCTTTTTCAAACCCATTTACTAAATACTGATCTATACT');
INSERT INTO marker_sequence VALUES(745,'d8c9096936594359fab2a2297fa37088','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(746,'960b79da22cb89a499914f331ed5a857','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACATCTTTCCACGTGAACCGTTTGTGACATGGTTGGGCTTGTGCGTTTTCTCTCTCTCTTTTGGGGGAGGGGATGCGTGCGAGCTATCTGTAAACTTGTCAAACCCATTCTTTTTGATAACTGAAACATACT');
INSERT INTO marker_sequence VALUES(747,'7e0a7eb4e4e265d03a1761147f8394f7','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATCAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAGATGCGTCCCATCATGGCGATCGTTTCGACTTCGGTTGAAATTAGTAGCTAAATTTTTAAACCTTTAATTATTACTGAATATACT');
INSERT INTO marker_sequence VALUES(748,'1efe8cc39292cd3d3bb960e8812aad84','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATCAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAGATGCGTCCCATCATGGCGATCGTTTCGACTTCGGTTGAAATTAGTAGCTACATTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(749,'0208c7514d7117d8b53cc2fdd1d5703a','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATCAGGCGGCGACTACAGACTTTATTGTTAGCGGTTGCTGCTAGATGCGTCCCATCATGGCGATCGTTTCGACTTCGGTTGAAATTAGTAGCTACATTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(750,'c9acdbe68a68335fc8ad16ba6db91ea8','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATCAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAGATGCGTCCCATCATGGCGATCGTTTCGACTTCGGTTGAAATTAGTAGCTAATTTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(751,'03290fd04e27108a966e02d45ac9214e','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATCAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAGATGCGTCCTATCATGGCGATCGTTTCGACCTTGGTTGAGATTAGTAGCTACATTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(752,'47141ece4e9f2792920234543f2629da','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAGATGCGTCCCATCTCCTGGTGATCGTTTCGACCTTTGGTTGGAATTAGTAGCTAAAAATTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(753,'b29aa2af855f1f59e123e682ed7bea0e','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATTAGGCGGCGACTGCAGACTTAATTGTTAGCGGTTGCTGCTAGATGCGTCCCATCATTGCGATCGTTTCGACCTTGGTTGAAATTAGTAGCTACATTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(754,'b08ee056a5607a13249edb16d5639f3a','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAGATGCGTCCCATCATGGCGACCGTTTCGACCTTGGTTGAAATTAGTAGCTACATTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(755,'808682f6b3eb35c6b53b1b1948c07498','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATTAGGCGGCGACTGCAGACTTTTTTGTCAGCGGTTGCTGCTAGATGCGTCCCATCATGGCGATCGTTTCGACCTTGGTTGAAATTAGTAGCTACATTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(756,'ed87d9d5ec60d6a88c6c7986dc88b927','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAGATGCGTCCCATCATGGCGATCGTTTCAACCTTGGTTGAAATTAGTAGCTAAACTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(757,'b45e66d6b8e8098dd24aff3d8c019d05','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATTAAAACTTAGTTGGGGACAATTCGGGCGGCGACTGTAGACTTAATTGTCGGCGGTTGCTGCTAGATGCGTCCTATCATGGCGATCGTTTCGACCTTGGTTGAAGTTAGTAGCTGAATTTTTAAACCTTTAATTATACTGATTATACT');
INSERT INTO marker_sequence VALUES(758,'7716549bafdc5c393881c254823ddb6e','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATTAAAACTTAGTTGGGGACAATTCGGGCGGCGACTGTAGACTTAATTGTCGGCGGTTGCTGCTAGATGCGTCCTATCGTGGCGATCGTTTCAACCTTGGTTGAAGTTAGTAGCTGAATTTTAAACCTTTAATTATACTGATTATACT');
INSERT INTO marker_sequence VALUES(759,'8b9d1f6d406d8820e9ab6044be0e4311','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAGATGCGTCCCATCATGGCGATCGTTTCGACCTTGGTTGAGATTAGTAGCTACATTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(760,'ddba7b904d0aafbd2d5b03b93cdc6f1c','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAAACTTTCACGTGAACCGTATCAAATTTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAGATGCGTCCTATCATGGCGAACGTTTCGACTTTTGTTGAAACGAGTAGCTAAATTTTTAACCCTTTAATTATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(761,'5fc82dd0f13e7a0faef2391c8885e295','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTCCACGTGAACCGTATCAAATTTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAGATGCGTCCTATCATGGCGAACGTTTCGACTTTTGTTGAAATGAGTAGCTAAATTTTTAACCCTTTAATTATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(762,'b9714f9e1a00eef26bbc3f823dba1e07','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAAACTTTCACGTGAACCGTATCAAATTTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAGATGCGTCCTATCATGGCGAACGTTTCGACTTTTGTTGAAATGAGTAGCTAAATTTTTAACCCTTTAATTATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(763,'5de6034227f1b2a0ac7a0b2be5d76282','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTCCACGTGAACTGTATCAAACTTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAGATGCGTCCTATCATGGCGAGCATTTCGACCTTGGTTGAAATGAGTAGCTGAATTTTTTAACCCTTTAATTATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(764,'1e0653c2f0f09d0db35cd74f9c93c70b','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGTGGTTGCTGCTAGATGCGTCCCATCATGGCGATCGTTTCGACCTTGGTTGAAATTAGTAGCTAAATTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(765,'e2f4d432931aa1a7caefd569b6fae188','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAGATGCGTCCTATCATGGCGATCGTTTCAACCTTGGTTGAGATTAGTAGCTACATTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(766,'9a78214740ce259f0cc964049be27e59','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATTAGGCGGCGACTGCAGACTTAATTGTTAGCGGTTGCTGCTAGATGCGTCCCATCATGGCGATCGTTTCGACCTTGGTTGAAATTAGTAGCTACATTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(767,'848c0486e984fc6fef4f37d5b3a30d88','GTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCTGGACGAGTAGCTTTTTGTTTTAAACCCATTTCTCAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(768,'f3e69d0797229426939262c50f985938','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCAACTAATTGGGGGTTTGTTTGGCGGCGGCTGCTGGCATTTTGTGCTGGCTGGCTGCTACTAGACGAGCCCTATCGCGAGCGTTTGGGCCTTGGCCTGAGCTAGTAGCTTTAATTTTAAACCATTCTTAATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(769,'bd647c77278f864b0be38f60085b4349','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGRGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(770,'71790d020f98cde9a4206a9dfbbca6e0','TTCCGTAGGTGAACATGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(771,'2d1983c9fc8f05b00de282ec320fffe3','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTRGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(772,'59ca7ac2c721724bb21476bba0b5d79b','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTTTAATTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTAGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCACTTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO marker_sequence VALUES(773,'492e9f5ae3391e0c0a59dbb9a99ae22b','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTAATTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(774,'214a92c6c3b391a9cf254a1ff972611d','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACATCTTTCCACGTGAACCGTTTGTGACATGGTTGGGCTTGTGCGTGTTCTCTCTCCTTTTGGGGGAGGGGAGGCGTGCGAGCTATCTGTAAACTTGTCAAACCCATTCTCTTTGATAACTGAAACATACT');
INSERT INTO marker_sequence VALUES(775,'bef7dd790969e115ad13f3e8feb29c89','TTTCCGTAGGTGAACTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTRCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(776,'a08f8c8576cffc2c1615a1a9e6613a50','CTTCCGTAGGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCACCCCATTAATTCGGGGGTTTAATTGGCGGCGGCTGCTGGCATCTTTTTGCTGGCTGGCTGCTGCTGAGCGAATCCCATCATGGCGAGCGCTCGGACCTCGGTCGGAGCTAGTAGCGTTAATTTTAAACCATTCTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(777,'32e89ca22e4633bd095b9b96aaf291ce','TTCGTAGTGAACCTGCGGAAGGATCATTACCACACCCTAAACATCTTTCCCGTGAACCGTTTGTGACATTGTTGGGCTTGTCTTTCTTTCGGGGAGGATGAGCTATCTGTAAACTTGTCAAACCCCTTTCTTTTTTTATAAAACTGAAACATACT');
INSERT INTO marker_sequence VALUES(778,'82adbb7d385c75826ba18410f0ed6ac3','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTAGTGACAAGATTAGCGCCGTGACGCGTGCTGCGGGTACTTGATTGTATCTGCGGCGTGCGGGCTCGGCTGATCGAAGGCTTCATTGCTGCGAGTGTGTGCTCTTCGGAGCGCGTCTCGCGGCGGTGAGCTGACTTACTCTTTCAAACCCCTTCCTTAATGACTGATGTATACT');
INSERT INTO marker_sequence VALUES(779,'c35a046c609a3d36ffe7ab978e85c2bd','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTCGTTATTTGTTGTGTGTCTGCGCGTTGCTGGCGTGCGTGCGTTTGCTTACGCTTCGGTGTTTGCGAGTGCGTGCTGGCGGTGCGCGGACTGAACGAAGGTCGTGTTTGCTGTGTGCCTGCTGCACCGCTGACTTTGCATTCATTTGCATGGTCTTGGCGGAGCGGCGGGTGCTGTGCGTGCGCGGCTGACTTATTTTTTCAAACCCCATACCTAAATGACTGATTATACT');
INSERT INTO marker_sequence VALUES(780,'198065a727c50a861697611f1a4c93fd','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACTGTCGTTATTTGTTGTGTGTGTGCGCGTTGCTGGCGTGCGTTTGCTTCCGCTTCGGTGGTTGCGAGTGCGTGCTGGCGGTGCGCGGACTGAACGAAGGTCGTGTGTTGCTGTGTGCCTGCTGCACCGCTGACTTTGCATTCGTTTGCATGGTCTTGGCGGAGCGGCGGGTGCTGTGCGTGTGCGCGGCTGACTTATTTTTTTTCAAACCCGATACCTAAATGACTGATTATACT');
INSERT INTO marker_sequence VALUES(781,'1aa356ec5e2f44d439bd6bab603a3ca2','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACTGTCGTTATTTGTTGTGTGTGTGCGTGTTGGTAGCATGCGTGTTTGCTTACGCTTTGGTGTTTGCGAGTGTGTGTGTTGTCGGTGCGCAGACTGAACGAAGGTCGTGTGTTGCTGTGTGCCTGCTGCACTGCTGACTTTGCATTGATTTGCATGGTGTTGGCGGAGCGGCGGGTGCTGTTGCATGCGCGGCTGACCTATTTTTTTCAAACCCCATACCTAAATGACTGATTATACT');
INSERT INTO marker_sequence VALUES(782,'d8bcfdac895cbffee42fd108ec2e6778','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCAAAAAAACTTTCCACGTGAACCGTTTTGTACGTTTTGTGCTTTTTGTTTTTCCATTTCCGCTCTATGAGTGGGGAAGGAGAAACGCTAGGCTAAACGAAGGCCGCGAGTTTCGTGCTTGCGGCCGATTTATTCTTTCAAACCCATACATTAAATACTGAACTATACT');
INSERT INTO marker_sequence VALUES(783,'1b26143798b43e61bf7f5b907da0dbce','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTCGTTATTTGTTGTGTGTCTGCGCGTTGCTGGCGTGCGTTTGCTTACGCTTCGGTGTTTGCGAGTGCGTGCTGGCGGTGCGCGGACTGAACGAAGGTCGTGTTGCTGTGTGCCTGCTGCACTGCTGACTTTGCATTGATTTGCATGGTCTTGGCGGAGCGGCGGGTGCTGTGCGTGCGCGGCCGACTTACTTTTTCAAACCCCATACCTAACTTACTGATTATACT');
INSERT INTO marker_sequence VALUES(784,'b51e4ec97f1d0c61b3a39982c396a0ca','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCAAAAAAACTTTCCACGTGAACCGTTCTGTCCGTTTTGTGCCGTTGCTGTTGTCGTCATTCGACGAGAAGAGCAGTGGCTAAACGAAGGCTGTGAGCTTCGTGCTTGCGGTCGATTTATTCTTTCAAACCCCATACGTTAAGAACTGAAGTATACT');
INSERT INTO marker_sequence VALUES(785,'5b4dc9d223642f85e4603318d34c686c','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACTGTCGTTATTTGTTGTGTGTGTGCGTGTTGGTAGCATGCGTGTTTGCTTACGCTTTGGTGTTTGCGAGTGTGTGTGTTGTCGGTGCGCAGACTGAACGAAGGTCGTGTGTTGCTGTGTGTCTGCTGCACTGCTGACTTTGCATTGATTTGCATGGTGTTGGCGGAGCGGCGGGTGCTGTTGCATGCGCGGCTGACCTATTTTTTTCAAACCCCATACCTAAATGACTGATTATACT');
INSERT INTO marker_sequence VALUES(786,'98355008ec0b0447c05c1dd43a4e64be','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCTTCTCTTTTAAACCCATTCCTAATGACTGAATATACT');
INSERT INTO marker_sequence VALUES(787,'6157646f7353f388b239521521d2113d','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTCGTTATTTGTTGTGTGTCTGCGCGTTGCTGGCGTGCGTTTGCTTACGCTTCGGTGTTTGCGAGTGCGTGCTGGCGGTGCGCGGACTGAACGAAGGTCGTGTTGCTGTGTGCCTGCTGCACTGCTGACTTTGCGTTGATTTGCATGGTCTTGGCGGAGCGGCGGGTGCTGTGCGTGCGCGGCTGACTTACTTTTTCAAACCCCATACCTAACTTACTGATTATACT');
INSERT INTO marker_sequence VALUES(788,'f8c2252a9521e5892ad828ea460e581b','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCAAAAAAACTTTCCACGTGAACCGTTTTGTGCGTTTTGTGCCTTGTGTTTGCTTTTGTTTGTCTCGCTCTTCGGGGTGTGGTGAACAAGAGGAAACGCAAGGCTAAACGAAGGCTGCGAGTCTCGTGCTTGCGGCCGATTTATTCTTTCAAACCCATACATTAAACACTGAACTATACT');
INSERT INTO marker_sequence VALUES(789,'bbdeaef4751657007c44a081b5d8c992','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACTTTAAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTAACTGATCTAGTGTTTTCCTATTTTTGGGACACTGGAATACAGGATTCAGCAGGACGAAGGTTAGTCTCTCGTAATGCAAATTAGGAGGACTAGCTGATGAACTTTTCTTTTTAAACCCTTACCTAAATACTGATTTATACT');
INSERT INTO marker_sequence VALUES(790,'260e0ea9dd65ff4c6ddf57ee9e865ae2','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACGCCAAAAACTATCCACGTGAACCGTTAAACAAACAGAAAGGGTCGTCCTATTTGATGCGATGTTTGGGAGATACTTTGTATTTTCTAGGCATTTCATTGAGTAGGTCGACTGTCGAAGGTCGGGCGTTCGCCTATAGTGTAGCTTTTGTTGCGCTGTAAGCTTGAGCAAACGGCTGATTTATTCTTTTAAACCATACCTGAACCTACTGATTATACT');
INSERT INTO marker_sequence VALUES(791,'d7a55448f750f6d0b717790137951dca','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTCGTTATTTGTTGTGTGTTTGCGCGTTGCTGGCGTGCGTTTGCTTACGCTTCGGTGTTTGCGAGTGCGTGCTGGCGGTGCGCGGACTGAACGAAGGTCGTGTTGCTGTGTGCCTGCTGCACTGCTGACTTTGCATTGATTTGCATGGTCTTGGCGGAGCGGCGGGTGCTGTGCGTGCGCGGCTGACTTACTTTTTCAAACCCCATACCTAACTTACTGATTATACT');
INSERT INTO marker_sequence VALUES(792,'003de3f6ab282cca6d7537b273353383','TTTCCGTNGGTGAACCTGCGGAAAGGATCATTACCNNACCAYCAAAAACCTTTCCACGTGAACTGTCGTTATTTGTTGTGTGTCTGCGCGTTGCTGGCGTGCGTTTGCTTACGCTTCGGTGTTTGCGAGTGCGTGCTGGCGGTGCGCGGACTGAACGAAGGTCGTGTTGCTGTGTGCCTGCTGCACTGCTGACTTTGCATTGATTTGCATGGTCTTGGCGGAGCGGCGGGTGCTGTGCGTGCGCGGCTGACTTACTTTTTCAAACCCCATACCTAACTTACTGATTATACT');
INSERT INTO marker_sequence VALUES(793,'8e718354b57bcb369f8ddcd873292bfe','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCNCACCTAAAAAAACTTTCCACGTGAACTGTCGTTATTTGTTGTGTGTGTGCGTGTTGGTAGCATGCGTGTTTGCTTACGCTTTGGTGTTTGCGAGTGTGTGTGTTGTCGGTGCGCAGACTGAACGAAGGTCGTGTGTTGCTGTGTGCCTGCTGCACTGCTGACTTTGCATTGATTTGCATGGTGTTGGCGGAGCGGCGGGTGCTGTTGCATGCGCGGCTGACCTATTTTTTTCAAACCCCATACCTAAATGACTGATTATACT');
INSERT INTO marker_sequence VALUES(794,'796263314c02705912247ec771e039c7','GTTCCGTAGGTGACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACTGTCGTTATTTGTTGTGTGTGTGCGTGTTGGTAGCATGCGTGTTTGCTTACGCTTTGGTGTTTGCGAGTGTGTGTGTTGTCGGTGCGCAGACTGAACGAAGGTCGTGTGTTGCTGTGTGTCTGCTGCACTGCTGACTTTGCATTGATTTGCATGGTGTTGGCGGAGCGGCGGGTGCTGTTGCATGCGCGGCTGACCTATTTTTTTCAAACCCCATACCTAAATGACTGATTATACT');
INSERT INTO marker_sequence VALUES(795,'97b025a69c66a3e29c5facaae16689c8','TTTCGTAGGTGAACTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTCAAACCTGTTCTGTGCTTGTGCTGGGTCTGCGTTTTCGGACGCGGACGCGGCGGAGGCTGAACGAAGGCTGGTTTCATTTGTATGAGATCAGCTGATATATTTTTTCAAACCCCTTTTTTACAAAATGACTGATCAATACT');
INSERT INTO marker_sequence VALUES(796,'fa83abef09bdfe9721374ea79e2e0dcb','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACTTTAAAAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTCACTGAGCTGGTGTTTTCCAATATATATATATTGGACACTGGAACGGGAGTCAGCAGGACGAAGGTTGGTCTCTTGTAATGCAAGTTATGAGAGACTAGCTGATGAACTTTTCTTTTTAAACCCTTCTTACCTAAATATACTGATTTATACT');
INSERT INTO marker_sequence VALUES(797,'013646a39a3edd6c870f5e2ba6cd0f28','GTTCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTCATTATTTGTTGTGCGCTCTCTGCGGTGTCGGTGGCGTCTGTTGGCTGTATTTGATACTGCTGGCGGGTGCGAGCCGGATGCAGAGGCTGAACGAAGGTCGAGTTGCTTTGCTCTCGGCTGACTTATTTTTCAAACCCAATACCCAACTTACTGATTATACT');
INSERT INTO marker_sequence VALUES(798,'181d76ec4843899a645b02d478a88652','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTCTGTATTTGTTGTGTGTCTGTGCGTGCTGGCGTGCGTTTTGCGTGCCGGCGTGTGCGGACTGAACGAAGGTCGTGTCGCTGTGCGGCTGACTTCTTTTTCAAACCCCATACGTAAATGACTGATTATACT');
INSERT INTO marker_sequence VALUES(799,'1fad4c4994eac717bc717c7fe22ec8aa','GTTCCGTAGGGAACCTGCGGAAGGATCATTACCACACCAAAAAAACTTTCCACGTGAACCGTTTTGTGCGTTTTGTGCTTGTTGTTTTTTTCGATCTGCTGCTCTGTGGAGTGTGTGGGGAAGAAAAAGCTCCAGGCTAAACGAAGGCTGCGAGTTTCGAGTTTCGTGCTTGCGGCCGATTTATTCTTTCAAACCCATACATTAAATACTGAAGTATACT');
INSERT INTO marker_sequence VALUES(800,'f3311becad78eaafd0256d0d4ea5beb7','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTCGTTATTTGTTGTGTGTGTGCGCGTTGCTGGCGTGCGTTTGCTTACGCTTGTGTGTTTGCGAGTGCGTGGTGGCGGTGCGCGGACTGAACGAAGGTCGTGTTGCGTGTGTGTGCCTGCTGCACTGCTGACTTTGCATTCATTTGCATGGTGTTGGCGGAGCGTTGGGTGCTGTGCGTGCGCGGCTGACTTATTTTTTCAAACCCCATACCTAAATGACTGATTATACT');
INSERT INTO marker_sequence VALUES(801,'438975b416bfffe16109d9036bcbd7f6','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCAAAAAAACTTTTCCACGTGAACCGTTTTGTGCGTTTTGTGCTTTGTGTTTGCTTTTGTTTGTCTCGCTCTTCGGGGTGTGGTGGACAAGAGGAAGCGCAAGGCTAAACGAAGGCTGCGAGTCTCGTGCTTGCGGCCGATTTATTCTTTCAAACCCATACATTAAACACTGAACTATACT');
INSERT INTO marker_sequence VALUES(802,'f98c76e966cd82d59c180d4eb20d3d0c','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTATCCACGTGAACCGTTAAGCAAACAAGTTAAGGCAGGCGCGATTGGTGGTGCGTCTGGGAAGCGCTTGTCGATATTCGATCGGATCGGATATTGTCGGGCGTCGTCCTGGACACGCTGTCGATCGGAGTCGGCTAAACGAAGGTCGGGCGTTCGCTATCGGAGCGATGTGCGCGTTGTCGCACGTTGCTGCAATGGCTCGAGCAAGCGGCTGATTTATGTCTTTCAAACCATACGTGACGTACTGATTATACT');
INSERT INTO marker_sequence VALUES(803,'a1a415f58f41b0eb2a1e565d7ef87bbc','TTTCCGTAGGTGACCTGCGGAAGGATCATACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGAGCTTGTTTGGCGGCGTGTGTGCTGGCCTGTTAAGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGATCGTTTTGGGCTTCGGCTCGAGCGAGTAGCTTTAATTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO marker_sequence VALUES(804,'7607a118b32e91e7fa83c9598d83e499','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTATCCACGTGAACCGTTAAGCAAACAAGTTAAGGCAGGCGCGATTCGTGGTGCGTCTGGGAAGCGCTTGTCGATATTCGATCGGATCGGATATTGTCGGGCGTCGTCCTGGACACGCTGTCGATCGGAGTCGGCTAAACGAAGGTCGGGCGTTCGCTATCGGAGCGATGTGCGCGTTGTCGCACGTTGCTGCAATGGCTCGAGCAAGCGGCTGATTTATGTCTTTCAAACCATACGTGACGTACTGATTATACT');
INSERT INTO marker_sequence VALUES(805,'869dbbfa70f7ca9b9b35b0c88bca1342','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAATATCCACGTGAACCGTTTAGATTTGTTTTGTGCGTCGCTGACGCTTGATGTTGGGTCTCGGCCCGACGTCGCGAAGGCTTGATGCTAAACGAAGGGGCGTTCGGCGATGTGTGGCTYGTGCTGCTGTTGTCTTGAACAAACCGAGTTGTTGGGGGGTCTTGCGGCGGTAGGTAACCTCGGTTACTGGCTGCTGCGAGCGTCTCGGCGGACGGTGGCTTCGGCCGCTGAATGCCTTGAGCAAACCGACGATTTGGGGCGATCGACGACGTGGCTGCGGCTACTTTCCGTCTTGAGCAAACCGATGTCTTTTTAAACCATTTCCTAATACTGATCTATACTC');
INSERT INTO marker_sequence VALUES(806,'905f4cabc41816995852408dc86ac39a','GTTCGTAGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTCGTTATTTGTTGTGTGTCTGCGCGTTGCTGGCGTGCGTTTGCTTACGCTTCGGTGTTTGCGAGTGCGTGCTGGCGGTGCGCGGACTGAACGAAGGTCGTGTTGCTGTGTGCCTGCTGCACTGCTGACTTTGCATTGATTTGCATGGTCTTGGCGGAGCGGCGGGTGCTGTGCGTGCGCGGCTGACTTACTTTTTCAAACCCCATACCTAACTTACTGATTATACT');
INSERT INTO marker_sequence VALUES(807,'d2e560328c01681c449f4777b8b0ef5a','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTTGTTATTTGTTGTGTGTCTGTGTGTTGTTGGTGTGTATTTGCTTCCATGTAATTGTTTGCGAGTGCATGCTGTCGGCACATGGACTGAACGAAGGCTTGGTTGTCGAGTATCTGCTGATCTGGTGTGCTTTTTTGTATTGCGCGGCAGTGTTGTGGATGCTGTGCGACCAGCTGACTTATTTTTTCAAACCCCATCCCCAATTTACTGATTATACT');
INSERT INTO marker_sequence VALUES(808,'9e1a4e7a55d33fe214240c1cc49209bd','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAGTTTGGGGGCTTGTTTGGCGGCGTGCGTGCTGGCCTGTTACGGGTTGGCGTGCTGCTGCTGGGCGAGCTCTATCATGGGCGACTCGTGTTGGGCTTCGGCTCGAGCGAGTAGCTTTTCCTTTTAAACCCATTCCTAATTACTGAACATACT');
INSERT INTO marker_sequence VALUES(809,'198440accecdb83da09862ddf83ab0f2','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCAAAAAAACTTTCCACGTGAACCGTTTTGTGCGTTTTGTGCTTTGTGTTTGCTTTTGTTTGTCTCGCTCTTCGGGGTGTGGTGGACAAGAGGAAGCGCAAGGCTAAACGAAGGCTGCGAGTCTCGTGCTTGYGGCCGATTTATTCTTTCAAACCCATACATTAAACACTGAACTATACT');
INSERT INTO marker_sequence VALUES(810,'682945315aea1273d9820044fad0a348','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTATCCACGTGAACCGTTAAGCAAACAAGTTAAGGCAGGCGCGATTGATGGTGCGTCTGGGAAGCGCTTGTCGATATTCGATCGGATCGGATATTGTCGGGCGTCGTCCTGGACACGCTGTCGAGCGGAGTCGGCTAAACGAAGGTCGGGCGTTCGCTATCGGAGCGATGTGCGCGTTGTCGCACGTTGCTGCAATGGCTCGAGCAAGCGGCTGATTTATGTCTTTCAAACCATACGTGACGTACTGATGATACT');
INSERT INTO marker_sequence VALUES(811,'46ee07987c9e8fc573d164046a054357','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTATCCACGTGAACCGTTAAGCAAACAAGTTAAGGCAGGCGCGATTGATGGTGCGTCTGGGAAGCGCTTGTCGATATTCGATCGGATCGGATATTGTCGGGCGTCGTCCTGGACACGCTGTCGAGCGGAGTCGGCTAAACGAAGGTCGGGCGTTCGCTATCGGAGCGATGTGCGCGTTGTCGTACGTTGCTGCAATGGCTCGAGCAAGCGGCTGATTTATGTCTTTCAAACCATACGTGACGTACTGATTATACT');
INSERT INTO marker_sequence VALUES(813,'9c2f1edde56784729c4dc4b5911aede6','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGAYGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(814,'4d0da30ebda04ea666337590b5092947','TTTCCGTAGGTGACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGATGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(815,'a0dd28d12079207af470914bdd20abbe','TTCCCGTAGGTGAACCTGCGGAAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGATGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(816,'eae6dea24a07773800450b98a8103a93','TTTCCGTAGGTGACCTGCGGAAGGATCATTACCACACCAAAAAAACTTTCCACGTGAACCGTTCTGTCCGTTTTGTGCCGTTGCTGTTGTCGTCATTCGACGAGAAGAGCAGTGGCTAAACGAAGGCTGTGAGCTTCGTGCTTGCGGTCGATTTATTCTTTCAAACCCCATACGTTAAGAACTGAAGTATACT');
INSERT INTO marker_sequence VALUES(817,'d2d24e0e1c7fafdae5d3eb2583ef061f','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACTGTCGTTATTTGTTGTGTGTGTGCGTGTTGGTAGCATGCGTGTTTGCTTACGCTTTGGTGTTTGCGAGTGTGTGTGTTGTCGGTGCGCAGACTGAACGAAGGTCGTGTGTTGCTGTGTGCCTGCTGCACTGCTGACTTTGCATTGATTTGCATGGTGTTGGCGGAGCGGCGGGTGCTGTTGCGTGCGCGGCTGACCTATTTTTTTCAAACCCCATACCTAAATGACTGATTATACT');
INSERT INTO marker_sequence VALUES(818,'1f70621c04bace5cb297a544538ff94f','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGATTTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(819,'7a72065ca59298892f85d6938bf95ae8','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCAAAAACAACTTTCCACGTGAACTGTCTTACGAGATTCGCGCCGTGACGCGTGTTGGCGCTGTGTGTGTCTGTGTCTTCTTTCGAGAGGATATTGTGATGCAAACAGTGTTGACCGTGTGGGTCGGCTGATCGAAGGTCGCTTTGTGCATTATTGTATGGAGCGGCTGACTTATTCTTTCAAACCCATTACACAATACTACTGATTCATACT');
INSERT INTO marker_sequence VALUES(820,'409d32b05c7e9b12274b6a11d96ce096','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTCAAACCTGTTCTGTGCTTGTGCTGGGTCTGCGTTTTCGGACGCGGACGCGGCAGAGGCTGAACGAAGGCTGGTTTCATTTGTATGAGATCAGCTGATATATTTTTCAAACCCCTTTTACAAAATGACTGATCAATACT');
INSERT INTO marker_sequence VALUES(821,'e68b4635f0c1b073d9473328c6f8bb5f','TTTCCGTAGGTGACCTGCGGAAGGATCATACCACACTTAAAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTGACTGAGCTGGTGTTTTCATTTTTGGACACTGGAACGGGAGTCAGCAGGACGAAGGTTGGTCTGTTGTAATGCAAGTTATGATGGACTAGCTGATGAACTTTTGTTTTTAAACCCTTACCTAAATACTGATTTATACT');
INSERT INTO marker_sequence VALUES(822,'627c51b6fdccf73369ca135679c13b59','GTTCCGTAGGGGACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTCATTATTTGTTGTGCGCTCTCTGCGGTGTCGGTGGCGTCTGTTGGCTGTATTTGATACTGCTGGCGGGTGCGAGCCGGATGCAGAGGCTGAACGAAGGTCGAGTTGCTTTGCTCTCGGCTGACTTATTTTTCAAACCCAATACCCAACTTACTGATTATACT');
INSERT INTO marker_sequence VALUES(823,'0c56dd964c332e2317bc4a553433ff8d','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCAAAAAAACTTTCCACGTGAACCGTTTTGTGCGTTTTGTGCTTGTTGTTTTTCCTTTTCCGCTCTATGAGTGGGGAAGGGAAACTTCAGGCTAAACGAAGGCTGCGAGTTTCGTGCTTGCGGCCGATTTATTCTTTCAAACCCATACATTAAATACTGAACTATACT');
INSERT INTO marker_sequence VALUES(824,'f277e0e265185bff4fc487600a7d5f0d','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCAAAAAAACTTTCCACGTGAACCGTTTTGTGCGTTTTGTGCTTTGTGTTTGCTTTTGTTTGTCTCGCTCTTCGGGGTGTGGTGGACAAGAGGAAGCGCAAGGCTAAACGAAGGCTGCGAGTCTCGTGCTTGCGGCCGATTTATTCTTTCAAACCCATACATTAAACACTGAACTATACT');
INSERT INTO marker_sequence VALUES(825,'00dc1aa4d1abca57c324cabf8ae32248','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTCGTTATTTGTTGTGTGTCTGCGCGTTGTTGGCGTGCGTTTGCTTACGCTTCGGTGTTTGCGAGTGCGTGCTGGCGGTGCGCGGACTGAACGAAGGTCGTGTTGCTGTGTGCCTGCTGCACTGCTGACTTTGCATTGATTTGCATGGTCTTGGCGGAGCGGCGGGTGCTGTGCGTGCGCGGCTGACTTACTTTTTCAAACCCCATACCTAACTTACTGATTATACT');
INSERT INTO marker_sequence VALUES(826,'f800318c9940773c0dbbb440a8f4af6c','GTTCCGTAGGGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACTGTCGTTATTTGTTGTGTGTGTGCGTGTTGGTAGCATGCGTGTTTGCTTACGCTTTGGTGTTTGCGAGTGTGTGTGTTGTCGGTGCGCAGACTGAACGAAGGTCGTGTGTTGCTGTGTGCCTGCTGCACTGCTGACTTTGCATTGATTTGCATGGTGTTGGCGGAGCGGCGGGTGCTGTTGCATGCGCGGCTGACCTATTTTTTTCAAACCCCATACCTAAATGACTGATTATACT');
INSERT INTO marker_sequence VALUES(827,'040c04bdc5e4a6b01a03c31e29c893e5','GTTCCGTAGGGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTATCCACGTGAACCGTTAAGCAAACAAGTTAAGGCAGGCGCGATTGATGGTGCGTCTGGGAAGCGCTTGTCGATATTCGATCGGATCGGATATTGTCGGGCGTCGTCCTGGACACGCTGTCGAGCGGAGTCGGCTAAACGAAGGTCGGGCGTTCGCTATCGGAGCGATGTGCGCGTTGTCGCACGTTGCTGCAATGGCTCGAGCAAGCGGCTGATTTATGTCTTTCAAACCATACGTGACGTACTGATGATACT');
INSERT INTO marker_sequence VALUES(828,'f011e114f1a573e19e5c5c564aa0b50e','GTTCCGTAGGTGACCCTGGGGAAGGATCATTACGCACCTAAAAAACTATCCACGTGAACCGTTAAGCAAACAAGTTAAGGCAGGCGCGATTGATGGTGCGTCTGGGAAGCGCTTGTCGATATTCGATCGGATCGGATATTGTCGGGCGTCGTCCTGGACACGCTGTCGAGCGGAGTCGGCTAAACGAAGGTCGGGCGTTCGCTATCGGAGCGATGTGCGCGTTGTCGCACGTTGCTGCAATGGCTCGAGCAAGCGGCTGATTTATGTCTTTCAAACCATACGTGACGTACTGATGATACT');
INSERT INTO marker_sequence VALUES(829,'fc4c11f8cfbe9e472f8c79ddc9eb0b98','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCNCACCTAAAAAACTTTCCACGTGAACTGTCGTTATTTGTTGTGTGTGTGCGCGTTGCTGGCGTGCGTTTGCTTACGCTTGTGTGTTTGCGAGTGCGTGGTGGCGGTGCGCGGACTGAACGAAGGTCGTGTTGCGTGTGTGTGCCTGCTGCACTGCTGACTTTGCATTCATTTGCATGGTGTTGGCGGAGCGTTGGGTGCTGTGCGTGCGCGGCTGACTTATTTTTTCAAACCCCATACCTAAATGACTGATTATACT');
INSERT INTO marker_sequence VALUES(830,'9316bd3be088afa9a6daf8d68efa39c2','TTCCGTAGGTGACCTGCGGAAGGATCATTACCACACCTAAAAAACTATCCACGTGAACCGTTAAGCAAACAAGTTAAGGCAGGCGCGATTGGTGGTGCGTCTGGGAAGCGCTTGTCGATATTCGATCGGATCGGATATTGTCGGGCGTCGTCCTGGACACGCTGTCGATCGGAGTCGGCTAAACGAAGGTCGGGCGTTCGCTATCGGAGCGATGTGCGCGTTGTCGCACGTTGCTGCAATGGCTCGAGCAAGCGGCTGATTTATGTCTTTCAAACCATACGTGACGTACTGATTATACT');
INSERT INTO marker_sequence VALUES(831,'5d3e78d071579e833c8d29c8d957bb73','TTTCCGTAGGGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTATCCACGTGAACCGTTAAGCAAACAAGTTAAGGCAGGCGCGATTGATGGTGCGTCTGGGAAGCGCTTGTCGATATTCGATCGGATCGGATATTGTCGGGCGTCGTCCTGGACACGCTGTCGAGCGGAGTCGGCTAAACGAAGGTCGGGCGTTCGCTATCGGAGCGATGTGCGCGTTGTCGCACGTTGCTGCAATGGCTCGAGCAAGCGGCTGATTTATGTCTTTCAAACCATACGTGACGTACTGATGATACT');
INSERT INTO marker_sequence VALUES(832,'b5df3b629899a8b5dd75c53035e6c2ee','TTCCGTAGGTGACCTGCGGAAGGATCATTACACACCTAAAACCTTTCCACGTGAACTGTCAAACCTGTTCTGTGCTTGTGCTGGGTCTGCGTTTTCGGACGCGGACGCGGCGGAGGCTGAACGAAGGCTGGTTTCATTTGTATGAGATCAGCTGATATATTTTTTCAAACCCCTTTTTTACAAAATGACTGATCAATACT');
INSERT INTO marker_sequence VALUES(833,'9581595ab3cec2ddf48310abea2f45a8','TTTCTGTAGTGAACCTGCGGAAGGATCATTACCACACTTTAAAAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTCACTGAGCTGGTGTTTTCCAATATATATATATTGGACACTGGAACGGGAGTCAGCAGGACGAAGGTTGGTCTCTTGTAATGCAAGTTATGAGAGACTAGCTGATGAACTTTTCTTTTTAAACCCTTCTTACCTAAATATACTGATTTATACT');
INSERT INTO marker_sequence VALUES(834,'aaecee014eb7f226923987b1bc651fd0','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCAAAAAAACTTTCCACGTGAACCGTTCTGTCCGTTTTGTGCCGTTGCTGTTGTCTCGATTCGTCGAGAAGAGCAGTGGCTAAACGAAGGCTGTGAGCTTCGTGCTTGCGGTCGATTTATTCTTTCAAACCCCATACGTTAAGAACTGAAGTATACT');
INSERT INTO marker_sequence VALUES(835,'cc07315edaa190f7d765ee8d8596146d','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCAAAAAAACTTTCCACGTGAACCGTTTTGTACGTTTTGTGCTTTTTGTTTTGTCTCTTCTGCTCTCGCGAGTGGAAAAGGCGGAACACTAGGCTAAACGAAGGCTGCGAGTTTCGTGCTTGCGGCCGATTTATTCTTTCAAACCCATACATTAAACACTGAACTATACT');
INSERT INTO marker_sequence VALUES(836,'189043118780da31e3fdc539b495f0d9','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCAAAAAAACTTTCCACGTGAACCGTTTTGTGCGTTTTGTGCTTGTTGTTTTTCCTTTTCCGCTCTATGAGTGGGGAAGGGAAACTTCAGGCTAAACGAAGGCTGCGAGTTTCGTGCTTGCGGCCGATTTATTCTTTCAAACCCATACATTAAATACTGAACTATACT');
INSERT INTO marker_sequence VALUES(837,'543fa19c52a1de484838806dd690b13b','GTTCCGTAGGGGACCTGCGGAAGGATCATTACCACACCAAAAAAACTTTCCACGTGAACCGTTTTGTGCGTTTTGTGCTTGTTGTTTTTTTCGATCTGCTGCTCTGTGGAGTGTGTGGGGAAGAAAAAGCTCCAGGCTAAACGAAGGCTGCGAGTTTCGAGTTTCGTGCTTGCGGCCGATTTATTCTTTCAAACCCATACATTAAATACTGAAGTATACT');
INSERT INTO marker_sequence VALUES(838,'7a23ef79729b4524b46d4afe781886b2','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCAAAAAAACTTTCCACGTGAACCGTTCTGTCCGTTTTGTGCCGCTGCTGTTGTCGCGATTCGTCGAGAAGAGCAGTGGCTAAACGAAGGCTGTGAGCTTCGTGCTTGCGGTCGATTTATTCTTTCAAACCCCATACGTTAAGAACTGAAGTATACT');
INSERT INTO marker_sequence VALUES(839,'d698920a99dd29255e557a49ee0f7c97','TTTCCGTAGGTGAACCTGCGGGAAGGATCATTWCCACACCTTAAAAAACTTTCCACGTGAACTGTCGTTATTTGTTGTGTGTGTGCGCGTTGCTGGCGTGCGTTTGCTTACGCTTGTGTGTTTGCGAGTGCGTGGTGGCGGTGCGCGGACTGAACGAAGGTCGTGTTGCGTGTGTGTGCCTGCTGCACTGCTGACTTTGCATTCATTTGCATGGTGTTGGCGGAGCGTTGGGTGCTGTGCGTGCGCGGCTGACTTATTTTTTCAAACCCCATACCTAAATGACTGATTATACT');
INSERT INTO marker_sequence VALUES(840,'7eefbcf39b2ab7a30e32cddaab727ca3','TTTCCGTAGGTGAACCTGCGGAAGGATCATTCCCACCCCAAAAAAACTTTCCACGTGAACCGTTTTGTGCGTTTTGTGCTTGTTGTTTTCGATCTGCTCTGTGCCTTCGGGTGTGGAGTAGAGAAGAAAACTCTAGGCTAAACGAAGGCTGCGAGTTTCGTGCTTGCGGCCGATTTATTCTTTCAAACCCATACATTAAACACTGAACTATACT');
INSERT INTO marker_sequence VALUES(841,'f62b8783d6c5b712d53526f064bcd3f2','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCAAAAAAACTTTCCACGTGAACCGTTTTGTGCGTTTTGTGCTTGTTGTTTTTTTCGATCTGCTGCTCTGTGGAGTGTGTGGGGAAGAAAAAGCTCCAGGCTAAACGAAGGCTGCGAGTTTCGAGTTTCGTGCTTGCGGCCGATTTATTCTTTCAAACCCATACATTAAATACTGAAGTATACT');
INSERT INTO marker_sequence VALUES(842,'273c71b0efa1e874b7bad4ac79fb7b33','TTTCCGTAGGTGACCTGCGGAAGGATCATTACCACACCTAAAAAACTATCCACGTGAACCGTTAAGCAAACAAGTTAAGGCAGGCGCGATTGATGGTGCGTCTGGGAAGCGCTTGTCGATATTCGATCGGATCGGATATTGTCGGGCGTCGTCCTGGACACGCTGTCGAGCGGAGTCGGCTAAACGAAGGTCGGGCGTTCGCTATCGGAGCGATGTGCGCGTTGTCGCACGTTGCTGCAATGGCTCGAGCAAGCGGCTGATTTATGTCTTTCAAACCATACGTGACGTACTGATGATACT');
INSERT INTO marker_sequence VALUES(843,'aeb9e8c96d896eb7ee8f99d3aa1dffaf','GTTCCGTAGTGAACCTGCGGAAGGATCATTACCACACCTTAAAACTATCCACGTGAACCGTTTGTACCCAGATTTGCGCCGAGATTTTCGTGCGTGTTTGTTTGTATCACTGTGTATTCGTACGCGGTGTGTGGCAAATATGTATGGAGCTTGGCTGATCGAAGGTCGTATCGCACTTTATTGTGTGTGTCGGCTGACTTATTTTTCAAACCCATTACTTACTACTGATTATACT');
INSERT INTO marker_sequence VALUES(844,'f0d9e85de0a95d78d95101d5cc34d2bc','TCCGTAGGTGAACTGCGGAAGGATCATTACCACACATAAAAAACTTTCCACGTGAACCGTTCAACCTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(845,'c463e83cbb905c559953373792833568','TCTGTAGGTGAACTTGCGGAAGGATCATTACCACACTAAAAAACTTTCCACGTGAACCGTCAACCTTTTAGTTGGGGACTCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGCGACCTATCAAAACGAGTGATTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(846,'af3944ea025d1ccef7f0deb2a114aa99','TCCGTAGGTGAACTGCGGAAGGATCATTACCACACTAAAAAACTTTCCACGTGAACCGTTCAACCTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGAGACTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(847,'a3972477d15e25491b11e43c43d8283f','GTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCAGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAACTAGTAGCTATCAATTTTAAACCCTTTCTTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(848,'f1fc55f645711984d42f617ab252efae','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGTCTTTCTGGCCCCATCAAACGAGGCGCTGGGCTGCAAAGTCTGGCGTAGTAGTTACTTTTTGTAAACCCCTTTACCTTATTTTCTGATCATACT');
INSERT INTO marker_sequence VALUES(849,'40e926b6c9ea5525a32c6efbe30c6106','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAATCTTTCCACGTGAACCGTATCAACCCCCTTCGTTGGGGGCCTGCTCTGGGCGGCGGCTGYCGATGTCAAAGTCGGCGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCCCTATTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(850,'04ddd78c93386cedb4a98975303900a8','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTGCTGAGCCCCGCCCTATCATGGCGAATGTTTGGACTTCGGTTTGGGCTAGTAGCTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(851,'2d0e59f05bef25b99c92e9fa2f09d3c8','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACRTGAACTGTCTGTGATGTTGGGGGCGTGTCGTTCGCGGCGGCTCCATCAAACGAGGCTCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTTACCACTTTTTCTGATCATACT');
INSERT INTO marker_sequence VALUES(852,'f2a1e9ab5665bccde391c3a0d1ae5da3','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCGTGTCGTTCGCGGCGGCTCCATCAAACGAGGCCYTGGGCTGAAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTTACCACTTTTTCTGATGATACT');
INSERT INTO marker_sequence VALUES(853,'15927be11bf5d2b928f47eacd21e1d38','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCGTGYCGTTCGCGGCGGCTCCATCAAACGAGGCTCTGGGCTGMAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTTACCACWTTTTCTGATCATACT');
INSERT INTO marker_sequence VALUES(854,'4feadbd894c41df2a833c5e6153a80e0','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCGTGYCGTTCGCGGCGGCTCCATCAAACGAGGCTCTGGGCTGAAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTTACCACWTTTTCTGATCATACT');
INSERT INTO marker_sequence VALUES(855,'f48bc49814ae12e123f753614710847b','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTCAAACCTGTTCTGTGCTTGTGCTGGGTCTGCGTTTTCGGACGCGGACACGGTGGAGGCTGAACGAAGGTTGGTTTTCTTCTTGTGAGAGACCAGCTGATATATTTTTCAAACCCCTTTTTACAAAATGACTGATCAATACT');
INSERT INTO marker_sequence VALUES(856,'6442a7ff073b0b1119dd00f7c6639830','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCAAAAACAACTTTCCACGTGAACTGTCTTACGAGATTCGCGCCGTGACGCGTGTTGACGCTGTGTGTGTCTGTGTCTTCTTTCGAGAGGATATTGTGATGCAAACAGTGTTGACCGTGTGGGTCGGCTGATCGAAGGTCGCTTTGTGCATTATTGTATGGAGCGGCTGACTTATTCTTTCAAACCCATTACACAATACTACTGATTCATACT');
INSERT INTO marker_sequence VALUES(857,'eda164d73eb8b0cb77ea1d4724a001c5','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTTAAAACTATCCACGTGAACCGTTTGTACCAAGATTTGCGCCGAGATGTTTGTGCGTGTTTGTTGTATCACTGTGTATTCGTACGCGGTGTGTGGCAAGTATGTATGACGCTTGGCTGATCGAAGGTCGTCTTGCACTTGATTGTGTGTGTCGGCTGACTTATTTTTCAAACCCATTCTGAACTACTGATTATACT');
INSERT INTO marker_sequence VALUES(858,'14ac885a391c69c8ea23dd50558e1452','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCTATAAATTGGGGGTTCAACTGGCGGTTGCTGCTGGCATCTTTTTGCTGGCTGGCGACTGCTGAGCGAACCCTATCATGGCGAGCGTTCTGACCTCGGTTGGAGCTAGTAGCGTAATTTTAAACCCATTCTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(859,'fd70f49d31675550292ff31d4fb86e8e','GTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACACCCTTCCACGTGAACCGTTTTGTTTTGCTTTCGAGTGCTTTGTTGTGCTCGGAGCATGTTTGGGCTTCGCTGCTGGCGCTTGATTGTGCTGGCGGCTCGAGGCCATCAAGCGGCGTTTTGAGTGTGTGTTCGCATACAATTGAAACGTCCAAACCTTTTAAACCCATTTGATTGAAAACTGAAGTATACT');
INSERT INTO marker_sequence VALUES(860,'4017e66726ea356327c2cf644157cce9','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATAATTTGGGGGTTTAATTGGCGGCGGCTGCTGGCATTTTTTTGCTGGCTGGCTACTGCTGAGTGAACCCTATCATAGTGAGTGTTCTGACTTCGGTTGGAACTAGTAGCTTGAATTACAAACCCTTTCTTAAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(861,'26042e9a0f45680600df3e1c24b1ce6a','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACCCCTAAAAAACTTTCCACGTGAACCGTATTAACAATTATAATTGGGGGTGATCTTAATGGAGGCTACTAGTCATTTTGGCTGGAGGCTACTATCGAGTGAACCTTATCATGGCGAAAAACTAGACTTTTGTTTGGTGAAGTAGTGAAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(862,'ec26f65db22489f065c223b40da47ee4','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGATGGTTAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(863,'4a500d7e340d924c77b9d6d14e202201','TTTTCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTCGTTATTTGTTGTGTGTCTGCGCGTTGCTGGCGTGCGTTTGCTTACGCTTCGGTGTTTGCGAGTGCGTGCTGGCGGTGCGCGGACTGAACGAAGGTCGTGTTGCTGTGTGCCTGCTGCACTGCTGACTTTGCATTGATTTGCATGGTCTTGGCGGAGCGGCGGGTGCTGTGCGTGCGCGGCTGACTTACTTTTTCAAACCCCATACCTAACTTACTGATTATACT');
INSERT INTO marker_sequence VALUES(864,'58ea7acfc1819a6abbd9a925cbe39c8a','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACTGTCGTTATTTGTTGTGTGTGTGCGTGTTGGTAGCATGCGTGTTTGCTTACGCTTTGGTGTTTGCGAGTGCGCGTACTGTCGGTGCGCAGACTGAACGAAGGTCGTGTGTTGCTGTGTGCCTGCTGCACTGCTGACTTTGCATTGATTTGCATGGTGTTGGCGGAGCGGCGGGTGCTGTTGCGTGCGCGGCTGACCTATTTTTTTCAAACCCCATACCTAAATGACTGATTATACT');
INSERT INTO marker_sequence VALUES(865,'f682426d5ab0bd6d2e4a30f6371241f5','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTCAGTTGGGGGCCTTGCTTTTTTGCGAGCCCTATCATGGCGAAAGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(866,'067873f405031fb02ef22de6dcbf7268','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAAAGCTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO marker_sequence VALUES(867,'799d06c2b59dbf0405c17123461e1708','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTCCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO marker_sequence VALUES(868,'1c0bb5900f0f781b7f0d11c9e023ca76','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGATTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO marker_sequence VALUES(869,'0c2a9a39e4b55df4eaee64d472722561','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGATTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGACTATACT');
INSERT INTO marker_sequence VALUES(870,'c00ce2ac2d2350a8f2eb0a4552d8fbed','TCCGTAGGGTGACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTATCGAACAACTAGTTGGGGGTCTTGTTTGGCGTGCGGCTGCTTCGGTAGCTGCTGCTAGGCGAGCCCTATCACGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTATTTTTTAAACCCATTCTTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(871,'544dff009d0c4ced40236a568c1ed797','TCCGTAGGGTGACCTGCGGAAGGATCATTAGCACACCTAAAAAACTTTCCACGTGAACTGTATCGAACAACTAGTTGGGGGTCTTGTTTGGCGTGCGGCTGCTTCGGTAGCTGCTGCTAGGCGAGCCCTATCACGGCGAGCATTTGGACTTCGGTCTGAGCTAGTAGCTATTTTTTAAACCCATTCTTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(872,'386e52576114e6d3ab6c5be08cc6a1f9','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCGTTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO marker_sequence VALUES(873,'febd734fc3b85fbff00f43d5757b361c','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO marker_sequence VALUES(874,'82cc390a45f370d78f394e89c7b55a1e','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTTTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO marker_sequence VALUES(875,'efa970ca86218d7ec99368d8238ce0f5','TCCGTAGGTGAACCTGCGGAAGGATCATTACTACACCTAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTTGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO marker_sequence VALUES(876,'c64c385a133edec9708c554a81cf6869','TTTCCGTAGGTGACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO marker_sequence VALUES(877,'b686924690b255add8895dc13c8adea2','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO marker_sequence VALUES(878,'fc815de9ce3c10f1f53fe80ad52b3b02','GTTCCGTAGGTGAACTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO marker_sequence VALUES(879,'8d9848b2b8eb124e9fdf9a0b2f526bad','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAATCTTTCCACGTGAATTGTTTTGTACACTGTTGGGTTTCGCTGGCGCGTGTTTTCTTGTCGAATGTAGTGTTTGACGGCGCGCGGCGGCTGGAGGCCATCAGGGCGTCTGTTGTTGTGATGGACGCTCTTTTTGTAAACCCCCTTTTTTTTTATTTTGTGAAACTGATTGTACT');
INSERT INTO marker_sequence VALUES(880,'19a9ea4424345a1a773d872c4d64d1df','GTTCGTAGGTGAACCTGCGGAAGGATCATTACCACACTTTAAAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTGACTGAGCCGGTGTTTTCATTTTTGGACACTGGAGCGGGAGTCAGCAGGACGAAGGTTGGTCTCTCGTAATGCAAGTTATGGGGGACTAGCTGATGAACTTTTCTTTTTAAACCCTTACCTAAATACTGATTTATACT');
INSERT INTO marker_sequence VALUES(881,'2d29bc7fbc54630aa976305122b1af18','TTTCGTAGGTGACCTGCGGAAGGATCATTACCACACCAAAATACTTTCCACGTGAACTGTCTTACGAGATTCGCGCCGTGACGTGTGTTGTCGCTGCGTGCGCTGTATTTATATAGTGCGCATAGCGTCGACTGCGTGGGTCGGCTGATCGAAGGTCGCATTGTGCTGTATTGCGCATTGTGGCTGACTTATTCTTTCAAACCCATTTCTTTATTACTGATTCATACT');
INSERT INTO marker_sequence VALUES(882,'8b9579cd06184bcc5de64d8a89e95fa9','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTCTTACTTAGTTTTGCGTTGCTGCAGGATGTTCTATGCACTTCTTGTGTAGAGAGTATTCTGCGACTGCTGAACGAAGGTTGGTGAAGTCTTGTCTCTGCGTGCTTGATTGCATGCGGGACGTGTACGTCGCCGGCTGACTTATTTTTTCAACCCATTACTTTAACAACTGAACTATACT');
INSERT INTO marker_sequence VALUES(883,'7e7f0f5beadfcc761ac48767cb67c7fd','TTTCCTAGGTGAACCTGCGGAAGGATCATCATTACCACTAAAAACTTTCCACGTGAACTGTCTTACTTAGTTTTGCGTTGCTGCAGGATGTTCTATGCACTTCTTGTGTAGAGAGTATTCTGCGACTGCTGAACGAAGGTTGGTGAAGTCTTGTCTCTGCGTGCTTGATTGCATGCGGGACGTGTACGTCGCCGGCTGACTTATTTTTTCAACCCATTACTTTAACAACTGAACTATACT');
INSERT INTO marker_sequence VALUES(884,'2f53620cbd8a061b872a2ded21abc58d','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTCTTACTTAGTTTTGCGTTGCTGCAGGATGTTCTCTTTTTGTGTAGAGAGTATTCTGCGACGGCTGAACGAAGGTTGGTGAAGTCTTGTCTCTGCGTGCTTGATTGCATGCGGGACGTGTACGTCGCCGGCTGACTTATTTTTTCAACCCATTACTTTAACAACTGAACTATACT');
INSERT INTO marker_sequence VALUES(885,'6eb8fdd940fabdee7d396b2cd14010fa','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCATTTTGCTGAGTCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCATTTAACAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(886,'8138cb7c9253a3b7582c415e7e174d47','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTCTAAATATGTTCTGTGCTTCGTCAGTGTGTGCTGCTATCCTTTGGAAAGTGGCGTAACATTGGCTTGAGGCTGAACGAAGGTTGGCTAAGTACTCGTGTAGCTCTCGGGCTGTGCGGTGGAACGGCTTACCGATGTCTTTTTCAAACCCATTAACTAAACACTGATCCTTACT');
INSERT INTO marker_sequence VALUES(887,'26942704852aedbfdb904a4531d760b6','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACTTTAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTGACTGATCTGGTGTTTTCGGATACTGGATCGGGAGTCAGCAGGACGAAGGTTGGTCTCGTAATGTAAATTATGGGACTAGCTGATGCATTCCTTTTTTCAAACCCTTACGTAAATACTGATTTATACT');
INSERT INTO marker_sequence VALUES(888,'173aa035e6c28d1fde1c85af45501ab3','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACACCCTTCCACGTGAACCGTTTTGTTTTGCTTTCGAGTGCTTTGTTGCGCTTCGGAGCATGTTTTGGGCTTCGCTGCTGGCCGCTTGATTGTGCTGGCGGCTCGAGGCCATCAAGTGGCGTTTTGAGTGTGCTTTGCGCAATTGAAACGTCGAAACCTTTTTTTTTAAACCCATTGATTGAAAACTGAAGTATACT');
INSERT INTO marker_sequence VALUES(889,'61a71516c07a88adbd01d6b24a48d757','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACACCCTTTCCACGTGAACCGTTTTGTTTTGCTTTCGAGTGCTTTGTTGCGCTCGGAGCATGTTTTGGGCTTCGCTGCTGGCGCTTGATTGTGCTGGCGGCTCGAGGCCCATCAAGTGGCGGTTTTGAGTGTGCTTTGCGCAATTGAAACGTCGAAACCTTTTTTTTAAACCCATTTGATTGAAAACTGAAGTATACT');
INSERT INTO marker_sequence VALUES(890,'df6d56bdd6f2784030d01bed0a88fe34','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACACCCTTCCACGTGAACCGTTTTGTTTTGCTTTCGAGTGCTTTGTTGCGCTCGGAGCATGTTTTGGGCTTCGCTGCTGGCGCTTGATTGTGCTGGCGGCTCGAGGCCATCAAGTGGCGTTTTGAGTGTGCTTTGCGCAATTGAAACGTCGAAACCTTTTTTTAAACCCATTTGATTGAAAACTGAAGTATACT');
INSERT INTO marker_sequence VALUES(891,'69b265f098a415aa50ebe69d188f2d23','TTGCCTGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACACCCTTCCACGTGAACCGTTTTGTTTTGCTTTCGAGTGCTTTGTTGCGCTCGGAGCATGTTTTGGGCTTCGCTGCTGGCGCTTGATTGTGCTGGCGGCTCGAGGCCATCAAGTGGCGTTTTGAGTGTGCTTTGCGCAATTGAAACGTCGAAACCTTTTTTTTAAACCCATTTGATTGAAAACTGAAGTATACT');
INSERT INTO marker_sequence VALUES(892,'4fcd2f5b91461b1ea2b4c34355441bbb','TTTCCGTAGGTGGTACTGCGGAAGGATCATTACCACACTTTAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTGACTGATCTGGTGTTTTCGGATACTGGATCGGGAGTCAGCAGGACGAAGGTTGGTCTCGTAATGTAAATTATGGGACTAGCTGATGCATTCCTTTTTCCAACCCCTTACTTAAATCCGGATGTATCCG');
INSERT INTO marker_sequence VALUES(893,'c1ec7aff4f681f020efa30a36bc64541','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACACCCTTCCACGTGAACCGTTTTGTTTTGCTTTCGAGTGCTTTGTTGCGCTCGGAGCATGTTTTGGGCTTCGCTGCTGGCGCTTGATTGTGCTGGCGGCTCGAGGCCATCAAGTGGCGTTTTGAGTGTGCTTTGCGCAATTGAAACGTCGAAACCTTTTTTTTAAACCCATTTGATTGAAAACTGAAGTATANN');
INSERT INTO marker_sequence VALUES(894,'d0a47c0e51dc76e31f22f2785fed12fe','TTTCCGGTAGGTGACCTTGCGGAAGGATCATTACCACACCTAAAAAACACCCTTCCACGTGAACCGTTTTGTTTTGCTTTCGAGTGCTTTGTTGCGCTCGGAGCATGTTTTGGGCTTCGCTGCTGGCGCTTGATTGTGCTGGCGGCTCGAGGCCATCAAGTGGCGTTTTGAGTGTGCTTTGCGCAATTGAAACGTCGAAACCTTTTTTTAAACCCATTTGATTGAAAACTGAAGTATACT');
INSERT INTO marker_sequence VALUES(895,'7eda94ec340340a29660aa989677eaff','CTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCCTTCCTTAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(896,'c63e8f1a85bc910ee0ee9fedab5c0f06','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTTTGATTATACT');
INSERT INTO marker_sequence VALUES(897,'3be3fe92bb13d7bdaf90a07e6993e1b7','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCCCACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGACTTAATTGCTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(898,'37073c649a9b254a127ccbf4d6142b10','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGACTTAATTGCTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(899,'0372499603839e39e1ddbd5d90182be9','ATCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO marker_sequence VALUES(900,'1d6f74a0d9f439dbc67626e473dbd754','GTTCCGTAGGTGAGACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO marker_sequence VALUES(901,'edb8670563451a6a154d5438d9e90e12','ATCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO marker_sequence VALUES(902,'360278fe99c1e78da46843292a75393e','AATCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO marker_sequence VALUES(903,'0103977ae3e3533fef87584d57cd9d95','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCGTGTCGTTCGCGGCGGCTCCATCAAACGAGGCTCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTTACCACTTTTTCTGATGATACT');
INSERT INTO marker_sequence VALUES(904,'28c0fccc653470c8a3102071658fd2ad','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCCTGCCGTTCGCGGCGGCTCCATCAAACGAGGCTCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCATTCCAATATTTTCTGATGATACT');
INSERT INTO marker_sequence VALUES(905,'9e1d3498e37fd7ba98a1f01230ff0194','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGGACTGTCTGTGATGTTGGGGGCCTGCCGTTCGCGGCGGCTCCATCAAACGAGGCTCTGGGCTGCAAAGTCGAGAGTAGTAGTTACTTTTTGTAAACCCATTCCAATATTTTCTGATGATACT');
INSERT INTO marker_sequence VALUES(906,'1887ada0e8c19ad524b8a4fdb9aafa19','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTGTTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(907,'99013ce0fe7a9115a0c9af86d9d7c052','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(908,'5f5878afffea8638cc2aacc28f949dcb','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCCTTCTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(909,'cfde732a2e3e43a9d7e59a44d914e4e2','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCACCTAGTTGGGGTTCTCGGTAGCTGTGTGGCATGTGGACTCGTTCTACGTGCTGCTGGCGGCTGAGACCTATCATGGCGAGCGTTTGGGCTTTCGGGCCTGGATTAGTAGCCCTCTTTTAAACTCATTCTGTAAAACTGATTATACT');
INSERT INTO marker_sequence VALUES(910,'8c6ab9e16d51ecb45144aea499b096c0','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTATCAACCCAATAAATTGGGGGTTTAATTGGCGGTGGCTGCTGGCATCTTTTTGTTGGCGGCTGTTGCTGAGCAAGCCCTATCATGGCGAACGTTTGGACCTCGGTCTGAACTAGTAGCTTTTATTTTAAACCCTTTCTTAATTACTGAATATACT');
INSERT INTO marker_sequence VALUES(911,'c66a0ace8143902f39061e53dbd71c14','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAACAACTTTCCACGTGAACCGTATCAACCCTATGTCTTGGGGGTTTGTTTCATGACCGCTGTTGGCATGTTTTGCTTGATGGCTACTATGGAACGAGCCCTATCGTGCGTGTTTGGACCTTGGTCTAAACAAGTAGCATTAATATTATAAACCCTTTCTTAAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(912,'45eda0a18d2010bdd33fba26a3011e61','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAACAACTTTCCACGTGAACCGTATCAACCCTATATCTTGGGGGTTTGTTTCATGACCGCTGTTGGCATCTTTTTGCTTGATGGCTACTATGGAACGAGCCCTATCGTGCGTGTTTCGACCTTGGTCTGAACAAGTAGCATTAACATTATAAACCCTTTCTTAAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(913,'c04c1213903ccdf691a81064a0cdf8e4','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCAAATAGTTGGGGATGAGTTAGGTGGCAGCTGCTGACTTTAATGTTGGCGGTAGCCGCTAGACGAGTCCTATCATAGTGAAGTGGTTTGGACATTATAGTCCGAGCTAGTAGCTATTTTTAAACCATTACTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(914,'7aae9031be0b11a9b65e5eaf6d3e1c6d','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCAAATAGTTGGGGATGAGTTAGGTGGCAGCTGCTGACTTTAATGTTGGCGGTAGCCGCTAGACGAGTCCTATCATAGTGAAGTGGTTTGGACATTATAGTCCGAGCTAGTAGCTATTTTTAAACCATTACTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(915,'3eebed5a2713b4857c48939e5b8df627','TTTCCGTAGGTGAACTTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCAAATAGTTGGGGATGAGTTAGGTGGCAGCTGCTGACTTTAATGTTGGCGGTAGCCGCTAGACGAGTCCTATCATAGTGAAGTGGTTTGGACATTATAGTCCGAGCTAGTAGCTATTTTTAAACCATTACTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(916,'87bde5e81c6774b3b95fb5c9f21b2fe4','TTTCCGTAGGTGAACCTGCGGAAGGATCWTTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCAAATAGTTGGGGATGAGTTAGGTGGCAGCTGCTGACTTTAATGTTGGCGGTAGCCGCTAGACGAGTCCTATCATAGTGAAGTGGTTTGGACATTATAGTCCGAGCTAGTAGCTATTTTTAAACCCTTACTTAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(917,'4d65be9a82ff26f5b0dcbfe7e7b40a6d','TTTCCGTAGGTGAACCTGCGCAAGGATCATTACCACACCTAAAACACCTGTCCACGTGAACCGTTTGTGAAGCAGTTGGGTCGGTTGTCGTTTCGCGACTGCCTGGCCATCAAGGAGTAGTGTGTTTGCGCACATCTCTCCTTCGCTTTAAACCCATTTCAATTGAAACTGATTATACT');
INSERT INTO marker_sequence VALUES(918,'64f040ddd9dae79f1c2a51b4fa8d372c','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAATTCCACGTGAACCGTATCAAATTTTTAAGTTGGGGGTCTTGTTTGGCGTGCGACTGCTTCGGTAGTTGCTGCTGGGCAAGCCCTATCGCGAACCGTTTGGACTTCGGTCTGAGCTAGTAGCTAAATTTTTTAAACCCATTAATTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(919,'294b8b10a14322f4dd2a6c23691b0029','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGTTTCATTGGCGGCTGCTACTGGCATCTTTTTGCTGGCTGGCTACTGCTGAGCAAACCCTATCGTGAGCGTTCTGACCTCGGTTGGAGCTAGTAGCTTGAATTTTTAACCCATTCTTACATACTGAAATTACT');
INSERT INTO marker_sequence VALUES(920,'14f347f90d6e0ff135b1199dc40e6c1f','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATAATTTGGGGGTTAATTTGGTAATGGCTGCTGGCATCTTTTTGTTGGCTGGCTGTTACTGAGTAAGCCCTATCATGGYGAGAGTTTGGACCTTTGTCTGAACAAGTAGCTACGATTGTAAACCCTTTCTTAATTACTGAATATACT');
INSERT INTO marker_sequence VALUES(921,'bcbf4050502686d899a7657da436f52f','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACTGTCGTTATTTGTTGTGTGTGTGCGCGTTGGTAGCATGCGCGTTTGCTTACGCTTCGGTGTTTGCGAGTGCGCGTGCTGGCGGTGCGCAGACTGAACGAAGGTCGTGTGTTTGCTGTGTGCCTGCTGCACCGCTGACTTTTGCATTGATTTGCATGATGTTGGCGGAGCGGCGGGTGCTGTGCGTGCGCGCGGCTGACCTATTTTTTTCAAACCCCATACCTAAATGACTGATTATACT');
INSERT INTO marker_sequence VALUES(922,'dd8d1ab6129ea9ab0e9121309218a6c6','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(923,'f64d6bbb45ff34d9fd5f42693be578fe','GTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGCTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCATATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO marker_sequence VALUES(924,'b0cba5c7c9be149d6636417e2e4af16f','GTTCCGTAGGTGAACTGCGGAAGGATCATTACCACACCAAAAAAACTTTCCACGTGAACCGTTTTGTGCGTTTTGTGCCTTTTGTTTTCCGATCTGCTCTGTGGAGCGGGGAAGAAAACTCGAGGCTGAACGAAGGCTGCGAGTCTCGTGCTTGCGGCCGATTTATTCTTTCAAACCCATACATTAAATACTGAACTATACT');
INSERT INTO marker_sequence VALUES(925,'7bd8342e31a9c4ea6548433be8b8e4e1','GTTCGTAGGTGAACTGCGGAAGGATCATTACCACACCTAAAAAACTATCCACGTGAACCGTAAGCAAACAAGTTAAGGCAGGCGCGATTGGTGGTGCGTCTGGGAAGCGCTGTCGATATTCGATCGGATCGGATATTGTCGGGCGTCGTCCTGGACACGCTGTCGATCGGAGTCGGCTAAACGAAGGTCGGGCGTTCGCTATCGGAGCGATGTGCGCGTTGTCGCACGTTGCTGCAATGGCTCGAGCAAGCGGCTGATTTATGTCTTTCAAACCATACGTGACGTACTGATTATACT');
INSERT INTO marker_sequence VALUES(926,'7cdc9f2ee5c786329e4364cf3659c82a','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(927,'787fc8e8e605798b17d7d8209533828f','GTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTGCTTGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(928,'b8e8b744951d6256ae03b8c2095fe76c','GTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(929,'214c78f65764a863dad8cc5f44119ed0','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTGCTTGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(930,'87c49e58b385e5347538b50b1cd8e0a6','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTGCTTGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(931,'bfb111d0803aa80122a862284a471ba8','TTTCCGTAGGTGAACTTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTGCTTGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(932,'91a57596fb3cce8b687bebb30a29ef2b','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTGCTGGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(933,'49758de9498ea675be5912baa90abaac','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTGCTTGGCGGCGTGCGTGCTGGCCTGTAATGGGTTGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(934,'7b530ceacdffa9f6a2d74cd7013c62b0','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTACTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(935,'40103bb284376757dddd792b05edabf5','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTGCTTGGCGGCCTGCCTGCTGGCCTGTAATGGGTTGGCGTGCTGCTGCTGGGCCGGCTTTATCATGGGCGAGCGGTTGGGGTTTGGCTTGAGGTTGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(936,'2e8aa2a83c42d7530ee26750e81fc075','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTGCTTGGCGGCCTGCCTTCTGGCCTGTAATGGGTTGGCGTGCTGCTGCTGGGCGGGCTTTATCATGGGCGAGCGCTTGGGCTTTGGCTCGAGCTTGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(937,'0673593abf6e6947da5b2e9f34002f28','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTGCTTGGCGGCGTGCGTGCTGGCCTGTAATGGGTTGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(938,'e7a5484da94577caa7bddb51c92be5b9','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(939,'d32a870434817af3da15653334feb977','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(940,'349bc0b31fe130b2a1b17fae711a802a','GTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTTGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(941,'b2fe2a97b047e98934e86bc24acdce46','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(942,'8395798f08e3be866f3ce4e0e29a630e','TTTCCGTAGGTGAACGTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTTGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(943,'4c0503621dab654c7fadd31c85f05843','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTTGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTTGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(944,'a4a4274bd489ce903dbe89605d172235','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTTGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(945,'d5dcfc50de533c6a4dc04e1552e5ef2c','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(946,'07bf081f75634d5f7d1f5e516b55b331','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCCTATAATTTGGGGGCTTGCTTGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTTGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(947,'3bd5720f7e529ba4830ab3970bc709b2','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTTGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(948,'d7b39edee0c8b6580b92799394509952','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTTGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(949,'c5fdfd74a90a5ffdbf9ca47ac81025c3','TTTCTGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTAGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(950,'37337465b07c71311de188b4f2b7f5b7','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(951,'3d8e523d9b764fc1aa11b27658c7216a','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTTGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTAGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(952,'bfd9ace0d95f4b45e232001d6d358933','TTTCCGTAGGGAACTGCGGAAGGATCATTACCACACTTAAAACTTTCCACGTGAACTGTCTGTGATGTGGGGGCTGTCTGCCTGTTGGCGGCGGCTCCATCAAACGAGGCTCTGGCTGCAAAGTCGAGGGTAGTAGTTACTTTTGTAAACCCTTCCTATATTTTCTGATCATACT');
INSERT INTO marker_sequence VALUES(953,'f5a0401ca6371fb4614ceb55e5842d74','TCCGTAGGGACCTGCGAAGGATCATTACCACACCTAAAACTTTCCACGTGAACTGTCTGTGATGTGGGGGCTGTCTGCCTTTGGCGGCGGCTCCATCAAACGAGGCTCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTTTGTAAACCCTTCCTATATTTTCTGATCATACT');
INSERT INTO marker_sequence VALUES(954,'46fe5730f64be11bcf5f1202a9581500','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGTTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(955,'d945b2321c41c3b3ae4cf9f5bcb4dbff','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTAAATTTGGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCACTTTTAAACCCTTTCTTAAAAAACTGAACATACT');
INSERT INTO marker_sequence VALUES(956,'6a9d08d481246f5171f1342be7284bd2','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTCCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO marker_sequence VALUES(957,'44acd6ea9163bde807c8bd15210d1bbe','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTCCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO marker_sequence VALUES(958,'c10f243d1b62c84af47e4f22ba3f9745','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTCCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO marker_sequence VALUES(959,'53a029e622e744b1d5bf615bc49cb4eb','GTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTCCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO marker_sequence VALUES(960,'6d616d9c50baec27d44d31b8d401be89','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTATCGAACAACTAGTTGGGGGTCTTGTTTGGCGTGCGGCTGCTTCGGTAGCTGCTGCTAGGCGAGCCCTATCACGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTATTTTTTAAACCCATTYTTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(961,'97c2dff00e2155757700caaea357a8a3','TTTCTGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTATCGAACAACTAGTTGGGGGTCTTGTTTGGCGTGCGGCTGCTTCGGTAGCTGCTGCTAGGCGAGCCCTATCACGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTATTTTTTAAACCCATTCTTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(962,'415410a6be65fad641df16d856354372','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTRGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTCCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(963,'e32346ee3cc6cdb95a523893c78b1cbc','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTATCGAACAACTAGTTGGGGGTCTTGTTTGGCGTGCGGCTGCTTCGGTAGCTGCTGCTAGGCGAGCCCTATCACGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTATTTTTTAAACCCATTTTTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(964,'6117ab04ddb0dfded99fb9295ae40dfc','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGRCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCAGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAACTAGTAGCTATCAATTTTAAACCCTTTCTTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(965,'6ce55a5b41379afa19282addbe42ee84','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAAACCCTTTTATTGGGGGCTTCTGTCTGGTCTAGCTTCGGCTGGATTGGGTGGCGGCTCTATCATGGCGACCGCTCTGAGCTTCGGCCTGGAGCTAGTAGCCCACTTTTTAAACCCATTCTTAATTACTGAACAAACT');
INSERT INTO marker_sequence VALUES(966,'fc789b5ed63b0ea04a61aa066b8d6900','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAAACTTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(967,'c1b4973c04a5f8e3604019a09b25bbe2','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTTAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTAATTTTAAACCCATTCTTAAATACTGAAYATACT');
INSERT INTO marker_sequence VALUES(968,'45763fe0cb7f75f80f6d3fd285a6e9a1','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCYCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(969,'fd87b504d3758f0ea3165820866c6b74','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTGCTGAGTCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(970,'80129190c537d933d3d94b07b6acd9ed','TCCGTAGGTGAACTGCGGAAGGATCATTACCACACTTAAAAACTTTCCACGTGAACCGTATTAACAATTATAATGGGGGGTGATCTTAATGGAGGCTACTAGTCATTTTGGCTGGAGGCTACTATCGAGTGAACCTTATCATGGCGAAAAACTAGACTTTTGTTTGGTGAAGTAGTGAAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(971,'a8c8d2dc73c9db3aceb8609707f6ce21','TCCGTAGGTGAACTGCGGAAGGATCATTAACACACTAAAAAACTTTCCACCTGAACCGTATTAACAATTATAATTGGGGGTGATCTTAATGGAGGCTACTAGTCATTTTGGCTGGAGGCTACTATCGAGTGAACCTTATCATGGCGAAAAACTAGACTTTTGTTTGGTGAAGTAGTGAAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(972,'9b30c985c59508690f12d2c5f9397583','TCCGTAGGTGAACTGCGGAAGGATCATTACCACACTTAAAAACTTTCCACGTGAACCGTATTAACAATTATAATTGGGGGTGATCTTAATGGAGGCTACTAGTCATTTTGGCTGGAGGCTACTATCGAGTGAACCTTATCATGGCGAAAAACTAGACTTTTGTTTGGTGAAGTAGTGAAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(973,'5d82c115a21efd576c2828806680398b','TCCGTAGGTGAACTGCGGAAGGATCATTACCACACTAAAAAACTTTCCACGTGAACCGTTTTAACAATTATAATTGGGGGTGATCTTAATGGAGGCTACTAGTCATTTTGGCTGGAGGCTACTATCGAGTGAACCTTATCATGGCGAAAAACTAGACTTTTGTTTGGTGAAGTAGTGAAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(974,'2f924c2ad6d64bb58651af856683e9da','TCCGTAGGTGAACTGCGGAAGGATCATTACCACACTAAAAAACTTTCCACCTGAACCGTATTAACAATTATAATTGGGGGTGATCTTAATGGAGGCTACTAGTCATTTTGGCTGGAGGCTACTATCGAGTGAACCTTATCATGGCGAAAAACTAGACTTTTGTTTGGTGAAGTAGTGAAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(975,'810139eea4997e745eef57eef8eb5925','TCCGTAGGTGAACTGCGGAAGGATCATTACCACACTTAAAAACTTTCCACGTGAACCGTATTACCAATTATAATTGGGGGTGATCTTAATGGAGGCTACTAGTCATTTTGGCTGGAGGCTACTATCGAGTGAACCTTATCATGGCGAAAAACTAGACTTTTGTTTGGTGAAGTAGTGAAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(976,'c5fc854fc068eebda3c52dae6648393c','TCCGTAGGTGAACTGCGGAAGGATCACTACCACACTAAAAAACTTTCCACGTGAACCGTATTAACAATTATAATTGGGGGTGATCTTAATGGAGGCTACTAGTCATTTTGGCTGGAGGCTACTATCGAGTGAACCTTATCATGGCGAAAAACTAGACTTTTGTTTGGTGAAGTAGTGAAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(977,'245e153c69d4125c529d8c2b3894bf30','TCCGTAGGTGAACTGCGGAAGGATCATTCCCACCCTAAAAAACTTTCCACGTGAACCGTATTAACAATTATAATGGGGGGTGATCTTAATGGAGGCTACTAGTCATTTTGGCTGGAGGCTACTATCGAGTGAACCTTATCATGGCGAAAAACTAGACTTTTGTTTGGTGAAGTAGTGAAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(978,'a9861207cf15d66a39dbbcdbd4f1da6e','TCCGTAGGTGAACTGCGGAAGGATCATTACCACCCTAAAAAACTTTCCACGTGAACCGTATTAACAATTATAATTGGGGGTGATCTTAATGGAGGCTACTAGTCATTTTGGCTGGAGGCTACTATCGAGTGAACCTTATCATGGCGAAAAACTAGACTTTTGTTTGGTGAAGTAGTGAAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(979,'bc202404a2afc98dd98b425d03dfa3a0','TTTCCGTAGGTGAACCTGCGGAAGGATCATCACCACACCTCAAAAACTTCTCACGTGAACCGTTTCAACCCAATAGTTGGGGGTATTATTTGGCGGCGGCTGCTGGTGTAATAGTTGTCGGCTGCTGCTGAGTAATCCCTATCAAAAAAAAAGGCGAACGTTTGGGGCTTCGGCCTGATTTAGTTAGTTTTTTTTTCTTTTACAACCCATTCCTTAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(980,'55e0bda7c74732074453002bddd5a5df','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCAATAATTTGGGGGTTTAATTGGCGGCTGCTGCTGGTATCTTTTTACTGGCTGGCGGCTGCTGAGCGAACCCTATCGTGAGCGTTCTGACCTTGGTTGGAGCTAGTAACTTAAATTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(981,'e006fbee2ea65903c2cf370e0c01644d','AATGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTTTCAACCAAATATTTTGGGGGTCTTGTCTGGCGTATGGCTGCTGCTGTAAAAGGCGGCGGCTGTTGCTGGGTGAGCCCTATCATGGCGAACGTTTGGGCTTCGGTCTGAACAAGTAGCTCTTTTTTAAACCATTACTTATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(982,'fffc8ca05179c4ee3d36a0a6145ee1a8','ATTGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTTTCAACCAAATATTTTGGGGGTCTTGTCTGGCGTATGGCTGCTGCTGTAAAAGGCGGCGGCTGTTGCTGGGTGAGCCCTATCATGGCGAACGTTTGGGCTTCGGTCTGAACAAGTAGCTCTTTTTTAAACCATTACTTATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(983,'716164a30f0693e67b1d2e0f4fdcf1ed','GCAGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTTTCAACCAAATATTTTGGGGGTCTTGTCTGGCGTATGGCTGCTGCTGTAAAAGGCGGCGGCTGTTGCTGGGTGAGCCCTATCATGGCGAACGTTTGGGCTTCGGTCTGAACAAGTAGCTCTTTTTTAAACCATTACTTATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(984,'e32d4c97dea72b4e7fbd8daff86c8247','TTTCCGGTAAGTGAACCTGCGGAAGGATCATTACCACACTTTAAAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTGACTGAGCTGGTGTTTTCATTTTTGGACACTGGAACGGGAGTCAGCAGGACGAAGGTTGGTCTGTTGTAATGCAAGTTATGATGGACTAGCTGATGAACTTTTGTTTTTAAACCCTTACCTAAATACTGATTTATACT');
INSERT INTO marker_sequence VALUES(985,'28f00d5b7ea2dd24900be0cd3426a321','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTCTAAATATGTTCTGTGCTTCGTCGAAGCGGACTGCTCTCTCCGGAGAATGGTCTTGCGACGGCTTGAGGCTGAACGAAGGCTTGCTCAGTGACTCGTTTGACTCTCGGGTTGTACGGCGGAACTGCTGGCCGATGTCTTTTTCAAACCCATTTTTACTAAACACTGATCTATACT');
INSERT INTO marker_sequence VALUES(986,'e4462f0cbd8585e40b6ccbb73e11ed41','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTCTAAATATGTTCTGTGCTTCGTCGAAGCGGACTGCTCTCTCCGGAGAATGGTCTTGCGACGGCTTGAGGCTGAACGAAGGCTTGCTCAGTAACTCGTATGACTCTCGGGTTGTACGGTGGAACTGCTGGCCGATGTCTTTTTCAAACCCATTTTACTAAACACTGATCTATACT');
INSERT INTO marker_sequence VALUES(987,'4418860f4c4c9c7a9624aebc42af412e','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCCCACCAAAAAAACTTTCCACGTGACCCGTTTTGTGCGTTTTGTGCTTTGTGTTTGCTTTTGTTTGTCTCGCTCTTCGGGGTGTGGTGAAGAAGAGGAAGCGCAAGGCTAAACGAAGGCTGCGAGTCTCGTGCTTGCGGCCGATTTATTCTTTCAAACCCATACATTAAACACTGAACTATACT');
INSERT INTO marker_sequence VALUES(988,'83a77f47e93e6a0c24a82ac3b520841c','TTTCCGTAGTGAACCTGCCGGAAGGATCATTACCACACTTTAAAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTGACTGAGCTGGTGTTTTCATTTTTGGACACTGGAACGGGAGTCAGCAGGACGAAGGGTTGGTCTGTTGTAATGCAAGTTATGATGGACTAGCTGATGAACTTTTGTTTTTAAACCCTTACCTAAATACTGATTTATACT');
INSERT INTO marker_sequence VALUES(989,'8a90868597e39d6022e18e35af2bd920','TTTCCGTAGGTGAACTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTGCTGAGTCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(990,'776d7fe7659da743d1ea6354e0d4c26f','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGRCTTTATTGTTGGCGGCTGCTGCTGGRYGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(991,'b3dba9fe986be0cbd7eaba174629e329','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGRGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(992,'18232970a6d564f54e4649d0a206091e','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTAATTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(993,'f50cdac836eafa107a43d5dc2a7a1cfd','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGKCTGTCGATGTCAAAGTCGACGGCTGGCTGCTRTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(994,'d51cac62893847dacdcf8ad9537ca2cc','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTCCCGTCTGGCCGGCCGGTTYTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO marker_sequence VALUES(995,'63557a7e131edfbee297906141db19de','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCRTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO marker_sequence VALUES(996,'5ee5253f198df6f18113950c73720207','TTTCCGTAGGTGAACTGCGGAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCCTGTCCTGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATCTTTTAAACCCATTCTTGAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(997,'a6c1d01ea30e8a9b97f8e73e5bf60304','TTTCCGTAGGTGAACTGCGGAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATTTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(998,'20eddc875172304412c495dad98eb03a','TTTCCGTAGGTGAACTGCGGAAGGATCATTACCACACTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTRCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(999,'623e495742c5a624949e09321e254934','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACCCCTAAAAAACCTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTTTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO marker_sequence VALUES(1000,'55172f9e1424726af3b5e3d45264c2d4','TTTCCGTAGGTGAACGTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO marker_sequence VALUES(1001,'4d8f5abc348efd8b24565d378a49e095','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO marker_sequence VALUES(1002,'b32c788be80116af1bfbc4bb0a193efe','CTTCCGTAGGTCAACCTGCGGAAGGATCATTACCACCACTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTCGCATTTTGCTGAGCCGCGCCGTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGGTTTTAACCCATTTAACAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(1003,'b7d07c8adaafc0fa1674f319b82e7add','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTTTTATTCGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(1004,'9ebe18312d6cf790be0a1f7af58fc1e7','TTTCCGTAGGTGAACCTGCCGAAGGATCATTACCACCCCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(1005,'ddb451bcd1ea54169fc8bd1ab70b9146','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACGCCCTTCCACGTGAACCGTTTTGTTTTGCTTTCGAGTGCTTTGTTGCGCTCGGAGCATGTTTTGGGCTTCGCTGCTGGCGCTTGATTGTGCTGGCGGCTCGAGGCCATCAAGTGGCGTTTTGAGTGTGCTTTGCGCAATTGAAACGTCGAAACCTTTTTTTTAAACCCATTTGATTGAAAACTGAAGTATACT');
INSERT INTO marker_sequence VALUES(1006,'4016b08de4a00c23d00285693efa9b4f','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGAGCTGTCTGCCTGTTGGCGGCGGCTCCATCAAACGAGGCTCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTCCTATATTTTCTGATCATACT');
INSERT INTO marker_sequence VALUES(1007,'8d8c394cf88ca412d75f8900ac21b280','TTTCCGTAGGTGAACCTGCCGGAAAGGATCCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(1008,'c13b2be38ae87d8b32f21d47805827ee','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACTTTAAAAAACTGTCCCACGTGAACTGTAAGCAAGTCTAGCGCTGTGACTGAGCTGGTGTTTTCATTTTTGGACACTGGAACGGGAGTCAGCAGGACGAAGGTTGGTCTGTTGTAATGCAAGTTATGATGGACTAGCTGATGAACTTTTGTTTTTAAACCCTTACCTAAATACTGATTTATACT');
INSERT INTO marker_sequence VALUES(1009,'5b6d09f18c32289e5027fa24ec044180','GTTCCGTAGGTGAACCTGCAGAAGGATCATTACCACACTTTAAAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTGACTGAGCTGGTGTTTTCATTTTTGGACACTGGAACGGGAGTCAGCAGGACGAAGGTTGGTCTGTTGTAATGCAAGTTATGATGGACTAGCTGATGAACTTTTGTTTTTAAACCCTTACCTAAATACTGATTTATACT');
INSERT INTO marker_sequence VALUES(1010,'8c0cc73466c8ed75403b80ea696d6d2c','CTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAGATTGGGAGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCCTTCTTTAATTACTGAAATACT');
INSERT INTO marker_sequence VALUES(1011,'fb0d5faf9aae8a92e152c8de06bf107f','CTTCCGTAAGGTGAACCTGCGGAAGGATCATTTCCACACCTAAAAAACTTTTCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTTGTTGGCGGGGTTGCGTGCTGGCCTGTAATGGGTTGGGCGTGGTGGTGCTAGGCGGGCTCTATTATGGGCGAGCGCTTGGGATTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(1012,'27fdf5749d98cb64080f30940a7b15fe','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCCGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO marker_sequence VALUES(1013,'10616d908c4d092a4182365299a5ea13','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACCAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO marker_sequence VALUES(1014,'7c640a74741d88d1aa8d41565e443d6e','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAATCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO marker_sequence VALUES(1015,'dd21b9c6a00c5c05d930ac29e02046f5','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCTTTAGTTGGGGGTCTTTTTCGGCGGCGGCTGCTGGTTTAATTACTGGCGGTTGCTGCTGGGAGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCATTATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1016,'da7a47cdb10854a321b90967394991aa','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCTTTAGTTGGGGGTCTTTTTCGGCGGCGGCTGCTGGTTTAATTACTGGCGGTTGCTGCTGGGAGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTAAACCCATTCATTATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1017,'84c9e67bc2cf5f15e31071e9b34fbe9d','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGCGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(1018,'b04d3611b6b58a4957e4d19fe341d1e4','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCATTTTGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCATTTAACAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(1019,'1965d94cf09538222eabeab061fbf751','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCATTTTGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(1020,'5090f1ffdd54f81f7c8aa73b42facd62','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTKCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(1021,'3294fc64512805d3301442046c30aba3','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(1022,'cd4a834ba83015f7ea444e1e2bb92ba1','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATAATTTGGGGGTTAATTTGGTAATGGCTGCTGGCATCTTTTTGTTGGCTGGCTGTTACTGAGTAAGCCCTATCATGGTGAGAGTTTGGACCTTTGTCTGAACAAGTAGCTACGATTGTAAACCCTTTCTTAATTACTGAATATACT');
INSERT INTO marker_sequence VALUES(1023,'49c7dbfa3024522a5f4cfc8dd6d84914','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACACCCTTCCACGTGAACCGTTTTGTTTTGCTTTCGAGTGCTTTGTTGTGCTCGGAGCATGTTTGGGCTTCGCTGCTGGCGCTTGATTGTGCTGGCGGCTTGAGGCCATCAAGCGGCGTTTTGAGTGTGTGTTCGCACACAATTAAAACGTCCAAACCTTTTAAACCCATTTGATTGAAAACTGAAGTATACT');
INSERT INTO marker_sequence VALUES(1024,'23c0e3b432b479395613e85954289549','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATTAATTGGGGGTTTTATTGGTGGTGGCTGCTGCTAGCATCTTTTTGCTGGCTGGCGACTGCTAAGCGAACCCTATCATGGCGAGCGTTCTGACCTCGGTTGGAGCTAGTAGCTTGCATTTTAAACCCATTCTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(1025,'45bea3ad64dda08df659b2055fe99bad','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTATCAACCCAATTAATTGGGGGTTTTATTGGTGGTGGCTGCTGCTAGCATCTTTTTGCTGGCTGGCGACTGCTAAGCGAACCCTATCATGGCGAGCGTTCTGACCTCGGTTGGAGCTAGTAGCTTGCATTTTAAACCCATTCTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(1026,'888e1383adce12bf83dbbbf657ea59b9','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATTAATTGGGGGTTTCGTTGGCGGCTGCTGCTGGCATGTTTTTGCTGGCTGGCAGCTGCTGAGTAAACCCTATCATGGCGAGTGCTCTGATCTCGGTCGGAGCTAGTAGCTTCAATTTTAAACCCTTTCTTAAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(1027,'836c78e2e147d8b8eaa5c9e9776d9b77','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCACATTAGTTGGGGGTTTGATTGGCGGCTGCTGCTGGCATCTTTTTGCTGGCTGGCGACTGCTGAGCGAACCCTATCTTGGTGATCGTTCTGACCTTCGGTTGGAGCTAGTAGCTTGCATTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO marker_sequence VALUES(1028,'da5433f1bf2b7acd154847542e9c8d5b','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCCATTAGTTGGGGGTTTGATTGGCGGTTGCTGCTGGCATCTTTTTGCTGGCTGGCGACTGCTGAGCGAACCCTATCTTGGCGATTGTTCTGACCTTCGGTTGGAGTGAGTAGCTTGCATTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO marker_sequence VALUES(1029,'bad6143729068c16a79878381981b4cd','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCACATTAGTTGGGGGTTTGATTGGCAGCTGCTGCTGGCATCTTTTGTGCTGGCTGGCGACTGCTGAGCGAACTCTATCCTGGCGATCGCTCTGACCTTCGGTTGGAGCTAGTAACTTGCATTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO marker_sequence VALUES(1030,'a59480c18ef4ff69c9c15003cf807da3','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCACATTAGTTGGGGGTTTGATTGGCGGCTGTTGCTGGCATCTTTTTGCTGGCTGGCGACTGCTGAGCGAACCCTATCCTGGCGATCGCTCTGACCTTCGGTTGGAGCTAGTAACTTGCATTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO marker_sequence VALUES(1031,'a9bb0898e88d5cad0eba835b8dab3491','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCACATTTATTGGGGGTTTCATTGGCGGCTGCTGCTGGCATCTTTTTGCTGACTGGCGACTGCTGAGCGAACCCTATCATGGCGAGCGTTCTGACCTCGGTTGGAGCTAGTAGCTTGTATTTTAAACCCATTCTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(1032,'8d45c74e667faf5bd6f5f5a50cb8e1ef','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCACATTTATTGGGGGTTTCATTGGCGGCTGCTGCTGGCATCTTTTTGCTGGCTGGCGACTGCTGAGCGAACCCTATCATGGCGAGCGTTCTGACCTCGGTTGGAGCTAGTAGCTTGCATTTTAAACCCATTCTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(1033,'eae5d9539aad7b3b4908c2dcc166e5a7','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO marker_sequence VALUES(1034,'6d6ee67552d25aab4403e65f6cc67790','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACATCTTTCCACGTGAACCGTTTGTGACATGGTTGGGCTCTGCTGCTCTTCTTCGGAGGAGGAGCGAGCTATCTGTAAACTTGTCAAACCCATTCTTACGATATAACTGAAACATACT');
INSERT INTO marker_sequence VALUES(1035,'c565708ae7e9c40ba00b3109615502a0','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAACACCTGTCCACGTGAACCGTTTGTGAAGCAGTTGGGTCGGTTGTCGTTTCGCGACTGCCTGGCCATCAAGGAGTCGTGCATGCACTTTTCCTTCGCTTTAAACCCATTTCAATTGAAACTGATTATACT');
INSERT INTO marker_sequence VALUES(1036,'c9a023b8460aa9e211864392211aaecd','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTAGTTACCCGATTAGCGCCGTGACGCGTGTCTGCGATGCATGTATGTGTGTTGTGGGCGTGTGGGCTCGGCTGATCGAAGGTTGTCGTGCCTGTTTGTGTTGCCTTGTGCGACGCGAGCGTGTGCGCGGCGGCTGACTTATTCTTTCAAACCCCTTACTTTAAAACTGATGTATACT');
INSERT INTO marker_sequence VALUES(1037,'11ff28ca4561156bc0c7402d1c8ac9a7','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACATCTTTCCACGTGAACCGTTTGTGACATGGTTGGGCTTGTGCGTTTTCTCTCTCTTTTGGGGGAGGGGATGCGTGCGAGCTATCTGTAAACTTGTCAAACCCATTCTTTTTGATAACTGAAACATACT');
INSERT INTO marker_sequence VALUES(1038,'19908d3f510c222e6113b5763458a8a6','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAATCTTTCCACGTGAATTGTTTTGCTGTAACTTTGGGCTTCGCCGTTGTCTTGTTCTTTTGTAAGAGAAAGGGGGAGGCGCGGTTGGAGGCCATCAGGGGTGCGTTCGTCGCGGTTTCTTTTGTTTTTGGAACTTGCGCGCGGATGCGTCCTTTTGTCAACCCATTTTTTTGAATGAAAAACTGATCATACT');
INSERT INTO marker_sequence VALUES(1039,'9a62b9dca9194feaefdd411bb7edb1d5','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAATCTTTCCACGTGAACCGTTTGTGACATTGTTGGGCTCTGCGCGTCTCGAGAGGGGTGCGCAAGCTATCTGTAAAACTTGTCAAACCCATTCTACCAATAACTGAAACATACT');
INSERT INTO marker_sequence VALUES(1040,'71d4ec21b2298fd00f863ed1e13e87fb','TTTCCGTAGGTGAACTGCGGAAGGATCATTACCACACATAAAAAAACTTTCCACGTGAACCGTATCAACCCATTTAGTTGGGGGCTTGTCCTGGTGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGGCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(1041,'df4fe29b427e58b5db6db8475783c528','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCAAAAAAACTTTCCACGTGAACCGTTCTGTCCGTTTTGTGCCGTTGCTGTTGTCTCGATTCGTCGAGAAGAGCAGTGGCTAAACGAAGGCTGTGAGCTTCGTGCTTGCGGTCGATTTATTCTTTCAAACCCCATACGTTAAGAACTGAAGTATACT');
INSERT INTO marker_sequence VALUES(1042,'bc12f543302b074257b895adf44ba142','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATCAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAGATGCGTCCCATCATGGCGATCGTTTCGACTTCGGTTGAAACTAGTAGCTAAATTTKTRAACCTTTAATTATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1043,'bc2d4c68f3219db3457e1fd8eb0c5aba','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATTAAAACTTAGTTGGGGACAATTCGGGCGGCGACTGTAGACTTAATTGTCAGCGGTTGCTGCTAGATGCGTCCTATCATGGCGATCGTTTCGACCTTGGTTGAAGTTAGTAGCTGAATTTTTAAACCTTTAATTATACTGATTATACT');
INSERT INTO marker_sequence VALUES(1044,'6ebc358ec63863572339406316c0ea24','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATTAAAACTTAATTGGGGACAAATTAGGCGGCGACTGCAGACTTTGATGTTAGCGATTGCTGCTAGATAAGTCTCATCATGGCGATTGTTTCGACCTTGGTCGGGACTAGTAGCTGTTCTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1045,'dc0072958501b8072c3f3a811d651dd8','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATCAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAGATGCGTCCCATCATGGCGATCGTTTCGACTTCGGTTGAAACTAGTAGCTAAWTTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1046,'856e82f26acaf6cfbdc547ebdc618bb9','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAAYTTAGTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAAATGCGTCCCATCATGGCGATCGTTTCGACCTCGGTTGGAATTAGTAGCTACATTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1047,'fc0b467c823e892f93eb0481303b7386','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAAYTTAGTTGGGRAYAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAAATGCGTCCCATCATGGCGATCGTTTCGACCTCGGTTGGAATTAGTAGCTACATTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1048,'488cc087b1e94442c16254e017a85084','TTTCCGTAGGTGRACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAAYTTAGTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAAATGCGTCCCATCATGGCGATCGTTTCGACCTCGRTTGGAATTAGTAGCTACATTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1049,'bcb76ba38308b87c078b8ddad271db9a','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAAYTTAGTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAAAYGCGTCCCATCATGGCGATCGTTTCGACCTCGGTTGGAATTAGTAGCTACWTTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1050,'83373f4979bf3e82d1ae5cab5cbe83d6','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAAYTTAGTTGGGGAYAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAAATGCGTCCCATCATGGCGATCGTTTCGACCTCGGTTGGAATTAGTAGCTACMTTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1051,'37e48a8bf6ac7e823cff9c7689a1825a','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATTAGGCGGCGACTGCAGACTYTATTGTYAGCGGTTGCTGCTAAATGCGTCCCATCATGGCGATCGTTTCGACCTCGGTTGGAATTAGTAGCTACATTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1052,'0e2c7b50412fd62188bd71a3d64f2016','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAAATGCRTCCCATCATGGCGATCGTTTCGACCTCGGTTGGAATTAGTAGCTACATTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1053,'8381608534dcae00658a5b9391372bcd','TTTCYGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATCAGGCGGCGACTACAGACTTTATTGTTAGCGGTTGCTGCTAGATGCGTCCCATCATGGCGATCGTTTCGACTTCGGTTGAAATTAGTAGCTAAATTATTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1054,'2a1c898bf1fe1f77c7d0cace33d5d2f4','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATMAAAACTTAGTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAAATGCGTCCCATCATGGCGATCGTTTCGACCTCGGTTGGAATTAGTAGCTACATTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1055,'15793e77128f6da2b829051aec3de1ea','TTTCCRTAGGTGAACYTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAAYTTAGTTGGGGACAAATTAGGCGGCGAYTGCAGACTTTATTGTTAGCGGTTGCTGCTAAATGCGTCCCATCATGGCGATCGTTTCGACCTCGGTTGGAATTAGTAGCTACWTTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1056,'3a20de18b27eaa2ce27a76e5fb40c0a3','TTTCCGTAGGTGAACCTGCGGAAGGATCAYTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAAYTTAGTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAAATGCGTCCCATCATGGCGATCGTTTCGACCTCGGTTGGAATTAGTAGCTACWTTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1057,'535ab17a6972b3b10cb741e5a657ec9b','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAAATGCGTCCCATCATGGCGATCGTTTCGACCTCGGTTGGAATTAGTAGCTACWTTTTTAAAYCTTTAATTATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1058,'9422b4c2d8e1541810f119143916b91a','TYTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAARACTTCCACGTGAACTGTATCAAAAYTTAGTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAAATGCGTCCCATCATGGCGATCGTTTCGACCTCGGTTGGAATTAGTAGCTACWTTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1059,'d40420b1045a68a0d0c41fafc46f5669','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTARAAAACTTCCACKTGAACTGTATCAAAAYTTAGTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAAATGCGTCCCAYCATGGCGATCGTTTCGACCTCGGTTGGAATTAGTAGCTACWTTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1060,'8584c284c9ebd5783b986fbbe81f176d','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAARAACTTCCACGTGAACTGTATCAAAAYTTAGTTGGGGACAAATTAGGCGRCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAAATGCGTCCCATCATGGCGATCGTTTCGACCTCGGTTGGAATTAGTAGCTACWTTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1061,'846c85dcefb60e671b95fd5cae5b88d0','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAAATGCGTCCCATCATGGCGATCGTTTCGACCTCGGTTGGAATTAGTAGCTACATTTTTAAACCTTTAATTATTAGTGATTATACT');
INSERT INTO marker_sequence VALUES(1062,'8f99a94eeefb42f0b0037f7fe2541e82','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAAATGCGTCCCATCATGGCGATCGCTTCGACCTCGGTTGGAATTAGTAGCTACATTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1063,'ea6ffeb05118e0f2127b3f646ad1f80f','TTTCCGTAGGTGAACCTGCGGAGGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAAATGCGTCCCATCATGGCGATCGTTTCGACCTCGGTTGGAATTAGTAGCTACATTTTTAGACCTTTAATTATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1064,'73cb087b6394781382ef6baf2de6617c','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTCAGTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAAATGCGTCCCATCATGGCGATCGTTTCGACCTCGGTTGGAATTAGTAGCTACATTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1065,'a39b9dd85f775e08b719caefa418e240','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATTAGGCGGCGACTGCAGACTCTATTGTTAGCGGTTGCTGCTAAATGCGTCCCATCATGGCGATCGTTTCGACCTCGGTTGGAATTAGTAGCTACATTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1066,'3c0025ad90eacdeef05730487d5fda42','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAAATGCGTCCCATCATGGCGATCGTTTCGACCTCGGTTGGAATTAGTAGCTACATTCTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1067,'65ec3e506822419f35705022a37e4f17','TTTCCGTAGGTGAACCTGCAGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAAATGCGTCCCATCATGGCGATCGTTTCGACCTCGGTTGGAATTAGTAGCTACATTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1068,'87c938df3d48662248a41b984983ac0c','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAAATGCGTCCCATCATGGCGATCGTTTCGACCTCGGTTGGAATTAGTAGCTACATTTTTAAACCTTTAATTATTACTGATTAAACT');
INSERT INTO marker_sequence VALUES(1069,'16cf6bf570063e60116c9830e3f58093','YTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAARAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAAATGCGTCCCATCATGGCGATCGTTTCGACCTCGGTTGGAATTAGTAGCTACATTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1070,'1fbf254f52d1cbcc4765eb5758888785','TTTCCGTAGGYGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACTGTATCAAAAYTTAGTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAAATGCGTCCCATCATGGCGATCGTTTCGACCTCGGTTGGAATTAGTAGCTACWTTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1071,'a3828b036b39c379f7b77be0ab199b8e','GTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTCGTTATTTGTTGTGTGTCTGCGCGTTGCTGGCGTGCGTTTGCTTACGCTTCGGTGTTTGCGAGTGCGTGCTGGCGGTGCGCGGACTGAACGAAGGTCGTGTTGCTGTGTGCCTGCTGCACTGCTGACTTTGCATTGATTTGCATGGTCTTGGCGGAGCGGCGGGTGCTGTGCGTGCGCGGCTGACTTACTTTTTCAAACCCCATACCTAACTTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1072,'c38f62dfbf1914e96a9bcd9faaab0560','TTTCCGTAGGTGAACCTGCGGAAGGATCATTCCCACACCTAAAAAAACTTTCCACGTGAACTGTCGTTATTTGTTGTGTGTGTGCGTGTTGGTAGCATGCGTGTTTGCTTACGCTTTGGTGTTTGCGAGTGTGTGTGTTGTCGGTGCGCAGACTGAACGAAGGTCGTGTGTTGCTGTGTGCCTGCTGCACTGCTGACTTTGCATTGATTTGCATGGTGTTGGCGGAGCGGCGGGTGCTGTTGCATGCGCGGCTGACCTATTTTTTTCAAACCCCATACCTAAATGACTGATTATACT');
INSERT INTO marker_sequence VALUES(1073,'35c3dec9f51051bad76ee1cbc5fbd79d','GTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACTTTAAAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTGACTGAGCTGGTGTTTTCATTTTTGGACACTGGAACGGGAGTCAGCAGGACGAAGGTTGGTCTGTTGTAATGCAAGTTATGATGGACTAGCTGATGAACTTTTGTTTTTAAACCCTTACCTAAATACTGATTTATACT');
INSERT INTO marker_sequence VALUES(1074,'f0df86d5dc018605fbdd86b005b64660','GTTCCGTAGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTCGTTATTTGTTGTGTGTCTGCGCGTTGCTGGCGTGCGTTTGCTTACGCTTCGGTGTTTGCGAGTGCGTGCTGGCGGTGCGCGGACTGAACGAAGGTCGTGTTGCTGTGTGCCTGCTGCACTGCTGACTTTGCATTGATTTGCATGGTCTTGGCGGAGCGGCGGGTGCTGTGCGTGCGCGGCTGACTTACTTTTTCAAACCCCATACCTAACTTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1075,'16140c5d5e9806903424c6cd5e0690ca','GTTCCGTAGTGAACCTGCGGAAGGATCATTACCACACTTTAAAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTGACTGAGCTGGTGTTTTCATTTTTGGACACTGGAACGGGAGTCAGCAGGACGAAGGTTGGTCTGTTGTAATGCAAGTTATGATGGACTAGCTGATGAACTTTTGTTTTTAAACCCTTACCTAAATACTGATTTATACT');
INSERT INTO marker_sequence VALUES(1076,'ef222fce3a4926631ea94bbef8f03ab9','GTTCGTAGTGAACCTGCGGAAGGATCATTACCACCACCTAAAAACTATCCACGTGAACCGTTAAGCAAACAAGTTAAGGCAGGCGCGATTGGTGGTGCGTCTGGGAAGCGCTTGTCGATATTCGATCGGATCGGATATTGTCGGGCGTCGTCCTGGACACGCTGTCGATCGGAGTCGGCTAAACGAAGGTCGGGCGTTCGCTATCGGAGCGATGTGCGCGTTGTCGCACGTTGCTGCAATGGCTCGAGCAAGCGGCTGATTTATGTCTTTCAAACCATACGTGACGTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1077,'ca7992bb1226646d3415466768b3dadf','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACCACTTTAAAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTGACTGAGCTGGTGTTTTCATTTTTGGACACTGGAACGGGAGTCAGCAGGACGAAGGTTGGTCTGTTGTAATGCAAGTTATGATGGACTAGCTGATGAACTTTTGTTTTTAAACCCTTACCTAAATACTGATTTATACT');
INSERT INTO marker_sequence VALUES(1078,'8714a9572c7bc6990202b30ef443306e','GTTCCGTAGGTGAACCTTGCGGAAGGATCAATTACCCCCCCTTAAAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTGACTGAGCTGGTGTTTTCATTTTTGGACACTGGAACGGGAGTCAGCAGGACGAAGGTTGGTCTGTTGTAATGCAAGTTATGATGGACTAGCTGATGAACTTTTGTTTTTAAACCCTTACCTAAATACTGATTTATACT');
INSERT INTO marker_sequence VALUES(1079,'8a7bc8e4c86c91decf1057b7c712dbbe','GTTCCGTAGGTGAACCTTGGGAAGGATCATTACCACCACTTTAAAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTGACTGAGCTGGTGTTTTCATTTTTGGACACTGGAACGGGAGTCAGCAGGACGAAGGTTGGTCTGTTGTAATGCAAGTTATGATGGACTAGCTGATGAACTTTTGTTTTTAAACCCTTACCTAAATACTGATTTATACT');
INSERT INTO marker_sequence VALUES(1080,'35f6b757b45c69c902858905d8aadf6d','GTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACTTTTAAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTGACTGAGCTGGTGTTTTCATTTTTGGACACTGGAACGGGAGTCAGCAGGACGAAGGTTGGTCTGTTGTAATGCAAGTTATGATGGACTAGCTGATGAACTTTTGTTTTTAAACCCTTACCTAAATACTGATTTATACT');
INSERT INTO marker_sequence VALUES(1081,'a278bbfe77516ac2440c9456261ab1d5','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACTTTTAAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTGACTGAGCTGGTGTTTTCATTTTTGGACACTGGAACGGGAGTCAGCAGGACGAAGGTTGGTCTGTTGTAATGCAAGTTATGATGGACTAGCTGATGAACTTTTGTTTTTAAACCCTTACCTAAATACTGATTTATACT');
INSERT INTO marker_sequence VALUES(1082,'c8c8330739f6286758f32dced653c05a','GTTCGTAGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACTGTCGTTATTTGTTGTGTGTCTGCGCGTTGCTGGCGTGCGTTTGCTTACGCTTCGGTGTTTGCGAGTGCGTGCTGGCGGTGCGCGGACTGAACGAAGGTCGTGTTGCTGTGTGCCTGCTGCACTGCTGACTTTGCATTGATTTGCATGGTCTTGGCGGAGCGGCGGGTGCTGTGCGTGCGCGGCTGACTTACTTTTTCAAACCCCATACCTAACTTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1083,'0a77d4506413e48d536a60bfedda9f4f','GTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTTCCACGGTGAACTGTCGTTATTTGTTGTGTGTCTGCGCGTAGCTGGCGTGCGTTTGCTTACGCTTCGGTGTTTGCGAGTGCGTGCTGGCGGTGCGCGGACTGAACGAAGGTCGTGTTGCTGTGTGCCTGCTGCACTGCTGACTTTGCATTGATTTGCATGGTCTTGGCGGAGCGGCGGGTGCTGTGCGTGCGCGGCTGACTTACTTTTTCAAACCCCATACCTAACTTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1084,'9bef5e33ff3992b04d7804bda3cee669','TTTCCGTAGGTGAACCTGCGGAAAGGATCATTACCACACCTMTAAAAACTATCCCACGTGAACCGTTAAGCAACAAGTTAAGGCAGGCGCGATTGGTGGTGCGTCTGGGAAGCGCTTGTCGATATTCGATCGGATCGGATATTGTCGGGCGTCGTCCTGGACACGCTGTCGATCGGAGTCGGCTAAACGAAGGTCGGGCGTTCGCTATCGGAGCGATGTGCGCGTTGTCGCACGTTGCTGCAATGGCTCGAGCAAGCGGCTGATTTATGTCTTTCAAACCATACGTGACGTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1085,'31607de7c07bc231809567cf3922d9b7','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACTGTCGTTATTTGTTGTGTGTGTGCGTGTTGGTAGCATGCGTGTTTGCTTACGCTTTGGTGTTTGCGAGTGTGTGTGTTGTCGGTGCGCAGACTGAACGAAGGTCGTGTGTTGCTGTGTGCCTGCTGCACTGCTGACTTTGCATTGATTTGCATGGTGTTGGCGGAGCGGCGGGTGCTGTTGCGTGCGCGGCTGACCTATTTTTTTCAAACCCCATACCTAAATGACTGATTATACT');
INSERT INTO marker_sequence VALUES(1086,'455583b76c9ede9d267fb97b5252df3b','TTTCCGTAGGTGAACCTGCGGAAAGGATCATTACCACACCTAAAAAAACTATCCACGTGAACCGTTAAGCAAACAAGTTAAGGCAGGCGCGATTGGTGGTGCGTCTGGGAAGCGCTTGTCGATATTCGATCGGATCGGATATTGTCGGGCGTCGTCCTGGACACGCTGTCGATCGGAGTCGGCTAAACGAAGGTCGGGCGTTCGCTATCGGAGCGATGTGCGCGTTGTCGCACGTTGCTGCAATGGCTCGAGCAAGCGGCTGATTTATGTCTTTCAAACCATACGTGACGTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1087,'5bfc565df9990670651fd4021cc415f9','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCCACGTGAACTGTCGTTAATTTGTTGTGTGTCTGCGCGTTGCTGGCGTGCGTTTGCTTACGCTTCGGTGTTTGCGAGTGCGTGCTGGCGGTGCGCGGACTGAACGAAGGTCGTGTTGCTGTGTGCCTGCTGCACTGCTGACTTTGCATTGATTTGCATGGTCTTGGCGGAGCGGCGGGTGCTGTGCGTGCGCGGCTGACTTACTTTTTCAAACCCCATACCTAACTTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1088,'a486452589cad0221028f09b77432306','GTTCGTAGTGAACCTGCGGAAGGATCATTACCACACTTTAAAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTGACTGAGCTGGTGTTTTCATTTTTGGACACTGGAACGGGAGTCAGCAGGACGAAGGTTGGTCTGTTGTAATGCAAGTTATGATGGACTAGCTGATGAACTTTTGTTTTTAAACCCTTACCTAAATACTGATTTATACT');
INSERT INTO marker_sequence VALUES(1089,'f0aa60b3fe8f667959405a85867b99f7','TTTCCGTAGGTGAACCTGCGGAAGGATCATTTCCACACCTAAAAAACTATCCACGTGAACCGTTAAGCAAACAAGTTAAGGCAGGCGCGATTGGTGGTGCGTCTGGGAAGCGCTTGTCGATATTCGATCGGATCGGATATTGTCGGGCGTCGTCCTGGACACGCTGTCGATCGGAGTCGGCTAAACGAAGGTCGGGCGTTCGCTATCGGAGCGATGTGCGCGTTGTCGCACGTTGCTGCAATGGCTCGAGCAAGCGGCTGATTTATGTCTTTCAAACCATACGTGACGTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1090,'e337ff6299afa0b56611ffed12b2ae58','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTCGTTATTTGTTGTGTGTCTGCGCGTTGCTGGCGTGCGTTTGCTTACGCTTCGGTGTTTGCGAGTGCGTGCTGGCGGTGCGCGGACTGAACGAAGGTCGTGTTGCTGTGTGCCTGCTGCACTGCTGACTTTGCATTGATTTGCATGGTCTTGGCGGAGCGGCGGGTGCTGTGCGTGCGCGGCTGACTTACTTTTTCAAACCCCATACCTAACTTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1091,'06730bc327800a358cec9b6b630eb165','GTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTCTGTATTTGTTGTGTGTCTGTGCGTGCTGGCGTGCGTTTTGCGTGCCGGCGTGTGCGGACTGAACGAAGGTCGTGTCGCTGTGCGGCTGACTTCTTTTTCAAACCCCATACGTAAATGACTGATTATACT');
INSERT INTO marker_sequence VALUES(1092,'163eb58be82467d696c85efc7bb1f133','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTTCACGTGAACTGTCAAACCTGTTCTGTGCTTGTGCTGGGTTTGCGTTTTTGGACGCGGACGCGGCCGAGGCTGAACGAAGGCTGGTTTCATTTGTATGAGATTAGGTGATATATTTTTTCAAACCCCTTTTTTACAAAATGACTGATCAATACT');
INSERT INTO marker_sequence VALUES(1093,'e94dfebebcac4c19caeef243c8c14c2b','TTTCCGTAGGTGAACCTGCGGAAGGATCCTTACCACACCTAAAAACTTTCCACGTGAACTGTCAAACCTGTTCTGTGCTTGTGCTGGGTCTGCGTTTTCGGACGCGGACGCGGCGGAGGCTGAACGAAGGCTGGTTTCATTTGTATGAGATCAGCTGATATATTTTTTCAAACCCCTTTTTTACAAAATGACTGATCAATACT');
INSERT INTO marker_sequence VALUES(1094,'b2675dbd8ed49706747c2cf0a7c31a03','TTCCGTAGGGAACCTGCGGAAGGATCATTACCACACTTTAAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTAACTGATCTAGTGTTTTCCTATTTTTGGGACACTGGAATACAGGATTCAGCAGGACGAAGGTTAGTCTCTCGTAATGCAAATTAGGAGGACTAGCTGATGAACTTTTCTTTTTAAACCCTTACCTAAATACTGATTTATACT');
INSERT INTO marker_sequence VALUES(1095,'2be420a2048fc47f1b8867471105c36e','GTTCCGTAGTGAACCTGCGGAAGGATCATTACCACACCAAAAAAACTTTCCACGTGAACCGTTTTGTGCGTTTTGTGCTTGTTGTTTTTTTCGATCTGCTGCTCTGTGGAGTGTGTGGGGAAGAGAAAGCTCCAGGCTAAACGAAGGCTGCGAGTTTCGAGTTTCGTGCTTGCGGCCGATTTATTCTTTCAAACCCATACATGAAATACTGAAGTATACT');
INSERT INTO marker_sequence VALUES(1096,'a4873f24909e4f30155a163ad44649ed','GTTCCGTAGGGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTCAAACCTGTTCTGTGCTTGTGCTGGGTCTGCGTTTTCGGACGCGGACGCGGCGGAGGCTGAACGAAGGCTGGTTTCATTTGTATGAGATCAGCTGATATATTTTTTCAAACCCCTTTTTTACAAAATGACTGATCAATACT');
INSERT INTO marker_sequence VALUES(1097,'20443baae8a0e84017178a3d325e9296','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCAAAAAAACTTTCCACGTGAACCGTTTTGTGCGTTTTGTGCTTGTTGTTGTTTTTCGATCTGCTGCTCTGTGGAGTGTGTGGGGAAGAAAAAGCTCCAGGCTAAACGAAGGCTGCGAGTTTCGAGTTTCGTGCTTGCGGTCGATTTATTCTTTCAAACCCATACATTAAATACTGAAGTATACT');
INSERT INTO marker_sequence VALUES(1098,'9a45bc1b8b5d20ccc48756fc8f6df038','TTCGTAGTGAACCTGCGGAAGGATCATTACCACACCAAAAAAACTTTCCACGTGAACCGTTTTGTGCGTTTTGTGCTTGTTGTTTTTTTCGATCTGCTGCTCTGTGGAGTGTGTGGGGAAGAGAAAGCTCCAGGCTAAACGAAGGCTGCGAGTTTCGAGTTTCGTGCTTGCGGCCGATTTATTCTTTCAAACCCATACATGAAATACTGAAGTATACT');
INSERT INTO marker_sequence VALUES(1100,'55ee6f9121d8d809915d80c5cf136fa2','GTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCAAAANAACTTTCCACGTGAACCGTTCTGTCCGTTTTGTGCCGTTGCTGTTGTCTCGATTCGTCGAGAAGAGCAGTGGCTAAACGAAGGCTGTGAGCTTCGTGCTTGCGGTCGATTTATTCTTTCAAACCCCATACGTTAAGAACTGAAGTATACT');
INSERT INTO marker_sequence VALUES(1101,'2f4b8653557020bf3d590d2ecb8c2376','TTTCGGTAGGTGAACTTGCGGAAGGATCATTACCACACTTAAAAAACTTTCCACGTGAACTGTCAACCTTGTTCTGTGCTTGTGCTGGTTCTGCGTTTTCGGAGGCGGACGCGGCGGAGGTTGAAGGAAGGCTGGTTTCATTKGTATGAGTTCAGTTGATATATTTTTTCAAACCCTTTTTTACAAAATGACTGATCAATACT');
INSERT INTO marker_sequence VALUES(1102,'af92eae1129194995c87b098be2654d5','GTTCGTAGGTGAACCTGCGGAAGGATCATTACCACACCAAAAAAACTTTCCACGTGAACCGTTCTGTCCGTTTTGTGCCGTTGCTGTTGTCTCGATTCGTCGAGAAGAGCAGTGGCTAAACGAAGGCTGTGAGCTTCGTGCTTGCGGTCGATTTATTCTTTCAAACCCCATACGTTAAGAACTGAAGTATACT');
INSERT INTO marker_sequence VALUES(1103,'56aeb2a58e948afa72cfc08125ee66a4','GTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACTTTAAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTAACTGATCTAGTGTTTTCCTATTTTTGGGACACTGGAATACAGGATTCAGCAGGACGAAGGTTAGTCTCTCGTAATGCAAATTAGGAGGACTAGCTGATGAACTTTTCTTTTTAAACCCTTACCTAAATACTGATTTATACT');
INSERT INTO marker_sequence VALUES(1104,'0cd189b1472c23cdb7edb499c9e3b738','TCCGTAGGTGAACCTGCGAAAGGATCATTACCCACACCTAAAAAACTTTCCACGTGAACTGTCAAACCTGTTCTGTGCTTGTGCTGGGTCTGCGTTTTCGGACGCGGACGCGGCGGAGGCTGAACGAAGGCTGGTTTCATTTGTATGAGATCAGCTGATATATTTTTTCAAACCCCTTTTTTACAAAATGACTGATCAATACT');
INSERT INTO marker_sequence VALUES(1105,'254b758bbf7f85b89178969d57c539ec','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCAAAAAAACTTTCCACGTGAACCGTTTTGTGCGTTTTGTGCTTGTTGTTTTTTTCGATCTGCTGCTCTGTGGAGCGTGTGGGGAAGAGAAAGCTCCAGGCTAAACGAAGGCTGCGAGTTTCGAGTTTCGTGCTTGCGGCCGATTTATTCTTTCAAACCCATACATGAAATACTGAAGTATACT');
INSERT INTO marker_sequence VALUES(1106,'565c4756d186926f9e5a4cef24506b63','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTCAAACCTGTTTTGTGCTTGTGCTGGGTTTGCGTTTTCGGACGCGGACGCGGCGGAGGCTTGAACGAAGGCTGGTTTCATTTGTATGAGATCAGCTGATATATTTTTTCAAACCCCTTTTTTACAAAATGACTGATCAATACT');
INSERT INTO marker_sequence VALUES(1107,'2cf601ba47b04971378f8ea2646c9308','GTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCTTCTCTTTTAAACCCATTCCTAATGACTGAATATACT');
INSERT INTO marker_sequence VALUES(1108,'d05e24089b52e1f05acfa16f2551bd83','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTTCACGTGAACTGTCAAACCTGTTCTGTGCTTGTGCTGGGTCTGCGTTTTCGGACGCGGACGCGGCGGAGGCTGAACGAAGGCTGGTTTCATTTGTATGAGATCAGCTGATATATTTTTTCAAACCCCTTTTTTACAAAATGACTGATCAATACT');
INSERT INTO marker_sequence VALUES(1109,'83bbff3909655a6e20fed5da15603e0a','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTCGTTATTTGTTGTGTGTCTGCGCGTTGCTGGCGTGCGTTTGCTTACGCTTCGGTGTTTGCGAGTGCGTGCTGGTGGTGCGCGGACTGAACGAAGGTCGTGTTGCTGTGTGCCTGCTGCACTGCTGACTTTGCATTGATTTGCATGGTCTTGGCGGAGCGGCGGGTGCTGTGCGTGCGCGGCTGACTTACTTTTTCAAACCCCATACCTAACTTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1110,'3c204a9f2c11eba1b90aef78a42dad1a','GTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTCGTTATTTGTTGTGCGCTCTCTGCGGTGTCGGTGGCGTCTGCTGGCTTTGTTGCTGGCGGGTGCGAGCCGGATGCGGAGGCTGAACGAAGGTCGAGTTGCTTTGCTCTCGGCTGACTTATTTTTCAAACCCAATACCAAACTTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1111,'9d5087894443343fb1b2116208a8822a','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACTTTAAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTGACTGAGCTGGTGTTTTCATTTTTGGACACTGGAACGGGAGTCAGCAGGACGAAGGTTGGTCTGTTGTAATGCAAGTTATGATGGACTAGCTGATGAACTTTTGTTTTTAAACCCTTACCTAAATACTGATTTATACT');
INSERT INTO marker_sequence VALUES(1112,'62c630c5b6cbcb55d5ac33bbc0d1b370','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACTTTAAAAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTGACTGAGCTGGTGTTTTCATTTTTGGACACTGGAACGGCAGTCAGCAGGACGAAAGTTGGTCTGTTGTAATGCAAGTTATGATGGACTAGCTGATGAACTTTTGTTTTTAAACCCTTACCTAAATACTGATTTATACT');
INSERT INTO marker_sequence VALUES(1113,'64d657dd6f773676a1c5e4cd06196744','GTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCAAAAAAACTTTCCACGTGAACCGTTCTGTCCGTTTTGTGCCGTTGCTGTTGTCTCGATTCGTCGAGAAGAGCAGTGGCTAAACGAAGGCTGTGAGCTTCGTGCTTGCGGTCGATTTATTCTTTCAAACCCCATACGTTAAGAACTGAAGTATACT');
INSERT INTO marker_sequence VALUES(1114,'a9598f7523758afc4fbb467019a6122e','AGTYCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACTGTCGTTATTTGTTGTGTGTGTGCGTGTTGGTAGCATGCGTGTTTGCTTACGCTTTGGTGTTTGCGAGTGTGTGTGTTGTCGGTGCGCAGACTGAACGAAGGTCGTGTGTTGCTGTGTGCCTGCTGCACTGCTGACTTTGCATTGATTTGCATGGTGTTGGCGGAGCGGCGGGTGCTGTTGCGTGCGCGGCTGACCTATTTTTTTCAAACCCCATACCTAAATGACTGATTATACT');
INSERT INTO marker_sequence VALUES(1115,'259d79b0bf95e42b3a529452d9dbcfbc','GTTCCGTAGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTCGTTATTTGTTGTGTGTCTGCGCGTTGCTGGCGTGCGTTTGCTTACGCTTCGGTGTTTGCGAGTGCGTGCTGGTGGTGCGCGGACTGAACGAAGGTCGTGTTGCTGTGTGCCTGCTGCACTGCTGACTTTGCATTGATTTGCATGGTCTTGGCGGAGCGGCGGGTGCTGTGCGTGCGCGGCTGACTTACTTTTTCAAACCCCATACCTAACTTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1116,'32b99581debc38ba285ab3916afc775e','TTTCCGTAGGTGAACCTGCGGAAAGGATCATTACCCACACCTAAAAAAACTTTTCCACGTGAACTGTCGTTATTTGTTGTGTGTCTGCGCGTTGCTGGCGTGCGTTTGCTTACGCTTCGGTGTTTGCGAGTGCGTGCTGGCGGTGCGCGGACTGAACGAAGGTCGTGTTGCTGTGTGCCTGCTGCACTGCTGACTTTGCATTGATTTGCATGGTCTTGGCGGAGCGGCGGGTGCTGTGCGTGCGCGGCTGACTTACTTTTTCAAACCCCATACCTAACTTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1117,'d371583fc04930d29403715e308dae37','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTCTCCACGTGAACTGTCTGATCCGATTCGCGCCGTGACGCGTGCTGCGGGTTTGTAAAAGAATCTGCGGCGTGCGGGCTCGGCTGATCGAAGGTTTCATTGCTGCGAGCGTGTGCTTTTCGGAGCGCGCGTTTCGCGGCGGTGGGGCTGACTTACTCTTTCAAACCCCTTTACCGAATGACTGATGTATACT');
INSERT INTO marker_sequence VALUES(1118,'d636a898390f1f67ead7c9b89f8981a9','GTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACTGTCGTTATTTGTTGTGTGTCTGCGCGTTGCTGGCGTGCGTTTGCTTACGCTTCGGTGTTTGCGAGTGCGTGCTGGCGGTGCGCGGACTGAACGAAGGTCGTGTTGCTGTGTGCCTGCTGCACTGCTGACTTTGCATTGATTTGCATGGTCTTGGCGGAGCGGCGGGTGCTGTGCGTGCGCGGCTGACTTACTTTTTCAAACCCCATACCTAACTTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1119,'c80101a624355e7b0d5acfa4d9efeec4','TTTCCGTAGGTGAACCTGCGGAAAGGATCATTACCACACCTAAAAACTTTTCCACGTGAACTGTCGTTATTTGTTGTGCGCTCTCTGCGGTGTCGGTGGCGTCTGCTGGCTTTGTTGCTGGCGGGTGCGAGCCGGATGCGGAGGCTGAACGAAGGTCGAGTTGCTTTGCTCTCGGCTGACTTATTTTTCAAACCCAATACCAAACTTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1120,'2dde206f2f8713792ad2d0981ec52ce3','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTCAAACCTGTTCTGTGCTTGTGCTGGGTCTGCGTTTTCGGACGCGGACACGGCAGAGGCTGAACGAAGGCTGGTTTCATTTTGTATGAGATCAGCTGATATATTTTTCAAACCCCTTTTTTACAAAATGACTGATCAATACT');
INSERT INTO marker_sequence VALUES(1121,'e5030823938c92a7a7acc026fa7366eb','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTTCCACGTGAACTGTCGTTATTTGTTGTGTGTCTGCGCGTTGCTGGCGTGCGTTTGCTTACGCTTCGGTGTTTGCGAGTGCGTGCTGGCGGTGCGCGGACTGAACGAAGGTCGTGTTGCTGTGTGCCTGCTGCACTGCTGACTTTGCATTGATTTGCATGGTCTTGGCGGAGCGGCGGGTGCTGTGCGTGCGCGGCTGACTTACTTTTTCAAACCCCATACCTAACTTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1122,'28e86371815a60fe31bbf4c132568931','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTCGTTAATTTGTTGTGTGTCTGCGCGTTGCTGGCGTGCGTTTGCTTACGCTTCGGTGTTTGCGAGTGCGTGCTGGCGGTGCGCGGACTGAACGAAGGTCGTGTTGCTGTGTGCCTGCTGCACTGCTGACTTTGCATTGATTTGCATGGTCTTGGCGGAGCGGCGGGTGCTGTGCGTGCGCGGCTGACTTACTTTTTCAAACCCCATACCTAACTTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1123,'9cad459ca58c620f864313d86d185a01','GTTCGTAGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACTGTCGTTATTTGTTGTGTGTGTGCGTGTTGGTAGCATGCGTGTTTGCTTACGCTTTGGTGTTTGCGAGTGTGTGTGTTGTCGGTGCGCAGACTGAACGAAGGTCGTGTGTTGCTGTGTGCCTGCTGCACTGCTGACTTTGCATTGATTTGCATGGTGTTGGCGGAGCGGCGGGTGCTGTTGCGTGCGCGGCTGACCTATTTTTTTCAAACCCCATACCTAAATGACTGATTATACT');
INSERT INTO marker_sequence VALUES(1124,'a91fc675a99a1c210680b44cd9a737d4','TTTCCGTAGGTGAACCTGCGGAAGGATCATTTCCACCCTAAAAAAACTATCCACGTGAACCGTTAAGCAAACAAGTTAAGGCAGGCGCGATTGATGGTGCGTCTGGGAAGCGCTTGTCGATATTCGATCGGATCGGATATTGTCGGGCGTCGTCCTGGACACGCTGTCGAGCGGAGTCGGCTAAACGAAGGTCGGGCGTTCGCTATCGGAGCGATGTGCGCGTTGTCGCACGTTGCTGCAATGGCTCGAGCAAGCGGCTGATTTATGTCTTTCAAACCATACGTGACGTACTGATGATACT');
INSERT INTO marker_sequence VALUES(1125,'b9e61de9a0d698e44e6496aaa83dfca0','GTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACTGTCGTTATTTGTTGTGTGTGTGCGTGTTGGTAGCATGCGTGTTTGCTTACGCTTTGGTGTTTGCGAGTGTGTGTGTTGTCGGTGCGCAGACTGAACGAAGGTCGTGTGTTGCTGTGTGTCTGCTGCACTGCTGACTTTGCATTGATTTGCATGGTGTTGGCGGAGCGGCGGGTGCTGTTGCATGCGCGGCTGACCTATTTTTTTCAAACCCCATACCTAAATGACTGATTATACT');
INSERT INTO marker_sequence VALUES(1126,'6c4250731d93688c81061d325f992994','GTTCCGTAGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACTGTCGTTATTTGTTGTGTGTCTGCGCGTTGCTGGCGTGCGTTTGCTTACGCTTCGGTGTTTGCGAGTGCGTGCTGGCGGTGCGCGGACTGAACGAAGGTCGTGTTGCTGTGTGCCTGCTGCACTGCTGACTTTGCATTGATTTGCATGGTCTTGGCGGAGCGGCGGGTGCTGTGCGTGCGCGGCTGACTTACTTTTTCAAACCCCATACCTAACTTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1127,'35cf41da0aa1e76a1ad2671a378ba538','GTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTCTCCACGTGAACTGTCTGATCCGATTCGCGCCGTGACGCGTGCTGCGGGTTTGTAAAAGAATCTGCGGCGTGCGGGCTCGGCTGATCGAAGGTTTCATTGCTGCGAGCGTGTGCTTTTCGGAGCGCGCGTTTCGCGGCGGTGGGGCTGACTTACTCTTTCAAACCCCTTTACCGAATGACTGATGTATACT');
INSERT INTO marker_sequence VALUES(1128,'89fd46421645b08cd96357c715ad8fdd','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTTCCACGTGAACTGTCGTTAATTTGTTGTGTGTCTGCGCGTTGCTGGCCATGCGTTGCTTACGCTTCGGTGTTTGCGAGTGCGTGCTGGCGGTGCGCGGACTGAACGAAGGTCGTGTTGCTGTGTGCCTGCTGCACTGCTGACTTTGCATTGATTTGCATGGTCTTGGCGGAGCGGCGGGTGCTGTGCGTGCGCGGCTGACTTACTTTTTCAAACCCCATACCTAACTTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1129,'52695afec93993744b2fce322a20dc9c','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTCTCCACGTGAACTGTCTGATCCGATTCGCGCCGTGACGCGTGCTGCGGGTTTGTAAAAGAATCTGCGGCGTGCGGGCTCGGCTGATCGAAGGTTTCATTGCTGCGAGCGTGTGCTTTTCGGAGCGCGCGTTTCGCGGCGGTGGGGCTGACTTACTCTTTCAAACCCCTTTACCGAATGACTGATGTATACT');
INSERT INTO marker_sequence VALUES(1130,'c3c758cd4b717757735b0de0c4c02c4e','TTTCCGTAGTGAAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTCGTTATTTGTTGTGTGTCTGCGCGTTGCTGGCGTGCGTTTGCTTACGCTTCGGTGTTTGCGAGTGCGTGCTGGCGGTGCGCGGACTGAACGAAGGTCGTGTTGCTGTGTGCCTGCTGCACTGCTGACTTTGCATTGATTTGCATGGTCTTGGCGGAGCGGCGGGTGCTGTGCGTGCGCGGCTGACTTACTTTTTCAAACCCCATACCTAACTTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1131,'bf58c877f4d1c1ea9c244231af8f8393','TTTCCGTAGGTGAACTTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTCGTTATTTGTTGTGTGTCTGCGCGTTGCTGGCGTGCGTTTGCTTACGCTTCGGTGTTTGCGAGTGCGTGCTGGCGGTGCGCGGACTGAACGAAGGTCGTGTTGCTGTGTGCCTGCTGCACTGCTGACTTTGCATTGATTTGCATGGTCTTGGCGGAGCGGCGGGTGCTGTGCGTGCGCGGCTGACTTACTTTTTCAAACCCCATACCTAACTTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1132,'855f433ad9e8fa5cd443364004a9685d','TTTCCGTAGTGAAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTCGTTATTTGTTGTGTGTCTGCGCGTTGTTGGCGTGCGTTTGCTTACGCTTCGGTGTTTGCGAGTGCGTGCTGGCGGTGCGCGGACTGAACGAAGGTCGTGTTGCTGTGTGCCTGCTGCACTGCTGACTTTGCATTGATTTGCATGGTCTTGGCGGAGCGGCGGGTGCTGTGCGTGCGCGGCTGACTTACTTTTTCAAACCCCATACCTAACTTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1133,'f268cae65b460b15a2c4db1bb2d1bfc5','TTCCGTAGGTGAACTTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTCGTTATTTGTTGTGTGTCTGCGCGTTGCTGGCGTGCGTTTGCTTACGCTTCGGTGTTTGCGAGTGCGTGCTGGCGGTGCGCGGACTGAACGAAGGTCGTGTTGCTGTGTGCCTGCTGCACTGCTGACTTTGCATTGATTTGCATGGTCTTGGCGGAGCGGCGGGTGCTGTGCGTGCGCGGCTGACTTACTTTTTCAAACCCCATACCTAACTTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1134,'edf0c7a634502faf4f9d232a99571760','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTCAAACCTGTTCTGTGCTTGTTCTGGGTCTGCGTTTTCGGACGCGGACGCGGCGGAGGCTGAACGAAGGCTGGTTTCATTTGTATGAGATCAGCTGATATATTTTTTCAAACCCCTTTTTTACAAAATGACTGATCAATACT');
INSERT INTO marker_sequence VALUES(1135,'6b5883a64672779d24b72660da6225fc','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTCGTTATTTGTTGTGTGTCTGCGCGTTGCTGGCGTGCGTTTGCTTACGCTTCGGTGTTTGCGAGTGCGTGCTGGCGGTGCGCGGACTGAACGAAGGTCGTGTTGCTGTGTGCCTGCTGCACTGCTGACTTTGCATTGATTTGCATGGTCTTGGCGGAGCGGCGGGTGCTGTGCGTGCGCGGCTGACTTACTTTTTCAAACCCCCATACCTAACTTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1136,'513d146954bdf15d68acff990f4523ef','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACTGTCGTTATTTGTTGTGTGTGTGCGTGTTGGTAGCATGCGTGTTTGCTTACGCTTTGGTGTTTGCGAGTGTGTGTGTTGTCGGTGCGCAGACTGAACGAAGGTCGTGTGTTGCTGTGTGCCTGCTGCACTGCTGACTTTGCATTGATTTGCATGGTGTTGGCGGAGCGGCGGGTGCTGTTGCGTGCGCGGCTGACCTATTTTTTTCAAACCCCCATACCTAAATGACTGATTATACT');
INSERT INTO marker_sequence VALUES(1137,'abb1f4973135157608b36d0efe4e27c0','TTTCCGTAGGTGAACCTGCGGAAGGATCATTCCCACACCTAAAAAACTTTCCACGTGAACTGTCGTTATTTGTTGTGTGTCTGCGCGTTGCTGGCGTGCGTTTGCTTACGCTTCGGTGTTTGCGAGTGCGTGCTGGCGGTGCGCGGACTGAACGAAGGTCGTGTTGCTGTGTGCCTGCTGCACTGCTGACTTTGCATTGATTTGCATGGTCTTGGCGGAGCGGCGGGTGCTGTGCGTGCGCGGCTGACTTACTTTTTCAAACCCCATACCTAACTTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1138,'77c3b80487c662e00870010ffb1a8d5c','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACTGTCGTTATTTGTTGTGTGTCTGCGCGTTGCTGGCGTGCGTTTGCTTACGCTTCGGTGTTTGCGAGTGCGTGCTGGCGGTGCGCGGACTGAACGAAGGTCGTGTTGCTGTGTGCCTGCTGCACTGCTGACTTTGCATTGATTTGCATGGTCTTGGCGGAGCGGCGGGTGCTGTGCGTGCGCGGCTGACTTACTTTTTCAAACCCCATACCTAACTTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1139,'d892aaf9c9c2c30121442d00ed07c9e1','TTTCCGTAGGTGAACCTGCGGAAGGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTCGTTATTTGTTGTGTGTCTGCGCGTTGCTGGCGTGCGTTTGCTTACGCTTTCGGTGTTTGCGAGTGCGTGCTGGCGGTGCGCGGACTGAACGAAGGTCGTGTTGCTGTGTGCCTGCTGCACTGCTGACTTTTGCATTGATTTGCATGGTCTTGGCGGAGCGGCGGGTGCTGTGCGTGCGCGGCTGACTTACTTTTTTCAAAACCCCCATACCTAACTTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1140,'f2e1788d9b40b9b242a355d027cec3d8','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTCGTTATTTGTTGTGTGTCTGCGCGTTGCTGGCGTGCGTTTGCTTACGCTTCGGTGTTTGCGAGTGCGTGCTGGCGGTGCGCGGACTGAACGAAGGTCGTGTTGCTGTGTGCCTGCTGCACTGCTGACTTTGCATTGATTTGCATGGTCTTGGCGGAGCGGCGGGTGCTGTGCGTGCGCGGCTGACTTACTTTTTCAAACCCCATACCTAACTTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1141,'3abc056cbd37697057cfa13e80ea526c','TTTCCGTAGGTGAAACCTGCGGAAGGGATCATTACCCACACCTAAAAAAACTTTCCCACGTGAAACTGTCGTTATTTTGTTGTGTGTCTGCGCGTTTGCTGGCGTGCGTTTTGCTTACGCTTCGGTGTTTGCGAGTGCGTGCTTGGCGGTGCGCGGACTGAACGAAGGTCGTGTTGCTGTGTGCCTGCTGCACTGCTGACTTTTGCATTGATTTGCATGGTCTTGGCGGAGCGGCGGGTGCTGTGCGTGCGCGGCTGACTTACTTTTTCAAACCCCATACCTAACTTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1142,'7d2c0766a9983b080dbe7a33059c6646','GTTCCGTAGGTGAACCTGCGGAAAGGATCATTACCAACACCTAAAAAACTTTCCCACGTGAACTGTCGTTATTTGTTGTGTGTCTGCGCGTTGCTGGCGTGCGTTTGCTTACGCTTCGGTGTTTGCGAGTGCGTGCTGGCGGTGCGCGGACTGAACGAAGGTCGTGTTGCTGTGTGCCTGCTGCACTGCTGACTTTGCATTGATTTGCATGGTCTTGGCGGAGCGGCGGGTGCTGTGCGTGCGCGGCTGACTTACTTTTTTCAAACCCCCATACCTAACTTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1143,'a32e45b9ee2bf37361acb754e3c84c41','TTTCCGTAGGTGAACCTTGCGGAAAGGATCATTACCCACACCTAAAAAAACTTTCCACGTGAACTGTCGTTATTTGTTGTGTGTCTGCGCGTTGCTGGCGTGCGTTTGCTTACGCTTCGGTGTTTGCGAGTGCGTGCTGGCGGTGCGCGGACTGAACGAAGGTCGTGTTGCTGTGTGCCTGCTGCACTGCTGACTTTGCATTGATTTGCATGGTCTTGGCGGAGCGGCGGGTGCTGTGCGTGCGCGGCTGACTTACTTTTTTCAAACCCCATACCTAACTTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1144,'a1445fca3d00884d1a921b785359a3c4','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCCACGTGAACTGTCGTTATTTGTTGTGCGCTCTCTGCGGTGTCGGTGGCGTCTGCTGGCTTTGTTGCTGGCGGGTGCGAGCCGGATGCGGAGGCTGAACGAAGGTCGAGTTGCTTTGCTCTCGGCTGACTTATTTTTCAAACCCAATACCAAACTTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1145,'ad4b7954375a5138b52c4f4441248437','TTTCCGTAGGTGAACCTGCGGAAGGGATCATTACCACACCCAAAAAAAACTTTTCCACGTGAACCGTTTTGTGCGTTTTGTGCTTTGTGTTTGCTTTTGTTTGTCTCGCTCTTCGGGGTGTGGTGGACAAGAGGAAGCGCAAGGCTAAACGAAGGCTGCGAGTCTCGTGCTTGCGGCCGATTTATTCTTTCAAACCCATACATTAAACACTGAACTATACT');
INSERT INTO marker_sequence VALUES(1146,'b1a78606429cba59e5068a3b38a47239','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTCAAACCTGTTCTGTGCTTGTGCTGGGTCTGCGTTTTCGGATGCGGACGCGGCGGAGGCTGAACGAAGGCTGGTTTCATTTGTATGAGATCAGCTGATATATTTTTTCAAACCCCTTTTTTACAAAATGACTGATCAATACT');
INSERT INTO marker_sequence VALUES(1147,'fc491a8f4c84dfc00c7992674fd0f176','GTTCCGTAGGTGAACATGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTCAAACCTGTTCTGTGCTTGTGCTGGGTCTGCGTTTTCGGACGCGGACGCGGCGGAGGCTGAACGAAGGCTGGTTTCATTTGTATGAGATCAGCTGATATATTTTTTCAAACCCCTTTTTTACAAAATGACTGATCAATACT');
INSERT INTO marker_sequence VALUES(1148,'eb1532e4c3ea43f14263521680982abc','TTCGTAGTGAACCTGCGGAAGGATCATTACCCACACCTAAAAAAACTTTCCCACGTGAACTGTCGTTATTTGTTGTGTGTCTGCGCGTTGCTGGCGTGCGTTTGCTTACGCTTCGGTGTTTGCGAGTGCGTGCTGGCGGTGCGCGGACTGAACGAAGGTCGTGTTGCTGTGTGCCTGCTGCACTGCTGACTTTGCATTGATTTGCATGGTCTTGGCGGAGCGGCGGGTGCTGTGCGTGCGCGGCTGACTTACTTTTTCAAACCCCATACCTAACTTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1149,'c44996d6c6bed10dd243f9708c910235','TTTCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTCAAACCTGTTCTGTGCTTGTGCTGGGTCTGCGTTTTCGGACGCGGACGCGGCGGAGGCTGAACGAAGGCTGGTTTCATTTGTATGAGATCAGCTGATATATTTTTTCAAACCCCTTTTTTACAAAATGACTGATCAATACT');
INSERT INTO marker_sequence VALUES(1150,'de3e7a804f30625808565796c8924491','GTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTCAAACCTGTTCTGTGCTTGTGCTGGGTCTGCGTTTTCGGACGCGGACGCGGCGGAGGCTGAACGAAGGCTGGTTTCATTTGTATGAGATCAGCTGATATATTTTTTCAAACCCCTTTTTTACAAAATGACTGATCAATACT');
INSERT INTO marker_sequence VALUES(1151,'e22c4c4875a52883adf8f290b0e943d1','TTTCCGTAGGTGAACCTGCGGAAAGGATCATTACCACACCTAAAAAACTCTCCACGTGAACTGTCTGATCCGATTCGCGCCGTGACGCGTGCTGCGGGTTTGTAAAAGAATCTGCGGCGTGCGGGCTCGGCTGATCGAAGGTTTCATTGCTGCGAGCGTGTGCTTTTCGGAGCGCGCGTTTCGCGGCGGTGGGGCTGACTTACTCTTTCAAACCCCTTTACCGAATGACTGATGTATACT');
INSERT INTO marker_sequence VALUES(1152,'4a6958a27c015fa0c539c56bc699f9b9','TTTCCGTAGGTGAACCTGCGGAAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTCGTTATTTGTTGTGTGTCTGCGCGTTGCTGGCGTGCGTTTGCTTACGCTTCGGTGTTTGCGAGTGCGTGCTGGCGGTGCGCGGACTGAACGAAGGTCGTGTTGCTGTGTGCCTGCTGCACTGCTGACTTTGCATTGATTTGCATGGTCTTGGCGGAGCGGCGGGTGCTGTGCGTGCGCGGCTGACTTACTTTTTCAAACCCCATACCTAACTTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1153,'5959c180cc6bd1e44810fd57b975981e','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACTTTAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTAACTGATCTAGTGTTTTCCTATTTTTGGGACACTGGAATACAGGATTCAGCAGGACGAAGGTTAGTCTCTCGTAATGCAAATTAGGAGGACTAGCTGATGAACTTTTCTTTTTAAACCCTTACCTAAATACTGATTTATACT');
INSERT INTO marker_sequence VALUES(1155,'084f3bcc2638c0936ee0f30343a4be6d','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACACCCTTCCACGTGAACCGTTTTGTTTTGCTTTCGAGTGCTTTGTTGCGCTCGGAGCATGTTTGGGCTTCGCTGCTGGCGCTTGATTGTGCTGGCGGCTCGAGGCCATCAAGCGGCGTTTTGAGTGCTTGCACAATTAACGTCCAAACCTTTTAAACCCATTTGATTGAAAACTGAAGTATACT');
INSERT INTO marker_sequence VALUES(1156,'faeb53445fe42c7c6629309cb0e95f6e','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAATCTTTCCACGTGAATTGTTTTGTACACTGTTGGGTTTCGCTGGCGCGTGTTTTCTTGTCGAATGTAGTGTTTGACGGCGCGCGGCGGCTGGAGGCCATCAGGGCGTCTGTTGTTGTGATGGACGCTCTTTTTGTAAACCCCCTTTTTTTTTATTTTGTGAAACTGATTGGACT');
INSERT INTO marker_sequence VALUES(1157,'82a84fb62742c2dd370401c8a4c3f34b','TTTCAGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAATCTTTCCACGTGAACCGTATCAACCCCCTTCGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGGCGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCCCTATTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(1158,'df9d3e9c1f49c6b45fb43077fb35d708','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAATAACACCCTTCCACGTGAACCGTTCTGTTTTGCTTTCGAGTGCTTTGTTGCGCTCGGAGCATGTTTTGGGCTTCGCTGCTGGCGCTTGATTGTGCTGGCGGCTCGAGGCCATCAAGTGGCGTTCTGAGTGTGCTTTGCGCAATTGAAACGTCGAAACCTTTTTTTTAAACCCATTTGATTGAAAACTGAAGTATACT');
INSERT INTO marker_sequence VALUES(1159,'a08e4a202160b94cecaf814f9e4aaa69','TTTCCGTAGGTGAACCTGCGGAAGGATCATTTCCCACACCTAAAAAACACCCTTCCACGTGAACCGTTTTGTTTTGCTTTCGAGTGCTTTGTTGCGCTCGGAGCATGTTTTGGGCTTCGCTGCTGGCGCTTGATTGTGCTGGCGGCTCGAGGCCATCAAGTGGCGTTTTGAGTGTGCTTTGCGCAATTGAAACGTCGAAACCTTTTTTTTAAACCCATTTGATTGAAAACTGAAGTATACT');
INSERT INTO marker_sequence VALUES(1160,'f6b4a1cb2cea8ff4659ec51c1489d23a','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAATTGGGGATTTGCTTGGTGTGCGGCTAGCTGGCCTTTATTGGCTGGCAGGCTGCGTGCTGGGCGAGTCCTATCATGGCAAACGTTTGGGCTTCGGTCTGAGCAAGTAGCTTTTTTTAAACCATTTCTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(1161,'fd86e8ee2cab3b478ceeeee5cbeaf4f2','GTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGATGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(1162,'e59f3460fb7785d83ed77f178f83117f','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATAATTTGGGGGTTAATTTGGTAATGGCTGCTGGCATCTTTTTGCTGGCTGGCTGTTACTGAGTAAGCCCTATCATGGCGAGAGTTTGGACCTTTGTCTGAACAAGTAGCTACGATTGTAAACCCTTTCTTAATTACTGAATATACT');
INSERT INTO marker_sequence VALUES(1163,'caa2893d0eb5a4f368078ada4b94f643','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAAACCCGTWTCAACCCAATAWTTTGGGGGTTAATTTGGTAATGGCTGCTGGCATCTTTTTGCTGGCTGGCTGTTACTGAGTAAGCCCTATCATGGCGAGAGTTTGGACCTTTGTCTGAACAAGTAGCTACGATTGTAAACCCTTTCTTAATTACTGAATATACT');
INSERT INTO marker_sequence VALUES(1164,'8ce34b6a6687e801135420f9a6142690','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTAACAAACCAATAGTTGGGGGCGAGTTTGGCGGCTGTTGCTGCTGGACGAGCTCTATCATGGCGAGCGTTTGGACTTCGGTCTGAACTAGTAGCCCTTCTTTTAAACCCATTCCTAATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1165,'90185ec7af557bbf42427e24cd41f8e7','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATTAATTGGGGGTTTACTTGGCGGCGGCTGCTGGCATAGTTTTGCTGGCTGCTGCTGCCGAGTGAGCCCTATCATGGCGAGTGTTTGGACCTCGGTCTGAGCTAGTAGCTTTAATTTCAAACCCATTCTTAATTACTGAATATACT');
INSERT INTO marker_sequence VALUES(1166,'77afb165ed2e7caeca7f24a9ebc1f86c','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATAATTTGGGGGTTAATTTGGTAATGGCTGCTGGCATCTTTTTGCTGGCTGGCTGTTACTGAGTAAGCCCTATCATGGCGAGAGTTTGGACCTTTGTCTGAACAAGTAGCTACGATTGTAAACACTTTCTTAATTACTGAATATACT');
INSERT INTO marker_sequence VALUES(1167,'d05cfc7afc0c835e1bd9810002fefb71','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATAATTTGGGGGTTAATTTGGTAATGGCTGCTGGCATCTTTTTGTTGGCTGGCTGTTACTGAGTAAGCCCTATCATGGCGAGAGTTTGGACCTTTGTCTGAACAAGTAGCTACGATTGTAAACCCTTTCTTCATTACTGAATATACT');
INSERT INTO marker_sequence VALUES(1168,'03c1551f4098935690ea8d879bbe01db','TTTCCGTAGGTGAACCTGCGGAAGGATCATTCCCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCCATACATTGGGGGCTAATTTGCCCTACCATGGCGAGTGTTTGGACTTCGGTCTGAATTAGTAGCTTGAATTGTAAACCCTTTCCTAATTACTGAATATACT');
INSERT INTO marker_sequence VALUES(1169,'075892f9e6b64c0b394d6cca9c054485','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTTCACGTGAACCGTATCAAACACTTTATTGGGGGCTGACTTGGTGGCGGCTGCTGGTATCTATTTTTTTACTGACTGGCTGCTGCTTTGAGAAAGCCCTATCATGGCGATCGCTTGGACTTATATTCGAGCTAGTAGCTACTATTTTAAACCCATTCTTAATTACTGAATATACT');
INSERT INTO marker_sequence VALUES(1170,'85fe415b12c6552982281f36c0628882','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGAGCTTGTTTGGCGGCGTGTGTGTTGGCCTGTTAAGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGATCGTTTTGGGCTTCGGCTCGAGCGAGTAGCTTTAATTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO marker_sequence VALUES(1171,'fd155ae5799b1a8b36885827fad77fd0','CTTCCGTAGGGTGACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTCTGTATTTGTTGTGTGTCTGTGCGTGCTGGCGTGCGTTTTGCGTGCCGGCGTGTGCGGACTGAACGAAGGTCGTGTCGCTGTGCGGCTGACTTCTTTTTCAAACCCCATACGTAAATGACTGATTATACT');
INSERT INTO marker_sequence VALUES(1172,'389db2cedc1847cdab796af43fa0753a','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTTCAAAATTTAGTTGGGGGTCTTTTTCGGCGACGGCTGCTGGCTTCATTGCTGGTGGCTGTTGTTGGACGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCATTATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1173,'303f97b0ef55cd727448ab47d1eb6ecb','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTTCAAAATTTAGTTGGGGGTCTTTTTCGGCGACGGCTGCTGGCTTCATTGCTGGTGGCTGTTGTTGGACGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCATTATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1174,'c2a49809ff5c007215e9930089cbde9c','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTTCAAAATTAAGTTGGGGGTCTTTTTCGGCGACGGCTGCTGGCTTCATTGCTGGTGGCTGTTGTTGGACGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCATTATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1175,'9e66292bf57505d45468b05dd41a952c','TTTCCGTAGGTGAACCTGCGGAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTTCAAAATTTAGTTGGGGGTCTTTTTCGGCGACGGCTGCTGGCTTCATTGCTGGTGGCTGTTGTTGGACGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCATTATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1176,'cafbd617a91c7cd7237e2a1abd0537c7','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAATCTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(1177,'4eb736bccc03228c9d26a7947ca998cf','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAATCTTTCCCGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(1178,'ad12baaa7843a74d3ad851c437ebdb82','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(1179,'b2926ecff45a634f167244f4dd6e3e69','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCACGTGAACCCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(1180,'5a8c4268a91e6bb0aa4661e20f359b19','TTCCGTAGGGTGACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTCAAACCTGTTCTGTGCTTGTGCTGGGTCTGCGTTTTCGGACGCGGACGCGGCGGAGGCTGAACGAAGGCTGGTTTCATTTTGTATGAGATCAGCTGATATACTTTTTCAAACCCCTTCTTTTACAAAATGACTGATGAATACT');
INSERT INTO marker_sequence VALUES(1181,'fec3ed7929b8c7378c6c9dc0f4afdfce','TTCCGTAGGGTGACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTCAAACCTGTTCTGTGCTTGTGCTGGGTCTGCGTTTTCGGACGCGGACGCGGCGGAGGCTGAACGAAGGCTGGTTTCATTTGTATGAGATCAGCTGATATATTTTTTCAAACCCCTTTTTTACAAAATGACTGATCAATACT');
INSERT INTO marker_sequence VALUES(1182,'43bd9bcbfa6f070215e142eaeeb9b67c','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTTTAATTTGGGGGCTTGTTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCACTTTTAAACTCCTTTCTTAAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(1183,'e06f12ffa0d39a27e61fbdf4b69e631e','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCTGCCGTTCGCGGCGGCTCCATCAAACGAGGCTCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTNCTTTATTTTCTGATCATACT');
INSERT INTO marker_sequence VALUES(1184,'312a8c106c3bba28ec0550e1991756a4','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTNCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGNGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(1185,'1bec8fbd147dc77e10fdf850fa2064ed','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCAACAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(1186,'5025b608a8298ba088ad09e497598208','TTCCGTAGGGTGACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(1187,'744ba4681d0c75c64dada316de98f885','TTTCGTAGGTGAACCTGCGGAAAGGATCATTACCCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(1188,'6acdafa593dce6702d292f27b2336942','TTTCCGTAAGGGTGACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(1189,'46f9fbe531ea4cc217088c772823d949','TCCGTAGGGTAACCTGAGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(1190,'03df7e22cd7f9835924ae4937ad1ae72','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTCGTTATTTGTTGTGTGTCTGCGCGTTGCTGGCGTGCGTTTGCTTACGCTTCGGTGTTTGCGAGTGCGTGCTGGCGGTGCGCGGACTGAACGAAGGTCGTGTTGCTGTGTGCCTGCTGCACTGCTGACTTTGCATTGATTTGCATGGTCTTGGCGGAGCGGCGGGTGCTGTGCGTGCGCGGCTGACTTACNTTTTCAAACCCCATACCTAACTTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1191,'a86d761e70cbbdd48232a269d5ad93d6','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTCGTTANTTGTTGTGTGTCTGCGCGTTGCTGGCGTGCGTTTGCTTACGCTTCGGTGTTTGCGAGTGCGTGCTGGCGGTGCGCGGACTGAACGAAGGTCGTGTTGCTGTGTGCCTGCTGCACTGCTGACTTTGCATTGATTTGCATGGTCTTGGCGGAGCGGCGGGTGCTGTGCGTGCGCGGCTGACTTACNTTTTCAAACCCCATACCTAACTTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1193,'0b4fcfd6140b2540b97ff2cebd58db02','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACACCCTTCCACGTGAACCGTTTTGTTTTGCTTTCGAGTGCNTTGTTGCGCTCGGAGCATGTTTGGGCTTCGCTGCTGGCGCTTGATTGTGCTGGCGGCTCGAGGCCATCAAGTGGCGTTTTGAGTGTGTGTTCGCATACAATTAAAACGTCCAAACCTTTTAAACCCATTTGATTGAAAACTGAAGTATACT');
INSERT INTO marker_sequence VALUES(1194,'6dac899b75ce53c7900abbec1d9ff0c7','GTTCCGTAGGGAACCTGCGGAAGGATCATTACCACACTTTAAAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTGACTGAGCTGGTGTTTTCATTTTTGGACACTGGAACGGGAGTCAGCAGGACGAAGGTTGGTCTGTTGTAATGCAAGTTATGATGGACTAGCTGATGAACTTTTGTTTTTAAACCCTTACCTAAATACTGATTTATACT');
INSERT INTO marker_sequence VALUES(1195,'e9a2ed7e0431859067b6ffc2bb8ba105','TTTCCGTAGGTAACCTGCGGAAGGATCATTCCCCCCCTAAAAACTTTCCACGGAACTGTCGTTATTTGTTTGTGTCTGCGCGTTGCTGGCGTGCGTTTGCTTACGCTTCGGTGTTTGCGAGTGCGTGCTGGCGGTGCGCGGACTGAACGAAGGTCGTGTTGCTGTGTGCCTGCTGCACTGCTGACTTTGCATTGATTTGCATGGTCTTGGCGGAGCGGCGGGTGCTGTGCGTGCGCGGCTGACTTACTTTTTCAAACCCCATACCTAACTTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1196,'0d6ae6d79f75acf168f543e3ccd426fa','TTCCGTAGGTAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTCGTTATTTGTTGTGTGTCTGCGCGTTGCTGGCGTGCGTTTGCTTACGCTTCGGTGTTTGCGAGTGCGTGCTGGCGGTGCGCGGACTGAACGAAGGTCGTGTTGCTGTGTGCCTGCTGCACTGCTGACTTTGCATTGATTTGCATGGTCTTGGCGGAGCGGCGGGTGCTGTGCGTGCGCGGCTGACTTACTTTTTCAAACCCCATACCTAACTTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1197,'7c215b6179d17ddcdb386bd01e691378','TTTCGTAGGGAACCTGCGGAAGGATCATTACCACACCTAAAAACTCTCCACGTGAACTGTTCGTATAAGATTAGCGCCGAGATTTTCGTGCGTGTTTGTGGTATCGCTATGTATTCGTACGTGGCGTTAGCAAGCATTGTATGGAGCTTGGCTGATCGAAGGTCGGTGTGCACCTTGTGTGTGTATCGGCTGATTAACCTTTCAAACCCTTTAAATTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(1198,'512721f332d1d8d2b76997dd281d457f','GTTCGTAGGGAACCTGCGGAAGGATCATTACCACACCTAAAAACTCTCCACGTGAACTGTTCGTATAAGATTAGCGCCGAGATTTTCGTGCGTGTTTGTGGTATCGCTATGTATTCGTACGTGGCGTTAGCAAGCATTGTATGGAGCTTGGCTGATCGAAGGTCGGTGTGCACCTTGTGTGTGTATCGGCTGATTAACCTTTCAAACCCTTTAAATTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(1199,'3172ad37a07926906d88d22317b0d826','TTTCGTAGGTAACCTGCGGAAGGATCATTACCACACCTAAAAACTCTCCACGTGAACTGTTCGTATAAGATTAGCGCCGAGATTTTCGTGCGTGTTTGTGGTATCGCTATGTATTCGTACGTGGCGTTAGCAAGCATTGTATGGAGCTTGGCTGATCGAAGGTCGGTGTGCACCTTGTGTGTGTATCGGCTGATTAACCTTTCAAACCCTTTAAATTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(1200,'494ebc22952d9af02324e88fc56e0428','GTTCGTAGGTAACCTGCGGAAGGATCATTACCACACCAAAAACAACTTTCCACGTGAACTGTCTTACGAGATTCGCGCCGTGACGCGTGTTGGCGCTGTGTGTGTCTGTGTCTTCTTTCGAGAGGATATTGTGATGCAAACAGTGTTGACCGTGTGGGTCGGCTGATCGAAGGTCGCTTTGTGCATTATTGTATGGAGCGGCTGACTTATTCTTTCAAACCCATTACACAATACTACTGATTCATACT');
INSERT INTO marker_sequence VALUES(1201,'a64c4ae066e89ab715e04d0dfafbe8d9','GTTCCGTAGGTAACCTGCGGAAGGATCATTACCACACCAAAAACAACTTTCCACGTGAACTGTCTTACGAGATTCGCGCCGTGACGCGTGTTGGCGCTGTGTGTGTCTGTGTCTTCTTTCGAGAGGATATTGTGATGCAAACAGTGTTGACCGTGTGGGTCGGCTGATCGAAGGTCGCTTTGTGCATTATTGTATGGAGCGGCTGACTTATTCTTTCAAACCCATTACACAATACTACTGATTCATACT');
INSERT INTO marker_sequence VALUES(1202,'61374361fcbdf735b480859bdb9be824','TTTCCGTAGGGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTCAAACCTGTTCTGTGCTTGTGCTGGGTCTGCGTTTTCGGACGCGGACACGGCAGAGGCTGAACGAAGGCTGGTTTCATTTTGTATGAGATCAGCTGATATATTTTTCAAACCCCTTTTTTACAAAATGACTGATCAATACT');
INSERT INTO marker_sequence VALUES(1203,'daec24144dd9b409f3c000ab8ec9c878','TTTCCGTAGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTCAAACCTGTTCTGTGCTTGTGCTGGGTCTGCGTTTTCGGACGCGGACACGGCAGAGGCTGAACGAAGGCTGGTTTCATTTTGTATGAGATCAGCTGATATATTTTTCAAACCCCTTTTTTACAAAATGACTGATCAATACT');
INSERT INTO marker_sequence VALUES(1204,'484f182eea06318bbb8a11be7b6c2016','TTTCCGTAGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTCAAACCTGTTCTGTGCTTGTGCTGGGTCTGCGTTTTCGGACGCGGACACGGCAGAGGCTGAACGAAGGCTGGTTTCATTTTGTATGAGATCAGCTGATATATTTTTTCAAACCCCTTTTTTACAAAATGACTGATCAATACT');
INSERT INTO marker_sequence VALUES(1205,'25df7ccdea6c54d2aee64d1b545f1d7e','TTTCCGTAGGTGACCTGCGGAAGGATCATTACCACACCTTAAAACTATCCACGTGAACCGTTTGTACCCAGATTTGCGCCGAGATTTTCGTGCGTGTTTGTTTGTATCACTGTGTATTCGTACGCAGTGTGTGGCAAATATGTATGGAGCTTGGCTGATCGAAGGTCGTATCGCACTTTATTGTGTGTGTCGGCTGACTTATTTTTCAAACCCATTACTTACTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1206,'8d9f501ed50d6e798c8ead01b438b5ab','TTTCGTAGGGAACCTGCGGAAGGATCATTACCACACCTTAAAACTATCCACGTGAACCGTTTGTACCCAGATTTGCGCCGAGATTTTCGTGCGTGTTTGTTTGTATCACTGTGTATTCGTACGCGGTGTGTGGCAAATATGTATGGAGCTTGGCTGATCGAAGGTCGTATCGCACTTTATTGTGTGTGTCGGCTGACTTATTTTTCAAACCCATTACTTACTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1207,'802646564a7670679fca372447cfa623','GTTCCGTAGGTGACCTGCGGAAGGATCATTACCACACCTTAAAACTATCCACGTGAACCGTTTGTATGAAGATTTGCGCCGAGATGTTTGTGCGTGTTTGTTGTATCACTGTGTGTTCGTACGCGGTGTGTGGCAAGTATGTATGACGCTTGGCTGATCGAAGGTCGATATGCACTTGATTGTGTGTGTCGGCTGACTTATTTTTCAAACCCATTCTACAGTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1208,'464fb2453ed1bf80f0f3a4be2615a77a','TTTCCGTAGGTGACCTGCGGAAGGATCATTACCACACCTTAAAACTATCCACGTGAACCGTTTGTATGAAGATTTGCGCCGAGATGTTTGTGCGTGTTTGTTGTATCACTGTGTGTTCGTACGCGGTGTGTGGCAAGTATGTATGACGCTTGGCTGATCGAAGGTCGATATGCACTTGGTTGCGTGTGTCGGCTGACTTATTTTTCAAACCCATTCTACAGTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1209,'e07ca9536f1d7933e30514b718c24405','GTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTTAAAACTATCCACGTGAACCGTTTGTATGAAGATTTGCGCCGAGATGTTTGTGCGTGTTTGTTGTATCACTGTGTGTTCGTACGCGGTGTGTGGCAAGTATGTATGACGCTTGGCTGATCGAAGGTCGATATGCACTTGATTGTGTGTGTCGGCTGACTTATTTTTCAAACCCATTCTACAGTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1210,'904a5aecace708dc17e059afc51523c9','TTTCCGTAGGTGAACCTGCGGAAGGATCATTCCCACACTTTAAAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTGACTGAGCTGGTGTTTTCATTTTTGGACACTGGAACGGGAGTCAGCAGGACGAAGGTTGGTCTGTTGTAATGCAAGTTATGATGGACTAGCTGATGAACTTTTGTTTTTAAACCCTTACCTAAATACTGATTTATACT');
INSERT INTO marker_sequence VALUES(1211,'1fae0f13e51bc87faae2c6d4e1502985','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTTAAACCCATTCTTGAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(1212,'912e1f1a91937bd17ff670bc36b7be16','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTTACGAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(1213,'290746c0a5177dfd5233486cb35e0df2','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(1214,'809eeee5c9feee79f02281161dd64e8e','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCCGCTGCTGAGTGAGCCCTATCAAAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTTTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(1215,'5eaddf6a1456bff8aef5b43e83c9d4ae','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACGCCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(1216,'a3b5ff2c4259f1151d567363e168736e','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCCCACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCACTAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(1217,'e64b8c3a6a36dc2a9ea68e830f0847a5','TTTCCGTAGGTGAACCTGCGGAAGGATCTTTACCCCACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(1218,'abefb4e6377f84f650e1a7f3615e1718','TTTCCGTAGGTGAACCTGCGGAAGGATCATTCCCCCCCCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTTTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(1219,'d46cc27995065661a2f890250827bc6c','TTTCGGTAGGTGACCTTGCGGAAGGATCATTACCACCACTTAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTGGGGGTGTTGCTTGGCGTTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(1220,'152c8173704801a56c115cbc3f6160c6','TCTCCGTAGGTGAACTGCGGAAGGATCATTACCACACTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTTAAGATTGGGAGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCCTTCTTTAATTACTGAAATACT');
INSERT INTO marker_sequence VALUES(1221,'4518fc107a247fe175293daee052ff69','TTCCCGTAGGTGAACCTGCCGAAGGATCATTACCACCACCTAAAAAACCTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTTGGCGGCGGCTGCTGGCTTAATTGTTGGCCGCCTGCTGCTGAGTGAGCCCTATCAAAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(1222,'59819862b7872062b3bf59320e44a35d','GTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACCCCCTAAAAACCTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(1223,'7ad75c1d5789fd543d02a6c7317538c3','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTTACGAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(1224,'da5a60a7f49f86257ff3703316d9786d','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCAATAATTTGGGGGTTTAATTGGCGGCTGCTGCTGGTATCTTTTTACTGGCTGGCGGCTGCTGAGCGAACCCTATCGTGAGCGTTCTGACCTTTGGTTGGAGCTAGTAACTTAAATTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(1225,'ac51f3a967e33953ef34a92d57fc0416','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACATCTTTCCACGTGAACCGTTTGTGACATGGTTGGGCTTGTGCGTTTTCTCTCTCTCTTTTGGGGGAGAGGATTCCTACCAACTATCAGTATACTTGACCAATCTCTTTTTTTTGATAGCTGAAACCTGCTGAGACGACAATCTTCTCTGCTATGAACAAAATATCTACTTTCA');
INSERT INTO marker_sequence VALUES(1226,'101068d6bd20c952d6807e56a7a474da','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACATCTTTCCACGTGAACCGTTTGTGACATGGTTGGGCTTGTGCGTTTTCTCTCTCTCTTTTGGGGGAGAGGATGCCTACCAACTATCTGTATTCTTGTCCAATCCCTTTTTTTTGATAACTGAAACCTGCTGTGAGGACAATCTTCTCTGCTATGAACTAGATAGCTTCTTTCA');
INSERT INTO marker_sequence VALUES(1227,'b41a637348c865e9d867746da928ad87','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACATCTTTCCACGTGAACCGTTTGTGACATGGTTGGGCTTGTGCGTGTTTTCTTCCTTTTGGGGGAGGCTTGCGAGCTATCTGTAAACTTGTCAAACCCATTCTCTTTGATAACTGAAACATACT');
INSERT INTO marker_sequence VALUES(1228,'69242a58097c246426b5f36f4e9414d9','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACATCTTTCCACGTGAACCGTTTGTGACATGGTTGGGCTTGTGCGTGTTCTCTCTCTTTTGGGGGAGGCGTGCGAGCTATCTGTAAACTTGTCAAACCCATTCTCTTTGATAACTGAAACATACT');
INSERT INTO marker_sequence VALUES(1229,'1fb2c0ff61e288eabe0e3740f5642d6e','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACATCTTTCCACGTGAACCGTTTGTGACATGGTTGGGCTTGTGCGTGTTCTCTCTCTTTTGGGGGAGGCGTGCGAACTATCTGTAGACTTGTCAAACCCATTCTCTTTGATAACTGAAACATACT');
INSERT INTO marker_sequence VALUES(1230,'ee889308f98718ffcdae8b971509f016','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTCGTTATTTGTTGTGTGTCTGCGCGTTGCTGGCGTGCGTTTGCTTACGCTTCGGTGTTTGCGAGTGCGTGCTGGCGGTGCGCGGACTGAACGAAGGTCGTGTTGCTGTGTGCCTGCTGCACTGCTGACTTTGCATTGATTTGCATGGTCTTGGCGGAACGGCGGGTGCTGTGCGTGCGCGGCTGACTTACTTTTTCAACCCCCATACCTAACTTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1231,'ab80f79efe98b4afa4437cc737cdeec7','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTCGTTATTTGTTGTGTGTCTGCGCGTTGCTGGCGTGCGTTTGCTTACGCTTCGGTGTTTGCGARTGCSTGCTGGCGGTGCGCGGACTGAACGAAGGTCGTGTTGCTGTGTGCCTGCTGCACTGCTGACTTTGCATTGATTTGCATGGTCTTGGCGGAGCGGCGGGTGCTGTGCGTGCGCGGCTGACTTACTTTTTCAAACCCCATACCTAACTTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1232,'dac32e2b4ee90a62710eccaad8f77419','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACACCCTTCCACGTGAACCGTTTTGTTTTGCTTTCGAGTGCTTTGTTGCGCTCGGAGCATGTTTGGGCTTCGCTGCTGGCGCTTGATTGTGCTGGCGGCTCGAGGCCATCAAGCGGCGTTTTGAGTGTGCTTGCGCAATTGAAACGTCCAAACCTTTTAAACCCATTTGATTGCAAACTGAAGTATACT');
INSERT INTO marker_sequence VALUES(1233,'5c2f8d3a1e5559d204857c20f794bacf','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTATAACTATGTTCTGTGCTTCGTCGCAAGACTTGAGGCTGAACGAAGGTGAGTCTGCGTCTATTTTGGATGCGGATTTGCTGATGTTATTTTAAACACCTATTACTTAATACTGAACTATACTCCGAATACGAAAGTTTTTGGTTTTAACAATTAACAACTTTCA');
INSERT INTO marker_sequence VALUES(1234,'c284564cce35c78023d5434dd3c4af89','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTCTGTATTTGTTTTGTGTCTGCGCGTTGCTGGCGTGCGTTTGCTTGCGCTTCGGCGTTTGCGAGTGCGTGCTGGCGGTGCGCGGACTGAACGAAGGTTGTGTTGCTGTGTGCCTGCTGCATTGCTGACTTTGCATTAAGTTGTATCGTCTTGGCGGAGCGGCGGGTGCTGATGCGACCGGCTGACTTATTTTTTCAAACCCCATACCTAACTTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1235,'8d7560819099bd721498958bccc07a43','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCAAATAGTTGGGGATGAGTTAGGTGGCAGCTGCTGACTTTAATGTTGGCGGTAGCCGCTAGACGAGTCCTATCATAGTGAAGTGGGTTTGGACATTATAGTCCGAGCTAGTAGCTATTTTTAAACCCTTTACTTAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(1236,'2d776bbf2a992e4ce8c39698f2c9eb08','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCAAATAGTTGGGGATGAGTTAGGTGGCAGCTGCTGACTTTAATGTTGGCGGTAGCCGCTAGACGAGTCCTATCATAGTGAAGTGGTTTGGACATTATAGTCCGAGCTAGTAGCTATTTTTTAAACCCTTACTTAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(1237,'ce6ca5792f1a7637f40a49ef4b70d507','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCCTGTCTGCCTGTTGGCGGGCGGCTCCATCAAACGAGGCCCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTTTTGTAAATCCTTACTATATTTTCTGATCATACT');
INSERT INTO marker_sequence VALUES(1238,'7c908ba95dd4c5172216a3a06d712aee','TTTCCGTAGGTGAACCTGCGGAAGGATCCTTTACCCCCCCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTCCCGNTCTGGCCGGCCGGTTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO marker_sequence VALUES(1239,'f9b5db5ccd93514a26191e343241b7bc','GTTCCGTAGGTGACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(1240,'c0da65a80a455170803345def2fc9132','GTTCCGTAGGTGAACCTGCGGAAGGATCCTTTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(1241,'3c685dafaa26b50700ff4338b06341fa','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTCGTTATTTGTTGTGTGTGTGCGCGTTGGTAGCATGCGTGTTTGCTTACGCTTCGGTGTTTGCGAGTGCGCGTGCTGGCGGTGCGCAGACTGAACGAAGGTCGTGTGTTGCTGTGTGCCTGCTGCACCGCTGACTTTGCATTGATTTGCATGATGTTGGCGGAGCGGCGGGTGCTGTTGCGTGCGCGGCTGACCTATTTTTTTCAAACCCCATACGTAAATGACTGAATATACT');
INSERT INTO marker_sequence VALUES(1242,'725344da87ed7a026a6255fdf93ab8dc','TTTCCGTAGGTGAACGGCGGAAGGATCATTACCACACCTAAAAAAACTTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(1243,'00064639be0396195c149a91d27e0410','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTCTTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(1244,'6fbc0430126818eefad73f35f22171b7','TTTCCGTAGGTGAACTGCGGAAGGATCATTACCACACTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTAATTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(1245,'3da1bca3ae36e55373f551dab12a2046','TTTCCGTAGGTGAAACTGCGGAAGGGATCATTACCCACACCTAAAAAACTTTTCACGTGAACCGTATCAACCTTTTAGTTGGGGGTCTTGCTTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(1246,'40de8db9306c23d2c4412dbd678fef4f','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATAATTTGGGGGTTAATTTGGTAATGGCTGCTGGCATCTTTTTGTTGGCTGGCTGTTACTGAGTAAGCCCTATCATGGCGAGAGTTTGGACCTTTGTCTGAACAAGTAGCTACGATTGTAAACCCTTTCTTAATTACTGAATATACT');
INSERT INTO marker_sequence VALUES(1247,'348bb91526d93a37f3afa452c27417df','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACTTTAAAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTGACTGAGCTGGTGTTTTCATTTTTGGACACTGGAACGGGAGTCAGCAGGACGAAGGTTGGTCTGTTGTAATGCAAGTTATAATGGACTAGCTGATGAACTTTTGTTTTTAAACCCTTACCTAAATACTGATTTATACT');
INSERT INTO marker_sequence VALUES(1248,'67ce22f69d4a3f7896d386153625e4fe','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACTTTAAAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTGACTGAGCTGGTGTTTTCATTTTTGGACACTGGAACGGGAGTCAGCAGGACGAAGGTTGGTCTGTTGTAATGCAAGTTATRATGGACTAGCTGATGAACTTTTGTTTTTAAACCCTTACCTAAATACTGATTTATACT');
INSERT INTO marker_sequence VALUES(1249,'1173a7c57963c3f5d2e1c938c49c46a4','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTATCCACGTGAACTGTCTGATCCGATTCGCGCCGTGACGCGTGCTGCGGGTTTGTAAAAGAATCTGCGGCGTGCGGGCTCGGCTGATCGAAGGTTTCATTGCTGCGAGCGTGTGCTTTTCGGAGCGCGCGTGTTGCGGCGGTGGGGCTGACTTACTCTTTCAAACCCGTTTACCGAATGACTGATGTATACT');
INSERT INTO marker_sequence VALUES(1250,'2abac8241200c22d053dbf27326a5dd6','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACATCTTTCCACGTGAACCGTTTGTGACATTGTTGGGCTTGTCTTTCTTTCGAGGAGGATGAGCTATCTGTAAACTTGTCAAACCCCTTTCTTTTATTATAAAACTGAAACATACT');
INSERT INTO marker_sequence VALUES(1251,'282d5f56daf5c255b60cd4cd052dc85c','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTCTAAATATGTTCTGTGCTTCGTCGAAGCAAACTGCTCTCTTTTTTGGGAGTGGTGAGCGACGGCTTGAGGCTGAACGAAGGTTGGCTCAGTACTCGTATGACTCTCGGGTTGTGCGGTGGAACAGCTTGCCGATGTCTTTTTCAAACCCATTTTACTAAACACTGATCTATACT');
INSERT INTO marker_sequence VALUES(1252,'b43c6913da7f423d13db3f0920aae8eb','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTCTAAATATGTTCTGTGCTTCGTCGAAGCGGACTGCTCTCTCCGGAGAAATGGTCTTGCGACGGCTTGAGGCTGAACGAAGGCTTGCTCAGTAACTCGTATGACTCTCGGGTTGTACGGTGGAACTGCTGGCCGATGTCTTTTTCAAACCCATTTTACTAAACACTGATCTATACT');
INSERT INTO marker_sequence VALUES(1253,'1546572dec89aa0a2d37fdedea4b2fe9','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTCATTATTTGTGGGGTGTCTGTGCGTTGTTGGCGTGCATTTGCTTACACTTTGGTGTTTGTGAGTGTGTGTTGGCAGTGTGCGGACTGAACGAAGGTTGTGTGTTGTTATGTGCCTACTGCACTGCTGACTTTGCATTCATTAGTATGGTCTTGGCGGAGTGGCGGGTACTGTGCATGCGCAACTGACTTATTTTTTCAAACCCCATACCTAAATGACTGATTATACT');
INSERT INTO marker_sequence VALUES(1254,'c202146bcc7c2458613783ccb3556a87','TTTCCGTAGGTGAACCTGCGGAAGGATCATTCCCACACCTAAAAAACTTTCCACGTGAACTGTCATTATTTGTTGTGTGTCTGTGCGTTGTTGGCGTGCATTTGCTTACACTATGGTGTTTGTGAGTGTGTGTTGGCAGTGTGCGGACTGAACGAAGGTTGTGTGTTGTTATGTGCCTACTGCACTGCTGACTTTGCATTCATTTGTATGGTCTTGGCGGAGTGGCGGGTACTGTGCATGCGCAACTGACTTATTTTTTCAAACCCCATACCTAAATGACTGATTATACT');
INSERT INTO marker_sequence VALUES(1255,'c36f8b85cdbe8ee5ca70863c1b23ff7f','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTGGCGTGCTGAGCAAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCGAAAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(1256,'551f34cac6a7397abfebdd2a8c452880','GTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(1257,'31cc4b3b92948fe6a2f4199337b75494','TTTCAGTAGGTGAACTTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(1258,'36d7b72ebf72d091ce77172e7a903a49','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTACTTGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGAGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(1259,'6ad479bba5dd1a37874f384b0110f5a9','TTTCAGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(1260,'94b318e9b29af985e6f387b7f1232c5b','GTTCAGTAGGTGAACTTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(1261,'e89e8db6d98311f4f402bf25f3c1444c','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTACTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGAGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(1262,'8c018840f9675a410ce90c1f3eb612df','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTACTTGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(1263,'9059f1bac89d293dbe6be59b3321600b','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGAGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(1264,'e50f7cd96f270ab8b6d3b5b297c0ae6d','GTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGAGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(1265,'0ea3c59de328c705e983f736ffc4d3cc','TTTCCGTAGGTGAACCTGCGGAWGGATCATTACCACACCTAAAAACACCCTTCCACGTGAACCGTTTTGTTTTGCTTTCGAGTGCTTTGTTGCGCTCGGAGCATGTTTGGGCTTCGCTGCTGGCGCTTGATTGTGCTGGCGGCTCGAGGCCATCAAGTGGCGTTTTGAGTGTGCKTGCGCATTTTGAACGTCCAAACCTTTTAAACCCATTTGATTGAAAACTGAAGTATACT');
INSERT INTO marker_sequence VALUES(1266,'f23d6ba7ff5d2024f58b764895f96a81','TTTCCGTAGGTGAACTTGCGGAAGGATCATTACCACACCTAAAAAAATTTTTCACGTTATCCGTATCATCCTTTTTATTTGGGGTTCTTGTTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(1267,'a3009917467dc1736322aa6d7a0b872b','TTCCGTAGGTGAACCGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO marker_sequence VALUES(1268,'696b2c5440d500455f145294ff64812b','TTCCGTAGGTGAACCGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCATTTCACAATTCTGATTATACT');
INSERT INTO marker_sequence VALUES(1269,'cea131f773b0bedbb4ba870eabe000fe','TTCCGTAGGTGAACCGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTCCACAATTCTGATTATACT');
INSERT INTO marker_sequence VALUES(1270,'9891a69393a9e47069b804fa36395bba','TTCCGTAGGTGAACCGCGGAAGGATCATTACCACACCTCAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO marker_sequence VALUES(1271,'6cc846759b0f069a60eecc6c73004746','TTCCGTAGGTGAACCGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO marker_sequence VALUES(1272,'ba937f483877591dc95e440f31413f42','TTCCGTAGGTGAACCGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCATTTCACAATTCTGATTATACT');
INSERT INTO marker_sequence VALUES(1273,'9197ca49c0d842d4a9a14eeb02183f63','TTCCGTAGGTGAACCGCGGAAGGATCATTTCCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO marker_sequence VALUES(1274,'6afebb694fc734c87182c22a61867906','TTCCGTAGGTGAACCGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTAGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO marker_sequence VALUES(1275,'3b78ca647debaf3334718e0380c2fce4','TTCCGTAGGTGAACCGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTCTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO marker_sequence VALUES(1276,'1738594bdba8e22c2c6f2c0fd5ecb921','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCATTTCACAATTCTGATTATACT');
INSERT INTO marker_sequence VALUES(1277,'b7bebbf82339eb6d8a63d5253e5569fd','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAGCCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGTTTTTTGTTTTAAACCATTTCACAATTCTGATTATACT');
INSERT INTO marker_sequence VALUES(1278,'60ed5396de6064e42a1bc3e12359410d','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACATCTTTCCACGTGAACCGTTTGTGACATTGTTGGGCTTGTCTTTCTTTCGAGGAAGGCGAGCTATCTGTAAACTTGTCAAACCCAATTCTTTTTTTATAAAACTGAAACATACT');
INSERT INTO marker_sequence VALUES(1279,'7344505a52e75e63f41b5c861111afc6','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACATCTTTCCACGTGAACCGTTTGTGACATTGTTGGGCTTGTCTTTCTTTCGAGGAAGGCGAGCTATCTGTAAACTTGTCAAACCCAATTCTTTTTATATAAAACTGAAACATACT');
INSERT INTO marker_sequence VALUES(1280,'c9f43635a4802f3ccc4a7adceff5ba0b','TTTCCGTAGGTGAACCTGCGGAAGGATCATTTCCCCACTTTAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTGACTGATCTGGTGTTTTCGGATAGTGGATCGGGAGTCAGCAGGACGAAGGTTGGTCTCGTAATGTAAATTATGGGACTAGCTGATGCATTCCTTTTTTCAAACCCTTACATAAATACTGATTGATACT');
INSERT INTO marker_sequence VALUES(1281,'6943bb99648975850fedbb7698e575b3','CTTCTGTAGGTGAACCTGCGGAAGGATCATTCCCTCACCTAAAAAACAACCTTGCCACGTGAACCGTTTTGTTTTGCTTTCGAGTGCTTTGTTGCGCTCGGAGCATGTTTTGGGCTTCGCTGCTGGCGCTTGATTGTGCTGGCGGCTCGAGGCCATCAAGTGGCGTTTTGAGTGTGCTTTGCGCAATTGAAACGTCGAAACCTTTTTTTTAAACCCATTTGATTGAAAACTGAAGTATACT');
INSERT INTO marker_sequence VALUES(1282,'d0cf4b56667a308517ba7f54eb69381c','TTTCCGTAGGTGACCCTGCGGAAGGATCATTACCACACCTAAAAACATCTTTCCACGTGAACCGTTTGTGACATGGTTGGGCTTGTGCGTGTTCTCTCTGTTTTGGGGGGAGGCGTGCGAGCTATCTGTAAACTTGTCAAACCCATTCTCTTTGATAACTGAAACATACT');
INSERT INTO marker_sequence VALUES(1283,'c17804cab76491cf00202d97c3ff086c','TTTCCGTAGGTGAACCTGCGGAAGGATCACTACCACACCTAAAAACATCTTTCCACGTGAACCGTTTGTGACATGGTTGGGCTTGTGTCGTGTTCTCTCTGTTTTGGGGGGAGGCGTGCGAGCTATCTGTAAACTTGTCAAACCCATTCTCTTTGATAACTGAAACATACT');
INSERT INTO marker_sequence VALUES(1284,'6a898b08296b8db3ba36bce3b16a52b8','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACATCTTTCCACGTGAACCGTTTGTGACATGGTTGGGCTTGTGCGCGTTCTCTCTGTTTTGGGGGGAGGCGTGCGAGCTATCTGTAAACTTGTCAAACCCATTCTCTTTGATAACTGAAACATACT');
INSERT INTO marker_sequence VALUES(1285,'a674015d4a832892b53b6426764326eb','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATTATCACCTAGTTGGGGACTCGTCTGTTGTCGGTTGGGCTGGCGCAAGCTGGTTTGTCTGTCGATGGTTTGTAGTTCTATCAAACGATCGCTGTGGCTGCAAAGTCGTAGTTGTTCGTTTCTACTTGTAAACCGTTTTTTATTTTCTGAATATACT');
INSERT INTO marker_sequence VALUES(1286,'d22bde2d8bf067f7270a98dcd0512d3a','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTCTGTATTTGTTGTGTGTCTGTGCGTGCTGGCGTGCGTTTTGCGTGCCGGCGTGTGCGGACTGAACGAAGGTCGTGTCGCTTTGCGGCTGCGGCTGACTTCTTTTTCAAACCCCATACTTGAATGACTGATTATACT');
INSERT INTO marker_sequence VALUES(1287,'be2cd53965c817f89b3df7e05ec1601e','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGACGGGCTCTATCATGGCAATTGGTTTGGGTCCTCCTCGTGGGGAACTAGATCATGAGCCCACTTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO marker_sequence VALUES(1288,'163cd2eb0ea382ea97486200abc9795a','CTTCCGTAGGGTGAACGTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(1289,'7ab5d60845995b336ee247d647d91b8b','GTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGATGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(1290,'52df510e24f607cbc03ea3b5025cede3','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACACCCTTCCACGTGAACCGTTTTGTTTTGCTTTCGAGTGCTGTTGCGCTCGGAGCATGTTTGGGCTTCGCTGCTGGCGCTTGATTGTGCTGGCGGCTCGAGGCCATCAAGCGGCGTTTTGAGTGTGTGTTCGCATACAATTAAAACGTCCAAACCTTTTAAACCCATTTGATTGAAAACTGAAGTATACT');
INSERT INTO marker_sequence VALUES(1291,'449d3901489a7ceb7c8cf2d4d2284ad4','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTTCACGTGAACCGTTTCAACCAAATAGTTGGGAACGAGTTAGGCGGCGACTGCTGACTTTATTGTTGGTGGTTACTGCTAGACGAGTTCTATCATAGTGAAGTGGTTTGGACTTCGGTTCGAGCTAGTAGCTATTTTTAAACCATTACTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(1292,'87c87263f4f952a11f75c6594574ba27','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACTTTAAAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTCACTGAGCTGGTGTTTTCATTTTTGGACACTGGAACGGGAGTCAGCAGGACGAAGGTTGGTCTCTTGTAATGCAAGTTATGATGGACTAGCTGATGAACTTTTGTTTTTAAACCCTTACCTAAATACTGATTTATACT');
INSERT INTO marker_sequence VALUES(1294,'2c4674a7a2762aa85ac47a8d5fe5a70e','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACACCCTTCCACGTGAACCGTTTTGTTTTGCTTTCGAGTGCTTTGTTGCGCTCGGAGCATGTTTGGGCTTCGCTGCTGGCGCTTGATTGTGCTGGCGGCTCGAGGCCATCAAGCGGCGTTTGGAGTGTGCTTGCGCACATTTTGAATGTCCAAACCTTTTAAACCCATTTGATTGAAAACTGAAGTATACT');
INSERT INTO marker_sequence VALUES(1295,'dca20220e12bd7285248c4d2861779d1','TTTCCGTAGGTGAACTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCACATTAGTTGGGGGTTTGATTGGCGGCTGCTGCTGGCATCTTTTTGCTGGCTGGCGACTGCTGAGTGAACCCTATCTTGGCGATCGTTCTGACCTCGGTTGGAGCTAGTAGCTTGCATTTTAAATCCATTCTTAATTACTGAACATACT');
INSERT INTO marker_sequence VALUES(1296,'eb900405b519e6a3e0a57acca57e6766','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCACATTTATTGGGGGTTTCATTGGCGGCTGCTGCTGGCATCTTTTTGCTGGCTGGCGACTGCTGAGCGAACCCTATCATGGCGAGCGTTCTGACCTCGGTTGGAGCTAGTAGCTTGCATTTTAAACCCCTTCTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(1297,'81b90282bc9c346fcdbd2ec9e1eec946','GGTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATAGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(1298,'8c4109758e97f907b790de4f83804c66','TTTCCGTAGGTGAACGTGCGGAAGGATCATTACCACACATAAAAACATCTTTCCACGTGAACCGTTTGTGACATGGTTGGGCTTGTGCGTGTTCTCTCTGTTTTGGGGGGGAGGCGTGCGAGCTATCTGTAAACTTGTCAAACCCATTCTCTTTGATAACTGAAACATACT');
INSERT INTO marker_sequence VALUES(1299,'0385ee2c62701b414f37088ec2c6243d','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTTCACGTGAACTGTATCAACCCCATTAATTGGGGGTTTTGTTTGGCGGTGATCGCTAGCTTAATTGCTGGTTGATTACTGCTAGGCGAGCCCTATCATGGTGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTATTTTAAACCCTTTCTTAATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1300,'e16b94aad0a8c6b3aef72c21d98c3afd','TTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGACTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(1301,'6ff4ab53f4102f5e0fff3d34cf88ce00','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAATTTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTCATGGGTCGGCGTGCTGCTGCTGGGTGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO marker_sequence VALUES(1302,'1ae614214aded5421b07e8269a11a515','TTTCCGTAGGTGAACTGCGGAAGGATCATTACCACACCTAAAAAAACTTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(1303,'7e0c5fec257d83d2d0765deae033aae8','TTTCCGTAGGTGAACTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTAACAAACCAATAGTTGGGGGCGAGTTTGGCGGCTGCTGCTGCTGGACGAGCTCTATCATGGCGAGCGTTTGGACTTCGGTCTGAACTAGTAGCCCTTCTTTTAAACCCATTCCTAATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1304,'860e54ca2cd2786375fd88746ff01798','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATTACCAAAGTTAGTTGGGGACTCCCTGTTGTTGGTCGATGTAGCAATATGTTGACCGGCGGCGGGTTGAGACCTATCAAACGACGGCGACGAATGTGCGGGCTGAAAAGTCGGCACGTTTGTTTCTGAAGTTTCTCTTTTAAACTCCTTCTTATTTAACTGAACATACT');
INSERT INTO marker_sequence VALUES(1305,'dcc5f7a39bf0070fc6284f61de480c9a','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTGTTGTCGATGTTGGGGGCTGGGCTGGCGTTTGTTCGTCAGTTGGGCTCCATCAAACGAGGCTCTGGGCTGAAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTTTTAAGTTTTTCTGAATATACT');
INSERT INTO marker_sequence VALUES(1306,'0cc6d92876184aae488d6415912a83cc','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACCCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTCTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(1307,'19f37ffcdb196efa729ce591c126e8b9','TTCCGTAGGTGAACCTGGGGAAGGATCATTCCCCCACCCCAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO marker_sequence VALUES(1308,'9d89b9e63606dd9e8cb8c17e8831eceb','TTCGTANTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTCATTATTTGTTGTGTGTCTGTGCGTTGTTGGCGTGCATTTGCTTACACTTTGGTGTTTGTGAGTGCGTGTTGGCAGTGTGCGGACTGAACGAAGGTTGTGTGTTGTTATGTGCCTGCTGCACTGCTGACTTTGCATTCATTTGTATGGTCTTGGCGGAGTGGCGGGTACTGTGCATGCGCAGCTGACTTATTTTTTCAAACCCCCATACCTAAATGACTGATTATACT');
INSERT INTO marker_sequence VALUES(1309,'6e859831e013abee7811d6a74fd07b4a','GTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTCATTATTTGTTGTGTGTCTGCGCGTTGTTGACGTGCATTTGCTTACGCTTTGGTGTTTGTGAGTGCGTGTTGGCAGTGTGCGGACTGAACGAAGGTTGTGTGTTGTTATGTGCCTGCTGCACTGCTGACTTTGCATTCATTTGTATGGTCTTGGCGGAGTGGCGGGTACTGTGCATGCGCAGCTGACTTATTTTTTCAAACCCCCATACCTAAATGACTGATTATACT');
INSERT INTO marker_sequence VALUES(1310,'1634d5d565cd8844500e45e173950e96','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTCATTATTTGTTGTGTGTCTGCGCGTTGTTGACGTGCATTTGCTTACGCTTTGGTGTTTGTGAGTGCGTGTTGGCAGTGTGCGGACTGAACGAAGGTTGTGTGTTGTTATGTGCCTGCTGCACTGCTGACTTTGCATTCATTTGTATGGTCTTGGCGGAGTGGCGGGTACTGTGCATGCGCAGCTGACTTATTTTTTCAAACCCCATACCTAAATGACTGATTATACT');
INSERT INTO marker_sequence VALUES(1311,'956ccb66a51048a58b6f5c1e41a946c9','GTTCTGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTCGTTATTTGTTGTGCGCTCTCTGCGGTGTCGGTGGCGTCTGCTGGCTTTGTTGCTGGCGGGTGCGAGCCGGATGCGGAGGCTGAACGAAGGTCGAGTTGCTTTGCTCTCGGCTGACTTATTTTTCAAACCCAATACCAAACTTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1312,'8a8298a1ec31852c1e74450f6436bda6','CTTCCGTAGGGTGACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO marker_sequence VALUES(1313,'b07282994ad1adeba7b6f541d794afdf','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTATTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(1314,'9ab048e401e83d415a132bcd48aa92c6','CTTCCGTAGGTGGACGTGCGGAAGGATCATTACCACACTTTAAAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTGACTGAGCTGGTGTTTTCATTTTTGGACACTGGAACGGGAGTCAGCAGGACGAAGGTTGGTCTGTTGTAATGCAAGTTATGATGGACTAGCTGATGAACTTTTGTTTTTAAACCCTTACCTAAATACTGATTTATACT');
INSERT INTO marker_sequence VALUES(1315,'2b0d9b5cc8025b1b10cde277180c8a5d','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACACCCTTCCACGTGAACCGTTTTGTTTTGCTTTTGAGTGCTTTGTTGTGCTCGGAGCATGTTTGGGCTTCGCTGCTGGCGCTTGATTGTGCTGGCGGCTCGAGGCCATCAAGCGGCGTTTTGAGTGTGTGTTCGCATACAATTAAAACGTCCAAACCTTTTAAACCCATTTGATTGAAAACTGAAGTATACT');
INSERT INTO marker_sequence VALUES(1316,'f18c3ef0d6ba461a9cfafe458c3e1fd5','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACTGTCGTTATTTGTTGTGTGTGTGCGTGTTGGTAGCATGCGTGTTTGCTTACGCTTTGGTGTTTGCGAGTGCGCGTGCTGTCGGTGCGCAGACTGAACGAAGGTCGTGTGTTGCTGTGTGCCTGCTGCACTGCTGACTTTGCATTGATTTGCATGATGTTGGCGGAGCGGCGGGTGCTGTTGCGTGCGCGGCTGACCTATTTTTTTCAAACCCCATACCTAAATGACTGATTATACT');
INSERT INTO marker_sequence VALUES(1317,'a4943621f79a8aad19f72a03b33e840b','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTCGTTATTTGTTGTGTGTGTGCGTGTTGGTAGCATGCGTGTTTGCTTACGCTTTGGTGTTTGCGAGTGTGTGTGTTGTCGGTGCGCAGACTGAACGAAGGTCGTGTGTTGCTGTGTGTCTGCTGTACTGCTGACTTTGCATTGATTTGCATGGTGTTGGCGGAGCGGCGGGTGCTGTTGCATGCGCGGCTGACCTATTTTTTTCAAACCCCATACCTAAATGACTGATTATACT');
INSERT INTO marker_sequence VALUES(1318,'8827a47e011ac0699d93142da6b11fff','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACTTTAAAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTCACTGAGCTGGTGTTTTCATTTTTGGACACTGGAACGGGAGTCAGCAGGACGAAGGTTGGTCTCTTGTAATGCAAGTTATGAGGGACTAGCTGATGAACTTTTGTTTTTAAACCCTTACCTAAATACTGATTTATACT');
INSERT INTO marker_sequence VALUES(1319,'7b58d5179b582f05c9a0a75a9eab39aa','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACTGTCGTTATTTGTTGTGTGTGTGCGTGTTGGTAGCATGCGTGTTTGCTTACGCTTTGGTGTTTGCGAGTGTGTGTGTTGTCGGTGCGCAGACTGAACGAAGGTCGTGTGTTGCTGTGTGTCTGCTGYACTGCTGACTTTGCATTGATTTGCATGGTGTTGGCGGAGCGGCGGGTGCTGTTGCATGCGCGGCTGACCTATTTTTTTCAAACCCCATACCTAAATGACTGATTATACT');
INSERT INTO marker_sequence VALUES(1320,'33c1515280fb4cf56457ba3ab9636bec','CTTCCGTAGGGTGAACCTGCGGGAAGGATCATTACCACACCTAAACAACTTTCCACGTGAACCGTATCAACAAGTAGTTGCGGGCCTGCTCTGTGTCCCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO marker_sequence VALUES(1321,'868417c6ceca6b50726359b970c5fa4f','TTTCCGTTGGCGAACCTGCGGAAGGATCATTCCCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTGGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO marker_sequence VALUES(1322,'2308991f000de1968d5f71d969c95cb0','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(1323,'e46f5d0bb0b7f784157a169398adc3e6','TTCCGTAGGGTGACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTCAGTTGGGGGCCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(1324,'031284f800486331db490adb91797a15','TTCCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACATCTTTCCACGTGAACCGTTTGTGACATTGTTGGGCTTGCTGTTCTTTTTTCGGGAGAGCGAGCTATCTGTAAAACTTGTCAAACCCATGTCTTTTATAAAACTGAAACATACT');
INSERT INTO marker_sequence VALUES(1325,'a288e932c1c7dbd1dd5b73ee6090af9f','CTTCCGTAGGTGAACCTGGGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTAAACCGTTCTAAATATGTTTTGTGCTTGCTGGAAGCAAACTCCTTTCTTTTTTGGGAGTGGTGAGCGACGGCTTGAGGTTGAACGAAGGTTGGCTCAGTACTCGTATGACTCTCGGGTTGTGCGGTGGAACAGCTTGCCGATGTCTTTTTCCAACCCATTTTTCTAAACACTGATCTATACT');
INSERT INTO marker_sequence VALUES(1326,'88b8f690696f04fde7fdfd2fa4791d82','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCGTGCCGTTCGCGGCGGCTCCATCAAACGAGGCTCTGGGCTGAAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTTACCACATTTTCTGATCATACT');
INSERT INTO marker_sequence VALUES(1327,'32866c1a87fadc2f7dcf9680a5d9f483','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACTTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTGGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(1328,'6d7c65f18228f348acf995e548db1a6d','TTTCCGTAGGTGAACTGCCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTNGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(1329,'f6d5fda5c1180b6213ee480752d6f39d','TTTCCGTAGGTGAACTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCAGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAACTAGTAGCTATCAATTTTAAACCCTTTCTTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(1330,'c85bd86bdd23c2aaddbd03d55e135416','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCKGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCAGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAACTAGTAGCTATCAATTTTAAACCCYTTYTTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(1331,'54473d2e013181b2cccad1f05ae60b0d','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCYTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCAGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAAMTAGTAGCTATCAATTTTAAACCCYTTYTTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(1332,'00a6a4f7e267a5434921b269499a7490','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACMCCTAAAAAAACTTTCCACGTGAMCCGTATCAACCCCYTAAATTTGGGGGCTTGCTCKGCGGCGTGCGTGCTGGCCYGTAATGGGTCGGCGTGCTGCTGCTGGGCAGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAAMTAGTAGCTATCAATTTTAAACCCYTTYTTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(1333,'0ff9e2d930f07367972c801344a04f68','TTTCCGTAGGTGAACTTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(1334,'f344986612fb0473a7a61a2ea4fdd264','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCYTTCTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(1335,'c01bb5979f9f5a0a9f273f9595d98154','TTTCCGTAGGTGAACTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCATTTAGTTGGGGGCTTGTCCTGGTGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGGCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(1336,'18bf3de496b0e33ac8c7ad579d605d6c','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(1337,'7fe5cfcc241b3f0ee417d2d0ec7e5c4c','TTTCCGTAGGTGAACTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(1338,'7a4ae50217380e0dd709c1602d32f38c','TTTCCGTAGGTGAACTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTAATTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(1339,'5bbedd1f285a5a6cfe2c42a4d6dc7df2','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCATTTAGTTGGGGGCTTGTCTGGTGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGGCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(1340,'3f3f37d69dffa47875a3e8848d4c3025','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACTGTCAAACCTGTTCTGTGCTTGTGCTGGGTCTGCGTTTTCGGACGCGGACACGGTGGAGGCTGAACGAAGGTTGGTTTTCTTCTTGTGAGAGTCCAGCTGATATATTTTTCAAACCCCTTTTTACAAAATGACTGATCAATACT');
INSERT INTO marker_sequence VALUES(1341,'6daa3debd3546fc544dea1a0e7475be2','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACTTTAAAACTGTCCACGTGAACTGTAAGCAAGTCTAGCGCTGTGACTGATCTGGTGTTTTGTGATACTGGATCGGGAGTGAGCAGGACGAAGGTTGGTCTCGTAATGTAAATTGTGGGACTAGCTGATGCATTCGTTTTTTCAAACCCTTACCTAAATACTGATTGATACT');
INSERT INTO marker_sequence VALUES(1342,'0cd2737f5b7314a70dc2d5048e3a989c','TTTCCGTAGGGAACCTGCGGAAGGATCATACCACACTAAAAAACTTTCCACGTGAACTGTCATTATTTGTTGTGTGTCTGTGCGTTGTTGGCGTGCATTTGCTTACACTTTGGTGTTTGYGAGTGCGTGTTGGCAGTGTGCGGACTGAACGAAGGTTGTGTGTTGTTATGTGCCTACTGCACTGCTGACTTTGCATTCATTTGTATGGTCTTGGCGGAGTGGCGGGTACTGTGCATGCGCAACTGACTTATTTTTTCAAACCCCATACCTAAATGACTGATTATACT');
INSERT INTO marker_sequence VALUES(1343,'b05bb7eb7407a88ccb2dc15c1b033474','TTTCCGTAGGGTGGACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATAATTTGGGGGTTAATTTGGTAATGGCTGCTGGCATCTTTTTGTTGGCTGGCTGTTACTGAGTAAGCCCTATCATGGCGAGAGTTTGGACCTTTGTCTGAACAAGTAGCTACGATTGTAAACCCTTTCTTAATTACTGAATATACT');
INSERT INTO marker_sequence VALUES(1344,'3be60797360a53eba762b1e34df14385','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACATAAAAAACATCTCTTCCACGTGAACCGTTTGTGACCGTTGTTGGGCTGCGATCGTTCGGTCGTTCGATCGATCGGTTGATTGCGGCCATCACTTGTTTGTCAAACCCATTCTTTGAATTCTAAACTGAACATACT');
INSERT INTO marker_sequence VALUES(1345,'f9d77c0224aa305c5065b3195be4d2c3','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCAAAAAAACTTTCCACGTGAACCGTTCTGTCCGTTTTGTGCCGTTGCTGTTGTCGGCGTTTGTCGAGAAGAGCAGTGGCTAAACGAAGGCTGTGAGCTTTGTTGCTTGCGGTCGATTTACTCTTTCAAACCCCATACGTTAAGAACTGAAGTATACT');
INSERT INTO marker_sequence VALUES(1346,'6a5cab7be2a5cb1a09a490ce68b3cb80','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAACACACCCTTCCACGTGAACCGTTTTGTTTTGCTTTCGAGTGCTTTGTTGCGCTCGGAGCATGTTTGGGCTTCGCTGCTGGCGCTTGATTGTGCTGGCGGCTCGAGGCCATCAAGCGGCGTTTGGAGTGTGCTTGCGCACATTTTGAATGTCCAAACCTTTTAAACCCATTTGATTGAAAACTGAAGTATACT');
INSERT INTO marker_sequence VALUES(1347,'4929692fd88a1c3056d2288a667e7570','TTCCCGTAGGTGAACCTGCGGAAGGATCTTTCCCACACCTAAAAAACACCCTTCCACGTGAACCGTTTTGTTTTGCTTTCGAGTGCTTTGTTGCGCTCGGAGCATGTTTTGGGCTTCGCTGCTGGCGCTTGATTGTGCTGGCGGCTCGAGGCCATCAAGTGGCGTTTTGAGTGTGCTTTGCGCAATTGAAACGTCGAAACCTTTTTTTTAAACCCATTTGATTGAAAACTGAAGTATACT');
INSERT INTO marker_sequence VALUES(1348,'be43b14b5aa03ee9889bfc2346d13d72','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCACGTGAACCGTATCAACCCTTTAAATTTGGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCACTTTTAAACCCTTTCTTAAAAAACTGAACATACT');
INSERT INTO marker_sequence VALUES(1349,'6b2274b7559580fd933abe72fa45d4b5','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCGAGTAGCCTTTTGTTTTAAACCCATTTCACAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(1350,'7fd41706908ae1cb84aab3647684e321','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACAGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCGAGTAGCCTTTTGTTTTAAACCCATTTCACAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(1351,'6724944286ee84bc2f92ec0c6e1c2219','TTACCGTAGGTGAACCTGCGGAGGGATCATGACCACACCTACATAAACTTTCCACGTGAACCGTATCTTCCCTTTTAGTTGGCGGTCTTGTACCCTATCATGGAGACTGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO marker_sequence VALUES(1352,'a8167d28c16a43274b1fa7b7efd45985','TTCCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(1353,'36602f3d480d05f53126173a2771c2e4','TCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTATCAACCCCATTAATTGGGGGTTTTGTTTGGCGGTGATCGCTAGCTTAATTGCTGGTTGATTACTGCTAGGCGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTATTTTAAACCCTTTCTTAATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1354,'46d57b8df7a8b2fdfaa1ed64206155f2','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACAACCCACGTGAACCGTATCAACCCCCCTTAATTGGGGCTTCCCTGCTGTCTTGTGCTGGCTGAGCTTTGTTGTTCGGCCGGTCGAGGCGGCGGGTTGAGGCCTATCAGCGAACGCTTTTTGTTAGTAGCTTTTTTTTGCGAACGAGCGTTTGTGCCGACTATTGAAGGAATCGCTTTTGCAAGCAGGCCAGTTACCTGTAGCATTGGCTTGAATCCGGAAGCGGTTGGCGCGAGCTAGTAGTTTTGCAAAAGTTTTTTAAACCCTTACTAAATACTGAAAAACT');
INSERT INTO marker_sequence VALUES(1355,'81f86052f357dfc24465a09abf492c78','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACAATCCACGTGAACCGTATCAACCAACTTGTAATTGGGGCCTCCCTGCTGTATTGTGGGTTGAGGCCTATCAGCGAACGCTTTGTTTCTGTTTGTTGTTGGCTGTCTGTTTTTTKGGGGGACTCGCTTGGGCGCCCGGTTTGATTAAGTTCGCTGGGAGGAAAGGTTTGAGGCTCTTTTTGGACGGACGGCTGGCTTTGGACATAAAGTTAGTAGCTTTTTTTAAACCCTTACTAAATACTGAAAAACT');
INSERT INTO marker_sequence VALUES(1356,'f48b3530ddf5868a93d5b559ad3a1b37','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACAATCCACGTGAACCGTATCAACCAACTTGTAATTGGGGCCTCCCTGCTGTATTGTGGGTTGAGGCCTATCAGCGAACGCTTTGTTTCTGTTTGTTGTTGGCTGTCTGTTTTTTTGGGGGACTCGCTTGGGCGCCCGGTTTGATTAAGTTCGCTGGGAGGAAAGGTTTGAGGCTCTTTTTGGACGGACGGCTGGCTTTGGACATAAAGTTAGTAGCTTTTTTTAAACCCTTACTAAATACTGAAAAACT');
INSERT INTO marker_sequence VALUES(1357,'914d49af030df99f78c1a7e2bbc8e906','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACAATCCACGTGAACCGTATCAACCACCCCTTAATTGGGGCTTCCCTGCTGTATTGTGCTGGCTGAGCTTTAATTGTTCGGCCGGTCAAAGCGGTGGGTTGAGGCCTATCAGCGAACGCTTTTCAAGTTAGTAGCTTTTTGTGAACGAGTGTTTGTACCGACTATTGATGGAATCGCTTTTTGCAAGCAGGCCAAATTACCTGTAGTAGAGGTTTGAATCCGGAAGTGGTTGGTGTGAGCTAGTAGTTTGCAAATCTTTTTTAAACCCTTACTAAATACTGAAAAACT');
INSERT INTO marker_sequence VALUES(1358,'cb12fec948fb03509c6846797c8f3808','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACAATCCACGTGAACCGTATCAACCACCCCTTAATTGGGGCTTCCCTGCTGTATTGTGCTGGCTGAGCTTTAATTGTTCGGCCGGTCAAAGCGGTGGGTTGAGGCCTATCAGCGAACGCTTTTCAAGTTAGTAGCTTTTTGTGAACGAGTGTTTGTACCGACTATTGATGGAATCGCTTTTTGCAAGCAGGCCAAATTACCTGTAGTAGAGGTTTGAATCCGGAAGTGGTTGGTGTGAGCTAGTAGTTTGCAAATCTTTTTTTAAACCCTTACTAAATACTGAAAAACT');
INSERT INTO marker_sequence VALUES(1359,'83e04ad8e9d43950e24e815ddb50e010','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACAATCCACGTGAACCGTATCAACCACCCCTTAATTGGGGCTTCCCTGCTGTCTTGTGCTGGCTGAGCTTTAATTGTTCGGYCGGTCAAAGCGGTGGGTTGAGGCCTATCAGCGAACGCTTTTCAAGTTAGTAGCTTTTTGTGAACGAGTGTTTGTACCGACTATTGATGGAATCGCTTTTTGCAAGCAGGCCAAATTACCTGTAGTAGAGGTTTGAATCCGGAAGTGGTTGGTGTGAGCTAGTAGTTTGCAAATCTTTTTTTAAACCCTTACTAAATACTGAAAAACT');
INSERT INTO marker_sequence VALUES(1360,'b6b515f69f9b04a6ed627c507cb23b63','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAACAATCCACGTGAACCGTATCAACCCCCCTTAATTGGGGCTTCCCTGCTGTCTTGTGCTGGCTGAGCTTTGTTGTTCGGCTGGTCGAGGCGGCGGGTTGAGGCCTATCAGCGAACGCTTTTTGTTAGTAGCTTTTTTTTGCGAACGAGCGTTTGTGCCGACTATTGAAGGAATCGCTTTTGCAAGCAGGCCAGTTACCTGTAGCATTGGCTTGAATCCGGACGCGGTTGGCGCGAGCTAGTAGTTTTGCAAAAGTTTTTTTAAACCCTTTACTAAATACTGAAAAACT');
INSERT INTO marker_sequence VALUES(1361,'bcb7f48bf7f61a8c1bedd5237f4e4710','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAACAATCCACGTGAACCGTATCAACCCCCCTTAATTGGGGCTTCCCTGCTGTCTTGTGCTGGCTGAGCTTTGTTGTTCGGCTGGTCGAGGCGGCGGGTTGAGGCCTATCAGCGAACGCTTTTTGTTAGTAGCTTTTTTTTGCGAACGAGCGTTTGTGCCGACTATTGATGGAATCGCTTTTGCAAGCAGGCCAGTTACCTGTAGCATTGGCTTGAATCCGGACGCGGTTGGCGCGAGCTAGTAGTTTTGCAAAAGTTTTTTTAAACCCTTACTAAATACTGAAAAACT');
INSERT INTO marker_sequence VALUES(1362,'2d959f82e21fc13b0ed235b2116367c5','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACAACTAAAAATTCCACGTGAACTGTATCGAACAACTAGTTGGGGGTCTTGTTTGGCGTGCGGCTGCTTCGGTAGCTGCTGCTAGGCGAGCCCTATCACGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTATTTTTTAAACCCATTCTTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(1363,'ae0a3566a49e975ea7bfcfd8f128d2ca','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGTTTGGCGGCGTGCGTGCTGGCCTGTTAAGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGATCGTTTTGGGCTTCGGCTCGAACGAGTAGCTTTAATTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO marker_sequence VALUES(1364,'30bf4df196ae47f5006321126295c54b','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(1365,'35cc612f7b4211c47c1859de4a461fa9','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAATTGGGGATTTTCTCGGTGTGCGGCTAGCTGGCCTTTATTGGCTGGTAGGCTGCGTGCTGGGCGAGTCCTATCATGGCAAACGTTTGGGCTTCGGTCTGAGCAAGTAGCTTTTTTAAACCATTTCTTAAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(1366,'d2e70c0b6f39fe8876b0a5948339363b','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTCCACGTGAACCGTATCAACCCTTTAATATTGGGGGCTGCTGACTGGACTGGCTTCGGCTGGACTGGGTGGCAGCTCTAGCGCGAGCGTTCTGAGCTTCGGCTTGGGGCTAGTAGCTTTTTTTAAACCCATTCTTAACTACTGTAATACT');
INSERT INTO marker_sequence VALUES(1367,'bf26ba8c31c4ad9451e5224ee7c790e1','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCCATGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATCTTTTAAACCCATTCTTGAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(1368,'b51486d26a984ee6613632fd8969546c','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGTTTGGCGGCGTGTGTGCTGGCCTGTTAAGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGATCGTTTTGAGCTTCGGCTCGAGCGAGTAGCTTTAATTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO marker_sequence VALUES(1369,'204b9fd585df16e71c2ff6db3911074e','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTTTAATTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTAGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATTTTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO marker_sequence VALUES(1370,'abccac2dd0d5071cec84150fa2182ecd','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTAAATTGGGGGTCTTGCTTGGTGTGCGGCTGGCTGGCCTTTATTGGCTGGCAGGCTGCGTGCTGGGCGAGCCCTATCATGGCAAACGTTTGGGCTTCGGTCTGAGCTAGTAGCTTTATTTTTAAACCCATTTCTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(1371,'51414f16b7c7844ddf50e69b064a5013','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTCAGTTGGGGGCCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(1372,'189d60b21afd31b7fc103efb16f3d4f5','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAATTGGGGGTCTTGTCTGGCGTATGGCTGCTGCTGTAAAAGGCGGCGGCTGTTGCTGGGTGAGCCCTATCATGGCGAACGTTTGGGCTTCGGTCTGAACAAGTAGCTCTTTTTTAAACCATTACTTATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1373,'4072200772c3c62b69c616d3b8327d96','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTGGCGTGCGGCTGCTGGCCTTTATTGGTTAGCTGGCTGCGTGCTGGGCGAGCCCTATCATGGCGATCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTGTTTTAAACCCATTCTTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(1374,'9523493e843ca70845c4098d97b786a4','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTGGCGTGCTGAGCAAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCGAAAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(1375,'accbf46be25afe6adf2bf2afc1098154','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(1376,'6f428a7008840ad71efe279b4f964f50','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTTAATTGGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCATTTTAAACTCATTCAATAATATACTGAACATACT');
INSERT INTO marker_sequence VALUES(1377,'2a95700955b33ff095bb4765ac5701c8','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTTTCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGACGGGCTCTATCATGGCAATTGGTTTGGGTCCTCCTCGTGGGGAACTAGATCATGAGCCCACTTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO marker_sequence VALUES(1378,'1673f59df5861284c97acedebd2247c8','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(1379,'ccf49bafc9118040d3db2cc5fae19dad','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACGTGAACTGTATCAACCAACTAGTTGGGGGTCTTGTTTGGCGTGCGGCTGCTTCGGTAGCTGTTGCTAGGCGAGCCCTATCACGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTATTTTTTAAACCCATTCTTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(1380,'94b22b9655455c2f020906a53dc4fe25','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTCCACTAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(1381,'fb80afb6a6537f624ff40d7f17dd2f4c','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAAACTTTTCCACGTGAACCGTATCAACCCTTTTAATTGGGGATTTGCTCGGTGTGCGGCTAGCTGGTCTTTATTGGCTGGCAGGCTGCGTGCTAGGCGAGTCCTATCATGGCAAACGTTTGGGCTTYGGCTTGARCTAGTAGCTTTTTTTAAACCATTTCTTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(1382,'bb8fe99ddf33f00d9bb9f3a69070c238','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACACTTTTCCACGTGAACCGTATCACCCCTTTTAATTGGGGATTTGCTCGGTGTGCGGCTAGCTGGCCTTTATTGGCTGGCAGGCTGCGTGCTAGGCGAGTCCTATCATGGCAAACGTTTGGGCTTCGGCTTGAGCTAGTAGCTTTTTTTTTAAACCATTTCTTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(1383,'cce35ad9d6237ccf6b420042496af908','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACATTCCACGTGAACCGTATCAACTTTTTAAATTGGGGGTCTTGTTTGGCGTGCGACTGCTTCGGTAGTTGCTGCTAGGCAAGCCCTATCGCGAGCGTTTGGGCTTCGGTCTGAGCTAGTAGCTTTATTTTTTTTAAACCATTTCTTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(1384,'693eb3fe1f900cc4191b5124a82acc64','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTATCCACGTGAACCGTATCAACCCAAGTAGTTGGGGGCGTTACTGTTCTGCGCAGGCTGTCGATGTGAAAGTCGGCGGCTGGTGCGGAGCGGTGATGCCCTATCATGGCGAAGGTGTTGTGTCCCTCTCGGGGGACGTGATGTCGGCTGCCCTCTGTTTTAAACCCATTCCTAATAACTGATTAATACT');
INSERT INTO marker_sequence VALUES(1385,'8c5fff465555fdfa822c1dacb15a1e28','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTGTCCACGTGAACCGTATCAACCCAAGTAGTTGGGGGCGTTACTGTTCTGCGCAGGCTGTCGATGTGAAAGTCGGCGGCTGGTGCGGGGCGGTGATGCCCTATCATGGCGAAGGTGTTGTGTCCCTCTCGGGGGACGTGATGTCGGCTGCCCTCTGTTTTAAACCCATTCCTAATAACTGATTAATACT');
INSERT INTO marker_sequence VALUES(1386,'9bcb0ae39f1e201b53a49ed6880c0a96','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACCGTATCAAAACCCTTAGTTGGGGGCTTCTGTTCGGCTGGCTTCGGCTGGCTGGGCGGCGGCTCTATCATGGCGAGCGCATGGGCCTTCGGGTCTGAGCTAGTAGCCCTCTTTTTAAACCCATTCCTAAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(1387,'b5e83f787ac170d40fd3b04f000cead1','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACCGTATCAACCCTTTAATATTGGGGGCTGCTGACTGGACTGGCTTCGGCTGGACTGGGTGGCAGCTCTAGCGCGAGCGTTCTGAGCTTCGGCTTGGGGCTAGTAGCTTTTTTTAAACCCATTCTTAACTACTGTAATACT');
INSERT INTO marker_sequence VALUES(1388,'a77f09a90fd6b54658269b2a6c48b738','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCCTGGGCCTCGGCCTGGGTTAGTAGCGTATTTTTTAAACCATTCCTAATTACTGAAAAAACT');
INSERT INTO marker_sequence VALUES(1389,'16ae33060a1b4a7343845abb4b0e6351','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTCCCACGTGAACCGTATCAACCCTTTAATATTGGGGGCTGCTGACTGGACTGGCTTCGGCTGGACTGGGTGGCAGCTCTAGCGCGAGCGTTCTGGGCTTCGGCTTGGGGCTAGTAGCTTTTCTTTTAAACCCATTCTTAATTACTGTAATACT');
INSERT INTO marker_sequence VALUES(1390,'b84047315514dfc365eab35e7b68a035','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGCATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGGCTGTCGATGTCAAAGTCGGCGGCTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO marker_sequence VALUES(1391,'6591d2a48ca18148737841d197747fe1','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTAACAAACCAATAGTTGGGGGCGAGTTTGGCGGCGGCTGCTGGCTTTGGCTGGCTGGCTGCTGCTGGACGAGCTCTATCATGGCGAGCGTTTGGACTTCGGTCTGAACTAGTAGCCCTTCTTTTAAACCCATTTCTAATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1392,'3e9889e1a4ca467a7e80bead6fff0002','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAAAACCCTTAGTTGGGGGTCTCTGTTTGGCTGGCTTCGGCTGGTTGGGCGGCGGCTCCATCATGGCGACCGCTTTGGCTTCGGCCCGAGCTAGTAGCTTCTATTTTAAACCCATTCCTAATTACTGAACATACT');
INSERT INTO marker_sequence VALUES(1393,'c18a70e5298fc15123218d6c4808d57c','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAAAACCCTTTTATTGGGGGCTTCTGTCTGGTCTGGCTTCGGCTGGTCTGGGTGGCGGCTCTATCATGGTGACCRCTCTGGGCTTCGGCTTGGAGTTAGTAGCCCACTTTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO marker_sequence VALUES(1394,'f525fb39044e62b1f2a097951a180d35','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAAAATTTAGTTGGGGGTCTTTTTCGGTGGCGGCTGCTGGCTTTATTGCTGGTGGCTGCTGCTGGGCGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTAATTATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1395,'06bb33dab4da9d3d074b4178356fc5eb','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAAACTTTAGTTGGGGGTCTTTTTCGGCGACGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGAATGAGCCCTATCATGGCGAGCGTTTAGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1396,'014ba3f438f07451d52ef58e81601498','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAAACTTTAGTTGGGGGTCTTTTTCGGCGACGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGAATKAGCCCTATCATGGCGAGCGTTTAGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1397,'c1b055a24cd3cbe55956129ae7d4261c','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAAACTTTAGTTGGGGGTCTTTTTCGGCGACGGTTGCTGGCTTCATTGCTGGCGGCTGCAGTTGGATGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1398,'fb5c95b85ba0bd601b2c1ad80008c43c','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGAGTGGCTGTCTGTCGATGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(1399,'0760232a761b42b634b29f96a395de83','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTCGCTGTCGATGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTGATTACTGAAGATACT');
INSERT INTO marker_sequence VALUES(1400,'354155d5139b0697459987afe0520d9e','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGTCTGCTCTGTGTGGCTGTCTGTCGATGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGATCTGGATCATGAGCCCACTTTTTAAATCCATTCTTAAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(1401,'c845064c265618b5a6d18ec572d00994','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCACCTAGTTGGGGTTCTCGGTAGCCGTGTGGCATGTGGACTCGTTCTACGTGCTGCTGGCGGCTGAGACCTATCATGGCGAGCGTTTGGGCTTTCGGGCCTGGATTAGTAGCCCTCTTTTAAACTCATTCTGTAAAACTGATTATACT');
INSERT INTO marker_sequence VALUES(1402,'af377ed1846b4c693468606612919f64','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCCTGTCCTGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATCTTTTAAACCCATTCTTGAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(1403,'94c48d7e8cb3eb7d0aaa15bb15b308aa','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCCTGTCCTGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGRTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTCAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(1404,'507944919ad0d0ffe6d347c4ac551ecb','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGKCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATTTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(1405,'7848a2de5900d170dbea9266dec68600','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCTGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACCGAGCCAGTAGCCCTTTTCTTTCAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(1406,'e5aee44564f3626b6a4e4187bb648bb7','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCYWGTCCYGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(1407,'bf70bd2daac24263c5e41d1a4cae3d1a','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCATTTAGTTGGGGGCTAGTCCTGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(1408,'d4710310a11c0cc546e6a18f6eb2ed73','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCATTTAGTTGGGGGCTTGCTCGGGTGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGGCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTCTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(1409,'3c50b66a456d94cb5353652d20f871ff','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCATTTAGTTGGGGGCTTGTCCTGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(1410,'12ccc0977c10d0368bc1e952bff77e75','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTCTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(1411,'8a5056f910a345b5a88cfc028a8178fa','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTTCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(1412,'17355e0662c13b70191a137683b53c77','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGTTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTCTTAATTACTGAACATACT');
INSERT INTO marker_sequence VALUES(1413,'78cf5eb050d52e4da46c2663a5b65d20','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTTAGTTGGGGGTCTTGCTTGGCGTGCGGCTGCTGGCCTTTATTGGTTGGCTGGCTGCGTGCTGGGCGAGCCCTATCATGGCGATCGTTTGGACCTCGGTCTGAGCTAGTAGCTTTTGTTTTAAACCCATTCTTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(1414,'14f9b916c45da114ae6ad243c3b3a3e9','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTGATTATTGGGGGCTGCTGACTGGACTGGCTTCGGCTAGACTGGGCGGCGGCTCTAGCGCGACCGTTCTGGGCTTCGGCTTGGGGCTAGTAGCTTATTTTAAACCCATTCTTAATTTACTGAAATACT');
INSERT INTO marker_sequence VALUES(1415,'8aef3951805f9df72761965a444e1cc4','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTGATTATTGGGGGCTGCTGACTGGACTGGCTTCGGCTGGACTGGGCGGCGGCTCTAGCGCGAGCGTTCTGGGCTTCGGCTTGGGGCTAGTAGCTTTTCTTTTAAACCCATTCTTAATTTACTGAAATACT');
INSERT INTO marker_sequence VALUES(1416,'6ed02912b2f7fd120bde804f02f7a5a3','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAATTGGGGGCTTGTTTGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGAGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCACTTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(1417,'ffe9bc68a52fad924e7198da946de675','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(1418,'39aebaff88cc30e75a121fe9b14f6ca5','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCGAGTAGCCTTTTGTTTTAAACCCATTTCTCAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(1419,'f0a78c8ba775e42ce018e769875fc901','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO marker_sequence VALUES(1420,'0e6a252f97b48cae486abc3721261ddc','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTTCACAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(1421,'858777bbc6e57d26b8330f9007b90ac7','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTCTGGCGTATGGCTGCTGCTGTAAAAGGCGGCGGCTGCTGTTGGGTGAGCCCTATCATCGACGAACGTTTAGGCTTCAGTCTGGACAAGTACTCTCTTTTAAACCATTACTTATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1422,'a12e66457b55f3b48615d3606a0b7b27','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCATTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTGTTTTAAACCATTTAACAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(1423,'46c631ba5575cacc25f1e9d4d5ef96cc','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCATTTTGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTWAACCCATTTAACAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(1424,'24009c543b86de39ea433541041f65f5','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCATTTTGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCATTTAACAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(1425,'7d5ba154869497ef9ebeccad0ac26fe0','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(1426,'5954e4e70b640a6ca19d972387aeadaa','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(1427,'adbf589e479defef4edc82a06338e61b','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTTAATTGGGGGCTTGTTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCACTTTTAAACCCTTTCTTAAAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(1428,'ee2f0522589c99870ed046a2d48c3ecc','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTAAATTGGGAGCTTTCGTCTGGCCGGCCGGCTTTTGGCTGGTTGGGCGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCTTGGGCTAGTAGCTTCTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO marker_sequence VALUES(1429,'56b2abe6202721a09d052c7d2689fc63','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGCTTTCGGCTGACTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCTTGGGCTAGTAGCTTCTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO marker_sequence VALUES(1430,'5517b62e19d6566b08fabe4b994b99ff','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTCCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO marker_sequence VALUES(1431,'a8fd7e7b2073a7c1cb26fa060b152656','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCATATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO marker_sequence VALUES(1432,'388980472e820fa93a31a6781955849d','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTATTACCAAAGTTAGTTGGGGACTCCCTGTTGTTGGTCGATGTAGCAATATGTTGACCGGCGGCGGGTTGAGACCTATCAAACGACGGCGACGAATGTGCGGGCTGAAAAGTCGGCACGTTTGTTTCTGAAGTTTCTCTTTTAAACTCCTTCTTATTTAACTGAACATACT');
INSERT INTO marker_sequence VALUES(1433,'e2eb2e800b1f113a1242417c5f152332','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTAAAACTTTAGTTGGGGACTCCTCATTGGCAGTTTGTTCTGTTGGTGAGTTGAGGCCTATCAAACGATCAATTTGGGCTGCAAAGTCGGAGTTGAGAGTTTCTTTTTTAAACCCATGCTTTTATTACTGAAAATACT');
INSERT INTO marker_sequence VALUES(1434,'c1c159ae5ae463e54e716ce5c931daf7','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTCAACCTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCCGGGCTGCTGGTGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(1435,'ebc55e3114dc89a9bb3e23c4261c02fa','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTCAACCTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGTTGGTGGGTTGAGGCCTATCAAAGCGAGTGATTTGGGCCGCAAGGTCTGAGTTGCGAGTTTTCCTTTTAAACCCATTACTTAAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(1436,'91cb922176351e35556563036bc82277','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCAAATATTTTGGGGGTCTTGTCTGGCGTATGGCTGCTGCTGTAAAAGGCGGCGGCTGTTGCTGGGTGAGCCCTATCATGGCGAACGTTTGGGCTTCGGTCTGAACAAGTAGCTCTTTTTTAAACCATTACTTATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1437,'d1537e6962d391b4daeb86f39b172729','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(1438,'bad52d46f2c0e8db2034aa71f00e19b7','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTTCCACGTGAACCGTAACAAACCAATAGTTGGGGGCGAGTTTGGCGGCGGCTGCTGGCTTTGGCTGGCTGGCTGCTGCTGGACGAGCTCTATCATGGCGAGCGTTTGGACTTCGGTCTGAACTAGTAGCCCTTCTTTTAAACCCATTCCTAATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1439,'6289b62a54bd257e3552c6bdcfe1efea','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAACTTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGTCTGCTCTGTGTGGCTGTCTGTCGATGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGATCTGGATCATGAGCCCACTTTTTAAATCCATTCTTAAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(1440,'4e778a063acb21f8d7a82b53a652d2ec','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAATTCACGTGAACCGTTTCAAACAAATAGTTGGGGGTTTTGTTTGGCGGCGGCTGCTGACTTTATTGTTGGCGGCTGCTGCTGGGCGAACCCTATCATGGCGAACGTTTGGACTTTGGTCTGAGCTAGTAGCTTTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(1441,'c21bace7ad4663d2bf1eee832c662b0e','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAAATTTCCACGTGAACCGTTTCAACCAAAAGTTGGGGGTCTTGTTTGGCGGTGACTGCTGGCTTTATTGCTGGCGGCTGCTGCTGGACGAGCCCTATCATGGCGAAAGTTTGGACTTCGGTCTGAGCTAGTAGTTATTATTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(1442,'b9119916a84bcc1e52191c6f468f1d53','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTGTCCACGTGAACTGTACTGAAGATGATTGGGGCGTGCTGGGCGTGCGTGTGCGGCTTCGGCTGCGTGCGTGTGTTTGGCGTGCTCATCAAACGAGGAGGCGGGTCGCAAGGCCTGCTTTAGTAGTTACTCTTTTAAACCCTTTTACTATTAACTGATATACT');
INSERT INTO marker_sequence VALUES(1443,'8a8aff1be29e1eb884987538f35896d7','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTGTCCACGTGAACTGTGCTGAAGATGATTGGGGCGTGCTGGGCGTGCGTGTGCGGCTTCGGCTGCGTGCGTGTGTTTGGCGTGCTCATCAAACGAGGAGGCGGGTCGCAAGGCCTGCTTTAGTAGTTACTCTTTTAAACCCTTTTACTATTAACTGATATACT');
INSERT INTO marker_sequence VALUES(1444,'2ccd0d342fb2d65d9e596d0a56fc2934','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTGTCCACGTGAACTGTGTCGATGTTGGGGCGTGCTGGGCGTGCGTGTGTGTGTGGCTTCGGCCGCGTGCGTGCGCGTGTTCGGTTGTGCTCATCAAACGAAGAGGCGGGTCGCAAGGCCTGTGTTCTTTGTTACTGTTTTAAATCCTTCTTATACACTGATTGTACT');
INSERT INTO marker_sequence VALUES(1445,'568fc4f64dfb112bb476064fb1554066','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTGTCCACGTGAACTGTGTCGATGTTGGGGCGTGCTGGGCGTGCGTGTTTGTGTGGCTTCGGCCGCGTGCGTGCGCGTGTTCGGTTGTGCTCATCAAACGAGGAGGCGGGTCGCAAGGCCTGCGTTCTTTGTTACTGTTTTAAATCCTTCTTGTACACTGATTGTACT');
INSERT INTO marker_sequence VALUES(1446,'be05ff935418be15ac22b1375e5595c1','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTCCACGTGAACCGTATCAACCCTTTAATATTGGGGCTGCTGACTGGACTGGCTTCGGCTGGACTGGGTGGCAGCTCTAGCGCGAGCGTTCTGAGCTTCGGCTTGGGGCTAGTAGCTTTTTTAAACCCATTCTTAACTACTGTAATACT');
INSERT INTO marker_sequence VALUES(1447,'a41c22a55e202d73d0ac8d38b7278cf8','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTCCCCCGTGAACCGTATCAACCCTTTTTTATTGGGGGCTGCTGACTGGACTGGCTTCGGCTGGACTGGGTGGCGGCTCTAGCGCGACCGTTCTGGGCTTCGGCTTGGGGCTAGTAGCTTTCTTTTTAAACCCATTCTTAATTTACTGAAATACT');
INSERT INTO marker_sequence VALUES(1448,'15a72c0e2a3ebbdc2c450833cf2acec7','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACACTCTTAGTTGGGGCTTCTGTCTGGCTGGCTTCGGCCGGGTGGGCGGAGGCTCTATCATGGCGACCGCTTGGGCCTCGGCTCGAGCTAGTAGCCCACATTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO marker_sequence VALUES(1449,'369e7108969ee6e31faf3d1727758fd1','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATTAATTGGGGCTAGCCTGGTAACGGCTGTTGGCTGTAATGGCTGACGGCTGTAACTGGGCAGGCCCTAACGCGACCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTATTTTAAACCATTACTAATTACTGAAAAAACG');
INSERT INTO marker_sequence VALUES(1450,'3d2b83b12f28c97b33e47423d44644d7','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(1451,'e3ec7579f77c7a0a268985570888abd7','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCATTTAGTTGGGGCTTGCTCGGGTGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGGCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTCTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(1452,'f71da539236d7298a3336f35c67d4ee2','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCATTTAGTTGGGGGCTTGCTCGGGTGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGGCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTCTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(1453,'ac4a7551b8e1964a99cdb356412ccae0','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCATTTAGTTGGGGGCTTGCTCGGGTGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGGCGGGCCCTATCATGGCGTGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTCTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(1454,'c10c83e38570f321825aba6f0040eee8','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAAATTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTTCTTTTAAACCCATTCTTTAATTACTGAAATACT');
INSERT INTO marker_sequence VALUES(1455,'4e5271ad5412f2f388699b6b7543c742','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAGATTGGGAGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCCTTCTTTAATTACTGAAATACT');
INSERT INTO marker_sequence VALUES(1456,'37a7b1d2bd2cc842ece2b42d4f75a1cd','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAGATTGGGAGCTTGCTCGGCGGCGTGCGTGCTGGCCTGWAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCCTTCTTTAATTACTGAAATACT');
INSERT INTO marker_sequence VALUES(1457,'2e1cfd0b59a262f4d1c7e524d012081c','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCCTTATAATTGGGGGCTTGCTTGGCGGCGTGCGTGCTGGCCTATTATGGGTCGGCGTGCTGCTGCTGGGCGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTTAAACCCATTCTTTAATTACTGAAATACT');
INSERT INTO marker_sequence VALUES(1458,'614c7c877c191e46a65c4e1d07bf4c92','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCCTTATAATTGGGGGCTTGCTTGGCGGCGTGCGTGCTGGCCTATTATGGGTCGGCGTGCTGCTGCTGGGCGAGCTCTATCATGGCGAGCGYTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTTAAACCCATTCTTTAATTACTGAAATACT');
INSERT INTO marker_sequence VALUES(1459,'036430ad3943c47104acec43b6e8f4f1','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCCTTTAATTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTAGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCACTTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO marker_sequence VALUES(1460,'52d2775e6d190ce2b11f9e4169ed79fa','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCTTGATTATTGGGGGCTGCTGACTGGACTGGCTTCGGCTGGACTGGGCGGCGGCTCTAGCGCGACCGTTCTGGGCTTCGGCTTGGGGCTAGTAGCTTTCATTTTAAACCCATTCTTAATTTACTGAAATACT');
INSERT INTO marker_sequence VALUES(1461,'bd9f7c026231518694e42c5f0aa42558','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCTTTATTATTGGGGCTGCTGACTGGACTGGCTTCGGCTGGACTGGGTGGCAGCTCTAGCGCGAGCGTTCTGGGCTTCGGCTTGGGGCTAGTAGCTTTTCTTTTAAACCCATTCTTAACTACTGTAATACT');
INSERT INTO marker_sequence VALUES(1462,'9d39facd71e9a9882c3a52d16d7c16b8','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAATTGGGGGTCTTGTCTGGCGTATGGCTGCTGCTGTAAAAGGCGGCGGCTGTTGCTGGGTGAGCCCTATCATGGCGAACGTTTGGGCTTCGGTCTGAACAAGTAGCTCTTTTTTAAACCATTACTTATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1463,'611adb2e200b51580231fbd3d7e2cdbc','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAATTGGGGTCTTGTCTGGCGTATGGCTGCTGCTGTAAAAGGCGGCGGCTGTTGCTGGGTGAGCCCTATCATGGCGAACGTTTGGGCTTCGGTCTGAACAAGTAGCTCTTTTTTAAACCATTACTTATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1464,'f7172611dceeaf56cb1ebb6c6c09244e','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTCTGGCGTATGGCTGCTGCTGTAAAAGGCGGCGGCTGCTGTTGGGTGAGCCCTATCATCGACGAACGTTTAGGCTTCAGTCTGGACAAGTACTCTCTTTTAAACCATTACTTATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1465,'546b1dc9a898762b2a9e53616a88bde2','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTTTACT');
INSERT INTO marker_sequence VALUES(1466,'04e3b3287f8294563e2601d6e11c3a74','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAACCTTTAGTTGGGGGTCTTTTTCGGCGGCGGCTGCTGGTTTAATTACTGGCGGTTGCTGCTGGGAGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCATTATTACTGATTATACT');
INSERT INTO marker_sequence VALUES(1467,'6d25e9a730b3de86d7da69f75693d2ff','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAATCCATTTAGTTGGGGGCTAGTCCTGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(1468,'a617ef702a606e8fa6c270a7cf391bce','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTATCAATCCATTTAGTTGGGGGCTAGTCCTGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTTAAACCCATTCTTGACT');
INSERT INTO marker_sequence VALUES(1469,'0e40eb87b3e706aad90568a57ffe5b9c','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTCAACCTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(1470,'f3dae98682339abb95053bc01213c6dd','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTGTTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(1471,'6e209f0a5d8ce42a64c7bbce6aba389d','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(1472,'89d4ba3ead2861ddd81d800b274dead8','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGGCTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(1473,'ad19937af794f90448b7092a70958d8e','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(1474,'c9a4662af671e7f9486fce74a3215213','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTATCGAACAACTAGTTGGGGGTCTTGTTTGGCGTGCGGCTGCTTCGGTAGCTGCTGCTAGGCGAGCCTATCACGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTATTTTTTAAACCCATTCTTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(1475,'f2ba78db2f0b4eb5040b7de6e3ab4775','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTATTGTCTGTTGTTGGGGGCTTGGGCTGGCGTTTCGGCGCCGGCTCGGGCTCCATCAAACGAGGCTCTGGGCTGCAAAGTCTGGGGTAGTAGTTACATTTTTTGTAAACCCTTTTCTTAATTTTTCTGATCATACT');
INSERT INTO marker_sequence VALUES(1476,'de9046cb975eae4d86290e401e19eae1','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCCGCCGCTTGCGGTGGCTTCATCAAACGAGGCTCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTTCGTATTTTCTGATCATACT');
INSERT INTO marker_sequence VALUES(1477,'a9ea6bc2f3954f25bfa79f85cee2ecdd','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCCTGTCGTTCGCGGCGGCTCCATCAAACGAGGCTCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTCCTTTATTTTCTGATCATACT');
INSERT INTO marker_sequence VALUES(1478,'b061545e6120779e5cd1b643a28cf6d9','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCCTGTCTGCCTGTTGGCGGGCGGCTCCATCAAACGAGGCCTTGGGCTGAAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTACCCAACCTTTCTGATCATACT');
INSERT INTO marker_sequence VALUES(1479,'6f0db7964d0b012c62e04315e4efded1','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCCTGTCTGCCTGTTGGCGGGCGGCTCCATCAAACGAGGCTCTGGGCTGAAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTACTCAACCTTTCTGATCATACT');
INSERT INTO marker_sequence VALUES(1480,'ff677ea4f194c6dad497cb138545fffd','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCGTGTCGTTCGCGGCGGCTCCATCAAACGAGGCTCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTTACCACTTTTTCTGATCATACT');
INSERT INTO marker_sequence VALUES(1481,'b2aed55a231718a3b05f2c6015684b41','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGGCTGCTGCTGCTGCTTCGGTGGCGGCGTGCTCCCATCAAACGAGGCCCTGGGCTGCAAAGTCGGGGGTAGTAGTTACTTTTTGTAAACCCTTTTCCTGTATTTTCTGAATATACT');
INSERT INTO marker_sequence VALUES(1482,'4095581ad779eeb56c6190a9c9eaa952','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCACGTGAACTGTGTTGTCGATGTTGGGGGCTGGGCTGGCGTTTGTTCGTCGGTTGGGCTCCATCAAACGAGGCTCTGGGCTGAAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTTTTAAGTTTTTCTGAATATACT');
INSERT INTO marker_sequence VALUES(1483,'945f5df4c2ab4e4b47d3dcf710557519','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAACTTTCCCCGTGAACCGTATCAACCCTTTTTTATTGGGGGCTGCTGACTGGACTGGCTTCGGCTGGACTGGGTGGCGGCTCTAGCGCGACCGTTCTGGGCTTCGGCCTGGGGCTAGTAGCTTTCTTTTTAAACCATTCTTAATTTACTGAAATACT');
INSERT INTO marker_sequence VALUES(1484,'198ffa2861a3389aa23ff7c6e2ecfaf2','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAATCTTTCCACGTGAACCGTATCAACCCATTAGTTGGGGGCTTGCTGTGTGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTACGCGGCGGGCCCTATCACTGGCGATCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCCAGCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(1485,'3bf5410f93f0acc727f67b09edbcf975','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAATCTTTCCACGTGAACCGTATCAACCCCCTTCGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGGCGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCCCTATTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO marker_sequence VALUES(1486,'4541e767ffb21c357cb5d2621acd0220','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAAATTTCCACGTGAACCGTTTCAACCCAAAAAATTGGGGGTCTTGTTTGGTGGTGGCTGCTGGCTTTATTGCTGGCGGCTGCTGCTGGATGAGCCCTAACGCGAAAGTTTAGACTTCGGTCCGGGCTAGTAGCTTTATTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(1487,'28eda0a77a524e236eee93545c25f152','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAACACTTTCCACGTGAACCGTATCAACCCCTTAAGATTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCCTTCTCTAATGACTGAAATACT');
INSERT INTO marker_sequence VALUES(1488,'8ac99f38a140c704b6240b12a5d3b01b','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAACACTTTCCACGTGAACCGTATCAACCCCTTCAAATTGGGGGCTTGCTCGGCGGTGGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGTTGCTGGGTGGGCTCTATCATGGGCGAGCGTTTGAGCTTCGGCTCGAGCTAGTAGCTTTTCTTTTAAACCCCTTCTTTAATAACTGAAATACT');
INSERT INTO marker_sequence VALUES(1489,'a8472295a350bb6dd3d1ba3e943cb207','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAACACTTTCCACGTGAACCGTATCAACCCTTCAAATCGAGGGCTTGCTCGGCGGTGGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGTTGCTGGGTGGGCTCTATCATGGGCGAGCGTTTGAGCTTCGGCTCGAGCTAGTAGCTTTTCTTTTAAACCCCTTCTTGAATAACTGAAATACT');
INSERT INTO marker_sequence VALUES(1490,'422fdfd853c35bfa3052203368ea0aed','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAACTTTCCACGTGAACCGTATTTTTGACGTTGGGGACTCCTGGCTTCGGCCGGTTGAGACCTATCACGCGACCGCTCGGGCTGAAAAGTCGGGGCCAGTAGCCTTTTTTAAACCCATTCCGAACTACTGAACCATACT');
INSERT INTO marker_sequence VALUES(1491,'bc1fd2ec3df354d0302c02c5b4822829','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO marker_sequence VALUES(1492,'83b6b35968d32e2364d95f63427615aa','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAACTTTCCACGTGAACTGTGTTGTTTGTTGTTGGGAGCTTGGCTGACGTTTCGGCGTTGGTAGAGGTCCATCAAACGAGGCTCTGGGCTGAAAAGTCGAGGGTAGTAGTTACTTTTGTAAACCCTTTCTTAAATTCTGATGATACT');
INSERT INTO marker_sequence VALUES(1493,'18055b7d13e07928ff23dc1ded700dde','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAACTTTTCCACGTGAACCGTATTTTTGACGTTGGGGACTCCTGGCTTCGGCCGGTTGAGACCTATCACGCGACCGCTCGGGCTGAAAAGTCGGGGCCAGTAGCCTTTTTTTAAACCCATTCCGAACTACTGAACCATACT');
INSERT INTO marker_sequence VALUES(1494,'8fe470cfc5374219043fb54f9fbbe9ec','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAAATTTTCCACGTGAACCGTATTTTTGACGTTGGGGACTCCTGGCTTCGGCCGGTTGAGACCTATCACGCGACCGCTCGGGCTGAAAAGTCGGGGCCAGTAGCCTTTTTTTAAACCCATTCCGAACTACTGAACCATACT');
INSERT INTO marker_sequence VALUES(1495,'76256930e82daf27b7988f640125a3c1','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAACACTTTCCACGTGAACTGTATCAACCCTTTTAATTGGGAGCCTGCTAGGCGGCGGCGTGTTGACCTGTAATGGGCTGACATACTGCTGCTAGACGGGCTCTATCATAGGCGAGCGTTTGGACTTCGGTCCGAGCTAGTAGCTTTTTTAAACCCTTTCCTAATTACTGAACATACT');
INSERT INTO marker_sequence VALUES(1496,'8e8018dc301dfbb32611ab5656dd1e2e','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCGTGTCGTTCGCGGCGGCTCCATCAAACGAGGCTCTGGGCTGAAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACTCATTGCATTATTTTCTGATCATACT');
INSERT INTO marker_sequence VALUES(1497,'50d012ecc53cec368cd2b816f352a73d','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTTAAAAAACCATCCACGTGAACCGTATTGTCAAAACATTTGGGGACTCCTTGCTAGCGGGCTTTCGGGCTTGCCGGTCGGTTGAGACCTAACACGAGAGCCTTGGCTGAAAAGCCGGGGTGAGTAGTTTCTTTTTAAACCCTTTACTAAAAACTGAAAAACT');
INSERT INTO marker_sequence VALUES(1498,'8518ae1aa5511454eec68a67c555270a','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTTAAAAAATTCCACGTGAACTGTATTGTCAACCAAATTCGGGGACTCCTTGCTAGTGTGCTTTCGGGCGTGCCGGTAGGTTGAGACCCATCAAACGAAAACATCGACTGAAAGGTCGGAGCCAGTAGTTACCTTTGTAAACCCTTTACTAAATACTGAAAAACT');
INSERT INTO marker_sequence VALUES(1499,'3b2049d7070d6fb291909ce4bf2f01bf','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTTAAAAAATTCCACGTGAACTGTATTGTCAACCAAATTCGGGGATTCCTTGCTAGCGTGCCTTCGGGCGTGCCGGTAGGTTGAGACCCATCAAACGAAAACATCGGCTGAAAGGTCGGAGCCAGTAGTTACCTTTGTAAACCCTTTACTAAATACTGAAAAACT');
INSERT INTO marker_sequence VALUES(1500,'5a7076479a2d227a52382f0a559453f5','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTTAAAAATTTCCACGTGAACTGTATTGTCAACCAAATTCGGGGACTCCTTGCTAGCGTGCCTTCGGGCGTGCCGGTAGGTTGAGACCCATCAAACGAAAACATCGGCTGAAAGGTCGGAGCCAGTAGTTACCTTTGTAAACCCTTTACTAAATACTGAAAAACT');
INSERT INTO marker_sequence VALUES(1501,'4a2d6b8f1ad2243d2a56a61cc37c151c','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTTAAAACTTTCCACGTGAACCGTTTCAACCTTTTATTGGGGCCTGCTAGGCGGAGGCGTGTTGACCTATTATAGGCTGATATGCTACTGCTAGGCGGGCTCCATCAAAGGCGATTGTTTGGACTTTTGTCTGAGCAGTTGCTTTTTATTTTAAACCATTTCTAAATACTGAATATACT');
INSERT INTO marker_sequence VALUES(1502,'9ab3d2babb9cf065611370d332ea7397','TTTCCGTAGGTGAACCTGCGGAAGGATCATTACCACACCTTAAAACTTTCCACGTGAACCGTTTCAACCTTTTATTGGGGGCCTGCTAGGCGGAGGCGTGTTGACCTATTATAGGCTGATATGCTACTGCTAGGCGGGCTCCATCAAAGGCGATTGTTTGGACTTTTGTCTGAGCAGTTGCTTTTTATTTTAAACCATTTCTAAATACTGAATATACT');
CREATE TABLE synonym (
	id INTEGER NOT NULL, 
	taxonomy_id INTEGER, 
	name VARCHAR(100) NOT NULL, 
	PRIMARY KEY (id), 
	FOREIGN KEY(taxonomy_id) REFERENCES taxonomy (id), 
	UNIQUE (name)
);
INSERT INTO synonym VALUES(1,85,'Achlya bisexuallis');
INSERT INTO synonym VALUES(2,85,'NCBI:taxid112076');
INSERT INTO synonym VALUES(3,88,'NCBI:taxid482747');
INSERT INTO synonym VALUES(4,88,'Saprolegnia sp. WD1B');
INSERT INTO synonym VALUES(5,90,'Peronospora halstedii');
INSERT INTO synonym VALUES(6,91,'NCBI:taxid763924');
INSERT INTO synonym VALUES(7,91,'Phytophthora capsici LT1534');
INSERT INTO synonym VALUES(8,92,'NCBI:taxid1048749');
INSERT INTO synonym VALUES(9,92,'NCBI:taxid134458');
INSERT INTO synonym VALUES(10,92,'NCBI:taxid622258');
INSERT INTO synonym VALUES(11,92,'NCBI:taxid708041');
INSERT INTO synonym VALUES(12,92,'Phytophthora cinnamomi var robiniae');
INSERT INTO synonym VALUES(13,92,'Phytophthora cinnamomi var. cinnamomi');
INSERT INTO synonym VALUES(14,92,'Phytophthora cinnamomi var. cinnamomi CBS 144.22');
INSERT INTO synonym VALUES(15,92,'Phytophthora cinnamomi var. parvispora');
INSERT INTO synonym VALUES(16,92,'Phytophthora cinnamomi var. robiniae');
INSERT INTO synonym VALUES(17,93,'Halophytophthora cryptogea');
INSERT INTO synonym VALUES(18,93,'NCBI:taxid2651249');
INSERT INTO synonym VALUES(19,93,'Phytophthora cryptogea f.sp. begoniae');
INSERT INTO synonym VALUES(20,94,'Botrytis infestans');
INSERT INTO synonym VALUES(21,94,'NCBI:taxid403677');
INSERT INTO synonym VALUES(22,94,'NCBI:taxid887080');
INSERT INTO synonym VALUES(23,94,'NCBI:taxid887081');
INSERT INTO synonym VALUES(24,94,'Phytophthora infestans 90128');
INSERT INTO synonym VALUES(25,94,'Phytophthora infestans PIC99189');
INSERT INTO synonym VALUES(26,94,'Phytophthora infestans T30-4');
INSERT INTO synonym VALUES(27,94,'Phytophthora infestans strain T30-4');
INSERT INTO synonym VALUES(28,95,'Phytophthora x megasperma');
INSERT INTO synonym VALUES(29,96,'NCBI:taxid4791');
INSERT INTO synonym VALUES(30,96,'Phytophthora nicotianae var. parasitica');
INSERT INTO synonym VALUES(31,97,'NCBI:taxid1317063');
INSERT INTO synonym VALUES(32,97,'NCBI:taxid1317064');
INSERT INTO synonym VALUES(33,97,'NCBI:taxid1317065');
INSERT INTO synonym VALUES(34,97,'NCBI:taxid1317066');
INSERT INTO synonym VALUES(35,97,'NCBI:taxid1368100');
INSERT INTO synonym VALUES(36,97,'NCBI:taxid291273');
INSERT INTO synonym VALUES(37,97,'NCBI:taxid761204');
INSERT INTO synonym VALUES(38,97,'Phytophthora parasitica CJ01A1');
INSERT INTO synonym VALUES(39,97,'Phytophthora parasitica INRA-310');
INSERT INTO synonym VALUES(40,97,'Phytophthora parasitica P10297');
INSERT INTO synonym VALUES(41,97,'Phytophthora parasitica P1569');
INSERT INTO synonym VALUES(42,97,'Phytophthora parasitica P1976');
INSERT INTO synonym VALUES(43,97,'Phytophthora parasitica var. nicotianae');
INSERT INTO synonym VALUES(44,97,'Phytophthora parasitica var. piperina');
INSERT INTO synonym VALUES(45,98,'NCBI:taxid388631');
INSERT INTO synonym VALUES(46,98,'Phytophthora citrophthora var. clementina');
INSERT INTO synonym VALUES(47,99,'NCBI:taxid1490529');
INSERT INTO synonym VALUES(48,99,'Phytophthora drechsleri var. cajani');
INSERT INTO synonym VALUES(49,101,'NCBI:taxid611791');
INSERT INTO synonym VALUES(50,101,'Phytophthora palmivora var. palmivora');
INSERT INTO synonym VALUES(51,101,'Phytophthora palmovora');
INSERT INTO synonym VALUES(52,101,'Pythium palmivorum');
INSERT INTO synonym VALUES(53,104,'Lagenidium giganteum f. caninum');
INSERT INTO synonym VALUES(54,104,'NCBI:taxid1440116');
INSERT INTO synonym VALUES(55,105,'NCBI:taxid266094');
INSERT INTO synonym VALUES(56,105,'NCBI:taxid482634');
INSERT INTO synonym VALUES(57,105,'NCBI:taxid482635');
INSERT INTO synonym VALUES(58,105,'NCBI:taxid482638');
INSERT INTO synonym VALUES(59,105,'NCBI:taxid482653');
INSERT INTO synonym VALUES(60,105,'NCBI:taxid482656');
INSERT INTO synonym VALUES(61,105,'NCBI:taxid482657');
INSERT INTO synonym VALUES(62,105,'NCBI:taxid658427');
INSERT INTO synonym VALUES(63,105,'Phytophthora applanata');
INSERT INTO synonym VALUES(64,105,'Phytophthora cactorum var. applanata');
INSERT INTO synonym VALUES(65,105,'Phytophthora sp. 748');
INSERT INTO synonym VALUES(66,105,'Phytophthora sp. 753');
INSERT INTO synonym VALUES(67,105,'Phytophthora sp. 764A');
INSERT INTO synonym VALUES(68,105,'Phytophthora sp. 798');
INSERT INTO synonym VALUES(69,105,'Phytophthora sp. 813');
INSERT INTO synonym VALUES(70,105,'Phytophthora sp. CSL 20316642');
INSERT INTO synonym VALUES(71,106,'Globisporangium irregulare DAOM BR486');
INSERT INTO synonym VALUES(72,106,'NCBI:taxid1223557');
INSERT INTO synonym VALUES(73,106,'NCBI:taxid482709');
INSERT INTO synonym VALUES(74,106,'NCBI:taxid482718');
INSERT INTO synonym VALUES(75,106,'Pythium irregulare');
INSERT INTO synonym VALUES(76,106,'Pythium sp. 766');
INSERT INTO synonym VALUES(77,106,'Pythium sp. 851A');
INSERT INTO synonym VALUES(78,107,'NCBI:taxid1612439');
INSERT INTO synonym VALUES(79,107,'Saprolegnia monoica var. acidamica');
INSERT INTO synonym VALUES(80,109,'NCBI:taxid107466');
INSERT INTO synonym VALUES(81,109,'Pythium pachycaule var. ramificatum');
INSERT INTO synonym VALUES(82,112,'NCBI:taxid129363');
INSERT INTO synonym VALUES(83,112,'Phytophthora fragariae var. fragariae');
INSERT INTO synonym VALUES(84,118,'NCBI:taxid1223555');
INSERT INTO synonym VALUES(85,118,'Pythium aphanidermatum DAOM BR444');
INSERT INTO synonym VALUES(86,118,'Rheosporangium aphanidermatum');
INSERT INTO synonym VALUES(87,119,'Aecidium candidum');
INSERT INTO synonym VALUES(88,119,'Albugo candida 2VRR');
INSERT INTO synonym VALUES(89,119,'Albugo candida Ac 2V');
INSERT INTO synonym VALUES(90,119,'Albugo candida Ac Bol');
INSERT INTO synonym VALUES(91,119,'Albugo candida Ac Bot');
INSERT INTO synonym VALUES(92,119,'Albugo candida AcNc2');
INSERT INTO synonym VALUES(93,119,'NCBI:taxid1204551');
INSERT INTO synonym VALUES(94,119,'NCBI:taxid1204552');
INSERT INTO synonym VALUES(95,119,'NCBI:taxid1204555');
INSERT INTO synonym VALUES(96,119,'NCBI:taxid1204556');
INSERT INTO synonym VALUES(97,119,'NCBI:taxid911350');
INSERT INTO synonym VALUES(98,122,'NCBI:taxid1094619');
INSERT INTO synonym VALUES(99,122,'NCBI:taxid4789');
INSERT INTO synonym VALUES(100,122,'Phytophthora megasperma f. sp. glycinea');
INSERT INTO synonym VALUES(101,122,'Phytophthora sojae strain P6497');
INSERT INTO synonym VALUES(102,124,'NCBI:taxid246205');
INSERT INTO synonym VALUES(103,124,'NCBI:taxid2501433');
INSERT INTO synonym VALUES(104,124,'Phytophthora vignae f. sp. adzukicola');
INSERT INTO synonym VALUES(105,124,'Phytophthora vignae f. sp. vignae');
INSERT INTO synonym VALUES(106,130,'Pythiomorpha gonapodyides');
INSERT INTO synonym VALUES(107,131,'Pythium splendens');
INSERT INTO synonym VALUES(108,132,'NCBI:taxid1223556');
INSERT INTO synonym VALUES(109,132,'Pythium arrhenomanes ATCC 12531');
INSERT INTO synonym VALUES(110,133,'NCBI:taxid1130070');
INSERT INTO synonym VALUES(111,133,'Phytopythium chamaihyphon');
INSERT INTO synonym VALUES(112,133,'Phytopythium sp. MAB-2011f');
INSERT INTO synonym VALUES(113,133,'Pythium chamaehyphon');
INSERT INTO synonym VALUES(114,133,'Pythium chamaihyphon');
INSERT INTO synonym VALUES(115,136,'NCBI:taxid482727');
INSERT INTO synonym VALUES(116,136,'Pythium sp. GD7F');
INSERT INTO synonym VALUES(117,139,'Pythium middletonii');
INSERT INTO synonym VALUES(118,141,'Pythium nunn');
INSERT INTO synonym VALUES(119,145,'Pythium sylvaticum');
INSERT INTO synonym VALUES(120,147,'Pythium violae');
INSERT INTO synonym VALUES(121,150,'NCBI:taxid482741');
INSERT INTO synonym VALUES(122,150,'Pythium sp. WD7A');
INSERT INTO synonym VALUES(123,158,'Nematosporangium monospermum');
INSERT INTO synonym VALUES(124,159,'NCBI:taxid482701');
INSERT INTO synonym VALUES(125,159,'Pythiopsis sp. 760B');
INSERT INTO synonym VALUES(126,165,'Aphanomyces euteiches f. sp. phaseoli');
INSERT INTO synonym VALUES(127,165,'NCBI:taxid253174');
INSERT INTO synonym VALUES(128,169,'Peronophythora litchii');
INSERT INTO synonym VALUES(129,171,'NCBI:taxid695850');
INSERT INTO synonym VALUES(130,171,'NCBI:taxid983306');
INSERT INTO synonym VALUES(131,171,'Saprolegnia parasitica CBS 223.65');
INSERT INTO synonym VALUES(132,171,'Saprolegnia parasitica N12');
INSERT INTO synonym VALUES(133,173,'NCBI:taxid2716693');
INSERT INTO synonym VALUES(134,173,'Peronospora viciae f. sp. fabae');
INSERT INTO synonym VALUES(135,174,'Pythium prolatum');
INSERT INTO synonym VALUES(136,175,'Pythium echinulatum');
INSERT INTO synonym VALUES(137,176,'Pythium nodosum');
INSERT INTO synonym VALUES(138,177,'Pythium ornacarpum');
INSERT INTO synonym VALUES(139,179,'syn. Pythium dreschleri Paul');
INSERT INTO synonym VALUES(140,180,'NCBI:taxid657394');
INSERT INTO synonym VALUES(141,180,'Phytophthora erythroseptica var. pisi');
INSERT INTO synonym VALUES(142,186,'Achlya oligocantha');
INSERT INTO synonym VALUES(143,186,'NCBI:taxid2954324');
INSERT INTO synonym VALUES(144,200,'NCBI:taxid482712');
INSERT INTO synonym VALUES(145,200,'Pythium sp. 796A');
INSERT INTO synonym VALUES(146,201,'NCBI:taxid1156394');
INSERT INTO synonym VALUES(147,201,'NCBI:taxid482743');
INSERT INTO synonym VALUES(148,201,'NCBI:taxid482750');
INSERT INTO synonym VALUES(149,201,'Saprolegnia declina');
INSERT INTO synonym VALUES(150,201,'Saprolegnia declina VS20');
INSERT INTO synonym VALUES(151,201,'Saprolegnia diclina VS20');
INSERT INTO synonym VALUES(152,201,'Saprolegnia sp. GD18A');
INSERT INTO synonym VALUES(153,201,'Saprolegnia sp. WD1F');
INSERT INTO synonym VALUES(154,205,'Pythium erinaceum');
INSERT INTO synonym VALUES(155,206,'Globisporangium iwayamae DAOM BR242034');
INSERT INTO synonym VALUES(156,206,'NCBI:taxid1223558');
INSERT INTO synonym VALUES(157,206,'Pythium iwayamae');
INSERT INTO synonym VALUES(158,207,'NCBI:taxid482714');
INSERT INTO synonym VALUES(159,207,'NCBI:taxid482715');
INSERT INTO synonym VALUES(160,207,'Pythium mamillatum');
INSERT INTO synonym VALUES(161,207,'Pythium sp. 836A');
INSERT INTO synonym VALUES(162,207,'Pythium sp. 838A');
INSERT INTO synonym VALUES(163,208,'Pythium paddicum');
INSERT INTO synonym VALUES(164,209,'Pythium pulchrum');
INSERT INTO synonym VALUES(165,210,'Peronospora viciae f. sp. pisi');
INSERT INTO synonym VALUES(166,216,'Aplanopsis spinosa');
INSERT INTO synonym VALUES(167,219,'Dictyuchus sp. MA-2014');
INSERT INTO synonym VALUES(168,219,'NCBI:taxid1492783');
INSERT INTO synonym VALUES(169,222,'NCBI:taxid482742');
INSERT INTO synonym VALUES(170,222,'NCBI:taxid482746');
INSERT INTO synonym VALUES(171,222,'Saprolegnia anisopora');
INSERT INTO synonym VALUES(172,222,'Saprolegnia sp. 837A');
INSERT INTO synonym VALUES(173,222,'Saprolegnia sp. WD1A');
INSERT INTO synonym VALUES(174,225,'NCBI:taxid482765');
INSERT INTO synonym VALUES(175,225,'NCBI:taxid482766');
INSERT INTO synonym VALUES(176,225,'Saprolegnia sp. WD4D');
INSERT INTO synonym VALUES(177,225,'Saprolegnia sp. WD7C');
INSERT INTO synonym VALUES(178,234,'Pythium perplexum');
INSERT INTO synonym VALUES(179,235,'Pythium helicoides');
INSERT INTO synonym VALUES(180,236,'Pythium megacarpum');
INSERT INTO synonym VALUES(181,237,'NCBI:taxid1130066');
INSERT INTO synonym VALUES(182,237,'Ovatisporangium ostracodes');
INSERT INTO synonym VALUES(183,237,'Phytopythium sp. MAB-2011b');
INSERT INTO synonym VALUES(184,237,'Pythium ostracodes');
INSERT INTO synonym VALUES(185,240,'NCBI:taxid482706');
INSERT INTO synonym VALUES(186,240,'NCBI:taxid482711');
INSERT INTO synonym VALUES(187,240,'NCBI:taxid482724');
INSERT INTO synonym VALUES(188,240,'NCBI:taxid482726');
INSERT INTO synonym VALUES(189,240,'NCBI:taxid92965');
INSERT INTO synonym VALUES(190,240,'Phytophthora undulata');
INSERT INTO synonym VALUES(191,240,'Pythium sp. 759');
INSERT INTO synonym VALUES(192,240,'Pythium sp. 775');
INSERT INTO synonym VALUES(193,240,'Pythium sp. GD35A');
INSERT INTO synonym VALUES(194,240,'Pythium sp. GD43B');
INSERT INTO synonym VALUES(195,240,'Pythium undulatum');
INSERT INTO synonym VALUES(196,246,'Phytophthora hevea');
INSERT INTO synonym VALUES(197,248,'NCBI:taxid482633');
INSERT INTO synonym VALUES(198,248,'NCBI:taxid482636');
INSERT INTO synonym VALUES(199,248,'NCBI:taxid482637');
INSERT INTO synonym VALUES(200,248,'NCBI:taxid482639');
INSERT INTO synonym VALUES(201,248,'NCBI:taxid482640');
INSERT INTO synonym VALUES(202,248,'NCBI:taxid482641');
INSERT INTO synonym VALUES(203,248,'NCBI:taxid482642');
INSERT INTO synonym VALUES(204,248,'NCBI:taxid482643');
INSERT INTO synonym VALUES(205,248,'NCBI:taxid482644');
INSERT INTO synonym VALUES(206,248,'NCBI:taxid482645');
INSERT INTO synonym VALUES(207,248,'NCBI:taxid482646');
INSERT INTO synonym VALUES(208,248,'NCBI:taxid482647');
INSERT INTO synonym VALUES(209,248,'NCBI:taxid482648');
INSERT INTO synonym VALUES(210,248,'NCBI:taxid482649');
INSERT INTO synonym VALUES(211,248,'NCBI:taxid482650');
INSERT INTO synonym VALUES(212,248,'NCBI:taxid482651');
INSERT INTO synonym VALUES(213,248,'NCBI:taxid482652');
INSERT INTO synonym VALUES(214,248,'NCBI:taxid482654');
INSERT INTO synonym VALUES(215,248,'NCBI:taxid482655');
INSERT INTO synonym VALUES(216,248,'NCBI:taxid482812');
INSERT INTO synonym VALUES(217,248,'NCBI:taxid482813');
INSERT INTO synonym VALUES(218,248,'NCBI:taxid482814');
INSERT INTO synonym VALUES(219,248,'NCBI:taxid482815');
INSERT INTO synonym VALUES(220,248,'NCBI:taxid482816');
INSERT INTO synonym VALUES(221,248,'NCBI:taxid482817');
INSERT INTO synonym VALUES(222,248,'NCBI:taxid482818');
INSERT INTO synonym VALUES(223,248,'NCBI:taxid482819');
INSERT INTO synonym VALUES(224,248,'Phytophthora sp. 6-2prime-a');
INSERT INTO synonym VALUES(225,248,'Phytophthora sp. 6-2prime-b');
INSERT INTO synonym VALUES(226,248,'Phytophthora sp. 6-3prime-a');
INSERT INTO synonym VALUES(227,248,'Phytophthora sp. 6-3prime-b');
INSERT INTO synonym VALUES(228,248,'Phytophthora sp. 6-3prime-c');
INSERT INTO synonym VALUES(229,248,'Phytophthora sp. 6-3prime-d');
INSERT INTO synonym VALUES(230,248,'Phytophthora sp. 6-3prime-e');
INSERT INTO synonym VALUES(231,248,'Phytophthora sp. 6-3prime-f');
INSERT INTO synonym VALUES(232,248,'Phytophthora sp. 747');
INSERT INTO synonym VALUES(233,248,'Phytophthora sp. 754A');
INSERT INTO synonym VALUES(234,248,'Phytophthora sp. 755');
INSERT INTO synonym VALUES(235,248,'Phytophthora sp. 769A');
INSERT INTO synonym VALUES(236,248,'Phytophthora sp. 772');
INSERT INTO synonym VALUES(237,248,'Phytophthora sp. 776');
INSERT INTO synonym VALUES(238,248,'Phytophthora sp. 777A');
INSERT INTO synonym VALUES(239,248,'Phytophthora sp. 778');
INSERT INTO synonym VALUES(240,248,'Phytophthora sp. 779A');
INSERT INTO synonym VALUES(241,248,'Phytophthora sp. 780A');
INSERT INTO synonym VALUES(242,248,'Phytophthora sp. 785');
INSERT INTO synonym VALUES(243,248,'Phytophthora sp. 786');
INSERT INTO synonym VALUES(244,248,'Phytophthora sp. 787A');
INSERT INTO synonym VALUES(245,248,'Phytophthora sp. 787B');
INSERT INTO synonym VALUES(246,248,'Phytophthora sp. 788');
INSERT INTO synonym VALUES(247,248,'Phytophthora sp. 791A');
INSERT INTO synonym VALUES(248,248,'Phytophthora sp. 794');
INSERT INTO synonym VALUES(249,248,'Phytophthora sp. 801');
INSERT INTO synonym VALUES(250,248,'Phytophthora sp. 804');
INSERT INTO synonym VALUES(251,248,'Phytophthora sp. 806');
INSERT INTO synonym VALUES(252,250,'NCBI:taxid1249586');
INSERT INTO synonym VALUES(253,250,'NCBI:taxid1249587');
INSERT INTO synonym VALUES(254,250,'NCBI:taxid1254522');
INSERT INTO synonym VALUES(255,250,'Phytophthora lateralis MPF4');
INSERT INTO synonym VALUES(256,250,'Phytophthora lateralis MPF6');
INSERT INTO synonym VALUES(257,250,'Phytophthora lateralis SMST21');
INSERT INTO synonym VALUES(258,251,'NCBI:taxid451108');
INSERT INTO synonym VALUES(259,251,'Phytophthora mirabilis PIC 99114');
INSERT INTO synonym VALUES(260,253,'NCBI:taxid887082');
INSERT INTO synonym VALUES(261,253,'Phytophthora phaseoli race F_18');
INSERT INTO synonym VALUES(262,258,'Phytophthora fragariae var. rubi');
INSERT INTO synonym VALUES(263,261,'NCBI:taxid980179');
INSERT INTO synonym VALUES(264,261,'Phytophthora sp. P3247');
INSERT INTO synonym VALUES(265,266,'Lagenidium chthamalophilum');
INSERT INTO synonym VALUES(266,267,'NCBI:taxid1348162');
INSERT INTO synonym VALUES(267,267,'NCBI:taxid230437');
INSERT INTO synonym VALUES(268,267,'NCBI:taxid481876');
INSERT INTO synonym VALUES(269,267,'NCBI:taxid546261');
INSERT INTO synonym VALUES(270,267,'Peronospora chenopodii');
INSERT INTO synonym VALUES(271,267,'Peronospora farinosa f. sp. betae');
INSERT INTO synonym VALUES(272,267,'Peronospora farinosa f. sp. chenopodii');
INSERT INTO synonym VALUES(273,267,'Peronospora farinosa f. sp. spinaciae');
INSERT INTO synonym VALUES(274,267,'Peronospora farinosa f.sp. betae');
INSERT INTO synonym VALUES(275,267,'Peronospora farinosa f.sp. chenopodii');
INSERT INTO synonym VALUES(276,272,'Atkinsiella okinawaensis');
INSERT INTO synonym VALUES(277,272,'NCBI:taxid135476');
INSERT INTO synonym VALUES(278,273,'Lagenidium callinectes');
INSERT INTO synonym VALUES(279,275,'Lagenidium humanum');
INSERT INTO synonym VALUES(280,275,'NCBI:taxid2957607');
INSERT INTO synonym VALUES(281,276,'Lagenidium myophilum');
INSERT INTO synonym VALUES(282,277,'Lagenidium thermophilum');
INSERT INTO synonym VALUES(283,286,'Pythium polymastum');
INSERT INTO synonym VALUES(284,289,'NCBI:taxid482707');
INSERT INTO synonym VALUES(285,289,'NCBI:taxid482708');
INSERT INTO synonym VALUES(286,289,'NCBI:taxid482710');
INSERT INTO synonym VALUES(287,289,'NCBI:taxid482713');
INSERT INTO synonym VALUES(288,289,'Pythium dimorphum');
INSERT INTO synonym VALUES(289,289,'Pythium sp. 761');
INSERT INTO synonym VALUES(290,289,'Pythium sp. 762');
INSERT INTO synonym VALUES(291,289,'Pythium sp. 773B');
INSERT INTO synonym VALUES(292,289,'Pythium sp. 833A');
INSERT INTO synonym VALUES(293,292,'Pythium buismaniae');
INSERT INTO synonym VALUES(294,294,'Pythium mastophorum');
INSERT INTO synonym VALUES(295,295,'Pythium megalacanthum');
INSERT INTO synonym VALUES(296,296,'Pythium uncinulatum');
INSERT INTO synonym VALUES(297,316,'NCBI:taxid230366');
INSERT INTO synonym VALUES(298,316,'Peronospora trifolii-pratensis');
INSERT INTO synonym VALUES(299,316,'Peronospora trifoliorum f. trifolii-pratensis');
INSERT INTO synonym VALUES(300,334,'Peronospora barbareae');
INSERT INTO synonym VALUES(301,335,'Peronospora dentariae');
INSERT INTO synonym VALUES(302,336,'Peronospora thlaspeos-arvensis');
INSERT INTO synonym VALUES(303,337,'Peronospora brassicae');
INSERT INTO synonym VALUES(304,339,'Protomyces graminicola');
INSERT INTO synonym VALUES(305,340,'Paraperonospora leptosperma (de Bary) Constant');
INSERT INTO synonym VALUES(306,347,'Plasmopara isopyri-thalictroidis');
INSERT INTO synonym VALUES(307,348,'NCBI:taxid332201');
INSERT INTO synonym VALUES(308,348,'Phytophthora sp. ex Parrotia persica');
INSERT INTO synonym VALUES(309,348,'ramorum blight');
INSERT INTO synonym VALUES(310,348,'sudden oak death');
INSERT INTO synonym VALUES(311,353,'Leptolegnia sp. CBS177.86');
INSERT INTO synonym VALUES(312,355,'Pythium proliferatum');
INSERT INTO synonym VALUES(313,361,'NCBI:taxid2711121');
INSERT INTO synonym VALUES(314,361,'Pythium okanoganense');
INSERT INTO synonym VALUES(315,362,'Pythium canariense');
INSERT INTO synonym VALUES(316,363,'NCBI:taxid162121');
INSERT INTO synonym VALUES(317,363,'Peronospora niessleana');
INSERT INTO synonym VALUES(318,363,'Peronospora niessliana');
INSERT INTO synonym VALUES(319,366,'Pythium cylindrosporum');
INSERT INTO synonym VALUES(320,370,'Pythium abappressorium');
INSERT INTO synonym VALUES(321,370,'Pythium sp. abappressorium');
INSERT INTO synonym VALUES(322,371,'Pythium carolinianum');
INSERT INTO synonym VALUES(323,373,'Pythium regulare');
INSERT INTO synonym VALUES(324,374,'Pythium segnitium');
INSERT INTO synonym VALUES(325,376,'Ovatisporangium montanum');
INSERT INTO synonym VALUES(326,376,'Pythium montanum');
INSERT INTO synonym VALUES(327,376,'Pythium sp. 334');
INSERT INTO synonym VALUES(328,378,'Pythium carbonicum');
INSERT INTO synonym VALUES(329,380,'Ovatisporangium citrinum');
INSERT INTO synonym VALUES(330,380,'Pythium citrinum');
INSERT INTO synonym VALUES(331,381,'Plasmopara angustitermina Novot. 1962lis');
INSERT INTO synonym VALUES(332,382,'Pythium rhizosaccharum');
INSERT INTO synonym VALUES(333,384,'Achlya sp. F-1245');
INSERT INTO synonym VALUES(334,384,'NCBI:taxid221745');
INSERT INTO synonym VALUES(335,386,'Pythium campanulatum');
INSERT INTO synonym VALUES(336,387,'Pythium glomeratum');
INSERT INTO synonym VALUES(337,388,'NCBI:taxid482752');
INSERT INTO synonym VALUES(338,388,'NCBI:taxid482758');
INSERT INTO synonym VALUES(339,388,'Saprolegnia sp. WD1H');
INSERT INTO synonym VALUES(340,388,'Saprolegnia sp. WD20C');
INSERT INTO synonym VALUES(341,391,'NCBI:taxid482744');
INSERT INTO synonym VALUES(342,391,'NCBI:taxid482748');
INSERT INTO synonym VALUES(343,391,'NCBI:taxid482755');
INSERT INTO synonym VALUES(344,391,'NCBI:taxid482756');
INSERT INTO synonym VALUES(345,391,'Saprolegnia sp. K07');
INSERT INTO synonym VALUES(346,391,'Saprolegnia sp. WD1D');
INSERT INTO synonym VALUES(347,391,'Saprolegnia sp. WD1K');
INSERT INTO synonym VALUES(348,391,'Saprolegnia sp. WD1L');
INSERT INTO synonym VALUES(349,403,'Peronospora nesleae');
INSERT INTO synonym VALUES(350,404,'Peronospora arabis-alpinae');
INSERT INTO synonym VALUES(351,434,'NCBI:taxid162126');
INSERT INTO synonym VALUES(352,434,'Peronospora camelinae');
INSERT INTO synonym VALUES(353,435,'NCBI:taxid240416');
INSERT INTO synonym VALUES(354,435,'Peronospora lunariae');
INSERT INTO synonym VALUES(355,436,'NCBI:taxid272972');
INSERT INTO synonym VALUES(356,436,'Peronospora tribulina');
INSERT INTO synonym VALUES(357,438,'Pythium debaryanum');
INSERT INTO synonym VALUES(358,443,'Plasmopara wildemanniana');
INSERT INTO synonym VALUES(359,445,'Bremiella baudysii');
INSERT INTO synonym VALUES(360,445,'NCBI:taxid162135');
INSERT INTO synonym VALUES(361,456,'NCBI:taxid858703');
INSERT INTO synonym VALUES(362,456,'Peronospora drabae-majusculae');
INSERT INTO synonym VALUES(363,456,'Peronospora erophilae');
INSERT INTO synonym VALUES(364,457,'NCBI:taxid272971');
INSERT INTO synonym VALUES(365,457,'Peronospora thlaspeos-alpestris');
INSERT INTO synonym VALUES(366,457,'Peronospora thlaspeos-perfoliati');
INSERT INTO synonym VALUES(367,459,'Bremiella megasperma');
INSERT INTO synonym VALUES(368,459,'NCBI:taxid162134');
INSERT INTO synonym VALUES(369,461,'Pythium attrantheridium');
INSERT INTO synonym VALUES(370,462,'NCBI:taxid129367');
INSERT INTO synonym VALUES(371,462,'NCBI:taxid211525');
INSERT INTO synonym VALUES(372,462,'NCBI:taxid211526');
INSERT INTO synonym VALUES(373,462,'NCBI:taxid211527');
INSERT INTO synonym VALUES(374,462,'NCBI:taxid211528');
INSERT INTO synonym VALUES(375,462,'NCBI:taxid211529');
INSERT INTO synonym VALUES(376,462,'NCBI:taxid211530');
INSERT INTO synonym VALUES(377,462,'NCBI:taxid211531');
INSERT INTO synonym VALUES(378,462,'NCBI:taxid211532');
INSERT INTO synonym VALUES(379,462,'NCBI:taxid211538');
INSERT INTO synonym VALUES(380,462,'NCBI:taxid211539');
INSERT INTO synonym VALUES(381,462,'NCBI:taxid211540');
INSERT INTO synonym VALUES(382,462,'NCBI:taxid211541');
INSERT INTO synonym VALUES(383,462,'NCBI:taxid211542');
INSERT INTO synonym VALUES(384,462,'NCBI:taxid211543');
INSERT INTO synonym VALUES(385,462,'Phytophthora sp. P1052');
INSERT INTO synonym VALUES(386,462,'Phytophthora sp. P210');
INSERT INTO synonym VALUES(387,462,'Phytophthora sp. P246b');
INSERT INTO synonym VALUES(388,462,'Phytophthora sp. P895');
INSERT INTO synonym VALUES(389,466,'NCBI:taxid708010');
INSERT INTO synonym VALUES(390,466,'Phytophthora sp. 52');
INSERT INTO synonym VALUES(391,466,'Phytophthora sp. P462');
INSERT INTO synonym VALUES(392,466,'Phytophthora sp. rosacearum');
INSERT INTO synonym VALUES(393,473,'NCBI:taxid162143');
INSERT INTO synonym VALUES(394,473,'Plasmopara oplismeni');
INSERT INTO synonym VALUES(395,477,'Pythium hypogynum');
INSERT INTO synonym VALUES(396,479,'Pythium longisporangium');
INSERT INTO synonym VALUES(397,480,'Pythium viniferum');
INSERT INTO synonym VALUES(398,481,'Pythium sp. strain F-74');
INSERT INTO synonym VALUES(399,482,'Pythium sp. strain F-39');
INSERT INTO synonym VALUES(400,483,'Pythium sp. strain F-1216');
INSERT INTO synonym VALUES(401,484,'Pythium sp. strain F-1234');
INSERT INTO synonym VALUES(402,485,'Hyaloperonospora arabidopsidis East Malling Oystese 2');
INSERT INTO synonym VALUES(403,485,'Hyaloperonospora arabidopsidis Emoy2');
INSERT INTO synonym VALUES(404,485,'Hyaloperonospora arabidopsis');
INSERT INTO synonym VALUES(405,485,'Hyaloperonospora parasitica Emoy2');
INSERT INTO synonym VALUES(406,485,'Hyaloperonospora parasitica strain Emoy2');
INSERT INTO synonym VALUES(407,485,'NCBI:taxid559515');
INSERT INTO synonym VALUES(408,485,'Peronospora arabidopsidis');
INSERT INTO synonym VALUES(409,486,'Peronospora berteroae');
INSERT INTO synonym VALUES(410,487,'Peronospora cardaminopsidis');
INSERT INTO synonym VALUES(411,488,'NCBI:taxid272961');
INSERT INTO synonym VALUES(412,488,'Peronospora cheiranthi');
INSERT INTO synonym VALUES(413,488,'Peronospora erysimi');
INSERT INTO synonym VALUES(414,489,'Peronospora cochleariae');
INSERT INTO synonym VALUES(415,490,'Peronospora galligena');
INSERT INTO synonym VALUES(416,491,'NCBI:taxid272954');
INSERT INTO synonym VALUES(417,491,'Peronospora buniadis');
INSERT INTO synonym VALUES(418,491,'Peronospora hesperidis');
INSERT INTO synonym VALUES(419,492,'Peronospora isatidis');
INSERT INTO synonym VALUES(420,493,'Peronospora nasturtii-aquatici');
INSERT INTO synonym VALUES(421,494,'Peronospora sisymbrii-loeselii');
INSERT INTO synonym VALUES(422,495,'Peronospora teesdaliae');
INSERT INTO synonym VALUES(423,498,'Haliphthoros sp. NJM0034');
INSERT INTO synonym VALUES(424,504,'NCBI:taxid459884');
INSERT INTO synonym VALUES(425,504,'Phytophthora ipomoeae PIC 99167');
INSERT INTO synonym VALUES(426,506,'NCBI:taxid451109');
INSERT INTO synonym VALUES(427,506,'NCBI:taxid983691');
INSERT INTO synonym VALUES(428,506,'Phytophthora andina EC3425');
INSERT INTO synonym VALUES(429,506,'Phytophthora sp. CAL-2011 andina');
INSERT INTO synonym VALUES(430,506,'Phytophthora sp. andina BOLD:AAO5683');
INSERT INTO synonym VALUES(431,513,'Pythium sp. BG 12');
INSERT INTO synonym VALUES(432,514,'Aphanomyces sp. strain F-1293');
INSERT INTO synonym VALUES(433,526,'Pythium acrogynum');
INSERT INTO synonym VALUES(434,527,'Pythium multisporum');
INSERT INTO synonym VALUES(435,528,'Pythium pleroticum');
INSERT INTO synonym VALUES(436,529,'NCBI:taxid482725');
INSERT INTO synonym VALUES(437,529,'Pythium anandrum');
INSERT INTO synonym VALUES(438,529,'Pythium sp. GD40G');
INSERT INTO synonym VALUES(439,530,'Pythium helicandrum');
INSERT INTO synonym VALUES(440,531,'Phytopythium cucurbitacearum');
INSERT INTO synonym VALUES(441,532,'Phytophthora avicenniae');
INSERT INTO synonym VALUES(442,535,'NCBI:taxid82954');
INSERT INTO synonym VALUES(443,535,'Pythium zingiberum');
INSERT INTO synonym VALUES(444,539,'NCBI:taxid482702');
INSERT INTO synonym VALUES(445,539,'NCBI:taxid482703');
INSERT INTO synonym VALUES(446,539,'NCBI:taxid482704');
INSERT INTO synonym VALUES(447,539,'NCBI:taxid482721');
INSERT INTO synonym VALUES(448,539,'NCBI:taxid482740');
INSERT INTO synonym VALUES(449,539,'Pythium sp. 746B');
INSERT INTO synonym VALUES(450,539,'Pythium sp. 749A');
INSERT INTO synonym VALUES(451,539,'Pythium sp. 749B');
INSERT INTO synonym VALUES(452,539,'Pythium sp. B11');
INSERT INTO synonym VALUES(453,539,'Pythium sp. WD46B');
INSERT INTO synonym VALUES(454,540,'NCBI:taxid1049192');
INSERT INTO synonym VALUES(455,540,'Pythium sp. CBS 750.96');
INSERT INTO synonym VALUES(456,541,'NCBI:taxid482728');
INSERT INTO synonym VALUES(457,541,'NCBI:taxid482729');
INSERT INTO synonym VALUES(458,541,'NCBI:taxid482730');
INSERT INTO synonym VALUES(459,541,'NCBI:taxid482731');
INSERT INTO synonym VALUES(460,541,'NCBI:taxid482732');
INSERT INTO synonym VALUES(461,541,'NCBI:taxid482733');
INSERT INTO synonym VALUES(462,541,'NCBI:taxid482734');
INSERT INTO synonym VALUES(463,541,'NCBI:taxid482735');
INSERT INTO synonym VALUES(464,541,'Pythium sp. W006');
INSERT INTO synonym VALUES(465,541,'Pythium sp. W015');
INSERT INTO synonym VALUES(466,541,'Pythium sp. W019');
INSERT INTO synonym VALUES(467,541,'Pythium sp. W021');
INSERT INTO synonym VALUES(468,541,'Pythium sp. W029');
INSERT INTO synonym VALUES(469,541,'Pythium sp. W041');
INSERT INTO synonym VALUES(470,541,'Pythium sp. WD1o');
INSERT INTO synonym VALUES(471,542,'Pythium radiosum');
INSERT INTO synonym VALUES(472,543,'Pythium parvum');
INSERT INTO synonym VALUES(473,544,'Pythium marsipium');
INSERT INTO synonym VALUES(474,545,'Pythium kunmingense');
INSERT INTO synonym VALUES(475,546,'Pythium nagaii');
INSERT INTO synonym VALUES(476,555,'Phytophthora hedraiandra de Cock & Man in ''t Veld');
INSERT INTO synonym VALUES(477,556,'Pythium cystogenes');
INSERT INTO synonym VALUES(478,559,'NCBI:taxid1861861');
INSERT INTO synonym VALUES(479,559,'Phytophthora alni subsp. alni');
INSERT INTO synonym VALUES(480,559,'Phytophthora sp. JB-2016d');
INSERT INTO synonym VALUES(481,559,'Phytophthora xalni');
INSERT INTO synonym VALUES(482,560,'Phytophthora alni subsp. uniformis');
INSERT INTO synonym VALUES(483,561,'NCBI:taxid1861862');
INSERT INTO synonym VALUES(484,561,'Phytophthora alni subsp. multiformis');
INSERT INTO synonym VALUES(485,561,'Phytophthora sp. JB-2016e');
INSERT INTO synonym VALUES(486,561,'Phytophthora xmultiformis');
INSERT INTO synonym VALUES(487,562,'Pythium rhizooryzae');
INSERT INTO synonym VALUES(488,567,'Peronospora sp. strain UASWS0007');
INSERT INTO synonym VALUES(489,568,'Peronospora sp. strain UASWS0008');
INSERT INTO synonym VALUES(490,569,'Peronospora sp. strain UASWS0009');
INSERT INTO synonym VALUES(491,570,'Peronospora sp. strain UASWS0010');
INSERT INTO synonym VALUES(492,592,'Phytophthora medicaginis x Phytophthora cryptogea');
INSERT INTO synonym VALUES(493,594,'NCBI:taxid1284355');
INSERT INTO synonym VALUES(494,594,'NCBI:taxid1284356');
INSERT INTO synonym VALUES(495,594,'NCBI:taxid1284357');
INSERT INTO synonym VALUES(496,594,'Phytophthora kernoviae 00238/432');
INSERT INTO synonym VALUES(497,594,'Phytophthora kernoviae 00629/1');
INSERT INTO synonym VALUES(498,594,'Phytophthora kernoviae 00844/4');
INSERT INTO synonym VALUES(499,610,'Albugo amaranthi');
INSERT INTO synonym VALUES(500,613,'Isoachlya subterranea');
INSERT INTO synonym VALUES(501,619,'Isoachlya humphreyana');
INSERT INTO synonym VALUES(502,621,'NCBI:taxid235578');
INSERT INTO synonym VALUES(503,621,'Plasmopara sphaerosperma');
INSERT INTO synonym VALUES(504,628,'Ovatisporangium litorale');
INSERT INTO synonym VALUES(505,628,'Pythium litorale');
INSERT INTO synonym VALUES(506,628,'Pythium litoralis');
INSERT INTO synonym VALUES(507,669,'Pythium sp. F-1326');
INSERT INTO synonym VALUES(508,679,'NCBI:taxid352271');
INSERT INTO synonym VALUES(509,679,'NCBI:taxid352272');
INSERT INTO synonym VALUES(510,679,'Pythium sp. JN-1a');
INSERT INTO synonym VALUES(511,679,'Pythium sp. JN-1b');
INSERT INTO synonym VALUES(512,695,'NCBI:taxid235583');
INSERT INTO synonym VALUES(513,695,'Peronospora nivea Unger 1847');
INSERT INTO synonym VALUES(514,695,'Peronospora umbelliferarum Casp. 1855');
INSERT INTO synonym VALUES(515,695,'Plasmopara crustosa');
INSERT INTO synonym VALUES(516,695,'Plasmopara umbelliferarum');
INSERT INTO synonym VALUES(517,696,'Botrytis pygmaea');
INSERT INTO synonym VALUES(518,696,'NCBI:taxid120414');
INSERT INTO synonym VALUES(519,696,'Plasmopara pygmaea');
INSERT INTO synonym VALUES(520,696,'Plasmoverna pygmea');
INSERT INTO synonym VALUES(521,697,'Bremia graminicola');
INSERT INTO synonym VALUES(522,697,'NCBI:taxid349943');
INSERT INTO synonym VALUES(523,698,'NCBI:taxid482719');
INSERT INTO synonym VALUES(524,698,'NCBI:taxid482720');
INSERT INTO synonym VALUES(525,698,'NCBI:taxid482736');
INSERT INTO synonym VALUES(526,698,'NCBI:taxid482737');
INSERT INTO synonym VALUES(527,698,'Pythium sp. B07');
INSERT INTO synonym VALUES(528,698,'Pythium sp. B09');
INSERT INTO synonym VALUES(529,698,'Pythium sp. WD41C');
INSERT INTO synonym VALUES(530,698,'Pythium sp. WD41D');
INSERT INTO synonym VALUES(531,703,'NCBI:taxid461280');
INSERT INTO synonym VALUES(532,703,'Plasmoverna anemone-ranunculoides');
INSERT INTO synonym VALUES(533,703,'Plasmoverna anemones-ranunculoidis');
INSERT INTO synonym VALUES(534,770,'NCBI:taxid348152');
INSERT INTO synonym VALUES(535,770,'Pythium sp. F-1022');
INSERT INTO synonym VALUES(536,770,'Pythium spiculum');
INSERT INTO synonym VALUES(537,771,'NCBI:taxid410856');
INSERT INTO synonym VALUES(538,771,'NCBI:taxid416214');
INSERT INTO synonym VALUES(539,771,'NCBI:taxid482680');
INSERT INTO synonym VALUES(540,771,'Phytophthora sp. GD7A');
INSERT INTO synonym VALUES(541,771,'Phytophthora sp. GD7D');
INSERT INTO synonym VALUES(542,771,'Phytophthora sp. GD7I');
INSERT INTO synonym VALUES(543,772,'Phytophthora cactorum x Phytophthora hedraiandra');
INSERT INTO synonym VALUES(544,778,'Phytophthora nicotianae x Phytophthora cactorum');
INSERT INTO synonym VALUES(545,858,'Pythium sp. AW-B1');
INSERT INTO synonym VALUES(546,859,'Pythium sp. AW-C1');
INSERT INTO synonym VALUES(547,860,'Pythium sp. AW-C2');
INSERT INTO synonym VALUES(548,883,'Atkinsiella panulirata');
INSERT INTO synonym VALUES(549,883,'Halocrusticida panulirata');
INSERT INTO synonym VALUES(550,883,'Halocrusticida panuliri');
INSERT INTO synonym VALUES(551,906,'Olpidiopsis porphyrae');
INSERT INTO synonym VALUES(552,906,'Olpidiopsis sp. porphyrae');
INSERT INTO synonym VALUES(553,930,'Pythium sp. UASWS STEU 6208');
INSERT INTO synonym VALUES(554,984,'Phytophthora sp. hungarica');
INSERT INTO synonym VALUES(555,986,'Plasmopara sp. constantinescui');
INSERT INTO synonym VALUES(556,1007,'Hyaloperonospora aff. parasitica');
INSERT INTO synonym VALUES(557,1007,'Hyaloperonospora parasitica');
INSERT INTO synonym VALUES(558,1007,'Hyaloperonospora parasitica f. brassicae');
INSERT INTO synonym VALUES(559,1007,'Hyaloperonospora parasitica f. raphani');
INSERT INTO synonym VALUES(560,1007,'Hyaloperonospora parasitica sensu lato');
INSERT INTO synonym VALUES(561,1007,'NCBI:taxid123356');
INSERT INTO synonym VALUES(562,1007,'NCBI:taxid230376');
INSERT INTO synonym VALUES(563,1007,'NCBI:taxid230455');
INSERT INTO synonym VALUES(564,1007,'NCBI:taxid272959');
INSERT INTO synonym VALUES(565,1007,'NCBI:taxid272960');
INSERT INTO synonym VALUES(566,1007,'NCBI:taxid272964');
INSERT INTO synonym VALUES(567,1007,'NCBI:taxid272969');
INSERT INTO synonym VALUES(568,1007,'NCBI:taxid376765');
INSERT INTO synonym VALUES(569,1007,'NCBI:taxid376766');
INSERT INTO synonym VALUES(570,1007,'Peronospora crispula');
INSERT INTO synonym VALUES(571,1007,'Peronospora diplotaxidis');
INSERT INTO synonym VALUES(572,1007,'Peronospora iberidis');
INSERT INTO synonym VALUES(573,1007,'Peronospora lepidii-sativi');
INSERT INTO synonym VALUES(574,1007,'Peronospora parasitica');
INSERT INTO synonym VALUES(575,1007,'Peronospora sisymbrii-officinalis');
INSERT INTO synonym VALUES(576,1007,'[Peronospora] crispula');
INSERT INTO synonym VALUES(577,1007,'[Peronospora] diplotaxidis');
INSERT INTO synonym VALUES(578,1007,'[Peronospora] iberidis');
INSERT INTO synonym VALUES(579,1007,'[Peronospora] lepidii-sativi');
INSERT INTO synonym VALUES(580,1007,'[Peronospora] sisymbrii-officinalis');
INSERT INTO synonym VALUES(581,1015,'NCBI:taxid631438');
INSERT INTO synonym VALUES(582,1015,'Phytophthora sp. P8221');
INSERT INTO synonym VALUES(583,1043,'Phytophthora novaeguine');
INSERT INTO synonym VALUES(584,1046,'NCBI:taxid634257');
INSERT INTO synonym VALUES(585,1046,'Phytophthora sp. P11491');
INSERT INTO synonym VALUES(586,1056,'NCBI:taxid362704');
INSERT INTO synonym VALUES(587,1056,'NCBI:taxid440499');
INSERT INTO synonym VALUES(588,1056,'Phytophthora sp. MD 92');
INSERT INTO synonym VALUES(589,1056,'Phytophthora sp. parvasperma');
INSERT INTO synonym VALUES(590,1059,'Plasmopara tanaceti');
INSERT INTO synonym VALUES(591,1089,'Phytophthora sp. Asparagus');
INSERT INTO synonym VALUES(592,1103,'NCBI:taxid1448065');
INSERT INTO synonym VALUES(593,1103,'Phytophthora PgChlamydo');
INSERT INTO synonym VALUES(594,1103,'Phytophthora chlamydosporum');
INSERT INTO synonym VALUES(595,1103,'Phytophthora sp. PgChlamydo');
INSERT INTO synonym VALUES(596,1156,'Phytophthora sp. TIB-2007-6');
INSERT INTO synonym VALUES(597,1157,'Phytophthora sp. TIB-2007-8');
INSERT INTO synonym VALUES(598,1161,'Pythium sp. 14-3');
INSERT INTO synonym VALUES(599,1222,'Pythium cryptoirregulare');
INSERT INTO synonym VALUES(600,1223,'Phytophthora sp. AAD-2008');
INSERT INTO synonym VALUES(601,1224,'Phytophthora sp. CH-2008a');
INSERT INTO synonym VALUES(602,1225,'Phytophthora persearum');
INSERT INTO synonym VALUES(603,1226,'Phytophthora rhododendri');
INSERT INTO synonym VALUES(604,1229,'Pythium digitatum');
INSERT INTO synonym VALUES(605,1230,'Pythium mediterraneum');
INSERT INTO synonym VALUES(606,1232,'NCBI:taxid1448064');
INSERT INTO synonym VALUES(607,1232,'NCBI:taxid482672');
INSERT INTO synonym VALUES(608,1232,'Phytophthora sp. GD38a');
INSERT INTO synonym VALUES(609,1232,'Phytophthora sp. oaksoil/Poland');
INSERT INTO synonym VALUES(610,1234,'NCBI:taxid302022');
INSERT INTO synonym VALUES(611,1234,'NCBI:taxid302023');
INSERT INTO synonym VALUES(612,1234,'NCBI:taxid302024');
INSERT INTO synonym VALUES(613,1234,'NCBI:taxid302025');
INSERT INTO synonym VALUES(614,1234,'NCBI:taxid302026');
INSERT INTO synonym VALUES(615,1234,'NCBI:taxid302028');
INSERT INTO synonym VALUES(616,1234,'Phytophthora sp. isolate C19');
INSERT INTO synonym VALUES(617,1234,'Phytophthora sp. isolate C25');
INSERT INTO synonym VALUES(618,1234,'Phytophthora sp. isolate C7');
INSERT INTO synonym VALUES(619,1234,'Phytophthora sp. isolate Rf17');
INSERT INTO synonym VALUES(620,1234,'Phytophthora sp. isolate Rf6');
INSERT INTO synonym VALUES(621,1234,'Phytophthora sp. isolate SCRP237');
INSERT INTO synonym VALUES(622,1235,'NCBI:taxid1130065');
INSERT INTO synonym VALUES(623,1235,'NCBI:taxid381963');
INSERT INTO synonym VALUES(624,1235,'NCBI:taxid381964');
INSERT INTO synonym VALUES(625,1235,'NCBI:taxid381965');
INSERT INTO synonym VALUES(626,1235,'NCBI:taxid381966');
INSERT INTO synonym VALUES(627,1235,'NCBI:taxid400750');
INSERT INTO synonym VALUES(628,1235,'NCBI:taxid400751');
INSERT INTO synonym VALUES(629,1235,'NCBI:taxid400752');
INSERT INTO synonym VALUES(630,1235,'NCBI:taxid400753');
INSERT INTO synonym VALUES(631,1235,'Phytopythium sp. MAB-2011a');
INSERT INTO synonym VALUES(632,1235,'Pythium mercuriale');
INSERT INTO synonym VALUES(633,1235,'Pythium sp. STE-U 6124');
INSERT INTO synonym VALUES(634,1235,'Pythium sp. STE-U 6125');
INSERT INTO synonym VALUES(635,1235,'Pythium sp. STE-U 6126');
INSERT INTO synonym VALUES(636,1235,'Pythium sp. STE-U 6127');
INSERT INTO synonym VALUES(637,1235,'Pythium sp. STE-U 6204');
INSERT INTO synonym VALUES(638,1235,'Pythium sp. STE-U 6205');
INSERT INTO synonym VALUES(639,1235,'Pythium sp. STE-U 6206');
INSERT INTO synonym VALUES(640,1235,'Pythium sp. STE-U 6207');
INSERT INTO synonym VALUES(641,1241,'Pythium sp. F-1516');
INSERT INTO synonym VALUES(642,1241,'Pythium sp. isolate F-1516');
INSERT INTO synonym VALUES(643,1242,'NCBI:taxid482669');
INSERT INTO synonym VALUES(644,1242,'Phytophthora sp. GD23B');
INSERT INTO synonym VALUES(645,1242,'Phytophthora sp. raspberry');
INSERT INTO synonym VALUES(646,1244,'NCBI:taxid358102');
INSERT INTO synonym VALUES(647,1244,'NCBI:taxid648803');
INSERT INTO synonym VALUES(648,1244,'Phytophthora sp. 1819B');
INSERT INTO synonym VALUES(649,1244,'Phytophthora sp. CBS 117693');
INSERT INTO synonym VALUES(650,1244,'Phytophthora sp. QT-2009a');
INSERT INTO synonym VALUES(651,1245,'NCBI:taxid548916');
INSERT INTO synonym VALUES(652,1245,'Thraustotheca sp. F-1532');
INSERT INTO synonym VALUES(653,1254,'Phytophthora sp. WMihV-2008');
INSERT INTO synonym VALUES(654,1255,'NCBI:taxid519069');
INSERT INTO synonym VALUES(655,1255,'NCBI:taxid519070');
INSERT INTO synonym VALUES(656,1255,'NCBI:taxid519071');
INSERT INTO synonym VALUES(657,1255,'Phytophthora sp. 42B9');
INSERT INTO synonym VALUES(658,1255,'Phytophthora sp. 44E4');
INSERT INTO synonym VALUES(659,1255,'Phytophthora sp. 4E4');
INSERT INTO synonym VALUES(660,1256,'NCBI:taxid517183');
INSERT INTO synonym VALUES(661,1256,'Phytophthora sp. hydropathica');
INSERT INTO synonym VALUES(662,1295,'Albugo portulacae');
INSERT INTO synonym VALUES(663,1295,'Albugo portulaceae');
INSERT INTO synonym VALUES(664,1295,'NCBI:taxid162092');
INSERT INTO synonym VALUES(665,1296,'Albugo tragopogonis');
INSERT INTO synonym VALUES(666,1296,'NCBI:taxid136152');
INSERT INTO synonym VALUES(667,1296,'Puccinia tragopogonis');
INSERT INTO synonym VALUES(668,1306,'Phytophthora sp. ZGA-2008');
INSERT INTO synonym VALUES(669,1309,'NCBI:taxid488862');
INSERT INTO synonym VALUES(670,1309,'NCBI:taxid550670');
INSERT INTO synonym VALUES(671,1309,'NCBI:taxid550671');
INSERT INTO synonym VALUES(672,1309,'NCBI:taxid574550');
INSERT INTO synonym VALUES(673,1309,'Phytophthora sp. TIB-2007-4');
INSERT INTO synonym VALUES(674,1309,'Phytophthora sp. australis');
INSERT INTO synonym VALUES(675,1309,'Phytophthora sp. multivora');
INSERT INTO synonym VALUES(676,1310,'Pythium sp. oopapillum');
INSERT INTO synonym VALUES(677,1313,'Pythium sp. BP-2009a');
INSERT INTO synonym VALUES(678,1314,'Pythium sp. BP-2009b');
INSERT INTO synonym VALUES(679,1314,'Pythium stipitatum');
INSERT INTO synonym VALUES(680,1316,'Phytophthora sp. CCH-2009b');
INSERT INTO synonym VALUES(681,1322,'NCBI:taxid575819');
INSERT INTO synonym VALUES(682,1322,'Peronospora sp. HV2280');
INSERT INTO synonym VALUES(683,1325,'NCBI:taxid458838');
INSERT INTO synonym VALUES(684,1325,'Phytophthora sp. asparagi');
INSERT INTO synonym VALUES(685,1326,'NCBI:taxid407133');
INSERT INTO synonym VALUES(686,1326,'Phytophthora austrocedrae');
INSERT INTO synonym VALUES(687,1326,'Phytophthora sp. austrocedrae');
INSERT INTO synonym VALUES(688,1345,'NCBI:taxid529382');
INSERT INTO synonym VALUES(689,1345,'NCBI:taxid529383');
INSERT INTO synonym VALUES(690,1345,'NCBI:taxid568995');
INSERT INTO synonym VALUES(691,1345,'Phytophthora sp. Chr3');
INSERT INTO synonym VALUES(692,1345,'Phytophthora sp. GF749');
INSERT INTO synonym VALUES(693,1345,'Phytophthora sp. MMAM-2009a');
INSERT INTO synonym VALUES(694,1345,'Phytophthora sp. MN-2008');
INSERT INTO synonym VALUES(695,1348,'Albugo spinulosus');
INSERT INTO synonym VALUES(696,1349,'Albugo bliti');
INSERT INTO synonym VALUES(697,1349,'NCBI:taxid162091');
INSERT INTO synonym VALUES(698,1350,'Albugo platensis');
INSERT INTO synonym VALUES(699,1350,'NCBI:taxid323839');
INSERT INTO synonym VALUES(700,1351,'Albugo achyranthis');
INSERT INTO synonym VALUES(701,1351,'NCBI:taxid162093');
INSERT INTO synonym VALUES(702,1352,'NCBI:taxid475608');
INSERT INTO synonym VALUES(703,1352,'Pythium senticosum');
INSERT INTO synonym VALUES(704,1352,'Pythium sp. senticosum');
INSERT INTO synonym VALUES(705,1353,'Pythium takayamanum');
INSERT INTO synonym VALUES(706,1378,'Haliphthoraceae sp. NJM 0447');
INSERT INTO synonym VALUES(707,1378,'Haliphthoraceae sp. NJM 0451');
INSERT INTO synonym VALUES(708,1378,'Haliphthoraceae sp. NJM 0462');
INSERT INTO synonym VALUES(709,1378,'Haliphthoraceae sp. NJM 0631');
INSERT INTO synonym VALUES(710,1378,'NCBI:taxid414535');
INSERT INTO synonym VALUES(711,1378,'NCBI:taxid414536');
INSERT INTO synonym VALUES(712,1378,'NCBI:taxid414537');
INSERT INTO synonym VALUES(713,1378,'NCBI:taxid414538');
INSERT INTO synonym VALUES(714,1380,'Albugo laibachii Alem1');
INSERT INTO synonym VALUES(715,1380,'Albugo laibachii Nc14');
INSERT INTO synonym VALUES(716,1380,'Albugo sp. MT-2009');
INSERT INTO synonym VALUES(717,1380,'NCBI:taxid890382');
INSERT INTO synonym VALUES(718,1380,'NCBI:taxid904126');
INSERT INTO synonym VALUES(719,1381,'NCBI:taxid657221');
INSERT INTO synonym VALUES(720,1381,'Pythium emineosum');
INSERT INTO synonym VALUES(721,1381,'Pythium sp. DAOM BR0479');
INSERT INTO synonym VALUES(722,1381,'Pythium sp. DAOM BR0836');
INSERT INTO synonym VALUES(723,1381,'Pythium sp. DAOM BR479');
INSERT INTO synonym VALUES(724,1381,'Pythium sp. DAOM BR836');
INSERT INTO synonym VALUES(725,1382,'Pythium camurandrum');
INSERT INTO synonym VALUES(726,1382,'Pythium sp. DAOM BR0876');
INSERT INTO synonym VALUES(727,1382,'Pythium sp. DAOM BR876');
INSERT INTO synonym VALUES(728,1383,'Peronospora elscholtziae');
INSERT INTO synonym VALUES(729,1387,'Pythium sp. D223');
INSERT INTO synonym VALUES(730,1474,'Peronospora drabae');
INSERT INTO synonym VALUES(731,1475,'Peronospora norvegica');
INSERT INTO synonym VALUES(732,1479,'Halophytophthora kandeliae');
INSERT INTO synonym VALUES(733,1479,'Halophytophthora kandelii');
INSERT INTO synonym VALUES(734,1479,'NCBI:taxid1486478');
INSERT INTO synonym VALUES(735,1479,'Phytopythium sp. AVM-2014');
INSERT INTO synonym VALUES(736,1492,'NCBI:taxid198420');
INSERT INTO synonym VALUES(737,1493,'NCBI:taxid1216628');
INSERT INTO synonym VALUES(738,1493,'NCBI:taxid445397');
INSERT INTO synonym VALUES(739,1493,'Phytophthora sp. MDC-2012a');
INSERT INTO synonym VALUES(740,1524,'NCBI:taxid272966');
INSERT INTO synonym VALUES(741,1524,'Peronospora lobulariae');
INSERT INTO synonym VALUES(742,1525,'NCBI:taxid272968');
INSERT INTO synonym VALUES(743,1525,'Peronospora rorippae-islandicae');
INSERT INTO synonym VALUES(744,1526,'NCBI:taxid230377');
INSERT INTO synonym VALUES(745,1526,'Peronospora sisymbrii-sophiae');
INSERT INTO synonym VALUES(746,1527,'NCBI:taxid708001');
INSERT INTO synonym VALUES(747,1527,'Phytophthora sp. P15166');
INSERT INTO synonym VALUES(748,1538,'Halophytophthora elongata');
INSERT INTO synonym VALUES(749,1539,'Halophytophthora mycoparasitica');
INSERT INTO synonym VALUES(750,1539,'Phytophthora mycoparasitica');
INSERT INTO synonym VALUES(751,1540,'NCBI:taxid289611');
INSERT INTO synonym VALUES(752,1540,'Phytophthora polymorphica');
INSERT INTO synonym VALUES(753,1543,'Halophytophthora epistomium');
INSERT INTO synonym VALUES(754,1543,'Phytophthora epistomium');
INSERT INTO synonym VALUES(755,1544,'Halophytophthora bahamensis');
INSERT INTO synonym VALUES(756,1544,'Phytophthora bahamensis');
INSERT INTO synonym VALUES(757,1546,'Phytophthora vesicula');
INSERT INTO synonym VALUES(758,1554,'Aphanomyces sp. TAOR-2010');
INSERT INTO synonym VALUES(759,1560,'Hyaloperonospora sp. HHV-2010');
INSERT INTO synonym VALUES(760,1562,'Cystopus resedae');
INSERT INTO synonym VALUES(761,1566,'Phytophthora sp. palustris');
INSERT INTO synonym VALUES(762,1566,'Phytophthora taxon palustris');
INSERT INTO synonym VALUES(763,1567,'Phytophthora sp. TIB-2010a');
INSERT INTO synonym VALUES(764,1568,'NCBI:taxid488864');
INSERT INTO synonym VALUES(765,1568,'NCBI:taxid634261');
INSERT INTO synonym VALUES(766,1568,'Phytophthora sp. 7 TIB-2007');
INSERT INTO synonym VALUES(767,1568,'Phytophthora sp. TIB-2007-7');
INSERT INTO synonym VALUES(768,1568,'Phytophthora sp. TIB-2010b');
INSERT INTO synonym VALUES(769,1568,'Phytophthora sp. raspberry WA');
INSERT INTO synonym VALUES(770,1569,'NCBI:taxid467786');
INSERT INTO synonym VALUES(771,1569,'NCBI:taxid488861');
INSERT INTO synonym VALUES(772,1569,'Phytophthora sp. 3 TIB-2007');
INSERT INTO synonym VALUES(773,1569,'Phytophthora sp. P10457');
INSERT INTO synonym VALUES(774,1569,'Phytophthora sp. TIB-2007-3');
INSERT INTO synonym VALUES(775,1569,'Phytophthora sp. TIB-2010d');
INSERT INTO synonym VALUES(776,1573,'Lagenidium sp. CBS 135281');
INSERT INTO synonym VALUES(777,1573,'Lagenidium sp. CBS135281');
INSERT INTO synonym VALUES(778,1573,'Lagenidium sp. PWL-2010c');
INSERT INTO synonym VALUES(779,1573,'NCBI:taxid1440117');
INSERT INTO synonym VALUES(780,1581,'Peronosclerospora phillippinensis');
INSERT INTO synonym VALUES(781,1581,'Sclerospora philippinensis');
INSERT INTO synonym VALUES(782,1582,'Peronospora maydis');
INSERT INTO synonym VALUES(783,1586,'NCBI:taxid1085615');
INSERT INTO synonym VALUES(784,1586,'Phytophthora sp. Hennops');
INSERT INTO synonym VALUES(785,1588,'NCBI:taxid488860');
INSERT INTO synonym VALUES(786,1588,'NCBI:taxid669490');
INSERT INTO synonym VALUES(787,1588,'Phytophthora sp. 2 TIB-2007');
INSERT INTO synonym VALUES(788,1588,'Phytophthora sp. TIB-2007-2');
INSERT INTO synonym VALUES(789,1588,'Phytophthora sp. TIB-2009a');
INSERT INTO synonym VALUES(790,1589,'NCBI:taxid669491');
INSERT INTO synonym VALUES(791,1589,'Phytophthora sp. TIB-2009b');
INSERT INTO synonym VALUES(792,1597,'NCBI:taxid1223560');
INSERT INTO synonym VALUES(793,1597,'NCBI:taxid42099');
INSERT INTO synonym VALUES(794,1597,'Ovatisporangium vexans');
INSERT INTO synonym VALUES(795,1597,'Phytopythium sp. AL-2010');
INSERT INTO synonym VALUES(796,1597,'Phytopythium vexans DAOM BR484');
INSERT INTO synonym VALUES(797,1597,'Pythium vexans');
INSERT INTO synonym VALUES(798,1615,'Pustula sp. SSP-2010a');
INSERT INTO synonym VALUES(799,1618,'Bremia tulasneii');
INSERT INTO synonym VALUES(800,1667,'Phytophthora sp. AMV-2010');
INSERT INTO synonym VALUES(801,1672,'NCBI:taxid488866');
INSERT INTO synonym VALUES(802,1672,'Phytophthora sp. 9 TIB-2007');
INSERT INTO synonym VALUES(803,1672,'Phytophthora sp. AJR-2010b');
INSERT INTO synonym VALUES(804,1672,'Phytophthora sp. TIB-2007-9');
INSERT INTO synonym VALUES(805,1673,'NCBI:taxid488859');
INSERT INTO synonym VALUES(806,1673,'NCBI:taxid519072');
INSERT INTO synonym VALUES(807,1673,'Phytophthora sp. 1 TIB-2007');
INSERT INTO synonym VALUES(808,1673,'Phytophthora sp. AJR-2010a');
INSERT INTO synonym VALUES(809,1673,'Phytophthora sp. DDS1221');
INSERT INTO synonym VALUES(810,1673,'Phytophthora sp. TIB-2007-1');
INSERT INTO synonym VALUES(811,1675,'Albugo sp. YJC-2010b');
INSERT INTO synonym VALUES(812,1676,'Aphanomyces sp. NJM 0801');
INSERT INTO synonym VALUES(813,1676,'Aphanomyces sp. NJM 0802');
INSERT INTO synonym VALUES(814,1676,'Aphanomyces sp. NJM 0803');
INSERT INTO synonym VALUES(815,1676,'Aphanomyces sp. NJM 0804');
INSERT INTO synonym VALUES(816,1676,'Aphanomyces sp. NJM 0805');
INSERT INTO synonym VALUES(817,1676,'NCBI:taxid656824');
INSERT INTO synonym VALUES(818,1676,'NCBI:taxid656825');
INSERT INTO synonym VALUES(819,1676,'NCBI:taxid656826');
INSERT INTO synonym VALUES(820,1676,'NCBI:taxid656827');
INSERT INTO synonym VALUES(821,1676,'NCBI:taxid656828');
INSERT INTO synonym VALUES(822,1681,'Achlya sparrowi');
INSERT INTO synonym VALUES(823,1683,'Brevilegnia unisperma var. delica');
INSERT INTO synonym VALUES(824,1683,'NCBI:taxid944595');
INSERT INTO synonym VALUES(825,1704,'NCBI:taxid394969');
INSERT INTO synonym VALUES(826,1704,'Pythium sp. kashmirense');
INSERT INTO synonym VALUES(827,1705,'Pythium lucens');
INSERT INTO synonym VALUES(828,1714,'Aphanomyces sp. CAL-2011');
INSERT INTO synonym VALUES(829,1715,'Leptolegnia sp. CAL-2011');
INSERT INTO synonym VALUES(830,1715,'Leptolegnia sp. OOMYA1238-08');
INSERT INTO synonym VALUES(831,1716,'Saprolegnia sp. CAL-2011');
INSERT INTO synonym VALUES(832,1717,'NCBI:taxid126816');
INSERT INTO synonym VALUES(833,1717,'Pythium oedichilum');
INSERT INTO synonym VALUES(834,1717,'Pythium oedochilum');
INSERT INTO synonym VALUES(835,1718,'Phytopythium sp. CAL-2011a');
INSERT INTO synonym VALUES(836,1718,'Phytopythium sp. nov. BOLD:AAO6860');
INSERT INTO synonym VALUES(837,1719,'NCBI:taxid983701');
INSERT INTO synonym VALUES(838,1720,'Pythium sp. GroupF BOLD:AAO5242');
INSERT INTO synonym VALUES(839,1722,'NCBI:taxid983687');
INSERT INTO synonym VALUES(840,1722,'Saprolegnia sp. CAL-2011 rodrigueziana');
INSERT INTO synonym VALUES(841,1723,'Pythium sp. aff iwayamai');
INSERT INTO synonym VALUES(842,1726,'NCBI:taxid519077');
INSERT INTO synonym VALUES(843,1726,'NCBI:taxid583341');
INSERT INTO synonym VALUES(844,1726,'NCBI:taxid880413');
INSERT INTO synonym VALUES(845,1726,'Phytophthora sp. 11');
INSERT INTO synonym VALUES(846,1726,'Phytophthora sp. TIB-2010c');
INSERT INTO synonym VALUES(847,1726,'Phytophthora sp. VHS17085');
INSERT INTO synonym VALUES(848,1727,'Phytophthora citricola group E');
INSERT INTO synonym VALUES(849,1739,'Halophytophthora spinosa');
INSERT INTO synonym VALUES(850,1739,'Halophytophthora spinosa var. spinosa');
INSERT INTO synonym VALUES(851,1739,'NCBI:taxid980199');
INSERT INTO synonym VALUES(852,1739,'Phytophthora spinosa');
INSERT INTO synonym VALUES(853,1739,'Salispina spinosa var. spinosa');
INSERT INTO synonym VALUES(854,1740,'Halophytophthora spinosa var. lobata');
INSERT INTO synonym VALUES(855,1740,'Phytophthora spinosa var. lobata');
INSERT INTO synonym VALUES(856,1741,'Halophytophthora masteri');
INSERT INTO synonym VALUES(857,1758,'Halophytophthora tartarea');
INSERT INTO synonym VALUES(858,1758,'NCBI:taxid944598');
INSERT INTO synonym VALUES(859,1766,'NCBI:taxid2650544');
INSERT INTO synonym VALUES(860,1766,'NCBI:taxid2691815');
INSERT INTO synonym VALUES(861,1766,'Pythium sp. CAL 2011f');
INSERT INTO synonym VALUES(862,1766,'Pythium sp. CAL2011f');
INSERT INTO synonym VALUES(863,1766,'Pythium sp. CAL_2011f');
INSERT INTO synonym VALUES(864,1790,'Pustula sp. MT-2011');
INSERT INTO synonym VALUES(865,1791,'Basidiophora butleri');
INSERT INTO synonym VALUES(866,1791,'Sclerophthora butleri');
INSERT INTO synonym VALUES(867,1791,'Sclerospora butleri');
INSERT INTO synonym VALUES(868,1802,'NCBI:taxid289608');
INSERT INTO synonym VALUES(869,1802,'Pythium boreale');
INSERT INTO synonym VALUES(870,1803,'Aphanomyces sp. CBS58385');
INSERT INTO synonym VALUES(871,1803,'NCBI:taxid983668');
INSERT INTO synonym VALUES(872,1806,'NCBI:taxid519078');
INSERT INTO synonym VALUES(873,1806,'Phytophthora sp. TIB-2011');
INSERT INTO synonym VALUES(874,1806,'Phytophthora sp. VHS17350');
INSERT INTO synonym VALUES(875,1807,'NCBI:taxid1055751');
INSERT INTO synonym VALUES(876,1807,'NCBI:taxid1055753');
INSERT INTO synonym VALUES(877,1807,'NCBI:taxid946368');
INSERT INTO synonym VALUES(878,1807,'Phytophthora sp. BOLD:AAO6255');
INSERT INTO synonym VALUES(879,1807,'Phytophthora sp. BOLD:AAO6743');
INSERT INTO synonym VALUES(880,1807,'Phytophthora sp. BOLD:AAO6744');
INSERT INTO synonym VALUES(881,1807,'Phytophthora sp. BOLD:AAO6745');
INSERT INTO synonym VALUES(882,1807,'Phytophthora sp. nov. BOLD:AAO6255');
INSERT INTO synonym VALUES(883,1807,'Phytophthora sp. nov. BOLD:AAO6743');
INSERT INTO synonym VALUES(884,1807,'Phytophthora sp. nov. BOLD:AAO6744');
INSERT INTO synonym VALUES(885,1807,'Phytophthora sp. nov. BOLD:AAO6745');
INSERT INTO synonym VALUES(886,1833,'Plasmopara sp. MT-2011');
INSERT INTO synonym VALUES(887,1866,'Aphanomyces sp. NJM 0719');
INSERT INTO synonym VALUES(888,1866,'Aphanomyces sp. NJM 0817');
INSERT INTO synonym VALUES(889,1866,'Aphanomyces sp. NJM 0818');
INSERT INTO synonym VALUES(890,1866,'Aphanomyces sp. NJM 0901');
INSERT INTO synonym VALUES(891,1866,'Aphanomyces sp. NJM 0902');
INSERT INTO synonym VALUES(892,1866,'NCBI:taxid691275');
INSERT INTO synonym VALUES(893,1866,'NCBI:taxid691276');
INSERT INTO synonym VALUES(894,1866,'NCBI:taxid691277');
INSERT INTO synonym VALUES(895,1866,'NCBI:taxid691278');
INSERT INTO synonym VALUES(896,1866,'NCBI:taxid691279');
INSERT INTO synonym VALUES(897,1876,'Phytophthora fagopyri');
INSERT INTO synonym VALUES(898,1876,'Phytopythium sp. MAB-2011c');
INSERT INTO synonym VALUES(899,1877,'Phytopythium sp. MAB-2011e');
INSERT INTO synonym VALUES(900,1878,'NCBI:taxid1130068');
INSERT INTO synonym VALUES(901,1878,'NCBI:taxid1448070');
INSERT INTO synonym VALUES(902,1878,'NCBI:taxid507575');
INSERT INTO synonym VALUES(903,1878,'Ovatisporangium sp. KC-2014');
INSERT INTO synonym VALUES(904,1878,'Phytopythium sp. MAB-2011d');
INSERT INTO synonym VALUES(905,1878,'Pythium delawarense');
INSERT INTO synonym VALUES(906,1878,'Pythium sp. delawarii');
INSERT INTO synonym VALUES(907,1879,'Phytophthora sp. JEB-2011');
INSERT INTO synonym VALUES(908,1880,'Phytophthora sp. strain P1200');
INSERT INTO synonym VALUES(909,1901,'NCBI:taxid759901');
INSERT INTO synonym VALUES(910,1901,'Phytophthora sp. VI_3-100B9F');
INSERT INTO synonym VALUES(911,1901,'Phytophthora sp. WS-2012a');
INSERT INTO synonym VALUES(912,1902,'NCBI:taxid759902');
INSERT INTO synonym VALUES(913,1902,'Phytophthora sp. AKWA58.1-0708');
INSERT INTO synonym VALUES(914,1902,'Phytophthora sp. WS-2012b');
INSERT INTO synonym VALUES(915,1903,'NCBI:taxid315269');
INSERT INTO synonym VALUES(916,1903,'NCBI:taxid315270');
INSERT INTO synonym VALUES(917,1903,'NCBI:taxid426302');
INSERT INTO synonym VALUES(918,1903,'NCBI:taxid482658');
INSERT INTO synonym VALUES(919,1903,'NCBI:taxid482659');
INSERT INTO synonym VALUES(920,1903,'NCBI:taxid482660');
INSERT INTO synonym VALUES(921,1903,'NCBI:taxid482661');
INSERT INTO synonym VALUES(922,1903,'NCBI:taxid482662');
INSERT INTO synonym VALUES(923,1903,'NCBI:taxid482663');
INSERT INTO synonym VALUES(924,1903,'NCBI:taxid482664');
INSERT INTO synonym VALUES(925,1903,'NCBI:taxid482665');
INSERT INTO synonym VALUES(926,1903,'NCBI:taxid482666');
INSERT INTO synonym VALUES(927,1903,'NCBI:taxid482667');
INSERT INTO synonym VALUES(928,1903,'NCBI:taxid482668');
INSERT INTO synonym VALUES(929,1903,'NCBI:taxid482670');
INSERT INTO synonym VALUES(930,1903,'NCBI:taxid482671');
INSERT INTO synonym VALUES(931,1903,'NCBI:taxid482673');
INSERT INTO synonym VALUES(932,1903,'NCBI:taxid482674');
INSERT INTO synonym VALUES(933,1903,'NCBI:taxid482675');
INSERT INTO synonym VALUES(934,1903,'NCBI:taxid482676');
INSERT INTO synonym VALUES(935,1903,'NCBI:taxid482677');
INSERT INTO synonym VALUES(936,1903,'NCBI:taxid482678');
INSERT INTO synonym VALUES(937,1903,'NCBI:taxid482679');
INSERT INTO synonym VALUES(938,1903,'NCBI:taxid482681');
INSERT INTO synonym VALUES(939,1903,'NCBI:taxid482682');
INSERT INTO synonym VALUES(940,1903,'NCBI:taxid482683');
INSERT INTO synonym VALUES(941,1903,'NCBI:taxid482684');
INSERT INTO synonym VALUES(942,1903,'NCBI:taxid482685');
INSERT INTO synonym VALUES(943,1903,'NCBI:taxid482686');
INSERT INTO synonym VALUES(944,1903,'NCBI:taxid482687');
INSERT INTO synonym VALUES(945,1903,'NCBI:taxid482688');
INSERT INTO synonym VALUES(946,1903,'NCBI:taxid482689');
INSERT INTO synonym VALUES(947,1903,'NCBI:taxid482690');
INSERT INTO synonym VALUES(948,1903,'NCBI:taxid482691');
INSERT INTO synonym VALUES(949,1903,'NCBI:taxid482692');
INSERT INTO synonym VALUES(950,1903,'NCBI:taxid482693');
INSERT INTO synonym VALUES(951,1903,'NCBI:taxid482694');
INSERT INTO synonym VALUES(952,1903,'NCBI:taxid482695');
INSERT INTO synonym VALUES(953,1903,'NCBI:taxid482696');
INSERT INTO synonym VALUES(954,1903,'NCBI:taxid482697');
INSERT INTO synonym VALUES(955,1903,'NCBI:taxid482698');
INSERT INTO synonym VALUES(956,1903,'NCBI:taxid482699');
INSERT INTO synonym VALUES(957,1903,'NCBI:taxid482700');
INSERT INTO synonym VALUES(958,1903,'Phytophthora salixsoil');
INSERT INTO synonym VALUES(959,1903,'Phytophthora sp. 920');
INSERT INTO synonym VALUES(960,1903,'Phytophthora sp. 921');
INSERT INTO synonym VALUES(961,1903,'Phytophthora sp. 922');
INSERT INTO synonym VALUES(962,1903,'Phytophthora sp. 923');
INSERT INTO synonym VALUES(963,1903,'Phytophthora sp. B01');
INSERT INTO synonym VALUES(964,1903,'Phytophthora sp. B02');
INSERT INTO synonym VALUES(965,1903,'Phytophthora sp. B04');
INSERT INTO synonym VALUES(966,1903,'Phytophthora sp. B14');
INSERT INTO synonym VALUES(967,1903,'Phytophthora sp. BO3');
INSERT INTO synonym VALUES(968,1903,'Phytophthora sp. GD15A');
INSERT INTO synonym VALUES(969,1903,'Phytophthora sp. GD18G');
INSERT INTO synonym VALUES(970,1903,'Phytophthora sp. GD36D');
INSERT INTO synonym VALUES(971,1903,'Phytophthora sp. GD36F');
INSERT INTO synonym VALUES(972,1903,'Phytophthora sp. GD40A');
INSERT INTO synonym VALUES(973,1903,'Phytophthora sp. GD40C');
INSERT INTO synonym VALUES(974,1903,'Phytophthora sp. GD40D');
INSERT INTO synonym VALUES(975,1903,'Phytophthora sp. GD7B');
INSERT INTO synonym VALUES(976,1903,'Phytophthora sp. GD7C');
INSERT INTO synonym VALUES(977,1903,'Phytophthora sp. GD7G');
INSERT INTO synonym VALUES(978,1903,'Phytophthora sp. GD7H');
INSERT INTO synonym VALUES(979,1903,'Phytophthora sp. P245');
INSERT INTO synonym VALUES(980,1903,'Phytophthora sp. P878');
INSERT INTO synonym VALUES(981,1903,'Phytophthora sp. Salixsoil');
INSERT INTO synonym VALUES(982,1903,'Phytophthora sp. WD37A');
INSERT INTO synonym VALUES(983,1903,'Phytophthora sp. WD37B');
INSERT INTO synonym VALUES(984,1903,'Phytophthora sp. WD37C');
INSERT INTO synonym VALUES(985,1903,'Phytophthora sp. WD38A');
INSERT INTO synonym VALUES(986,1903,'Phytophthora sp. WD38B');
INSERT INTO synonym VALUES(987,1903,'Phytophthora sp. WD39A');
INSERT INTO synonym VALUES(988,1903,'Phytophthora sp. WD39B');
INSERT INTO synonym VALUES(989,1903,'Phytophthora sp. WD40A');
INSERT INTO synonym VALUES(990,1903,'Phytophthora sp. WD40C');
INSERT INTO synonym VALUES(991,1903,'Phytophthora sp. WD40D');
INSERT INTO synonym VALUES(992,1903,'Phytophthora sp. WD40E');
INSERT INTO synonym VALUES(993,1903,'Phytophthora sp. WD41a');
INSERT INTO synonym VALUES(994,1903,'Phytophthora sp. WD43A');
INSERT INTO synonym VALUES(995,1903,'Phytophthora sp. WD44B');
INSERT INTO synonym VALUES(996,1903,'Phytophthora sp. WD44C');
INSERT INTO synonym VALUES(997,1903,'Phytophthora sp. WD45A');
INSERT INTO synonym VALUES(998,1903,'Phytophthora sp. WD45B');
INSERT INTO synonym VALUES(999,1903,'Phytophthora sp. WD45C');
INSERT INTO synonym VALUES(1000,1903,'Phytophthora sp. WD47A');
INSERT INTO synonym VALUES(1001,1903,'Phytophthora sp. WD47C');
INSERT INTO synonym VALUES(1002,1903,'Phytophthora sp. taxon Salixsoil');
INSERT INTO synonym VALUES(1003,1903,'Phytophthora taxon salixsoil');
INSERT INTO synonym VALUES(1004,1905,'Chlamydomyzium sp. TYJ-2012');
INSERT INTO synonym VALUES(1005,1908,'Phytophthora taxon forest-soil');
INSERT INTO synonym VALUES(1006,1910,'NCBI:taxid622443');
INSERT INTO synonym VALUES(1007,1910,'Plasmopara sp. HOH HUH1024');
INSERT INTO synonym VALUES(1008,1911,'NCBI:taxid1235426');
INSERT INTO synonym VALUES(1009,1911,'Phytophthora sp. 16 TIB-2012');
INSERT INTO synonym VALUES(1010,1917,'Pythium sp. WHNS23');
INSERT INTO synonym VALUES(1011,1917,'Pythium wuhanense');
INSERT INTO synonym VALUES(1012,1918,'NCBI:taxid942184');
INSERT INTO synonym VALUES(1013,1918,'NCBI:taxid946205');
INSERT INTO synonym VALUES(1014,1918,'Pythium breve');
INSERT INTO synonym VALUES(1015,1918,'Pythium sp. CNN213');
INSERT INTO synonym VALUES(1016,1918,'Pythium sp. YYL-2011c');
INSERT INTO synonym VALUES(1017,1919,'NCBI:taxid946203');
INSERT INTO synonym VALUES(1018,1919,'NCBI:taxid947340');
INSERT INTO synonym VALUES(1019,1919,'Pythium baisense');
INSERT INTO synonym VALUES(1020,1919,'Pythium sp. QBS123');
INSERT INTO synonym VALUES(1021,1919,'Pythium sp. YYL-2011a');
INSERT INTO synonym VALUES(1022,1924,'Achlya hypogyna ATCC 48635');
INSERT INTO synonym VALUES(1023,1924,'NCBI:taxid1202773');
INSERT INTO synonym VALUES(1024,1979,'Phytophthora amnicola x Phytophthora taxon PgChlamydo');
INSERT INTO synonym VALUES(1025,1980,'Phytophthora thermophila x Phytophthora amnicola');
INSERT INTO synonym VALUES(1026,1993,'Pythiogeton puliensis');
INSERT INTO synonym VALUES(1027,1993,'Pythiogeton sp. JH-2012a');
INSERT INTO synonym VALUES(1028,1994,'Pythiogeton sp. JH-2012b');
INSERT INTO synonym VALUES(1029,1995,'Pythiogeton sp. JH-2012c');
INSERT INTO synonym VALUES(1030,1996,'Pythiogeton sp. JH-2012d');
INSERT INTO synonym VALUES(1031,1997,'Pythiogeton sp. JH-2012e');
INSERT INTO synonym VALUES(1032,1998,'Pythiogeton sp. JH-2012f');
INSERT INTO synonym VALUES(1033,2046,'Peronospora sp. MMT-2012');
INSERT INTO synonym VALUES(1034,2047,'Phytophthora taxon Pgchlamydo x Phytophthora amnicola');
INSERT INTO synonym VALUES(1035,2048,'Phytophthora thermophila x Phytophthora taxon Pgchlamydo');
INSERT INTO synonym VALUES(1036,2049,'Phytophthora sp. BG-2012');
INSERT INTO synonym VALUES(1037,2050,'Lagenidium sp. LM-2012a');
INSERT INTO synonym VALUES(1038,2052,'Lagenidium sp. LM-2012d');
INSERT INTO synonym VALUES(1039,2052,'Lagenidium vilelae');
INSERT INTO synonym VALUES(1040,2059,'Pythium RB II');
INSERT INTO synonym VALUES(1041,2068,'Peronospora cyperi');
INSERT INTO synonym VALUES(1042,2081,'Globisporangium sp. MA-2018b');
INSERT INTO synonym VALUES(1043,2081,'NCBI:taxid1041101');
INSERT INTO synonym VALUES(1044,2081,'NCBI:taxid2125996');
INSERT INTO synonym VALUES(1045,2081,'Pythium schmitthenneri');
INSERT INTO synonym VALUES(1046,2081,'Pythium sp. G7-1');
INSERT INTO synonym VALUES(1047,2082,'Globisporangium sp. MA-2018c');
INSERT INTO synonym VALUES(1048,2082,'NCBI:taxid1041102');
INSERT INTO synonym VALUES(1049,2082,'NCBI:taxid2125997');
INSERT INTO synonym VALUES(1050,2082,'Pythium selbyi');
INSERT INTO synonym VALUES(1051,2082,'Pythium sp. G7-2');
INSERT INTO synonym VALUES(1052,2083,'Lagenidium caudatum G.L. Barron 1976');
INSERT INTO synonym VALUES(1053,2085,'Phytophthora cactorum/Phytophthora hedraiandra SP-2013');
INSERT INTO synonym VALUES(1054,2086,'Phytophthora sp. 1 XY-2013');
INSERT INTO synonym VALUES(1055,2087,'Ph. cactorum (Leb. & Cohn) Schroet. x Ph. nicotianaevan Breda de Haan');
INSERT INTO synonym VALUES(1056,2091,'Phytophthora sp. 1 LB-2013');
INSERT INTO synonym VALUES(1057,2092,'Phytophthora sp. 2 LB-2013');
INSERT INTO synonym VALUES(1058,2093,'Phytophthora sp. 3 LB-2013');
INSERT INTO synonym VALUES(1059,2096,'Peronospora digitalidis');
INSERT INTO synonym VALUES(1060,2123,'Phytophthora sp. 1 WCS-2013');
INSERT INTO synonym VALUES(1061,2131,'NCBI:taxid272955');
INSERT INTO synonym VALUES(1062,2131,'Peronospora cardamines-laciniatae');
INSERT INTO synonym VALUES(1063,2132,'Peronospora dentariae-macrophyllae');
INSERT INTO synonym VALUES(1064,2133,'Peronospora malyi');
INSERT INTO synonym VALUES(1065,2144,'Phytophthora sp. 1 BH-2013');
INSERT INTO synonym VALUES(1066,2146,'Phytophthora sp. 1 WAMitV-2013');
INSERT INTO synonym VALUES(1067,2147,'Phytophthora sp. 2 WAMitV-2013');
INSERT INTO synonym VALUES(1068,2151,'Phytophthora sp. MS1');
INSERT INTO synonym VALUES(1069,2152,'Phytophthora sp. MS2');
INSERT INTO synonym VALUES(1070,2186,'Lagenidium sp. LM-2012c');
INSERT INTO synonym VALUES(1071,2186,'NCBI:taxid1243778');
INSERT INTO synonym VALUES(1072,2188,'NCBI:taxid1441738');
INSERT INTO synonym VALUES(1073,2197,'Halophytophthora sp. XY-2014');
INSERT INTO synonym VALUES(1074,2199,'NCBI:taxid82939');
INSERT INTO synonym VALUES(1075,2199,'Pythium intermedium');
INSERT INTO synonym VALUES(1076,2207,'Pythium cederbergense');
INSERT INTO synonym VALUES(1077,2220,'Lagenidium sp. LM-2014a');
INSERT INTO synonym VALUES(1078,2221,'Caeoma (Uredo) obtusatum');
INSERT INTO synonym VALUES(1079,2221,'Caeoma obtusatum');
INSERT INTO synonym VALUES(1080,2224,'Phytophthora sp. Buxus');
INSERT INTO synonym VALUES(1081,2227,'Bremia cf. lagoseridis YJC-2015');
INSERT INTO synonym VALUES(1082,2227,'NCBI:taxid1697570');
INSERT INTO synonym VALUES(1083,2268,'Peronospora melandrii-noctiflori');
INSERT INTO synonym VALUES(1084,2277,'Pythium sp. MES-2014');
INSERT INTO synonym VALUES(1085,2279,'Phytophthora sp. PJA-2014');
INSERT INTO synonym VALUES(1086,2288,'NCBI:taxid1132835');
INSERT INTO synonym VALUES(1087,2288,'NCBI:taxid434748');
INSERT INTO synonym VALUES(1088,2288,'NCBI:taxid434749');
INSERT INTO synonym VALUES(1089,2288,'NCBI:taxid434750');
INSERT INTO synonym VALUES(1090,2288,'NCBI:taxid434751');
INSERT INTO synonym VALUES(1091,2288,'NCBI:taxid434752');
INSERT INTO synonym VALUES(1092,2288,'NCBI:taxid434753');
INSERT INTO synonym VALUES(1093,2288,'NCBI:taxid434754');
INSERT INTO synonym VALUES(1094,2288,'Pythium polare');
INSERT INTO synonym VALUES(1095,2288,'Pythium sp. AvdB-2012');
INSERT INTO synonym VALUES(1096,2288,'Pythium sp. OPU1078');
INSERT INTO synonym VALUES(1097,2288,'Pythium sp. OPU1084');
INSERT INTO synonym VALUES(1098,2288,'Pythium sp. OPU1243');
INSERT INTO synonym VALUES(1099,2288,'Pythium sp. OPU1244');
INSERT INTO synonym VALUES(1100,2288,'Pythium sp. OPU1335');
INSERT INTO synonym VALUES(1101,2288,'Pythium sp. OPU1336');
INSERT INTO synonym VALUES(1102,2288,'Pythium sp. OPU1435');
INSERT INTO synonym VALUES(1103,2289,'Pythium solare');
INSERT INTO synonym VALUES(1104,2290,'Pythium recalcitrans');
INSERT INTO synonym VALUES(1105,2293,'Lagenocystis radicicola');
INSERT INTO synonym VALUES(1106,2294,'NCBI:taxid1258707');
INSERT INTO synonym VALUES(1107,2294,'NCBI:taxid1258708');
INSERT INTO synonym VALUES(1108,2294,'NCBI:taxid1258709');
INSERT INTO synonym VALUES(1109,2294,'NCBI:taxid1258710');
INSERT INTO synonym VALUES(1110,2294,'NCBI:taxid1258711');
INSERT INTO synonym VALUES(1111,2294,'NCBI:taxid1258712');
INSERT INTO synonym VALUES(1112,2294,'NCBI:taxid1329192');
INSERT INTO synonym VALUES(1113,2294,'NCBI:taxid1329193');
INSERT INTO synonym VALUES(1114,2294,'NCBI:taxid1329194');
INSERT INTO synonym VALUES(1115,2294,'NCBI:taxid1329195');
INSERT INTO synonym VALUES(1116,2294,'NCBI:taxid1329196');
INSERT INTO synonym VALUES(1117,2294,'NCBI:taxid1329197');
INSERT INTO synonym VALUES(1118,2294,'NCBI:taxid445425');
INSERT INTO synonym VALUES(1119,2294,'Phytophthora sp. CH05MT11');
INSERT INTO synonym VALUES(1120,2294,'Phytophthora sp. CH05MT31');
INSERT INTO synonym VALUES(1121,2294,'Phytophthora sp. CH05MT40');
INSERT INTO synonym VALUES(1122,2294,'Phytophthora sp. CH05NSU11');
INSERT INTO synonym VALUES(1123,2294,'Phytophthora sp. CH05NSU21');
INSERT INTO synonym VALUES(1124,2294,'Phytophthora sp. CH05NSU31');
INSERT INTO synonym VALUES(1125,2294,'Phytophthora sp. HSP501');
INSERT INTO synonym VALUES(1126,2294,'Phytophthora sp. HSP502');
INSERT INTO synonym VALUES(1127,2294,'Phytophthora sp. HSP503');
INSERT INTO synonym VALUES(1128,2294,'Phytophthora sp. HSP504');
INSERT INTO synonym VALUES(1129,2294,'Phytophthora sp. HSP505');
INSERT INTO synonym VALUES(1130,2294,'Phytophthora sp. HSP506');
INSERT INTO synonym VALUES(1131,2294,'Phytophthora sp. fragaefolia');
INSERT INTO synonym VALUES(1132,2295,'Peronospora sp. HV-2014a');
INSERT INTO synonym VALUES(1133,2296,'Peronospora sp. HV-2014b');
INSERT INTO synonym VALUES(1134,2306,'Phytophthora lacustris x Phytophthora riparia');
INSERT INTO synonym VALUES(1135,2316,'NCBI:taxid1125984');
INSERT INTO synonym VALUES(1136,2316,'NCBI:taxid1125985');
INSERT INTO synonym VALUES(1137,2316,'NCBI:taxid1125986');
INSERT INTO synonym VALUES(1138,2316,'NCBI:taxid1125987');
INSERT INTO synonym VALUES(1139,2316,'NCBI:taxid1125988');
INSERT INTO synonym VALUES(1140,2316,'NCBI:taxid1125989');
INSERT INTO synonym VALUES(1141,2316,'NCBI:taxid1125990');
INSERT INTO synonym VALUES(1142,2316,'NCBI:taxid1125991');
INSERT INTO synonym VALUES(1143,2316,'NCBI:taxid1125992');
INSERT INTO synonym VALUES(1144,2316,'NCBI:taxid1125993');
INSERT INTO synonym VALUES(1145,2316,'NCBI:taxid1125994');
INSERT INTO synonym VALUES(1146,2316,'NCBI:taxid1125995');
INSERT INTO synonym VALUES(1147,2316,'Phytophthora sp. CH00MKR1');
INSERT INTO synonym VALUES(1148,2316,'Phytophthora sp. CH00MKR2');
INSERT INTO synonym VALUES(1149,2316,'Phytophthora sp. CH02PHR1');
INSERT INTO synonym VALUES(1150,2316,'Phytophthora sp. CH04PHR11');
INSERT INTO synonym VALUES(1151,2316,'Phytophthora sp. CH04PHR12');
INSERT INTO synonym VALUES(1152,2316,'Phytophthora sp. CH94PHR1');
INSERT INTO synonym VALUES(1153,2316,'Phytophthora sp. CH95PHR10');
INSERT INTO synonym VALUES(1154,2316,'Phytophthora sp. CH95PHR16');
INSERT INTO synonym VALUES(1155,2316,'Phytophthora sp. CH95PHR17');
INSERT INTO synonym VALUES(1156,2316,'Phytophthora sp. CH97PHR1');
INSERT INTO synonym VALUES(1157,2316,'Phytophthora sp. P-A');
INSERT INTO synonym VALUES(1158,2316,'Phytophthora sp. P-B');
INSERT INTO synonym VALUES(1159,2317,'NCBI:taxid1571769');
INSERT INTO synonym VALUES(1160,2318,'NCBI:taxid1571767');
INSERT INTO synonym VALUES(1161,2319,'NCBI:taxid1571768');
INSERT INTO synonym VALUES(1162,2321,'NCBI:taxid1125999');
INSERT INTO synonym VALUES(1163,2321,'NCBI:taxid701260');
INSERT INTO synonym VALUES(1164,2321,'NCBI:taxid701261');
INSERT INTO synonym VALUES(1165,2321,'NCBI:taxid701262');
INSERT INTO synonym VALUES(1166,2321,'Phytophthora sp. Toku-1');
INSERT INTO synonym VALUES(1167,2321,'Phytophthora sp. Toku_1');
INSERT INTO synonym VALUES(1168,2321,'Phytophthora sp. Toku_3');
INSERT INTO synonym VALUES(1169,2321,'Phytophthora sp. Toku_8');
INSERT INTO synonym VALUES(1170,2461,'Plasmopara sp. ARMT-2014');
INSERT INTO synonym VALUES(1171,2463,'P. hedraiandra x P. cactorum');
INSERT INTO synonym VALUES(1172,2467,'NCBI:taxid1457390');
INSERT INTO synonym VALUES(1173,2467,'NCBI:taxid519075');
INSERT INTO synonym VALUES(1174,2467,'Phytophthora sp. TIB-2014a');
INSERT INTO synonym VALUES(1175,2467,'Phytophthora sp. VHS16108');
INSERT INTO synonym VALUES(1176,2481,'NCBI:taxid1500417');
INSERT INTO synonym VALUES(1177,2481,'Phytopythium sp. TLR-2014');
INSERT INTO synonym VALUES(1178,2482,'Pythium palingenes');
INSERT INTO synonym VALUES(1179,2487,'Achlya spinosa');
INSERT INTO synonym VALUES(1180,2487,'NCBI:taxid112332');
INSERT INTO synonym VALUES(1181,2495,'Achlya sp. GHJ-2015');
INSERT INTO synonym VALUES(1182,2496,'Pythium barbulae');
INSERT INTO synonym VALUES(1183,2498,'Cystopus lepigoni');
INSERT INTO synonym VALUES(1184,2500,'Pythium sp. ACB-2015');
INSERT INTO synonym VALUES(1185,2501,'Peronospora simplex');
INSERT INTO synonym VALUES(1186,2538,'Peronospora polycarponis');
INSERT INTO synonym VALUES(1187,2544,'NCBI:taxid561257');
INSERT INTO synonym VALUES(1188,2544,'Pythium apinafurcum');
INSERT INTO synonym VALUES(1189,2544,'Pythium sp. UZ300');
INSERT INTO synonym VALUES(1190,2545,'Pontisma feldmannii');
INSERT INTO synonym VALUES(1191,2556,'Olpidiopsis pyropiae');
INSERT INTO synonym VALUES(1192,2557,'NCBI:taxid1769909');
INSERT INTO synonym VALUES(1193,2557,'NCBI:taxid1769910');
INSERT INTO synonym VALUES(1194,2557,'NCBI:taxid1769911');
INSERT INTO synonym VALUES(1195,2557,'Saprolegnia sp. NeSS1');
INSERT INTO synonym VALUES(1196,2557,'Saprolegnia sp. NeSS2');
INSERT INTO synonym VALUES(1197,2557,'Saprolegnia sp. PelSS');
INSERT INTO synonym VALUES(1198,2561,'NCBI:taxid244164');
INSERT INTO synonym VALUES(1199,2561,'Phytophthora sp. P236');
INSERT INTO synonym VALUES(1200,2568,'Phytophthora sp. BS-2015b');
INSERT INTO synonym VALUES(1201,2570,'Boababopsis donbarretti');
INSERT INTO synonym VALUES(1202,2571,'Peronosporales sp. YJC-2015b');
INSERT INTO synonym VALUES(1203,2585,'Lagenidium sp. DAOM BR89-12');
INSERT INTO synonym VALUES(1204,2585,'Lagenidium sp. SL08');
INSERT INTO synonym VALUES(1205,2585,'NCBI:taxid1702236');
INSERT INTO synonym VALUES(1206,2591,'Phytophthora moyootj x Phytophthora thermophila');
INSERT INTO synonym VALUES(1207,2593,'Phytophthora amnicola x Phytophthora moyootj');
INSERT INTO synonym VALUES(1208,2594,'Phytophthora moyootj x Phytophthora fluvialis');
INSERT INTO synonym VALUES(1209,2595,'Phytophthora fluvialis x Phytophthora moyootj');
INSERT INTO synonym VALUES(1210,2596,'Phytophthora moyootj x Phytophthora litoralis');
INSERT INTO synonym VALUES(1211,2598,'Phytophthora thermophila x Phytophthora moyootj');
INSERT INTO synonym VALUES(1212,2646,'Phytophthora sp. VJF-2015a');
INSERT INTO synonym VALUES(1213,2647,'Phytophthora sp. XY-2015');
INSERT INTO synonym VALUES(1214,2667,'NCBI:taxid1696061');
INSERT INTO synonym VALUES(1215,2667,'Phytophthora sp. BS-2015a');
INSERT INTO synonym VALUES(1216,2669,'Pythium aff. acanthophoron JEB-2016');
INSERT INTO synonym VALUES(1217,2669,'Pythium yorkense');
INSERT INTO synonym VALUES(1218,2716,'Peronospora australis');
INSERT INTO synonym VALUES(1219,2717,'Phytophthora sp. TIB-2016a');
INSERT INTO synonym VALUES(1220,2718,'Halophytophthora taxon Zostera');
INSERT INTO synonym VALUES(1221,2724,'Phytophthora sp. WMitV-2016a');
INSERT INTO synonym VALUES(1222,2726,'Halophytophthora sp. GHJ-2016a');
INSERT INTO synonym VALUES(1223,2727,'Phytophthora sp. MHJ-2016a');
INSERT INTO synonym VALUES(1224,2728,'Phytophthora sp. MHJ-2016b');
INSERT INTO synonym VALUES(1225,2739,'Phytophthora xincrassata');
INSERT INTO synonym VALUES(1226,2740,'Phytophthora sp. JB-2016b');
INSERT INTO synonym VALUES(1227,2741,'Phytophthora sp. JB-2016c');
INSERT INTO synonym VALUES(1228,2742,'Phytophthora sp. GHJ-2016a');
INSERT INTO synonym VALUES(1229,2743,'Phytophthora sp. GHJ-2016b');
INSERT INTO synonym VALUES(1230,2750,'Saprolegnia sp. SCOR-2016a');
INSERT INTO synonym VALUES(1231,2752,'Pythium sp. JJC-2016a');
INSERT INTO synonym VALUES(1232,2753,'Lagenidium sp. RV-2016a');
INSERT INTO synonym VALUES(1233,2760,'NCBI:taxid2909663');
INSERT INTO synonym VALUES(1234,2760,'Ovatisporangium sp.');
INSERT INTO synonym VALUES(1235,2762,'Pythium ershadii');
INSERT INTO synonym VALUES(1236,2762,'Pythium sp. MA-2016a');
INSERT INTO synonym VALUES(1237,2763,'Pythium pyrioosporum');
INSERT INTO synonym VALUES(1238,2763,'Pythium sp. MA-2016c');
INSERT INTO synonym VALUES(1239,2764,'Pythium sp. MA-2016b');
INSERT INTO synonym VALUES(1240,2764,'Pythium urmianum');
INSERT INTO synonym VALUES(1241,2766,'Pustula sp. BX-2016a');
INSERT INTO synonym VALUES(1242,2769,'Pleotrachelus rosenvingii');
INSERT INTO synonym VALUES(1243,2771,'Pythium sp. SU-2017');
INSERT INTO synonym VALUES(1244,2772,'NCBI:taxid1938504');
INSERT INTO synonym VALUES(1245,2780,'Peronospora cf. ducometi');
INSERT INTO synonym VALUES(1246,2781,'Globisporangium sp. SU-2016');
INSERT INTO synonym VALUES(1247,2781,'NCBI:taxid1882251');
INSERT INTO synonym VALUES(1248,2781,'NCBI:taxid572075');
INSERT INTO synonym VALUES(1249,2781,'Pythium sp. UZ382');
INSERT INTO synonym VALUES(1250,2782,'Halophytophthora operculata');
INSERT INTO synonym VALUES(1251,2782,'NCBI:taxid1451285');
INSERT INTO synonym VALUES(1252,2782,'NCBI:taxid758749');
INSERT INTO synonym VALUES(1253,2782,'Peronosporaceae sp. RB-2017a');
INSERT INTO synonym VALUES(1254,2782,'Phytophthora operculata');
INSERT INTO synonym VALUES(1255,2782,'Phytopythium operculatum');
INSERT INTO synonym VALUES(1256,2782,'Phytopythium sp. TLR-2014a');
INSERT INTO synonym VALUES(1257,2783,'Peronosporaceae sp. RB-2017b');
INSERT INTO synonym VALUES(1258,2793,'Phytophthora sp. BS-2017a');
INSERT INTO synonym VALUES(1259,2794,'Phytophthora sp. BS-2017b');
INSERT INTO synonym VALUES(1260,2795,'Phytophthora sp. BS-2017c');
INSERT INTO synonym VALUES(1261,2796,'Phytophthora sp. BS-2017d');
INSERT INTO synonym VALUES(1262,2798,'Phytopythium sp. RB-2017b');
INSERT INTO synonym VALUES(1263,2799,'Phytopythium sp. RB-2017a');
INSERT INTO synonym VALUES(1264,2814,'Plasmopara sp. BM-2017a');
INSERT INTO synonym VALUES(1265,2815,'Plasmopara sp. BM-2017b');
INSERT INTO synonym VALUES(1266,2816,'Olpidiopsis muelleri');
INSERT INTO synonym VALUES(1267,2816,'Olpidiopsis sp. YB-2017a');
INSERT INTO synonym VALUES(1268,2817,'Olpidiopsis palmariae');
INSERT INTO synonym VALUES(1269,2817,'Olpidiopsis sp. YB-2017b');
INSERT INTO synonym VALUES(1270,2818,'Olpidiopsis sp. YB-2017c');
INSERT INTO synonym VALUES(1271,2852,'Pythium iranense');
INSERT INTO synonym VALUES(1272,2852,'Pythium sp. M-2017a');
INSERT INTO synonym VALUES(1273,2853,'Pythium monoclinum');
INSERT INTO synonym VALUES(1274,2853,'Pythium sp. M-2017b');
INSERT INTO synonym VALUES(1275,2857,'Globisporangium ultimum DAOM BR144');
INSERT INTO synonym VALUES(1276,2857,'Globisporangium ultimum DAOM BR748');
INSERT INTO synonym VALUES(1277,2857,'Globisporangium ultimum var. sporangiiferum');
INSERT INTO synonym VALUES(1278,2857,'Globisporangium ultimum var. sporangiiferum BR650');
INSERT INTO synonym VALUES(1279,2857,'Globisporangium ultimum var. ultimum');
INSERT INTO synonym VALUES(1280,2857,'NCBI:taxid115421');
INSERT INTO synonym VALUES(1281,2857,'NCBI:taxid1223559');
INSERT INTO synonym VALUES(1282,2857,'NCBI:taxid162153');
INSERT INTO synonym VALUES(1283,2857,'NCBI:taxid2052683');
INSERT INTO synonym VALUES(1284,2857,'NCBI:taxid431595');
INSERT INTO synonym VALUES(1285,2857,'NCBI:taxid65071');
INSERT INTO synonym VALUES(1286,2857,'NCBI:taxid695756');
INSERT INTO synonym VALUES(1287,2857,'Pythium ultimum');
INSERT INTO synonym VALUES(1288,2857,'Pythium ultimum var. sporangiiferum');
INSERT INTO synonym VALUES(1289,2857,'Pythium ultimum var. ultimum');
INSERT INTO synonym VALUES(1290,2858,'NCBI:taxid1457388');
INSERT INTO synonym VALUES(1291,2858,'Phytophthora sp. TIB-2017a');
INSERT INTO synonym VALUES(1292,2858,'Phytophthora sp. cyperaceae');
INSERT INTO synonym VALUES(1293,2858,'Phytophthora taxon cyperaceae');
INSERT INTO synonym VALUES(1294,2859,'NCBI:taxid1457389');
INSERT INTO synonym VALUES(1295,2859,'NCBI:taxid910610');
INSERT INTO synonym VALUES(1296,2859,'Phytophthora sp. TIB-2017b');
INSERT INTO synonym VALUES(1297,2859,'Phytophthora sp. casuarina');
INSERT INTO synonym VALUES(1298,2859,'Phytophthora sp. humicola-like/TIB-2010');
INSERT INTO synonym VALUES(1299,2859,'Phytophthora taxon casuarina');
INSERT INTO synonym VALUES(1300,2860,'NCBI:taxid910608');
INSERT INTO synonym VALUES(1301,2860,'Phytophthora sp. TIB-2017c');
INSERT INTO synonym VALUES(1302,2860,'Phytophthora sp. kwongan/TIB-2010');
INSERT INTO synonym VALUES(1303,2861,'NCBI:taxid519073');
INSERT INTO synonym VALUES(1304,2861,'NCBI:taxid519074');
INSERT INTO synonym VALUES(1305,2861,'Phytophthora sp. DDS3599');
INSERT INTO synonym VALUES(1306,2861,'Phytophthora sp. IMI329669');
INSERT INTO synonym VALUES(1307,2861,'Phytophthora sp. TIB-2017d');
INSERT INTO synonym VALUES(1308,2862,'NCBI:taxid910609');
INSERT INTO synonym VALUES(1309,2862,'Phytophthora sp. TIB-2017e');
INSERT INTO synonym VALUES(1310,2862,'Phytophthora sp. rosacearum-like/TIB-2010');
INSERT INTO synonym VALUES(1311,2864,'NCBI:taxid1571772');
INSERT INTO synonym VALUES(1312,2864,'Phytophthora sp. GUCC0007');
INSERT INTO synonym VALUES(1313,2865,'NCBI:taxid1571771');
INSERT INTO synonym VALUES(1314,2865,'Phytophthora sp. GUCC0015');
INSERT INTO synonym VALUES(1315,2865,'Pythium alternatum');
INSERT INTO synonym VALUES(1316,2869,'Peronospora arabidis-glabrae');
INSERT INTO synonym VALUES(1317,2870,'Hyaloperonospora nasturtii-montani');
INSERT INTO synonym VALUES(1318,2870,'Peronospora nasturtii-montani');
INSERT INTO synonym VALUES(1319,2871,'Peronospora nasturtii-palustris');
INSERT INTO synonym VALUES(1320,2875,'Phytophthora sp. aureomontensis');
INSERT INTO synonym VALUES(1321,2876,'Phytophthora humicola x Phytophthora inundata');
INSERT INTO synonym VALUES(1322,2882,'Pustula sp. BX-2017a');
INSERT INTO synonym VALUES(1323,2883,'Pustula sp. BX-2017b');
INSERT INTO synonym VALUES(1324,2887,'Phytophthora sp. DRR-2018a');
INSERT INTO synonym VALUES(1325,2890,'NCBI:taxid107433');
INSERT INTO synonym VALUES(1326,2890,'Pythium acanthophoron');
INSERT INTO synonym VALUES(1327,2892,'NCBI:taxid82943');
INSERT INTO synonym VALUES(1328,2892,'Pythium orthogonon');
INSERT INTO synonym VALUES(1329,2893,'NCBI:taxid482716');
INSERT INTO synonym VALUES(1330,2893,'NCBI:taxid82944');
INSERT INTO synonym VALUES(1331,2893,'Pythium paroecandrum');
INSERT INTO synonym VALUES(1332,2893,'Pythium sp. 839A');
INSERT INTO synonym VALUES(1333,2894,'NCBI:taxid82948');
INSERT INTO synonym VALUES(1334,2894,'Pythium spinosum');
INSERT INTO synonym VALUES(1335,2931,'Aphanomyces sp. SH-2018a');
INSERT INTO synonym VALUES(1336,2945,'Olpidiopsis drebesii');
INSERT INTO synonym VALUES(1337,2948,'Saprolegnia maragheica A.C. Bouket, Y. Tanaka, 2018');
INSERT INTO synonym VALUES(1338,2948,'Saprolegnia sp. LB-2018a');
INSERT INTO synonym VALUES(1339,2950,'Phytophthora sp. TB-2018a');
INSERT INTO synonym VALUES(1340,2951,'Phytophthora sp. TB-2018b');
INSERT INTO synonym VALUES(1341,2964,'Olpidiopsis gillii');
INSERT INTO synonym VALUES(1342,2964,'Olpidium gillii De Wild., 1896');
INSERT INTO synonym VALUES(1343,2972,'Olpidiopsis bostrychiae');
INSERT INTO synonym VALUES(1344,2974,'Phytophthora sp. NPS-2018a');
INSERT INTO synonym VALUES(1345,2975,'Miracula sp. AB-2018a');
INSERT INTO synonym VALUES(1346,2979,'Phytophthora sp. NZFRI-2018a');
INSERT INTO synonym VALUES(1347,2980,'Pythium sp. JJC-2018a');
INSERT INTO synonym VALUES(1348,2986,'Paralagenidium sp. LM-2019a');
INSERT INTO synonym VALUES(1349,2988,'Olpidiopsis sp. AB-2019a');
INSERT INTO synonym VALUES(1350,2992,'Phytophthora chlamydospora x Phytophthora amnicola');
INSERT INTO synonym VALUES(1351,2993,'Plasmopara sp. YJC-2019a');
INSERT INTO synonym VALUES(1352,2997,'Leptomitales sp. WWM-2019a');
INSERT INTO synonym VALUES(1353,3003,'NCBI:taxid2760282');
INSERT INTO synonym VALUES(1354,3003,'NCBI:taxid2768178');
INSERT INTO synonym VALUES(1355,3003,'Phytophthora sp. ''Carya''');
INSERT INTO synonym VALUES(1356,3003,'Phytophthora sp. CMR-2019a');
INSERT INTO synonym VALUES(1357,3003,'Phytophthora sp. CMR-2020a');
INSERT INTO synonym VALUES(1358,3022,'NCBI:taxid266018');
INSERT INTO synonym VALUES(1359,3022,'NCBI:taxid703085');
INSERT INTO synonym VALUES(1360,3022,'Phytophthora sp. BL-2009a');
INSERT INTO synonym VALUES(1361,3022,'Phytophthora taxon niederhauserii');
INSERT INTO synonym VALUES(1362,3024,'Phytophthora aff. porri x Phytophthora sp. ''parsley''');
INSERT INTO synonym VALUES(1363,3025,'Phytophthora pseudocryptogea x Phytophthora sp kelmania');
INSERT INTO synonym VALUES(1364,3037,'Phytophthora niederhauseri x Phytophthora aff. asparagi');
INSERT INTO synonym VALUES(1365,3038,'Phytophthora occultans x Phytophthora aff. citrophthora');
INSERT INTO synonym VALUES(1366,3039,'Phytophthora hedraiandra x Phytophthora sp. ''hedraiandra 1-KP-2019''');
INSERT INTO synonym VALUES(1367,3040,'Phytophthora amnicola x Phytophthora chlamydospora');
INSERT INTO synonym VALUES(1368,3042,'Phytophthora chlamydospora x Phytophthora lacustris');
INSERT INTO synonym VALUES(1369,3043,'Phytophthora cactorum x Phytophthora aff. hedraiandra');
INSERT INTO synonym VALUES(1370,3046,'Saprolegniales sp. AB-2019a');
INSERT INTO synonym VALUES(1371,3049,'NCBI:taxid2676865');
INSERT INTO synonym VALUES(1372,3049,'Phytophthora sp. ''kelmania'' x Phytophthora sansomeana');
INSERT INTO synonym VALUES(1373,3050,'Saprolegnia monoica var. glomerata');
INSERT INTO synonym VALUES(1374,3051,'Scoliolegnia blelhamensis');
INSERT INTO synonym VALUES(1375,3052,'Diatomophthora perforans subsp. destruens');
INSERT INTO synonym VALUES(1376,3052,'Diatomophthora perforans subsp. norvegica');
INSERT INTO synonym VALUES(1377,3052,'Diatomophthora perforans subsp. pleurosigmae');
INSERT INTO synonym VALUES(1378,3052,'Diatomophthora sp. AB-2019a');
INSERT INTO synonym VALUES(1379,3052,'Diatomophthora sp. AB-2019b');
INSERT INTO synonym VALUES(1380,3052,'Diatomophthora sp. AB-2019c');
INSERT INTO synonym VALUES(1381,3052,'Diatomophthora sp. AB-2019d');
INSERT INTO synonym VALUES(1382,3052,'Ectrogella perforans');
INSERT INTO synonym VALUES(1383,3052,'NCBI:taxid2681713');
INSERT INTO synonym VALUES(1384,3052,'NCBI:taxid2681714');
INSERT INTO synonym VALUES(1385,3052,'NCBI:taxid2681715');
INSERT INTO synonym VALUES(1386,3052,'NCBI:taxid2730044');
INSERT INTO synonym VALUES(1387,3081,'Achlya apiculata');
INSERT INTO synonym VALUES(1388,3081,'NCBI:taxid92966');
INSERT INTO synonym VALUES(1389,3082,'Achlya oblongata');
INSERT INTO synonym VALUES(1390,3082,'NCBI:taxid364101');
INSERT INTO synonym VALUES(1391,3085,'NCBI:taxid115416');
INSERT INTO synonym VALUES(1392,3085,'NCBI:taxid482717');
INSERT INTO synonym VALUES(1393,3085,'Pythium heterothallicum');
INSERT INTO synonym VALUES(1394,3085,'Pythium sp. 847A');
INSERT INTO synonym VALUES(1395,3086,'NCBI:taxid181666');
INSERT INTO synonym VALUES(1396,3086,'Pythium macrosporum');
INSERT INTO synonym VALUES(1397,3087,'NCBI:taxid295492');
INSERT INTO synonym VALUES(1398,3087,'Pythium rostratifingens');
INSERT INTO synonym VALUES(1399,3088,'NCBI:taxid82947');
INSERT INTO synonym VALUES(1400,3088,'Pythium rostratum');
INSERT INTO synonym VALUES(1401,3091,'Hyaloperonospora sp. CSS-2020a');
INSERT INTO synonym VALUES(1402,3094,'Phytophthora sp. HM-2020a');
INSERT INTO synonym VALUES(1403,3103,'Pythium huanghuaiense');
INSERT INTO synonym VALUES(1404,3103,'Pythium sp. WY-2020a');
INSERT INTO synonym VALUES(1405,3106,'NCBI:taxid1880903');
INSERT INTO synonym VALUES(1406,3106,'Phytophthora sp. TIB-2016b');
INSERT INTO synonym VALUES(1407,3115,'NCBI:taxid2588954');
INSERT INTO synonym VALUES(1408,3115,'Peronospora sp. WD-2020a');
INSERT INTO synonym VALUES(1409,3115,'Peronospora sp. WJD-2019a');
INSERT INTO synonym VALUES(1410,3117,'Uredo cruciferarum');
INSERT INTO synonym VALUES(1411,3138,'Olpidium bryopsidis');
INSERT INTO synonym VALUES(1412,3140,'Phytophthora sp. RMG-2020a');
INSERT INTO synonym VALUES(1413,3148,'Peronospora myosuri f. eranthidis-hiemalis');
INSERT INTO synonym VALUES(1414,3150,'Phytophthora sp. DP-2021a');
INSERT INTO synonym VALUES(1415,3160,'Phytophthora vanyenensis');
INSERT INTO synonym VALUES(1416,3163,'Phytophthora sp. CB-2020a');
INSERT INTO synonym VALUES(1417,3169,'NCBI:taxid1329265');
INSERT INTO synonym VALUES(1418,3169,'NCBI:taxid911892');
INSERT INTO synonym VALUES(1419,3169,'Phytophthora sp. emzansi');
INSERT INTO synonym VALUES(1420,3169,'Phytophthora sp. emzansi/CCB-2010');
INSERT INTO synonym VALUES(1421,3169,'Phytophthora taxon emzansi');
INSERT INTO synonym VALUES(1422,3173,'Phytophthora sp. CB-2021a');
INSERT INTO synonym VALUES(1423,3179,'Phytophthora sp. MHJ-2021a');
INSERT INTO synonym VALUES(1424,3180,'Phytophthora sp. MHJ-2021b');
INSERT INTO synonym VALUES(1425,3181,'Phytophthora sp. MHJ-2021c');
INSERT INTO synonym VALUES(1426,3194,'Achlya androgyna');
INSERT INTO synonym VALUES(1427,3194,'NCBI:taxid1628356');
INSERT INTO synonym VALUES(1428,3194,'Saprolegnia androgyna');
INSERT INTO synonym VALUES(1429,3198,'NCBI:taxid2923032');
INSERT INTO synonym VALUES(1430,3198,'Pythium sp. 1 YL2020');
INSERT INTO synonym VALUES(1431,3199,'NCBI:taxid2923033');
INSERT INTO synonym VALUES(1432,3199,'Pythium sp. 2 YL2020');
INSERT INTO synonym VALUES(1433,3210,'Pythium sp. LM-2022a');
INSERT INTO synonym VALUES(1434,3224,'NCBI:taxid1200953');
INSERT INTO synonym VALUES(1435,3224,'Pythium sp. LY221g');
CREATE TABLE sequence_source (
	id INTEGER NOT NULL, 
	source_accession VARCHAR, 
	source_id INTEGER, 
	marker_seq_id INTEGER, 
	marker_definition_id INTEGER, 
	taxonomy_id INTEGER, 
	PRIMARY KEY (id), 
	FOREIGN KEY(source_id) REFERENCES data_source (id), 
	FOREIGN KEY(marker_seq_id) REFERENCES marker_sequence (id), 
	FOREIGN KEY(marker_definition_id) REFERENCES marker_definition (id), 
	FOREIGN KEY(taxonomy_id) REFERENCES taxonomy (id)
);
INSERT INTO sequence_source VALUES(1,'Control_05',1,1,1,3227);
INSERT INTO sequence_source VALUES(2,'Control_14',1,2,1,3228);
INSERT INTO sequence_source VALUES(3,'Control_22',1,3,1,3229);
INSERT INTO sequence_source VALUES(4,'Control_42',1,4,1,3230);
INSERT INTO sequence_source VALUES(5,'88531412fbe9f8496ee2e80d1cbfa17d_19845',2,5,1,89);
INSERT INTO sequence_source VALUES(6,'29c57fb8bb431163a028917e552a1259_44253',3,6,1,1007);
INSERT INTO sequence_source VALUES(7,'f48331c6566caa6da14adda9329f1d9a_8001',3,7,1,1007);
INSERT INTO sequence_source VALUES(8,'dd7e2a61f258d6befab1d2a55242e5e0_7159',3,8,1,1007);
INSERT INTO sequence_source VALUES(9,'d9bc3879fdab3b4184c04bfbb5cf6afb_47087',4,9,1,1326);
INSERT INTO sequence_source VALUES(10,'d9bc3879fdab3b4184c04bfbb5cf6afb_53370',5,9,1,1326);
INSERT INTO sequence_source VALUES(11,'688ca1f52e3ffeb2417adceff1011655_42963',6,10,1,1836);
INSERT INTO sequence_source VALUES(12,'259d50fc8098473b48ceacb48eb3ed99_27802',7,11,1,94);
INSERT INTO sequence_source VALUES(13,'3d3fa2fd6fe0f183cad80771f5950b27_51849',8,12,1,358);
INSERT INTO sequence_source VALUES(14,'f1d4c0432c89f005ec2b4e467839f5cc_53023',9,13,1,92);
INSERT INTO sequence_source VALUES(15,'86faa3e6c55cb63348af05c3272a51ed_1360',9,14,1,92);
INSERT INTO sequence_source VALUES(16,'f696591f997895f8ae62d4b9c44f4ccd_54499',10,15,1,891);
INSERT INTO sequence_source VALUES(17,'8c593016c6c188d66817d7c0ada433d5_40764',11,16,1,153);
INSERT INTO sequence_source VALUES(18,'ab082031f945cad0319dffaf35beade5_2154',12,17,1,74);
INSERT INTO sequence_source VALUES(19,'04f98d2bf3f9dd49f7102ea1db7a128f_1409',12,18,1,74);
INSERT INTO sequence_source VALUES(20,'ed44806393cfa394e5056fca15b45a5c_1208',12,19,1,74);
INSERT INTO sequence_source VALUES(21,'d9bc3879fdab3b4184c04bfbb5cf6afb_3272',13,9,1,1326);
INSERT INTO sequence_source VALUES(22,'d9bc3879fdab3b4184c04bfbb5cf6afb_48944',14,9,1,1326);
INSERT INTO sequence_source VALUES(23,'d9bc3879fdab3b4184c04bfbb5cf6afb_3816',15,9,1,1326);
INSERT INTO sequence_source VALUES(24,'d9bc3879fdab3b4184c04bfbb5cf6afb_59358',16,9,1,1326);
INSERT INTO sequence_source VALUES(25,'d9bc3879fdab3b4184c04bfbb5cf6afb_48335',17,9,1,1326);
INSERT INTO sequence_source VALUES(26,'d9bc3879fdab3b4184c04bfbb5cf6afb_38102',18,9,1,1326);
INSERT INTO sequence_source VALUES(27,'d9bc3879fdab3b4184c04bfbb5cf6afb_3895',19,9,1,1326);
INSERT INTO sequence_source VALUES(28,'d9bc3879fdab3b4184c04bfbb5cf6afb_67258',20,9,1,1326);
INSERT INTO sequence_source VALUES(29,'ed15fefb7a3655147115fc28a8d6d671_29441',21,20,1,130);
INSERT INTO sequence_source VALUES(30,'af46526f85cbf2d345d419a0f30e854a_4935',21,21,1,130);
INSERT INTO sequence_source VALUES(31,'f65d8c80202d42fc17e32da2bb7f2858_2859',21,22,1,130);
INSERT INTO sequence_source VALUES(32,'10ba08ab269b69142b6f83328e3e7099_2403',21,23,1,130);
INSERT INTO sequence_source VALUES(33,'a012903e04863a4c2f904dee8dabc5cb_52929',22,24,1,180);
INSERT INTO sequence_source VALUES(34,'a012903e04863a4c2f904dee8dabc5cb_57914',23,24,1,180);
INSERT INTO sequence_source VALUES(35,'b1199a1082e563c9954dee14b4150557_29741',24,25,1,96);
INSERT INTO sequence_source VALUES(36,'2e4f0ed53888ed39a2aee6d6d8e02206_45573',25,26,1,379);
INSERT INTO sequence_source VALUES(37,'2e4f0ed53888ed39a2aee6d6d8e02206_35237',26,26,1,379);
INSERT INTO sequence_source VALUES(38,'2e4f0ed53888ed39a2aee6d6d8e02206_71661',27,26,1,379);
INSERT INTO sequence_source VALUES(39,'2e4f0ed53888ed39a2aee6d6d8e02206_71737',28,26,1,379);
INSERT INTO sequence_source VALUES(40,'2e4f0ed53888ed39a2aee6d6d8e02206_52942',29,26,1,379);
INSERT INTO sequence_source VALUES(41,'2e4f0ed53888ed39a2aee6d6d8e02206_61177',30,26,1,379);
INSERT INTO sequence_source VALUES(42,'2e4f0ed53888ed39a2aee6d6d8e02206_66444',31,26,1,379);
INSERT INTO sequence_source VALUES(43,'2e4f0ed53888ed39a2aee6d6d8e02206_47050',32,26,1,379);
INSERT INTO sequence_source VALUES(44,'b3b684fc69437b76cc7921e2ed287dae_38271',33,27,1,560);
INSERT INTO sequence_source VALUES(45,'12dc63e906f613f17219530896e88839_1716',33,28,1,560);
INSERT INTO sequence_source VALUES(46,'c50b7fc6de0f1405b4388e95bdb01b4c_31373',34,29,1,91);
INSERT INTO sequence_source VALUES(47,'18ab920ad62eb511ae7b88fdccec0e36_6832',34,30,1,91);
INSERT INTO sequence_source VALUES(48,'d9bc3879fdab3b4184c04bfbb5cf6afb_70843',35,9,1,1326);
INSERT INTO sequence_source VALUES(49,'6bcdcba67f36c711c34f3a5ec368babb_29348',36,31,1,1326);
INSERT INTO sequence_source VALUES(50,'d343fb37b0b42e3533546d8cbae33048_27182',36,32,1,1326);
INSERT INTO sequence_source VALUES(51,'ed15fefb7a3655147115fc28a8d6d671_16943',37,20,1,130);
INSERT INTO sequence_source VALUES(52,'10ba08ab269b69142b6f83328e3e7099_2581',37,23,1,130);
INSERT INTO sequence_source VALUES(53,'af46526f85cbf2d345d419a0f30e854a_1784',37,21,1,130);
INSERT INTO sequence_source VALUES(54,'ed15fefb7a3655147115fc28a8d6d671_8918',38,20,1,130);
INSERT INTO sequence_source VALUES(55,'10ba08ab269b69142b6f83328e3e7099_5239',38,23,1,130);
INSERT INTO sequence_source VALUES(56,'af46526f85cbf2d345d419a0f30e854a_2912',38,21,1,130);
INSERT INTO sequence_source VALUES(57,'e827e3de506c4ff02217fde4a95bfa70_2100',38,33,1,130);
INSERT INTO sequence_source VALUES(58,'602d96b1f4128367c10946522fe33269_2011',38,34,1,130);
INSERT INTO sequence_source VALUES(59,'f65d8c80202d42fc17e32da2bb7f2858_1463',38,22,1,130);
INSERT INTO sequence_source VALUES(60,'ed15fefb7a3655147115fc28a8d6d671_25259',39,20,1,130);
INSERT INTO sequence_source VALUES(61,'af46526f85cbf2d345d419a0f30e854a_5453',39,21,1,130);
INSERT INTO sequence_source VALUES(62,'e827e3de506c4ff02217fde4a95bfa70_1470',39,33,1,130);
INSERT INTO sequence_source VALUES(63,'602d96b1f4128367c10946522fe33269_1253',39,34,1,130);
INSERT INTO sequence_source VALUES(64,'2e4f0ed53888ed39a2aee6d6d8e02206_31423',40,26,1,379);
INSERT INTO sequence_source VALUES(65,'2e4f0ed53888ed39a2aee6d6d8e02206_34919',41,26,1,379);
INSERT INTO sequence_source VALUES(66,'88c30cd5198b5c00764cb64ead1ea822_2124',42,35,1,111);
INSERT INTO sequence_source VALUES(67,'783143261c94eddc7a13630cd5ba33ee_21599',43,36,1,98);
INSERT INTO sequence_source VALUES(68,'ed32541ef8addf4b146847ac02646b28_4248',43,37,1,98);
INSERT INTO sequence_source VALUES(69,'681a00ee195ffe65ef3f2dfd47598653_1725',43,38,1,98);
INSERT INTO sequence_source VALUES(70,'28c639a1150d8b7e4c6fba0e424e0271_1404',43,39,1,98);
INSERT INTO sequence_source VALUES(71,'3c94d5e2cb0abf95075ee1a12aa129c8_1080',43,40,1,98);
INSERT INTO sequence_source VALUES(72,'e6371979623484f3c17cb4805b8a3940_56868',44,41,1,93);
INSERT INTO sequence_source VALUES(73,'7ac50609279c89c7fc3d88ffed426dac_60039',45,42,1,178);
INSERT INTO sequence_source VALUES(74,'4b5e99f8fcd8d04270c10da2bf59020b_39296',46,43,1,244);
INSERT INTO sequence_source VALUES(75,'a2ac9d97f7118c5cd7fa12880050a74a_2371',46,44,1,244);
INSERT INTO sequence_source VALUES(76,'d8613e80b8803b13f7ea5d097f8fe46f_50581',47,45,1,258);
INSERT INTO sequence_source VALUES(77,'f27df8e8755049e831b1ea4521ad6eb3_18661',48,46,1,105);
INSERT INTO sequence_source VALUES(78,'f27df8e8755049e831b1ea4521ad6eb3_82968',49,46,1,105);
INSERT INTO sequence_source VALUES(79,'fe1bd3a42e730f95c9fde798e32f8478_17520',50,47,1,113);
INSERT INTO sequence_source VALUES(80,'fe1bd3a42e730f95c9fde798e32f8478_51270',51,47,1,113);
INSERT INTO sequence_source VALUES(81,'8950417251c8298320f60deda691b35b_59649',52,48,1,156);
INSERT INTO sequence_source VALUES(82,'a59091bd29e998d270db901e842e9bef_8567',53,49,1,121);
INSERT INTO sequence_source VALUES(83,'29de890989becddc5e0b10ecbbc11b1a_48993',54,50,1,2548);
INSERT INTO sequence_source VALUES(84,'36ad9a45fa33397a67d7f6be02a39964_22242',55,51,1,250);
INSERT INTO sequence_source VALUES(85,'24be91088cd4734b066a717bd2de041c_1741',55,52,1,250);
INSERT INTO sequence_source VALUES(86,'7f3b213656cc5541bdcdf4692a3ed5bb_34240',56,53,1,95);
INSERT INTO sequence_source VALUES(87,'d48d9e6e3548bfd92a88d1b46d19bde1_8304',56,54,1,95);
INSERT INTO sequence_source VALUES(88,'7f3b213656cc5541bdcdf4692a3ed5bb_33739',57,53,1,95);
INSERT INTO sequence_source VALUES(89,'d48d9e6e3548bfd92a88d1b46d19bde1_2857',57,54,1,95);
INSERT INTO sequence_source VALUES(90,'8b835ab53506bff14285df6262625455_2854',57,55,1,95);
INSERT INTO sequence_source VALUES(91,'76ca49ebff534e95634d75561c06cf23_1799',57,56,1,95);
INSERT INTO sequence_source VALUES(92,'c971cc015791eec087271765b2b19cc3_32824',58,57,1,211);
INSERT INTO sequence_source VALUES(93,'c79d286595a487be4d76cd8dd3bd384d_5940',58,58,1,211);
INSERT INTO sequence_source VALUES(94,'5661d8e6ef0f1cc4e6cf61e4d7500fcb_1338',58,59,1,211);
INSERT INTO sequence_source VALUES(95,'a7471bc623c89cef2d91a9d43df99579_65718',59,60,1,101);
INSERT INTO sequence_source VALUES(96,'a7471bc623c89cef2d91a9d43df99579_50572',60,60,1,101);
INSERT INTO sequence_source VALUES(97,'f27df8e8755049e831b1ea4521ad6eb3_39917',61,46,1,105);
INSERT INTO sequence_source VALUES(98,'07874837d1d9a8477337081d921a38d4_134940',62,61,1,689);
INSERT INTO sequence_source VALUES(99,'91bf0a26b1eb21d6e54ac6a814c62775_24316',62,62,1,689);
INSERT INTO sequence_source VALUES(100,'0a61e6d1bd2525462225d081bea9c3ce_1055',62,63,1,689);
INSERT INTO sequence_source VALUES(101,'ac00bb7b4811bcc240d374d8bf03cd72_34111',63,64,1,462);
INSERT INTO sequence_source VALUES(102,'3efd1e21521baf83a4751ccd90d39421_5896',63,65,1,462);
INSERT INTO sequence_source VALUES(103,'32159de6cbb6df37d084e31c37c30e7b_54273',64,66,1,123);
INSERT INTO sequence_source VALUES(104,'32159de6cbb6df37d084e31c37c30e7b_28259',65,66,1,123);
INSERT INTO sequence_source VALUES(105,'972db44c016a166de86a2bacab3f4226_11681',66,67,1,110);
INSERT INTO sequence_source VALUES(106,'21d6308d89d74b8ed493d73a2cb4adb5_7364',66,68,1,110);
INSERT INTO sequence_source VALUES(107,'99977bef41e2f50048e6c730637dc941_6189',66,69,1,110);
INSERT INTO sequence_source VALUES(108,'301acf5db567b162de87ca69423a8440_4977',66,70,1,110);
INSERT INTO sequence_source VALUES(109,'4ae6aaf0acd68944c1274608a7211df3_4387',66,71,1,110);
INSERT INTO sequence_source VALUES(110,'366a3b698343fa24129a272f807ccf94_2548',66,72,1,110);
INSERT INTO sequence_source VALUES(111,'d9e6de1308a8ac1448de351747d023c0_1674',66,73,1,110);
INSERT INTO sequence_source VALUES(112,'f502b76965836568a0a113e2074879c8_1353',66,74,1,110);
INSERT INTO sequence_source VALUES(113,'2843e160cc0859ffa1b6ac4f6ec7c508_1248',66,75,1,110);
INSERT INTO sequence_source VALUES(114,'3d3f43d07f2d4dd63fe88aa3d6df9b52_31170',67,76,1,594);
INSERT INTO sequence_source VALUES(115,'2e4f0ed53888ed39a2aee6d6d8e02206_64275',68,26,1,379);
INSERT INTO sequence_source VALUES(116,'951ac00b20e25e3e1664a5edef2acb6c_37204',69,77,1,122);
INSERT INTO sequence_source VALUES(117,'66abcf5b8d99d1570bd815e67442f666_23333',69,78,1,122);
INSERT INTO sequence_source VALUES(118,'b3b684fc69437b76cc7921e2ed287dae_42327',70,27,1,560);
INSERT INTO sequence_source VALUES(119,'12dc63e906f613f17219530896e88839_2218',70,28,1,560);
INSERT INTO sequence_source VALUES(120,'ed15fefb7a3655147115fc28a8d6d671_13032',71,20,1,130);
INSERT INTO sequence_source VALUES(121,'10ba08ab269b69142b6f83328e3e7099_6865',71,23,1,130);
INSERT INTO sequence_source VALUES(122,'e827e3de506c4ff02217fde4a95bfa70_3750',71,33,1,130);
INSERT INTO sequence_source VALUES(123,'af46526f85cbf2d345d419a0f30e854a_3594',71,21,1,130);
INSERT INTO sequence_source VALUES(124,'602d96b1f4128367c10946522fe33269_2428',71,34,1,130);
INSERT INTO sequence_source VALUES(125,'f65d8c80202d42fc17e32da2bb7f2858_2086',71,22,1,130);
INSERT INTO sequence_source VALUES(126,'8b82f3e8bc9c3b11d34027df788ab8b9_1048',71,79,1,130);
INSERT INTO sequence_source VALUES(127,'259d50fc8098473b48ceacb48eb3ed99_30485',72,11,1,94);
INSERT INTO sequence_source VALUES(128,'4b639550662bfcf27f9face76af10d6b_6465',72,80,1,94);
INSERT INTO sequence_source VALUES(129,'b88010d58905d035f845a320e18e00c3_1623',72,81,1,94);
INSERT INTO sequence_source VALUES(130,'259d50fc8098473b48ceacb48eb3ed99_2164',73,11,1,94);
INSERT INTO sequence_source VALUES(131,'259d50fc8098473b48ceacb48eb3ed99_37480',74,11,1,94);
INSERT INTO sequence_source VALUES(132,'4b639550662bfcf27f9face76af10d6b_7494',74,80,1,94);
INSERT INTO sequence_source VALUES(133,'b88010d58905d035f845a320e18e00c3_1863',74,81,1,94);
INSERT INTO sequence_source VALUES(134,'259d50fc8098473b48ceacb48eb3ed99_38509',75,11,1,94);
INSERT INTO sequence_source VALUES(135,'4b639550662bfcf27f9face76af10d6b_6206',75,80,1,94);
INSERT INTO sequence_source VALUES(136,'b88010d58905d035f845a320e18e00c3_1575',75,81,1,94);
INSERT INTO sequence_source VALUES(137,'259d50fc8098473b48ceacb48eb3ed99_42261',76,11,1,94);
INSERT INTO sequence_source VALUES(138,'4b639550662bfcf27f9face76af10d6b_8442',76,80,1,94);
INSERT INTO sequence_source VALUES(139,'b88010d58905d035f845a320e18e00c3_2055',76,81,1,94);
INSERT INTO sequence_source VALUES(140,'259d50fc8098473b48ceacb48eb3ed99_45802',77,11,1,94);
INSERT INTO sequence_source VALUES(141,'4b639550662bfcf27f9face76af10d6b_9102',77,80,1,94);
INSERT INTO sequence_source VALUES(142,'b88010d58905d035f845a320e18e00c3_2213',77,81,1,94);
INSERT INTO sequence_source VALUES(143,'259d50fc8098473b48ceacb48eb3ed99_22928',78,11,1,94);
INSERT INTO sequence_source VALUES(144,'4b639550662bfcf27f9face76af10d6b_3800',78,80,1,94);
INSERT INTO sequence_source VALUES(145,'259d50fc8098473b48ceacb48eb3ed99_42871',79,11,1,94);
INSERT INTO sequence_source VALUES(146,'4b639550662bfcf27f9face76af10d6b_8628',79,80,1,94);
INSERT INTO sequence_source VALUES(147,'b88010d58905d035f845a320e18e00c3_2141',79,81,1,94);
INSERT INTO sequence_source VALUES(148,'259d50fc8098473b48ceacb48eb3ed99_52030',80,11,1,94);
INSERT INTO sequence_source VALUES(149,'4b639550662bfcf27f9face76af10d6b_10261',80,80,1,94);
INSERT INTO sequence_source VALUES(150,'b88010d58905d035f845a320e18e00c3_2544',80,81,1,94);
INSERT INTO sequence_source VALUES(151,'ed15fefb7a3655147115fc28a8d6d671_15291',81,20,1,130);
INSERT INTO sequence_source VALUES(152,'af46526f85cbf2d345d419a0f30e854a_3811',81,21,1,130);
INSERT INTO sequence_source VALUES(153,'10ba08ab269b69142b6f83328e3e7099_1681',81,23,1,130);
INSERT INTO sequence_source VALUES(154,'32159de6cbb6df37d084e31c37c30e7b_25991',82,66,1,123);
INSERT INTO sequence_source VALUES(155,'EU049258.X',83,82,1,35);
INSERT INTO sequence_source VALUES(156,'EU049259.X',83,82,1,35);
INSERT INTO sequence_source VALUES(157,'KC495023.X',83,82,1,35);
INSERT INTO sequence_source VALUES(158,'KC495024.X',83,82,1,35);
INSERT INTO sequence_source VALUES(159,'KC495026.X',83,82,1,35);
INSERT INTO sequence_source VALUES(160,'KC495027.X',83,82,1,35);
INSERT INTO sequence_source VALUES(161,'KC495028.X',83,82,1,35);
INSERT INTO sequence_source VALUES(162,'KC495029.X',83,82,1,35);
INSERT INTO sequence_source VALUES(163,'KC495030.X',83,82,1,35);
INSERT INTO sequence_source VALUES(164,'KC495031.X',83,82,1,35);
INSERT INTO sequence_source VALUES(165,'EU049205.X',83,82,1,35);
INSERT INTO sequence_source VALUES(166,'EU049244.X',83,82,1,35);
INSERT INTO sequence_source VALUES(167,'MZ298305.X',83,83,1,5);
INSERT INTO sequence_source VALUES(168,'AY995379.X',83,83,1,5);
INSERT INTO sequence_source VALUES(169,'MH750688.X',83,83,1,5);
INSERT INTO sequence_source VALUES(170,'MH750698.X',83,83,1,5);
INSERT INTO sequence_source VALUES(171,'KC291561.X',83,83,1,5);
INSERT INTO sequence_source VALUES(172,'AY198307.X',83,84,1,30);
INSERT INTO sequence_source VALUES(173,'HM636048.X',83,84,1,30);
INSERT INTO sequence_source VALUES(174,'HM636049.X',83,84,1,30);
INSERT INTO sequence_source VALUES(175,'MF115273.X',83,85,1,5);
INSERT INTO sequence_source VALUES(176,'MF115278.X',83,85,1,5);
INSERT INTO sequence_source VALUES(177,'MF115280.X',83,85,1,5);
INSERT INTO sequence_source VALUES(178,'MF115282.X',83,85,1,5);
INSERT INTO sequence_source VALUES(179,'MF115284.X',83,85,1,5);
INSERT INTO sequence_source VALUES(180,'MW314367.X',83,85,1,5);
INSERT INTO sequence_source VALUES(181,'MW314372.X',83,85,1,5);
INSERT INTO sequence_source VALUES(182,'MN540000.X',83,86,1,5);
INSERT INTO sequence_source VALUES(183,'MN540001.X',83,86,1,5);
INSERT INTO sequence_source VALUES(184,'JF300276.X',83,87,1,5);
INSERT INTO sequence_source VALUES(185,'JF300280.X',83,87,1,5);
INSERT INTO sequence_source VALUES(186,'AY198254.X',83,88,1,35);
INSERT INTO sequence_source VALUES(187,'EF174955.X',83,89,1,9);
INSERT INTO sequence_source VALUES(188,'AY198234.X',83,89,1,9);
INSERT INTO sequence_source VALUES(189,'KJ494913.X',83,90,1,5);
INSERT INTO sequence_source VALUES(190,'MH290443.X',83,90,1,5);
INSERT INTO sequence_source VALUES(191,'KU248811.X',83,90,1,5);
INSERT INTO sequence_source VALUES(192,'MK177599.X',83,90,1,5);
INSERT INTO sequence_source VALUES(193,'AB688379.X',83,90,1,5);
INSERT INTO sequence_source VALUES(194,'EU301134.X',83,90,1,5);
INSERT INTO sequence_source VALUES(195,'GU993910.X',83,90,1,5);
INSERT INTO sequence_source VALUES(196,'JX965379.X',83,90,1,5);
INSERT INTO sequence_source VALUES(197,'KC748453.X',83,90,1,5);
INSERT INTO sequence_source VALUES(198,'KJ506203.X',83,90,1,5);
INSERT INTO sequence_source VALUES(199,'KJ506204.X',83,90,1,5);
INSERT INTO sequence_source VALUES(200,'KJ506205.X',83,90,1,5);
INSERT INTO sequence_source VALUES(201,'KJ506207.X',83,90,1,5);
INSERT INTO sequence_source VALUES(202,'KJ506209.X',83,90,1,5);
INSERT INTO sequence_source VALUES(203,'KJ506210.X',83,90,1,5);
INSERT INTO sequence_source VALUES(204,'KJ506212.X',83,90,1,5);
INSERT INTO sequence_source VALUES(205,'KJ506216.X',83,90,1,5);
INSERT INTO sequence_source VALUES(206,'KJ506236.X',83,90,1,5);
INSERT INTO sequence_source VALUES(207,'EU391654.X',83,91,1,9);
INSERT INTO sequence_source VALUES(208,'AF266783.X',83,91,1,9);
INSERT INTO sequence_source VALUES(209,'AY198276.X',83,92,1,9);
INSERT INTO sequence_source VALUES(210,'AY198277.X',83,92,1,9);
INSERT INTO sequence_source VALUES(211,'MG542979.X',83,93,1,5);
INSERT INTO sequence_source VALUES(212,'MG542980.X',83,93,1,5);
INSERT INTO sequence_source VALUES(213,'MN306111.X',83,94,1,6);
INSERT INTO sequence_source VALUES(214,'AB688413.X',83,95,1,5);
INSERT INTO sequence_source VALUES(215,'DQ643847.X',83,96,1,9);
INSERT INTO sequence_source VALUES(216,'DQ643851.X',83,96,1,9);
INSERT INTO sequence_source VALUES(217,'DQ643853.X',83,96,1,9);
INSERT INTO sequence_source VALUES(218,'DQ643854.X',83,96,1,9);
INSERT INTO sequence_source VALUES(219,'DQ821186.X',83,97,1,5);
INSERT INTO sequence_source VALUES(220,'KC478759.X',83,97,1,5);
INSERT INTO sequence_source VALUES(221,'MH620162.X',83,97,1,5);
INSERT INTO sequence_source VALUES(222,'OK083797.X',83,98,1,5);
INSERT INTO sequence_source VALUES(223,'MF447452.X',83,99,1,5);
INSERT INTO sequence_source VALUES(224,'AF228086.X',83,99,1,5);
INSERT INTO sequence_source VALUES(225,'KT148940.X',83,99,1,5);
INSERT INTO sequence_source VALUES(226,'GU259281.X',83,99,1,5);
INSERT INTO sequence_source VALUES(227,'AY198278.X',83,100,1,9);
INSERT INTO sequence_source VALUES(228,'KJ506208.X',83,101,1,5);
INSERT INTO sequence_source VALUES(229,'AY198303.X',83,102,1,9);
INSERT INTO sequence_source VALUES(230,'AY608610.X',83,102,1,9);
INSERT INTO sequence_source VALUES(231,'DQ874342.X',83,102,1,9);
INSERT INTO sequence_source VALUES(232,'DQ874343.X',83,102,1,9);
INSERT INTO sequence_source VALUES(233,'KT795474.X',83,102,1,9);
INSERT INTO sequence_source VALUES(234,'KT795475.X',83,102,1,9);
INSERT INTO sequence_source VALUES(235,'KT795476.X',83,102,1,9);
INSERT INTO sequence_source VALUES(236,'KT795477.X',83,102,1,9);
INSERT INTO sequence_source VALUES(237,'AY943305.X',83,103,1,5);
INSERT INTO sequence_source VALUES(238,'KC855180.X',83,103,1,5);
INSERT INTO sequence_source VALUES(239,'OM779088.X',83,104,1,5);
INSERT INTO sequence_source VALUES(240,'OM779089.X',83,104,1,5);
INSERT INTO sequence_source VALUES(241,'JF300218.X',83,105,1,5);
INSERT INTO sequence_source VALUES(242,'JF300278.X',83,106,1,5);
INSERT INTO sequence_source VALUES(243,'EF174893.X',83,107,1,9);
INSERT INTO sequence_source VALUES(244,'EF174898.X',83,107,1,9);
INSERT INTO sequence_source VALUES(245,'DQ078691.X',83,107,1,9);
INSERT INTO sequence_source VALUES(246,'DQ078700.X',83,107,1,9);
INSERT INTO sequence_source VALUES(247,'AY198279.X',83,108,1,9);
INSERT INTO sequence_source VALUES(248,'KF889745.X',83,109,1,55);
INSERT INTO sequence_source VALUES(249,'JF300228.X',83,110,1,5);
INSERT INTO sequence_source VALUES(250,'MG721453.X',83,110,1,5);
INSERT INTO sequence_source VALUES(251,'HQ012959.X',83,111,1,5);
INSERT INTO sequence_source VALUES(252,'HQ012960.X',83,111,1,5);
INSERT INTO sequence_source VALUES(253,'JN547634.X',83,111,1,5);
INSERT INTO sequence_source VALUES(254,'MW830150.X',83,111,1,5);
INSERT INTO sequence_source VALUES(255,'OK041016.X',83,111,1,5);
INSERT INTO sequence_source VALUES(256,'EU049276.X',83,112,1,35);
INSERT INTO sequence_source VALUES(257,'AF465763.X',83,113,1,35);
INSERT INTO sequence_source VALUES(258,'AY659418.X',83,114,1,5);
INSERT INTO sequence_source VALUES(259,'MT328700.X',83,114,1,5);
INSERT INTO sequence_source VALUES(260,'MT328701.X',83,114,1,5);
INSERT INTO sequence_source VALUES(261,'EF174902.X',83,115,1,9);
INSERT INTO sequence_source VALUES(262,'DQ078686.X',83,115,1,9);
INSERT INTO sequence_source VALUES(263,'DQ078690.X',83,115,1,9);
INSERT INTO sequence_source VALUES(264,'EF174953.X',83,115,1,9);
INSERT INTO sequence_source VALUES(265,'AY198230.X',83,115,1,9);
INSERT INTO sequence_source VALUES(266,'MN784447.X',83,115,1,9);
INSERT INTO sequence_source VALUES(267,'AY198232.X',83,116,1,9);
INSERT INTO sequence_source VALUES(268,'AB108061.X',83,117,1,55);
INSERT INTO sequence_source VALUES(269,'AB847465.X',83,117,1,55);
INSERT INTO sequence_source VALUES(270,'MH750692.X',83,118,1,5);
INSERT INTO sequence_source VALUES(271,'GU258891.X',83,118,1,5);
INSERT INTO sequence_source VALUES(272,'KC695701.X',83,118,1,5);
INSERT INTO sequence_source VALUES(273,'MN540006.X',83,119,1,5);
INSERT INTO sequence_source VALUES(274,'JF300255.X',83,120,1,5);
INSERT INTO sequence_source VALUES(275,'JF300256.X',83,120,1,5);
INSERT INTO sequence_source VALUES(276,'JF300257.X',83,120,1,5);
INSERT INTO sequence_source VALUES(277,'JF300263.X',83,120,1,5);
INSERT INTO sequence_source VALUES(278,'JF300264.X',83,120,1,5);
INSERT INTO sequence_source VALUES(279,'EU049249.X',83,121,1,35);
INSERT INTO sequence_source VALUES(280,'AY198257.X',83,121,1,35);
INSERT INTO sequence_source VALUES(282,'AY198263.X',83,122,1,9);
INSERT INTO sequence_source VALUES(283,'GU259492.X',83,123,1,5);
INSERT INTO sequence_source VALUES(284,'MW248419.X',83,124,1,5);
INSERT INTO sequence_source VALUES(285,'KF889744.X',83,125,1,55);
INSERT INTO sequence_source VALUES(286,'JX074738.X',83,125,1,55);
INSERT INTO sequence_source VALUES(287,'JF300254.X',83,126,1,5);
INSERT INTO sequence_source VALUES(288,'DQ131920.X',83,127,1,4);
INSERT INTO sequence_source VALUES(289,'AY198244.X',83,128,1,9);
INSERT INTO sequence_source VALUES(290,'MK015675.X',83,129,1,55);
INSERT INTO sequence_source VALUES(291,'KY084741.X',83,129,1,55);
INSERT INTO sequence_source VALUES(292,'AB108025.X',83,129,1,55);
INSERT INTO sequence_source VALUES(293,'AB108026.X',83,129,1,55);
INSERT INTO sequence_source VALUES(294,'AB108030.X',83,129,1,55);
INSERT INTO sequence_source VALUES(295,'AB108037.X',83,129,1,55);
INSERT INTO sequence_source VALUES(296,'AB108038.X',83,129,1,55);
INSERT INTO sequence_source VALUES(297,'AB108044.X',83,129,1,55);
INSERT INTO sequence_source VALUES(298,'AB108045.X',83,129,1,55);
INSERT INTO sequence_source VALUES(299,'AB108046.X',83,129,1,55);
INSERT INTO sequence_source VALUES(300,'AB108056.X',83,129,1,55);
INSERT INTO sequence_source VALUES(301,'AB690611.X',83,129,1,55);
INSERT INTO sequence_source VALUES(302,'AB847463.X',83,129,1,55);
INSERT INTO sequence_source VALUES(303,'GU133575.X',83,129,1,55);
INSERT INTO sequence_source VALUES(304,'KC907734.X',83,129,1,55);
INSERT INTO sequence_source VALUES(305,'MK035954.X',83,130,1,5);
INSERT INTO sequence_source VALUES(306,'MK035955.X',83,130,1,5);
INSERT INTO sequence_source VALUES(307,'AB688418.X',83,131,1,5);
INSERT INTO sequence_source VALUES(308,'KY084742.X',83,132,1,55);
INSERT INTO sequence_source VALUES(309,'OK083788.X',83,133,1,5);
INSERT INTO sequence_source VALUES(310,'EU301141.X',83,134,1,5);
INSERT INTO sequence_source VALUES(311,'KT337856.X',83,135,1,5);
INSERT INTO sequence_source VALUES(312,'KT337858.X',83,135,1,5);
INSERT INTO sequence_source VALUES(313,'KJ651411.X',83,136,1,9);
INSERT INTO sequence_source VALUES(314,'AB920522.X',83,137,1,55);
INSERT INTO sequence_source VALUES(315,'AB920533.X',83,137,1,55);
INSERT INTO sequence_source VALUES(316,'DQ916368.X',83,137,1,55);
INSERT INTO sequence_source VALUES(317,'DQ916372.X',83,137,1,55);
INSERT INTO sequence_source VALUES(318,'DQ916374.X',83,137,1,55);
INSERT INTO sequence_source VALUES(319,'JN630486.X',83,137,1,55);
INSERT INTO sequence_source VALUES(320,'KT337673.X',83,137,1,55);
INSERT INTO sequence_source VALUES(321,'KT337717.X',83,137,1,55);
INSERT INTO sequence_source VALUES(322,'FJ499337.X',83,138,1,5);
INSERT INTO sequence_source VALUES(323,'AB217683.1',84,139,1,5);
INSERT INTO sequence_source VALUES(324,'AB305060.1',84,140,1,5);
INSERT INTO sequence_source VALUES(325,'AB305061.1',84,140,1,5);
INSERT INTO sequence_source VALUES(326,'AB305062.1',84,140,1,5);
INSERT INTO sequence_source VALUES(327,'AB305063.1',84,140,1,5);
INSERT INTO sequence_source VALUES(328,'AB305064.1',84,140,1,5);
INSERT INTO sequence_source VALUES(329,'AB305065.1',84,140,1,5);
INSERT INTO sequence_source VALUES(330,'AB305066.1',84,46,1,5);
INSERT INTO sequence_source VALUES(331,'AB355596.1',84,141,1,62);
INSERT INTO sequence_source VALUES(332,'AB627344.1',84,142,1,6);
INSERT INTO sequence_source VALUES(333,'AB627345.1',84,143,1,6);
INSERT INTO sequence_source VALUES(334,'AB627346.1',84,144,1,55);
INSERT INTO sequence_source VALUES(335,'AB627347.1',84,145,1,55);
INSERT INTO sequence_source VALUES(336,'AB669142.1',84,60,1,5);
INSERT INTO sequence_source VALUES(337,'AB688354.1',84,146,1,5);
INSERT INTO sequence_source VALUES(338,'AB898680.1',84,147,1,35);
INSERT INTO sequence_source VALUES(339,'AF087471.1',84,148,1,5);
INSERT INTO sequence_source VALUES(340,'AF087472.1',84,149,1,5);
INSERT INTO sequence_source VALUES(341,'AF087473.1',84,150,1,5);
INSERT INTO sequence_source VALUES(342,'AF087474.1',84,151,1,5);
INSERT INTO sequence_source VALUES(343,'AF087475.1',84,152,1,5);
INSERT INTO sequence_source VALUES(344,'AF087476.1',84,148,1,5);
INSERT INTO sequence_source VALUES(345,'AF087477.1',84,153,1,5);
INSERT INTO sequence_source VALUES(346,'AF087478.1',84,154,1,5);
INSERT INTO sequence_source VALUES(347,'AF087479.1',84,155,1,5);
INSERT INTO sequence_source VALUES(348,'AF087480.1',84,156,1,5);
INSERT INTO sequence_source VALUES(349,'AF241740.1',84,157,1,35);
INSERT INTO sequence_source VALUES(350,'AF241741.1',84,157,1,35);
INSERT INTO sequence_source VALUES(351,'AF241742.1',84,157,1,35);
INSERT INTO sequence_source VALUES(352,'AF241743.1',84,157,1,35);
INSERT INTO sequence_source VALUES(353,'AF241744.1',84,157,1,35);
INSERT INTO sequence_source VALUES(354,'AF241745.1',84,157,1,35);
INSERT INTO sequence_source VALUES(355,'AF241746.1',84,157,1,35);
INSERT INTO sequence_source VALUES(356,'AF241747.1',84,157,1,35);
INSERT INTO sequence_source VALUES(357,'AF241748.1',84,157,1,35);
INSERT INTO sequence_source VALUES(358,'AF241749.1',84,157,1,35);
INSERT INTO sequence_source VALUES(359,'AF241750.1',84,157,1,35);
INSERT INTO sequence_source VALUES(360,'AF241751.1',84,157,1,35);
INSERT INTO sequence_source VALUES(361,'AF241752.1',84,157,1,35);
INSERT INTO sequence_source VALUES(362,'AF241753.1',84,158,1,35);
INSERT INTO sequence_source VALUES(363,'AF241754.1',84,158,1,35);
INSERT INTO sequence_source VALUES(364,'AF241755.1',84,158,1,35);
INSERT INTO sequence_source VALUES(365,'AF241756.1',84,158,1,35);
INSERT INTO sequence_source VALUES(366,'AF241757.1',84,158,1,35);
INSERT INTO sequence_source VALUES(367,'AF241758.1',84,158,1,35);
INSERT INTO sequence_source VALUES(368,'AF241759.1',84,158,1,35);
INSERT INTO sequence_source VALUES(369,'AF241760.1',84,158,1,35);
INSERT INTO sequence_source VALUES(370,'AF241761.1',84,158,1,35);
INSERT INTO sequence_source VALUES(371,'AF241762.1',84,158,1,35);
INSERT INTO sequence_source VALUES(372,'AF241763.1',84,158,1,35);
INSERT INTO sequence_source VALUES(373,'AF241764.1',84,158,1,35);
INSERT INTO sequence_source VALUES(374,'AF241770.1',84,5,1,3);
INSERT INTO sequence_source VALUES(375,'AF528556.1',84,159,1,9);
INSERT INTO sequence_source VALUES(376,'AF528557.1',84,159,1,9);
INSERT INTO sequence_source VALUES(377,'AF528558.1',84,160,1,9);
INSERT INTO sequence_source VALUES(378,'AF528559.1',84,161,1,9);
INSERT INTO sequence_source VALUES(379,'AF528560.1',84,162,1,9);
INSERT INTO sequence_source VALUES(380,'AF528561.1',84,163,1,9);
INSERT INTO sequence_source VALUES(381,'AF528562.1',84,163,1,9);
INSERT INTO sequence_source VALUES(382,'AF528563.1',84,163,1,9);
INSERT INTO sequence_source VALUES(383,'AF528564.1',84,164,1,9);
INSERT INTO sequence_source VALUES(384,'AJ007040.1',84,165,1,5);
INSERT INTO sequence_source VALUES(385,'AJ007368.1',84,166,1,5);
INSERT INTO sequence_source VALUES(386,'AJ007369.1',84,167,1,5);
INSERT INTO sequence_source VALUES(387,'AJ007370.1',84,168,1,5);
INSERT INTO sequence_source VALUES(388,'AJ299733.1',84,169,1,5);
INSERT INTO sequence_source VALUES(389,'AJ299734.1',84,170,1,5);
INSERT INTO sequence_source VALUES(390,'AJ555612.1',84,29,1,5);
INSERT INTO sequence_source VALUES(391,'AJ628985.1',84,171,1,62);
INSERT INTO sequence_source VALUES(392,'AJ628986.1',84,172,1,62);
INSERT INTO sequence_source VALUES(393,'AJ854284.1',84,29,1,5);
INSERT INTO sequence_source VALUES(394,'AJ854285.1',84,29,1,5);
INSERT INTO sequence_source VALUES(395,'AJ854288.1',84,46,1,5);
INSERT INTO sequence_source VALUES(396,'AJ854289.1',84,46,1,5);
INSERT INTO sequence_source VALUES(397,'AJ854290.1',84,46,1,5);
INSERT INTO sequence_source VALUES(398,'AJ854291.1',84,11,1,5);
INSERT INTO sequence_source VALUES(399,'AJ854292.1',84,11,1,5);
INSERT INTO sequence_source VALUES(400,'AJ854293.1',84,11,1,5);
INSERT INTO sequence_source VALUES(401,'AJ854295.1',84,173,1,5);
INSERT INTO sequence_source VALUES(402,'AJ854297.1',84,66,1,5);
INSERT INTO sequence_source VALUES(403,'AJ854298.1',84,66,1,5);
INSERT INTO sequence_source VALUES(404,'AJ854300.1',84,13,1,5);
INSERT INTO sequence_source VALUES(405,'AJ854301.1',84,174,1,5);
INSERT INTO sequence_source VALUES(406,'AJ854302.1',84,175,1,5);
INSERT INTO sequence_source VALUES(407,'AM235209.1',84,176,1,5);
INSERT INTO sequence_source VALUES(408,'AM422703.1',84,177,1,5);
INSERT INTO sequence_source VALUES(409,'AM422704.1',84,60,1,5);
INSERT INTO sequence_source VALUES(410,'AY191003.1',84,178,1,55);
INSERT INTO sequence_source VALUES(411,'AY198240.3',84,179,1,9);
INSERT INTO sequence_source VALUES(412,'AY198246.3',84,180,1,9);
INSERT INTO sequence_source VALUES(413,'AY198250.3',84,181,1,35);
INSERT INTO sequence_source VALUES(414,'AY198253.3',84,182,1,35);
INSERT INTO sequence_source VALUES(415,'AY198293.3',84,183,1,9);
INSERT INTO sequence_source VALUES(416,'AY198296.3',84,184,1,9);
INSERT INTO sequence_source VALUES(417,'AY198298.3',84,185,1,9);
INSERT INTO sequence_source VALUES(418,'AY198300.3',84,186,1,9);
INSERT INTO sequence_source VALUES(419,'AY198301.3',84,187,1,9);
INSERT INTO sequence_source VALUES(420,'AY198306.3',84,188,1,30);
INSERT INTO sequence_source VALUES(421,'AY210983.1',84,189,1,35);
INSERT INTO sequence_source VALUES(422,'AY210984.1',84,190,1,35);
INSERT INTO sequence_source VALUES(423,'AY210985.1',84,191,1,35);
INSERT INTO sequence_source VALUES(424,'AY210986.1',84,192,1,35);
INSERT INTO sequence_source VALUES(425,'AY210987.1',84,193,1,35);
INSERT INTO sequence_source VALUES(426,'AY210988.1',84,194,1,35);
INSERT INTO sequence_source VALUES(427,'AY210989.1',84,195,1,35);
INSERT INTO sequence_source VALUES(428,'AY210990.1',84,196,1,35);
INSERT INTO sequence_source VALUES(429,'AY210991.1',84,196,1,35);
INSERT INTO sequence_source VALUES(430,'AY210992.1',84,196,1,35);
INSERT INTO sequence_source VALUES(431,'AY210993.1',84,196,1,35);
INSERT INTO sequence_source VALUES(432,'AY210994.1',84,197,1,35);
INSERT INTO sequence_source VALUES(433,'AY210995.1',84,198,1,35);
INSERT INTO sequence_source VALUES(434,'AY210996.1',84,198,1,35);
INSERT INTO sequence_source VALUES(435,'AY210997.1',84,199,1,35);
INSERT INTO sequence_source VALUES(436,'AY210998.1',84,200,1,35);
INSERT INTO sequence_source VALUES(437,'AY210999.1',84,201,1,35);
INSERT INTO sequence_source VALUES(438,'AY211000.1',84,202,1,35);
INSERT INTO sequence_source VALUES(439,'AY211001.1',84,203,1,35);
INSERT INTO sequence_source VALUES(440,'AY211002.1',84,204,1,35);
INSERT INTO sequence_source VALUES(441,'AY211003.1',84,205,1,35);
INSERT INTO sequence_source VALUES(442,'AY211004.1',84,206,1,35);
INSERT INTO sequence_source VALUES(443,'AY211005.1',84,206,1,35);
INSERT INTO sequence_source VALUES(444,'AY211006.1',84,207,1,35);
INSERT INTO sequence_source VALUES(445,'AY211007.1',84,208,1,35);
INSERT INTO sequence_source VALUES(446,'AY211008.1',84,209,1,35);
INSERT INTO sequence_source VALUES(447,'AY211009.1',84,210,1,35);
INSERT INTO sequence_source VALUES(448,'AY211010.1',84,211,1,35);
INSERT INTO sequence_source VALUES(449,'AY211011.1',84,212,1,36);
INSERT INTO sequence_source VALUES(450,'AY211012.1',84,213,1,36);
INSERT INTO sequence_source VALUES(451,'AY211013.1',84,214,1,36);
INSERT INTO sequence_source VALUES(452,'AY211014.1',84,215,1,36);
INSERT INTO sequence_source VALUES(453,'AY211015.1',84,163,1,9);
INSERT INTO sequence_source VALUES(454,'AY211016.1',84,163,1,9);
INSERT INTO sequence_source VALUES(455,'AY211017.1',84,159,1,9);
INSERT INTO sequence_source VALUES(456,'AY211018.1',84,160,1,9);
INSERT INTO sequence_source VALUES(457,'AY211019.1',84,216,1,9);
INSERT INTO sequence_source VALUES(458,'AY256844.1',84,217,1,5);
INSERT INTO sequence_source VALUES(459,'AY277278.1',84,218,1,5);
INSERT INTO sequence_source VALUES(460,'AY302142.1',84,13,1,5);
INSERT INTO sequence_source VALUES(461,'AY302143.1',84,13,1,5);
INSERT INTO sequence_source VALUES(462,'AY302144.1',84,13,1,5);
INSERT INTO sequence_source VALUES(463,'AY302145.1',84,13,1,5);
INSERT INTO sequence_source VALUES(464,'AY302146.1',84,13,1,5);
INSERT INTO sequence_source VALUES(465,'AY302147.1',84,13,1,5);
INSERT INTO sequence_source VALUES(466,'AY302150.1',84,154,1,5);
INSERT INTO sequence_source VALUES(467,'AY302152.1',84,13,1,5);
INSERT INTO sequence_source VALUES(468,'AY302153.1',84,13,1,5);
INSERT INTO sequence_source VALUES(469,'AY302157.1',84,13,1,5);
INSERT INTO sequence_source VALUES(470,'AY302161.1',84,13,1,5);
INSERT INTO sequence_source VALUES(471,'AY302163.1',84,13,1,5);
INSERT INTO sequence_source VALUES(472,'AY302166.1',84,13,1,5);
INSERT INTO sequence_source VALUES(473,'AY302167.1',84,13,1,5);
INSERT INTO sequence_source VALUES(474,'AY302168.1',84,13,1,5);
INSERT INTO sequence_source VALUES(475,'AY302169.1',84,13,1,5);
INSERT INTO sequence_source VALUES(476,'AY302170.1',84,13,1,5);
INSERT INTO sequence_source VALUES(477,'AY302172.1',84,13,1,5);
INSERT INTO sequence_source VALUES(478,'AY302173.1',84,13,1,5);
INSERT INTO sequence_source VALUES(479,'AY302174.1',84,219,1,5);
INSERT INTO sequence_source VALUES(480,'AY302175.1',84,13,1,5);
INSERT INTO sequence_source VALUES(481,'AY302176.1',84,13,1,5);
INSERT INTO sequence_source VALUES(482,'AY302178.1',84,13,1,5);
INSERT INTO sequence_source VALUES(483,'AY302179.1',84,13,1,5);
INSERT INTO sequence_source VALUES(484,'AY302180.1',84,13,1,5);
INSERT INTO sequence_source VALUES(485,'AY302181.1',84,13,1,5);
INSERT INTO sequence_source VALUES(486,'AY302182.1',84,13,1,5);
INSERT INTO sequence_source VALUES(487,'AY310438.1',84,220,1,6);
INSERT INTO sequence_source VALUES(488,'AY310440.1',84,171,1,62);
INSERT INTO sequence_source VALUES(489,'AY332651.1',84,221,1,5);
INSERT INTO sequence_source VALUES(490,'AY332652.1',84,221,1,5);
INSERT INTO sequence_source VALUES(491,'AY332653.1',84,221,1,5);
INSERT INTO sequence_source VALUES(492,'AY332654.1',84,221,1,5);
INSERT INTO sequence_source VALUES(493,'AY366462.1',84,222,1,5);
INSERT INTO sequence_source VALUES(494,'AY366463.1',84,222,1,5);
INSERT INTO sequence_source VALUES(495,'AY375242.1',84,223,1,62);
INSERT INTO sequence_source VALUES(496,'AY436638.1',84,224,1,61);
INSERT INTO sequence_source VALUES(497,'AY486144.1',84,225,1,6);
INSERT INTO sequence_source VALUES(498,'AY525786.1',84,168,1,5);
INSERT INTO sequence_source VALUES(499,'AY590267.1',84,78,1,5);
INSERT INTO sequence_source VALUES(500,'AY590268.1',84,78,1,5);
INSERT INTO sequence_source VALUES(501,'AY590270.1',84,77,1,5);
INSERT INTO sequence_source VALUES(502,'AY590271.1',84,78,1,5);
INSERT INTO sequence_source VALUES(503,'AY590272.1',84,77,1,5);
INSERT INTO sequence_source VALUES(504,'AY590273.1',84,77,1,5);
INSERT INTO sequence_source VALUES(505,'AY590274.1',84,78,1,5);
INSERT INTO sequence_source VALUES(506,'AY590275.1',84,226,1,5);
INSERT INTO sequence_source VALUES(507,'AY590276.1',84,78,1,5);
INSERT INTO sequence_source VALUES(508,'AY590277.1',84,78,1,5);
INSERT INTO sequence_source VALUES(509,'AY594197.1',84,227,1,5);
INSERT INTO sequence_source VALUES(510,'AY594198.1',84,227,1,5);
INSERT INTO sequence_source VALUES(511,'AY598639.2',84,228,1,62);
INSERT INTO sequence_source VALUES(512,'AY598641.2',84,229,1,62);
INSERT INTO sequence_source VALUES(513,'AY598642.2',84,230,1,62);
INSERT INTO sequence_source VALUES(514,'AY598643.2',84,231,1,62);
INSERT INTO sequence_source VALUES(515,'AY598644.2',84,232,1,62);
INSERT INTO sequence_source VALUES(516,'AY598645.2',84,233,1,62);
INSERT INTO sequence_source VALUES(517,'AY598646.2',84,234,1,62);
INSERT INTO sequence_source VALUES(518,'AY598647.4',84,235,1,62);
INSERT INTO sequence_source VALUES(519,'AY598648.2',84,236,1,62);
INSERT INTO sequence_source VALUES(520,'AY598649.2',84,237,1,62);
INSERT INTO sequence_source VALUES(521,'AY598650.3',84,238,1,61);
INSERT INTO sequence_source VALUES(522,'AY598652.2',84,239,1,61);
INSERT INTO sequence_source VALUES(523,'AY598653.2',84,240,1,61);
INSERT INTO sequence_source VALUES(524,'AY598654.2',84,241,1,62);
INSERT INTO sequence_source VALUES(525,'AY598655.2',84,242,1,62);
INSERT INTO sequence_source VALUES(526,'AY598657.2',84,141,1,62);
INSERT INTO sequence_source VALUES(527,'AY598658.2',84,243,1,62);
INSERT INTO sequence_source VALUES(528,'AY598659.2',84,244,1,62);
INSERT INTO sequence_source VALUES(529,'AY598660.2',84,245,1,62);
INSERT INTO sequence_source VALUES(530,'AY598661.2',84,246,1,62);
INSERT INTO sequence_source VALUES(531,'AY598662.2',84,247,1,55);
INSERT INTO sequence_source VALUES(532,'AY598663.2',84,248,1,55);
INSERT INTO sequence_source VALUES(533,'AY598664.2',84,249,1,55);
INSERT INTO sequence_source VALUES(534,'AY598665.2',84,250,1,55);
INSERT INTO sequence_source VALUES(535,'AY598666.2',84,251,1,55);
INSERT INTO sequence_source VALUES(536,'AY598696.2',84,252,1,62);
INSERT INTO sequence_source VALUES(537,'AY598697.2',84,253,1,62);
INSERT INTO sequence_source VALUES(538,'AY598701.2',84,254,1,62);
INSERT INTO sequence_source VALUES(539,'AY598702.2',84,255,1,62);
INSERT INTO sequence_source VALUES(540,'AY598704.2',84,256,1,62);
INSERT INTO sequence_source VALUES(541,'AY598705.2',84,257,1,62);
INSERT INTO sequence_source VALUES(542,'AY598706.2',84,258,1,62);
INSERT INTO sequence_source VALUES(543,'AY598707.2',84,259,1,62);
INSERT INTO sequence_source VALUES(544,'AY598708.2',84,224,1,61);
INSERT INTO sequence_source VALUES(545,'AY598709.2',84,260,1,62);
INSERT INTO sequence_source VALUES(546,'AY598711.2',84,261,1,62);
INSERT INTO sequence_source VALUES(547,'AY598712.2',84,262,1,62);
INSERT INTO sequence_source VALUES(548,'AY598717.2',84,263,1,62);
INSERT INTO sequence_source VALUES(549,'AY684914.1',84,264,1,5);
INSERT INTO sequence_source VALUES(550,'AY684915.1',84,265,1,5);
INSERT INTO sequence_source VALUES(551,'AY684925.1',84,266,1,6);
INSERT INTO sequence_source VALUES(552,'AY695806.1',84,267,1,9);
INSERT INTO sequence_source VALUES(553,'AY695807.1',84,267,1,9);
INSERT INTO sequence_source VALUES(554,'AY739021.1',84,268,1,5);
INSERT INTO sequence_source VALUES(555,'AY745749.1',84,269,1,5);
INSERT INTO sequence_source VALUES(556,'AY745750.1',84,60,1,5);
INSERT INTO sequence_source VALUES(557,'AY745751.1',84,60,1,5);
INSERT INTO sequence_source VALUES(558,'AY745752.1',84,270,1,5);
INSERT INTO sequence_source VALUES(559,'AY753572.1',84,271,1,6);
INSERT INTO sequence_source VALUES(560,'AY753573.1',84,272,1,62);
INSERT INTO sequence_source VALUES(561,'AY964101.1',84,154,1,5);
INSERT INTO sequence_source VALUES(562,'AY964102.1',84,273,1,5);
INSERT INTO sequence_source VALUES(563,'AY987037.1',84,274,1,6);
INSERT INTO sequence_source VALUES(564,'AY987038.1',84,275,1,62);
INSERT INTO sequence_source VALUES(565,'AY995339.1',84,276,1,5);
INSERT INTO sequence_source VALUES(566,'AY995341.1',84,277,1,5);
INSERT INTO sequence_source VALUES(567,'AY995342.1',84,278,1,5);
INSERT INTO sequence_source VALUES(568,'AY995343.1',84,279,1,5);
INSERT INTO sequence_source VALUES(569,'AY995351.1',84,46,1,5);
INSERT INTO sequence_source VALUES(570,'AY995355.1',84,280,1,5);
INSERT INTO sequence_source VALUES(571,'AY995356.1',84,281,1,5);
INSERT INTO sequence_source VALUES(572,'AY995360.1',84,282,1,5);
INSERT INTO sequence_source VALUES(573,'AY995366.1',84,283,1,5);
INSERT INTO sequence_source VALUES(574,'AY995367.1',84,284,1,5);
INSERT INTO sequence_source VALUES(575,'AY995373.1',84,285,1,5);
INSERT INTO sequence_source VALUES(576,'AY995376.1',84,46,1,5);
INSERT INTO sequence_source VALUES(577,'AY995377.1',84,282,1,5);
INSERT INTO sequence_source VALUES(578,'AY995378.1',84,46,1,5);
INSERT INTO sequence_source VALUES(579,'AY995380.1',84,286,1,5);
INSERT INTO sequence_source VALUES(580,'AY995385.1',84,287,1,5);
INSERT INTO sequence_source VALUES(581,'AY995386.1',84,288,1,5);
INSERT INTO sequence_source VALUES(582,'AY995389.1',84,287,1,5);
INSERT INTO sequence_source VALUES(583,'AY995390.1',84,277,1,5);
INSERT INTO sequence_source VALUES(584,'AY995391.1',84,287,1,5);
INSERT INTO sequence_source VALUES(585,'AY995392.1',84,289,1,5);
INSERT INTO sequence_source VALUES(586,'AY995395.1',84,285,1,5);
INSERT INTO sequence_source VALUES(587,'AY995396.1',84,53,1,5);
INSERT INTO sequence_source VALUES(588,'AY995399.1',84,290,1,5);
INSERT INTO sequence_source VALUES(589,'AY995403.1',84,277,1,5);
INSERT INTO sequence_source VALUES(590,'AY995405.1',84,291,1,5);
INSERT INTO sequence_source VALUES(591,'AY995406.1',84,53,1,5);
INSERT INTO sequence_source VALUES(592,'D86515.1',84,171,1,62);
INSERT INTO sequence_source VALUES(593,'DQ067896.1',84,292,1,9);
INSERT INTO sequence_source VALUES(594,'DQ067897.1',84,292,1,9);
INSERT INTO sequence_source VALUES(595,'DQ168873.1',84,293,1,5);
INSERT INTO sequence_source VALUES(596,'DQ173082.1',84,294,1,5);
INSERT INTO sequence_source VALUES(597,'DQ202400.1',84,295,1,9);
INSERT INTO sequence_source VALUES(598,'DQ235793.1',84,296,1,3);
INSERT INTO sequence_source VALUES(599,'DQ235794.1',84,296,1,3);
INSERT INTO sequence_source VALUES(600,'DQ235795.1',84,5,1,3);
INSERT INTO sequence_source VALUES(601,'DQ235796.1',84,5,1,3);
INSERT INTO sequence_source VALUES(602,'DQ235799.1',84,297,1,3);
INSERT INTO sequence_source VALUES(603,'DQ235800.1',84,298,1,3);
INSERT INTO sequence_source VALUES(604,'DQ528740.1',84,299,1,62);
INSERT INTO sequence_source VALUES(605,'DQ528741.1',84,233,1,62);
INSERT INTO sequence_source VALUES(606,'DQ528742.1',84,300,1,62);
INSERT INTO sequence_source VALUES(607,'DQ528743.1',84,301,1,6);
INSERT INTO sequence_source VALUES(608,'DQ995184.1',84,31,1,5);
INSERT INTO sequence_source VALUES(609,'DQ995185.1',84,31,1,5);
INSERT INTO sequence_source VALUES(610,'EF027353.1',84,302,1,5);
INSERT INTO sequence_source VALUES(611,'EF055294.1',84,303,1,62);
INSERT INTO sequence_source VALUES(612,'EF055298.1',84,304,1,62);
INSERT INTO sequence_source VALUES(613,'EF064137.1',84,53,1,5);
INSERT INTO sequence_source VALUES(614,'EF064138.1',84,41,1,5);
INSERT INTO sequence_source VALUES(615,'EF126351.1',84,305,1,5);
INSERT INTO sequence_source VALUES(616,'EF150860.1',84,13,1,5);
INSERT INTO sequence_source VALUES(617,'EF150861.1',84,13,1,5);
INSERT INTO sequence_source VALUES(618,'EF150862.1',84,306,1,5);
INSERT INTO sequence_source VALUES(619,'EF150863.1',84,307,1,5);
INSERT INTO sequence_source VALUES(620,'EF150865.1',84,13,1,5);
INSERT INTO sequence_source VALUES(621,'EF150870.1',84,13,1,5);
INSERT INTO sequence_source VALUES(622,'EF150871.1',84,13,1,5);
INSERT INTO sequence_source VALUES(623,'EF150872.1',84,13,1,5);
INSERT INTO sequence_source VALUES(624,'EF150874.1',84,219,1,5);
INSERT INTO sequence_source VALUES(625,'EF150876.1',84,13,1,5);
INSERT INTO sequence_source VALUES(626,'EF152508.1',84,308,1,6);
INSERT INTO sequence_source VALUES(627,'EF152512.1',84,309,1,5);
INSERT INTO sequence_source VALUES(628,'EF152514.1',84,310,1,5);
INSERT INTO sequence_source VALUES(629,'EF152519.1',84,311,1,5);
INSERT INTO sequence_source VALUES(630,'EF153666.1',84,312,1,9);
INSERT INTO sequence_source VALUES(631,'EF153667.1',84,312,1,9);
INSERT INTO sequence_source VALUES(632,'EF153668.1',84,312,1,9);
INSERT INTO sequence_source VALUES(633,'EF153669.1',84,312,1,9);
INSERT INTO sequence_source VALUES(634,'EF153670.1',84,312,1,9);
INSERT INTO sequence_source VALUES(635,'EF153672.1',84,313,1,5);
INSERT INTO sequence_source VALUES(636,'EF153673.1',84,313,1,5);
INSERT INTO sequence_source VALUES(637,'EF153674.1',84,176,1,5);
INSERT INTO sequence_source VALUES(638,'EF153677.1',84,314,1,6);
INSERT INTO sequence_source VALUES(639,'EF174435.1',84,315,1,5);
INSERT INTO sequence_source VALUES(640,'EF187913.1',84,265,1,5);
INSERT INTO sequence_source VALUES(641,'EF187915.1',84,171,1,62);
INSERT INTO sequence_source VALUES(642,'EF193212.1',84,311,1,5);
INSERT INTO sequence_source VALUES(643,'EF193213.1',84,311,1,5);
INSERT INTO sequence_source VALUES(644,'EF193214.1',84,311,1,5);
INSERT INTO sequence_source VALUES(645,'EF193215.1',84,36,1,5);
INSERT INTO sequence_source VALUES(646,'EF193216.1',84,311,1,5);
INSERT INTO sequence_source VALUES(647,'EF193217.1',84,311,1,5);
INSERT INTO sequence_source VALUES(648,'EF193218.1',84,311,1,5);
INSERT INTO sequence_source VALUES(649,'EF193219.1',84,311,1,5);
INSERT INTO sequence_source VALUES(650,'EF193220.1',84,311,1,5);
INSERT INTO sequence_source VALUES(651,'EF193221.1',84,311,1,5);
INSERT INTO sequence_source VALUES(652,'EF193222.1',84,311,1,5);
INSERT INTO sequence_source VALUES(653,'EF193223.1',84,279,1,5);
INSERT INTO sequence_source VALUES(654,'EF193224.1',84,311,1,5);
INSERT INTO sequence_source VALUES(655,'EF193225.1',84,311,1,5);
INSERT INTO sequence_source VALUES(656,'EF193226.1',84,156,1,5);
INSERT INTO sequence_source VALUES(657,'EF193230.1',84,176,1,5);
INSERT INTO sequence_source VALUES(658,'EF193231.1',84,316,1,5);
INSERT INTO sequence_source VALUES(659,'EF193232.1',84,46,1,5);
INSERT INTO sequence_source VALUES(660,'EF193234.1',84,311,1,5);
INSERT INTO sequence_source VALUES(661,'EF193235.1',84,46,1,5);
INSERT INTO sequence_source VALUES(662,'EF193236.1',84,316,1,5);
INSERT INTO sequence_source VALUES(663,'EF193238.1',84,316,1,5);
INSERT INTO sequence_source VALUES(664,'EF193239.1',84,311,1,5);
INSERT INTO sequence_source VALUES(665,'EF195137.1',84,317,1,6);
INSERT INTO sequence_source VALUES(666,'EF195138.1',84,317,1,6);
INSERT INTO sequence_source VALUES(667,'EF195139.1',84,317,1,6);
INSERT INTO sequence_source VALUES(668,'EF213590.1',84,318,1,5);
INSERT INTO sequence_source VALUES(669,'EF213591.1',84,53,1,5);
INSERT INTO sequence_source VALUES(670,'EF213592.1',84,53,1,5);
INSERT INTO sequence_source VALUES(671,'EF213593.1',84,319,1,5);
INSERT INTO sequence_source VALUES(672,'EF213594.1',84,53,1,5);
INSERT INTO sequence_source VALUES(673,'EF213595.1',84,20,1,5);
INSERT INTO sequence_source VALUES(674,'EF213596.1',84,46,1,5);
INSERT INTO sequence_source VALUES(675,'EF213597.1',84,46,1,5);
INSERT INTO sequence_source VALUES(676,'EF213598.1',84,53,1,5);
INSERT INTO sequence_source VALUES(677,'EF213599.1',84,20,1,5);
INSERT INTO sequence_source VALUES(678,'EF213600.1',84,53,1,5);
INSERT INTO sequence_source VALUES(679,'EF213601.1',84,20,1,5);
INSERT INTO sequence_source VALUES(680,'EF213602.1',84,46,1,5);
INSERT INTO sequence_source VALUES(681,'EF213604.1',84,320,1,5);
INSERT INTO sequence_source VALUES(682,'EF213605.1',84,46,1,5);
INSERT INTO sequence_source VALUES(683,'EF213606.1',84,46,1,5);
INSERT INTO sequence_source VALUES(684,'EF213607.1',84,41,1,5);
INSERT INTO sequence_source VALUES(685,'EF213608.1',84,36,1,5);
INSERT INTO sequence_source VALUES(686,'EF213609.1',84,46,1,5);
INSERT INTO sequence_source VALUES(687,'EF213610.1',84,46,1,5);
INSERT INTO sequence_source VALUES(688,'EF213611.1',84,46,1,5);
INSERT INTO sequence_source VALUES(689,'EF213612.1',84,53,1,5);
INSERT INTO sequence_source VALUES(690,'EF213613.1',84,20,1,5);
INSERT INTO sequence_source VALUES(691,'EF213614.1',84,46,1,5);
INSERT INTO sequence_source VALUES(692,'EF213615.1',84,46,1,5);
INSERT INTO sequence_source VALUES(693,'EF213616.1',84,66,1,5);
INSERT INTO sequence_source VALUES(694,'EF213617.1',84,46,1,5);
INSERT INTO sequence_source VALUES(695,'EF213618.1',84,46,1,5);
INSERT INTO sequence_source VALUES(696,'EF213621.1',84,311,1,5);
INSERT INTO sequence_source VALUES(697,'EF213622.1',84,321,1,5);
INSERT INTO sequence_source VALUES(698,'EF213623.1',84,322,1,5);
INSERT INTO sequence_source VALUES(699,'EF406101.1',84,224,1,61);
INSERT INTO sequence_source VALUES(700,'EF406102.1',84,224,1,61);
INSERT INTO sequence_source VALUES(701,'EF406103.1',84,224,1,61);
INSERT INTO sequence_source VALUES(702,'EF418938.1',84,46,1,5);
INSERT INTO sequence_source VALUES(703,'EF418939.1',84,46,1,5);
INSERT INTO sequence_source VALUES(704,'EF418940.1',84,41,1,5);
INSERT INTO sequence_source VALUES(705,'EF418941.1',84,46,1,5);
INSERT INTO sequence_source VALUES(706,'EF418942.1',84,46,1,5);
INSERT INTO sequence_source VALUES(707,'EF418944.1',84,323,1,5);
INSERT INTO sequence_source VALUES(708,'EF418945.1',84,311,1,5);
INSERT INTO sequence_source VALUES(709,'EF418946.1',84,311,1,5);
INSERT INTO sequence_source VALUES(710,'EF418949.1',84,311,1,5);
INSERT INTO sequence_source VALUES(711,'EF418950.1',84,311,1,5);
INSERT INTO sequence_source VALUES(712,'EF418951.1',84,324,1,5);
INSERT INTO sequence_source VALUES(713,'EF418952.1',84,46,1,5);
INSERT INTO sequence_source VALUES(714,'EF452178.1',84,325,1,5);
INSERT INTO sequence_source VALUES(715,'EF452179.1',84,326,1,5);
INSERT INTO sequence_source VALUES(716,'EF452180.1',84,326,1,5);
INSERT INTO sequence_source VALUES(717,'EF486691.1',84,67,1,5);
INSERT INTO sequence_source VALUES(718,'EF486692.1',84,67,1,5);
INSERT INTO sequence_source VALUES(719,'EF486693.1',84,67,1,5);
INSERT INTO sequence_source VALUES(720,'EF490382.1',84,26,1,5);
INSERT INTO sequence_source VALUES(721,'EF490383.1',84,311,1,5);
INSERT INTO sequence_source VALUES(722,'EF490682.1',84,327,1,5);
INSERT INTO sequence_source VALUES(723,'EF490683.1',84,327,1,5);
INSERT INTO sequence_source VALUES(724,'EF490684.1',84,327,1,5);
INSERT INTO sequence_source VALUES(725,'EF523386.1',84,327,1,5);
INSERT INTO sequence_source VALUES(726,'EF523387.1',84,327,1,5);
INSERT INTO sequence_source VALUES(727,'EF553487.2',84,328,1,32);
INSERT INTO sequence_source VALUES(728,'EF553488.1',84,329,1,39);
INSERT INTO sequence_source VALUES(729,'EF553489.1',84,329,1,39);
INSERT INTO sequence_source VALUES(730,'EF553490.1',84,330,1,34);
INSERT INTO sequence_source VALUES(731,'EF553491.1',84,331,1,34);
INSERT INTO sequence_source VALUES(732,'EF553492.1',84,331,1,34);
INSERT INTO sequence_source VALUES(733,'EF553493.1',84,331,1,34);
INSERT INTO sequence_source VALUES(734,'EF553494.1',84,332,1,49);
INSERT INTO sequence_source VALUES(735,'EF553495.1',84,5,1,3);
INSERT INTO sequence_source VALUES(736,'EF553496.1',84,333,1,3);
INSERT INTO sequence_source VALUES(737,'EF553497.1',84,334,1,3);
INSERT INTO sequence_source VALUES(738,'EF553498.1',84,335,1,3);
INSERT INTO sequence_source VALUES(739,'EF553499.1',84,336,1,3);
INSERT INTO sequence_source VALUES(740,'EF553500.1',84,337,1,3);
INSERT INTO sequence_source VALUES(741,'EF553501.1',84,338,1,3);
INSERT INTO sequence_source VALUES(742,'EF553502.1',84,336,1,3);
INSERT INTO sequence_source VALUES(743,'EF553503.1',84,339,1,3);
INSERT INTO sequence_source VALUES(744,'EF553504.1',84,340,1,3);
INSERT INTO sequence_source VALUES(745,'EF553505.1',84,341,1,3);
INSERT INTO sequence_source VALUES(746,'EF553506.1',84,342,1,4);
INSERT INTO sequence_source VALUES(747,'EF553507.1',84,343,1,4);
INSERT INTO sequence_source VALUES(748,'EF553508.1',84,343,1,4);
INSERT INTO sequence_source VALUES(749,'EF553509.1',84,344,1,4);
INSERT INTO sequence_source VALUES(750,'EF553510.1',84,345,1,4);
INSERT INTO sequence_source VALUES(751,'EF553511.1',84,346,1,4);
INSERT INTO sequence_source VALUES(752,'EF553512.1',84,347,1,4);
INSERT INTO sequence_source VALUES(753,'EF553513.1',84,347,1,4);
INSERT INTO sequence_source VALUES(754,'EF553514.1',84,347,1,4);
INSERT INTO sequence_source VALUES(755,'EF583438.1',84,348,1,62);
INSERT INTO sequence_source VALUES(756,'EF583445.1',84,349,1,6);
INSERT INTO sequence_source VALUES(757,'EU000062.1',84,53,1,5);
INSERT INTO sequence_source VALUES(758,'EU000064.1',84,46,1,5);
INSERT INTO sequence_source VALUES(759,'EU000066.1',84,46,1,5);
INSERT INTO sequence_source VALUES(760,'EU000068.1',84,36,1,5);
INSERT INTO sequence_source VALUES(761,'EU000069.1',84,46,1,5);
INSERT INTO sequence_source VALUES(762,'EU000070.1',84,46,1,5);
INSERT INTO sequence_source VALUES(763,'EU000071.1',84,41,1,5);
INSERT INTO sequence_source VALUES(764,'EU000072.1',84,350,1,5);
INSERT INTO sequence_source VALUES(765,'EU000073.1',84,351,1,5);
INSERT INTO sequence_source VALUES(766,'EU000074.1',84,352,1,5);
INSERT INTO sequence_source VALUES(767,'EU000080.1',84,353,1,5);
INSERT INTO sequence_source VALUES(768,'EU000081.1',84,282,1,5);
INSERT INTO sequence_source VALUES(769,'EU000082.1',84,354,1,5);
INSERT INTO sequence_source VALUES(770,'EU000083.1',84,176,1,5);
INSERT INTO sequence_source VALUES(771,'EU000085.1',84,53,1,5);
INSERT INTO sequence_source VALUES(772,'EU000086.1',84,53,1,5);
INSERT INTO sequence_source VALUES(773,'EU000087.1',84,355,1,5);
INSERT INTO sequence_source VALUES(774,'EU000088.1',84,356,1,5);
INSERT INTO sequence_source VALUES(775,'EU000091.1',84,357,1,5);
INSERT INTO sequence_source VALUES(776,'EU000093.1',84,46,1,5);
INSERT INTO sequence_source VALUES(777,'EU000095.1',84,46,1,5);
INSERT INTO sequence_source VALUES(778,'EU000097.1',84,311,1,5);
INSERT INTO sequence_source VALUES(779,'EU000098.1',84,64,1,5);
INSERT INTO sequence_source VALUES(780,'EU000099.1',84,358,1,5);
INSERT INTO sequence_source VALUES(781,'EU000100.1',84,282,1,5);
INSERT INTO sequence_source VALUES(782,'EU000101.1',84,66,1,5);
INSERT INTO sequence_source VALUES(783,'EU000104.1',84,46,1,5);
INSERT INTO sequence_source VALUES(784,'EU000106.1',84,359,1,5);
INSERT INTO sequence_source VALUES(785,'EU000107.1',84,20,1,5);
INSERT INTO sequence_source VALUES(786,'EU000109.1',84,53,1,5);
INSERT INTO sequence_source VALUES(787,'EU000110.1',84,20,1,5);
INSERT INTO sequence_source VALUES(788,'EU000111.1',84,20,1,5);
INSERT INTO sequence_source VALUES(789,'EU000112.1',84,46,1,5);
INSERT INTO sequence_source VALUES(790,'EU000113.1',84,36,1,5);
INSERT INTO sequence_source VALUES(791,'EU000114.1',84,311,1,5);
INSERT INTO sequence_source VALUES(792,'EU000115.1',84,53,1,5);
INSERT INTO sequence_source VALUES(793,'EU000116.1',84,53,1,5);
INSERT INTO sequence_source VALUES(794,'EU000117.1',84,66,1,5);
INSERT INTO sequence_source VALUES(795,'EU000118.1',84,311,1,5);
INSERT INTO sequence_source VALUES(796,'EU000119.1',84,311,1,5);
INSERT INTO sequence_source VALUES(797,'EU000120.1',84,41,1,5);
INSERT INTO sequence_source VALUES(798,'EU000122.1',84,41,1,5);
INSERT INTO sequence_source VALUES(799,'EU000123.1',84,41,1,5);
INSERT INTO sequence_source VALUES(800,'EU000124.1',84,360,1,5);
INSERT INTO sequence_source VALUES(801,'EU000125.1',84,322,1,5);
INSERT INTO sequence_source VALUES(802,'EU000128.1',84,311,1,5);
INSERT INTO sequence_source VALUES(803,'EU000129.1',84,311,1,5);
INSERT INTO sequence_source VALUES(804,'EU000130.1',84,361,1,5);
INSERT INTO sequence_source VALUES(805,'EU000131.1',84,361,1,5);
INSERT INTO sequence_source VALUES(806,'EU000132.1',84,20,1,5);
INSERT INTO sequence_source VALUES(807,'EU000133.1',84,362,1,5);
INSERT INTO sequence_source VALUES(808,'EU000134.1',84,53,1,5);
INSERT INTO sequence_source VALUES(809,'EU000135.1',84,311,1,5);
INSERT INTO sequence_source VALUES(810,'EU000136.1',84,311,1,5);
INSERT INTO sequence_source VALUES(811,'EU000137.1',84,53,1,5);
INSERT INTO sequence_source VALUES(812,'EU000138.1',84,363,1,5);
INSERT INTO sequence_source VALUES(813,'EU000139.1',84,269,1,5);
INSERT INTO sequence_source VALUES(814,'EU000141.1',84,311,1,5);
INSERT INTO sequence_source VALUES(815,'EU000142.1',84,311,1,5);
INSERT INTO sequence_source VALUES(816,'EU000146.1',84,311,1,5);
INSERT INTO sequence_source VALUES(817,'EU000148.1',84,53,1,5);
INSERT INTO sequence_source VALUES(818,'EU000149.1',84,20,1,5);
INSERT INTO sequence_source VALUES(819,'EU000150.1',84,53,1,5);
INSERT INTO sequence_source VALUES(820,'EU000152.1',84,351,1,5);
INSERT INTO sequence_source VALUES(821,'EU000153.1',84,53,1,5);
INSERT INTO sequence_source VALUES(822,'EU000155.1',84,311,1,5);
INSERT INTO sequence_source VALUES(823,'EU000159.1',84,311,1,5);
INSERT INTO sequence_source VALUES(824,'EU000160.1',84,13,1,5);
INSERT INTO sequence_source VALUES(825,'EU000161.1',84,53,1,5);
INSERT INTO sequence_source VALUES(826,'EU000162.1',84,364,1,5);
INSERT INTO sequence_source VALUES(827,'EU000163.1',84,311,1,5);
INSERT INTO sequence_source VALUES(828,'EU000164.1',84,311,1,5);
INSERT INTO sequence_source VALUES(829,'EU098125.1',84,53,1,5);
INSERT INTO sequence_source VALUES(830,'EU106582.1',84,46,1,5);
INSERT INTO sequence_source VALUES(831,'EU106583.1',84,46,1,5);
INSERT INTO sequence_source VALUES(832,'EU106584.1',84,365,1,5);
INSERT INTO sequence_source VALUES(833,'EU106585.1',84,311,1,5);
INSERT INTO sequence_source VALUES(834,'EU106586.1',84,46,1,5);
INSERT INTO sequence_source VALUES(835,'EU106587.1',84,53,1,5);
INSERT INTO sequence_source VALUES(836,'EU106588.1',84,46,1,5);
INSERT INTO sequence_source VALUES(837,'EU106589.1',84,46,1,5);
INSERT INTO sequence_source VALUES(838,'EU106590.1',84,366,1,5);
INSERT INTO sequence_source VALUES(839,'EU106592.1',84,311,1,5);
INSERT INTO sequence_source VALUES(840,'EU109566.1',84,46,1,5);
INSERT INTO sequence_source VALUES(841,'EU109567.1',84,46,1,5);
INSERT INTO sequence_source VALUES(842,'EU109568.1',84,46,1,5);
INSERT INTO sequence_source VALUES(843,'EU162760.1',84,367,1,62);
INSERT INTO sequence_source VALUES(844,'EU162765.1',84,368,1,5);
INSERT INTO sequence_source VALUES(845,'EU162767.1',84,369,1,62);
INSERT INTO sequence_source VALUES(846,'EU169130.1',84,141,1,62);
INSERT INTO sequence_source VALUES(847,'EU169133.1',84,370,1,5);
INSERT INTO sequence_source VALUES(848,'EU169134.1',84,371,1,62);
INSERT INTO sequence_source VALUES(849,'EU169136.1',84,372,1,5);
INSERT INTO sequence_source VALUES(850,'EU194378.1',84,373,1,5);
INSERT INTO sequence_source VALUES(851,'EU194379.1',84,20,1,5);
INSERT INTO sequence_source VALUES(852,'EU194380.1',84,318,1,5);
INSERT INTO sequence_source VALUES(853,'EU194381.1',84,53,1,5);
INSERT INTO sequence_source VALUES(854,'EU194382.1',84,46,1,5);
INSERT INTO sequence_source VALUES(855,'EU194383.1',84,53,1,5);
INSERT INTO sequence_source VALUES(856,'EU194384.1',84,316,1,5);
INSERT INTO sequence_source VALUES(857,'EU194385.1',84,53,1,5);
INSERT INTO sequence_source VALUES(858,'EU194388.1',84,374,1,5);
INSERT INTO sequence_source VALUES(859,'EU194389.1',84,24,1,5);
INSERT INTO sequence_source VALUES(860,'EU194390.1',84,53,1,5);
INSERT INTO sequence_source VALUES(861,'EU194392.1',84,46,1,5);
INSERT INTO sequence_source VALUES(862,'EU194393.1',84,375,1,5);
INSERT INTO sequence_source VALUES(863,'EU194394.1',84,41,1,5);
INSERT INTO sequence_source VALUES(864,'EU194395.1',84,46,1,5);
INSERT INTO sequence_source VALUES(865,'EU194396.1',84,311,1,5);
INSERT INTO sequence_source VALUES(866,'EU194397.1',84,311,1,5);
INSERT INTO sequence_source VALUES(867,'EU194398.1',84,376,1,5);
INSERT INTO sequence_source VALUES(868,'EU194399.1',84,377,1,5);
INSERT INTO sequence_source VALUES(869,'EU194400.1',84,377,1,5);
INSERT INTO sequence_source VALUES(870,'EU194401.1',84,46,1,5);
INSERT INTO sequence_source VALUES(871,'EU194402.1',84,322,1,5);
INSERT INTO sequence_source VALUES(872,'EU194403.1',84,46,1,5);
INSERT INTO sequence_source VALUES(873,'EU194404.1',84,46,1,5);
INSERT INTO sequence_source VALUES(874,'EU194406.1',84,46,1,5);
INSERT INTO sequence_source VALUES(875,'EU194407.1',84,46,1,5);
INSERT INTO sequence_source VALUES(876,'EU194408.1',84,378,1,5);
INSERT INTO sequence_source VALUES(877,'EU194409.1',84,311,1,5);
INSERT INTO sequence_source VALUES(878,'EU194410.1',84,379,1,5);
INSERT INTO sequence_source VALUES(879,'EU194411.1',84,363,1,5);
INSERT INTO sequence_source VALUES(880,'EU194412.1',84,20,1,5);
INSERT INTO sequence_source VALUES(881,'EU194413.1',84,311,1,5);
INSERT INTO sequence_source VALUES(882,'EU194414.1',84,46,1,5);
INSERT INTO sequence_source VALUES(883,'EU194415.1',84,380,1,5);
INSERT INTO sequence_source VALUES(884,'EU194417.1',84,20,1,5);
INSERT INTO sequence_source VALUES(885,'EU194418.1',84,311,1,5);
INSERT INTO sequence_source VALUES(886,'EU194419.1',84,41,1,5);
INSERT INTO sequence_source VALUES(887,'EU194420.1',84,46,1,5);
INSERT INTO sequence_source VALUES(888,'EU194421.1',84,46,1,5);
INSERT INTO sequence_source VALUES(889,'EU194422.1',84,46,1,5);
INSERT INTO sequence_source VALUES(890,'EU194423.1',84,311,1,5);
INSERT INTO sequence_source VALUES(891,'EU194425.1',84,176,1,5);
INSERT INTO sequence_source VALUES(892,'EU194428.1',84,381,1,5);
INSERT INTO sequence_source VALUES(893,'EU194429.1',84,382,1,5);
INSERT INTO sequence_source VALUES(894,'EU194438.1',84,60,1,5);
INSERT INTO sequence_source VALUES(895,'EU194439.1',84,66,1,5);
INSERT INTO sequence_source VALUES(896,'EU194440.1',84,66,1,5);
INSERT INTO sequence_source VALUES(897,'EU200238.1',84,11,1,5);
INSERT INTO sequence_source VALUES(898,'EU200239.1',84,383,1,5);
INSERT INTO sequence_source VALUES(899,'EU200240.1',84,384,1,5);
INSERT INTO sequence_source VALUES(900,'EU200241.1',84,11,1,5);
INSERT INTO sequence_source VALUES(901,'EU200242.1',84,385,1,5);
INSERT INTO sequence_source VALUES(902,'EU200244.1',84,386,1,5);
INSERT INTO sequence_source VALUES(903,'EU200245.1',84,387,1,5);
INSERT INTO sequence_source VALUES(904,'EU200246.1',84,11,1,5);
INSERT INTO sequence_source VALUES(905,'EU200247.1',84,11,1,5);
INSERT INTO sequence_source VALUES(906,'EU200248.1',84,383,1,5);
INSERT INTO sequence_source VALUES(907,'EU200249.1',84,388,1,5);
INSERT INTO sequence_source VALUES(908,'EU200250.1',84,389,1,5);
INSERT INTO sequence_source VALUES(909,'EU200251.1',84,390,1,5);
INSERT INTO sequence_source VALUES(910,'EU200252.1',84,386,1,5);
INSERT INTO sequence_source VALUES(911,'EU200253.1',84,391,1,5);
INSERT INTO sequence_source VALUES(912,'EU200257.1',84,392,1,5);
INSERT INTO sequence_source VALUES(913,'EU200261.1',84,392,1,5);
INSERT INTO sequence_source VALUES(914,'EU200262.1',84,392,1,5);
INSERT INTO sequence_source VALUES(915,'EU200264.1',84,11,1,5);
INSERT INTO sequence_source VALUES(916,'EU200268.1',84,386,1,5);
INSERT INTO sequence_source VALUES(917,'EU200269.1',84,11,1,5);
INSERT INTO sequence_source VALUES(918,'EU200270.1',84,393,1,5);
INSERT INTO sequence_source VALUES(919,'EU200272.1',84,392,1,5);
INSERT INTO sequence_source VALUES(920,'EU200274.1',84,394,1,5);
INSERT INTO sequence_source VALUES(921,'EU200276.1',84,390,1,5);
INSERT INTO sequence_source VALUES(922,'EU200278.1',84,383,1,5);
INSERT INTO sequence_source VALUES(923,'EU200280.1',84,386,1,5);
INSERT INTO sequence_source VALUES(924,'EU200282.1',84,395,1,5);
INSERT INTO sequence_source VALUES(925,'EU200284.1',84,396,1,5);
INSERT INTO sequence_source VALUES(926,'EU200288.1',84,389,1,5);
INSERT INTO sequence_source VALUES(927,'EU200289.1',84,397,1,5);
INSERT INTO sequence_source VALUES(928,'EU200292.1',84,11,1,5);
INSERT INTO sequence_source VALUES(929,'EU200293.1',84,394,1,5);
INSERT INTO sequence_source VALUES(930,'EU200294.1',84,398,1,5);
INSERT INTO sequence_source VALUES(931,'EU200296.1',84,11,1,5);
INSERT INTO sequence_source VALUES(932,'EU200301.1',84,383,1,5);
INSERT INTO sequence_source VALUES(933,'EU200302.1',84,394,1,5);
INSERT INTO sequence_source VALUES(934,'EU200304.1',84,386,1,5);
INSERT INTO sequence_source VALUES(935,'EU200307.1',84,383,1,5);
INSERT INTO sequence_source VALUES(936,'EU200310.1',84,386,1,5);
INSERT INTO sequence_source VALUES(937,'EU200316.1',84,399,1,5);
INSERT INTO sequence_source VALUES(938,'EU200317.1',84,386,1,5);
INSERT INTO sequence_source VALUES(939,'EU200318.1',84,399,1,5);
INSERT INTO sequence_source VALUES(940,'EU200320.1',84,400,1,5);
INSERT INTO sequence_source VALUES(941,'EU216567.1',84,386,1,5);
INSERT INTO sequence_source VALUES(942,'EU216568.1',84,11,1,5);
INSERT INTO sequence_source VALUES(943,'EU216569.1',84,392,1,5);
INSERT INTO sequence_source VALUES(944,'EU216570.1',84,392,1,5);
INSERT INTO sequence_source VALUES(945,'EU240049.1',84,224,1,61);
INSERT INTO sequence_source VALUES(946,'EU240052.1',84,311,1,5);
INSERT INTO sequence_source VALUES(947,'EU240059.1',84,311,1,5);
INSERT INTO sequence_source VALUES(948,'EU240138.1',84,313,1,5);
INSERT INTO sequence_source VALUES(949,'EU240177.1',84,313,1,5);
INSERT INTO sequence_source VALUES(950,'EU240188.1',84,311,1,5);
INSERT INTO sequence_source VALUES(951,'EU240189.1',84,311,1,5);
INSERT INTO sequence_source VALUES(952,'EU240193.1',84,311,1,5);
INSERT INTO sequence_source VALUES(953,'EU240194.1',84,311,1,5);
INSERT INTO sequence_source VALUES(954,'EU244850.1',84,401,1,5);
INSERT INTO sequence_source VALUES(955,'EU244851.1',84,66,1,5);
INSERT INTO sequence_source VALUES(956,'EU244852.1',84,380,1,5);
INSERT INTO sequence_source VALUES(957,'EU253560.1',84,402,1,62);
INSERT INTO sequence_source VALUES(958,'EU257523.1',84,11,1,5);
INSERT INTO sequence_source VALUES(959,'EU263905.1',84,311,1,5);
INSERT INTO sequence_source VALUES(960,'EU263906.1',84,282,1,5);
INSERT INTO sequence_source VALUES(961,'EU295529.1',84,267,1,9);
INSERT INTO sequence_source VALUES(962,'EU334634.2',84,403,1,5);
INSERT INTO sequence_source VALUES(963,'EU391654.1',84,404,1,9);
INSERT INTO sequence_source VALUES(964,'EU419613.1',84,405,1,5);
INSERT INTO sequence_source VALUES(965,'EU515167.1',84,406,1,5);
INSERT INTO sequence_source VALUES(966,'EU515171.1',84,407,1,5);
INSERT INTO sequence_source VALUES(967,'EU515173.1',84,60,1,5);
INSERT INTO sequence_source VALUES(968,'EU515174.1',84,408,1,5);
INSERT INTO sequence_source VALUES(969,'EU644715.1',84,409,1,5);
INSERT INTO sequence_source VALUES(970,'EU644720.1',84,410,1,5);
INSERT INTO sequence_source VALUES(971,'EU644721.1',84,411,1,5);
INSERT INTO sequence_source VALUES(972,'EU660054.1',84,188,1,30);
INSERT INTO sequence_source VALUES(973,'EU662221.1',84,412,1,5);
INSERT INTO sequence_source VALUES(974,'EU877748.1',84,316,1,5);
INSERT INTO sequence_source VALUES(975,'EU915283.1',84,413,1,5);
INSERT INTO sequence_source VALUES(976,'EU925375.1',84,277,1,5);
INSERT INTO sequence_source VALUES(977,'EU925376.1',84,414,1,5);
INSERT INTO sequence_source VALUES(978,'FJ215687.1',84,415,1,5);
INSERT INTO sequence_source VALUES(979,'FJ361036.1',84,13,1,5);
INSERT INTO sequence_source VALUES(980,'FJ361037.1',84,13,1,5);
INSERT INTO sequence_source VALUES(981,'FJ384778.1',84,416,1,9);
INSERT INTO sequence_source VALUES(982,'FJ595479.1',84,417,1,5);
INSERT INTO sequence_source VALUES(983,'FJ842111.1',84,418,1,5);
INSERT INTO sequence_source VALUES(984,'FJ849839.1',84,419,1,5);
INSERT INTO sequence_source VALUES(985,'FJ873179.1',84,420,1,62);
INSERT INTO sequence_source VALUES(986,'FN257934.1',84,421,1,5);
INSERT INTO sequence_source VALUES(987,'FN257935.1',84,406,1,5);
INSERT INTO sequence_source VALUES(988,'FN257936.1',84,421,1,5);
INSERT INTO sequence_source VALUES(989,'FN257937.1',84,421,1,5);
INSERT INTO sequence_source VALUES(990,'FN257938.1',84,421,1,5);
INSERT INTO sequence_source VALUES(991,'FN257939.1',84,422,1,5);
INSERT INTO sequence_source VALUES(992,'FN257940.1',84,421,1,5);
INSERT INTO sequence_source VALUES(993,'FN547052.1',84,311,1,5);
INSERT INTO sequence_source VALUES(994,'FN547055.1',84,311,1,5);
INSERT INTO sequence_source VALUES(995,'GQ131800.1',84,60,1,5);
INSERT INTO sequence_source VALUES(997,'GQ165531.1',84,424,1,6);
INSERT INTO sequence_source VALUES(998,'GQ398157.1',84,425,1,5);
INSERT INTO sequence_source VALUES(999,'GQ421459.1',84,426,1,9);
INSERT INTO sequence_source VALUES(1000,'GQ848201.1',84,427,1,5);
INSERT INTO sequence_source VALUES(1001,'GQ853880.1',84,277,1,5);
INSERT INTO sequence_source VALUES(1002,'GQ924478.1',84,60,1,5);
INSERT INTO sequence_source VALUES(1003,'GQ980052.1',84,428,1,6);
INSERT INTO sequence_source VALUES(1004,'GU011684.1',84,29,1,5);
INSERT INTO sequence_source VALUES(1005,'GU073387.1',84,429,1,5);
INSERT INTO sequence_source VALUES(1006,'GU073388.1',84,430,1,5);
INSERT INTO sequence_source VALUES(1007,'GU073389.1',84,431,1,5);
INSERT INTO sequence_source VALUES(1008,'GU073392.1',84,432,1,5);
INSERT INTO sequence_source VALUES(1009,'GU111584.1',84,433,1,5);
INSERT INTO sequence_source VALUES(1010,'GU111585.1',84,433,1,5);
INSERT INTO sequence_source VALUES(1011,'GU111586.1',84,60,1,5);
INSERT INTO sequence_source VALUES(1012,'GU111587.1',84,46,1,5);
INSERT INTO sequence_source VALUES(1013,'GU111588.1',84,316,1,5);
INSERT INTO sequence_source VALUES(1014,'GU111590.1',84,13,1,5);
INSERT INTO sequence_source VALUES(1015,'GU111591.1',84,13,1,5);
INSERT INTO sequence_source VALUES(1016,'GU111592.1',84,434,1,5);
INSERT INTO sequence_source VALUES(1017,'GU111593.1',84,13,1,5);
INSERT INTO sequence_source VALUES(1018,'GU111594.1',84,13,1,5);
INSERT INTO sequence_source VALUES(1019,'GU111595.1',84,13,1,5);
INSERT INTO sequence_source VALUES(1020,'GU111596.1',84,282,1,5);
INSERT INTO sequence_source VALUES(1021,'GU111598.1',84,435,1,5);
INSERT INTO sequence_source VALUES(1022,'GU111599.1',84,281,1,5);
INSERT INTO sequence_source VALUES(1023,'GU111600.1',84,436,1,5);
INSERT INTO sequence_source VALUES(1024,'GU111601.1',84,436,1,5);
INSERT INTO sequence_source VALUES(1025,'GU111602.1',84,436,1,5);
INSERT INTO sequence_source VALUES(1026,'GU111603.1',84,437,1,5);
INSERT INTO sequence_source VALUES(1027,'GU111604.1',84,438,1,5);
INSERT INTO sequence_source VALUES(1028,'GU111605.1',84,439,1,5);
INSERT INTO sequence_source VALUES(1029,'GU111606.1',84,440,1,5);
INSERT INTO sequence_source VALUES(1030,'GU111607.1',84,440,1,5);
INSERT INTO sequence_source VALUES(1031,'GU111608.1',84,441,1,5);
INSERT INTO sequence_source VALUES(1032,'GU111609.1',84,441,1,5);
INSERT INTO sequence_source VALUES(1033,'GU111610.1',84,442,1,5);
INSERT INTO sequence_source VALUES(1034,'GU111611.1',84,443,1,5);
INSERT INTO sequence_source VALUES(1035,'GU111612.1',84,444,1,5);
INSERT INTO sequence_source VALUES(1036,'GU111613.1',84,445,1,5);
INSERT INTO sequence_source VALUES(1037,'GU111614.1',84,445,1,5);
INSERT INTO sequence_source VALUES(1038,'GU111615.1',84,445,1,5);
INSERT INTO sequence_source VALUES(1039,'GU111616.1',84,446,1,5);
INSERT INTO sequence_source VALUES(1040,'GU111617.1',84,401,1,5);
INSERT INTO sequence_source VALUES(1041,'GU111618.1',84,446,1,5);
INSERT INTO sequence_source VALUES(1042,'GU111619.1',84,177,1,5);
INSERT INTO sequence_source VALUES(1043,'GU111620.1',84,177,1,5);
INSERT INTO sequence_source VALUES(1044,'GU111621.1',84,177,1,5);
INSERT INTO sequence_source VALUES(1045,'GU111622.1',84,177,1,5);
INSERT INTO sequence_source VALUES(1046,'GU111623.1',84,177,1,5);
INSERT INTO sequence_source VALUES(1047,'GU111624.1',84,447,1,5);
INSERT INTO sequence_source VALUES(1048,'GU111625.1',84,448,1,5);
INSERT INTO sequence_source VALUES(1049,'GU111626.1',84,449,1,5);
INSERT INTO sequence_source VALUES(1050,'GU111627.1',84,381,1,5);
INSERT INTO sequence_source VALUES(1051,'GU111628.1',84,381,1,5);
INSERT INTO sequence_source VALUES(1052,'GU111629.1',84,381,1,5);
INSERT INTO sequence_source VALUES(1053,'GU111630.1',84,381,1,5);
INSERT INTO sequence_source VALUES(1054,'GU111631.1',84,450,1,5);
INSERT INTO sequence_source VALUES(1055,'GU111632.1',84,381,1,5);
INSERT INTO sequence_source VALUES(1056,'GU111633.1',84,381,1,5);
INSERT INTO sequence_source VALUES(1057,'GU111634.1',84,29,1,5);
INSERT INTO sequence_source VALUES(1058,'GU111635.1',84,29,1,5);
INSERT INTO sequence_source VALUES(1059,'GU111636.1',84,29,1,5);
INSERT INTO sequence_source VALUES(1060,'GU111637.1',84,451,1,5);
INSERT INTO sequence_source VALUES(1061,'GU111638.1',84,29,1,5);
INSERT INTO sequence_source VALUES(1062,'GU111639.1',84,29,1,5);
INSERT INTO sequence_source VALUES(1063,'GU111640.1',84,29,1,5);
INSERT INTO sequence_source VALUES(1064,'GU111641.1',84,29,1,5);
INSERT INTO sequence_source VALUES(1065,'GU111642.1',84,452,1,5);
INSERT INTO sequence_source VALUES(1066,'GU111643.1',84,29,1,5);
INSERT INTO sequence_source VALUES(1067,'GU111644.1',84,453,1,5);
INSERT INTO sequence_source VALUES(1068,'GU111645.1',84,421,1,5);
INSERT INTO sequence_source VALUES(1069,'GU111646.1',84,60,1,5);
INSERT INTO sequence_source VALUES(1070,'GU111647.1',84,454,1,5);
INSERT INTO sequence_source VALUES(1071,'GU111648.1',84,60,1,5);
INSERT INTO sequence_source VALUES(1072,'GU111649.1',84,60,1,5);
INSERT INTO sequence_source VALUES(1073,'GU111650.1',84,60,1,5);
INSERT INTO sequence_source VALUES(1074,'GU111651.1',84,60,1,5);
INSERT INTO sequence_source VALUES(1075,'GU111652.1',84,60,1,5);
INSERT INTO sequence_source VALUES(1076,'GU111653.1',84,60,1,5);
INSERT INTO sequence_source VALUES(1077,'GU111654.1',84,455,1,5);
INSERT INTO sequence_source VALUES(1078,'GU111655.1',84,60,1,5);
INSERT INTO sequence_source VALUES(1079,'GU111656.1',84,60,1,5);
INSERT INTO sequence_source VALUES(1080,'GU111657.1',84,60,1,5);
INSERT INTO sequence_source VALUES(1081,'GU111658.1',84,60,1,5);
INSERT INTO sequence_source VALUES(1082,'GU111659.1',84,60,1,5);
INSERT INTO sequence_source VALUES(1083,'GU111660.1',84,60,1,5);
INSERT INTO sequence_source VALUES(1084,'GU111661.1',84,60,1,5);
INSERT INTO sequence_source VALUES(1085,'GU111662.1',84,60,1,5);
INSERT INTO sequence_source VALUES(1086,'GU111663.1',84,60,1,5);
INSERT INTO sequence_source VALUES(1087,'GU111664.1',84,60,1,5);
INSERT INTO sequence_source VALUES(1088,'GU111665.1',84,456,1,5);
INSERT INTO sequence_source VALUES(1089,'GU111666.1',84,25,1,5);
INSERT INTO sequence_source VALUES(1090,'GU111667.1',84,25,1,5);
INSERT INTO sequence_source VALUES(1091,'GU111668.1',84,25,1,5);
INSERT INTO sequence_source VALUES(1092,'GU111670.1',84,457,1,5);
INSERT INTO sequence_source VALUES(1093,'GU111671.1',84,25,1,5);
INSERT INTO sequence_source VALUES(1094,'GU111672.1',84,25,1,5);
INSERT INTO sequence_source VALUES(1095,'GU111673.1',84,25,1,5);
INSERT INTO sequence_source VALUES(1096,'GU111674.1',84,25,1,5);
INSERT INTO sequence_source VALUES(1097,'GU111675.1',84,25,1,5);
INSERT INTO sequence_source VALUES(1098,'GU111677.1',84,25,1,5);
INSERT INTO sequence_source VALUES(1099,'GU111678.1',84,25,1,5);
INSERT INTO sequence_source VALUES(1100,'GU111679.1',84,25,1,5);
INSERT INTO sequence_source VALUES(1101,'GU111680.1',84,25,1,5);
INSERT INTO sequence_source VALUES(1102,'GU111681.1',84,25,1,5);
INSERT INTO sequence_source VALUES(1103,'GU111682.1',84,25,1,5);
INSERT INTO sequence_source VALUES(1104,'GU111683.1',84,60,1,5);
INSERT INTO sequence_source VALUES(1105,'GU133065.1',84,37,1,5);
INSERT INTO sequence_source VALUES(1106,'GU133066.1',84,458,1,5);
INSERT INTO sequence_source VALUES(1107,'GU133067.1',84,459,1,5);
INSERT INTO sequence_source VALUES(1108,'GU133068.1',84,39,1,5);
INSERT INTO sequence_source VALUES(1109,'GU223372.1',84,460,1,5);
INSERT INTO sequence_source VALUES(1110,'GU233297.1',84,141,1,62);
INSERT INTO sequence_source VALUES(1111,'GU233300.1',84,461,1,62);
INSERT INTO sequence_source VALUES(1112,'GU564664.1',84,462,1,5);
INSERT INTO sequence_source VALUES(1113,'GU564665.1',84,177,1,5);
INSERT INTO sequence_source VALUES(1114,'GU564666.1',84,463,1,5);
INSERT INTO sequence_source VALUES(1115,'GU564667.1',84,177,1,5);
INSERT INTO sequence_source VALUES(1116,'GU583835.1',84,464,1,35);
INSERT INTO sequence_source VALUES(1117,'GU583836.1',84,464,1,35);
INSERT INTO sequence_source VALUES(1118,'GU583837.1',84,465,1,35);
INSERT INTO sequence_source VALUES(1119,'GU583838.1',84,466,1,35);
INSERT INTO sequence_source VALUES(1120,'GU583839.1',84,466,1,35);
INSERT INTO sequence_source VALUES(1121,'GU799635.1',84,13,1,5);
INSERT INTO sequence_source VALUES(1122,'GU799636.1',84,13,1,5);
INSERT INTO sequence_source VALUES(1123,'GU799637.1',84,13,1,5);
INSERT INTO sequence_source VALUES(1124,'GU799638.1',84,13,1,5);
INSERT INTO sequence_source VALUES(1125,'GU799639.1',84,467,1,5);
INSERT INTO sequence_source VALUES(1126,'GU799640.1',84,467,1,5);
INSERT INTO sequence_source VALUES(1127,'GU799641.1',84,468,1,5);
INSERT INTO sequence_source VALUES(1128,'GU799642.1',84,467,1,5);
INSERT INTO sequence_source VALUES(1129,'GU799643.1',84,469,1,5);
INSERT INTO sequence_source VALUES(1130,'GU799644.1',84,470,1,5);
INSERT INTO sequence_source VALUES(1131,'GU799645.1',84,471,1,5);
INSERT INTO sequence_source VALUES(1132,'GU799646.1',84,471,1,5);
INSERT INTO sequence_source VALUES(1133,'GU799647.1',84,472,1,5);
INSERT INTO sequence_source VALUES(1134,'GU799648.1',84,473,1,5);
INSERT INTO sequence_source VALUES(1135,'GU799649.1',84,474,1,5);
INSERT INTO sequence_source VALUES(1136,'GU931701.1',84,475,1,55);
INSERT INTO sequence_source VALUES(1137,'GU931702.1',84,25,1,5);
INSERT INTO sequence_source VALUES(1138,'GU992938.1',84,476,1,5);
INSERT INTO sequence_source VALUES(1139,'HE580280.1',84,477,1,5);
INSERT INTO sequence_source VALUES(1140,'HG007960.1',84,25,1,5);
INSERT INTO sequence_source VALUES(1141,'HM004217.1',84,478,1,5);
INSERT INTO sequence_source VALUES(1142,'HM004218.1',84,479,1,25);
INSERT INTO sequence_source VALUES(1143,'HM004219.1',84,313,1,5);
INSERT INTO sequence_source VALUES(1144,'HM004220.1',84,67,1,5);
INSERT INTO sequence_source VALUES(1145,'HM004221.1',84,480,1,5);
INSERT INTO sequence_source VALUES(1146,'HM004222.1',84,481,1,5);
INSERT INTO sequence_source VALUES(1147,'HM004223.1',84,482,1,5);
INSERT INTO sequence_source VALUES(1148,'HM004224.1',84,483,1,5);
INSERT INTO sequence_source VALUES(1149,'HM004225.1',84,484,1,5);
INSERT INTO sequence_source VALUES(1150,'HM004226.1',84,485,1,5);
INSERT INTO sequence_source VALUES(1151,'HM004227.1',84,322,1,5);
INSERT INTO sequence_source VALUES(1152,'HM004228.1',84,26,1,5);
INSERT INTO sequence_source VALUES(1153,'HM004229.1',84,66,1,5);
INSERT INTO sequence_source VALUES(1154,'HM004230.1',84,351,1,5);
INSERT INTO sequence_source VALUES(1155,'HM004231.1',84,20,1,5);
INSERT INTO sequence_source VALUES(1156,'HM004232.1',84,486,1,5);
INSERT INTO sequence_source VALUES(1157,'HM004233.1',84,46,1,5);
INSERT INTO sequence_source VALUES(1158,'HM004234.1',84,310,1,5);
INSERT INTO sequence_source VALUES(1159,'HM004511.1',84,487,1,41);
INSERT INTO sequence_source VALUES(1160,'HM004512.1',84,488,1,4);
INSERT INTO sequence_source VALUES(1161,'HM004513.1',84,343,1,4);
INSERT INTO sequence_source VALUES(1162,'HM134862.1',84,489,1,62);
INSERT INTO sequence_source VALUES(1163,'HM357616.1',84,490,1,5);
INSERT INTO sequence_source VALUES(1164,'HM357617.1',84,490,1,5);
INSERT INTO sequence_source VALUES(1165,'HM357618.1',84,490,1,5);
INSERT INTO sequence_source VALUES(1166,'HM357619.1',84,490,1,5);
INSERT INTO sequence_source VALUES(1167,'HM357620.1',84,491,1,5);
INSERT INTO sequence_source VALUES(1168,'HM357621.1',84,492,1,5);
INSERT INTO sequence_source VALUES(1169,'HM357622.1',84,493,1,5);
INSERT INTO sequence_source VALUES(1170,'HM357623.1',84,494,1,5);
INSERT INTO sequence_source VALUES(1171,'HM357624.1',84,495,1,5);
INSERT INTO sequence_source VALUES(1172,'HM357625.1',84,495,1,5);
INSERT INTO sequence_source VALUES(1173,'HM585360.1',84,496,1,5);
INSERT INTO sequence_source VALUES(1174,'HM585361.1',84,496,1,5);
INSERT INTO sequence_source VALUES(1175,'HM585362.1',84,496,1,5);
INSERT INTO sequence_source VALUES(1176,'HM585363.1',84,496,1,5);
INSERT INTO sequence_source VALUES(1177,'HM585364.1',84,496,1,5);
INSERT INTO sequence_source VALUES(1178,'HM585365.1',84,496,1,5);
INSERT INTO sequence_source VALUES(1179,'HM585366.1',84,496,1,5);
INSERT INTO sequence_source VALUES(1180,'HM585367.1',84,496,1,5);
INSERT INTO sequence_source VALUES(1181,'HM627524.1',84,497,1,5);
INSERT INTO sequence_source VALUES(1182,'HQ191483.1',84,11,1,5);
INSERT INTO sequence_source VALUES(1183,'HQ191485.1',84,498,1,5);
INSERT INTO sequence_source VALUES(1184,'HQ191487.1',84,499,1,5);
INSERT INTO sequence_source VALUES(1185,'HQ191488.1',84,11,1,5);
INSERT INTO sequence_source VALUES(1186,'HQ191489.1',84,11,1,5);
INSERT INTO sequence_source VALUES(1187,'HQ237477.1',84,477,1,5);
INSERT INTO sequence_source VALUES(1188,'HQ237478.1',84,477,1,5);
INSERT INTO sequence_source VALUES(1189,'HQ237479.1',84,500,1,5);
INSERT INTO sequence_source VALUES(1190,'HQ237480.1',84,477,1,5);
INSERT INTO sequence_source VALUES(1191,'HQ237481.1',84,477,1,5);
INSERT INTO sequence_source VALUES(1192,'HQ237482.1',84,501,1,6);
INSERT INTO sequence_source VALUES(1194,'HQ237484.1',84,503,1,55);
INSERT INTO sequence_source VALUES(1195,'HQ237485.1',84,504,1,55);
INSERT INTO sequence_source VALUES(1196,'HQ237486.1',84,505,1,62);
INSERT INTO sequence_source VALUES(1197,'HQ446241.1',84,176,1,5);
INSERT INTO sequence_source VALUES(1198,'HQ446242.1',84,506,1,5);
INSERT INTO sequence_source VALUES(1199,'HQ446243.1',84,507,1,5);
INSERT INTO sequence_source VALUES(1200,'HQ446244.1',84,176,1,5);
INSERT INTO sequence_source VALUES(1201,'HQ446245.1',84,508,1,5);
INSERT INTO sequence_source VALUES(1202,'HQ446246.1',84,507,1,5);
INSERT INTO sequence_source VALUES(1203,'HQ636491.1',84,188,1,30);
INSERT INTO sequence_source VALUES(1204,'HQ636492.1',84,188,1,30);
INSERT INTO sequence_source VALUES(1205,'HQ636493.1',84,188,1,30);
INSERT INTO sequence_source VALUES(1206,'HQ636494.1',84,509,1,30);
INSERT INTO sequence_source VALUES(1207,'HQ636495.1',84,188,1,30);
INSERT INTO sequence_source VALUES(1208,'HQ636496.1',84,188,1,30);
INSERT INTO sequence_source VALUES(1209,'HQ636497.1',84,188,1,30);
INSERT INTO sequence_source VALUES(1210,'HQ636498.1',84,510,1,30);
INSERT INTO sequence_source VALUES(1211,'HQ636499.1',84,511,1,30);
INSERT INTO sequence_source VALUES(1212,'HQ636500.1',84,512,1,30);
INSERT INTO sequence_source VALUES(1213,'HQ636501.1',84,188,1,30);
INSERT INTO sequence_source VALUES(1214,'HQ636502.1',84,513,1,30);
INSERT INTO sequence_source VALUES(1215,'HQ636503.1',84,513,1,30);
INSERT INTO sequence_source VALUES(1216,'HQ636504.1',84,514,1,30);
INSERT INTO sequence_source VALUES(1217,'HQ636505.1',84,188,1,30);
INSERT INTO sequence_source VALUES(1218,'HQ636506.1',84,188,1,30);
INSERT INTO sequence_source VALUES(1219,'HQ636507.1',84,188,1,30);
INSERT INTO sequence_source VALUES(1220,'HQ636508.1',84,515,1,30);
INSERT INTO sequence_source VALUES(1221,'HQ636509.1',84,516,1,30);
INSERT INTO sequence_source VALUES(1222,'HQ643373.2',84,517,1,55);
INSERT INTO sequence_source VALUES(1223,'HQ643386.2',84,518,1,55);
INSERT INTO sequence_source VALUES(1224,'HQ643388.2',84,247,1,55);
INSERT INTO sequence_source VALUES(1225,'HQ643389.2',84,519,1,55);
INSERT INTO sequence_source VALUES(1226,'HQ643396.2',84,520,1,55);
INSERT INTO sequence_source VALUES(1227,'HQ643400.2',84,475,1,55);
INSERT INTO sequence_source VALUES(1228,'HQ643408.2',84,521,1,62);
INSERT INTO sequence_source VALUES(1229,'HQ643443.2',84,522,1,6);
INSERT INTO sequence_source VALUES(1230,'HQ643476.2',84,523,1,62);
INSERT INTO sequence_source VALUES(1231,'HQ643515.2',84,524,1,62);
INSERT INTO sequence_source VALUES(1232,'HQ643518.2',84,525,1,62);
INSERT INTO sequence_source VALUES(1233,'HQ643543.2',84,526,1,62);
INSERT INTO sequence_source VALUES(1234,'HQ643681.2',84,527,1,62);
INSERT INTO sequence_source VALUES(1235,'HQ643721.2',84,228,1,62);
INSERT INTO sequence_source VALUES(1236,'HQ643761.2',84,528,1,62);
INSERT INTO sequence_source VALUES(1237,'HQ643772.2',84,529,1,62);
INSERT INTO sequence_source VALUES(1238,'HQ643773.2',84,530,1,61);
INSERT INTO sequence_source VALUES(1239,'HQ643778.2',84,531,1,6);
INSERT INTO sequence_source VALUES(1240,'HQ643854.2',84,532,1,62);
INSERT INTO sequence_source VALUES(1241,'HQ659668.1',84,60,1,5);
INSERT INTO sequence_source VALUES(1242,'HQ681250.1',84,533,1,5);
INSERT INTO sequence_source VALUES(1243,'HQ681251.1',84,534,1,5);
INSERT INTO sequence_source VALUES(1244,'HQ730979.1',84,312,1,9);
INSERT INTO sequence_source VALUES(1245,'HQ853456.1',84,535,1,55);
INSERT INTO sequence_source VALUES(1246,'HQ853457.1',84,536,1,55);
INSERT INTO sequence_source VALUES(1247,'HQ853458.1',84,535,1,55);
INSERT INTO sequence_source VALUES(1248,'HQ853459.1',84,535,1,55);
INSERT INTO sequence_source VALUES(1249,'HQ853461.1',84,537,1,55);
INSERT INTO sequence_source VALUES(1250,'HQ853462.1',84,537,1,55);
INSERT INTO sequence_source VALUES(1251,'HQ853463.1',84,536,1,55);
INSERT INTO sequence_source VALUES(1252,'HQ875382.1',84,51,1,5);
INSERT INTO sequence_source VALUES(1253,'HQ875383.1',84,51,1,5);
INSERT INTO sequence_source VALUES(1254,'HQ875384.1',84,51,1,5);
INSERT INTO sequence_source VALUES(1255,'HQ875386.1',84,538,1,5);
INSERT INTO sequence_source VALUES(1256,'HQ875387.1',84,51,1,5);
INSERT INTO sequence_source VALUES(1257,'HQ875388.1',84,51,1,5);
INSERT INTO sequence_source VALUES(1258,'HQ875389.1',84,51,1,5);
INSERT INTO sequence_source VALUES(1259,'HQ875390.1',84,51,1,5);
INSERT INTO sequence_source VALUES(1260,'JF792536.1',84,539,1,5);
INSERT INTO sequence_source VALUES(1261,'JF792538.1',84,540,1,5);
INSERT INTO sequence_source VALUES(1262,'JF792539.1',84,541,1,5);
INSERT INTO sequence_source VALUES(1263,'JF792540.1',84,25,1,5);
INSERT INTO sequence_source VALUES(1264,'JF792541.1',84,25,1,5);
INSERT INTO sequence_source VALUES(1265,'JF833941.1',84,13,1,5);
INSERT INTO sequence_source VALUES(1266,'JF833942.1',84,13,1,5);
INSERT INTO sequence_source VALUES(1267,'JF833943.1',84,13,1,5);
INSERT INTO sequence_source VALUES(1268,'JF833944.1',84,13,1,5);
INSERT INTO sequence_source VALUES(1269,'JF833945.1',84,13,1,5);
INSERT INTO sequence_source VALUES(1270,'JF833946.1',84,13,1,5);
INSERT INTO sequence_source VALUES(1271,'JF833947.1',84,13,1,5);
INSERT INTO sequence_source VALUES(1272,'JF833948.1',84,13,1,5);
INSERT INTO sequence_source VALUES(1273,'JF833949.1',84,13,1,5);
INSERT INTO sequence_source VALUES(1274,'JF833954.1',84,67,1,5);
INSERT INTO sequence_source VALUES(1276,'JF975613.1',84,542,1,35);
INSERT INTO sequence_source VALUES(1277,'JF975614.1',84,543,1,35);
INSERT INTO sequence_source VALUES(1278,'JN120097.1',84,544,1,5);
INSERT INTO sequence_source VALUES(1279,'JN120134.1',84,545,1,5);
INSERT INTO sequence_source VALUES(1280,'JN120148.1',84,546,1,5);
INSERT INTO sequence_source VALUES(1281,'JN676898.1',84,547,1,5);
INSERT INTO sequence_source VALUES(1282,'JN676899.1',84,547,1,5);
INSERT INTO sequence_source VALUES(1283,'JN676900.1',84,547,1,5);
INSERT INTO sequence_source VALUES(1284,'JN676901.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1285,'JN676902.1',84,547,1,5);
INSERT INTO sequence_source VALUES(1286,'JN676903.1',84,547,1,5);
INSERT INTO sequence_source VALUES(1287,'JN676904.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1288,'JN676906.1',84,547,1,5);
INSERT INTO sequence_source VALUES(1289,'JN676907.1',84,46,1,5);
INSERT INTO sequence_source VALUES(1290,'JN676908.1',84,46,1,5);
INSERT INTO sequence_source VALUES(1291,'JN676910.1',84,548,1,5);
INSERT INTO sequence_source VALUES(1292,'JN676911.1',84,549,1,5);
INSERT INTO sequence_source VALUES(1293,'JN676912.1',84,550,1,5);
INSERT INTO sequence_source VALUES(1294,'JN676914.1',84,550,1,5);
INSERT INTO sequence_source VALUES(1295,'JN676915.1',84,550,1,5);
INSERT INTO sequence_source VALUES(1296,'JN695787.1',84,551,1,62);
INSERT INTO sequence_source VALUES(1297,'JN695789.1',84,552,1,62);
INSERT INTO sequence_source VALUES(1298,'JN710016.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1299,'JN710017.1',84,13,1,5);
INSERT INTO sequence_source VALUES(1300,'JN710018.1',84,66,1,5);
INSERT INTO sequence_source VALUES(1301,'JN710019.1',84,67,1,5);
INSERT INTO sequence_source VALUES(1302,'JN710020.1',84,26,1,5);
INSERT INTO sequence_source VALUES(1303,'JN710021.1',84,553,1,55);
INSERT INTO sequence_source VALUES(1304,'JN710022.1',84,480,1,5);
INSERT INTO sequence_source VALUES(1305,'JN710023.1',84,316,1,5);
INSERT INTO sequence_source VALUES(1306,'JN710024.1',84,20,1,5);
INSERT INTO sequence_source VALUES(1307,'JN882274.1',84,554,1,9);
INSERT INTO sequence_source VALUES(1308,'JQ354936.1',84,555,1,5);
INSERT INTO sequence_source VALUES(1309,'JQ626594.1',84,484,1,5);
INSERT INTO sequence_source VALUES(1310,'JQ626595.1',84,484,1,5);
INSERT INTO sequence_source VALUES(1311,'JQ626596.1',84,486,1,5);
INSERT INTO sequence_source VALUES(1312,'JQ626597.1',84,486,1,5);
INSERT INTO sequence_source VALUES(1313,'JQ626598.1',84,486,1,5);
INSERT INTO sequence_source VALUES(1314,'JQ626599.1',84,556,1,5);
INSERT INTO sequence_source VALUES(1315,'JQ626600.1',84,484,1,5);
INSERT INTO sequence_source VALUES(1316,'JQ626601.1',84,486,1,5);
INSERT INTO sequence_source VALUES(1317,'JQ626602.1',84,557,1,5);
INSERT INTO sequence_source VALUES(1318,'JQ626603.1',84,558,1,5);
INSERT INTO sequence_source VALUES(1319,'JQ626604.1',84,484,1,5);
INSERT INTO sequence_source VALUES(1320,'JQ626605.1',84,559,1,5);
INSERT INTO sequence_source VALUES(1321,'JQ653034.1',84,480,1,5);
INSERT INTO sequence_source VALUES(1322,'JQ745261.1',84,560,1,5);
INSERT INTO sequence_source VALUES(1323,'JQ757060.1',84,561,1,5);
INSERT INTO sequence_source VALUES(1324,'JQ898452.1',84,261,1,62);
INSERT INTO sequence_source VALUES(1325,'JQ898453.1',84,562,1,62);
INSERT INTO sequence_source VALUES(1326,'JQ898456.1',84,563,1,62);
INSERT INTO sequence_source VALUES(1327,'JQ898458.1',84,564,1,62);
INSERT INTO sequence_source VALUES(1328,'JQ898461.1',84,241,1,62);
INSERT INTO sequence_source VALUES(1329,'JQ898462.1',84,562,1,62);
INSERT INTO sequence_source VALUES(1330,'JQ898464.1',84,565,1,62);
INSERT INTO sequence_source VALUES(1331,'JQ898465.1',84,566,1,55);
INSERT INTO sequence_source VALUES(1332,'JQ898466.1',84,348,1,62);
INSERT INTO sequence_source VALUES(1333,'JQ898468.1',84,567,1,62);
INSERT INTO sequence_source VALUES(1334,'JQ898470.1',84,568,1,62);
INSERT INTO sequence_source VALUES(1335,'JQ898471.1',84,243,1,62);
INSERT INTO sequence_source VALUES(1336,'JQ898474.1',84,569,1,6);
INSERT INTO sequence_source VALUES(1337,'JQ898475.1',84,233,1,62);
INSERT INTO sequence_source VALUES(1338,'JQ898477.1',84,570,1,62);
INSERT INTO sequence_source VALUES(1339,'JQ898478.1',84,371,1,62);
INSERT INTO sequence_source VALUES(1340,'JQ898479.1',84,571,1,55);
INSERT INTO sequence_source VALUES(1341,'JQ917064.1',84,550,1,5);
INSERT INTO sequence_source VALUES(1342,'JX049151.1',84,548,1,5);
INSERT INTO sequence_source VALUES(1343,'JX094353.1',84,11,1,5);
INSERT INTO sequence_source VALUES(1344,'JX134648.1',84,572,1,5);
INSERT INTO sequence_source VALUES(1345,'JX155790.1',84,573,1,5);
INSERT INTO sequence_source VALUES(1346,'JX155795.1',84,574,1,5);
INSERT INTO sequence_source VALUES(1347,'JX315267.1',84,60,1,5);
INSERT INTO sequence_source VALUES(1348,'JX315268.1',84,60,1,5);
INSERT INTO sequence_source VALUES(1349,'JX315269.1',84,60,1,5);
INSERT INTO sequence_source VALUES(1350,'JX315270.1',84,60,1,5);
INSERT INTO sequence_source VALUES(1351,'JX315271.1',84,60,1,5);
INSERT INTO sequence_source VALUES(1352,'JX458086.1',84,575,1,5);
INSERT INTO sequence_source VALUES(1353,'JX683127.1',84,11,1,5);
INSERT INTO sequence_source VALUES(1354,'JX978446.1',84,25,1,5);
INSERT INTO sequence_source VALUES(1355,'JX978447.1',84,576,1,5);
INSERT INTO sequence_source VALUES(1356,'JX996044.1',84,577,1,5);
INSERT INTO sequence_source VALUES(1357,'JX996045.1',84,578,1,5);
INSERT INTO sequence_source VALUES(1358,'JX996046.1',84,579,1,5);
INSERT INTO sequence_source VALUES(1359,'JX996047.1',84,360,1,5);
INSERT INTO sequence_source VALUES(1360,'JX996048.1',84,580,1,5);
INSERT INTO sequence_source VALUES(1361,'JX996050.1',84,581,1,5);
INSERT INTO sequence_source VALUES(1362,'KC136208.1',84,582,1,61);
INSERT INTO sequence_source VALUES(1363,'KC146363.1',84,11,1,5);
INSERT INTO sequence_source VALUES(1364,'KC146365.1',84,386,1,5);
INSERT INTO sequence_source VALUES(1365,'KC184900.1',84,13,1,5);
INSERT INTO sequence_source VALUES(1366,'KC184901.1',84,13,1,5);
INSERT INTO sequence_source VALUES(1367,'KC184902.1',84,13,1,5);
INSERT INTO sequence_source VALUES(1368,'KC184903.1',84,13,1,5);
INSERT INTO sequence_source VALUES(1369,'KC184904.1',84,13,1,5);
INSERT INTO sequence_source VALUES(1370,'KC248201.1',84,583,1,5);
INSERT INTO sequence_source VALUES(1371,'KC248202.1',84,584,1,5);
INSERT INTO sequence_source VALUES(1372,'KC311832.1',84,585,1,5);
INSERT INTO sequence_source VALUES(1373,'KC311833.1',84,586,1,5);
INSERT INTO sequence_source VALUES(1374,'KC311835.1',84,587,1,5);
INSERT INTO sequence_source VALUES(1375,'KC311837.1',84,588,1,5);
INSERT INTO sequence_source VALUES(1376,'KC311838.1',84,589,1,5);
INSERT INTO sequence_source VALUES(1377,'KC335544.1',84,590,1,5);
INSERT INTO sequence_source VALUES(1378,'KC335545.1',84,591,1,5);
INSERT INTO sequence_source VALUES(1379,'KC335546.1',84,592,1,5);
INSERT INTO sequence_source VALUES(1380,'KC335548.1',84,593,1,5);
INSERT INTO sequence_source VALUES(1381,'KC335549.1',84,29,1,5);
INSERT INTO sequence_source VALUES(1382,'KC335550.1',84,594,1,5);
INSERT INTO sequence_source VALUES(1383,'KC335551.1',84,595,1,5);
INSERT INTO sequence_source VALUES(1384,'KC347531.1',84,595,1,5);
INSERT INTO sequence_source VALUES(1385,'KC414198.1',84,596,1,35);
INSERT INTO sequence_source VALUES(1386,'KC415918.1',84,597,1,5);
INSERT INTO sequence_source VALUES(1387,'KC415920.1',84,597,1,5);
INSERT INTO sequence_source VALUES(1388,'KC438374.1',84,29,1,5);
INSERT INTO sequence_source VALUES(1389,'KC438376.1',84,587,1,5);
INSERT INTO sequence_source VALUES(1390,'KC438377.1',84,595,1,5);
INSERT INTO sequence_source VALUES(1391,'KC529657.1',84,478,1,5);
INSERT INTO sequence_source VALUES(1392,'KC594037.1',84,598,1,5);
INSERT INTO sequence_source VALUES(1393,'KC602466.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1394,'KC602476.1',84,599,1,5);
INSERT INTO sequence_source VALUES(1395,'KC602477.1',84,599,1,5);
INSERT INTO sequence_source VALUES(1396,'KC602485.1',84,600,1,55);
INSERT INTO sequence_source VALUES(1397,'KC602486.1',84,601,1,55);
INSERT INTO sequence_source VALUES(1398,'KC602488.1',84,602,1,55);
INSERT INTO sequence_source VALUES(1399,'KC602489.1',84,238,1,61);
INSERT INTO sequence_source VALUES(1400,'KC602493.1',84,603,1,55);
INSERT INTO sequence_source VALUES(1401,'KC602494.1',84,604,1,55);
INSERT INTO sequence_source VALUES(1402,'KC602496.1',84,224,1,61);
INSERT INTO sequence_source VALUES(1403,'KC677731.1',84,598,1,5);
INSERT INTO sequence_source VALUES(1404,'KC677774.1',84,11,1,5);
INSERT INTO sequence_source VALUES(1405,'KC677775.1',84,605,1,5);
INSERT INTO sequence_source VALUES(1406,'KC677776.1',84,11,1,5);
INSERT INTO sequence_source VALUES(1407,'KC677778.1',84,606,1,5);
INSERT INTO sequence_source VALUES(1408,'KC677779.1',84,607,1,5);
INSERT INTO sequence_source VALUES(1409,'KC677782.1',84,608,1,5);
INSERT INTO sequence_source VALUES(1410,'KC677784.1',84,609,1,5);
INSERT INTO sequence_source VALUES(1411,'KC677785.1',84,610,1,5);
INSERT INTO sequence_source VALUES(1412,'KC677786.1',84,611,1,5);
INSERT INTO sequence_source VALUES(1413,'KC677788.1',84,612,1,5);
INSERT INTO sequence_source VALUES(1414,'KC677791.1',84,613,1,5);
INSERT INTO sequence_source VALUES(1415,'KC677793.1',84,614,1,5);
INSERT INTO sequence_source VALUES(1416,'KC677797.1',84,615,1,5);
INSERT INTO sequence_source VALUES(1417,'KC677798.1',84,616,1,5);
INSERT INTO sequence_source VALUES(1418,'KC677799.1',84,617,1,5);
INSERT INTO sequence_source VALUES(1419,'KC677800.1',84,11,1,5);
INSERT INTO sequence_source VALUES(1420,'KC677801.1',84,618,1,5);
INSERT INTO sequence_source VALUES(1421,'KC677804.1',84,598,1,5);
INSERT INTO sequence_source VALUES(1422,'KC677805.1',84,598,1,5);
INSERT INTO sequence_source VALUES(1423,'KC677806.1',84,619,1,5);
INSERT INTO sequence_source VALUES(1424,'KC677807.1',84,620,1,5);
INSERT INTO sequence_source VALUES(1425,'KC677808.1',84,621,1,5);
INSERT INTO sequence_source VALUES(1426,'KC677809.1',84,622,1,5);
INSERT INTO sequence_source VALUES(1427,'KC677810.1',84,623,1,5);
INSERT INTO sequence_source VALUES(1428,'KC677811.1',84,624,1,5);
INSERT INTO sequence_source VALUES(1429,'KC677812.1',84,624,1,5);
INSERT INTO sequence_source VALUES(1430,'KC677813.1',84,624,1,5);
INSERT INTO sequence_source VALUES(1431,'KC677814.1',84,624,1,5);
INSERT INTO sequence_source VALUES(1432,'KC677815.1',84,625,1,5);
INSERT INTO sequence_source VALUES(1433,'KC677816.1',84,598,1,5);
INSERT INTO sequence_source VALUES(1434,'KC677817.1',84,626,1,5);
INSERT INTO sequence_source VALUES(1435,'KC677818.1',84,627,1,5);
INSERT INTO sequence_source VALUES(1436,'KC677819.1',84,624,1,5);
INSERT INTO sequence_source VALUES(1437,'KC677820.1',84,628,1,5);
INSERT INTO sequence_source VALUES(1438,'KC677822.1',84,629,1,5);
INSERT INTO sequence_source VALUES(1439,'KC677823.1',84,630,1,5);
INSERT INTO sequence_source VALUES(1440,'KC677824.1',84,619,1,5);
INSERT INTO sequence_source VALUES(1441,'KC677825.1',84,631,1,5);
INSERT INTO sequence_source VALUES(1442,'KC677826.1',84,632,1,5);
INSERT INTO sequence_source VALUES(1443,'KC677827.1',84,624,1,5);
INSERT INTO sequence_source VALUES(1444,'KC677828.1',84,633,1,5);
INSERT INTO sequence_source VALUES(1445,'KC677829.1',84,634,1,5);
INSERT INTO sequence_source VALUES(1446,'KC677830.1',84,635,1,5);
INSERT INTO sequence_source VALUES(1447,'KC677831.1',84,636,1,5);
INSERT INTO sequence_source VALUES(1448,'KC677835.1',84,637,1,5);
INSERT INTO sequence_source VALUES(1449,'KC677836.1',84,638,1,5);
INSERT INTO sequence_source VALUES(1450,'KC677837.1',84,639,1,5);
INSERT INTO sequence_source VALUES(1451,'KC677838.1',84,633,1,5);
INSERT INTO sequence_source VALUES(1452,'KC677840.1',84,640,1,5);
INSERT INTO sequence_source VALUES(1453,'KC677841.1',84,641,1,5);
INSERT INTO sequence_source VALUES(1454,'KC677842.1',84,634,1,5);
INSERT INTO sequence_source VALUES(1455,'KC677843.1',84,642,1,5);
INSERT INTO sequence_source VALUES(1456,'KC677844.1',84,643,1,5);
INSERT INTO sequence_source VALUES(1457,'KC677845.1',84,624,1,5);
INSERT INTO sequence_source VALUES(1458,'KC677847.1',84,644,1,5);
INSERT INTO sequence_source VALUES(1459,'KC677848.1',84,645,1,5);
INSERT INTO sequence_source VALUES(1460,'KC677849.1',84,646,1,5);
INSERT INTO sequence_source VALUES(1461,'KC677850.1',84,647,1,5);
INSERT INTO sequence_source VALUES(1462,'KC677851.1',84,648,1,5);
INSERT INTO sequence_source VALUES(1463,'KC677852.1',84,633,1,5);
INSERT INTO sequence_source VALUES(1464,'KC695722.1',84,649,1,5);
INSERT INTO sequence_source VALUES(1465,'KC695724.1',84,650,1,5);
INSERT INTO sequence_source VALUES(1466,'KC768775.1',84,265,1,5);
INSERT INTO sequence_source VALUES(1467,'KF010299.1',84,60,1,5);
INSERT INTO sequence_source VALUES(1468,'KF010300.1',84,651,1,5);
INSERT INTO sequence_source VALUES(1469,'KF010301.1',84,652,1,5);
INSERT INTO sequence_source VALUES(1470,'KF010302.1',84,42,1,5);
INSERT INTO sequence_source VALUES(1471,'KF010303.1',84,25,1,5);
INSERT INTO sequence_source VALUES(1472,'KF010304.1',84,42,1,5);
INSERT INTO sequence_source VALUES(1473,'KF010305.1',84,42,1,5);
INSERT INTO sequence_source VALUES(1474,'KF010306.1',84,60,1,5);
INSERT INTO sequence_source VALUES(1475,'KF010307.1',84,60,1,5);
INSERT INTO sequence_source VALUES(1476,'KF010308.1',84,60,1,5);
INSERT INTO sequence_source VALUES(1477,'KF010309.1',84,60,1,5);
INSERT INTO sequence_source VALUES(1478,'KF110980.1',84,653,1,5);
INSERT INTO sequence_source VALUES(1479,'KF147897.1',84,654,1,5);
INSERT INTO sequence_source VALUES(1480,'KF147900.1',84,25,1,5);
INSERT INTO sequence_source VALUES(1481,'KF147901.1',84,584,1,5);
INSERT INTO sequence_source VALUES(1482,'KF181448.1',84,655,1,62);
INSERT INTO sequence_source VALUES(1483,'KF181449.1',84,141,1,62);
INSERT INTO sequence_source VALUES(1484,'KF181450.1',84,656,1,6);
INSERT INTO sequence_source VALUES(1485,'KF181451.1',84,141,1,62);
INSERT INTO sequence_source VALUES(1486,'KF181453.1',84,657,1,62);
INSERT INTO sequence_source VALUES(1487,'KF181454.1',84,141,1,62);
INSERT INTO sequence_source VALUES(1488,'KF181455.1',84,233,1,62);
INSERT INTO sequence_source VALUES(1489,'KF234654.1',84,322,1,5);
INSERT INTO sequence_source VALUES(1490,'KF234655.1',84,322,1,5);
INSERT INTO sequence_source VALUES(1491,'KF234656.1',84,322,1,5);
INSERT INTO sequence_source VALUES(1492,'KF234657.1',84,322,1,5);
INSERT INTO sequence_source VALUES(1493,'KF234658.1',84,322,1,5);
INSERT INTO sequence_source VALUES(1494,'KF234659.1',84,322,1,5);
INSERT INTO sequence_source VALUES(1495,'KF234660.1',84,322,1,5);
INSERT INTO sequence_source VALUES(1496,'KF234661.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1497,'KF234662.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1498,'KF234663.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1499,'KF234664.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1500,'KF234665.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1501,'KF234666.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1502,'KF234667.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1503,'KF234668.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1504,'KF234669.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1505,'KF234670.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1506,'KF234671.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1507,'KF234672.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1508,'KF234673.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1509,'KF234674.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1510,'KF234675.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1511,'KF234676.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1512,'KF234677.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1513,'KF234678.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1514,'KF234679.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1515,'KF234680.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1516,'KF234681.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1517,'KF234682.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1518,'KF234683.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1519,'KF234684.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1520,'KF234685.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1521,'KF234686.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1522,'KF234687.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1523,'KF234688.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1524,'KF234689.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1525,'KF234690.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1526,'KF234691.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1527,'KF234692.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1528,'KF234693.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1529,'KF234694.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1530,'KF234695.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1531,'KF234696.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1532,'KF234697.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1533,'KF234698.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1534,'KF234699.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1535,'KF234700.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1536,'KF234701.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1537,'KF234702.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1538,'KF234703.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1539,'KF234704.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1540,'KF234705.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1541,'KF234706.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1542,'KF234707.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1543,'KF234708.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1544,'KF234709.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1545,'KF234710.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1546,'KF234711.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1547,'KF234712.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1548,'KF234713.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1549,'KF234714.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1550,'KF234715.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1551,'KF234716.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1552,'KF234717.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1553,'KF234718.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1554,'KF234719.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1555,'KF234720.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1556,'KF234721.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1557,'KF234722.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1558,'KF234723.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1559,'KF234724.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1560,'KF234725.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1561,'KF234726.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1562,'KF234727.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1563,'KF234728.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1564,'KF234729.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1565,'KF234730.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1566,'KF234731.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1567,'KF234732.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1568,'KF234733.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1569,'KF234734.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1570,'KF234735.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1571,'KF234736.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1572,'KF234737.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1573,'KF234738.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1574,'KF234739.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1575,'KF234740.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1576,'KF234741.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1577,'KF234742.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1578,'KF234743.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1579,'KF234744.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1580,'KF234745.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1581,'KF234746.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1582,'KF234747.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1583,'KF234748.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1584,'KF234749.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1585,'KF234750.1',84,313,1,5);
INSERT INTO sequence_source VALUES(1586,'KF234751.1',84,313,1,5);
INSERT INTO sequence_source VALUES(1587,'KF234752.1',84,313,1,5);
INSERT INTO sequence_source VALUES(1588,'KF234753.1',84,313,1,5);
INSERT INTO sequence_source VALUES(1589,'KF234754.1',84,313,1,5);
INSERT INTO sequence_source VALUES(1590,'KF234755.1',84,313,1,5);
INSERT INTO sequence_source VALUES(1591,'KF234756.1',84,313,1,5);
INSERT INTO sequence_source VALUES(1592,'KF234757.1',84,313,1,5);
INSERT INTO sequence_source VALUES(1593,'KF234758.1',84,313,1,5);
INSERT INTO sequence_source VALUES(1594,'KF234759.1',84,658,1,5);
INSERT INTO sequence_source VALUES(1595,'KF234760.1',84,659,1,5);
INSERT INTO sequence_source VALUES(1596,'KF234761.1',84,659,1,5);
INSERT INTO sequence_source VALUES(1597,'KF234762.1',84,659,1,5);
INSERT INTO sequence_source VALUES(1598,'KF234763.1',84,660,1,5);
INSERT INTO sequence_source VALUES(1599,'KF234764.1',84,660,1,5);
INSERT INTO sequence_source VALUES(1600,'KF234765.1',84,41,1,5);
INSERT INTO sequence_source VALUES(1601,'KF263691.1',84,60,1,5);
INSERT INTO sequence_source VALUES(1602,'KF271785.1',84,661,1,5);
INSERT INTO sequence_source VALUES(1603,'KF271786.1',84,662,1,5);
INSERT INTO sequence_source VALUES(1604,'KF271787.1',84,663,1,5);
INSERT INTO sequence_source VALUES(1605,'KF271788.1',84,664,1,5);
INSERT INTO sequence_source VALUES(1606,'KF271790.1',84,665,1,5);
INSERT INTO sequence_source VALUES(1607,'KF271791.1',84,363,1,5);
INSERT INTO sequence_source VALUES(1608,'KF278458.1',84,11,1,5);
INSERT INTO sequence_source VALUES(1609,'KF286843.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1610,'KF286844.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1611,'KF286845.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1612,'KF286846.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1613,'KF286847.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1614,'KF286848.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1615,'KF286849.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1616,'KF286850.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1617,'KF286851.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1618,'KF286852.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1619,'KF286853.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1620,'KF286854.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1621,'KF286855.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1622,'KF286856.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1623,'KF286857.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1624,'KF286858.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1625,'KF286859.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1626,'KF286860.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1627,'KF286861.1',84,666,1,5);
INSERT INTO sequence_source VALUES(1628,'KF286862.1',84,666,1,5);
INSERT INTO sequence_source VALUES(1629,'KF286863.1',84,666,1,5);
INSERT INTO sequence_source VALUES(1630,'KF286864.1',84,666,1,5);
INSERT INTO sequence_source VALUES(1631,'KF286865.1',84,666,1,5);
INSERT INTO sequence_source VALUES(1632,'KF286866.1',84,666,1,5);
INSERT INTO sequence_source VALUES(1633,'KF286867.1',84,666,1,5);
INSERT INTO sequence_source VALUES(1634,'KF286868.1',84,666,1,5);
INSERT INTO sequence_source VALUES(1635,'KF286869.1',84,666,1,5);
INSERT INTO sequence_source VALUES(1636,'KF286870.1',84,666,1,5);
INSERT INTO sequence_source VALUES(1637,'KF286871.1',84,666,1,5);
INSERT INTO sequence_source VALUES(1638,'KF286872.1',84,666,1,5);
INSERT INTO sequence_source VALUES(1639,'KF286873.1',84,666,1,5);
INSERT INTO sequence_source VALUES(1640,'KF286874.1',84,666,1,5);
INSERT INTO sequence_source VALUES(1641,'KF286875.1',84,309,1,5);
INSERT INTO sequence_source VALUES(1642,'KF286876.1',84,313,1,5);
INSERT INTO sequence_source VALUES(1643,'KF286877.1',84,313,1,5);
INSERT INTO sequence_source VALUES(1644,'KF286878.1',84,313,1,5);
INSERT INTO sequence_source VALUES(1645,'KF286879.1',84,313,1,5);
INSERT INTO sequence_source VALUES(1646,'KF286880.1',84,313,1,5);
INSERT INTO sequence_source VALUES(1647,'KF286881.1',84,313,1,5);
INSERT INTO sequence_source VALUES(1648,'KF286882.1',84,313,1,5);
INSERT INTO sequence_source VALUES(1649,'KF286883.1',84,313,1,5);
INSERT INTO sequence_source VALUES(1650,'KF286884.1',84,313,1,5);
INSERT INTO sequence_source VALUES(1651,'KF286885.1',84,313,1,5);
INSERT INTO sequence_source VALUES(1652,'KF286886.1',84,313,1,5);
INSERT INTO sequence_source VALUES(1653,'KF286887.1',84,313,1,5);
INSERT INTO sequence_source VALUES(1654,'KF286888.1',84,313,1,5);
INSERT INTO sequence_source VALUES(1655,'KF286889.1',84,313,1,5);
INSERT INTO sequence_source VALUES(1656,'KF286890.1',84,667,1,5);
INSERT INTO sequence_source VALUES(1657,'KF286891.1',84,667,1,5);
INSERT INTO sequence_source VALUES(1658,'KF286892.1',84,667,1,5);
INSERT INTO sequence_source VALUES(1659,'KF286893.1',84,667,1,5);
INSERT INTO sequence_source VALUES(1660,'KF286894.1',84,667,1,5);
INSERT INTO sequence_source VALUES(1661,'KF318041.1',84,668,1,6);
INSERT INTO sequence_source VALUES(1662,'KF356393.1',84,669,1,5);
INSERT INTO sequence_source VALUES(1663,'KF366378.1',84,670,1,4);
INSERT INTO sequence_source VALUES(1664,'KF366379.1',84,670,1,4);
INSERT INTO sequence_source VALUES(1665,'KF366380.1',84,670,1,4);
INSERT INTO sequence_source VALUES(1666,'KF444064.1',84,671,1,5);
INSERT INTO sequence_source VALUES(1667,'KF444065.1',84,20,1,5);
INSERT INTO sequence_source VALUES(1668,'KF444067.1',84,672,1,5);
INSERT INTO sequence_source VALUES(1669,'KF444070.1',84,411,1,5);
INSERT INTO sequence_source VALUES(1670,'KF494895.1',84,673,1,62);
INSERT INTO sequence_source VALUES(1671,'KF501392.1',84,674,1,5);
INSERT INTO sequence_source VALUES(1672,'KF525843.1',84,300,1,62);
INSERT INTO sequence_source VALUES(1673,'KF611668.1',84,477,1,5);
INSERT INTO sequence_source VALUES(1674,'KF611669.1',84,675,1,5);
INSERT INTO sequence_source VALUES(1675,'KF611670.1',84,676,1,5);
INSERT INTO sequence_source VALUES(1676,'KF611671.1',84,677,1,5);
INSERT INTO sequence_source VALUES(1677,'KF611672.1',84,678,1,5);
INSERT INTO sequence_source VALUES(1678,'KF611673.1',84,598,1,5);
INSERT INTO sequence_source VALUES(1679,'KF611674.1',84,679,1,5);
INSERT INTO sequence_source VALUES(1680,'KF611675.1',84,598,1,5);
INSERT INTO sequence_source VALUES(1681,'KF700086.1',84,680,1,5);
INSERT INTO sequence_source VALUES(1682,'KF700087.1',84,591,1,5);
INSERT INTO sequence_source VALUES(1683,'KF700088.1',84,595,1,5);
INSERT INTO sequence_source VALUES(1684,'KF700089.1',84,29,1,5);
INSERT INTO sequence_source VALUES(1685,'KF700090.1',84,29,1,5);
INSERT INTO sequence_source VALUES(1686,'KF700091.1',84,593,1,5);
INSERT INTO sequence_source VALUES(1687,'KF723832.1',84,681,1,5);
INSERT INTO sequence_source VALUES(1688,'KF723833.1',84,682,1,5);
INSERT INTO sequence_source VALUES(1689,'KF723835.1',84,682,1,5);
INSERT INTO sequence_source VALUES(1690,'KF723836.1',84,682,1,5);
INSERT INTO sequence_source VALUES(1691,'KF724686.1',84,683,1,5);
INSERT INTO sequence_source VALUES(1692,'KF750595.1',84,380,1,5);
INSERT INTO sequence_source VALUES(1693,'KF761214.1',84,171,1,62);
INSERT INTO sequence_source VALUES(1694,'KF761215.1',84,171,1,62);
INSERT INTO sequence_source VALUES(1695,'KF761216.1',84,684,1,62);
INSERT INTO sequence_source VALUES(1696,'KF761217.1',84,171,1,62);
INSERT INTO sequence_source VALUES(1697,'KF831193.1',84,682,1,5);
INSERT INTO sequence_source VALUES(1698,'KF831194.1',84,682,1,5);
INSERT INTO sequence_source VALUES(1699,'KF831195.1',84,682,1,5);
INSERT INTO sequence_source VALUES(1700,'KF888585.1',84,162,1,9);
INSERT INTO sequence_source VALUES(1701,'KF888586.1',84,162,1,9);
INSERT INTO sequence_source VALUES(1702,'KF888587.1',84,162,1,9);
INSERT INTO sequence_source VALUES(1703,'KF888588.1',84,162,1,9);
INSERT INTO sequence_source VALUES(1704,'KF888589.1',84,162,1,9);
INSERT INTO sequence_source VALUES(1705,'KF888590.1',84,162,1,9);
INSERT INTO sequence_source VALUES(1706,'KF888591.1',84,162,1,9);
INSERT INTO sequence_source VALUES(1707,'KF888592.1',84,162,1,9);
INSERT INTO sequence_source VALUES(1708,'KF888593.1',84,162,1,9);
INSERT INTO sequence_source VALUES(1709,'KF888594.1',84,162,1,9);
INSERT INTO sequence_source VALUES(1710,'KF888595.1',84,162,1,9);
INSERT INTO sequence_source VALUES(1711,'KF888596.1',84,162,1,9);
INSERT INTO sequence_source VALUES(1712,'KF888597.1',84,162,1,9);
INSERT INTO sequence_source VALUES(1713,'KF888598.1',84,162,1,9);
INSERT INTO sequence_source VALUES(1714,'KF888599.1',84,162,1,9);
INSERT INTO sequence_source VALUES(1715,'KF888600.1',84,162,1,9);
INSERT INTO sequence_source VALUES(1716,'KF888601.1',84,162,1,9);
INSERT INTO sequence_source VALUES(1717,'KF888602.1',84,162,1,9);
INSERT INTO sequence_source VALUES(1718,'KF888603.1',84,162,1,9);
INSERT INTO sequence_source VALUES(1719,'KF888604.1',84,162,1,9);
INSERT INTO sequence_source VALUES(1720,'KF963049.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1721,'KF963050.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1722,'KF990557.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1723,'KJ002561.1',84,685,1,9);
INSERT INTO sequence_source VALUES(1724,'KJ128038.1',84,686,1,75);
INSERT INTO sequence_source VALUES(1725,'KJ144772.1',84,687,1,5);
INSERT INTO sequence_source VALUES(1726,'KJ162353.1',84,688,1,62);
INSERT INTO sequence_source VALUES(1727,'KJ494889.1',84,265,1,5);
INSERT INTO sequence_source VALUES(1728,'KJ494890.1',84,689,1,5);
INSERT INTO sequence_source VALUES(1729,'KJ494891.1',84,690,1,5);
INSERT INTO sequence_source VALUES(1730,'KJ494892.1',84,265,1,5);
INSERT INTO sequence_source VALUES(1731,'KJ494893.1',84,265,1,5);
INSERT INTO sequence_source VALUES(1732,'KJ494894.1',84,265,1,5);
INSERT INTO sequence_source VALUES(1733,'KJ494895.1',84,265,1,5);
INSERT INTO sequence_source VALUES(1734,'KJ494896.1',84,265,1,5);
INSERT INTO sequence_source VALUES(1735,'KJ494897.1',84,265,1,5);
INSERT INTO sequence_source VALUES(1736,'KJ494898.1',84,265,1,5);
INSERT INTO sequence_source VALUES(1737,'KJ494899.1',84,265,1,5);
INSERT INTO sequence_source VALUES(1738,'KJ494900.1',84,265,1,5);
INSERT INTO sequence_source VALUES(1739,'KJ494901.1',84,265,1,5);
INSERT INTO sequence_source VALUES(1740,'KJ494902.1',84,265,1,5);
INSERT INTO sequence_source VALUES(1741,'KJ494903.1',84,265,1,5);
INSERT INTO sequence_source VALUES(1742,'KJ494904.1',84,691,1,5);
INSERT INTO sequence_source VALUES(1743,'KJ494905.1',84,692,1,5);
INSERT INTO sequence_source VALUES(1744,'KJ494906.1',84,265,1,5);
INSERT INTO sequence_source VALUES(1745,'KJ494907.1',84,265,1,5);
INSERT INTO sequence_source VALUES(1746,'KJ494908.1',84,265,1,5);
INSERT INTO sequence_source VALUES(1747,'KJ494909.1',84,691,1,5);
INSERT INTO sequence_source VALUES(1748,'KJ494910.1',84,265,1,5);
INSERT INTO sequence_source VALUES(1749,'KJ494911.1',84,265,1,5);
INSERT INTO sequence_source VALUES(1750,'KJ494912.1',84,693,1,5);
INSERT INTO sequence_source VALUES(1751,'KJ494913.1',84,694,1,5);
INSERT INTO sequence_source VALUES(1752,'KJ494914.1',84,265,1,5);
INSERT INTO sequence_source VALUES(1753,'KJ494915.1',84,265,1,5);
INSERT INTO sequence_source VALUES(1754,'KJ494916.1',84,693,1,5);
INSERT INTO sequence_source VALUES(1755,'KJ494917.1',84,265,1,5);
INSERT INTO sequence_source VALUES(1756,'KJ494918.1',84,265,1,5);
INSERT INTO sequence_source VALUES(1757,'KJ494919.1',84,265,1,5);
INSERT INTO sequence_source VALUES(1758,'KJ494920.1',84,265,1,5);
INSERT INTO sequence_source VALUES(1759,'KJ507656.1',84,695,1,5);
INSERT INTO sequence_source VALUES(1760,'KJ507657.1',84,381,1,5);
INSERT INTO sequence_source VALUES(1761,'KJ549640.1',84,696,1,5);
INSERT INTO sequence_source VALUES(1762,'KJ549641.1',84,697,1,5);
INSERT INTO sequence_source VALUES(1763,'KJ562359.1',84,25,1,5);
INSERT INTO sequence_source VALUES(1764,'KJ572971.1',84,698,1,5);
INSERT INTO sequence_source VALUES(1765,'KJ576799.1',84,598,1,5);
INSERT INTO sequence_source VALUES(1766,'KJ664801.1',84,154,1,5);
INSERT INTO sequence_source VALUES(1767,'KJ754387.1',84,699,1,5);
INSERT INTO sequence_source VALUES(1768,'KJ755087.1',84,141,1,62);
INSERT INTO sequence_source VALUES(1769,'KJ755089.1',84,520,1,55);
INSERT INTO sequence_source VALUES(1770,'KJ755090.1',84,13,1,5);
INSERT INTO sequence_source VALUES(1771,'KJ755091.1',84,700,1,5);
INSERT INTO sequence_source VALUES(1772,'KJ755092.1',84,12,1,5);
INSERT INTO sequence_source VALUES(1773,'KJ755093.1',84,701,1,5);
INSERT INTO sequence_source VALUES(1774,'KJ755094.1',84,45,1,5);
INSERT INTO sequence_source VALUES(1775,'KJ755095.1',84,67,1,5);
INSERT INTO sequence_source VALUES(1776,'KJ755096.1',84,702,1,5);
INSERT INTO sequence_source VALUES(1777,'KJ755097.1',84,703,1,5);
INSERT INTO sequence_source VALUES(1778,'KJ755098.1',84,485,1,5);
INSERT INTO sequence_source VALUES(1779,'KJ755101.1',84,401,1,5);
INSERT INTO sequence_source VALUES(1780,'KJ755102.1',84,704,1,5);
INSERT INTO sequence_source VALUES(1781,'KJ755103.1',84,37,1,5);
INSERT INTO sequence_source VALUES(1782,'KJ755104.1',84,29,1,5);
INSERT INTO sequence_source VALUES(1783,'KJ755108.1',84,221,1,5);
INSERT INTO sequence_source VALUES(1784,'KJ755109.1',84,705,1,5);
INSERT INTO sequence_source VALUES(1785,'KJ755110.1',84,46,1,5);
INSERT INTO sequence_source VALUES(1786,'KJ755111.1',84,60,1,5);
INSERT INTO sequence_source VALUES(1787,'KJ755112.1',84,669,1,5);
INSERT INTO sequence_source VALUES(1788,'KJ755113.1',84,20,1,5);
INSERT INTO sequence_source VALUES(1789,'KJ755114.1',84,706,1,5);
INSERT INTO sequence_source VALUES(1790,'KJ755115.1',84,64,1,5);
INSERT INTO sequence_source VALUES(1791,'KJ755116.1',84,707,1,5);
INSERT INTO sequence_source VALUES(1792,'KJ755117.1',84,708,1,5);
INSERT INTO sequence_source VALUES(1793,'KJ755118.1',84,709,1,5);
INSERT INTO sequence_source VALUES(1794,'KJ755119.1',84,24,1,5);
INSERT INTO sequence_source VALUES(1795,'KJ755120.1',84,710,1,5);
INSERT INTO sequence_source VALUES(1796,'KJ755121.1',84,480,1,5);
INSERT INTO sequence_source VALUES(1797,'KJ755122.1',84,480,1,5);
INSERT INTO sequence_source VALUES(1798,'KJ755123.1',84,480,1,5);
INSERT INTO sequence_source VALUES(1799,'KJ755124.1',84,480,1,5);
INSERT INTO sequence_source VALUES(1800,'KJ755125.1',84,480,1,5);
INSERT INTO sequence_source VALUES(1801,'KJ755127.1',84,538,1,5);
INSERT INTO sequence_source VALUES(1802,'KJ755128.1',84,382,1,5);
INSERT INTO sequence_source VALUES(1803,'KJ755130.1',84,66,1,5);
INSERT INTO sequence_source VALUES(1804,'KJ755131.1',84,10,1,5);
INSERT INTO sequence_source VALUES(1805,'KJ755134.1',84,76,1,5);
INSERT INTO sequence_source VALUES(1806,'KJ755193.1',84,380,1,5);
INSERT INTO sequence_source VALUES(1807,'KJ755194.1',84,380,1,5);
INSERT INTO sequence_source VALUES(1808,'KJ755195.1',84,380,1,5);
INSERT INTO sequence_source VALUES(1809,'KJ831613.1',84,711,1,55);
INSERT INTO sequence_source VALUES(1810,'KJ855323.1',84,313,1,5);
INSERT INTO sequence_source VALUES(1811,'KJ855324.1',84,411,1,5);
INSERT INTO sequence_source VALUES(1812,'KJ855325.1',84,269,1,5);
INSERT INTO sequence_source VALUES(1813,'KJ855326.1',84,29,1,5);
INSERT INTO sequence_source VALUES(1814,'KJ855327.1',84,322,1,5);
INSERT INTO sequence_source VALUES(1815,'KJ865226.1',84,712,1,5);
INSERT INTO sequence_source VALUES(1816,'KJ865227.1',84,359,1,5);
INSERT INTO sequence_source VALUES(1817,'KJ865230.1',84,25,1,5);
INSERT INTO sequence_source VALUES(1818,'KJ865238.1',84,713,1,55);
INSERT INTO sequence_source VALUES(1819,'KJ960193.1',84,312,1,9);
INSERT INTO sequence_source VALUES(1820,'KM052583.1',84,311,1,5);
INSERT INTO sequence_source VALUES(1821,'KM058095.1',84,714,1,9);
INSERT INTO sequence_source VALUES(1822,'KM058096.1',84,715,1,9);
INSERT INTO sequence_source VALUES(1823,'KM058097.1',84,716,1,9);
INSERT INTO sequence_source VALUES(1824,'KM058101.1',84,717,1,9);
INSERT INTO sequence_source VALUES(1825,'KM061707.1',84,224,1,61);
INSERT INTO sequence_source VALUES(1826,'KM061711.1',84,718,1,5);
INSERT INTO sequence_source VALUES(1827,'KM087089.1',84,719,1,5);
INSERT INTO sequence_source VALUES(1828,'KM279674.1',84,720,1,5);
INSERT INTO sequence_source VALUES(1829,'KM279676.1',84,721,1,5);
INSERT INTO sequence_source VALUES(1830,'KM369965.1',84,722,1,5);
INSERT INTO sequence_source VALUES(1831,'KM387400.1',84,723,1,5);
INSERT INTO sequence_source VALUES(1832,'KM519189.1',84,724,1,5);
INSERT INTO sequence_source VALUES(1833,'KM979514.1',84,454,1,5);
INSERT INTO sequence_source VALUES(1834,'KP050543.1',84,454,1,5);
INSERT INTO sequence_source VALUES(1835,'KP050544.1',84,60,1,5);
INSERT INTO sequence_source VALUES(1836,'KP050545.1',84,477,1,5);
INSERT INTO sequence_source VALUES(1837,'KP050546.1',84,477,1,5);
INSERT INTO sequence_source VALUES(1838,'KP063125.1',84,725,1,62);
INSERT INTO sequence_source VALUES(1839,'KP159287.1',84,13,1,5);
INSERT INTO sequence_source VALUES(1840,'KP164987.1',84,312,1,9);
INSERT INTO sequence_source VALUES(1841,'KP183929.1',84,726,1,6);
INSERT INTO sequence_source VALUES(1842,'KP183932.1',84,727,1,55);
INSERT INTO sequence_source VALUES(1843,'KP183936.1',84,728,1,5);
INSERT INTO sequence_source VALUES(1844,'KP183937.1',84,729,1,6);
INSERT INTO sequence_source VALUES(1845,'KP183939.1',84,728,1,5);
INSERT INTO sequence_source VALUES(1846,'KP183940.1',84,730,1,55);
INSERT INTO sequence_source VALUES(1847,'KP183941.1',84,731,1,55);
INSERT INTO sequence_source VALUES(1848,'KP183942.1',84,732,1,55);
INSERT INTO sequence_source VALUES(1849,'KP183944.1',84,733,1,55);
INSERT INTO sequence_source VALUES(1850,'KP183946.1',84,734,1,6);
INSERT INTO sequence_source VALUES(1851,'KP183952.1',84,735,1,55);
INSERT INTO sequence_source VALUES(1852,'KP183954.1',84,736,1,6);
INSERT INTO sequence_source VALUES(1853,'KP183955.1',84,737,1,6);
INSERT INTO sequence_source VALUES(1854,'KP183957.1',84,738,1,6);
INSERT INTO sequence_source VALUES(1856,'KP183960.1',84,740,1,55);
INSERT INTO sequence_source VALUES(1857,'KP183961.1',84,741,1,55);
INSERT INTO sequence_source VALUES(1858,'KP183962.1',84,741,1,55);
INSERT INTO sequence_source VALUES(1859,'KP183963.1',84,60,1,5);
INSERT INTO sequence_source VALUES(1860,'KP271924.1',84,742,1,9);
INSERT INTO sequence_source VALUES(1861,'KP670200.1',84,743,1,5);
INSERT INTO sequence_source VALUES(1862,'KP780448.1',84,744,1,6);
INSERT INTO sequence_source VALUES(1863,'KP780453.1',84,745,1,5);
INSERT INTO sequence_source VALUES(1864,'KR827692.1',84,25,1,5);
INSERT INTO sequence_source VALUES(1865,'KT175508.1',84,25,1,5);
INSERT INTO sequence_source VALUES(1866,'KT223573.1',84,746,1,55);
INSERT INTO sequence_source VALUES(1867,'KT248949.1',84,341,1,3);
INSERT INTO sequence_source VALUES(1868,'KT248950.1',84,341,1,3);
INSERT INTO sequence_source VALUES(1869,'KT248951.1',84,341,1,3);
INSERT INTO sequence_source VALUES(1870,'KT248952.1',84,341,1,3);
INSERT INTO sequence_source VALUES(1871,'KT248953.1',84,341,1,3);
INSERT INTO sequence_source VALUES(1872,'KT248954.1',84,341,1,3);
INSERT INTO sequence_source VALUES(1873,'KT248955.1',84,341,1,3);
INSERT INTO sequence_source VALUES(1874,'KT248956.1',84,341,1,3);
INSERT INTO sequence_source VALUES(1875,'KT248957.1',84,341,1,3);
INSERT INTO sequence_source VALUES(1876,'KT248958.1',84,341,1,3);
INSERT INTO sequence_source VALUES(1877,'KT248959.1',84,341,1,3);
INSERT INTO sequence_source VALUES(1878,'KT248960.1',84,341,1,3);
INSERT INTO sequence_source VALUES(1879,'KT248961.1',84,747,1,3);
INSERT INTO sequence_source VALUES(1880,'KT248962.1',84,747,1,3);
INSERT INTO sequence_source VALUES(1881,'KT248963.1',84,747,1,3);
INSERT INTO sequence_source VALUES(1882,'KT248964.1',84,747,1,3);
INSERT INTO sequence_source VALUES(1883,'KT248965.1',84,747,1,3);
INSERT INTO sequence_source VALUES(1884,'KT248966.1',84,748,1,3);
INSERT INTO sequence_source VALUES(1885,'KT248967.1',84,748,1,3);
INSERT INTO sequence_source VALUES(1886,'KT248968.1',84,748,1,3);
INSERT INTO sequence_source VALUES(1887,'KT248969.1',84,748,1,3);
INSERT INTO sequence_source VALUES(1888,'KT248970.1',84,748,1,3);
INSERT INTO sequence_source VALUES(1889,'KT248971.1',84,748,1,3);
INSERT INTO sequence_source VALUES(1890,'KT248972.1',84,341,1,3);
INSERT INTO sequence_source VALUES(1891,'KT248973.1',84,747,1,3);
INSERT INTO sequence_source VALUES(1892,'KT248974.1',84,341,1,3);
INSERT INTO sequence_source VALUES(1893,'KT248975.1',84,340,1,3);
INSERT INTO sequence_source VALUES(1894,'KT248976.1',84,340,1,3);
INSERT INTO sequence_source VALUES(1895,'KT248977.1',84,340,1,3);
INSERT INTO sequence_source VALUES(1896,'KT248978.1',84,340,1,3);
INSERT INTO sequence_source VALUES(1897,'KT248979.1',84,341,1,3);
INSERT INTO sequence_source VALUES(1898,'KT248980.1',84,341,1,3);
INSERT INTO sequence_source VALUES(1899,'KT248981.1',84,341,1,3);
INSERT INTO sequence_source VALUES(1900,'KT248982.1',84,341,1,3);
INSERT INTO sequence_source VALUES(1901,'KT248983.1',84,341,1,3);
INSERT INTO sequence_source VALUES(1902,'KT248984.1',84,341,1,3);
INSERT INTO sequence_source VALUES(1903,'KT248985.1',84,333,1,3);
INSERT INTO sequence_source VALUES(1904,'KT248986.1',84,333,1,3);
INSERT INTO sequence_source VALUES(1905,'KT248987.1',84,333,1,3);
INSERT INTO sequence_source VALUES(1906,'KT248988.1',84,333,1,3);
INSERT INTO sequence_source VALUES(1907,'KT248989.1',84,333,1,3);
INSERT INTO sequence_source VALUES(1908,'KT248990.1',84,333,1,3);
INSERT INTO sequence_source VALUES(1909,'KT248991.1',84,333,1,3);
INSERT INTO sequence_source VALUES(1910,'KT248992.1',84,333,1,3);
INSERT INTO sequence_source VALUES(1911,'KT248993.1',84,333,1,3);
INSERT INTO sequence_source VALUES(1912,'KT248994.1',84,333,1,3);
INSERT INTO sequence_source VALUES(1913,'KT248995.1',84,333,1,3);
INSERT INTO sequence_source VALUES(1914,'KT248996.1',84,333,1,3);
INSERT INTO sequence_source VALUES(1915,'KT248997.1',84,333,1,3);
INSERT INTO sequence_source VALUES(1916,'KT248998.1',84,333,1,3);
INSERT INTO sequence_source VALUES(1917,'KT248999.1',84,333,1,3);
INSERT INTO sequence_source VALUES(1918,'KT249000.1',84,333,1,3);
INSERT INTO sequence_source VALUES(1919,'KT249001.1',84,333,1,3);
INSERT INTO sequence_source VALUES(1920,'KT249002.1',84,333,1,3);
INSERT INTO sequence_source VALUES(1921,'KT249003.1',84,749,1,3);
INSERT INTO sequence_source VALUES(1922,'KT249004.1',84,749,1,3);
INSERT INTO sequence_source VALUES(1923,'KT249005.1',84,749,1,3);
INSERT INTO sequence_source VALUES(1924,'KT249006.1',84,749,1,3);
INSERT INTO sequence_source VALUES(1925,'KT249007.1',84,749,1,3);
INSERT INTO sequence_source VALUES(1926,'KT249008.1',84,749,1,3);
INSERT INTO sequence_source VALUES(1927,'KT249009.1',84,749,1,3);
INSERT INTO sequence_source VALUES(1928,'KT249010.1',84,750,1,3);
INSERT INTO sequence_source VALUES(1929,'KT249011.1',84,750,1,3);
INSERT INTO sequence_source VALUES(1930,'KT249012.1',84,750,1,3);
INSERT INTO sequence_source VALUES(1931,'KT249013.1',84,751,1,3);
INSERT INTO sequence_source VALUES(1932,'KT249014.1',84,751,1,3);
INSERT INTO sequence_source VALUES(1933,'KT249015.1',84,751,1,3);
INSERT INTO sequence_source VALUES(1934,'KT249016.1',84,752,1,3);
INSERT INTO sequence_source VALUES(1935,'KT249017.1',84,341,1,3);
INSERT INTO sequence_source VALUES(1936,'KT249018.1',84,753,1,3);
INSERT INTO sequence_source VALUES(1937,'KT249019.1',84,753,1,3);
INSERT INTO sequence_source VALUES(1938,'KT249020.1',84,341,1,3);
INSERT INTO sequence_source VALUES(1939,'KT249021.1',84,5,1,3);
INSERT INTO sequence_source VALUES(1940,'KT249022.1',84,5,1,3);
INSERT INTO sequence_source VALUES(1941,'KT249023.1',84,5,1,3);
INSERT INTO sequence_source VALUES(1942,'KT249024.1',84,5,1,3);
INSERT INTO sequence_source VALUES(1943,'KT249025.1',84,5,1,3);
INSERT INTO sequence_source VALUES(1944,'KT249026.1',84,5,1,3);
INSERT INTO sequence_source VALUES(1945,'KT249027.1',84,5,1,3);
INSERT INTO sequence_source VALUES(1946,'KT249028.1',84,5,1,3);
INSERT INTO sequence_source VALUES(1947,'KT249029.1',84,5,1,3);
INSERT INTO sequence_source VALUES(1948,'KT249030.1',84,5,1,3);
INSERT INTO sequence_source VALUES(1949,'KT249031.1',84,5,1,3);
INSERT INTO sequence_source VALUES(1950,'KT249032.1',84,5,1,3);
INSERT INTO sequence_source VALUES(1951,'KT249033.1',84,5,1,3);
INSERT INTO sequence_source VALUES(1952,'KT249034.1',84,5,1,3);
INSERT INTO sequence_source VALUES(1953,'KT249035.1',84,5,1,3);
INSERT INTO sequence_source VALUES(1954,'KT249036.1',84,754,1,3);
INSERT INTO sequence_source VALUES(1955,'KT249037.1',84,754,1,3);
INSERT INTO sequence_source VALUES(1956,'KT249038.1',84,754,1,3);
INSERT INTO sequence_source VALUES(1957,'KT249039.1',84,754,1,3);
INSERT INTO sequence_source VALUES(1958,'KT249040.1',84,754,1,3);
INSERT INTO sequence_source VALUES(1959,'KT249041.1',84,755,1,3);
INSERT INTO sequence_source VALUES(1960,'KT249042.1',84,755,1,3);
INSERT INTO sequence_source VALUES(1961,'KT249043.1',84,755,1,3);
INSERT INTO sequence_source VALUES(1962,'KT249044.1',84,341,1,3);
INSERT INTO sequence_source VALUES(1963,'KT249045.1',84,341,1,3);
INSERT INTO sequence_source VALUES(1964,'KT249046.1',84,341,1,3);
INSERT INTO sequence_source VALUES(1965,'KT249047.1',84,341,1,3);
INSERT INTO sequence_source VALUES(1966,'KT249048.1',84,756,1,3);
INSERT INTO sequence_source VALUES(1967,'KT249049.1',84,756,1,3);
INSERT INTO sequence_source VALUES(1968,'KT249050.1',84,756,1,3);
INSERT INTO sequence_source VALUES(1969,'KT249051.1',84,756,1,3);
INSERT INTO sequence_source VALUES(1970,'KT249052.1',84,756,1,3);
INSERT INTO sequence_source VALUES(1971,'KT249053.1',84,756,1,3);
INSERT INTO sequence_source VALUES(1972,'KT249054.1',84,756,1,3);
INSERT INTO sequence_source VALUES(1973,'KT249055.1',84,756,1,3);
INSERT INTO sequence_source VALUES(1974,'KT249056.1',84,756,1,3);
INSERT INTO sequence_source VALUES(1975,'KT249057.1',84,756,1,3);
INSERT INTO sequence_source VALUES(1976,'KT249058.1',84,756,1,3);
INSERT INTO sequence_source VALUES(1977,'KT249059.1',84,756,1,3);
INSERT INTO sequence_source VALUES(1978,'KT249060.1',84,753,1,3);
INSERT INTO sequence_source VALUES(1979,'KT249061.1',84,753,1,3);
INSERT INTO sequence_source VALUES(1980,'KT249062.1',84,753,1,3);
INSERT INTO sequence_source VALUES(1981,'KT249063.1',84,753,1,3);
INSERT INTO sequence_source VALUES(1982,'KT249064.1',84,753,1,3);
INSERT INTO sequence_source VALUES(1983,'KT249065.1',84,341,1,3);
INSERT INTO sequence_source VALUES(1984,'KT249066.1',84,341,1,3);
INSERT INTO sequence_source VALUES(1985,'KT249067.1',84,341,1,3);
INSERT INTO sequence_source VALUES(1986,'KT249068.1',84,341,1,3);
INSERT INTO sequence_source VALUES(1987,'KT249069.1',84,341,1,3);
INSERT INTO sequence_source VALUES(1988,'KT249070.1',84,341,1,3);
INSERT INTO sequence_source VALUES(1989,'KT249071.1',84,341,1,3);
INSERT INTO sequence_source VALUES(1990,'KT249072.1',84,757,1,3);
INSERT INTO sequence_source VALUES(1991,'KT249073.1',84,5,1,3);
INSERT INTO sequence_source VALUES(1992,'KT249074.1',84,757,1,3);
INSERT INTO sequence_source VALUES(1993,'KT249075.1',84,757,1,3);
INSERT INTO sequence_source VALUES(1994,'KT249076.1',84,758,1,3);
INSERT INTO sequence_source VALUES(1995,'KT249077.1',84,758,1,3);
INSERT INTO sequence_source VALUES(1996,'KT249078.1',84,757,1,3);
INSERT INTO sequence_source VALUES(1997,'KT249079.1',84,758,1,3);
INSERT INTO sequence_source VALUES(1998,'KT249080.1',84,758,1,3);
INSERT INTO sequence_source VALUES(1999,'KT249081.1',84,758,1,3);
INSERT INTO sequence_source VALUES(2000,'KT249082.1',84,758,1,3);
INSERT INTO sequence_source VALUES(2001,'KT249083.1',84,757,1,3);
INSERT INTO sequence_source VALUES(2002,'KT249084.1',84,757,1,3);
INSERT INTO sequence_source VALUES(2003,'KT249085.1',84,757,1,3);
INSERT INTO sequence_source VALUES(2004,'KT249086.1',84,757,1,3);
INSERT INTO sequence_source VALUES(2005,'KT249087.1',84,757,1,3);
INSERT INTO sequence_source VALUES(2006,'KT249088.1',84,757,1,3);
INSERT INTO sequence_source VALUES(2007,'KT249089.1',84,757,1,3);
INSERT INTO sequence_source VALUES(2008,'KT249090.1',84,757,1,3);
INSERT INTO sequence_source VALUES(2009,'KT249091.1',84,757,1,3);
INSERT INTO sequence_source VALUES(2010,'KT249092.1',84,757,1,3);
INSERT INTO sequence_source VALUES(2011,'KT249093.1',84,757,1,3);
INSERT INTO sequence_source VALUES(2012,'KT249094.1',84,757,1,3);
INSERT INTO sequence_source VALUES(2013,'KT249095.1',84,757,1,3);
INSERT INTO sequence_source VALUES(2014,'KT249096.1',84,757,1,3);
INSERT INTO sequence_source VALUES(2015,'KT249097.1',84,757,1,3);
INSERT INTO sequence_source VALUES(2016,'KT249098.1',84,757,1,3);
INSERT INTO sequence_source VALUES(2017,'KT249099.1',84,5,1,3);
INSERT INTO sequence_source VALUES(2018,'KT249100.1',84,334,1,3);
INSERT INTO sequence_source VALUES(2019,'KT249101.1',84,754,1,3);
INSERT INTO sequence_source VALUES(2020,'KT249102.1',84,5,1,3);
INSERT INTO sequence_source VALUES(2021,'KT249103.1',84,759,1,3);
INSERT INTO sequence_source VALUES(2022,'KT249104.1',84,759,1,3);
INSERT INTO sequence_source VALUES(2023,'KT249105.1',84,331,1,34);
INSERT INTO sequence_source VALUES(2024,'KT249106.1',84,5,1,3);
INSERT INTO sequence_source VALUES(2025,'KT249107.1',84,5,1,3);
INSERT INTO sequence_source VALUES(2026,'KT249108.1',84,5,1,3);
INSERT INTO sequence_source VALUES(2027,'KT249109.1',84,760,1,3);
INSERT INTO sequence_source VALUES(2028,'KT249110.1',84,761,1,3);
INSERT INTO sequence_source VALUES(2029,'KT249111.1',84,762,1,3);
INSERT INTO sequence_source VALUES(2030,'KT249112.1',84,762,1,3);
INSERT INTO sequence_source VALUES(2031,'KT249113.1',84,761,1,3);
INSERT INTO sequence_source VALUES(2032,'KT249114.1',84,761,1,3);
INSERT INTO sequence_source VALUES(2033,'KT249115.1',84,297,1,3);
INSERT INTO sequence_source VALUES(2034,'KT249116.1',84,297,1,3);
INSERT INTO sequence_source VALUES(2035,'KT249117.1',84,763,1,3);
INSERT INTO sequence_source VALUES(2036,'KT249118.1',84,763,1,3);
INSERT INTO sequence_source VALUES(2037,'KT249119.1',84,763,1,3);
INSERT INTO sequence_source VALUES(2038,'KT249120.1',84,764,1,3);
INSERT INTO sequence_source VALUES(2039,'KT249121.1',84,764,1,3);
INSERT INTO sequence_source VALUES(2040,'KT249122.1',84,296,1,3);
INSERT INTO sequence_source VALUES(2041,'KT249123.1',84,296,1,3);
INSERT INTO sequence_source VALUES(2042,'KT249124.1',84,296,1,3);
INSERT INTO sequence_source VALUES(2043,'KT249125.1',84,757,1,3);
INSERT INTO sequence_source VALUES(2044,'KT249126.1',84,757,1,3);
INSERT INTO sequence_source VALUES(2045,'KT249127.1',84,765,1,3);
INSERT INTO sequence_source VALUES(2046,'KT249128.1',84,747,1,3);
INSERT INTO sequence_source VALUES(2047,'KT249129.1',84,341,1,3);
INSERT INTO sequence_source VALUES(2048,'KT249130.1',84,341,1,3);
INSERT INTO sequence_source VALUES(2049,'KT249131.1',84,341,1,3);
INSERT INTO sequence_source VALUES(2050,'KT249132.1',84,749,1,3);
INSERT INTO sequence_source VALUES(2051,'KT249133.1',84,749,1,3);
INSERT INTO sequence_source VALUES(2052,'KT249134.1',84,753,1,3);
INSERT INTO sequence_source VALUES(2053,'KT249135.1',84,756,1,3);
INSERT INTO sequence_source VALUES(2054,'KT249136.1',84,341,1,3);
INSERT INTO sequence_source VALUES(2055,'KT249137.1',84,341,1,3);
INSERT INTO sequence_source VALUES(2056,'KT249138.1',84,341,1,3);
INSERT INTO sequence_source VALUES(2057,'KT249139.1',84,766,1,3);
INSERT INTO sequence_source VALUES(2058,'KT249140.1',84,5,1,3);
INSERT INTO sequence_source VALUES(2059,'KT249141.1',84,341,1,3);
INSERT INTO sequence_source VALUES(2060,'KT249142.1',84,332,1,49);
INSERT INTO sequence_source VALUES(2061,'KT249143.1',84,329,1,39);
INSERT INTO sequence_source VALUES(2062,'KT250631.1',84,767,1,5);
INSERT INTO sequence_source VALUES(2063,'KT265813.1',84,13,1,5);
INSERT INTO sequence_source VALUES(2064,'KT265814.1',84,13,1,5);
INSERT INTO sequence_source VALUES(2065,'KT265815.1',84,13,1,5);
INSERT INTO sequence_source VALUES(2066,'KT285842.1',84,768,1,9);
INSERT INTO sequence_source VALUES(2067,'KT285843.1',84,768,1,9);
INSERT INTO sequence_source VALUES(2068,'KT306841.1',84,380,1,5);
INSERT INTO sequence_source VALUES(2069,'KT306842.1',84,168,1,5);
INSERT INTO sequence_source VALUES(2070,'KT306851.1',84,168,1,5);
INSERT INTO sequence_source VALUES(2071,'KT306860.1',84,281,1,5);
INSERT INTO sequence_source VALUES(2072,'KT306862.1',84,281,1,5);
INSERT INTO sequence_source VALUES(2073,'KT306869.1',84,311,1,5);
INSERT INTO sequence_source VALUES(2074,'KT306871.1',84,281,1,5);
INSERT INTO sequence_source VALUES(2075,'KT306874.1',84,281,1,5);
INSERT INTO sequence_source VALUES(2076,'KT306876.1',84,281,1,5);
INSERT INTO sequence_source VALUES(2077,'KT306877.1',84,311,1,5);
INSERT INTO sequence_source VALUES(2078,'KT306878.1',84,281,1,5);
INSERT INTO sequence_source VALUES(2079,'KT306879.1',84,281,1,5);
INSERT INTO sequence_source VALUES(2080,'KT306881.1',84,281,1,5);
INSERT INTO sequence_source VALUES(2081,'KT306888.1',84,311,1,5);
INSERT INTO sequence_source VALUES(2082,'KT306889.1',84,281,1,5);
INSERT INTO sequence_source VALUES(2083,'KT306890.1',84,281,1,5);
INSERT INTO sequence_source VALUES(2084,'KT306891.1',84,311,1,5);
INSERT INTO sequence_source VALUES(2085,'KT306892.1',84,281,1,5);
INSERT INTO sequence_source VALUES(2086,'KT306894.1',84,311,1,5);
INSERT INTO sequence_source VALUES(2087,'KT306900.1',84,281,1,5);
INSERT INTO sequence_source VALUES(2088,'KT306901.1',84,311,1,5);
INSERT INTO sequence_source VALUES(2089,'KT350498.1',84,311,1,5);
INSERT INTO sequence_source VALUES(2090,'KT350499.1',84,769,1,5);
INSERT INTO sequence_source VALUES(2091,'KT350500.2',84,41,1,5);
INSERT INTO sequence_source VALUES(2092,'KT361201.1',84,279,1,5);
INSERT INTO sequence_source VALUES(2093,'KT361202.1',84,279,1,5);
INSERT INTO sequence_source VALUES(2094,'KT363855.1',84,770,1,5);
INSERT INTO sequence_source VALUES(2095,'KT363858.1',84,11,1,5);
INSERT INTO sequence_source VALUES(2096,'KT363859.1',84,383,1,5);
INSERT INTO sequence_source VALUES(2097,'KT363860.1',84,11,1,5);
INSERT INTO sequence_source VALUES(2098,'KT363862.1',84,11,1,5);
INSERT INTO sequence_source VALUES(2099,'KT363863.1',84,11,1,5);
INSERT INTO sequence_source VALUES(2100,'KT363865.1',84,11,1,5);
INSERT INTO sequence_source VALUES(2101,'KT383038.2',84,20,1,5);
INSERT INTO sequence_source VALUES(2102,'KT383039.1',84,771,1,5);
INSERT INTO sequence_source VALUES(2103,'KT383040.2',84,772,1,5);
INSERT INTO sequence_source VALUES(2104,'KT383041.2',84,773,1,5);
INSERT INTO sequence_source VALUES(2105,'KT383042.1',84,20,1,5);
INSERT INTO sequence_source VALUES(2106,'KT383043.2',84,20,1,5);
INSERT INTO sequence_source VALUES(2107,'KT383044.2',84,20,1,5);
INSERT INTO sequence_source VALUES(2108,'KT383045.1',84,20,1,5);
INSERT INTO sequence_source VALUES(2109,'KT383046.1',84,20,1,5);
INSERT INTO sequence_source VALUES(2110,'KT383047.2',84,20,1,5);
INSERT INTO sequence_source VALUES(2111,'KT383048.1',84,313,1,5);
INSERT INTO sequence_source VALUES(2112,'KT383049.2',84,313,1,5);
INSERT INTO sequence_source VALUES(2113,'KT383050.1',84,313,1,5);
INSERT INTO sequence_source VALUES(2114,'KT383051.1',84,313,1,5);
INSERT INTO sequence_source VALUES(2115,'KT383052.1',84,313,1,5);
INSERT INTO sequence_source VALUES(2116,'KT383053.2',84,53,1,5);
INSERT INTO sequence_source VALUES(2117,'KT383054.2',84,53,1,5);
INSERT INTO sequence_source VALUES(2118,'KT383055.1',84,311,1,5);
INSERT INTO sequence_source VALUES(2119,'KT383056.1',84,311,1,5);
INSERT INTO sequence_source VALUES(2120,'KT383057.2',84,311,1,5);
INSERT INTO sequence_source VALUES(2121,'KT383058.1',84,311,1,5);
INSERT INTO sequence_source VALUES(2122,'KT383059.2',84,311,1,5);
INSERT INTO sequence_source VALUES(2123,'KT595686.1',84,774,1,55);
INSERT INTO sequence_source VALUES(2124,'KT722768.1',84,270,1,5);
INSERT INTO sequence_source VALUES(2125,'KT750954.1',84,250,1,55);
INSERT INTO sequence_source VALUES(2126,'KT826759.1',84,699,1,5);
INSERT INTO sequence_source VALUES(2127,'KT884525.1',84,775,1,5);
INSERT INTO sequence_source VALUES(2128,'KU161589.1',84,776,1,9);
INSERT INTO sequence_source VALUES(2129,'KU209127.1',84,777,1,55);
INSERT INTO sequence_source VALUES(2130,'KU210448.1',84,141,1,62);
INSERT INTO sequence_source VALUES(2131,'KU210450.1',84,78,1,5);
INSERT INTO sequence_source VALUES(2132,'KU210451.1',84,78,1,5);
INSERT INTO sequence_source VALUES(2133,'KU210452.1',84,78,1,5);
INSERT INTO sequence_source VALUES(2134,'KU210453.1',84,78,1,5);
INSERT INTO sequence_source VALUES(2135,'KU210454.1',84,778,1,6);
INSERT INTO sequence_source VALUES(2136,'KU210455.1',84,233,1,62);
INSERT INTO sequence_source VALUES(2137,'KU210456.1',84,779,1,62);
INSERT INTO sequence_source VALUES(2138,'KU210457.1',84,780,1,62);
INSERT INTO sequence_source VALUES(2139,'KU210458.1',84,781,1,62);
INSERT INTO sequence_source VALUES(2140,'KU210475.1',84,255,1,62);
INSERT INTO sequence_source VALUES(2141,'KU210477.1',84,782,1,62);
INSERT INTO sequence_source VALUES(2142,'KU210488.1',84,783,1,62);
INSERT INTO sequence_source VALUES(2143,'KU210524.1',84,233,1,62);
INSERT INTO sequence_source VALUES(2144,'KU210526.1',84,233,1,62);
INSERT INTO sequence_source VALUES(2145,'KU210544.1',84,784,1,62);
INSERT INTO sequence_source VALUES(2146,'KU210545.1',84,785,1,62);
INSERT INTO sequence_source VALUES(2147,'KU210555.1',84,786,1,5);
INSERT INTO sequence_source VALUES(2149,'KU210688.1',84,141,1,62);
INSERT INTO sequence_source VALUES(2150,'KU210689.1',84,233,1,62);
INSERT INTO sequence_source VALUES(2151,'KU210690.1',84,787,1,62);
INSERT INTO sequence_source VALUES(2152,'KU210691.1',84,233,1,62);
INSERT INTO sequence_source VALUES(2153,'KU210692.1',84,781,1,62);
INSERT INTO sequence_source VALUES(2154,'KU210693.1',84,233,1,62);
INSERT INTO sequence_source VALUES(2155,'KU210725.1',84,788,1,62);
INSERT INTO sequence_source VALUES(2156,'KU210726.1',84,785,1,62);
INSERT INTO sequence_source VALUES(2157,'KU210728.1',84,789,1,62);
INSERT INTO sequence_source VALUES(2158,'KU210729.1',84,790,1,62);
INSERT INTO sequence_source VALUES(2159,'KU210819.1',84,791,1,62);
INSERT INTO sequence_source VALUES(2160,'KU210820.1',84,233,1,62);
INSERT INTO sequence_source VALUES(2161,'KU210835.1',84,792,1,62);
INSERT INTO sequence_source VALUES(2162,'KU210947.1',84,78,1,5);
INSERT INTO sequence_source VALUES(2163,'KU210948.1',84,78,1,5);
INSERT INTO sequence_source VALUES(2164,'KU210950.1',84,793,1,62);
INSERT INTO sequence_source VALUES(2165,'KU210951.1',84,233,1,62);
INSERT INTO sequence_source VALUES(2166,'KU210952.1',84,523,1,62);
INSERT INTO sequence_source VALUES(2167,'KU210953.1',84,785,1,62);
INSERT INTO sequence_source VALUES(2168,'KU210954.1',84,794,1,62);
INSERT INTO sequence_source VALUES(2169,'KU210972.1',84,795,1,62);
INSERT INTO sequence_source VALUES(2170,'KU210973.1',84,796,1,62);
INSERT INTO sequence_source VALUES(2171,'KU210974.1',84,77,1,5);
INSERT INTO sequence_source VALUES(2172,'KU210976.1',84,797,1,62);
INSERT INTO sequence_source VALUES(2173,'KU210977.1',84,798,1,6);
INSERT INTO sequence_source VALUES(2174,'KU210978.1',84,300,1,62);
INSERT INTO sequence_source VALUES(2175,'KU210979.1',84,300,1,62);
INSERT INTO sequence_source VALUES(2176,'KU210980.1',84,300,1,62);
INSERT INTO sequence_source VALUES(2177,'KU210981.1',84,243,1,62);
INSERT INTO sequence_source VALUES(2178,'KU210983.1',84,799,1,62);
INSERT INTO sequence_source VALUES(2179,'KU210984.1',84,800,1,6);
INSERT INTO sequence_source VALUES(2180,'KU210998.1',84,796,1,62);
INSERT INTO sequence_source VALUES(2181,'KU210999.1',84,77,1,5);
INSERT INTO sequence_source VALUES(2182,'KU211000.1',84,78,1,5);
INSERT INTO sequence_source VALUES(2183,'KU211001.1',84,789,1,62);
INSERT INTO sequence_source VALUES(2184,'KU211003.1',84,796,1,62);
INSERT INTO sequence_source VALUES(2185,'KU211004.1',84,243,1,62);
INSERT INTO sequence_source VALUES(2186,'KU211005.1',84,783,1,62);
INSERT INTO sequence_source VALUES(2187,'KU211006.1',84,801,1,62);
INSERT INTO sequence_source VALUES(2188,'KU211007.1',84,800,1,6);
INSERT INTO sequence_source VALUES(2189,'KU211008.1',84,802,1,62);
INSERT INTO sequence_source VALUES(2190,'KU211080.1',84,803,1,5);
INSERT INTO sequence_source VALUES(2191,'KU211081.1',84,804,1,62);
INSERT INTO sequence_source VALUES(2192,'KU211082.1',84,805,1,56);
INSERT INTO sequence_source VALUES(2193,'KU211084.1',84,300,1,62);
INSERT INTO sequence_source VALUES(2194,'KU211085.1',84,806,1,62);
INSERT INTO sequence_source VALUES(2195,'KU211093.1',84,243,1,62);
INSERT INTO sequence_source VALUES(2196,'KU211094.1',84,807,1,62);
INSERT INTO sequence_source VALUES(2197,'KU211098.1',84,300,1,62);
INSERT INTO sequence_source VALUES(2198,'KU211242.1',84,808,1,5);
INSERT INTO sequence_source VALUES(2199,'KU211243.1',84,77,1,5);
INSERT INTO sequence_source VALUES(2200,'KU211244.1',84,300,1,62);
INSERT INTO sequence_source VALUES(2201,'KU211245.1',84,809,1,62);
INSERT INTO sequence_source VALUES(2202,'KU211246.1',84,810,1,62);
INSERT INTO sequence_source VALUES(2203,'KU211247.1',84,811,1,62);
INSERT INTO sequence_source VALUES(2204,'KU211248.1',84,77,1,5);
INSERT INTO sequence_source VALUES(2205,'KU211253.1',84,812,1,55);
INSERT INTO sequence_source VALUES(2206,'KU211259.1',84,813,1,5);
INSERT INTO sequence_source VALUES(2207,'KU211297.1',84,277,1,5);
INSERT INTO sequence_source VALUES(2208,'KU211304.1',84,277,1,5);
INSERT INTO sequence_source VALUES(2209,'KU211310.1',84,78,1,5);
INSERT INTO sequence_source VALUES(2210,'KU211312.1',84,78,1,5);
INSERT INTO sequence_source VALUES(2211,'KU211313.1',84,78,1,5);
INSERT INTO sequence_source VALUES(2212,'KU211314.1',84,78,1,5);
INSERT INTO sequence_source VALUES(2213,'KU211315.1',84,78,1,5);
INSERT INTO sequence_source VALUES(2214,'KU211316.1',84,77,1,5);
INSERT INTO sequence_source VALUES(2215,'KU211317.1',84,78,1,5);
INSERT INTO sequence_source VALUES(2216,'KU211318.1',84,78,1,5);
INSERT INTO sequence_source VALUES(2217,'KU211319.1',84,78,1,5);
INSERT INTO sequence_source VALUES(2218,'KU211320.1',84,78,1,5);
INSERT INTO sequence_source VALUES(2219,'KU211321.1',84,78,1,5);
INSERT INTO sequence_source VALUES(2220,'KU211322.1',84,78,1,5);
INSERT INTO sequence_source VALUES(2221,'KU211323.1',84,78,1,5);
INSERT INTO sequence_source VALUES(2222,'KU211324.1',84,78,1,5);
INSERT INTO sequence_source VALUES(2223,'KU211325.1',84,78,1,5);
INSERT INTO sequence_source VALUES(2224,'KU211326.1',84,78,1,5);
INSERT INTO sequence_source VALUES(2225,'KU211327.1',84,78,1,5);
INSERT INTO sequence_source VALUES(2226,'KU211328.1',84,78,1,5);
INSERT INTO sequence_source VALUES(2227,'KU211329.1',84,78,1,5);
INSERT INTO sequence_source VALUES(2228,'KU211330.1',84,78,1,5);
INSERT INTO sequence_source VALUES(2229,'KU211331.1',84,77,1,5);
INSERT INTO sequence_source VALUES(2230,'KU211332.1',84,78,1,5);
INSERT INTO sequence_source VALUES(2231,'KU211334.1',84,78,1,5);
INSERT INTO sequence_source VALUES(2232,'KU211335.1',84,78,1,5);
INSERT INTO sequence_source VALUES(2233,'KU211336.1',84,78,1,5);
INSERT INTO sequence_source VALUES(2234,'KU211337.1',84,78,1,5);
INSERT INTO sequence_source VALUES(2235,'KU211339.1',84,78,1,5);
INSERT INTO sequence_source VALUES(2236,'KU211340.1',84,78,1,5);
INSERT INTO sequence_source VALUES(2237,'KU211341.1',84,78,1,5);
INSERT INTO sequence_source VALUES(2238,'KU211342.1',84,78,1,5);
INSERT INTO sequence_source VALUES(2239,'KU211343.1',84,814,1,5);
INSERT INTO sequence_source VALUES(2240,'KU211344.1',84,78,1,5);
INSERT INTO sequence_source VALUES(2241,'KU211345.1',84,78,1,5);
INSERT INTO sequence_source VALUES(2242,'KU211346.1',84,78,1,5);
INSERT INTO sequence_source VALUES(2243,'KU211347.1',84,78,1,5);
INSERT INTO sequence_source VALUES(2244,'KU211348.1',84,78,1,5);
INSERT INTO sequence_source VALUES(2245,'KU211351.1',84,815,1,5);
INSERT INTO sequence_source VALUES(2246,'KU211353.1',84,77,1,5);
INSERT INTO sequence_source VALUES(2247,'KU211354.1',84,233,1,62);
INSERT INTO sequence_source VALUES(2248,'KU211355.1',84,77,1,5);
INSERT INTO sequence_source VALUES(2249,'KU211356.1',84,78,1,5);
INSERT INTO sequence_source VALUES(2250,'KU211357.1',84,812,1,55);
INSERT INTO sequence_source VALUES(2251,'KU211358.1',84,816,1,62);
INSERT INTO sequence_source VALUES(2252,'KU211359.1',84,817,1,62);
INSERT INTO sequence_source VALUES(2253,'KU211360.1',84,785,1,62);
INSERT INTO sequence_source VALUES(2254,'KU211361.1',84,817,1,62);
INSERT INTO sequence_source VALUES(2255,'KU211362.1',84,818,1,5);
INSERT INTO sequence_source VALUES(2256,'KU211363.1',84,802,1,62);
INSERT INTO sequence_source VALUES(2257,'KU211374.1',84,819,1,62);
INSERT INTO sequence_source VALUES(2258,'KU211392.1',84,820,1,62);
INSERT INTO sequence_source VALUES(2259,'KU211402.1',84,821,1,62);
INSERT INTO sequence_source VALUES(2260,'KU211403.1',84,77,1,5);
INSERT INTO sequence_source VALUES(2261,'KU211404.1',84,78,1,5);
INSERT INTO sequence_source VALUES(2262,'KU211405.1',84,77,1,5);
INSERT INTO sequence_source VALUES(2263,'KU211406.1',84,77,1,5);
INSERT INTO sequence_source VALUES(2264,'KU211407.1',84,77,1,5);
INSERT INTO sequence_source VALUES(2265,'KU211408.1',84,77,1,5);
INSERT INTO sequence_source VALUES(2266,'KU211409.1',84,77,1,5);
INSERT INTO sequence_source VALUES(2267,'KU211410.1',84,796,1,62);
INSERT INTO sequence_source VALUES(2268,'KU211411.1',84,77,1,5);
INSERT INTO sequence_source VALUES(2269,'KU211412.1',84,78,1,5);
INSERT INTO sequence_source VALUES(2270,'KU211413.1',84,300,1,62);
INSERT INTO sequence_source VALUES(2271,'KU211414.1',84,822,1,62);
INSERT INTO sequence_source VALUES(2272,'KU211415.1',84,725,1,62);
INSERT INTO sequence_source VALUES(2273,'KU211417.1',84,260,1,62);
INSERT INTO sequence_source VALUES(2274,'KU211419.1',84,823,1,62);
INSERT INTO sequence_source VALUES(2275,'KU211420.1',84,783,1,62);
INSERT INTO sequence_source VALUES(2276,'KU211421.1',84,243,1,62);
INSERT INTO sequence_source VALUES(2277,'KU211423.1',84,824,1,62);
INSERT INTO sequence_source VALUES(2278,'KU211424.1',84,243,1,62);
INSERT INTO sequence_source VALUES(2279,'KU211425.1',84,243,1,62);
INSERT INTO sequence_source VALUES(2280,'KU211426.1',84,825,1,62);
INSERT INTO sequence_source VALUES(2281,'KU211427.1',84,243,1,62);
INSERT INTO sequence_source VALUES(2282,'KU211428.1',84,826,1,62);
INSERT INTO sequence_source VALUES(2283,'KU211429.1',84,827,1,62);
INSERT INTO sequence_source VALUES(2284,'KU211430.1',84,828,1,62);
INSERT INTO sequence_source VALUES(2285,'KU211431.1',84,528,1,62);
INSERT INTO sequence_source VALUES(2286,'KU211432.1',84,829,1,6);
INSERT INTO sequence_source VALUES(2287,'KU211433.1',84,830,1,62);
INSERT INTO sequence_source VALUES(2288,'KU211434.1',84,802,1,62);
INSERT INTO sequence_source VALUES(2289,'KU211435.1',84,831,1,62);
INSERT INTO sequence_source VALUES(2290,'KU211436.1',84,802,1,62);
INSERT INTO sequence_source VALUES(2291,'KU211437.1',84,802,1,62);
INSERT INTO sequence_source VALUES(2292,'KU211438.1',84,528,1,62);
INSERT INTO sequence_source VALUES(2293,'KU211456.1',84,832,1,62);
INSERT INTO sequence_source VALUES(2294,'KU211465.1',84,141,1,62);
INSERT INTO sequence_source VALUES(2295,'KU211466.1',84,64,1,5);
INSERT INTO sequence_source VALUES(2296,'KU211468.1',84,833,1,62);
INSERT INTO sequence_source VALUES(2297,'KU211469.1',84,64,1,5);
INSERT INTO sequence_source VALUES(2298,'KU211471.1',84,798,1,6);
INSERT INTO sequence_source VALUES(2299,'KU211474.1',84,796,1,62);
INSERT INTO sequence_source VALUES(2300,'KU211475.1',84,796,1,62);
INSERT INTO sequence_source VALUES(2301,'KU211476.1',84,834,1,62);
INSERT INTO sequence_source VALUES(2302,'KU211478.1',84,835,1,62);
INSERT INTO sequence_source VALUES(2303,'KU211479.1',84,836,1,62);
INSERT INTO sequence_source VALUES(2304,'KU211481.1',84,782,1,62);
INSERT INTO sequence_source VALUES(2305,'KU211482.1',84,300,1,62);
INSERT INTO sequence_source VALUES(2306,'KU211483.1',84,837,1,62);
INSERT INTO sequence_source VALUES(2307,'KU211484.1',84,838,1,62);
INSERT INTO sequence_source VALUES(2308,'KU211485.1',84,243,1,62);
INSERT INTO sequence_source VALUES(2309,'KU211486.1',84,839,1,6);
INSERT INTO sequence_source VALUES(2310,'KU211487.1',84,233,1,62);
INSERT INTO sequence_source VALUES(2311,'KU211488.1',84,233,1,62);
INSERT INTO sequence_source VALUES(2312,'KU211489.1',84,840,1,62);
INSERT INTO sequence_source VALUES(2313,'KU211490.1',84,841,1,62);
INSERT INTO sequence_source VALUES(2314,'KU211491.1',84,781,1,62);
INSERT INTO sequence_source VALUES(2315,'KU211492.1',84,810,1,62);
INSERT INTO sequence_source VALUES(2316,'KU211493.1',84,842,1,62);
INSERT INTO sequence_source VALUES(2317,'KU211494.1',84,802,1,62);
INSERT INTO sequence_source VALUES(2318,'KU211500.1',84,77,1,5);
INSERT INTO sequence_source VALUES(2319,'KU211501.1',84,843,1,62);
INSERT INTO sequence_source VALUES(2320,'KU221328.1',84,311,1,5);
INSERT INTO sequence_source VALUES(2321,'KU310651.1',84,669,1,5);
INSERT INTO sequence_source VALUES(2322,'KU310652.1',84,669,1,5);
INSERT INTO sequence_source VALUES(2323,'KU310653.1',84,669,1,5);
INSERT INTO sequence_source VALUES(2324,'KU518776.1',84,598,1,5);
INSERT INTO sequence_source VALUES(2325,'KU518777.1',84,598,1,5);
INSERT INTO sequence_source VALUES(2326,'KU518778.1',84,598,1,5);
INSERT INTO sequence_source VALUES(2327,'KU518779.1',84,626,1,5);
INSERT INTO sequence_source VALUES(2328,'KU518780.1',84,627,1,5);
INSERT INTO sequence_source VALUES(2329,'KU518781.1',84,598,1,5);
INSERT INTO sequence_source VALUES(2330,'KU518782.1',84,598,1,5);
INSERT INTO sequence_source VALUES(2331,'KU518783.1',84,598,1,5);
INSERT INTO sequence_source VALUES(2332,'KU518784.1',84,626,1,5);
INSERT INTO sequence_source VALUES(2333,'KU518785.1',84,627,1,5);
INSERT INTO sequence_source VALUES(2334,'KU518786.1',84,619,1,5);
INSERT INTO sequence_source VALUES(2335,'KU518787.1',84,620,1,5);
INSERT INTO sequence_source VALUES(2336,'KU518788.1',84,844,1,5);
INSERT INTO sequence_source VALUES(2337,'KU518789.1',84,623,1,5);
INSERT INTO sequence_source VALUES(2338,'KU518790.1',84,624,1,5);
INSERT INTO sequence_source VALUES(2339,'KU518791.1',84,624,1,5);
INSERT INTO sequence_source VALUES(2340,'KU518792.1',84,624,1,5);
INSERT INTO sequence_source VALUES(2341,'KU518793.1',84,624,1,5);
INSERT INTO sequence_source VALUES(2342,'KU518794.1',84,624,1,5);
INSERT INTO sequence_source VALUES(2343,'KU518795.1',84,628,1,5);
INSERT INTO sequence_source VALUES(2344,'KU518797.1',84,845,1,5);
INSERT INTO sequence_source VALUES(2345,'KU518798.1',84,632,1,5);
INSERT INTO sequence_source VALUES(2346,'KU518799.1',84,624,1,5);
INSERT INTO sequence_source VALUES(2347,'KU518800.1',84,633,1,5);
INSERT INTO sequence_source VALUES(2348,'KU518801.1',84,634,1,5);
INSERT INTO sequence_source VALUES(2349,'KU518802.1',84,846,1,5);
INSERT INTO sequence_source VALUES(2350,'KU518805.1',84,637,1,5);
INSERT INTO sequence_source VALUES(2351,'KU518806.1',84,638,1,5);
INSERT INTO sequence_source VALUES(2352,'KU645759.1',84,270,1,5);
INSERT INTO sequence_source VALUES(2353,'KU682560.1',84,50,1,5);
INSERT INTO sequence_source VALUES(2354,'KU682562.1',84,847,1,5);
INSERT INTO sequence_source VALUES(2355,'KU682567.1',84,13,1,5);
INSERT INTO sequence_source VALUES(2356,'KU682568.1',84,13,1,5);
INSERT INTO sequence_source VALUES(2357,'KU682569.1',84,306,1,5);
INSERT INTO sequence_source VALUES(2358,'KU682571.1',84,219,1,5);
INSERT INTO sequence_source VALUES(2359,'KU682577.1',84,682,1,5);
INSERT INTO sequence_source VALUES(2360,'KU682578.1',84,848,1,5);
INSERT INTO sequence_source VALUES(2361,'KU682579.1',84,849,1,5);
INSERT INTO sequence_source VALUES(2362,'KU682580.1',84,270,1,5);
INSERT INTO sequence_source VALUES(2363,'KU682582.1',84,177,1,5);
INSERT INTO sequence_source VALUES(2364,'KU682584.1',84,850,1,5);
INSERT INTO sequence_source VALUES(2365,'KU682603.1',84,851,1,5);
INSERT INTO sequence_source VALUES(2366,'KU682604.1',84,852,1,5);
INSERT INTO sequence_source VALUES(2367,'KU682605.1',84,853,1,5);
INSERT INTO sequence_source VALUES(2368,'KU682609.1',84,854,1,5);
INSERT INTO sequence_source VALUES(2370,'KU715057.1',84,855,1,6);
INSERT INTO sequence_source VALUES(2371,'KU715059.1',84,856,1,6);
INSERT INTO sequence_source VALUES(2372,'KU715060.1',84,857,1,6);
INSERT INTO sequence_source VALUES(2373,'KU715062.1',84,857,1,6);
INSERT INTO sequence_source VALUES(2374,'KU715063.1',84,857,1,6);
INSERT INTO sequence_source VALUES(2375,'KU948930.1',84,858,1,9);
INSERT INTO sequence_source VALUES(2376,'KU961895.1',84,859,1,55);
INSERT INTO sequence_source VALUES(2377,'KU961897.1',84,13,1,5);
INSERT INTO sequence_source VALUES(2378,'KU961898.1',84,13,1,5);
INSERT INTO sequence_source VALUES(2379,'KU961899.1',84,553,1,55);
INSERT INTO sequence_source VALUES(2380,'KU961900.1',84,553,1,55);
INSERT INTO sequence_source VALUES(2381,'KU961902.1',84,306,1,5);
INSERT INTO sequence_source VALUES(2382,'KU961903.1',84,553,1,55);
INSERT INTO sequence_source VALUES(2383,'KU961904.1',84,306,1,5);
INSERT INTO sequence_source VALUES(2384,'KU961905.1',84,859,1,55);
INSERT INTO sequence_source VALUES(2385,'KU961906.1',84,13,1,5);
INSERT INTO sequence_source VALUES(2386,'KU961907.1',84,13,1,5);
INSERT INTO sequence_source VALUES(2387,'KU961908.1',84,64,1,5);
INSERT INTO sequence_source VALUES(2388,'KX090410.1',84,552,1,62);
INSERT INTO sequence_source VALUES(2389,'KX118438.1',84,860,1,9);
INSERT INTO sequence_source VALUES(2390,'KX231682.1',84,861,1,35);
INSERT INTO sequence_source VALUES(2391,'KX257260.1',84,279,1,5);
INSERT INTO sequence_source VALUES(2392,'KX371899.1',84,265,1,5);
INSERT INTO sequence_source VALUES(2393,'KX371900.1',84,862,1,5);
INSERT INTO sequence_source VALUES(2394,'KX423736.1',84,316,1,5);
INSERT INTO sequence_source VALUES(2395,'KX423737.1',84,316,1,5);
INSERT INTO sequence_source VALUES(2396,'KX423738.1',84,316,1,5);
INSERT INTO sequence_source VALUES(2397,'KX618503.1',84,311,1,5);
INSERT INTO sequence_source VALUES(2398,'KX618504.1',84,311,1,5);
INSERT INTO sequence_source VALUES(2399,'KX683285.1',84,382,1,5);
INSERT INTO sequence_source VALUES(2400,'KX822120.1',84,416,1,9);
INSERT INTO sequence_source VALUES(2401,'KX844996.1',84,20,1,5);
INSERT INTO sequence_source VALUES(2402,'KX844997.1',84,311,1,5);
INSERT INTO sequence_source VALUES(2403,'KX844998.1',84,46,1,5);
INSERT INTO sequence_source VALUES(2404,'KX844999.1',84,67,1,5);
INSERT INTO sequence_source VALUES(2405,'KX845000.1',84,13,1,5);
INSERT INTO sequence_source VALUES(2406,'KX845001.1',84,26,1,5);
INSERT INTO sequence_source VALUES(2407,'KX845002.1',84,669,1,5);
INSERT INTO sequence_source VALUES(2408,'KX845003.1',84,863,1,62);
INSERT INTO sequence_source VALUES(2409,'KX845004.1',84,224,1,61);
INSERT INTO sequence_source VALUES(2410,'KX869911.1',84,864,1,62);
INSERT INTO sequence_source VALUES(2411,'KX906603.1',84,46,1,5);
INSERT INTO sequence_source VALUES(2412,'KX925551.1',84,865,1,5);
INSERT INTO sequence_source VALUES(2413,'KX925552.1',84,176,1,5);
INSERT INTO sequence_source VALUES(2414,'KY197718.1',84,866,1,5);
INSERT INTO sequence_source VALUES(2415,'KY197719.1',84,867,1,5);
INSERT INTO sequence_source VALUES(2416,'KY197720.1',84,868,1,5);
INSERT INTO sequence_source VALUES(2417,'KY197721.1',84,477,1,5);
INSERT INTO sequence_source VALUES(2418,'KY197722.1',84,477,1,5);
INSERT INTO sequence_source VALUES(2419,'KY197723.1',84,869,1,5);
INSERT INTO sequence_source VALUES(2420,'KY322141.1',84,870,1,5);
INSERT INTO sequence_source VALUES(2421,'KY322142.1',84,871,1,5);
INSERT INTO sequence_source VALUES(2422,'KY447326.1',84,425,1,5);
INSERT INTO sequence_source VALUES(2423,'KY475615.1',84,477,1,5);
INSERT INTO sequence_source VALUES(2424,'KY475616.1',84,477,1,5);
INSERT INTO sequence_source VALUES(2425,'KY475617.1',84,477,1,5);
INSERT INTO sequence_source VALUES(2426,'KY475618.1',84,477,1,5);
INSERT INTO sequence_source VALUES(2427,'KY475619.1',84,477,1,5);
INSERT INTO sequence_source VALUES(2428,'KY475620.1',84,477,1,5);
INSERT INTO sequence_source VALUES(2429,'KY475621.1',84,477,1,5);
INSERT INTO sequence_source VALUES(2430,'KY475622.1',84,872,1,5);
INSERT INTO sequence_source VALUES(2431,'KY475623.1',84,873,1,5);
INSERT INTO sequence_source VALUES(2432,'KY475624.1',84,874,1,5);
INSERT INTO sequence_source VALUES(2433,'KY475625.1',84,477,1,5);
INSERT INTO sequence_source VALUES(2434,'KY475626.1',84,875,1,5);
INSERT INTO sequence_source VALUES(2435,'KY475627.1',84,477,1,5);
INSERT INTO sequence_source VALUES(2436,'KY475628.1',84,477,1,5);
INSERT INTO sequence_source VALUES(2437,'KY475629.1',84,477,1,5);
INSERT INTO sequence_source VALUES(2438,'KY475630.1',84,477,1,5);
INSERT INTO sequence_source VALUES(2439,'KY475631.1',84,477,1,5);
INSERT INTO sequence_source VALUES(2440,'KY475632.1',84,477,1,5);
INSERT INTO sequence_source VALUES(2441,'KY475633.1',84,477,1,5);
INSERT INTO sequence_source VALUES(2442,'KY475634.1',84,869,1,5);
INSERT INTO sequence_source VALUES(2443,'KY490699.1',84,876,1,5);
INSERT INTO sequence_source VALUES(2444,'KY575676.1',84,877,1,5);
INSERT INTO sequence_source VALUES(2445,'KY747521.1',84,812,1,55);
INSERT INTO sequence_source VALUES(2446,'KY751715.1',84,878,1,5);
INSERT INTO sequence_source VALUES(2447,'KY751716.1',84,878,1,5);
INSERT INTO sequence_source VALUES(2448,'KY785379.1',84,879,1,6);
INSERT INTO sequence_source VALUES(2451,'KY785385.1',84,880,1,6);
INSERT INTO sequence_source VALUES(2452,'KY785395.1',84,881,1,6);
INSERT INTO sequence_source VALUES(2453,'KY930644.1',84,584,1,5);
INSERT INTO sequence_source VALUES(2454,'LC028389.1',84,882,1,62);
INSERT INTO sequence_source VALUES(2455,'LC028390.1',84,883,1,62);
INSERT INTO sequence_source VALUES(2456,'LC028391.1',84,884,1,62);
INSERT INTO sequence_source VALUES(2457,'LC076471.1',84,885,1,5);
INSERT INTO sequence_source VALUES(2458,'LC556017.1',84,886,1,6);
INSERT INTO sequence_source VALUES(2459,'LC684531.1',84,739,1,55);
INSERT INTO sequence_source VALUES(2460,'LC684532.1',84,887,1,62);
INSERT INTO sequence_source VALUES(2461,'LC684533.1',84,888,1,6);
INSERT INTO sequence_source VALUES(2462,'LC684535.1',84,889,1,6);
INSERT INTO sequence_source VALUES(2463,'LC684539.1',84,890,1,6);
INSERT INTO sequence_source VALUES(2464,'LC684546.1',84,739,1,55);
INSERT INTO sequence_source VALUES(2465,'LC684549.1',84,887,1,62);
INSERT INTO sequence_source VALUES(2466,'LC684551.1',84,739,1,6);
INSERT INTO sequence_source VALUES(2467,'LC684552.1',84,739,1,6);
INSERT INTO sequence_source VALUES(2468,'LC684553.1',84,891,1,55);
INSERT INTO sequence_source VALUES(2469,'LC684554.1',84,739,1,6);
INSERT INTO sequence_source VALUES(2470,'LC684555.1',84,892,1,62);
INSERT INTO sequence_source VALUES(2471,'LC684560.1',84,887,1,62);
INSERT INTO sequence_source VALUES(2472,'LC684561.1',84,893,1,55);
INSERT INTO sequence_source VALUES(2473,'LC684562.1',84,894,1,55);
INSERT INTO sequence_source VALUES(2474,'LC684563.1',84,242,1,62);
INSERT INTO sequence_source VALUES(2475,'LM650992.1',84,60,1,5);
INSERT INTO sequence_source VALUES(2476,'LM650997.1',84,176,1,5);
INSERT INTO sequence_source VALUES(2477,'LM650998.1',84,176,1,5);
INSERT INTO sequence_source VALUES(2478,'LM650999.1',84,176,1,5);
INSERT INTO sequence_source VALUES(2479,'LM651001.1',84,176,1,5);
INSERT INTO sequence_source VALUES(2480,'LM651003.1',84,176,1,5);
INSERT INTO sequence_source VALUES(2481,'LM651011.1',84,475,1,55);
INSERT INTO sequence_source VALUES(2482,'LM651012.1',84,553,1,55);
INSERT INTO sequence_source VALUES(2483,'LR535923.1',84,477,1,5);
INSERT INTO sequence_source VALUES(2484,'LS479175.1',84,895,1,5);
INSERT INTO sequence_source VALUES(2485,'LS479896.1',84,895,1,5);
INSERT INTO sequence_source VALUES(2486,'LS999935.1',84,896,1,5);
INSERT INTO sequence_source VALUES(2487,'LT628537.1',84,897,1,5);
INSERT INTO sequence_source VALUES(2488,'LT628538.1',84,898,1,5);
INSERT INTO sequence_source VALUES(2489,'LT628539.1',84,898,1,5);
INSERT INTO sequence_source VALUES(2490,'LT670911.1',84,551,1,62);
INSERT INTO sequence_source VALUES(2491,'LT670914.1',84,899,1,5);
INSERT INTO sequence_source VALUES(2492,'LT707525.1',84,177,1,5);
INSERT INTO sequence_source VALUES(2493,'LT707526.1',84,177,1,5);
INSERT INTO sequence_source VALUES(2494,'LT707527.1',84,721,1,5);
INSERT INTO sequence_source VALUES(2495,'LT707528.1',84,900,1,5);
INSERT INTO sequence_source VALUES(2496,'LT707529.1',84,900,1,5);
INSERT INTO sequence_source VALUES(2497,'LT707530.1',84,901,1,5);
INSERT INTO sequence_source VALUES(2498,'LT707531.1',84,902,1,5);
INSERT INTO sequence_source VALUES(2499,'LT707535.1',84,29,1,5);
INSERT INTO sequence_source VALUES(2500,'LT707536.1',84,29,1,5);
INSERT INTO sequence_source VALUES(2501,'LT707537.1',84,29,1,5);
INSERT INTO sequence_source VALUES(2502,'LT707538.1',84,417,1,5);
INSERT INTO sequence_source VALUES(2503,'LT707539.1',84,900,1,5);
INSERT INTO sequence_source VALUES(2504,'LT707540.1',84,29,1,5);
INSERT INTO sequence_source VALUES(2505,'MF034088.1',84,903,1,5);
INSERT INTO sequence_source VALUES(2506,'MF034089.1',84,904,1,5);
INSERT INTO sequence_source VALUES(2507,'MF034090.1',84,905,1,5);
INSERT INTO sequence_source VALUES(2508,'MF034091.1',84,906,1,5);
INSERT INTO sequence_source VALUES(2509,'MF034092.1',84,907,1,5);
INSERT INTO sequence_source VALUES(2510,'MF034093.1',84,907,1,5);
INSERT INTO sequence_source VALUES(2511,'MF034094.1',84,907,1,5);
INSERT INTO sequence_source VALUES(2512,'MF034095.1',84,907,1,5);
INSERT INTO sequence_source VALUES(2513,'MF034096.1',84,908,1,5);
INSERT INTO sequence_source VALUES(2514,'MF094304.1',84,418,1,5);
INSERT INTO sequence_source VALUES(2515,'MF138883.1',84,909,1,5);
INSERT INTO sequence_source VALUES(2516,'MF138884.1',84,909,1,5);
INSERT INTO sequence_source VALUES(2517,'MF149917.1',84,277,1,5);
INSERT INTO sequence_source VALUES(2518,'MF155576.1',84,36,1,5);
INSERT INTO sequence_source VALUES(2519,'MF319537.1',84,910,1,9);
INSERT INTO sequence_source VALUES(2520,'MF356294.1',84,155,1,5);
INSERT INTO sequence_source VALUES(2521,'MF356295.1',84,155,1,5);
INSERT INTO sequence_source VALUES(2522,'MF356296.1',84,155,1,5);
INSERT INTO sequence_source VALUES(2523,'MF356297.1',84,155,1,5);
INSERT INTO sequence_source VALUES(2524,'MF370566.1',84,60,1,5);
INSERT INTO sequence_source VALUES(2525,'MF370567.1',84,60,1,5);
INSERT INTO sequence_source VALUES(2526,'MF370572.1',84,696,1,5);
INSERT INTO sequence_source VALUES(2527,'MF370574.1',84,898,1,5);
INSERT INTO sequence_source VALUES(2528,'MF370575.1',84,898,1,5);
INSERT INTO sequence_source VALUES(2529,'MF372422.1',84,911,1,9);
INSERT INTO sequence_source VALUES(2530,'MF372507.1',84,912,1,9);
INSERT INTO sequence_source VALUES(2531,'MF372740.1',84,913,1,4);
INSERT INTO sequence_source VALUES(2532,'MF372741.1',84,914,1,4);
INSERT INTO sequence_source VALUES(2533,'MF372742.1',84,670,1,4);
INSERT INTO sequence_source VALUES(2534,'MF372743.1',84,914,1,4);
INSERT INTO sequence_source VALUES(2535,'MF372744.1',84,914,1,4);
INSERT INTO sequence_source VALUES(2536,'MF372745.1',84,914,1,4);
INSERT INTO sequence_source VALUES(2537,'MF372746.1',84,914,1,4);
INSERT INTO sequence_source VALUES(2538,'MF372747.1',84,915,1,4);
INSERT INTO sequence_source VALUES(2539,'MF372748.1',84,914,1,4);
INSERT INTO sequence_source VALUES(2540,'MF372749.1',84,914,1,4);
INSERT INTO sequence_source VALUES(2541,'MF372750.1',84,916,1,4);
INSERT INTO sequence_source VALUES(2542,'MF459634.1',84,917,1,55);
INSERT INTO sequence_source VALUES(2543,'MF459635.1',84,917,1,55);
INSERT INTO sequence_source VALUES(2544,'MF459636.1',84,917,1,55);
INSERT INTO sequence_source VALUES(2545,'MF680415.1',84,898,1,5);
INSERT INTO sequence_source VALUES(2546,'MF693893.1',84,918,1,5);
INSERT INTO sequence_source VALUES(2547,'MF693894.1',84,162,1,9);
INSERT INTO sequence_source VALUES(2548,'MF693895.1',84,162,1,9);
INSERT INTO sequence_source VALUES(2549,'MF693896.1',84,919,1,9);
INSERT INTO sequence_source VALUES(2550,'MF693898.1',84,920,1,9);
INSERT INTO sequence_source VALUES(2551,'MF693899.1',84,5,1,3);
INSERT INTO sequence_source VALUES(2552,'MF693900.1',84,757,1,3);
INSERT INTO sequence_source VALUES(2553,'MF919631.1',84,921,1,62);
INSERT INTO sequence_source VALUES(2554,'MF959532.1',84,403,1,5);
INSERT INTO sequence_source VALUES(2555,'MF980709.1',84,922,1,5);
INSERT INTO sequence_source VALUES(2556,'MF980710.1',84,923,1,5);
INSERT INTO sequence_source VALUES(2557,'MF984123.1',84,924,1,6);
INSERT INTO sequence_source VALUES(2558,'MF984124.1',84,924,1,6);
INSERT INTO sequence_source VALUES(2559,'MF984125.1',84,924,1,6);
INSERT INTO sequence_source VALUES(2560,'MF984133.1',84,925,1,62);
INSERT INTO sequence_source VALUES(2561,'MF984192.1',84,251,1,55);
INSERT INTO sequence_source VALUES(2562,'MF984193.1',84,251,1,55);
INSERT INTO sequence_source VALUES(2563,'MG434772.1',84,60,1,5);
INSERT INTO sequence_source VALUES(2564,'MG523188.1',84,313,1,5);
INSERT INTO sequence_source VALUES(2565,'MG543911.1',84,926,1,5);
INSERT INTO sequence_source VALUES(2566,'MG543912.1',84,927,1,5);
INSERT INTO sequence_source VALUES(2567,'MG547776.1',84,313,1,5);
INSERT INTO sequence_source VALUES(2568,'MG547777.1',84,928,1,5);
INSERT INTO sequence_source VALUES(2569,'MG547778.1',84,313,1,5);
INSERT INTO sequence_source VALUES(2570,'MG547779.1',84,927,1,5);
INSERT INTO sequence_source VALUES(2571,'MG547780.1',84,313,1,5);
INSERT INTO sequence_source VALUES(2572,'MG547781.1',84,313,1,5);
INSERT INTO sequence_source VALUES(2573,'MG547784.1',84,313,1,5);
INSERT INTO sequence_source VALUES(2574,'MG547786.1',84,313,1,5);
INSERT INTO sequence_source VALUES(2575,'MG547787.1',84,313,1,5);
INSERT INTO sequence_source VALUES(2576,'MG547788.1',84,926,1,5);
INSERT INTO sequence_source VALUES(2577,'MG547789.1',84,929,1,5);
INSERT INTO sequence_source VALUES(2578,'MG547790.1',84,313,1,5);
INSERT INTO sequence_source VALUES(2579,'MG547792.1',84,313,1,5);
INSERT INTO sequence_source VALUES(2580,'MG547793.1',84,929,1,5);
INSERT INTO sequence_source VALUES(2581,'MG547794.1',84,907,1,5);
INSERT INTO sequence_source VALUES(2582,'MG547795.1',84,926,1,5);
INSERT INTO sequence_source VALUES(2583,'MG547796.1',84,313,1,5);
INSERT INTO sequence_source VALUES(2584,'MG547797.1',84,313,1,5);
INSERT INTO sequence_source VALUES(2585,'MG547798.1',84,313,1,5);
INSERT INTO sequence_source VALUES(2586,'MG547799.1',84,313,1,5);
INSERT INTO sequence_source VALUES(2587,'MG547800.1',84,313,1,5);
INSERT INTO sequence_source VALUES(2588,'MG547801.1',84,313,1,5);
INSERT INTO sequence_source VALUES(2589,'MG547802.1',84,313,1,5);
INSERT INTO sequence_source VALUES(2590,'MG547803.1',84,313,1,5);
INSERT INTO sequence_source VALUES(2591,'MG547804.1',84,313,1,5);
INSERT INTO sequence_source VALUES(2592,'MG547805.1',84,313,1,5);
INSERT INTO sequence_source VALUES(2593,'MG547806.1',84,313,1,5);
INSERT INTO sequence_source VALUES(2594,'MG547807.1',84,926,1,5);
INSERT INTO sequence_source VALUES(2595,'MG547808.1',84,313,1,5);
INSERT INTO sequence_source VALUES(2596,'MG547811.1',84,313,1,5);
INSERT INTO sequence_source VALUES(2597,'MG547813.1',84,907,1,5);
INSERT INTO sequence_source VALUES(2598,'MG547814.1',84,907,1,5);
INSERT INTO sequence_source VALUES(2599,'MG547815.1',84,313,1,5);
INSERT INTO sequence_source VALUES(2600,'MG547816.1',84,313,1,5);
INSERT INTO sequence_source VALUES(2601,'MG547817.1',84,930,1,5);
INSERT INTO sequence_source VALUES(2602,'MG547818.1',84,930,1,5);
INSERT INTO sequence_source VALUES(2603,'MG547819.1',84,930,1,5);
INSERT INTO sequence_source VALUES(2604,'MG547820.1',84,927,1,5);
INSERT INTO sequence_source VALUES(2605,'MG547821.1',84,313,1,5);
INSERT INTO sequence_source VALUES(2606,'MG547822.1',84,313,1,5);
INSERT INTO sequence_source VALUES(2607,'MG547824.1',84,930,1,5);
INSERT INTO sequence_source VALUES(2608,'MG547825.1',84,930,1,5);
INSERT INTO sequence_source VALUES(2609,'MG547826.1',84,927,1,5);
INSERT INTO sequence_source VALUES(2610,'MG547828.1',84,930,1,5);
INSERT INTO sequence_source VALUES(2611,'MG547829.1',84,930,1,5);
INSERT INTO sequence_source VALUES(2612,'MG547830.1',84,927,1,5);
INSERT INTO sequence_source VALUES(2613,'MG547834.1',84,931,1,5);
INSERT INTO sequence_source VALUES(2614,'MG547835.1',84,930,1,5);
INSERT INTO sequence_source VALUES(2615,'MG547836.1',84,313,1,5);
INSERT INTO sequence_source VALUES(2616,'MG547837.1',84,930,1,5);
INSERT INTO sequence_source VALUES(2617,'MG547838.1',84,930,1,5);
INSERT INTO sequence_source VALUES(2618,'MG547840.1',84,313,1,5);
INSERT INTO sequence_source VALUES(2619,'MG547841.1',84,907,1,5);
INSERT INTO sequence_source VALUES(2620,'MG547845.1',84,930,1,5);
INSERT INTO sequence_source VALUES(2621,'MG547846.1',84,907,1,5);
INSERT INTO sequence_source VALUES(2622,'MG547847.1',84,930,1,5);
INSERT INTO sequence_source VALUES(2623,'MG547848.1',84,927,1,5);
INSERT INTO sequence_source VALUES(2624,'MG547850.1',84,313,1,5);
INSERT INTO sequence_source VALUES(2625,'MG547851.1',84,929,1,5);
INSERT INTO sequence_source VALUES(2626,'MG547853.1',84,927,1,5);
INSERT INTO sequence_source VALUES(2627,'MG547856.1',84,932,1,5);
INSERT INTO sequence_source VALUES(2628,'MG547857.1',84,929,1,5);
INSERT INTO sequence_source VALUES(2629,'MG547859.1',84,929,1,5);
INSERT INTO sequence_source VALUES(2630,'MG547860.1',84,930,1,5);
INSERT INTO sequence_source VALUES(2631,'MG547861.1',84,313,1,5);
INSERT INTO sequence_source VALUES(2632,'MG547862.1',84,929,1,5);
INSERT INTO sequence_source VALUES(2633,'MG547863.1',84,930,1,5);
INSERT INTO sequence_source VALUES(2634,'MG547864.1',84,930,1,5);
INSERT INTO sequence_source VALUES(2635,'MG547865.1',84,933,1,5);
INSERT INTO sequence_source VALUES(2636,'MG549036.1',84,907,1,5);
INSERT INTO sequence_source VALUES(2637,'MG549037.1',84,313,1,5);
INSERT INTO sequence_source VALUES(2638,'MG549038.1',84,313,1,5);
INSERT INTO sequence_source VALUES(2639,'MG549039.1',84,907,1,5);
INSERT INTO sequence_source VALUES(2640,'MG549040.1',84,930,1,5);
INSERT INTO sequence_source VALUES(2641,'MG549041.1',84,926,1,5);
INSERT INTO sequence_source VALUES(2642,'MG549043.1',84,927,1,5);
INSERT INTO sequence_source VALUES(2643,'MG549044.1',84,929,1,5);
INSERT INTO sequence_source VALUES(2644,'MG549045.1',84,313,1,5);
INSERT INTO sequence_source VALUES(2645,'MG549046.1',84,907,1,5);
INSERT INTO sequence_source VALUES(2646,'MG549047.1',84,927,1,5);
INSERT INTO sequence_source VALUES(2647,'MG549048.1',84,930,1,5);
INSERT INTO sequence_source VALUES(2648,'MG549049.1',84,930,1,5);
INSERT INTO sequence_source VALUES(2649,'MG549050.1',84,313,1,5);
INSERT INTO sequence_source VALUES(2650,'MG549051.1',84,313,1,5);
INSERT INTO sequence_source VALUES(2651,'MG549052.1',84,926,1,5);
INSERT INTO sequence_source VALUES(2652,'MG549053.1',84,313,1,5);
INSERT INTO sequence_source VALUES(2653,'MG549054.1',84,313,1,5);
INSERT INTO sequence_source VALUES(2654,'MG549055.1',84,313,1,5);
INSERT INTO sequence_source VALUES(2655,'MG549056.1',84,313,1,5);
INSERT INTO sequence_source VALUES(2656,'MG549057.1',84,934,1,5);
INSERT INTO sequence_source VALUES(2657,'MG549059.1',84,929,1,5);
INSERT INTO sequence_source VALUES(2658,'MG549061.1',84,930,1,5);
INSERT INTO sequence_source VALUES(2659,'MG549062.1',84,930,1,5);
INSERT INTO sequence_source VALUES(2660,'MG549064.1',84,907,1,5);
INSERT INTO sequence_source VALUES(2661,'MG549065.1',84,313,1,5);
INSERT INTO sequence_source VALUES(2662,'MG549066.1',84,313,1,5);
INSERT INTO sequence_source VALUES(2663,'MG549067.1',84,313,1,5);
INSERT INTO sequence_source VALUES(2664,'MG549068.1',84,313,1,5);
INSERT INTO sequence_source VALUES(2665,'MG549069.1',84,313,1,5);
INSERT INTO sequence_source VALUES(2666,'MG549070.1',84,313,1,5);
INSERT INTO sequence_source VALUES(2667,'MG549071.1',84,313,1,5);
INSERT INTO sequence_source VALUES(2668,'MG549072.1',84,907,1,5);
INSERT INTO sequence_source VALUES(2669,'MG549073.1',84,313,1,5);
INSERT INTO sequence_source VALUES(2670,'MG549074.1',84,313,1,5);
INSERT INTO sequence_source VALUES(2671,'MG549075.1',84,927,1,5);
INSERT INTO sequence_source VALUES(2672,'MG550122.1',84,935,1,5);
INSERT INTO sequence_source VALUES(2673,'MG550123.1',84,936,1,5);
INSERT INTO sequence_source VALUES(2674,'MG550124.1',84,313,1,5);
INSERT INTO sequence_source VALUES(2675,'MG550125.1',84,928,1,5);
INSERT INTO sequence_source VALUES(2676,'MG550126.1',84,313,1,5);
INSERT INTO sequence_source VALUES(2677,'MG550128.1',84,313,1,5);
INSERT INTO sequence_source VALUES(2678,'MG550129.1',84,313,1,5);
INSERT INTO sequence_source VALUES(2679,'MG550130.1',84,313,1,5);
INSERT INTO sequence_source VALUES(2680,'MG550131.1',84,313,1,5);
INSERT INTO sequence_source VALUES(2681,'MG550132.1',84,313,1,5);
INSERT INTO sequence_source VALUES(2682,'MG550133.1',84,313,1,5);
INSERT INTO sequence_source VALUES(2683,'MG550134.1',84,907,1,5);
INSERT INTO sequence_source VALUES(2684,'MG550135.1',84,313,1,5);
INSERT INTO sequence_source VALUES(2685,'MG550136.1',84,313,1,5);
INSERT INTO sequence_source VALUES(2686,'MG550137.1',84,929,1,5);
INSERT INTO sequence_source VALUES(2687,'MG550138.1',84,937,1,5);
INSERT INTO sequence_source VALUES(2688,'MG550139.1',84,929,1,5);
INSERT INTO sequence_source VALUES(2689,'MG550140.1',84,929,1,5);
INSERT INTO sequence_source VALUES(2690,'MG550141.1',84,313,1,5);
INSERT INTO sequence_source VALUES(2691,'MG550142.1',84,313,1,5);
INSERT INTO sequence_source VALUES(2692,'MG550143.1',84,926,1,5);
INSERT INTO sequence_source VALUES(2693,'MG550145.1',84,930,1,5);
INSERT INTO sequence_source VALUES(2694,'MG551856.1',84,37,1,5);
INSERT INTO sequence_source VALUES(2695,'MG551857.1',84,938,1,5);
INSERT INTO sequence_source VALUES(2696,'MG551881.1',84,37,1,5);
INSERT INTO sequence_source VALUES(2697,'MG551882.1',84,37,1,5);
INSERT INTO sequence_source VALUES(2698,'MG551883.1',84,37,1,5);
INSERT INTO sequence_source VALUES(2699,'MG551884.1',84,37,1,5);
INSERT INTO sequence_source VALUES(2700,'MG552076.1',84,939,1,5);
INSERT INTO sequence_source VALUES(2701,'MG552077.1',84,20,1,5);
INSERT INTO sequence_source VALUES(2702,'MG552078.1',84,940,1,5);
INSERT INTO sequence_source VALUES(2703,'MG552079.1',84,20,1,5);
INSERT INTO sequence_source VALUES(2704,'MG552080.1',84,941,1,5);
INSERT INTO sequence_source VALUES(2705,'MG552081.1',84,942,1,5);
INSERT INTO sequence_source VALUES(2706,'MG552082.1',84,943,1,5);
INSERT INTO sequence_source VALUES(2707,'MG552083.1',84,944,1,5);
INSERT INTO sequence_source VALUES(2708,'MG552085.1',84,945,1,5);
INSERT INTO sequence_source VALUES(2709,'MG552086.1',84,20,1,5);
INSERT INTO sequence_source VALUES(2710,'MG552087.1',84,34,1,5);
INSERT INTO sequence_source VALUES(2711,'MG552088.1',84,946,1,5);
INSERT INTO sequence_source VALUES(2712,'MG552089.1',84,947,1,5);
INSERT INTO sequence_source VALUES(2713,'MG553201.1',84,948,1,5);
INSERT INTO sequence_source VALUES(2714,'MG553203.1',84,949,1,5);
INSERT INTO sequence_source VALUES(2715,'MG553204.1',84,950,1,5);
INSERT INTO sequence_source VALUES(2716,'MG553205.1',84,23,1,5);
INSERT INTO sequence_source VALUES(2717,'MG553207.1',84,20,1,5);
INSERT INTO sequence_source VALUES(2718,'MG553208.1',84,951,1,5);
INSERT INTO sequence_source VALUES(2719,'MG554683.1',84,712,1,5);
INSERT INTO sequence_source VALUES(2720,'MG554684.1',84,952,1,5);
INSERT INTO sequence_source VALUES(2721,'MG554685.1',84,953,1,5);
INSERT INTO sequence_source VALUES(2722,'MG554691.1',84,53,1,5);
INSERT INTO sequence_source VALUES(2723,'MG554738.1',84,54,1,5);
INSERT INTO sequence_source VALUES(2724,'MG554739.1',84,954,1,5);
INSERT INTO sequence_source VALUES(2725,'MG554741.1',84,54,1,5);
INSERT INTO sequence_source VALUES(2726,'MG557699.1',84,176,1,5);
INSERT INTO sequence_source VALUES(2727,'MG557701.1',84,176,1,5);
INSERT INTO sequence_source VALUES(2728,'MG557901.1',84,311,1,5);
INSERT INTO sequence_source VALUES(2729,'MG557902.1',84,311,1,5);
INSERT INTO sequence_source VALUES(2730,'MG561726.1',84,168,1,5);
INSERT INTO sequence_source VALUES(2731,'MG561727.1',84,311,1,5);
INSERT INTO sequence_source VALUES(2732,'MG561728.1',84,311,1,5);
INSERT INTO sequence_source VALUES(2733,'MG561729.1',84,311,1,5);
INSERT INTO sequence_source VALUES(2734,'MG561730.1',84,311,1,5);
INSERT INTO sequence_source VALUES(2735,'MG561731.1',84,311,1,5);
INSERT INTO sequence_source VALUES(2736,'MG561732.1',84,311,1,5);
INSERT INTO sequence_source VALUES(2737,'MG561733.1',84,311,1,5);
INSERT INTO sequence_source VALUES(2738,'MG561734.1',84,311,1,5);
INSERT INTO sequence_source VALUES(2739,'MG561735.1',84,311,1,5);
INSERT INTO sequence_source VALUES(2740,'MG561736.1',84,311,1,5);
INSERT INTO sequence_source VALUES(2741,'MG561737.1',84,311,1,5);
INSERT INTO sequence_source VALUES(2742,'MG561738.1',84,311,1,5);
INSERT INTO sequence_source VALUES(2743,'MG561739.1',84,311,1,5);
INSERT INTO sequence_source VALUES(2744,'MG561740.1',84,311,1,5);
INSERT INTO sequence_source VALUES(2745,'MG561741.1',84,311,1,5);
INSERT INTO sequence_source VALUES(2746,'MG561742.1',84,311,1,5);
INSERT INTO sequence_source VALUES(2747,'MG561743.1',84,311,1,5);
INSERT INTO sequence_source VALUES(2748,'MG561744.1',84,311,1,5);
INSERT INTO sequence_source VALUES(2749,'MG561745.1',84,311,1,5);
INSERT INTO sequence_source VALUES(2750,'MG561747.1',84,168,1,5);
INSERT INTO sequence_source VALUES(2751,'MG561748.1',84,311,1,5);
INSERT INTO sequence_source VALUES(2752,'MG561749.1',84,281,1,5);
INSERT INTO sequence_source VALUES(2753,'MG561750.1',84,311,1,5);
INSERT INTO sequence_source VALUES(2754,'MG561944.1',84,955,1,5);
INSERT INTO sequence_source VALUES(2755,'MG561945.1',84,955,1,5);
INSERT INTO sequence_source VALUES(2756,'MG561946.1',84,955,1,5);
INSERT INTO sequence_source VALUES(2757,'MG561947.1',84,955,1,5);
INSERT INTO sequence_source VALUES(2758,'MG587712.1',84,956,1,5);
INSERT INTO sequence_source VALUES(2759,'MG587713.1',84,269,1,5);
INSERT INTO sequence_source VALUES(2760,'MG587714.1',84,269,1,5);
INSERT INTO sequence_source VALUES(2761,'MG587715.1',84,497,1,5);
INSERT INTO sequence_source VALUES(2762,'MG587716.1',84,497,1,5);
INSERT INTO sequence_source VALUES(2763,'MG587717.1',84,497,1,5);
INSERT INTO sequence_source VALUES(2764,'MG587718.1',84,269,1,5);
INSERT INTO sequence_source VALUES(2765,'MG587719.1',84,957,1,5);
INSERT INTO sequence_source VALUES(2766,'MG587720.1',84,957,1,5);
INSERT INTO sequence_source VALUES(2767,'MG587721.1',84,269,1,5);
INSERT INTO sequence_source VALUES(2768,'MG587722.1',84,497,1,5);
INSERT INTO sequence_source VALUES(2769,'MG587723.1',84,269,1,5);
INSERT INTO sequence_source VALUES(2770,'MG587724.1',84,269,1,5);
INSERT INTO sequence_source VALUES(2771,'MG587725.1',84,497,1,5);
INSERT INTO sequence_source VALUES(2772,'MG587726.1',84,957,1,5);
INSERT INTO sequence_source VALUES(2773,'MG589424.1',84,958,1,5);
INSERT INTO sequence_source VALUES(2774,'MG589425.1',84,959,1,5);
INSERT INTO sequence_source VALUES(2775,'MG589426.1',84,152,1,5);
INSERT INTO sequence_source VALUES(2776,'MG589427.1',84,497,1,5);
INSERT INTO sequence_source VALUES(2777,'MG589428.1',84,497,1,5);
INSERT INTO sequence_source VALUES(2778,'MG589429.1',84,269,1,5);
INSERT INTO sequence_source VALUES(2779,'MG589430.1',84,956,1,5);
INSERT INTO sequence_source VALUES(2780,'MG589431.1',84,956,1,5);
INSERT INTO sequence_source VALUES(2781,'MG589432.1',84,269,1,5);
INSERT INTO sequence_source VALUES(2782,'MG589433.1',84,152,1,5);
INSERT INTO sequence_source VALUES(2783,'MG589434.1',84,152,1,5);
INSERT INTO sequence_source VALUES(2784,'MG589435.1',84,958,1,5);
INSERT INTO sequence_source VALUES(2785,'MG589436.1',84,956,1,5);
INSERT INTO sequence_source VALUES(2786,'MG589437.1',84,152,1,5);
INSERT INTO sequence_source VALUES(2787,'MG589438.1',84,497,1,5);
INSERT INTO sequence_source VALUES(2788,'MG589439.1',84,269,1,5);
INSERT INTO sequence_source VALUES(2789,'MG589440.1',84,956,1,5);
INSERT INTO sequence_source VALUES(2790,'MG589441.1',84,497,1,5);
INSERT INTO sequence_source VALUES(2791,'MG589442.1',84,269,1,5);
INSERT INTO sequence_source VALUES(2792,'MG589443.1',84,269,1,5);
INSERT INTO sequence_source VALUES(2793,'MG589444.1',84,497,1,5);
INSERT INTO sequence_source VALUES(2794,'MG589445.1',84,269,1,5);
INSERT INTO sequence_source VALUES(2795,'MG589446.1',84,497,1,5);
INSERT INTO sequence_source VALUES(2796,'MG589447.1',84,269,1,5);
INSERT INTO sequence_source VALUES(2797,'MG589448.1',84,497,1,5);
INSERT INTO sequence_source VALUES(2798,'MG589449.1',84,497,1,5);
INSERT INTO sequence_source VALUES(2799,'MG589450.1',84,957,1,5);
INSERT INTO sequence_source VALUES(2800,'MG589451.1',84,956,1,5);
INSERT INTO sequence_source VALUES(2801,'MG594643.1',84,46,1,5);
INSERT INTO sequence_source VALUES(2802,'MG594644.1',84,316,1,5);
INSERT INTO sequence_source VALUES(2803,'MG594645.1',84,46,1,5);
INSERT INTO sequence_source VALUES(2804,'MG594646.1',84,46,1,5);
INSERT INTO sequence_source VALUES(2805,'MG594856.1',84,363,1,5);
INSERT INTO sequence_source VALUES(2806,'MG595272.1',84,363,1,5);
INSERT INTO sequence_source VALUES(2807,'MG595666.1',84,669,1,5);
INSERT INTO sequence_source VALUES(2808,'MG595667.1',84,669,1,5);
INSERT INTO sequence_source VALUES(2809,'MG670447.1',84,29,1,5);
INSERT INTO sequence_source VALUES(2810,'MG674700.1',84,46,1,5);
INSERT INTO sequence_source VALUES(2811,'MG685779.1',84,46,1,5);
INSERT INTO sequence_source VALUES(2812,'MG685781.1',84,46,1,5);
INSERT INTO sequence_source VALUES(2813,'MG685782.1',84,46,1,5);
INSERT INTO sequence_source VALUES(2814,'MG685783.1',84,46,1,5);
INSERT INTO sequence_source VALUES(2815,'MG685784.1',84,46,1,5);
INSERT INTO sequence_source VALUES(2816,'MG685785.1',84,46,1,5);
INSERT INTO sequence_source VALUES(2817,'MG685786.1',84,46,1,5);
INSERT INTO sequence_source VALUES(2818,'MG685787.1',84,46,1,5);
INSERT INTO sequence_source VALUES(2819,'MG685788.1',84,46,1,5);
INSERT INTO sequence_source VALUES(2820,'MG696314.1',84,960,1,5);
INSERT INTO sequence_source VALUES(2821,'MG696326.1',84,481,1,5);
INSERT INTO sequence_source VALUES(2822,'MG696327.1',84,478,1,5);
INSERT INTO sequence_source VALUES(2823,'MG696330.1',84,26,1,5);
INSERT INTO sequence_source VALUES(2824,'MG696335.1',84,961,1,5);
INSERT INTO sequence_source VALUES(2825,'MG696415.1',84,46,1,5);
INSERT INTO sequence_source VALUES(2826,'MG696441.1',84,46,1,5);
INSERT INTO sequence_source VALUES(2827,'MG696442.1',84,66,1,5);
INSERT INTO sequence_source VALUES(2828,'MG696443.1',84,46,1,5);
INSERT INTO sequence_source VALUES(2829,'MG696444.1',84,962,1,5);
INSERT INTO sequence_source VALUES(2830,'MG696445.1',84,66,1,5);
INSERT INTO sequence_source VALUES(2831,'MG696446.1',84,66,1,5);
INSERT INTO sequence_source VALUES(2832,'MG696447.1',84,478,1,5);
INSERT INTO sequence_source VALUES(2833,'MG696448.1',84,481,1,5);
INSERT INTO sequence_source VALUES(2834,'MG696449.1',84,26,1,5);
INSERT INTO sequence_source VALUES(2835,'MG696450.1',84,26,1,5);
INSERT INTO sequence_source VALUES(2836,'MG696451.1',84,46,1,5);
INSERT INTO sequence_source VALUES(2837,'MG696452.1',84,481,1,5);
INSERT INTO sequence_source VALUES(2838,'MG696453.1',84,478,1,5);
INSERT INTO sequence_source VALUES(2839,'MG696454.1',84,963,1,5);
INSERT INTO sequence_source VALUES(2840,'MG696455.1',84,478,1,5);
INSERT INTO sequence_source VALUES(2841,'MG696456.1',84,66,1,5);
INSERT INTO sequence_source VALUES(2842,'MG696457.1',84,46,1,5);
INSERT INTO sequence_source VALUES(2843,'MG696458.1',84,380,1,5);
INSERT INTO sequence_source VALUES(2844,'MG696459.1',84,481,1,5);
INSERT INTO sequence_source VALUES(2845,'MG696461.1',84,380,1,5);
INSERT INTO sequence_source VALUES(2846,'MG696462.1',84,964,1,5);
INSERT INTO sequence_source VALUES(2847,'MG696463.1',84,66,1,5);
INSERT INTO sequence_source VALUES(2848,'MG696464.1',84,965,1,5);
INSERT INTO sequence_source VALUES(2849,'MG696466.1',84,46,1,5);
INSERT INTO sequence_source VALUES(2850,'MG696467.1',84,966,1,5);
INSERT INTO sequence_source VALUES(2851,'MG696468.1',84,380,1,5);
INSERT INTO sequence_source VALUES(2852,'MG696471.1',84,380,1,5);
INSERT INTO sequence_source VALUES(2853,'MG696472.1',84,20,1,5);
INSERT INTO sequence_source VALUES(2854,'MG696473.1',84,380,1,5);
INSERT INTO sequence_source VALUES(2855,'MG696477.1',84,20,1,5);
INSERT INTO sequence_source VALUES(2856,'MG696478.1',84,965,1,5);
INSERT INTO sequence_source VALUES(2857,'MG696479.1',84,478,1,5);
INSERT INTO sequence_source VALUES(2858,'MG696480.1',84,478,1,5);
INSERT INTO sequence_source VALUES(2859,'MG696481.1',84,478,1,5);
INSERT INTO sequence_source VALUES(2860,'MG696483.1',84,481,1,5);
INSERT INTO sequence_source VALUES(2861,'MG696484.1',84,481,1,5);
INSERT INTO sequence_source VALUES(2862,'MG696485.1',84,478,1,5);
INSERT INTO sequence_source VALUES(2863,'MG696488.1',84,483,1,5);
INSERT INTO sequence_source VALUES(2864,'MG696490.1',84,481,1,5);
INSERT INTO sequence_source VALUES(2865,'MG696493.1',84,380,1,5);
INSERT INTO sequence_source VALUES(2866,'MG696494.1',84,380,1,5);
INSERT INTO sequence_source VALUES(2867,'MG696497.1',84,481,1,5);
INSERT INTO sequence_source VALUES(2868,'MG696498.1',84,380,1,5);
INSERT INTO sequence_source VALUES(2869,'MG696499.1',84,327,1,5);
INSERT INTO sequence_source VALUES(2870,'MG696500.1',84,327,1,5);
INSERT INTO sequence_source VALUES(2871,'MG696505.1',84,481,1,5);
INSERT INTO sequence_source VALUES(2872,'MG696506.1',84,313,1,5);
INSERT INTO sequence_source VALUES(2873,'MG696507.1',84,380,1,5);
INSERT INTO sequence_source VALUES(2874,'MG696508.1',84,481,1,5);
INSERT INTO sequence_source VALUES(2875,'MG696511.1',84,483,1,5);
INSERT INTO sequence_source VALUES(2876,'MG696512.1',84,66,1,5);
INSERT INTO sequence_source VALUES(2877,'MG696514.1',84,20,1,5);
INSERT INTO sequence_source VALUES(2878,'MG696515.1',84,20,1,5);
INSERT INTO sequence_source VALUES(2879,'MG696516.1',84,46,1,5);
INSERT INTO sequence_source VALUES(2880,'MG696517.1',84,46,1,5);
INSERT INTO sequence_source VALUES(2881,'MG696519.1',84,176,1,5);
INSERT INTO sequence_source VALUES(2882,'MG696521.1',84,483,1,5);
INSERT INTO sequence_source VALUES(2883,'MG696522.1',84,483,1,5);
INSERT INTO sequence_source VALUES(2884,'MG696525.1',84,26,1,5);
INSERT INTO sequence_source VALUES(2885,'MG696526.1',84,950,1,5);
INSERT INTO sequence_source VALUES(2886,'MG696527.1',84,20,1,5);
INSERT INTO sequence_source VALUES(2887,'MG696529.1',84,66,1,5);
INSERT INTO sequence_source VALUES(2888,'MG696530.1',84,484,1,5);
INSERT INTO sequence_source VALUES(2889,'MG696533.1',84,967,1,5);
INSERT INTO sequence_source VALUES(2890,'MG696534.1',84,310,1,5);
INSERT INTO sequence_source VALUES(2891,'MG696535.1',84,20,1,5);
INSERT INTO sequence_source VALUES(2892,'MG696536.1',84,968,1,5);
INSERT INTO sequence_source VALUES(2893,'MG696537.1',84,478,1,5);
INSERT INTO sequence_source VALUES(2894,'MG696541.1',84,478,1,5);
INSERT INTO sequence_source VALUES(2895,'MG696543.1',84,313,1,5);
INSERT INTO sequence_source VALUES(2896,'MG696544.1',84,478,1,5);
INSERT INTO sequence_source VALUES(2897,'MG696547.1',84,481,1,5);
INSERT INTO sequence_source VALUES(2898,'MG696550.1',84,481,1,5);
INSERT INTO sequence_source VALUES(2899,'MG707787.1',84,46,1,5);
INSERT INTO sequence_source VALUES(2900,'MG707788.1',84,46,1,5);
INSERT INTO sequence_source VALUES(2901,'MG707790.1',84,316,1,5);
INSERT INTO sequence_source VALUES(2902,'MG707791.1',84,322,1,5);
INSERT INTO sequence_source VALUES(2903,'MG707804.1',84,969,1,5);
INSERT INTO sequence_source VALUES(2904,'MG757758.1',84,970,1,35);
INSERT INTO sequence_source VALUES(2905,'MG757759.1',84,970,1,35);
INSERT INTO sequence_source VALUES(2906,'MG757760.1',84,971,1,35);
INSERT INTO sequence_source VALUES(2907,'MG757761.1',84,972,1,35);
INSERT INTO sequence_source VALUES(2908,'MG757762.1',84,543,1,35);
INSERT INTO sequence_source VALUES(2909,'MG757765.1',84,972,1,35);
INSERT INTO sequence_source VALUES(2910,'MG757766.1',84,543,1,35);
INSERT INTO sequence_source VALUES(2911,'MG757767.1',84,972,1,35);
INSERT INTO sequence_source VALUES(2912,'MG757768.1',84,972,1,35);
INSERT INTO sequence_source VALUES(2913,'MG757769.1',84,543,1,35);
INSERT INTO sequence_source VALUES(2914,'MG757770.1',84,972,1,35);
INSERT INTO sequence_source VALUES(2915,'MG757772.1',84,973,1,35);
INSERT INTO sequence_source VALUES(2916,'MG757773.1',84,974,1,35);
INSERT INTO sequence_source VALUES(2917,'MG757774.1',84,972,1,35);
INSERT INTO sequence_source VALUES(2918,'MG757775.1',84,972,1,35);
INSERT INTO sequence_source VALUES(2919,'MG757776.1',84,970,1,35);
INSERT INTO sequence_source VALUES(2920,'MG757777.1',84,972,1,35);
INSERT INTO sequence_source VALUES(2921,'MG757778.1',84,975,1,35);
INSERT INTO sequence_source VALUES(2922,'MG757779.1',84,972,1,35);
INSERT INTO sequence_source VALUES(2923,'MG757780.1',84,970,1,35);
INSERT INTO sequence_source VALUES(2924,'MG757781.1',84,972,1,35);
INSERT INTO sequence_source VALUES(2925,'MG757782.1',84,542,1,35);
INSERT INTO sequence_source VALUES(2926,'MG757783.1',84,542,1,35);
INSERT INTO sequence_source VALUES(2927,'MG757784.1',84,542,1,35);
INSERT INTO sequence_source VALUES(2928,'MG757785.1',84,543,1,35);
INSERT INTO sequence_source VALUES(2929,'MG757786.1',84,543,1,35);
INSERT INTO sequence_source VALUES(2930,'MG757787.1',84,543,1,35);
INSERT INTO sequence_source VALUES(2931,'MG757788.1',84,543,1,35);
INSERT INTO sequence_source VALUES(2932,'MG757789.1',84,976,1,35);
INSERT INTO sequence_source VALUES(2933,'MG757790.1',84,972,1,35);
INSERT INTO sequence_source VALUES(2934,'MG757791.1',84,977,1,35);
INSERT INTO sequence_source VALUES(2935,'MG757792.1',84,978,1,35);
INSERT INTO sequence_source VALUES(2936,'MG761692.1',84,674,1,5);
INSERT INTO sequence_source VALUES(2937,'MG765402.1',84,979,1,5);
INSERT INTO sequence_source VALUES(2938,'MG765403.1',84,979,1,5);
INSERT INTO sequence_source VALUES(2939,'MG765404.1',84,979,1,5);
INSERT INTO sequence_source VALUES(2940,'MG765405.1',84,979,1,5);
INSERT INTO sequence_source VALUES(2941,'MG782843.1',84,980,1,9);
INSERT INTO sequence_source VALUES(2942,'MG823261.1',84,399,1,5);
INSERT INTO sequence_source VALUES(2943,'MG823262.1',84,386,1,5);
INSERT INTO sequence_source VALUES(2944,'MG823263.1',84,399,1,5);
INSERT INTO sequence_source VALUES(2945,'MG823269.1',84,11,1,5);
INSERT INTO sequence_source VALUES(2946,'MG823270.1',84,398,1,5);
INSERT INTO sequence_source VALUES(2947,'MG823271.1',84,394,1,5);
INSERT INTO sequence_source VALUES(2948,'MG823336.1',84,981,1,5);
INSERT INTO sequence_source VALUES(2949,'MG823337.1',84,982,1,5);
INSERT INTO sequence_source VALUES(2950,'MG823355.1',84,983,1,5);
INSERT INTO sequence_source VALUES(2951,'MG910455.1',84,984,1,62);
INSERT INTO sequence_source VALUES(2952,'MG956799.1',84,60,1,5);
INSERT INTO sequence_source VALUES(2953,'MG971299.1',84,985,1,6);
INSERT INTO sequence_source VALUES(2954,'MG971301.1',84,986,1,6);
INSERT INTO sequence_source VALUES(2955,'MH036001.1',84,987,1,62);
INSERT INTO sequence_source VALUES(2956,'MH037150.1',84,311,1,5);
INSERT INTO sequence_source VALUES(2957,'MH043608.1',84,988,1,62);
INSERT INTO sequence_source VALUES(2958,'MH059526.1',84,860,1,9);
INSERT INTO sequence_source VALUES(2959,'MH141414.1',84,989,1,5);
INSERT INTO sequence_source VALUES(2960,'MH141415.1',84,969,1,5);
INSERT INTO sequence_source VALUES(2961,'MH171627.1',84,46,1,5);
INSERT INTO sequence_source VALUES(2962,'MH171628.1',84,46,1,5);
INSERT INTO sequence_source VALUES(2963,'MH171629.1',84,46,1,5);
INSERT INTO sequence_source VALUES(2964,'MH171630.1',84,46,1,5);
INSERT INTO sequence_source VALUES(2965,'MH171631.1',84,46,1,5);
INSERT INTO sequence_source VALUES(2966,'MH171632.1',84,46,1,5);
INSERT INTO sequence_source VALUES(2967,'MH171633.1',84,316,1,5);
INSERT INTO sequence_source VALUES(2968,'MH171634.1',84,990,1,5);
INSERT INTO sequence_source VALUES(2969,'MH171635.1',84,176,1,5);
INSERT INTO sequence_source VALUES(2970,'MH171636.1',84,176,1,5);
INSERT INTO sequence_source VALUES(2971,'MH171637.1',84,176,1,5);
INSERT INTO sequence_source VALUES(2972,'MH171638.1',84,969,1,5);
INSERT INTO sequence_source VALUES(2973,'MH171639.1',84,176,1,5);
INSERT INTO sequence_source VALUES(2974,'MH171640.1',84,322,1,5);
INSERT INTO sequence_source VALUES(2975,'MH171641.1',84,53,1,5);
INSERT INTO sequence_source VALUES(2976,'MH171642.1',84,991,1,5);
INSERT INTO sequence_source VALUES(2977,'MH171643.1',84,955,1,5);
INSERT INTO sequence_source VALUES(2978,'MH171644.1',84,992,1,5);
INSERT INTO sequence_source VALUES(2979,'MH171645.1',84,993,1,5);
INSERT INTO sequence_source VALUES(2980,'MH171646.1',84,993,1,5);
INSERT INTO sequence_source VALUES(2981,'MH171647.1',84,269,1,5);
INSERT INTO sequence_source VALUES(2982,'MH171648.1',84,994,1,5);
INSERT INTO sequence_source VALUES(2983,'MH171649.1',84,269,1,5);
INSERT INTO sequence_source VALUES(2984,'MH171650.1',84,363,1,5);
INSERT INTO sequence_source VALUES(2985,'MH171651.1',84,995,1,5);
INSERT INTO sequence_source VALUES(2986,'MH178328.1',84,996,1,5);
INSERT INTO sequence_source VALUES(2987,'MH178329.1',84,997,1,5);
INSERT INTO sequence_source VALUES(2988,'MH178331.1',84,41,1,5);
INSERT INTO sequence_source VALUES(2989,'MH178332.1',84,12,1,5);
INSERT INTO sequence_source VALUES(2990,'MH178333.1',84,701,1,5);
INSERT INTO sequence_source VALUES(2991,'MH178334.1',84,33,1,5);
INSERT INTO sequence_source VALUES(2992,'MH178335.1',84,51,1,5);
INSERT INTO sequence_source VALUES(2993,'MH178336.1',84,25,1,5);
INSERT INTO sequence_source VALUES(2994,'MH178341.1',84,480,1,5);
INSERT INTO sequence_source VALUES(2995,'MH178342.1',84,78,1,5);
INSERT INTO sequence_source VALUES(2996,'MH178344.1',84,998,1,5);
INSERT INTO sequence_source VALUES(2997,'MH178345.1',84,580,1,5);
INSERT INTO sequence_source VALUES(2998,'MH178350.1',84,11,1,5);
INSERT INTO sequence_source VALUES(2999,'MH196529.1',84,29,1,5);
INSERT INTO sequence_source VALUES(3000,'MH196530.1',84,999,1,5);
INSERT INTO sequence_source VALUES(3001,'MH219822.1',84,64,1,5);
INSERT INTO sequence_source VALUES(3002,'MH219826.1',84,60,1,5);
INSERT INTO sequence_source VALUES(3003,'MH219829.1',84,60,1,5);
INSERT INTO sequence_source VALUES(3004,'MH219833.1',84,401,1,5);
INSERT INTO sequence_source VALUES(3005,'MH219839.1',84,1000,1,5);
INSERT INTO sequence_source VALUES(3006,'MH219844.1',84,60,1,5);
INSERT INTO sequence_source VALUES(3007,'MH219849.1',84,60,1,5);
INSERT INTO sequence_source VALUES(3008,'MH219859.1',84,898,1,5);
INSERT INTO sequence_source VALUES(3009,'MH219866.1',84,60,1,5);
INSERT INTO sequence_source VALUES(3010,'MH219882.1',84,64,1,5);
INSERT INTO sequence_source VALUES(3011,'MH219886.1',84,25,1,5);
INSERT INTO sequence_source VALUES(3012,'MH219887.1',84,1001,1,5);
INSERT INTO sequence_source VALUES(3013,'MH219902.1',84,64,1,5);
INSERT INTO sequence_source VALUES(3014,'MH219904.1',84,60,1,5);
INSERT INTO sequence_source VALUES(3015,'MH219918.1',84,13,1,5);
INSERT INTO sequence_source VALUES(3016,'MH236137.1',84,1002,1,5);
INSERT INTO sequence_source VALUES(3017,'MH236139.1',84,1003,1,5);
INSERT INTO sequence_source VALUES(3018,'MH236141.1',84,1004,1,5);
INSERT INTO sequence_source VALUES(3019,'MH236241.1',84,553,1,55);
INSERT INTO sequence_source VALUES(3020,'MH236250.1',84,154,1,5);
INSERT INTO sequence_source VALUES(3021,'MH243441.1',84,1005,1,55);
INSERT INTO sequence_source VALUES(3022,'MH321577.1',84,1006,1,5);
INSERT INTO sequence_source VALUES(3023,'MH341612.1',84,1007,1,5);
INSERT INTO sequence_source VALUES(3024,'MH341616.1',84,25,1,5);
INSERT INTO sequence_source VALUES(3025,'MH341621.1',84,25,1,5);
INSERT INTO sequence_source VALUES(3026,'MH352420.1',84,401,1,5);
INSERT INTO sequence_source VALUES(3027,'MH393373.1',84,1008,1,62);
INSERT INTO sequence_source VALUES(3028,'MH393378.1',84,1009,1,62);
INSERT INTO sequence_source VALUES(3029,'MH397235.1',84,1010,1,5);
INSERT INTO sequence_source VALUES(3030,'MH397236.1',84,1011,1,5);
INSERT INTO sequence_source VALUES(3031,'MH401198.1',84,1012,1,5);
INSERT INTO sequence_source VALUES(3032,'MH401199.1',84,477,1,5);
INSERT INTO sequence_source VALUES(3033,'MH401200.1',84,1013,1,5);
INSERT INTO sequence_source VALUES(3034,'MH401201.1',84,1014,1,5);
INSERT INTO sequence_source VALUES(3035,'MH401202.1',84,1015,1,5);
INSERT INTO sequence_source VALUES(3036,'MH401203.1',84,1016,1,5);
INSERT INTO sequence_source VALUES(3037,'MH401204.1',84,1015,1,5);
INSERT INTO sequence_source VALUES(3038,'MH401205.1',84,958,1,5);
INSERT INTO sequence_source VALUES(3039,'MH401206.1',84,386,1,5);
INSERT INTO sequence_source VALUES(3040,'MH401207.1',84,386,1,5);
INSERT INTO sequence_source VALUES(3041,'MH401208.1',84,265,1,5);
INSERT INTO sequence_source VALUES(3042,'MH401209.1',84,1017,1,5);
INSERT INTO sequence_source VALUES(3043,'MH401210.1',84,1018,1,5);
INSERT INTO sequence_source VALUES(3044,'MH401211.1',84,1019,1,5);
INSERT INTO sequence_source VALUES(3045,'MH443074.1',84,991,1,5);
INSERT INTO sequence_source VALUES(3046,'MH443075.1',84,991,1,5);
INSERT INTO sequence_source VALUES(3047,'MH443076.1',84,53,1,5);
INSERT INTO sequence_source VALUES(3048,'MH443077.1',84,53,1,5);
INSERT INTO sequence_source VALUES(3049,'MH443078.1',84,53,1,5);
INSERT INTO sequence_source VALUES(3050,'MH443079.1',84,53,1,5);
INSERT INTO sequence_source VALUES(3051,'MH443080.1',84,53,1,5);
INSERT INTO sequence_source VALUES(3052,'MH443081.1',84,53,1,5);
INSERT INTO sequence_source VALUES(3053,'MH443083.1',84,1020,1,5);
INSERT INTO sequence_source VALUES(3054,'MH443084.1',84,991,1,5);
INSERT INTO sequence_source VALUES(3055,'MH443085.1',84,991,1,5);
INSERT INTO sequence_source VALUES(3056,'MH443087.1',84,53,1,5);
INSERT INTO sequence_source VALUES(3057,'MH443088.1',84,53,1,5);
INSERT INTO sequence_source VALUES(3058,'MH588088.1',84,1021,1,5);
INSERT INTO sequence_source VALUES(3059,'MH593844.1',84,1021,1,5);
INSERT INTO sequence_source VALUES(3060,'MH620351.1',84,1022,1,9);
INSERT INTO sequence_source VALUES(3061,'MH665654.1',84,764,1,3);
INSERT INTO sequence_source VALUES(3062,'MH671329.1',84,1023,1,55);
INSERT INTO sequence_source VALUES(3063,'MH730799.1',84,1024,1,9);
INSERT INTO sequence_source VALUES(3064,'MH730800.1',84,1025,1,9);
INSERT INTO sequence_source VALUES(3065,'MH730801.1',84,267,1,9);
INSERT INTO sequence_source VALUES(3066,'MH730802.1',84,1026,1,9);
INSERT INTO sequence_source VALUES(3067,'MH730803.1',84,1027,1,9);
INSERT INTO sequence_source VALUES(3068,'MH730804.1',84,714,1,9);
INSERT INTO sequence_source VALUES(3069,'MH730805.1',84,1028,1,9);
INSERT INTO sequence_source VALUES(3070,'MH730806.1',84,1029,1,9);
INSERT INTO sequence_source VALUES(3071,'MH730807.1',84,188,1,30);
INSERT INTO sequence_source VALUES(3072,'MH730808.1',84,1030,1,9);
INSERT INTO sequence_source VALUES(3073,'MH730809.1',84,858,1,9);
INSERT INTO sequence_source VALUES(3074,'MH730810.1',84,416,1,9);
INSERT INTO sequence_source VALUES(3075,'MH730811.1',84,416,1,9);
INSERT INTO sequence_source VALUES(3076,'MH730817.1',84,1031,1,9);
INSERT INTO sequence_source VALUES(3077,'MH730818.1',84,1032,1,9);
INSERT INTO sequence_source VALUES(3078,'MH806381.1',84,159,1,9);
INSERT INTO sequence_source VALUES(3079,'MH807778.1',84,60,1,5);
INSERT INTO sequence_source VALUES(3080,'MH842154.1',84,29,1,5);
INSERT INTO sequence_source VALUES(3081,'MH842155.1',84,29,1,5);
INSERT INTO sequence_source VALUES(3082,'MH842156.1',84,29,1,5);
INSERT INTO sequence_source VALUES(3083,'MH842157.1',84,29,1,5);
INSERT INTO sequence_source VALUES(3084,'MH842158.1',84,29,1,5);
INSERT INTO sequence_source VALUES(3085,'MH842159.1',84,877,1,5);
INSERT INTO sequence_source VALUES(3086,'MH842160.1',84,29,1,5);
INSERT INTO sequence_source VALUES(3087,'MH842161.1',84,29,1,5);
INSERT INTO sequence_source VALUES(3088,'MH842162.1',84,29,1,5);
INSERT INTO sequence_source VALUES(3089,'MH842163.1',84,1033,1,5);
INSERT INTO sequence_source VALUES(3090,'MH865074.1',84,176,1,5);
INSERT INTO sequence_source VALUES(3091,'MH923447.1',84,553,1,55);
INSERT INTO sequence_source VALUES(3092,'MH999837.1',84,159,1,9);
INSERT INTO sequence_source VALUES(3093,'MK011110.1',84,571,1,55);
INSERT INTO sequence_source VALUES(3094,'MK011111.1',84,571,1,55);
INSERT INTO sequence_source VALUES(3095,'MK011112.1',84,571,1,55);
INSERT INTO sequence_source VALUES(3096,'MK011113.1',84,571,1,55);
INSERT INTO sequence_source VALUES(3097,'MK011114.1',84,571,1,55);
INSERT INTO sequence_source VALUES(3098,'MK011115.1',84,571,1,55);
INSERT INTO sequence_source VALUES(3099,'MK011116.1',84,571,1,55);
INSERT INTO sequence_source VALUES(3100,'MK011117.1',84,571,1,55);
INSERT INTO sequence_source VALUES(3101,'MK011118.1',84,571,1,55);
INSERT INTO sequence_source VALUES(3102,'MK011119.1',84,571,1,55);
INSERT INTO sequence_source VALUES(3103,'MK011120.1',84,571,1,55);
INSERT INTO sequence_source VALUES(3104,'MK011121.1',84,571,1,55);
INSERT INTO sequence_source VALUES(3105,'MK015670.1',84,1034,1,6);
INSERT INTO sequence_source VALUES(3106,'MK015672.1',84,1035,1,6);
INSERT INTO sequence_source VALUES(3107,'MK015673.1',84,1036,1,62);
INSERT INTO sequence_source VALUES(3108,'MK015675.1',84,1037,1,55);
INSERT INTO sequence_source VALUES(3109,'MK015677.1',84,1038,1,55);
INSERT INTO sequence_source VALUES(3110,'MK015679.1',84,1039,1,6);
INSERT INTO sequence_source VALUES(3111,'MK067077.1',84,914,1,4);
INSERT INTO sequence_source VALUES(3112,'MK163944.1',84,1040,1,5);
INSERT INTO sequence_source VALUES(3113,'MK299414.1',84,457,1,5);
INSERT INTO sequence_source VALUES(3114,'MK326522.1',84,817,1,62);
INSERT INTO sequence_source VALUES(3115,'MK326541.1',84,796,1,62);
INSERT INTO sequence_source VALUES(3116,'MK326550.1',84,1041,1,62);
INSERT INTO sequence_source VALUES(3117,'MK500842.1',84,60,1,5);
INSERT INTO sequence_source VALUES(3118,'MK524730.1',84,5,1,3);
INSERT INTO sequence_source VALUES(3119,'MK524731.1',84,1042,1,3);
INSERT INTO sequence_source VALUES(3120,'MK524732.1',84,1043,1,3);
INSERT INTO sequence_source VALUES(3121,'MK524733.1',84,757,1,3);
INSERT INTO sequence_source VALUES(3122,'MK524734.1',84,5,1,3);
INSERT INTO sequence_source VALUES(3123,'MK524735.1',84,1044,1,39);
INSERT INTO sequence_source VALUES(3124,'MK524736.1',84,1045,1,3);
INSERT INTO sequence_source VALUES(3125,'MK524737.1',84,329,1,39);
INSERT INTO sequence_source VALUES(3126,'MK524738.1',84,1046,1,3);
INSERT INTO sequence_source VALUES(3127,'MK524739.1',84,1047,1,3);
INSERT INTO sequence_source VALUES(3128,'MK524740.1',84,1048,1,3);
INSERT INTO sequence_source VALUES(3129,'MK524741.1',84,5,1,3);
INSERT INTO sequence_source VALUES(3130,'MK524742.1',84,1049,1,3);
INSERT INTO sequence_source VALUES(3131,'MK524743.1',84,1050,1,3);
INSERT INTO sequence_source VALUES(3132,'MK524744.1',84,1051,1,3);
INSERT INTO sequence_source VALUES(3133,'MK524745.1',84,1052,1,3);
INSERT INTO sequence_source VALUES(3134,'MK524746.1',84,341,1,3);
INSERT INTO sequence_source VALUES(3135,'MK524747.1',84,341,1,3);
INSERT INTO sequence_source VALUES(3136,'MK524748.1',84,1053,1,3);
INSERT INTO sequence_source VALUES(3137,'MK524749.1',84,749,1,3);
INSERT INTO sequence_source VALUES(3138,'MK524750.1',84,753,1,3);
INSERT INTO sequence_source VALUES(3139,'MK524751.1',84,753,1,3);
INSERT INTO sequence_source VALUES(3140,'MK524752.1',84,1054,1,3);
INSERT INTO sequence_source VALUES(3141,'MK524753.1',84,1055,1,3);
INSERT INTO sequence_source VALUES(3142,'MK524754.1',84,1056,1,3);
INSERT INTO sequence_source VALUES(3143,'MK524755.1',84,341,1,3);
INSERT INTO sequence_source VALUES(3144,'MK524756.1',84,1046,1,3);
INSERT INTO sequence_source VALUES(3145,'MK524757.1',84,1057,1,3);
INSERT INTO sequence_source VALUES(3146,'MK524758.1',84,1058,1,3);
INSERT INTO sequence_source VALUES(3147,'MK524759.1',84,5,1,3);
INSERT INTO sequence_source VALUES(3148,'MK524760.1',84,1046,1,3);
INSERT INTO sequence_source VALUES(3149,'MK524761.1',84,1059,1,3);
INSERT INTO sequence_source VALUES(3150,'MK524762.1',84,1046,1,3);
INSERT INTO sequence_source VALUES(3151,'MK524763.1',84,1060,1,3);
INSERT INTO sequence_source VALUES(3152,'MK524764.1',84,5,1,3);
INSERT INTO sequence_source VALUES(3153,'MK524765.1',84,5,1,3);
INSERT INTO sequence_source VALUES(3154,'MK524766.1',84,1061,1,3);
INSERT INTO sequence_source VALUES(3155,'MK524767.1',84,5,1,3);
INSERT INTO sequence_source VALUES(3156,'MK524768.1',84,1062,1,3);
INSERT INTO sequence_source VALUES(3157,'MK524769.1',84,5,1,3);
INSERT INTO sequence_source VALUES(3158,'MK524770.1',84,5,1,3);
INSERT INTO sequence_source VALUES(3159,'MK524771.1',84,5,1,3);
INSERT INTO sequence_source VALUES(3160,'MK524772.1',84,5,1,3);
INSERT INTO sequence_source VALUES(3161,'MK524773.1',84,5,1,3);
INSERT INTO sequence_source VALUES(3162,'MK524774.1',84,1063,1,3);
INSERT INTO sequence_source VALUES(3163,'MK524775.1',84,5,1,3);
INSERT INTO sequence_source VALUES(3164,'MK524776.1',84,5,1,3);
INSERT INTO sequence_source VALUES(3165,'MK524777.1',84,5,1,3);
INSERT INTO sequence_source VALUES(3166,'MK524778.1',84,1064,1,3);
INSERT INTO sequence_source VALUES(3167,'MK524779.1',84,1065,1,3);
INSERT INTO sequence_source VALUES(3168,'MK524780.1',84,1066,1,3);
INSERT INTO sequence_source VALUES(3169,'MK524781.1',84,5,1,3);
INSERT INTO sequence_source VALUES(3170,'MK524782.1',84,5,1,3);
INSERT INTO sequence_source VALUES(3171,'MK524783.1',84,5,1,3);
INSERT INTO sequence_source VALUES(3172,'MK524784.1',84,5,1,3);
INSERT INTO sequence_source VALUES(3173,'MK524785.1',84,5,1,3);
INSERT INTO sequence_source VALUES(3174,'MK524786.1',84,5,1,3);
INSERT INTO sequence_source VALUES(3175,'MK524787.1',84,5,1,3);
INSERT INTO sequence_source VALUES(3176,'MK524788.1',84,1067,1,3);
INSERT INTO sequence_source VALUES(3177,'MK524789.1',84,1068,1,3);
INSERT INTO sequence_source VALUES(3178,'MK524790.1',84,5,1,3);
INSERT INTO sequence_source VALUES(3179,'MK524791.1',84,5,1,3);
INSERT INTO sequence_source VALUES(3180,'MK524792.1',84,5,1,3);
INSERT INTO sequence_source VALUES(3181,'MK524793.1',84,5,1,3);
INSERT INTO sequence_source VALUES(3182,'MK524794.1',84,1069,1,3);
INSERT INTO sequence_source VALUES(3183,'MK524795.1',84,1070,1,3);
INSERT INTO sequence_source VALUES(3184,'MK583656.1',84,141,1,62);
INSERT INTO sequence_source VALUES(3185,'MK583657.1',84,141,1,62);
INSERT INTO sequence_source VALUES(3186,'MK742802.1',84,13,1,5);
INSERT INTO sequence_source VALUES(3187,'MK742806.1',84,13,1,5);
INSERT INTO sequence_source VALUES(3188,'MK794624.1',84,1071,1,62);
INSERT INTO sequence_source VALUES(3189,'MK794625.1',84,1072,1,62);
INSERT INTO sequence_source VALUES(3190,'MK794626.1',84,1073,1,62);
INSERT INTO sequence_source VALUES(3191,'MK794627.1',84,141,1,62);
INSERT INTO sequence_source VALUES(3192,'MK794628.1',84,1074,1,62);
INSERT INTO sequence_source VALUES(3193,'MK794631.1',84,233,1,62);
INSERT INTO sequence_source VALUES(3194,'MK794632.1',84,1075,1,62);
INSERT INTO sequence_source VALUES(3195,'MK794636.1',84,1076,1,62);
INSERT INTO sequence_source VALUES(3196,'MK794637.1',84,233,1,62);
INSERT INTO sequence_source VALUES(3197,'MK794638.1',84,1077,1,62);
INSERT INTO sequence_source VALUES(3198,'MK794641.1',84,1078,1,62);
INSERT INTO sequence_source VALUES(3199,'MK794642.1',84,141,1,62);
INSERT INTO sequence_source VALUES(3200,'MK794644.1',84,1071,1,62);
INSERT INTO sequence_source VALUES(3201,'MK794645.1',84,1079,1,62);
INSERT INTO sequence_source VALUES(3202,'MK794646.1',84,171,1,62);
INSERT INTO sequence_source VALUES(3203,'MK794648.1',84,233,1,62);
INSERT INTO sequence_source VALUES(3204,'MK794649.1',84,1080,1,62);
INSERT INTO sequence_source VALUES(3205,'MK794650.1',84,1081,1,62);
INSERT INTO sequence_source VALUES(3206,'MK794652.1',84,1071,1,62);
INSERT INTO sequence_source VALUES(3207,'MK794654.1',84,802,1,62);
INSERT INTO sequence_source VALUES(3208,'MK794655.1',84,1082,1,62);
INSERT INTO sequence_source VALUES(3209,'MK794656.1',84,141,1,62);
INSERT INTO sequence_source VALUES(3210,'MK794658.1',84,233,1,62);
INSERT INTO sequence_source VALUES(3211,'MK794659.1',84,233,1,62);
INSERT INTO sequence_source VALUES(3212,'MK794660.1',84,1083,1,62);
INSERT INTO sequence_source VALUES(3213,'MK794661.1',84,233,1,62);
INSERT INTO sequence_source VALUES(3214,'MK794662.1',84,141,1,62);
INSERT INTO sequence_source VALUES(3215,'MK794663.1',84,141,1,62);
INSERT INTO sequence_source VALUES(3216,'MK794665.1',84,1074,1,62);
INSERT INTO sequence_source VALUES(3217,'MK794666.1',84,1084,1,62);
INSERT INTO sequence_source VALUES(3218,'MK794667.1',84,1085,1,62);
INSERT INTO sequence_source VALUES(3219,'MK794668.1',84,802,1,62);
INSERT INTO sequence_source VALUES(3220,'MK794669.1',84,141,1,62);
INSERT INTO sequence_source VALUES(3221,'MK794670.1',84,233,1,62);
INSERT INTO sequence_source VALUES(3222,'MK794671.1',84,233,1,62);
INSERT INTO sequence_source VALUES(3223,'MK794672.1',84,798,1,6);
INSERT INTO sequence_source VALUES(3224,'MK794675.1',84,233,1,62);
INSERT INTO sequence_source VALUES(3225,'MK794678.1',84,1086,1,62);
INSERT INTO sequence_source VALUES(3226,'MK794679.1',84,802,1,62);
INSERT INTO sequence_source VALUES(3227,'MK794680.1',84,233,1,62);
INSERT INTO sequence_source VALUES(3228,'MK794681.1',84,1087,1,62);
INSERT INTO sequence_source VALUES(3229,'MK794682.1',84,1088,1,62);
INSERT INTO sequence_source VALUES(3230,'MK794683.1',84,1089,1,62);
INSERT INTO sequence_source VALUES(3231,'MK794685.1',84,1090,1,62);
INSERT INTO sequence_source VALUES(3232,'MK794686.1',84,1071,1,62);
INSERT INTO sequence_source VALUES(3233,'MK794687.1',84,802,1,62);
INSERT INTO sequence_source VALUES(3234,'MK794688.1',84,1091,1,6);
INSERT INTO sequence_source VALUES(3235,'MK794690.1',84,802,1,62);
INSERT INTO sequence_source VALUES(3236,'MK794693.1',84,233,1,62);
INSERT INTO sequence_source VALUES(3237,'MK794695.1',84,1092,1,62);
INSERT INTO sequence_source VALUES(3238,'MK794698.1',84,1093,1,62);
INSERT INTO sequence_source VALUES(3239,'MK794702.1',84,1094,1,62);
INSERT INTO sequence_source VALUES(3240,'MK794705.1',84,789,1,62);
INSERT INTO sequence_source VALUES(3241,'MK794706.1',84,1095,1,6);
INSERT INTO sequence_source VALUES(3242,'MK794708.1',84,277,1,5);
INSERT INTO sequence_source VALUES(3243,'MK794709.1',84,789,1,62);
INSERT INTO sequence_source VALUES(3244,'MK794717.1',84,1096,1,62);
INSERT INTO sequence_source VALUES(3245,'MK794718.1',84,1097,1,6);
INSERT INTO sequence_source VALUES(3246,'MK794719.1',84,1098,1,6);
INSERT INTO sequence_source VALUES(3247,'MK794721.1',84,1041,1,62);
INSERT INTO sequence_source VALUES(3250,'MK794727.1',84,789,1,62);
INSERT INTO sequence_source VALUES(3251,'MK794731.1',84,1100,1,62);
INSERT INTO sequence_source VALUES(3252,'MK794732.1',84,241,1,62);
INSERT INTO sequence_source VALUES(3253,'MK794733.1',84,1101,1,62);
INSERT INTO sequence_source VALUES(3254,'MK794735.1',84,1102,1,62);
INSERT INTO sequence_source VALUES(3255,'MK794736.1',84,1103,1,62);
INSERT INTO sequence_source VALUES(3256,'MK794737.1',84,1104,1,62);
INSERT INTO sequence_source VALUES(3257,'MK794740.1',84,1105,1,6);
INSERT INTO sequence_source VALUES(3258,'MK794741.1',84,1106,1,62);
INSERT INTO sequence_source VALUES(3259,'MK794744.1',84,789,1,62);
INSERT INTO sequence_source VALUES(3260,'MK794746.1',84,1105,1,6);
INSERT INTO sequence_source VALUES(3261,'MK794747.1',84,1107,1,5);
INSERT INTO sequence_source VALUES(3262,'MK794749.1',84,1097,1,6);
INSERT INTO sequence_source VALUES(3263,'MK794753.1',84,1108,1,62);
INSERT INTO sequence_source VALUES(3264,'MK794762.1',84,1109,1,62);
INSERT INTO sequence_source VALUES(3265,'MK794763.1',84,1041,1,62);
INSERT INTO sequence_source VALUES(3266,'MK794764.1',84,1041,1,62);
INSERT INTO sequence_source VALUES(3267,'MK794765.1',84,1110,1,62);
INSERT INTO sequence_source VALUES(3268,'MK794771.1',84,1111,1,62);
INSERT INTO sequence_source VALUES(3269,'MK794772.1',84,1112,1,62);
INSERT INTO sequence_source VALUES(3270,'MK794778.1',84,141,1,62);
INSERT INTO sequence_source VALUES(3271,'MK794782.1',84,141,1,62);
INSERT INTO sequence_source VALUES(3272,'MK794789.1',84,1113,1,62);
INSERT INTO sequence_source VALUES(3273,'MK794790.1',84,141,1,62);
INSERT INTO sequence_source VALUES(3274,'MK794791.1',84,233,1,62);
INSERT INTO sequence_source VALUES(3275,'MK794798.1',84,1114,1,62);
INSERT INTO sequence_source VALUES(3276,'MK794799.1',84,523,1,62);
INSERT INTO sequence_source VALUES(3277,'MK794806.1',84,523,1,62);
INSERT INTO sequence_source VALUES(3278,'MK794810.1',84,233,1,62);
INSERT INTO sequence_source VALUES(3279,'MK794819.1',84,1115,1,62);
INSERT INTO sequence_source VALUES(3280,'MK794820.1',84,1116,1,62);
INSERT INTO sequence_source VALUES(3281,'MK794823.1',84,1117,1,6);
INSERT INTO sequence_source VALUES(3282,'MK794825.1',84,1118,1,62);
INSERT INTO sequence_source VALUES(3283,'MK794829.1',84,233,1,62);
INSERT INTO sequence_source VALUES(3284,'MK794830.1',84,233,1,62);
INSERT INTO sequence_source VALUES(3285,'MK794833.1',84,1119,1,62);
INSERT INTO sequence_source VALUES(3286,'MK794837.1',84,1110,1,62);
INSERT INTO sequence_source VALUES(3287,'MK794839.1',84,798,1,6);
INSERT INTO sequence_source VALUES(3288,'MK794840.1',84,233,1,62);
INSERT INTO sequence_source VALUES(3289,'MK794841.1',84,241,1,62);
INSERT INTO sequence_source VALUES(3290,'MK794844.1',84,1120,1,62);
INSERT INTO sequence_source VALUES(3291,'MK794845.1',84,241,1,62);
INSERT INTO sequence_source VALUES(3293,'MK794850.1',84,1121,1,62);
INSERT INTO sequence_source VALUES(3294,'MK794851.1',84,1122,1,62);
INSERT INTO sequence_source VALUES(3296,'MK794858.1',84,233,1,62);
INSERT INTO sequence